;************************************************************************
;*									*
;*	title name	: "ZELDA-3 NES messege porgram"			*
;*	proccess	: system main					*
;*	file name	: m5main					*
;*									*
;************************************************************************
;
;
		INCLUDE	ztmacro.asm
		INCLUDE	tl_ram.asm
;
;
;------------------------------------------------------------------------
;-	global symbol							-
;------------------------------------------------------------------------
;-----< tl_main >--------------------------------------------------------
;
;------------------------------------------------------------------------
;-	extern symbol							-
;------------------------------------------------------------------------
;
;-----< tl_msg0 >--------------------------------------------------------
		GLB	KEYINPT,MSGINIT,NOINPUT,LOADSUB
;
;
;------------------------------------------------------------------------
;-	define symbol							-
;------------------------------------------------------------------------
;		EQU
;
;
;************************************************************************
;*									*
;*	program start							*
;*									*
;************************************************************************
;
;
		ORG	018000H
;
;
		EXTEND
;
;
		MEM8
		IDX8
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		JSL	MSGINIT	( messege data init. sub )		x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
MSGINIT		EQU	$
		MI16
;
		LDX	#007FEH
;
MIN050		EQU	$
		LDA	#00000H
		STA	>DOTBUF,X
		STA	>CHRBUF,X
		LDA	#08080H
		STA	>MOJBUF,X
		DEX
		DEX
		BPL	MIN050
;
		MI8
;
		LDA	#168
		STA	<NOKORI
		INC	<VRAMSH
		RTL
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		JSR	KEYINPT	( key input data cheange sub )		x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
KEYINPT		EQU	$
		LDX	<DOTPIT
		LDY	#080H
		STZ	<DELFLG
		LDA	!KEYWK2
		BNE	KIT005		; key in ?
;					; no
		JMP	KIT040
;
;
KIT005		EQU	$
		ASL	A
		BCC	KIT007		; (80H) : [INS]-key ?
;					; yes
		LDA	<RETURN
		STA	<YPOSDT
		LDA	<DOTPIT
		STA	<XPOSDT
;
		LDA	<INSFLG
		EOR	#00000001B
		STA	<INSFLG
		JMP	KITEND
;
KIT007		EQU	$
		ASL	A
		BCC	KIT009		; (40H) : [DEL]-key ?
;					; yes
		LDA	<INSFLG
		BEQ	KIT008		; insert on ?
;					; yes
		INC	<DELFLG
		JMP	KITEND
;
KIT008		EQU	$
		JSR	BACKSPC
		JSR	NOKOCNT
		LDY	#080H
		JMP	KITEND
;
KIT009		EQU	$
		ASL	A
		BCC	KIT0094		; (20H) : [Space]-key ?
;					; yes
		LDY	#059H
		JMP	KITEND
;
KIT0094		EQU	$
		ASL	A
		BCC	KIT010		; (10H) : [Dwon]-key ?
;					; yes
		LDY	#04EH
		LDA	<INSFLG
		BNE	KIT0098		; insert-mode ?
;					; no
		LDA	>DOTBUF,X
		CLC
		ADC	#010H
		CMP	#0169
		BCS	KIT0099		; set ok ?
;					; yes
		LDY	#062H
		JSL	>KITEND
		LDY	#063H
KIT0098		EQU	$
		JSL	>KITEND
KIT0099		EQU	$
		RTL
;
KIT010		EQU	$
		ASL	A
		BCC	KIT020		; (08H) : [Left]-key ?
;					; yes
		LDY	#04FH
		LDA	<INSFLG
		BNE	KIT0015		; insert-mode ?
;					; no
		LDA	>DOTBUF,X
		CLC
		ADC	#010H
		CMP	#0169
		BCS	KIT0016		; set ok ?
;					; yes
		LDY	#04FH
		JSL	>KITEND
		LDY	#050H
KIT0015		EQU	$
		JSL	>KITEND
KIT0016		EQU	$
		RTL
;
KIT020		EQU	$
		ASL	A
		BCC	KIT030		; (04H) : [Right]-key ?
;					; yes
		LDY	#050H
		LDA	<INSFLG
		BNE	KIT0025		; insert-mode ?
;					; no
		LDA	>DOTBUF,X
		CLC
		ADC	#010H
		CMP	#0169
		BCS	KIT0026		; set ok ?
;					; yes
		LDY	#064H
		JSL	>KITEND
		LDY	#065H
KIT0025		EQU	$
		JSL	>KITEND
KIT0026		EQU	$
		RTL
;
KIT030		EQU	$
		ASL	A
		BCC	KIT031		; (02H) : [Up]-key ?
;					; yes
		LDY	#04DH
		LDA	<INSFLG
		BNE	KIT0030A	; insert-mode ?
;					; no
		LDA	>DOTBUF,X
		CLC
		ADC	#010H
		CMP	#0169
		BCS	KIT0030B	; set ok ?
;					; yes
		LDY	#04DH
		JSL	>KITEND
		LDY	#04EH
KIT0030A	EQU	$
		JSL	>KITEND
KIT0030B	EQU	$
		RTL
;
KIT031		EQU	$
		STZ	!MODENO
		JMP	KITEND
;
KIT040		EQU	$
		LDA	!KEYWK2+1
		BEQ	KIT080		; key in ?
;					; yes
		ASL	A
		BCC	KIT050		; (80H) : [2]-key ?
;					; yes
		LDY	#036H
		LDY	#035H
		LDA	!KEYWK1+1
		AND	#00010000B
		BNE	KIT045		; shift-key on ?
;					; no
		LDA	!KEYWK1+8
		AND	#00100000B
		BEQ	KIT046		; shift-key on ?
;					; yes
KIT045		EQU	$
		LDY	#04CH		; ["] set
KIT046		EQU	$
		JMP	KITEND
;
KIT050		EQU	$
		ASL	A
		BCC	KIT060		; (40H) : [1]-key ?
;					; yes
		LDY	#035H
		LDA	!KEYWK1+1
		AND	#00010000B
		BNE	KIT055		; shift-key on ?
;					; no
		LDA	!KEYWK1+8
		AND	#00100000B
		BEQ	KIT056		; shift-key on ?
;					; yes
KIT055		EQU	$
		LDY	#03EH		; [!] set
KIT056		EQU	$
		JMP	KITEND
;
;
KIT060		EQU	$
		ASL	A
		ASL	A
		ASL	A
		ASL	A
		BCC	KIT070		; (04H) : [Q]-key ?
;					; yes
		LDY	#010H
		JMP	KITEND
;
KIT070		EQU	$
		ASL	A
		BCC	KIT075		; (02H) : [ESC]-key ?
;					; yes
		LDA	<ESCFLG
		EOR	#00000001B
		STA	<ESCFLG
		JMP	KITEND
;
KIT075		EQU	$
		ASL	A
		BCC	KIT080		; (01H) : [F_1]-key ?
;					; yes
		LDY	#045H
		LDA	!KEYWK1+1
		AND	#00010000B
		BNE	KIT078		; [shift]-key ?
;					; no
		LDA	!KEYWK1+8
		AND	#00100000B
		BNE	KIT078		; [shift]-key ?
;					; no
		LDA	>DOTBUF,X
		CLC
		ADC	#010H
		CMP	#0169
		BCS	KIT079		; set ok ?
;					; yes
		LDY	#052H
		JSL	>KITEND
		LDY	#053H
KIT078		EQU	$
		JMP	KITEND
;
KIT079		EQU	$
		RTL
;
;
KIT080		EQU	$
		LDA	!KEYWK2+2
		BEQ	KIT160		; key in ?
;					; yes
		ASL	A
		BCC	KIT090		; (80H) : [3]-key ?
;					; yes
		LDY	#037H
		JMP	KITEND
;
KIT090		EQU	$
		ASL	A
		BCC	KIT100		; (40H) : [E]-key ?
;					; yes
		LDY	#004H
		JMP	KITEND
;
KIT100		EQU	$
		ASL	A
		BCC	KIT110		; (20H) : [Z]-key ?
;					; yes
		LDY	#019H
		JMP	KITEND
;
KIT110		EQU	$
		ASL	A
		BCC	KIT120		; (10H) : [X]-key ?
;					; yes
		LDY	#017H
		JMP	KITEND
;
KIT120		EQU	$
		ASL	A
		BCC	KIT130		; (08H) : [A]-key ?
;					; yes
		LDY	#000H
		JMP	KITEND
;
KIT130		EQU	$
		ASL	A
		BCC	KIT140		; (04H) : [S]-key ?
;					; yes
		LDY	#012H
		JMP	KITEND
;
KIT140		EQU	$
		ASL	A
		BCC	KIT150		; (02H) : [W]-key ?
;					; yes
		LDY	#016H
		JMP	KITEND
;
KIT150		EQU	$
		LDY	#046H		; (01H) : [F_2]-key
		LDA	!KEYWK1+1
		AND	#00010000B
		BNE	KIT155		; [shift]-key ?
;					; no
		LDA	!KEYWK1+8
		AND	#00100000B
		BNE	KIT155		; [shift]-key ?
;					; no
		LDA	>DOTBUF,X
		CLC
		ADC	#010H
		CMP	#0169
		BCS	KIT156		; set ok ?
;					; yes
		LDY	#054H
		JSL	>KITEND
		LDY	#053H
KIT155		EQU	$
		JMP	KITEND
;
KIT156		EQU	$
		RTL
;
KIT160		EQU	$
		LDA	!KEYWK2+3
		BEQ	KIT240		; key-in ?
;					; yes
		ASL	A
		BCC	KIT170		; (80H) : [4]-key ?
;					; yes
		LDY	#038H
		JMP	KITEND
;
KIT170		EQU	$
		ASL	A
		BCC	KIT180		; (40H) : [5]-key ?
;					; yes
		LDY	#039H
		JMP	KITEND
;
KIT180		EQU	$
		ASL	A
		BCC	KIT190		; (20H) : [C]-key ?
;					; yes
		LDY	#002H
		JMP	KITEND
;
KIT190		EQU	$
		ASL	A
		BCC	KIT200		; (10H) : [F]-key ?
;					; yes
		LDY	#005H
		JMP	KITEND
;
KIT200		EQU	$
		ASL	A
		BCC	KIT210		; (08H) : [D]-key ?
;					; yes
		LDY	#0003H
		JMP	KITEND
;
KIT210		EQU	$
		ASL	A
		BCC	KIT220		; (04H) : [R]-key ?
;					; yes
		LDY	#011H
		JMP	KITEND
;
KIT220		EQU	$
		ASL	A
		BCC	KIT230		; (02H) : [T]-key ?
;					; yes
		LDY	#013H
		JMP	KITEND
;
KIT230		EQU	$
		LDY	#047H		; (01H) : [F_3]-key
		LDA	!KEYWK1+1
		AND	#00010000B
		BNE	KIT235		; [shift]-key ?
;					; no
		LDA	!KEYWK1+8
		AND	#00100000B
		BNE	KIT235		; [shift]-key ?
;					; no
		LDA	>DOTBUF,X
		CLC
		ADC	#010H
		CMP	#0169
		BCS	KIT236		; set ok ?
;					; yes
		LDY	#055H
		JSL	>KITEND
		LDY	#056H
KIT235		EQU	$
		JMP	KITEND
;
KIT236		EQU	$
		RTL
;
KIT240		EQU	$
		LDA	!KEYWK2+4
		BEQ	KIT320		; key in ?
;					; yes
		ASL	A
		BCC	KIT250		; (80H) : [6]-key ?
;					; yes
		LDY	#03AH
		JMP	KITEND
;
KIT250		EQU	$
		ASL	A
		BCC	KIT260		; (40H) : [7]-key ?
;					; yes
		LDY	#03BH
		JMP	KITEND
;
KIT260		EQU	$
		ASL	A
		BCC	KIT270		; (20H) : [V]-key ?
;					; yes
		LDY	#015H
		JMP	KITEND
;
KIT270		EQU	$
		ASL	A
		BCC	KIT280		; (10H) : [B]-key ?
;					; yes
		LDY	#001H
		JMP	KITEND
;
KIT280		EQU	$
		ASL	A
		BCC	KIT290		; (08H) : [H]-key ?
;					; yes
		LDY	#007H
		JMP	KITEND
;
KIT290		EQU	$
		ASL	A
		BCC	KIT300		; (04H) : [G]-key ?
;					; yes
		LDY	#006H
		JMP	KITEND
;
KIT300		EQU	$
		ASL	A
		BCC	KIT310		; (02H) : [Y]-key ?
;					; yes
		LDY	#018H
		JMP	KITEND
;
KIT310		EQU	$
		LDY	#048H		; (01H) : [F_4]-key
		LDA	!KEYWK1+1
		AND	#00010000B
		BNE	KIT315		; [shift]-key ?
;					; no
		LDA	!KEYWK1+8
		AND	#00100000B
		BNE	KIT315		; [shift]-key ?
;					; no
		LDA	>DOTBUF,X
		CLC
		ADC	#010H
		CMP	#0169
		BCS	KIT316		; set ok ?
;					; yes
		LDY	#057H
		JSL	>KITEND
		LDY	#058H
KIT315		EQU	$
		JMP	KITEND
;
KIT316		EQU	$
		RTL
;
;
KIT320		EQU	$
		LDA	!KEYWK2+5
		BEQ	KIT400		; key in ?
;					; yes
		ASL	A
		BCC	KIT330		; (80H) : [8]-key ?
;					; yes
		LDY	#003CH
		JMP	KITEND
;
KIT330		EQU	$
		ASL	A
		BCC	KIT340		; (40H) : [9]-key ?
;					; yes
		LDY	#03DH
		JMP	KITEND
;
KIT340		EQU	$
		ASL	A
		BCC	KIT350		; (20H) : [N]-key ?
;					; yes
		LDY	#00DH
		JMP	KITEND
;
KIT350		EQU	$
		ASL	A
		BCC	KIT360		; (10H) : [M]-key ?
;					; yes
		LDY	#00CH
		JMP	KITEND
;
KIT360		EQU	$
		ASL	A
		BCC	KIT370		; (08H) : [J]-key ?
;					; yes
		LDY	#009H
		JMP	KITEND
;
KIT370		EQU	$
		ASL	A
		BCC	KIT380		; (04H) : [U]-key ?
;					; yes
		LDY	#014H
		JMP	KITEND
;
KIT380		EQU	$
		ASL	A
		BCC	KIT390		; (02H) : [I]-key ?
;					; yes
		LDY	#008H
		JMP	KITEND
;
KIT390		EQU	$
		LDY	#049H		; (01H) : [F_5]-key
		LDA	!KEYWK1+1
		AND	#00010000B
		BNE	KIT395		; [shift]-key ?
;					; no
		LDA	!KEYWK1+8
		AND	#00100000B
		BNE	KIT395		; [shift]-key ?
;					; no
		LDY	#05BH
KIT395		EQU	$
		JMP	KITEND
;
;
;
KIT400		EQU	$
		LDA	!KEYWK2+6
		BEQ	KIT480		; key in ?
;					; yes
		ASL	A
		BCC	KIT410		; (80H) : [0]-key ?
;					; yes
		LDY	#034H
		JMP	KITEND
;
KIT410		EQU	$
		ASL	A
		BCC	KIT420		; (40H) : [P]-key ?
;					; yes
		LDY	#00FH
		JMP	KITEND
;
KIT420		EQU	$
		ASL	A
		BCC	KIT430		; (20H) : [,]-key ?
;					; yes
		LDY	#042H
		JMP	KITEND
;
KIT430		EQU	$
		ASL	A
		BCC	KIT440		; (10H) : [.]-key ?
;					; yes
		LDY	#041H
		JMP	KITEND
;
KIT440		EQU	$
		ASL	A
		BCC	KIT450		; (08H) : [K]-key ?
;					; yes
		LDY	#00AH
		JMP	KITEND
;
KIT450		EQU	$
		ASL	A
		BCC	KIT460		; (04H) : [L]-key ?
;					; yes
		LDY	#00BH
		JMP	KITEND
;
KIT460		EQU	$
		ASL	A
		BCC	KIT470		; (02H) : [O]-key ?
;					; yes
		LDY	#00EH
		JMP	KITEND
;
KIT470		EQU	$
		LDY	#04AH		; (01H : [F_6]-key
		LDA	!KEYWK1+1
		AND	#00010000B
		BNE	KIT475		; [shift]-key ?
;					; no
		LDA	!KEYWK1+8
		AND	#00100000B
		BNE	KIT475		; [shift]-key ?
;					; no
		LDY	#05CH
KIT475		EQU	$
		JMP	KITEND
;
;
KIT480		EQU	$
		LDA	!KEYWK2+7
		BEQ	KIT502		; key in ?
;					; yes
		ASL	A
		BCC	KIT490		; (80H) : [^(...)]-key ?
;					; yes
		LDY	#043H
		JMP	KITEND
;
KIT490		EQU	$
		ASL	A
		BCC	KIT500		; (40H) : [-]-key ?
;					; yes
		LDY	#040H
		JMP	KITEND
;
KIT500		EQU	$
		ASL	A
		BCC	KIT501		; (20H) : [?]-key ?
;					; yes
		LDY	#03FH
		JMP	KITEND
;
KIT501		EQU	$
		ASL	A
		ASL	A
		ASL	A
		BCC	KIT5010		; (04H) : [:]-key ?
;					; yes
		LDY	#07FH
		JMP	KITEND
;
KIT5010		EQU	$
		ASL	A
		ASL	A
		BCC	KIT502		; (01H) : [F_7]-key ?
;					; yes
		LDY	#04BH
		LDA	!KEYWK1+1
		AND	#00010000B
		BNE	KIT5011		; [shift]-key ?
;					; no
		LDA	!KEYWK1+8
		AND	#00100000B
		BNE	KIT5011		; [shift]-key ?
;					; no
		LDY	#05DH
KIT5011		EQU	$
		BRA	KITEND
;
;
KIT502		EQU	$
		LDA	!KEYWK2+8
		BEQ	KITEND		; key in ?
;					; yes
		ASL	A
		BCC	KIT503		; (80H) : [STOP]-key ?
;					; yes
		JSR	SAVESUB
		STZ	!MODENO
		BRA	KITEND
;
KIT503		EQU	$
		LSR	A
		LSR	A
		BCC	KIT506		; (20H) : [F_8]-key ?
;					; yes
		LDY	#090H
		LDA	!KEYWK1+1
		AND	#00010000B
		BNE	KIT504		; [shift]-key ?
;					; no
		LDA	!KEYWK1+8
		AND	#00100000B
		BNE	KIT504		; [shift]-key ?
;					; yes
		LDY	#05EH
KIT504		EQU	$
		BRA	KITEND
;
KIT506		EQU	$
		LSR	A
		BCC	KITEND		; (10H) : [RETURN]-key ?
;					; yes
		LDA	<INSFLG
		BNE	KIT550		; insert mode ?
;					; no
		LDA	<RETURN
		INC	A
		CMP	#003H
		BEQ	KITEND
;
KIT508		EQU	$
		STA	<RETURN
		ASL	A
		TAX
;
		LDA	#0168
		STA	<NOKORI
		STZ	<OAMPIT
;
		M16
;
		LDA	>CHRPDAT,X
		STA	<CHRPIT
		LDA	>DOTPDAT,X
		STA	<DOTPIT
		JSR	NOKOCNT
;
		M8
;
KITEND		EQU	$
		STY	<KEYDAT
		CPY	#01AH
		BCS	KIT530		; [A ~ Z]-key ?
;					; yes
		LDA	!KEYWK1+1
		AND	#00010000B
		BNE	KIT510		; [shift]-key ?
;					; no
		LDA	!KEYWK1+8
		AND	#00100000B
		BNE	KIT510		; [shift]-key ?
;					; yes
KIT509		EQU	$
		TYA
		CLC
		ADC	#01AH
		TAY			; [a ~ z]-code reset
KIT510		EQU	$
		LDA	<ESCFLG
		BEQ	KIT530		; [ESC] flag on ?
;					; yes
		LDA	<KEYDAT
		CLC
		ADC	#066H
		TAY
KIT530		EQU	$
		STY	<KEYDAT
;
		JSR	STTDSP		; state display
;
		LDA	<INSFLG
		BEQ	KIT540
;
		JMP	SOUNYUU
;
KIT540		EQU	$
		JSR	MOJISET
		JMP	CASLOAM
;
KIT550		EQU	$
		RTL
;
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		dot  data						x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
DOTDATA		EQU	$
		HEX	006,006,006,006,006,006,006,006,005,006,006,006,007,006,006,006
		HEX	006,006,006,007,006,007,007,007,007,006,006,006,006,006,006,006
		HEX	006,006,005,005,006,003,007,006,006,006,006,005,006,006,006,007
		HEX	007,007,007,006,006,004,006,006,006,006,006,006,006,006,003,007
		HEX	006,004,004,006,008,006,006,006,006,006,008,008,008,008,008,008
		HEX	008,004,008,008,008,008,008,008,008,004,008,008,008,008,008,008
		HEX	008,008,008,008,008,008,006,006,006,006,006,006,006,006,005,005
		HEX	006,006,006,006,008,008,008,008,008,006,006,006,006,006,007,003
		HEX	006,006,006,006,008,008,008,008,008,006,006,006,006,006,007,003
		HEX	030
;
DOTDATA1	EQU	$
;			  0   1   2   3   4   5   6   7   8   9   A   B   C   D   E   F
		HEX	006,006,006,006,006,006,006,006,005,006,006,006,007,006,006,006
		HEX	006,006,006,007,006,007,007,007,007,006,006,006,006,006,006,006
		HEX	006,006,005,005,006,003,007,006,006,006,006,005,006,006,006,007
		HEX	007,007,007,006,006,004,006,006,006,006,006,006,006,006,003,007
		HEX	006,004,004,006,008,006,006,006,006,006,008,008,008,010,008,010
		HEX	008,004,010,008,010,010,008,010,008,004,008,008,008,008,008,008
		HEX	008,008,010,008,010,008,006,006,006,006,006,006,006,006,005,005
		HEX	006,006,006,006,008,008,008,008,008,006,006,006,006,006,007,003
		HEX	006,006,006,006,008,008,008,008,008,006,006,006,006,006,007,003
		HEX	030
;
BITDATA		EQU	$
		BYTE	10000000B,01000000B,00100000B,00010000B
		BYTE	00001000B,00000100B,00000010B,00000001B
;
CHRPDAT		EQU	$
		WORD	00000H,002A0H,00540H
;
DOTPDAT		EQU	$
		WORD	00000H,00040H,00080H
;
ANDDATA		EQU	$
		BYTE	00000000B,10000000B,11000000B,11100000B
		BYTE	11110000B,11111000B,11111100B,11111110B
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		JSR	MOJISET	( moji dot data buffer set )		x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
MOJISET		EQU	$
		PHB
		PHK
		PLB
;
		STZ	<WORK3
		LDX	<DOTPIT
		LDY	<KEYDAT
		CPY	#080H
		BNE	MIT010
;
MIT000		EQU	$
		MI8
;
		PLB
		RTS
;
;
MIT010		EQU	$
		LDA	<NOKORI
		BEQ	MIT000
;
		LDA	!DOTDATA,Y
		STA	<WORK2
		CLC
		ADC	>DOTBUF,X
		CMP	#0169
		BCS	MIT000
;
		STA	>DOTBUF+1,X
		LDA	#168
		SEC
		SBC	>DOTBUF+1,X
		STA	<NOKORI
		INX
		STX	<DOTPIT
		INC	<OAMPIT
;
		LDA	<KEYDAT
		STA	>MOJBUF,X
		CMP	#090H
		BNE	MIT015		; name ?
;					; yes
		LDA	#044H
MIT015		EQU	$
		TAY
		AND	#0F0H
		ASL	A
		STA	<WORK0
		TYA
		AND	#00FH
		ORA	<WORK0
		STA	<KEYDAT
;
		M16
;
		LDA	#08000H
		STA	<WORKD
		LDY	#008H
		STY	<WORKF
;
		I16
;
		LDX	<DOTPIT
		LDA	>DOTBUF-1,X
		AND	#000FFH
		ASL	A
		STA	<WORK0
;
		LDX	#00000H
		LDA	<KEYDAT
		ASL	A
		ASL	A
		ASL	A
		ASL	A
		TAY
;
MIT150		EQU	$
		LDA	[<WORKD],Y
		STA	<WORK4
;
		PHY
		STX	<WORK6
;
		LDA	<WORK0
		CLC
		ADC	<CHRPIT
		TAY
		AND	#00FF0H
		CLC
		ADC	<WORK6
		TAX
		TYA
		LSR	A
		AND	#00007H
		TAY
		BEQ	MIT350
;
		M8
;
MIT200		EQU	$
		ASL	<WORK4
		BCC	MIT250
;
		LDA	>CHRBUF,X
		EOR	!BITDATA,Y
		STA	>CHRBUF,X
;
MIT250		EQU	$
		ASL	<WORK5
		BCC	MIT300
;
		LDA	>CHRBUF+1,X
		EOR	!BITDATA,Y
		STA	>CHRBUF+1,X
;
MIT300		EQU	$
		INY
		CPY	#00008H
		BNE	MIT200
;
		M16
;
		TXA
		CLC
		ADC	#00010H
		TAX
;
MIT350		EQU	$
		LDA	<WORK4
		BEQ	MIT360
;
		STA	>CHRBUF,X
;
MIT360		EQU	$
		PLY
		INY
		INY
		LDX	<WORK6
		INX
		INX
		CPX	#00010H
		BNE	MIT150
;
		LDA	<CHRPIT
		CLC
		ADC	#00150H
		STA	<WORK8
;
		LDX	#00000H
		LDA	<KEYDAT
		CLC
		ADC	#00010H
		ASL	A
		ASL	A
		ASL	A
		ASL	A
		TAY
;
MIT400		EQU	$
		LDA	[<WORKD],Y
		STA	<WORK4
;
		PHY
		STX	<WORK6
;
		LDX	<DOTPIT
		LDA	>DOTBUF-1,X
		AND	#000FFH
		ASL	A
		CLC
		ADC	<WORK8
		TAY
		AND	#00FF0H
		CLC
		ADC	<WORK6
		TAX
		TYA
		LSR	A
		AND	#00007H
		TAY
		BEQ	MIT600
;
		M8
;
MIT450		EQU	$
		ASL	<WORK4
		BCC	MIT500
;
		LDA	>CHRBUF,X
		EOR	!BITDATA,Y
		STA	>CHRBUF,X
;
MIT500		EQU	$
		ASL	<WORK5
		BCC	MIT550
;
		LDA	>CHRBUF+1,X
		EOR	!BITDATA,Y
		STA	>CHRBUF+1,X
;
MIT550		EQU	$
		INY
		CPY	#00008H
		BNE	MIT450
;
		M16
;
		TXA
		CLC
		ADC	#00010H
		TAX
;
MIT600		EQU	$
		LDA	<WORK4
		BEQ	MIT610
;
		STA	>CHRBUF,X
;
MIT610		EQU	$
		PLY
		INY
		INY
		LDX	<WORK6
		INX
		INX
		CPX	#00010H
		BNE	MIT400
;
		INC	<VRAMSH
		JSR	NOKOCNT
MITEND		EQU	$
		MI8
;
		PLB
		RTS
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		JSR	NOKOCNT	(  nokori count disp sub )		x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
NOKOCNT		EQU	$
		MI16
;
		STZ	<WORK0
		STZ	<WORK2
		STZ	<WORK4
;
		LDA	<NOKORI
		CMP	#100
		BMI	NRT050
;
		SEC
		SBC	#100
		INC	<WORK0
;
NRT050		EQU	$
		CMP	#10
		BMI	NRT100
;
		SEC
		SBC	#10
		INC	<WORK2
		BRA	NRT050
;
NRT100		EQU	$
		STA	<WORK4
;
		LDA	#05851H
		STA	>VRAMD+2
		CLC
		ADC	#02000H
		STA	>VRAMD+12
		LDA	#00500H
		STA	>VRAMD+4
		STA	>VRAMD+14
;
		LDA	<WORK0
		CLC
		ADC	#01D64H
		STA	>VRAMD+6
		CLC
		ADC	#00010H
		STA	>VRAMD+16
;
		LDA	<WORK2
		CLC
		ADC	#01D64H
		STA	>VRAMD+8
		CLC
		ADC	#00010H
		STA	>VRAMD+18
;
		LDA	<WORK4
		CLC
		ADC	#01D64H
		STA	>VRAMD+10
		CLC
		ADC	#00010H
		STA	>VRAMD+20
;
		LDA	#000FFH
		STA	>VRAMD+22
;
		MI8
;
		RTS
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		JSR	BACKSPC	( back space data set sub )		x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
BACKSPC		EQU	$
		PHB
		PHK
		PLB
;
		LDX	<DOTPIT
		TXA
		AND	#00111111B
		BNE	BKC150
;
		DEX
		DEC	<RETURN
		LDA	<RETURN
		BPL	BKC050
;
		STZ	<RETURN
		JMP	BKCEND
;
BKC050		EQU	$
		LDA	<RETURN
		ASL	A
		TAY
;
		M16
;
		LDA	!CHRPDAT,Y		
		STA	<CHRPIT
;
		M8
;
BKC100		EQU	$
		LDA	>DOTBUF,X
		BNE	BKC150
;
		DEX
		CPX	#001H
		BNE	BKC100
;
BKC150		EQU	$
		DEX
		STX	<DOTPIT
;
		LDA	#000H
		STA	>DOTBUF+1,X
		LDA	#080H
		STA	>MOJBUF+1,X
;
		LDA	#168
		SEC
		SBC	>DOTBUF,X
		STA	<NOKORI
;
		DEC	<OAMPIT
;
		MI16
;
		LDA	>DOTBUF,X
		AND	#000FFH
		TAY
		ASL	A
		AND	#00FF0H
		CLC
		ADC	<CHRPIT
		TAX
		TYA
		AND	#00007H
		TAY
;
		M8
;
BKC200		EQU	$
		LDA	>CHRBUF,X
		AND	!ANDDATA,Y
		STA	>CHRBUF,X
;
		LDA	>CHRBUF+150H,X
		AND	!ANDDATA,Y
		STA	>CHRBUF+150H,X
;
		INX
		TXA
		AND	#00FH
		BNE	BKC200
;
		CPY	#00000H
		BEQ	BKCEND
;
		CPX	#00150H
		BEQ	BKCEND
;
		CPX	#003F0H
		BEQ	BKCEND
;
		CPX	#00690H
		BEQ	BKCEND
;
		LDY	#00000H
;
BKC250		EQU	$
		LDA	>CHRBUF,X
		AND	!ANDDATA,Y
		STA	>CHRBUF,X
;
		LDA	>CHRBUF+150H,X
		AND	!ANDDATA,Y
		STA	>CHRBUF+150H,X
;
		INX
		TXA
		AND	#00FH
		BNE	BKC250
;
BKCEND		EQU	$
		MI8
;
		INC	<VRAMSH
		PLB
		RTS
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		JSR	CASLOAM	( corsol OAM data set sub )		x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
OAMYPOS		EQU	$
		HEX	087,097,0A7
;
CASLOAM		EQU	$
		LDX	<RETURN
		LDA	>OAMYPOS,X
		STA	!OAM+1
		CLC
		ADC	#008H
		STA	!OAM+5
;
		LDX	<DOTPIT
		LDA	>DOTBUF,X
		CLC
		ADC	#028H
		STA	!OAM
		STA	!OAM+4
;
		LDA	#00EH
		STA	!OAM+3
		STA	!OAM+7
;
		LDA	#0FEH
		STA	!OAM+2
		STA	!OAM+6
;
		RTL
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		JSR	SOUNYUU	(  moji sounyuu data set sub )		x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
YPOSDAT		EQU	$
		HEX	0FF,001,000,000
;
XPOSDAT		EQU	$
		HEX	000,000,0FF,001
;
YPOSDT1		EQU	$
		HEX	000,002,000,000
;
XPOSDT1		EQU	$
		HEX	000,000,000,002
;
SOUNYUU		EQU	$
		PHB
		PHK
		PLB
;
		LDA	<KEYDAT
		SEC
		SBC	#04DH
		TAY
		CMP	#04H
		BCC	SNU010		; houkou key ?
;					; no
		JMP	SNU150
;
SNU010		EQU	$
		LDA	<YPOSDT
		CLC
		ADC	!YPOSDAT,Y
		TAX
		CMP	#0FFH
		BNE	SNU020
;
		LDX	#000H
		BRA	SNU050
;
SNU020		EQU	$
		CMP	<RETURN
		BEQ	SNU050
;
		BMI	SNU050
;
		LDX	<RETURN
;
SNU050		EQU	$
		STX	<YPOSDT
		TXA
		ASL	A
		TAX
		LDA	<XPOSDT
		AND	#03FH
		CLC
		ADC	!DOTPDAT,X
		STA	<XPOSDT
		CLC
		ADC	!XPOSDAT,Y
		TAX
		CMP	#0FFH
		BNE	SNU060
;
		LDX	#000H
		BRA	SNU100
;
SNU060		EQU	$
		AND	#00111111B
		CMP	#00111111B
		BNE	SNU070
;
		LDA	<YPOSDT
		BEQ	SNU070
;
		DEC	<YPOSDT
;
SNU070		EQU	$
		LDA	>DOTBUF,X
		BNE	SNU100
;
		TXA
		AND	#00111111B
		BEQ	SNU100
;
		DEX
		BRA	SNU070
;
SNU100		EQU	$
		STX	<XPOSDT
		LDY	<YPOSDT
		LDA	!OAMYPOS,Y
		STA	!OAM+1
		CLC
		ADC	#008H
		STA	!OAM+5
;
		LDA	>DOTBUF,X
		CLC
		ADC	#028H
		STA	!OAM
		STA	!OAM+4
;
		LDA	#00EH
		STA	!OAM+3
		STA	!OAM+7
;
		LDA	#0FEH
		STA	!OAM+2
		STA	!OAM+6
;
		JMP	SNUEND
;
SNU150		EQU	$
		LDA	<KEYDAT
		CMP	#080H
		BEQ	SNU200
;
		JSR	DATAINS
		BRA	SNUEND
;
SNU200		EQU	$
		LDA	<DELFLG
		BEQ	SNUEND
;
		JSR	DATADEL
;
;
SNUEND		EQU	$
		PLB
		RTL
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		JSR	DATADEL	( moji data delete sub )		x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
DATADEL		EQU	$
		LDX	<XPOSDT
		LDA	>MOJBUF+1,X
		TAY
		LDA	!DOTDATA,Y
		STA	<WORK0		; (work0) <-- dot data
DAL050		EQU	$
		LDA	>MOJBUF+2,X
		STA	>MOJBUF+1,X
		LDA	>DOTBUF+2,X
		TAY
		SEC
		SBC	<WORK0
		STA	>DOTBUF+1,X
		INX
		CPY	#000H
		BNE	DAL050		; moji shift end ?
;					; yes
		TYA
		STA	>DOTBUF,X
		LDA	#0168
		SEC
		SBC	>DOTBUF-1,X
		STA	<NOKORI
;
		LDA	<YPOSDT
		CMP	<RETURN
		BNE	DAL070
;
		DEC	<DOTPIT
DAL070		EQU	$
		LDA	#008H
		STA	<WORK2
;
		MI16
;
		LDA	#08000H
		STA	<WORK0
;
		LDA	<YPOSDT
		ASL	A
		TAY
		LDX	!CHRPDAT,Y
		STX	<DELPIT		; (X) <-- chara. buffer pointer
		LDY	#002A0H
		LDA	#00000H
DAL100		EQU	$
		STA	>CHRBUF,X
		INX
		INX
		DEY
		DEY
		BNE	DAL100		; chara. buffer clear end ?
;					; yes
		LDA	<YPOSDT
		ASL	A
		TAY
		LDX	!DOTPDAT,Y
		LDA	>DOTBUF+1,X
		BNE	DAL150
;
		JMP	DALEND
;
DAL150		EQU	$
		STX	<WORK6
		LDA	>MOJBUF+1,X
		AND	#000FFH
		CMP	#00090H
		BNE	DAL160		; name ?
;					; yes
		LDA	#044H
DAL160		EQU	$
		TAY
		AND	#000F0H
		ASL	A
		STA	<WORK4
		TYA
		AND	#0000FH
		ORA	<WORK4
		ASL	A
		ASL	A
		ASL	A
		ASL	A
		STA	<WORK4
		TAY
;
		LDA	>DOTBUF,X
		AND	#000FFH
		ASL	A
		STA	<WORKE
;
		STZ	<WORK8
DAL200		EQU	$
		LDA	[<WORK0],Y
		STA	<WORKC
;
		PHY
;
		LDA	<WORKE
		CLC
		ADC	<DELPIT
		TAY
		AND	#00FF0H
		CLC
		ADC	<WORK8
		TAX
		TYA
		LSR	A
		AND	#00007H
		TAY
		BEQ	DAL400
;
		M8
;
DAL250		EQU	$
		ASL	<WORKC
		BCC	DAL300
;
		LDA	>CHRBUF,X
		ORA	!BITDATA,Y
		STA	>CHRBUF,X
;
DAL300		EQU	$
		ASL	<WORKD
		BCC	DAL350
;
		LDA	>CHRBUF+1,X
		ORA	!BITDATA,Y
		STA	>CHRBUF+1,X
;
DAL350		EQU	$
		INY
		CPY	#00008H
		BNE	DAL250
;
		M16
;
		TXA
		CLC
		ADC	#00010H
		TAX
;
DAL400		EQU	$
		LDA	<WORKC
		BEQ	DAL450
;
		STA	>CHRBUF,X
;
DAL450		EQU	$
		PLY
		INY
		INY
		LDA	<WORK8
		INC	A
		INC	A
		STA	<WORK8
		CMP	#00010H
		BNE	DAL200
;
		LDA	<WORK4
		CLC
		ADC	#00100H
		TAY
;
		STZ	<WORK8
;
DAL500		EQU	$
		LDA	[<WORK0],Y
		STA	<WORKC
;
		PHY
;
		LDA	<WORKE
		CLC
		ADC	<DELPIT
		TAY
		AND	#00FF0H
		CLC
		ADC	<WORK8
		TAX
		TYA
		LSR	A
		AND	#00007H
		TAY
		BEQ	DAL700
;
		M8
;
DAL550		EQU	$
		ASL	<WORKC
		BCC	DAL600
;
		LDA	>CHRBUF+150H,X
		ORA	!BITDATA,Y
		STA	>CHRBUF+150H,X
;
DAL600		EQU	$
		ASL	<WORKD
		BCC	DAL650
;
		LDA	>CHRBUF+151H,X
		ORA	!BITDATA,Y
		STA	>CHRBUF+151H,X
;
DAL650		EQU	$
		INY
		CPY	#00008H
		BNE	DAL550
;
		M16
;
		TXA
		CLC
		ADC	#00010H
		TAX
;
DAL700		EQU	$
		LDA	<WORKC
		BEQ	DAL750
;
		STA	>CHRBUF+150H,X
;
DAL750		EQU	$
		PLY
		INY
		INY
		LDA	<WORK8
		INC	A
		INC	A
		STA	<WORK8
		CMP	#00010H
		BNE	DAL500
;
		INC	<WORK6
		LDX	<WORK6
		LDA	>DOTBUF+1,X
		BEQ	DALEND
;
		JMP	DAL150
;
DALEND		EQU	$
		MI8
;
		INC	<VRAMSH
		JMP	NOKOCNT
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;		JSR	DATAINS	( moji data ins. sub )			x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
DATAINS		EQU	$
		LDX	<KEYDAT
		LDA	!DOTDATA,X
		STA	<WORK0		; (work0) <-- dot data
		LDX	<DOTPIT
		LDA	>DOTBUF,X
		CLC
		ADC	<WORK0
		CMP	#0169
		BCS	DASEND		; insert ok ?
;					; yes
DAS100		EQU	$
		LDA	>MOJBUF,X
		STA	>MOJBUF+1,X
		LDA	>DOTBUF,X
		CLC
		ADC	<WORK0
		STA	>DOTBUF+1,X
		DEX
		CPX	<XPOSDT
		BNE	DAS100		; moji shift end ?
;					; yes
		LDA	<KEYDAT
		STA	>MOJBUF+1,X	; insert moji set
		LDA	>DOTBUF,X
		CLC
		ADC	<WORK0
		STA	>DOTBUF+1,X	; insert dot data set
		INC	<XPOSDT
		LDA	<YPOSDT
		CMP	<RETURN
		BNE	DAS150
;
		INC	<DOTPIT
DAS150		EQU	$
		LDX	<DOTPIT
		LDA	#168
		SEC
		SBC	>DOTBUF,X
		STA	<NOKORI
;
		LDY	<YPOSDT
		LDA	!OAMYPOS,Y
		STA	!OAM+1
		CLC
		ADC	#008H
		STA	!OAM+5
;
		LDX	<XPOSDT
		LDA	>DOTBUF,X
		CLC
		ADC	#028H
		STA	!OAM
		STA	!OAM+4
;
		STZ	!OAM+3
		STZ	!OAM+7
;
		LDA	#0FEH
		STA	!OAM+2
		STA	!OAM+6
;
		JMP	DAL070
;
DASEND		EQU	$
		RTS
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		JSR	SAVESUB	( messege data save sub )		x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
SAVESUB		EQU	$
		PHB
		LDA	#BANK MSGBUF
		PHA
		PLB
;
		MI16
;
		LDA	<SAVENO
		BEQ	SEB010
;
		DEC	A
		BRA	SEB020
;
SEB010		EQU	$
		LDA	!FILENO
;
SEB020		EQU	$
		ASL	A
		ASL	A
		ASL	A
		ASL	A
		ASL	A
		ASL	A
		STA	<WORK0
		ASL	A
		CLC
		ADC	<WORK0
		TAY
;
		LDX	#00000H
;
SEB050		EQU	$
		LDA	>MOJBUF,X
		STA	!MSGBUF,Y
		INY
		INY
		INX
		INX
		CPX	#000C0H
		BNE	SEB050
;
		LDA	<SAVENO
		BNE	SEB100
;
		LDA	>FILENO
		INC	A
		STA	>FILENO
;
SEB100		EQU	$
		MI8
;
		PLB
		RTS
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		JSR	LOADSUB	( messege data load sub )		x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
LOADSUB		EQU	$
		PHB
		LDA	#BANK MSGBUF
		PHA
		PLB
;
		MI16
;
		LDA	<SAVENO
		DEC	A
		ASL	A
		ASL	A
		ASL	A
		ASL	A
		ASL	A
		ASL	A
		STA	<WORK0
		ASL	A
		CLC
		ADC	<WORK0
		TAY
		LDX	#00000H
;
LDB050		EQU	$
		LDA	!MSGBUF,Y
		STA	>MOJBUF,X
		INY
		INY
		INX
		INX
		CPX	#000C0H
		BNE	LDB050
;
		MI8
;
		PLB
;
		PHB
		PHK
		PLB
;
		LDX	#000H
;
LDB100		EQU	$
		LDA	>MOJBUF,X
		TAY
		CMP	#080H
		BEQ	LDB250
;
;;;;		CMP	#0F8H
;;;;		BCC	LDB150
;;;;;
;;;;		TYA
;;;;		SEC
;;;;		SBC	#0F8H
;;;;		TAY
;;;;		LDA	!DOTSPAC,Y
;;;;		BRA	LDB200
;;;;;
;;;;LDB150		EQU	$
		LDA	!DOTDATA,Y
;
LDB200		EQU	$
		CLC
		ADC	>DOTBUF-1,X
		STA	>DOTBUF,X
;
LDB250		EQU	$
		INX
		CPX	#0C0H
		BNE	LDB100
;
		LDY	#000
;
LDB300		EQU	$
		STY	<YPOSDT
		JSR	DAL070
		LDY	<YPOSDT
		INY
		CPY	#003H
		BNE	LDB300	
;
		LDX	<WORK6
		LDA	#168
		SEC
		SBC	>DOTBUF,X
		STA	<NOKORI
;
		JSR	NOKOCNT
;
		LDX	#081H
		LDY	#002H
		LDA	>DOTBUF,X
		BNE	LDB350
;
		DEY
		LDX	#041H
		LDA	>DOTBUF,X
		BNE	LDB350
;
		DEY
		LDX	#001H
;
LDB350		EQU	$
		LDA	>DOTBUF,X
		BEQ	LDB400
;
		INX
		BRA	LDB350
;
LDB400		EQU	$
		STY	<RETURN
		DEX
		STX	<DOTPIT
		TYA
		ASL	A
		TAY
;
		M16
;
		LDA	!CHRPDAT,Y
		STA	<CHRPIT
;
		M8
;
		PLB
		RTL
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		JSR	NOINPUT	( file no input sub )			x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
NOINPUT		EQU	$
		LDY	#080H
		LDA	!KEYWK2+1
		AND	#11000000B
		BEQ	NNT100
;
		LDY	#001H
		ASL	A
		BCC	NNT050
;
		LDY	#002H
;
NNT050		EQU	$
		BRA	NNTEND
;
NNT100		EQU	$
		LDA	!KEYWK2+2
		ASL	A
		BCC	NNT150
;
		LDY	#003H
		BRA	NNTEND
;
NNT150		EQU	$
		LDA	!KEYWK2+3
		AND	#11000000B
		BEQ	NNT200
;
		LDY	#005H
		ASL	A
		BCC	NNT050
;
		LDY	#004H
		BRA	NNTEND
;
NNT200		EQU	$
		LDA	!KEYWK2+4
		AND	#11000000B
		BEQ	NNT250
;
		LDY	#007H
		ASL	A
		BCC	NNT050
;
		LDY	#006H
		BRA	NNTEND
;
NNT250		EQU	$
		LDA	!KEYWK2+5
		AND	#11000000B
		BEQ	NNT300
;
		LDY	#009H
		ASL	A
		BCC	NNT050
;
		LDY	#008H
		BRA	NNTEND
;
NNT300		EQU	$
		LDA	!KEYWK2+6
		ASL	A
		BCC	NNT350
;
		LDY	#000H
		BRA	NNTEND
;
NNT350		EQU	$
		LDA	!KEYWK2+8
		AND	#00000010
		BEQ	NNTEND
;
		LDA	<INPTDT
		ASL	A
		STA	<WORK0
		ASL	A
		ASL	A
		CLC
		ADC	<WORK0
		CLC
		ADC	<INPTDT+2
		STA	<SAVENO
		BEQ	NNT360
;
		CMP	>FILENO
		BEQ	NNT370
		BMI	NNT370
;
		BRA	NNT400
;
NNT360		EQU	$
		INC	!MODENO
;
NNT370		EQU	$
		INC	!MODENO
;
NNTEND		EQU	$
		LDX	<INPTNO
		CPY	#080H
		BEQ	NNT400
;
		STY	<INPTDT,X
		TXA
		EOR	#00000010B
		STA	<INPTNO
;
NNT400		EQU	$
		JSR	INPUTDT
		RTL
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		JSR	INPUTDT	( input data V-ram set sub )		x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
INPUTDT		EQU	$
		M16
;
		LDA	#04D51H
		STA	>VRAMD+2
		CLC
		ADC	#02000H
		STA	>VRAMD+10
;
		LDA	#00300H
		STA	>VRAMD+4
		STA	>VRAMD+12
;
		LDA	<INPTDT
		CLC
		ADC	#03D64H
		STA	>VRAMD+6
		CLC
		ADC	#00010H
		STA	>VRAMD+14
;
		LDA	<INPTDT+2
		CLC
		ADC	#03D64H
		STA	>VRAMD+8
		CLC
		ADC	#00010H
		STA	>VRAMD+16
;
		LDA	#0FFFFH
		STA	>VRAMD+18
;
		M8
;
		LDA	#04EH
		STA	!OAM+1
		CLC
		ADC	#08H
		STA	!OAM+5
;
		LDA	<INPTNO
		ASL	A
		ASL	A
		CLC
		ADC	#068H
		STA	!OAM
		STA	!OAM+4
;
		LDA	#00EH
		STA	!OAM+3
		STA	!OAM+7
;
		LDA	#0FEH
		STA	!OAM+2
		STA	!OAM+6
;
		RTS
;
;
;
;************************************************************************
;*		status display				(STTDSP)	*
;************************************************************************
STTDSP		EQU	$
		LDA	#030H
		STA	!OAM+10H
		LDA	#048H
		STA	!OAM+14H
;
		LDA	#030H
		STA	!OAM+11H
		STA	!OAM+15H
;
		LDA	<INSFLG
		ASL	A
		ORA	#090H
		STA	!OAM+12H
		LDA	<ESCFLG
		ASL	A
		ORA	#094H
		STA	!OAM+16H
;
		LDA	#000H
		STA	!OAM+13H
		LDA	#002H
		STA	!OAM+17H
;
		LDA	#00001010B
		STA	!OAMSUB+1
		RTS
;
;
;
;
;
;
;
		END
