/***********************************************
 *                                             *
 *  NES ZELDA MSSAGE FRAGMENTS COUNT PROGRAM   *
 *                                             *
 *         (@hCcŁ@DP@)        *
 *                                             *
 ***********************************************/

/*
#include "inc.h"
*/


#include	"stdio.h"
#define		unshort	  unsigned short
#define		unchar	  unsigned char


unchar sp_tbl[3][6]={
					{' ',' ',' ',' ','4','\0'},
					{' ',' ',' ','3','\0'},
					{' ',' ','2','\0'}};

unchar sp2_tbl[1][3]={			{0xa4,0xa4,'\0'}};


unchar a_tbl[5][5]={
					{'a','b','e','r','\0'},
					{'a','u','c','h','\0'},
					{'a','u','s','\0'},
					{'a','u','f','\0'},
					{'a','n','\0'}};

unchar b_tbl[3][5]={
					{'b','i','s','t','\0'},
					{'b','i','n','\0'},
					{'b','a','r','\0'}};

unchar d_tbl[15][5]={
					{'d','r','e','i','\0'},
					{'d','e','r',' ','\0'},
					{'d','i','e',' ','\0'},
					{'d','a','s',' ','\0'},
					{'d','e','n',' ','\0'},
					{'d','i','r','\0'},
					{'d','e','m','\0'},
					{'d','a',0xdf,'\0'},
					{'d','e','r','\0'},
					{'d','i','e','\0'},
					{'d','a','s','\0'},
					{'d','e','n','\0'},
					{'d','u',' ','\0'},
					{'d','u','\0'},
					{'d','a','\0'}};

unchar e_tbl[9][6]={
					{'e','t','w','a','s','\0'},
					{'e','i','n',' ','\0'},
					{'e','i','n','\0'},
					{'e','n',' ','\0'},
					{'e','r',' ','\0'},
					{'e','i',' ','\0'},
					{'e','n','\0'},
					{'e','r','\0'},
					{'e','i','\0'}};

unchar f_tbl[1][4]={			{'f',0xfc,'r','\0'}};

unchar h_tbl[4][5]={
					{'h','i','e','r','\0'},
					{'h','a','s','t','\0'},
					{'h','e','r','\0'},
					{'h','i','\0'}};

unchar i_tbl[6][5]={
					{'i','c','h',' ','\0'},
					{'i','c','h','\0'},
					{'i','s','t','\0'},
					{'i','e',' ','\0'},
					{'i','m','\0'},
					{'i','e','\0'}};

unchar m_tbl[4][6]={
					{'m','a','c','h','t','\0'},
					{'m','i','t','\0'},
					{'m','a','l','\0'},
					{'m','u','t','\0'}};

unchar n_tbl[2][7]={
					{'n','i','c','h','t',' ','\0'},
					{'n','i','c','h','t','\0'}};

unchar s_tbl[6][6]={
					{'s','c','h','o','n','\0'},
					{'s','i','c','h','\0'},
					{'s','c','h','\0'},
					{'s','i','e','\0'},
					{'s','a','m','\0'},
					{'s','p','\0'}};

unchar u_tbl[4][5]={
					{'u','n','d',' ','\0'},
					{'u','n','d','\0'},
					{'u','n','g','\0'},
					{'u','m','\0'}};

unchar v_tbl[2][4]={
					{'v','e','r','\0'},
					{'v','o','r','\0'}};

unchar z_tbl[1][3]={			{'z','u','\0'}};

unchar aa_tbl[5][5]={
					{'A','b','e','r','\0'},
					{'A','u','c','h','\0'},
					{'A','u','s','\0'},
					{'A','u','f','\0'},
					{'A','n','\0'}};

unchar bb_tbl[3][5]={
					{'B','i','s','t','\0'},
					{'B','i','n','\0'},
					{'B','a','r','\0'}};

unchar dd_tbl[12][5]={
					{'D','r','e','i','\0'},
					{'D','i','r',' ','\0'},
					{'D','i','r','\0'},
					{'D','e','m','\0'},
					{'D','a',0xdf,'\0'},
					{'D','e','r','\0'},
					{'D','i','e','\0'},
					{'D','a','s','\0'},
					{'D','e','n','\0'},
					{'D','u',' ','\0'},
					{'D','u','\0'},
					{'D','a','\0'}};

unchar ee_tbl[8][6]={
					{'E','t','w','a','s','\0'},
					{'E','i','n','\0'},
					{'E','n',' ','\0'},
					{'E','r',' ','\0'},
					{'E','i',' ','\0'},
					{'E','n','\0'},
					{'E','r','\0'},
					{'E','i','\0'}};

unchar ff_tbl[1][4]={			{'F',0xfc,'r','\0'}};

unchar hh_tbl[4][5]={
					{'H','i','e','r','\0'},
					{'H','a','s','t','\0'},
					{'H','e','r','\0'},
					{'H','i','\0'}};

unchar ii_tbl[5][5]={
					{'I','c','h',' ','\0'},
					{'I','c','h','\0'},
					{'I','s','t','\0'},
					{'I','m','\0'},
					{'I','e','\0'}};

unchar mm_tbl[4][6]={
					{'M','a','c','h','t','\0'},
					{'M','i','t','\0'},
					{'M','a','l','\0'},
					{'M','u','t','\0'}};

unchar nn_tbl[1][6]={			{'N','i','c','h','t','\0'}};

unchar ss_tbl[6][6]={
					{'S','c','h','o','n','\0'},
					{'S','i','c','h','\0'},
					{'S','c','h','\0'},
					{'S','i','e','\0'},
					{'S','a','m','\0'},
					{'S','p','\0'}};

unchar uu_tbl[3][4]={			{'U','n','d','\0'},
					{'U','n','g','\0'},
					{'U','m','\0'}};

unchar vv_tbl[2][4]={
					{'V','e','r','\0'},
					{'V','o','r','\0'}};

unchar zz_tbl[1][3]={			{'Z','u','\0'}};


unshort	sp_cnt[3];
unshort	sp2_cnt[2];
unshort a_cnt[5];
unshort b_cnt[3];
unshort d_cnt[15];
unshort e_cnt[9];
unshort f_cnt=0;
unshort h_cnt[4];
unshort i_cnt[6];
unshort m_cnt[4];
unshort n_cnt[2];
unshort s_cnt[6];
unshort u_cnt[4];
unshort v_cnt[2];
unshort z_cnt=0;
unshort aa_cnt[5];
unshort bb_cnt[3];
unshort dd_cnt[12];
unshort ee_cnt[8];
unshort ff_cnt=0;
unshort hh_cnt[4];
unshort ii_cnt[5];
unshort mm_cnt[4];
unshort nn_cnt=0;
unshort ss_cnt[6];
unshort uu_cnt[3];
unshort vv_cnt[2];
unshort zz_cnt=0;


main(argc,argv)
int  argc;
char *argv[];
{
	FILE *rfp1;
	FILE *rfp2;

	unshort tot=0;
	unshort i,j;
	unchar	*r_pnt;
	unchar	r_buf[150];

	char    name_buf[20];

	if((rfp1=fopen("Tmsgtbl.TBL","r"))==NULL){
		printf("OPEN ERROR  [ Tmsgtbl.TBL ] !!\n"); exit(1);
	}

	cnt_tbl_cls();

	while(fgets(name_buf,20,rfp1)!=NULL){

		name_buf[11]='\0';
j=0;
		if((rfp2=fopen(name_buf,"r"))==NULL){
			printf("OPEN ERROR  [ %s ] !!\n",name_buf); exit(1);
		}

		while(fgets(r_buf,150,rfp2)!=NULL){
j++;
			r_pnt=r_buf;

			while((char)(*r_pnt)!='\0'){

				switch(*r_pnt){

					case '@':
						while(*r_pnt!='@') r_pnt++;
						r_pnt++;
						break;

					case ' ':
						if(*(r_pnt+1)==sp_tbl[0][1] && *(r_pnt+2)==sp_tbl[0][2] && *(r_pnt+3)==sp_tbl[0][3]){
							sp_cnt[0]++;
							r_pnt+=4;
						}

						else if(*(r_pnt+1)==sp_tbl[1][1] && *(r_pnt+2)==sp_tbl[1][2]){
								sp_cnt[1]++;
								r_pnt+=3;
						}

						else if(*(r_pnt+1)==sp_tbl[2][1]){
								sp_cnt[2]++;
								r_pnt+=2;
						}

						else {
							r_pnt++;
						}

						break;


					case 0xa4:
						for(i=1;i<42;i++){
							if(*(r_pnt+i)!=0xa4)
								break;
						}

						if(i==42){
								sp2_cnt[0]++;
								r_pnt+=42;
								break;
						}

						if(*(r_pnt+1)==sp2_tbl[0][1]){
					   			sp2_cnt[1]++;
					   			r_pnt++;
					   	}

						r_pnt++;
						break;


					case 'a':
						for(i=0;i<2;i++){
							if(*(r_pnt+1)==a_tbl[i][1] && *(r_pnt+2)==a_tbl[i][2] && *(r_pnt+3)==a_tbl[i][3]){
					   			a_cnt[i]++;
					   			r_pnt+=4;
					   			i=99;
						   	}
					   	}

						if(i==100) break;

						for(i=2;i<4;i++){
							if(*(r_pnt+1)==a_tbl[i][1] && *(r_pnt+2)==a_tbl[i][2]){
								a_cnt[i]++;
								r_pnt+=3;
								i=99;
							}
						}

						if(i==100) break;

						if(*(r_pnt+1)==a_tbl[4][1]){
								a_cnt[4]++;
								r_pnt++;
				   		}

						r_pnt++;
						break;


					case 'b':
						if(*(r_pnt+1)==b_tbl[0][1] && *(r_pnt+2)==b_tbl[0][2] && *(r_pnt+3)==b_tbl[0][3]){
								b_cnt[0]++;
								r_pnt+=4;
								break;
					   	}

						for(i=1;i<3;i++){
							if(*(r_pnt+1)==b_tbl[i][1] && *(r_pnt+2)==b_tbl[i][2]){
								b_cnt[i]++;
								r_pnt+=2;
								i=99;
							}
						}

						r_pnt++;
						break;


					case 'd':
						for(i=0;i<5;i++){
							if(*(r_pnt+1)==d_tbl[i][1] && *(r_pnt+2)==d_tbl[i][2] && *(r_pnt+3)==d_tbl[i][3]){
								d_cnt[i]++;
								r_pnt+=4;
								i=99;
							}
						}

						if(i==100) break;

						for(i=5;i<13;i++){
							if(*(r_pnt+1)==d_tbl[i][1] && *(r_pnt+2)==d_tbl[i][2]){
					   			d_cnt[i]++;
					   			r_pnt+=3;
								i=99;
							}
						}

						if(i==100) break;

						for(i=13;i<15;i++){
							if(*(r_pnt+1)==d_tbl[i][1]){
					   			d_cnt[i]++;
					   			r_pnt++;
								i=99;
							}
						}

						r_pnt++;
						break;


					case 'e':
						if(*(r_pnt+1)==e_tbl[0][1] && *(r_pnt+2)==e_tbl[0][2] &&
						   *(r_pnt+3)==e_tbl[0][3] && *(r_pnt+4)==e_tbl[0][4]){
								e_cnt[0]++;
								r_pnt+=5;
								break;
				   		}

						if(*(r_pnt+1)==e_tbl[1][1] && *(r_pnt+2)==e_tbl[1][2] && *(r_pnt+3)==e_tbl[1][3]){
								e_cnt[1]++;
								r_pnt+=3;
								i=99;
						}

						for(i=2;i<6;i++){
							if(*(r_pnt+1)==e_tbl[i][1] && *(r_pnt+2)==e_tbl[i][2]){
								e_cnt[i]++;
								r_pnt+=3;
								i=99;
							}
						}

						if(i==100) break;

						for(i=6;i<9;i++){
							if(*(r_pnt+1)==e_tbl[i][1]){
								e_cnt[i]++;
								r_pnt++;
								i=99;
							}
						}

						r_pnt++;
						break;


					case 'f':
						if(*(r_pnt+1)==f_tbl[0][1] && *(r_pnt+2)==f_tbl[0][2]){
								f_cnt++;
								r_pnt+=2;
					   	}

						r_pnt++;
						break;
						

					case 'h':
						for(i=0;i<2;i++){
							if(*(r_pnt+1)==h_tbl[i][1] && *(r_pnt+2)==h_tbl[i][2] && *(r_pnt+3)==h_tbl[i][3]){
								h_cnt[i]++;
								r_pnt+=4;
								i=99;
							}
					   	}

						if(i==100) break;

						if(*(r_pnt+1)==h_tbl[2][1] && *(r_pnt+2)==h_tbl[2][2]){
								h_cnt[2]++;
								r_pnt+=3;
								break;
						}

						if(*(r_pnt+1)==h_tbl[3][1]){
								h_cnt[3]++;
								r_pnt++;
						}

						r_pnt++;
						break;


					case 'i':
						if(*(r_pnt+1)==i_tbl[0][1] && *(r_pnt+2)==i_tbl[0][2] && *(r_pnt+3)==i_tbl[0][3]){
								i_cnt[0]++;
								r_pnt+=4;
								break;
						}

						for(i=1;i<4;i++){
							if(*(r_pnt+1)==i_tbl[i][1] && *(r_pnt+2)==i_tbl[i][2]){
								i_cnt[i]++;
								r_pnt+=3;
								i=99;
							}
						}

						if(i==100) break;

						for(i=4;i<6;i++){
							if(*(r_pnt+1)==i_tbl[i][1]){
								i_cnt[i]++;
								r_pnt++;
								i=99;
							}
						}

						r_pnt++;
						break;


					case 'm':
						if(*(r_pnt+1)==m_tbl[0][1] && *(r_pnt+2)==m_tbl[0][2] &&
						   *(r_pnt+3)==m_tbl[0][3] && *(r_pnt+4)==m_tbl[0][4]){
								m_cnt[0]++;
								r_pnt+=5;
								break;
						}

						for(i=1;i<4;i++){
							if(*(r_pnt+1)==m_tbl[i][1]&& *(r_pnt+2)==m_tbl[i][2]){
								m_cnt[i]++;
								r_pnt+=2;
								i=99;
							}
					   	}

						r_pnt++;
						break;


					case 'n':
						if(*(r_pnt+1)==n_tbl[0][1] && *(r_pnt+2)==n_tbl[0][2] &&
						   *(r_pnt+3)==n_tbl[0][3] && *(r_pnt+4)==n_tbl[0][4] &&
						   *(r_pnt+5)==n_tbl[0][5]){
								n_cnt[0]++;
								r_pnt+=6;
								break;
						}


						if(*(r_pnt+1)==n_tbl[1][1] && *(r_pnt+2)==n_tbl[1][2] &&
						   *(r_pnt+3)==n_tbl[1][3] && *(r_pnt+4)==n_tbl[1][4]){
								n_cnt[1]++;
								r_pnt+=4;
						}

						r_pnt++;
						break;


					case 's':
						if(*(r_pnt+1)==s_tbl[0][1] && *(r_pnt+2)==s_tbl[0][2] &&
						   *(r_pnt+3)==s_tbl[0][3] && *(r_pnt+4)==s_tbl[0][4]){
								s_cnt[0]++;
								r_pnt+=5;
								break;
						}

						if(*(r_pnt+1)==s_tbl[1][1] && *(r_pnt+2)==s_tbl[1][2] && *(r_pnt+3)==s_tbl[1][3]){
								s_cnt[1]++;
								r_pnt+=4;
								break;
						}

						for(i=2;i<5;i++){
							if(*(r_pnt+1)==s_tbl[i][1] && *(r_pnt+2)==s_tbl[i][2]){
					   			s_cnt[i]++;
					   			r_pnt+=3;
					   			i=99;
					   		}
					   	}

						if(i==100) break;

						if(*(r_pnt+1)==s_tbl[5][1]){
					   			s_cnt[5]++;
					   			r_pnt++;
				   		}

						r_pnt++;
						break;


					case 'u':
						if(*(r_pnt+1)==u_tbl[0][1] && *(r_pnt+2)==u_tbl[0][2] && *(r_pnt+3)==u_tbl[0][3]){
						   		u_cnt[0]++;
						   		r_pnt+=4;
								break;
						}

						for(i=1;i<3;i++){
							if(*(r_pnt+1)==u_tbl[i][1] && *(r_pnt+2)==u_tbl[i][2]){
						   		u_cnt[i]++;
						   		r_pnt+=3;
								i=99;
							}
						}

						if(i==100) break;

						if(*(r_pnt+1)==u_tbl[3][1]){
								u_cnt[3]++;
								r_pnt++;
						}

						r_pnt++;
						break;


					case 'v':
						for(i=0;i<2;i++){
							if(*(r_pnt+1)==v_tbl[i][1] && *(r_pnt+2)==v_tbl[i][2]){
						   		v_cnt[i]++;
						   		r_pnt+=2;
						   		i=99;
							}
						}

						r_pnt++;
						break;


					case 'A':
						for(i=0;i<2;i++){
							if(*(r_pnt+1)==aa_tbl[i][1] && *(r_pnt+2)==aa_tbl[i][2] && *(r_pnt+3)==aa_tbl[i][3]){
					   			aa_cnt[i]++;
					   			r_pnt+=4;
					   			i=99;
						   	}
					   	}

						if(i==100) break;

						for(i=2;i<4;i++){
							if(*(r_pnt+1)==aa_tbl[i][1] && *(r_pnt+2)==aa_tbl[i][2]){
								aa_cnt[i]++;
								r_pnt+=3;
								i=99;
							}
						}

						if(i==100) break;

						if(*(r_pnt+1)==aa_tbl[4][1]){
								aa_cnt[4]++;
								r_pnt++;
				   		}

						r_pnt++;
						break;


					case 'B':
						if(*(r_pnt+1)==bb_tbl[0][1] && *(r_pnt+2)==bb_tbl[0][2] && *(r_pnt+3)==bb_tbl[0][3]){
								bb_cnt[0]++;
								r_pnt+=4;
								break;
					   	}

						for(i=1;i<3;i++){
							if(*(r_pnt+1)==bb_tbl[i][1] && *(r_pnt+2)==bb_tbl[i][2]){
								bb_cnt[i]++;
								r_pnt+=2;
								i=99;
							}
						}

						r_pnt++;
						break;


					case 'D':
						for(i=0;i<2;i++){
							if(*(r_pnt+1)==dd_tbl[i][1] && *(r_pnt+2)==dd_tbl[i][2] && *(r_pnt+3)==dd_tbl[i][3]){
								dd_cnt[i]++;
								r_pnt+=4;
								i=99;
							}
						}

						if(i==100) break;

						for(i=2;i<10;i++){
							if(*(r_pnt+1)==dd_tbl[i][1] && *(r_pnt+2)==dd_tbl[i][2]){
					   			dd_cnt[i]++;
					   			r_pnt+=3;
								i=99;
							}
						}

						if(i==100) break;

						for(i=10;i<12;i++){
							if(*(r_pnt+1)==dd_tbl[i][1]){
					   			dd_cnt[i]++;
					   			r_pnt++;
								i=99;
							}
						}

						r_pnt++;
						break;


					case 'E':
						if(*(r_pnt+1)==ee_tbl[0][1] && *(r_pnt+2)==ee_tbl[0][2] &&
						   *(r_pnt+3)==ee_tbl[0][3] && *(r_pnt+4)==ee_tbl[0][4]){
								ee_cnt[0]++;
								r_pnt+=5;
								break;
				   		}

						for(i=1;i<5;i++){
							if(*(r_pnt+1)==ee_tbl[i][1] && *(r_pnt+2)==ee_tbl[i][2]){
								ee_cnt[i]++;
								r_pnt+=3;
								i=99;
							}
						}

						if(i==100) break;

						for(i=5;i<8;i++){
							if(*(r_pnt+1)==ee_tbl[i][1]){
								ee_cnt[i]++;
								r_pnt++;
								i=99;
							}
						}

						r_pnt++;
						break;


					case 'F':
						if(*(r_pnt+1)==ff_tbl[0][1] && *(r_pnt+2)==ff_tbl[0][2]){
								ff_cnt++;
								r_pnt+=2;
					   	}

						r_pnt++;
						break;
						

					case 'H':
						for(i=0;i<2;i++){
							if(*(r_pnt+1)==hh_tbl[i][1] && *(r_pnt+2)==hh_tbl[i][2] && *(r_pnt+3)==hh_tbl[i][3]){
								hh_cnt[i]++;
								r_pnt+=4;
								i=99;
							}
					   	}

						if(i==100) break;

						if(*(r_pnt+1)==hh_tbl[2][1] && *(r_pnt+2)==hh_tbl[2][2]){
								hh_cnt[2]++;
								r_pnt+=3;
								break;
						}

						if(*(r_pnt+1)==hh_tbl[3][1]){
								hh_cnt[3]++;
								r_pnt++;
						}

						r_pnt++;
						break;


					case 'I':
						if(*(r_pnt+1)==ii_tbl[0][1] && *(r_pnt+2)==ii_tbl[0][2] && *(r_pnt+3)==ii_tbl[0][3]){
								ii_cnt[0]++;
								r_pnt+=4;
								break;
						}

						for(i=1;i<3;i++){
							if(*(r_pnt+1)==ii_tbl[i][1] && *(r_pnt+2)==ii_tbl[i][2]){
								ii_cnt[i]++;
								r_pnt+=3;
								i=99;
							}
						}

						if(i==100) break;

						for(i=3;i<5;i++){
							if(*(r_pnt+1)==ii_tbl[i][1]){
								ii_cnt[i]++;
								r_pnt++;
								i=99;
							}
						}

						r_pnt++;
						break;


					case 'M':
						if(*(r_pnt+1)==mm_tbl[0][1] && *(r_pnt+2)==mm_tbl[0][2] &&
						   *(r_pnt+3)==mm_tbl[0][3] && *(r_pnt+4)==mm_tbl[0][4]){
								mm_cnt[0]++;
								r_pnt+=5;
								break;
						}

						for(i=1;i<4;i++){
							if(*(r_pnt+1)==mm_tbl[i][1]&& *(r_pnt+2)==mm_tbl[i][2]){
					   			mm_cnt[i]++;
					   			r_pnt+=2;
					   			i=99;
					   		}
					   	}

						r_pnt++;
						break;


					case 'N':
						if(*(r_pnt+1)==nn_tbl[0][1] && *(r_pnt+2)==nn_tbl[0][2] &&
						   *(r_pnt+3)==nn_tbl[0][3] && *(r_pnt+4)==nn_tbl[0][4]){
								nn_cnt++;
								r_pnt+=4;
						}

						r_pnt++;
						break;


					case 'S':
						if(*(r_pnt+1)==ss_tbl[0][1] && *(r_pnt+2)==ss_tbl[0][2] &&
						   *(r_pnt+3)==ss_tbl[0][3] && *(r_pnt+4)==ss_tbl[0][4]){
								ss_cnt[0]++;
								r_pnt+=5;
								break;
						}

						if(*(r_pnt+1)==ss_tbl[1][1] && *(r_pnt+2)==ss_tbl[1][2] && *(r_pnt+3)==ss_tbl[1][3]){
								ss_cnt[1]++;
								r_pnt+=4;
								break;
						}

						for(i=2;i<5;i++){
							if(*(r_pnt+1)==ss_tbl[i][1] && *(r_pnt+2)==ss_tbl[i][2]){
								ss_cnt[i]++;
								r_pnt+=3;
								i=99;
							}
					   	}

						if(i==100) break;

						if(*(r_pnt+1)==ss_tbl[5][1]){
					   			ss_cnt[5]++;
					   			r_pnt++;
				   		}

						r_pnt++;
						break;


					case 'U':
						for(i=0;i<2;i++){
							if(*(r_pnt+1)==uu_tbl[i][1] && *(r_pnt+2)==uu_tbl[i][2]){
								uu_cnt[i]++;
								r_pnt+=3;
								i=99;
							}
						}

						if(i==100) break;

						if(*(r_pnt+1)==uu_tbl[2][1]){
								uu_cnt[2]++;
								r_pnt++;
						}

						r_pnt++;
						break;


					case 'V':
						for(i=0;i<2;i++){
							if(*(r_pnt+1)==vv_tbl[i][1] && *(r_pnt+2)==vv_tbl[i][2]){
						   		vv_cnt[i]++;
						   		r_pnt+=2;
						   		i=99;
							}
						}

						r_pnt++;
						break;


					default :
						r_pnt++;
						break;	
				}
			}
		}
		fclose(rfp2);
	}


	for(i=0;i<3;i++){
		printf(" SP  %c --> %4d    * %3d  =  %4d\n",sp_tbl[i][i*(-1)+4],sp_cnt[i],(strlen(sp_tbl[i])-2),(sp_cnt[i]*(strlen(sp_tbl[i])-2)));	
		tot+=sp_cnt[i]*(strlen(sp_tbl[i])-2);
	}

	printf(" SP 42 --> %4d    * %3d  =  %4d\n",sp2_cnt[0],(42-1),(sp2_cnt[0]*(42-1)));
	tot+=sp2_cnt[0]*(42-1);
	printf(" SP  2 --> %4d    * %3d  =  %4d\n\n",sp2_cnt[1],(strlen(sp2_tbl[0])-1),(sp2_cnt[1]*(strlen(sp2_tbl[0])-1)));
	tot+=sp2_cnt[1]*(strlen(sp2_tbl[0])-1);


	for(i=0;i<5;i++){
		printf("%10s --> %4d    * %3d  =  %4d\n",a_tbl[i],a_cnt[i],(strlen(a_tbl[i])-1),(a_cnt[i]*(strlen(a_tbl[i])-1)));
		tot+=a_cnt[i]*(strlen(a_tbl[i])-1);
	}

	for(i=0;i<3;i++){
		printf("%10s --> %4d    * %3d  =  %4d\n",b_tbl[i],b_cnt[i],(strlen(b_tbl[i])-1),(b_cnt[i]*(strlen(b_tbl[i])-1)));
		tot+=b_cnt[i]*(strlen(b_tbl[i])-1);
	}

	for(i=0;i<15;i++){
		printf("%10s --> %4d    * %3d  =  %4d\n",d_tbl[i],d_cnt[i],(strlen(d_tbl[i])-1),(d_cnt[i]*(strlen(d_tbl[i])-1)));
		tot+=d_cnt[i]*(strlen(d_tbl[i])-1);
	}

	for(i=0;i<9;i++){
		printf("%10s --> %4d    * %3d  =  %4d\n",e_tbl[i],e_cnt[i],(strlen(e_tbl[i])-1),(e_cnt[i]*(strlen(e_tbl[i])-1)));
		tot+=e_cnt[i]*(strlen(e_tbl[i])-1);
	}

	printf("%10s --> %4d    * %3d  =  %4d\n",f_tbl[0],f_cnt,(strlen(f_tbl[0])-1),(f_cnt*(strlen(f_tbl[0])-1)));
	tot+=f_cnt*(strlen(f_tbl[0])-1);

	for(i=0;i<3;i++){
		printf("%10s --> %4d    * %3d  =  %4d\n",h_tbl[i],h_cnt[i],(strlen(h_tbl[i])-1),(h_cnt[i]*(strlen(h_tbl[i])-1)));
		tot+=h_cnt[i]*(strlen(h_tbl[i])-1);
	}

	for(i=0;i<6;i++){
		printf("%10s --> %4d    * %3d  =  %4d\n",i_tbl[i],i_cnt[i],(strlen(i_tbl[i])-1),(i_cnt[i]*(strlen(i_tbl[i])-1)));
		tot+=i_cnt[i]*(strlen(i_tbl[i])-1);
	}

	for(i=0;i<4;i++){
		printf("%10s --> %4d    * %3d  =  %4d\n",m_tbl[i],m_cnt[i],(strlen(m_tbl[i])-1),(m_cnt[i]*(strlen(m_tbl[i])-1)));
		tot+=m_cnt[i]*(strlen(m_tbl[i])-1);
	}

	for(i=0;i<2;i++){
		printf("%10s --> %4d    * %3d  =  %4d\n",n_tbl[i],n_cnt[i],(strlen(n_tbl[i])-1),(n_cnt[i]*(strlen(n_tbl[i])-1)));
		tot+=n_cnt[i]*(strlen(n_tbl[i])-1);
	}

	for(i=0;i<6;i++){
		printf("%10s --> %4d    * %3d  =  %4d\n",s_tbl[i],s_cnt[i],(strlen(s_tbl[i])-1),(s_cnt[i]*(strlen(s_tbl[i])-1)));
		tot+=s_cnt[i]*(strlen(s_tbl[i])-1);
	}

	for(i=0;i<4;i++){
		printf("%10s --> %4d    * %3d  =  %4d\n",u_tbl[i],u_cnt[i],(strlen(u_tbl[i])-1),(u_cnt[i]*(strlen(u_tbl[i])-1)));
		tot+=u_cnt[i]*(strlen(u_tbl[i])-1);
	}

	for(i=0;i<2;i++){
		printf("%10s --> %4d    * %3d  =  %4d\n",v_tbl[i],v_cnt[i],(strlen(v_tbl[i])-1),(v_cnt[i]*(strlen(v_tbl[i])-1)));
		tot+=v_cnt[i]*(strlen(v_tbl[i])-1);
	}

	printf("%10s --> %4d    * %3d  =  %4d\n\n",z_tbl[0],z_cnt,(strlen(z_tbl[0])-1),(z_cnt*(strlen(z_tbl[0])-1)));
	tot+=z_cnt*(strlen(z_tbl[0])-1);


	for(i=0;i<5;i++){
		printf("%10s --> %4d    * %3d  =  %4d\n",aa_tbl[i],aa_cnt[i],(strlen(aa_tbl[i])-1),(aa_cnt[i]*(strlen(aa_tbl[i])-1)));
		tot+=aa_cnt[i]*(strlen(aa_tbl[i])-1);
	}

	for(i=0;i<3;i++){
		printf("%10s --> %4d    * %3d  =  %4d\n",bb_tbl[i],bb_cnt[i],(strlen(bb_tbl[i])-1),(bb_cnt[i]*(strlen(bb_tbl[i])-1)));
		tot+=bb_cnt[i]*(strlen(bb_tbl[i])-1);
	}

	for(i=0;i<12;i++){
		printf("%10s --> %4d    * %3d  =  %4d\n",dd_tbl[i],dd_cnt[i],(strlen(dd_tbl[i])-1),(dd_cnt[i]*(strlen(dd_tbl[i])-1)));
		tot+=dd_cnt[i]*(strlen(dd_tbl[i])-1);
	}

	for(i=0;i<8;i++){
		printf("%10s --> %4d    * %3d  =  %4d\n",ee_tbl[i],ee_cnt[i],(strlen(ee_tbl[i])-1),(ee_cnt[i]*(strlen(ee_tbl[i])-1)));
		tot+=ee_cnt[i]*(strlen(ee_tbl[i])-1);
	}

	printf("%10s --> %4d    * %3d  =  %4d\n",ff_tbl[0],ff_cnt,(strlen(ff_tbl[0])-1),(ff_cnt*(strlen(ff_tbl[0])-1)));
	tot+=ff_cnt*(strlen(ff_tbl[0])-1);

	for(i=0;i<3;i++){
		printf("%10s --> %4d    * %3d  =  %4d\n",hh_tbl[i],hh_cnt[i],(strlen(hh_tbl[i])-1),(hh_cnt[i]*(strlen(hh_tbl[i])-1)));
		tot+=hh_cnt[i]*(strlen(hh_tbl[i])-1);
	}

	for(i=0;i<5;i++){
		printf("%10s --> %4d    * %3d  =  %4d\n",ii_tbl[i],ii_cnt[i],(strlen(ii_tbl[i])-1),(ii_cnt[i]*(strlen(ii_tbl[i])-1)));
		tot+=ii_cnt[i]*(strlen(ii_tbl[i])-1);
	}

	for(i=0;i<4;i++){
		printf("%10s --> %4d    * %3d  =  %4d\n",mm_tbl[i],mm_cnt[i],(strlen(mm_tbl[i])-1),(mm_cnt[i]*(strlen(mm_tbl[i])-1)));
		tot+=mm_cnt[i]*(strlen(mm_tbl[i])-1);
	}

	printf("%10s --> %4d    * %3d  =  %4d\n",nn_tbl[0],nn_cnt,(strlen(nn_tbl[0])-1),(nn_cnt*(strlen(nn_tbl[0])-1)));
	tot+=nn_cnt*(strlen(nn_tbl[0])-1);

	for(i=0;i<6;i++){
		printf("%10s --> %4d    * %3d  =  %4d\n",ss_tbl[i],ss_cnt[i],(strlen(ss_tbl[i])-1),(ss_cnt[i]*(strlen(ss_tbl[i])-1)));
		tot+=ss_cnt[i]*(strlen(ss_tbl[i])-1);
	}

	for(i=0;i<3;i++){
		printf("%10s --> %4d    * %3d  =  %4d\n",uu_tbl[i],uu_cnt[i],(strlen(uu_tbl[i])-1),(uu_cnt[i]*(strlen(uu_tbl[i])-1)));
		tot+=uu_cnt[i]*(strlen(uu_tbl[i])-1);
	}

	for(i=0;i<2;i++){
		printf("%10s --> %4d    * %3d  =  %4d\n",vv_tbl[i],vv_cnt[i],(strlen(vv_tbl[i])-1),(vv_cnt[i]*(strlen(vv_tbl[i])-1)));
		tot+=vv_cnt[i]*(strlen(vv_tbl[i])-1);
	}

	printf("%10s --> %4d    * %3d  =  %4d\n",zz_tbl[0],zz_cnt,(strlen(zz_tbl[0])-1),(zz_cnt*(strlen(zz_tbl[0])-1)));
	tot+=zz_cnt*(strlen(zz_tbl[0])-1);



	printf("\n\n@@@@@@@@@@@@@v  =%6d\n\n",tot);

	fclose(rfp1);

}


cnt_tbl_cls()
{
	unshort i;

	for(i=0;i<2;i++){
		n_cnt[i]=0;
		v_cnt[i]=0;
		vv_cnt[i]=0;
	}
	for(i=0;i<3;i++){
		sp_cnt[i]=0;
		b_cnt[i]=0;
		bb_cnt[i]=0;
		uu_cnt[i]=0;
	}
	for(i=0;i<4;i++){
		h_cnt[i]=0;
		hh_cnt[i]=0;
		m_cnt[i]=0;
		mm_cnt[i]=0;
		u_cnt[i]=0;
	}
	for(i=0;i<5;i++){
		a_cnt[i]=0;
		aa_cnt[i]=0;
		ii_cnt[i]=0;
	}
	for(i=0;i<6;i++){
		i_cnt[i]=0;
		s_cnt[i]=0;
		ss_cnt[i]=0;
	}
	for(i=0;i<8;i++){
		e_cnt[i]=0;
		ee_cnt[i]=0;
	}
	for(i=0;i<15;i++)
		d_cnt[i]=0;
	for(i=0;i<12;i++)
		dd_cnt[i]=0;
}
