;
		INCLUDE	zel_ram.asm
;
;------------------------------------------------------------------------
;
;		PAL_ZELDA-3 (FRANCE)		1992.05.26(TUE)
;
;------------------------------------------------------------------------
;
		ORG	0EBF81H
;
;=============================================== (zel_ending) ===========
		GLB	ENDPLY1,GGNDSCL,EDPLINT
		GLB	TRYD
;=============================================== (zel_main) =============
		EXT	VRAMCL2,SNDTR1,BLANKING,DTSAVE
;=============================================== (zel_init) =============
		EXT	ENDINT0,ENDINT1,ENDGSCL,EIT800
;=============================================== (zel_vma ) =============
		EXT	VT01
;=============================================== (zel_char0) ============
		EXT	ENDGVRMS
		EXT	B3CGSET
;=============================================== (zel_enmy.etc ) ========
		EXT	ENRMCL,SETOAML22,PSSAVE2,OAMENT1,ENMOVE2
		EXT	ENMVCLL,SADWSTL,BSSTXD,BSSTYD,RNDSET
		EXT	NIWAT,NOKOG,BWAKO,ZORAB,ZORAS,BABAA,HACHI
		EXT	HAGE0,SEKMV,OYAGI,MAJOO,MJSY1,USAGI,OOOMU
		EXT	KUTUU,NYORO,KARAS,ATARS,TORI0,KAJIY,YOSEI
		EXT	EMOVE
;=============================================== (zel_comn) =============
		EXT	CGCNG1,MGMCRS000,MGMCGCNG
;=============================================== (zel_title) ============
		EXT	TILRETURN,PLGNED2,TRYFS20
;========================================================================
		EXT	GOVHRTD
;========================================================================
		EXT	transfer_flag
;========================================================================
;
		MEM8
		IDX8
		EXTEND
;
;
;
;************************************************************************
;*									*
;************************************************************************
;
ENDDATA	EQU	$
	WORD	ENDINT2		;  1 [ shiro ]
	WORD	ENDPLY2
	WORD	ENDINT3		;  2 [ kyoukai ]
	WORD	ENDPLY3
	WORD	ENDINT2		;  3 [ chourou no machi ]
	WORD	ENDPLY2
	WORD	ENDINT2		;  4 [ sabaku ]
	WORD	ENDPLY2
	WORD	ENDINT2		;  5 [ yama no tryforce ]
	WORD	ENDPLY2
	WORD	ENDINT2		;  6 [ link no ie ]
	WORD	ENDPLY2
	WORD	ENDINT2		;  7 [ zora ]
	WORD	ENDPLY2
	WORD	ENDINT2		;  8 [ mahouya ]
	WORD	ENDPLY2
	WORD	ENDINT2		;  9 [ kikori ]
	WORD	ENDPLY2
	WORD	ENDINT2		; 10 [ okarina syounen ]
	WORD	ENDPLY2
	WORD	ENDINT3		; 11 [ megami no doukuthu ]
	WORD	ENDPLY3
	WORD	ENDINT3		; 12 [ kajiya ]
	WORD	ENDPLY3
	WORD	ENDINT2		; 13 [ machi ]
	WORD	ENDPLY2
	WORD	ENDINT2		; 14 [ yama no hashi ]
	WORD	ENDPLY2
	WORD	ENDINT2		; 15 [ mori ]
	WORD	ENDPLY2
	WORD	ENDINT2		; 16 [ ken spot ]
	WORD	ENDPLY2
	WORD	STAFINT		; staff roll init.
	WORD	FAIDIN0
	WORD	SCRMOVE		; staff roll move
	WORD	ENDEND1
TRYDT	WORD	ENDEND2
	WORD	ENDEND3
	WORD	ENDEND0
;
TRYD		EQU	(TRYDT-ENDDATA)/2
;
;
ENDPLY1	EQU	$
	MEM16
	REP	#00100000B	; memory 16bit mode !!
;
	LDA	#30H
	STA	NXINDX
	LDA	#01D0H
	STA	NXINDX+2
	STZ	NXINDX+4
;
	MEM8
	SEP	#00100000B	; memory 8bit mode !!
;
	LDA	<GAMEMD
	ASL	A
	TAX
	JSR	(ENDDATA,X)
;
	RTL
;
;
ENDINT2	EQU	$
	JSL	>ENDINT0
	JSR	MEGESET
	RTS
;
ENDINT3	EQU	$
	JSL	>ENDINT1
	JSR	MEGESET
	RTS
;
;
ENDDAT1	EQU	$
	WORD	ENINT01		;  1
	WORD	ENINT12		;  2
	WORD	ENINT02		;  3
	WORD	ENINT11		;  4
	WORD	ENINT03		;  5
	WORD	ENINT04		;  6
	WORD	ENINT09		;  7
	WORD	ENINT13		;  8
	WORD	ENINT06		;  9
	WORD	ENINT14		; 10
	WORD	ENINT07		; 11
	WORD	ENINT10		; 12
	WORD	ENINT08		; 13
	WORD	ENINT05		; 14
	WORD	ENINT15		; 15
	WORD	ENINT16		; 16
;
;
;
EDPLINT	EQU	$
	PHB
	PHK
	PLB			; DBR <= PBR
;
	LDX	#16-1
EDPLIN0	EQU	$
	JSL	>ENRMCL
	STZ	ENMODE,X
	STZ	ENMOD4,X
	STZ	ENMOD5,X
;
	DEX
	BPL	EDPLIN0
;
	LDA	<GAMEMD
	AND	#0FEH
	TAX
	JSR	(ENDDAT1,X)
;
	PLB			; DBR reset !!
	RTL
;
;
SCCVDT	EQU	$
	WORD	006F2H		;  1
	WORD	00210H		;  2
	WORD	0072CH		;  3
	WORD	00C00H		;  4
	WORD	0010CH		;  5
	WORD	00A9BH		;  6
	WORD	00010H		;  7
	WORD	00510H		;  8
	WORD	00089H		;  9
	WORD	00A8EH		; 10
	WORD	0222CH		; 11
	WORD	02510H		; 12
	WORD	00826H		; 13
	WORD	0005CH		; 14
	WORD	0020AH		; 15
	WORD	00030H		; 16
;
SCCHDT	EQU	$
	WORD	0077FH		;  1
	WORD	00480H		;  2
	WORD	00193H		;  3
	WORD	000AAH		;  4
	WORD	00878H		;  5
	WORD	00847H		;  6
	WORD	004FDH		;  7
	WORD	00C57H		;  8
	WORD	0040FH		;  9
	WORD	00478H		; 10
	WORD	00A00H		; 11
	WORD	00200H		; 12
	WORD	00201H		; 13
	WORD	00AA1H		; 14
	WORD	0026FH		; 15
	WORD	00000H		; 16
;
SCVADDT	EQU	$
	WORD	0FFFFH		;  1
	WORD	0FFFFH		;  2
	WORD	00001H		;  3
	WORD	0FFFFH		;  4
	WORD	00001H		;  5
	WORD	00001H		;  6
	WORD	00000H		;  7
	WORD	00001H		;  8
	WORD	00000H		;  9
	WORD	0FFFFH		; 10
	WORD	0FFFFH		; 11
	WORD	00000H		; 12
	WORD	00000H		; 13
	WORD	00000H		; 14
	WORD	00001H		; 15
	WORD	0FFFFH		; 16
;
SCHADDT	EQU	$
	WORD	00000H		;  1
	WORD	00000H		;  2
	WORD	0FFFFH		;  3
	WORD	00000H		;  4
	WORD	00000H		;  5
	WORD	0FFFFH		;  6
	WORD	00001H		;  7
	WORD	00000H		;  8
	WORD	0FFFFH		;  9
	WORD	00000H		; 10
	WORD	00000H		; 11
	WORD	00000H		; 12
	WORD	00001H		; 13
	WORD	0FFFFH		; 14
	WORD	00001H		; 15
	WORD	00000H		; 16
;
ENDPLY2	EQU	$
	PHB
	PHK
	PLB			; DBR <= PBR
;
	LDX	#16-1
EDPL220	EQU	$
	LDA	ENTIM0,X
	BEQ	EDPL230		; timer dec ? [ no:EDPL230 ]
;
	DEC	ENTIM0,X
EDPL230	EQU	$
	DEX
	BPL	EDPL220		; timer dec end ? [ no:EDPL220 ]
;
	LDA	<GAMEMD
	AND	#0FEH
	TAX
	STZ	<PLYMVC
	STZ	<PLXMVC
;
	MEM16
	REP	#00100000B	; memory 16bit mode !!
;
	LDA	<CWORK0
	CMP	#00040H
	BCC	EDPL260		; scrool ? [ no:EDPL260 ]
;
;'92.07.02.[THU]	AND	#00007H
;'92.07.02.[THU]	BEQ	EDPL238		; scrool ? [ yes:EDPL238 ]
;'92.07.02.[THU];
;'92.07.02.[THU]	LSR	A
;'92.07.02.[THU]	BCC	EDPL260		; scrool ? [ no:EDPL260 ]
;'92.07.02.[THU];
	AND	#00001H
	BNE	EDPL260		; scrool ? [ no:EDPL260 ]
;
;'92.07.02.[THU]EDPL238	EQU	$
	LDA	<SCCV2
	CMP	SCCVDT,X
	BEQ	EDPL240		; V scrool ? [ no:EDPL240 ]
;
	LDY	SCVADDT,X
	STY	<PLYMVC
EDPL240	EQU	$
	LDA	<SCCH2
	CMP	SCCHDT,X
	BEQ	EDPL260		; H scrool ? [ no:EDPL260 ]
;
	LDY	SCHADDT,X
	STY	<PLXMVC
EDPL260	EQU	$
;
	MEM8
	SEP	#00100000B	; memory 8bit mode !!
;
	PHX
	JSL	>ENDGSCL
;
	PLX
	JSR	(ENDDAT2,X)
;
	JMP	ENDPLYZ
;
;
ENDDAT2	EQU	$
	WORD	ENDEN01		;  1
	WORD	ENDEN12		;  2
	WORD	ENDEN02		;  3
	WORD	ENDEN11		;  4
	WORD	ENDEN03		;  5
	WORD	ENDEN04		;  6
	WORD	ENDEN09		;  7
	WORD	ENDEN13		;  8
	WORD	ENDEN06		;  9
	WORD	ENDEN14		; 10
	WORD	ENDEN07		; 11
	WORD	ENDEN10		; 12
	WORD	ENDEN08		; 13
	WORD	ENDEN05		; 14
	WORD	ENDEN15		; 15
	WORD	ENDEN16		; 16
;
;
;
ENDPLY3	EQU	$
	PHB
	PHK
	PLB			; DBR <= PBR
;
	LDX	#16-1
EDPL320	EQU	$
	LDA	ENTIM0,X
	BEQ	EDPL330		; timer dec ? [ no:EDPL330 ]
;
	DEC	ENTIM0,X
EDPL330	EQU	$
	DEX
	BPL	EDPL320		; timer dec end ? [ no:EDPL320 ]
;
	LDA	<GAMEMD
	AND	#0FEH
	TAX
;
	MEM16
	REP	#00100000B	; memory 16bit mode !!
;
	LDA	<CWORK0
	CMP	#040H
	BCC	EDPL360		; scrool ? [ no:EDPL360 ]
;
;'92.07.02.[THU]	AND	#00007H
;'92.07.02.[THU]	BEQ	EDPL338		; scrool ? [ yes:EDPL338 ]
;'92.07.02.[THU];
;'92.07.02.[THU]	LSR	A
;'92.07.02.[THU]	BCC	EDPL360		; scrool ? [ no:EDPL360 ]
;'92.07.02.[THU];
	AND	#00001H
	BNE	EDPL360		; scrool ? [ no:EDPL360 ]
;
;'92.07.02.[THU]EDPL338	EQU	$
	LDA	<SCCV2
	CMP	SCCVDT,X
	BEQ	EDPL340		; V scrool ? [ no:EDPL340 ]
;
	CLC
	ADC	SCVADDT,X
	STA	<SCCV2
EDPL340	EQU	$
	LDA	<SCCH2
	CMP	SCCHDT,X
	BEQ	EDPL360		; H scrool ? [ no:EDPL360 ]
;
	CLC
	ADC	SCHADDT,X
	STA	<SCCH2
EDPL360	EQU	$
;
	MEM8
	SEP	#00100000B	; memory 8bit mode !!
;
	JSR	(ENDDAT2,X)
;
	JMP	ENDPLYZ
;
;
SCCRLM	EQU	$
	WORD	00300H		; [ 1]		;  1
	WORD	00280H		; [12]		;  2
	WORD	00250H		; [ 2]		;  3
	WORD	002E0H		; [11]		;  4
	WORD	00280H		; [ 3]		;  5
	WORD	00250H		; [ 4]		;  6
	WORD	002C0H		; [ 9]		;  7
	WORD	002C0H		; [13]		;  8
	WORD	00250H		; [ 6]		;  9
	WORD	00250H		; [14]		; 10
	WORD	00280H		; [ 7]		; 11
	WORD	00250H		; [10]		; 12
	WORD	00480H		; [ 8]		; 13
	WORD	00400H		; [ 5]		; 14
	WORD	00250H		; [15]		; 15
	WORD	00500H		; [16]		; 16
;
ENDPLYZ	EQU	$
	LDA	<GAMEMD
	AND	#0FEH
	TAX
;
	MEM16
	REP	#00100000B	; memory 16bit mode !!
;
	LDA	<CWORK0
	CMP	SCCRLM,X
;
	MEM8
	SEP	#00100000B	; memory 8bit mode !!
;
	BCC	ENFIN		; fade out ? [ no:ENFIN ]
;
ENFOT	EQU	$
	LDA	<CWORK0
	AND	#01
	BNE	ENFIN80		; dec ? [ no:ENFIN80 ]
;
	DEC	<BLKFLG
	BNE	ENFIN80		; mode change ? [ no:ENFIN80 ]
;
	INC	<GAMEMD
	BRA	ENFINF0		; [ -> ENFINF0 ]
;
ENFIN	EQU	$
	LDA	<CWORK0
	AND	#01
	BNE	ENFIN80		; inc ? [ no:ENFIN80 ]
;
	LDA	<BLKFLG
	CMP	#0FH
	BEQ	ENFIN80		; inc ? [ no:ENFIN80 ]
;
	INC	<BLKFLG
ENFIN80	EQU	$
;
	MEM16
	REP	#00100000B	; memory 16bit mode !!
;
	INC	<CWORK0
;
	MEM8
	SEP	#00100000B	; memory 8bit mode !!
;
ENFINF0	EQU	$
		MEM16
		REP	#00100000B	; memory 16bit mode
;
		LDA	<SCCH2
		STA	!SSCCH2
		LDA	<SCCV2
		STA	!SSCCV2
;
		LDA	<SCCH1
		STA	!SSCCH1
		LDA	<SCCV1
		STA	!SSCCV1
;
		MEM8
		SEP	#00100000B	; memory 8bit mode
;
	PLB			; DBR reset !!
	RTS
;
;
ENXPS01	EQU	$
	WORD	001E0H,00200H,001EDH,00203H
	WORD	001DAH,00216H,001C8H,00228H
	WORD	001C0H,001E0H,00208H,00228H
;
ENYPS01	EQU	$
	WORD	00158H,00158H,00138H,00138H
	WORD	00140H,00140H,00150H,00150H
	WORD	00120H,00120H,00120H,00120H
;
ENXPS02	EQU	$
	WORD	00278H,00298H,001E0H,00200H
	WORD	00220H,00288H,001E2H
;
ENYPS02	EQU	$
	WORD	000C2H,000C2H,0016BH,0016CH
	WORD	0016BH,000B8H,0016BH
;
ENXPS03	EQU	$
	WORD	00335H,00335H,00300H
;
ENYPS03	EQU	$
	WORD	00128H,00128H,0016FH
;
ENXPS04	EQU	$
	WORD	000B8H,000CEH,000ACH,000C4H
;
ENYPS04	EQU	$
	WORD	000F5H,000FCH,0010DH,0010DH
;
ENXPS05	EQU	$
	WORD	00180H
;
ENYPS05	EQU	$
	WORD	000D8H
;
ENXPS06	EQU	$
	WORD	00080H
;
ENYPS06	EQU	$
	WORD	000F4H
;
ENXPS07	EQU	$
	WORD	00070H,00070H,00070H,00068H,00088H,00070H
;
ENYPS07	EQU	$
	WORD	0003CH,0003CH,0003CH,00090H,00080H,0003CH
;
ENXPS08	EQU	$
	WORD	000C8H,00278H,00258H,001D8H,001C8H,00188H,00270H
;
ENYPS08	EQU	$
	WORD	00250H,002B0H,002B0H,002A0H,002B0H,002B0H,002B8H
;
ENXPS09	EQU	$
	WORD	003B0H,00390H,003D0H
;
ENYPS09	EQU	$
	WORD	00040H,00040H,00040H
;
ENXPS10	EQU	$
	WORD	00040H,00070H,0004FH,00061H,00037H,00079H
;
ENYPS10	EQU	$
	WORD	0016CH,0016CH,00174H,00174H,00175H,00175H
;
ENXPS11	EQU	$
	WORD	000E0H,00150H,000E8H,00168H,00128H,00170H,00170H
;
ENYPS11	EQU	$
	WORD	00080H,00060H,00146H,00146H,001C6H,00070H,00070H
;
ENXPS12	EQU	$
	WORD	000F8H,000F0H
;
ENYPS12	EQU	$
	WORD	00060H,00037H
;
ENXPS13	EQU	$
	WORD	000F8H,000C8H
;
ENYPS13	EQU	$
	WORD	00150H,00158H
;
ENXPS14	EQU	$
	WORD	000F8H,000F8H,000F8H,000F8H
	WORD	000F8H,000E8H,000F8H,000D8H
	WORD	000F8H,000C8H,00108H
;
ENYPS14	EQU	$
	WORD	00120H,00120H,00120H,00120H
	WORD	00120H,00108H,00100H,000D8H
	WORD	000D8H,000F0H,000F0H
;
ENXPS15	EQU	$
	WORD	002E8H,00270H,00270H,002A0H
	WORD	002A0H,002A4H,002FCH
;
ENYPS15	EQU	$
	WORD	0024BH,001B0H,001C8H,001C8H
	WORD	001B0H,00230H,00230H
;
ENXPS16	EQU	$
	WORD	00076H,00073H,00076H,00000H
	WORD	000D0H,00080H
;
ENYPS16	EQU	$
	WORD	0008BH,00083H,00085H,0002CH
	WORD	000F8H,00100H
;
ENXPDT	EQU	$
	WORD	ENXPS01		;  1
	WORD	ENXPS12		;  2
	WORD	ENXPS02		;  3
	WORD	ENXPS11		;  4
	WORD	ENXPS03		;  5
	WORD	ENXPS04		;  6
	WORD	ENXPS09		;  7
	WORD	ENXPS13		;  8
	WORD	ENXPS06		;  9
	WORD	ENXPS14		; 10
	WORD	ENXPS07		; 11
	WORD	ENXPS10		; 12
	WORD	ENXPS08		; 13
	WORD	ENXPS05		; 14
	WORD	ENXPS15		; 15
	WORD	ENXPS16		; 16
;
ENYPDT	EQU	$
	WORD	ENYPS01		;  1
	WORD	ENYPS12		;  2
	WORD	ENYPS02		;  3
	WORD	ENYPS11		;  4
	WORD	ENYPS03		;  5
	WORD	ENYPS04		;  6
	WORD	ENYPS09		;  7
	WORD	ENYPS13		;  8
	WORD	ENYPS06		;  9
	WORD	ENYPS14		; 10
	WORD	ENYPS07		; 11
	WORD	ENYPS10		; 12
	WORD	ENYPS08		; 13
	WORD	ENYPS05		; 14
	WORD	ENYPS15		; 15
	WORD	ENYPS16		; 16
;
ENIDDT	EQU	$
	BYTE	12-1		;  1
	BYTE	02-1		;  2
	BYTE	07-1		;  3
	BYTE	07-1		;  4
	BYTE	03-1		;  5
	BYTE	04-1		;  6
	BYTE	03-1		;  7
	BYTE	02-1		;  8
	BYTE	01-1		;  9
	BYTE	11-1		; 10
	BYTE	06-1		; 11
	BYTE	06-1		; 12
	BYTE	07-1		; 13
	BYTE	01-1		; 14
	BYTE	07-1		; 15
	BYTE	06-1		; 16
;
;- - Zora initial - -
ENINT09	EQU	$
	LDA	#0FFH
	STA	ENTIM0+0
	STA	ENTIM0+1
	STA	ENTIM0+2
	BRA	ENI11F0
;
ENINT02	EQU	$
	LDA	TORYLM+1
	STA	ENYSPD+6
	BRA	ENI11F0
;
ENINT11	EQU	$
	LDA	#16H
	STA	ENWRK0+5
	LDA	TORYLM+1
	STA	ENYSPD
	LDA	TORYLM
	STA	ENYSPD+1
	LDA	#01
	STA	ENCMKI+1
	LDY	#03-1
ENI1120	EQU	$
	LDA	#SEKMV
	STA	ENMYNO+2,Y
	LDA	#00110001B
	STA	ENCLOR+2,Y
;;;;	TYA
;;;;	STA	ENWRK0+2,Y
	DEY
	BPL	ENI1120
ENI11F0	EQU	$
	BRA	EIN14F0
;
ONPINT	EQU	$
	BYTE	13H*0,13H*1,13H*2,13H*3,13H*4
;
ENINT14	EQU	$
	LDY	#05-1
EIN1400	EQU	$
	LDA	!ONPINT,Y
	STA	ENTIM0,Y
	LDA	#00
	STA	ENMODE,Y
	DEY
	BPL	EIN1400
	LDA	#KUTUU
	STA	ENMYNO+5
	LDY	#02-1
EIN1410	EQU	$
	LDA	#USAGI
	STA	ENMYNO+7,Y
	LDA	#OOOMU
	STA	ENMYNO+9,Y
	LDA	#01H
	STA	ENMOD0+7,Y
	INC	A
	STA	ENMOD0+9,Y
	LDA	#010H
	STA	ENMOD2+7,Y
	STA	ENMOD2+9,Y
	DEY
	BPL	EIN1410
EIN14F0	EQU	$
	BRA	ENINT01
;
ENINT15	EQU	$
	LDA	TORYLM+1
	STA	ENYSPD+5
	LDA	TORYLM
	STA	ENYSPD+6
	LDA	#01
	STA	ENCMKI+6
	LDA	#08
	STA	ENWRK0
	LDY	#04-1
EIN1510	EQU	$
	LDA	#04H
	STA	ENYSPD+1,Y
	DEY
	BPL	EIN1510
	BRA	ENINT01
;
ENINT16	EQU	$
	LDA	#02
	STA	ENWRK2+4
	LDA	#08
	STA	ENYSPD+5
	LDA	#013H
	STA	ENTIM0+1
	LDA	#040H
	STA	ENTIM0+4
	BRA	ENINT01
;
ENINT13	EQU	$
	LDA	#0FFH
	STA	ENTIM0+1
	BRA	ENINT01
;
ENINT08	EQU	$
	LDY	#01
ENI0810	EQU	$
	LDA	#39H
	STA	ENCLOR+3,Y
	LDA	#NIWAT
	STA	ENMYNO+3,Y
	LDA	#010H
	STA	ENMOD2+3,Y
	LDA	#01
	STA	ENMOD0+3,Y
	DEY
	BPL	ENI0810
	LDA	#BABAA
	STA	ENMYNO+5
	LDA	#HACHI
	STA	ENMYNO+6
	LDA	#01
	STA	ENSTAT+6
	LDA	#5
	STA	ENZPSL+6
;
ENINT01	EQU	$
ENINT03	EQU	$
ENINT04	EQU	$
ENINT05	EQU	$
ENINT06	EQU	$
	LDA	ENXPDT,X
	STA	<WORK4
	LDA	ENXPDT+1,X
	STA	<WORK5
	LDA	ENYPDT,X
	STA	<WORK6
	LDA	ENYPDT+1,X
	STA	<WORK7
;
	TXA
	LSR	A
	TAX
	LDA	ENIDDT,X
	TAX
;;;	LDX	#12-1
;;;	LDY	#(12-1)*2
ENIT010	EQU	$
	TXA
	ASL	A
	TAY
;- - Ground initial - -
	MEM16
	REP	#00100000B	; memory 16bit mode !!
;
                LDA     #0FFFFH
                STA     GRRMLY          ; For ground displ
                STA     GRRMLX
;
	LDA	!GRNDNO
	ASL	A
	XBA
	AND	#00F00H
	CLC
	ADC	(<WORK4),Y
;;;	ADC	ENXPS1,Y
	STA	<WORK0
;
	LDA	!GRNDNO
	LSR	A
	LSR	A
	XBA
	AND	#00E00H
	CLC
	ADC	(<WORK6),Y
;;;	ADC	ENYPS1,Y
	STA	<WORK2
;
	MEM8
	SEP	#00100000B	; memory 8bit mode !!
;
	LDA	<WORK0
	STA	ENXPSL,X
	LDA	<WORK1
	STA	ENXPSH,X
	LDA	<WORK2
	STA	ENYPSL,X
	LDA	<WORK3
	STA	ENYPSH,X
	DEX
	BPL	ENIT010		; loop end ? [ no:ENIT010 ]
;
	RTS
;
;
ENINT07	EQU	$
	LDA	#10H
	STA	ENTIM0+1
	LDA	#20H
	STA	ENTIM0+2
	LDA	#08H
	STA	ENCLOR+3
	STA	ENCLOR+4
	BRA	ENINT12
;
ENINT10	EQU	$
	LDA	#01111001B
	STA	ENCLOR+4
	LDA	#00111001B
	STA	ENCLOR+5
	LDA	#01
	STA	ENMUKI+1
	LDA	#04
	STA	ENWRK0+1
ENINT12	EQU	$
;- - Dnjyon initial - -
	MEM16
	REP	#00100000B	; memory 16bit mode !!
;
        LDA	ERXYCT
	LSR	A
	LSR	A
	LSR	A
;
	MEM8
	SEP	#00100000B	; memory 8bit mode !!
;
	AND	#11111110B
	STA	NOWRMY		; (Y)H
        LDA	ERXYCT
	AND	#00001111B
	ASL	A
	STA	NOWRMX		; (X)H
;
	LDA	ENXPDT,X
	STA	<WORK4
	LDA	ENXPDT+1,X
	STA	<WORK5
	LDA	ENYPDT,X
	STA	<WORK6
	LDA	ENYPDT+1,X
	STA	<WORK7
;
	TXA
	LSR	A
	TAX
	LDA	ENIDDT,X
	TAX
ENIT710	EQU	$
	TXA
	ASL	A
	TAY
;
	LDA	NOWRMY
	XBA
	LDA	#00
;
	MEM16
	REP	#00100000B	; memory 16bit mode !!
;
	CLC
	ADC	(<WORK6),Y
	STA	<WORK2
;
	MEM8
	SEP	#00100000B	; memory 8bit mode !!
;
	LDA	NOWRMX
	XBA
	LDA	#00
;
	MEM16
	REP	#00100000B	; memory 16bit mode !!
;
	CLC
	ADC	(<WORK4),Y
	STA	<WORK0
;
	MEM8
	SEP	#00100000B	; memory 8bit mode !!
;
	LDA	<WORK0
	STA	ENXPSL,X
	LDA	<WORK1
	STA	ENXPSH,X
	LDA	<WORK2
	STA	ENYPSL,X
	LDA	<WORK3
	STA	ENYPSH,X
	DEX
	BPL	ENIT710		; loop end ? [ no:ENIT710 ]
;
	RTS
;
;
OHSANCD	EQU	$
	WORD	0FFFDH,00011H
	HEX	2B,00,00,00		; thue
	WORD	0FFFDH,00019H
	HEX	3B,00,00,00		;   "
	WORD	00000H,00000H
	HEX	0E,00,00,02		; king
	WORD	00010H,00000H
	HEX	0E,40,00,02		;  "
	WORD	00000H,00010H
	HEX	2E,00,00,02		;  "
	WORD	00010H,00010H
	HEX	2E,40,00,02		;  "
;
ZELDACD	EQU	$
	WORD	00008H,00005H
	HEX	04,0A,00,02		; zelda
	WORD	00000H,00010H
	HEX	06,08,00,02		;   "
	WORD	00010H,00010H
	HEX	06,48,00,02		;   "
;
GIRL0CD	EQU	$
	WORD	00000H,00000H
	HEX	00,00,00,02		; girl
	WORD	00000H,0000BH
	HEX	02,00,00,02		;  "
;
HEISICD	EQU	$
	WORD	00001H,00004H
	HEX	2A,00,00,00		; yari
	WORD	00001H,0000CH
	HEX	3A,00,00,00		;   "
	WORD	00004H,00000H
	HEX	26,00,00,02		; heishi
	WORD	00000H,00009H
	HEX	24,00,00,02		;   "
	WORD	00008H,00009H
	HEX	24,40,00,02		;   "
	WORD	00004H,00014H
	HEX	6C,01,00,02		; kage
;
ENYAD01	EQU	$
	HEX	1E,20,22,22,22,22,22,22,16,16,16,16
;
ENKOS01	EQU	$
	BYTE	06,03,02,02,02,02,02,02
	BYTE	06,06,06,06
;
ENCOL01	EQU	$
	BYTE	00111011B,00110001B,00111101B,00111111B
	BYTE	00111001B,00111011B,00110111B,00111101B
	BYTE	00111001B,00110111B,00110111B,00111001B
;
ENDEN01	EQU	$
	PHX
	LDX	#12-1
EDEN110	EQU	$
	LDA	ENCOL01,X
	STA	ENCLOR,X	; color set !!
	LDA	ENKOS01,X
	LDY	ENYAD01,X
	JSR	ENGCST
;
	DEX
	CPX	#12-4-1
	BNE	EDEN110		; loop end ? [ no:EDEN110 ]
;
EDEN140	EQU	$
	LDA	<FRCNT
	ASL	A
	ASL	A
	AND	#40H
	ORA	ENCOL01,X
	STA	ENCLOR,X	; color set !!
	LDA	ENKOS01,X
	LDY	ENYAD01,X
	JSR	ENGCST
;
	DEX
	CPX	#12-4-6-1
	BNE	EDEN140		; loop end ? [ no:EDEN140 ]
;
EDEN180	EQU	$
	LDA	ENCOL01,X
	STA	ENCLOR,X	; color set !!
	LDA	ENKOS01,X
	LDY	ENYAD01,X
	JSR	ENGCST
;
	DEX
	BPL	EDEN180		; loop end ? [ no:EDEN180 ]
;
	PLX
	RTS
;
IJMRUCD	EQU	$
	WORD	00000H,0FFF6H
	HEX	4C,08,00,02		; ijimerukun
	WORD	00000H,00000H
	HEX	6C,0A,00,02		;     "
;
	WORD	00000H,0FFF7H
	HEX	4C,08,00,02		; ijimerukun
	WORD	00000H,00000H
	HEX	A8,0A,00,02		;     "
;
IJMTECD	EQU	$
	WORD	00000H,0FFF9H
	HEX	4A,08,00,02		; ijimetekun
	WORD	00000H,00000H
	HEX	6A,0C,00,02		;     "
;
	WORD	00000H,0FFF9H
	HEX	4A,08,00,02		; ijimetekun
	WORD	00000H,00000H
	HEX	A6,0C,00,02		;     "
;
WARP0CD	EQU	$
	WORD	00000H,00000H
	HEX	86,00,00,02		; warp zoon
;
ENYAD03	EQU	$
	HEX	30,32
;
ENKOS03	EQU	$
	BYTE	02,02
;
CMPDAT	EQU	$
	WORD	00020H,00000H
;
XSPDT03	EQU	$
	HEX	00,F4
YSPDT03	EQU	$
	HEX	F0,F4,00,0C,10,0C,00,F4
;
TIMDT	EQU	$
	HEX	3B,14,1E,1D,2C,2B,42,20
	HEX	27,28,2E,38,3A,4C,32,44
	HEX	2E,2F,1E,28,47,35,32,30
;
ENDEN03	EQU	$
	PHX
	LDX	#03-1
	LDA	#00110101B
	STA	ENCLOR,X
	LDA	#01
	LDY	#3CH
	JSR	ENGCST
;
	DEX
EDEN310	EQU	$
	LDA	ENXSPD,X
	DEC	A
	LSR	A
	AND	#40H
	EOR	#01110001B
	STA	ENCLOR,X
	LDA	<FRCNT
;;;;	LSR	A
	LSR	A
	LSR	A
	LSR	A
	AND	#01
	STA	ENCHPT,X
;
	TXA
	ASL	A
	TAY
;
	MEM16
	REP	#00100000B	; memory 16bit mode !!
;
	LDA	<CWORK0
	CMP	CMPDAT,Y
;
	MEM8
	SEP	#00100000B	; memory 8bit mode !!
;
	BCC	EDEN360		; move ? [ no:EDEN360 ]
;
	LDA	ENTIM0,X
	BNE	EDEN360		; speed cheng ? [ no:EDEN360 ]
;
	LDY	ENWRK0,X
	LDA	TIMDT,Y
	PHA
	AND	#0F8H
	STA	ENTIM0,X
	PLA
	AND	#07H
	TAY
	LDA	YSPDT03,Y
	STA	ENYSPD,X
	LDA	XSPDT03,Y
	STA	ENXSPD,X
	INC	ENWRK0,X
EDEN360	EQU	$
	LDA	ENKOS03,X
	LDY	ENYAD03,X
	JSR	ENGCST
;
	JSR	SHADOW		; shadow set !!
;
	JSL	>ENMVCLL
;
	DEX
	BPL	EDEN310		; loop end ? [ no:EDEN110 ]
;
	PLX
	RTS
;
;
SAHASCD	EQU	$
	WORD	0FFFCH,0000AH-9
	HEX	68,0C,00,00		; sahaslala
	WORD	00000H,00001H-9
	HEX	40,0C,00,02		;     "
	WORD	00000H,0000AH-9
	HEX	42,0C,00,02		;     "
;
	WORD	0FFFCH,0000AH-9
	HEX	78,0C,00,00		;     "
	WORD	00000H,00001H-9
	HEX	40,0C,00,02		;     "
	WORD	00000H,0000AH-9
	HEX	42,0C,00,02		;     "
;
OBABACD	EQU	$
	WORD	00008H,0000FH-0AH
	HEX	79,06,00,00		; okamisan
	WORD	00000H,00000H-0AH
	HEX	8E,08,00,02		;    "
	WORD	00000H,0000AH-0AH
	HEX	6E,06,00,02		;    "
;
	WORD	00000H,00000H-0AH
	HEX	8E,08,00,02		;    "
	WORD	00000H,00000H-0AH
	HEX	8E,08,00,02		;    "
	WORD	00000H,0000AH-0AH
	HEX	6E,06,00,02		;    "
;
KODOMCD	EQU	$
	WORD	00000H,00000H
	HEX	82,08,00,02		; gaki
	WORD	00000H,00007H
	HEX	4E,0A,00,02		;  "
;
	WORD	00000H,00000H
	HEX	80,48,00,02		; gaki
	WORD	00000H,00007H
	HEX	4E,0A,00,02		;  "
;
	WORD	00000H,00000H
	HEX	82,08,00,02		; gaki
	WORD	00000H,00007H
	HEX	4E,0A,00,02		;  "
;
	WORD	00000H,00000H
	HEX	80,08,00,02		; gaki
	WORD	00000H,00007H
	HEX	4E,0A,00,02		;  "
;
FUTAGCD	EQU	$
	WORD	0000BH,00009H-0CH
	HEX	69,08,00,00		; futago
	WORD	00000H,00000H-0CH
	HEX	04,08,00,02		;   "
	WORD	00000H,0000CH-0CH
	HEX	60,08,00,02		;   "
;
	WORD	0000AH,00009H-0CH
	HEX	67,08,00,00		;   "
	WORD	00000H,00000H-0CH
	HEX	04,08,00,02		;   "
	WORD	00000H,0000CH-0CH
	HEX	60,08,00,02		;   "
;
ANESNCD	EQU	$
	WORD	0FFFEH,0000DH-0CH
	HEX	68,08,00,00		; oneesan
	WORD	00000H,00004H-0CH
	HEX	C0,08,00,02		;    "
	WORD	00000H,0000CH-0CH
	HEX	C2,08,00,02		;    "
;
	WORD	0FFFDH,0000DH-0CH
	HEX	78,08,00,00		;    "
	WORD	00000H,00004H-0CH
	HEX	C0,08,00,02		;    "
	WORD	00000H,0000CH-0CH
	HEX	C2,08,00,02		;    "
;
TORI0CD	EQU	$
	WORD	00000H,00000H
	HEX	0E,00,00,02		; tori
	WORD	00000H,00040H
	HEX	6C,00,00,02		; kage
;
KODOMTM	EQU	$
	HEX	30,10
;
ENYAD02	EQU	$
	HEX	28,2A,2C,2E,2C
;
ENKOS02	EQU	$
	BYTE	03,03,03,03,03,02,02
;
TORIID	EQU	$
	HEX	20,40
;
TORIMK	EQU	$
	HEX	10,F0
;
ENDEN02	EQU	$
	PHX
	LDX	#7-1
	LDA	>FRCNT
	LSR	A
	LSR	A
	AND	#1
	TAY
;
	LDA	TORIID,Y
	STA	!TORICFG
	LDA	ENXSPD,X
	ROL	A
	ROL	A
	AND	#01
	TAY
	LDA	ENXSPD,X
	CLC
	ADC	TORIMK,Y
	LSR	A
	AND	#40H
	ORA	#00110010B
	STA	ENCLOR,X
;
	LDA	#02
	LDY	#24H
	JSR	ENGCST
;
	JSR	TORISAN
;
	DEX
EDEN210	EQU	$
	LDA	#00110001B
	STA	ENCLOR,X
	LDA	ENTIM0,X
	BNE	EDEN220		; timer set ? [ no:EDEN220 ]
;
	LDA	ENWRK0,X
	TAY
	EOR	#01H
	STA	ENWRK0,X
	LDA	KODOMTM,Y
	STA	ENTIM0,X
	LDA	ENCHPT,X
	INC	A
	AND	#03H
	STA	ENCHPT,X
EDEN220	EQU	$
	LDY	#26H
	LDA	#02
	JSR	ENGCST	
;
	DEX
;
EDEN230	EQU	$
	LDA	<FRCNT
	AND	#0FH
	BNE	EDEN240		; paturn change ? [ no:EDEN240 ]
;
	LDA	ENCHPT,X
	EOR	#01
	STA	ENCHPT,X
EDEN240	EQU	$
	LDA	#00110001B
	STA	ENCLOR,X
	LDY	ENYAD02,X
	LDA	ENKOS02,X
	JSR	ENGCST	
;
	JSR	SHADOW		; shadow set !!
;
	DEX
	BPL	EDEN230		; loop end ? [ no:EDEN230 ]
;
	PLX
	RTS
;
OJSANCD	EQU	$
	WORD	0000AH,00008H
	HEX	32,8A,00,00		; ken
	WORD	0000AH,00010H
	HEX	22,8A,00,00		;  "
	WORD	00000H,00000H-0AH
	HEX	00,08,00,02		; ottyan
	WORD	00000H,0000AH-0AH
	HEX	2C,08,00,02		;   "
;
	WORD	0000AH,0FFFCH-0AH
	HEX	22,0A,00,00		; ken
	WORD	0000AH,00004H-0AH
	HEX	32,0A,00,00		;  "
	WORD	00000H,00000H-0AH
	HEX	2A,08,00,02		; ottyan
	WORD	00000H,0000AH-0AH
	HEX	28,08,00,02		;   "
;
LINK0CD	EQU	$
	WORD	0000AH,00010H
	HEX	05,8A,00,00		; ken
	WORD	0000AH,00008H
	HEX	15,8A,00,00		;  "
	WORD	0FFFCH,00001H+1
	HEX	07,0A,00,02		; tate
	WORD	00000H,0FFF8H+1
	HEX	00,0E,00,02		; link
	WORD	00000H,00000H+1
	HEX	02,0E,00,02
;
	WORD	0000AH,0FFF3H-8+1
	HEX	05,0A,00,00		; ken
	WORD	0000AH,0FFFBH-8+1
	HEX	15,0A,00,00		;  "
	WORD	0FFF9H,00000H+1
	HEX	07,4A,00,02		; tate
	WORD	00000H,0FFF8H+1
	HEX	00,0E,00,02		; link
	WORD	00000H,00000H+1
	HEX	02,0E,00,02
;
LINK1CD	EQU	$
	WORD	00000H,0FFF8H+1
	HEX	00,0E,00,02		; link
	WORD	00000H,00000H+1
	HEX	02,4E,00,02
;
	WORD	00000H,0FFF7H+1
	HEX	00,0E,00,02		; link
	WORD	00000H,00000H+1
	HEX	02,0E,00,02
;
	WORD	00000H,0FFF6H+1
	HEX	00,0E,00,02		; link
	WORD	00000H,00000H+1
	HEX	02,0E,00,02
;
	WORD	00000H,0FFF8H+1
	HEX	00,0E,00,02		; link
	WORD	00000H,00000H+1
	HEX	02,0E,00,02
;
	WORD	00000H,0FFF8H+1
	HEX	00,0E,00,02		; link
	WORD	00000H,00000H+1
	HEX	02,4E,00,02
;
	WORD	00000H,0FFF7H+1
	HEX	00,0E,00,02		; link
	WORD	00000H,00000H+1
	HEX	02,4E,00,02
;
	WORD	00000H,0FFF6H+1
	HEX	00,0E,00,02		; link
	WORD	00000H,00000H+1
	HEX	02,4E,00,02
;
	WORD	00000H,0FFF8H+1
	HEX	00,0E,00,02		; link
	WORD	00000H,00000H+1
	HEX	02,4E,00,02
;
TATEPT	EQU	$
	HEX	00,04
;
PLAYPT	EQU	$
	WORD	00005H*2,00112H*2
;
PLIDYDT	EQU	$
	HEX	0A,0E
;
ENDEN04	EQU	$
	PHX
;------ sound set -----------
	MEM16
	REP	#00100000B	; memory 16bit mode !!
;
	LDA	<CWORK0
	CMP	#200H
	BNE	EDEN480		; syu ? [ no:EDEN480 ]
;
	LDY	#01		; syu !!
	BRA	EDEN488
;
EDEN480	EQU	$
	CMP	#208H
	BNE	EDEN490		; kakin ? [ no:EDEN490 ]
;
	LDY	#2CH		; kakin !!
EDEN488	EQU	$
	STY	SOUND2
;
EDEN490	EQU	$
;------ kirarin -----------
	SEC
	SBC	#208H
	CMP	#0030H
;
	MEM8
	SEP	#00100000B	; memory 8bit mode !!
;
	BCS	EDEN4A0		; kirarin ? [ no:EDEN4A0 ]
;
	LDY	#02
	JSR	KIRARIN		;kirarin move
;
EDEN4A0	EQU	$
	LDX	#04-1
EDEN410	EQU	$
;------ o'san oam 
	MEM16
	REP	#00100000B	; memory 16bit mode !!
;
	LDA	<CWORK0
	CMP	#200H
;
	MEM8
	SEP	#00100000B	; memory 8bit mode !!
;
	BCC	EDEN450		; ken pose ? [ no:EDEN450 ]
;
	LDA	#01
	STA	ENCHPT,X
EDEN450	EQU	$
	LDA	#00110001B
	STA	ENCLOR,X
	LDA	#04
	LDY	#08
	JSR	ENGCST
;
	JSR	SHADOW		; shadow set !!
;
;------ link oam
	LDA	ENCHPT,X
	DEX
	STA	ENCHPT,X
	TAY
	STZ	!KENCPT
	LDA	TATEPT,Y
	STA	!TATCPT
	LDA	#00110000B
	STA	ENCLOR,X
	PHY
	TYA
	ASL	A
	TAY
;
	MEM16
	REP	#00100000B	; memory 16bit mode !!
;
	LDA	PLAYPT,Y
	STA	!PCHPT0
;
	MEM8
	SEP	#00100000B	; memory 8bit mode !!
;
	PLY
	LDA	PLIDYDT,Y
	TAY
	LDA	#05
	JSR	ENGCST
;
	JSR	SHADOW		; shadow set !!
;
	PLX
	RTS
;
GSAMACD	EQU	$		;(5) G-sama
	WORD	0FFEEH,0FFE8H
	HEX	A4,39,00,02
	WORD	0FFF0H,0FFF0H
	HEX	A8,39,00,02
	WORD	0FFEEH,0FFE8H
	HEX	A4,39,00,02
;
	WORD	0FFEEH,0FFE8H
	HEX	A4,39,00,02
	WORD	0FFF0H,0FFF0H
	HEX	A6,39,00,02
	WORD	0FFEEH,0FFE8H
	HEX	A4,39,00,02
;
	WORD	0FFFAH,0FFEFH
	HEX	2D,39,00,00
	WORD	0FFF0H,0FFE8H
	HEX	A0,39,00,02
	WORD	0FFF0H,0FFF0H
	HEX	AA,39,00,02
;
	WORD	0FFFBH,0FFEFH
	HEX	2C,39,00,00
	WORD	0FFF0H,0FFE8H
	HEX	A0,39,00,02
	WORD	0FFF0H,0FFF0H
	HEX	AA,39,00,02
;
ENDEN05	EQU	$
	PHX
	LDX	#1-1
EDEN510	EQU	$
	MEM16
	REP	#00100000B	; memory 16bit mode !!
;
	LDA	<CWORK0
	CMP	#00200H
;
	MEM8
	SEP	#00100000B	; memory 8bit mode !!
;
	BNE	EDEN530		; x speed set ? [ no:EDEN530 ]
;
	LDA	#0FCH
	STA	ENXSPD,X
EDEN530	EQU	$
	LDA	<FRCNT
	AND	#10H
	LSR	A
	LSR	A
	LSR	A
	LSR	A
	STA	ENCHPT,X
	LDA	ENXPSL,X
	CMP	#38H
	BNE	EDEN540		; stop ? [ no:EDEN540 ]
;
	STZ	ENXSPD,X
	INC	ENCHPT,X
	INC	ENCHPT,X
EDEN540	EQU	$
	LDA	#03
	LDY	#34H
	JSR	ENGCST
;
	JSL	>ENMVCLL
;
	PLX
	RTS
;
ENDEN06	EQU	$
	PHX
	LDX	#00
	LDA	#NOKOG
	STA	ENMYNO,X
	LDA	#0BH*4
	JSL	>OAMENT1
	LDA	#3BH
	STA	ENCLOR,X
	JSL	>PSSAVE2
;
;;	LDA	<GAMEMD
;;	PHA
;;	STZ	<GAMEMD
;;	LDA	#EMOVE
;;	STA	ENMODE,X
;
	LDA	#02H
	IDX16
	REP	#00010000B	; memory 16bit mode !!
;
	LDY	<CWORK0
	CPY	#001C0H
;
	IDX8
	SEP	#00010000B	; memory 8bit mode !!
;
	BCS	END610
;
	TYA
	AND	#00100000B
	ASL	A
	ASL	A
	ASL	A
	ROL	A
END610	EQU	$
	STA	ENCHPT,X
;
	JSL	>ENMOVE2
;;	PLA
;;	STA	<GAMEMD
;
	PLX
	RTS
;
ENDEN07	EQU	$
	PHX
	ldx	#05h	
	JSL	>PSSAVE2
;------ "kirarin" --------------------------
	LDA	ENDSPL,X
	BNE	BWA00		; Display in ?
;				; yes !
	JSL	>RNDSET
	AND	#00000111B
	TAX
	LDA	>BSSTXD,X
	CLC
	ADC	ENXP2L
	PHA
	JSL	>RNDSET
	AND	#00000111B
	TAX
	LDA	>BSSTYD,X
	CLC
	ADC	ENYP2L		;(A) <-- Y pos
	PLX			;(X) <-- X  "
	LDY	#03		;(Y) <-- loop no
	JSR	KIRARIN		;kirarin move
;
BWA00	EQU	$
	LDX	#03
YOSE00	EQU	$
	LDA	ENTIM1,X
	BEQ	YOSE10		; dec ? [ no:YOSE10 ]
;
	DEC	ENTIM1,X
YOSE10	EQU	$
	LDA	#YOSEI
	STA	ENMYNO,X
	LDA	#01
	JSR	ENMDST
;
	JSR	ENGEMV2
;
	INX
	CPX	#05
	BNE	YOSE00
;
	LDA	#BWAKO
	STA	ENMYNO,X
	LDA	#3BH
	STA	ENCLOR,X
	LDA	#EMOVE
	STA	ENMODE,X
	STA	ENWRK1,X
;
	LDA	#0CH*4
	JSR	ENGECS
;
	PLX
	RTS
;
;
BOUSICD	EQU	$		;(8) BOUSI
	WORD	0FFF0H+10H,0FFE8H+10H		
	HEX	2A,07,00,02
	WORD	0FFF0H+10H,0FFE8H+10H
	HEX	2A,07,00,02
	WORD	0FFF0H+10H,0FFF0H+10H
	HEX	CA,4F,00,02
;
	WORD	0FFF0H+10H,0FFE8H+10H
	HEX	2A,07,00,02
	WORD	0FFF0H+10H,0FFE8H+10H
	HEX	2A,07,00,02
	WORD	0FFF0H+10H,0FFF0H+10H
	HEX	CA,0F,00,02
;
	WORD	0FFEEH+10H,0FFF0H+10H
	HEX	77,0F,00,00
	WORD	0FFF0H+10H,0FFE8H+10H
	HEX	2A,07,00,02
	WORD	0FFF0H+10H,0FFF0H+10H
	HEX	CA,4F,00,02
;
	WORD	0FFEDH+10H,0FFF0H+10H
	HEX	66,0F,00,00
	WORD	0FFF0H+10H,0FFE8H+10H
	HEX	2A,07,00,02
	WORD	0FFF0H+10H,0FFF0H+10H
	HEX	CA,4F,00,02
;
MUSITCD	EQU	$		;(8) MUSITORI BOY
	WORD	0FFFEH+10H,0FFE9H+10H
	HEX	48,0D,00,02
	WORD	0FFF0H+10H,0FFEAH+10H
	HEX	44,09,00,02
	WORD	0FFF0H+10H,0FFF0H+10H
	HEX	4E,09,00,02
;
	WORD	0FFFDH+10H,0FFDCH+16H
	HEX	48,0D,00,02
	WORD	0FFF0H+10H,0FFE2H+16H
	HEX	44,09,00,02
	WORD	0FFF0H+10H,0FFEAH+16H
	HEX	46,09,00,02
;
ONOJSCD	EQU	$		;(8) O-NEESAN & O-JISAN
	WORD	0FFAEH+50H,0FFF0H
	HEX	78,3D,00,00
	WORD	0FFB0H+50H,0FFE8H
	HEX	24,3D,00,02
	WORD	0FFB0H+50H,0FFF0H
	HEX	C2,3D,00,02
	WORD	0FFEDH+50H,0FFF0H
	HEX	77,37,00,00
	WORD	0FFF0H+50H,0FFE8H
	HEX	C4,37,00,02
	WORD	0FFF0H+50H,0FFF0H
	HEX	CA,77,00,02
	WORD	0FFB0H+50H,0FFF0H+0AH
	HEX	6C,32,00,02
	WORD	0FFF0H+50H,0FFF0H+0AH
	HEX	6C,32,00,02
;
	WORD	0FFAEH+50H,0FFF0H
	HEX	68,3D,00,00
	WORD	0FFB0H+50H,0FFE8H
	HEX	24,3D,00,02
	WORD	0FFB0H+50H,0FFF0H
	HEX	C2,3D,00,02
	WORD	0FFEDH+50H,0FFF0H
	HEX	66,37,00,00
	WORD	0FFF0H+50H,0FFE8H
	HEX	C4,37,00,02
	WORD	0FFF0H+50H,0FFF0H
	HEX	CA,77,00,02
	WORD	0FFB0H+50H,0FFF0H+0AH
	HEX	6C,32,00,02
	WORD	0FFF0H+50H,0FFF0H+0AH
	HEX	6C,32,00,02
;
MSONOJ	EQU	$		;number of OAM data
	HEX	03,03,08
MUSTZP	EQU	$
	HEX	02,04,05,06,06,07,07,07,07,06,06,05,04,02,00
;
ENDEN08	EQU	$
	PHX
;
;------ hatchi move ------------------------------		
	LDX	#06
	LDA	<FRCNT
	AND	#01H
	STA	ENCHPT,X
	BNE	EDEN880	
	LDA	#01
	LDY	!ENXPSL,X
	CPY	#080H
	BMI	EDEN800
	LDA	#0FFH
EDEN800	EQU	$
	CLC
	ADC	ENXSPD,X
	STA	ENXSPD,X
	LDA	#01
	LDY	ENYPSL,X
	CPY	#0B0H
	BMI	EDEN870
	LDA	#0FFH
EDEN870	EQU	$
	CLC
	ADC	ENYSPD,X
	STA	ENYSPD,X
	JSL	>ENMVCLL
EDEN880	EQU	$
	LDA	ENXSPD,X
	LSR	A
	AND	#040H
	EOR	#01111110B
	STA	ENCLOR,X
	LDA	#01
	STA	ENMOD0,X
	LDA	#30H
	STA	ENMOD2,X
	LDA	#10H
	STA	ENZPSL,X
	JSR	ENGECS2		;OAM set
;
;------ re re re no obasan move -----------------
	DEX			;[ LDX #05 ]
	LDA	#00110111B	;color set
	STA	ENCLOR,X
	LDA	#02
	JSR	ENMDST
	LDA	#03*4		;(A) <-- number of OAM
	JSR	ENGEMV		;game move
;
;------ niwatori move ---------------------------
	DEX			;[ LDX #04 ]
	JSR	ENGEMV2
	DEX			;[ LDX #03 ]
	JSR	ENGEMV2
;
	DEX			;[ LDX #02 ]
EDEN810	EQU	$
;------ OAM set ---------------------------------
	TXA			;(Y) <-- OBJ data address data index
	ASL	A
	TAY
	LDA	!MSONOJ,X	;(A) <-- number of OAM
	JSR	ENGCST		;OAM set
	TXA
	BNE	EDEN820		;okawari boy ? ( no:EDEN820 )
;------ bousi boy move --------------------------
	JSR	WALKMV		;walk move
	BRA	EDEN860
;
EDEN820	EQU	$
	LSR	A
	BEQ	EDEN830		;musitori boy ? ( yes:EDEN830 )
;------ o-neesan & o-jisan move -----------------
	LDA	<FRCNT
	LSR	A
	LSR	A
	LSR	A
	AND	#01
	STA	!ENCHPT,X
	BRA	EDEN860
;
;------ musitori boy move -----------------------
EDEN830	EQU	$
	LDY	#00
	LDA	<FRCNT
	AND	#1FH
	CMP	#0FH
	BCS	EDEN840		;wait ? ( yes:EDEN840 )
;
	TAY
	LDA	!MUSTZP,Y	;Z pos set
	STA	ENZPSL,X
	LDY	#01
EDEN840	EQU	$
	TYA
	STA	ENCHPT,X
	JSR	SHADOW2
;
EDEN860	EQU	$
	DEX
	BPL	EDEN810
;
	PLX
	RTS
;
SHADOW2	EQU	$
	LDA	#00110000B	;pri. set
SHADOW3	EQU	$
	STA	ENCLOR,X
SHADOW	EQU	$
	LDA	#00
	JSR	ENMDST
	LDA	#01*04
	JSL	>OAMENT1
	JSL	>SADWSTL	;shadow set
;
	RTS
;
;--------------------------------------------------------
;-	walk move					-
;--------------------------------------------------------
MUSBYT	EQU	$-1
	BYTE	10,10,10,10,20,08,08,0
	HEX	FF,0C,0C,0C,0C,0C,0C,1E,08,04,04,04,00,0
	HEX	FF,FF,90,04,0
MUSBYP	EQU	$-1
	HEX	00,01,00,01,00,02,03,0
	HEX	02,00,01,00,01,00,01,02,03,04,05,06,03,0
	HEX	FF,FF,FF,02,03
;
WALKMV	EQU	$
	LDA	#00110000B	;(A) <-- pri.
WALKMV2	EQU	$
	JSR	SHADOW3		;shadow set
	LDY	ENWRK0,X
	LDA	ENTIM0,X
	BNE	EDEN814		;pattern change ? ( no:EDEN814 )
	INY
	CPY	#08
	BNE	EDEN811
	LDY	#06
EDEN811	EQU	$
	CPY	#16H
	BNE	EDEN812
	LDY	#15H
EDEN812	EQU	$
	CPY	#1CH
	BNE	EDEN813
	LDY	#1BH
EDEN813	EQU	$
	TYA
	STA	ENWRK0,X
	LDA	!MUSBYT,Y
	STA	ENTIM0,X
EDEN814	EQU	$
	LDA	!MUSBYP,Y	;pattern no. set
	BPL	EDEN8XX		;henna ojisan ? 
	LDA	<FRCNT
	AND	#08H
	LSR	A
	LSR	A
	LSR	A
EDEN8XX	EQU	$
	STA	ENCHPT,X
	CPY	#05
	BCC	EDEN815
	CPY	#0AH
	BCC	EDEN816
	CPY	#0FH
	BCS	EDEN816
EDEN815	EQU	$
	LDA	<FRCNT		;walk move
	AND	#01H
	BNE	EDEN816
	INC	ENYPSL,X
EDEN816	EQU	$
	RTS
;
;--------------------------------------------------------
;-							-
;--------------------------------------------------------
ENGEMV2	EQU	$
	LDA	#02*4		;(A) <-- number of OAM
ENGEMV	EQU	$
	STX	!ENINDX
	JSL	>OAMENT1
	JSL	>PSSAVE2
;
	LDA	<GAMEMD
	PHA
	STZ	<GAMEMD
	LDA	#EMOVE		;move "ON" !!
	STA	!ENMODE,X
	JSL	>ENMOVE2	;move
	PLA
	STA	<GAMEMD
	RTS
;
;--------------------------------------------------------
;-							-
;--------------------------------------------------------
ENGECS2	EQU	$
	LDA	#02*4		;(A) <-- number of OAM
ENGECS	EQU	$
	JSL	>OAMENT1
ENGECSP	EQU	$
	STX	!ENINDX
	JSL	>PSSAVE2
	JSL	>ENMOVE2	;OAM set
	RTS
;
;----------------------------------------------------------
;-	OAM set sub					  -
;-		in  : (A) <-- number of OAM	 	  -
;-		      (Y) <-- OBJ data address data index -
;----------------------------------------------------------
OBJADR	EQU	$
	WORD	BOUSICD		;[00] (8) bousi boy
	WORD	MUSITCD		;[02] (8) musito boy
	WORD	ONOJSCD		;[04] (8) o-neesan & o-jisan
	WORD	KAJIYCD		;[06] (10) kajiya 
	WORD	OJSANCD		;[08] (4) link o'san
	WORD	LINK0CD		;[0A] (4) link
	WORD	SHINPCD		;[0C] (12) shinpu-san
	WORD	LINK0CD-(8*2)	;[0E] (4) link
	WORD	ONP14CD		;[10] (14) onpu
	WORD	OJI14CD		;[12] (14) jiisama
	WORD	RIS16CD		;[14] (16) risu
	WORD	HEISICD		;[16] (1) heishi
	WORD	DORBOCD		;[18] (15) dorobo-
	WORD	LINK1CD		;[1A] (16) link
	WORD	KIRARCD		;[1C] (16) sord "kirarin"
	WORD	OHSANCD		;[1E] (1) ohsan
	WORD	ZELDACD		;[20] (1) zelda
	WORD	GIRL0CD		;[22] (1) girl
	WORD	TORI0CD		;[24] (2) tori
	WORD	KODOMCD		;[26] (2) gaki
	WORD	SAHASCD		;[28] (2) sahasurarra
	WORD	OBABACD		;[2A] (2) obaba
	WORD	FUTAGCD		;[2C] (2) futago
	WORD	ANESNCD		;[2E] (2) anego
	WORD	IJMRUCD		;[30] (3) ijimeru kun
	WORD	IJMTECD		;[32] (3) ijimete kun
	WORD	GSAMACD		;[34] (5) kaokaki G-sama
	WORD	HIBANCD		;[36] (10) kajiya(hibana)
	WORD	HENJNCD		;[38] (11) henna ojisan
	WORD	TAKARCD		;[3A] (11) takara box
	WORD	WARP0CD		;[3C] (3) warp zoon
	WORD	TONKCCD		;[3E] (10 tonkachi
;
ENGCST	EQU	$
	PHA			;(SP) <-- number of OAM
	PHY			;(SP) <-- OBJ data address data index
	PHA			;(SP) <-- number of OAM
	ASL	A		;x4
	ASL	A	
	JSL	>OAMENT1
	JSL	>PSSAVE2
	PLA
	STA	4202H
	LDA	#08
	STA	4203H
	NOP
	NOP
	NOP
	NOP
	LDA	4216H
	STA	4202H
	LDA	!ENCHPT,X
	STA	4203H
;
	MEM16
	REP	#00100000B	;memory 16 bit mode set
;
	PLY
	LDA	!OBJADR,Y
	CLC
	ADC	!4216H
	STA	<WORK+8
;
	MEM8
	SEP	#00100000B	;momory 8 bit mode set
;
	PLA			;(A) <-- number of OAM
	JSL	>SETOAML22	;OAM set	
	RTS
;
;
ENCHR09	EQU	$
	BYTE	ZORAB
	BYTE	ZORAS
	BYTE	ZORAS
;
ENKOS09	EQU	$
	BYTE	08*4,02*4,02*4
;
ENST09	EQU	$
	HEX	3,1,1
;
ENCH09	EQU	$
	HEX	0,5,5
	HEX	1,6,6
;
ENDEN09	EQU	$
	PHX
	TXA
	LSR	A
	TAX
	LDA	ENIDDT,X
	TAX
EDEN910	EQU	$
	STX	ENINDX
	LDA	ENCHR09,X
	STA	ENMYNO,X
	LDA	ENKOS09,X
	JSL	>OAMENT1
;
	LDA	ENST09,X
	STA	ENSTAT,X
;
	TXY
;
	MEM16
	REP	#00100000B	; memory 16bit mode !!
;
	LDA	<CWORK0
	CMP	#26FH
	BNE	EDEN915
;
	PHY
	LDY	#21H
	STY	!SOUND3
	PLY
EDEN915	EQU	$
;
	MEM8
	SEP	#00100000B	; memory 8bit mode !!
;
	BCC	EDEN920
	INY
	INY
	INY
EDEN920	EQU	$
	LDA	ENCH09,Y
	STA	ENCHPT,X
;
	LDA	#33H
	STA	ENCLOR,X
	JSL	>PSSAVE2
;
	JSL	>ENMOVE2
;
	DEX
	BPL	EDEN910		; loop end ? [ no:EDEN910 ]
;
	PLX
	RTS
;
;
KAJIYCD	EQU	$
;;;	WORD	0FFF8H,00008H
;;;	HEX	60,C0,00,02	; tonkachi
;;;	WORD	00038H,00008H
;;;	HEX	60,80,00,02	;    "
	WORD	00000H,00000H
	HEX	22,00,00,02	; kajiya
	WORD	00030H,00000H
	HEX	64,00,00,02	;   "
	WORD	00000H,00000H+0AH
	HEX	6C,01,00,02	; kajiya
	WORD	00030H,00000H+0AH
	HEX	6C,01,00,02	;   "
;
;;;	WORD	0FFF8H,00008H
;;;	HEX	60,C0,00,02	; tonkachi
;;;	WORD	00038H,00008H
;;;	HEX	60,80,00,02	;    "
	WORD	00000H,00000H
	HEX	64,00,00,02	; kajiya
	WORD	00030H,00000H
	HEX	22,00,00,02	;   "
	WORD	00000H,00000H+0AH
	HEX	6C,01,00,02	; kajiya
	WORD	00030H,00000H+0AH
	HEX	6C,01,00,02	;   "
;
;;;	WORD	0FFF8H,00008H
;;;	HEX	60,C0,00,02	; tonkachi
;;;	WORD	00038H,00008H
;;;	HEX	60,80,00,02	;    "
	WORD	00000H,00000H
	HEX	64,00,00,02	; kajiya
	WORD	00030H,00000H
	HEX	64,00,00,02	;   "
	WORD	00000H,00000H+0AH
	HEX	6C,01,00,02	; kajiya
	WORD	00030H,00000H+0AH
	HEX	6C,01,00,02	;   "
;
TONKCCD	EQU	$
	WORD	00000H,00000H
	HEX	60,80,00,02	; tonkachi
;
ENDEN10	EQU	$
	PHX
	LDX	#00
;
	MEM16
	REP	#00100000B	; memory 16bit mode !!
;
	LDA	<CWORK0
	CMP	#00170H
;
	MEM8
	SEP	#00100000B	; memory 8bit mode !!
;
	BCC	EDE1040		; pattern change ? [ no:EDE1040 ]
;
	LDX	#04
EDE1002	EQU	$
	LDA	#01
	LDY	#3EH
	JSR	ENGCST
;
	INX
	CPX	#06
	BNE	EDE1002		; loop ? [ yes:EDE1002 ]
;
	LDX	#00
	LDA	#00111001B
	STA	ENCLOR,X	
;
	MEM16
	REP	#00100000B	; memory 16bit mode !!
;
	LDA	<CWORK0
	CMP	#001C0H
;
	MEM8
	SEP	#00100000B	; memory 8bit mode !!
;
	BCS	EDE1005		; pattern change ? [ no:EDE1005 ]
;
	LDA	#02
	BRA	EDE1008		;
;
EDE1005	EQU	$
	LDA	ENTIM0,X
	BNE	EDE1010		; pattern change ? [ no:EDE1010 ]
;
	LDA	#20H
	STA	ENTIM0,X
	LDA	ENCHPT,X
	EOR	#01
	AND	#01
EDE1008	EQU	$
	STA	ENCHPT,X
EDE1010	EQU	$
	LDA	#04
;;;;	LDA	#06
	LDY	#06
	JSR	ENGCST
;
	PLX
	RTS
;
EDE1040	EQU	$
	LDA	#KAJIY
	STA	ENMYNO,X
	LDA	#00111001B
	STA	ENCLOR,X
	LDA	#2
	JSR	ENMDST		; mode set !!
;
	LDA	<SLMODE
	PHA
	LDA	#3*4
	JSR	ENGEMV		; move !!
;
	PLA
	STA	<SLMODE
	LDA	ENWRK1,X
	CMP	#0FH
	BNE	EDE1080		; hibana on ? [ no:EDE1080 ]
;
	LDA	ENWRK0,X
	CMP	#04
	BNE	EDE1080		; hibana on ? [ no:EDE1080 ]
;
	LDA	#0FH
	STA	ENTIM0+2,X
EDE1080	EQU	$
	JSR	HIBANA
;
	INX
	CPX	#02
	BNE	EDE1040		; loop ? [ yes:EDE1040 ]
;
	PLX
	RTS
;
HIBANCD	EQU	$
	WORD	00000H,0FFFCH
	HEX	AA,30,00,02		; hibana
	WORD	00000H,0FFFCH
	HEX	AA,30,00,02		;   "
;
	WORD	0FFFCH,0FFF8H
	HEX	90,30,00,00		;   "
	WORD	0000CH,0FFF8H
	HEX	90,70,00,00		;   "
;
	WORD	0FFFAH,0FFF6H
	HEX	91,30,00,00		;   "
	WORD	0000EH,0FFF6H
	HEX	91,70,00,00		;   "
;
CHPTDT	EQU	$
	HEX	01,01,02,02,01,01,01,01
	HEX	02,02,02,02,00,00,00,00
;
HIBANA	EQU	$
	PHX
	INX
	INX
	LDA	ENTIM0,X
	BEQ	HIBN0F0		; hibana on ? [ no:HIBN0F0 ]
;
	TAY
	LDA	#00000010B
	STA	ENCLOR,X
	LDA	CHPTDT,Y
	STA	ENCHPT,X
	LDA	#02
	LDY	#36H
	JSR	ENGCST		; oam set !!
;
HIBN0F0	EQU	$
	PLX
	RTS
;
;********************************************************
;*	no.(11)						*
;********************************************************
;------ henna ojisan
HENJNCD	EQU	$
	WORD	0FFF0H+10H,0FFF0H+10H
	HEX	22,07,00,02
	WORD	0FFF0H+10H,0FFE8H+10H
	HEX	C2,09,00,02
;
	WORD	0FFF0H+10H,0FFF0H+10H
	HEX	22,47,00,02
	WORD	0FFF0H+10H,0FFE8H+10H
	HEX	C2,09,00,02
;
	WORD	0FFF0H+10H,0FFE7H+10H
	HEX	C4,09,00,02
	WORD	0FFF0H+10H,0FFF0H+10H
	HEX	22,07,00,02
;
	WORD	0FFF0H+10H,0FFE7H+10H
	HEX	24,09,00,02
	WORD	0FFF0H+10H,0FFF0H+10H
	HEX	22,07,00,02
;
;------ takarabako
TAKARCD	EQU	$
	WORD	0FFE0H+10H,0FFE4H+10H
	HEX	08,3F,00,02
	WORD	0FFF0H+10H,0FFE4H+10H
	HEX	20,3F,00,02
	WORD	00000H+10H,0FFE4H+10H
	HEX	20,3F,00,02
;
HAGTPT	EQU	$
	HEX	01,02,03,02
;
ENDEN11	EQU	$
	PHX
;
	LDX	#00
EDE1110	EQU	$
	CPX	#02
	BCS	EDE1120		;hage taka ? ( no:EDE1120 )
;------ hage taka move --------------------------
	LDA	#HAGE0
	STA	ENMYNO,X
	LDA	#00001011B
	STA	ENCLOR,X
	LDA	#02
	JSR	ENMDST
	LDA	#30H
	STA	ENZPSL,X
	LDA	<FRCNT
	CLC
	ADC	$,X
	LSR	A
	LSR	A
	AND	#03H
	TAY
	LDA	!HAGTPT,Y
	STA	!ENCHPT,X
	JSR	TORISAN		;tori move
	LDA	#03*4		;(A) <-- number of OAM
	JSR	ENGECS		;OAM set	
	BRA	EDE1130
;	
;------ sekizo move -----------------------------
EDE1120	EQU	$
	LDA	#04*4
	JSR	ENGECS		;OAM set
;;;	JSR	ENGECSP		;OAM set
EDE1130	EQU	$
	INX
	CPX	#05
	BCC	EDE1110
;
;------ henna ojisan move -----------------------
	LDA	#02		;(A) <-- number of OAM
	LDY	#38H		;(Y) <-- OBJ data address data index
	JSR	ENGCST		;OAM set
	JSR	WALKMV		;pattern set
;
;------ takara box ------------------------------
	INX			;[ LDX #06 ]
	LDA	#03		;(A) <-- number of OAM
	LDY	#3AH		;(Y) <-- OBJ data address data index
	JSR	ENGCST		;OAM set
;
	PLX
	RTS
;
;********************************************************
;*	no.(12)						*
;********************************************************
SHINPCD	EQU	$
	WORD	0FFEAH+10H,0FFEFH+0FH
	HEX	06,07,00,02
	WORD	0FFF0H+10H,0FFE8H+0FH
	HEX	0E,09,00,02
	WORD	0FFF0H+10H,0FFF0H+0FH
	HEX	08,09,00,02
;
ENDEN12	EQU	$
	PHX
;
	LDX	#00
	LDY	#0CH		;(Y) <-- OBJ data address data index
	LDA	#03		;(A) <-- number of OAM
	JSR	ENGCST		;OAM set
	JSR	SHADOW2		;shadow set
	INX
	LDA	#OYAGI
	STA	!ENMYNO,X
	LDA	#00100111B
	STA	!ENCLOR,X
	LDA	#02
	STA	!ENWRK3,X
	LDA	#04*4		;(A) <-- number of OAM
	JSR	ENGECS		;OAM set
;
	PLX
	RTS
;
;------ (13) mahou ya -----------------
ENADD13	EQU	$
	HEX	01,FF
;
ENDEN13	EQU	$
	PHX
	LDX	#02-1
	LDA	#02
	JSR	ENMDST
;
	LDA	#MJSY1
	STA	ENMYNO,X
	LDA	#03H*4
	JSL	>OAMENT1
	LDA	#37H
	STA	ENCLOR,X
	JSL	>PSSAVE2
;
	LDA	<FRCNT
	AND	#0FH
	BNE	EDE1310
;
	LDA	ENCHPT,X
	EOR	#01
	STA	ENCHPT,X
EDE1310	EQU	$
	JSL	>ENMOVE2
;
	MEM16
	REP	#00100000B	; memory 16bit mode !!
;
	LDA	<CWORK0
	CMP	#00180H
;
	MEM8
	SEP	#00100000B	; memory 8bit mode !!
;
	BCC	EDE1315		; move ? [ no:EDE1315 ]
;
	LDA	#04
	STA	ENYSPD,X
	LDA	ENYPSL,X
	CMP	#7CH
	BEQ	EDE1315		; move ? [ no:EDE1315 ]
;
	JSL	>ENMVCLL
;
EDE1315	EQU	$
	DEX
	LDA	#MAJOO
	STA	ENMYNO,X
	LDA	#06H*4
	JSL	>OAMENT1
	LDA	#39H
	STA	ENCLOR,X
	JSL	>PSSAVE2
;
	LDA	ENTIM0,X
	BNE	EDE1320
;
	LDA	#4
	STA	ENTIM0,X
	LDA	<CWORK1
	LSR	A
	AND	#01
	TAY
	LDA	ENCHPT,X
	CLC
	ADC	ENADD13,Y
	AND	#07
	STA	ENCHPT,X
EDE1320	EQU	$
	JSL	>ENMOVE2
;
	PLX
	RTS
;
;********************************************************
;*	no.(14)						*
;********************************************************
OJI14CD	EQU	$
	WORD	0FFF0H,0FFE8H
	HEX	04,37,00,02
	WORD	0FFF0H,0FFF0H
	HEX	64,37,00,02
;
	WORD	0FFF0H,0FFE8H
	HEX	62,37,00,02
	WORD	0FFF0H,0FFF0H
	HEX	64,37,00,02
;
ONP14CD	EQU	$
	WORD	00000H,0FFEDH
	HEX	AF,39,00,00
;
ONPUUSX	EQU	$
	BYTE	001,-01
;
OKBOYT	EQU	$
	HEX 	10,0E,10,12
JIISMT	EQU	$
	HEX	14,30,14,14
;
ANIMAL	EQU	$
	BYTE	02*4,02*4,03*4,03*4
ANICOL	EQU	$
	BYTE	00110111B,00110111B,00111011B,00111101B
ANIMKI	EQU	$
	HEX	00,01,00,01
;
ENDEN14	EQU	$
	PHX
;
;------ onpu move -------------------------------
	LDX	#00
EDE1400	EQU	$
	LDA	ENTIM0,X
	BNE	EDE1412
;
	LDA	#060H		;timer set
	STA	ENTIM0,X
	STA	ENMODE,X	;mode "ON"
	STZ	ENXSPD,X	;X speed claer
	LDA	#0EEH		;onpu again set
	STA	ENXPSL,X
	LDA	#04H
	STA	ENXPSH,X
	LDA	#018H
	STA	ENYPSL,X
	LDA	#0BH
	STA	ENYPSH,X
EDE1412	EQU	$
	LDA	ENMODE,X
	BEQ	EDE1414
;
	LDA	#0F8H		;Y speed set
	STA	ENYSPD,X
	JSL	>ENMVCLL	;xclc,yclc
;
	LDA	<FRCNT
	LSR	A
	BCS	ONPUU20
	STX	<WORK
	LDA	<FRCNT
	LSR	A
	LSR	A
	LSR	A
	LSR	A
	LSR	A
	EOR	<WORK
	AND	#01H
	TAY
	LDA	ENXSPD,X
	CLC
	ADC	ONPUUSX,Y
	STA	ENXSPD,X
ONPUU20	EQU	$
;
	LDY	#10H		;(Y) <-- OBJ data address data index
	LDA	#01H		;(A) <-- number of OAM
	JSR	ENGCST		;OAM set
EDE1414	EQU	$
	INX
	CPX	#05
	BCC	EDE1400
;
;------ okarina-boy & jiisama move --------------
EDE1410	EQU	$
	LDY	!ENWRK0,X
	LDA	!ENTIM0,X
	BNE	EDE1424
	LDA	!OKBOYT,Y
	CPX	#05
	BEQ	EDE1422
	LDA	!JIISMT,Y
EDE1422	EQU	$
	STA	!ENTIM0,X
	TYA
	INC	A
	AND	#03H
	STA	!ENWRK0,X
	LDA	!ENCHPT,X
	EOR	#01
	STA	!ENCHPT,X
EDE1424	EQU	$
	CPX	#05
	BNE	EDE1426		;okarina-boy ? ( no:EDE1426 )
	LDA	#00110001B
	STA	ENCLOR,X
	LDA	#04*4		;(A) <-- number of OAM
	JSR	ENGECS		;OAM set
	INX			;[ LDX #06 ]
	BRA	EDE1410
;
EDE1426	EQU	$
	LDY	#12H		;(Y) <-- OBJ data address data index
	LDA	#02H		;(A) <-- number of OAM
	JSR	ENGCST		;OAM set
;
;------ animal move -----------------------------
	INX			;[ LDX	#07 ]
EDE1430	EQU	$
	LDA	!ANICOL-7,X
	STA	ENCLOR,X
	LDA	!ANIMKI-7,X
	STA	ENMUKI,X
	LDA	!ANIMAL-7,X	;(A) <-- number of OAM
	JSR	ENGEMV		;game move
	INX
	CPX	#11
	BCC	EDE1430
;
	PLX
	RTS
;
;
DORBOCD	EQU	$		;(15) dorobo
	WORD	0FFF0H+10H,0FFE9H+10H
	HEX	00,0D,00,02
	WORD	0FFF0H+10H,0FFE9H+10H
	HEX	00,0D,00,02
	WORD	0FFF0H+10H,0FFF0H+10H
	HEX	06,0D,00,02
;
	WORD	0FFF0H+10H,0FFE9H+10H
	HEX	00,0D,00,02
	WORD	0FFF0H+10H,0FFE9H+10H
	HEX	00,0D,00,02
	WORD	0FFF0H+10H,0FFF0H+10H
	HEX	06,4D,00,02
;
	WORD	0FFF0H+10H,0FFE8H+10H
	HEX	00,0D,00,02
	WORD	0FFF0H+10H,0FFE8H+10H
	HEX	00,0D,00,02
	WORD	0FFF0H+10H,0FFF0H+10H
	HEX	20,0D,00,02
;
	WORD	0FFF0H+10H,0FFE8H+10H
	HEX	02,0D,00,02
	WORD	0FFF0H+10H,0FFE8H+10H
	HEX	02,0D,00,02
	WORD	0FFF0H+10H,0FFF0H+10H
	HEX	2C,0D,00,02
;
	WORD	0FFEDH+10H,0FFF0H+10H
	HEX	2F,0D,00,00
	WORD	0FFF0H+10H,0FFE9H+10H
	HEX	02,0D,00,02
	WORD	0FFF0H+10H,0FFF0H+10H
	HEX	2C,0D,00,02
;
	WORD	0FFEBH+10H,0FFF2H+10H
	HEX	2F,0D,00,00
	WORD	0FFF0H+10H,0FFE8H+10H
	HEX	02,0D,00,02
	WORD	0FFF0H+10H,0FFF0H+10H
	HEX	2C,0D,00,02
;
	WORD	0FFEBH+10H,0FFF2H+10H
	HEX	3F,0D,00,00
	WORD	0FFF0H+10H,0FFE8H+10H
	HEX	02,0D,00,02
	WORD	0FFF0H+10H,0FFF0H+10H
	HEX	2C,0D,00,02
;
;;;;	WORD	0FFFAH+10H,0FFEFH+10H
;;;;	HEX	2F,0D,00,00
;;;;	WORD	0FFF0H+10H,0FFE8H+10H
;;;;	HEX	00,0D,00,02
;;;;	WORD	0FFF0H+10H,0FFF0H+10H
;;;;	HEX	2C,0D,00,02
;
;;;;	WORD	0FFF8H+10H,0FFEEH+10H
;;;;	HEX	3F,0D,00,00
;;;;	WORD	0FFF0H+10H,0FFE8H+10H
;;;;	HEX	00,0D,00,02
;;;;	WORD	0FFF0H+10H,0FFF0H+10H
;;;;	HEX	2C,0D,00,02
;
;
NYORPT	EQU	$
	HEX	00,01,00,02
NYORCP	EQU	$
	HEX	08,20,20,08
;
ENDEN15	EQU	$
	PHX
;
	LDX	#06
EDE1510	EQU	$
	CPX	#05
	BCC	EDE1520		;karasu ? ( no:EDE1520 )
;------ karasu move -----------------------------
	LDA	#KARAS
	STA	ENMYNO,X
	LDA	#01
	JSR	ENMDST
	LDA	<FRCNT
	CLC
	ADC	$,X
	AND	#08H
	LSR	A
	LSR	A
	LSR	A
	STA	ENCHPT,X	
	LDA	#020H
	STA	ENZPSL,X
	JSR	TORISAN		;tori move
	LDA	ENXSPD,X
	LSR	A
	AND	#040H
	EOR	#00001111B
	STA	ENCLOR,X
	LDA	#02*4		;(A) <-- number of OAM
	JSR	ENGECS		;OAM set
	BRA	EDE1550
;
;------ nyoro nyoro move ------------------------
EDE1520	EQU	$
	LDA	#NYORO
	STA	ENMYNO,X
;- - - - - - - - - - - - - - - 
;	TXA
;	AND	#01H
	CPX	#01H
	BNE	O200
;
	STA	ENKBMK,X	; 0:Normal 1:Otsu
O200	EQU	$
;
	LDA	#03
	JSR	ENMDST
	LDA	#00101011B
	STA	ENCLOR,X
	LDA	ENTIM0,X
	BNE	EDE1522
	LDA	#0C0H
	STA	ENTIM0,	X
EDE1522	EQU	$
	LSR	A
	BNE	EDE1523		;stop ? ( yes:EDE1523 )
	STA	ENYSPD,X
	BRA	EDE1524
;
EDE1523	EQU	$	
	CMP	!NYORCP-1,X
	BCS	EDE1526		;out ? ( no:EDE1526 )
;------ out move ------------------------
	LDA	<FRCNT
	AND	#03H
	BNE	EDE1526
	LDA	ENYSPD,X
	BEQ	EDE1526
	DEC	A
	STA	ENYSPD,X
	CLC
	ADC	#0FCH		;[ #04H ]
	CPX	#03
	BCS	EDE1524
	EOR	#0FFH
	INC	A
EDE1524	EQU	$
	STA	!ENXSPD,X
EDE1526	EQU	$
	JSL	>ENMVCLL	;pos move
	LDA	<FRCNT
	LSR	A
	LSR	A
	LSR	A
	AND	#03H
	TAY
	LDA	!NYORPT,Y
	STA	ENCHPT,X
	LDA	#04*4		;(A) <-- number of OAM
	JSR	ENGECS		;OAM set
;
EDE1550	EQU	$
	DEX
	BEQ	EDE1560
	JMP	EDE1510
;
EDE1560	EQU	$
;------ dorobo- move ----------------------------
	LDY	#18H		;(Y) <-- OBJ data address data index
	LDA	#03		;(A) <-- number of OAM
	JSR	ENGCST		;OAM set
	LDA	#00100000B	;(A) <-- pri.
	JSR	WALKMV2		;walk move
;
	PLX
	RTS
;
;------------------------------------------------
;-	ENMOD0 & ENMOD2 set			-
;-		in  : (A) <-- (number of OAM)-1	-
;------------------------------------------------
ENMDST	EQU	$
	STA	ENMOD0,X
	LDA	#010H
	STA	ENMOD2,X
	RTS
;
;------ (16) ken spot ---------------------------
RIS16CD	EQU	$
	WORD	00000H,00000H
	HEX	0C,0C,00,02		; risu
;
	WORD	00000H,00000H
	HEX	0A,0C,00,02		; risu
;
	WORD	00000H,00000H
	HEX	C5,0C,00,02		; risu
;
	WORD	00000H,00000H
	HEX	E1,0C,00,02		; risu
;
RISCOL	EQU	$
	BYTE	01100001B,01100001B
;
HEICOL	EQU	$
	BYTE	00111011B,00111001B
;
RISTIM	EQU	$
	BYTE	06,06,06,06,06,06,10,08
;
KIRART	EQU	$		;sord "kirarin" data
	HEX	20,04,04,04,05,06
KIRAXP	EQU	$
	HEX	76,73,71,78
KIRAYP	EQU	$
	HEX	8B,83,8D,85
;
;------------------------------------------------
;-	kirarin					-
;-		in  : (Y) <-- loop no		-
;-		      (X) <-- X pos		-
;-		      (A) <-- Y  "		-
;------------------------------------------------
KIRARIN	EQU	$
	STX	<WORK		;X pos
	STA	<WORK+2		;Y pos	
	STY	ENWRK2		;loop no set
	LDX	#00
KIRAR10	EQU	$
	LDY	ENCHPT,X
	LDA	ENTIM0,X
	BNE	KIRAR30
	INY
	CPY	#06
	BCC	KIRAR20
	LDA	<WORK	
	STA	ENXPSL,X
	LDA	<WORK+2
	STA	ENYPSL,X	
	LDY	#00
KIRAR20	EQU	$
	TYA
	STA	ENCHPT,X
	LDA	!KIRART,Y		;timer set
	STA	ENTIM0,X
KIRAR30	EQU	$
	TYA
	BEQ	KIRAR40		;display ? ( no:KIRAR40 )
;
	LDY	#1CH		;(Y) <-- OBJ data address data index
	LDA	#01H		;(A) <-- number of OAM
	JSR	ENGCST		;OAM set
KIRAR40	EQU	$
	INX
	CPX	ENWRK2
	BCC	KIRAR10
	RTS
;
;------------------------------------------------------------------	
ENDEN16	EQU	$
	PHX
;
;------ sord "kirarin" --------------------------
	LDY	<FRCNT
	LDA	$,Y
	AND	#00000011B
	TAY
	LDX	!KIRAXP,Y	;(X) <-- X pos		
	LDA	!KIRAYP,Y	;(A) <-- Y  "
	LDY	#02		;(Y) <-- loop no
	JSR	KIRARIN		;kirarin move
;
;------ master sord
	LDA	#ATARS
	STA	ENMYNO,X
	LDA	#39H
	STA	ENCLOR,X
	LDA	#06H*4
	JSR	ENGECS	
;------ risu
	LDY	#02-1
EDE1640	EQU	$
	INX
	LDA	ENTIM1,X
	BEQ	EDE1645		; timer 1 dec ? [ no:EDE1645 ]
;
	DEC	ENTIM1,X
EDE1645	EQU	$
	LDA	ENXSPD,X
	LSR	A
	AND	#40H
	EOR	RISCOL,Y
	STA	ENCLOR,X
	LDA	ENTIM0,X
	BNE	EDE1648		; mode set ? [ no:EDE1648 ]
;
	LDA	#80H
	STA	ENTIM0,X
	STZ	ENWRK0,X
EDE1648	EQU	$
	LDA	ENWRK0,X
	BNE	EDE1650		; mode change ? [ yes:EDE1650 ]
;
	LDA	<FRCNT
	LSR	A
	LSR	A
	AND	#01
	INC	A
	INC	A
	STA	ENCHPT,X
	PHY
	JSR	RISU0MV
;
	PLY
	BRA	EDE16A0
;
EDE1650	EQU	$
	LDA	ENTIM1,X
	BNE	EDE16A0		; [ :EDE16A0 ]
;
	LDA	ENWRK1,X
	CMP	#08
	BNE	EDE1680		; [ :EDE1680 ]
;
	STZ	ENWRK1,X
EDE1680	EQU	$
	PHY
	LDA	ENWRK1,X
	AND	#07
	TAY
	LDA	RISTIM,Y
	STA	ENTIM1,X
	PLY
	LDA	ENCHPT,X
	AND	#01
	EOR	#01
	STA	ENCHPT,X
	INC	ENWRK1,X
EDE16A0	EQU	$
	PHY
	LDA	#01
	LDY	#14H
	JSR	ENGCST
;
	JSR	SHADOW		; shadow set !!
;
	PLY
	DEY
	BPL	EDE1640		; risu end ? [ no:EDE1640 ]
;
	INX
	JSR	LINK0MV
;
	PLX
	RTS
;
;
KIRARCD	EQU	$-(1*8)
	WORD	00000H,00000H
	HEX	C7,34,00,00
	WORD	00000H,00000H
	HEX	80,34,00,00
	WORD	00000H,00000H
	HEX	B6,34,00,00
	WORD	00000H,00000H
	HEX	B7,34,00,00
	WORD	00000H,00000H
	HEX	A6,34,00,00
;
PLYPT1	EQU	$
;		(0)      (2)      (4)      (6)
	WORD	000B6H*2,000B7H*2,000B8H*2,000B9H*2
;		(8)      (a)      (c)      (e)
	WORD	000B6H*2,000BAH*2,000BBH*2,000BCH*2
;
;------ link
LINK0MV	EQU	$
	LDA	ENTIM0,X
	BNE	LINK040		; inc ? [ no:LINK040 ]
;
	LDA	ENCHPT,X
	INC	A
	AND	#07H
	STA	ENCHPT,X
	LDA	#04
	STA	ENTIM0,X
LINK040	EQU	$
	LDA	ENCHPT,X
	ASL	A
	TAY
;
	MEM16
	REP	#00100000B	; memory 16bit mode !!
;
	LDA	PLYPT1,Y
	STA	!PCHPT0
;
	MEM8
	SEP	#00100000B	; memory 8bit mode !!
;
	LDA	#00100000B
	STA	ENCLOR,X
	LDA	#02
	LDY	#1AH
	JSR	ENGCST
;
	JSR	SHADOW
;
	JSL	>ENMVCLL
;
LINK080	EQU	$
;
	RTS
;
;------------------------------------------------------------
;-        sub                                               -
;------------------------------------------------------------
;
RISXAD	EQU	$
	HEX	20,18,E0,E8
RISYAD	EQU	$
	HEX	08,F8,F8,08
;
RISU0MV	EQU	$
;------ risu san move -------------------------
	LDA	ENTIM0,X
	CMP	#40H
	BCS	RISU20		; [ :RISU20 ]
;
	LDA	ENWRK2,X
	INC	A
	AND	#03
	STA	ENWRK2,X
	INC	ENWRK0,X
	RTS
;
RISU20	EQU	$
	LDY	ENWRK2,X
	LDA	RISXAD,Y
	STA	ENXSPD,X
	LDA	RISYAD,Y
	STA	ENYSPD,X
	JSL	>ENMVCLL
;
	RTS
;
;
TORXAD	EQU	$
TORYAD	EQU	$
	HEX	01,FF
;
TORXLM	EQU	$
	HEX	20,E0
;
TORYLM	EQU	$
	HEX	10,F0
;
TORISAN	EQU	$
;------ tori san move -------------------------
	LDA	ENMUKI,X
	AND	#01H
	TAY
	LDA	ENXSPD,X
	CLC
	ADC	TORXAD,Y
	STA	ENXSPD,X
	CMP	TORXLM,Y
	BNE	EDEN200		; [ :EDEN200 ]
;
	INC	ENMUKI,X
EDEN200	EQU	$
	LDA	<FRCNT
	AND	#01
	BNE	EDEN208		; [ :EDEN208 ]
;
	LDA	ENCMKI,X
	AND	#01H
	TAY
	LDA	ENYSPD,X
	CLC
	ADC	TORYAD,Y
	STA	ENYSPD,X
	CMP	TORYLM,Y
	BNE	EDEN208		; [ :EDEN208 ]
;
	INC	ENCMKI,X
EDEN208	EQU	$
	JSL	>ENMVCLL
;
;------ tori san move end ---------------------
;
	RTS
;
;
;
;
;************************************************************************
;*		GROUND Gamen scroll check		(GGNDSCL)	*
;************************************************************************
GDWTPT		EQU	$		; write point data
		WORD	00008H,00004H,00002H,00001H
;
;
GGNDSCL		EQU	$
		PHB
		PHK
		PLB			; (DBR) set
;
		MEM16
		REP	#00100000B	; memory 16bit mode
;
		LDA	#00001H
		STA	<WORK0
		LDA	<PLYMVC
		AND	#000FFH
		BNE	GDSL20		; y-move ?
;					; no
GDSL10		EQU	$
		JMP	GDSL200
;
GDSL20		EQU	$
		CMP	#00080H
		BCC	GDSL40		; (-) data ?
;					; yes
		EOR	#000FFH
		INC	A
		DEC	<WORK0
		DEC	<WORK0
		STA	<WORK2
;
		LDY	#000H
		BRA	GDSL80
;
GDSL40		EQU	$
		STA	<WORK2
		LDY	#002H
GDSL80		EQU	$
		LDX	#006H
		JSR	GDSL400		; y-move
		LDA	<WORK4
		STA	!SCRMVY		; Y-scroll dot
;
		LDX	<MPDTN1
		CPX	#097H
		BEQ	GDSL200		; kiri ?
;					; no
		CPX	#09DH
		BEQ	GDSL200		; kiri ?
;					; yes
		LDA	<WORK4
		BEQ	GDSL200		; move ?
;					; yes
		STZ	<WORK0
		LSR	A
		ROR	<WORK0
		LDX	<MPDTN1
		CPX	#0B5H
		BEQ	GDSL140		; yama ?
;					; no
		CPX	#0BEH
		BNE	GDSL160		; mori kokage ?
;					; yes
GDSL140		EQU	$
		LSR	A
		ROR	<WORK0
		CMP	#03000H
		BCC	GDSL180		; (-) data ?
;					; yes
		ORA	#0F000H
		BRA	GDSL180
;
GDSL160		EQU	$
		CMP	#07000H
		BCC	GDSL180		; (-) data ?
;					; yes
		ORA	#0F000H
GDSL180		EQU	$
		STA	<WORK6
;
		LDA	!SCV1CT
		CLC
		ADC	<WORK0
		STA	!SCV1CT
		LDA	<SCCV1
		ADC	<WORK6
		STA	<SCCV1
GDSL200		EQU	$
		LDA	#00001H
		STA	<WORK0
;
		LDA	<PLXMVC
		AND	#000FFH
		BNE	GDSL220		; x-move ?
;					; no
		JMP	GDSL380
;
GDSL220		EQU	$
		CMP	#00080H
		BCC	GDSL240		; (-) data ?
;					; yes
		EOR	#000FFH
		INC	A
		DEC	<WORK0
		DEC	<WORK0
		STA	<WORK2
;
		LDY	#004H
		BRA	GDSL280
;
GDSL240		EQU	$
		STA	<WORK2
;
		LDY	#006H
GDSL280		EQU	$
		LDX	#000H
		JSR	GDSL400		; x-move
		LDA	<WORK4
		STA	!SCRMVX		; X-scroll dot
;
		LDX	<MPDTN1
		CPX	#097H
		BEQ	GDSL380		; kiri ?
;					; no
		CPX	#09DH
		BEQ	GDSL380		; kiri ?
;					; yes
		LDA	<WORK4
		BEQ	GDSL380		; move ?
;					; yes
		STZ	<WORK0
		LSR	A
		ROR	<WORK0
		LDX	<MPDTN1
		CPX	#095H
		BEQ	GDSL300		; yama ?
;					; no
		CPX	#09EH
		BNE	GDSL350		; mori kokage ?
;					; yes
GDSL300		EQU	$
		LSR	A
		ROR	<WORK0
		CMP	#03000H
		BCC	GDSL360		; (-) data ?
;					; yes
		ORA	#0F000H
		BRA	GDSL360
;
GDSL350		EQU	$
		CMP	#07000H
		BCC	GDSL360		; (-) data ?
;					; yes
		ORA	#0F000H
GDSL360		EQU	$
		STA	<WORK6
;
		LDA	!SCH1CT
		CLC
		ADC	<WORK0
		STA	!SCH1CT
		LDA	<SCCH1
		ADC	<WORK6
		STA	<SCCH1
GDSL380		EQU	$
		LDX	<MPDTN1
		CPX	#09CH
		BEQ	GDSL387		; ura-yama ?
;					; no
		CPX	#097H
		BEQ	GDSL385		; kiri ?
;					; no
		CPX	#09DH
		BNE	GDSL390		; kiri ?
;					; yes
GDSL385		EQU	$
		LDA	!SCV1CT
		CLC
		ADC	#02000H
		STA	!SCV1CT
		LDA	<SCCV1
		ADC	#00000H
		STA	<SCCV1
;
		LDA	!SCH1CT
		CLC
		ADC	#02000H
		STA	!SCH1CT
		LDA	<SCCH1
		ADC	#00000H
		STA	<SCCH1
		BRA	GDSL390
;
GDSL387		EQU	$
		LDA	!SCV1CT
		SEC
		SBC	#02000H
		STA	!SCV1CT
		LDA	<SCCV1
		SBC	#00000H
		CLC
		ADC	!SCRMVY		; Y-scroll dot
		STA	<SCCV1
;
		LDA	<SCCH2
		STA	<SCCH1
GDSL390		EQU	$
		LDA	<RMXYCT
		CMP	#00181H
		BNE	GDSL399		;
;					;
		LDA	<SCCV2
		ORA	#00100H
		STA	<SCCV1
		LDA	<SCCH2
		STA	<SCCH1
GDSL399		EQU	$
		MEM8
		SEP	#00100000B	; memory 8bit mode
;
		PLB			; (DBR) reset
		RTL
;
;
		MEM16
GDSL400		EQU	$
		STZ	<WORK4
		STZ	<WORK6
GDSL420		EQU	$
		LDA	<SCCH2,X
		CLC
		ADC	<WORK0
		STA	<SCCH2,X
;
		INC	<WORK6
		LDA	<WORK4
		CLC
		ADC	<WORK0
		STA	<WORK4
;
		DEC	<WORK2
		BNE	GDSL420		; move end ?
;					; yes
GDSL500		EQU	$
		TYA
		EOR	#00002H
		TAX
		LDA	!UPSLCT,Y
		CLC
		ADC	<WORK6
		STA	!UPSLCT,Y
		CMP	#00010H
		BMI	GDSL540		; write ?
;					; yes
		SEC
		SBC	#00010H
		STA	!UPSLCT,Y
;
		LDA	GDWTPT,Y
		ORA	!GDWTFG
		STA	!GDWTFG
GDSL540		EQU	$
		LDA	#00000H
		SEC
		SBC	!UPSLCT,Y
		STA	!UPSLCT,X
		RTS
;
;
;
;
;
POINTDT		EQU	$
R_A		EQU	038E4H
R_B		EQU	038E5H
R_C		EQU	038E6H
R_D		EQU	038E7H
R_E		EQU	038E8H
R_F		EQU	038E9H
R_G		EQU	038EAH
R_H		EQU	038EBH
R_I		EQU	038ECH
R_J		EQU	038EDH
R_K		EQU	038EEH
R_L		EQU	038EFH
R_M		EQU	038F4H
R_N		EQU	038F5H
R_O		EQU	038F6H
R_P		EQU	038F7H
R_Q		EQU	038F8H
R_R		EQU	038F9H
R_S		EQU	038FAH
R_T		EQU	038FBH
R_U		EQU	038FCH
R_V		EQU	038FDH
R_W		EQU	038FEH
R_X		EQU	038FFH
R_Y		EQU	03900H
R_Z		EQU	03901H
RHI		EQU	03902H
RAP		EQU	03903H
RPI		EQU	03904H
RA0		EQU	03905H
RA1		EQU	03906H
RTN		EQU	03907H
;
E_A		EQU	02CE4H
E_B		EQU	02CE5H
E_C		EQU	02CE6H
E_D		EQU	02CE7H
E_E		EQU	02CE8H
E_F		EQU	02CE9H
E_G		EQU	02CEAH
E_H		EQU	02CEBH
E_I		EQU	02CECH
E_J		EQU	02CEDH
E_K		EQU	02CEEH
E_L		EQU	02CEFH
E_M		EQU	02CF4H
E_N		EQU	02CF5H
E_O		EQU	02CF6H
E_P		EQU	02CF7H
E_Q		EQU	02CF8H
E_R		EQU	02CF9H
E_S		EQU	02CFAH
E_T		EQU	02CFBH
E_U		EQU	02CFCH
E_V		EQU	02CFDH
E_W		EQU	02CFEH
E_X		EQU	02CFFH
E_Y		EQU	02D00H
E_Z		EQU	02D01H
EHI		EQU	02D02H
EAP		EQU	02D03H
EPI		EQU	02D04H
EA0		EQU	02D05H
EA1		EQU	02D06H
ETN		EQU	02D07H
;
G_A		EQU	028E4H
G_B		EQU	028E5H
G_C		EQU	028E6H
G_D		EQU	028E7H
G_E		EQU	028E8H
G_F		EQU	028E9H
G_G		EQU	028EAH
G_H		EQU	028EBH
G_I		EQU	028ECH
G_J		EQU	028EDH
G_K		EQU	028EEH
G_L		EQU	028EFH
G_M		EQU	028F4H
G_N		EQU	028F5H
G_O		EQU	028F6H
G_P		EQU	028F7H
G_Q		EQU	028F8H
G_R		EQU	028F9H
G_S		EQU	028FAH
G_T		EQU	028FBH
G_U		EQU	028FCH
G_V		EQU	028FDH
G_W		EQU	028FEH
G_X		EQU	028FFH
G_Y		EQU	02900H
G_Z		EQU	02901H
GHI		EQU	02902H
GAP		EQU	02903H
GPI		EQU	02904H
GA0		EQU	02905H
GA1		EQU	02906H
GTN		EQU	02907H
;
;
U_0		EQU	03C64H
U_1		EQU	03C65H
U_2		EQU	03C66H
U_3		EQU	03C67H
U_4		EQU	03C68H
U_5		EQU	03C69H
U_6		EQU	03C6AH
U_7		EQU	03C6BH
U_8		EQU	03C6CH
U_9		EQU	03C6DH
U_A		EQU	03C00H
U_B		EQU	03C01H
U_C		EQU	03C02H
U_D		EQU	03C03H
U_E		EQU	03C04H
U_F		EQU	03C05H
U_G		EQU	03C06H
U_H		EQU	03C07H
U_I		EQU	03CE0H
U_J		EQU	03C09H
U_K		EQU	03C0AH
U_L		EQU	03C0BH
U_M		EQU	03C0CH
U_N		EQU	03C0DH
U_O		EQU	03C0EH
U_P		EQU	03C0FH
U_Q		EQU	03C20H
U_R		EQU	03C21H
U_S		EQU	03C22H
U_T		EQU	03C23H
U_U		EQU	03C24H
U_V		EQU	03C25H
U_W		EQU	03C26H
U_X		EQU	03C27H
U_Y		EQU	03C28H
U_Z		EQU	03C29H
UAP		EQU	03CA1H
UBK		EQU	03CE2H
UHI		EQU	03C80H
UTN		EQU	03C81H
U00		EQU	03CC6H
U01		EQU	03CC7H
U02		EQU	03CC8H
U03		EQU	03CC9H
U04		EQU	03CCAH
U05		EQU	03CCBH
U06		EQU	03CCCH
U07		EQU	03CCDH
U08		EQU	03CCEH
U09		EQU	03CCFH
U0A		EQU	03CAAH
U0B		EQU	03CAFH
U0C		EQU	03CC0H
U0D		EQU	03CC1H
UZ1		EQU	03CE3H
;
D_0		EQU	03C74H
D_1		EQU	03C75H
D_2		EQU	03C76H
D_3		EQU	03C77H
D_4		EQU	03C78H
D_5		EQU	03C79H
D_6		EQU	03C7AH
D_7		EQU	03C7BH
D_8		EQU	03C7CH
D_9		EQU	03C7DH
D_A		EQU	03C10H
D_B		EQU	03C11H
D_C		EQU	03C12H
D_D		EQU	03C13H
D_E		EQU	03C14H
D_F		EQU	03C15H
D_G		EQU	03C16H
D_H		EQU	03C17H
D_I		EQU	03CF0H
D_J		EQU	03C19H
D_K		EQU	03C1AH
D_L		EQU	03C1BH
D_M		EQU	03C1CH
D_N		EQU	03C1DH
D_O		EQU	03C1EH
D_P		EQU	03C1FH
D_Q		EQU	03C30H
D_R		EQU	03C31H
D_S		EQU	03C32H
D_T		EQU	03C33H
D_U		EQU	03C34H
D_V		EQU	03C35H
D_W		EQU	03C36H
D_X		EQU	03C37H
D_Y		EQU	03C38H
D_Z		EQU	03C39H
DAP		EQU	03CB1H
DBK		EQU	03CF2H
DHI		EQU	03C90H
DTN		EQU	03C91H
D00		EQU	03CD6H
D01		EQU	03CD7H
D02		EQU	03CD8H
D03		EQU	03CD9H
D04		EQU	03CDAH
D05		EQU	03CDBH
D06		EQU	03CDCH
D07		EQU	03CDDH
D08		EQU	03CDEH
D09		EQU	03CDFH
D0A		EQU	03CBAH
D0B		EQU	03CBFH
D0C		EQU	03CD0H
D0D		EQU	03CD1H
DZ1		EQU	03CF3H
;
;
SPACDAT		EQU	$
SPA		EQU	03CA9H
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		staff title data					x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
STAF000		EQU	$
		BYTE	007H,staf0001-staf0000-1
staf0000	equ	$
		WORD	G_P,G_R,G_O,G_D,G_U,G_C,G_T,G_E,G_U,G_R,SPA
		WORD	G_E,G_X,G_E,G_C,G_U,G_T,G_I,G_F
staf0001	equ	$
;
STAF001		EQU	$
		BYTE	0FFH
;
STAF002		EQU	$
		BYTE	008H,16*2-1
		WORD	U_H,U_I,U_R,U_O,U_S,U_H,U_I,SPA
		WORD	U_Y,U_A,U_M,U_A,U_U,U_C,U_H,U_I
;
STAF003		EQU	$
		BYTE	008H,16*2-1
		WORD	D_H,D_I,D_R,D_O,D_S,D_H,D_I,SPA
		WORD	D_Y,D_A,D_M,D_A,D_U,D_C,D_H,D_I
;
STAF004		EQU	$
		BYTE	00BH,staf0041-staf0040-1
staf0040	equ	$
		WORD	E_P,E_R,E_O,E_D,E_U,E_C,E_T,E_E,E_U,E_R
staf0041	equ	$
;
STAF005		EQU	$
		BYTE	008H,16*2-1
		WORD	U_S,U_H,U_I,U_G,U_E,U_R,U_U,SPA
		WORD	U_M,U_I,U_Y,U_A,U_M,U_O,U_T,U_O
;
STAF006		EQU	$
		BYTE	008H,16*2-1
		WORD	D_S,D_H,D_I,D_G,D_E,D_R,D_U,SPA
		WORD	D_M,D_I,D_Y,D_A,D_M,D_O,D_T,D_O
;
STAF007		EQU	$
		BYTE	00BH,staf0071-staf0070-1
staf0070	equ	$
		WORD	R_D,R_I,R_R,R_E,R_C,R_T,R_E,R_U,R_R
staf0071	equ	$
;
STAF008		EQU	$
		BYTE	009H,14*2-1
		WORD	U_T,U_A,U_K,U_A,U_S,U_H,U_I,SPA
		WORD	U_T,U_E,U_Z,U_U,U_K,U_A
;
STAF009		EQU	$
		BYTE	009H,14*2-1
		WORD	D_T,D_A,D_K,D_A,D_S,D_H,D_I,SPA
		WORD	D_T,D_E,D_Z,D_U,D_K,D_A
;
STAF010		EQU	$
		BYTE	00CH,staf0101-staf0100-1
staf0100	equ	$
		WORD	G_S,G_C,G_R,G_I,G_P,G_T,G_S
staf0101	equ	$
;
STAF011		EQU	$
		BYTE	009H,14*2-1
		WORD	U_K,U_E,U_N,U_S,U_U,U_K,U_E,SPA
		WORD	U_T,U_A,U_N,U_A,U_B,U_E
;
STAF012		EQU	$
		BYTE	009H,14*2-1
		WORD	D_K,D_E,D_N,D_S,D_U,D_K,D_E,SPA
		WORD	D_T,D_A,D_N,D_A,D_B,D_E
;
STAF013		EQU	$
		BYTE	005H,staf0131-staf0130-1
staf0130	equ	$
		WORD	E_D,E_I,E_R,E_E,E_C,E_T,E_E,E_U,E_R,E_S,SPA
		WORD	E_A,E_S,E_S,E_I,E_S,E_T,E_A,E_N,E_T,E_S
staf0131	equ	$
;
STAF014		EQU	$
		BYTE	007H,17*2-1
		WORD	U_Y,U_A,U_S,U_U,U_H,U_I,U_S,U_A,SPA
		WORD	U_Y,U_A,U_M,U_A,U_M,U_U,U_R,U_A
;
STAF015		EQU	$
		BYTE	007H,17*2-1
		WORD	D_Y,D_A,D_S,D_U,D_H,D_I,D_S,D_A,SPA
		WORD	D_Y,D_A,D_M,D_A,D_M,D_U,D_R,D_A
;
STAF016		EQU	$
		BYTE	009H,13*2-1
		WORD	U_Y,U_O,U_I,U_C,U_H,U_I,SPA
		WORD	U_Y,U_A,U_M,U_A,U_D,U_A
;
STAF017		EQU	$
		BYTE	009H,13*2-1
		WORD	D_Y,D_O,D_I,D_C,D_H,D_I,SPA
		WORD	D_Y,D_A,D_M,D_A,D_D,D_A
;
STAF018		EQU	$
		BYTE	005H,staf0181-staf0180-1
staf0180	equ	$
		WORD	G_C,G_O,G_N,G_C,G_E,G_P,G_T,G_E,G_U,G_R,G_S,SPA
		WORD	G_G,G_R,G_A,G_P,G_H,G_I,G_Q,G_U,G_E,G_S
staf0181	equ	$
;
STAF019		EQU	$
		BYTE	007H,staf0191-staf0190-1
staf0190	equ	$
		WORD	E_C,E_O,E_N,E_C,E_E,E_P,E_T,E_E,E_U,E_R,E_S,SPA
		WORD	E_S,E_U,E_J,E_E,E_T,E_S
staf0191	equ	$
;
STAF020		EQU	$
		BYTE	008H,15*2-1
		WORD	U_S,U_O,U_I,U_C,U_H,U_I,U_R,U_O,SPA
		WORD	U_T,U_O,U_M,U_I,U_T,U_A
;
STAF021		EQU	$
		BYTE	008H,15*2-1
		WORD	D_S,D_O,D_I,D_C,D_H,D_I,D_R,D_O,SPA
		WORD	D_T,D_O,D_M,D_I,D_T,D_A
;
STAF022		EQU	$
		BYTE	008H,14*2-1
		WORD	U_T,U_A,U_K,U_A,U_Y,U_A,SPA
		WORD	U_I,U_M,U_A,U_M,U_U,U_R,U_A
;
STAF023		EQU	$
		BYTE	008H,14*2-1
		WORD	D_T,D_A,D_K,D_A,D_Y,D_A,SPA
		WORD	D_I,D_M,D_A,D_M,D_U,D_R,D_A
;
STAF024		EQU	$
		BYTE	007H,staf0241-staf0240-1
staf0240	equ	$
		WORD	E_C,E_O,E_N,E_C,E_E,E_P,E_T,E_E,E_U,E_R,E_S,SPA
		WORD	E_D,E_E,E_C,E_O,E_R,E_S
staf0241	equ	$
;
STAF025		EQU	$
		BYTE	008H,15*2-1
		WORD	U_M,U_A,U_S,U_A,U_N,U_A,U_O,SPA
		WORD	U_A,U_R,U_I,U_M,U_O,U_T,U_O
;
STAF026		EQU	$
		BYTE	008H,15*2-1
		WORD	D_M,D_A,D_S,D_A,D_N,D_A,D_O,SPA
		WORD	D_A,D_R,D_I,D_M,D_O,D_T,D_O
;
STAF027		EQU	$
		BYTE	007H,17*2-1
		WORD	U_T,U_S,U_U,U_Y,U_O,U_S,U_H,U_I,SPA
		WORD	U_W,U_A,U_T,U_A,U_N,U_A,U_B,U_E
;
STAF028		EQU	$
		BYTE	007H,17*2-1
		WORD	D_T,D_S,D_U,D_Y,D_O,D_S,D_H,D_I,SPA
		WORD	D_W,D_A,D_T,D_A,D_N,D_A,D_B,D_E
;
STAF029		EQU	$
		BYTE	007H,staf0291-staf0290-1
staf0290	equ	$
		WORD	R_P,R_R,R_O,R_G,R_R,R_A,R_M,R_M,R_E,R_U,R_R,SPA
		WORD	R_E,R_N,SPA
		WORD	R_C,R_H,R_E,R_F
staf0291	equ	$
;
STAF030		EQU	$
		BYTE	008H,16*2-1
		WORD	U_T,U_O,U_S,U_H,U_I,U_H,U_I,U_K,U_O,SPA
		WORD	U_N,U_A,U_K,U_A,U_G,U_O
;
STAF031		EQU	$
		BYTE	008H,16*2-1
		WORD	D_T,D_O,D_S,D_H,D_I,D_H,D_I,D_K,D_O,SPA
		WORD	D_N,D_A,D_K,D_A,D_G,D_O
;
STAF032		EQU	$
		BYTE	007H,staf0321-staf0320-1
staf0320	equ	$
		WORD	G_P,G_R,G_O,G_G,G_R,G_A,G_M,G_M,G_E,G_U,G_R,SPA
		WORD	G_G,G_E,G_N,G_E,G_R,G_A,G_L
staf0321	equ	$
;
STAF033		EQU	$
		BYTE	008H,16*2-1
		WORD	U_Y,U_A,U_S,U_U,U_N,U_A,U_R,U_I,SPA
		WORD	U_S,U_O,U_E,U_J,U_I,U_M,U_A
;
STAF034		EQU	$
		BYTE	008H,16*2-1
		WORD	D_Y,D_A,D_S,D_U,D_N,D_A,D_R,D_I,SPA
		WORD	D_S,D_O,D_E,D_J,D_I,D_M,D_A
;
STAF035		EQU	$
		BYTE	009H,14*2-1
		WORD	U_K,U_A,U_Z,U_U,U_A,U_K,U_I,SPA
		WORD	U_M,U_O,U_R,U_I,U_T,U_A
;
STAF036		EQU	$
		BYTE	009H,14*2-1
		WORD	D_K,D_A,D_Z,D_U,D_A,D_K,D_I,SPA
		WORD	D_M,D_O,D_R,D_I,D_T,D_A
;
STAF037		EQU	$
		BYTE	00AH,staf0371-staf0370-1
staf0370	equ	$
		WORD	E_P,E_R,E_O,E_G,E_R,E_A,E_M,E_M,E_E,E_U,E_R,E_S
staf0371	equ	$
;
STAF038		EQU	$
		BYTE	008H,16*2-1
		WORD	U_T,U_A,U_T,U_S,U_U,U_O,SPA
		WORD	U_N,U_I,U_S,U_H,U_I,U_Y,U_A,U_M,U_A
;
STAF039		EQU	$
		BYTE	008H,16*2-1
		WORD	D_T,D_A,D_T,D_S,D_U,D_O,SPA
		WORD	D_N,D_I,D_S,D_H,D_I,D_Y,D_A,D_M,D_A
;
STAF040		EQU	$
		BYTE	008H,15*2-1
		WORD	U_Y,U_U,U_I,U_C,U_H,U_I,SPA
		WORD	U_Y,U_A,U_M,U_A,U_M,U_O,U_T,U_O
;
STAF041		EQU	$
		BYTE	008H,15*2-1
		WORD	D_Y,D_U,D_I,D_C,D_H,D_I,SPA
		WORD	D_Y,D_A,D_M,D_A,D_M,D_O,D_T,D_O
;
STAF042		EQU	$
		BYTE	008H,16*2-1
		WORD	U_Y,U_O,U_S,U_H,U_I,U_H,U_I,U_R,U_O,SPA
		WORD	U_N,U_O,U_M,U_O,U_T,U_O
;
STAF043		EQU	$
		BYTE	008H,16*2-1
		WORD	D_Y,D_O,D_S,D_H,D_I,D_H,D_I,D_R,D_O,SPA
		WORD	D_N,D_O,D_M,D_O,D_T,D_O
;
STAF044		EQU	$
		BYTE	00BH,9*2-1
		WORD	U_E,U_I,U_J,U_I,SPA
		WORD	U_N,U_O,U_T,U_O
;
STAF045		EQU	$
		BYTE	00BH,9*2-1
		WORD	D_E,D_I,D_J,D_I,SPA
		WORD	D_N,D_O,D_T,D_O
;
STAF046		EQU	$
		BYTE	008H,15*2-1
		WORD	U_S,U_A,U_T,U_O,U_R,U_U,SPA
		WORD	U_T,U_A,U_K,U_A,U_H,U_A,U_T,U_A
;
STAF047		EQU	$
		BYTE	008H,15*2-1
		WORD	D_S,D_A,D_T,D_O,D_R,D_U,SPA
		WORD	D_T,D_A,D_K,D_A,D_H,D_A,D_T,D_A
;
STAF048		EQU	$
		BYTE	005H,staf0481-staf0480-1
staf0480	equ	$
		WORD	R_M,R_U,R_S,R_I,R_Q,R_U,R_E,SPA
		WORD	R_E,R_T,SPA
		WORD	R_B,R_R,R_U,R_I,R_T,R_A,R_G,R_E,R_S
staf0481	equ	$
;
STAF049		EQU	$
		BYTE	00AH,10*2-1
		WORD	U_K,U_O,U_J,U_I,SPA
		WORD	U_K,U_O,U_N,U_D,U_O
;
STAF050		EQU	$
		BYTE	00AH,10*2-1
		WORD	D_K,D_O,D_J,D_I,SPA
		WORD	D_K,D_O,D_N,D_D,D_O
;
STAF051		EQU	$
		BYTE	009H,staf0511-staf0510-1
staf0510	equ	$
		WORD	G_C,G_O,G_O,G_R,G_D,G_I,G_N,G_A,G_T,G_E,G_U,G_R,G_S
staf0511	equ	$
;
STAF052		EQU	$
		BYTE	00AH,10*2-1
		WORD	U_K,U_E,U_I,U_Z,U_O,SPA
		WORD	U_K,U_A,U_T,U_O
;
STAF053		EQU	$
		BYTE	00AH,10*2-1
		WORD	D_K,D_E,D_I,D_Z,D_O,SPA
		WORD	D_K,D_A,D_T,D_O
;
STAF054		EQU	$
		BYTE	009H,13*2-1
		WORD	U_T,U_A,U_K,U_A,U_O,SPA
		WORD	U_S,U_H,U_I,U_M,U_I,U_Z,U_U
;
STAF055		EQU	$
		BYTE	009H,13*2-1
		WORD	D_T,D_A,D_K,D_A,D_O,SPA
		WORD	D_S,D_H,D_I,D_M,D_I,D_Z,D_U
;
STAF056		EQU	$
		BYTE	009H,staf0561-staf0560-1
staf0560	equ	$
		WORD	E_I,E_L,E_L,E_U,E_S,E_T,E_R,E_A,E_T,E_E,E_U,E_R,E_S
staf0561	equ	$
;
STAF057		EQU	$
		BYTE	009H,13*2-1
		WORD	U_Y,U_O,U_I,U_C,U_H,U_I,SPA
		WORD	U_K,U_O,U_T,U_A,U_B,U_E
;
STAF058		EQU	$
		BYTE	009H,13*2-1
		WORD	D_Y,D_O,D_I,D_C,D_H,D_I,SPA
		WORD	D_K,D_O,D_T,D_A,D_B,D_E
;
;;;;STAF059		EQU	$
;;;;		BYTE	00AH,12*2-1
;;;;		WORD	U_M,U_I,U_N,U_O,U_R,U_U,SPA
;;;;		WORD	U_M,U_A,U_E,U_D,U_A
;;;;;
;;;;STAF060		EQU	$
;;;;		BYTE	00AH,12*2-1
;;;;		WORD	D_M,D_I,D_N,D_O,D_R,D_U,SPA
;;;;		WORD	D_M,D_A,D_E,D_D,D_A
;;;;;
STAF061		EQU	$
		BYTE	00AH,12*2-1
		WORD	U_H,U_I,U_D,U_E,U_K,U_I,SPA
		WORD	U_F,U_U,U_J,U_I,U_I
;
STAF062		EQU	$
		BYTE	00AH,12*2-1
		WORD	D_H,D_I,D_D,D_E,D_K,D_I,SPA
		WORD	D_F,D_U,D_J,D_I,D_I
;
STAF063		EQU	$
		BYTE	008H,16*2-1
		WORD	U_Y,U_O,U_S,U_H,U_I,U_A,U_K,U_I,SPA
		WORD	U_K,U_O,U_I,U_Z,U_U,U_M,U_I
;
STAF064		EQU	$
		BYTE	008H,16*2-1
		WORD	D_Y,D_O,D_S,D_H,D_I,D_A,D_K,D_I,SPA
		WORD	D_K,D_O,D_I,D_Z,D_U,D_M,D_I
;
STAF065		EQU	$
		BYTE	009H,14*2-1
		WORD	U_Y,U_A,U_S,U_U,U_H,U_I,U_R,U_O,SPA
		WORD	U_S,U_A,U_K,U_A,U_I
;
STAF066		EQU	$
		BYTE	009H,14*2-1
		WORD	D_Y,D_A,D_S,D_U,D_H,D_I,D_R,D_O,SPA
		WORD	D_S,D_A,D_K,D_A,D_I
;
STAF067		EQU	$
		BYTE	008H,15*2-1
		WORD	U_T,U_O,U_M,U_O,U_A,U_K,U_I,SPA
		WORD	U_K,U_U,U_R,U_O,U_U,U_M,U_E
;
STAF068		EQU	$
		BYTE	008H,15*2-1
		WORD	D_T,D_O,D_M,D_O,D_A,D_K,D_I,SPA
		WORD	D_K,D_U,D_R,D_O,D_U,D_M,D_E
;
STAF069		EQU	$
		BYTE	008H,staf0691-staf0690-1
staf0690	equ	$
		WORD	R_R,R_E,R_M,R_E,R_R,R_C,R_I,R_E,R_M,R_E,R_N,R_T,R_S,SPA,R_A
staf0691	equ	$
;
STAF070		EQU	$
		BYTE	007H,17*2-1
		WORD	U_Y,U_A,U_S,U_U,U_N,U_O,U_R,U_I,SPA
		WORD	U_T,U_A,U_K,U_E,U_T,U_A,U_N,U_I
;
;;;;;		BYTE	009H,13*2-1
;;;;;		WORD	U_N,U_O,U_B,U_U,U_O,SPA
;;;;;		WORD	U_O,U_K,U_A,U_J,U_I,U_M,U_A
;
STAF071		EQU	$
		BYTE	007H,17*2-1
		WORD	D_Y,D_A,D_S,D_U,D_N,D_O,D_R,D_I,SPA
		WORD	D_T,D_A,D_K,D_E,D_T,D_A,D_N,D_I
;
;;;;;		BYTE	009H,13*2-1
;;;;;		WORD	D_N,D_O,D_B,D_U,D_O,SPA
;;;;;		WORD	D_O,D_K,D_A,D_J,D_I,D_M,D_A
;
STAF072		EQU	$
		BYTE	009H,staf0721-staf0720-1
staf0720	equ	$
		WORD	U_N,U_O,U_B,U_U,U_O,SPA
		WORD	U_O,U_K,U_A,U_J,U_I,U_M,U_A
;
;;;;;		WORD	U_M,U_I,U_C,U_H,U_A,U_E,U_L,SPA
;;;;;		WORD	U_F,U_R,U_I,U_E,U_S,U_L
staf0721	equ	$
;
STAF073		EQU	$
		BYTE	009H,staf0731-staf0730-1
staf0730	equ	$
		WORD	D_N,D_O,D_B,D_U,D_O,SPA
		WORD	D_O,D_K,D_A,D_J,D_I,D_M,D_A
;
;;;;;		WORD	D_M,D_I,D_C,D_H,D_A,D_E,D_L,SPA
;;;;;		WORD	D_F,D_R,D_I,D_E,D_S,D_L
staf0731	equ	$
;
STAF074		EQU	$
		BYTE	00AH,12*2-1
		WORD	U_K,U_I,U_Y,U_O,U_S,U_H,U_I,SPA
		WORD	U_K,U_O,U_D,U_A
;
STAF075		EQU	$
		BYTE	00AH,12*2-1
		WORD	D_K,D_I,D_Y,D_O,D_S,D_H,D_I,SPA
		WORD	D_K,D_O,D_D,D_A
;
STAF076		EQU	$
		BYTE	007H,staf0761-staf0760-1
staf0760	equ	$
		WORD	U_T,U_A,U_K,U_A,U_M,U_I,U_T,U_S,U_U,SPA
		WORD	U_K,U_U,U_Z,U_U,U_H,U_A,U_R,U_A
;
;;;;;		WORD	U_A,U_N,U_G,U_E,U_L,U_I,U_K,U_A,SPA
;;;;;		WORD	U_R,U_A,U_U,U_G,U_U,U_S,U_T
staf0761	equ	$
;
STAF077		EQU	$
		BYTE	007H,staf0771-staf0770-1
staf0770	equ	$
		WORD	D_T,D_A,D_K,D_A,D_M,D_I,D_T,D_S,D_U,SPA
		WORD	D_K,D_U,D_Z,D_U,D_H,D_A,D_R,D_A
;
;;;;;		WORD	D_A,D_N,D_G,D_E,D_L,D_I,D_K,D_A,SPA
;;;;;		WORD	D_R,D_A,D_U,D_G,D_U,D_S,D_T
staf0771	equ	$
;
STAF078		EQU	$
		BYTE	009H,14*2-1
		WORD	U_H,U_I,U_R,U_O,U_N,U_O,U_B,U_U,SPA
		WORD	U_K,U_A,U_K,U_U,U_I
;
STAF079		EQU	$
		BYTE	009H,14*2-1
		WORD	D_H,D_I,D_R,D_O,D_N,D_O,D_B,D_U,SPA
		WORD	D_K,D_A,D_K,D_U,D_I
;
STAF080		EQU	$
		BYTE	007H,17*2-1
		WORD	U_S,U_H,U_I,U_G,U_E,U_K,U_I,SPA
		WORD	U_Y,U_A,U_M,U_A,U_S,U_H,U_I,U_R,U_O
;
STAF081		EQU	$
		BYTE	007H,17*2-1
		WORD	D_S,D_H,D_I,D_G,D_E,D_K,D_I,SPA
		WORD	D_Y,D_A,D_M,D_A,D_S,D_H,D_I,D_R,D_O
;
;;;;STAF082		EQU	$
;;;;		BYTE	00CH,7*2-1
;;;;		WORD	U_T,U_H,U_E,SPA
;;;;		WORD	U_E,U_N,U_D
;;;;;
;;;;STAF083		EQU	$
;;;;		BYTE	00CH,7*2-1
;;;;		WORD	D_T,D_H,D_E,SPA
;;;;		WORD	D_E,D_N,D_D
;;;;;
STAF084		EQU	$
		BYTE	007H,staf0841-staf0840-1
staf0840	equ	$
		WORD	G_P,G_R,G_O,G_G,G_R,G_A,G_M,G_M,G_E,G_U,G_R,SPA
		WORD	G_S,G_U,G_J,G_E,G_T,G_S
staf0841	equ	$
;
STAF085		EQU	$
		BYTE	009H,14*2-1
		WORD	U_T,U_O,U_S,U_H,U_I,U_O,SPA
		WORD	U_I,U_W,U_A,U_W,U_A,U_K,U_I
;
STAF086		EQU	$
		BYTE	009H,14*2-1
		WORD	D_T,D_O,D_S,D_H,D_I,D_O,SPA
		WORD	D_I,D_W,D_A,D_W,D_A,D_K,D_I
;
STAF087		EQU	$
		BYTE	006H,19*2-1
		WORD	U_S,U_H,U_I,U_G,U_E,U_H,U_I,U_R,U_O,SPA
		WORD	U_K,U_A,U_S,U_A,U_M,U_A,U_T,U_S,U_U
;
STAF088		EQU	$
		BYTE	006H,19*2-1
		WORD	D_S,D_H,D_I,D_G,D_E,D_H,D_I,D_R,D_O,SPA
		WORD	D_K,D_A,D_S,D_A,D_M,D_A,D_T,D_S,D_U
;
STAF089		EQU	$
		BYTE	00BH,staf0891-staf0890-1
staf0890	equ	$
		WORD	U_T,U_A,SPA,U_Q,U_U,U_E,U_T,U_E
staf0891	equ	$
;
STAF090		EQU	$
		BYTE	00BH,staf0901-staf0900-1
staf0900	equ	$
		WORD	D_T,D_A,SPA,D_Q,D_U,D_E,D_T,D_E
staf0901	equ	$
;
STAF091		EQU	$
		BYTE	003H,staf0911-staf0910-1
staf0910	equ	$
		WORD	R_L,R_I,R_E,R_U,R_X,SPA,SPA,SPA
		WORD	SPA,SPA,SPA,SPA,SPA,SPA,SPA,SPA
		WORD	SPA,SPA,SPA,SPA,SPA
		WORD	R_J,R_E,R_U,R_X
staf0911	equ	$
;
STAF092		EQU	$
		BYTE	004H,staf0921-staf0920-1
staf0920	equ	$
		WORD	E_C,E_H,ETN,SPA,E_D,EAP,E_H,E_Y,E_R,E_U,E_L,E_E
staf0921	equ	$
;
STAF093		EQU	$
		BYTE	004H,staf0931-staf0930-1
staf0930	equ	$
		WORD	G_D,G_O,G_N,G_J,G_O,G_N,SPA,G_C,G_H,GTN
staf0931	equ	$
;
STAF094		EQU	$
		BYTE	004H,staf0941-staf0940-1
staf0940	equ	$
		WORD	E_P,E_A,E_L,E_A,E_I,E_S,SPA
		WORD	E_D,E_E,SPA,E_L,EAP,E_E,E_S,E_T
staf0941	equ	$
;
STAF095		EQU	$
		BYTE	004H,staf0951-staf0950-1
staf0950	equ	$
		WORD	G_P,GTN,SPA,G_D,G_U,SPA,G_D,G_E,G_S,G_E,G_R,G_T
staf0951	equ	$
;
STAF096		EQU	$
		BYTE	004H,staf0961-staf0960-1
staf0960	equ	$
		WORD	E_T,E_O,E_U,E_R,SPA,E_M,E_O,E_N,E_T,E_A,E_G,E_N,E_E
staf0961	equ	$
;
STAF097		EQU	$
		BYTE	009H,staf0971-staf0970-1
staf0970	equ	$
		WORD	UZ1,SPA
		WORD	U_P,UTN,SPA,U_T,U_E,U_N,U_E,U_B,U_R,U_E,U_S
staf0971	equ	$
;
STAF098		EQU	$
		BYTE	003H,staf0981-staf0980-1
staf0980	equ	$
		WORD	R_N,R_I,R_V,R_E,R_A,R_U
		WORD	DZ1,SPA
		WORD	D_P,DTN,SPA,D_T,D_E,D_N,D_E,D_B,D_R,D_E,D_S
staf0981	equ	$
;
STAF099		EQU	$
		BYTE	009H,staf0991-staf0990-1
staf0990	equ	$
		WORD	U_2,SPA
		WORD	U_P,UTN,SPA,U_D,U_U,SPA,U_M,U_A,U_R,U_A,U_I,U_S
staf0991	equ	$
;
STAF100		EQU	$
		BYTE	003H,staf1001-staf1000-1
staf1000	equ	$
		WORD	R_N,R_I,R_V,R_E,R_A,R_U
		WORD	D_2,SPA
		WORD	D_P,DTN,SPA,D_D,D_U,SPA,D_M,D_A,D_R,D_A,D_I,D_S
staf1001	equ	$
;
STAF101		EQU	$
		BYTE	009H,staf1011-staf1010-1
staf1010	equ	$
		WORD	U_3,SPA
		WORD	U_F,UTN,SPA,U_S,U_Q,U_U,U_E,U_L,U_E,U_T,U_T,U_E,U_S
staf1011	equ	$
;
STAF102		EQU	$
		BYTE	003H,staf1021-staf1020-1
staf1020	equ	$
		WORD	R_N,R_I,R_V,R_E,R_A,R_U
		WORD	D_3,SPA
		WORD	D_F,DTN,SPA,D_S,D_Q,D_U,D_E,D_L,D_E,D_T,D_T,D_E,D_S
staf1021	equ	$
;
STAF103		EQU	$
		BYTE	009H,staf1031-staf1030-1
staf1030	equ	$
		WORD	U_4,SPA
		WORD	U_V,UTN,SPA,U_B,U_A,U_N,U_D,U_I,U_T,U_S
staf1031	equ	$
;
STAF104		EQU	$
		BYTE	003H,staf1041-staf1040-1
staf1040	equ	$
		WORD	R_N,R_I,R_V,R_E,R_A,R_U
		WORD	D_4,SPA
		WORD	D_V,DTN,SPA,D_B,D_A,D_N,D_D,D_I,D_T,D_S
staf1041	equ	$
;
STAF105		EQU	$
		BYTE	009H,staf1051-staf1050-1
staf1050	equ	$
		WORD	U_5,SPA
		WORD	U_P,UTN,SPA,U_D,U_E,SPA,U_G,U_L,U_A,U_C,U_E
staf1051	equ	$
;
STAF106		EQU	$
		BYTE	003H,staf1061-staf1060-1
staf1060	equ	$
		WORD	R_N,R_I,R_V,R_E,R_A,R_U
		WORD	D_5,SPA
		WORD	D_P,DTN,SPA,D_D,D_E,SPA,D_G,D_L,D_A,D_C,D_E
staf1061	equ	$
;
STAF107		EQU	$
		BYTE	009H,staf1071-staf1070-1
staf1070	equ	$
		WORD	U_6,SPA
		WORD	U_B,UTN,SPA,U_S,U_O,U_U,U_F,U_F,U_R,U_A,U_N,U_C,U_E
staf1071	equ	$
;
STAF108		EQU	$
		BYTE	003H,staf1081-staf1080-1
staf1080	equ	$
		WORD	R_N,R_I,R_V,R_E,R_A,R_U
		WORD	D_6,SPA
		WORD	D_B,DTN,SPA,D_S,D_O,D_U,D_F,D_F,D_R,D_A,D_N,D_C,D_E
staf1081	equ	$
;
STAF109		EQU	$
		BYTE	009H,staf1091-staf1090-1
staf1090	equ	$
		WORD	U_7,SPA
		WORD	U_R,UTN,SPA,U_T,U_O,U_R,U_T,U_U,U_E
staf1091	equ	$
;
STAF110		EQU	$
		BYTE	003H,staf11001-staf1100-1
staf1100	equ	$
		WORD	R_N,R_I,R_V,R_E,R_A,R_U
		WORD	D_7,SPA
		WORD	D_R,DTN,SPA,D_T,D_O,D_R,D_T,D_U,D_E
staf11001	equ	$
;
STAF111		EQU	$
		BYTE	009H,staf1111-staf1110-1
staf1110	equ	$
		WORD	U_8,SPA
		WORD	U_T,U_O,U_U,U_R,SPA,U_D,U_E,SPA
		WORD	U_G,U_A,U_N,U_O,U_N
staf1111	equ	$
;
STAF112		EQU	$
		BYTE	003H,staf1121-staf1120-1
staf1120	equ	$
		WORD	R_N,R_I,R_V,R_E,R_A,R_U
		WORD	D_8,SPA
		WORD	D_T,D_O,D_U,D_R,SPA,D_D,D_E,SPA
		WORD	D_G,D_A,D_N,D_O,D_N
staf1121	equ	$
;
STAF113		EQU	$
		BYTE	006H,staf1131-staf1130-1
staf1130	equ	$
		WORD	U_T,U_O,U_T,U_A,U_L,SPA
		WORD	U_J,U_E,U_U,U_X
staf1131	equ	$
;
STAF114		EQU	$
		BYTE	006H,staf1141-staf1140-1
staf1140	equ	$
		WORD	D_T,D_O,D_T,D_A,D_L,SPA
		WORD	D_J,D_E,D_U,D_X
staf1141	equ	$
;
STAF115		EQU	$
		BYTE	008H,16*2-1
		WORD	U_Y,U_A,U_S,U_U,U_N,U_A,U_R,U_I,SPA
		WORD	U_N,U_I,U_S,U_H,U_I,U_D,U_A
;
STAF116		EQU	$
		BYTE	008H,16*2-1
		WORD	D_Y,D_A,D_S,D_U,D_N,D_A,D_R,D_I,SPA
		WORD	D_N,D_I,D_S,D_H,D_I,D_D,D_A
;
STAF117		EQU	$
		BYTE	006H,staf1171-staf1170-1
staf1170	equ	$
		WORD	E_A,E_D,E_A,E_P,E_T,E_A,E_T,E_I,E_O,E_N,SPA
		WORD	E_F,E_R,E_A,E_N,E_C,E_A,E_I,E_S,E_E
staf1171	equ	$
;
STAF118		EQU	$
		BYTE	008H,staf1181-staf1180-1
staf1180	equ	$
		WORD	U_T,U_A,U_K,U_E,U_S,U_H,U_I,SPA
		WORD	U_Y,U_A,U_S,U_U,U_K,U_A,U_W,U_A
staf1181	equ	$
;
STAF119		EQU	$
		BYTE	008H,staf1191-staf1190-1
staf1190	equ	$
		WORD	D_T,D_A,D_K,D_E,D_S,D_H,D_I,SPA
		WORD	D_Y,D_A,D_S,D_U,D_K,D_A,D_W,D_A
staf1191	equ	$
;
STAF120		EQU	$
		BYTE	008H,16*2-1
		WORD	U_S,U_Y,U_L,U_V,U_I,U_E,SPA
		WORD	U_B,U_O,U_M,U_S,U_T,U_E,U_I,U_N
;
STAF121		EQU	$
		BYTE	008H,16*2-1
		WORD	D_S,D_Y,D_L,D_V,D_I,D_E,SPA
		WORD	D_B,D_O,D_M,D_S,D_T,D_E,D_I,D_N
;
;
MESSEGD		EQU	$
		WORD	STAF000-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
;
		WORD	STAF002-STAF000
		WORD	STAF003-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
;
		WORD	STAF004-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
;
		WORD	STAF005-STAF000
		WORD	STAF006-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
;
		WORD	STAF007-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
;
		WORD	STAF008-STAF000
		WORD	STAF009-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
;
		WORD	STAF010-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
;
		WORD	STAF011-STAF000
		WORD	STAF012-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
;
		WORD	STAF013-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
;
		WORD	STAF014-STAF000
		WORD	STAF015-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
;
		WORD	STAF016-STAF000
		WORD	STAF017-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
;
		WORD	STAF018-STAF000
		WORD	STAF001-STAF000
;
		WORD	STAF019-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
;
		WORD	STAF020-STAF000
		WORD	STAF021-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
;
		WORD	STAF022-STAF000
		WORD	STAF023-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
;
		WORD	STAF024-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
;
		WORD	STAF025-STAF000
		WORD	STAF026-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
;
		WORD	STAF027-STAF000
		WORD	STAF028-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
;
		WORD	STAF029-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
;
		WORD	STAF030-STAF000
		WORD	STAF031-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
;
		WORD	STAF032-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
;
		WORD	STAF033-STAF000
		WORD	STAF034-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
;
		WORD	STAF084-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
;
		WORD	STAF035-STAF000
		WORD	STAF036-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
;
		WORD	STAF037-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
;
		WORD	STAF038-STAF000
		WORD	STAF039-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
;
		WORD	STAF040-STAF000
		WORD	STAF041-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
;
		WORD	STAF042-STAF000
		WORD	STAF043-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
;
		WORD	STAF044-STAF000
		WORD	STAF045-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
;
		WORD	STAF046-STAF000
		WORD	STAF047-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
;
		WORD	STAF085-STAF000
		WORD	STAF086-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
;
		WORD	STAF087-STAF000
		WORD	STAF088-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
;
		WORD	STAF115-STAF000
		WORD	STAF116-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
;
		WORD	STAF048-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
;
		WORD	STAF049-STAF000
		WORD	STAF050-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
;
		WORD	STAF051-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
;
		WORD	STAF052-STAF000
		WORD	STAF053-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
;
		WORD	STAF054-STAF000
		WORD	STAF055-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
;
		WORD	STAF056-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
;
		WORD	STAF057-STAF000
		WORD	STAF058-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
;
;;;;		WORD	STAF059-STAF000
;;;;		WORD	STAF060-STAF000
;;;;		WORD	STAF001-STAF000
;;;;		WORD	STAF001-STAF000
;;;;;
		WORD	STAF061-STAF000
		WORD	STAF062-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
;
		WORD	STAF063-STAF000
		WORD	STAF064-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
;
		WORD	STAF065-STAF000
		WORD	STAF066-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
;
		WORD	STAF067-STAF000
		WORD	STAF068-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
;
		WORD	STAF117-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
;
		WORD	STAF118-STAF000
		WORD	STAF119-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
;
		WORD	STAF120-STAF000
		WORD	STAF121-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
;
		WORD	STAF069-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
;
		WORD	STAF072-STAF000
		WORD	STAF073-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
;
		WORD	STAF076-STAF000
		WORD	STAF077-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
;
		WORD	STAF070-STAF000
		WORD	STAF071-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
;
		WORD	STAF074-STAF000
		WORD	STAF075-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
;
		WORD	STAF078-STAF000
		WORD	STAF079-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
;
		WORD	STAF080-STAF000
		WORD	STAF081-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
;
		WORD	STAF089-STAF000
		WORD	STAF090-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
;
		WORD	STAF091-STAF000
		WORD	STAF001-STAF000
;
TIMED00		EQU	$
		WORD	STAF001-STAF000
		WORD	STAF092-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
;
TIMED01		EQU	$
		WORD	STAF001-STAF000
		WORD	STAF093-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
;
TIMED02		EQU	$
		WORD	STAF001-STAF000
		WORD	STAF094-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
;
TIMED03		EQU	$
		WORD	STAF001-STAF000
		WORD	STAF095-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
;
TIMED04		EQU	$
		WORD	STAF001-STAF000
		WORD	STAF096-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
;
TIMED05		EQU	$
		WORD	STAF097-STAF000
		WORD	STAF098-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
;
TIMED06		EQU	$
		WORD	STAF099-STAF000
		WORD	STAF100-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
;
TIMED07		EQU	$
		WORD	STAF101-STAF000
		WORD	STAF102-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
;
TIMED08		EQU	$
		WORD	STAF103-STAF000
		WORD	STAF104-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
;
TIMED09		EQU	$
		WORD	STAF105-STAF000
		WORD	STAF106-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
;
TIMED10		EQU	$
		WORD	STAF107-STAF000
		WORD	STAF108-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
;
TIMED11		EQU	$
		WORD	STAF109-STAF000
		WORD	STAF110-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
;
TIMED12		EQU	$
		WORD	STAF111-STAF000
		WORD	STAF112-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
		WORD	STAF001-STAF000
;
TIMED13		EQU	$
		WORD	STAF113-STAF000
		WORD	STAF114-STAF000
TIMEDEN		EQU	$
;;;;		WORD	STAF001-STAF000
;;;;		WORD	STAF001-STAF000
;;;;		WORD	STAF001-STAF000
;;;;		WORD	STAF001-STAF000
;;;;;
;;;;;;;;		WORD	STAF082-STAF000
;;;;;;;;		WORD	STAF083-STAF000
;;;;		WORD	STAF001-STAF000
;;;;		WORD	STAF001-STAF000
;;;;		WORD	STAF001-STAF000
;;;;		WORD	STAF001-STAF000
;;;;		WORD	STAF001-STAF000
;;;;		WORD	STAF001-STAF000
;;;;		WORD	STAF001-STAF000
;;;;		WORD	STAF001-STAF000
;;;;		WORD	STAF001-STAF000
;;;;		WORD	STAF001-STAF000
;;;;		WORD	STAF001-STAF000
;;;;		WORD	STAF001-STAF000
;;;;		WORD	STAF001-STAF000
;;;;		WORD	STAF001-STAF000
;;;;		WORD	STAF001-STAF000
;;;;		WORD	STAF001-STAF000
;;;;		WORD	STAF001-STAF000
;
;
STFE		EQU	TIMEDEN-MESSEGD
;
TIMERDT		EQU	$
		WORD	TIMED00-MESSEGD
		WORD	TIMED01-MESSEGD
		WORD	TIMED02-MESSEGD
		WORD	TIMED03-MESSEGD
		WORD	TIMED04-MESSEGD
		WORD	TIMED05-MESSEGD
		WORD	TIMED06-MESSEGD
		WORD	TIMED07-MESSEGD
		WORD	TIMED08-MESSEGD
		WORD	TIMED09-MESSEGD
		WORD	TIMED10-MESSEGD
		WORD	TIMED11-MESSEGD
		WORD	TIMED12-MESSEGD
TIMEREN		WORD	TIMED13-MESSEGD
;
;
TMCNT		EQU	TIMEREN-TIMERDT
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		JSL	STAFINT	( staff roll init. sub )		x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
		MEM8
		IDX8
;
STAFINT		EQU	$
		JSL	>BLANKING	; blanking on & H-DMA disable
;// 03.09.17 //		LDA	#080H
;// 03.09.17 //		STA	!2100H
;// 03.09.17 //		STA	<BLKFLG		; blanking flag set
;
		JSL	>VRAMCL2	; V-RAM clear sub
;
;// 03.10.21 //		JSL	>MSGETNP	; message chara. buffer set
;
		JSL	>ENDGVRMS	; ending character set
;
		JSL	>EIT800		; BG.1 set
;
		JSL	>PLGNED2	; tryforse init.
		LDA	#080H
		STA	<BLKFLG
;
		LDA	#002H
		STA	!CGSTPT+1
		LDA	#001H
		STA	!BG3BGC
		JSL	>B3CGSET	; BG.3 CG. set
		INC	<CGVMAF
;
		MEM16
		REP	#00100000B
;
		LDA	#00000
		STA	>DIECT08
		LDA	>DIECONT
		CLC
		ADC	>DIECT1A
		STA	>DIECT1A
		LDX	#TMCNT-2
;
SFI050		EQU	$
		CLC
		ADC	>DIECT00,X
		STA	>DIETOTAL	; total games counter set
		DEX
		DEX	
		BPL	SFI050
;
		LDA	#00000
		STA	>DIECONT
;
		MEM8
		SEP	#00100000B
;
		LDA	>LFITCT
		LSR	A
		LSR	A
		LSR	A
		TAX
		LDA	>GOVHRTD,X
		STA	>LFNWCT		; life reset
		LDA	#01000000B
		STA	>GDTRPF
		JSL	>DTSAVE		; data save
;
		MEM16
		REP	#00100000B
;
;;92.7.2;;		LDA	#003H
;;92.7.2;;		STA	<HWORK0
;;92.7.2;;		STZ	<HWORK4
;;92.7.2;;;
		LDA	#00000H
		STA	>CGRAM+4CH
		STA	>CGWORK+4CH
		LDA	#00000H
		STA	>CGRAM+000H
		STA	>CGWORK+000H
;
		LDA	#00016H
		STA	<DPMAIN
;
		LDA	#07C00H
		STA	<CWORK0
		STZ	<CWORK2
		STZ	<CWORK4
;
		LDA	#03084H
		STA	>CGWORK+03AH
;
		LDA	#0FFB8H
		STA	<SCCV2
		LDA	#00090H
		STA	<SCCH2
;
		STZ	<SCCV3
		STZ	<SCCH3
		JSR	STAFSET
;
		MEM8
		SEP	#00100000B
;
		LDA	#022H
		STA	!SOUND0		; <sound0>
;
		STZ	<WD2130
		LDA	#10100010B
		STA	<WD2131
;
		LDA	#00010010B
		STA	2108H
;
		LDA	#03FH
		STA	<WD2132R
		LDA	#05FH
		STA	<WD2132G
		LDA	#09FH
		STA	<WD2132B
		LDA	#040H
		STA	<JRSBPT		; counter set
;
;;;;		INC	<GAMEMD
		STZ	<BLKFLG
;
;****************************************************************
;*	H-DMA intial						*
;****************************************************************
;
INHDMA	EQU	$
	LDX	#04
IHD010	EQU	$
	LDA	>HDMAP0,X
	STA	4370H,X
	DEX
	BPL	IHD010
	STZ	4377H		;data bank set
	LDA	#10000000B	;H-DMA "ON"
	STA	<WD420C
;	
		BRL	SMEEND
;
;====== H-DMA parameter data ===================================
HDMAP0	EQU	$
	BYTE	01000010B	;DMA control parameter
	BYTE	0FH		;    B bus address
	BYTE	LOW  HDMADR0	;    A     "      (L)
	BYTE	HIGH HDMADR0	;          "      (H)
	BYTE	BANK HDMADR0	;          "      (B)
;
HDMADR0	EQU	$
	BYTE	00H+52H
	WORD	ESCCH0
	BYTE	00H+08H
	WORD	SCCH2
	BYTE	00H+08H
	WORD	ESCCH1
	BYTE	00H+05H
	WORD	ESCCH2
	BYTE	00H+10H
	WORD	ESCCH3
	BYTE	80H+01H
	WORD	SCCH2
	BYTE	00H
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		JSR	RGBCHEG	( R.G.B. data chenge sub )		x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
RGBCHNG		EQU	$
		DEC	<JRSBPT
		BNE	RCGEND
;
		LDA	#010H
		STA	<JRSBPT
;
		LDA	<WD2132R
		CMP	#020H
		BEQ	RCG050
;
		DEC	<WD2132R
		BRA	RCGEND
;
RCG050		EQU	$
		LDA	<WD2132G
		CMP	#040H
		BEQ	RCG100
;
		DEC	<WD2132G
		BRA	RCGEND
;
RCG100		EQU	$
		LDA	<WD2132B
		CMP	#080H
		BEQ	RCGEND
;
		DEC	<WD2132B
;
RCGEND		EQU	$
		RTS
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		JSR	SCRMOVE	( scroll move sub )			x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
SCRMOVE		EQU	$
		JSR	RGBCHNG
;
		LDA	#001H
		STA	!GMAPDF
;
		MEM8
		IDX8
		SEP	#00110000B
;
		JSL	>TRYFS20		; tryforse move
;
		MEM16
		IDX16
		REP	#00110000B
;
;;92.7.2;;		DEC	<HWORK0
;;92.7.2;;		LDA	<HWORK0
;;92.7.2;;		BNE	SMEEND
;;92.7.2;;;
;;92.7.2;;		LDY	#00003H
;;92.7.2;;		INC	<HWORK4
;;92.7.2;;		LDA	<HWORK4
;;92.7.2;;		CMP	#00003H
;;92.7.2;;		BNE	SME010
;;92.7.2;;;
;;92.7.2;;		STZ	<HWORK4
;;92.7.2;;		LDY	#00004H
;;92.7.2;;;
;;92.7.2;;SME010		EQU	$
;;92.7.2;;		STY	<HWORK0
		LDA	<FRCNT
		AND	#00000011B
		BNE	SMEEND
;
		INC	<SCCH2
		LDA	<SCCH2
;
		CMP	#0C00H
		BNE	SME0FF		;sun start ? ( no:SME0FF )
		LDY	#00010011B*0100H
		STY	2107H
SME0FF		EQU	$
;
		LSR	A
		STA	!ESCCH2
		CLC
		ADC	<SCCH2
		STA	!ESCCH0
		LSR	A
		STA	!ESCCH1
		LDA	!ESCCH2
		LSR	A
		STA	!ESCCH3
;;;;		LDA	<SCCH2
;;;;		LSR	A
;;;;		CLC
;;;;		ADC	<SCCH2
;;;;		STA	!ESCCH0
;;;;		LSR	A
;;;;		STA	!ESCCH1
;;;;		LSR	A
;;;;		STA	!ESCCH2
;;;;;
;;;;		LDA	<FRCNT
;;;;		AND	#0001FH
;;;;		BNE	SME000
;;;;;
;;;;		DEC	!ESCCH3
;;;;;
;;;;SME000		EQU	$
		LDA	<SCCV3
		CMP	#00CD8H
		BNE	SME050		; end ?
;					; Yes!
		LDA	#080H
		STA	<CWORK0		; timer set
		INC	<GAMEMD
		BRA	SMEEND
;
SME050		EQU	$
		CLC
		ADC	#00001H
		STA	<SCCV3		; BG_3 scroll inc .
		TAY
		AND	#00007H
		BNE	SMEEND		; staff roll write ?
;					; Yes!
		TYA
		LSR	A
		LSR	A
		LSR	A
		STA	<CWORK2
;
		JSR	STAFSET
;
SMEEND		EQU	$
		MEM16
		REP	#00100000B	; memory 16bit mode
;
		LDA	<SCCH2
		STA	!SSCCH2
		LDA	<SCCV2
		STA	!SSCCV2
;
		LDA	<SCCH1
		STA	!SSCCH1
		LDA	<SCCV1
		STA	!SSCCV1
;
		MEM8
		IDX8
		SEP	#00110000B
;
		RTS
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;		JSR	STAFSET	( staff data V-ram set sub )		x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
CHRDATA		EQU	$
		WORD	U_0,D_0
;;;;		WORD	03CE6H,03CF6H
;
RAMADRS		EQU	$
		WORD	00002H,00000H,00004H,00006H,00014H,0000CH
		WORD	0000AH,00010H,00016H,00012H,0000EH,00018H
		WORD	0001AH,0001EH
;
STAFSET		EQU	$
		PHB
		PHK
		PLB
;
		MEM16
		IDX16
		REP	#00110000B
;
		LDX	!VRAMD
		LDA	<CWORK0
		XBA
		STA	!VRAMD+2,X
;
		LDA	#03E40H
		STA	!VRAMD+4,X
;
		LDA	#SPA
		STA	!VRAMD+6,X
;
		TXA
		CLC
		ADC	#00006H
		TAX
;
		LDA	<CWORK2
		ASL	A
		TAY
		CPY	#STFE
		BCC	SFT000
;
		BRL	SFT400
;
SFT000		EQU	$
		LDA	!MESSEGD,Y
		TAY
;
		LDA	!STAF000,Y
		AND	#000FFH
		CMP	#000FFH
		BEQ	SFT100
;
		CLC
		ADC	<CWORK0
		XBA
		STA	!VRAMD+2,X
		INY
		LDA	!STAF000,Y
		AND	#000FFH
		XBA
		STA	!VRAMD+4,X
		XBA
		INC	A
		LSR	A
		STA	<WORK2
		INY
;;;;		STY	<WORK0
;
SFT050		EQU	$
;;;;		LDY	<WORK0
		LDA	!STAF000,Y
;;;;		AND	#000FFH
;;;;		ASL	A
;;;;		TAY
;;;;		LDA	!POINTDT,Y
		STA	!VRAMD+6,X
;;;;		INC	<WORK0
		INY
		INY
		INX
		INX
		DEC	<WORK2
		BNE	SFT050
;
		INX
		INX
		INX
		INX
;
SFT100		EQU	$
		LDA	<CWORK4
		AND	#00001H
		TAY
		BNE	SFT150
;
		LDA	<CWORK4
		AND	#000FEH
		TAY	
		LDA	<CWORK2
		ASL	A
		CMP	!TIMERDT,Y
		BNE	SFT400
;
SFT150		EQU	$
		TYA
		AND	#00001H
		ASL	A
		TAY
		LDA	!CHRDATA,Y
		STA	<CWORK6
;
		LDA	<CWORK0
		CLC
		ADC	#00019H
		XBA
		STA	!VRAMD+2,X
		LDA	#00500H
		STA	!VRAMD+4,X
;
		PHX
		LDA	<CWORK4
		LSR	A
		ASL	A
		TAX
		LDA	!RAMADRS,X
		TAX
		LDA	>DIECT00,X
;;;;		TAY
;;;;		LDA	<CWORK4
;;;;		AND	#00001H
;;;;		BNE	SFT160
;;;;;
;;;;		CPX	#TMCNT
;;;;		BCS	SFT160
;;;;;
;;;;		TYA
;;;;		CLC
;;;;		ADC	>DIECONT
;;;;		STA	>DIECONT
;;;;;
;;;;SFT160		EQU	$
;;;;		TYA
		PLX
		CMP	#01000
		BCC	SFT190
;
		LDA	#00009H
		CLC
		ADC	<CWORK6
;; SFX 04.05.07 ::		STA	!VRAMD+6,X
		STA	!VRAMD+8,X
		STA	!VRAMD+10,X
;; SFX 04.05.07 ::		BRA	SFT370
		BRA	SFT360
;
SFT190		EQU	$
		LDY	#00000H
;
SFT200		EQU	$
		CMP	#00010
		BMI	SFT250
;
		SEC
		SBC	#00010
		INY
		BRA	SFT200
;
SFT250		EQU	$
;; SFX 04.05.07 ::		CLC
;; SFX 04.05.07 ::		ADC	<CWORK6
		JSR	SUJICHK
		STA	!VRAMD+10,X
		TYA
		LDY	#00000H
;
SFT300		EQU	$
		CMP	#00010
		BMI	SFT350
;
		SEC
		SBC	#00010
		INY
		BRA	SFT300
;
SFT350		EQU	$
;; SFX 04.05.07 ::		CLC
;; SFX 04.05.07 ::		ADC	<CWORK6
		JSR	SUJICHK
		STA	!VRAMD+8,X
;
		TYA
;; SFX 04.05.07 ::		CLC
;; SFX 04.05.07 ::		ADC	<CWORK6
		JSR	SUJICHK
SFT360		EQU	$
		STA	!VRAMD+6,X
SFT370		EQU	$
		INC	<CWORK4
		TXA
		CLC
		ADC	#00010
		TAX
;
SFT400		EQU	$
		STX	!VRAMD
;
		LDA	<CWORK0
		CLC
		ADC	#00020H
		TAY
		AND	#003FFH
		BNE	SFTEND
;
		LDA	<CWORK0
		AND	#07C00H
		EOR	#00400H
		TAY
;
SFTEND		EQU	$
		STY	<CWORK0
;
		MEM8
		IDX8
		SEP	#00110000B
;
		LDA	#0FFH
		STA	!VRAMD+2,X
		LDA	#VT01
		STA	<VRFLG
;
		PLB
		RTS
;
;
		MEM16
;
SUJICHK		EQU	$
		CLC
		ADC	<CWORK6
		CMP	#U_1
		BNE	SUJIC40		; 1 ?
;					; yes
		LDA	#UZ1
		RTS
;
SUJIC40		EQU	$
		CMP	#D_1
		BNE	SUJIC80		; 1 ?
;					; yes
		LDA	#DZ1
SUJIC80		EQU	$
		RTS
;
		MEM8
;
;
;
;-------------- messege data --------------------------------------------
MEGED00		EQU	$
		BYTE	07AH,068H,000H,mege001-mege000-1
mege000
		WORD	E_L,E_E,SPA,E_R,E_E,E_T,E_O,E_U,E_R,SPA,E_D,E_U,SPA,E_R,E_O,E_I
mege001
;
		BYTE	07AH,0E8H,000H,mege003-mege002-1
mege002
		WORD	U_C,U_H,U_A,U_T,U_E,U_A,U_U,SPA,U_D,UAP,U_H,U_Y,U_R,U_U,U_L,U_E
mege003
		BYTE	07BH,008H,000H,mege003-mege002-1
		WORD	D_C,D_H,D_A,D_T,D_E,D_A,D_U,SPA,D_D,DAP,D_H,D_Y,D_R,D_U,D_L,D_E
;
;
MEGED01		EQU	$
		BYTE	07AH,064H,000H,mege011-mege010-1
mege010
		WORD	E_L,E_E,SPA,E_M,E_A,E_I,E_T,E_R,E_E,SPA,E_D,E_U,SPA
		WORD	E_S,E_A,E_N,E_C,E_T,E_U,E_A,E_I,E_R,E_E
mege011
;
		BYTE	07AH,0EBH,000H,mege013-mege012-1
mege012
		WORD	U_S,U_A,U_N,U_C,U_T,U_U,U_A,U_I,U_R,U_E
mege013
		BYTE	07BH,00BH,000,mege013-mege012-1
		WORD	D_S,D_A,D_N,D_C,D_T,D_U,D_A,D_I,D_R,D_E
;
;
MEGED02		EQU	$
		BYTE	07AH,067H,000H,mege021-mege020-1
mege020
		WORD	E_S,E_A,E_H,E_A,E_S,E_R,E_A,E_H,E_L,E_A,SPA,E_R,E_E,E_G,E_A,E_G,E_N,E_E
mege021
;
		BYTE	07AH,0AAH,000H,mege023-mege022-1
mege022
		WORD	E_S,E_E,E_S,SPA,E_P,E_E,E_N,E_A,E_T,E_E,E_S
mege023
;
		BYTE	07AH,0E6H,000H,mege025-mege024-1
mege024
		WORD	U_V,U_I,U_L,U_L,U_A,U_G,U_E,SPA,U_D,U_E,SPA
		WORD	U_C,U_O,U_C,U_O,U_R,U_I,U_C,U_O
mege025
		BYTE	07BH,006H,000H,mege025-mege024-1
		WORD	D_V,D_I,D_L,D_L,D_A,D_G,D_E,SPA,D_D,D_E,SPA
		WORD	D_C,D_O,D_C,D_O,D_R,D_I,D_C,D_O
;
;
MEGED03		EQU	$
		BYTE	07AH,065H,000H,mege031-mege030-1
mege030
		WORD	E_L,E_E,E_S,SPA,E_V,E_A,E_U,E_T,E_O,E_U,E_R,E_S,SPA
		WORD	E_D,E_U,SPA,E_D,E_E,E_S,E_E,E_R,E_T
mege031
;
		BYTE	07AH,0E8H,000H,mege033-mege032-1
mege032
		WORD	U_P,U_A,U_L,U_A,U_I,U_S,SPA,U_D,U_U,SPA
		WORD	U_D,U_E,U_S,U_E,U_R,U_T
mege033
		BYTE	07BH,008H,000H,mege033-mege032-1
		WORD	D_P,D_A,D_L,D_A,D_I,D_S,SPA,D_D,D_U,SPA
		WORD	D_D,D_E,D_S,D_E,D_R,D_T
;
;
MEGED04		EQU	$
		BYTE	07AH,065H,000H,mege041-mege040-1
mege040
		WORD	E_P,E_E,E_T,E_I,E_T,E_E,SPA,E_P,E_E,E_S,E_T,E_E,SPA
		WORD	E_A,SPA,E_U,E_N,SPA,E_A,E_M,E_I
mege041
;
		BYTE	07AH,0E6H,000H,mege043-mege042-1
mege042
		WORD	U_T,U_O,U_U,U_R,SPA,U_D,U_E,SPA,U_L,U_A,SPA
		WORD	U_M,U_O,U_N,U_T,U_A,U_G,U_N,U_E
mege043
		BYTE	07BH,006H,000H,mege043-mege042-1
		WORD	D_T,D_O,D_U,D_R,SPA,D_D,D_E,SPA,D_L,D_A,SPA
		WORD	D_M,D_O,D_N,D_T,D_A,D_G,D_N,D_E
;
;
MEGED05		EQU	$
		BYTE	07AH,065H,000H,mege051-mege050-1
mege050
		WORD	E_T,E_O,E_N,SPA,E_O,E_N,E_C,E_L,E_E,SPA
		WORD	E_C,E_O,E_N,E_V,E_A,E_L,E_E,E_S,E_C,E_E,E_N,E_T
mege051
;
		BYTE	07AH,0EBH,000H,mege053-mege052-1
mege052
		WORD	U_T,U_A,SPA,U_M,U_A,U_I,U_S,U_O,U_N
mege053
		BYTE	07BH,00BH,000H,mege053-mege052-1
		WORD	D_T,D_A,SPA,D_M,D_A,D_I,D_S,D_O,D_N
;
;
MEGED06		EQU	$
		BYTE	07AH,068H,000H,mege061-mege060-1
mege060		EQU	$
		WORD	E_P,E_A,E_L,E_M,E_E,E_S,SPA,E_A,SPA,E_V,E_E,E_N,E_D,E_R,E_E
mege061		EQU	$
;
		BYTE	07AH,0E8H,000H,mege063-mege062-1
mege062
		WORD	U_C,U_A,U_S,U_C,U_A,U_D,U_E,SPA,U_D,U_E,SPA,U_Z,U_O,U_R,U_A
mege063
		BYTE	07BH,008H,000H,mege063-mege062-1
		WORD	D_C,D_A,D_S,D_C,D_A,D_D,D_E,SPA,D_D,D_E,SPA,D_Z,D_O,D_R,D_A
;
;
MEGED07		EQU	$
		BYTE	07AH,064H,000H,mege071-mege070-1
mege070
		WORD	E_L,E_A,SPA,E_S,E_O,E_R,E_C,E_I,E_E,E_R,E_E,SPA,EA0,EA1,SPA
		WORD	E_L,EAP,E_A,E_P,E_P,E_R,E_E,E_N,E_T,E_I
mege071
;
		BYTE	07AH,0E8H,000H,mege073-mege072-1
mege072
		WORD	U_B,U_O,U_U,U_T,U_I,U_Q,U_U,U_E,SPA,U_M,U_A,U_G,U_I,U_Q,U_U,U_E
mege073
		BYTE	07BH,008H,000H,mege073-mege072-1
		WORD	D_B,D_O,D_U,D_T,D_I,D_Q,D_U,D_E,SPA,D_M,D_A,D_G,D_I,D_Q,D_U,D_E
;
;
MEGED08		EQU	$
		BYTE	07AH,065H,000H,mege081-mege080-1
mege080
		WORD	E_L,E_E,E_S,SPA,E_B,E_U,E_C,E_H,E_E,E_R,E_O,E_N,E_S,SPA,E_J,E_U,E_M,E_E,E_A,E_V,E_X
mege081
;
		BYTE	07AH,0E6H,000H,mege083-mege082-1
mege082
		WORD	U_C,U_A,U_B,U_A,U_N,U_E,SPA,U_D,U_E,U_S,SPA,U_B,U_U,U_C,U_H,U_E,U_R,U_O,U_N,U_S
mege083
		BYTE	07BH,006H,000H,mege083-mege082-1
		WORD	D_C,D_A,D_B,D_A,D_N,D_E,SPA,D_D,D_E,D_S,SPA,D_B,D_U,D_C,D_H,D_E,D_R,D_O,D_N,D_S
;
;
MEGED09		EQU	$
		BYTE	07AH,067H,000H,mege091-mege090-1
mege090
		WORD	E_L,E_E,SPA,E_F,E_L,E_U,E_T,E_I,E_S,E_T,E_E,SPA,E_R,E_E,E_J,E_O,E_U,E_E
mege091
;
		BYTE	07AH,0E9H,000H,mege093-mege092-1
mege092
		WORD	U_B,U_O,U_S,U_Q,U_U,U_E,U_T,SPA,U_H,U_A,U_N,U_T,U_E
mege093
		BYTE	07BH,009H,000H,mege093-mege092-1
		WORD	D_B,D_O,D_S,D_Q,D_U,D_E,D_T,SPA,D_H,D_A,D_N,D_T,D_E
;
;
MEGED10		EQU	$
		BYTE	07AH,066H,000H,mege101-mege100-1
mege100
		WORD	E_V,E_E,E_N,E_U,E_S,SPA,E_R,E_E,E_I,E_N,E_E,SPA
		WORD	E_D,E_E,E_S,SPA,E_F,E_E,E_E,E_S
mege101
;
		BYTE	07AH,0E8H,000H,mege103-mege102-1
mege102
		WORD	U_E,U_T,U_A,U_N,U_G,SPA,U_D,U_U,SPA,U_B,U_O,U_N,U_H,U_E,U_U,U_R
mege103
		BYTE	07BH,008H,000H,mege103-mege102-1
		WORD	D_E,D_T,D_A,D_N,D_G,SPA,D_D,D_U,SPA,D_B,D_O,D_N,D_H,D_E,D_U,D_R
;
;
MEGED11		EQU	$
		BYTE	07AH,066H,000H,mege111-mege110-1
mege110
		WORD	E_L,E_E,E_S,SPA,E_F,E_O,E_R,E_G,E_E,E_R,E_O,E_N,E_S,SPA
		WORD	E_N,E_A,E_I,E_N,E_S
mege111
;
		BYTE	07AH,0EDH,000H,mege113-mege112-1
mege112
		WORD	U_F,U_O,U_R,U_G,U_E
mege113
		BYTE	07BH,00DH,000H,mege113-mege112-1
		WORD	D_F,D_O,D_R,D_G,D_E
;
;
MEGED12		EQU	$
		BYTE	07AH,067H,000H,mege121-mege120-1
mege120
		WORD	E_L,E_E,SPA,E_C,E_H,E_A,E_S,E_S,E_E,E_U,E_R,SPA,E_D,E_E,EPI,EPI,EPI
mege121
;
		BYTE	07AH,0E6H,000H,mege123-mege122-1
mege122
		WORD	U_V,U_I,U_L,U_L,U_A,U_G,U_E,SPA,U_D,U_E,SPA
		WORD	U_C,U_O,U_C,U_O,U_R,U_I,U_C,U_O
mege123
		BYTE	07BH,006H,000H,mege123-mege122-1
		WORD	D_V,D_I,D_L,D_L,D_A,D_G,D_E,SPA,D_D,D_E,SPA
		WORD	D_C,D_O,D_C,D_O,D_R,D_I,D_C,D_O
;
;
MEGED13		EQU	$
		BYTE	07AH,045H,000H,mege131-mege130-1
mege130
		WORD	E_L,E_E,SPA,E_V,E_I,E_E,E_I,E_L,SPA
		WORD	E_H,E_O,E_M,E_M,E_E,SPA,E_P,E_E,E_R,E_D,E_U
mege131
;
		BYTE	07AH,0E6H,000H,mege133-mege132-1
mege132
		WORD	U_M,U_O,U_N,U_T,U_A,U_G,U_N,U_E,SPA
		WORD	U_D,U_E,SPA,U_L,U_A,SPA,U_M,U_O,U_R,U_T
mege133
		BYTE	07BH,006H,000H,mege133-mege132-1
		WORD	D_M,D_O,D_N,D_T,D_A,D_G,D_N,D_E,SPA
		WORD	D_D,D_E,SPA,D_L,D_A,SPA,D_M,D_O,D_R,D_T
;
;
MEGED14		EQU	$
		BYTE	07AH,065H,000H,mege141-mege140-1
mege140
		WORD	E_L,E_E,SPA,E_B,E_A,E_N,E_D,E_I,E_T,SPA,E_D,E_E,SPA,E_L,E_A,SPA
		WORD	E_F,E_O,E_R,E_E,E_T
mege141
;
		BYTE	07AH,0E8H,000H,mege143-mege142-1
mege142
		WORD	U_L,U_E,U_S,SPA,U_B,U_O,U_I,U_S,SPA,U_P,U_E,U_R,U_D,U_U,U_S
mege143
		BYTE	07BH,008H,000H,mege143-mege142-1
		WORD	D_L,D_E,D_S,SPA,D_B,D_O,D_I,D_S,SPA,D_P,D_E,D_R,D_D,D_U,D_S
;
;
MEGED15		EQU	$
		BYTE	07AH,06BH,000H,mege151-mege150-1
mege150
		WORD	E_E,E_X,E_C,E_A,E_L,E_I,E_B,E_U,E_R
mege151
;
		BYTE	07AH,0A8H,000H,mege153-mege152-1
mege152
		WORD	G_R,G_E,G_P,G_O,G_S,G_E,SPA
		WORD	G_A,SPA,G_N,G_O,G_U,G_V,G_E,G_A,G_U
mege153
;
		BYTE	07AH,0E9H,000H,mege155-mege154-1
mege154
		WORD	U_P,U_O,U_U,U_R,SPA,U_T,U_O,U_U,U_J,U_O,U_U,U_R,U_S,SPA,UBK
mege155
		BYTE	07BH,009H,000H,mege155-mege154-1
		WORD	D_P,D_O,D_U,D_R,SPA,D_T,D_O,D_U,D_J,D_O,D_U,D_R,D_S,SPA,DBK
;
;
;;;;		HEX	062,044,000,02D
;;;;		WORD	E_T,E_H,E_U,E_S,SPA
;;;;		WORD	E_P,E_E,E_A,E_C,E_E,SPA
;;;;		WORD	E_H,E_A,E_S,SPA
;;;;		WORD	E_R,E_E,E_T,E_U,E_R,E_N,E_E,E_D
;;;;;
;;;;		HEX	062,08B,000,011
;;;;		WORD	G_T,G_O,SPA
;;;;		WORD	G_H,G_Y,G_R,G_U,G_L,G_E
;;;;;
;;;;		HEX	062,0E5,000,029
;;;;		WORD	U_T,U_H,U_A,U_N,U_K,SPA
;;;;		WORD	U_Y,U_O,U_U,SPA
;;;;		WORD	U_F,U_O,U_R,SPA
;;;;		WORD	U_P,U_L,U_A,U_Y,U_I,U_N,U_G
;;;;		HEX	063,005,000,029
;;;;		WORD	D_T,D_H,D_A,D_N,D_K,SPA
;;;;		WORD	D_Y,D_O,D_U,SPA
;;;;		WORD	D_F,D_O,D_R,SPA
;;;;		WORD	D_P,D_L,D_A,D_Y,D_I,D_N,D_G
;;;;;
MEGEDEN		EQU	$
;
;
MEGEADR		EQU	$
		WORD	MEGED00-MEGED00
		WORD	MEGED01-MEGED00
		WORD	MEGED02-MEGED00
		WORD	MEGED03-MEGED00
		WORD	MEGED04-MEGED00
		WORD	MEGED05-MEGED00
		WORD	MEGED06-MEGED00
		WORD	MEGED07-MEGED00
		WORD	MEGED08-MEGED00
		WORD	MEGED09-MEGED00
		WORD	MEGED10-MEGED00
		WORD	MEGED11-MEGED00
		WORD	MEGED12-MEGED00
		WORD	MEGED13-MEGED00
		WORD	MEGED14-MEGED00
		WORD	MEGED15-MEGED00
		WORD	MEGEDEN-MEGED00
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		JSR	MEGESET	( mesege data set sub )			x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
MEGESET		EQU	$
		PHB
		PHK
		PLB
;
		MEM16
		IDX16
		REP	#00110000B
;
		LDA	#00078H
		STA	!VRAMD+2
		LDA	#0FE47H
		STA	!VRAMD+4
		LDA	#SPA
		STA	!VRAMD+6
;
		LDA	<GAMEMD
		AND	#000FEH
		TAY
		LDA	!MEGEADR+2,Y
		STA	<WORK4
		LDA	!MEGEADR,Y
		TAY
		LDX	#00000H
;
MET050		EQU	$
		LDA	!MEGED00,Y
		STA	!VRAMD+8,X
		INY
		INY
		INX
		INX
		LDA	!MEGED00,Y
		STA	!VRAMD+8,X
		XBA
		AND	#000FFH
		LSR	A
		STA	<WORK0
		INY
		INY
		INX
		INX
;;;;		STY	<WORK2
;
MET100		EQU	$
;;;;		LDY	<WORK2
		LDA	!MEGED00,Y
;;;;		AND	#000FFH
;;;;		ASL	A
;;;;		TAY
;;;;		LDA	!POINTDT,Y
		STA	!VRAMD+8,X
;;;;		INC	<WORK2
		INY
		INY
		INX
		INX
		DEC	<WORK0
		BPL	MET100
;
;;;;		LDY	<WORK2
		CPY	<WORK4
		BNE	MET050
;
		TXA
		CLC
		ADC	#00006H
		STA	!VRAMD
;
;
		MEM8
		IDX8
		SEP	#00110000B
;
		LDA	#0FFH
		STA	!VRAMD+8,X
		LDA	#VT01
		STA	<VRFLG
;
		PLB
		RTS
;
;
FAIDIN0	EQU	$
	LDA	<FRCNT
	AND	#00FH
	BNE	FAID080		; inc ? [ no:FAID080 ]
;
	INC	<BLKFLG
	LDA	<BLKFLG
	CMP	#0FH
	BNE	FAID080		; end ? [ no:FAID080 ]
;
	INC	<GAMEMD
FAID080	EQU	$
EDED080		EQU	$
	JSL	>TRYFS20
	RTS
;
;
;
ENDEND1		EQU	$
		DEC	<CWORK0
		BNE	EE1END
;
		MEM16
		REP	#00100000B
;
		STZ	!CCNGPT
		LDA	#00000H
		STA	>CCNGFG
		STA	>CCNGCT
		LDA	#0001FH
		STA	>CCNGED
;
		MEM8
		SEP	#00100000B
;
		INC	<GAMEMD
		LDA	#0C0H
		STA	<CWORK0
		STZ	<CWORK2
;
EE1END		EQU	$
		BRA	EDED080
;
;
ENDEND2		EQU	$		
		DEC	<CWORK0
		LDA	<CWORK2
		BNE	EE2050
;
		JSL	>CGCNG1
		LDA	>CCNGCT
		BNE	EE1END
;
		INC	<CWORK2
;
EE2050		EQU	$
		LDA	<CWORK0
		BNE	EE1END
;
;;92.7.2;;		LDA	#008H
;;92.7.2;;		STA	<HWORK2		; "THE END" color data set timer
;;92.7.2;;;
		INC	<GAMEMD
		JSL	>MGMCRS000
		RTS	
;
;
ENDEND3		EQU	$
;;;;		LDA	<FRCNT
;;92.7.2;;		DEC	<HWORK2
;;92.7.2;;		LDA	<HWORK2
;;92.7.2;;		BNE	EE3END
;;92.7.2;;;
;;92.7.2;;		LDA	#008H
;;92.7.2;;		STA	<HWORK2
		LDA	<FRCNT
		AND	#007H
		BNE	EE3END
;
		JSL	>MGMCGCNG
		LDA	>CCNGCT
		BNE	EE3END
;
		INC	<GAMEMD
;
EE3END		EQU	$
		JMP	ENDOBJS
;
;
OBJDATA		EQU	$
		WORD	0B8A0H,03B00H
		WORD	0B8B0H,03B02H
		WORD	0B8C0H,03B04H
		WORD	0B8D0H,03B06H
;
ENDOBJS		EQU	$
		MEM16
		REP	#00100000B
;
		LDX	#(ENDOBJS-OBJDATA)-2
;
EOS050		EQU	$
		LDA	>OBJDATA,X
		STA	!OAM,X
		DEX
		DEX
		BPL	EOS050
;
		MEM8
		SEP	#00100000B
;
		LDA	#002H
		STA	!OAMSB
		STA	!OAMSB+1
		STA	!OAMSB+2
		STA	!OAMSB+3
;
		RTS
;
;
ENDEND0		EQU	$
		BRA	ENDOBJS
;// 03.09.24 //		LDA	<KEYA2
;// 03.09.24 //		AND	#10010000B
;// 03.09.24 //		BEQ	ENDOBJS		; start on ?
;// 03.09.24 //;					; yes
;// 03.09.24 //		JSL	>BLANKING	; blanking on & H-DMA disable
;// 03.09.24 //		LDA	#0FFH
;// 03.09.24 //		STA	!IRQSWFG
;// 03.09.24 //		STZ	!POLYCFG
;// 03.09.24 //		STZ	!transfer_flag 
;// 03.09.24 //;// 03.09.17 //		LDA	#10000000B
;// 03.09.24 //;// 03.09.17 //		STA	2100H
;// 03.09.24 //;// 03.09.17 //		STA	<BLKFLG		; blanking on
;// 03.09.24 //;// 03.09.17 //		STZ	420CH
;// 03.09.24 //;// 03.09.17 //		STZ	<WD420C
;// 03.09.24 //;
;// 03.09.24 //		JSL	>MSGETNP	; message buffer set
;// 03.09.24 //;
;// 03.09.24 //		LDA	#010H
;// 03.09.24 //		STA	<DPMAIN
;// 03.09.24 //		STZ	<GMMODE
;// 03.09.24 //;
;// 03.09.24 //		JSL	>TILRETURN	; title return
;// 03.09.24 //;
;// 03.09.24 //		STZ	!RESTSFG
;// 03.09.24 //		STZ	!GOVRCFG
;// 03.09.24 //;
;// 03.09.24 //		SEI
;// 03.09.24 //		STZ	4200H		; NMI  disable
;// 03.09.24 //		STZ	420CH		; HDMA
;// 03.09.24 //;
;// 03.09.24 //		STZ	!SNDPCFG
;// 03.09.24 //		LDA	#0FFH
;// 03.09.24 //		STA	2140H
;// 03.09.24 //		JSL	>SNDTR1		; sound-0 set
;// 03.09.24 //;
;// 03.09.24 //		LDA	#10000001B
;// 03.09.24 //		STA	4200H		; NMI enable
;// 03.09.24 //;
;// 03.09.24 //		LDA	#00001111B
;// 03.09.24 //		STA	<BLKFLG
;// 03.09.24 //		RTS
;
;
;
;
;
;
;
;
;
		END
