#include <stdio.h>
#include <string.h>
#include <ctype.h>

#define HYOU 0x8000
#define GYOU 45

FILE *fpr0,*fpw0;
unsigned char FNAME[20],nmi[4],byte,nmno,adno;
unsigned char flg8_16; 	/* =0x00; lMX */
			/* =0x10; lMx */
			/* =0x20; lmX */	
			/* =0x30; lmx */
unsigned char mode816; 	/* =0x00; lMX */
			/* =0x10; lMx */
			/* =0x20; lmX */	
			/* =0x30; lmx */
unsigned char modem; 	/* =0x20; lm */
			/* =0x00; lM */
unsigned char modex; 	/* =0x10; lx */
			/* =0x00; lX */
unsigned char flgarea[100],*flgstak;
unsigned char data[HYOU];
unsigned long adrs,adrs1,adrs2,adrs3,svadrs,svadrs2,z;
int rt;

/****** mnemonic code ******/
static unsigned char mnecod[92][24]
			   ={{0x69,0x6d,0x6f,0x65,0x00,0x00,0x71,0x77 /* ADC */
			     ,0x61,0x75,0x00,0x7d,0x7f,0x79,0x00,0x00
			     ,0x00,0x72,0x67,0x00,0x00,0x63,0x73,0x00},
	
			     {0x29,0x2d,0x2f,0x25,0x00,0x00,0x31,0x37 /* AND */
			     ,0x21,0x35,0x00,0x3d,0x3f,0x39,0x00,0x00
			     ,0x00,0x32,0x27,0x00,0x00,0x23,0x33,0x00},

			     {0x00,0x0e,0x00,0x06,0x0a,0x00,0x00,0x00 /* ASL */
			     ,0x00,0x16,0x00,0x1e,0x00,0x00,0x00,0x00
			     ,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},

			     {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 /* BCC */
			     ,0x00,0x00,0x00,0x00,0x00,0x00,0x90,0x00
			     ,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},

			     {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 /* BCS */
			     ,0x00,0x00,0x00,0x00,0x00,0x00,0xb0,0x00
			     ,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},

			     {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 /* BEQ */
			     ,0x00,0x00,0x00,0x00,0x00,0x00,0xf0,0x00
			     ,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},

			     {0x89,0x2c,0x00,0x24,0x00,0x00,0x00,0x00 /* BIT */
			     ,0x00,0x34,0x00,0x3c,0x00,0x00,0x00,0x00
			     ,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},

			     {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 /* BMI */
			     ,0x00,0x00,0x00,0x00,0x00,0x00,0x30,0x00
			     ,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},

			     {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 /* BNE */
			     ,0x00,0x00,0x00,0x00,0x00,0x00,0xd0,0x00
			     ,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},

			     {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 /* BPL*/
			     ,0x00,0x00,0x00,0x00,0x00,0x00,0x10,0x00
			     ,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},

			     {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 /* BRA */
			     ,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x00
			     ,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},

			     {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 /* BRK */
			     ,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
			     ,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},

			     {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 /* BRL */
			     ,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x82
			     ,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},

			     {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 /* BVC */
			     ,0x00,0x00,0x00,0x00,0x00,0x00,0x50,0x00
			     ,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},

			     {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 /* BVS */
			     ,0x00,0x00,0x00,0x00,0x00,0x00,0x70,0x00
			     ,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},

			     {0x00,0x00,0x00,0x00,0x00,0x18,0x00,0x00 /* CLC */
			     ,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
			     ,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},

			     {0x00,0x00,0x00,0x00,0x00,0xd8,0x00,0x00 /* CLD */
			     ,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
			     ,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},

			     {0x00,0x00,0x00,0x00,0x00,0x58,0x00,0x00 /* CLI */
			     ,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
			     ,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},

			     {0x00,0x00,0x00,0x00,0x00,0xb8,0x00,0x00 /* CLV */
			     ,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
			     ,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},

			     {0xc9,0xcd,0xcf,0xc5,0x00,0x00,0xd1,0xd7 /* CMP */
			     ,0xc1,0xd5,0x00,0xdd,0xdf,0xd9,0x00,0x00
			     ,0x00,0xd2,0xc7,0x00,0x00,0xc3,0xd3,0x00},

			     {0x00,0x00,0x00,0x02,0x00,0x00,0x00,0x00 /* COP */
			     ,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
			     ,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},

			     {0xe0,0xec,0x00,0xe4,0x00,0x00,0x00,0x00 /* CPX */
			     ,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
			     ,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},

			     {0xc0,0xcc,0x00,0xc4,0x00,0x00,0x00,0x00 /* CPY */
			     ,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
			     ,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},

			     {0x00,0xce,0x00,0xc6,0x3a,0x00,0x00,0x00 /* DEC */
			     ,0x00,0xd6,0x00,0xde,0x00,0x00,0x00,0x00
			     ,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},

			     {0x00,0x00,0x00,0x00,0x00,0xca,0x00,0x00 /* DEX */
			     ,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
			     ,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},

			     {0x00,0x00,0x00,0x00,0x00,0x88,0x00,0x00 /* DEY */
			     ,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
			     ,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},

			     {0x49,0x4d,0x4f,0x45,0x00,0x00,0x51,0x57 /* EOR */
			     ,0x41,0x55,0x00,0x5d,0x5f,0x59,0x00,0x00
			     ,0x00,0x52,0x47,0x00,0x00,0x43,0x53,0x00},

			     {0x00,0xee,0x00,0xe6,0x1a,0x00,0x00,0x00 /* INC */
			     ,0x00,0xf6,0x00,0xfe,0x00,0x00,0x00,0x00
			     ,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},

			     {0x00,0x00,0x00,0x00,0x00,0xe8,0x00,0x00 /* INX */
			     ,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
			     ,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},

			     {0x00,0x00,0x00,0x00,0x00,0xc8,0x00,0x00 /* INY */
			     ,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
			     ,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},

			     {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 /* JML */
			     ,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
			     ,0xdc,0x00,0x00,0x00,0x00,0x00,0x00,0x00},

			     {0x00,0x4c,0x5c,0x00,0x00,0x00,0x00,0x00 /* JMP */
			     ,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
			     ,0x6c,0x00,0x00,0x7c,0x00,0x00,0x00,0x00},

			     {0x00,0x00,0x22,0x00,0x00,0x00,0x00,0x00 /* JSL */
			     ,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
			     ,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},

			     {0x00,0x20,0x00,0x00,0x00,0x00,0x00,0x00 /* JSR */
			     ,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
			     ,0x00,0x00,0x00,0xfc,0x00,0x00,0x00,0x00},

			     {0xa9,0xad,0xaf,0xa5,0x00,0x00,0xb1,0xb7 /* LDA */
			     ,0xa1,0xb5,0x00,0xbd,0xbf,0xb9,0x00,0x00
			     ,0x00,0xb2,0xa7,0x00,0x00,0xa3,0xb3,0x00},

			     {0xa2,0xae,0x00,0xa6,0x00,0x00,0x00,0x00 /* LDX */
			     ,0x00,0x00,0xb6,0x00,0x00,0xbe,0x00,0x00
			     ,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},

			     {0xa0,0xac,0x00,0xa4,0x00,0x00,0x00,0x00 /* LDY */
			     ,0x00,0xb4,0x00,0xbc,0x00,0x00,0x00,0x00
			     ,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},

			     {0x00,0x4e,0x00,0x46,0x4a,0x00,0x00,0x00 /* LSR */
			     ,0x00,0x56,0x00,0x5e,0x00,0x00,0x00,0x00
			     ,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},

			     {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 /* MVN */
			     ,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
			     ,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x54},

			     {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 /* MVP */
			     ,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
			     ,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x44},

			     {0x00,0x00,0x00,0x00,0x00,0xea,0x00,0x00 /* NOP */
			     ,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
			     ,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},

			     {0x09,0x0d,0x0f,0x05,0x00,0x00,0x11,0x17 /* ORA */
			     ,0x01,0x15,0x00,0x1d,0x1f,0x19,0x00,0x00
			     ,0x00,0x12,0x07,0x00,0x00,0x03,0x13,0x00},

			     {0xf4,0x00,0x00,0x00,0x00,0x00,0x00,0x00 /* PEA */
			     ,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
			     ,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},

			     {0xd4,0x00,0x00,0x00,0x00,0x00,0x00,0x00 /* PEI */
			     ,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
			     ,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},

			     {0x62,0x00,0x00,0x00,0x00,0x00,0x00,0x00 /* PER */
			     ,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
			     ,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},

			     {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 /* PHA */
			     ,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
			     ,0x00,0x00,0x00,0x00,0x48,0x00,0x00,0x00},

			     {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 /* PHB */
			     ,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
			     ,0x00,0x00,0x00,0x00,0x8B,0x00,0x00,0x00},

			     {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 /* PHD */
			     ,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
			     ,0x00,0x00,0x00,0x00,0x0B,0x00,0x00,0x00},

			     {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 /* PHK */
			     ,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
			     ,0x00,0x00,0x00,0x00,0x4b,0x00,0x00,0x00},

			     {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 /* PHP */
			     ,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
			     ,0x00,0x00,0x00,0x00,0x08,0x00,0x00,0x00},

			     {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 /* PHX */
			     ,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
			     ,0x00,0x00,0x00,0x00,0xda,0x00,0x00,0x00},

			     {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 /* PHY */
			     ,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
			     ,0x00,0x00,0x00,0x00,0x5a,0x00,0x00,0x00},

			     {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 /* PLA */
			     ,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
			     ,0x00,0x00,0x00,0x00,0x68,0x00,0x00,0x00},

			     {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 /* PLB */
			     ,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
			     ,0x00,0x00,0x00,0x00,0xab,0x00,0x00,0x00},

			     {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 /* PLD */
			     ,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
			     ,0x00,0x00,0x00,0x00,0x2b,0x00,0x00,0x00},

			     {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 /* PLP */
			     ,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
			     ,0x00,0x00,0x00,0x00,0x28,0x00,0x00,0x00},

			     {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 /* PLX */
			     ,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
			     ,0x00,0x00,0x00,0x00,0xfa,0x00,0x00,0x00},

			     {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 /* PLY */
			     ,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
			     ,0x00,0x00,0x00,0x00,0x7a,0x00,0x00,0x00},

			     {0xc2,0x00,0x00,0x00,0x00,0x00,0x00,0x00 /* REP */
			     ,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
			     ,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},

			     {0x00,0x2e,0x00,0x26,0x2a,0x00,0x00,0x00 /* ROL */
			     ,0x00,0x36,0x00,0x3e,0x00,0x00,0x00,0x00
			     ,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},

			     {0x00,0x6e,0x00,0x66,0x6a,0x00,0x00,0x00 /* ROR */
			     ,0x00,0x76,0x00,0x7e,0x00,0x00,0x00,0x00
			     ,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},

			     {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 /* RTI */
			     ,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
			     ,0x00,0x00,0x00,0x00,0x40,0x00,0x00,0x00},

			     {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 /* RTL */
			     ,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
			     ,0x00,0x00,0x00,0x00,0x6b,0x00,0x00,0x00},

			     {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 /* RTS */
			     ,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
			     ,0x00,0x00,0x00,0x00,0x60,0x00,0x00,0x00},

			     {0xe9,0xed,0xef,0xe5,0x00,0x00,0xf1,0xf7 /* SBC */
			     ,0xe1,0xf5,0x00,0xfd,0xff,0xf9,0x00,0x00
			     ,0x00,0xf2,0xe7,0x00,0x00,0xe3,0xf3,0x00},

			     {0x00,0x00,0x00,0x00,0x00,0x38,0x00,0x00 /* SEC */
			     ,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
			     ,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},

			     {0x00,0x00,0x00,0x00,0x00,0xf8,0x00,0x00 /* SED */
			     ,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
			     ,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},

			     {0x00,0x00,0x00,0x00,0x00,0x78,0x00,0x00 /* SEI */
			     ,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
			     ,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},

			     {0xe2,0x00,0x00,0x00,0x00,0x00,0x00,0x00 /* SEP */
			     ,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
			     ,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},

			     {0x00,0x8d,0x8f,0x85,0x00,0x00,0x91,0x97 /* STA */
			     ,0x81,0x95,0x00,0x9d,0x9f,0x99,0x00,0x00
			     ,0x00,0x92,0x87,0x00,0x00,0x83,0x93,0x00},

			     {0x00,0x00,0x00,0x00,0x00,0xdb,0x00,0x00 /* STP */
			     ,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
			     ,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},

			     {0x00,0x8e,0x00,0x86,0x00,0x00,0x00,0x00 /* STX */
			     ,0x00,0x00,0x96,0x00,0x00,0x00,0x00,0x00
			     ,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},

			     {0x00,0x8c,0x00,0x84,0x00,0x00,0x00,0x00 /* STY */
			     ,0x00,0x94,0x00,0x00,0x00,0x00,0x00,0x00
			     ,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},

			     {0x00,0x9c,0x00,0x64,0x00,0x00,0x00,0x00 /* STZ */
			     ,0x00,0x74,0x00,0x9e,0x00,0x00,0x00,0x00
			     ,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},

			     {0x00,0x00,0x00,0x00,0x00,0xaa,0x00,0x00 /* TAX */
			     ,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
			     ,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},

			     {0x00,0x00,0x00,0x00,0x00,0xa8,0x00,0x00 /* TAY */
			     ,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
			     ,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},

			     {0x00,0x00,0x00,0x00,0x00,0x5b,0x00,0x00 /* TCD */
			     ,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
			     ,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},

			     {0x00,0x00,0x00,0x00,0x00,0x1b,0x00,0x00 /* TCS */
			     ,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
			     ,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},

			     {0x00,0x00,0x00,0x00,0x00,0x7b,0x00,0x00 /* TDC */
			     ,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
			     ,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},

			     {0x00,0x1c,0x00,0x14,0x00,0x00,0x00,0x00 /* TRB */
			     ,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
			     ,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},

			     {0x00,0x0c,0x00,0x04,0x00,0x00,0x00,0x00 /* TSB */
			     ,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
			     ,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},

			     {0x00,0x00,0x00,0x00,0x00,0x3b,0x00,0x00 /* TSC */
			     ,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
			     ,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},

			     {0x00,0x00,0x00,0x00,0x00,0xba,0x00,0x00 /* TSX */
			     ,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
			     ,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},

			     {0x00,0x00,0x00,0x00,0x00,0x8a,0x00,0x00 /* TXA */
			     ,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
			     ,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},

			     {0x00,0x00,0x00,0x00,0x00,0x9a,0x00,0x00 /* TXS */
			     ,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
			     ,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},

			     {0x00,0x00,0x00,0x00,0x00,0x9b,0x00,0x00 /* TXY */
			     ,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
			     ,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},

			     {0x00,0x00,0x00,0x00,0x00,0x98,0x00,0x00 /* TYA */
			     ,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
			     ,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},

			     {0x00,0x00,0x00,0x00,0x00,0xbb,0x00,0x00 /* TYX */
			     ,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
			     ,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},

			     {0x00,0x00,0x00,0x00,0x00,0xcb,0x00,0x00 /* WAI */
			     ,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
			     ,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},

			     {0x00,0x00,0x00,0x00,0x00,0x42,0x00,0x00 /* WDM */
			     ,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
			     ,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},

			     {0x00,0x00,0x00,0x00,0x00,0xeb,0x00,0x00 /* XBA */
			     ,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
			     ,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},

			     {0x00,0x00,0x00,0x00,0x00,0xfb,0x00,0x00 /* XCE */
			     ,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
			     ,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}};

/****** number of byte ******/
static unsigned char mnebyt[24]
			    ={0xff,0x03,0x04,0x02,0x01,0x01,0x02,0x02
			     ,0x02,0x02,0x03,0x03,0x04,0x03,0x02,0x03
			     ,0x03,0x02,0x02,0x03,0x01,0x02,0x02,0x03};

static char *nimo[92]={"ADC","AND","ASL","BCC","BCS","BEQ","BIT","BMI",
		       "BNE","BPL","BRA","BRK","BRL","BVC","BVS","CLC",
		       "CLD","CLI","CLV","CMP","COP","CPX","CPY","DEC",
		       "DEX","DEY","EOR","INC","INX","INY","JML","JMP",
		       "JSL","JSR","LDA","LDX","LDY","LSR","MVN","MVP",
		       "NOP","ORA","PEA","PEI","PER","PHA","PHB","PHD",
		       "PHK","PHP","PHX","PHY","PLA","PLB","PLD","PLP",
		       "PLX","PLY","REP","ROL","ROR","RTI","RTL","RTS",
		       "SBC","SEC","SED","SEI","SEP","STA","STP","STX",
		       "STY","STZ","TAX","TAY","TCD","TCS","TDC","TRB",
		       "TSB","TSC","TSX","TXA","TXS","TXY","TYA","TYX",
		       "WAI","WDM","XBA","XCE"};

#define REP 	0xc2
#define SEP 	0xe2

#define PHP 	0x08
#define PLP 	0x28

/***************  SOUTAI ADDRESS  ***************/
#define BCC 	0x90
#define BCS 	0xB0
#define BEQ 	0xF0
#define BMI 	0x30
#define BNE 	0xD0
#define BPL 	0x10
#define BRA 	0x80
#define BRL 	0x82
#define BVC 	0x50
#define BVS 	0x70

/***************  CHOKUSETU ADDRESS  ***************/
#define JMP1	0x4C
#define JMP2	0x5C

/***************  SAB ADDRESS  ***************/
#define JSL 	0x22
#define JSR 	0x20

#define S_0	fprintf(fpw0,",S")
#define X_0	fprintf(fpw0,",X")
#define Y_0	fprintf(fpw0,",Y")
#define S_1	printf(",S")
#define X_1	printf(",X")
#define Y_1	printf(",Y")


main(argc,argv)
int argc;
char *argv[];
{
	flg8_16=0x30;
	modem=0x20;
	modex=0x10;
	adrs1=0x008000;
	svadrs=0x008000;
/*	adrs=0x008000;*/
	flgstak=flgarea;

	if(argc != 2){
		printf("Parameter error !!!\n");
		exit(1);
	}

	strcpy(FNAME,argv[1]);
	strcat(FNAME,".hex");
	filread();

	strcpy(FNAME,argv[1]);
	strcat(FNAME,".lis");

	sub();

	fclose(fpr0);
}

filread()	/*******  FILE READ OPEN  *******/
{
	unsigned long i;
/*	long j=16; */

	if((fpr0=fopen(FNAME,"rb")) == 0){
		printf("can't open 1 %s\n",FNAME);
		exit(1);
	}

/*	fseek(fpr0,j,0); */
	i=0;
	while(i<HYOU){
		data[i++]=fgetc(fpr0);
	}
}

filwopn()	/*******  FILE WRITE OPEN  *******/
{
	if((fpw0=fopen(FNAME,"at")) == 0){
		printf("can't open 2 %s\n",FNAME);
		exit(1);
	}

}


sub()
{
	int a,b,j;
	unsigned long ad;

	a=j=0;
	mode816=flg8_16;
	while(a==0){
		while((b=inputsub())==-1){}
		if(b==-2)  break;
		switch(b){
			case	 0 :
				adrs=adrs1;
				adrs2=adrs3;
				mode816=flg8_16&0x30;
				while(mnemonic()==0){
					printf("%02d>",j);
					pfilsub();
					j++;
					if(j>=GYOU){
						j=0;
						break;
					}
				}
				mode_dsp();
				break;
			case	 1 :
				filwopn();
				switch(rt){
					case	1 :
						nomal(&a);
						break;
					case	2 :
					case	3 :
					case	4 :
						fprintf(fpw0,";\n");
						dump_sv();
						fprintf(fpw0,";\n");
						break;
				}
				fclose(fpw0);
				printf("... %s  s a v eo k   ! ! !\n",FNAME);  
				break;
			case	 2 :
				dump_menu();
				break;
		}
		svadrs=adrs;
		svadrs2=adrs2;
	}
}

nomal(a)
int *a;
{
	unsigned long ad;

	printf("IAhX́H");
	printf("iO͉̎ʂ̂܂܁j---> ");
	scanf("%x",&adrs);
	ad=(adrs&0x7fff)|((adrs&0xff0000)>>1);
	if(adrs==0)	ad=adrs2;
	adrs=adrs1;
	adrs2=adrs3;
	while((adrs2<ad)&&(((*a)=mnemonic())==0))  filsub();
}

filsub()
{
	int i,j;

	fprintf(fpw0,"    %02X:",(adrs/0x10000));   
	fprintf(fpw0,"%04X   ",(adrs&0x0000ffff));   
	fprintf(fpw0,"%02X",nmi[0]);

	for(i=1;i<byte;i++)
		fprintf(fpw0,"%02X",nmi[i]);

	j=4-byte;
	while(j>0){
		fprintf(fpw0,"  ");
		j--;
	}

	fprintf(fpw0,"    %s   ",nimo[nmno]);

	adsub(adrs);

	if(nmno==61 || nmno==62	|| nmno==63){
		fprintf(fpw0,";\n");
	}

	adrs=adrs+byte;
	if((adrs&0x8000)==0){
		adrs=adrs+0x8000;
	}
}

adsub()
{
	int i;
	long a;

	switch(adno){
		case	 0 :
			fputc('#',fpw0);
		case	 1 :
		case	 2 :
		case	 3 :
			typeck();
			nmiprn();
		case	 5 :
			break;
		case	 4 :
			fprintf(fpw0,"A");
			break;
		case	 6 :
			fputc('(',fpw0);
			typeck();
			nmiprn();
			fputc(')',fpw0);
			Y_0;
			break;
		case	 7 :
			fputc('[',fpw0);
			typeck();
			nmiprn();
			fputc(']',fpw0);
			Y_0;
			break;
		case	 8 :
		case	19 :
			fputc('(',fpw0);
			typeck();
			nmiprn();
			X_0;
			fprintf(fpw0,")");
			break;
		case	 9 :
		case	11 :
		case	12 :
			typeck();
			nmiprn();
			X_0;
			break;
		case	10 :
		case	13 :
			typeck();
			nmiprn();
			Y_0;
			break;
		case	14 :
			a=(long)(adrs+(char)nmi[1])+2;
			fprintf(fpw0,"%03X",a);
			break;
		case	15 :
			a=(long)(adrs+(short)(nmi[1]+nmi[2]*0x100))+3;
			fprintf(fpw0,"%03X",a);
			break;
		case	16 :
		case	17 :
			fputc('(',fpw0);
			typeck();
			nmiprn();
			fprintf(fpw0,")");
			break;
		case	18 :
			fputc('[',fpw0);
			typeck();
			nmiprn();
			fprintf(fpw0,"]");
		case	20 :
			break;
		case	21 :
			typeck();
			nmiprn();
			S_0;
			break;
		case	22 :
			fputc('(',fpw0);
			typeck();
			nmiprn();
			S_0;
			fprintf(fpw0,")");
			Y_0;
			break;
		case	23 :
			fprintf(fpw0,"#%02X,%02X",nmi[1],nmi[2]);
			break;
	}
	fputc('\n',fpw0);
}

typeck()
{
	switch(adno){
		case	 1 :
		case	11 :
		case	13 :
		case	19 :
			fputc('!',fpw0);
			break;
		case	 2 :
		case	12 :
			fputc('>',fpw0);
			break;
		case	 3 :
		case	 6 :
		case	 7 :
		case	 8 :
		case	 9 :
		case	10 :
		case	17 :
		case	18 :
		case	21 :
		case	22 :
			fputc('<',fpw0);
		default :
			break;
	}
}

/*********************************************************************
*	CRT display 						     *
*********************************************************************/
pfilsub()
{
	int i,j;

	printf("    %02X:",(adrs/0x10000));   
	printf("%04X   ",(adrs&0x0000ffff));   
	printf("%02X",nmi[0]);

	for(i=1;i<byte;i++)
		printf("%02X",nmi[i]);

	j=4-byte;
	while(j>0){
		printf("  ");
		j--;
	}

	printf("    %s   ",nimo[nmno]);

	padsub(adrs);

	if(nmno==61 || nmno==62	|| nmno==63){
		printf(";\n");
	}

	adrs=adrs+byte;
	if((adrs&0x8000)==0){
		adrs=adrs+0x8000;
	}
}

padsub()
{
	int i;
	long a;

	switch(adno){
		case	 0 :
			printf("#");
		case	 1 :
		case	 2 :
		case	 3 :
			ptypeck();
			pnmiprn();
		case	 5 :
			break;
		case	 4 :
			printf("A");
			break;
		case	 6 :
			printf("(");
			ptypeck();
			pnmiprn();
			printf(")");
			Y_1;
			break;
		case	 7 :
			printf("[");
			ptypeck();
			pnmiprn();
			printf("]");
			Y_1;
			break;
		case	 8 :
		case	19 :
			printf("(");
			ptypeck();
			pnmiprn();
			X_1;
			printf(")");
			break;
		case	 9 :
		case	11 :
		case	12 :
			ptypeck();
			pnmiprn();
			X_1;
			break;
		case	10 :
		case	13 :
			ptypeck();
			pnmiprn();
			Y_1;
			break;
		case	14 :
			a=(long)(adrs+(char)nmi[1])+2;
			printf("%03X",a);
			break;
		case	15 :
			a=(long)(adrs+(short)(nmi[1]+nmi[2]*0x100))+3;
			printf("%03X",a);
			break;
		case	16 :
		case	17 :
			printf("(");
			ptypeck();
			pnmiprn();
			printf(")");
			break;
		case	18 :
			printf("[");
			ptypeck();
			pnmiprn();
			printf("]");
		case	20 :
			break;
		case	21 :
			ptypeck();
			pnmiprn();
			S_1;
			break;
		case	22 :
			printf("(");
			ptypeck();
			pnmiprn();
			S_1;
			printf(")");
			Y_1;
			break;
		case	23 :
			printf("#%02X,%02X",nmi[1],nmi[2]);
			break;
	}
	printf("\n");
}

ptypeck()
{
	switch(adno){
		case	 1 :
		case	11 :
		case	13 :
		case	19 :
			printf("!");
			break;
		case	 2 :
		case	12 :
			printf(">");
			break;
		case	 3 :
		case	 6 :
		case	 7 :
		case	 8 :
		case	 9 :
		case	10 :
		case	17 :
		case	18 :
		case	21 :
		case	22 :
			printf("<");
		default :
			break;
	}
}


/*********************************************************************
*	CRT display ( byte dump )				     *
*********************************************************************/
pdumpb()
{
	adrs3=adrs2;
	while(adrs3<=z && adrs3<HYOU){
		if(((adrs3-adrs2)&0x0f)==0x00){
			if(adrs3!=adrs2){
				printf("\n");
			}
			printf("    %02X:",(adrs/0x10000));   
			printf("%04X               HEX   ",(adrs&0x0ffff));
			printf("%02X",data[adrs3]);
		} 
		else{
			printf(",%02X",data[adrs3]);
		}
		adrs++;
		if((adrs&0x8000)==0){
			adrs=adrs+0x8000;
		}
		adrs3++;
	}
	printf("\n");
}

/*********************************************************************
*	CRT display ( word dump )				     *
*********************************************************************/
pdumpw()
{
	adrs3=adrs2;
	while(adrs3<=z && adrs3<HYOU){
		if(((adrs3-adrs2)&0x0f)==0x00){
			if(adrs3!=adrs2){
				printf("\n");
			}
			printf("    %02X:",(adrs/0x10000));   
			printf("%04X               WORD  ",(adrs&0x0ffff));
			printf("%02X",data[adrs3+1]);
		} 
		else{
			printf(",%02X",data[adrs3+1]);
		}
		printf("%02XH",data[adrs3]);

		adrs+=2;
		if((adrs&0x8000)==0){
			adrs=adrs+0x8000;
		}
		adrs3+=2;
	}
	printf("\n");
}

/*********************************************************************
*	CRT display ( long word dump )				     *
*********************************************************************/
pdumpl()
{
	adrs3=adrs2;
	while(adrs3<=z && adrs3<HYOU){
		if(((adrs3-adrs2)/18)*18==(adrs3-adrs2)){
			if(adrs3!=adrs2){
				printf("\n");
			}
			printf("    %02X:",(adrs/0x10000));   
			printf("%04X               LWORD ",(adrs&0x0ffff));
			printf("%02X",data[adrs3+2]);
		} 
		else{
			printf(",%02X",data[adrs3+2]);
		}
		printf("%02X",data[adrs3+1]);
		printf("%02XH",data[adrs3]);

		adrs+=3;
		if((adrs&0x8000)==0){
			adrs=adrs+0x8000;
		}
		adrs3+=3;
	}
	printf("\n");
}
/*********************************************************************
*	file write ( byte dump )				     *
*********************************************************************/
dumpb()
{
	unsigned long i;

	i=adrs2;
	while(i<=z && i<HYOU){
		if(((i-adrs2)&0x0f)==0x00){
			if(i!=adrs2){
				fprintf(fpw0,"\n");
			}
			fprintf(fpw0,"    %02X:",(adrs/0x10000));   
			fprintf(fpw0,"%04X               HEX   ",(adrs&0x0ffff));  			
			fprintf(fpw0,"%02X",data[i]);
		} 
		else{
			fprintf(fpw0,",%02X",data[i]);
		}
		adrs++;
		if((adrs&0x8000)==0){
			adrs=adrs+0x8000;
		}
		i++;
	}
	fprintf(fpw0,"\n");
}

/*********************************************************************
*	file write ( word dump )				     *
*********************************************************************/
dumpw()
{
	unsigned long i;

	i=adrs2;
	while(i<=z && i<HYOU){
		if(((i-adrs2)&0x0f)==0x00){
			if(i!=adrs2){
				fprintf(fpw0,"\n");
			}
			fprintf(fpw0,"    %02X:",(adrs/0x10000));   
			fprintf(fpw0,"%04X               WORD  ",(adrs&0x0ffff));  			
			fprintf(fpw0,"%02X",data[i+1]);
		} 
		else{
			fprintf(fpw0,",%02X",data[i+1]);
		}
		fprintf(fpw0,"%02XH",data[i]);

		adrs+=2;
		if((adrs&0x8000)==0){
			adrs=adrs+0x8000;
		}
		i+=2;
	}
	fprintf(fpw0,"\n");
}

/*********************************************************************
*	file write ( long word dump )				     *
*********************************************************************/
dumpl()
{
	unsigned long i;

	i=adrs2;
	while(i<=z && i<HYOU){
		if(((i-adrs2)/18)*18==(i-adrs2)){
			if(i!=adrs2){
				fprintf(fpw0,"\n");
			}
			fprintf(fpw0,"    %02X:",(adrs/0x10000));   
			fprintf(fpw0,"%04X               LWORD ",(adrs&0x0ffff));  			
			fprintf(fpw0,"%02X",data[i+2]);
		} 
		else{
			fprintf(fpw0,",%02X",data[i+2]);
		}
		fprintf(fpw0,"%02X",data[i+1]);
		fprintf(fpw0,"%02XH",data[i]);

		adrs+=3;
		if((adrs&0x8000)==0){
			adrs=adrs+0x8000;
		}
		i+=3;
	}
	fprintf(fpw0,"\n");
}

pnmiprn()
{
	int i;
	for(i=byte-1;i>0;i--)
		printf("%02X",nmi[i]);
}

/*********************************************************************
*	dis assemble check 					     *
*		return()= 0:ok					     *
*			  1:error				     *
*			 -1:file EOF				     *
*********************************************************************/

mnemonic()
{
	/****** work ram ******/
	unsigned char buf,i;
	
	/****** mnemonic check ******/
	nmno=0;adno=0;byte=0;i=1;

	while(i!=byte){
		buf=data[adrs2++];
		if(adrs2>=HYOU){
			return(-1);
		}
		if(byte==0){
			if(buf==0x00){
				nmno=11;adno=20;
			}
			else{
				while(buf!=mnecod[nmno][adno]){
					if(++adno==24){
						++nmno;adno=0;
					}
				}
			}		
			nmi[0]=buf;
			if((byte=mnebyt[adno])==0xff){
				switch(nmi[0]){
					case 0x69:
					case 0x29:
					case 0x89:
					case 0xc9:
					case 0x49:
					case 0xa9:
					case 0x09:
					case 0xe9:
						if((flg8_16&0x20)==0){
							byte=0x03;
						}
						else{
							byte=0x02;
						}
						break;
					case 0xe0:
					case 0xc0:
					case 0xa2:
					case 0xa0:
						if((flg8_16&0x10)==0){
							byte=0x03;
						}
						else{
							byte=0x02;
						}
						break;
					case 0xf4:
					case 0x62:
						byte=0x03;
						break;
					default:
						byte=0x02;
						break;
				}
			}
			else if(nmi[0]==PHP){
				*(flgstak++)=flg8_16;
			}
			else if(nmi[0]==PLP){
				if(flgarea<flgstak){
					flg8_16=(*(--flgstak));
				}
			} 
		}	
		else{
			nmi[i++]=buf;
			if(nmi[0]==REP){
				flg8_16=flg8_16&(nmi[1]^0xff);
			}
			else if(nmi[0]==SEP){
				flg8_16=flg8_16|nmi[1];
			}	
		}
	}
	return(0);
}
		
nmiprn()
{
	int i;
	for(i=byte-1;i>0;i--)
		fprintf(fpw0,"%02X",nmi[i]);
}

/*********************************************************************
*  	input mode						     *
*********************************************************************/
inputsub()
{
	char indata[81],indt[80];
	int strl;

	printf(">>>> ");
	scanf("%s",indata);

	strl=strlen(indata);
	switch(indata[0]){
		case	'L' :
		case	'l' :
			if(strl==1){
				adrs1=svadrs;
				adrs3=svadrs2;
			}
			rt=1;
			if(strl>1){
				strcpy(indt,indata+1);
				if(modeck(indt)!=0)  return(-1);
			}
			return(0);
		case	'D' :
			indata[0]='d';
		case	'd' :
			adrs1=0;
			if(strl==1){
				adrs1=svadrs;
				adrs3=svadrs2;
			}
			if(strl>1){
				strcpy(indt,indata+1);
				if(adhenkan(indt)!=0)  return(-1);
			}
			return(2);
			break;
		case	'f' :
		case	'F' :
			flg8_16=mode816;
			if(strl>1){
				strcpy(indt,indata+1);
				if(modeck(indt)!=0)  return(-1);
			}
			mode_dsp();
			return(1);
		case	'e' :
		case	'E' :
			return(-2);
		default	    :
			errdisp();
			return(-1);
	}

}

modeck(indt)
char *indt;
{
	int i,q;
	unsigned long a,b;

	adrs1=0;
	q=0;
	for(i=0;i<2;i++){
		switch(*indt){
			case	'm' :	/* memory 16bit */
				modem=0x00;
				break;
			case	'M' :	/* memory  8bit */
				modem=0x20;
				break;
			case	'x' :	/* index  16bit */
				modex=0x00;
				break;
			case	'X' :	/* index   8bit */
				modex=0x10;
				break;
			default	    :
				q=1;
				break;
		}
		if(q!=0)  break;
		flg8_16=modem|modex;
		*indt++;
	}

	if(adhenkan(indt)!=0)  return(-1);

	a=adrs1&0x7fff;
	b=(adrs1&0xff0000)>>1;
	adrs3=b|a;
	if(adrs3>=0x80000){
		printf("<<< AhXEG[@>>>\n");
		return(-1);
	}
	return(0);
}

adhenkan(indt)
char *indt;
{
	int i,a;
	
	i=strlen(indt);
	if(i>6){
		printf("<<< AhXEG[@>>>\n");
		return(-1);
	}
	else{
		for(;i>0;i--){
			if(isdigit(*indt))  a=(*indt)&0x0f;
			else{
				switch(*indt){
					case	'a' :
					case	'b' : 			
					case	'c' :
					case	'd' :
					case	'e' :
					case	'f' :
						a=(*indt)-'a'+0x0a;
						break;
					case	'A' :
					case	'B' :
					case	'C' :
					case	'D' :
					case	'E' :
					case	'F' :
						a=(*indt)-'A'+0x0a;
						break;
					default	    :
						errdisp();
						return(-1);
				}
			}
			adrs1=(adrs1*0x10)+a;
			*indt++;
		}
	}
	if((adrs1&0x8000)==0){
		errdisp();
		return(-1);
	}
	return(0);
}

errdisp()
{
	printf("<<< h  @III >>>\n");
}

dump_menu()
{
	int i=0;

	while(i<1 || i>3){
		printf("PEEEoCgE_v\n");
		printf("QEEE[hE_v\n");
		printf("REEEOE_v\n");
		printf("----------------------\n");
		printf("input No.---> ");
		scanf("%d",&i);
	}
/*
	printf("JnAhX́H@---------------------------> ");
	scanf("%x",&adrs1);
*/
	printf("IAhX́H@iw肵ȂƂ͂Oj@---> ");
	scanf("%x",&z);
	z=(z&0x7fff)|((z&0xff0000)>>1);
	adrs=adrs1;
	adrs2=(adrs&0x7fff)|((adrs&0xff0000)>>1);
	switch(i){
		case	1 :
			if(z==0){
				z=adrs2+16*20-1;
				if(z>HYOU)  z=HYOU;
			}
			pdumpb();
			rt=2;
			break;
		case	2 :
			if(z==0){
				z=adrs2+16*20-1;
				if(z>HYOU)  z=HYOU;
			}
			pdumpw();
			rt=3;
			break;
		case	3 :
			if(z==0){
				z=adrs2+18*20-1;
				if(z>HYOU)  z=HYOU;
			}
			pdumpl();
			rt=4;
			break;
	}
}

dump_sv()
{

	printf("IAhX́H@iw肵ȂƂ͂Oj@---> ");
	scanf("%x",&z);
	z=(z&0x7fff)|((z&0xff0000)>>1);
	adrs=adrs1;
	adrs2=(adrs&0x7fff)|((adrs&0xff0000)>>1);
	switch(rt){
		case	2 :
			if(z==0){
				z=adrs3-1;
				if(z>HYOU)  z=HYOU;
			}
			dumpb();
			break;
		case	3 :
			if(z==0){
				z=adrs3-1;
				if(z>HYOU)  z=HYOU;
			}
			dumpw();
			break;
		case	4 :
			if(z==0){
				z=adrs3-1;
				if(z>HYOU)  z=HYOU;
			}
			dumpl();
			break;
	}
}

mode_dsp()
{
	switch(flg8_16&0x30){
		case	0x00 :
			printf("... mx\n");
			break;
		case	0x10 :
			printf("... mX\n");
			break;
		case	0x20 :
			printf("... Mx\n");
			break;
		case	0x30 :
			printf("... MX\n");
	}
}
