;************************************************************************
;*									*
;*	title name	: "tensai BAKABON"				*
;*	proccess	: system main					*
;*	file name	: m5main					*
;*									*
;************************************************************************
;
;
	include		ztmacro.asm
	include		tl_ram.asm
;
;
;------------------------------------------------------------------------
;-	global symbol							-
;------------------------------------------------------------------------
;-----< tl_main >--------------------------------------------------------
;
;------------------------------------------------------------------------
;-	extern symbol							-
;------------------------------------------------------------------------
;
;-----< tl_msg0 >--------------------------------------------------------
	EXT	KEYINPT,MSGINIT,NOINPUT,LOADSUB
;
;
;
;------------------------------------------------------------------------
;-	define symbol							-
;------------------------------------------------------------------------
;	EQU
;
;
;************************************************************************
;*									*
;*	program start							*
;*									*
;************************************************************************
;
;
	ORG	008000H
;
;
	EXTEND
;
;
;****************************************************************
;*	reset routine						*
;****************************************************************
;
	EMULATION
;
GSTART	EQU	$
	SEI			;IRQ   disable
	STZ	4200H		;NMI      "
	STZ	420BH		;DMA      "
	STZ	420CH		;H-DMA    "
	STZ	2140H		;sound port reset
	STZ	2141H		;       "
	STZ	2142H		;       "
	STZ	2143H		;       "
	LDA	#10000000B	;branking "ON"
	STA	2100H
;
	NATIVE
;
	CLC			;set native mode
	XCE			;
;
	MI16
;
	LDA	#0000H		;direct register set( 000~0ff )
	TCD
	LDA	#01FFH		;stack pointer set
	TCS
;
;
	LDA	>FILENO
	CMP	#0FFFFH
	BEQ	GTT050
;
	CMP	#00041H
	BCC	GTT100
;
GTT050	EQU	$
	LDA	#00000H
	STA	>FILENO
;
GTT100	EQU	$
;----------------------------------------------------------------
;-	OAM clear program make					-
;----------------------------------------------------------------
	LDA	#0A9H+0F0H*100H		;[ LDA	#0F0H ]
	STA	>OAMCLR
	LDX	#(128-1)*3		;program address index
	LDY	#OAM+1+(128-1)*4	;store addresss
GST010	EQU	$
	LDA	#08DH+000H*100H		;[ STY	[Y] ]
	STA	>OAMCLR+2,X
	TYA
	STA	>OAMCLR+3,X
	SEC
	SBC	#04
	TAY
	DEX
	DEX
	DEX
	BPL	GST010
;
	MI8
;
	LDA	#6BH			;[ RTL ]
	STA	>OAMCLR+2+(128*3)
;
;----------------------------------------------------------------
;	OAM sub change program make				-
;----------------------------------------------------------------
;
	MI16
;
	LDA	#OAMSUB+(20H-1)
	STA	<WORK
	LDY	#OAMSB+200H-4
	LDX	#(20H-1)*21
GST020	EQU	$
	LDA	#00ADH		;[ LDA	OAMSB+? ]
	STA	>OAMCHG,X
	TYA
	STA	>OAMCHG+1,X
	DEY
	DEY
	DEY
	DEY
	LDA	#0003
	STA	<WORK+2
GST030	EQU	$
	LDA	#0A0AH		;[ ASL	A ]
	STA	>OAMCHG+3,X	;[ ASL	A ]
	LDA	#000DH		;[ ORA	OAMSB+? ]
	STA	>OAMCHG+5,X
	TYA
	STA	>OAMCHG+6,X
	DEY
	DEY
	DEY
	DEY
	TXA
	CLC
	ADC	#0005
	TAX
	DEC	<WORK+2
	BNE	GST030
	LDA	#008DH		;[ STA	OAMSUB+? ]
	STA	>OAMCHG+3,X
	LDA	<WORK		
	STA	>OAMCHG+4,X
	DEC	<WORK
	TXA
	SEC	
	SBC	#21+(21-6)
	TAX			
	BPL	GST020
;
	MI8
;
	LDA	#6BH			;[ RTL ]
	STA	>OAMCHG+20H*21
;
;----------------------------------------------------------------
;-      reset start intial set	                                -
;----------------------------------------------------------------
	LDA	#00000011B	;OBJ intial set
	STA	2101H
;;;;	LDA	#01		;[ !=0 ]
	STA	<NMIFLG
	STZ	!MODENO		;move no. set( intial )
;
;----------------------------------------------------------------
;-	polygon initial set					-
;----------------------------------------------------------------
;;;;	JSL	>INITIAL_POLYGON
;
;
;****************************************************************
;*	Main routine						*
;****************************************************************
;
GST100	EQU	$
	LDA	<NMIFLG
	BEQ	GST100		;NMI end ? ( no:GST100 )
;
	CLI			;IRQ "ON" !!
	INC	<FRCNT		;frame counter set
	JSR	MOVE		;[ move ]
;
	STZ	<NMIFLG		;NMI flag clear 
	BRA	GST100
;
;****************************************************************
;*      NMI routine	                                        *
;****************************************************************
;
INTSUB	EQU	$
;
	MI16
;
	PHA
	PHX
	PHY
	PHD
	PHB
;
	LDA	#0000H		;(D) set
	TCD
	PHK			;(DBR) set
	PLB
;
	MI8
;
	LDA	4210H		;NMI status reset
;
;------ NMI intial --------------------------------------
	LDA	#10000000B	;branking "ON" 
	STA	2100H
	STZ	420CH		;H-DMA disable
;
	LDA	<NMIFLG	
	BNE	INT010		;time over( yes:INT010 )
;
;------ NMI move ----------------------------------------
	INC	<NMIFLG		;NMI flag "ON"
;
;------ DMA set -----------------------------------------
;;;;	JSR	PCHDMA		;player chara DMA set
;;;;	JSR	COLDMA		;color DMA set
	JSR	VMADSP		;BG write
	JSR	OBJDMA		;OBJ DMA set
	LDA	<VRAMSH
	BEQ	INT005
;
	JSR	MMJIWT
;
INT005	EQU	$
;	JSL	>BGWRITE	; BG kakikae write
;
;------ controller input --------------------------------
;;;;	JSR	CONT2		;controller read
	JSR	KSNS		;controller read
;
	LDA	#10000001B	;NMI enable
	STA	4200H
INT010	EQU	$
;------ scroll counter set ------------------------------
	LDA	<SCCH1		;BG1_H
	STA	210DH
	LDA	<SCCH1+1
	STA	210DH
	LDA	<SCCV1		; " _V
	STA	210EH
	LDA	<SCCV1+1
	STA	210EH
	LDA	<SCCH2		;BG2_H
	STA	210FH
	LDA	<SCCH2+1	
	STA	210FH
	LDA	<SCCV2		; " _V
	STA	2110H
	LDA	<SCCV2+1
	STA	2110H
	LDA	<SCCH3		;BG3_H
	STA	2111H
	LDA	<SCCH3+1
	STA	2111H
	LDA	<SCCV3		; " _V
	STA	2112H
	LDA	<SCCV3+1
	STA	2112H
	LDA	<SCCH4		;BG4_H
	STA	2113H
	LDA	<SCCH4+1
	STA	2113H
	LDA	<SCCV4		; " _V
	STA	2114H
	LDA	<SCCV4+1
	STA	2114H
;
;------ NMI end set -------------------------------------
	LDA	!FADNO		;fade set
	STA	2100H
	LDA	!HD420C		;H-DMA flag set
	STA	420CH
;
;------ polygon task change -----------------------------
INT020	EQU	$
;
	MI16
;
	PLB
	PLD
	PLY
	PLX
	PLA
;
RTISUB	EQU	$
	RTI
;
	MEM8
	IDX8
;
;****************************************************************
;*      IRQ routine	                                        *
;****************************************************************
;
IRQSUB	EQU	$
	RTI
;
;
;************************************************************************
;*		Message Moji character write		(MMJIWT)	*
;************************************************************************
MMJIWT		EQU	$
		IDX16
		REP	#00010000B	; index 16bit mode
;
		LDA	#10000000B
		STA	2115H		; Vram address auto inc.
		LDX	#01801H
		STX	4300H		; inc. mode & B-bus address set
;
		LDY	#00000H
		STY	2116H		; Vram address set
;
		LDY	#CHRBUF
		STY	4302H		; A-bus address (L,H)
		LDA	#BANK CHRBUF
		STA	4304H		; A-bus address (B)
		LDX	#00010H*80H
		STX	4305H		; data count
		LDA	#00000001B
		STA	420BH		; HEAD DMA on!!
;
		IDX8
		SEP	#00010000B	; index 8bit mode
;
		STZ	<VRAMSH
		RTS
;
;****************************************************************
;*	BG write 						*
;****************************************************************
VTABLE	EQU	$
VTB00	LWORD	VRAMD+2
VTB01	LWORD	VRCLDT
;
VTCL	EQU	VTB01-VTABLE
;
;----------------------------------------------------------------
;-	VRAM clear  						-
;----------------------------------------------------------------
VRCLDT	EQU	$
	HEX	50,00,47,FE
	WORD	007FH
	HEX	60,00,47,FE
	WORD	00FFH
;
	HEX	51,4D,00,03
	WORD	1D64H,1D64H
	HEX	51,6D,00,03
	WORD	1D74H,1D74H
;
	HEX	51,17,80,0B
	WORD	15A1H,15B1H,15A7H,15A7H,15A4H,15B4H
	HEX	51,18,40,04
	WORD	15A2H
	HEX	51,1B,80,0B
	WORD	15A3H,15B3H,15A8H,15A8H,15A6H,15B6H
	HEX	51,38,40,04
	WORD	15B2H
	HEX	51,98,40,04
	WORD	15A5H
	HEX	51,B8,40,04
	WORD	15B5H
;
	HEX	51,58,00,05
	WORD	1D65H,1D6AH,1D6CH
	HEX	51,78,00,05
	WORD	1D75H,1D7AH,1D7CH
;
	HEX	51,E4,80,03
	WORD	15A1H,15B1H
	HEX	52,24,C0,0A
	WORD	15A7H
	HEX	52,E4,80,03
	WORD	15A4H,15B4H
	HEX	51,E5,40,28
	WORD	15A2H
	HEX	52,05,40,28
	WORD	15B2H
	HEX	52,E5,40,28
	WORD	15A5H
	HEX	53,05,40,28
	WORD	15B5H
	HEX	51,FA,80,03
	WORD	15A3H,15B3H
	HEX	52,3A,C0,0A
	WORD	15A8H
	HEX	52,FA,80,03
	WORD	15A6H,15B6H
;
	HEX	52,25,00,29
	WORD	03C00H,03C01H,03C02H,03C03H,03C04H,03C05H,03C06H,03C07H
	WORD	03C08H,03C09H,03C0AH,03C0BH,03C0CH,03C0DH,03C0EH,03C0FH
	WORD	03C10H,03C11H,03C12H,03C13H,03C14H
	HEX	52,45,00,29
	WORD	03C15H,03C16H,03C17H,03C18H,03C19H,03C1AH,03C1BH,03C1CH
	WORD	03C1DH,03C1EH,03C1FH,03C20H,03C21H,03C22H,03C23H,03C24H
	WORD	03C25H,03C26H,03C27H,03C28H,03C29H
	HEX	52,65,00,29
	WORD	03C2AH,03C2BH,03C2CH,03C2DH,03C2EH,03C2FH,03C30H,03C31H
	WORD	03C32H,03C33H,03C34H,03C35H,03C36H,03C37H,03C38H,03C39H
	WORD	03C3AH,03C3BH,03C3CH,03C3DH,03C3EH
	HEX	52,85,00,29
	WORD	03C3FH,03C40H,03C41H,03C42H,03C43H,03C44H,03C45H,03C46H
	WORD	03C47H,03C48H,03C49H,03C4AH,03C4BH,03C4CH,03C4DH,03C4EH
	WORD	03C4FH,03C50H,03C51H,03C52H,03C53H
	HEX	52,A5,00,29
	WORD	03C54H,03C55H,03C56H,03C57H,03C58H,03C59H,03C5AH,03C5BH
	WORD	03C5CH,03C5DH,03C5EH,03C5FH,03C60H,03C61H,03C62H,03C63H
	WORD	03C64H,03C65H,03C66H,03C67H,03C68H
	HEX	52,C5,00,29
	WORD	03C69H,03C6AH,03C6BH,03C6CH,03C6DH,03C6EH,03C6FH,03C70H
	WORD	03C71H,03C72H,03C73H,03C74H,03C75H,03C76H,03C77H,03C78H
	WORD	03C79H,03C7AH,03C7BH,03C7CH,03C7DH
	HEX	0FFH
;
VRAMCL	EQU	$
	JSR	BLNKON		;branking "ON"
;
;------ OAM intial ----------------------------------------------
	STZ	OAMROT		;OAM priority rotation set ( 000H~ )
	JSL	>OAMCLR		; "  clear
	JSL	>OAMCHG		; "  sub change
;;;;	LDA	#VTCL
;;;;	STA	<VRFLG
;	
;----------------------------------------------------------------
;-	BG write  						-
;----------------------------------------------------------------
VMADSP	EQU	$
	LDY	<VRFLG		
	LDA	!VTABLE,Y	;BG data address(L) set
	STA	<WORK
	LDA	!VTABLE+1,Y	;       "       (H) set
	STA	<WORK+1
	LDA	!VTABLE+2,Y	;       "       (B) set
	STA	<WORK+2
	JSR	VRAMTR		;VRAM write
	LDA	<VRFLG
	BNE	VMD010		;VRAMD write ? ( no:VMD010 )
;
	STA	>VRAMD
	STA	>VRAMD+1
	DEC	A		;[ LDA	#0FFH ]
	STA	>VRAMD+2
VMD010	EQU	$
	STZ	<VRFLG
	RTS
;
;****************************************************************
;*	color DMA  						*
;****************************************************************
CTABLE	EQU	$
CTB00	LWORD	CRAMD+1
;
COLDMA	EQU	$
	LDY	!CGFLG
	LDA	!CTABLE+2,Y	;data address(B) set
	STA	4320H+4
	STA	<WORK+2		;work address(B)
	STZ	<WORK+1		;      "     (H)
	STZ	<WORK		;      "     (L)
	STZ	<WORK+4		;[ to 16 bit mode ]
	LDA	!CTABLE+1,Y	;data address(L,H)
	XBA
	LDA	!CTABLE,Y
;
	I16
;
	TAY
	LDX	#00000000B+(22H*100H)	;inc mode & B bus address
	STX	4320H
CLDM10	EQU	$
	LDA	[<WORK],Y
	BEQ	CLDM20	;end ? ( yes:CLDM20 )
;
	STA	4320H+5		;number of byte
	STA	<WORK+3		;(WK3) <-- "
	STZ	4320H+6
	INY
	LDA	[<WORK],Y	;C.G ram address set
	STA	2121H
;
	M16
;
	INY
	TYA			;data address(L,H) set
	STA	4320H+2
	CLC
	ADC	<WORK+3
	TAY
;
	M8
;
	LDA	#00000100B	;DMA "ON"
	STA	420BH
	BRA	CLDM10
;
CLDM20	EQU	$
;
	I8
;
	LDA	!CGFLG
	BNE	CLDM30
;
	STZ	!CRAMD	;pointer reset 
	STZ	!CRAMD	;end code set
CLDM30	EQU	$
	STZ	!CGFLG
;
;----------------------------------------------------------------
;-	constant color set					-
;----------------------------------------------------------------
	LDA	!NUKCOL		;[ red ]
	AND	#00011111B
	ORA	#00100000B
	STA	2132H
;
	M16
;
	LDA	!NUKCOL		;[ green ]
	LSR	A
	LSR	A
;
	M8
;
	LSR	A
	LSR	A
	LSR	A
	AND	#00011111B
	ORA	#01000000B
	STA	2132H
;
	LDA	!NUKCOL+1	;[ blue ]
	LSR	A
	LSR	A
	ORA	#10000000B
	STA	2132H
	RTS
;
;****************************************************************
;*	OBJ DMA		                                        *
;****************************************************************
;
OBJDMA	EQU	$
	STZ	4300H	;DMA control parameter
;
	M16
;
	STZ	2102H	;OAM address set ( 00~ )
;
	LDA	#04+((OAM&0000FFH)*100H)			;DMA B bus address & A bus address(L)
	STA	4301H
	LDA	#((OAM&00FF00H)/100H)+((OAM&0FF0000H)/100H) 	;DMA A bus address(H,B)
	STA	4303H
	LDA	#0220H		;DMA number of byte
	STA	4305H
	LDY	#00000001B	;DMA ch "ON"
	STY	420BH
;
	M8
;
	LDA	#10000000B	;OAM rotation set
	STA	2103H
	LDA	!OAMROT
	STA	2102H
	RTS
;
;****************************************************************
;*      controller read                                         *
;****************************************************************
;
CONT2	EQU	$
	LDA	4212H
	LSR	A
	BCS	CONT2		;read ok ? ( no:CONT2 )
;
	MI16
;
	LDA	4218H		;1p controller
	AND	#1111111111110000B
	STA	!KEYA1L
	TAY
	EOR	!KEYABFL
	AND	!KEYA1L
	STA	!KEYA2L
	STY	!KEYABFL
;
	LDA	421AH		;2p controller
	AND	#1111111111110000B
	STA	!KEYB1L
	TAY
	EOR	!KEYBBFL
	AND	!KEYB1L
	STA	!KEYB2L
	STY	!KEYBBFL
;
	LDA	!KEYA1L		;move controller set
	STA	<KEYC1L
	LDA	!KEYA2L
	STA	<KEYC2L
;
	MI8
;
	RTS
;
;************************************************************************
;*		keyborad read 		key sense		(KSNS)						*
;************************************************************************
KSNS	EQU	$
	LDA	#00H
	STA	4201H
	STA	4016H
;
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	LDA	#00H
	STA	4016H
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	LDA	#00H
	STA	4016H
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	LDA	#00H
	STA	4016H
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	LDA	#00H
	STA	4016H
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	LDA	#00000001B
	STA	4016H
;;;;;		STA	4201H
;
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	LDA	#01H
	STA	4016H
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	LDA	#01H
	STA	4016H
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	LDA	#01H
	STA	4016H
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	LDA	#01H
	STA	4016H
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	LDA	#00H
	STA	4016H
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	LDA	#00H
	STA	4016H
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	LDA	#00H
	STA	4016H
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	LDA	#00H
	STA	4016H
;
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	LDX	#08H
	LDA	#00000000B
	STA	4016H
;;;;;;;		STA	4017H
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
;
KSN010	EQU	$
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
;
	LDA	#00000000B
	STA	4201H
;
	LDY	#0AH
;
KSN020	EQU	$
	DEY
	BNE	KSN020
	NOP
;
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
;
	LDA	4016H
	LSR	A
	ROR	!KEYWK1,X
	LSR	A
	ROR	!KEYWK1,X
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
;
	LDA	4017H
	LSR	A
	ROR	!KEYWK1,X
	LSR	A
	ROR	!KEYWK1,X
;
	LDA	#10000000B
	STA	4201H
	LDY	#0AH
;
KSN030	EQU	$
	DEY
	BNE	KSN030
	NOP
	NOP
;
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
;
	LDA	4016H
	LSR	A
	ROR	!KEYWK1,X
	LSR	A
	ROR	!KEYWK1,X
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
;		
	LDA	4017H
	LSR	A
	ROR	!KEYWK1,X
	LSR	A
	ROR	!KEYWK1,X
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	DEX
	BPL	KSN010
;	
KSN040	EQU	$
;
	LDY	#08H
KSN045	EQU	$
	LDA	!KEYWK1,Y
	EOR	#0FFH
	STA	!KEYWK1,Y
	DEY
	BPL	KSN045
;
	LDY	#08H
KSN050	EQU	$
	LDA	!KEYWK1,Y
	TAX
	EOR	!KEYWK3,Y
	AND	!KEYWK1,Y
	STA	!KEYWK2,Y
	TXA
	STA	!KEYWK3,Y
	DEY
	BPL	KSN050
;
	RTS
;
;****************************************************************
;*      call subroutine ( long )                                *
;*		in  : (A) <- call no.				*
;****************************************************************
;
JSLSUB	EQU	$
	STY	<WORK+5		;(Y) save
;
	PLY
	STY	<WORK+2
;
	MI16
;
	AND	#00FFH
	STA	<WORK+3
	ASL	A
	ADC	<WORK+3
	TAY
	PLA
	STA	<WORK+3
;
	INY
	LDA	[<WORK+2],Y
	STA	<WORK
	INY
	LDA	[<WORK+2],Y
	STA	<WORK+1
;
	MI8
;
	LDY	<WORK+5		;(Y) load 
	JML 	(WORK)	
;
;
;****************************************************************
;*      VRAM write	                                        *
;****************************************************************
;
VRAMTR	EQU	$
;
	I16
;
	STA	4314H		;DMA A bus address(B) set
	LDY	#0000H
VMR010	EQU	$
	LDA	[<WORK],Y
	BPL	VMR020		;end ? ( no:VMR020 )
;
	MI8
;
	RTS
;
VMR020	EQU	$
;
	IDX16
;
	STA	<WORK+4
	INY
	LDA	[<WORK],Y
	STA	<WORK+3
	INY
	LDA	[<WORK],Y
	STZ	<WORK+7
	ASL	A
	ROL	<WORK+7
;
	LDA	#18H		;B bus address set
	STA	4311H
;
	LDA	[<WORK],Y	;DMA control parameter set
	AND	#01000000B
	LSR 	A
	LSR	A
	LSR 	A
	STA	<WORK+5
	STZ	<WORK+6
	ORA	#00000001B
	STA	4310H
;
	MEM16
	REP	#00100001B	;[ CLC ] memory 16 bit mode set
;
	LDA	<WORK+3		;VRAM address set
	STA	2116H
;
	LDA	[<WORK],Y
	XBA
	AND	#3FFFH
	TAX
	INX
	INY
	INY
;
	TYA			;DMA A bus address(L,H) set
;;;;	CLC			;[ REP	#00100001B ]
	ADC	<WORK
	STA	4312H
;
	STX	4315H		;number of byte set
	LDA	<WORK+5
	BEQ	VTR030		;=data ? ( no:VTR030 )
;
	M8
;
	LDA	<WORK+7		;VRAM inc mode set
	STA	2115H
;
	LDA	#00000010B	;DMA ch "ON"
	STA	420BH
;
	LDA	#19H		;DMA B bus address set
	STA	4311H
;
	M16
;
	LDA	<WORK+3		;VRAM addeess set
	STA	2116H
;
	TYA	
	SEC			;[ INC A ]
	ADC	<WORK	
;;;;	INC	A
	STA	4312H
;
	STX	4315H		;number of byte set
;
	LDX	#0002H
VTR030	EQU	$
	STX	<WORK+3
	TYA
	CLC
	ADC	<WORK+3
	TAY
;
	M8
;
	LDA	<WORK+7		;VRAM inc mode set
	ORA	#10000000B
	STA	2115H
;
	LDA	#00000010B	;DMA ch "ON"
	STA	420BH
;
	JMP	VMR010	
;
;
;****************************************************************
;*      ram clear	                                        *
;****************************************************************
;
RAMCLR	EQU	$
;
	MI16
;
	LDX	#01EFEH
RMC010	EQU	$
	STZ	<WORK,X
	DEX
	DEX
	BMI	RMC020
	CPX	#01FEH
	BNE	RMC010		;stack area ? ( no:RMC010 )
	LDX	#00FEH
	BRA	RMC010
;
RMC020	EQU	$
	LDA	#0000H
	STA	>VRAMD
	STZ	!CRAMD
;
	MI8
;
	DEC	A		;[ LDA	#0FFH ]
	STA	>VRAMD+2
	RTS
;
;****************************************************************
;*      BG mode set	                                        *
;****************************************************************
;
BGMDST	EQU	$
	STZ	2133H		;display intial set
	STZ	2106H		;mozaiku reset
;
	LDA	#00001001B
	STA	!BGMODE		;BG mode set( mode 0 )
	STA	2105H
;
;;;;	LDA	#01010010B
	LDA	#01010000B
	STA	2107H		;BG1 screen address set
	STA	!BG1SCF
	LDA	#01100000B
	STA	2108H		;BG2        "
	STA	!BG2SCF
	LDA	#01010000B
	STA	2109H		;BG3        "
	STA	!BG3SCF
	LDA	#01000010B
	STA	210AH		;BG4        "
	STA	!BG4SCF
;
	LDA	#00100000B	
	STA	210BH		;BG1,2 chara address set
	LDA	#00000000B
	STA	210CH		;BG3,4      "
;
	LDA	#00010100B	
	STA	212CH		;main display select set
	LDA	#00000000B
	STA	212DH		;sub         "
	STZ	212EH
	LDA	#00000000B
	STA	212FH
;
;;;;	LDA	#11110000B
;;;;	STA	!WIND23		;BG1,2 window disable
;;;;	LDA	#10101111B
;;;;	STA	!WIND24		;BG3,4        "
;;;;	LDA	#11111111B	
;;;;	STA	!WIND25		;OBJ,color    "   
;;;;	LDA	#00100010B
;;;;	STA	!WIND30		;color window "ON/OFF" set
;;;;	LDA	#00011110B
;;;;	STA	!SUBADF		;add & sub flag set
;;;;;
;;;;	STZ	212AH		;window logic
;;;;	LDA	#00000100B
;;;;	STA	212BH
;;;;;
	LDA	#10000000B	;mode 7 over flow set
	STA	211AH
	RTS
;
;****************************************************************
;*      H-DMA intial	                                    *
;****************************************************************
;
INHDMA	EQU	$
	LDX	#04
IHD010	EQU	$
	LDA	!HDMAP0,X
	STA	4360H,X
	LDA	!HDMAP1,X
	STA	4370H,X
	DEX
	BPL	IHD010
	LDA	#BANK HDMAB0	;data bank set
	STA	4377H
	STA	4367H
	LDA	#11000000B
;;;;	LDA	#01000000B
	STA	!HD420C
	RTS
;
;====== H-DMA parameter data ===================================
HDMAP0	EQU	$
	BYTE	01000001B	;DMA control parameter
	BYTE	26H		;    B bus address
	BYTE	LOW  HDMADR0	;    A     "      (L)
	BYTE	HIGH HDMADR0	;          "      (H)
	BYTE	BANK HDMADR0	;          "      (B)
;
HDMAP1	EQU	$
	BYTE	01000001B	;DMA control parameter
	BYTE	28H		;    B bus address
	BYTE	LOW  HDMADR1	;    A     "      (L)
	BYTE	HIGH HDMADR1	;          "      (H)
	BYTE	BANK HDMADR1	;          "      (B)
;
HDMADR0	EQU	$
	BYTE	80H+70H		;line no.1
	WORD	HDMAB0
	BYTE	80H+70H		;line no.2
	WORD	HDMAB0+70H*2
	BYTE	00H
;
HDMADR1	EQU	$
	BYTE	80H+70H		;line no.1
	WORD	HDMAB0+70H*2*2
	BYTE	80H+70H		;line no.2
	WORD	HDMAB0+70H*2*2+70H*2
	BYTE	00H
;
;****************************************************************
;*      move play	                                        *
;****************************************************************
;
MOVE	EQU	$
	LDA	!MODENO
	ASL	A
	TAX
	JMP	(!MOVADR,X)
;
MOVADR	EQU	$
	WORD	RESTIN		;reset start intial
;;;;	WORD	GMINIT		;game intial
	WORD	GMPLAY1		;  "  play 1
	WORD	GMINIT1		;  "  intial 1
	WORD	GMPLAY		;  "  play
;
;****************************************************************
;*      blanking "ON" 		                                *
;****************************************************************
;
BLNKON	EQU	$
	STZ	4200H		;NMI disable
	STZ	420CH		;H-DMA  "
	LDA	#10000000B	;blanking "ON"
	STA	2100H
	RTS
;
;****************************************************************
;*      reset start intial	                                *
;****************************************************************
;
RESTIN	EQU	$
	JSR	RAMCLR		;ram clear
;
;****************************************************************
;*      game intial 		                                *
;****************************************************************
;
GMINIT	EQU	$
	JSR	VRAMCL		;VRAM clear
	JSR	BGMDST		;BG mode set
;
	JSL	>MSGINIT
	LDA	#VTCL		;[test] BG1 clear
	STA	<VRFLG
	JSR	VMADSP
;
	I16
;
	LDA	#080H
	STA	2115H
	LDY	#00800H
	STY	2116H
	LDY	#00000001B+(018H*100H)
	STY	4300H
	LDY	#08000H
	STY	4302H
	LDA	#008H
	STA	4304H
	LDY	#01000H
	STY	4305H
	LDA	#00000001B
	STA	420BH
;
	LDA	#080H
	STA	2115H
	LDY	#06000H
	STY	2116H
	LDY	#00000001B+(018H*100H)
	STY	4300H
	LDY	#08000H
	STY	4302H
	LDA	#009H
	STA	4304H
	LDY	#02000H
	STY	4305H
	LDA	#00000001B
	STA	420BH
;
	STZ	2115H
	STZ	2121H
	LDY	#00000000B+(022H*100H)
	STY	4300H
	LDY	#0C000H
	STY	4302H
	LDA	#008H
	STA	4304H
	LDY	#00100H
	STY	4305H
	LDA	#00000001B
	STA	420BH
;
	LDA	#080H
	STA	2121H
	LDY	#00000000B+(022H*100H)
	STY	4300H
	LDY	#0C200H
	STY	4302H
	LDA	#008H
	STA	4304H
	LDY	#00100H
	STY	4305H
	LDA	#00000001B
	STA	420BH
;
	I8
;
	LDA	#0FH		;fade no. set
	STA	!FADNO
	LDA	#01		;  "  muki set
	STA	!FADMK
;
MODINC	EQU	$
	INC	!MODENO		;go to next mode 
;
;****************************************************************
;*      blanking "OFF" 		                                *
;****************************************************************
;
BLNKOF	EQU	$
	LDA	#10000001B	;NMI enable
	STA	4200H
	RTS
;
;****************************************************************
;*      game play		                                *
;****************************************************************
;
GMPLAY	EQU	$
	LDA	!MSGFG
	BEQ	GMPL10
;;;;	JSL	>MSGDSP
	RTS
;
GMPL10	EQU	$
;;;;	JSL	>OAMCLR		;OAM clear
;;;;	JSL	>PLSCRL		;player scroll set
;;;;	JSL	>PLCSET		;player OAM set
;;;;	JSL	>PLAYER		;player move
;;;;	JSL	>ENEMY
;;;;	JSL	>OAMCHG		;OAM sub change
;;;;	JSL	>BGSCRST	; BG scroll set sub
	JSL	>KEYINPT	; key input data chenge sub
;;;;	LDA	#08
;;;;	STA	2100H
	RTS
;
;
;****************************************************************
;*      game play 1		                                *
;****************************************************************
;
GMPLAY1	EQU	$
	JSL	>NOINPUT	; file-no. input sub
	RTS
;
;****************************************************************
;*      game intial 		                                *
;****************************************************************
;
GMINIT1	EQU	$
	JSL	>LOADSUB
	INC	!MODENO
	RTS
;
;****************************************************************
;*       game name                                              *
;****************************************************************
; 
	ORG	0FFC0H

	EXTEND
;
	IDX8
	MEM8
; 
	BYTE	053H,055H,050H,045H,052H,020H			   ;"SUPER "
	BYTE	04DH,041H,052H,049H,04FH,057H,04FH,052H,04CH,044H  ;"MARIOWORLD"
	BYTE	020H,020H,020H,020H,020H,020H			   ;"      "
	BYTE	002H,009H,001H,000H,001H,000H			   ;type data 
	BYTE	0FFH,0FFH,000H,000H				   ;check sum 
;
;****************************************************************
;*       Interrupt Vector                                       *
;****************************************************************
;
;======= native mode vector =====================================
;
	ORG	0FFE4H
;
	EXTEND
;
	MEM8
	IDX8
;
	WORD	RTISUB		;COP
;;;;	WORD	RTISUB		;BRK 
;
	ORG	0FFE8H
	EXTEND
	IDX8
	MEM8
	WORD	RTISUB		;Abort
	WORD	INTSUB		;NMI
	WORD	GSTART		;( ??? ) reset ?
	WORD	IRQSUB		;IRQ
; 
;======= emulation mode vector ===================================
; 
	ORG	0FFF4H
;
	EXTEND
;
	MEM8
	IDX8
; 
	WORD	RTISUB		;COP
	WORD	RTISUB		;( ??? )
	WORD	RTISUB		;Abort
	WORD	RTISUB		;NMI
	WORD	GSTART		;Reset
	WORD	RTISUB		;IRQ
;
	END
