;
			INCLUDE		zel_ram.asm
;
;--------------------------------------------------------------------
;
;			ZELDA-3						1989.10.12(THU)
;
;--------------------------------------------------------------------
;
			ORG		08B80H
;
;=============================================== (zel_move) =========
			GLB		PLMAIN1,XYCALC,RDCHCK
			GLB		XCALC0,XCALC1,XCALC2,XCALC3
			GLB		YCALC0,YCALC1,YCALC2,YCALC3
;
			GLB		PLMAIN2,PLMAIN3,PLMAIN4,PLMAIN5
;=============================================== (zel_main) =========
			EXT		JSRSUB,JSRSUBL,OAMCLR,OAMCHG
;=============================================== (zel_play) =========
			EXT		PLMOVE,PYOMST,PYCRCN
;=============================================== (zel_vma) ==========
			EXT		WBUFS0,WBUFS1
;
			EXT		VT01,VT02,VT03,VT04,VT05,VT06,VT07,VT08
;=============================================== (zel_make) =========
			EXT		RCHRCK,INFDCHK,BGCHNG,DRCHCK
			EXT		DOPPLY,SDRPLY
			EXT		MKROOM,IDROPCK
;=============================================== (zel_comn) =========
			EXT		SLITEM
;=============================================== (zel_msge) =========
			EXT		MSGE_I
;=============================================== (zel_enmy) =========
			EXT		ENEMY
;====================================================================
;
			EXTEND
;
;********************************************************************
;*			Play  main								(PLAYMAIN)		*
;********************************************************************
PLMAIN1		EQU		$
PLMAIN2		EQU		$
PLMAIN3		EQU		$
PLMAIN4		EQU		$
PLMAIN5		EQU		$
			MEM8
			IDX8
			SEP		#00110000B			; memory,index 16bit mode
;
			JSR		OAMCLR				; OAM clear			
;
			JSL		>PLM1100
;
 			JSR		PYOMST				; character set
;
			JSR		ENEMY				; enemy move
;
			JSR		OAMCHG				; OAM chenge
;
;;;;;;;;			LDA		<WDWFLG
;;;;;;;;			BNE		PLM1080				;
;;;;;;;;;										;
;;;;;;;;			LDA		<SCCV2
;;;;;;;;			STA		<WORK0
;;;;;;;;;
;;;;;;;;			LDX		!SCRLFG
;;;;;;;;			CPX		#02H
;;;;;;;;			BEQ		PLM1040				;
;;;;;;;;;										;
;;;;;;;;			CMP		#0C0H
;;;;;;;;			BCC		PLM1030				;
;;;;;;;;;										;
;;;;;;;;			LDA		<RMCKYF
;;;;;;;;			CMP		#02H
;;;;;;;;			BNE		PLM1040				;
;;;;;;;;;										;
;;;;;;;;			LDA		<SCCV21
;;;;;;;;			LSR		A
;;;;;;;;			BCS		PLM1040				;
;;;;;;;;;										;
;;;;;;;;;PLM1030		EQU		$
;;;;;;;;;			STZ		<WORK0
;;;;;;;;;PLM1040		EQU		$
;;;;;;;;;			LDY		#00H
;;;;;;;;;			LDA		#00H
;;;;;;;;;			SEC
;;;;;;;;;			SBC		<WORK0
;;;;;;;;;PLM1050		EQU		$
;;;;;;;;;			CMP		#41H
;;;;;;;;;			BCC		PLM1060				;
;;;;;;;;;;										;
;;;;;;;;;			SEC
;;;;;;;;;			SBC		#40H
;;;;;;;;;			TAX
;;;;;;;;;			LDA		#40H
;;;;;;;;;			STA		!WINDOW,Y
;;;;;;;;;			TXA
;;;;;;;;;			INY
;;;;;;;;;			INY
;;;;;;;;;			INY
;;;;;;;;;			BRA		PLM1050
;;;;;;;;;;
;;;;;;;;;PLM1060		EQU		$
;;;;;;;;;			STA		!WINDOW,Y
;;;;;;;;;PLM1080		EQU		$
			RTS
;
;
PLM1100		EQU		$
			LDA		<GAMEMD
			JSL		>JSRSUBL
			LWORD	MOVE				; 0 : move
			LWORD	SCROL0				; 1 : scroll
			LWORD	SCROL1				; 2 : scroll (& write)
			LWORD	SLITEM				; 3 : select item main
			LWORD	BGCHNG				; 4 : BG. change
			LWORD	DOPPLY				; 5 : door open
			LWORD	SDRPLY				; 6 : shutter door
			LWORD	MSGE_I				; 7 : message
;;;;;;;;			WORD	CGCHNG				; 4 : CG. change
;;;;;;;;			WORD	RSBGWT				; 5 : BG. reset
;;;;;;;;			WORD	WDMOVE				; 6 : window move
;
;
;
;********************************************************************
;*			Move									(MOVE)			*
;********************************************************************
MOVE		EQU		$
			LDA		<KEYA2
			AND		#00010000B
			BEQ		MV20				; goto item select?
;										; yes
			LDA		#03H
			STA		<GAMEMD				; goto select item
			RTL
;
MV20		EQU		$
			LDA		<KEYA2
			AND		#00100000B
			BEQ		MV40				; message ?
;										; yes
			LDA		#07H
			STA		<GAMEMD				; goto CG. change
			RTL
;
MV40		EQU		$
			JSR		PLMOVE				; Player move
;
			LDA		<GAMEMD
			BNE		MV80				; scroll check ?
;										; yes
			JSR		GMSLCK				; gamen scroll check
;
			JSL		>INFDCHK				; information data check
;
			JSL		>DRCHCK				; door open check
;;;;			JSR		DROAMST				; door OAM set
MV80		EQU		$
			RTL
;
;
;********************************************************************
;*			Scrol0									(SCROL0)		*
;********************************************************************
NULCDT		EQU		$					; null color data
			BYTE	00101111B
			BYTE	01001011B
			BYTE	10000110B
			BYTE	000H
;
			BYTE	11100000B
			BYTE	11100000B
			BYTE	11100000B
			BYTE	000H
;
;
SCROL0		EQU		$
			LDA		!SCRLMD
			JSL		>JSRSUB
			WORD	SCRLCK				; 0 : 1st. scroll
			WORD	AUTOMV0				; 1 : auto move - 0
			WORD	AUTOMV1				; 2 :           - 1
;
;
;
;********************************************************************
;*			Scroll (& write)						(SCROL1)		*
;********************************************************************
SCROL1		EQU		$
			LDA		!SCRLMD
			JSL		>JSRSUB
			WORD	SCL100				; 0 : room making
			WORD	SCL200				; 1 : BG1. write
			WORD	SCL300				; 2 : BG2. write
			WORD	SCL200				; 3 : BG1. write
			WORD	SCL300				; 4 : BG2. write
			WORD	SCRLCK				; 5 : 1st. scroll
			WORD	SCL200				; 6 : BG1. write
			WORD	SCL300				; 7 : BG2. write
			WORD	SCL200				; 8 : BG1. write
			WORD	SCL400				; 9 : BG2. write & etc.
			WORD	AUTOMV0				; A : auto move - 0
			WORD	AUTOMV1				; A :           - 1
;
;
SCL100		EQU		$
			JSL		>MKROOM				; make room
;
			INC		!SCRLMD
;
			JSL		>IDROPCK			; initial door open check
;
			MEM16
			REP		#00100000B			; memory 16bit mode
;
			LDA		<SCCH2
			CLC
			ADC		#00100H
			AND		#00100H
			STA		<SCCH1
			LDA		<SCCV2
			CLC
			ADC		#00100H
			AND		#00100H
			STA		<SCCV1
;
			MEM8
			SEP		#00100000B			; memory 8bit mode
;
			LDA		<DPSUB
			BNE		SCL140				; sub. gamen set ?
;										; yes
			LDA		!GSUBFG
			STA		<DPSUB
;
SCL140		EQU		$
			LDA		!ONULPT
			BEQ		SCL440				; CG. change ?
;										; no
			RTL
;
;
SCL200		EQU		$
			LDA		!BG1WFG
			BNE		SCL240				; BG.1 write ?
;										; yes
			JSL		>WBUFS1				; BG1. write buffer set
SCL240		EQU		$
			INC		!SCRLMD
			RTL
;
;
SCL300		EQU		$
			JSL		>WBUFS0				; BG.2 write buffer set
			INC		!SCRLMD
			RTL
;
;
SCL400		EQU		$
			JSL		>WBUFS0				; write buffer set-3
			JSL		>RCHRCK				; reset character check
;
			INC		!SCRLMD
			LDA		!GSUBFG
			STA		<DPSUB
SCL440		EQU		$
			LDX		!NULLPT
			LDA		!NULCDT+000H,X
			STA		2132H
			LDA		!NULCDT+001H,X
			STA		2132H
			LDA		!NULCDT+002H,X
			STA		2132H
			STX		!ONULPT
			RTL
;
;
;
;********************************************************************
;*			Read character check					(RDCHCK)		*
;********************************************************************
RDCHCK		EQU		$
			MEM16
			IDX16
;
			PHX							; (X) push
			STA		<GETCHD
			LDX		#00020H
			AND		#001FFH
			CMP		#0001BH
			BEQ		RDCCK20				; slanting data ?
;										; no
			LDX		#00010H
			CMP		#00071H
			BEQ		RDCCK20				; slanting data ?
;										; no
			LDX		#00020H
			CMP		#0000EH
			BEQ		RDCCK20				; slanting data ?
;										; no
			LDX		#00010H
			CMP		#00070H
			BNE		RDCCK40				; slanting data ?
;										; yes
RDCCK20		EQU		$
			LDA		<GETCHD
			STX		<GETCHD
			ASL		A
			ROL		A
			ROL		A
			AND		#00003H
			ORA		<GETCHD
			PLX							; (X) pull
			RTS
;
;
RDCCK40		EQU		$
			LDA		<GETCHD
			CMP		#00080H
			BNE		RDCCK60				; normal door ?
;										; yes
			PLX							; (X) pull
			RTS
;
;
RDCCK60		EQU		$					; in bomb door char. check
			CMP		#00082H
			BNE		RDCCK80				; bomb door ?
;										; yes
			PLX							; (X) pull
			RTS
;
;
RDCCK80		EQU		$					; under door char. check
			CMP		#00084H
			BNE		RDCCK200			; under door ?
;										; yes
			PLX							; (X) pull
			RTS
;
;
;
RDCCK200	EQU		$					; char. check
			LDA		<GETCHD
			AND		#001F0H
			CMP		#00060H
			BEQ		RDCCK220			; not-check char. ?
;										; no
			CMP		#00070H
			BEQ		RDCCK220			; not-check char. ?
;										; no
			CMP		#00110H
			BEQ		RDCCK220			; not-check char. ?
;										; no
			CMP		#00120H
			BEQ		RDCCK220			; not-check char. ?
;										; no
			CMP		#00130H
			BEQ		RDCCK220			; not-check char. ?
;										; no
			CMP		#00180H
			BNE		RDCCK240			; not-check char. ?
;										; yes
RDCCK220	EQU		$
			LDA		#00000H
			PLX							; (X) pull
			RTS
;
RDCCK240	EQU		$
			LDA		#00001H
			PLX							; (X) pull
			RTS
;
;
			MEM8
			IDX8
;
;********************************************************************
;*			X,Y-move								(XYCALC)		*
;********************************************************************
RMCKDT		EQU		$
			BYTE	00001111B			;  0
			BYTE	00001111B			;  1
			BYTE	00001111B			;  2
			BYTE	00001111B			;  3
;
			BYTE	00001011B			;  4
			BYTE	00001011B			;  5
			BYTE	00000111B			;  6
			BYTE	00000111B			;  7
;
			BYTE	00001111B			;  8
			BYTE	00001011B			;  9
			BYTE	00001111B			;  A
			BYTE	00000111B			;  B
;
			BYTE	00001011B			;  C
			BYTE	00001111B			;  D
			BYTE	00000111B			;  E
			BYTE	00001111B			;  F
;
			BYTE	00001110B			; 10
			BYTE	00001101B			; 11
			BYTE	00001110B			; 12
			BYTE	00001101B			; 13
;
			BYTE	00001111B			; 14
			BYTE	00001111B			; 15
			BYTE	00001110B			; 16
			BYTE	00001101B			; 17
;
			BYTE	00001110B			; 18
			BYTE	00001101B			; 19
			BYTE	00001111B			; 1A
			BYTE	00001111B			; 1B
;
			BYTE	00001010B			; 1C
			BYTE	00001001B			; 1D
			BYTE	00000110B			; 1E
			BYTE	00000101B			; 1F
;
;
XYCALC		EQU		$
			MEM8
			IDX8
			SEP		#00110000B			; memory,index 8bit mode
;
			JSR		RMPTGT				; room point get
;
			STZ		<RMCKXF
			LDY		#00000010B
			LDA		!RMXCPT
			BNE		XYCL40				; left room ?
;										; yes
			LDY		#00000001B
XYCL40		EQU		$
			STY		<WORK0
			LDX		<RMCKPT
			LDA		!RMCKDT,X
			AND		<WORK0
			BNE		XYCL100				;
;										; yes
			LDA		#002H
			STA		<RMCKXF
XYCL100		EQU		$
			STZ		<RMCKYF
			LDY		#00001000B
			LDA		<RMYCPT
			BNE		XYCL140				; upper room ?
;										; yes
			LDY		#00000100B
XYCL140		EQU		$
			STY		<WORK0
			LDX		<RMCKPT
			LDA		!RMCKDT,X
			AND		<WORK0
			BNE		XYCL180				;
;										;
			LDA		#002H
			STA		<RMCKYF
XYCL180		EQU		$
			RTL
;
;  
;********************************************************************
;*			X-move (+)								(XCALC0)		*
;********************************************************************
XCALC0
			JSR		XCALC2				;
;
			LDX		<RMCKPT
			LDA		!RMCKDT,X
			AND		#00000010B
			BEQ		XCL080				; next room ?
;										; yes
			LDA		<RMXCPT
			JSR		SLEDS0				; scroll end check data set
;
			LDY		#002H
			JSR		SLCTST				; scroll check counter set
;
			INC		<GAMEMD
			LDA		<RMXCPT
			BNE		XCL040				; room write ?
;										; yes
			LDX		#08H
			JSR		SLDC01				; scroll counter change
;
			MEM16
			IDX16
			REP		#00110000B			; memory,index 16bit mode
;
			JSR		RSTSET				; room status set
			INC		<RMXYCT
;
			MEM8
			IDX8
			SEP		#00110000B			; memory,index 8bit mode
;
			INC		<GAMEMD
XCL040		EQU		$
			JSL		>XYCL100			;
XCL080		EQU		$
			RTS
;
;
;********************************************************************
;*			X-move (-)								(XCALC1)		*
;********************************************************************
XCALC1
			JSR		XCALC3				;
;
			LDX		<RMCKPT
			LDA		!RMCKDT,X
			AND		#00000001B
			BEQ		XCL180				; next room ?
;										; yes
			LDA		<RMXCPT
			EOR		#00000001B
			JSR		SLEDS0				; scroll end check data set
;
			LDY		#003H
			JSR		SLCTST				; scroll check counter set
;
			INC		<GAMEMD
			LDA		<RMXCPT
			BEQ		XCL140				; room write ?
;										; yes
			LDX		#08H
			JSR		SLDC11				; scroll counter change
;
			MEM16
			IDX16
			REP		#00110000B			; memory,index 16bit mode
;
			JSR		RSTSET				; room status set
			DEC		<RMXYCT
;
			MEM8
			IDX8
			SEP		#00110000B			; memory,index 8bit mode
;
			INC		<GAMEMD
XCL140		EQU		$
			JSL		>XYCL100			;
XCL180		EQU		$
			RTS
;
;  
;********************************************************************
;*			X-move (+)								(XCALC2)		*
;********************************************************************
XCALC2
			LDA		<RMXCPT
			EOR		#00000001B
			STA		<RMXCPT
			JSR		RMPTGT				; room point get
;
			LDX		#08H
			JMP		SLDC00				; scroll counter change
;
;
;********************************************************************
;*			X-move (-)								(XCALC3)		*
;********************************************************************
XCALC3
			LDA		<RMXCPT
			EOR		#00000001B
			STA		<RMXCPT
			JSR		RMPTGT				; room point get
;
			LDX		#08H
			JMP		SLDC10				; scroll counter change
;
;
;********************************************************************
;*			Y-move (+)								(YCALC0)		*
;********************************************************************
YCALC0
			JSR		YCALC2				;
;
			LDX		<RMCKPT
			LDA		!RMCKDT,X
			AND		#00001000B
			BEQ		YCL080				; next room ?
;										; yes
			LDA		<RMYCPT
			JSR		SLEDS1				; scroll end check data set
;
			LDY		#000H
			JSR		SLCTST				; scroll check counter set
;
			INC		<GAMEMD
			LDA		<RMYCPT
			BNE		YCL040				; room write ?
;										; yes
			LDX		#00H
			JSR		SLDC01				; scroll counter change
;
			MEM16
			IDX16
			REP		#00110000B			; memory,index 16bit mode
;
			JSR		RSTSET				; room status set
			LDA		<RMXYCT
			CLC
			ADC		#00010H
			STA		<RMXYCT
;
			MEM8
			IDX8
			SEP		#00110000B			; memory,index 8bit mode
;
			INC		<GAMEMD
YCL040		EQU		$
			STZ		<RMCKXF
			LDY		#00000010B
			LDA		<RMXCPT
			BNE		YCL060				; left room ?
;										; yes
			LDY		#00000001B
YCL060		EQU		$
			STY		<WORK0
			LDX		<RMCKPT
			LDA		!RMCKDT,X
			AND		<WORK0
			BNE		YCL080				;
;										; yes
			LDA		#002H
			STA		<RMCKXF
YCL080		EQU		$
			RTS
;
;
;********************************************************************
;*			Y-move (-)								(YCALC1)		*
;********************************************************************
YCALC1
			JSR		YCALC3
;
			LDX		<RMCKPT
			LDA		!RMCKDT,X
			AND		#00000100B
			BEQ		YCL180				; next room ?
;										; yes
			LDA		<RMYCPT
			EOR		#00000010B
			JSR		SLEDS1				; scroll end check data set
;
			LDY		#001H
			JSR		SLCTST				; scroll check counter set
;
			INC		<GAMEMD
			LDA		<RMYCPT
			BEQ		YCL140				; room write ?
;										; yes
			LDX		#00H
			JSR		SLDC11				; scroll counter change
;
			MEM16
			IDX16
			REP		#00110000B			; memory,index 16bit mode
;
			JSR		RSTSET				; room status set
			LDA		<RMXYCT
			SEC
			SBC		#00010H
			STA		<RMXYCT
;
			MEM8
			IDX8
			SEP		#00110000B			; memory,index 8bit mode
;
			INC		<GAMEMD
YCL140		EQU		$
			JSR		YCL040
YCL180		EQU		$
			RTS
;
;
;********************************************************************
;*			Y-move (+)								(YCALC2)		*
;********************************************************************
YCALC2
			LDA		<RMYCPT
			EOR		#00000010B
			STA		<RMYCPT
			JSR		RMPTGT				; room point get
;
			LDX		#00H
			JMP		SLDC00				; scroll counter change
;
;
;********************************************************************
;*			Y-move (-)								(YCALC3)		*
;********************************************************************
YCALC3
			LDA		<RMYCPT
			EOR		#00000010B
			STA		<RMYCPT
			JSR		RMPTGT				; room point get
;
			LDX		#00H
			JMP		SLDC10				; scroll counter change
;
;
;
;********************************************************************
;*			Room status set							(RSTSET)		*
;********************************************************************
			MEM16
			IDX16
RSTSET		EQU		$
			LDA		<RMXYCT
			ASL		A
			TAX
			LDA		<RMSTAT
			STA		>RMDTBL,X
			RTS
;
			MEM8
			IDX8
;
;
;********************************************************************
;*			Scroll check data change - 00			(SLDC00)		*
;********************************************************************
SLDC00		EQU		$
			MEM16
			REP		#00100000B			; memory 16bit mode
;
			LDA		<SCVU,X
			CLC
			ADC		#0100H
			STA		<SCVU,X
			LDA		<SCVD,X
			CLC
			ADC		#0100H
			STA		<SCVD,X
;
			MEM8
			SEP		#00100000B			; memory 8bit mode
			RTS
;
;
;********************************************************************
;*			Scroll check data change - 01			(SLDC01)		*
;********************************************************************
SLDC01		EQU		$
			MEM16
			REP		#00100000B			; memory 16bit mode
;
			LDA		<SCVU1,X
			CLC
			ADC		#0200H
			STA		<SCVU1,X
			LDA		<SCVD1,X
			CLC
			ADC		#0200H
			STA		<SCVD1,X
;
			MEM8
			SEP		#00100000B			; memory 8bit mode
			RTS
;
;
;********************************************************************
;*			Scroll check data change - 10			(SLDC10)		*
;********************************************************************
SLDC10		EQU		$
			MEM16
			REP		#00100000B			; memory 16bit mode
;
			LDA		<SCVU,X
			SEC
			SBC		#0100H
			STA		<SCVU,X
			LDA		<SCVD,X
			SEC
			SBC		#0100H
			STA		<SCVD,X
;
			MEM8
			SEP		#00100000B			; memory 8bit mode
			RTS
;
;
;********************************************************************
;*			Scroll check data change - 11			(SLDC11)		*
;********************************************************************
SLDC11		EQU		$
			MEM16
			REP		#00100000B			; memory 16bit mode
;
			LDA		<SCVU1,X
			SEC
			SBC		#0200H
			STA		<SCVU1,X
			LDA		<SCVD1,X
			SEC
			SBC		#0200H
			STA		<SCVD1,X
;
			MEM8
			SEP		#00100000B			; memory 8bit mode
			RTS
;
;
;********************************************************************
;*			Scroll check counter set				(SLCTST)		*
;********************************************************************
RMUSLD		EQU		$
			WORD	0063H,0163H
RMDSLD		EQU		$
			WORD	00ABH,01ADH
RMLSLD		EQU		$
			WORD	0077H,0179H
RMRSLD		EQU		$
			WORD	0087H,0189H
;
;
SLCTST
			STY		!SCRLFG				; scroll muki set
;
			LDA		<PWORK1
			AND		#00000011B
			BEQ		SCTS100				; left,right move ?
;										; yes
			MEM16
			REP		#00100000B			; memory 16bit mode
;
			LDA		<PLYPS1
			AND		#001FFH
			CLC
			ADC		#0000BH
			STA		<PYUPCT
			INC		A
			INC		A
			STA		<PYDWCT
;
			LDX		#004H
			LDA		<PWORK1
			AND		#0000000000000001B
			BEQ		SCTS20				; right move ?
;										; yes
			LDX		#000H
SCTS20		EQU		$
			LDY		<RMXCPT
			BEQ		SCTS40				; ?
;										; yes
			INX
			INX
SCTS40		EQU		$
			LDA		!RMLSLD,X
			STA		<PXLFCT
			INC		A
			INC		A
			STA		<PXRTCT				; left,right check counter set
;
			MEM8
			SEP		#00100000B			; memory 8bit mode
			RTS
;
SCTS100		EQU		$
			MEM16
			REP		#00100000B			; memory 16bit mode
;
			LDA		<PLXPS1
			AND		#001FFH
			CLC
			ADC		#00007H
			STA		<PXLFCT
			INC		A
			INC		A
			STA		<PXRTCT
;
			LDX		#004H
			LDA		<PWORK1
			AND		#0000000000000100B
			BEQ		SCTS120				; down move ?
;										; yes
			LDX		#000H
SCTS120		EQU		$
			LDY		<RMYCPT
			BEQ		SCTS140				; ?
;										; yes
			INX
			INX
SCTS140		EQU		$
			LDA		!RMUSLD,X
			STA		<PYUPCT
			INC		A
			INC		A
			STA		<PYDWCT				; up,down check counter set
;
			MEM8
			SEP		#00100000B			; memory 8bit mode
			RTS
;
;
;********************************************************************
;*			Room point get							(RMPTGT)		*
;********************************************************************
RMPTGT		EQU		$
			LDA		!ROOMNO
			ORA		<RMYCPT
			ORA		<RMXCPT
			STA		<RMCKPT
			RTS
;
;
;********************************************************************
;*			Gamen scroll check						(GMSLCK)		*
;********************************************************************
GMSLCK		EQU		$
			MEM16
			REP		#00100000B			; memory 16bit mode
;
			LDA		<PLYPS1
			AND		#001FFH
			CLC
			ADC		#0000CH
			STA		<WORK0
;
			LDX		<RMCKYF
			LDA		<PWORK1
			AND		#0000000000001000B
			BEQ		GSCK40				; up move ?
;										; yes
			LDA		<PYUPCT
			CMP		<WORK0
			BCS		GSCK80				; gamen scroll ?
;										; no
			BCC		GSCK200
;
GSCK40		EQU		$
			LDA		<PWORK1
			AND		#0000000000000100B
			BEQ		GSCK200				; down move ?
;										; yes
			LDA		<WORK0
			CMP		<PYDWCT
			BCC		GSCK200				; gamen scroll ?
;										; yes
			INX
			INX
			INX
			INX
GSCK80		EQU		$
			LDA		#00001H
			STA		<WORK0
			STZ		<WORK4
;
			LDA		<PLYMVC
			AND		#000FFH
			BEQ		GSCK200				; y-move ?
;										; yes
			CMP		#00080H
			BCC		GSCK120				; (-) data ?
;										; yes
			EOR		#000FFH
			INC		A
			DEC		<WORK0
			DEC		<WORK0
GSCK120		EQU		$
			STA		<WORK2
GSCK160		EQU		$
			LDA		<SCCV2
			CMP		<SCVU,X
			BEQ		GSCK200				; limit ?
;										; no
			CLC
			ADC		<WORK0
			STA		<SCCV2
;
			LDA		<WORK4
			CLC
			ADC		<WORK0
			STA		<WORK4
;
			DEC		<WORK2
			BNE		GSCK160				; move end ?
;										; yes
			LDA		<PYUPCT
			CLC
			ADC		<WORK4
			STA		<PYUPCT
			LDA		<PYDWCT
			CLC
			ADC		<WORK4
			STA		<PYDWCT
;
			STZ		<WORK0
			LDA		<WORK4
			LSR		A
			ROR		<WORK0
			CMP		#07000H
			BCC		GSCK180				; (-) data ?
;										; yes
			ORA		#0F000H
GSCK180		EQU		$
			STA		<WORK4
;
			LDA		!SCV1CT
			CLC
			ADC		<WORK0
			STA		!SCV1CT
;
			LDA		<SCCV1
			ADC		<WORK4
			STA		<SCCV1
GSCK200		EQU		$
			LDA		<PLXPS1
			AND		#001FFH
			CLC
			ADC		#00008H
			STA		<WORK0
;
			LDX		<RMCKXF
			LDA		<PWORK1
			AND		#0000000000000010B
			BEQ		GSCK240				; left move ?
;										; yes
			LDA		<PXLFCT
			CMP		<WORK0
			BCS		GSCK280				; gamen scroll ?
;										; no
			BCC		GSCK400
;
GSCK240		EQU		$
			LDA		<PWORK1
			AND		#0000000000000001B
			BEQ		GSCK400				; right move ?
;										; yes
			LDA		<WORK0
			CMP		<PXRTCT
			BCC		GSCK400				; gamen scroll ?
;										; yes
			INX
			INX
			INX
			INX
GSCK280		EQU		$
			LDA		#00001H
			STA		<WORK0
			STZ		<WORK4
;
			LDA		<PLXMVC
			AND		#000FFH
			BEQ		GSCK400				; x-move ?
;										; yes
			CMP		#00080H
			BCC		GSCK320				; (-) data ?
;										; yes
			EOR		#000FFH
			INC		A
			DEC		<WORK0
			DEC		<WORK0
GSCK320		EQU		$
			STA		<WORK2
GSCK360		EQU		$
			LDA		<SCCH2
			CMP		<SCHL,X
			BEQ		GSCK400				; limit ?
;										; yes
			CLC
			ADC		<WORK0
			STA		<SCCH2
;
			LDA		<WORK4
			CLC
			ADC		<WORK0
			STA		<WORK4
;
			DEC		<WORK2
			BNE		GSCK360				; move end ?
;										; yes
			LDA		<PXLFCT
			CLC
			ADC		<WORK4
			STA		<PXLFCT
			LDA		<PXRTCT
			CLC
			ADC		<WORK4
			STA		<PXRTCT
;
			STZ		<WORK0
			LDA		<WORK4
			LSR		A
			ROR		<WORK0
			CMP		#07000H
			BCC		GSCK380				; (-) data ?
;										; yes
			ORA		#0F000H
GSCK380		EQU		$
			STA		<WORK4
;
			LDA		!SCH1CT
			CLC
			ADC		<WORK0
			STA		!SCH1CT
;
			LDA		<SCCH1
			ADC		<WORK4
			STA		<SCCH1
GSCK400		EQU		$
			MEM8
			SEP		#00100000B			; memory 8bit mode
			RTS
;
;
;********************************************************************
;*			X-Scroll end check data set				(SLEDS0)		*
;********************************************************************
SCLCD0		EQU		$
			WORD	01F8H,0108H
			WORD	00F8H,0008H
;
;
SLEDS0		EQU		$
			ASL		A
			ASL		A
			TAY
			LDX		#00000000B
SED040		EQU		$
			LDA		!SCLCD0,Y
			STA		<SCKX00,X
			INY
			INX
			CPX		#04H
			BNE		SED040				;
;										;
			RTS
;
;
;********************************************************************
;*			Y-Scroll end check data set				(SLEDS1)		*
;********************************************************************
SCLCD1		EQU		$
			WORD	01E0H,0128H
			WORD	00E0H,0028H
;
;
SLEDS1		EQU		$
			ASL		A
			TAY
			LDX		#00000000B
SED140		EQU		$
			LDA		!SCLCD1,Y
			STA		<SCKY00,X
			INY
			INX
			CPX		#04H
			BNE		SED140				;
;										;
			RTS
;
;
;********************************************************************
;*			Scroll check							(SCRLCK)		*
;********************************************************************
SCCADD		EQU		$					; scroll counter add. data-0
			WORD	00008H,0FFF8H,00008H,0FFF8H
;
;
SCRLCK		EQU		$
			LDA		#03H				; oam shokyo set
			STA		<OMSBMD
;
			LDA		!SCRLFG
			ASL		A
			TAY
;
			MEM16
			REP		#00100000B			; memory 16bit mode
;
			LDX		#000H
			CPY		#004H
			BCS		SLCK40				; SCCH ?
;										; no
			LDX		#006H
SLCK40		EQU		$
			LDA		<SCCH1,X
			CLC
			ADC		!SCCADD,Y
			STA		<SCCH1,X
			LDA		<SCCH2,X
			CLC
			ADC		!SCCADD,Y
			STA		<SCCH2,X
			AND		#01F8H
			CMP		SCKY00,Y
			BNE		SLCK240				; scroll end ?
;										; yes
			LDA		!SCCADD,Y
			LDX		#000H
			STX		<OMSBMD				; oam shokyo clear !
			CPY		#004H
			BCC		SLCK80				; player y-pos. hosei ?
;										; no
			LDX		#002H				;        x-pos. hosei
SLCK80		EQU		$
			CLC
			ADC		<PLYPS1,X
			STA		<PLYPS1,X
;
			INC		!SCRLMD
SLCK240		EQU		$
			MEM8
			SEP		#00100000B			; memory 8bit mode
			RTL
;
;
;********************************************************************
;*			Auto move								(AUTOMV0)		*
;********************************************************************
PTRPDT		EQU		$					; point replace data
			BYTE	000H,004H,008H,00CH
;
YAMCKD0		EQU		$					; Y(+) auto move check data
			BYTE	000H,010H,020H,028H
YAMCKD1		EQU		$					; Y(-)
			BYTE	0F0H,0D8H,0C0H,0C0H
XAMCKD0		EQU		$					; X(+)
			BYTE	000H,018H,028H,030H
XAMCKD1		EQU		$					; X(-)
			BYTE	0F0H,0D8H,0C8H,0C0H
;
;
AUTOMV0		EQU		$
			JSR		PYCRCN				; player chara henkan sub
;
			LDX		#000H
			JSR		ATMV200				; auto move
			BCC		ATMV080				; auto move end ?
;										; yes
			INC		!SCRLMD
			JSR		PYATCK				; player auto move check
ATMV080		EQU		$
			RTL
;
;
AUTOMV1		EQU		$
			JSR		PYCRCN				; player chara henkan sub
;
			LDX		<PYATFG				; (X) <-- door auto move check point
			JSR		ATMV200				; auto move
			BCC		ATMV180				; auto move end ?
;										; yes
			LDX		<PYATFG
			CPX		#002H
			BNE		ATMV140				; bomb door ?
;										; yes
			STZ		<PWORK6
ATMV140		EQU		$
			STZ		<PWORK9
			STZ		<DRATMV
			STZ		<PYATFG
			STZ		!SCRLMD
			STZ		!SCRLFG
			STZ		<GAMEMD
;;;;;;;;			STZ		<WDWCNT
ATMV180		EQU		$
			RTL
;
;
;
ATMV200		EQU		$
			TXA
			LDY		!SCRLFG
			CLC
			ADC		!PTRPDT,Y
			TAX
;
			LDY		#001H
			LDA		!SCRLFG
			LSR		A
			BCC		ATMV210				; Y(+) ?
;
			LDY		#0FFH
ATMV210		EQU		$
			LDA		!SCRLFG
			CMP		#002H
			BCS		ATMV240				; up,down ?
;										; yes
			TYA
			BMI		ATMV220				;
;										;
			DEY
ATMV220		EQU		$
			CLC
			ADC		<PLYPS1
			STA		<PLYPS1
			TYA
			ADC		<PLYPS0
			STA		<PLYPS0
;
			LDA		<PLYPS1
			CMP		!YAMCKD0,X
			BEQ		ATMV280				; end ?
;										; no
ATMV230		EQU		$
			CLC
			RTS
;
ATMV240		EQU		$
			TYA
			BMI		ATMV250				;
;										;
			DEY
ATMV250		EQU		$
			CLC
			ADC		<PLXPS1
			STA		<PLXPS1
			TYA
			ADC		<PLXPS0
			STA		<PLXPS0
;
			LDA		<PLXPS1
			CMP		!YAMCKD0,X
			BNE		ATMV230				; end ?
;										; yes
ATMV280		EQU		$
			SEC
			RTS
;
;
;********************************************************************
;*			Player auto move check					(PYATCK)		*
;********************************************************************
PYATCK		EQU		$
			MEM16
			IDX16
			REP		#00110000B			; memory,index 16bit mode
;
			LDA		<PLYPS1
			CLC
			ADC		#0000CH
			AND		#001F8H
			ASL		A
			ASL		A
			ASL		A
			ASL		A
			STA		<WORK0
			LDA		<PLXPS1
			CLC
			ADC		#00008H
			AND		#001F8H
			LSR		A
			LSR		A
			ORA		<WORK0
			TAX
			LDA		>ROOMBF+000H,X
			LDY		#00001H
			CMP		#00080H
			BEQ		PYAC40				; normal ?
;										; no
			INY
			CMP		#00082H
			BEQ		PYAC40				; bomb,shutter ?
;										; no
			INY
PYAC40		EQU		$
			MEM8
			IDX8
			SEP		#00110000B			; memory,index 8bit mode
;
			STY		<PYATFG
			RTS
;
;
;
;
;
			END
