;
		INCLUDE	zel_ram.asm
;
;------------------------------------------------------------------------
;
;		ZELDA-3			1990.02.01(THU)
;
;------------------------------------------------------------------------
;
		ORG	0A000H
;
;=============================================== (zel_main) =============
		GLB	MAIN_P,GDCHCK
;=============================================== (zel_init) =============
		EXT	INIT1,INIT2
		EXT	PLMAIN1,PLMAIN2
		EXT	MZFDOUT,MZFDIN
;=============================================== (zel_title) ============
		EXT	TITLE0
;=============================================== (zel_mpdt) =============
		EXT	MPUNIT
;========================================================================
;
		EXTEND
;
;
;
;************************************************************************
;*		Main  Program						*
;************************************************************************
M_TBL_L		EQU	$
		BYTE	LOW TITLE0
		BYTE	LOW INIT1
		BYTE	LOW PLMAIN1
		BYTE	LOW INIT2
		BYTE	LOW PLMAIN2
		BYTE	LOW MZFDOUT
		BYTE	LOW MZFDIN
;
M_TBL_H		EQU	$
		BYTE	HIGH TITLE0
		BYTE	HIGH INIT1
		BYTE	HIGH PLMAIN1
		BYTE	HIGH INIT2
		BYTE	HIGH PLMAIN2
		BYTE	HIGH MZFDOUT
		BYTE	HIGH MZFDIN
;
M_TBL_B		EQU	$
		BYTE	BANK TITLE0
		BYTE	BANK INIT1
		BYTE	BANK PLMAIN1
		BYTE	BANK INIT2
		BYTE	BANK PLMAIN2
		BYTE	BANK MZFDOUT
		BYTE	BANK MZFDIN
;
MAIN_P		EQU	$
		LDY	<SLMODE
		LDA	M_TBL_L,Y
		STA	<WORK3
		LDA	M_TBL_H,Y
		STA	<WORK4
		LDA	M_TBL_B,Y
		STA	<WORK5
		JML	(!WORK3)
;
;
;
;
;
;
;************************************************************************
;*		Ground character check			(GDCHCK)	*
;*		[in]	work0,1 <-- y-pos.				*
;*			work2,3 <-- x-pos.				*
;*									*
;*		[out]	(A)						*
;************************************************************************
GDCHCK		EQU	$
		MEM16
		IDX16
		REP	#00110000B	; memory,index 16bit mode
;
		LDA	<WORK0
		AND	#0FFFEH
		ASL	A
		ASL	A
		ASL	A
		ASL	A
		ASL	A
		ASL	A
		STA	<WORK6
		LDA	<WORK2
		AND	#0FFFEH
		ORA	<WORK6
		TAX
		CPX	#01000H
		BCS	GDCK40		; buffer -0 ?
;					; yes
		LDA	>GDBUF0,X
		BRA	GDCK80
;
GDCK40		EQU	$
		AND	#00FFFH
		TAX
		LDA	>GDBUF1,X
GDCK80		EQU	$
		ASL	A
		ASL	A
		ASL	A
		STA	<WORK6
;
		LDA	<WORK2
		AND	#00001H
		ASL	A
		ORA	<WORK6
		STA	<WORK6
		LDA	<WORK0
		AND	#00001H
		ASL	A
		ASL	A
		ORA	<WORK6
		TAX
		LDA	>MPUNIT,X
		LDY	#00008H
		AND	#000FFH
		CMP	#000DFH
		BEQ	GDCK200		;
;					;
		INY
		CMP	#000EFH
		BEQ	GDCK200		;
;					;
		LDY	#00000H
		AND	#000F0H
		CMP	#000F0H
		BEQ	GDCK200		; ok ?
;					; no
		CMP	#000E0H
		BEQ	GDCK200		; ok ?
;					; no
		CMP	#000D0H
		BEQ	GDCK200		; ok ?
;					; no
		INY
GDCK200		EQU	$
		TYA			; (A) <-- return code
;
		MEM8
		IDX8
		SEP	#00110000B	; memory,index 8bit mode
		RTL
;
;
;
;
;
		END
