;
		INCLUDE	"zel_ram.asm"
;
;--------------------------------------------------------------------
;
;			ZELDA-3						1989.08.28(MON)
;
;--------------------------------------------------------------------
;
		ORG	0B000H
;
;=============================================== (zel_wind) =========
		GLB	PLMAIN3,PLMAIN4,PLMAIN5
;=============================================== (zel_main) =========
		EXT	JSRSUB,OAMCLR,OAMCHG
;=============================================== (zel_play) =========
		EXT	PYOMST
;====================================================================
;
;
;
;********************************************************************
;*			Kiri main								(PLMAIN3)		*
;********************************************************************
PLMAIN3
		MEM8
		IDX8
		SEP	#00110000B	; memory,index 16bit mode
;
		JSR	OAMCLR		; OAM clear
;
		JSR	PLM3200
;
		JSR	KIRIMV		; kiri move
;
		JSR	PYOMST		; OAM set
;
		JSR	OAMCHG		; OAM change
		RTS
;
PLM3200		EQU	$
		LDA	<GAMEMD
		JSL	>JSRSUB
		WORD	PLMOVE		; 0 : move
		WORD	NRMWT0		; 1 : next room write - 0
		WORD	NRMWT1		; 2 :                 - 1
		WORD	KAGEMV		; 3 : kagerou move
;
;
;********************************************************************
;*			Window main								(PLMAIN4)		*
;********************************************************************
PLMAIN4
		JSR	OAMCLR		; OAM clear
;
		JSR	PLM4200
;
		JSR	PYOMST		; OAM set
;
		JSR	EYMOVE		; enemy
;
		JSR	OAMCHG		; OAM change
		RTS
;
PLM4200		EQU	$
		LDA	<GAMEMD
		JSL	>JSRSUB
		WORD	WDMOVE		; 0 : window move
		WORD	NRMWT0		; 1 : next room write - 0
		WORD	NRMWT1		; 2 :                 - 1
		WORD	WDMAIN		; 3 : window open-close
;
;
;********************************************************************
;*													(EYMOVE)		*
;********************************************************************
EYMOVE		EQU	$
		INC	<EYXPOS1
		INC	<EYYPOS1
;
		LDA	#078H
		STA	<WORK1
		LDA	<EYXPOS1
		STA	<WORK0
;
		LDA	<EYYPOS1
		STA	<WORK3
		LDA	#078H
		STA	<WORK2
;
		MEM16
		IDX16
		REP	#00110000B	; memory,index 16bit mode
;
		LDA	<WORK0
		STA	!POAM+10H	; x,y-pos. set
		LDA	<WORK2
		STA	!POAM+14H
;
		LDX	#0001110011101000B
		LDY	#0101010011101010B
		LDA	<FCNT
		AND	#0000000000000011B
		BEQ	EYMV20		;
;										;
		LDX	#0101110011101000B
		LDY	#0001010011101010B
EYMV20		EQU	$
		STX	!POAM+12H	; char. set
		STY	!POAM+16H
;
		MEM8
		IDX8
		SEP	#00110000B	; memory,index 8bit mode
;
		LDA	#002H
		STA	!POAMSB+4
		STA	!POAMSB+5
		RTS
;
;
;********************************************************************
;*			Umi main								(PLMAIN5)		*
;********************************************************************
PLMAIN5
		JSR	OAMCLR		; OAM clear
;
		LDA	<FCNT
		AND	#00000011B
		BNE	PLM5100		;
;										;
		LDA	<SCCV11
		EOR	#00000001B
		STA	<SCCV11
PLM5100		EQU	$
		JSR	PLM5200
PLMRTS		EQU	$
		RTS
;
PLM5200		EQU	$
		LDA	<GAMEMD
		JSL	>JSRSUB
		WORD	UMIMV		; 0 : umi move
		WORD	UMIWT0		; 1 : umi write - 0
		WORD	UMIWT1		; 2 :           - 1
;
;
;
;********************************************************************
;*			Kagerou move							(KAGEMV)		*
;********************************************************************
KGPOWR		EQU	$		; G-power data
		WORD	0FF20H,000E0H
KGLMTD		EQU	$		; limit check data
		WORD	0F400H,00C00H
;
;
KAGEMV		EQU	$
		LDA	<FCNT
		LSR	A
		BCS	PLMRTS		; move ok ?
;										; yes
		MEM16
		IDX16
		REP	#00110000B	; memory,index 16bit mode
;
		LDX	#01D4H
		LDY	#01E4H
		LDA	#0006H
		STA	<WORK0
		LDA	#0007H
		STA	<WORK2
KGMV20		EQU	$
		LDA	!HDMABF+00H,X
		STA	!HDMABF+00H,Y
		STA	!HDMABF+04H,Y
		STA	!HDMABF+08H,Y
		STA	!HDMABF+0CH,Y
		TXA
		SEC
		SBC	#0010H
		TAX
		DEC	<WORK0
		BNE	KGMV40		; next buffer ?
;										; yes
		LDA	#0008H
		STA	<WORK0
		DEX
KGMV40		EQU	$
		TYA
		SEC
		SBC	#0010H
		TAY
		DEC	<WORK2
		BNE	KGMV60		; next buffer ?
;										; yes
		LDA	#0008H
		STA	<WORK2
		DEY
KGMV60		EQU	$
		CPY	#0001H
		BNE	KGMV20		; end ?
;										; yes
		LDX	<KGMUKI
		LDA	<KGXPBF
		CLC
		ADC	!KGPOWR,X
		PHA			; (A) push
		SEC
		SBC	!KGLMTD,X
		EOR	!KGLMTD,X
		BMI	KGMV140		; limit ?
;										; yes
		LDA	<KGMUKI
		EOR	#0002H
		STA	<KGMUKI
;
		PLA			; (A) pull
		LDA	!KGLMTD,X
		PHA			; (A) push
KGMV140		EQU	$
		PLA			; (A) pull
		STA	<KGXPBF
		CLC
		ADC	<KGXPCT
		PHA			; (A) push
		AND	#00FFH
		STA	<KGXPCT
		PLA			; (A) pull
		BPL	KGMV180		;
;										;
		ORA	#000FFH
KGMV180		EQU	$
		XBA
		CLC
		ADC	!HDMABF+01H
		STA	!HDMABF+01H
		STA	!HDMABF+05H
		STA	!HDMABF+09H
		STA	!HDMABF+0DH
;
		MEM8
		IDX8
		SEP	#00110000B	; memory,index 8bit mode
KGMV300		EQU	$
		RTS
;
;
;
;
;;KGADDT		EQU		$					; add. data
;;			WORD	00001H,00001H,00001H,00001H,00001H,00001H,00001H,00001H
;;			WORD	00001H,00001H,00001H,00001H,00001H,00001H,00001H,00001H
;;			WORD	00001H,00001H,00000H,00001H,00001H,00000H,00001H,00000H
;;			WORD	00001H,00000H,00001H,00000H,00001H,00000H,00000H,00001H
;;;
;;			WORD	00000H,00000H,00000H,00000H
;;;
;;			WORD	0FFFFH,00000H,00000H,0FFFFH,00000H,0FFFFH,00000H,0FFFFH
;;			WORD	00000H,0FFFFH,00000H,0FFFFH,0FFFFH,00000H,0FFFFH,0FFFFH
;;			WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
;;			WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
;;;
;;			WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
;;			WORD	0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH,0FFFFH
;;			WORD	0FFFFH,0FFFFH,00000H,0FFFFH,0FFFFH,00000H,0FFFFH,00000H
;;			WORD	0FFFFH,00000H,0FFFFH,00000H,0FFFFH,00000H,00000H,0FFFFH
;;;
;;			WORD	00000H,00000H,00000H,00000H
;;;
;;			WORD	00001H,00000H,00000H,00001H,00000H,00001H,00000H,00001H
;;			WORD	00000H,00001H,00000H,00001H,00001H,00000H,00001H,00001H
;;			WORD	00001H,00001H,00001H,00001H,00001H,00001H,00001H,00001H
;;			WORD	00001H,00001H,00001H,00001H,00001H,00001H,00001H,00001H
;;;
;;;
;;KAGEMV		EQU		$
;;			LDA		<FCNT
;;			LSR		A
;;			BCC		KGMV10				;
;;;										;
;;			RTS
;;;
;;KGMV10		EQU		$
;;			MEM16
;;			IDX16
;;			REP		#00110000B			; memory,index 16bit mode
;;;
;;			LDX		#0000H
;;			LDY		#0000H
;;KGMV20		EQU		$
;;			STY		<WORK0
;;			LDA		!KGPTBL,Y
;;			TAY
;;			LDA		!KGADDT,Y			; (A) <-- add. data
;;;
;;			CPX		#0180H
;;			BCS		KGMV140				;
;;;										;
;;			CPX		#0100H
;;			BCS		KGMV120				;
;;;										;
;;			CPX		#0080H
;;			BCS		KGMV100				;
;;;										;
;;			CLC
;;			ADC		!HDMABF+01H,X
;;			STA		!HDMABF+01H,X
;;			STA		!HDMABF+05H,X
;;			STA		!HDMABF+09H,X
;;			STA		!HDMABF+0DH,X
;;			BRA		KGMV200
;;;
;;KGMV100		EQU		$
;;			CLC
;;			ADC		!HDMABF+02H,X
;;			STA		!HDMABF+02H,X
;;			STA		!HDMABF+06H,X
;;			STA		!HDMABF+0AH,X
;;			STA		!HDMABF+0EH,X
;;			BRA		KGMV200
;;;
;;KGMV120		EQU		$
;;			CLC
;;			ADC		!HDMABF+03H,X
;;			STA		!HDMABF+03H,X
;;			STA		!HDMABF+07H,X
;;			STA		!HDMABF+0BH,X
;;			STA		!HDMABF+0FH,X
;;			BRA		KGMV200
;;;
;;KGMV140		EQU		$
;;			CLC
;;			ADC		!HDMABF+04H,X
;;			STA		!HDMABF+04H,X
;;			STA		!HDMABF+08H,X
;;			STA		!HDMABF+0CH,X
;;			STA		!HDMABF+10H,X
;;KGMV200		EQU		$
;;			LDY		<WORK0
;;			LDA		!KGPTBL,Y
;;			CLC
;;			ADC		#0002H
;;			CMP		#0110H
;;			BCC		KGMV240				; limit ?
;;;										;
;;			LDA		#0000H
;;KGMV240		EQU		$
;;			STA		!KGPTBL,Y
;;;
;;			INY
;;			INY
;;			TXA
;;			CLC
;;			ADC		#0010H
;;			TAX
;;			CMP		<KAGEPT
;;			BCC		KGMV20				; end ?
;;;										; yes
;;KGMV300		EQU		$
;;			CMP		#01F0H
;;			BCS		KGMV340				;
;;;										;
;;			LDA		<KAGEPT
;;			CLC
;;			ADC		#0008H
;;			STA		<KAGEPT
;;KGMV340		EQU		$
;;			MEM8
;;			IDX8
;;			SEP		#00110000B			; memory,index 8bit mode
;;			RTS
;
;
;********************************************************************
;*			Kiri move								(KIRIMV)		*
;********************************************************************
KIRIMV		EQU	$
		JSR	KCGCNG		; kiri CG. change
;
		LDA	<KIRIXP
		CLC
		ADC	#60H
		STA	<KIRIXP
		LDA	<SCCH1
		ADC	#00H
		STA	<SCCH1
;
		LDA	<KIRIYP
		CLC
		ADC	#30H
		STA	<KIRIYP
		LDA	<SCCV1
		ADC	#00H
		STA	<SCCV1
		RTS
;
;
;********************************************************************
;*			Kiri CG. change							(KCGCNG)		*
;********************************************************************
CGCHDT		EQU	$		; CG. change check data
;					0123456789ABCDEF
		WORD	1111111111111111B; color -  0
		WORD	1111111111111111B
		WORD	1111111111111110B;       -  1
		WORD	1111111111111111B
		WORD	0111111111111111B;       -  2
		WORD	0111111111111111B
		WORD	0111111111011111B;       -  3
		WORD	1111101111111111B
;
		WORD	0111111101111111B;       -  4
		WORD	0111111101111111B
		WORD	0111110111110111B;       -  5
		WORD	1110111110111111B
		WORD	0111101111011111B;       -  6
		WORD	0111101111011111B
		WORD	0111011110111011B;       -  7
		WORD	1101110111101111B
;
;					0123456789ABCDEF
		WORD	0111011101110111B;       -  8
		WORD	0111011101110111B
		WORD	0110111011011101B;       -  9
		WORD	1011101101110111B
		WORD	0110110110110111B;       -  A
		WORD	0110110110110111B
		WORD	0101101101101101B;       -  B
		WORD	1011011011011011B
;
		WORD	0101101101011011B;       -  C
		WORD	0101101101011011B
		WORD	0101011010110110B;       -  D
		WORD	1010110101101011B
		WORD	0101010101010101B;       -  E
		WORD	1010110101101011B
		WORD	0101010101010101B;       -  F
		WORD	1010101010101011B
;
;					0123456789ABCDEF
		WORD	0101010101010101B;       - 10
		WORD	0101010101010101B
		WORD	0010101001010101B;       - 11
		WORD	0101010101010101B
		WORD	0010101001010101B;       - 12
		WORD	0010101001010101B
		WORD	0010100101001010B;       - 13
		WORD	0101001010010101B
;
		WORD	0010010100100101B;       - 14
		WORD	0010010100100101B
		WORD	0010010010010010B;       - 15
		WORD	0100100100100101B
		WORD	0001001001001001B;       - 16
		WORD	0001001001001001B
		WORD	0001000100100010B;       - 17
		WORD	0100010010001001B
;
;					0123456789ABCDEF
		WORD	0001000100010001B;       - 18
		WORD	0001000100010001B
		WORD	0000100001000100B;       - 19
		WORD	0010001000010001B
		WORD	0000010000100001B;       - 1A
		WORD	0000010000100001B
		WORD	0000001000001000B;       - 1B
		WORD	0001000001000001B
;
		WORD	0000000100000001B;       - 1C
		WORD	0000000100000001B
		WORD	0000000000100000B;       - 1D
		WORD	0000010000000001B
		WORD	0000000000000001B;       - 1E
		WORD	0000000000000001B
		WORD	0000000000000000B;       - 1F
		WORD	0000000000000001B
;
;
CCHKDT		EQU	$		; CG. change check data
		WORD	1000000000000000B; 0
		WORD	0100000000000000B; 1
		WORD	0010000000000000B; 2
		WORD	0001000000000000B; 3
		WORD	0000100000000000B; 4
		WORD	0000010000000000B; 5
		WORD	0000001000000000B; 6
		WORD	0000000100000000B; 7
		WORD	0000000010000000B; 8
		WORD	0000000001000000B; 9
		WORD	0000000000100000B; A
		WORD	0000000000010000B; B
		WORD	0000000000001000B; C
		WORD	0000000000000100B; D
		WORD	0000000000000010B; E
		WORD	0000000000000001B; F
;
;
KCGCNG		EQU	$
		LDA	<FCNT
		AND	#00000011B
		BEQ	KCNG10		;
;										;
		RTS
;
KCNG10		EQU	$
		LDA	<CCNGCT
		AND	#00001111B
		ASL	A
		TAY
;
		MEM16
		REP	#00100000B	; memory 16bit mode
;
		LDA	!CCHKDT,Y
		STA	<WORKC		; (workc) <-- check data
;
		LDX	#00H
KCNG20		EQU	$
		LDA	!CGRAM+040H,X
		AND	#0000000000011111B
		ASL	A
		ASL	A
		STA	<WORK0		; (work0) <-- RED data
		LDA	!CGRAM+040H,X
		AND	#0000001111100000B
		LSR	A
		LSR	A
		LSR	A
		STA	<WORK2		; (work2) <-- GREEN data
		LDA	!CGRAM+040H,X
		AND	#0111110000000000B
		XBA
		STA	<WORK4		; (work4) <-- BLUE data
;
		LDA	!CGWORK+040H,X
		AND	#0000000000011111B
		STA	<WORK6		; (work6) <-- RED data
		LDA	!CGWORK+040H,X
		AND	#0000001111100000B
		STA	<WORK8		; (work8) <-- GREEN data
		LDA	!CGWORK+040H,X
		AND	#0111110000000000B
		STA	<WORKA		; (workA) <-- BLUE data
;
		LDY	<KIRIFG
		BEQ	KCNG200		;
;										;
		LDY	<CCNGCT
		CPY	#10H
		BCS	KCNG100		;
;										;
		LDY	<WORK0
		LDA	!CGCHDT,Y
		AND	<WORKC
		BNE	KCNG40		; CG. change ?
;										; yes
		INC	<WORK6
KCNG40		EQU	$
		LDY	<WORK2
		LDA	!CGCHDT,Y
		AND	<WORKC
		BNE	KCNG60		; CG. change ?
;										; yes
		LDA	<WORK8
		CLC
		ADC	#0000000000100000B
		STA	<WORK8
KCNG60		EQU	$
		LDY	<WORK4
		LDA	!CGCHDT,Y
		BRA	KCNG160
;
KCNG100		EQU	$
		LDY	<WORK0
		LDA	!CGCHDT+2,Y
		AND	<WORKC
		BNE	KCNG120		; CG. change ?
;										; yes
		INC	<WORK6
KCNG120		EQU	$
		LDY	<WORK2
		LDA	!CGCHDT+2,Y
		AND	<WORKC
		BNE	KCNG140		; CG. change ?
;										; yes
		LDA	<WORK8
		CLC
		ADC	#0000000000100000B
		STA	<WORK8
KCNG140		EQU	$
		LDY	<WORK4
		LDA	!CGCHDT+2,Y
KCNG160		EQU	$
		AND	<WORKC
		BNE	KCNG180		; CG. change ?
;										; yes
		LDA	<WORKA
		CLC
		ADC	#0000010000000000B
		STA	<WORKA
KCNG180		EQU	$
		BRA	KCNG380
;
;
KCNG200		EQU	$
		LDY	<CCNGCT
		CPY	#10H
		BCS	KCNG300		;
;										;
		LDY	<WORK0
		LDA	!CGCHDT,Y
		AND	<WORKC
		BNE	KCNG220		; CG. change ?
;										; yes
		DEC	<WORK6
KCNG220		EQU	$
		LDY	<WORK2
		LDA	!CGCHDT,Y
		AND	<WORKC
		BNE	KCNG240		; CG. change ?
;										; yes
		LDA	<WORK8
		SEC
		SBC	#0000000000100000B
		STA	<WORK8
KCNG240		EQU	$
		LDY	<WORK4
		LDA	!CGCHDT,Y
		BRA	KCNG360
;
KCNG300		EQU	$
		LDY	<WORK0
		LDA	!CGCHDT+2,Y
		AND	<WORKC
		BNE	KCNG320		; CG. change ?
;										; yes
		DEC	<WORK6
KCNG320		EQU	$
		LDY	<WORK2
		LDA	!CGCHDT+2,Y
		AND	<WORKC
		BNE	KCNG340		; CG. change ?
;										; yes
		LDA	<WORK8
		SEC
		SBC	#0000000000100000B
		STA	<WORK8
KCNG340		EQU	$
		LDY	<WORK4
		LDA	!CGCHDT+2,Y
KCNG360		EQU	$
		AND	<WORKC
		BNE	KCNG380		; CG. change ?
;										; yes
		LDA	<WORKA
		SEC
		SBC	#0000010000000000B
		STA	<WORKA
KCNG380		EQU	$
		LDA	<WORK6
		ORA	<WORK8
		ORA	<WORKA
		STA	!CGWORK+40H,X
;
		INX
		INX
		CPX	#20H
		BEQ	KCNG400		; end ?
;										; no
		JMP	KCNG20
;
KCNG400		EQU	$
		MEM8
		SEP	#00100000B	; memory 8bit mode
;
		INC	<CCNGFG		; CG. VMA flag on
;
		INC	<CCNGCT
		LDA	<CCNGCT
		CMP	#1FH
		BNE	KCNG440		; end ?
;										; yes
		LDA	<KIRIFG
		EOR	#00000001B
		STA	<KIRIFG
;
		STZ	<CCNGCT
KCNG440		EQU	$
		RTS
;
;
;********************************************************************
;*			Kiri main								(PLM3000)		*
;********************************************************************
ROOMD0		EQU	$		; X(+),Y(+)
;					  0    1    2    3    4    5    6    7
		BYTE	000H,001H,001H,000H,000H,001H,001H,000H
		BYTE	002H,003H,003H,002H,002H,003H,003H,002H
		BYTE	002H,003H,003H,002H,002H,003H,003H,002H
ROOMD2		EQU	$		; Y(-)
		BYTE	000H,001H,001H,000H,000H,001H,001H,000H
;
		BYTE	000H,001H,001H,000H,000H,001H,001H,000H
		BYTE	002H,003H,003H,002H,002H,003H,003H,002H
		BYTE	002H,003H,003H,002H,002H,003H,003H,002H
		BYTE	000H,001H,001H,000H,000H,001H,001H,000H
;
		BYTE	000H,001H,001H,000H,000H,001H,001H,000H
		BYTE	002H,003H,003H,002H,002H,003H,003H,002H
		BYTE	002H,003H,003H,002H,002H,003H,003H,002H
;
ROOMD1		EQU	$		; X(-)
;					  0    1    2    3    4    5    6    7
		BYTE	000H,000H,001H,001H,000H,000H,001H,001H
		BYTE	002H,002H,003H,003H,002H,002H,003H,003H
		BYTE	002H,002H,003H,003H,002H,002H,003H,001H
		BYTE	000H,000H,001H,001H,000H,000H,001H,003H
;
		BYTE	000H,000H,001H,001H,000H,000H,001H,001H
		BYTE	002H,002H,003H,003H,002H,002H,003H,003H
		BYTE	002H,002H,003H,003H,002H,002H,003H,001H
		BYTE	000H,000H,001H,001H,000H,000H,001H,003H
;
;
;
PLMOVE		EQU	$
		LDA	<KEYA1
		AND	#00010000B
		BEQ	PLMV20		; start on ?
;										; yes
		MEM16
		REP	#00100000B	; memory 16bit mode
;
		LDA	#0C00H
		STA	<KGXPBF
		LDX	#7EH
		LDA	<SCCH2
PLMV10		EQU	$
		STA	!HDMABF+01H,X
		STA	!HDMABF+82H,X
		STA	!HDMABF+103H,X
		STA	!HDMABF+184H,X
		DEX
		DEX
		BPL	PLMV10		;
;										;
		MEM8
		SEP	#00100000B	; memory 8bit mode
;
		LDA	#03H
		STA	<GAMEMD
		LDA	#10000000B
		STA	420CH
		RTS
;
PLMV20		EQU	$
		LDA	<KEYA1
		AND	#00001111B
		BEQ	PLMV999		; move ?
;										; yes
		AND	#00000011B
		BNE	PLMV80		; L,R move ?
;										; no
		JMP	PLMV100
;
PLMV80		EQU	$
		LSR	A
		BCC	XCALC9		; Right move ?
;										; yes
;
;********************************************************************
;*			X-move (+)								(XCALC8)		*
;********************************************************************
XCALC8		EQU	$
		MEM16
		REP	#00100000B	; memory 16bit mode
;
		LDA	<SCCH2
		CLC
		ADC	#0001H
		STA	<SCCH2
;
		LDA	<SCCH1
		CLC
		ADC	#0001H
		STA	<SCCH1
;
		MEM8
		SEP	#00100000B	; memory 8bit mode
;
		LDA	<SCCH2
		BNE	XCL880		; next room write ?
;										; yes
		LDA	<RMCTXH
		CLC
		ADC	#00000001B
		AND	#00000111B
		STA	<RMCTXH
		ORA	<RMCTYH
		TAY
		LDA	!ROOMD0,Y
		ASL	A
		ASL	A
		TAX
		LDA	<RMCTXH
		AND	#00000001B
		BNE	XCL840		; after ?
;										; yes
		INC	<GAMEMD
		INX
		TXA
		AND	#00001111B
		TAX
XCL840		EQU	$
		STX	<RDPTF0		; data point-0 set
		INX
		INX
;
		LDA	<SCCV21
		AND	#00000001B
		TAY
		TXA
		CPY	#00H
		BEQ	XCL860		; next room ?
;										; yes
		CLC
		ADC	#00001000B
XCL860		EQU	$
		AND	#00001111B
		STA	<RDPTF1		; data point-1 set
;
		INC	<GAMEMD
		LDA	#03H
		STA	<SCRLFG
XCL880		EQU	$
PLMV999		EQU	$
		RTS
;
;
;********************************************************************
;*			X-move (-)								(XCALC9)		*
;********************************************************************
XCALC9		EQU	$
		MEM16
		REP	#00100000B	; memory 16bit mode
;
		LDA	<SCCH2
		SEC
		SBC	#0001H
		STA	<SCCH2
;
		LDA	<SCCH1
		SEC
		SBC	#0001H
		STA	<SCCH1
;
		MEM8
		SEP	#00100000B	; memory 8bit mode
;
		LDA	<SCCH2
		CMP	#0FFH
		BNE	XCL980		; next room write ?
;										; yes
		LDA	<RMCTXH
		SEC
		SBC	#00000001B
		AND	#00000111B
		STA	<RMCTXH
		ORA	<RMCTYH
		TAY
		LDA	!ROOMD1,Y
		ASL	A
		ASL	A
		TAX
		LDA	<RMCTXH
		AND	#00000001B
		BEQ	XCL940		; after ?
;										; yes
		INX
		INC	<GAMEMD
XCL940		EQU	$
		STX	<RDPTF0		; data point-0 set
		INX
		INX
;
		LDA	<SCCV21
		AND	#00000001B
		TAY
		TXA
		CPY	#00000000B
		BEQ	XCL960		; next room ?
;										; yes
		CLC
		ADC	#00001000B
XCL960		EQU	$
		AND	#00001111B
		STA	<RDPTF1		; data point-1 set
;
		LDY	#03H
		STY	<SCRLFG
		INC	<GAMEMD
XCL980		EQU	$
		RTS
;
;
PLMV100		EQU	$
		LDA	KEYA1
		AND	#00000100B
		BEQ	YCALC9		; down move ?
;										; yes
;********************************************************************
;*			Y-move (+)								(YCALC8)		*
;********************************************************************
YCALC8		EQU	$
		MEM16
		REP	#00100000B	; memory 16bit mode
;
		LDA	<SCCV2
		CLC
		ADC	#0001H
		STA	<SCCV2
;
		LDA	<SCCV1
		CLC
		ADC	#0001H
		STA	<SCCV1
;
		MEM8
		SEP	#00100000B	; memory 8bit mode
;
		LDA	<SCCV2
		BNE	YCL880		; next room write ?
;										; yes
		LDA	<RMCTYH
		CLC
		ADC	#00001000B
		AND	#00111000B
		STA	<RMCTYH
		ORA	<RMCTXH
		TAY
		LDA	!ROOMD0,Y
		ASL	A
		ASL	A
		TAX
		LDA	<RMCTYH
		AND	#00001000B
		BNE	YCL840		; after ?
;										; yes
		INX
		INX
		TXA
		AND	#00001111B
		TAX
		INC	<GAMEMD
YCL840		EQU	$
		STX	<RDPTF0		; data point-0 set
		INX
;
		LDA	<SCCH21
		AND	#00000001B
		TAY
		TXA
		CPY	#00000000B
		BEQ	YCL860		; next room ?
;										; yes
		STA	<WORK0
		AND	#00000100B
		EOR	#00000100B
		ASL	A
		SEC
		SBC	#00000100B
		CLC
		ADC	<WORK0
YCL860		EQU	$
		AND	#00001111B
		STA	<RDPTF1		; data point-1 set
;
		LDY	#01H
		STY	<SCRLFG
		INC	<GAMEMD		;
YCL880		EQU	$
		RTS
;
;
;********************************************************************
;*			Y-move (-)								(YCALC9)		*
;********************************************************************
YCALC9		EQU	$
		MEM16
		REP	#00100000B	; memory 16bit mode
;
		LDA	<SCCV2
		SEC
		SBC	#0001H
		STA	<SCCV2
;
		LDA	<SCCV1
		SEC
		SBC	#0001H
		STA	<SCCV1
;
		MEM8
		SEP	#00100000B	; memory 8bit mode
;
		LDA	<SCCV2
		CMP	#0FFH
		BNE	YCL980		; next room write ?
;										; yes
		LDA	<RMCTYH
		SEC
		SBC	#00001000B
		AND	#00111000B
		STA	<RMCTYH
		ORA	<RMCTXH
		TAY
		LDA	!ROOMD2,Y
		ASL	A
		ASL	A
		TAX
		LDA	<RMCTYH
		AND	#00001000B
		BEQ	YCL940		; after ?
;										; yes
		INX
		INX
		INC	<GAMEMD
YCL940		EQU	$
		STX	<RDPTF0		; data point-0 set
		INX
;
		LDA	<SCCH21
		AND	#00000001B
		TAY
		TXA
		CPY	#00000000B
		BEQ	YCL960		; next room ?
;										;
		STA	<WORK0
		AND	#00000100B
		EOR	#00000100B
		ASL	A
		SEC
		SBC	#00000100B
		CLC
		ADC	<WORK0
YCL960		EQU	$
		AND	#00001111B
		STA	<RDPTF1		; data point-1 set
;
		LDY	#01H
		STY	<SCRLFG
		INC	<GAMEMD
YCL980		EQU	$
		RTS
;
;
;
;********************************************************************
;*			Window move								(WDMOVE)		*
;********************************************************************
WDMOVE		EQU	$
		LDA	<KEYA2
		AND	#00010000B
		BEQ	WDMV40		; start on ?
;										; yes
		LDA	#03H
		STA	<GAMEMD
		RTS
;
WDMV40		EQU	$
		LDA	KEYA1
		AND	#00001111B
		BEQ	WDMV999		; move ?
;										; yes
		AND	#00000011B
		BNE	WDMV80		; L,R move ?
;										; no
		JMP	WDMV100
;
WDMV80		EQU	$
		LSR	A
		BCC	XCALC1		; Right move ?
;										; yes
;
;********************************************************************
;*			X-move (+)								(XCALC0)		*
;********************************************************************
XCALC0		EQU	$
		MEM16
		REP	#00100000B	; memory 16bit mode
;
		LDA	<SCCH2
		CLC
		ADC	#0001H
		STA	<SCCH2
		LSR	A
		BCS	XCL020		;
;										;
		LDA	<SCCH1
		CLC
		ADC	#0001H
		STA	<SCCH1
XCL020		EQU	$
		MEM8
		SEP	#00100000B	; memory 8bit mode
;
		LDA	<SCCH2
		BNE	XCL080		; next room write ?
;										; yes
		LDA	<RMCTXH
		CLC
		ADC	#00000001B
		AND	#00000111B
		STA	<RMCTXH
		ORA	<RMCTYH
		TAY
		LDA	!ROOMD0,Y
		ASL	A
		ASL	A
		TAX
		LDA	<RMCTXH
		AND	#00000001B
		BNE	XCL040		; after ?
;										; yes
		INC	<GAMEMD
		INX
		TXA
		AND	#00001111B
		TAX
XCL040		EQU	$
		STX	<RDPTF0		; data point-0 set
		INX
		INX
;
		LDA	<SCCV21
		AND	#00000001B
		TAY
		TXA
		CPY	#00H
		BEQ	XCL060		; next room ?
;										; yes
		CLC
		ADC	#00001000B
XCL060		EQU	$
		AND	#00001111B
		STA	<RDPTF1		; data point-1 set
;
		INC	<GAMEMD
		LDA	#03H
		STA	<SCRLFG
XCL080		EQU	$
WDMV999		EQU	$
		RTS
;
;
;********************************************************************
;*			X-move (-)								(XCALC1)		*
;********************************************************************
XCALC1		EQU	$
		MEM16
		REP	#00100000B	; memory 16bit mode
;
		LDA	<SCCH2
		SEC
		SBC	#0001H
		STA	<SCCH2
		LSR	A
		BCS	XCL120		;
;										;
		LDA	<SCCH1
		SEC
		SBC	#0001H
		STA	<SCCH1
XCL120		EQU	$
		MEM8
		SEP	#00100000B	; memory 8bit mode
;
		LDA	<SCCH2
		CMP	#0FFH
		BNE	XCL180		; next room write ?
;										; yes
		LDA	<RMCTXH
		SEC
		SBC	#00000001B
		AND	#00000111B
		STA	<RMCTXH
		ORA	<RMCTYH
		TAY
		LDA	!ROOMD1,Y
		ASL	A
		ASL	A
		TAX
		LDA	<RMCTXH
		AND	#00000001B
		BEQ	XCL140		; after ?
;										; yes
		INX
		INC	<GAMEMD
XCL140		EQU	$
		STX	<RDPTF0		; data point-0 set
		INX
		INX
;
		LDA	<SCCV21
		AND	#00000001B
		TAY
		TXA
		CPY	#00000000B
		BEQ	XCL160		; next room ?
;										; yes
		CLC
		ADC	#00001000B
XCL160		EQU	$
		AND	#00001111B
		STA	<RDPTF1		; data point-1 set
;
		LDY	#03H
		STY	<SCRLFG
		INC	<GAMEMD
XCL180		EQU	$
		RTS
;
;
WDMV100		EQU	$
		LDA	KEYA1
		AND	#00000100B
		BEQ	YCALC1		; down move ?
;										; yes
;********************************************************************
;*			Y-move (+)								(YCALC0)		*
;********************************************************************
YCALC0		EQU	$
		MEM16
		REP	#00100000B	; memory 16bit mode
;
		LDA	<SCCV2
		CLC
		ADC	#0001H
		STA	<SCCV2
		LSR	A
		BCS	YCL020		;
;										;
		LDA	<SCCV1
		CLC
		ADC	#0001H
		STA	<SCCV1
YCL020		EQU	$
		MEM8
		SEP	#00100000B	; memory 8bit mode
;
		LDA	<SCCV2
		BNE	YCL080		; next room write ?
;										; yes
		LDA	<RMCTYH
		CLC
		ADC	#00001000B
		AND	#00111000B
		STA	<RMCTYH
		ORA	<RMCTXH
		TAY
		LDA	!ROOMD0,Y
		ASL	A
		ASL	A
		TAX
		LDA	<RMCTYH
		AND	#00001000B
		BNE	YCL040		; after ?
;										; yes
		INX
		INX
		TXA
		AND	#00001111B
		TAX
		INC	<GAMEMD
YCL040		EQU	$
		STX	<RDPTF0		; data point-0 set
		INX
;
		LDA	<SCCH21
		AND	#00000001B
		TAY
		TXA
		CPY	#00000000B
		BEQ	YCL060		; next room ?
;										; yes
		STA	<WORK0
		AND	#00000100B
		EOR	#00000100B
		ASL	A
		SEC
		SBC	#00000100B
		CLC
		ADC	<WORK0
YCL060		EQU	$
		AND	#00001111B
		STA	<RDPTF1		; data point-1 set
;
		LDY	#01H
		STY	<SCRLFG
		INC	<GAMEMD		;
YCL080		EQU	$
		RTS
;
;
;********************************************************************
;*			Y-move (-)								(YCALC1)		*
;********************************************************************
YCALC1		EQU	$
		MEM16
		REP	#00100000B	; memory 16bit mode
;
		LDA	<SCCV2
		SEC
		SBC	#0001H
		STA	<SCCV2
		LSR	A
		BCS	YCL120		;
;										;
		LDA	<SCCV1
		SEC
		SBC	#0001H
		STA	<SCCV1
YCL120		EQU	$
		MEM8
		SEP	#00100000B	; memory 8bit mode
;
		LDA	<SCCV2
		CMP	#0FFH
		BNE	YCL180		; next room write ?
;										; yes
		LDA	<RMCTYH
		SEC
		SBC	#00001000B
		AND	#00111000B
		STA	<RMCTYH
		ORA	<RMCTXH
		TAY
		LDA	!ROOMD2,Y
		ASL	A
		ASL	A
		TAX
		LDA	<RMCTYH
		AND	#00001000B
		BEQ	YCL140		; after ?
;										; yes
		INX
		INX
		INC	<GAMEMD
YCL140		EQU	$
		STX	<RDPTF0		; data point-0 set
		INX
;
		LDA	<SCCH21
		AND	#00000001B
		TAY
		TXA
		CPY	#00000000B
		BEQ	YCL160		; next room ?
;										;
		STA	<WORK0
		AND	#00000100B
		EOR	#00000100B
		ASL	A
		SEC
		SBC	#00000100B
		CLC
		ADC	<WORK0
YCL160		EQU	$
		AND	#00001111B
		STA	<RDPTF1		; data point-1 set
;
		LDY	#01H
		STY	<SCRLFG
		INC	<GAMEMD
YCL180		EQU	$
		RTS
;
;
;
;********************************************************************
;*			Next room write - 0						(NRMWT0)		*
;********************************************************************
NRMWT0		EQU	$
		LDA	<SCRLMD
		BNE	NRW040		;
;										;
		JSR	WBUFS0
		INC	<SCRLMD
		RTS
;
NRW040		EQU	$
		JSR	WBUFS1
		STZ	<SCRLMD
		STZ	<GAMEMD
		RTS
;
;
;********************************************************************
;*			Next room write - 1						(NRMWT1)		*
;********************************************************************
NRMWT1		EQU	$
		LDA	<SCRLMD
		BNE	NRW140		;
;										;
		JSR	WBUFS2
		INC	<SCRLMD
		RTS
;
NRW140		EQU	$
		JSR	WBUFS3
		STZ	<SCRLMD
		STZ	<GAMEMD
		RTS
;
;
;********************************************************************
;*			Window move								(WDMAIN)		*
;********************************************************************
WDSTPT		EQU	$		; window stop point
		BYTE	039H,0B0H,000H
WDADD		EQU	$
		BYTE	004H,004H,0FCH
WDADR		EQU	$
		BYTE	001H,038H,0B0H
;
;
WDMAIN		EQU	$
		LDA	<HNKIZN
		CMP	<HNKEI
		BCC	WDMN200		;
;										;
		LDA	<HNKIZN
		BEQ	WDMN100		;
;										;
		LDA	#77H
		SEC
		SBC	<HNKIZN
		STA	<WORK0
		ASL	A
		TAX
		CPX	#80H
		BCC	WDMN20		;
;										;
		INX
WDMN20		EQU	$
		STZ	!HDMABF+01H,X
		STZ	!HDMABF+02H,X
;
		LDA	#77H
		SEC
		SBC	<WORK0
		ASL	A
		TAX
		CPX	#70H
		BCC	WDMN40		;
;										;
		INX
WDMN40		EQU	$
		STZ	!HDMABF+0F3H,X
		STZ	!HDMABF+0F4H,X
;
		DEC	<HNKIZN
		JMP	WDMAIN
;
WDMN100		EQU	$
		RTS
;
WDMN200		EQU	$
		LDA	<WDYPOS
		CMP	#78H
		BCS	WDMN330		;
;										;
		JSR	WDSUB		;
;
		LDA	#77H
		SEC
		SBC	<WDYPOS
		ASL	A
		TAX
		CPX	#80H
		BCC	WDMN300		;
;										;
		INX
WDMN300		EQU	$
		STZ	!HDMABF+01H,X
		STZ	<WORK4
		LDA	#0FFH
		STA	!HDMABF+02H,X
		STA	<WORK3
;
		LDA	<WDXPOS
		BMI	WDMN310		;
;										;
		CLC
		ADC	#80H
		STA	!HDMABF+02H,X
		STA	<WORK3
		LDA	#80H
		SEC
		SBC	<WDXPOS
		STA	!HDMABF+01H,X
		STA	<WORK4
WDMN310		EQU	$
		LDA	#77H
		SEC
		SBC	<WDYPOS
		STA	<WORK0
		LDA	#77H
		SEC
		SBC	<WORK0
		ASL	A
		TAX
		CPX	#70H
		BCC	WDMN320		;
;										;
		INX
WDMN320		EQU	$
		LDA	<WORK4
		STA	!HDMABF+0F3H,X
		LDA	<WORK3
		STA	!HDMABF+0F4H,X
WDMN330		EQU	$
		DEC	<WDYPOS
		LDA	<WDYPOS
		CMP	#0FFH
		BNE	WDMN200		;
;										;
		LDA	#77H
		STA	<HNKIZN
;
		LDA	<HNKEI
		CLC
		ADC	<HNKADD
		TAY
		LDX	<WINDMD
		CMP	!WDSTPT,X
		BNE	WDMN350		; window stop point ?
;										; yes
		INX
		CPX	#03H
		BNE	WDMN340		; limit ?
;										; yes
		LDX	#00H
WDMN340		EQU	$
		STX	<WINDMD
		STZ	<GAMEMD
		LDA	!WDADD,X
		STA	<HNKADD
		LDY	!WDADR,X
WDMN350		EQU	$
		STY	<HNKEI
		STY	<WDYPOS
		RTS
;
;
;
;********************************************************************
;*			Window move sub							(WDSUB)			*
;********************************************************************
WINDDT		EQU	$
		BYTE	0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH
		BYTE	0FFH,0FFH,0FFH,0FFH,0FEH,0FEH,0FEH,0FEH
		BYTE	0FDH,0FDH,0FDH,0FDH,0FCH,0FCH,0FCH,0FBH
		BYTE	0FBH,0FBH,0FAH,0FAH,0F9H,0F9H,0F8H,0F8H
		BYTE	0F7H,0F7H,0F6H,0F6H,0F5H,0F5H,0F4H,0F3H
		BYTE	0F3H,0F2H,0F1H,0F1H,0F0H,0EFH,0EEH,0EEH
		BYTE	0EDH,0ECH,0EBH,0EAH,0E9H,0E9H,0E8H,0E7H
		BYTE	0E6H,0E5H,0E4H,0E3H,0E2H,0E1H,0DFH,0DEH
;
		BYTE	0DDH,0DCH,0DBH,0DAH,0D8H,0D7H,0D6H,0D5H
		BYTE	0D3H,0D2H,0D0H,0CFH,0CDH,0CCH,0CAH,0C9H
		BYTE	0C7H,0C6H,0C4H,0C2H,0C1H,0BFH,0BDH,0BBH
		BYTE	0B9H,0B7H,0B6H,0B4H,0B1H,0AFH,0ADH,0ABH
		BYTE	0A9H,0A7H,0A4H,0A2H,09FH,09DH,09AH,097H
		BYTE	095H,092H,08FH,08CH,089H,086H,082H,07FH
		BYTE	07BH,078H,074H,070H,06CH,067H,063H,05EH
		BYTE	059H,053H,04DH,046H,03FH,037H,02DH,01FH
;
		BYTE	000H
;
;
WDSUB		EQU	$
		LDA	<WDYPOS		; warizan
		STA	4205H		; (H) set
		STZ	4204H		; (L) set
		LDA	<HNKEI
		STA	4206H		; (L) set
		NOP
		NOP
		NOP
		NOP
		NOP
		NOP
		MEM16
		REP	#00100000B	; memory 16bit mode
		LDA	4214H
		LSR	A
		MEM8
		SEP	#00100000B	; memory 8bit mode
		TAX
		LDA	!WINDDT,X
		STA	4202H
		LDA	<HNKEI
		STA	4203H
		NOP
		NOP
		NOP
		NOP
		LDA	4217H
		STA	<WDXPOS
		RTS
;
;
;********************************************************************
;*			Next BG. buffer set-0					(WBUFS0)		*
;********************************************************************
ADRPNT		EQU	$		; data address data
		WORD	08000H,08800H,09000H,09800H
		WORD	0A000H,0A800H,0B000H,0B800H
		WORD	0C000H,0C800H,0D000H,0D800H
		WORD	0E000H,0E800H,0F000H,0F800H
;
WTPNT0		EQU	$		; write point data
		BYTE	00H
		BYTE	01H,05H,09H,0DH
;
;
WBUFS0		EQU	$
		LDA	<RDPTF0
		ASL	A
		TAY
		MEM16
		REP	#00100000B	; memory 16bit mode
;
		LDA	!ADRPNT,Y
;
		IDX16
		REP	#00010000B	; index 16bit mode
;
		TAX
		PHB			; (DBR) push
		LDA	#07FFH
		LDY	#WBGBUF
		MVN	#!0100H
		PLB			; (DBR) pull
;
		MEM8
		IDX8
		SEP	#00110000B	; memory,index 8bit mode
;
		LDX	<SCRLFG
		LDA	!WTPNT0,X
		STA	<NXBWFG		; write point set
		RTS
;
;
;********************************************************************
;*			Next BG. buffer set-1					(WBUFS1)		*
;********************************************************************
WTPNT1		EQU	$		; write point data
		BYTE	00H
		BYTE	02H,06H,0AH,0EH
;
;
WBUFS1		EQU	$
		LDA	<RDPTF1
		ASL	A
		TAY
;
		MEM16
		REP	#00100000B	; memory 16bit mode
;
		LDA	!ADRPNT,Y
;
		IDX16
		REP	#00010000B	; index 16bit mode
;
		PHB			; (DBR) push
		TAX
		LDA	#07FFH
		LDY	#WBGBUF
		MVN	#!0100H
		PLB			; (DBR) pull
;
		MEM8
		IDX8
		SEP	#00110000B	; memory,index 8bit mode
;
		LDX	<SCRLFG
		LDA	!WTPNT1,X
		STA	<NXBWFG		; write point set
		RTS
;
;
;********************************************************************
;*			Next BG. buffer set-2					(WBUFS2)		*
;********************************************************************
WTPNT2		EQU	$		; write point data
		BYTE	00H
		BYTE	03H,07H,0BH,0FH
;
;
WBUFS2		EQU	$
		JSR	WBUFS0		; data set
;
		LDX	<SCRLFG
		LDA	!WTPNT2,X
		STA	<NXBWFG		; write point set
		RTS
;
;
;********************************************************************
;*			Next BG. buffer set-3					(WBUFS3)		*
;********************************************************************
WTPNT3		EQU	$		; write point data
		BYTE	00H
		BYTE	04H,08H,0CH,10H
;
;
WBUFS3		EQU	$
		JSR	WBUFS1		; data set
;
		LDX	<SCRLFG
		LDA	!WTPNT3,X
		STA	<NXBWFG		; write point set
		RTS
;
;
;
;********************************************************************
;*			Umi move								(UMIMV)			*
;********************************************************************
UMADD0		EQU	$
;					 0   1   2   3   4   5   6   7   8
		BYTE	01H,02H,04H,30H,40H,60H,20H,04H,02H
UMADD1		EQU	$
		BYTE	04H,06H,10H,1CH,24H,30H,40H,50H,60H
;
;
UMIMV		EQU	$
		LDA	<UMIFLG
		BNE	UMIM100		; yose wave ?
;										; yes
		LDA	<XSPDBF
		LSR	A
		LSR	A
		TAX
		LDA	<XSPDB0
		SEC
		SBC	!UMADD0,X
		STA	<XSPDB0
		LDA	<XSPDBF
		SBC	#00H
		STA	<XSPDBF
		JSR	XGCALC		; X-G-calc.
		ADC	<SCCH1
		STA	<SCCH1
		CMP	#0FFH
		BCC	UMIM40		; yose wave end ?
;										; yes
		INC	<UMIFLG
		INC	<GAMEMD
		LDA	#000H
		STA	<XSPDBF
UMIM40		EQU	$
		RTS
;
UMIM100		EQU	$
		LDA	#000H
		SEC
		SBC	<XSPDBF
		LSR	A
		LSR	A
		TAX
		LDA	<XSPDB0
		SEC
		SBC	!UMADD1,X
		STA	<XSPDB0
		LDA	<XSPDBF
		SBC	#000H
		STA	<XSPDBF
		JSR	XGCALC		; X-G-calc.
		ADC	<SCCH1
		STA	<SCCH1
		CMP	#040H
		BCS	UMIM140		; hiki wave end ?
;										; yes
		STZ	<UMIFLG
		INC	<GAMEMD
		LDA	#020H
		STA	<XSPDBF
UMIM140		EQU	$
		RTS
;
;
;********************************************************************
;*			X-G-calc.								(XGCALC)		*
;********************************************************************
XGCALC		EQU	$
		LDA	<XSPDBF
		ASL	A
		ASL	A
		ASL	A
		ASL	A
		CLC
		ADC	<XSPDCT
		STA	<XSPDCT
		PHP			; (P) push
		LDA	<XSPDBF
		LSR	A
		LSR	A
		LSR	A
		LSR	A
		CMP	#08H
		BCC	XGCL40		; (-) data ?
;										; yes
		ORA	#0F0H
XGCL40		EQU	$
		PLP			; (P) pull
		RTS
;
;
;********************************************************************
;*			Umi write - 0							(UMIWT0)		*
;********************************************************************
UMIWT0		EQU	$
		LDA	<SCCV11
		BEQ	UMW080		; write ok ?
;										; yes
		IDX16
		REP	#00010000B	; index 16bit mode
;
		LDX	#0A000H
		LDA	<UMIFLG
		BNE	UMW020		; yose wave ?
;										; yes
		LDX	#0A800H
UMW020		EQU	$
		MEM16
		REP	#00100000B	; memory 16bit mode
;
		PHB			; (DBR) push
		LDA	#07FFH
		LDY	#WBGBUF
		MVN	#!0B00H
		PLB			; (DBR) pull
;
		LDX	#07FEH
UMW040		EQU	$
		LDA	>18000H,X
		CLC
		ADC	#2000H
		STA	>18000H,X
		DEX
		DEX
		BPL	UMW040		;
;										;
		MEM8
		IDX8
		SEP	#00110000B	; memory,index 8bit mode
;
		LDA	#12H
		STA	<NXBWFG
		INC	<GAMEMD
UMW080		EQU	$
		RTS
;
;
;********************************************************************
;*			Umi write - 1							(UMIWT1)		*
;********************************************************************
UMIWT1		EQU	$
		LDA	<SCCV11
		BNE	UMW080		; write ok ?
;										; yes
		IDX16
		REP	#00010000B	; index 16bit mode
;
		LDX	#0B000H
		LDA	<UMIFLG
		BNE	UMW120		; yose wave ?
;										; yes
		LDX	#0B800H
UMW120		EQU	$
		JSR	UMW020		; write buffer set
;
		LDA	#14H
		STA	<NXBWFG
		STZ	<GAMEMD
		RTS
;
;
;
;
		END
