
/****************************************************************
/*titl:	bak bg data unit convert  version 1.00
		  Programmed by t.takakura
					[ May.29, 1989 ]
 ****************************************************************/

#include	<stdio.h>
#include	<memory.h>
#include	<strings.h>

#define		unchar		unsigned char
#define		unshort		unsigned short
#define		MAXPNL		0x3000

unshort	pnlbuf[MAXPNL][4] ;		/* panel buffer		*/
unchar   utbuf[MAXPNL];
int	pnllen  = 0 ;			/* panel data length	*/
int	pnlcnt  = 0 ;			/* panel counter	*/
int wrcnt   = 0 ;			/* write count  pnlcnt*4 */
int	clrcode = 0 ;			/* clear code		*/


main( argc,argv )
int	argc ;
char	**argv ;
{
	FILE	*tp ;
	char	tbl_name[65] ;
	char	srn_name[65] ;
	char	pnl_name[65] ;
	char    wk_name[65]  ;
	int	ct = 1 ;

	puts( "\n\nBatck bg unit data & bg data make file  version 1.00" ) ;
	if ( argc != 2 && argc != 3 ) {
		fputs( "usage: mkpanel <FILE name> [clear code]\n",stderr ) ;
		exit( 1 ) ;
	}
	strcpy( tbl_name,*(++argv)) ;
	strcat( tbl_name,".TBL" ) ;
	if (( tp = fopen( tbl_name,"r" )) == NULL ) {
		perror( tbl_name ) ;
		exit( 1 ) ;
	}
	if ( argc == 3 )  clrcode = atoi( *(argv+1)) & 0xff ;

	while ( fgets( srn_name,60,tp ) != NULL ) {
		strcpy(wk_name,srn_name) ;
 		set_sname( srn_name ) ;
 		set1_sname( wk_name ) ;  
		printf("\n name = %s   --->   %s\n",srn_name,wk_name);
		mkpanel( ct++,srn_name ) ;	/*  make panel data	*/
		gendat( wk_name ); /* data file write */
		wrcnt = 0;	
	}
	fclose( tp ) ;

	if ( pnllen > 0x8000 ) {
		printf( "panel data size over. ( size=$%05x )\n", pnllen ) ;
		exit( 1 ) ;
	}

	strcpy( pnl_name,*argv ) ;
    strcat( pnl_name,".PNL" ) ;
	genpnl( pnl_name ) ;			/* ganerate panel data file	*/

	exit( 0 ) ;
}

/******* set screen file name ***********************************/

set_sname( ss )
char	*ss ;
{
	while ((*ss != '\0') && (*ss != '\n')) ss++ ;
	strcpy( ss,".SCR" ) ;
}

/******* set screen unit data file name *************************/

set1_sname( ii )
char	*ii;
{
	while ((*ii != '\0') && (*ii != '\n')) ii++ ;
	strcpy( ii,".DAT" ) ;
}

/****************************************************************/
/*	Make panel data from screen file			*/
/****************************************************************/

mkpanel( nn,fname )
int	nn ;
char	*fname ;
{
	FILE	*rp ;
	unshort	redbuf[0x2000],*dat ;
	unshort	pnldat[4],*pa ;
	int	pct,sct,rct,pn ;

	if (( rp = fopen( fname,"r" )) == NULL ) {
		perror( fname ) ;
		exit( 1 ) ;
	}
	pn = pnlcnt ;
	printf( "%2d screen file \"%s\"\t", nn,fname ) ; 
	fread( redbuf,sizeof(unshort),0x2000,rp ) ;

	dat = redbuf ;
	for ( rct=0 ; rct<4 ; rct++ ) {
		for ( sct=0 ; sct<16 ; sct++ ) {
			for ( pct=0 ; pct<16 ; pct++ ) {
				 pa   =  pnldat ;
				*pa++ = *(dat+ 0) ;
				*pa++ = *(dat+32) ;
				*pa++ = *(dat+ 1) ;
				*pa++ = *(dat+33) ;
				 dat += 2 ;
				setpnl( pnldat ) ;
			}
			dat += 32 ;
		}
	}
	fclose( rp ) ;
	printf( "create %4d panel(s)\n", pnlcnt-pn ) ;
}

/*******  set panel data into panel buffer **********************/

setpnl( pnl )
unshort	*pnl ;
{
	int	pnum ;

	if ( pnlcnt == 0 ) {
		memcpy( pnlbuf[pnlcnt],pnl,sizeof(unshort)*4 ) ;
	    utbuf[wrcnt] = pnlcnt  ;
		pnlcnt++;
		wrcnt++;
		return ( 0 ) ;
	}

	for ( pnum=0 ; pnum<pnlcnt ; pnum++ ) {
		if ( !memcmp( pnlbuf[pnum],pnl,sizeof(unshort)*4 )){
			utbuf[wrcnt] = pnum; 
			wrcnt++;
			return ( pnum ) ;
		}
	}
	if ( pnlcnt == 0xff ) { /*MAXPNL*/
		fputs( "panel data buffer over.\n",stderr ) ;
		exit( 1 ) ;
	}
	memcpy( pnlbuf[pnlcnt],pnl,sizeof(unshort)*4 ) ;
	utbuf[wrcnt] = pnlcnt ;
	pnlcnt++;	
	wrcnt++;
	return ( pnum ) ;
}


/****************************************************************/
/*	Generate panel data file				*/
/****************************************************************/

genpnl( fname )
char	*fname ;
{
	FILE	*wp ;
	int	ct,nn,i ;

	if (( wp = fopen( fname,"w" )) == NULL ) {
		perror( fname ) ;
		exit( 1 ) ;
	}
	if(fwrite(pnlbuf,sizeof(unshort)*4,pnlcnt,wp) != pnlcnt){
		printf("ERROR ERROR \n");
		exit(1) ;
	}
	fclose( wp ) ;
	printf( "total %d panels write.  ( size=$%05x )\n", pnlcnt,pnllen ) ;
}

/****************************************************************/
/*	unit panel data file				*/
/****************************************************************/

gendat( fname )
char	*fname ;
{
	FILE	*wp ;
	int	ct,nn,i ;

	if (( wp = fopen( fname,"w" )) == NULL ) {
		perror( fname ) ;
		exit( 1 ) ;
	}
	if(fwrite(utbuf,sizeof(unchar),wrcnt,wp) != wrcnt){
		printf("ERROR ERROR \n");
		exit(1) ;
	}
	fclose( wp ) ;
}
