/****************************************************************/
/*	Message converter					*/
/*		( gcc msgcnv.c -o msgcnv )			*/
/*						by S.Takahata	*/
/****************************************************************/
#include	<stdio.h>

#if 0
#define DSP
#endif

#define MAXMUM	1000
#define KUGIRI	"\n"

typedef struct{
    unsigned char	name[3];
    unsigned char	label[9];
}LABEL;

static LABEL	cnvdat[MAXMUM];
static int	num;
static FILE	*fpr, *fpw;

static int moji_label(unsigned c);
static int moji_number(unsigned c, int n);

void main(int argc, char **argv)
{
    int		i;
    char	s[256], *s1;
    unsigned char	in_file[40], out_file[44], label_file[40], title[40], OUTPUT[60];

    if(argc < 2){
	printf("Input Error !!\n");
	printf("msgcnv [$(BF~NO%U%!%$%kL>(B] (-l[$(B%i%Y%kL>(B]) (-h[$(BJQ49%U%!%$%kL>(B])\n");
	exit(1);
    }

    strcpy(in_file, argv[1]);
    strcpy(out_file, argv[1]);
    strcat(out_file, ".OUT");
    strcpy(label_file, "../../bin/msg.LBL");
    title[0] = '\0';
    if(argc >= 3){
	for(i = 2; i < argc; i++){
	    if(*argv[i] != '-'){
		printf("Input Error !!\n");
		printf("msgcnv [$(BF~NO%U%!%$%kL>(B] (-l[$(B%i%Y%kL>(B]) (-h[$(BJQ49%U%!%$%kL>(B])\n");
		exit(1);
	    }
	    switch(*(argv[i]+1)){
		case 'l' :
		case 'L' :
		    strcpy(title, argv[i]+2);
		    strcat(title, "\tEQU\t$\n");
		    break;
		case 'h' :
		case 'H' :
		    strcpy(label_file, argv[i]+2);
		    break;
		default :
		    printf("Input Error !!\n");
		    printf("msgcnv [$(BF~NO%U%!%$%kL>(B] (-l[$(B%i%Y%kL>(B]) (-h[$(BJQ49%U%!%$%kL>(B])\n");
		    exit(1);
	    }
	}
    }

    if((fpr = fopen(label_file, "r")) == NULL){
	printf("File Open Error !! [%s]\n", label_file);
	exit(1);
    }

    i = 0;
    while(fgets(s, 256, fpr) != NULL){
	cnvdat[i].name[0] = s[0];
	cnvdat[i].name[1] = '\0';
	strcpy(cnvdat[i].label, s+2);
	cnvdat[i].label[5] = '\0';
#if 0
	s1 = (char *)strtok(s, KUGIRI);
	strcpy(cnvdat[i].name, s1);
	s1 = (char *)strtok(NULL, KUGIRI);
	strcpy(cnvdat[i].label, s1);
#endif
	i ++;
    }

    fclose(fpr);

    if(i < 1){
	printf("LABEL ERROR !!\n");
	exit(1);
    }
    num = i;

    if((fpr = fopen(in_file, "r")) == NULL){
	printf("File Open Error !! [%s]\n", in_file);
	exit(1);
    }
    if((fpw = fopen(out_file, "w")) == NULL){
	printf("File Open Error !! [%s]\n", out_file);
	exit(1);
    }

    printf("START <<< %s >>>\n", in_file);

    fprintf(fpw, "%s", title);

    mojicheck();

    fclose(fpr);
    fclose(fpw);

#ifdef DSP
    strcpy(OUTPUT, "more ");
    strcat(OUTPUT, out_file);
    system(OUTPUT);
#endif
    printf("END\n");
}

mojicheck()
{
    int		i, j, k, no;
    unsigned char	buf[256], number[6], str[256];

    j = 1;
    while(fgets(buf, 256, fpr) != NULL){
	i = 0;
	if((unsigned)buf[0] < 0x20){
	    fprintf(fpw, ";\n");
	}
	else{
	    if((no = moji_label((unsigned)buf[i++])) >= 0){
		k = 1;
		strcpy(str, "\t\tBYTE\t");
		strcat(str, cnvdat[no].label);
		switch(cnvdat[no].name[0]){
		case '@' :
		    moji_number((unsigned)buf[i], j);
		    number[2] = buf[i++];
		    moji_number((unsigned)buf[i], j);
		    number[3] = buf[i++];
		    number[0] = ',';
		    number[1] = '0';
		    number[4] = 'H';
		    number[5] = '\0';
		    strcat(str, number);
		    break;
		}
		while(buf[i] != '\0'){
		    if((no = moji_label((unsigned)buf[i++])) >= 0){
			k ++;
			if(k > 16){
			    strcat(str, "\n\t\tBYTE\t");
			    k = 1;
			}
			else{
			    strcat(str, ",");
			}
			strcat(str, cnvdat[no].label);
			switch(cnvdat[no].name[0]){
			case '@' :
			    moji_number((unsigned)buf[i], j);
			    number[2] = buf[i++];
			    moji_number((unsigned)buf[i], j);
			    number[3] = buf[i++];
			    number[0] = ',';
			    number[1] = '0';
			    number[4] = 'H';
			    number[5] = '\0';
			    strcat(str, number);
			    break;
			}
		    }
		}
		fprintf(fpw, "%s\n", str);
	    }
	}
	j ++;
    }
}

static int moji_label(unsigned c)
{
    int		i;

    for(i = 0; i < num; i ++){
	if(c == (int)cnvdat[i].name[0]){
	    return i;
	}
    }
    return -1;
}

static int moji_number(unsigned c, int n)
{
    static char number[] = {'0', '1', '2', '3', '4', '5', '6', '7',
			    '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    int		i;

    for(i = 0; i < 16; i ++){
	  if(c == (int)number[i])	return i;
    }

    printf("Input Error %d line\n", n);
    exit(1);
}


