#include <math.h>
#include <stdio.h>

#define	PI	3.1415927

#define	CENTZ	246.0
#define	R1	15.0
#define	R2	16.0
#define	R3	8.0
#define	CSZ	32.0

FILE *fpw0;

main()
{
	/****** ram set ******/
	double i,chrsize,dw0,dw1;
	unsigned short a,b,j;

	/****** write file open ******/
	if((fpw0=fopen("angl.dat","w")) == 0){
		printf("can't open !!\n");
		exit(1);
	}

	chrsize = 24.0 * CENTZ;

	/****** cos data label set ******/
	fprintf(fpw0,";************************************************************************\n");
	fprintf(fpw0,";*	\"Hira Hira\" data						*\n");	
	fprintf(fpw0,";************************************************************************\n");

	/****** cos data make ******/
	fprintf(fpw0,"HIRASTEP\tEQU\t$");

	/****** step.1 ******/
	a = ( (chrsize / CENTZ) / CSZ * 256.0 ) + 0.5;
	b = ( CSZ / (chrsize / CENTZ) * 256.0 ) + 0.5;
	for( j=0,i=0.0;i<32.0;i++ ){
		if(j--==0){
			j=3;
			fprintf(fpw0,"\n\t\tWORD\t%05XH,%05XH",b,a);
		}
		else{
			fprintf(fpw0,", %05XH,%05XH",b,a);
		}
	}
	fprintf(fpw0,"\n;");

	/******	step.2 ******/
	for(j=0,i=0.0;i<180.0;i+=(180.0/(R1*PI))){
		dw0=cos(i*(PI/180.0))*chrsize;
		dw1=cos(i*(PI/180.0))*R1;
		dw1 = R1 - dw1;
		a=( (dw0 / (CENTZ-dw1)) / CSZ * 256.0 ) + 0.5;

		dw0=chrsize;
		dw1=cos(i*(PI/180.0))*R1;
		dw1 = R1 - dw1;
		b=( CSZ / (dw0 / (CENTZ-dw1)) * 256.0 ) + 0.5;

		if(j--==0){
			j=3;
			fprintf(fpw0,"\n\t\tWORD\t%05XH,%05XH",b,a);
		}
		else{
			fprintf(fpw0,", %05XH,%05XH",b,a);
		}
	}
	fprintf(fpw0,"\n;");

	/******	step.3 ******/
	for(j=0,i=180.0;i<360.0;i+=(180.0/(R2*PI))){
		dw0=cos(i*(PI/180.0))*chrsize;
		dw1=0-cos(i*(PI/180.0))*R2;
		dw1 = R2 - dw1;
		a=( (dw0 / (CENTZ-dw1-R1*2)) / CSZ * 256.0 ) + 0.5;

		dw0=chrsize;
		dw1=0-cos(i*(PI/180.0))*R2;
		dw1 = R2 - dw1;
		b=( CSZ / (dw0 / (CENTZ-dw1-R1*2)) * 256.0 ) + 0.5;

		if(j--==0){
			j=3;
			fprintf(fpw0,"\n\t\tWORD\t%05XH,%05XH",b,a);
		}
		else{
			fprintf(fpw0,", %05XH,%05XH",b,a);
		}
	}
	fprintf(fpw0,"\n;\n");


	/****** write file close ******/
	fclose(fpw0);

}

