/****************************************************************************/
/*	File : app_init.c														*/
/*																			*/
/*																1993/10/12	*/
/****************************************************************************/
#include			<stdio.h>

#include			<X11/Xlib.h>
#include			<X11/Xutil.h>

#define				DEF_APP_GLOB
#include			"app_glob.c"

#define				DEF_BG_COL			"white"
#define				DEF_FG_COL			"black"
#define				DEF_BD_WID			1
#define				DEF_FONT			"-*-fixed-medium-r-normal--14-*-*-*-*-*-jisx0201.1976-*"
#define				DEF_FONT16			"-*-fixed-medium-r-normal--14-*-*-*-*-*-jisx0208.1983-*"

#define				GCVALMASK			(GCFont | GCForeground | GCBackground)
#define				XGCVALMASK			(GCVALMASK | GCFunction | GCPlaneMask)

typedef struct{
	char				*name,
						**string;
}APP_PARAS;

/* Default parameter values */
char				*BGcol      = DEF_BG_COL,
					*FGcol      = DEF_FG_COL,
					*Ft         = DEF_FONT,
					*Ft16       = DEF_FONT16,
					*Geom_rsrc  = NULL,
					*Disp_name  = NULL,
					*Geom_cline = NULL,
					*Geom       = NULL;


APP_PARAS			resources[] = {
						"background", &BGcol,
						"foreground", &FGcol,
						"font",       &Ft,
						"geometry",   &BGcol,
					};
int					num_res = sizeof(resources) / sizeof(APP_PARAS);

APP_PARAS			options[] = {
						"-display",  &Disp_name,
						"-d",        &Disp_name,
						"-geometry", &Geom_cline,
						"-g       ", &Geom_cline,
					};
int					num_opt = sizeof(options) / sizeof(APP_PARAS);



void		usage();


void app_init(int argc, char **argv, int x, int y, unsigned width, unsigned height)
{
	static char				pattern_bits[] = {0x55, 0xaa, 0x55, 0xaa, 0x55, 0xaa, 0x55, 0xaa};
	static int				pattern_width  = 8,
							pattern_height = 8;
	register int			i, j, bitmask;
	char					*str, def_gom[80];
	Colormap				def_cmap;
	XColor					color;
	XGCValues				gcv, gcv16;
	XSetWindowAttributes	xswa;
	XWMHints				xwmh;
	XSizeHints				xsh;

	Name     = argv[0];
	ExitFlag = 0;


	for(i=1; i<argc; i+=2){
		for(j=0; j<num_opt; j++){
			if(strcmp(options[j].name,argv[i]) == 0){
				*options[j].string = argv[i+1];
				break;
			}
		}
		if(j >= num_opt)	usage();
	}


	if((display = XOpenDisplay(Disp_name)) == NULL){
		fprintf(stderr,"%s: can't open display named %s\n",argv[0],XDisplayName(Disp_name));
		exit(1);
	}

	for(i=0; i<num_res; i++){
		if((str = XGetDefault(display,Name,resources[i].name)) != NULL)	*resources[i].string = str;
	}

	if((font = XLoadQueryFont(display,Ft)) == NULL){
		fprintf(stderr,"%s: display %s cannot load font %s\n",Name,DisplayString(display),Ft);
		exit(1);
	}

	if((font16 = XLoadQueryFont(display,Ft16)) == NULL){
		fprintf(stderr,"%s: display %s cannot load font %s\n",Name,DisplayString(display),Ft16);
		exit(1);
	}

	def_cmap = DefaultColormap(display,DefaultScreen(display));

	if(XParseColor(display,def_cmap,BGcol,&color) == 0 || XAllocColor(display,def_cmap,&color) == 0)
		BG = WhitePixel(display,DefaultScreen(display));
	else	BG = color.pixel;

	if(XParseColor(display,def_cmap,FGcol,&color) == 0 || XAllocColor(display,def_cmap,&color) == 0)
		FG = BlackPixel(display,DefaultScreen(display));
	else	FG = color.pixel;


	xsh.flags  = PPosition | PSize | PMinSize;
	xsh.width  = xsh.min_width  = width;
	xsh.height = xsh.min_height = height;
	xsh.x      = x;
	xsh.y      = y;

	sprintf(def_gom,"%dx%d+%d+%d",xsh.width,xsh.height,xsh.x,xsh.y);
	Geom = def_gom;

	if(Geom_cline != NULL)	Geom = Geom_cline;
	else if(Geom_rsrc != NULL)	Geom = Geom_rsrc;

	bitmask = XGeometry(display,DefaultScreen(display),Geom,def_gom,DEF_BD_WID,
				font->max_bounds.width,font->max_bounds.ascent+font->max_bounds.descent,
				1,1,&(xsh.x),&(xsh.y),&(xsh.width),&(xsh.height));

	if(bitmask & (XValue | YValue))	xsh.flags |= USPosition;
	if(bitmask & (WidthValue | HeightValue))	xsh.flags |= USSize;

	TopWind = XCreateSimpleWindow(display,DefaultRootWindow(display),xsh.x,xsh.y,xsh.width,
				xsh.height,DEF_BD_WID,FG,BG);
	XSetStandardProperties(display,TopWind,Name,Name,None,argv,argc,&xsh);

	xwmh.flags         = InputHint | StateHint;
	xwmh.input         = True;
	xwmh.initial_state = NormalState;
	XSetWMHints(display,TopWind,&xwmh);

	gcv.font         = font->fid;
	gcv.foreground   = FG;
	gcv.background   = BG;
	gc               = XCreateGC(display,TopWind,GCVALMASK,&gcv);
	gcv.function     = GXxor;
	gcv.plane_mask   = BlackPixel(display,DefaultScreen(display)) ^ WhitePixel(display,DefaultScreen(display));
	xorgc            = XCreateGC(display,TopWind,XGCVALMASK,&gcv);
	gcv16.font       = font16->fid;
	gcv16.foreground = FG;
	gcv16.background = BG;
	gc16             = XCreateGC(display,TopWind,GCVALMASK,&gcv16);
	gcv16.function   = GXxor;
	gcv16.plane_mask = BlackPixel(display,DefaultScreen(display)) ^ WhitePixel(display,DefaultScreen(display));
	xorgc16          = XCreateGC(display,TopWind,XGCVALMASK,&gcv16);

	xswa.colormap    = DefaultColormap(display,DefaultScreen(display));
	xswa.bit_gravity = NorthWestGravity;
	XChangeWindowAttributes(display,TopWind,(CWColormap|CWBitGravity),&xswa);

	XSelectInput(display,TopWind,ExposureMask);

	XMapRaised(display,TopWind);

	if(XGetWindowAttributes(display,TopWind,&T_XWA) == 0){
		fprintf(stderr,"Error getting attributes\n");
		exit(2);
	}

	XSetDashes(display,gc,     0,dash,2);
	XSetDashes(display,gc16,   0,dash,2);
	XSetDashes(display,xorgc,  0,dash,2);
	XSetDashes(display,xorgc16,0,dash,2);

	pattern = XCreateBitmapFromData(display, TopWind,
				pattern_bits, pattern_width, pattern_height);
}


void	usage(void)
{
	fprintf(stderr,"%s [-display name] [-geometry geom]\n",Name);
}


