#include <math.h>
#include <stdio.h>

#define unchar	unsigned char
#define unshort unsigned short

#define PI	3.1415927


#define T_MAX	 5

FILE *fp;

void main()
{
	/****** ram set ******/
	unchar	b_point_no;
	char	b_point[256][2];
	unshort x_point_no;
	unshort x_point[256][2];

	double	T;
	unshort x, y;

#ifdef CCC
	double	B1[T_MAX], B2[T_MAX], B3[T_MAX];
	double	x1, y1;
	double	x2, y2;
	double	x3, y3;
#endif

	short	B1[T_MAX], B2[T_MAX], B3[T_MAX];
	short	x1, y1;
	short	x2, y2;
	short	x3, y3;

	unchar	i, j;


	/****** QaXvC\_ǂݍ ******/
	if((fp=fopen("bspline_b.bin","r")) == 0){
		printf("can't open !!\n");
		exit(1);
	}

	b_point_no = ( fread( b_point, sizeof(unchar), 256*2, fp) ) / 2;

	fclose(fp);





	for(i=0; i<b_point_no;i++){
		T = (double)b_point[i][0];
		T = T * (144.0 / 163.0);
		b_point[i][0] = (char)T;
		T = b_point[i][1];
		T = T * (144.0 / 163.0);
		b_point[i][1] = (char)T;
	}

	if((fp=fopen("bspline_b.bin","w")) == 0){
		printf("can't open !!\n");
		exit(1);
	}

	if( fwrite( b_point, sizeof(char), b_point_no*2, fp ) != b_point_no*2 ){
		printf( "write error !!\n" );
		exit(1);
	}

	fclose(fp);






#ifdef AAA
	/****** ******/
	for(x_point_no=0; x_point_no<b_point_no; x_point_no++){
		x_point[x_point_no][0] = (unshort)b_point[x_point_no][0] << 8;
		x_point[x_point_no][1] = (unshort)b_point[x_point_no][1] << 8;
	}
#endif


#ifdef DDD
	/****** QaXvCvZ ******/
	for(T=0.0, i=0; T<1.0; T+=(1.0/T_MAX), i++){
		B1[i] = 0.5 * ((1.0 - T) * (1.0 - T));
		B2[i] = ((1.0 - T) * T) + 0.5;
		B3[i] = 0.5 * (T * T);
	}

	for(i=0, x_point_no=0; i<b_point_no; i++){
		x1 = (double)b_point[(i-1)>=0 ? i-1 : b_point_no-1][0];
		y1 = (double)b_point[(i-1)>=0 ? i-1 : b_point_no-1][1];
		x2 = (double)b_point[i][0];
		y2 = (double)b_point[i][1];
		x3 = (double)b_point[(i+1)<b_point_no ? i+1 : 0][0];
		y3 = (double)b_point[(i+1)<b_point_no ? i+1 : 0][1];

		for(j=0; j<T_MAX; j++){
			x = (unshort)((B1[j] * x1) + (B2[j] * x2) + (B3[j] * x3) + 0.5);
			y = (unshort)((B1[j] * y1) + (B2[j] * y2) + (B3[j] * y3) + 0.5);
			x_point[x_point_no][0] = ((x & 0xff00) >> 8) | ((x & 0x00ff) << 8);
			x_point[x_point_no][1] = ((y & 0xff00) >> 8) | ((y & 0x00ff) << 8);
			x_point_no++;
		}
	}
#endif

	/****** QaXvCvZ ******/
	for(T=0.0, i=0; T<1.0; T+=(1.0/T_MAX), i++){
		B1[i] = (short)((0.48 * ((1.0 - T) * (1.0 - T))) * 64.0);
		B2[i] = (short)((((1.0 - T) * T) + 0.5) * 64.0);
		B3[i] = (short)((0.48 * (T * T)) * 64.0);
	printf( "%04XH, %04XH, %04XH\n", (unshort)B1[i], (unshort)B2[i], (unshort)B3[i]);
	}

	for(i=0, x_point_no=0; i<b_point_no; i++){
		x1 = (short)b_point[(i-1)>=0 ? i-1 : b_point_no-1][0];
		y1 = (short)b_point[(i-1)>=0 ? i-1 : b_point_no-1][1];
		x2 = (short)b_point[i][0];
		y2 = (short)b_point[i][1];
		x3 = (short)b_point[(i+1)<b_point_no ? i+1 : 0][0];
		y3 = (short)b_point[(i+1)<b_point_no ? i+1 : 0][1];

		for(j=0; j<T_MAX; j++){
			x = (unshort)(((B1[j] * x1) + (B2[j] * x2) + (B3[j] * x3) + 32) >> 6);
			y = (unshort)(((B1[j] * y1) + (B2[j] * y2) + (B3[j] * y3) + 32) >> 6);
			x_point[x_point_no][0] = ((x & 0xff00) >> 8) | ((x & 0x00ff) << 8);
			x_point[x_point_no][1] = ((y & 0xff00) >> 8) | ((y & 0x00ff) << 8);
			x_point_no++;
		}
	}


	/****** \_ ******/
	if((fp=fopen("angl.dat","w")) == 0){
		printf("can't open !!\n");
		exit(1);
	}

	if( fwrite( x_point, sizeof(unshort), x_point_no*2, fp ) != x_point_no*2 ){
		printf( "write error !!\n" );
		exit(1);
	}

	fclose(fp);

}

