/******************************************************************************/
/*			    Header command.h				      */
/*									      */
/*			    ver 1.00 91/11/15				      */
/*			    ver 1.50 92/01/17				      */
/******************************************************************************/

extern int InputChar() ;
extern int MoveCursorUp() ;
extern int MoveCursorDown() ;
extern int MoveCursorRight() ;
extern int MoveCursorLeft() ;
extern int ScrollDown() ;
extern int ScrollUp() ;
extern int PageUp() ;
extern int PageDown() ;
extern int MoveTopLine() ;
extern int MoveBottomLine() ;
extern int Tabulation() ;
extern int BackTab() ;
extern int MoveTextTop() ;
extern int MoveTextBottom() ;

extern int DeleteChar() ;
extern int BackSpace() ;
extern int InsertMode() ;
extern int EraseLine() ;
extern int EraseLineAll() ;
extern int InsertLine() ;
extern int DeleteLine() ;
extern int CopyLine() ;
extern int PasteDeletedLine() ;
extern int CarriageReturn() ;
extern int DuplicateLine() ;
extern int AdjustIndent() ;
extern int ChangeAutoIndent() ;
extern int DefineKeyMacro() ;
extern int ExecuteKeyMacro() ;

extern int SetTextBlock() ;
extern int DeleteBlock() ;
extern int CopyBlock() ;
extern int DeleteWord() ;
extern int SavePartText() ;
extern int PasteBlock() ;

extern int SearchString() ;
extern int ReplaceString() ;
extern int RangeSet();
extern int NextSearchReplace() ;
extern int ChangeLatin() ;
extern int DotCount();

extern int  WinMenu1();
extern int  WinMenu2();
extern int  WinMenu3();
extern int  WinMenu4();


static int SaveFile() ;
static int ExitEditor() ;
static int QuitEditor() ;
static int ChangeFileName() ;
static int MargeFile() ;


int (*CommandProcess[55])() = {
    ExecuteKeyMacro,   /*  00H: Control - @  L[}N̎s			    */
    MoveTopLine,       /*  01H: Control - A  J[\s̐擪Ɉړ		    */
    MoveTextBottom,    /*  02H: Control - B  J[\t@C̍ŌɈړ	    */
    PageDown,	       /*  03H: Control - C  PʃXN[Abv		    */
    MoveCursorRight,   /*  04H: Control - D  ijJ[\EɈړ		    */
    MoveCursorUp,      /*  05H: Control - E  ijJ[\Ɉړ		    */
    MoveBottomLine,    /*  06H: Control - F   J[\s̍ŌɈړ		    */
    CopyLine,	       /*  07H: Control - G   J[\ssobt@ɓo^	    */
    BackSpace,	       /*  08H: Control - H  iarjJ[\̑O̕폜	    */
    Tabulation,	       /*  09H: Control - I  is`ajJ[\̃^uʒuɈړ */
    MoveTextTop,       /*  0AH: Control - J   J[\t@C̐擪Ɉړ	    */
    EraseLine,	       /*  0BH: Control - K   J[\ȍ~̕		    */
    NextSearchReplace, /*  0CH: Control - L   Au̍Ďs		    */
    CarriageReturn,    /*  0DH: Control - M   iqdstqmj			    */
    InsertLine,	       /*  0EH: Control - N   Ps}				    */
    InsertMode,	       /*  0FH: Control - O   CT[g[h̐؂ւ	    */
    DuplicateLine,     /*  10H: Control - P   s̓d			    */
    BackTab,	       /*  11H: Control - Q   J[\Õ^uʒuɈړ	    */
    PageUp,	       /*  12H: Control - R   PʃXN[_E		    */
    MoveCursorLeft,    /*  13H: Control - S   ijJ[\Ɉړ		    */
    DeleteWord,	       /*  14H: Control - T   폜			    */
    ChangeAutoIndent,  /*  15H: Control - U   I[g^u[h̐؂ւ	    */
    AdjustIndent,      /*  16H: Control - V   J[\ʒuɍs킹	    */
    ScrollDown,	       /*  17H: Control - W   PsXN[_E		    */
    MoveCursorDown,    /*  18H: Control - X   ijJ[\Ɉړ		    */
    DeleteLine,	       /*  19H: Control - Y   J[\s폜sobt@ɓo^    */
    ScrollUp,	       /*  1AH: Control - Z   PsXN[Abv		    */
    InputChar,	       /*  1BH: Escape	- @					    */
    InputChar,	       /*  1CH: Escape	- A					    */
    SetTextBlock,      /*  1DH: Escape	- B   ubNI			    */
    CopyBlock,	       /*  1EH: Escape	- C   ubN			    */
    DeleteBlock,       /*  1FH: Escape	- D   ubN폜			    */
    ExitEditor,	       /*  20H: Escape	- E   Z[uďI			    */
    SearchString,      /*  21H: Escape	- F   񌟍			    */
    WinMenu1,	       /*  22H: Escape	- G   j[P			    */
    WinMenu2,	       /*  23H: Escape	- H   j[Q			    */
    PasteDeletedLine,  /*  24H: Escape	- I   sobt@̒t		    */
    WinMenu3,	       /*  25H: Escape	- J   j[R			    */
    WinMenu4,	       /*  26H: Escape	- K   j[S			    */
    InputChar,	       /*  27H: Escape	- L					    */
    DefineKeyMacro,    /*  28H: Escape	- M   L[}N̒`			    */
    ChangeFileName,    /*  29H: Escape	- N   t@C̕ύX			    */
    InputChar,	       /*  2AH: Escape	- O					    */
    PasteBlock,	       /*  2BH: Escape	- P   ubNt			    */
    QuitEditor,	       /*  2CH: Escape	- Q   Z[uɏI			    */
    RangeSet,	       /*  2DH: Escape	- R   uW̐ݒ		    */
    SaveFile,	       /*  2EH: Escape	- S   t@CZ[u			    */
    InputChar,	       /*  2FH: Escape	- T					    */
    DotCount,	       /*  30H: Escape	- U   hbg̃JEg			    */
    EraseLineAll,      /*  31H: Escape	- V   J[\sobt@ɓo^A*/
    SavePartText,      /*  32H: Escape	- W   Z[u			    */
    ReplaceString,     /*  33H: Escape	- X   u			    */
    MargeFile,	       /*  34H: Escape	- Y   t@C̃}[W			    */
    ChangeLatin,       /*  35H: Escape	- Z   e̓			    */
    DeleteChar	       /*  36H: Delete code   J[\̉̕폜		    */
} ;
