/*******************************************************************************/
/*                   Console I/O processing module                             */
/*                                                                             */
/*           Programmed by Y.Nishida   [ Nov.08,1991 ]  Version 1.00           */
/*******************************************************************************/

#include	<stdio.h>
#include	<strings.h>
#include	<ctype.h>
#include	<sys/ioctl.h>
#include	"editor.h"
#include	"console.h"

/************************************************************************/
/*	Print message							*/
/************************************************************************/

extern void PrintMessage( msg )
register char *msg ;
{
	register int len,len2 ;
	
	if ( len = strlen( msg )) {
		if ( len >= ScreenWidth ) len = ScreenWidth - 1 ;
		PutStr( "\033[7m" ) ;
		write( 1,msg,len ) ;
		
		if ( len < ScreenWidth - 1 ) {
			len2=(ScreenWidth - 1)-len ;
			PutSpc( len2 ) ;
		}	

		PutStr( "\033[27m" ) ;
	}
}

/************************************************************************/
/*	Put string to console						*/
/************************************************************************/

extern void PutStr( str )
register char *str ;
{
	register int len ;

	if ( len = strlen( str )) {
		write( 1,str,len ) ;
	}
}

/************************************************************************/
/*	Put some space code						*/
/************************************************************************/

extern void PutSpc( cnt )
register int cnt ;
{
	char	c = ' ' ;
	while ( cnt-- > 0 ) write( 1,&c,1 ) ;
}


/************************************************************************/
/*	Move cursor							*/
/************************************************************************/

extern void Locate( tx,ty )
register int tx,ty ;
{
	static char prtbuf[9] = { '\033','[','0','0',';','0','0','0','H' } ;

	tx++ ;
	ty++ ;
	prtbuf[2] = '0' + ty /  10 ;
	prtbuf[3] = '0' + ty %  10 ;
	prtbuf[5] = '0' + tx / 100 ;
	tx %= 100 ;
	prtbuf[6] = '0' + tx /  10 ;
	prtbuf[7] = '0' + tx %  10 ;
	write( 1,prtbuf,9 ) ;
}

/************************************************************************/
/*	Get chracter from console					*/
/************************************************************************/

extern int GetChr()
{
	unsigned char	ch ;

	if ( read( 0,&ch,1 ) == -1 )  return ( 0x1f ) ;
	return ( (int)ch ) ;
}

/************************************************************************/
/*	Set console I/O mode						*/
/************************************************************************/

extern void SetConsoleMode( mode )
int     mode ;
{
	static struct sgttyb ttyctrl ;
	static short original_status = 0 ;
 
	if ( mode == 1 ) {
		ioctl( 0,TIOCGETP,&ttyctrl ) ;
		original_status  = ttyctrl.sg_flags ;
		ttyctrl.sg_flags = ( ttyctrl.sg_flags & ~ECHO ) | RAW ;
		ioctl( 0,TIOCSETP,&ttyctrl ) ;
	}
	else if ( mode == 2 ) {
		ioctl( 0,TIOCGETP,&ttyctrl ) ;
		ttyctrl.sg_flags = original_status ;
		ioctl( 0,TIOCSETP,&ttyctrl ) ;
	}
}

/************************************************************************/
/*	Get screen width and screen height				*/
/************************************************************************/

extern void GetScreenSize( width,height )
int	*width,*height ;
{
	struct winsize ttyctrl ;

	ioctl( 0,TIOCGWINSZ,&ttyctrl ) ;
	*width  = ttyctrl.ws_col ;
	*height = ttyctrl.ws_row ;
}
