/****************************************************************
*								*
****************************************************************/

#include	<stdio.h>
#include	<math.h>
#include	<memory.h>
#include	<strings.h>

#define		unchar		unsigned char
#define		unshort		unsigned short
#define		PI		3.141592654

/*====================
	main
====================*/
main()
{
	/****** ram ******/
	FILE	*fp;
	int	col,x,w1,w2;
	double	i,j;
	int	k;

	/****** data write ******/
	if( ( fp = fopen( "rcol.dat","w" )) == NULL ){
		printf("data file open error !!\n");
		exit( 1 ) ;
	}

	/****** data make ******/
	for(i=1;i<=32;i++){
		for(j=(-16);j<=16;j+=(33.0/32.0)){
			if(abs((int)j)<=(int)(i/2)){
				col=(int)((16*(sqrt(((i)/2)*((i)/2)-j*j)/17))+0.0);
				if(col<0) col=0;
			}
			else{
				col=0;
			}
			if(j==(-16)){
				fprintf(fp,"\tHEX\t%1X",col);
			}
			else{
				fprintf(fp,",%1X",col);
			}
		}
		fprintf(fp,"\n");
	}

	fclose( fp );

	/****** data write ******/
	if( ( fp = fopen( "circ.dat","w" )) == NULL ){
		printf("data file open error !!\n");
		exit( 1 ) ;
	}

	/****** data make ******/
	for(i=(-10);i<=10;i++){
		x=(int)(sqrt(10*10-i*i))*2;
		if(i==(-10)){
			fprintf(fp,"\tHEX\t%02X",x);
		}
		else if(i==0){
			fprintf(fp,"\n\tHEX\t%02X",x);
		}
		else{
			fprintf(fp,",%02X",x);
		}
	}

	fclose( fp );

	/****** data write ******/
	if( ( fp = fopen( "circ.dat","w" )) == NULL ){
		printf("data file open error !!\n");
		exit( 1 ) ;
	}

	/****** data make ******/
	for(i=0,k=0;i<=2*PI;i+=1.0/16.0,k++){
		w1=abs((int)(8.0*cos(i)))+1;
		w2=abs((int)(4.0*sin(i)))+1;
		if(cos(i)<0.0){
			col=0x11;
		}
		else{
			col=0x16;
		}
		if(sin(i)>=0.0){
			x=w1;
			w1=w2;
			w2=x;
			col+=5;
		}
		x=(int)(16+cos(i)*16);
		fprintf(fp,"\tHEX\t%02X,%02X,%02X,%02X\t;[%03X]\n",x,col,w1,w2,k);
	}

	fclose( fp );


}

