#include <math.h>
#include <stdio.h>
#include <ctype.h>

#define	unchar	unsigned char 
#define	unshort	unsigned short

#define	ON	1
#define	OFF	0

#define	MAXFILE	18

#define	OBJMAX	0x9b
#define	CHDTIN	OBJMAX
#define	CHYPAD	CHDTIN+(OBJMAX*2)
 
FILE *fpr0,*fpr1,*fpw0;

main()
{
	/****** ram set ******/
	static char	*cmp_name[MAXFILE] = { "P0","BE","P1","SI","SL","SW","SC","SB","DM","BO"
					      ,"PC","CR","SM","MG","HR","KS","TR","SK" };
	static char	*file_name[MAXFILE] = { "P0OB","BERO","P1OB","SITA","SLIP","SWIM","SCOG"
				  ,"SBER","DMGE","BOMB","PCHG","CRYS","SMYS","MGYS"
				  ,"HRYS","KSYS","TRYS","SKYS" };
	char	spr_buf[MAXFILE][32][6][4];
	int	obj_size[MAXFILE][32];

	char	obj_data[0x4000];
	char	h_buf[256];
	unchar	spr_data[(6*8+1)*32+0x200];

	char	w_name[16];
	int	obj_name,name_no;
	int	i,j,k,l;
	int	*p;

	/****** read file open ******/
	if( (fpr0=fopen("../ys_asm/ys_pld.h","r")) == 0 ){
		printf("can't open (ys_pld.h) !!\n");
		exit(1);
	}
	if( (fpr1=fopen("obj.dat","r")) == 0 ){
		printf("can't open (test.dat) !!\n");
		exit(1);
	}

	/******	obj file convert ******/
	i=0;
	while( !feof( fpr1 ) ) obj_data[i++] = fgetc( fpr1 );

	for( p = &obj_size[0][0],i=0;i<(MAXFILE*32);i++ ) *(p++) = 0;

	while( fgets(h_buf,256,fpr0) != NULL ){
		if( isupper(h_buf[0]) ){
			obj_name = 0;
			while( strncmp( cmp_name[obj_name],h_buf,2 ) != 0 ){
				if( ++obj_name >= MAXFILE ){
					printf("not type data !!\n");
					exit(1);
				}
			}
			h_buf[4] = '\0';
			name_no = (int)strtol(&h_buf[2],(char **)NULL,16);
			h_buf[13] = '\0';
			i = (int)strtol(&h_buf[10],(char **)NULL,16);

			obj_size[obj_name][name_no] = (int)obj_data[i];
			j = (int)((unchar)obj_data[CHDTIN+(i*2+1)])*0x100+(int)((unchar)obj_data[CHDTIN+(i*2)]);

			for( i=0;i<obj_size[obj_name][name_no];i++,j+=4 ){
				spr_buf[obj_name][name_no][i][0] = obj_data[CHYPAD+j];			
				spr_buf[obj_name][name_no][i][1] = obj_data[CHYPAD+j+1];			
				spr_buf[obj_name][name_no][i][2] = obj_data[CHYPAD+j+2];	
				spr_buf[obj_name][name_no][i][3] = obj_data[CHYPAD+j+3];
			}
		}
	}

	/****** read file close ******/
	fclose( fpr0 );
	fclose( fpr1 );


	/****** sprite file make ******/
	for( i=0;i<MAXFILE;i++ ){

		/****** write file open ******/
		strcpy( w_name,file_name[i] );
		strcat( w_name,".SPR" ); 
		if( (fpw0=fopen(w_name,"w")) == 0 ){
			printf("can't open (%s) !!\n",w_name);
			exit(1);
		}
		
		/******	sprite data convert ******/
		for( k=0,j=0;k<32;k++ ){
			spr_data[j++] = (char)obj_size[i][k];
			for(l=0;l<obj_size[i][k];l++ ){
				spr_data[j++] = ( spr_buf[i][k][l][1] >= 0 ) ? 0x00 : 0xff;
				spr_data[j++] = spr_buf[i][k][l][1];
				spr_data[j++] = ( spr_buf[i][k][l][2] >= 0 ) ? 0x00 : 0xff;	
				spr_data[j++] = spr_buf[i][k][l][2];
				spr_data[j++] = spr_buf[i][k][l][0] & 0x0f;
				spr_data[j++] = spr_buf[i][k][l][3];
				spr_data[j++] = ( spr_buf[i][k][l][0] & 0xc0 ) | 0x0c;
				spr_data[j++] = ( spr_buf[i][k][l][0] & 0x20 ) >> 4;
			}
		}

		while( fwrite(spr_data,sizeof(unchar),j+0x200,fpw0) != j+0x200 ){
			printf("file write error !!\n");
			exit(1);
		}
			
		/****** write file close ******/
		fclose( fpw0 );

	}

}

