#include <math.h>
#include <stdio.h>

FILE *fpw0;

#define         PAI     3.141592654
#define         RAG     PAI/180.0
#define		R12	0x240
#define		R22	0xC40
#define		R1	0x18
#define		R2	0x38
main()
{
	/****** ram set ******/
	unsigned short j=0;
	long x;
	double y;

	/****** write file open ******/
	if((fpw0=fopen("tantan.dat","w")) == 0){
		printf("can't open !!\n");
		exit(1);
	}

	/****** 1/tan data label set ******/
	fprintf(fpw0,";************************************************************************\n");
	fprintf(fpw0,";*	1/tan data							*\n");	
	fprintf(fpw0,";************************************************************************\n");

	/****** 1/tan data make ******/
	fprintf(fpw0,"TAN_DATA\tEQU\t$");	
	for(y=0;y<=64;y++){
		if((x=256/(tan(y*90/64*RAG)))>0xffff)	x=0xffff;
		if(j--==0){
			j=7;
			fprintf(fpw0,"\n\t\tWORD\t%05XH",x);
		}
		else{
			fprintf(fpw0,",%05XH",x);
		}

	}

	fprintf(fpw0,"\n");

	/****** small circle data label set ******/
	fprintf(fpw0,";************************************************************************\n");
	fprintf(fpw0,";*	small circle data						*\n");	
	fprintf(fpw0,";************************************************************************\n");

	j=0;

	/****** small circle data make ******/
	fprintf(fpw0,"R1_DATA\tEQU\t$");	
	for(y=0;y<=R1;y++){
		x=sqrt(R12-y*y);
		if(j--==0){
			j=7;
			fprintf(fpw0,"\n\t\tBYTE\t%03XH",x);
		}
		else{
			fprintf(fpw0,",%03XH",x);
		}

	}

	fprintf(fpw0,"\n");

	/****** large circle data label set ******/
	fprintf(fpw0,";************************************************************************\n");
	fprintf(fpw0,";*	large circle data						*\n");	
	fprintf(fpw0,";************************************************************************\n");

	j=0;

	/****** large circle data make ******/
	fprintf(fpw0,"R2_DATA\tEQU\t$");	
	for(y=0;y<=R2;y++){
		x=sqrt(R22-y*y);
		if(j--==0){
			j=7;
			fprintf(fpw0,"\n\t\tBYTE\t%03XH",x);
		}
		else{
			fprintf(fpw0,",%03XH",x);
		}

	}

	fprintf(fpw0,"\n;\n");






        /****** write file close ******/
	fclose(fpw0);

}
