/****************************************************************/
/*								*/
/*	sample	2						*/
/*								*/
/****************************************************************/
#include <stdio.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>

Display *d;
Window root_w;
Window win;
XEvent ev;
unsigned int depth;
unsigned long black,white;
GC gc;
XPoint point[200];
XArc   arc[200];
XColor c0,c1;
unsigned long redcol;
int p_cnt;

main( int argc,char **argv )
{
	register int i;


	if( argc!=2 ) {
		fprintf( stderr,"x_iwa [input-file]\n" );
		exit( 1 );
	}

	file_read( argv[1] );

	d=XOpenDisplay( NULL );

	/* XSynchronize(d,True); */

	black=BlackPixel( d,0 );
	white=WhitePixel( d,0 );

	depth=DefaultDepth(d,DefaultScreen(d));
	root_w=RootWindow(d,DefaultScreen(d));

	gc=XCreateGC(d,root_w,0,0);
	XSetForeground( d,gc,black );
	
	XSetLineAttributes( d, gc, 2, LineSolid, CapButt, JoinMiter );

	win=XCreateSimpleWindow( d,DefaultRootWindow(d),200,300,550,550,1,black,white );

	XSelectInput( d,win,ButtonPressMask|ExposureMask );

	XAllocNamedColor( d,DefaultColormap(d,0),"red",&c1,&c0 );
	redcol=c1.pixel;

	XMapWindow(d,win);

	while( 1 ) {
		XNextEvent( d,&ev );
		switch( ev.type ) {
			case ButtonPress:
				exit( 1 );
			case Expose:
				line_write();
				break;
		}
	}
	XCloseDisplay(d);
}

file_read( char *fname )
{
	FILE *fp;
	char cc[4];

	if( (fp=fopen(fname,"r"))==NULL ) {
		fprintf( stderr,"open error %s\n",fname );
		exit( 1 );
	}
	
	p_cnt=0;	

	while( 1 ) {
		if( fread( cc, sizeof(char), 4, fp )==0 ) break;
 		arc[p_cnt].x=(cc[0]*3+270)-4;
		arc[p_cnt].y=(cc[2]*3+260)-4;
		arc[p_cnt].width=8;
		arc[p_cnt].height=8;
		arc[p_cnt].angle1=0;
		arc[p_cnt].angle2=360*64;


		point[p_cnt].x=cc[0]*3+270;
		point[p_cnt].y=cc[2]*3+260;
	
		p_cnt++;
	}

	fclose( fp );
}



line_write()
{
	int i;

	XDrawLines( d, win, gc, point, p_cnt, CoordModeOrigin );
	XDrawLine( d, win, gc, point[p_cnt-1].x, point[p_cnt-1].y, point[0].x, point[0].y );

	for( i=0; i<p_cnt; i++ ) {
		if( !(i%5) ) XSetForeground( d,gc,redcol );
		else 	     XSetForeground( d,gc,black );
		XFillArc( d, win,gc,arc[i].x,arc[i].y,8,8,0,360*64 );
	}

	/** XFillArcs( d, win, gc, arc, p_cnt ); **/
}

