/****************************************************************************/
/*	File : xdirset.c														*/
/*																			*/
/*																1993/10/20	*/
/****************************************************************************/
#include			<stdio.h>
#include			<stdarg.h>
#include			<sys/types.h>
#include			<sys/stat.h>
#include			<sys/dir.h>
#include			<sys/file.h>
#include			<X11/X.h>
#include			<X11/cursorfont.h>


#define				DEF_DIR_GLOB
#include			"dir_glob.c"

#define				WINDMASK		(ExposureMask | ButtonReleaseMask | ButtonPressMask | ButtonMotionMask)
#define				DISPSTRING		43
#define				DATESTRING		14
#define				SCROLLFILE		(2 * 5)
#define				PAGEDOT			2
#define				DIRLINE			10
#define				ONELINE			(FONTHEIGHT + 3)

#define				BUTTONBDW		2
#define				BUTTONWID		20
#define				BUTTONHIT		20
#define				BUTTONDISTW		(BUTTONWID + (BUTTONBDW * 2) + 1)
#define				BUTTONDISTH		(BUTTONHIT + (BUTTONBDW * 2) + 1)
#define				BUTTONWID2		((BUTTONWID * 2) + (BUTTONBDW * 2) + 1)
#define				BUTTONDISTW2	(BUTTONWID2 + (BUTTONBDW * 2) + 1)

#define				UNMAPBTBW		2
#define				UNMAPBTWD		(font16->max_bounds.width * 3 + 4)
#define				UNMAPBTHT		(FONT16HEIGHT + 3)
#define				UNMAPBTXP		8
#define				UNMAPBTYP		4

#define				DIRWINBDW		2
#define				DIRWINWID		((BUTTONDISTW * (ALPHA - 2)) + (BUTTONWID + (BUTTONBDW * 2)) - (DIRWINBDW * 2))
#define				DIRWINHIT		(ONELINE * DIRLINE)
#define				DIRWINXPS		(BUTTONDISTW + 8)
#define				DIRWINYPS		(UNMAPBTYP + UNMAPBTHT + (UNMAPBTBW * 2) + 8)
#define				UPBUTTONBW		2
#define				UPBUTTONWD		BUTTONWID
#define				UPBUTTONHT		BUTTONHIT
#define				UPBUTTONXP		UNMAPBTXP
#define				UPBUTTONYP		DIRWINYPS
#define				DNBUTTONBW		2
#define				DNBUTTONWD		BUTTONWID
#define				DNBUTTONHT		BUTTONHIT
#define				DNBUTTONXP		UPBUTTONXP
#define				DNBUTTONYP		(UPBUTTONYP + DIRWINHIT - (DNBUTTONHT + DNBUTTONBW * 2) + (DIRWINBDW * 2))
#define				BARBDW			2
#define				BARWIDTH		BUTTONWID
#define				BARHEIGHT		(DIRWINHIT - (BUTTONDISTH * 2))
#define				BARXPOS			UPBUTTONXP
#define				BARYPOS			(UPBUTTONYP + BUTTONDISTH)
#define				BUTTONXPS		UPBUTTONXP
#define				BUTTONYPS		(DIRWINHIT + (DIRWINBDW * 2) + DIRWINYPS + 8)
#define				WINDOWWID		(DIRWINWID + BUTTONDISTW + (DIRWINBDW * 2) + (BUTTONXPS * 2))
#define				WINDOWHIT		(BUTTONYPS + (BUTTONDISTH * 4))

typedef struct{
	char			*label;
	int				(*expose_action)(caddr_t),
					(*buttonpress_action)(caddr_t),
					(*buttonrelease_action)(caddr_t),
					(*motion_action)(caddr_t);
	caddr_t			action_args;
}D_DIRSET;

typedef int			(*P_ACTION)();

char			*month[12]        = {"Jan","Feb","Mar","Apr","May","Jun",
									 "Jul","Aug","Sep","Oct","Nov","Dec"},
				*Alphabet[]       = {"A","B","C","D","E","F","G","H","I","J","K","L","M",
									 "N","O","P","Q","R","S","T","U","V","W","X","Y","Z"},
				*alphabet[]       = {"a","b","c","d","e","f","g","h","i","j","k","l","m",
									 "n","o","p","q","r","s","t","u","v","w","x","y","z"},
				*figure[]         = {"0","1","2","3","4","5","6","7","8","9"},
				*Alphabet16[]     = {"`","a","b","c","d","e","f","g","h","i","j","k","l",
									 "m","n","o","p","q","r","s","t","u","v","w","x","y"},
				*alphabet16[]     = {"","","","","","","","","","","","","",
									 "","","","","","","","","","","","",""},
				*figure16[]       = {"O","P","Q","R","S","T","U","V","W","X"},
				*minus_label      = "|",
				*comma_label      = "C",
				*period_label     = "D",
				*slash_label      = "^",
				*__label          = "Q",
				*clear_label      = "bkq",
				*backspace_label  = "ar",
				*up_label         = "",
				*down_label       = "",
				*unmap_label      = "";

int				status,
				scrollpos;

/*----------------------------------------------------------------------------------*/
/*----------------------------------------------------------------------------------*/
int			get_dir(Dirdata *dirdat);
void		dirmem_free(Dirdata *dirdat);
void		month_chg(char *sp, char *rp);
int			get_dir2(DirDatas *dirs);
void		dirmem_free2(DirDatas *dirs);


/*----------------------------------------------------------------------------------*/
/*----------------------------------------------------------------------------------*/
int			dir_handler(XWIN *);

int			_mainunmap(caddr_t data);
int			_directorydisp(caddr_t data);
int			_nameselect(caddr_t data);
int			_scrollbardisp(caddr_t data);
int			_scrollbarmovestart(caddr_t data);
int			_scrollbarmove(caddr_t data);
int			_scrollbarmoveend(caddr_t data);
int			_scrollup(caddr_t data);
int			_scrolldown(caddr_t data);
int			_textclear(caddr_t data);
int			_textbackspace(caddr_t data);
int			A_set(caddr_t data);
int			B_set(caddr_t data);
int			C_set(caddr_t data);
int			D_set(caddr_t data);
int			E_set(caddr_t data);
int			F_set(caddr_t data);
int			G_set(caddr_t data);
int			H_set(caddr_t data);
int			I_set(caddr_t data);
int			J_set(caddr_t data);
int			K_set(caddr_t data);
int			L_set(caddr_t data);
int			M_set(caddr_t data);
int			N_set(caddr_t data);
int			O_set(caddr_t data);
int			P_set(caddr_t data);
int			Q_set(caddr_t data);
int			R_set(caddr_t data);
int			S_set(caddr_t data);
int			T_set(caddr_t data);
int			U_set(caddr_t data);
int			V_set(caddr_t data);
int			W_set(caddr_t data);
int			X_set(caddr_t data);
int			Y_set(caddr_t data);
int			Z_set(caddr_t data);
int			a_set(caddr_t data);
int			b_set(caddr_t data);
int			c_set(caddr_t data);
int			d_set(caddr_t data);
int			e_set(caddr_t data);
int			f_set(caddr_t data);
int			g_set(caddr_t data);
int			h_set(caddr_t data);
int			i_set(caddr_t data);
int			j_set(caddr_t data);
int			k_set(caddr_t data);
int			l_set(caddr_t data);
int			m_set(caddr_t data);
int			n_set(caddr_t data);
int			o_set(caddr_t data);
int			p_set(caddr_t data);
int			q_set(caddr_t data);
int			r_set(caddr_t data);
int			s_set(caddr_t data);
int			t_set(caddr_t data);
int			u_set(caddr_t data);
int			v_set(caddr_t data);
int			w_set(caddr_t data);
int			x_set(caddr_t data);
int			y_set(caddr_t data);
int			z_set(caddr_t data);
int			_0_set(caddr_t data);
int			_1_set(caddr_t data);
int			_2_set(caddr_t data);
int			_3_set(caddr_t data);
int			_4_set(caddr_t data);
int			_5_set(caddr_t data);
int			_6_set(caddr_t data);
int			_7_set(caddr_t data);
int			_8_set(caddr_t data);
int			_9_set(caddr_t data);
int			_minusset(caddr_t data);
int			_commaset(caddr_t data);
int			_periodset(caddr_t data);
int			_slashset(caddr_t data);
int			__set(caddr_t data);

static void	text_stringset(char *str, Dirdata *data);

int			_mainunmap2(caddr_t data);
int			_directorydisp2(caddr_t data);
int			_nameselect2(caddr_t data);
int			_scrollbardisp2(caddr_t data);
int			_scrollbarmovestart2(caddr_t data);
int			_scrollbarmove2(caddr_t data);
int			_scrollbarmoveend2(caddr_t data);
int			_scrollup2(caddr_t data);
int			_scrolldown2(caddr_t data);
int			_textclear2(caddr_t data);
int			_textbackspace2(caddr_t data);
int			A_set2(caddr_t data);
int			B_set2(caddr_t data);
int			C_set2(caddr_t data);
int			D_set2(caddr_t data);
int			E_set2(caddr_t data);
int			F_set2(caddr_t data);
int			G_set2(caddr_t data);
int			H_set2(caddr_t data);
int			I_set2(caddr_t data);
int			J_set2(caddr_t data);
int			K_set2(caddr_t data);
int			L_set2(caddr_t data);
int			M_set2(caddr_t data);
int			N_set2(caddr_t data);
int			O_set2(caddr_t data);
int			P_set2(caddr_t data);
int			Q_set2(caddr_t data);
int			R_set2(caddr_t data);
int			S_set2(caddr_t data);
int			T_set2(caddr_t data);
int			U_set2(caddr_t data);
int			V_set2(caddr_t data);
int			W_set2(caddr_t data);
int			X_set2(caddr_t data);
int			Y_set2(caddr_t data);
int			Z_set2(caddr_t data);
int			a_set2(caddr_t data);
int			b_set2(caddr_t data);
int			c_set2(caddr_t data);
int			d_set2(caddr_t data);
int			e_set2(caddr_t data);
int			f_set2(caddr_t data);
int			g_set2(caddr_t data);
int			h_set2(caddr_t data);
int			i_set2(caddr_t data);
int			j_set2(caddr_t data);
int			k_set2(caddr_t data);
int			l_set2(caddr_t data);
int			m_set2(caddr_t data);
int			n_set2(caddr_t data);
int			o_set2(caddr_t data);
int			p_set2(caddr_t data);
int			q_set2(caddr_t data);
int			r_set2(caddr_t data);
int			s_set2(caddr_t data);
int			t_set2(caddr_t data);
int			u_set2(caddr_t data);
int			v_set2(caddr_t data);
int			w_set2(caddr_t data);
int			x_set2(caddr_t data);
int			y_set2(caddr_t data);
int			z_set2(caddr_t data);
int			_0_set2(caddr_t data);
int			_1_set2(caddr_t data);
int			_2_set2(caddr_t data);
int			_3_set2(caddr_t data);
int			_4_set2(caddr_t data);
int			_5_set2(caddr_t data);
int			_6_set2(caddr_t data);
int			_7_set2(caddr_t data);
int			_8_set2(caddr_t data);
int			_9_set2(caddr_t data);
int			_minusset2(caddr_t data);
int			_commaset2(caddr_t data);
int			_periodset2(caddr_t data);
int			_slashset2(caddr_t data);
int			__set2(caddr_t data);

static void	text_stringset2(char *str, Dirdata2 *data);


int			(*_Alphaset[])() = {
				A_set, B_set, C_set, D_set, E_set, F_set, G_set, H_set, I_set,
				J_set, K_set, L_set, M_set, N_set, O_set, P_set, Q_set, R_set,
				S_set, T_set, U_set, V_set, W_set, X_set, Y_set, Z_set,
			};
int			(*_alphaset[])() = {
				a_set, b_set, c_set, d_set, e_set, f_set, g_set, h_set, i_set,
				j_set, k_set, l_set, m_set, n_set, o_set, p_set, q_set, r_set,
				s_set, t_set, u_set, v_set, w_set, x_set, y_set, z_set,
			};
int			(*_figureset[])() = {
				_0_set, _1_set, _2_set, _3_set, _4_set, _5_set,
				_6_set, _7_set, _8_set, _9_set,
			};


int			(*_Alphaset2[])() = {
				A_set2, B_set2, C_set2, D_set2, E_set2, F_set2, G_set2, H_set2, I_set2,
				J_set2, K_set2, L_set2, M_set2, N_set2, O_set2, P_set2, Q_set2, R_set2,
				S_set2, T_set2, U_set2, V_set2, W_set2, X_set2, Y_set2, Z_set2,
			};
int			(*_alphaset2[])() = {
				a_set2, b_set2, c_set2, d_set2, e_set2, f_set2, g_set2, h_set2, i_set2,
				j_set2, k_set2, l_set2, m_set2, n_set2, o_set2, p_set2, q_set2, r_set2,
				s_set2, t_set2, u_set2, v_set2, w_set2, x_set2, y_set2, z_set2,
			};
int			(*_figureset2[])() = {
				_0_set2, _1_set2, _2_set2, _3_set2, _4_set2, _5_set2,
				_6_set2, _7_set2, _8_set2, _9_set2,
			};
			

/****************************************************************************/
/*																			*/
/****************************************************************************/
XWIN *MakeXDirset(int x, int y, unsigned bdwidth,
		unsigned long bdcolor, unsigned long bgcolor,
		Window parent, char *label, caddr_t action_data,...)
{
	register int	i, x0, y0, y1;
	unsigned		width, height, border;
	va_list			argp;
	XSizeHints		hint;
	XWIN			*new_button;
	D_DIRSET		*p_data;
	P_ACTION		p_action;

	if((p_data = (D_DIRSET *)calloc(1,sizeof(D_DIRSET))) == NULL){
		fprintf(stderr,"No memory for button's data");
		exit(1);
	}

	if((new_button = (XWIN *)calloc(1,sizeof(XWIN))) == NULL){
		fprintf(stderr,"No memory for button");
		exit(1);
	}

	p_data->action_args          = action_data;
	p_data->label                = label;
	p_data->expose_action        = NULL;
	p_data->buttonpress_action   = NULL;
	p_data->buttonrelease_action = NULL;
	p_data->motion_action        = NULL;

	va_start(argp,action_data);
	while((p_action = va_arg(argp,P_ACTION)) != NULL){
		switch(va_arg(argp,int)){
			case Expose :
				p_data->expose_action = p_action;
				break;
			case ButtonPress :
				p_data->buttonpress_action = p_action;
				break;
			case ButtonRelease :
				p_data->buttonrelease_action = p_action;
				break;
			case MotionNotify :
				p_data->motion_action = p_action;
				break;
		}
	}
	va_end(argp);

	hint.x          = x;
	hint.y          = y;
	hint.width      = WINDOWWID;
	hint.height     = WINDOWHIT;
	hint.min_width  = WINDOWWID;
	hint.min_height = WINDOWHIT;
	hint.max_width  = WINDOWWID;
	hint.max_height = WINDOWHIT;
	hint.flags      = USPosition | USSize | PMinSize | PMaxSize;

	new_button->data          = p_data;
	new_button->event_handler = dir_handler;
	new_button->xid           = XCreateSimpleWindow(display,parent,x,y,WINDOWWID,WINDOWHIT,
									bdwidth,bdcolor,bgcolor);

	if(XSaveContext(display,new_button->xid,xwin_context,(caddr_t)new_button) != 0){
		fprintf(stderr,"Error saving xwin_context data");
		exit(1);
	}

	XSetNormalHints(display,new_button->xid,&hint);
	XStoreName(display,new_button->xid,label);
	XSelectInput(display,new_button->xid,WINDMASK);

#if 0
	XMapRaised(display,new_button->xid);
#endif

	border      = UNMAPBTBW;
	width       = UNMAPBTWD;
	height      = UNMAPBTHT;
	x0          = UNMAPBTXP;
	y0          = UNMAPBTYP;
	UnmapButton = MakeXButton(x0,y0,width,height,border,FG,BG,
					new_button->xid,unmap_label,_mainunmap,NULL,BUTTON16MODE);

	border     = DIRWINBDW;
	width      = DIRWINWID;
	height     = DIRWINHIT;
	x0         = DIRWINXPS;
	y0         = DIRWINYPS;
	DirDisplay = MakeXGraphic(x0,y0,width,height,border,FG,BG,
						new_button->xid,"",action_data,NORMAL,
						_directorydisp, Expose,
						_nameselect,    ButtonRelease,
						NULL);
	border     = UPBUTTONBW;
	width      = UPBUTTONWD;
	height     = UPBUTTONHT;
	x0         = UPBUTTONXP;
	y0         = UPBUTTONYP;
	UpButton   = MakeXButton(x0,y0,width,height,border,FG,BG,
					new_button->xid,up_label,_scrollup,action_data,BUTTON16MODE);
	border     = DNBUTTONBW;
	width      = DNBUTTONWD;
	height     = DNBUTTONHT;
	x0         = DNBUTTONXP;
	y0         = DNBUTTONYP;
	DownButton = MakeXButton(x0,y0,width,height,border,FG,BG,
					new_button->xid,down_label,_scrolldown,action_data,BUTTON16MODE);
	border     = BARBDW;
	width      = BARWIDTH;
	height     = BARHEIGHT;
	x0         = BARXPOS;
	y0         = BARYPOS;
	ScrollBar  = MakeXGraphic(x0,y0,width,height,border,FG,BG,
						new_button->xid,"",action_data,NORMAL,
						_scrollbardisp,      Expose,
						_scrollbarmovestart, ButtonPress,
						_scrollbarmove,      MotionNotify,
						_scrollbarmoveend,   ButtonRelease,
						NULL);

	border = BUTTONBDW;
	width  = BUTTONWID2;
	height = BUTTONHIT;
	x0     = BUTTONXPS;
	y0     = BUTTONYPS;
	ClearButton     = MakeXButton(x0,y0,width,height,border,FG,BG,
						new_button->xid,clear_label,_textclear,action_data,BUTTON16MODE);
	x0 += BUTTONDISTW2;
	BackSpaceButton = MakeXButton(x0,y0,width,height,border,FG,BG,
						new_button->xid,backspace_label,_textbackspace,action_data,BUTTON16MODE);
	width  = BUTTONWID;
	height = BUTTONHIT;
	x0     = BUTTONXPS;
	y0    += BUTTONDISTH;
	y1     = y0 + BUTTONDISTH;
	for(i=0; i<ALPHA; i++){
		AlphaButton[i] = MakeXButton(x0,y0,width,height,border,FG,BG,
							new_button->xid,Alphabet16[i],_Alphaset[i],action_data,BUTTON16MODE);
		alphaButton[i] = MakeXButton(x0,y1,width,height,border,FG,BG,
							new_button->xid,alphabet16[i],_alphaset[i],action_data,BUTTON16MODE);
		x0 += BUTTONDISTW;
	}
	x0 = BUTTONXPS;
	y0 = y1 + BUTTONDISTH;
	for(i=0; i<FIGURE; i++){
		FigureButton[i] = MakeXButton(x0,y0,width,height,border,FG,BG,
							new_button->xid,figure16[i],_figureset[i],action_data,BUTTON16MODE);
		x0 += BUTTONDISTW;
	}
	MinusButton  = MakeXButton(x0,y0,width,height,border,FG,BG,
						new_button->xid,minus_label,_minusset,action_data,BUTTON16MODE);
	x0 += BUTTONDISTW;
	CommaButton  = MakeXButton(x0,y0,width,height,border,FG,BG,
						new_button->xid,comma_label,_commaset,action_data,BUTTON16MODE);
	x0 += BUTTONDISTW;
	PeriodButton = MakeXButton(x0,y0,width,height,border,FG,BG,
						new_button->xid,period_label,_periodset,action_data,BUTTON16MODE);
	x0 += BUTTONDISTW;
	SlashButton  = MakeXButton(x0,y0,width,height,border,FG,BG,
						new_button->xid,slash_label,_slashset,action_data,BUTTON16MODE);
	x0 += BUTTONDISTW;
	_Button      = MakeXButton(x0,y0,width,height,border,FG,BG,
						new_button->xid,__label,__set,action_data,BUTTON16MODE);
	x0 += BUTTONDISTW;


	MainStage = new_button;
	return new_button;
}


int dir_handler(XWIN *p_xwin)
{
	D_DIRSET			*p_data = (D_DIRSET *)p_xwin->data;

	if(event.xany.window == p_xwin->xid){
		switch(event.type){
			case Expose :
				if(p_data->expose_action != NULL)
					(*p_data->expose_action)(p_data->action_args);
				break;
			case ButtonPress :
				if(p_data->buttonpress_action != NULL)
					(*p_data->buttonpress_action)(p_data->action_args);
				break;
			case ButtonRelease :
				if(p_data->buttonrelease_action != NULL)
					(*p_data->buttonrelease_action)(p_data->action_args);
				break;
			case MotionNotify :
				if(p_data->motion_action != NULL)
					(*p_data->motion_action)(p_data->action_args);
				break;
		}
	}
}




/****************************************************************************/
/*																			*/
/****************************************************************************/
int _mainunmap(caddr_t data)
{
	XUnmapWindow(display,MainStage->xid);
	return 1;
}



/****************************************************************************/
/*																			*/
/****************************************************************************/
int _directorydisp(caddr_t data)
{
	static char			dirstr[EXTENDSTR] = "<DIR>";
	char				str[DISPSTRING + 1], str2[EXTENDSTR];
	register int		i, j, x0, y0, x1, extlen, textlen, dirlen, n, nn;
	Dirdata				*dirdat;
	DIRLIST				*pnt;
	XWindowAttributes	attr;

	dirdat = (Dirdata *)data;

	if(event.xexpose.count == 0){
		XClearWindow(display,event.xexpose.window);
		if((pnt = dirdat->top) != NULL){
			extlen  = strlen(dirdat->extend);
			strcpy(str2,dirdat->extend);
			dirlen  = strlen(dirstr);
			if(extlen < dirlen){
				for(i=extlen; i<(dirlen-extlen); i++)	str2[i] = ' ';
				str2[i] = '\0';
				extlen = dirlen;
			}
			else{
				for(i=dirlen; i<(extlen-dirlen); i++)	dirstr[i] = ' ';
				dirstr[i] = '\0';
				dirlen = extlen;
			}
			textlen = DISPSTRING - DATESTRING - extlen - 1;
			XGetWindowAttributes(display,event.xexpose.window,&attr);
			x0 = 2;
			y0 = FONTHEIGHT;
			x1 = attr.width / 2 + x0;
			for(i=0; i<dirdat->dir_pnt; i++){
				if((pnt = pnt->next) == NULL)	break;
			}
			for(j=0; j<DIRLINE; j++){
				if(pnt == NULL)	break;
				strcpy(str,pnt->name);
				if((n = strlen(str)) > textlen){
					str[textlen+1] = '\0';
				}
				else{
					nn = textlen - n;
					for(i=0; i<nn; i++)	strcat(str," ");
				}
				if(pnt->flag)	strcat(str,dirstr);
				else	strcat(str,str2);
				strcat(str," ");
				strcat(str,pnt->date);
				XDrawString(display,event.xexpose.window,gc,x0,y0,str,strlen(str));
				if((pnt = pnt->next) == NULL)	break;
				strcpy(str,pnt->name);
				if((n = strlen(str)) > textlen){
					str[textlen+1] = '\0';
				}
				else{
					nn = textlen - n;
					for(i=0; i<nn; i++)	strcat(str," ");
				}
				if(pnt->flag)	strcat(str,dirstr);
				else	strcat(str,str2);
				strcat(str," ");
				strcat(str,pnt->date);
				XDrawString(display,event.xexpose.window,gc,x1,y0,str,strlen(str));
				y0 += ONELINE;
				pnt = pnt->next;
			}
		}
		XClearArea(display,ScrollBar->xid,0,0,0,0,True);
	}
	return 1;
}



/****************************************************************************/
/*																			*/
/****************************************************************************/
int _nameselect(caddr_t data)
{
	register int		i, x, y, n, n1, flag;
	char				*s, str[TEXTSTR];
	XWindowAttributes	attr;
	Dirdata				*dirdat;
	DIRLIST				*pnt;

	dirdat = (Dirdata *)data;
	XGetWindowAttributes(display,event.xbutton.window,&attr);
	x = event.xbutton.x / (attr.width / 2);
	if(x < 0)	x = 0;
	else if(x > 1)	x = 1;
	y = event.xbutton.y / ONELINE;
	if(y < 0)	y = 0;
	else if(y > 9)	y = 9;
	n = x | (y << 1);


	pnt = dirdat->top;
	for(i=0; i<dirdat->dir_pnt; i++){
		if(pnt == NULL)	break;
		pnt = pnt->next;
	}
	for(i=0; i<n; i++){
		if(pnt == NULL)	break;
		pnt = pnt->next;
	}
	flag = 1;
	if(pnt != NULL){
		if(strcmp(pnt->name,".") != 0){
			if((s = (char *)strrchr(dirdat->text,'/')) != NULL){
				*(s + 1) = '\0';
				if(strcmp(pnt->name,"..") == 0){
					strcpy(str,dirdat->text);
					str[strlen(str) - 1] = '\0';
					if((s = (char *)strrchr(str,'/')) != NULL){
						if(strcmp((s + 1),"..") != 0){
							dirdat->text[strlen(dirdat->text) - 1] = '\0';
							s        = (char *)strrchr(dirdat->text,'/');
							*(s + 1) = '\0';
							flag = 0;
						}
					}
					else if(strcmp(str,"..") != 0){
						dirdat->text[0] = '\0';
						flag = 0;
					}
				}
			}
			else	dirdat->text[0] = '\0';
			if(flag){
				n  = strlen(dirdat->text);
				n1 = strlen(pnt->name);
				i  = 0;
				do{
					if(n >= TEXTSTR)	break;
					dirdat->text[n++] = pnt->name[i++];
				}while(i < n1);
				if(n < TEXTSTR && pnt->flag){
					dirdat->text[n++] = '/';
					dirdat->text[n]   = '\0';
					get_dir(dirdat);
					XClearArea(display,DirDisplay->xid,0,0,0,0,True);
				}
				else	dirdat->text[n] = '\0';
			}
			else{
				get_dir(dirdat);
				XClearArea(display,DirDisplay->xid,0,0,0,0,True);
			}
			XClearArea(display,dirdat->FileText->xid,0,0,0,0,True);
		}
	}

	return 1;
}



/****************************************************************************/
/*																			*/
/****************************************************************************/
int _scrollbardisp(caddr_t data)
{
	register int		x, y, n;
	unsigned			width, height;
	XWindowAttributes	attr;
	Dirdata				*dirdat;

	dirdat = (Dirdata *)data;

	if(event.xexpose.count == 0){
		XClearWindow(display,event.xexpose.window);
		XGetWindowAttributes(display,event.xexpose.window,&attr);
		x      = 0;
		width  = attr.width;
		n      = (dirdat->fcnt / 2) + (dirdat->fcnt % 2);
		height = attr.height - (((n - 1) / DIRLINE) * PAGEDOT);
		y      = dirdat->dir_pnt / SCROLLFILE;
		XFillRectangle(display,event.xexpose.window,gc,x,y,width,height);
	}
	return 1;
}




/****************************************************************************/
/*																			*/
/****************************************************************************/
int _scrollbarmovestart(caddr_t data)
{
	Dirdata				*dirdat;
	Cursor				cur;

	dirdat = (Dirdata *)data;

#if 0
	cur    = XCreateFontCursor(display, XC_trek);
	status = XGrabPointer(display, event.xbutton.window, False,
				ButtonReleaseMask | ButtonMotionMask,
				GrabModeAsync, GrabModeAsync, None, cur, event.xbutton.time);
#endif

	scrollpos = event.xbutton.y;
	return 1;
}



/****************************************************************************/
/*																			*/
/****************************************************************************/
int _scrollbarmove(caddr_t data)
{
	register int		n, n2;
	Dirdata				*dirdat;

	dirdat = (Dirdata *)data;

	n  = (event.xmotion.y - scrollpos) * SCROLLFILE;
	n2 = (((dirdat->fcnt / 2) + (dirdat->fcnt % 2)) - (DIRLINE)) * 2;
	n2 = (int)((n2 + 9) / 10) * 10;
	dirdat->dir_pnt += n;
	if(dirdat->dir_pnt < 0)	dirdat->dir_pnt = 0;
	else if(dirdat->dir_pnt > n2)	dirdat->dir_pnt = n2;
	XClearArea(display,ScrollBar->xid,0,0,0,0,True);
	scrollpos = event.xmotion.y;
	return 1;
}



/****************************************************************************/
/*																			*/
/****************************************************************************/
int _scrollbarmoveend(caddr_t data)
{
	register int		n, n2;
	Dirdata				*dirdat;

	dirdat = (Dirdata *)data;

#if 0
	XUngrabPointer(display,event.xbutton.time);
#endif

	n  = (event.xmotion.y - scrollpos) * SCROLLFILE;
	n2 = (((dirdat->fcnt / 2) + (dirdat->fcnt % 2)) - (DIRLINE)) * 2;
	n2 = (int)((n2 + 9) / 10) * 10;
	dirdat->dir_pnt += n;
	if(dirdat->dir_pnt < 0)	dirdat->dir_pnt = 0;
	else if(dirdat->dir_pnt > n2)	dirdat->dir_pnt = n2;
	XClearArea(display,ScrollBar->xid,0,0,0,0,True);
	XClearArea(display,DirDisplay->xid,0,0,0,0,True);
	return 1;
}



/****************************************************************************/
/*																			*/
/****************************************************************************/
int _scrollup(caddr_t data)
{
	Dirdata				*dirdat;

	dirdat = (Dirdata *)data;

	dirdat->dir_pnt -= 2;
	if(dirdat->dir_pnt < 0)	dirdat->dir_pnt = 0;
	XClearArea(display,ScrollBar->xid,0,0,0,0,True);
	XClearArea(display,DirDisplay->xid,0,0,0,0,True);
	return 1;
}



/****************************************************************************/
/*																			*/
/****************************************************************************/
int _scrolldown(caddr_t data)
{
	register int		n;
	Dirdata				*dirdat;

	dirdat = (Dirdata *)data;

	n = (((dirdat->fcnt / 2) + (dirdat->fcnt % 2)) - (DIRLINE)) * 2;
	n = (int)((n + 9) / 10) * 10;
	dirdat->dir_pnt += 2;
	if(dirdat->dir_pnt > n)	dirdat->dir_pnt = n;
	XClearArea(display,ScrollBar->xid,0,0,0,0,True);
	XClearArea(display,DirDisplay->xid,0,0,0,0,True);
	return 1;
}



/****************************************************************************/
/*																			*/
/****************************************************************************/
int _textclear(caddr_t data)
{
	Dirdata				*dirdat;

	dirdat          = (Dirdata *)data;
	dirdat->text[0] = '\0';
	XClearArea(display,dirdat->FileText->xid,0,0,0,0,True);
	get_dir(dirdat);
	XClearArea(display,DirDisplay->xid,0,0,0,0,True);
	return 1;
}



/****************************************************************************/
/*																			*/
/****************************************************************************/
int _textbackspace(caddr_t data)
{
	register int		n;
	Dirdata				*dirdat;

	dirdat = (Dirdata *)data;
	n      = strlen(dirdat->text);
	if(n)	dirdat->text[n-1] = '\0';
	XClearArea(display,dirdat->FileText->xid,0,0,0,0,True);
	return 1;
}



/****************************************************************************/
/*																			*/
/****************************************************************************/
int A_set(caddr_t data)
{
	Dirdata				*dirdat;

	dirdat = (Dirdata *)data;
	text_stringset("A", dirdat);
	return 1;
}



/****************************************************************************/
/*																			*/
/****************************************************************************/
int B_set(caddr_t data)
{
	Dirdata				*dirdat;

	dirdat = (Dirdata *)data;
	text_stringset("B", dirdat);
	return 1;
}



/****************************************************************************/
/*																			*/
/****************************************************************************/
int C_set(caddr_t data)
{
	Dirdata				*dirdat;

	dirdat = (Dirdata *)data;
	text_stringset("C", dirdat);
	return 1;
}



/****************************************************************************/
/*																			*/
/****************************************************************************/
int D_set(caddr_t data)
{
	Dirdata				*dirdat;

	dirdat = (Dirdata *)data;
	text_stringset("D", dirdat);
	return 1;
}



/****************************************************************************/
/*																			*/
/****************************************************************************/
int E_set(caddr_t data)
{
	Dirdata				*dirdat;

	dirdat = (Dirdata *)data;
	text_stringset("E", dirdat);
	return 1;
}



/****************************************************************************/
/*																			*/
/****************************************************************************/
int F_set(caddr_t data)
{
	Dirdata				*dirdat;

	dirdat = (Dirdata *)data;
	text_stringset("F", dirdat);
	return 1;
}



/****************************************************************************/
/*																			*/
/****************************************************************************/
int G_set(caddr_t data)
{
	Dirdata				*dirdat;

	dirdat = (Dirdata *)data;
	text_stringset("G", dirdat);
	return 1;
}



/****************************************************************************/
/*																			*/
/****************************************************************************/
int H_set(caddr_t data)
{
	Dirdata				*dirdat;

	dirdat = (Dirdata *)data;
	text_stringset("H", dirdat);
	return 1;
}



/****************************************************************************/
/*																			*/
/****************************************************************************/
int I_set(caddr_t data)
{
	Dirdata				*dirdat;

	dirdat = (Dirdata *)data;
	text_stringset("I", dirdat);
	return 1;
}



/****************************************************************************/
/*																			*/
/****************************************************************************/
int J_set(caddr_t data)
{
	Dirdata				*dirdat;

	dirdat = (Dirdata *)data;
	text_stringset("J", dirdat);
	return 1;
}



/****************************************************************************/
/*																			*/
/****************************************************************************/
int K_set(caddr_t data)
{
	Dirdata				*dirdat;

	dirdat = (Dirdata *)data;
	text_stringset("K", dirdat);
	return 1;
}



/****************************************************************************/
/*																			*/
/****************************************************************************/
int L_set(caddr_t data)
{
	Dirdata				*dirdat;

	dirdat = (Dirdata *)data;
	text_stringset("L", dirdat);
	return 1;
}



/****************************************************************************/
/*																			*/
/****************************************************************************/
int M_set(caddr_t data)
{
	Dirdata				*dirdat;

	dirdat = (Dirdata *)data;
	text_stringset("M", dirdat);
	return 1;
}



/****************************************************************************/
/*																			*/
/****************************************************************************/
int N_set(caddr_t data)
{
	Dirdata				*dirdat;

	dirdat = (Dirdata *)data;
	text_stringset("N", dirdat);
	return 1;
}



/****************************************************************************/
/*																			*/
/****************************************************************************/
int O_set(caddr_t data)
{
	Dirdata				*dirdat;

	dirdat = (Dirdata *)data;
	text_stringset("O", dirdat);
	return 1;
}



/****************************************************************************/
/*																			*/
/****************************************************************************/
int P_set(caddr_t data)
{
	Dirdata				*dirdat;

	dirdat = (Dirdata *)data;
	text_stringset("P", dirdat);
	return 1;
}



/****************************************************************************/
/*																			*/
/****************************************************************************/
int Q_set(caddr_t data)
{
	Dirdata				*dirdat;

	dirdat = (Dirdata *)data;
	text_stringset("Q", dirdat);
	return 1;
}



/****************************************************************************/
/*																			*/
/****************************************************************************/
int R_set(caddr_t data)
{
	Dirdata				*dirdat;

	dirdat = (Dirdata *)data;
	text_stringset("R", dirdat);
	return 1;
}



/****************************************************************************/
/*																			*/
/****************************************************************************/
int S_set(caddr_t data)
{
	Dirdata				*dirdat;

	dirdat = (Dirdata *)data;
	text_stringset("S", dirdat);
	return 1;
}



/****************************************************************************/
/*																			*/
/****************************************************************************/
int T_set(caddr_t data)
{
	Dirdata				*dirdat;

	dirdat = (Dirdata *)data;
	text_stringset("T", dirdat);
	return 1;
}



/****************************************************************************/
/*																			*/
/****************************************************************************/
int U_set(caddr_t data)
{
	Dirdata				*dirdat;

	dirdat = (Dirdata *)data;
	text_stringset("U", dirdat);
	return 1;
}



/****************************************************************************/
/*																			*/
/****************************************************************************/
int V_set(caddr_t data)
{
	Dirdata				*dirdat;

	dirdat = (Dirdata *)data;
	text_stringset("V", dirdat);
	return 1;
}



/****************************************************************************/
/*																			*/
/****************************************************************************/
int W_set(caddr_t data)
{
	Dirdata				*dirdat;

	dirdat = (Dirdata *)data;
	text_stringset("W", dirdat);
	return 1;
}



/****************************************************************************/
/*																			*/
/****************************************************************************/
int X_set(caddr_t data)
{
	Dirdata				*dirdat;

	dirdat = (Dirdata *)data;
	text_stringset("X", dirdat);
	return 1;
}



/****************************************************************************/
/*																			*/
/****************************************************************************/
int Y_set(caddr_t data)
{
	Dirdata				*dirdat;

	dirdat = (Dirdata *)data;
	text_stringset("Y", dirdat);
	return 1;
}



/****************************************************************************/
/*																			*/
/****************************************************************************/
int Z_set(caddr_t data)
{
	Dirdata				*dirdat;

	dirdat = (Dirdata *)data;
	text_stringset("Z", dirdat);
	return 1;
}



/****************************************************************************/
/*																			*/
/****************************************************************************/
int a_set(caddr_t data)
{
	Dirdata				*dirdat;

	dirdat = (Dirdata *)data;
	text_stringset("a", dirdat);
	return 1;
}



/****************************************************************************/
/*																			*/
/****************************************************************************/
int b_set(caddr_t data)
{
	Dirdata				*dirdat;

	dirdat = (Dirdata *)data;
	text_stringset("b", dirdat);
	return 1;
}



/****************************************************************************/
/*																			*/
/****************************************************************************/
int c_set(caddr_t data)
{
	Dirdata				*dirdat;

	dirdat = (Dirdata *)data;
	text_stringset("c", dirdat);
	return 1;
}



/****************************************************************************/
/*																			*/
/****************************************************************************/
int d_set(caddr_t data)
{
	Dirdata				*dirdat;

	dirdat = (Dirdata *)data;
	text_stringset("d", dirdat);
	return 1;
}



/****************************************************************************/
/*																			*/
/****************************************************************************/
int e_set(caddr_t data)
{
	Dirdata				*dirdat;

	dirdat = (Dirdata *)data;
	text_stringset("e", dirdat);
	return 1;
}



/****************************************************************************/
/*																			*/
/****************************************************************************/
int f_set(caddr_t data)
{
	Dirdata				*dirdat;

	dirdat = (Dirdata *)data;
	text_stringset("f", dirdat);
	return 1;
}



/****************************************************************************/
/*																			*/
/****************************************************************************/
int g_set(caddr_t data)
{
	Dirdata				*dirdat;

	dirdat = (Dirdata *)data;
	text_stringset("g", dirdat);
	return 1;
}



/****************************************************************************/
/*																			*/
/****************************************************************************/
int h_set(caddr_t data)
{
	Dirdata				*dirdat;

	dirdat = (Dirdata *)data;
	text_stringset("h", dirdat);
	return 1;
}



/****************************************************************************/
/*																			*/
/****************************************************************************/
int i_set(caddr_t data)
{
	Dirdata				*dirdat;

	dirdat = (Dirdata *)data;
	text_stringset("i", dirdat);
	return 1;
}



/****************************************************************************/
/*																			*/
/****************************************************************************/
int j_set(caddr_t data)
{
	Dirdata				*dirdat;

	dirdat = (Dirdata *)data;
	text_stringset("j", dirdat);
	return 1;
}



/****************************************************************************/
/*																			*/
/****************************************************************************/
int k_set(caddr_t data)
{
	Dirdata				*dirdat;

	dirdat = (Dirdata *)data;
	text_stringset("k", dirdat);
	return 1;
}



/****************************************************************************/
/*																			*/
/****************************************************************************/
int l_set(caddr_t data)
{
	Dirdata				*dirdat;

	dirdat = (Dirdata *)data;
	text_stringset("l", dirdat);
	return 1;
}



/****************************************************************************/
/*																			*/
/****************************************************************************/
int m_set(caddr_t data)
{
	Dirdata				*dirdat;

	dirdat = (Dirdata *)data;
	text_stringset("m", dirdat);
	return 1;
}



/****************************************************************************/
/*																			*/
/****************************************************************************/
int n_set(caddr_t data)
{
	Dirdata				*dirdat;

	dirdat = (Dirdata *)data;
	text_stringset("n", dirdat);
	return 1;
}



/****************************************************************************/
/*																			*/
/****************************************************************************/
int o_set(caddr_t data)
{
	Dirdata				*dirdat;

	dirdat = (Dirdata *)data;
	text_stringset("o", dirdat);
	return 1;
}



/****************************************************************************/
/*																			*/
/****************************************************************************/
int p_set(caddr_t data)
{
	Dirdata				*dirdat;

	dirdat = (Dirdata *)data;
	text_stringset("p", dirdat);
	return 1;
}



/****************************************************************************/
/*																			*/
/****************************************************************************/
int q_set(caddr_t data)
{
	Dirdata				*dirdat;

	dirdat = (Dirdata *)data;
	text_stringset("q", dirdat);
	return 1;
}



/****************************************************************************/
/*																			*/
/****************************************************************************/
int r_set(caddr_t data)
{
	Dirdata				*dirdat;

	dirdat = (Dirdata *)data;
	text_stringset("r", dirdat);
	return 1;
}



/****************************************************************************/
/*																			*/
/****************************************************************************/
int s_set(caddr_t data)
{
	Dirdata				*dirdat;

	dirdat = (Dirdata *)data;
	text_stringset("s", dirdat);
	return 1;
}



/****************************************************************************/
/*																			*/
/****************************************************************************/
int t_set(caddr_t data)
{
	Dirdata				*dirdat;

	dirdat = (Dirdata *)data;
	text_stringset("t", dirdat);
	return 1;
}



/****************************************************************************/
/*																			*/
/****************************************************************************/
int u_set(caddr_t data)
{
	Dirdata				*dirdat;

	dirdat = (Dirdata *)data;
	text_stringset("u", dirdat);
	return 1;
}



/****************************************************************************/
/*																			*/
/****************************************************************************/
int v_set(caddr_t data)
{
	Dirdata				*dirdat;

	dirdat = (Dirdata *)data;
	text_stringset("v", dirdat);
	return 1;
}



/****************************************************************************/
/*																			*/
/****************************************************************************/
int w_set(caddr_t data)
{
	Dirdata				*dirdat;

	dirdat = (Dirdata *)data;
	text_stringset("w", dirdat);
	return 1;
}



/****************************************************************************/
/*																			*/
/****************************************************************************/
int x_set(caddr_t data)
{
	Dirdata				*dirdat;

	dirdat = (Dirdata *)data;
	text_stringset("x", dirdat);
	return 1;
}



/****************************************************************************/
/*																			*/
/****************************************************************************/
int y_set(caddr_t data)
{
	Dirdata				*dirdat;

	dirdat = (Dirdata *)data;
	text_stringset("y", dirdat);
	return 1;
}



/****************************************************************************/
/*																			*/
/****************************************************************************/
int z_set(caddr_t data)
{
	Dirdata				*dirdat;

	dirdat = (Dirdata *)data;
	text_stringset("z", dirdat);
	return 1;
}



/****************************************************************************/
/*																			*/
/****************************************************************************/
int _0_set(caddr_t data)
{
	Dirdata				*dirdat;

	dirdat = (Dirdata *)data;
	text_stringset("0", dirdat);
	return 1;
}



/****************************************************************************/
/*																			*/
/****************************************************************************/
int _1_set(caddr_t data)
{
	Dirdata				*dirdat;

	dirdat = (Dirdata *)data;
	text_stringset("1", dirdat);
	return 1;
}



/****************************************************************************/
/*																			*/
/****************************************************************************/
int _2_set(caddr_t data)
{
	Dirdata				*dirdat;

	dirdat = (Dirdata *)data;
	text_stringset("2", dirdat);
	return 1;
}



/****************************************************************************/
/*																			*/
/****************************************************************************/
int _3_set(caddr_t data)
{
	Dirdata				*dirdat;

	dirdat = (Dirdata *)data;
	text_stringset("3", dirdat);
	return 1;
}



/****************************************************************************/
/*																			*/
/****************************************************************************/
int _4_set(caddr_t data)
{
	Dirdata				*dirdat;

	dirdat = (Dirdata *)data;
	text_stringset("4", dirdat);
	return 1;
}



/****************************************************************************/
/*																			*/
/****************************************************************************/
int _5_set(caddr_t data)
{
	Dirdata				*dirdat;

	dirdat = (Dirdata *)data;
	text_stringset("5", dirdat);
	return 1;
}



/****************************************************************************/
/*																			*/
/****************************************************************************/
int _6_set(caddr_t data)
{
	Dirdata				*dirdat;

	dirdat = (Dirdata *)data;
	text_stringset("6", dirdat);
	return 1;
}



/****************************************************************************/
/*																			*/
/****************************************************************************/
int _7_set(caddr_t data)
{
	Dirdata				*dirdat;

	dirdat = (Dirdata *)data;
	text_stringset("7", dirdat);
	return 1;
}



/****************************************************************************/
/*																			*/
/****************************************************************************/
int _8_set(caddr_t data)
{
	Dirdata				*dirdat;

	dirdat = (Dirdata *)data;
	text_stringset("8", dirdat);
	return 1;
}



/****************************************************************************/
/*																			*/
/****************************************************************************/
int _9_set(caddr_t data)
{
	Dirdata				*dirdat;

	dirdat = (Dirdata *)data;
	text_stringset("9", dirdat);
	return 1;
}



/****************************************************************************/
/*																			*/
/****************************************************************************/
int _minusset(caddr_t data)
{
	Dirdata				*dirdat;

	dirdat = (Dirdata *)data;
	text_stringset("-", dirdat);
	return 1;
}



/****************************************************************************/
/*																			*/
/****************************************************************************/
int _commaset(caddr_t data)
{
	Dirdata				*dirdat;

	dirdat = (Dirdata *)data;
	text_stringset(",", dirdat);
	return 1;
}



/****************************************************************************/
/*																			*/
/****************************************************************************/
int _periodset(caddr_t data)
{
	Dirdata				*dirdat;

	dirdat = (Dirdata *)data;
	text_stringset(".", dirdat);
	return 1;
}



/****************************************************************************/
/*																			*/
/****************************************************************************/
int _slashset(caddr_t data)
{
	Dirdata				*dirdat;

	dirdat = (Dirdata *)data;
	text_stringset("/", dirdat);
	return 1;
}



/****************************************************************************/
/*																			*/
/****************************************************************************/
int __set(caddr_t data)
{
	Dirdata				*dirdat;

	dirdat = (Dirdata *)data;
	text_stringset("_", dirdat);
	return 1;
}



/****************************************************************************/
/*																			*/
/****************************************************************************/
static void text_stringset(char *str, Dirdata *data)
{
	register int		i, n, n1, a;

	n  = strlen(data->text);
	n1 = strlen(str);
	if(n < (TEXTSTR - 1)){
		for(i=0; i<n1; i++){
			if((n + i) >= TEXTSTR)	break;
			data->text[n + i] = *(str + i);
		}
		data->text[n + i] = '\0';
	}
	XClearArea(display,data->FileText->xid,0,0,0,0,True);
}



/************************************************************************/
/* fBNgf[^̎擾												*/
/************************************************************************/
int get_dir(Dirdata *dirdat)
{
	DIR					*dirp;
	register int		i, j;
	short				n, nn, flg;
	struct direct 		*dir;
	struct stat			sbuf;
	DIRLIST 			*new_p, *before_p, *after_p;
	char 				ss[200], tmp[20], wpath[TEXTSTR], *p1, *p2;

	XFlush(display);

	dirdat->dir_pnt = 0;
	dirdat->fcnt    = 0;

	dirmem_free(dirdat);      /* dir memory free */

	strcpy( wpath,dirdat->text );								/* path name save */
	p1 = (char *)rindex(  wpath,'/' );
	if( !(strlen(wpath)) || p1==NULL ) strcpy( wpath,"./" );
	else	*(p1+1)='\0';
	
	if( (dirp=opendir(wpath))==NULL ) return( -1 );		/* dir error */

	while( (dir=readdir(dirp))!=NULL ) {
		if( !(dir->d_ino) )	continue;					/* skip removed file */

		new_p = (DIRLIST *)calloc(1,sizeof(DIRLIST));		/* memory allocate */
		if( new_p==NULL ) break;						/* memory allocate error */
		/* mۏoȂ_ directory-search I */

		strcpy( ss,wpath );
		strcat( ss,"/" );
		strcat( ss,dir->d_name );
		stat( ss,&sbuf );
		flg = 0;
		switch( sbuf.st_mode & S_IFMT ) {
			case S_IFREG:								/* file */
				n  = strlen( dirdat->extend );
				nn = dir->d_namlen - n;
				if( !n || (strcmp( dirdat->extend,&(dir->d_name[nn])) ) == 0 ) {
					strncpy( new_p->name,dir->d_name,nn );
					new_p->name[nn] = '\0';
					new_p->flag = 0;
					flg = 1;
				}
				break;

			case S_IFDIR:								/* directory */
				strcpy( new_p->name,dir->d_name );
				new_p->flag = 1;
				flg = 1;
				break;

			default:
				break;
		}

		if( flg ) {
			dirdat->fcnt ++;
			p2 = (char *)ctime(&sbuf.st_mtime);
			month_chg( p2,tmp );
			strncpy( new_p->date,p2+22,2 );
			new_p->date[2] = '\0';
			strcat( new_p->date,tmp );
			strncat( new_p->date,p2+8,8 );
			if( new_p->date[6] == ' ' ) new_p->date[6]='0';
			new_p->date[14]='\0';
		
			if( dirdat->top == NULL ) {
				dirdat->top = new_p;
				new_p->next = NULL;
			}
			else {
				before_p = dirdat->top;
				while(1) {					/* sort */ 
					after_p = before_p->next;
					if( after_p == NULL ) break;
					if( (strcmp(new_p->name,after_p->name)) < 0 ) break;		/* alphabet sorting */
					/** if( (strcmp(new_p->date,after_p->date)) > 0 ) break; **/ /* date sorting */
					before_p=after_p;
				}
				before_p->next=new_p;
				new_p->next=after_p;
			}
		}
		
	}

	closedir( dirp );
	return( 0 );
}



/************************************************************************/
/* dir memory free														*/
/************************************************************************/
void dirmem_free(Dirdata *dirdat)
{
	DIRLIST *p;

	if( dirdat->top != NULL ) {
		for( p=dirdat->top; p!=NULL; p=p->next )	free( (DIRLIST *)p );
		dirdat->top = NULL;
	}
}


/************************************************************************/
/* pꖼ̌𐔎ɕϊ 												*/
/************************************************************************/
void month_chg(char *sp, char *rp)
{
	register int			i;
	
	for( i=0; i<12; i++ ) {
		if( strncmp(sp+4,month[i],3)==0 )  break;
	}
	i++;
		
	*rp='-';
	if( i<10 ) {
		*(rp+1)=0x30;			
		*(rp+2)=i+0x30;
	}
	else {
		*(rp+1)=(i/10)+0x30;			
		*(rp+2)=(i%10)+0x30;
	}
	*(rp+3)='-';
	*(rp+4)='\0';
}











/********************************************************************************/
/*	Directory type2																*/
/********************************************************************************/
XWIN *MakeXDirset2(int x, int y, unsigned bdwidth,
		unsigned long bdcolor, unsigned long bgcolor,
		Window parent, char *label, caddr_t action_data,...)
{
	register int	i, x0, y0, y1;
	unsigned		width, height, border;
	va_list			argp;
	XSizeHints		hint;
	XWIN			*new_button;
	D_DIRSET		*p_data;
	P_ACTION		p_action;

	if((p_data = (D_DIRSET *)calloc(1,sizeof(D_DIRSET))) == NULL){
		fprintf(stderr,"No memory for button's data");
		exit(1);
	}

	if((new_button = (XWIN *)calloc(1,sizeof(XWIN))) == NULL){
		fprintf(stderr,"No memory for button");
		exit(1);
	}

	p_data->action_args          = action_data;
	p_data->label                = label;
	p_data->expose_action        = NULL;
	p_data->buttonpress_action   = NULL;
	p_data->buttonrelease_action = NULL;
	p_data->motion_action        = NULL;

	va_start(argp,action_data);
	while((p_action = va_arg(argp,P_ACTION)) != NULL){
		switch(va_arg(argp,int)){
			case Expose :
				p_data->expose_action = p_action;
				break;
			case ButtonPress :
				p_data->buttonpress_action = p_action;
				break;
			case ButtonRelease :
				p_data->buttonrelease_action = p_action;
				break;
			case MotionNotify :
				p_data->motion_action = p_action;
				break;
		}
	}
	va_end(argp);

	hint.x          = x;
	hint.y          = y;
	hint.width      = WINDOWWID;
	hint.height     = WINDOWHIT;
	hint.min_width  = WINDOWWID;
	hint.min_height = WINDOWHIT;
	hint.max_width  = WINDOWWID;
	hint.max_height = WINDOWHIT;
	hint.flags      = USPosition | USSize | PMinSize | PMaxSize;

	new_button->data          = p_data;
	new_button->event_handler = dir_handler;
	new_button->xid           = XCreateSimpleWindow(display,parent,x,y,WINDOWWID,WINDOWHIT,
									bdwidth,bdcolor,bgcolor);

	if(XSaveContext(display,new_button->xid,xwin_context,(caddr_t)new_button) != 0){
		fprintf(stderr,"Error saving xwin_context data");
		exit(1);
	}

	XSetNormalHints(display,new_button->xid,&hint);
	XStoreName(display,new_button->xid,label);
	XSelectInput(display,new_button->xid,WINDMASK);

	border      = UNMAPBTBW;
	width       = UNMAPBTWD;
	height      = UNMAPBTHT;
	x0          = UNMAPBTXP;
	y0          = UNMAPBTYP;
	UnmapButton = MakeXButton(x0,y0,width,height,border,FG,BG,
					new_button->xid,unmap_label,_mainunmap,NULL,BUTTON16MODE);

	border      = DIRWINBDW;
	width       = DIRWINWID;
	height      = DIRWINHIT;
	x0          = DIRWINXPS;
	y0          = DIRWINYPS;
	DirDisplay  = MakeXGraphic(x0,y0,width,height,border,FG,BG,
						new_button->xid,"",action_data,NORMAL,
						_directorydisp2, Expose,
						_nameselect2,    ButtonRelease,
						NULL);
	border      = UPBUTTONBW;
	width       = UPBUTTONWD;
	height      = UPBUTTONHT;
	x0          = UPBUTTONXP;
	y0          = UPBUTTONYP;
	UpButton    = MakeXButton(x0,y0,width,height,border,FG,BG,
					new_button->xid,up_label,_scrollup2,action_data,BUTTON16MODE);
	border      = DNBUTTONBW;
	width       = DNBUTTONWD;
	height      = DNBUTTONHT;
	x0          = DNBUTTONXP;
	y0          = DNBUTTONYP;
	DownButton  = MakeXButton(x0,y0,width,height,border,FG,BG,
					new_button->xid,down_label,_scrolldown2,action_data,BUTTON16MODE);
	border      = BARBDW;
	width       = BARWIDTH;
	height      = BARHEIGHT;
	x0          = BARXPOS;
	y0          = BARYPOS;
	ScrollBar   = MakeXGraphic(x0,y0,width,height,border,FG,BG,
						new_button->xid,"",action_data,NORMAL,
						_scrollbardisp2,      Expose,
						_scrollbarmovestart2, ButtonPress,
						_scrollbarmove2,      MotionNotify,
						_scrollbarmoveend2,   ButtonRelease,
						NULL);

	border          = BUTTONBDW;
	width           = BUTTONWID2;
	height          = BUTTONHIT;
	x0              = BUTTONXPS;
	y0              = BUTTONYPS;
	ClearButton     = MakeXButton(x0,y0,width,height,border,FG,BG,
						new_button->xid,clear_label,_textclear2,action_data,BUTTON16MODE);
	x0 += BUTTONDISTW2;
	BackSpaceButton = MakeXButton(x0,y0,width,height,border,FG,BG,
						new_button->xid,backspace_label,_textbackspace2,action_data,BUTTON16MODE);
	width  = BUTTONWID;
	height = BUTTONHIT;
	x0     = BUTTONXPS;
	y0    += BUTTONDISTH;
	y1     = y0 + BUTTONDISTH;
	for(i=0; i<ALPHA; i++){
		AlphaButton[i] = MakeXButton(x0,y0,width,height,border,FG,BG,
							new_button->xid,Alphabet16[i],_Alphaset2[i],action_data,BUTTON16MODE);
		alphaButton[i] = MakeXButton(x0,y1,width,height,border,FG,BG,
							new_button->xid,alphabet16[i],_alphaset2[i],action_data,BUTTON16MODE);
		x0 += BUTTONDISTW;
	}
	x0 = BUTTONXPS;
	y0 = y1 + BUTTONDISTH;
	for(i=0; i<FIGURE; i++){
		FigureButton[i] = MakeXButton(x0,y0,width,height,border,FG,BG,
							new_button->xid,figure16[i],_figureset2[i],action_data,BUTTON16MODE);
		x0 += BUTTONDISTW;
	}
	MinusButton  = MakeXButton(x0,y0,width,height,border,FG,BG,
						new_button->xid,minus_label,_minusset2,action_data,BUTTON16MODE);
	x0 += BUTTONDISTW;
	CommaButton  = MakeXButton(x0,y0,width,height,border,FG,BG,
						new_button->xid,comma_label,_commaset2,action_data,BUTTON16MODE);
	x0 += BUTTONDISTW;
	PeriodButton = MakeXButton(x0,y0,width,height,border,FG,BG,
						new_button->xid,period_label,_periodset2,action_data,BUTTON16MODE);
	x0 += BUTTONDISTW;
	SlashButton  = MakeXButton(x0,y0,width,height,border,FG,BG,
						new_button->xid,slash_label,_slashset2,action_data,BUTTON16MODE);
	x0 += BUTTONDISTW;
	_Button      = MakeXButton(x0,y0,width,height,border,FG,BG,
						new_button->xid,__label,__set2,action_data,BUTTON16MODE);
	x0 += BUTTONDISTW;


	MainStage = new_button;
	return new_button;
}






/****************************************************************************/
/*																			*/
/****************************************************************************/
int _directorydisp2(caddr_t data)
{
	static char			dirstr[EXTENDSTR] = "<DIR>";
	char				str[DISPSTRING + 1], str2[EXTENDSTR];
	register int		i, j, x0, y0, x1, extlen, textlen, dirlen, n, nn;
	DirDatas			*dirs;
	Dirdata2			*dirdat;
	DIRLIST				*pnt;
	XWindowAttributes	attr;

	dirs   = (DirDatas *)data;
	dirdat = dirs->texts + dirs->number;

	if(event.xexpose.count == 0){
		XClearWindow(display,event.xexpose.window);
		if((pnt = dirs->top) != NULL){
			extlen  = strlen(dirdat->extend);
			strcpy(str2,dirdat->extend);
			dirlen  = strlen(dirstr);
			if(extlen < dirlen){
				for(i=extlen; i<(dirlen-extlen); i++)	str2[i] = ' ';
				str2[i] = '\0';
				extlen = dirlen;
			}
			else{
				for(i=dirlen; i<(extlen-dirlen); i++)	dirstr[i] = ' ';
				dirstr[i] = '\0';
				dirlen = extlen;
			}
			textlen = DISPSTRING - DATESTRING - extlen - 1;
			XGetWindowAttributes(display,event.xexpose.window,&attr);
			x0 = 2;
			y0 = FONTHEIGHT;
			x1 = attr.width / 2 + x0;
			for(i=0; i<dirs->dir_pnt; i++){
				if((pnt = pnt->next) == NULL)	break;
			}
			for(j=0; j<DIRLINE; j++){
				if(pnt == NULL)	break;
				strcpy(str,pnt->name);
				if((n = strlen(str)) > textlen){
					str[textlen+1] = '\0';
				}
				else{
					nn = textlen - n;
					for(i=0; i<nn; i++)	strcat(str," ");
				}
				if(pnt->flag)	strcat(str,dirstr);
				else	strcat(str,str2);
				strcat(str," ");
				strcat(str,pnt->date);
				XDrawString(display,event.xexpose.window,gc,x0,y0,str,strlen(str));
				if((pnt = pnt->next) == NULL)	break;
				strcpy(str,pnt->name);
				if((n = strlen(str)) > textlen){
					str[textlen+1] = '\0';
				}
				else{
					nn = textlen - n;
					for(i=0; i<nn; i++)	strcat(str," ");
				}
				if(pnt->flag)	strcat(str,dirstr);
				else	strcat(str,str2);
				strcat(str," ");
				strcat(str,pnt->date);
				XDrawString(display,event.xexpose.window,gc,x1,y0,str,strlen(str));
				y0 += ONELINE;
				pnt = pnt->next;
			}
		}
		XClearArea(display,ScrollBar->xid,0,0,0,0,True);
	}
	return 1;
}



/****************************************************************************/
/*																			*/
/****************************************************************************/
int _nameselect2(caddr_t data)
{
	register int		i, x, y, n, n1, flag;
	char				*s, str[TEXTSTR];
	XWindowAttributes	attr;
	DirDatas			*dirs;
	Dirdata2			*dirdat;
	DIRLIST				*pnt;

	dirs   = (DirDatas *)data;
	dirdat = dirs->texts + dirs->number;

	XGetWindowAttributes(display,event.xbutton.window,&attr);
	x = event.xbutton.x / (attr.width / 2);
	if(x < 0)	x = 0;
	else if(x > 1)	x = 1;
	y = event.xbutton.y / ONELINE;
	if(y < 0)	y = 0;
	else if(y > 9)	y = 9;
	n = x | (y << 1);


	pnt = dirs->top;
	for(i=0; i<dirs->dir_pnt; i++){
		if(pnt == NULL)	break;
		pnt = pnt->next;
	}
	for(i=0; i<n; i++){
		if(pnt == NULL)	break;
		pnt = pnt->next;
	}
	flag = 1;
	if(pnt != NULL){
		if(strcmp(pnt->name,".") != 0){
			if((s = (char *)strrchr(dirdat->text,'/')) != NULL){
				*(s + 1) = '\0';
				if(strcmp(pnt->name,"..") == 0){
					strcpy(str,dirdat->text);
					str[strlen(str) - 1] = '\0';
					if((s = (char *)strrchr(str,'/')) != NULL){
						if(strcmp((s + 1),"..") != 0){
							dirdat->text[strlen(dirdat->text) - 1] = '\0';
							s        = (char *)strrchr(dirdat->text,'/');
							*(s + 1) = '\0';
							flag = 0;
						}
					}
					else if(strcmp(str,"..") != 0){
						dirdat->text[0] = '\0';
						flag = 0;
					}
				}
			}
			else	dirdat->text[0] = '\0';
			if(flag){
				n  = strlen(dirdat->text);
				n1 = strlen(pnt->name);
				i  = 0;
				do{
					if(n >= TEXTSTR)	break;
					dirdat->text[n++] = pnt->name[i++];
				}while(i < n1);
				if(n < TEXTSTR && pnt->flag){
					dirdat->text[n++] = '/';
					dirdat->text[n]   = '\0';
					get_dir2(dirs);
					XClearArea(display,DirDisplay->xid,0,0,0,0,True);
				}
				else	dirdat->text[n] = '\0';
			}
			else{
				get_dir2(dirs);
				XClearArea(display,DirDisplay->xid,0,0,0,0,True);
			}
			XClearArea(display,dirdat->FileText->xid,0,0,0,0,True);
		}
	}

	return 1;
}



/****************************************************************************/
/*																			*/
/****************************************************************************/
int _scrollbardisp2(caddr_t data)
{
	register int		x, y, n;
	unsigned			width, height;
	XWindowAttributes	attr;
	DirDatas			*dirs;
	Dirdata2			*dirdat;

	dirs   = (DirDatas *)data;
	dirdat = dirs->texts + dirs->number;

	if(event.xexpose.count == 0){
		XClearWindow(display,event.xexpose.window);
		XGetWindowAttributes(display,event.xexpose.window,&attr);
		x      = 0;
		width  = attr.width;
		n      = (dirs->fcnt / 2) + (dirs->fcnt % 2);
		height = attr.height - (((n - 1) / DIRLINE) * PAGEDOT);
		y      = dirs->dir_pnt / SCROLLFILE;
		XFillRectangle(display,event.xexpose.window,gc,x,y,width,height);
	}
	return 1;
}




/****************************************************************************/
/*																			*/
/****************************************************************************/
int _scrollbarmovestart2(caddr_t data)
{
	DirDatas			*dirs;
	Dirdata2			*dirdat;
	Cursor				cur;

	dirs   = (DirDatas *)data;
	dirdat = dirs->texts + dirs->number;

	scrollpos = event.xbutton.y;
	return 1;
}



/****************************************************************************/
/*																			*/
/****************************************************************************/
int _scrollbarmove2(caddr_t data)
{
	register int		n, n2;
	DirDatas			*dirs;
	Dirdata2			*dirdat;

	dirs   = (DirDatas *)data;
	dirdat = dirs->texts + dirs->number;

	n  = (event.xmotion.y - scrollpos) * SCROLLFILE;
	n2 = (((dirs->fcnt / 2) + (dirs->fcnt % 2)) - (DIRLINE)) * 2;
	n2 = (int)((n2 + 9) / 10) * 10;
	dirs->dir_pnt += n;
	if(dirs->dir_pnt < 0)	dirs->dir_pnt = 0;
	else if(dirs->dir_pnt > n2)	dirs->dir_pnt = n2;
	XClearArea(display,ScrollBar->xid,0,0,0,0,True);
	scrollpos = event.xmotion.y;
	return 1;
}



/****************************************************************************/
/*																			*/
/****************************************************************************/
int _scrollbarmoveend2(caddr_t data)
{
	register int		n, n2;
	DirDatas			*dirs;
	Dirdata2			*dirdat;

	dirs   = (DirDatas *)data;
	dirdat = dirs->texts + dirs->number;


	n  = (event.xmotion.y - scrollpos) * SCROLLFILE;
	n2 = (((dirs->fcnt / 2) + (dirs->fcnt % 2)) - (DIRLINE)) * 2;
	n2 = (int)((n2 + 9) / 10) * 10;
	dirs->dir_pnt += n;
	if(dirs->dir_pnt < 0)	dirs->dir_pnt = 0;
	else if(dirs->dir_pnt > n2)	dirs->dir_pnt = n2;
	XClearArea(display,ScrollBar->xid,0,0,0,0,True);
	XClearArea(display,DirDisplay->xid,0,0,0,0,True);
	return 1;
}



/****************************************************************************/
/*																			*/
/****************************************************************************/
int _scrollup2(caddr_t data)
{
	DirDatas			*dirs;
	Dirdata2			*dirdat;

	dirs   = (DirDatas *)data;
	dirdat = dirs->texts + dirs->number;

	dirs->dir_pnt -= 2;
	if(dirs->dir_pnt < 0)	dirs->dir_pnt = 0;
	XClearArea(display,ScrollBar->xid,0,0,0,0,True);
	XClearArea(display,DirDisplay->xid,0,0,0,0,True);
	return 1;
}



/****************************************************************************/
/*																			*/
/****************************************************************************/
int _scrolldown2(caddr_t data)
{
	register int		n;
	DirDatas			*dirs;
	Dirdata2			*dirdat;

	dirs   = (DirDatas *)data;
	dirdat = dirs->texts + dirs->number;

	n = (((dirs->fcnt / 2) + (dirs->fcnt % 2)) - (DIRLINE)) * 2;
	n = (int)((n + 9) / 10) * 10;
	dirs->dir_pnt += 2;
	if(dirs->dir_pnt > n)	dirs->dir_pnt = n;
	XClearArea(display,ScrollBar->xid,0,0,0,0,True);
	XClearArea(display,DirDisplay->xid,0,0,0,0,True);
	return 1;
}



/****************************************************************************/
/*																			*/
/****************************************************************************/
int _textclear2(caddr_t data)
{
	DirDatas			*dirs;
	Dirdata2			*dirdat;

	dirs   = (DirDatas *)data;
	dirdat = dirs->texts + dirs->number;

	dirdat->text[0] = '\0';
	XClearArea(display,dirdat->FileText->xid,0,0,0,0,True);
	get_dir2(dirs);
	XClearArea(display,DirDisplay->xid,0,0,0,0,True);
	return 1;
}



/****************************************************************************/
/*																			*/
/****************************************************************************/
int _textbackspace2(caddr_t data)
{
	register int		n;
	DirDatas			*dirs;
	Dirdata2			*dirdat;

	dirs   = (DirDatas *)data;
	dirdat = dirs->texts + dirs->number;

	n      = strlen(dirdat->text);
	if(n)	dirdat->text[n-1] = '\0';
	XClearArea(display,dirdat->FileText->xid,0,0,0,0,True);
	return 1;
}



/****************************************************************************/
/*																			*/
/****************************************************************************/
int A_set2(caddr_t data)
{
	DirDatas			*dirs;
	Dirdata2			*dirdat;

	dirs   = (DirDatas *)data;
	dirdat = dirs->texts + dirs->number;

	text_stringset2("A", dirdat);
	return 1;
}



/****************************************************************************/
/*																			*/
/****************************************************************************/
int B_set2(caddr_t data)
{
	DirDatas			*dirs;
	Dirdata2			*dirdat;

	dirs   = (DirDatas *)data;
	dirdat = dirs->texts + dirs->number;

	text_stringset2("B", dirdat);
	return 1;
}



/****************************************************************************/
/*																			*/
/****************************************************************************/
int C_set2(caddr_t data)
{
	DirDatas			*dirs;
	Dirdata2			*dirdat;

	dirs   = (DirDatas *)data;
	dirdat = dirs->texts + dirs->number;

	text_stringset2("C", dirdat);
	return 1;
}



/****************************************************************************/
/*																			*/
/****************************************************************************/
int D_set2(caddr_t data)
{
	DirDatas			*dirs;
	Dirdata2			*dirdat;

	dirs   = (DirDatas *)data;
	dirdat = dirs->texts + dirs->number;

	text_stringset2("D", dirdat);
	return 1;
}



/****************************************************************************/
/*																			*/
/****************************************************************************/
int E_set2(caddr_t data)
{
	DirDatas			*dirs;
	Dirdata2			*dirdat;

	dirs   = (DirDatas *)data;
	dirdat = dirs->texts + dirs->number;

	text_stringset2("E", dirdat);
	return 1;
}



/****************************************************************************/
/*																			*/
/****************************************************************************/
int F_set2(caddr_t data)
{
	DirDatas			*dirs;
	Dirdata2			*dirdat;

	dirs   = (DirDatas *)data;
	dirdat = dirs->texts + dirs->number;

	text_stringset2("F", dirdat);
	return 1;
}



/****************************************************************************/
/*																			*/
/****************************************************************************/
int G_set2(caddr_t data)
{
	DirDatas			*dirs;
	Dirdata2			*dirdat;

	dirs   = (DirDatas *)data;
	dirdat = dirs->texts + dirs->number;

	text_stringset2("G", dirdat);
	return 1;
}



/****************************************************************************/
/*																			*/
/****************************************************************************/
int H_set2(caddr_t data)
{
	DirDatas			*dirs;
	Dirdata2			*dirdat;

	dirs   = (DirDatas *)data;
	dirdat = dirs->texts + dirs->number;

	text_stringset2("H", dirdat);
	return 1;
}



/****************************************************************************/
/*																			*/
/****************************************************************************/
int I_set2(caddr_t data)
{
	DirDatas			*dirs;
	Dirdata2			*dirdat;

	dirs   = (DirDatas *)data;
	dirdat = dirs->texts + dirs->number;

	text_stringset2("I", dirdat);
	return 1;
}



/****************************************************************************/
/*																			*/
/****************************************************************************/
int J_set2(caddr_t data)
{
	DirDatas			*dirs;
	Dirdata2			*dirdat;

	dirs   = (DirDatas *)data;
	dirdat = dirs->texts + dirs->number;

	text_stringset2("J", dirdat);
	return 1;
}



/****************************************************************************/
/*																			*/
/****************************************************************************/
int K_set2(caddr_t data)
{
	DirDatas			*dirs;
	Dirdata2			*dirdat;

	dirs   = (DirDatas *)data;
	dirdat = dirs->texts + dirs->number;

	text_stringset2("K", dirdat);
	return 1;
}



/****************************************************************************/
/*																			*/
/****************************************************************************/
int L_set2(caddr_t data)
{
	DirDatas			*dirs;
	Dirdata2			*dirdat;

	dirs   = (DirDatas *)data;
	dirdat = dirs->texts + dirs->number;

	text_stringset2("L", dirdat);
	return 1;
}



/****************************************************************************/
/*																			*/
/****************************************************************************/
int M_set2(caddr_t data)
{
	DirDatas			*dirs;
	Dirdata2			*dirdat;

	dirs   = (DirDatas *)data;
	dirdat = dirs->texts + dirs->number;

	text_stringset2("M", dirdat);
	return 1;
}



/****************************************************************************/
/*																			*/
/****************************************************************************/
int N_set2(caddr_t data)
{
	DirDatas			*dirs;
	Dirdata2			*dirdat;

	dirs   = (DirDatas *)data;
	dirdat = dirs->texts + dirs->number;

	text_stringset2("N", dirdat);
	return 1;
}



/****************************************************************************/
/*																			*/
/****************************************************************************/
int O_set2(caddr_t data)
{
	DirDatas			*dirs;
	Dirdata2			*dirdat;

	dirs   = (DirDatas *)data;
	dirdat = dirs->texts + dirs->number;

	text_stringset2("O", dirdat);
	return 1;
}



/****************************************************************************/
/*																			*/
/****************************************************************************/
int P_set2(caddr_t data)
{
	DirDatas			*dirs;
	Dirdata2			*dirdat;

	dirs   = (DirDatas *)data;
	dirdat = dirs->texts + dirs->number;

	text_stringset2("P", dirdat);
	return 1;
}



/****************************************************************************/
/*																			*/
/****************************************************************************/
int Q_set2(caddr_t data)
{
	DirDatas			*dirs;
	Dirdata2			*dirdat;

	dirs   = (DirDatas *)data;
	dirdat = dirs->texts + dirs->number;

	text_stringset2("Q", dirdat);
	return 1;
}



/****************************************************************************/
/*																			*/
/****************************************************************************/
int R_set2(caddr_t data)
{
	DirDatas			*dirs;
	Dirdata2			*dirdat;

	dirs   = (DirDatas *)data;
	dirdat = dirs->texts + dirs->number;

	text_stringset2("R", dirdat);
	return 1;
}



/****************************************************************************/
/*																			*/
/****************************************************************************/
int S_set2(caddr_t data)
{
	DirDatas			*dirs;
	Dirdata2			*dirdat;

	dirs   = (DirDatas *)data;
	dirdat = dirs->texts + dirs->number;

	text_stringset2("S", dirdat);
	return 1;
}



/****************************************************************************/
/*																			*/
/****************************************************************************/
int T_set2(caddr_t data)
{
	DirDatas			*dirs;
	Dirdata2			*dirdat;

	dirs   = (DirDatas *)data;
	dirdat = dirs->texts + dirs->number;

	text_stringset2("T", dirdat);
	return 1;
}



/****************************************************************************/
/*																			*/
/****************************************************************************/
int U_set2(caddr_t data)
{
	DirDatas			*dirs;
	Dirdata2			*dirdat;

	dirs   = (DirDatas *)data;
	dirdat = dirs->texts + dirs->number;

	text_stringset2("U", dirdat);
	return 1;
}



/****************************************************************************/
/*																			*/
/****************************************************************************/
int V_set2(caddr_t data)
{
	DirDatas			*dirs;
	Dirdata2			*dirdat;

	dirs   = (DirDatas *)data;
	dirdat = dirs->texts + dirs->number;

	text_stringset2("V", dirdat);
	return 1;
}



/****************************************************************************/
/*																			*/
/****************************************************************************/
int W_set2(caddr_t data)
{
	DirDatas			*dirs;
	Dirdata2			*dirdat;

	dirs   = (DirDatas *)data;
	dirdat = dirs->texts + dirs->number;

	text_stringset2("W", dirdat);
	return 1;
}



/****************************************************************************/
/*																			*/
/****************************************************************************/
int X_set2(caddr_t data)
{
	DirDatas			*dirs;
	Dirdata2			*dirdat;

	dirs   = (DirDatas *)data;
	dirdat = dirs->texts + dirs->number;

	text_stringset2("X", dirdat);
	return 1;
}



/****************************************************************************/
/*																			*/
/****************************************************************************/
int Y_set2(caddr_t data)
{
	DirDatas			*dirs;
	Dirdata2			*dirdat;

	dirs   = (DirDatas *)data;
	dirdat = dirs->texts + dirs->number;

	text_stringset2("Y", dirdat);
	return 1;
}



/****************************************************************************/
/*																			*/
/****************************************************************************/
int Z_set2(caddr_t data)
{
	DirDatas			*dirs;
	Dirdata2			*dirdat;

	dirs   = (DirDatas *)data;
	dirdat = dirs->texts + dirs->number;

	text_stringset2("Z", dirdat);
	return 1;
}



/****************************************************************************/
/*																			*/
/****************************************************************************/
int a_set2(caddr_t data)
{
	DirDatas			*dirs;
	Dirdata2			*dirdat;

	dirs   = (DirDatas *)data;
	dirdat = dirs->texts + dirs->number;

	text_stringset2("a", dirdat);
	return 1;
}



/****************************************************************************/
/*																			*/
/****************************************************************************/
int b_set2(caddr_t data)
{
	DirDatas			*dirs;
	Dirdata2			*dirdat;

	dirs   = (DirDatas *)data;
	dirdat = dirs->texts + dirs->number;

	text_stringset2("b", dirdat);
	return 1;
}



/****************************************************************************/
/*																			*/
/****************************************************************************/
int c_set2(caddr_t data)
{
	DirDatas			*dirs;
	Dirdata2			*dirdat;

	dirs   = (DirDatas *)data;
	dirdat = dirs->texts + dirs->number;

	text_stringset2("c", dirdat);
	return 1;
}



/****************************************************************************/
/*																			*/
/****************************************************************************/
int d_set2(caddr_t data)
{
	DirDatas			*dirs;
	Dirdata2			*dirdat;

	dirs   = (DirDatas *)data;
	dirdat = dirs->texts + dirs->number;

	text_stringset2("d", dirdat);
	return 1;
}



/****************************************************************************/
/*																			*/
/****************************************************************************/
int e_set2(caddr_t data)
{
	DirDatas			*dirs;
	Dirdata2			*dirdat;

	dirs   = (DirDatas *)data;
	dirdat = dirs->texts + dirs->number;

	text_stringset2("e", dirdat);
	return 1;
}



/****************************************************************************/
/*																			*/
/****************************************************************************/
int f_set2(caddr_t data)
{
	DirDatas			*dirs;
	Dirdata2			*dirdat;

	dirs   = (DirDatas *)data;
	dirdat = dirs->texts + dirs->number;

	text_stringset2("f", dirdat);
	return 1;
}



/****************************************************************************/
/*																			*/
/****************************************************************************/
int g_set2(caddr_t data)
{
	DirDatas			*dirs;
	Dirdata2			*dirdat;

	dirs   = (DirDatas *)data;
	dirdat = dirs->texts + dirs->number;

	text_stringset2("g", dirdat);
	return 1;
}



/****************************************************************************/
/*																			*/
/****************************************************************************/
int h_set2(caddr_t data)
{
	DirDatas			*dirs;
	Dirdata2			*dirdat;

	dirs   = (DirDatas *)data;
	dirdat = dirs->texts + dirs->number;

	text_stringset2("h", dirdat);
	return 1;
}



/****************************************************************************/
/*																			*/
/****************************************************************************/
int i_set2(caddr_t data)
{
	DirDatas			*dirs;
	Dirdata2			*dirdat;

	dirs   = (DirDatas *)data;
	dirdat = dirs->texts + dirs->number;

	text_stringset2("i", dirdat);
	return 1;
}



/****************************************************************************/
/*																			*/
/****************************************************************************/
int j_set2(caddr_t data)
{
	DirDatas			*dirs;
	Dirdata2			*dirdat;

	dirs   = (DirDatas *)data;
	dirdat = dirs->texts + dirs->number;

	text_stringset2("j", dirdat);
	return 1;
}



/****************************************************************************/
/*																			*/
/****************************************************************************/
int k_set2(caddr_t data)
{
	DirDatas			*dirs;
	Dirdata2			*dirdat;

	dirs   = (DirDatas *)data;
	dirdat = dirs->texts + dirs->number;

	text_stringset2("k", dirdat);
	return 1;
}



/****************************************************************************/
/*																			*/
/****************************************************************************/
int l_set2(caddr_t data)
{
	DirDatas			*dirs;
	Dirdata2			*dirdat;

	dirs   = (DirDatas *)data;
	dirdat = dirs->texts + dirs->number;

	text_stringset2("l", dirdat);
	return 1;
}



/****************************************************************************/
/*																			*/
/****************************************************************************/
int m_set2(caddr_t data)
{
	DirDatas			*dirs;
	Dirdata2			*dirdat;

	dirs   = (DirDatas *)data;
	dirdat = dirs->texts + dirs->number;

	text_stringset2("m", dirdat);
	return 1;
}



/****************************************************************************/
/*																			*/
/****************************************************************************/
int n_set2(caddr_t data)
{
	DirDatas			*dirs;
	Dirdata2			*dirdat;

	dirs   = (DirDatas *)data;
	dirdat = dirs->texts + dirs->number;

	text_stringset2("n", dirdat);
	return 1;
}



/****************************************************************************/
/*																			*/
/****************************************************************************/
int o_set2(caddr_t data)
{
	DirDatas			*dirs;
	Dirdata2			*dirdat;

	dirs   = (DirDatas *)data;
	dirdat = dirs->texts + dirs->number;

	text_stringset2("o", dirdat);
	return 1;
}



/****************************************************************************/
/*																			*/
/****************************************************************************/
int p_set2(caddr_t data)
{
	DirDatas			*dirs;
	Dirdata2			*dirdat;

	dirs   = (DirDatas *)data;
	dirdat = dirs->texts + dirs->number;

	text_stringset2("p", dirdat);
	return 1;
}



/****************************************************************************/
/*																			*/
/****************************************************************************/
int q_set2(caddr_t data)
{
	DirDatas			*dirs;
	Dirdata2			*dirdat;

	dirs   = (DirDatas *)data;
	dirdat = dirs->texts + dirs->number;

	text_stringset2("q", dirdat);
	return 1;
}



/****************************************************************************/
/*																			*/
/****************************************************************************/
int r_set2(caddr_t data)
{
	DirDatas			*dirs;
	Dirdata2			*dirdat;

	dirs   = (DirDatas *)data;
	dirdat = dirs->texts + dirs->number;

	text_stringset2("r", dirdat);
	return 1;
}



/****************************************************************************/
/*																			*/
/****************************************************************************/
int s_set2(caddr_t data)
{
	DirDatas			*dirs;
	Dirdata2			*dirdat;

	dirs   = (DirDatas *)data;
	dirdat = dirs->texts + dirs->number;

	text_stringset2("s", dirdat);
	return 1;
}



/****************************************************************************/
/*																			*/
/****************************************************************************/
int t_set2(caddr_t data)
{
	DirDatas			*dirs;
	Dirdata2			*dirdat;

	dirs   = (DirDatas *)data;
	dirdat = dirs->texts + dirs->number;

	text_stringset2("t", dirdat);
	return 1;
}



/****************************************************************************/
/*																			*/
/****************************************************************************/
int u_set2(caddr_t data)
{
	DirDatas			*dirs;
	Dirdata2			*dirdat;

	dirs   = (DirDatas *)data;
	dirdat = dirs->texts + dirs->number;

	text_stringset2("u", dirdat);
	return 1;
}



/****************************************************************************/
/*																			*/
/****************************************************************************/
int v_set2(caddr_t data)
{
	DirDatas			*dirs;
	Dirdata2			*dirdat;

	dirs   = (DirDatas *)data;
	dirdat = dirs->texts + dirs->number;

	text_stringset2("v", dirdat);
	return 1;
}



/****************************************************************************/
/*																			*/
/****************************************************************************/
int w_set2(caddr_t data)
{
	DirDatas			*dirs;
	Dirdata2			*dirdat;

	dirs   = (DirDatas *)data;
	dirdat = dirs->texts + dirs->number;

	text_stringset2("w", dirdat);
	return 1;
}



/****************************************************************************/
/*																			*/
/****************************************************************************/
int x_set2(caddr_t data)
{
	DirDatas			*dirs;
	Dirdata2			*dirdat;

	dirs   = (DirDatas *)data;
	dirdat = dirs->texts + dirs->number;

	text_stringset2("x", dirdat);
	return 1;
}



/****************************************************************************/
/*																			*/
/****************************************************************************/
int y_set2(caddr_t data)
{
	DirDatas			*dirs;
	Dirdata2			*dirdat;

	dirs   = (DirDatas *)data;
	dirdat = dirs->texts + dirs->number;

	text_stringset2("y", dirdat);
	return 1;
}



/****************************************************************************/
/*																			*/
/****************************************************************************/
int z_set2(caddr_t data)
{
	DirDatas			*dirs;
	Dirdata2			*dirdat;

	dirs   = (DirDatas *)data;
	dirdat = dirs->texts + dirs->number;

	text_stringset2("z", dirdat);
	return 1;
}



/****************************************************************************/
/*																			*/
/****************************************************************************/
int _0_set2(caddr_t data)
{
	DirDatas			*dirs;
	Dirdata2			*dirdat;

	dirs   = (DirDatas *)data;
	dirdat = dirs->texts + dirs->number;

	text_stringset2("0", dirdat);
	return 1;
}



/****************************************************************************/
/*																			*/
/****************************************************************************/
int _1_set2(caddr_t data)
{
	DirDatas			*dirs;
	Dirdata2			*dirdat;

	dirs   = (DirDatas *)data;
	dirdat = dirs->texts + dirs->number;

	text_stringset2("1", dirdat);
	return 1;
}



/****************************************************************************/
/*																			*/
/****************************************************************************/
int _2_set2(caddr_t data)
{
	DirDatas			*dirs;
	Dirdata2			*dirdat;

	dirs   = (DirDatas *)data;
	dirdat = dirs->texts + dirs->number;

	text_stringset2("2", dirdat);
	return 1;
}



/****************************************************************************/
/*																			*/
/****************************************************************************/
int _3_set2(caddr_t data)
{
	DirDatas			*dirs;
	Dirdata2			*dirdat;

	dirs   = (DirDatas *)data;
	dirdat = dirs->texts + dirs->number;

	text_stringset2("3", dirdat);
	return 1;
}



/****************************************************************************/
/*																			*/
/****************************************************************************/
int _4_set2(caddr_t data)
{
	DirDatas			*dirs;
	Dirdata2			*dirdat;

	dirs   = (DirDatas *)data;
	dirdat = dirs->texts + dirs->number;

	text_stringset2("4", dirdat);
	return 1;
}



/****************************************************************************/
/*																			*/
/****************************************************************************/
int _5_set2(caddr_t data)
{
	DirDatas			*dirs;
	Dirdata2			*dirdat;

	dirs   = (DirDatas *)data;
	dirdat = dirs->texts + dirs->number;

	text_stringset2("5", dirdat);
	return 1;
}



/****************************************************************************/
/*																			*/
/****************************************************************************/
int _6_set2(caddr_t data)
{
	DirDatas			*dirs;
	Dirdata2			*dirdat;

	dirs   = (DirDatas *)data;
	dirdat = dirs->texts + dirs->number;

	text_stringset2("6", dirdat);
	return 1;
}



/****************************************************************************/
/*																			*/
/****************************************************************************/
int _7_set2(caddr_t data)
{
	DirDatas			*dirs;
	Dirdata2			*dirdat;

	dirs   = (DirDatas *)data;
	dirdat = dirs->texts + dirs->number;

	text_stringset2("7", dirdat);
	return 1;
}



/****************************************************************************/
/*																			*/
/****************************************************************************/
int _8_set2(caddr_t data)
{
	DirDatas			*dirs;
	Dirdata2			*dirdat;

	dirs   = (DirDatas *)data;
	dirdat = dirs->texts + dirs->number;

	text_stringset2("8", dirdat);
	return 1;
}



/****************************************************************************/
/*																			*/
/****************************************************************************/
int _9_set2(caddr_t data)
{
	DirDatas			*dirs;
	Dirdata2			*dirdat;

	dirs   = (DirDatas *)data;
	dirdat = dirs->texts + dirs->number;

	text_stringset2("9", dirdat);
	return 1;
}



/****************************************************************************/
/*																			*/
/****************************************************************************/
int _minusset2(caddr_t data)
{
	DirDatas			*dirs;
	Dirdata2			*dirdat;

	dirs   = (DirDatas *)data;
	dirdat = dirs->texts + dirs->number;

	text_stringset2("-", dirdat);
	return 1;
}



/****************************************************************************/
/*																			*/
/****************************************************************************/
int _commaset2(caddr_t data)
{
	DirDatas			*dirs;
	Dirdata2			*dirdat;

	dirs   = (DirDatas *)data;
	dirdat = dirs->texts + dirs->number;

	text_stringset2(",", dirdat);
	return 1;
}



/****************************************************************************/
/*																			*/
/****************************************************************************/
int _periodset2(caddr_t data)
{
	DirDatas			*dirs;
	Dirdata2			*dirdat;

	dirs   = (DirDatas *)data;
	dirdat = dirs->texts + dirs->number;

	text_stringset2(".", dirdat);
	return 1;
}



/****************************************************************************/
/*																			*/
/****************************************************************************/
int _slashset2(caddr_t data)
{
	DirDatas			*dirs;
	Dirdata2			*dirdat;

	dirs   = (DirDatas *)data;
	dirdat = dirs->texts + dirs->number;

	text_stringset2("/", dirdat);
	return 1;
}



/****************************************************************************/
/*																			*/
/****************************************************************************/
int __set2(caddr_t data)
{
	DirDatas			*dirs;
	Dirdata2			*dirdat;

	dirs   = (DirDatas *)data;
	dirdat = dirs->texts + dirs->number;

	text_stringset2("_", dirdat);
	return 1;
}



/****************************************************************************/
/*																			*/
/****************************************************************************/
static void text_stringset2(char *str, Dirdata2 *data)
{
	register int		i, n, n1, a;

	n  = strlen(data->text);
	n1 = strlen(str);
	if(n < (TEXTSTR - 1)){
		for(i=0; i<n1; i++){
			if((n + i) >= TEXTSTR)	break;
			data->text[n + i] = *(str + i);
		}
		data->text[n + i] = '\0';
	}
	XClearArea(display,data->FileText->xid,0,0,0,0,True);
}



/************************************************************************/
/* fBNgf[^̎擾												*/
/************************************************************************/
int get_dir2(DirDatas *dirs)
{
	DIR					*dirp;
	register int		i, j;
	short				n, nn, flg;
	struct direct 		*dir;
	struct stat			sbuf;
	DIRLIST 			*new_p, *before_p, *after_p;
	Dirdata2			*dirdat;
	char 				ss[200], tmp[20], wpath[TEXTSTR], *p1, *p2;

	XFlush(display);

	dirs->dir_pnt = 0;
	dirs->fcnt    = 0;
	dirdat        = dirs->texts + dirs->number;

	dirmem_free2(dirs);      /* dir memory free */

	strcpy( wpath,dirdat->text );								/* path name save */
	p1 = (char *)rindex(  wpath,'/' );
	if( !(strlen(wpath)) || p1==NULL ) strcpy( wpath,"./" );
	else	*(p1+1)='\0';
	
	if( (dirp=opendir(wpath))==NULL ) return( -1 );		/* dir error */

	while( (dir=readdir(dirp))!=NULL ) {
		if( !(dir->d_ino) )	continue;					/* skip removed file */

		new_p = (DIRLIST *)calloc(1,sizeof(DIRLIST));		/* memory allocate */
		if( new_p==NULL ) break;						/* memory allocate error */
		/* mۏoȂ_ directory-search I */

		strcpy( ss,wpath );
		strcat( ss,"/" );
		strcat( ss,dir->d_name );
		stat( ss,&sbuf );
		flg = 0;
		switch( sbuf.st_mode & S_IFMT ) {
			case S_IFREG:								/* file */
				n  = strlen( dirdat->extend );
				nn = dir->d_namlen - n;
				if( !n || (strcmp( dirdat->extend,&(dir->d_name[nn])) ) == 0 ) {
					strncpy( new_p->name,dir->d_name,nn );
					new_p->name[nn] = '\0';
					new_p->flag = 0;
					flg = 1;
				}
				break;

			case S_IFDIR:								/* directory */
				strcpy( new_p->name,dir->d_name );
				new_p->flag = 1;
				flg = 1;
				break;

			default:
				break;
		}

		if( flg ) {
			dirs->fcnt ++;
			p2 = (char *)ctime(&sbuf.st_mtime);
			month_chg( p2,tmp );
			strncpy( new_p->date,p2+22,2 );
			new_p->date[2] = '\0';
			strcat( new_p->date,tmp );
			strncat( new_p->date,p2+8,8 );
			if( new_p->date[6] == ' ' ) new_p->date[6]='0';
			new_p->date[14]='\0';
		
			if( dirs->top == NULL ) {
				dirs->top = new_p;
				new_p->next = NULL;
			}
			else {
				before_p = dirs->top;
				while(1) {					/* sort */ 
					after_p = before_p->next;
					if( after_p == NULL ) break;
					if( (strcmp(new_p->name,after_p->name)) < 0 ) break;		/* alphabet sorting */
					/** if( (strcmp(new_p->date,after_p->date)) > 0 ) break; **/ /* date sorting */
					before_p=after_p;
				}
				before_p->next=new_p;
				new_p->next=after_p;
			}
		}
		
	}

	closedir( dirp );
	return( 0 );
}



/************************************************************************/
/* dir memory free														*/
/************************************************************************/
void dirmem_free2(DirDatas *dirs)
{
	DIRLIST *p;

	if( dirs->top != NULL ) {
		for( p=dirs->top; p!=NULL; p=p->next )	free( (DIRLIST *)p );
		dirs->top = NULL;
	}
}


