/************************************************************************/
/*					YOSHI ENEMY DATA SET PROGRAM						*/
/*																		*/
/*			Ver 0.1  Programmed by N.Okajima   [			]			*/
/*																		*/
/*																		*/
/*				(gcc ys_enset.c -O2 -lX11 -o ys_enset)					*/
/************************************************************************/
#include	<stdio.h>
#include	<ctype.h>
#include	<X11/Xlib.h>
#include	<X11/Xutil.h>
#include	<X11/keysym.h>

#define		unlong	unsigned long
#define		unshort unsigned short
#define		unchar	unsigned char
#define		unint	unsigned int

#define	 CHGHL(p)  (((p)>>8)|((p)<<8))	/* low high cange */
#define	 PLANE  8						/* bitmap plane suu */
#define	 ON   0x01						/*                 */
#define	 OFF  0x00						/*                 */
#define	 LOOP 0x01						/* flag parameters */
#define	 END  0x00						/*                 */

unlong White,							/* While pixsel (0) */
       Black;							/* Black pixsel (1) */

int screen,
    flag,
	winp,
	enno,
	dtpt[21];
	
char dtbuf[21][87];

Display *MyDisplay;

Window MainWindow,
       Msg1Window,
       Msg2Window,
       Msg3Window,
       Msg4Window,
       FnamWindow[4],
       ComWindow,
       DtinWindow0[6],
       DtinWindow1[3],
       DtinWindow2[3],
       DtinWindow3[2],
       DtinWindow4[2],
       window_tbl[21],
       EnnoWindow;

GC     GrContext,
       GrContextK;
       
Font	font;

XEvent event;

KeySym key;

XChar2b  msg0[30],
         msg1[30],
         msg2[30],
         msg3[30],
         msg4[30],
         msg5[30],
         msg6[60],
         msg7[60],
         msg8[60],
         msg9[60],
         msg10[60],
         msg11[60],
         msg12[60],
         msg121[60],
         msg13[60],
         msg14[10],
         msg15[10],
         msga[20],
         msgb[20],
         msgc[20],
         msgd[20],
         msge[20],
         msgA[12],
         msgB[12],
         msgC[12],
         msgD[12],
         msgE[12],
         msgF[12];

typedef struct en_list{
	char en_name[6];
	char in_name[8];
	char mv_name[8];
	char fl_name[8];
	char comment[87];
	unshort enmode0;
	unshort enmode1;
	unshort enmode2;
	unshort endat0;
	unshort endat1;
	struct en_list *next; 
} EN_LIST;


EN_LIST rot,*after_ptr,*root;

/************************************************************************/
/*  Main																*/
/************************************************************************/
void main( argc,argv )
int	argc;
char	**argv;
{
	register int i;

	enno = 0;
	root = &rot;
	
	root=NULL;
	
	for( i=0; i<21; i++ ) {
		dtpt[i]=0;
	}	

	OpenWindow();		/* Window open */

	MsgCnv();

	XMapSubwindows( MyDisplay,MainWindow );
	XMapWindow( MyDisplay,MainWindow );

	EventMain();		/* main process */

	XCloseDisplay( MyDisplay );
}

/************************************************************************/
/*  Alloc data 															*/
/************************************************************************/
AllocData()
{
	return( calloc(1,sizeof(EN_LIST)) );
}

/************************************************************************/
/*  Window Open															*/
/************************************************************************/
OpenWindow()
{
	register int  i,p;
	XSizeHints  size;


	MyDisplay =XOpenDisplay( NULL );
	screen	  =DefaultScreen(MyDisplay);
	White     =WhitePixel(MyDisplay,screen);
	Black     =BlackPixel(MyDisplay,screen);
	GrContext =XCreateGC( MyDisplay,DefaultRootWindow(MyDisplay),0,0 );
	GrContextK=XCreateGC( MyDisplay,DefaultRootWindow(MyDisplay),0,0 );

	font=XLoadFont( MyDisplay,"8x16" );
	XSetFont( MyDisplay,GrContext,font );

	font=XLoadFont( MyDisplay,"16x16kanji" );
	XSetFont( MyDisplay,GrContextK,font );

	XSetLineAttributes( MyDisplay,GrContext,2,LineSolid,CapButt,JoinMiter );

	MainWindow=XCreateSimpleWindow( MyDisplay,DefaultRootWindow(MyDisplay),0,0,850,900,0,White,Black );
	Msg1Window=XCreateSimpleWindow( MyDisplay,MainWindow,0,24,80,123,0,White,Black );
	Msg2Window=XCreateSimpleWindow( MyDisplay,MainWindow,150,54,20,64,0,White,Black );
	Msg3Window=XCreateSimpleWindow( MyDisplay,MainWindow,85,160,750,630,0,White,Black );
	Msg4Window=XCreateSimpleWindow( MyDisplay,MainWindow,720,24,80,30,0,White,Black );
	EnnoWindow=XCreateSimpleWindow( MyDisplay,MainWindow,803,24,40,30,2,White,Black );
	ComWindow =XCreateSimpleWindow( MyDisplay,MainWindow,85,122,700,20,1,White,Black );

	XSelectInput( MyDisplay,MainWindow,ExposureMask | KeyPressMask );
	XSelectInput( MyDisplay,ComWindow ,ExposureMask | KeyPressMask );
	XSelectInput( MyDisplay,Msg1Window,ExposureMask | KeyPressMask );
	XSelectInput( MyDisplay,Msg2Window,ExposureMask | KeyPressMask );
	XSelectInput( MyDisplay,Msg3Window,ExposureMask | KeyPressMask );
	XSelectInput( MyDisplay,Msg4Window,ExposureMask | KeyPressMask );
	XSelectInput( MyDisplay,EnnoWindow,ExposureMask | KeyPressMask );


	p=0;
	for( i=0; i<4; i++ ) {
		FnamWindow[i]=XCreateSimpleWindow( MyDisplay,MainWindow,85,30+(i*23),60,20,1,White,Black );	
		window_tbl[p++]=FnamWindow[i];
		XSelectInput( MyDisplay,FnamWindow[i],ExposureMask | KeyPressMask );
	}
	window_tbl[p++]=ComWindow;
	for( i=0; i<6; i++ ) {
		DtinWindow0[i]=XCreateSimpleWindow( MyDisplay,MainWindow,30,193+(i*23),30,20,1,White,Black );
		window_tbl[p++]=DtinWindow0[i];
		XSelectInput( MyDisplay,DtinWindow0[i],ExposureMask | KeyPressMask );
	}	
	for( i=0; i<3; i++ ) {
		DtinWindow1[i]=XCreateSimpleWindow( MyDisplay,MainWindow,30,375+(i*23),30,20,1,White,Black );
		window_tbl[p]=DtinWindow1[i];
		DtinWindow2[i]=XCreateSimpleWindow( MyDisplay,MainWindow,30,493+(i*23),30,20,1,White,Black );
		window_tbl[p+3]=DtinWindow2[i];
		XSelectInput( MyDisplay,DtinWindow1[i],ExposureMask | KeyPressMask );
		XSelectInput( MyDisplay,DtinWindow2[i],ExposureMask | KeyPressMask );
		p++;
	}
	p+=3;
	for( i=0; i<2; i++ ) {
		DtinWindow3[i]=XCreateSimpleWindow( MyDisplay,MainWindow,30,613+(i*23),30,20,1,White,Black );
		window_tbl[p]=DtinWindow3[i];
		DtinWindow4[i]=XCreateSimpleWindow( MyDisplay,MainWindow,30,733+(i*23),30,20,1,White,Black );
		window_tbl[p+2]=DtinWindow4[i];
		XSelectInput( MyDisplay,DtinWindow3[i],ExposureMask | KeyPressMask );
		XSelectInput( MyDisplay,DtinWindow4[i],ExposureMask | KeyPressMask );
		p++;
	}

	XStoreName( MyDisplay,MainWindow,"ENEMY" );

	size.max_width	= 850;
	size.max_height = 900;
	size.flags = PMaxSize;
	XSetNormalHints( MyDisplay,MainWindow,&size );

	XSetForeground( MyDisplay,GrContext,White );		/* window Foregroundcolor set */
	XSetBackground( MyDisplay,GrContext,Black );		/* window Backgroundcolor set */

	XSetFunction( MyDisplay,GrContext,GXcopy ) ;
	XSetPlaneMask( MyDisplay,GrContext,0xffffffff );

}

/************************************************************************/
/*  Event Main process													*/
/************************************************************************/
EventMain()
{
	register int i,pass,sw;

	winp=0;
	flag=LOOP;
	pass=OFF;

	XSetWindowBorderWidth( MyDisplay,window_tbl[winp],2);
	
	while( flag ) {
	
		XNextEvent( MyDisplay,&event );

		switch ( event.type ) {
			case Expose:
				ExposeEvent();
				break;

			case KeyPress:
				KeyPressEvent();
				break;

			default:
				break;
		}
	}

}

/******************************************************************************/
/*  Key Press Event															  */
/******************************************************************************/
KeyPressEvent()
 {
 	register int res,xp,i;
	char string[10],ens[4];

	EN_LIST *dat_ptr;

	if( XLookupString( &event,string,10,&key,NULL )==1 ); 

	switch( key ) {
		case XK_Down:
		case XK_Return:
		case XK_KP_Enter:
			XSetWindowBorderWidth( MyDisplay,window_tbl[winp],1);
			winp++;
			if( winp==21 ) winp=0;
			XSetWindowBorderWidth( MyDisplay,window_tbl[winp],2);			
			break;

		case XK_Up:
			XSetWindowBorderWidth( MyDisplay,window_tbl[winp],1);
			winp--;
			if( winp<0 ) winp=20;
			XSetWindowBorderWidth( MyDisplay,window_tbl[winp],2);			
			break;

		case XK_BackSpace:
			if( dtpt[winp]!=0 ) { 
				dtpt[winp]--;
				dtbuf[winp][dtpt[winp]]='\0';
				XClearWindow( MyDisplay,window_tbl[winp] );
				XDrawString( MyDisplay,window_tbl[winp],GrContext,8,16,dtbuf[winp],strlen(dtbuf[winp]) );
			}
			break;
		
		case XK_F1:
			AppendData();		
			for( i=0; i<21; i++ ) {
				dtpt[i]=0;
				dtbuf[i][0]='\0';
			}
			for( i=0; i<21; i++ ) XClearWindow( MyDisplay,window_tbl[i] );
			enno++;
			htos( enno,ens,4 );
			XClearWindow( MyDisplay,EnnoWindow );		
			XDrawString( MyDisplay,EnnoWindow,GrContext,5,22,ens,4 );
			
			XSetWindowBorderWidth( MyDisplay,window_tbl[winp],1);
			winp=0;
			XSetWindowBorderWidth( MyDisplay,window_tbl[0],2);

			break;

		case XK_F2:
			dat_ptr=root;
			printf( "%x\n",dat_ptr );
			do {
				printf( "%s\n",dat_ptr->en_name );
				printf( "%s\n",dat_ptr->in_name );
				printf( "%s\n",dat_ptr->mv_name );
				printf( "%s\n",dat_ptr->fl_name );
				printf( "%s\n",dat_ptr->comment );
				printf( "\n" );
				dat_ptr=dat_ptr->next;
				printf( "%x\n",dat_ptr->next );
			} while( (dat_ptr->next)!=NULL );
			break;

		case XK_F4:
			enno++;
			htos( enno,ens,4 );
			XClearWindow( MyDisplay,EnnoWindow );		
			XDrawString( MyDisplay,EnnoWindow,GrContext,5,22,ens,4 );
			break;
			
		case XK_F5:
			if( !enno ) break;
			enno--;
			htos( enno,ens,4 );
			XClearWindow( MyDisplay,EnnoWindow );		
			XDrawString( MyDisplay,EnnoWindow,GrContext,5,22,ens,4 );
			break;

		case XK_Escape:
			flag=END;
			break;

		default :
			res=WordCheck( string[0],winp );
			if( !res ) break;
			res=LengthCheck( dtpt[winp],winp );
			if( !res ) break;
			dtbuf[winp][dtpt[winp]++]=string[0];
			dtbuf[winp][dtpt[winp]]='\0';
			XClearWindow( MyDisplay,window_tbl[winp] );
			res=MaxCheck( dtbuf[winp],winp );
			if( !res ) {
				dtbuf[winp][0]='\0';
				dtpt[winp]=0;
				break;
			}
			xp=8;
			if( (strlen(dtbuf[winp]))==1 && winp>4 ) xp=16;
			XDrawString( MyDisplay,window_tbl[winp],GrContext,xp,16,dtbuf[winp],strlen(dtbuf[winp]) );
			break;
	}
}

/******************************************************************************/
/*  Append Data																  */
/******************************************************************************/
AppendData()
{
	EN_LIST *ptr;

	ptr=(EN_LIST *)AllocData();

	strcpy( ptr->en_name,dtbuf[0] );	
	strcpy( ptr->in_name,dtbuf[1] );	
	strcpy( ptr->mv_name,dtbuf[2] );	
	strcpy( ptr->fl_name,dtbuf[3] );	
	strcpy( ptr->comment,dtbuf[4] );	

	if( root==NULL ) {
		ptr->next=root;
		root=ptr;
	}
	else {
		ptr->next=after_ptr->next;
		after_ptr->next=ptr;
	}
	after_ptr=ptr;


}

/******************************************************************************/
/*  Expose event process													  */
/******************************************************************************/
ExposeEvent()
{
	register int i;	
	char ens[5];

	if( event.xany.window==MainWindow ) {	
		XDrawLine( MyDisplay,MainWindow,GrContext,0,21,850,21 );
		XDrawLine( MyDisplay,MainWindow,GrContext,0,152,850,152 );
	}
	
	if( event.xany.window==Msg1Window ) {
		XDrawString16( MyDisplay,Msg1Window,GrContextK,5,22,msgA,5 );
		XDrawString16( MyDisplay,Msg1Window,GrContextK,5,45,msgB,5 );
		XDrawString16( MyDisplay,Msg1Window,GrContextK,5,68,msgC,5 );
		XDrawString16( MyDisplay,Msg1Window,GrContextK,5,91,msgD,5 );
		XDrawString16( MyDisplay,Msg1Window,GrContextK,5,114,msgE,5 );
	}
	
	if( event.xany.window==Msg2Window ) {
		XDrawString( MyDisplay,Msg2Window,GrContext,2,17,"IN",2 );
		XDrawString( MyDisplay,Msg2Window,GrContext,2,39,"MV",2 );
		XDrawString( MyDisplay,Msg2Window,GrContext,2,60,"FL",2 );
	}

	if( event.xany.window==Msg3Window ) {
		XDrawString16( MyDisplay,Msg3Window,GrContextK,65,18,msga,8 );
		XDrawString16( MyDisplay,Msg3Window,GrContextK,5,49,msg0,29 );
		XDrawString16( MyDisplay,Msg3Window,GrContextK,5,72,msg1,29 );
		XDrawString16( MyDisplay,Msg3Window,GrContextK,5,95,msg2,29 );
		XDrawString16( MyDisplay,Msg3Window,GrContextK,5,118,msg3,29 );
		XDrawString16( MyDisplay,Msg3Window,GrContextK,5,141,msg4,29 );
		XDrawString16( MyDisplay,Msg3Window,GrContextK,5,164,msg5,29 );

		XDrawString16( MyDisplay,Msg3Window,GrContextK,65,205,msgb,8 );
		XDrawString16( MyDisplay,Msg3Window,GrContextK,5,233,msg6,32 );
		XDrawString16( MyDisplay,Msg3Window,GrContextK,5,256,msg7,32 );
		XDrawString16( MyDisplay,Msg3Window,GrContextK,5,279,msg8,32 );	

		XDrawString16( MyDisplay,Msg3Window,GrContextK,65,320,msgc,8 );
		XDrawString16( MyDisplay,Msg3Window,GrContextK,5,349,msg9,31 );
		XDrawString16( MyDisplay,Msg3Window,GrContextK,5,372,msg10,31 );
		XDrawString16( MyDisplay,Msg3Window,GrContextK,5,397,msg11,31 );

		XDrawString16( MyDisplay,Msg3Window,GrContextK,65,440,msgd,8 );
		XDrawString16( MyDisplay,Msg3Window,GrContextK,5,469,msg13,3 );
		XDrawString16( MyDisplay,Msg3Window,GrContextK,5,492,msg12,8 );
		XDrawString16( MyDisplay,Msg3Window,GrContextK,5,511,msg121,45 );

		XDrawString16( MyDisplay,Msg3Window,GrContextK,65,560,msge,8 );
		XDrawString16( MyDisplay,Msg3Window,GrContextK,5,589,msg14,5 );
		XDrawString16( MyDisplay,Msg3Window,GrContextK,5,612,msg15,6 );
	}

	if( event.xany.window==Msg4Window ) {
		XDrawString16( MyDisplay,Msg4Window,GrContextK,5,22,msgF,5 );
	}

	if( event.xany.window==EnnoWindow ) {
		htos( enno,ens,4 );		
		XDrawString( MyDisplay,EnnoWindow,GrContext,5,22,ens,4 );
	}
	
	for( i=0; i<21; i++ ) {
		if( event.xany.window==window_tbl[i] ) {
			XDrawString( MyDisplay,window_tbl[i],GrContext,8,16,dtbuf[i],strlen(dtbuf[i]) );
			break;
		}
	}		

}

/******************************************************************************/
/*  Message data convert													  */
/******************************************************************************/
MsgCnv()
{
	register int i;
	unshort *p,*p1,*p2,*p3,*p4,*p5;
	static unchar stra[20]="dmlncd@O";
	static unchar strb[20]="dmlncd@P";
	static unchar strc[20]="dmlncd@Q";
	static unchar strd[20]="dmc`s@@O";
	static unchar stre[20]="dmc`s@@P";

	static unchar strA[12]="@@OF";
	static unchar strB[12]="hmhsF";
	static unchar strC[12]="lnudF";
	static unchar strD[12]="e`hkF";
	static unchar strE[12]="RgF";
	static unchar strF[12]="GmDF";

	static unchar str0[60]="naiՓ˃TCY@@@iOF`FbNj@@@@@@@@";	/* 29 */
	static unchar str1[60]="Gu邩@@@@iOFȂ@PFj@@@";
	static unchar str2[60]="Hׂ邩@@@@@iOFHׂ@PFHׂȂj";
	static unchar str3[60]="vC[Փ˃`FbNiOF@@@@PFȂj@@@";
	static unchar str4[60]="񂾂@@@iOF@@PFȂj@";
	static unchar str5[60]="G邩@@@iOF@@@PFȂj@";

	static unchar str6[80]="af`FbNTCY@@iOF`FbN@Pb`FP_`FbNj";	/* 32 */
	static unchar str7[80]="af`FbNĂxXs[hNA[iOF@PFj";
	static unchar str8[80]="OFHׂ@PFɓ邾@Q`Fϐgm@@@@@@@@@";	
	
	static unchar str9[80] ="n`lZbg^CviOFPL@PFg@QFZbgj";	/* 31 */
	static unchar str10[80]="͈̓NA[@@@iOF@@@P`FTCYmj@@@@@";
	static unchar str11[80]="naigp@@@i{Pj@@@@@@@@@@@@@@@@@@";

	static unchar str12[80]="n`l̗D揇";										/* 8 */
	static unchar str121[100]="iO`RFvC[̑O@SFvC[Ɠ@T`VFvC[̌@eeF\\j";	/* 45 */
	static unchar str13[80]="J[";															/*  3 */

	static unchar str14[14]="d̓f[^@";														/*  5 */
	static unchar str15[14]="ő嗎x";														/*  6 */

	p =(unshort *)stra;
	p1=(unshort *)strb;
	p2=(unshort *)strc;
	p3=(unshort *)strd;
	p4=(unshort *)stre;
	for( i=0; i<8; i++ ) {
		msga[i].byte1=(sjis2jis(*p)&0xff00)>>8;
		msga[i].byte2=sjis2jis(*p)&0x00ff;
		msgb[i].byte1=(sjis2jis(*p1)&0xff00)>>8;
		msgb[i].byte2=sjis2jis(*p1)&0x00ff;
		msgc[i].byte1=(sjis2jis(*p2)&0xff00)>>8;
		msgc[i].byte2=sjis2jis(*p2)&0x00ff;
		msgd[i].byte1=(sjis2jis(*p3)&0xff00)>>8;
		msgd[i].byte2=sjis2jis(*p3)&0x00ff;
		msge[i].byte1=(sjis2jis(*p4)&0xff00)>>8;
		msge[i].byte2=sjis2jis(*p4)&0x00ff;
		p++;
		p1++;
		p2++;
		p3++;
		p4++;
	}	
	
	p=(unshort *)strA;
	p1=(unshort *)strB;
	p2=(unshort *)strC;
	p3=(unshort *)strD;
	p4=(unshort *)strE;
	p5=(unshort *)strF;
	for( i=0; i<5; i++ ) {
		msgA[i].byte1=(sjis2jis(*p)&0xff00)>>8;
		msgA[i].byte2=sjis2jis(*p)&0x00ff;
		msgB[i].byte1=(sjis2jis(*p1)&0xff00)>>8;
		msgB[i].byte2=sjis2jis(*p1)&0x00ff;
		msgC[i].byte1=(sjis2jis(*p2)&0xff00)>>8;
		msgC[i].byte2=sjis2jis(*p2)&0x00ff;
		msgD[i].byte1=(sjis2jis(*p3)&0xff00)>>8;
		msgD[i].byte2=sjis2jis(*p3)&0x00ff;
		msgE[i].byte1=(sjis2jis(*p4)&0xff00)>>8;
		msgE[i].byte2=sjis2jis(*p4)&0x00ff;
		msgF[i].byte1=(sjis2jis(*p5)&0xff00)>>8;
		msgF[i].byte2=sjis2jis(*p5)&0x00ff;
		p++;
		p1++;
		p2++;
		p3++;
		p4++;
		p5++;
	}	

	p=(unshort *)str0;
	p1=(unshort *)str1;
	p2=(unshort *)str2;
	p3=(unshort *)str3;
	p4=(unshort *)str4;
	p5=(unshort *)str5;
	for( i=0; i<29; i++ ) {
		msg0[i].byte1=(sjis2jis(*p)&0xff00)>>8;
		msg0[i].byte2=sjis2jis(*p)&0x00ff;
		msg1[i].byte1=(sjis2jis(*p1)&0xff00)>>8;
		msg1[i].byte2=sjis2jis(*p1)&0x00ff;
		msg2[i].byte1=(sjis2jis(*p2)&0xff00)>>8;
		msg2[i].byte2=sjis2jis(*p2)&0x00ff;
		msg3[i].byte1=(sjis2jis(*p3)&0xff00)>>8;
		msg3[i].byte2=sjis2jis(*p3)&0x00ff;
		msg4[i].byte1=(sjis2jis(*p4)&0xff00)>>8;
		msg4[i].byte2=sjis2jis(*p4)&0x00ff;
		msg5[i].byte1=(sjis2jis(*p5)&0xff00)>>8;
		msg5[i].byte2=sjis2jis(*p5)&0x00ff;
		p++;
		p1++;
		p2++;
		p3++;
		p4++;
		p5++;
	}	

	p=(unshort *)str6;
	p1=(unshort *)str7;
	p2=(unshort *)str8;
	for( i=0; i<32; i++ ) {
		msg6[i].byte1=(sjis2jis(*p)&0xff00)>>8;
		msg6[i].byte2=sjis2jis(*p)&0x00ff;
		msg7[i].byte1=(sjis2jis(*p1)&0xff00)>>8;
		msg7[i].byte2=sjis2jis(*p1)&0x00ff;
		msg8[i].byte1=(sjis2jis(*p2)&0xff00)>>8;
		msg8[i].byte2=sjis2jis(*p2)&0x00ff;
		p++;
		p1++;
		p2++;
	}	

	p=(unshort *)str9;
	p1=(unshort *)str10;
	p2=(unshort *)str11;
	for( i=0; i<31; i++ ) {
		msg9[i].byte1=(sjis2jis(*p)&0xff00)>>8;
		msg9[i].byte2=sjis2jis(*p)&0x00ff;
		msg10[i].byte1=(sjis2jis(*p1)&0xff00)>>8;
		msg10[i].byte2=sjis2jis(*p1)&0x00ff;
		msg11[i].byte1=(sjis2jis(*p2)&0xff00)>>8;
		msg11[i].byte2=sjis2jis(*p2)&0x00ff;
		p++;
		p1++;
		p2++;
	}	

	p=(unshort *)str12;
	for( i=0; i<8; i++ ) {
		msg12[i].byte1=(sjis2jis(*p)&0xff00)>>8;
		msg12[i].byte2=sjis2jis(*p)&0x00ff;
		p++;
	}	
	p=(unshort *)str121;
	for( i=0; i<45; i++ ) {
		msg121[i].byte1=(sjis2jis(*p)&0xff00)>>8;
		msg121[i].byte2=sjis2jis(*p)&0x00ff;
		p++;
	}	

	p=(unshort *)str13;
	for( i=0; i<3; i++ ) {
		msg13[i].byte1=(sjis2jis(*p)&0xff00)>>8;
		msg13[i].byte2=sjis2jis(*p)&0x00ff;
		p++;
	}	

	p=(unshort *)str14;
	p1=(unshort *)str15;
	for( i=0; i<6; i++ ) {
		msg14[i].byte1=(sjis2jis(*p)&0xff00)>>8;
		msg14[i].byte2=sjis2jis(*p)&0x00ff;
		msg15[i].byte1=(sjis2jis(*p1)&0xff00)>>8;
		msg15[i].byte2=sjis2jis(*p1)&0x00ff;
		p++;
		p1++;
	}	

}

/******************************************************************************/
/*  Word Check																  */
/******************************************************************************/
WordCheck( dat,flg )
char dat;
int flg;
{
	if( flg<5 ) {
		if( !(isalnum(dat)) ) return( 0 );
	}
	else {
		if( !(isxdigit(dat)) ) return( 0 );	 
	}

	return( 1 );
}

/******************************************************************************/
/*  Length Check															  */
/******************************************************************************/
LengthCheck( dat,flg )
int dat,flg;
{
	switch( flg ) {
		case 0:
		case 1:
		case 2:
		case 3:
			if( dat>=5 ) return( 0 ); 
			break;

		case 4:
			if( dat>=85 ) return( 0 );
			break;

		case 5:
		case 11:
		case 16:
		case 18:
		case 19:
		case 20:
			if( dat>=2 ) return( 0 );
			break;

		case 6:
		case 7:
		case 8:
		case 9:
		case 10:
		case 12:
		case 13:
		case 14:
		case 15:
		case 17:
			if( dat>=1 ) return( 0 );
			break;

		default:
			break;

	}

	return( 1 );
}

/******************************************************************************/
/*  Max Check																  */
/******************************************************************************/
MaxCheck( sdat,flg )
char *sdat;
int flg;
{
	int dat;
	
	dat=strtol(sdat, (char **)NULL, 16); 

	switch( flg ) {
		case 5:
		case 11:
		case 16:
			if( dat>0x1f ) return( 0 );
			break;
			
		case 6:
		case 7:
		case 8:
		case 9:
		case 10:
		case 12:
			if( dat>0x01 ) return( 0 );
			break;
			
		case 13:
			if( dat>0x0f ) return( 0 );
			break;

		case 14:
			if( dat>0x03 ) return( 0 );
			break;
			
		case 15:
		case 17:
			if( dat>0x07 ) return( 0 );
			break;
			
		default:
			break;

	}

	return( 1 );
}

/******************************************************************************/
/*  hex to string															  */
/******************************************************************************/
htos( dat,s,fg )
int dat,fg;
char *s;
{
	register int i,mask,wk,st;

	st=(fg-1)*4;
	mask=0x000f<<st;

	for( i=st; i>=0; i-=4 ) {
		wk=(dat&mask)>>i;
		if( wk < 10 ) s[(st/4)-(i/4)]=wk+0x30;
		else	      s[(st/4)-(i/4)]=wk+0x37;
		mask=mask>>4;
	}
	s[(st/4)-(i/4)]='\0';
}

