/****************************************************************
*		l`o|Cgf[^ Ro[g			*
****************************************************************/

#include <stdio.h>

#define unchar  unsigned char
#define unshort unsigned short

typedef struct{
	unchar plstat;		/*** v[[̏ ***/
	unchar play_x;		/*** ړf[^ w ***/
	unchar play_z;		/*** ړf[^ y ***/
	unchar play_y;		/*** ړf[^ x ***/
} play_mv;

typedef struct{
	unchar nxt_dt;		/*** mdws fnsn |Cg ***/
	play_mv play_dt[16];	/*** v[[̈ړf[^ ***/
} qst_dt;

typedef struct{
	unchar map_typ;		/*** }bv ^Cv ***/
	unchar prs_pos;		/*** p[c |C^[ ***/
	unchar cos_dat;		/*** R[X mn. ***/
	unchar tim_dat;		/*** ^C}[ ***/
	unchar pl_xpos;		/*** v[[ wW ***/
	unchar pl_ypos;		/*** v[[ xW ***/
	unchar qst_ps0;
	unchar qst_ps1;
	unchar qst_ps2;
	unchar qst_ps3;
	qst_dt qst_cnt[4];
} mpdt_old;


FILE           *fpr0, *fpr1, *fpw;

void mpptcnv(char *);

void main(int argc, char **argv)
{
	/****** ϐ錾 ******/

	char		ptdt_file[100];

	/****** `FbN ******/
	if (argc != 2) {
		printf("Usage: ys_obtpcnv (ptdt_file)\n");
		exit(1);
	}
	/****** l`o|Cgf[^ t@Cnodm ******/
	strcpy(ptdt_file, argv[1]);
	strcat(ptdt_file, ".pdt");
	if (!(fpr0 = fopen(ptdt_file, "r"))) {
		printf("can't open (%s) !!\n", ptdt_file);
		exit(1);
	}

	/****** l`o|Cgf[^ ϊe[u t@Cnodm ******/
	if (!(fpr1 = fopen("mpptdt.TBL", "r"))) {
		printf("can't open (mpptdt.TBL) !!\n");
		exit(1);
	}

	/****** Ro[gf[^o̓t@Cnodm ******/
	if (!(fpw = fopen("mpptdt.lis", "w"))) {
		printf("can't open (mpptdt.lis) !!\n");
		exit(1);
	}
	/****** l`o|Cgf[^ ϊ ******/
	mpptcnv(ptdt_file);

	/****** t@Cbknrd ******/
	fclose(fpr0);
	fclose(fpr1);
	fclose(fpw);
}

/****************************************************************
*		l`o|Cgf[^ ϊ			*
****************************************************************/
void	mpptcnv(char *ptdt_file)
{
	/****** ϐ錾 ******/
	mpdt_old	old_buf[100];
	mpdt_old	new_buf[100];
	char		nxt_buf[100];
	char		work_tbl[256];
	char		arg0_buf[256];
	char		arg1_buf[256];
	char		arg2_buf[256];
	char		arg3_buf[256];

	short		f_max;

	int		world_no;
	int		i,j,k;

	/*** t@C̃Rs[ ***/
	if(fread( &f_max, sizeof(short), 1, fpr0 ) !=2){
	}
	f_max=(f_max<<8)|(f_max>>8);
	if(fread( old_buf, sizeof(mpdt_old), 100, fpr0 ) !=100){
	}

	/*** t@C̃\[g ***/
	j = 0;
	for( world_no = 0;world_no<8;world_no++ ){
		for( i=0;i<f_max;i++ ){
			if(old_buf[i].map_typ == world_no){
				new_buf[j] = old_buf[i];
				nxt_buf[i] = j++;
			}
		}
		if( j >= f_max){
			world_no = 8;
		}
	}
	/*** mdws fnsn |Cg V ***/
	for( i=0;i<f_max;i++ ){
		for( k=0;k<4;k++ ){
			j = new_buf[i].qst_cnt[k].nxt_dt;
			if( j!=255 ){
			new_buf[i].qst_cnt[k].nxt_dt = nxt_buf[j];
			}
		}
	}

	/****** x Zbg ******/
	fprintf(fpw, ";*****************************************************************\n");
	fprintf(fpw, ";*\t\tmap point status data\t\t\t\t*\n");
	fprintf(fpw, ";*****************************************************************\n");
	fprintf(fpw, ";\n");
	fprintf(fpw, "\t\tGLB\tMPSTATUS\n");
	fprintf(fpw, "MPSTATUS\tEQU\t$\t\t;[Map Point No.]\n");
	fprintf(fpw, ";\n");

	/*** Ro[g!! ***/
	i=j=0;
	while (fgets(work_tbl, 256, fpr1) != NULL ){
		arg0_buf[0]='\0';
		sscanf( work_tbl,"%s %s %s %s",arg0_buf,arg1_buf,arg2_buf,arg3_buf);

		if( strlen( arg0_buf ) && arg0_buf[0] !='#' ){

			if( !( strcmp( arg0_buf,"END" ) ) ){
				break;
			}

			else;
			if( !( strcmp( arg0_buf,"PAS" ) ) ){
				fprintf(fpw, ";-------------- point no.[%02X] -----------------------------------\n",i);
				fprintf(fpw, "MPSTAT_%02X\tEQU\t$\t\t;[%02X]\n",i,i);
			}

			else{
				fprintf(fpw, ";-------------- point no.[%02X] -----------------------------------\n",i);
				fprintf(fpw, "MPSTAT_%02X\tEQU\t$\t\t;[%02X]\n",i,i);
				fprintf(fpw, "\t\tBYTE\t%x\t\t;\t[map type]\n",new_buf[j].map_typ);
				fprintf(fpw, "\t\tBYTE\t%03XH\t\t;\t[  \" parts pointer]\n",new_buf[j].prs_pos);
				fprintf(fpw, "\t\tBYTE\t%s\t;\t[course data table pointer]\n",arg0_buf);
				fprintf(fpw, "\t\tBYTE\t%s\t\t;\t[timer]\n",arg1_buf);
				fprintf(fpw, "\t\tHEX\t%s,%s\t\t;\t[player X,Y_pos]\n",arg2_buf,arg3_buf);
				fprintf(fpw, "\t\tBYTE\tMPCLR_%02X_1-$\t;\t[course clear<1> data pointer]\n",i);
				fprintf(fpw, "MPCLR_%02X_1-$\tEQU\t$\t\t;<1>\n",i);

				if(new_buf[j].qst_cnt[1].nxt_dt != 255){
					fprintf(fpw, "\t\tBYTE\tMPCLR_%02X_2-$\t;\t[course clear<2> data pointer]\n",i);
				}

				if(new_buf[j].qst_cnt[2].nxt_dt != 255){
					fprintf(fpw, "\t\tBYTE\tMPCLR_%02X_3-$\t;\t[course clear<3> data pointer]\n",i);
				}

				if(new_buf[j].qst_cnt[3].nxt_dt != 255){
					fprintf(fpw, "\t\tBYTE\tMPCLR_%02X_4-$\t;\t[course clear<4> data pointer]\n",i);
				}

				fprintf(fpw, "MPCLR_%02X_1-$\tEQU\t$\t\t;<1>\n",i);
				fprintf(fpw, "\t\tBYTE\t%02XH\t\t;\t[go to next point no.]\n"
					,new_buf[j].qst_cnt[0].nxt_dt);
				fprintf(fpw, "\t\tBYTE\t%02XH\t\t;\t[player status]\n"
					,new_buf[j].qst_cnt[0].play_dt[0].plstat);
					for ( k=1;k<16;k++ ){
						if( new_buf[j].qst_cnt[0].play_dt[k].plstat !=128 ){
							fprintf(fpw, "\t\tHEX\t%02XH,%02XH,%02XH\t;\t[   \"   X,Z,Y pos]\n"
								,new_buf[j].qst_cnt[0].play_dt[k].play_x);
								,new_buf[j].qst_cnt[0].play_dt[k].play_z);
								,new_buf[j].qst_cnt[0].play_dt[k].play_y);
						}
					}

				if(new_buf[j].qst_cnt[1].nxt_dt != 255){
					fprintf(fpw, "MPCLR_%02X_2-$\tEQU\t$\t\t;<2>\n",i);
				}

				if(new_buf[j].qst_cnt[2].nxt_dt != 255){
					fprintf(fpw, "MPCLR_%02X_3-$\tEQU\t$\t\t;<3>\n",i);
				}

				if(new_buf[j].qst_cnt[3].nxt_dt != 255){
					fprintf(fpw, "MPCLR_%02X_4-$\tEQU\t$\t\t;<4>\n",i);
				}
			j++;
			}
		i++;
		}
	}

	/****** x Zbg ******/
	fprintf(fpw, ";*****************************************************************\n");
	fprintf(fpw, ";*\t\tmap point status data table\t\t\t*\n");
	fprintf(fpw, ";*****************************************************************\n");
	fprintf(fpw, ";\n");
	fprintf(fpw, "\t\tGLB\tMPSTATBL\n");
	fprintf(fpw, "MPSTATBL\tEQU\t$\t\t\t;[Map Point No.]\n");

#ifdef A
	for( i=0;i<f_max;i++ ){
		fprintf(fpw, "\t\tWORD\tMPSTAT_%02X-MPSTATUS\t;[%02X]\n",i,i);
	}

	fprintf(fpw, "MPSTATBLE\tEQU\t$\n");
	fprintf(fpw, ";\n");
	fprintf(fpw, "\t\tGLB\tNOW_Point\n");
	fprintf(fpw, "NOW_Point\tEQU\t(MPSTATBLE-MPSTATBL)/2\n");
	fprintf(fpw, ";\n");

#endif
}
