/************************************************************************
		     bfwt@CkB

		Copyright (c) 1994.2.9 by Nintendo Co.,ltd.

		      Programmed by K.Ohta

 ************************************************************************/

#include	<stdlib.h>
#include	<stdio.h>
#include	<strings.h>

#define		TEN_KAZU	(128*128*4)	/* k_̐ */


static	unsigned char	data_buff[TEN_KAZU] ;
static	int		data_count, data_index ;


/***********************************************************************
		Prbgf[^ data_buff ɉʂ珇ɏ
		߂lFȂ
***********************************************************************/
void		write_bit( bit )
int		bit ;
{
	data_buff[ data_index ] &= 0xFF >> ( 8 - data_count ) ;

	if ( bit )
	data_buff[ data_index ] |= 1 << data_count ;

	data_count = ++ data_count & 7 ;

	if ( 0 == data_count )	++ data_index ;
}


/***********************************************************************
		lf[^ data_buff ɏ
		߂lFȂ
***********************************************************************/
void		write_number( number )
int		number ;
{
	unsigned int		bit_count = 15, bit_flag = 0x8000 ;

	while ( ( number & bit_flag ) == 0 ) {
		bit_flag >>= 1 ;
		-- bit_count ;
	}

	bit_flag = 0x0001 ;
	while ( bit_count > 0 ) {
		write_bit( 1 ) ;
		write_bit( number & bit_flag ) ;
		bit_flag <<= 1 ;
		-- bit_count ;
	}

	write_bit( 0 ) ;
}


/***********************************************************************
		J[f[^ data_buff ɏ
		߂lFȂ
***********************************************************************/
void		write_color( color )
int		color ;
{
	write_bit( color & 0x02 ) ;
	write_bit( color & 0x01 ) ;
}


/***********************************************************************
		tOf[^ data_buff ɏ
		߂lFȂ
***********************************************************************/
void		write_flag( flag )
int		flag ;
{
	write_bit( flag & 0x01 ) ;
	write_bit( flag & 0x02 ) ;
}


/***********************************************************************
		Pk
		߂lFkf[^̃rbg
***********************************************************************/
int		as_line_0( f, buff, line )
int		f ;
unsigned char	*buff, *line ;
{
	int		c, n, x, i ;
	int		count, color ;

	data_index = data_count = 0 ;
	write_bit( 0 ) ;

	/*****  Ck */
	for ( x = 127 ; x >= 0 ; ) {

		for ( i = x-1, count = 1, color = line[x] ;
			i >= 0 && color == line[i] ;
			-- i, ++ count ) ;

		write_number( count ) ;
		write_color( color ) ;
		x -= count ;
	}

	/*****  vrbg */
	x = ( data_index << 3 ) + data_count ;

	/*****  voCg */
	n = x + 7 >> 3 ;

	/*****  obt@Rs[ */
	for ( i = 0 ; i < n ; ++ i )
		buff[ i ] = data_buff[ i ] ;

	return( x ) ;
}


/***********************************************************************
		Gk
		߂lFkf[^̃rbg
***********************************************************************/
int		as_line_1( f, buff, now_line, old_line )
int		f ;
unsigned char	*buff, *now_line, *old_line ;
{
	int		c, n, x, i ;
	int		old_count, now_count, old_color, now_color ;

	data_index = data_count = 0 ;
	if ( f )  write_bit( 1 ) ;

	/*****  Ck */
	for ( x = 127 ; x >= 0 ; ) {

		/*****  ̋ԃp[^ */
		for ( i = x-1, now_count = 1, now_color = now_line[x] ;
			i >= 0 && now_color == now_line[i] ;
			-- i, ++ now_count ) ;

		/*****  ߋ̋ԃp[^ */
		for ( i = x-1, old_count = 1, old_color = old_line[x] ;
			i >= 0 && old_color == old_line[i] ;
			-- i, ++ old_count ) ;

		/*****  Vԍ쐬 */
		if ( now_color != old_color ) {
			write_number( now_count ) ;
			write_flag( 2 ) ;
			write_color( now_color ) ;
			x -= now_count ;
			continue ;
		}

		/***** Lяk݋ԍ쐬 */
		if ( now_count != old_count ) {
			n = now_count - old_count ;
			if ( n > 0 ) {
				/*****  Lт */
				write_number( n ) ;
				write_flag( 1 ) ;

				/*****  LтɃS}t */
				i = x - now_count ;
				if ( i >= 0 ) {
					c = old_line[ x - old_count ] ;
					old_line[ i ] = c ;
				}
			} else {
				/*****  k񂾋 */
				write_number( -n ) ;
				write_flag( 3 ) ;

				/*****  k񂾐ɃS}t */
				i = x - old_count ;
				if ( i >= 0 ) {
					c = old_line[ i ] ;
				} else {
					c = 0 ;
				}
				old_line[ x - now_count ] = c ;
			}
			x -= now_count ;
			continue ;
		}

		/*****  A铯ԍ쐬 */
		n = 0 ;
		while ( now_color == old_color && now_count == old_count ) {
			++ n ;
			if ( ( x -= now_count ) < 0 )  break ;

			/*****  ̋ԃp[^ */
			for ( i = x-1, now_count = 1, now_color = now_line[x] ;
				i >= 0 && now_color == now_line[i] ;
				-- i, ++ now_count ) ;

			/*****  ߋ̋ԃp[^ */
			for ( i = x-1, old_count = 1, old_color = old_line[x] ;
				i >= 0 && old_color == old_line[i] ;
				-- i, ++ old_count ) ;
		}
		write_number( n ) ;
		write_flag( 0 ) ;
	}

	/*****  vrbg */
	x = ( data_index << 3 ) + data_count ;

	/*****  voCg */
	n = x + 7 >> 3 ;

	/*****  obt@Rs[ */
	for ( i = 0 ; i < n ; ++ i )
		buff[ i ] = data_buff[ i ] ;

	return( x ) ;
}


/***********************************************************************
		f[^t@Cɏo
		߂lFȂ
***********************************************************************/
write_data( buff, bit_su, fp )
unsigned char	*buff ;
int		bit_su ;
FILE		*fp ;
{
	static unsigned char	bit_data=0 ;
	static int		bit_count=0 ;
	unsigned char		flag ;
	int			bit, i, index ;


	if ( bit_su == 0 ) {
		if ( bit_count != 0 )  putc( bit_data, fp ) ;
		bit_data = bit_count = 0 ;
		return ;
	}

	for ( i = 0 ; i < bit_su ; ++ i ) {
		flag = 1 << ( i & 7 ) ;
		index = i >> 3 ;
		bit = buff[ index ] & flag ;

		flag = 1 << bit_count ;
		if ( bit )  bit_data |= flag ;
		bit_count = ++ bit_count & 7 ;
		if ( bit_count == 0 ) {
			putc( bit_data, fp ) ;
			bit_data = 0 ;
		}
	}
}


/***********************************************************************
		kf[^쐬
		߂lFkf[^̃oCg
***********************************************************************/
int		make_ascgx( picture, line_su, fp )
unsigned char	*picture ;
int		line_su ;
FILE		*fp ;
{
	unsigned char	now_line[128], old_line[128] ;
	unsigned char	buff0[512], buff1[512] ;
	int		n0, n1, n, y, bit_su ;


	bit_su = 0 ;

	/*****  ߋ̃C */
	for ( n = 0 ; n < 128 ; ++ n ) {
		now_line[ n ] = 0 ;
	}

	/*****  CɈk */
	for ( y = 0 ; y < line_su ; ++ y ) {

		/*****  VC荞 */
		for ( n = 0 ; n < 128 ; ++ n ) {
			old_line[ n ] = now_line[ n ] ;
			now_line[ n ] = picture[ ( y << 7 ) | n ] ;
		}

		/*****  Ck */
		if ( 1 ) {	/* Cf */
			n0 = as_line_0( 1, buff0, now_line ) ;
			n1 = as_line_1( 1, buff1, now_line, old_line ) ;
			if ( n0 <= n1 ) {
				write_data( buff0, n0, fp ) ;
				bit_su += n0 ;
			} else {
				write_data( buff1, n1, fp ) ;
				bit_su += n1 ;
			}
		} else {
			n1 = as_line_1( 0, buff1, now_line, old_line ) ;
			write_data( buff1, n1, fp ) ;
			bit_su += n1 ;
		}
	}

	write_data( buff0, 0, fp ) ;
	return ( bit_su + 7 >> 3 ) ;
}


/***********************************************************************
		SF̃|Cgf[^𓾂
		߂lFȂ
***********************************************************************/
void		get_picture4( picture, fp )
unsigned char	*picture ;
FILE		*fp ;
{
	unsigned char	chr_data[0x10], flag[8], page0, page1 ;
	int		x, y, n, ni, yi, xi ;

	flag[0] = 0x80 ;
	flag[1] = 0x40 ;
	flag[2] = 0x20 ;
	flag[3] = 0x10 ;
	flag[4] = 0x08 ;
	flag[5] = 0x04 ;
	flag[6] = 0x02 ;
	flag[7] = 0x01 ;

	for ( n = 0 ; n < TEN_KAZU ; ++n ) {
		picture[n] = 0 ;
	}

	for ( n = 0 ; n < TEN_KAZU/64 ; ++n ) {
		ni = (n & 0xFFF0) << 6 | (n & 0x000F) << 3 ;
		if ( fread( chr_data, sizeof(char), 0x10, fp ) != 0x10 )
			for ( y = 0 ; y < 0x10 ; ++y )  chr_data[ y ] = 0 ;

		for ( y = 0 ; y < 8 ; ++y ) {
			yi = ni | y << 7 ;
			page0 = chr_data[ ( y << 1 ) + 00 ] ;
			page1 = chr_data[ ( y << 1 ) + 01 ] ;

			for ( x = 0 ; x < 8 ; ++x ) {
				xi = yi | x ;
				if ( page0 & flag[x] )  picture[ xi ] |= 1 ;
				if ( page1 & flag[x] )  picture[ xi ] |= 2 ;
			}
		}
	}
}


/***********************************************************************
		CvO
***********************************************************************/
main( argc,argv )
int	argc ;
char	**argv ;
{
	unsigned char	in_fname[64], out_fname[64], picture[TEN_KAZU] ;
	FILE		*in_fp, *out_fp ;
	int		m, n, s, id ;
	int		start_n, end_n, step_n ;


	if ( argc < 3 ) {
		printf( "b4Fbfwt@Ck܂B\n") ;
		printf( "bgp@F\n" ) ;
		printf( "b ascgx ̓t@C o̓t@C [Jn(0-63)] [I(0-63)] [(1-16)]\n" ) ;
		printf( "b                                 i16LN^1ƂBj\n" ) ;
		exit( 1 ) ;
	}

	/*****  t@CI[v */
	strcpy( in_fname, *++argv ) ;
	if ( (in_fp = fopen( in_fname, "r" )) == NULL ) {
		perror( in_fname ) ;
		exit( 1 ) ;
	}
	strcpy( out_fname, *++argv ) ;
	if ( (out_fp = fopen( out_fname, "w" )) == NULL ) {
		perror( out_fname ) ;
		exit( 1 ) ;
	}

	/*****  p[^ */
	if ( argc > 3 )	start_n = atoi( *++argv ) ;
	else		start_n = 0 ;

	if ( argc > 4 )	end_n = atoi( *++argv ) ;
	else		end_n = ( TEN_KAZU - 1 ) / 1024 ;

	if ( argc > 5 ) {
		step_n = atoi( *++argv ) ;
	} else {
		if ( ( end_n - start_n + 1 ) >= 16 )  step_n = 16 ;
		else	step_n = end_n - start_n + 1 ;
	}

	if ( ( end_n - start_n + 1 ) % step_n != 0 ) {
		printf( "Warning !! [Jn][I][]Ŋ肫܂B\n" ) ;
	}
	if ( start_n > end_n || step_n < 1 || step_n > 16 ) {
		printf( "p[^ُłB\n" ) ;
		exit( 1 ) ;
	}

	/*****  P_PoCg̃sN`[f[^ɕϊ */
	get_picture4( picture, in_fp ) ;
	fclose( in_fp ) ;

	/*****  kf[^쐬 */
	start_n *= 1024 ;
	step_n *= 1024 ;
	end_n = 1024 * ( end_n + 1 ) ;

	m = s = 0 ;
	for ( id = start_n ; id < end_n ; id += step_n ) {
		n = make_ascgx( picture + id, step_n / 128, out_fp ) ;
		printf("Address%5X hex :%6d byte (%5.1f %% )\n",m,n,400.0*n/step_n ) ;
		m += n ;
		s += step_n ;
	}
	printf("  Total%5X hex :%6d byte (%5.1f %% )\n",m,m,400.0*m/s ) ;

	/*****  I */
	if ( fclose( out_fp ) == EOF ) {
		printf( "Data write error !!\n" ) ;
		exit( 1 ) ;
	}

	exit( 0 ) ;
}


