;************************************************************************
;*									*
;*	title name	: "yossy"					*
;*	proccess	: mario chip program.3				*
;*	file name	: ys_chip2					*
;*									*
;************************************************************************
;
;
		SALL
;
		include		ys_chip.inc
;
		XALL
;
;
;------------------------------------------------------------------------
;-		global symbol						-
;------------------------------------------------------------------------
		GLB	C_16_ROTZOM,C_16_ROTZOM_C
		GLB	C_16_ZOOM,C_16_ZOOM_XY
		GLB	C_16_RTZ_16_XY
		GLB	C_32_ROTZOM,C_32_ROTZOM_C
		GLB	C_32_ZOOM,C_32_ZOOM_XY,C_32_ZOOM_XY_C
		GLB	C_32_ZOOM_16,C_32_ZOOM_XY_16
		GLB	C_32_ROTZOM_16,C_32_ROTZOM_C16
		GLB	C_32_RTZ_16_XY,C_32_RTZ_32_XY
		GLB	C_64_ZOOM_16,C_64_ZOOM_32
		GLB	C_64HZOOM_32
;
;------------------------------------------------------------------------
;-		extern symbol						-
;------------------------------------------------------------------------
;
;-------------< ys_chip0 >-----------------------------------------------
		EXT	COS,SIN,LCOS,LSIN
		EXT	FURA_WAVE_MAP
;
;
;************************************************************************
;*									*
;*		program start						*
;*									*
;************************************************************************
;
;
Group_8		GROUP	S_chip_2
S_chip_2	SECT	REL
;
;
;************************************************************************
;*		TEST							*
;************************************************************************
TEST_01		EQU	$
		STOP
		NOP
;
;************************************************************************
;*		|SEBhE					*
;*			in  : (R1) <-- w]p			*
;*			      (R2) <-- x   h				*
;*			      (R3) <-- y   h				*
;*			      (R4) <-- g嗦				*
;*			      (R5) <-- SQw				*
;*			      (R6) <--	 hQx				*
;************************************************************************
MSWINPOLY	EQU	$
;
;-------------- massage display window set ------------------------------
		IBT	R9,#30H		;(R9) <-- Y wide
		FROM	R6
		TO	R12
		SUB	R9
		IWT	R0,#WINDBF+2	;(R0) <-- H-DMA buffer pointer
		IBT	R7,#4		;(R7) <--	   "           add data
		IWT	R8,#00FFH	;(R8) <-- clear data
;
		CACHE
;
		DEC	R12
		BMI	MSWPL012	;0 line ? ( yes:MSWPL012 )
		INC	R12
;
		MOVE	R13,R15
MSWPL010
		FROM	R8
		STW	(R0)
		LOOP
		ADD	R7
;
MSWPL012	EQU	$
		MOVE	R10,R0		;(R10) <-- H-DMA buffer pointer
		IBT	R0,#50H		;(R0) <-- X wide
		FROM	R5
		TO	R11		;(R11) <-- left X pos
		SUB	R0
		ADD	R5
		DEC	R0		;[ -1 ]
		SWAP			;(R0) <-- right X pos
		TO	R11		;(R11) <-- window set data
		OR	R11
;
		MOVE	R0,R10		;(R0) <-- H-DMA buffer pointer
		IBT	R12,#30H*2
		MOVE	R13,R15
MSWPL020
		FROM	R11
		STW	(R0)
		LOOP
		ADD	R7
;
		MOVE	R10,R0		;(R10) <-- H-DMA buffer pointer
		IWT	R0,#0D2H
		SUB	R6
		TO	R12
		SUB	R9
		MOVE	R0,R10		;(R0) <-- H-DMA buffer pointer
		MOVE	R13,R15
MSWPL030
		FROM	R8
		STW	(R0)
		LOOP
		ADD	R7
;
WINDPOLY	EQU	$
;
;-------------- polygon window set --------------------------------------
		SMS	R4,REG4		;(REG4) <-- zoom size
		SMS	R5,REG5		;(REG5) <-- center X pos
		SMS	R6,REG6		;(REG6) <--    "   Y  "
;
;-------------- cos & sin data read -------------------------------------
		IBT	R0,#BANK LCOS
		ROMB
;
		IWT	R0,#LCOS
		TO	R14
		ADD	R1
		TO	R4		;(R4) <-- X cos data
		GETB
;
		TO	R14
		ADD	R2
		TO	R6		;(R6) <-- Y cos data
		GETB
;
		TO	R14
		ADD	R3
		TO	R8		;(R8) <-- Z cos data
		GETB
;
		IWT	R0,#LSIN
		TO	R14
		ADD	R1
		TO	R5		;(R5) <-- X sin data
		GETB
;
		TO	R14
		ADD	R2
		TO	R7		;(R7) <-- Y sin data
		GETB
;
		TO	R14
		ADD	R3
		TO	R9		;(R9) <-- Z sin data
		GETB
;
;-------------- rotation matrix data calculate --------------------------
		IWT	R14,#080H	;(R14) <-- hosei data
;
		FROM	R5
		MULT	R7
		ADD	R0		;[ ASL ]
		ADD	R0		;[ ASL ]
		ADD	R14
		HIB
		SEX
		MOVE	R10,R0		;(R10) <-- (X sin)*(Y sin)
;
		TO	R1		;(R1) <-- (X sin)*(Y sin)*(Z sin)
		MULT	R9
		FROM	R6
		MULT	R8
		ADD	R1
		ADD	R0		;[ ASL ]
		ADD	R0		;[ ASL ]
		ADD	R14
		HIB
		TO	R1		;(R1) <-- (Y cos)*(Z cos)+(X sin)*(Y sin)*(Z sin)
		SEX
;
		FROM	R6
		TO	R2		;(R2) <-- (Y cos)*(Z sin)
		MULT	R9
		FROM	R10
		MULT	R8
		SUB	R2
		ADD	R0		;[ ASL ]
		ADD	R0		;[ ASL ]
		ADD	R14
		HIB
		TO	R2		;(R2) <-- -(Y cos)*(Z sin)+(X sin)*(Y sin)*(Z cos)
		SEX
;
		FROM	R4
		MULT	R9
		ADD	R0		;[ ASL ]
		ADD	R0		;[ ASL ]
		ADD	R14
		HIB
		TO	R3		;(R3) <-- (X cos)*(Z sin)
		SEX
;
		FROM	R4
		MULT	R8
		ADD	R0		;[ ASL ]
		ADD	R0		;[ ASL ]
		ADD	R14
		HIB
		TO	R10		;(R10) <-- (X cos)*(Z cos)
		SEX
;
		FROM	R5
		MULT	R6
		ADD	R0		;[ ASL ]
		ADD	R0		;[ ASL ]
		ADD	R14
		HIB
		SEX
		MOVE	R4,R0		;(R4) <-- (X sin)*(Y cos)
;
		TO	R5		;(R5) <-- (X sin)*(Y cos)*(Z cos)
		MULT	R8
		FROM	R7
		MULT	R9
		ADD	R5
		ADD	R0		;[ ASL ]
		ADD	R0		;[ ASL ]
		ADD	R14
		HIB
		TO	R5		;(R5) <-- (Y sin)*(Z sin)+(X sin)*(Y cos)*(Z cos)
		SEX
;
		WITH	R7		;(R7) <-- (Y sin)*(Z cos)
		MULT	R8
		FROM	R4
		MULT	R9
		SUB	R7
		ADD	R0		;[ ASL ]
		ADD	R0		;[ ASL ]
		ADD	R14
		HIB
		TO	R7		;(R7) <-- -(Y sin)*(Z cos)+(X sin)*(Y cos)*(Z sin)
		SEX
;
;-------------- position rotation ---------------------------------------
		IBT	R0,#BANK MSWPOLDT
		ROMB
		IWT	R14,#MSWPOLDT	;(R14) <-- polygon data address
		IBT	R11,#CWORK	;(R11) <-- 2D pos set buffer pointer
;
		CACHE
;
		IBT	R12,#(MSWPOLDTE-MSWPOLDT)/2
		MOVE	R13,R15
WPOL010
		GETB			;(R0) <-- X pos
		INC	R14
;
		TO	R9		;(R9) <-- X pos * ((Y cos)*(Z cos)+(X sin)*(Y sin)*(Z sin))
		MULT	R1
;
		TO	R8		;(R8) <-- X pos * ((X cos)*(Z sin))
		MULT	R3
;
		TO	R4		;(R4) <-- X pos * (-(Y sin)*(Z cos)+(X sin)*(Y cos)*(Z sin))
		MULT	R7
;
		GETB
		INC	R14
		MOVE	R6,R0		;(R0)(R6) <-- Y pos
;
		MULT	R2
		ADD	R9		;(R0) <-- X pos * ((Y cos)*(Z cos)+(X sin)*(Y sin)*(Z sin)) + Y pos * (-(Y cos)*(Z sin)+(X sin)*(Y sin)*(Z cos))
		ADD	R0		;[ ASL ]
		TO	R9		;(R9) <-- rotation X pos
		ADD	R0		;[ ASL ]
;
		FROM	R6
		MULT	R10
		ADD	R8		;(R0) <-- X pos * ((X cos)*(Z sin)) + Y pos * ((X cos)*(Z cos))
		ADD	R0		;[ ASL ]
		TO	R8		;(R8) <-- rotation Y pos
		ADD	R0		;[ ASL ]
;
		FROM	R6
		MULT	R5
		ADD	R4		;(R0) <-- X pos * (-(Y sin)*(Z cos)+(X sin)*(Y cos)*(Z sin)) + Y pos * ((Y sin)*(Z sin)+(X sin)*(Y cos)*(Z cos))
		ADD	R0		;[ ASL ]
		ADD	R0		;[ ASL ]
		HIB
		SEX			;(R0) <-- rotation Z pos
;
;-------------- 2D convert ----------------------------------------------
		ADD	R0		;Z pos x2
		IWT	R6,#DIVBUF+(0100H*2)
		ADD	R6
		TO	R6		;(R6) <-- div data
		LDW	(R0)
		LMS	R0,REG4		;(R0) <-- zoom size
		LMULT
		SWAP
		WITH	R4
		HIB
		TO	R6		;(R6) <-- zoom div data
		OR	R4
;
		FROM	R8
		FMULT
		LMS	R8,REG6
		TO	R8		;(R8) <-- 2D Y pos
		ADD	R8
;
		FROM	R9
		FMULT
		LMS	R9,REG5
		ADD	R9
		SWAP
		OR	R8
		STW	(R11)		;2D X pos set
;
		INC	R11
		LOOP
		INC	R11
;
		DEC	R11
		DEC	R11
		SMS	R11,REG12	;(REG12) <-- number of point
;
;-------------- polygon calculate ---------------------------------------
WINDPOLY_SET	EQU	$
;
;-------------- min & max Y pos check ---------------------------
		IBT	R1,#CWORK0	;(R1) <-- 2D pos buffer pointer
		MOVE	R3,R1		;(R3) <-- min 2D pos buffer pointer
		TO	R2		;(R2) <-- min Y pos
		LDB	(R1)
		MOVE	R4,R2		;(R4) <-- max Y pos
		INC	R1
;
		LMS	R0,REG12
		TO	R12
		LSR
		MOVE	R13,R15
WPOL020
		INC	R1
		LDB	(R1)
		SUB	R2
		BPL	WPOL030		;new min Y pos ? ( no:WPOL030 )
		ADD	R2
;
		MOVE	R2,R0		;(R2) <-- new min Y pos
		MOVE	R3,R1		;(R3) <-- new min 2D pos buffer pointer
WPOL030
		SUB	R4
		BMI	WPOL040		;new max Y pos ? ( no:WPOL040 )
		ADD	R4
;
		MOVE	R4,R0		;(R4) <-- new max Y pos
WPOL040
		LOOP
		INC	R1
;
;-------------- H-DMA buffer clear ------------------------------
		IWT	R0,#0D2H
		TO	R12
		SUB	R4
		IWT	R0,#WINDBF+(0D2H-1)*4	;(R0) <-- H-DMA buffer pointer
		IWT	R5,#00FFH	;(R5) <-- clear data
		IBT	R6,#4		;(R6) <-- H-DMA buffer pointer add data
		MOVE	R13,R15
WPOL042
		FROM	R5
		STW	(R0)
		LOOP
		SUB	R6
;
		IWT	R0,#WINDBF	;(R0) <-- H-DMA buffer pointer
		MOVES	R12,R2
		BEQ	WPOL045
		NOP
;
		MOVE	R13,R15
WPOL044
		FROM	R5
		STW	(R0)
		LOOP
		ADD	R6
;
WPOL045
		MOVE	R1,R0		;(R1) <-- polygon window H-DMA buffer pointer
;
;-------------- face display set --------------------------------
		FROM	R4
		TO	R12		;(R12) <-- Y loop no.
		SUB	R2
		BNE	WPOL046+1	;polygon display ? ( yes:WPOL046+1 )
		MOVE	R5,R3		;(R5) <-- right 2D pos buffer pointer
;
;-------------- not display !! --------------------------
		STOP
		NOP
;
WPOL046
		MOVE	R5,R3		;(R5) <-- right 2D pos buffer pointer
		TO	R10		;(R10) <-- left next Y pos
		LDB	(R3)
		MOVE	R11,R10		;(R11) <-- right next Y pos
;
		MOVE	R13,R15
WPOL050
;
;-------------- left pos check --------------------------
		FROM	R2
		SUB	R10
		BCC	WPOL080+1	;next pos change ? ( no:WPOL080+1 )
		WITH	R8		;[ dummy ]
;
WPOL060
		MOVE	R4,R3		;(R4) <-- now pointer
		DEC	R3
		BPL	WPOL070		;pointer max over ? ( no:WPOL070 )
		DEC	R3
;
		LMS	R3,REG12
WPOL070
		LDB	(R3)
		MOVE	R10,R0		;(R10) <-- left next Y pos
		SUB	R2
		BEQ	WPOL060		;= Y pos ? ( yes:WPOL060 )
		INC	R0
;
		ADD	R0		;x2
		IWT	R6,#DIVBUF
		ADD	R6
		LDW	(R0)
		TO	R6		;(R6) <-- (div data)/2
		LSR
		INC	R4
		TO	R8		;(R8) <-- left start X pos
		LDB	(R4)
		INC	R3
		LDB	(R3)
		DEC	R3
		SUB	R8
		ADD	R0		;x2
		LMULT
		LOB
		SWAP
		WITH	R4
		HIB
		TO	R14		;(R14) <-- X pos step
		OR	R4
		WITH	R8		;(R8) <-- left start X pos * 100H
		SWAP
		IWT	R0,#080H
		TO	R8
		ADD	R8
;
WPOL080
		WITH	R8		;(R8) <-- left X pos move
		ADD	R14
;
;-------------- right pos check -------------------------
		FROM	R2
		SUB	R11
		BCC	WPOL110+1	;next pos change ? ( no:WPOL110+1 )
		WITH	R9
;
WPOL090
		MOVE	R4,R5		;(R4) <-- now pointer
		INC	R5
		LMS	R0,REG12
		SUB	R5
		BPL	WPOL100		;pointer max over ? ( no:WPOL100 )
		INC	R5
;
		IBT	R5,#CWORK	;[ IBT R5,#0 ]
WPOL100
		LDB	(R5)
		MOVE	R11,R0		;(R11) <-- right next Y pos
		SUB	R2
		BEQ	WPOL090		;= Y pos ? ( yes:WPOL090 )
		INC	R0
;
		ADD	R0		;x2
		IWT	R6,#DIVBUF
		ADD	R6
		LDW	(R0)
		TO	R6		;(R6) <-- (div data)/2
		LSR
		INC	R4
		TO	R9		;(R9) <-- right start X pos
		LDB	(R4)
		INC	R5
		LDB	(R5)
		DEC	R5
		SUB	R9
		ADD	R0		;x2
		LMULT
		LOB
		SWAP
		WITH	R4
		HIB
		TO	R7		;(R7) <-- X pos step
		OR	R4
		WITH	R9		;(R9) <-- right start X pos * 100H
		SWAP
		IWT	R0,#080H
		TO	R9
		ADD	R9
;
WPOL110
		WITH	R9		;(R9) <-- right X pos move
		ADD	R7
;
;-------------- window data set -------------------------
		FROM	R9
		HIB
		MOVE	R6,R0		;(R6) <-- right X pos
		TO	R4		;(R4) <-- window set data
		SWAP
		FROM	R8
		HIB
		TO	R6
		SUB	R6
		BCC	WPOL120		;"omote" ? ( yes:WPOL120 )
		OR	R4
;
		MOVES	R6,R6
		BNE	WPOL120		;= X pos ? ( no:WPOL120 )
		SWAP
;
		IWT	R0,#00FFH	;clear data set
WPOL120
		STW	(R1)
		WITH	R1
		ADD	#4
		LOOP
		INC	R2		;Y pos inc
;
		STOP
		NOP
;
;------------------------------------------------------------------------
;-		polygon window data					-
;------------------------------------------------------------------------
;;;;MSWPOLDT	    EQU	    $
;;;;;			     X	 Y
;;;;		    HEX	    0B8,020
;;;;		    HEX	    0B9,021
;;;;		    HEX	    0B9,023
;;;;		    HEX	    0BA,024
;;;;		    HEX	    0BB,025
;;;;		    HEX	    0BD,026
;;;;		    HEX	    0BE,027
;;;;		    HEX	    0C0,027
;;;;		    HEX	    040,027
;;;;		    HEX	    042,027
;;;;		    HEX	    043,026
;;;;		    HEX	    045,025
;;;;		    HEX	    046,024
;;;;		    HEX	    047,023
;;;;		    HEX	    047,021
;;;;		    HEX	    048,020
;;;;		    HEX	    048,0E0
;;;;		    HEX	    047,0DF
;;;;		    HEX	    047,0DD
;;;;		    HEX	    046,0DC
;;;;		    HEX	    045,0DB
;;;;		    HEX	    043,0DA
;;;;		    HEX	    042,0D9
;;;;		    HEX	    040,0D9
;;;;		    HEX	    0C0,0D9
;;;;		    HEX	    0BE,0D9
;;;;		    HEX	    0BD,0DA
;;;;		    HEX	    0BB,0DB
;;;;		    HEX	    0BA,0DC
;;;;		    HEX	    0B9,0DD
;;;;		    HEX	    0B9,0DF
;;;;		    HEX	    0B8,0E0
;;;;MSWPOLDTE	    EQU	    $
;
MSWPOLDT	EQU	$
;			 X   Y
		HEX	0B0,030
		HEX	04F,030
		HEX	04F,0D0
		HEX	0B0,0D0
MSWPOLDTE	EQU	$
;
;
;
;
;************************************************************************
;*		LN^[gAkA]iTCY RQ~RQj	*
;*			 F (R2)  <-- rbg}bvWQx		*
;*				(R3)  <--	 h	  Qw		*
;*				(R5)  <-- pxiO`eegj		*
;*				(R6)  <-- {iPOOgPDOj	*
;*				(R12) <-- LN^[AhXikCgj*
;*				(R13) <--	  h	       (aj	*
;************************************************************************
;
C_32_ROTZOM	EQU	$
		IBT	R1,#01H		;(R1) <-- color mode initial set
;
C_32_ROTZOM_C	EQU	$
;
;-------------- LN^[{ϊ ------------------------------------
		IWT	R0,#DIVBUF
		ADD	R6
		ADD	R6
		TO	R6		;(R6) <-- LN^[{
		LDW	(R0)
;
;-------------- LN^[X^[g|C^[vZ ----------------------
		WITH	R5
		ADD	R5
;
		IBT	R0,#BANK COS
		ROMB
		IWT	R0,#COS
		TO	R14
		ADD	R5
		GETB
		INC	R14
		GETBH
		LMULT
		WITH	R4
		HIB
		LOB
		SWAP
		OR	R4
		MOVE	R9,R0		;(R9) <-- cos data
		NOT
		INC	R0
		ADD	R0
		ADD	R0
		ADD	R0
		TO	R11
		ADD	R0
;
		IWT	R0,#SIN
		TO	R14
		ADD	R5
		GETB
		INC	R14
		GETBH
		LMULT
		WITH	R4
		HIB
		LOB
		SWAP
		OR	R4
		MOVE	R4,R0		;(R4) <-- sin data
		NOT
		INC	R0
		ADD	R0
		ADD	R0
		ADD	R0
		ADD	R0
		MOVE	R5,R0
		ADD	R11
		IWT	R6,#010H*100H
		TO	R10		;(R10) <-- SX * cos + SY * sin
		ADD	R6
;
		FROM	R11
		SUB	R5
		TO	R11		;(R11) <-- SY * cos - SX * sin
		ADD	R6
;
;-------------- ݃[h LN^[AhXZbg -------------
		MOVE	R0,R12
		LSR			;(C) <-- color mode
		BCC	C_32_ROTZOM_10	;hight bit color ? ( no:C_32_ROTZOM_10 )
		ADD	R0
;
		WITH	R1
		OR	#04H
C_32_ROTZOM_10
		FROM	R1
		CMODE			;color mode set
		MOVE	R6,R0		;(R6) <-- LN^[AhXikCgjZbg
;
;-------------- LN^[ ------------------------------------
		FROM	R13
		ROMB			;LN^[AhXiajZbg
;
		IWT	R13,#C_32_ROTZOM_30	;(R13) <-- loop return address set
		IBT	R5,#32			;(R5)  <-- Y loop set
;
		CACHE
;
C_32_ROTZOM_20
		MOVE	R1,R3		;(R1) <-- plot start X pos set
		MOVE	R8,R10		;(R8) <-- PX
		MOVE	R7,R11		;(R7) <-- PY
;
		IBT	R12,#32		;X loop set
C_32_ROTZOM_30
		MERGE
		BCS	C_32_ROTZOM_40	;area over ? ( yes:C_32_ROTZOM_40 )
		TO	R14
;
		ADD	R6
;
		WITH	R8
		ADD	R9
		WITH	R7
		SUB	R4
		GETC			;color set
		LOOP
		PLOT			;pset
;
		BRA	C_32_ROTZOM_50+1
		WITH	R10
;
C_32_ROTZOM_40
		WITH	R8
		ADD	R9
		WITH	R7
		SUB	R4
		SUB	R0		;[ IBT	R0,#00 ]
		COLOUR			;color set
		LOOP
		PLOT			;pset
;
C_32_ROTZOM_50
		WITH	R10
		ADD	R4
		WITH	R11
		ADD	R9
		DEC	R5
		BNE	C_32_ROTZOM_20	 ;end ? ( no:C_32_ROTZOM_20 )
		INC	R2		;Y pos +1
;
		RPIX
;
		STOP
		NOP
;
;************************************************************************
;*		LN^[gAkiTCY RQ~RQj		*
;*			 F (R2)  <-- rbg}bvWQx		*
;*				(R3)  <--	 h	  Qw		*
;*				(R6)  <-- {iPOOgPDOj	*
;*				(R8)  <-- SQw			*
;*				(R9)  <--   hQx			*
;*				(R12) <-- LN^[AhXikCgj*
;*				(R13) <--	  h	       (aj	*
;************************************************************************
;
C_32_ZOOM	EQU	$
		MOVE	R11,R6		;(R11) <-- x{Zbg
;
C_32_ZOOM_XY	EQU	$
		IBT	R1,#01H		;(R1) <-- color mode initial set
;
C_32_ZOOM_XY_C	EQU	$
;
;-------------- LN^[{ϊ ------------------------------------
		IWT	R4,#DIVBUF
		FROM	R4
		ADD	R6
		ADD	R6
		TO	R6		;(R6) <-- LN^[{
		LDW	(R0)
;
		FROM	R4
		ADD	R11
		ADD	R11
		TO	R11		;(R11) <-- LN^[{
		LDW	(R0)
;
;-------------- LN^[X^[g|C^[vZ ----------------------
		MOVE	R0,R8
		TO	R10
		SWAP
		NOT
		INC	R0
		LMULT
		WITH	R10		;(R10) <-- SX * x_zoom
		ADD	R4
		MOVE	R5,R6		;(R5) <-- w{
;
		MOVE	R6,R11
		MOVE	R0,R9
		TO	R7
		SWAP
		NOT
		INC	R0
		LMULT
		WITH	R7		;(R7) <-- SY * y_zoom
		ADD	R4
;
;-------------- ݃[h LN^[AhXZbg -------------
		MOVE	R0,R12
		LSR			;(C) <-- color mode
		BCC	C_32_ZOOM_10	;hight bit color ? ( no:C_32_ZOOM_10 )
		ADD	R0
;
		WITH	R1
		OR	#04H
C_32_ZOOM_10
		FROM	R1
		CMODE			;color mode set
		MOVE	R6,R0		;(R6) <-- LN^[AhXikCgjZbg
;
;-------------- LN^[ ------------------------------------
		FROM	R13
		ROMB			;LN^[AhX (ajset
;
		IWT	R13,#C_32_ZOOM_30	;(R13) <-- loop return address set
		IBT	R4,#32			;(R4)  <-- Y loop set
		MOVE	R9,R4			;(R9)  <-- X loop set
;
		CACHE
;
C_32_ZOOM_20
		MOVE	R1,R3		;(R1) <-- plot start X pos set
		MOVE	R8,R10		;(R8) <-- PX
;
		MOVE	R12,R9		;X loop set
C_32_ZOOM_30
		MERGE
		BCS	C_32_ZOOM_40	;area over ? ( yes:C_32_ZOOM_40 )
		TO	R14
;
		ADD	R6
;
		WITH	R8
		ADD	R5
		GETC			;color set
		LOOP
		PLOT			;pset
;
		BRA	C_32_ZOOM_50+1
		WITH	R7
;
C_32_ZOOM_40
		WITH	R8
		ADD	R5
		SUB	R0		;[ IBT	R0,#00 ]
		COLOUR			;color set
		LOOP
		PLOT			;pset
;
C_32_ZOOM_50
		WITH	R7
		ADD	R11
		DEC	R4
		BNE	C_32_ZOOM_20	;end ? ( no:C_32_ZOOM_20 )
		INC	R2		;Y pos +1
;
		RPIX
;
		STOP
		NOP
;
;************************************************************************
;*		LN^[gAkiTCY RQ~RQj		*
;*				      iGA PU~PUj		*
;*			 F (R2)  <-- rbg}bvWQx		*
;*				(R3)  <--	 h	  Qw		*
;*				(R6)  <-- {iPOOgPDOj	*
;*				(R8)  <-- SQw			*
;*				(R9)  <--   hQx			*
;*				(R12) <-- LN^[AhXikCgj*
;*				(R13) <--	  h	       (aj	*
;************************************************************************
;
C_32_ZOOM_16	EQU	$
		MOVE	R11,R6		;(R11) <-- x{Zbg
;
C_32_ZOOM_XY_16 EQU	$
		IBT	R1,#01H		;(R1) <-- color mode initial set
;
;-------------- LN^[{ϊ ------------------------------------
		IWT	R4,#DIVBUF
		FROM	R4
		ADD	R6
		ADD	R6
		TO	R6		;(R6) <-- LN^[{
		LDW	(R0)
;
		FROM	R4
		ADD	R11
		ADD	R11
		TO	R11		;(R11) <-- LN^[{
		LDW	(R0)
;
;-------------- LN^[X^[g|C^[vZ ----------------------
		MOVE	R0,R8
		TO	R10
		SWAP
		ADD	R0		;x2
		NOT
		INC	R0
		LMULT
		WITH	R10		;(R10) <-- SX * x_zoom
		ADD	R4
		MOVE	R5,R6		;(R5) <-- w{
;
		MOVE	R6,R11
		MOVE	R0,R9
		TO	R7
		SWAP
		ADD	R0		;x2
		NOT
		INC	R0
		LMULT
		WITH	R7		;(R7) <-- SY * y_zoom
		ADD	R4
;
;-------------- ݃[h LN^[AhXZbg -------------
		MOVE	R0,R12
		LSR			;(C) <-- color mode
		BCC	C_32_ZOOM_16_10 ;hight bit color ? ( no:C_32_ZOOM_16_10 )
		ADD	R0
;
		WITH	R1
		OR	#04H
C_32_ZOOM_16_10
		FROM	R1
		CMODE			;color mode set
		MOVE	R6,R0		;(R6) <-- LN^[AhXikCgjZbg
;
;-------------- LN^[ ------------------------------------
		FROM	R13
		ROMB			;LN^[AhX (ajset
;
		IWT	R13,#C_32_ZOOM_16_30	;(R13) <-- loop return address set
		IBT	R4,#32			;(R4)  <-- Y loop set
		MOVE	R9,R4			;(R9)  <-- X loop set
;
		CACHE
;
C_32_ZOOM_16_20
		MOVE	R1,R3		;(R1) <-- plot start X pos set
		MOVE	R8,R10		;(R8) <-- PX
;
		MOVE	R12,R9		;X loop set
C_32_ZOOM_16_30
		MERGE
		BEQ	C_32_ZOOM_16_40 ;area over ? ( yes:C_32_ZOOM_16_40 )
		TO	R14
;
		ADD	R6
;
		WITH	R8
		ADD	R5
		GETC			;color set
		LOOP
		PLOT			;pset
;
		BRA	C_32_ZOOM_16_50+1
		WITH	R7
;
C_32_ZOOM_16_40
		WITH	R8
		ADD	R5
		SUB	R0		;[ IBT	R0,#00 ]
		COLOUR			;color set
		LOOP
		PLOT			;pset
;
C_32_ZOOM_16_50
		WITH	R7
		ADD	R11
		DEC	R4
		BNE	C_32_ZOOM_16_20 ;end ? ( no:C_32_ZOOM_16_20 )
		INC	R2		;Y pos +1
;
		RPIX
;
		STOP
		NOP
;
;************************************************************************
;*		LN^[gAkA]iTCY RQ~RQj	*
;*					    iGA PU~PUj	*
;*			 F (R2)  <-- rbg}bvWQx		*
;*				(R3)  <--	 h	  Qw		*
;*				(R5)  <-- pxiO`eegj		*
;*				(R6)  <-- {iPOOgPDOj	*
;*				(R12) <-- LN^[AhXikCgj*
;*				(R13) <--	  h	       (aj	*
;************************************************************************
;
C_32_ROTZOM_16	EQU	$
		IBT	R1,#01H		;(R1) <-- color mode initial set
;
C_32_ROTZOM_C16 EQU	$
;
;-------------- LN^[{ϊ ------------------------------------
		IWT	R0,#DIVBUF
		ADD	R6
		ADD	R6
		TO	R6		;(R6) <-- LN^[{
		LDW	(R0)
;
;-------------- LN^[X^[g|C^[vZ ----------------------
		WITH	R5
		ADD	R5
;
		IBT	R0,#BANK COS
		ROMB
		IWT	R0,#COS
		TO	R14
		ADD	R5
		GETB
		INC	R14
		GETBH
		LMULT
		WITH	R4
		HIB
		LOB
		SWAP
		OR	R4
		MOVE	R9,R0		;(R9) <-- cos data
		NOT
		INC	R0
		ADD	R0
		ADD	R0
		ADD	R0
		TO	R11
		ADD	R0
;
		IWT	R0,#SIN
		TO	R14
		ADD	R5
		GETB
		INC	R14
		GETBH
		LMULT
		WITH	R4
		HIB
		LOB
		SWAP
		OR	R4
		MOVE	R4,R0		;(R4) <-- sin data
		NOT
		INC	R0
		ADD	R0
		ADD	R0
		ADD	R0
		ADD	R0
		MOVE	R5,R0
		ADD	R11
		IWT	R6,#08H*100H
		TO	R10		;(R10) <-- SX * cos + SY * sin
		ADD	R6
;
		FROM	R11
		SUB	R5
		TO	R11		;(R11) <-- SY * cos - SX * sin
		ADD	R6
;
;-------------- ݃[h LN^[AhXZbg -------------
		MOVE	R0,R12
		LSR			;(C) <-- color mode
		BCC	C_32_ROTZOM1610 ;hight bit color ? ( no:C_32_ROTZOM1610 )
		ADD	R0
;
		WITH	R1
		OR	#04H
C_32_ROTZOM1610
		FROM	R1
		CMODE			;color mode set
		MOVE	R6,R0		;(R6) <-- LN^[AhXikCgjZbg
;
;-------------- LN^[ ------------------------------------
		FROM	R13
		ROMB			;LN^[AhXiajZbg
;
		IWT	R13,#C_32_ROTZOM1630	;(R13) <-- loop return address set
		IBT	R5,#32			;(R5)  <-- Y loop set
;
		CACHE
;
C_32_ROTZOM1620
		MOVE	R1,R3		;(R1) <-- plot start X pos set
		MOVE	R8,R10		;(R8) <-- PX
		MOVE	R7,R11		;(R7) <-- PY
;
		IBT	R12,#32		;X loop set
C_32_ROTZOM1630
		MERGE
		BEQ	C_32_ROTZOM1640 ;area over ? ( yes:C_32_ROTZOM1640 )
		TO	R14
;
		ADD	R6
;
		WITH	R8
		ADD	R9
		WITH	R7
		SUB	R4
		GETC			;color set
		LOOP
		PLOT			;pset
;
		BRA	C_32_ROTZOM1650+1
		WITH	R10
;
C_32_ROTZOM1640
		WITH	R8
		ADD	R9
		WITH	R7
		SUB	R4
		SUB	R0		;[ IBT	R0,#00 ]
		COLOUR			;color set
		LOOP
		PLOT
;
C_32_ROTZOM1650
		WITH	R10
		ADD	R4
		WITH	R11
		ADD	R9
		DEC	R5
		BNE	C_32_ROTZOM1620	  ;end ? ( no:C_32_ROTZOM1620 )
		INC	R2		;Y pos +1
;
		RPIX
;
		STOP
		NOP
;
;************************************************************************
;*		LN^[gAkA]iTCY PU~PUj	*
;*		  iwCx{ݒ^Cvj  iGA PU~PUj	*
;*			 F (R2)  <-- rbg}bvWQx		*
;*				(R3)  <--	 h	  Qw		*
;*				(R5)  <-- pxiO`eegj		*
;*				(R6)  <-- w{iPOOgPDOj	*
;*				(R11) <-- x	     h			*
;*				(R12) <-- LN^[AhXikCgj*
;*				(R13) <--	  h	       (aj	*
;************************************************************************
;
C_16_RTZ_16_XY	EQU	$
		IBT	R1,#01H		;(R1) <-- color mode initial set
;
;-------------- LN^[{ϊ ------------------------------------
		IWT	R4,#DIVBUF
		FROM	R4
		ADD	R6
		ADD	R6
		TO	R6		;(R6) <-- LN^[{
		LDW	(R0)
;
		FROM	R4
		ADD	R11
		ADD	R11
		TO	R11		;(R11) <-- LN^[{
		LDW	(R0)
;
C_16_RTZ_C16_XY EQU	$
		WITH	R5
		ADD	R5
;
;-------------- LN^[X^[g|C^[vZ ----------------------
		IBT	R0,#BANK COS
		ROMB
		IWT	R0,#COS
		TO	R14
		ADD	R5
		GETB
		INC	R14
		GETBH
		MOVE	R14,R0
		LMULT
		WITH	R4
		HIB
		LOB
		SWAP
		TO	R9		;(R9) <-- cos * 
		OR	R4
;
		MOVE	R7,R6		;(R7) <-- 
		MOVE	R6,R11
		FROM	R14
		LMULT
		WITH	R4
		HIB
		LOB
		SWAP
		TO	R8		;(R8) <---- cos * 
		OR	R4
		SMS	R8,CWORK0	;(CWK0) <--    "
;
		IWT	R0,#SIN
		TO	R14
		ADD	R5
		GETB
		INC	R14
		GETBH
		MOVE	R14,R0
		LMULT
		WITH	R4
		HIB
		LOB
		SWAP
		OR	R4
		NOT
		INC	R0
		MOVE	R5,R0		;(R5) <--- -sin * 
		ADD	R8		;(R0) <-- cos *  - sin * 
		NOT
		INC	R0
		ADD	R0
		ADD	R0
		ADD	R0
		IWT	R10,#008H*100H	;(R10)	<-- cxy
		TO	R11		;(R11) <-- (xy) * (cos *  - sin * ) + (cxy)
		ADD	R10
;
		MOVE	R6,R7
		FROM	R14
		LMULT
		WITH	R4
		HIB
		LOB
		SWAP
		OR	R4
		SMS	R0,CWORK1	;(CWK1) <-- sin * 
		ADD	R9		;(R0) <-- cos *  + sin * 
		NOT
		INC	R0
		ADD	R0
		ADD	R0
		ADD	R0
		TO	R10		;(R10) <-- (xy) * (cos *  + sin * ) + (cxy)
		ADD	R10
;
;-------------- ݃[h LN^[AhXZbg -------------
		MOVE	R0,R12
		LSR			;(C) <-- color mode
		BCC	C_16_RTZ_XY1610 ;hight bit color ? ( no:C_16_RTZ_XY1610 )
		ADD	R0
;
		WITH	R1
		OR	#04H
C_16_RTZ_XY1610
		FROM	R1
		CMODE			;color mode set
		MOVE	R6,R0		;(R6) <-- LN^[AhXikCgjZbg
;
;-------------- LN^[ ------------------------------------
		FROM	R13
		ROMB			;LN^[AhXiajZbg
;
		IWT	R13,#C_16_RTZ_XY1630	;(R13) <-- loop return address set
		IBT	R4,#16			;(R4)  <-- Y loop set
;
		CACHE
;
C_16_RTZ_XY1620
		MOVE	R1,R3		;(R1) <-- plot start X pos set
		MOVE	R8,R10		;(R8) <-- PX
		MOVE	R7,R11		;(R7) <-- PY
;
		IBT	R12,#16		;X loop set
C_16_RTZ_XY1630
		MERGE
		BEQ	C_16_RTZ_XY1640 ;area over ? ( yes:C_16_RTZ_XY1640 )
		TO	R14
;
		ADD	R6
;
		WITH	R8
		ADD	R9
		WITH	R7
		ADD	R5
		GETC			;color set
		LOOP
		PLOT
;
		BRA	C_16_RTZ_XY1650+1
		LMS	R0,CWORK1	;[ dummy ]
;
C_16_RTZ_XY1640
		WITH	R8
		ADD	R9
		WITH	R7
		ADD	R5
		SUB	R0		;[ IBT	R0,#00 ]
		COLOUR			;color set
		LOOP
		PLOT			;pset
;
C_16_RTZ_XY1650
		LMS	R0,CWORK1	;(R0) <-- sin * 
		TO	R10
		ADD	R10
		LMS	R0,CWORK0	;(R0) <-- cos * 
		TO	R11
		ADD	R11
		DEC	R4
		BNE	C_16_RTZ_XY1620 ;end ? ( no:C_16_RTZ_XY1620 )
		INC	R2		;Y pos +1
;
		RPIX
;
		STOP
		NOP
;
;
;************************************************************************
;*		LN^[gAkA]iTCY RQ~RQj	*
;*		  iwCx{ݒ^Cvj  iGA RQ~RQj	*
;*			 F (R2)  <-- rbg}bvWQx		*
;*				(R3)  <--	 h	  Qw		*
;*				(R5)  <-- pxiO`eegj		*
;*				(R6)  <-- w{iPOOgPDOj	*
;*				(R11) <-- x	     h			*
;*				(R12) <-- LN^[AhXikCgj*
;*				(R13) <--	  h	       (aj	*
;************************************************************************
;
C_32_RTZ_32_XY	EQU	$
		IBT	R1,#01H		;(R1) <-- color mode initial set
;
;-------------- LN^[{ϊ ------------------------------------
		IWT	R4,#DIVBUF
		FROM	R4
		ADD	R6
		ADD	R6
		TO	R6		;(R6) <-- LN^[{
		LDW	(R0)
;
		FROM	R4
		ADD	R11
		ADD	R11
		TO	R11		;(R11) <-- LN^[{
		LDW	(R0)
;
C_32_RTZ_C32_XY EQU	$
		WITH	R5
		ADD	R5
;
;-------------- LN^[X^[g|C^[vZ ----------------------
		IBT	R0,#BANK COS
		ROMB
		IWT	R0,#COS
		TO	R14
		ADD	R5
		GETB
		INC	R14
		GETBH
		MOVE	R14,R0
		LMULT
		WITH	R4
		HIB
		LOB
		SWAP
		TO	R9		;(R9) <-- cos * 
		OR	R4
;
		MOVE	R7,R6		;(R7) <-- 
		MOVE	R6,R11
		FROM	R14
		LMULT
		WITH	R4
		HIB
		LOB
		SWAP
		TO	R8		;(R8) <---- cos * 
		OR	R4
		SMS	R8,CWORK0	;(CWK0) <--    "
;
		IWT	R0,#SIN
		TO	R14
		ADD	R5
		GETB
		INC	R14
		GETBH
		MOVE	R14,R0
		LMULT
		WITH	R4
		HIB
		LOB
		SWAP
		OR	R4
		NOT
		INC	R0
		MOVE	R5,R0		;(R5) <--- -sin * 
		ADD	R8		;(R0) <-- cos *  - sin * 
		NOT
		INC	R0
		ADD	R0
		ADD	R0
		ADD	R0
		ADD	R0
		IWT	R10,#010H*100H	;(R10)	<-- cxy
		TO	R11		;(R11) <-- (xy) * (cos *  - sin * ) + (cxy)
		ADD	R10
;
		MOVE	R6,R7
		FROM	R14
		LMULT
		WITH	R4
		HIB
		LOB
		SWAP
		OR	R4
		SMS	R0,CWORK1	;(CWK1) <-- sin * 
		ADD	R9		;(R0) <-- cos *  + sin * 
		NOT
		INC	R0
		ADD	R0
		ADD	R0
		ADD	R0
		ADD	R0
		TO	R10		;(R10) <-- (xy) * (cos *  + sin * ) + (cxy)
		ADD	R10
;
;-------------- ݃[h LN^[AhXZbg -------------
		MOVE	R0,R12
		LSR			;(C) <-- color mode
		BCC	C_32_RTZ_XY3210 ;hight bit color ? ( no:C_32_RTZ_XY3210 )
		ADD	R0
;
		WITH	R1
		OR	#04H
C_32_RTZ_XY3210
		FROM	R1
		CMODE			;color mode set
		MOVE	R6,R0		;(R6) <-- LN^[AhXikCgjZbg
;
;-------------- LN^[ ------------------------------------
		FROM	R13
		ROMB			;LN^[AhXiajZbg
;
		IWT	R13,#C_32_RTZ_XY3230	;(R13) <-- loop return address set
		IBT	R4,#32			;(R4)  <-- Y loop set
;
		CACHE
;
C_32_RTZ_XY3220
		MOVE	R1,R3		;(R1) <-- plot start X pos set
		MOVE	R8,R10		;(R8) <-- PX
		MOVE	R7,R11		;(R7) <-- PY
;
		IBT	R12,#32		;X loop set
C_32_RTZ_XY3230
		MERGE
		BCS	C_32_RTZ_XY3240 ;area over ? ( yes:C_32_RTZ_XY3240 )
		TO	R14
;
		ADD	R6
;
		WITH	R8
		ADD	R9
		WITH	R7
		ADD	R5
		GETC			;color set
		LOOP
		PLOT
;
		BRA	C_32_RTZ_XY3250+1
		LMS	R0,CWORK1	;[ dummy ]
;
C_32_RTZ_XY3240
		WITH	R8
		ADD	R9
		WITH	R7
		ADD	R5
		SUB	R0		;[ IBT	R0,#00 ]
		COLOUR			;color set
		LOOP
		PLOT			;pset
;
C_32_RTZ_XY3250
		LMS	R0,CWORK1	;(R0) <-- sin * 
		TO	R10
		ADD	R10
		LMS	R0,CWORK0	;(R0) <-- cos * 
		TO	R11
		ADD	R11
		DEC	R4
		BNE	C_32_RTZ_XY3220 ;end ? ( no:C_32_RTZ_XY3220 )
		INC	R2		;Y pos +1
;
		RPIX
;
		STOP
		NOP
;
;
;************************************************************************
;*		LN^[gAkA]iTCY RQ~RQj	*
;*		  iwCx{ݒ^Cvj  iGA PU~PUj	*
;*			 F (R2)  <-- rbg}bvWQx		*
;*				(R3)  <--	 h	  Qw		*
;*				(R5)  <-- pxiO`eegj		*
;*				(R6)  <-- w{iPOOgPDOj	*
;*				(R11) <-- x	     h			*
;*				(R12) <-- LN^[AhXikCgj*
;*				(R13) <--	  h	       (aj	*
;************************************************************************
;
C_32_RTZ_16_XY	EQU	$
		IBT	R1,#01H		;(R1) <-- color mode initial set
;
;-------------- LN^[{ϊ ------------------------------------
		IWT	R4,#DIVBUF
		FROM	R4
		ADD	R6
		ADD	R6
		TO	R6		;(R6) <-- LN^[{
		LDW	(R0)
;
		FROM	R4
		ADD	R11
		ADD	R11
		TO	R11		;(R11) <-- LN^[{
		LDW	(R0)
;
C_32_RTZ_C16_XY EQU	$
;
;-------------- LN^[X^[g|C^[vZ ----------------------
		WITH	R5
		ADD	R5
;
		IBT	R0,#BANK COS
		ROMB
		IWT	R0,#COS
		TO	R14
		ADD	R5
		GETB
		INC	R14
		GETBH
		MOVE	R14,R0
		LMULT
		WITH	R4
		HIB
		LOB
		SWAP
		TO	R9		;(R9) <-- cos * 
		OR	R4
;
		MOVE	R7,R6		;(R7) <-- 
		MOVE	R6,R11
		FROM	R14
		LMULT
		WITH	R4
		HIB
		LOB
		SWAP
		TO	R8		;(R8) <---- cos * 
		OR	R4
		SMS	R8,CWORK0	;(CWK0) <--    "
;
		IWT	R0,#SIN
		TO	R14
		ADD	R5
		GETB
		INC	R14
		GETBH
		MOVE	R14,R0
		LMULT
		WITH	R4
		HIB
		LOB
		SWAP
		OR	R4
		NOT
		INC	R0
		MOVE	R5,R0		;(R5) <--- -sin * 
		ADD	R8		;(R0) <-- cos *  - sin * 
		NOT
		INC	R0
		ADD	R0
		ADD	R0
		ADD	R0
		ADD	R0
		IWT	R10,#08H*100H	;(R10)	<-- cxy
		TO	R11		;(R11) <-- (xy) * (cos *  - sin * ) + (cxy)
		ADD	R10
;
		MOVE	R6,R7
		FROM	R14
		LMULT
		WITH	R4
		HIB
		LOB
		SWAP
		OR	R4
		SMS	R0,CWORK1	;(CWK1) <-- sin * 
		ADD	R9		;(R0) <-- cos *  + sin * 
		NOT
		INC	R0
		ADD	R0
		ADD	R0
		ADD	R0
		ADD	R0
		TO	R10		;(R10) <-- (xy) * (cos *  + sin * ) + (cxy)
		ADD	R10
;
;-------------- ݃[h LN^[AhXZbg -------------
		MOVE	R0,R12
		LSR			;(C) <-- color mode
		BCC	C_32_RTZ_XY1610 ;hight bit color ? ( no:C_32_RTZ_XY1610 )
		ADD	R0
;
		WITH	R1
		OR	#04H
C_32_RTZ_XY1610
		FROM	R1
		CMODE			;color mode set
		MOVE	R6,R0		;(R6) <-- LN^[AhXikCgjZbg
;
;-------------- LN^[ ------------------------------------
		FROM	R13
		ROMB			;LN^[AhXiajZbg
;
		IWT	R13,#C_32_RTZ_XY1630	;(R13) <-- loop return address set
		IBT	R4,#32			;(R4)  <-- Y loop set
;
		CACHE
;
C_32_RTZ_XY1620
		MOVE	R1,R3		;(R1) <-- plot start X pos set
		MOVE	R8,R10		;(R8) <-- PX
		MOVE	R7,R11		;(R7) <-- PY
;
		IBT	R12,#32		;X loop set
C_32_RTZ_XY1630
		MERGE
		BEQ	C_32_RTZ_XY1640 ;area over ? ( yes:C_32_RTZ_XY1640 )
		TO	R14
;
		ADD	R6
;
		WITH	R8
		ADD	R9
		WITH	R7
		ADD	R5
		GETC			;color set
		LOOP
		PLOT
;
		BRA	C_32_RTZ_XY1650+1
		LMS	R0,CWORK1	;[ dummy ]
;
C_32_RTZ_XY1640
		WITH	R8
		ADD	R9
		WITH	R7
		ADD	R5
		SUB	R0		;[ IBT	R0,#00 ]
		COLOUR			;color set
		LOOP
		PLOT			;pset
;
C_32_RTZ_XY1650
		LMS	R0,CWORK1	;(R0) <-- sin * 
		TO	R10
		ADD	R10
		LMS	R0,CWORK0	;(R0) <-- cos * 
		TO	R11
		ADD	R11
		DEC	R4
		BNE	C_32_RTZ_XY1620 ;end ? ( no:C_32_RTZ_XY1620 )
		INC	R2		;Y pos +1
;
		RPIX
;
		STOP
		NOP
;
;************************************************************************
;*		LN^[gAkiTCY PU~PUj		*
;*			 F (R2)  <-- rbg}bvWQx		*
;*				(R3)  <--	 h	  Qw		*
;*				(R6)  <-- {iPOOgPDOj	*
;*				(R8)  <-- SQw			*
;*				(R9)  <--   hQx			*
;*				(R12) <-- LN^[AhXikCgj*
;*				(R13) <--	  h	       (aj	*
;************************************************************************
;
C_16_ZOOM	EQU	$
		MOVE	R11,R6		;(R11) <-- x{Zbg
;
C_16_ZOOM_XY	EQU	$
		IBT	R1,#01H		;(R1) <-- color mode initial set
;
;-------------- LN^[{ϊ ------------------------------------
		IWT	R4,#DIVBUF
		FROM	R4
		ADD	R6
		ADD	R6
		TO	R6		;(R6) <-- LN^[{
		LDW	(R0)
;
		FROM	R4
		ADD	R11
		ADD	R11
		TO	R11		;(R11) <-- LN^[{
		LDW	(R0)
;
;-------------- LN^[X^[g|C^[vZ ----------------------
		MOVE	R0,R8
		TO	R10
		SWAP
		NOT
		INC	R0
		LMULT
		WITH	R10		;(R10) <-- SX * x_zoom
		ADD	R4
		MOVE	R5,R6		;(R5) <-- w{
;
		MOVE	R6,R11
		MOVE	R0,R9
		TO	R7
		SWAP
		NOT
		INC	R0
		LMULT
		WITH	R7		;(R7) <-- SY * y_zoom
		ADD	R4
;
;-------------- ݃[h LN^[AhXZbg -------------
		MOVE	R0,R12
		LSR			;(C) <-- color mode
		BCC	C_16_ZOOM_10	;hight bit color ? ( no:C_16_ZOOM_10 )
		ADD	R0
;
		WITH	R1
		OR	#04H
C_16_ZOOM_10
		FROM	R1
		CMODE			;color mode set
		MOVE	R6,R0		;(R6) <-- LN^[AhXikCgjZbg
;
;-------------- LN^[ ------------------------------------
		FROM	R13
		ROMB			;LN^[AhX (ajset
;
		IWT	R13,#C_16_ZOOM_30	;(R13) <-- loop return address set
		IBT	R4,#16			;(R4)  <-- Y loop set
		MOVE	R9,R4			;(R9)  <-- X loop set
;
		CACHE
;
C_16_ZOOM_20
		MOVE	R1,R3		;(R1) <-- plot start X pos set
		MOVE	R8,R10		;(R8) <-- PX
;
		MOVE	R12,R9		;X loop set
C_16_ZOOM_30
		MERGE
		BEQ	C_16_ZOOM_40	;area over ? ( yes:C_16_ZOOM_40 )
		TO	R14
;
		ADD	R6
;
		WITH	R8
		ADD	R5
		GETC			;color set
		LOOP
		PLOT			;pset
;
		BRA	C_16_ZOOM_50+1
		WITH	R7
;
C_16_ZOOM_40
		WITH	R8
		ADD	R5
		SUB	R0		;[ IBT	R0,#00 ]
		COLOUR			;color set
		LOOP
		PLOT			;pset
;
C_16_ZOOM_50
		WITH	R7
		ADD	R11
		DEC	R4
		BNE	C_16_ZOOM_20	;end ? ( no:C_16_ZOOM_20 )
		INC	R2		;Y pos +1
;
		RPIX
;
		STOP
		NOP
;
;************************************************************************
;*		LN^[gAkA]iTCY PU~PUj	*
;*			 F (R2)  <-- rbg}bvWQx		*
;*				(R3)  <--	 h	  Qw		*
;*				(R5)  <-- pxiO`eegj		*
;*				(R6)  <-- {iPOOgPDOj	*
;*				(R12) <-- LN^[AhXikCgj*
;*				(R13) <--	  h	       (aj	*
;************************************************************************
;
C_16_ROTZOM	EQU	$
		IBT	R1,#01H		;(R1) <-- color mode initial set
;
C_16_ROTZOM_C	EQU	$
;
;-------------- LN^[{ϊ ------------------------------------
		IWT	R0,#DIVBUF
		ADD	R6
		ADD	R6
		TO	R6		;(R6) <-- LN^[{
		LDW	(R0)
;
;-------------- LN^[X^[g|C^[vZ ----------------------
		WITH	R5
		ADD	R5
;
		IBT	R0,#BANK COS
		ROMB
		IWT	R0,#COS
		TO	R14
		ADD	R5
		GETB
		INC	R14
		GETBH
		LMULT
		WITH	R4
		HIB
		LOB
		SWAP
		OR	R4
		MOVE	R9,R0		;(R9) <-- cos data
		NOT
		INC	R0
		ADD	R0
		ADD	R0
		TO	R11
		ADD	R0
;
		IWT	R0,#SIN
		TO	R14
		ADD	R5
		GETB
		INC	R14
		GETBH
		LMULT
		WITH	R4
		HIB
		LOB
		SWAP
		OR	R4
		MOVE	R4,R0		;(R4) <-- sin data
		NOT
		INC	R0
		ADD	R0
		ADD	R0
		ADD	R0
		MOVE	R5,R0
		ADD	R11
		IWT	R6,#08H*100H
		TO	R10		;(R10) <-- SX * cos + SY * sin
		ADD	R6
;
		FROM	R11
		SUB	R5
		TO	R11		;(R11) <-- SY * cos - SX * sin
		ADD	R6
;
;-------------- ݃[h LN^[AhXZbg -------------
		MOVE	R0,R12
		LSR			;(C) <-- color mode
		BCC	C_16_ROTZOM_10	;hight bit color ? ( no:C_16_ROTZOM_10 )
		ADD	R0
;
		WITH	R1
		OR	#04H
C_16_ROTZOM_10
		FROM	R1
		CMODE			;color mode set
		MOVE	R6,R0		;(R6) <-- LN^[AhXikCgjZbg
;
;-------------- LN^[ ------------------------------------
		FROM	R13
		ROMB			;LN^[AhXiajZbg
;
		IWT	R13,#C_16_ROTZOM_30	;(R13) <-- loop return address set
		IBT	R5,#16			;(R5)  <-- Y loop set
;
		CACHE
;
C_16_ROTZOM_20
		MOVE	R1,R3		;(R1) <-- plot start X pos set
		MOVE	R8,R10		;(R8) <-- PX
		MOVE	R7,R11		;(R7) <-- PY
;
		IBT	R12,#16		;X loop set
C_16_ROTZOM_30
		MERGE
		BEQ	C_16_ROTZOM_40	;area over ? ( yes:C_16_ROTZOM_40 )
		TO	R14
;
		ADD	R6
;
		WITH	R8
		ADD	R9
		WITH	R7
		SUB	R4
		GETC			;color set
		LOOP
		PLOT			;pset
;
		BRA	C_16_ROTZOM_50+1
		WITH	R10
;
C_16_ROTZOM_40
		WITH	R8
		ADD	R9
		WITH	R7
		SUB	R4
		SUB	R0		;[ IBT	R0,#00 ]
		COLOUR			;color set
		LOOP
		PLOT			;pset
;
C_16_ROTZOM_50
		WITH	R10
		ADD	R4
		WITH	R11
		ADD	R9
		DEC	R5
		BNE	C_16_ROTZOM_20	 ;end ? ( no:C_16_ROTZOM_20 )
		INC	R2		;Y pos +1
;
		RPIX
;
		STOP
		NOP
;
;************************************************************************
;*		LN^[gAkiTCY US~USj		*
;*				      iGA RQ~RQj		*
;*			 F (R2)  <-- rbg}bvWQx		*
;*				(R3)  <--	 h	  Qw		*
;*				(R6)  <-- {iPOOgPDOj	*
;*				(R8)  <-- SQw			*
;*				(R9)  <--   hQx			*
;*				(R12) <-- LN^[AhXikCgj*
;*				(R13) <--	  h	       (aj	*
;************************************************************************
;
C_64_ZOOM_32	EQU	$
		MOVE	R11,R6		;(R11) <-- x{Zbg
;
C_64_ZOOM_XY_32 EQU	$
		IBT	R1,#01H		;(R1) <-- color mode initial set
;
;-------------- LN^[{ϊ ------------------------------------
		IWT	R4,#DIVBUF
		FROM	R4
		ADD	R6
		ADD	R6
		TO	R6		;(R6) <-- LN^[{
		LDW	(R0)
;
		FROM	R4
		ADD	R11
		ADD	R11
		TO	R11		;(R11) <-- LN^[{
		LDW	(R0)
;
;-------------- LN^[X^[g|C^[vZ ----------------------
		MOVE	R0,R8
		TO	R10
		SWAP
		ADD	R0		;x2
		NOT
		INC	R0
		LMULT
		WITH	R10		;(R10) <-- SX * x_zoom
		ADD	R4
		MOVE	R5,R6		;(R5) <-- w{
;
		MOVE	R6,R11
		MOVE	R0,R9
		TO	R7
		SWAP
		ADD	R0		;x2
		NOT
		INC	R0
		LMULT
		WITH	R7		;(R7) <-- SY * y_zoom
		ADD	R4
;
;-------------- ݃[h LN^[AhXZbg -------------
		MOVE	R0,R12
		LSR			;(C) <-- color mode
		BCC	C_64_ZOOM_32_10 ;hight bit color ? ( no:C_64_ZOOM_32_10 )
		ADD	R0
;
		WITH	R1
		OR	#04H
C_64_ZOOM_32_10
		FROM	R1
		CMODE			;color mode set
		MOVE	R6,R0		;(R6) <-- LN^[AhXikCgjZbg
;
;-------------- LN^[ ------------------------------------
		FROM	R13
		ROMB			;LN^[AhX (ajset
;
		IWT	R13,#C_64_ZOOM_32_30	;(R13) <-- loop return address set
;;;;		    IBT	    R9,#64		    ;(R9)  <-- X loop set
		IBT	R9,#32			;(R9)  <-- X loop set
;
		CACHE
;
		IBT	R4,#32		;(R4)  <-- Y loop set
C_64_ZOOM_32_20
		MOVE	R1,R3		;(R1) <-- plot start X pos set
		MOVE	R8,R10		;(R8) <-- PX
;
		MOVE	R12,R9		;X loop set
C_64_ZOOM_32_30
		MERGE
		BCS	C_64_ZOOM_32_40 ;area over ? ( yes:C_64_ZOOM_32_40 )
		TO	R14
;
		ADD	R6
;
		WITH	R8
		ADD	R5
		GETC			;color set
		LOOP
		PLOT
;
		BRA	C_64_ZOOM_32_60+1
		WITH	R7		;[ dummy ]
;
C_64_ZOOM_32_40
		WITH	R8
		ADD	R5
		SUB	R0		;[ IBT	R0,#00 ]
		COLOUR			;color set
C_64_ZOOM_32_50
		LOOP
		PLOT			;pset
;
C_64_ZOOM_32_60
		WITH	R7
		ADD	R11
;
		DEC	R4
		BNE	C_64_ZOOM_32_20 ;end ? ( no:C_64_ZOOM_32_20 )
		INC	R2		;Y pos +1
;
		FROM	R9		;[ IBT R4,#32 ]
		TO	R4
		LSR
		WITH	R2
		SUB	R4
		WITH	R3
		ADD	R9
		FROM	R3
		SWAP			;[ CMP #80H ]
		BPL	C_64_ZOOM_32_20+1
		MOVE	R1,R3		;[ dummy ]
;
		RPIX
;
		STOP
		NOP
;
;************************************************************************
;*		LN^[gAkA]iTCY US~USj	*
;*					    iGA RQ~RQj	*
;*			 F (R2)  <-- rbg}bvWQx		*
;*				(R3)  <--	 h	  Qw		*
;*				(R5)  <-- pxiO`eegj		*
;*				(R6)  <-- {iPOOgPDOj	*
;*				(R12) <-- LN^[AhXikCgj*
;*				(R13) <--	  h	       (aj	*
;************************************************************************
;
C_64_ROTZOM_32	EQU	$
		IBT	R1,#01H		;(R1) <-- color mode initial set
;
C_64_ROTZOM_C32 EQU	$
;
;-------------- LN^[{ϊ ------------------------------------
		IWT	R0,#DIVBUF
		ADD	R6
		ADD	R6
		TO	R6		;(R6) <-- LN^[{
		LDW	(R0)
;
;-------------- LN^[X^[g|C^[vZ ----------------------
		WITH	R5
		ADD	R5
;
		IBT	R0,#BANK COS
		ROMB
		IWT	R0,#COS
		TO	R14
		ADD	R5
		GETB
		INC	R14
		GETBH
		LMULT
		WITH	R4
		HIB
		LOB
		SWAP
		OR	R4
		MOVE	R9,R0		;(R9) <-- cos data
		NOT
		INC	R0
		ADD	R0
		ADD	R0
		ADD	R0
		ADD	R0
		TO	R11
		ADD	R0
;
		IWT	R0,#SIN
		TO	R14
		ADD	R5
		GETB
		INC	R14
		GETBH
		LMULT
		WITH	R4
		HIB
		LOB
		SWAP
		OR	R4
		MOVE	R4,R0		;(R4) <-- sin data
		NOT
		INC	R0
		ADD	R0
		ADD	R0
		ADD	R0
		ADD	R0
		ADD	R0
		MOVE	R5,R0
		ADD	R11
		IWT	R6,#10H*100H
		TO	R10		;(R10) <-- SX * cos + SY * sin
		ADD	R6
;
		FROM	R11
		SUB	R5
		TO	R11		;(R11) <-- SY * cos - SX * sin
		ADD	R6
;
;-------------- ݃[h LN^[AhXZbg -------------
		MOVE	R0,R12
		LSR			;(C) <-- color mode
		BCC	C_64_ROTZOM3210 ;hight bit color ? ( no:C_64_ROTZOM3210 )
		ADD	R0
;
		WITH	R1
		OR	#04H
C_64_ROTZOM3210
		FROM	R1
		CMODE			;color mode set
		MOVE	R6,R0		;(R6) <-- LN^[AhXikCgjZbg
;
;-------------- LN^[ ------------------------------------
		FROM	R13
		ROMB			;LN^[AhXiajZbg
;
		IWT	R13,#C_64_ROTZOM3230	;(R13) <-- loop return address set
;
		CACHE
;
		IBT	R5,#32		;(R5)  <-- Y loop set
C_64_ROTZOM3220
		MOVE	R1,R3		;(R1) <-- plot start X pos set
		MOVE	R8,R10		;(R8) <-- PX
		MOVE	R7,R11		;(R7) <-- PY
;
		IBT	R12,#64		;X loop set
C_64_ROTZOM3230
		MERGE
		BCS	C_64_ROTZOM3240 ;area over ? ( yes:C_64_ROTZOM3240 )
		TO	R14
;
		ADD	R6
;
		WITH	R8
		ADD	R9
		WITH	R7
		SUB	R4
		GETC			;color set
		LOOP
		PLOT			;pset
;
		BRA	C_64_ROTZOM3260+1
		WITH	R10		;[ dummy]
;
C_64_ROTZOM3240
		WITH	R8
		ADD	R9
		WITH	R7
		SUB	R4
		SUB	R0		;[ IBT	R0,#00 ]
		COLOUR			;color set
C_64_ROTZOM3250
		LOOP
		PLOT			;pset
;
C_64_ROTZOM3260
		WITH	R10
		ADD	R4
		WITH	R11
		ADD	R9
;
		DEC	R5
		BNE	C_64_ROTZOM3220 ;end ? ( no:C_64_ROTZOM3220 )
		INC	R2		;Y pos +1
;
		IBT	R5,#32
		WITH	R2
		SUB	R5
		FROM	R5
		ADD	R5
		ADD	R3
		MOVE	R3,R0
		SWAP			;[ CMP #80H ]
		BPL	C_64_ROTZOM3220+1
		MOVE	R1,R3		;[ dummy ]
;
		RPIX
;
		STOP
		NOP
;
;************************************************************************
;*		LN^[gAkA]iTCY US~USj	*
;*					    iGA US~USj	*
;*					    iRQ̂݁j		*
;*			 F (R2)  <-- rbg}bvWQx		*
;*				(R3)  <--	 h	  Qw		*
;*				(R5)  <-- pxiO`eegj		*
;*				(R6)  <-- {iPOOgPDOj	*
;*				(R12) <-- LN^[AhXikCgj*
;*				(R13) <--	  h	       (aj	*
;************************************************************************
;
C_64_ROTZOM_V64 EQU	$
		IBT	R1,#01H		;(R1) <-- color mode initial set
;
;-------------- LN^[{ϊ ------------------------------------
		IWT	R0,#DIVBUF
		ADD	R6
		ADD	R6
		TO	R6		;(R6) <-- LN^[{
		LDW	(R0)
;
;-------------- LN^[X^[g|C^[vZ ----------------------
		WITH	R5
		ADD	R5
;
		IBT	R0,#BANK COS
		ROMB
		IWT	R0,#COS
		TO	R14
		ADD	R5
		GETB
		INC	R14
		GETBH
		LMULT
		WITH	R4
		HIB
		LOB
		SWAP
		OR	R4
		MOVE	R9,R0		;(R9) <-- cos data
		NOT
		INC	R0
		ADD	R0		;x32
		ADD	R0
		ADD	R0
		ADD	R0
		TO	R11
		ADD	R0
;
		IWT	R0,#SIN
		TO	R14
		ADD	R5
		GETB
		INC	R14
		GETBH
		LMULT
		WITH	R4
		HIB
		LOB
		SWAP
		OR	R4
		MOVE	R4,R0		;(R4) <-- sin data
		NOT
		INC	R0
		ADD	R0		;x32
		ADD	R0
		ADD	R0
		ADD	R0
		ADD	R0
		MOVE	R5,R0
		ADD	R11
		IWT	R6,#20H*100H
		TO	R10		;(R10) <-- SX * cos + SY * sin
		ADD	R6
;
		FROM	R11
		SUB	R5
		TO	R11		;(R11) <-- SY * cos - SX * sin
		ADD	R6
;
;-------------- ݃[h LN^[AhXZbg -------------
		MOVE	R0,R12
		LSR			;(C) <-- color mode
		BCC	C_64_ROTZMV6410 ;hight bit color ? ( no:C_64_ROTZMV6410 )
		ADD	R0
;
		WITH	R1
		OR	#04H
C_64_ROTZMV6410
		FROM	R1
		CMODE			;color mode set
		MOVE	R6,R0		;(R6) <-- LN^[AhXikCgjZbg
;
;-------------- LN^[ ------------------------------------
		FROM	R13
		ROMB			;LN^[AhXiajZbg
;
		IWT	R13,#C_64_ROTZMV6430	;(R13) <-- loop return address set
;
		CACHE
;
		IBT	R5,#32		;(R5)  <-- Y loop set
C_64_ROTZMV6420
		MOVE	R1,R3		;(R1) <-- plot start X pos set
		MOVE	R8,R10		;(R8) <-- PX
		MOVE	R7,R11		;(R7) <-- PY
;
		IBT	R12,#64		;X loop set
C_64_ROTZMV6430
		MERGE
		BVS	C_64_ROTZMV6440 ;area over ? ( yes:C_64_ROTZMV6440 )
		TO	R14
;
		ADD	R6
;
		WITH	R8
		ADD	R9
		WITH	R7
		SUB	R4
		GETC			;color set
		LOOP
		PLOT			;pset
;
		BRA	C_64_ROTZMV6460+1
		WITH	R10		;[ dummy]
;
C_64_ROTZMV6440
		WITH	R8
		ADD	R9
		WITH	R7
		SUB	R4
		SUB	R0		;[ IBT	R0,#00 ]
		COLOUR			;color set
C_64_ROTZMV6450
		LOOP
		PLOT			;pset
;
C_64_ROTZMV6460
		WITH	R10
		ADD	R4
		WITH	R11
		ADD	R9
;
		DEC	R5
		BNE	C_64_ROTZMV6420 ;end ? ( no:C_64_ROTZMV6420 )
		INC	R2		;Y pos +1
;
		RPIX
;
		STOP
		NOP
;
;************************************************************************
;*		LN^[gAkA]iTCY PQW~PQWj	*
;*					    iGA RQ~RQj	*
;*			 F (R2)  <-- rbg}bvWQx		*
;*				(R3)  <--	 h	  Qw		*
;*				(R5)  <-- pxiO`eegj		*
;*				(R6)  <-- {iPOOgPDOj	*
;*				(R12) <-- LN^[AhXikCgj*
;*				(R13) <--	  h	       (aj	*
;************************************************************************
;
C_128_ROTZOM_32 EQU	$
		IBT	R1,#01H		;(R1) <-- color mode initial set
;
C_128_ROTZM_C32 EQU	$
;
;;;;;-------------- LN^[{ϊ ------------------------------------
;;;;		    IWT	    R0,#DIVBUF
;;;;		    ADD	    R6
;;;;		    ADD	    R6
;;;;		    TO	    R6		    ;(R6) <-- LN^[{
;;;;		    LDW	    (R0)
;
;-------------- LN^[X^[g|C^[vZ ----------------------
		WITH	R5
		ADD	R5
;
		IBT	R0,#BANK COS
		ROMB
		IWT	R0,#COS
		TO	R14
		ADD	R5
		GETB
		INC	R14
		GETBH
		LMULT
		WITH	R4
		HIB
		LOB
		SWAP
		OR	R4
		MOVE	R9,R0		;(R9) <-- cos data
		NOT
		INC	R0
		ADD	R0
		ADD	R0
		ADD	R0
		ADD	R0
		ADD	R0
		TO	R11
		ADD	R0
;
		IWT	R0,#SIN
		TO	R14
		ADD	R5
		GETB
		INC	R14
		GETBH
		LMULT
		WITH	R4
		HIB
		LOB
		SWAP
		OR	R4
		MOVE	R4,R0		;(R4) <-- sin data
		NOT
		INC	R0
		ADD	R0
		ADD	R0
		ADD	R0
		ADD	R0
		ADD	R0
		ADD	R0
		MOVE	R5,R0
		ADD	R11
		IWT	R6,#10H*100H
		TO	R10		;(R10) <-- SX * cos + SY * sin
		ADD	R6
;
		FROM	R11
		SUB	R5
		TO	R11		;(R11) <-- SY * cos - SX * sin
		ADD	R6
;
;-------------- ݃[h LN^[AhXZbg -------------
		MOVE	R0,R12
		LSR			;(C) <-- color mode
		BCC	C_128_ROTZM3210 ;hight bit color ? ( no:C_128_ROTZM3210 )
		ADD	R0
;
		WITH	R1
		OR	#04H
C_128_ROTZM3210
		FROM	R1
		CMODE			;color mode set
		MOVE	R6,R0		;(R6) <-- LN^[AhXikCgjZbg
;
;-------------- LN^[ ------------------------------------
		FROM	R13
		ROMB			;LN^[AhXiajZbg
;
		IWT	R13,#C_128_ROTZM3230	;(R13) <-- loop return address set
;
		CACHE
;
		IBT	R5,#32		;(R5)  <-- Y loop set
C_128_ROTZM3220
		MOVE	R1,R3		;(R1) <-- plot start X pos set
		MOVE	R8,R10		;(R8) <-- PX
		MOVE	R7,R11		;(R7) <-- PY
;
		IBT	R12,#64		;X loop set
C_128_ROTZM3230
		MERGE
		BCS	C_128_ROTZM3240 ;area over ? ( yes:C_128_ROTZM3240 )
		TO	R14
;
		ADD	R6
;
		WITH	R8
		ADD	R9
		WITH	R7
		SUB	R4
		GETC			;color set
		LOOP
		PLOT			;pset
;
		BRA	C_128_ROTZM3260+1
		WITH	R10		;[ dummy]
;
C_128_ROTZM3240
		WITH	R8
		ADD	R9
		WITH	R7
		SUB	R4
		SUB	R0		;[ IBT	R0,#00 ]
		COLOUR			;color set
C_128_ROTZM3250
		LOOP
		PLOT			;pset
;
C_128_ROTZM3260
		WITH	R10
		ADD	R4
		WITH	R11
		ADD	R9
;
		DEC	R5
		BNE	C_128_ROTZM3220 ;end ? ( no:C_128_ROTZM3220 )
		INC	R2		;Y pos +1
;
		IBT	R5,#32
		WITH	R2
		SUB	R5
		FROM	R5
		ADD	R5
		ADD	R3
		MOVE	R3,R0
		SWAP			;[ CMP #80H ]
		BPL	C_128_ROTZM3220+1
		MOVE	R1,R3		;[ dummy ]
;
		RPIX
;
		STOP
		NOP
;
;;;;;************************************************************************
;;;;;*		    LN^[gAkiTCY US~USj		    *
;;;;;*					  iGA PU~PUj		    *
;;;;;*			     F (R2)  <-- rbg}bvWQx	    *
;;;;;*				    (R3)  <--	     h	      Qw	    *
;;;;;*				    (R6)  <-- {iPOOgPDOj	    *
;;;;;*				    (R8)  <-- SQw			    *
;;;;;*				    (R9)  <--	hQx			    *
;;;;;*				    (R12) <-- LN^[AhXikCgj*
;;;;;*				    (R13) <--	      h	   (aj    *
;;;;;************************************************************************
;;;;;
;;;;C_64_ZOOM_16    EQU	    $
;;;;		    MOVE    R11,R6	    ;(R11) <-- x{Zbg
;;;;;
;;;;C_64_ZOOM_XY_16 EQU	    $
;;;;		    IBT	    R1,#01H	    ;(R1) <-- color mode initial set
;;;;;
;;;;;-------------- LN^[{ϊ ------------------------------------
;;;;		    IWT	    R4,#DIVBUF
;;;;		    FROM    R4
;;;;		    ADD	    R6
;;;;		    ADD	    R6
;;;;		    TO	    R6		    ;(R6) <-- LN^[{
;;;;		    LDW	    (R0)
;;;;;
;;;;		    FROM    R4
;;;;		    ADD	    R11
;;;;		    ADD	    R11
;;;;		    TO	    R11		    ;(R11) <-- LN^[{
;;;;		    LDW	    (R0)
;;;;;
;;;;;-------------- LN^[X^[g|C^[vZ ----------------------
;;;;		    MOVE    R0,R8
;;;;		    TO	    R10
;;;;		    SWAP
;;;;		    ADD	    R0		    ;x4
;;;;		    ADD	    R0		    ;
;;;;		    NOT
;;;;		    INC	    R0
;;;;		    LMULT
;;;;		    WITH    R10		    ;(R10) <-- SX * x_zoom
;;;;		    ADD	    R4
;;;;		    MOVE    R5,R6	    ;(R5) <-- w{
;;;;;
;;;;		    MOVE    R6,R11
;;;;		    MOVE    R0,R9
;;;;		    TO	    R7
;;;;		    SWAP
;;;;		    ADD	    R0		    ;x4
;;;;		    ADD	    R0		    ;
;;;;		    NOT
;;;;		    INC	    R0
;;;;		    LMULT
;;;;		    WITH    R7		    ;(R7) <-- SY * y_zoom
;;;;		    ADD	    R4
;;;;;
;;;;;-------------- ݃[h LN^[AhXZbg -------------
;;;;		    MOVE    R0,R12
;;;;		    LSR			    ;(C) <-- color mode
;;;;		    BCC	    C_64_ZOOM_16_10 ;hight bit color ? ( no:C_64_ZOOM_16_10 )
;;;;		    ADD	    R0
;;;;;
;;;;		    WITH    R1
;;;;		    OR	    #04H
;;;;C_64_ZOOM_16_10
;;;;		    FROM    R1
;;;;		    CMODE		    ;color mode set
;;;;		    MOVE    R6,R0	    ;(R6) <-- LN^[AhXikCgjZbg
;;;;;
;;;;;-------------- LN^[ ------------------------------------
;;;;		    FROM    R13
;;;;		    ROMB		    ;LN^[AhX (ajset
;;;;;
;;;;		    IWT	    R13,#C_64_ZOOM_16_30    ;(R13) <-- loop return address set
;;;;		    IBT	    R9,#64		    ;(R9)  <-- X loop set
;;;;;
;;;;		    CACHE
;;;;;
;;;;		    IBT	    R4,#32	    ;(R4)  <-- Y loop set
;;;;C_64_ZOOM_16_20
;;;;		    MOVE    R1,R3	    ;(R1) <-- plot start X pos set
;;;;		    MOVE    R8,R10	    ;(R8) <-- PX
;;;;;
;;;;		    MOVE    R12,R9	    ;X loop set
;;;;C_64_ZOOM_16_30
;;;;		    MERGE
;;;;		    BEQ	    C_64_ZOOM_16_40 ;area over ? ( yes:C_64_ZOOM_16_40 )
;;;;		    TO	    R14
;;;;;
;;;;		    ADD	    R6
;;;;;
;;;;		    WITH    R8
;;;;		    ADD	    R5
;;;;		    GETC		    ;color set
;;;;		    LOOP
;;;;		    PLOT
;;;;;
;;;;		    BRA	    C_64_ZOOM_16_60+1
;;;;		    WITH    R7		    ;[ dummy ]
;;;;;
;;;;C_64_ZOOM_16_40
;;;;		    WITH    R8
;;;;		    ADD	    R5
;;;;		    SUB	    R0		    ;[ IBT  R0,#00 ]
;;;;		    COLOUR		    ;color set
;;;;C_64_ZOOM_16_50
;;;;		    LOOP
;;;;		    PLOT		    ;pset
;;;;;
;;;;C_64_ZOOM_16_60
;;;;		    WITH    R7
;;;;		    ADD	    R11
;;;;;
;;;;		    DEC	    R4
;;;;		    BNE	    C_64_ZOOM_16_20 ;end ? ( no:C_64_ZOOM_16_20 )
;;;;		    INC	    R2		    ;Y pos +1
;;;;;
;;;;		    FROM    R9		    ;[ IBT R4,#32 ]
;;;;		    TO	    R4
;;;;		    LSR
;;;;		    WITH    R2
;;;;		    SUB	    R4
;;;;		    WITH    R3
;;;;		    ADD	    R9
;;;;		    FROM    R3
;;;;		    SWAP		    ;[ CMP #80H ]
;;;;		    BPL	    C_64_ZOOM_16_20+1
;;;;		    MOVE    R1,R3	    ;[ dummy ]
;;;;;
;;;;		    RPIX
;;;;;
;;;;		    STOP
;;;;		    NOP
;;;;;
;;;;;************************************************************************
;;;;;*		    LN^[gAkA]iTCY US~USj	    *
;;;;;*						iGA PU~PUj	    *
;;;;;*			     F (R2)  <-- rbg}bvWQx	    *
;;;;;*				    (R3)  <--	     h	      Qw	    *
;;;;;*				    (R5)  <-- pxiO`eegj	    *
;;;;;*				    (R6)  <-- {iPOOgPDOj	    *
;;;;;*				    (R12) <-- LN^[AhXikCgj*
;;;;;*				    (R13) <--	      h	   (aj    *
;;;;;************************************************************************
;;;;;
;;;;C_64_ROTZOM_16  EQU	    $
;;;;		    IBT	    R1,#01H	    ;(R1) <-- color mode initial set
;;;;;
;;;;C_64_ROTZOM_C16 EQU	    $
;;;;;
;;;;;-------------- LN^[{ϊ ------------------------------------
;;;;		    IWT	    R0,#DIVBUF
;;;;		    ADD	    R6
;;;;		    ADD	    R6
;;;;		    TO	    R6		    ;(R6) <-- LN^[{
;;;;		    LDW	    (R0)
;;;;;
;;;;;-------------- LN^[X^[g|C^[vZ ----------------------
;;;;		    WITH    R5
;;;;		    ADD	    R5
;;;;;
;;;;		    IBT	    R0,#BANK COS
;;;;		    ROMB
;;;;		    IWT	    R0,#COS
;;;;		    TO	    R14
;;;;		    ADD	    R5
;;;;		    GETB
;;;;		    INC	    R14
;;;;		    GETBH
;;;;		    LMULT
;;;;		    WITH    R4
;;;;		    HIB
;;;;		    LOB
;;;;		    SWAP
;;;;		    OR	    R4
;;;;		    MOVE    R9,R0	    ;(R9) <-- cos data
;;;;		    NOT
;;;;		    INC	    R0
;;;;		    ADD	    R0
;;;;		    ADD	    R0
;;;;		    ADD	    R0
;;;;		    ADD	    R0
;;;;		    TO	    R11
;;;;		    ADD	    R0
;;;;;
;;;;		    IWT	    R0,#SIN
;;;;		    TO	    R14
;;;;		    ADD	    R5
;;;;		    GETB
;;;;		    INC	    R14
;;;;		    GETBH
;;;;		    LMULT
;;;;		    WITH    R4
;;;;		    HIB
;;;;		    LOB
;;;;		    SWAP
;;;;		    OR	    R4
;;;;		    MOVE    R4,R0	    ;(R4) <-- sin data
;;;;		    NOT
;;;;		    INC	    R0
;;;;		    ADD	    R0
;;;;		    ADD	    R0
;;;;		    ADD	    R0
;;;;		    ADD	    R0
;;;;		    ADD	    R0
;;;;		    MOVE    R5,R0
;;;;		    ADD	    R11
;;;;		    IWT	    R6,#08H*100H
;;;;		    TO	    R10		    ;(R10) <-- SX * cos + SY * sin
;;;;		    ADD	    R6
;;;;;
;;;;		    FROM    R11
;;;;		    SUB	    R5
;;;;		    TO	    R11		    ;(R11) <-- SY * cos - SX * sin
;;;;		    ADD	    R6
;;;;;
;;;;;-------------- ݃[h LN^[AhXZbg -------------
;;;;		    MOVE    R0,R12
;;;;		    LSR			    ;(C) <-- color mode
;;;;		    BCC	    C_64_ROTZOM1610 ;hight bit color ? ( no:C_64_ROTZOM1610 )
;;;;		    ADD	    R0
;;;;;
;;;;		    WITH    R1
;;;;		    OR	    #04H
;;;;C_64_ROTZOM1610
;;;;		    FROM    R1
;;;;		    CMODE		    ;color mode set
;;;;		    MOVE    R6,R0	    ;(R6) <-- LN^[AhXikCgjZbg
;;;;;
;;;;;-------------- LN^[ ------------------------------------
;;;;		    FROM    R13
;;;;		    ROMB		    ;LN^[AhXiajZbg
;;;;;
;;;;		    IWT	    R13,#C_64_ROTZOM1630    ;(R13) <-- loop return address set
;;;;;
;;;;		    CACHE
;;;;;
;;;;		    IBT	    R5,#32	    ;(R5)  <-- Y loop set
;;;;C_64_ROTZOM1620
;;;;		    MOVE    R1,R3	    ;(R1) <-- plot start X pos set
;;;;		    MOVE    R8,R10	    ;(R8) <-- PX
;;;;		    MOVE    R7,R11	    ;(R7) <-- PY
;;;;;
;;;;		    IBT	    R12,#64	    ;X loop set
;;;;C_64_ROTZOM1630
;;;;		    MERGE
;;;;		    BEQ	  C_64_ROTZOM1640 ;area over ? ( yes:C_64_ROTZOM1640 )
;;;;		    TO	    R14
;;;;;
;;;;		    ADD	    R6
;;;;;
;;;;		    WITH    R8
;;;;		    ADD	    R9
;;;;		    WITH    R7
;;;;		    SUB	    R4
;;;;		    GETC		    ;color set
;;;;		    LOOP
;;;;		    PLOT		    ;pset
;;;;;
;;;;		    BRA	    C_64_ROTZOM1660+1
;;;;		    WITH    R10		    ;[ dummy]
;;;;;
;;;;C_64_ROTZOM1640
;;;;		    WITH    R8
;;;;		    ADD	    R9
;;;;		    WITH    R7
;;;;		    SUB	    R4
;;;;		    SUB	    R0		    ;[ IBT  R0,#00 ]
;;;;		    COLOUR		    ;color set
;;;;C_64_ROTZOM1650
;;;;		    LOOP
;;;;		    PLOT		    ;pset
;;;;;
;;;;C_64_ROTZOM1660
;;;;		    WITH    R10
;;;;		    ADD	    R4
;;;;		    WITH    R11
;;;;		    ADD	    R9
;;;;;
;;;;		    DEC	    R5
;;;;		    BNE	    C_64_ROTZOM1620 ;end ? ( no:C_64_ROTZOM1620 )
;;;;		    INC	    R2		    ;Y pos +1
;;;;;
;;;;		    IBT	    R5,#32
;;;;		    WITH    R2
;;;;		    SUB	    R5
;;;;		    FROM    R5
;;;;		    ADD	    R5
;;;;		    ADD	    R3
;;;;		    MOVE    R3,R0
;;;;		    SWAP		    ;[ CMP #80H ]
;;;;		    BPL	    C_64_ROTZOM1620+1
;;;;		    MOVE    R1,R3	    ;[ dummy ]
;;;;;
;;;;		    RPIX
;;;;;
;;;;		    STOP
;;;;		    NOP
;
;************************************************************************
;*		LN^[gAkA]iTCY US~USj	*
;*		  iwCx{ݒ^Cvj  iGA RQ~RQj	*
;*			 F (R2)  <-- rbg}bvWQx		*
;*				(R3)  <--	 h	  Qw		*
;*				(R5)  <-- pxiO`eegj		*
;*				(R6)  <-- w{iPOOgPDOj	*
;*				(R11) <-- x	     h			*
;*				(R12) <-- LN^[AhXikCgj*
;*				(R13) <--	  h	       (aj	*
;************************************************************************
;
C_64_RTZ_32_XY	EQU	$
		IBT	R1,#01H		;(R1) <-- color mode initial set
;
;-------------- LN^[{ϊ ------------------------------------
		IWT	R4,#DIVBUF
		FROM	R4
		ADD	R6
		ADD	R6
		TO	R6		;(R6) <-- LN^[{
		LDW	(R0)
;
		FROM	R4
		ADD	R11
		ADD	R11
		TO	R11		;(R11) <-- LN^[{
		LDW	(R0)
;
C_64_RTZ_C32_XY EQU	$
		WITH	R5
		ADD	R5
;
;-------------- LN^[X^[g|C^[vZ ----------------------
		IBT	R0,#BANK COS
		ROMB
		IWT	R0,#COS
		TO	R14
		ADD	R5
		GETB
		INC	R14
		GETBH
		MOVE	R14,R0
		LMULT
		WITH	R4
		HIB
		LOB
		SWAP
		TO	R9		;(R9) <-- cos * 
		OR	R4
;
		MOVE	R7,R6		;(R7) <-- 
		MOVE	R6,R11
		FROM	R14
		LMULT
		WITH	R4
		HIB
		LOB
		SWAP
		TO	R8		;(R8) <---- cos * 
		OR	R4
		SMS	R8,CWORK0	;(CWK0) <--    "
;
		IWT	R0,#SIN
		TO	R14
		ADD	R5
		GETB
		INC	R14
		GETBH
		MOVE	R14,R0
		LMULT
		WITH	R4
		HIB
		LOB
		SWAP
		OR	R4
		NOT
		INC	R0
		MOVE	R5,R0		;(R5) <--- -sin * 
		ADD	R8		;(R0) <-- cos *  - sin * 
		NOT
		INC	R0
		ADD	R0
		ADD	R0
		ADD	R0
		ADD	R0
		ADD	R0
		IWT	R10,#010H*100H	;(R10)	<-- cxy
		TO	R11		;(R11) <-- (xy) * (cos *  - sin * ) + (cxy)
		ADD	R10
;
		MOVE	R6,R7
		FROM	R14
		LMULT
		WITH	R4
		HIB
		LOB
		SWAP
		OR	R4
		SMS	R0,CWORK1	;(CWK1) <-- sin * 
		ADD	R9		;(R0) <-- cos *  + sin * 
		NOT
		INC	R0
		ADD	R0
		ADD	R0
		ADD	R0
		ADD	R0
		ADD	R0
		TO	R10		;(R10) <-- (xy) * (cos *  + sin * ) + (cxy)
		ADD	R10
;
;-------------- ݃[h LN^[AhXZbg -------------
		MOVE	R0,R12
		LSR			;(C) <-- color mode
		BCC	C_64_RTZ_XY3210 ;hight bit color ? ( no:C_64_RTZ_XY3210 )
		ADD	R0
;
		WITH	R1
		OR	#04H
C_64_RTZ_XY3210
		FROM	R1
		CMODE			;color mode set
		MOVE	R6,R0		;(R6) <-- LN^[AhXikCgjZbg
;
;-------------- LN^[ ------------------------------------
		FROM	R13
		ROMB			;LN^[AhXiajZbg
;
		IWT	R13,#C_64_RTZ_XY3230	;(R13) <-- loop return address set
		IBT	R4,#32			;(R4)  <-- Y loop set
;
		CACHE
;
C_64_RTZ_XY3220
		MOVE	R1,R3		;(R1) <-- plot start X pos set
		MOVE	R8,R10		;(R8) <-- PX
		MOVE	R7,R11		;(R7) <-- PY
;
		IBT	R12,#64		;X loop set
C_64_RTZ_XY3230
		MERGE
		BCS	C_64_RTZ_XY3240 ;area over ? ( yes:C_64_RTZ_XY3240 )
		TO	R14
;
		ADD	R6
;
		WITH	R8
		ADD	R9
		WITH	R7
		ADD	R5
		GETC			;color set
		LOOP
		PLOT
;
		BRA	C_64_RTZ_XY3250+1
		LMS	R0,CWORK1	;[ dummy ]
;
C_64_RTZ_XY3240
		WITH	R8
		ADD	R9
		WITH	R7
		ADD	R5
		SUB	R0		;[ IBT	R0,#00 ]
		COLOUR			;color set
		LOOP
		PLOT			;pset
;
C_64_RTZ_XY3250
		LMS	R0,CWORK1	;(R0) <-- sin * 
		TO	R10
		ADD	R10
		LMS	R0,CWORK0	;(R0) <-- cos * 
		TO	R11
		ADD	R11
		DEC	R4
		BNE	C_64_RTZ_XY3220 ;end ? ( no:C_64_RTZ_XY3220 )
		INC	R2		;Y pos +1

		IBT	R4,#32
		WITH	R2
		SUB	R4
		FROM	R4
		ADD	R4
		ADD	R3
		MOVE	R3,R0
		SWAP			;[ CMP #80H ]
		BPL	C_64_RTZ_XY3220+1
		MOVE	R1,R3		;[ dummy ]
;
		RPIX
;
		STOP
		NOP
;
;************************************************************************
;*		LN^[gAkiTCY RQ~USj		*
;*				      iGA RQ~RQj		*
;*			 F (R2)  <-- rbg}bvWQx		*
;*				(R3)  <--	 h	  Qw		*
;*				(R6)  <-- {iPOOgPDOj	*
;*				(R8)  <-- SQw			*
;*				(R9)  <--   hQx			*
;*				(R12) <-- LN^[AhXikCgj*
;*				(R13) <--	  h	       (aj	*
;************************************************************************
;
C_64HZOOM_32	EQU	$
		MOVE	R11,R6		;(R11) <-- x{Zbg
;
C_64HZOOM_XY_32 EQU	$
		IBT	R1,#01H		;(R1) <-- color mode initial set
;
;-------------- LN^[{ϊ ------------------------------------
		IWT	R4,#DIVBUF
		FROM	R4
		ADD	R6
		ADD	R6
		TO	R6		;(R6) <-- LN^[{
		LDW	(R0)
;
		FROM	R4
		ADD	R11
		ADD	R11
		TO	R11		;(R11) <-- LN^[{
		LDW	(R0)
;
;-------------- LN^[X^[g|C^[vZ ----------------------
		MOVE	R0,R8
		TO	R10
		SWAP
		ADD	R0		;x2
		NOT
		INC	R0
		LMULT
		WITH	R10		;(R10) <-- SX * x_zoom
		ADD	R4
		MOVE	R5,R6		;(R5) <-- w{
;
		MOVE	R6,R11
		MOVE	R0,R9
		TO	R7
		SWAP
		ADD	R0		;x2
		NOT
		INC	R0
		LMULT
		WITH	R7		;(R7) <-- SY * y_zoom
		ADD	R4
;
;-------------- ݃[h LN^[AhXZbg -------------
		MOVE	R0,R12
		LSR			;(C) <-- color mode
		BCC	C_64HZOOM_32_10 ;hight bit color ? ( no:C_64HZOOM_32_10 )
		ADD	R0
;
		WITH	R1
		OR	#04H
C_64HZOOM_32_10
		FROM	R1
		CMODE			;color mode set
		MOVE	R6,R0		;(R6) <-- LN^[AhXikCgjZbg
;
;-------------- LN^[ ------------------------------------
		FROM	R13
		ROMB			;LN^[AhX (ajset
;
		IWT	R13,#C_64HZOOM_32_30	;(R13) <-- loop return address set
;;;;		    IBT	    R9,#64		    ;(R9)  <-- X loop set
		IBT	R9,#2		;(R9)  <-- Y loop set
;
		CACHE
;
		IBT	R4,#32		;(R4)  <-- Y loop set
C_64HZOOM_32_20
		MOVE	R1,R3		;(R1) <-- plot start X pos set
		MOVE	R8,R10		;(R8) <-- PX
;
		IBT	R12,#32		;X loop set
C_64HZOOM_32_30
		MERGE
		BCS	C_64HZOOM_32_40 ;area over ? ( yes:C_64HZOOM_32_40 )
		TO	R14
;
		ADD	R6
;
		WITH	R8
		ADD	R5
		GETC			;color set
		LOOP
		PLOT
;
		BRA	C_64HZOOM_32_60+1
		WITH	R7		;[ dummy ]
;
C_64HZOOM_32_40
		WITH	R8
		ADD	R5
		SUB	R0		;[ IBT	R0,#00 ]
		COLOUR			;color set
C_64HZOOM_32_50
		LOOP
		PLOT			;pset
;
C_64HZOOM_32_60
		WITH	R7
		ADD	R11
;
		DEC	R4
		BNE	C_64HZOOM_32_20 ;end ? ( no:C_64HZOOM_32_20 )
		INC	R2		;Y pos +1
;
		IBT	R4,#32
		WITH	R2
		SUB	R4
		WITH	R3
		ADD	R4
;
		DEC	R9
		BNE	C_64HZOOM_32_20+1
		MOVE	R1,R3		;[ dummy ]
;
		RPIX
;
		STOP
		NOP
;
;************************************************************************
;*		LN^[gAkA]iTCY US~USj	*
;*		  iwCx{ݒ^Cvj  iGA RQ~RQj	*
;*			 F (R2)  <-- rbg}bvWQx		*
;*				(R3)  <--	 h	  Qw		*
;*				(R5)  <-- pxiO`Peegj		*
;*				(R6)  <-- w{iPOOgPDOj	*
;*				(R11) <-- x	     h			*
;*				(R12) <-- LN^[AhXikCgj*
;*				(R13) <--	  h	       (aj	*
;*									*
;*			 F (R2)  <-- rbg}bvWQx		*
;*				(R3)  <--	 h	  Qw		*
;*				(R10) <-- f[^w@onrD		*
;*				(R11) <-- f[^x@onrD		*
;*				(R12) <-- LN^[AhXikCgj*
;*				(R13) <--	  h	       (aj	*
;*				WRK0  <-- cos * 			*
;*				WRK1  <-- sin * 			*
;*				WRK2  <-- cos * 			*
;*				WRK3  <-- -sin * 			*
;*									*
;************************************************************************
;
C_64_RZ_32_XY_0 EQU	$
;
;-------------- LN^[{ϊ ------------------------------------
		IWT	R4,#DIVBUF
		FROM	R4
		ADD	R6
		ADD	R6
		TO	R6		;(R6) <-- LN^[{
		LDW	(R0)
;
		FROM	R4
		ADD	R11
		ADD	R11
		TO	R11		;(R11) <-- LN^[{
		LDW	(R0)
;
;-------------- LN^[X^[g|C^[vZ ----------------------
		IBT	R0,#BANK COS
		ROMB
		IWT	R0,#COS
		TO	R14
		ADD	R5
		GETB
		INC	R14
		GETBH
		MOVE	R14,R0
		LMULT
		WITH	R4
		HIB
		LOB
		SWAP
		TO	R9		;(R9) <-- cos * 
		OR	R4
		SMS	R9,CWORK2
;
		MOVE	R7,R6		;(R7) <-- 
		MOVE	R6,R11
		FROM	R14
		LMULT
		WITH	R4
		HIB
		LOB
		SWAP
		TO	R8		;(R8) <---- cos * 
		OR	R4
		SMS	R8,CWORK0	;(CWK0) <--    "
;
		IWT	R0,#SIN
		TO	R14
		ADD	R5
		GETB
		INC	R14
		GETBH
		MOVE	R14,R0
		LMULT
		WITH	R4
		HIB
		LOB
		SWAP
		OR	R4
		NOT
		INC	R0
		MOVE	R5,R0		;(R5) <--- -sin * 
		SMS	R5,CWORK3
		ADD	R8		;(R0) <-- cos *  - sin * 
		NOT
		INC	R0
		ADD	R0
		ADD	R0
		ADD	R0
		ADD	R0
		ADD	R0
		IWT	R10,#010H*100H	;(R10)	<-- cxy
		TO	R11		;(R11) <-- (xy) * (cos *  - sin * ) + (cxy)
		ADD	R10
;
		MOVE	R6,R7
		FROM	R14
		LMULT
		WITH	R4
		HIB
		LOB
		SWAP
		OR	R4
		SMS	R0,CWORK1	;(CWK1) <-- sin * 
		ADD	R9		;(R0) <-- cos *  + sin * 
		NOT
		INC	R0
		ADD	R0
		ADD	R0
		ADD	R0
		ADD	R0
		ADD	R0
		TO	R10		;(R10) <-- (xy) * (cos *  + sin * ) + (cxy)
		ADD	R10

C_64_RZ_32_XY_1 EQU	$
		LMS	R9,CWORK2
		LMS	R5,CWORK3
;
;-------------- ݃[h LN^[AhXZbg -------------
		IBT	R1,#01H		;(R1) <-- color mode initial set
		MOVE	R0,R12
		LSR			;(C) <-- color mode
		BCC	C_64_RZ_XY32_010 ;hight bit color ? ( no:C_64_RZ_XY32_010 )
		ADD	R0
;
		WITH	R1
		OR	#04H
C_64_RZ_XY32_010
		FROM	R1
		CMODE			;color mode set
		MOVE	R6,R0		;(R6) <-- LN^[AhXikCgjZbg
;
;-------------- LN^[ ------------------------------------
		FROM	R13
		ROMB			;LN^[AhXiajZbg
;
		IWT	R13,#C_64_RZ_XY32_030	;(R13) <-- loop return address set
		IBT	R4,#32			;(R4)  <-- Y loop set
;
		CACHE
;
C_64_RZ_XY32_020
		MOVE	R1,R3		;(R1) <-- plot start X pos set
		MOVE	R8,R10		;(R8) <-- PX
		MOVE	R7,R11		;(R7) <-- PY
;
		IBT	R12,#64		;X loop set
C_64_RZ_XY32_030
		MERGE
		BCS	C_64_RZ_XY32_040 ;area over ? ( yes:C_64_RZ_XY32_040 )
		TO	R14
;
		ADD	R6
;
		WITH	R8
		ADD	R9
		WITH	R7
		ADD	R5
		GETC			;color set
		LOOP
		PLOT
;
		BRA	C_64_RZ_XY32_050+1
		LMS	R0,CWORK1	;[ dummy ]
;
C_64_RZ_XY32_040
		WITH	R8
		ADD	R9
		WITH	R7
		ADD	R5
		SUB	R0		;[ IBT	R0,#00 ]
		COLOUR			;color set
		LOOP
		PLOT			;pset
;
C_64_RZ_XY32_050
		LMS	R0,CWORK1	;(R0) <-- sin * 
		TO	R10
		ADD	R10
		LMS	R0,CWORK0	;(R0) <-- cos * 
		TO	R11
		ADD	R11
		DEC	R4
		BNE	C_64_RZ_XY32_020 ;end ? ( no:C_64_RZ_XY32_020 )
		INC	R2		;Y pos +1
;
		RPIX
;
		STOP
		NOP
;
;************************************************************************
;*		LN^[gAkA]iTCY US~USj	*
;*		  iwCx{ݒ^Cvj  iGA US~USj	*
;*			 F (R2)  <-- rbg}bvWQx		*
;*				(R3)  <--	 h	  Qw		*
;*				(R5)  <-- pxiO`eegj		*
;*				(R6)  <-- w{iPOOgPDOj	*
;*				(R11) <-- x	     h			*
;*				(R12) <-- LN^[AhXikCgj*
;*				(R13) <--	  h	       (aj	*
;************************************************************************
;
C_64_ROTZOM	EQU	$
		MOVE	R11,R6		;(R11) <-- x{
;
C_64_RTZ_64_XY	EQU	$
		IBT	R1,#01H		;(R1) <-- color mode initial set
;
;-------------- LN^[{ϊ ------------------------------------
		IWT	R4,#DIVBUF
		FROM	R4
		ADD	R6
		ADD	R6
		TO	R6		;(R6) <-- LN^[{
		LDW	(R0)
;
		FROM	R4
		ADD	R11
		ADD	R11
		TO	R11		;(R11) <-- LN^[{
		LDW	(R0)
;
C_64_RTZ_C64_XY EQU	$
		WITH	R5
		ADD	R5
;
;-------------- LN^[X^[g|C^[vZ ----------------------
		IBT	R0,#BANK COS
		ROMB
		IWT	R0,#COS
		TO	R14
		ADD	R5
		GETB
		INC	R14
		GETBH
		MOVE	R14,R0
		LMULT
		WITH	R4
		HIB
		LOB
		SWAP
		TO	R9		;(R9) <-- cos * 
		OR	R4
;
		MOVE	R7,R6		;(R7) <-- 
		MOVE	R6,R11
		FROM	R14
		LMULT
		WITH	R4
		HIB
		LOB
		SWAP
		TO	R8		;(R8) <---- cos * 
		OR	R4
		SMS	R8,CWORK0	;(CWK0) <--    "
;
		IWT	R0,#SIN
		TO	R14
		ADD	R5
		GETB
		INC	R14
		GETBH
		MOVE	R14,R0
		LMULT
		WITH	R4
		HIB
		LOB
		SWAP
		OR	R4
		NOT
		INC	R0
		MOVE	R5,R0		;(R5) <--- -sin * 
		ADD	R8		;(R0) <-- cos *  - sin * 
		NOT
		INC	R0
		ADD	R0
		ADD	R0
		ADD	R0
		ADD	R0
		ADD	R0
		IWT	R10,#(020H*100H) ;(R10)	 <-- cxy
		TO	R11		;(R11) <-- (xy) * (cos *  - sin * ) + (cxy)
		ADD	R10
;
		MOVE	R6,R7
		FROM	R14
		LMULT
		WITH	R4
		HIB
		LOB
		SWAP
		OR	R4
		SMS	R0,CWORK1	;(CWK1) <-- sin * 
		ADD	R9		;(R0) <-- cos *  + sin * 
		NOT
		INC	R0
		ADD	R0
		ADD	R0
		ADD	R0
		ADD	R0
		ADD	R0
		TO	R10		;(R10) <-- (xy) * (cos *  + sin * ) + (cxy)
		ADD	R10
;
;-------------- ݃[h LN^[AhXZbg -------------
		MOVE	R0,R12
		LSR			;(C) <-- color mode
		BCC	C_64_RTZ_XY6410 ;hight bit color ? ( no:C_64_RTZ_XY6410 )
		ADD	R0
;
		WITH	R1
		OR	#04H
C_64_RTZ_XY6410
		FROM	R1
		CMODE			;color mode set
		MOVE	R6,R0		;(R6) <-- LN^[AhXikCgjZbg
;
;-------------- LN^[ ------------------------------------
		FROM	R13
		ROMB			;LN^[AhXiajZbg
;
		IWT	R13,#C_64_RTZ_XY6430	;(R13) <-- loop return address set
		IBT	R4,#32			;(R4)  <-- Y loop set
;
		CACHE
;
C_64_RTZ_XY6420
		MOVE	R1,R3		;(R1) <-- plot start X pos set
		MOVE	R8,R10		;(R8) <-- PX
		MOVE	R7,R11		;(R7) <-- PY
;
		IBT	R12,#64		;X loop set
C_64_RTZ_XY6430
		MERGE
		BVS	C_64_RTZ_XY6440 ;area over ? ( yes:C_64_RTZ_XY6440 )
		TO	R14
;
		ADD	R6
;
		WITH	R8
		ADD	R9
		WITH	R7
		ADD	R5
		GETC			;color set
		LOOP
		PLOT
;
		BRA	C_64_RTZ_XY6450+1
		LMS	R0,CWORK1	;[ dummy ]
;
C_64_RTZ_XY6440
		WITH	R8
		ADD	R9
		WITH	R7
		ADD	R5
		SUB	R0		;[ IBT	R0,#00 ]
		COLOUR			;color set
		LOOP
		PLOT			;pset
;
C_64_RTZ_XY6450
		LMS	R0,CWORK1	;(R0) <-- sin * 
		TO	R10
		ADD	R10
		LMS	R0,CWORK0	;(R0) <-- cos * 
		TO	R11
		ADD	R11
		DEC	R4
		BNE	C_64_RTZ_XY6420 ;end ? ( no:C_64_RTZ_XY6420 )
		INC	R2		;Y pos +1

		IBT	R4,#32
		WITH	R2
		SUB	R4
		FROM	R4
		ADD	R4
		ADD	R3
		MOVE	R3,R0
		SWAP			;[ CMP #80H ]
		BPL	C_64_RTZ_XY6420+1
		MOVE	R1,R3		;[ dummy ]
;
		RPIX
;
		STOP
		NOP
;
;************************************************************************
;*		LN^[gAkiTCY PU~RQj		*
;*			 F (R2)  <-- rbg}bvWQx		*
;*				(R3)  <--	 h	  Qw		*
;*				(R6)  <-- w{iPOOgPDOj	*
;*				(R11) <-- x{iPOOgPDOj	*
;*				(R8)  <-- SQw			*
;*				(R9)  <--   hQx			*
;*				(R12) <-- LN^[AhXikCgj*
;*				(R13) <--	  h	       (aj	*
;************************************************************************
;
C_1632_ZOOM	EQU	$
		MOVE	R11,R6		;(R11) <-- x{Zbg
;
C_1632_ZOOM_XY	EQU	$
		IBT	R1,#01H		;(R1) <-- color mode initial set
;
;-------------- LN^[{ϊ ------------------------------------
		IWT	R4,#DIVBUF
		FROM	R4
		ADD	R6
		ADD	R6
		TO	R6		;(R6) <-- LN^[{
		LDW	(R0)
;
		FROM	R4
		ADD	R11
		ADD	R11
		TO	R11		;(R11) <-- LN^[{
		LDW	(R0)
;
;-------------- LN^[X^[g|C^[vZ ----------------------
		MOVE	R0,R8
		TO	R10
		SWAP
		NOT
		INC	R0
		LMULT
		WITH	R10		;(R10) <-- SX * x_zoom
		ADD	R4
		MOVE	R5,R6		;(R5) <-- w{
;
		MOVE	R6,R11
		MOVE	R0,R9
		TO	R7
		SWAP
		NOT
		INC	R0
		LMULT
		WITH	R7		;(R7) <-- SY * y_zoom
		ADD	R4
;
;-------------- ݃[h LN^[AhXZbg -------------
		MOVE	R0,R12
		LSR			;(C) <-- color mode
		BCC	C_1632_ZOOM_10	;hight bit color ? ( no:C_1632_ZOOM_10 )
		ADD	R0
;
		WITH	R1
		OR	#04H
C_1632_ZOOM_10
		FROM	R1
		CMODE			;color mode set
		MOVE	R6,R0		;(R6) <-- LN^[AhXikCgjZbg
;
;-------------- LN^[ ------------------------------------
		FROM	R13
		ROMB			;LN^[AhX (ajset
;
		IWT	R13,#C_1632_ZOOM_30	;(R13) <-- loop return address set
		IBT	R4,#32			;(R4)  <-- Y loop set
		IBT	R9,#16			;(R9)  <-- X loop set
;
		CACHE
;
C_1632_ZOOM_20
		MOVE	R1,R3		;(R1) <-- plot start X pos set
		MOVE	R8,R10		;(R8) <-- PX
;
		MOVE	R12,R9		;X loop set
C_1632_ZOOM_30
		MERGE
		BCS	C_1632_ZOOM_40	;area over ? ( yes:C_1632_ZOOM_40 )
		TO	R14
;
		ADD	R6
;
		WITH	R8
		ADD	R5
		GETC			;color set
		LOOP
		PLOT			;pset
;
		BRA	C_1632_ZOOM_50+1
		WITH	R7
;
C_1632_ZOOM_40
		WITH	R8
		ADD	R5
		SUB	R0		;[ IBT	R0,#00 ]
		COLOUR			;color set
		LOOP
		PLOT			;pset
;
C_1632_ZOOM_50
		WITH	R7
		ADD	R11
		DEC	R4
		BNE	C_1632_ZOOM_20	;end ? ( no:C_1632_ZOOM_20 )
		INC	R2		;Y pos +1
;
		RPIX
;
		STOP
		NOP
;
;************************************************************************
;*		LN^[gAkiTCY US~USj		*
;*		  iwCx{ݒ^Cvj  iGA US~USj	*
;*					    iRQ̂݁j		*
;*			 F (R2)  <-- rbg}bvWQx		*
;*				(R3)  <--	 h	  Qw		*
;*				(R6)  <-- {iPOOgPDOj	*
;*				(R8)  <-- SQw			*
;*				(R9)  <--   hQx			*
;*				(R12) <-- LN^[AhXikCgj*
;*				(R13) <--	  h	       (aj	*
;************************************************************************
;
;;;;C_64_ZOOM_V	    EQU	    $
;;;;		    MOVE    R11,R6	    ;(R11) <-- x{Zbg
;
C_64_ZOOM_V_XY	EQU	$
		IBT	R1,#01H		;(R1) <-- color mode initial set
;
C_64_ZOOM_VXY_C EQU	$
;
;-------------- LN^[{ϊ ------------------------------------
		IWT	R4,#DIVBUF
		FROM	R4
		ADD	R6
		ADD	R6
		TO	R6		;(R6) <-- LN^[{
		LDW	(R0)
;
		FROM	R4
		ADD	R11
		ADD	R11
		TO	R11		;(R11) <-- LN^[{
		LDW	(R0)
;
;-------------- LN^[X^[g|C^[vZ ----------------------
		MOVE	R0,R8
		TO	R10
		SWAP
		NOT
		INC	R0
		LMULT
		WITH	R10		;(R10) <-- SX * x_zoom
		ADD	R4
		MOVE	R5,R6		;(R5) <-- w{
;
		MOVE	R6,R11
		MOVE	R0,R9
		TO	R7
		SWAP
		NOT
		INC	R0
		LMULT
		WITH	R7		;(R7) <-- SY * y_zoom
		ADD	R4
;
;-------------- ݃[h LN^[AhXZbg -------------
		MOVE	R0,R12
		LSR			;(C) <-- color mode
		BCC	C_64_ZOOM_V_10	;hight bit color ? ( no:C_64_ZOOM_V_10 )
		ADD	R0
;
		WITH	R1
		OR	#04H
C_64_ZOOM_V_10
		FROM	R1
		CMODE			;color mode set
		MOVE	R6,R0		;(R6) <-- LN^[AhXikCgjZbg
;
;-------------- LN^[ ------------------------------------
		FROM	R13
		ROMB			;LN^[AhX (ajset
;
		IWT	R13,#C_64_ZOOM_V_30	;(R13) <-- loop return address set
		IBT	R4,#32			;(R4)  <-- Y loop set
		IBT	R9,#64			;(R9)  <-- X loop set
;
		CACHE
;
C_64_ZOOM_V_20
		MOVE	R1,R3		;(R1) <-- plot start X pos set
		MOVE	R8,R10		;(R8) <-- PX
;
		MOVE	R12,R9		;X loop set
C_64_ZOOM_V_30
		MERGE
		BVS	C_64_ZOOM_V_40	;area over ? ( yes:C_64_ZOOM_V_40 )
		TO	R14
;
		ADD	R6
;
		WITH	R8
		ADD	R5
		GETC			;color set
		LOOP
		PLOT			;pset
;
		BRA	C_64_ZOOM_V_50+1
		WITH	R7
;
C_64_ZOOM_V_40
		WITH	R8
		ADD	R5
		SUB	R0		;[ IBT	R0,#00 ]
		COLOUR			;color set
		LOOP
		PLOT			;pset
;
C_64_ZOOM_V_50
		WITH	R7
		ADD	R11
		DEC	R4
		BNE	C_64_ZOOM_V_20	;end ? ( no:C_64_ZOOM_V_20 )
		INC	R2		;Y pos +1
;
		RPIX
;
		STOP
		NOP
;
;
;************************************************************************
;*		afւ݁iTCY SW~PUj			*
;*			 F (R2)  <-- rbg}bvWQx		*
;*				(R3)  <--	 h	  Qw		*
;*				(R6)  <-- {iPOOgPDOj	*
;*				(R11) <-- Jn_			*
;*				(R12) <-- LN^[AhXikCgj*
;*				(R13) <--	  h	       (aj	*
;************************************************************************
;
FLOOR_DOWN	EQU	$
;
;-------------- ւ݃f[^Zbg --------------------------------------
		IWT	R0,#020H*100H
		TO	R9		;(R9) <-- G power
		FMULT
;
;-------------- ݃[h LN^[AhXZbg -------------
		IBT	R0,#01H		;(R0) <-- color mode initial set
		CMODE			;color mode set
		MOVE	R6,R12		;(R12) <-- LN^[AhXikCgjZbg
;
;-------------- LN^[ ------------------------------------
		FROM	R13
		ROMB			;LN^[AhX (ajset
;
		IBT	R4,#16		;(R4)  <-- Y loop set
		IWT	R10,#0100H	;(R10) <-- chara data pointer step
;
		CACHE
;
FLOOR_DOWN_20
		MOVE	R1,R3		;(R1) <-- plot start X pos
		IBT	R0,#16
		SUB	R4
		TO	R7		;(R7) <-- start chara data Y pointer
		SWAP
		TO	R5		;[ IBT R5,#0 ] (R5) <-- initial Y speed
		SUB	R0
		MOVE	R8,R5		;[ IBT R8,#0 ] (R8) <-- start chara data X pointer
		MOVES	R12,R11
		BEQ	FLOOR_DOWN_40	;Jn_OH ( yes:FLOOR_DOWN_40 )
		MERGE			;[ dummy ]
;
;-------------- 1.st area -----------------------------------------------
		TO	R14
		ADD	R6
;
		MOVE	R13,R15
FLOOR_DOWN_30
		WITH	R8
		ADD	R10
		GETC
		INC	R14
		LOOP
		PLOT
;
;-------------- 2.st area -----------------------------------------------
FLOOR_DOWN_40
		IBT	R12,#8		;(R12) <-- loop no.
		MOVE	R13,R15
FLOOR_DOWN_50
		MERGE
		BVS	FLOOR_DOWN_60	;chara data over ? ( yes:FLOOR_DOWN_60 )
		TO	R14
;
		ADD	R6
;
		WITH	R7
		ADD	R5
		WITH	R5
		SUB	R9
		WITH	R8
		ADD	R10
		GETC
		LOOP
		PLOT
;
		BRA	FLOOR_DOWN_70+1
		IBT	R12,#16		;[ dummy ]
;
FLOOR_DOWN_60
		WITH	R7
		ADD	R5
		WITH	R5
		SUB	R9
		WITH	R8
		ADD	R10
		SUB	R0
		COLOUR
		LOOP
		PLOT
;
;-------------- 3.st area -----------------------------------------------
FLOOR_DOWN_70
		IBT	R12,#16		;(R12) <-- loop no.
		MOVE	R13,R15
FLOOR_DOWN_80
		MERGE
		BVS	FLOOR_DOWN_90	;chara data over ? ( yes:FLOOR_DOWN_90 )
		TO	R14
;
		ADD	R6
;
		WITH	R7
		ADD	R5
		WITH	R5
		ADD	R9
		WITH	R8
		ADD	R10
		GETC
		LOOP
		PLOT
;
		BRA	FLOOR_DOWN_100+1
		IBT	R12,#8		;[ dummy ]
;
FLOOR_DOWN_90
		WITH	R7
		ADD	R5
		WITH	R5
		ADD	R9
		WITH	R8
		ADD	R10
		SUB	R0
		COLOUR
		LOOP
		PLOT
;
;-------------- 4.st area -----------------------------------------------
FLOOR_DOWN_100
		IBT	R12,#8		;(R12) <-- loop no.
		MOVE	R13,R15
FLOOR_DOWN_110
		MERGE
		BVS	FLOOR_DOWN_120	;chara data over ? ( yes:FLOOR_DOWN_120 )
		TO	R14
;
		ADD	R6
;
		WITH	R7
		ADD	R5
		WITH	R5
		SUB	R9
		WITH	R8
		ADD	R10
		GETC
		LOOP
		PLOT
;
		BRA	FLOOR_DOWN_130+1
		IBT	R0,#48-32	;[ dummy ]
;
FLOOR_DOWN_120
		WITH	R7
		ADD	R5
		WITH	R5
		SUB	R9
		WITH	R8
		ADD	R10
		SUB	R0
		COLOUR
		LOOP
		PLOT
;
;-------------- 5.st area -----------------------------------------------
FLOOR_DOWN_130
		IBT	R0,#48-32
		TO	R12
		SUB	R11
		MOVE	R13,R15
FLOOR_DOWN_140
		MERGE
		TO	R14
		ADD	R6
;
		WITH	R8
		ADD	R10
		GETC
		LOOP
		PLOT
;
		DEC	R4
		BEQ	FLOOR_DOWN_150
		INC	R2
;
		IWT	R15,#FLOOR_DOWN_20+1
		MOVE	R1,R3		;[ dummy ]
;
FLOOR_DOWN_150
		RPIX
;
		STOP
		NOP
;
;;;;;************************************************************************
;;;;;*		    afւ݁mkniTCY SW~PUj		    *
;;;;;*			     F (R2)  <-- rbg}bvWQx	    *
;;;;;*				    (R3)  <--	     h	      Qw	    *
;;;;;*				    (R6)  <-- {iPOOgPDOj	    *
;;;;;*				    (R11) <-- Jn_			    *
;;;;;*				    (R12) <-- LN^[AhXikCgj*
;;;;;*				    (R13) <--	      h	   (aj    *
;;;;;************************************************************************
;;;;;
;;;;FLOOR_DOWN_SP   EQU	    $
;;;;;
;;;;;-------------- ւ݃f[^Zbg --------------------------------------
;;;;		    IWT	    R0,#020H*100H
;;;;		    FMULT
;;;;		    MOVE    R9,R0	    ;(R9) <-- G power
;;;;		    DIV2		    ;--+
;;;;		    DIV2		    ;  +--> 1/16
;;;;		    DIV2		    ;  |
;;;;		    DIV2		    ;--+
;;;;		    SMS	    R0,CWORK0	    ;(CWK0) <-- G power dec data
;;;;;
;;;;;-------------- ݃[h LN^[AhXZbg -------------
;;;;		    IBT	    R0,#01H	    ;(R0) <-- color mode initial set
;;;;		    CMODE		    ;color mode set
;;;;		    MOVE    R6,R12	    ;(R12) <-- LN^[AhXikCgjZbg
;;;;;
;;;;;-------------- LN^[ ------------------------------------
;;;;		    FROM    R13
;;;;		    ROMB		    ;LN^[AhX (ajset
;;;;;
;;;;		    IBT	    R4,#16	    ;(R4)  <-- Y loop set
;;;;		    IWT	    R10,#0100H	    ;(R10) <-- chara data pointer step
;;;;;
;;;;		    CACHE
;;;;;
;;;;FLOOR_DOWN_S20
;;;;		    MOVE    R1,R3	    ;(R1) <-- plot start X pos
;;;;		    IBT	    R0,#16
;;;;		    SUB	    R4
;;;;		    TO	    R7		    ;(R7) <-- start chara data Y pointer
;;;;		    SWAP
;;;;		    TO	    R5		    ;[ IBT R5,#0 ] (R5) <-- initial Y speed
;;;;		    SUB	    R0
;;;;		    MOVE    R8,R5	    ;[ IBT R8,#0 ] (R8) <-- start chara data X pointer
;;;;		    MOVES   R12,R11
;;;;		    BEQ	    FLOOR_DOWN_S40  ;Jn_OH ( yes:FLOOR_DOWN_S40 )
;;;;		    MERGE		    ;[ dummy ]
;;;;;
;;;;;-------------- 1.st area -----------------------------------------------
;;;;		    TO	    R14
;;;;		    ADD	    R6
;;;;;
;;;;		    MOVE    R13,R15
;;;;FLOOR_DOWN_S30
;;;;		    WITH    R8
;;;;		    ADD	    R10
;;;;		    GETC
;;;;		    INC	    R14
;;;;		    LOOP
;;;;		    PLOT
;;;;;
;;;;;-------------- 2.st area -----------------------------------------------
;;;;FLOOR_DOWN_S40
;;;;		    IBT	    R12,#8	    ;(R12) <-- loop no.
;;;;		    MOVE    R13,R15
;;;;FLOOR_DOWN_S50
;;;;		    MERGE
;;;;		    BVS	    FLOOR_DOWN_S60  ;chara data over ? ( yes:FLOOR_DOWN_S60 )
;;;;		    TO	    R14
;;;;;
;;;;		    ADD	    R6
;;;;;
;;;;		    WITH    R7
;;;;		    ADD	    R5
;;;;		    WITH    R5
;;;;		    SUB	    R9
;;;;		    WITH    R8
;;;;		    ADD	    R10
;;;;		    GETC
;;;;		    LOOP
;;;;		    PLOT
;;;;;
;;;;		    BRA	    FLOOR_DOWN_S70+1
;;;;		    IBT	    R12,#16	    ;[ dummy ]
;;;;;
;;;;FLOOR_DOWN_S60
;;;;		    WITH    R7
;;;;		    ADD	    R5
;;;;		    WITH    R5
;;;;		    SUB	    R9
;;;;		    WITH    R8
;;;;		    ADD	    R10
;;;;		    SUB	    R0
;;;;		    COLOUR
;;;;		    LOOP
;;;;		    PLOT
;;;;;
;;;;;-------------- 3.st area -----------------------------------------------
;;;;FLOOR_DOWN_S70
;;;;		    IBT	    R12,#16	    ;(R12) <-- loop no.
;;;;		    MOVE    R13,R15
;;;;FLOOR_DOWN_S80
;;;;		    MERGE
;;;;		    BVS	    FLOOR_DOWN_S90  ;chara data over ? ( yes:FLOOR_DOWN_S90 )
;;;;		    TO	    R14
;;;;;
;;;;		    ADD	    R6
;;;;;
;;;;		    WITH    R7
;;;;		    ADD	    R5
;;;;		    WITH    R5
;;;;		    ADD	    R9
;;;;		    WITH    R8
;;;;		    ADD	    R10
;;;;		    GETC
;;;;		    LOOP
;;;;		    PLOT
;;;;;
;;;;		    BRA	    FLOOR_DOWN_S100+1
;;;;		    IBT	    R12,#8	    ;[ dummy ]
;;;;;
;;;;FLOOR_DOWN_S90
;;;;		    WITH    R7
;;;;		    ADD	    R5
;;;;		    WITH    R5
;;;;		    ADD	    R9
;;;;		    WITH    R8
;;;;		    ADD	    R10
;;;;		    SUB	    R0
;;;;		    COLOUR
;;;;		    LOOP
;;;;		    PLOT
;;;;;
;;;;;-------------- 4.st area -----------------------------------------------
;;;;FLOOR_DOWN_S100
;;;;		    IBT	    R12,#8	    ;(R12) <-- loop no.
;;;;		    MOVE    R13,R15
;;;;FLOOR_DOWN_S110
;;;;		    MERGE
;;;;		    BVS	    FLOOR_DOWN_S120 ;chara data over ? ( yes:FLOOR_DOWN_S120 )
;;;;		    TO	    R14
;;;;;
;;;;		    ADD	    R6
;;;;;
;;;;		    WITH    R7
;;;;		    ADD	    R5
;;;;		    WITH    R5
;;;;		    SUB	    R9
;;;;		    WITH    R8
;;;;		    ADD	    R10
;;;;		    GETC
;;;;		    LOOP
;;;;		    PLOT
;;;;;
;;;;		    BRA	    FLOOR_DOWN_S130+1
;;;;		    IBT	    R0,#48-32	    ;[ dummy ]
;;;;;
;;;;FLOOR_DOWN_S120
;;;;		    WITH    R7
;;;;		    ADD	    R5
;;;;		    WITH    R5
;;;;		    SUB	    R9
;;;;		    WITH    R8
;;;;		    ADD	    R10
;;;;		    SUB	    R0
;;;;		    COLOUR
;;;;		    LOOP
;;;;		    PLOT
;;;;;
;;;;;-------------- 5.st area -----------------------------------------------
;;;;FLOOR_DOWN_S130
;;;;		    IBT	    R0,#48-32
;;;;		    TO	    R12
;;;;		    SUB	    R11
;;;;		    MOVE    R13,R15
;;;;FLOOR_DOWN_S140
;;;;		    MERGE
;;;;		    TO	    R14
;;;;		    ADD	    R6
;;;;;
;;;;		    WITH    R8
;;;;		    ADD	    R10
;;;;		    GETC
;;;;		    LOOP
;;;;		    PLOT
;;;;;
;;;;		    DEC	    R4
;;;;		    BEQ	    FLOOR_DOWN_S150
;;;;		    INC	    R2
;;;;;
;;;;		    LMS	    R0,CWORK0
;;;;		    WITH    R9
;;;;		    SUB	    R0
;;;;		    IWT	    R15,#FLOOR_DOWN_S20+1
;;;;		    MOVE    R1,R3	    ;[ dummy ]
;;;;;
;;;;FLOOR_DOWN_S150
;;;;		    STOP
;;;;		    NOP
;
;************************************************************************
;*		afgłiTCY RQ~PUj			*
;*			 F (R2)  <-- rbg}bvWQx		*
;*				(R3)  <--	 h	  Qw		*
;*				(R6)  <-- {iPOOgPDOj	*
;*				(R11) <-- Jn_			*
;*				(R12) <-- LN^[AhXikCgj*
;*				(R13) <--	  h	       (aj	*
;************************************************************************
;
FLOOR_WAVE	EQU	$
		FROM	R11
		SWAP
		SMS	R0,CWORK0	;(CWK0) <-- Jn_
;
;-------------- ւ݃f[^Zbg --------------------------------------
		IWT	R0,#020H*100H
		TO	R9		;(R9) <-- G power
		FMULT
;
;-------------- ݃[h LN^[AhXZbg -------------
		IBT	R0,#05H		;(R0) <-- color mode initial set
		CMODE			;color mode set
		MOVE	R6,R12		;(R12) <-- LN^[AhXikCgjZbg
;
;-------------- LN^[ ------------------------------------
		FROM	R13
		ROMB			;LN^[AhX (ajset
;
		IBT	R4,#0		;(R4)  <-- Y loop set
		IWT	R10,#0100H	;(R10) <-- chara data pointer step
		IWT	R11,#01F00H	;(R11) <--	"     X pointer AND data
;
		CACHE
;
FLOOR_WAVE_20
		LMS	R8,CWORK0	;(R8) <-- plot start X offset
		MOVE	R7,R4
		IBT	R5,#0		;(R5) <-- initial Y speed
;
;-------------- 2.st area -----------------------------------------------
FLOOR_WAVE_40
		IBT	R12,#8		;(R12) <-- loop no.
		MOVE	R13,R15
FLOOR_WAVE_50
		MERGE
		BVS	FLOOR_WAVE_60	;chara data over ? ( yes:FLOOR_WAVE_60 )
		TO	R14
;
		ADD	R6
;
		WITH	R7
		ADD	R5
		WITH	R5
		SUB	R9
		FROM	R8
		ADD	R10
		AND	R11
		MOVE	R8,R0
		HIB
		TO	R1
		ADD	R3
		GETC
		LOOP
		PLOT
;
		BRA	FLOOR_WAVE_70+1
		IBT	R12,#16		;[ dummy ]
;
FLOOR_WAVE_60
		WITH	R7
		ADD	R5
		WITH	R5
		SUB	R9
		FROM	R8
		ADD	R10
		AND	R11
		MOVE	R8,R0
		HIB
		TO	R1
		ADD	R3
		SUB	R0
		COLOUR
		LOOP
		PLOT
;
;-------------- 3.st area -----------------------------------------------
FLOOR_WAVE_70
		IBT	R12,#16		;(R12) <-- loop no.
		MOVE	R13,R15
FLOOR_WAVE_80
		MERGE
		BVS	FLOOR_WAVE_90	;chara data over ? ( yes:FLOOR_WAVE_90 )
		TO	R14
;
		ADD	R6
;
		WITH	R7
		ADD	R5
		WITH	R5
		ADD	R9
		FROM	R8
		ADD	R10
		AND	R11
		MOVE	R8,R0
		HIB
		TO	R1
		ADD	R3
		GETC
		LOOP
		PLOT
;
		BRA	FLOOR_WAVE_100+1
		IBT	R12,#8		;[ dummy ]
;
FLOOR_WAVE_90
		WITH	R7
		ADD	R5
		WITH	R5
		ADD	R9
		FROM	R8
		ADD	R10
		AND	R11
		MOVE	R8,R0
		HIB
		TO	R1
		ADD	R3
		SUB	R0
		COLOUR
		LOOP
		PLOT
;
;-------------- 4.st area -----------------------------------------------
FLOOR_WAVE_100
		IBT	R12,#8		;(R12) <-- loop no.
		MOVE	R13,R15
FLOOR_WAVE_110
		MERGE
		BVS	FLOOR_WAVE_120	;chara data over ? ( yes:FLOOR_WAVE_120 )
		TO	R14
;
		ADD	R6
;
		WITH	R7
		ADD	R5
		WITH	R5
		SUB	R9
		FROM	R8
		ADD	R10
		AND	R11
		MOVE	R8,R0
		HIB
		TO	R1
		ADD	R3
		GETC
		LOOP
		PLOT
;
		BRA	FLOOR_WAVE_130+1
		FROM	R4
;
FLOOR_WAVE_120
		WITH	R7
		ADD	R5
		WITH	R5
		SUB	R9
		FROM	R8
		ADD	R10
		AND	R11
		MOVE	R8,R0
		HIB
		TO	R1
		ADD	R3
		SUB	R0
		COLOUR
		LOOP
		PLOT
;
FLOOR_WAVE_130
		FROM	R4
		SUB	R11
		BCS	FLOOR_WAVE_150
		INC	R2
;
		WITH	R4
		ADD	R10
		FROM	R2
		AND	#0FH
		BNE	FLOOR_WAVE_140	;Y pos change ? ( no:FLOOR_WAVE_140 )
		NOP
;
		IBT	R0,#10H
		WITH	R2
		SUB	R0
		ADD	R0		;[ IBT R0,#20H ]
		TO	R3
		ADD	R3
FLOOR_WAVE_140
		IWT	R15,#FLOOR_WAVE_20+1
		LMS	R8,CWORK0	;[ dummy ]
;
FLOOR_WAVE_150
		RPIX
;
		STOP
		NOP
;
;************************************************************************
;*		ό`EBhE						*
;*			in  : (R1) <-- ό`f[^mD		*
;*			      (R2) <--	h 	   h			*
;*			      (R6) <--	h 				*
;************************************************************************
WIND_CHANGE	EQU	$
		IBT	R0,#BANK WIND_CHANGE_IN
		ROMB
;
		IWT	R0,#WIND_CHANGE_IN
		WITH	R1
		ADD	R1
		TO	R14
		ADD	R1
		TO	R10
		GETB
		INC	R14
		WITH	R10		;(R10) <-- ό`f[^|C^[
		GETBH
;
		ADD	R2
		TO	R14
		ADD	R2
		GETB
		INC	R14
		GETBH
		MOVE	R11,R0		;(R11) <-- ό`f[^|C^[
;
		IBT	R1,#CWORK0	;(R1)  <-- point data set pointer
		MOVE	R14,R10
;
		CACHE
;
		IBT	R12,#WIND_CHANGE_PNO
		MOVE	R13,R15
WIND_CHANGE_010 EQU	$
		TO	R2		;(R2) <-- ό` X pos
		GETB
		INC	R14
;
		INC	R10
		INC	R10
		TO	R3		;(R3) <-- ό` Y pos
		GETB
;
		MOVE	R14,R11
		INC	R11
		INC	R11
		GETB			;(R0) <-- ό` X pos
		INC	R14
;
		SUB	R2
		LMULT
		WITH	R4
		HIB
		LOB
		SWAP
		OR	R4
		ADD	R2
		TO	R2		;(R2) <-- change X pos
		SWAP
;
		GETB			;(R0) <-- ό` Y pos
;
		SUB	R3
		LMULT
		WITH	R4
		HIB
		LOB
		SWAP
		OR	R4
		ADD	R3		;(R0) <-- change Y pos
		OR	R2
		STW	(R1)		;change X,Y pos set
;
		MOVE	R14,R10
		INC	R1
		LOOP
		INC	R1
;
		DEC	R1
		DEC	R1
		SMS	R1,REG12
		IWT	R15,#WINDPOLY_SET	;[ JMP WINDPOLY_SET ]
		CACHE
;
;------------------------------------------------------------------------
;-		ό`EBhEf[^AhXf[^			-
;------------------------------------------------------------------------
WIND_CHANGE_IN	EQU	$
		WORD	WIND_CHANGE_DT0 ;[0]
		WORD	WIND_CHANGE_DT1 ;[1]
		WORD	WIND_CHANGE_DT2 ;[2]
;
;------------------------------------------------------------------------
;-		ό`EBhEf[^					-
;------------------------------------------------------------------------
WIND_CHANGE_PNO EQU	8
;
WIND_CHANGE_DT0 EQU	$
;			X  Y
		HEX	80,6A	;[0]
		HEX	80,6A	;[1]
		HEX	80,6A	;[2]
		HEX	80,6A	;[3]
		HEX	80,6A	;[4]
		HEX	80,6A	;[5]
		HEX	80,6A	;[6]
		HEX	80,6A	;[7]
;
WIND_CHANGE_DT1 EQU	$
		HEX	80,02	;[0]
		HEX	90,5A	;[1]
		HEX	FF,6A	;[2]
		HEX	90,7A	;[3]
		HEX	80,D1	;[4]
		HEX	70,7A	;[5]
		HEX	00,6A	;[6]
		HEX	70,5A	;[7]
;
WIND_CHANGE_DT2 EQU	$
		HEX	80,02	;[0]
		HEX	FF,02	;[1]
		HEX	FF,6A	;[2]
		HEX	FF,D1	;[3]
		HEX	80,D1	;[4]
		HEX	00,D1	;[5]
		HEX	00,6A	;[6]
		HEX	00,02	;[7]
;;;;K;;;;;
;;;;K;;;;;
;;;;K;;;;;****************************************************************
;;;;K;;;;;*								*
;;;;K;;;;;*	l`qhn`bv eXg vO			*
;;;;K;;;;;*			in					*
;;;;K;;;;;*			R2  <- rbg}bvW x		*
;;;;K;;;;;*			R3  <-	"       "	w		*
;;;;K;;;;;*			R12 <- LN^[AhX(k,g)	*
;;;;K;;;;;*			R13 <-		"          (a)         *
;;;;K;;;;;****************************************************************
;;;;K;;;;TESTCHIP	EQU	$
;;;;K;;;;		SMS	R13,CWORK0
;;;;K;;;;		SMS	R0,CWORK2
;;;;K;;;;;
;;;;K;;;;		IWT	R5,#0007FH	; R7 <- sin data read address
;;;;K;;;;		TO	R7		;
;;;;K;;;;		AND	R5		;	R7 <- R0 and R5
;;;;K;;;;		IWT	R0,#00080H	;
;;;;K;;;;		TO	R7		;
;;;;K;;;;		OR	R7		;	R7 = R0 + R7
;;;;K;;;;		MOVE	R11,R0		; R11 <- #080H
;;;;K;;;;;
;;;;K;;;;		IBT	R0,#05
;;;;K;;;;		CMODE
;;;;K;;;;;
;;;;K;;;;		MOVE	R9,R2
;;;;K;;;;		MOVE	R10,R12
;;;;K;;;;		IWT	R13,#TESTCHIP_200	; loop return address
;;;;K;;;;		IBT	R4,#32			; Y loop count
;;;;K;;;;		IWT	R8,#256
;;;;K;;;;		IBT	R0,#00
;;;;K;;;;		IBT	R6,#08		; a
;;;;K;;;;		IBT	R5,#07FH
;;;;K;;;;;
;;;;K;;;;		CACHE			; LbV X^[g !!
;;;;K;;;;;
;;;;K;;;;TESTCHIP_100
;;;;K;;;;		MOVE	R1,R3
;;;;K;;;;		IBT	R12,#32		; X loop count
;;;;K;;;;;
;;;;K;;;;TESTCHIP_200
;;;;K;;;;		COLOUR			; J[ set
;;;;K;;;;		LOOP
;;;;K;;;;		PLOT
;;;;K;;;;;
;;;;K;;;;		DEC	R4		; set end ?
;;;;K;;;;		BNE	TESTCHIP_100	;	NO -> TESTCHIP_100
;;;;K;;;;		INC	R2
;;;;K;;;;;
;;;;K;;;;;--------------------------------------- LN^[Zbg !!
;;;;K;;;;		MOVE	R2,R9
;;;;K;;;;		IWT	R13,#TESTCHIP_600	; loop return address
;;;;K;;;;		IBT	R9,#32			; Y loop count
;;;;K;;;;;
;;;;K;;;;TESTCHIP_500
;;;;K;;;;		IBT	R0,#BANK LSIN	; X pos set
;;;;K;;;;		ROMB			;
;;;;K;;;;		IWT	R14,#LSIN	; R7 <- sin data read address
;;;;K;;;;		WITH	R14		;
;;;;K;;;;		ADD	R7		;	R14 = R14 + R7
;;;;K;;;;		GETBS			;
;;;;K;;;;		MULT	R6		;	R0 = R0 * R6
;;;;K;;;;		ASR			;
;;;;K;;;;		ASR			;
;;;;K;;;;		ASR			;
;;;;K;;;;		ASR			;
;;;;K;;;;		ASR			;
;;;;K;;;;		ASR			;
;;;;K;;;;		TO	R1		;
;;;;K;;;;		ADD	R3		;	R1 = R0 + R3
;;;;K;;;;		WITH	R7
;;;;K;;;;		ADD	#04		;	R7 = #n + R7
;;;;K;;;;		WITH	R7
;;;;K;;;;		AND	R5		;	R7 <- R7 and R5(07FH)
;;;;K;;;;		WITH	R7
;;;;K;;;;		OR	R11		;	R7 <- R7 or R11(080H)
;;;;K;;;;;
;;;;K;;;;		IBT	R12,#32		; X loop count
;;;;K;;;;		MOVE	R14,R10		; LN^[AhX set
;;;;K;;;;		LMS	R0,CWORK0
;;;;K;;;;		ROMB			; LN^[AhX (a) set
;;;;K;;;;TESTCHIP_600
;;;;K;;;;		GETC			; data read
;;;;K;;;;		INC	R14		; LN^[AhX inc.
;;;;K;;;;		LOOP
;;;;K;;;;		PLOT			; data set  (INC R1)
;;;;K;;;;;
;;;;K;;;;		WITH	R10		; D,S reg <- R10
;;;;K;;;;		ADD	R8		;	R10 = R10 + R8
;;;;K;;;;		DEC	R9		; data set end ?
;;;;K;;;;		BNE	TESTCHIP_500	;	NO -> TESTCHIP_500
;;;;K;;;;		INC	R2
;;;;K;;;;;
;;;;K;;;;		LMS	R0,CWORK2
;;;;K;;;;		INC	R0
;;;;K;;;;;
;;;;K;;;;		STOP
;;;;K;;;;		NOP
;
;
;
;
;
;************************************************************************
;*									*
;*		S[̂n`l̕ύXAWoLN^[Zbg	*
;*			 F (R1)  <-- G̃CfbNX		*
;;;;;*				    (R2)  <-- `[up^[mD	    *
;*				(R3)  <-- S[DX^[gxʒu	*
;*				(R4)  <--      h   pJE^[	*
;*				(R6)  <-- {iPOOgPDOj	*
;*									*
;*			óF	(CWK0) <-- Wôւ񂾍	*
;*				(CWK1) <-- Wôn`l|C^[	*
;*									*
;************************************************************************
;
;;;;;-------------- `[uZbgf[^ ------------------------------------
;;;;GOAL_CBPT	    EQU	    $		    ;[ENWRKA] n`lZbgf[^
;;;;		    HEX	    18,00,AC,00	    ;[0] start pattern.1
;;;;		    HEX	    18,00,AC,00
;;;;		    HEX	    18,08,AC,00
;;;;;
;;;;		    HEX	    18,00,8F,00	    ;[1]       "      .2
;;;;		    HEX	    18,08,9F,00
;;;;		    HEX	    18,08,AC,00
;;;;;
;;;;		    HEX	    18,00,8E,02	    ;[2] normal pattern.1
;;;;		    HEX	    18,00,AC,00
;;;;		    HEX	    18,08,AC,00
;;;;;
;;;;		    HEX	    20,00,8E,02	    ;[3]       "       .2
;;;;		    HEX	    20,00,AC,00
;;;;		    HEX	    20,08,AC,00
;;;;;
;;;;		    HEX	    18,00,8F,00	    ;[4]       "       .3
;;;;		    HEX	    18,08,9F,00
;;;;		    HEX	    28,00,8E,02
;;;;;
;;;;		    HEX	    18,00,8E,02	    ;[5] end pattern.1
;;;;		    HEX	    30,00,8E,00
;;;;		    HEX	    30,08,9E,00
;;;;;
;;;;		    HEX	    20,00,8E,02	    ;[6]      "     .2
;;;;		    HEX	    20,00,AC,00
;;;;		    HEX	    20,08,AC,00
;;;;;
;;;;		    HEX	    18,00,AC,00	    ;[7]      "     .3
;;;;		    HEX	    18,08,AC,00
;;;;		    HEX	    28,00,8E,02
;;;;;;;;;
;;;;;;;;;-------------- S[DZbgf[^ ----------------------------------
;;;;;;;;GOAL_FSYR	EQU	$		;S[Dhhf[^
;;;;;;;;		HEX	01,01,00,00,00,FF,FF,FF
;;;;;;;;		HEX	FF,FF,00,00,00,01,01,01
;;;;;;;;;
;;;;;;;;M_GOAL0		EQU	$
;;;;;;;;;
;;;;;-------------- `[un`lZbg ------------------------------------
;;;;		    IBT	    R0,#BANK GOAL_CBPT
;;;;		    ROMB
;;;;;
;;;;		    mLDW    R5,CENOAML,R1   ;(R5) <-- OAM index
;;;;;
;;;;		    FROM    R2
;;;;		    MULT    #4*3
;;;;		    IWT	    R14,#GOAL_CBPT
;;;;		    TO	    R14		    ;(R14) <-- `[un`lZbgf[^|C^[
;;;;		    ADD	    R14
;;;;;
;;;;		    CACHE
;;;;;
;;;;		    IBT	    R12,#3
;;;;		    MOVE    R13,R15
;;;;M_GOAL0_010
;;;;		    GETB
;;;;		    INC	    R14
;;;;		    TO	    R7
;;;;		    LDW	    (R5)
;;;;		    ADD	    R7
;;;;		    SBK
;;;;		    GETB
;;;;		    INC	    R14
;;;;		    INC	    R5
;;;;		    INC	    R5
;;;;		    TO	    R7
;;;;		    LDW	    (R5)
;;;;		    ADD	    R7
;;;;		    SBK
;;;;		    GETB
;;;;		    INC	    R14
;;;;		    INC	    R5
;;;;		    INC	    R5
;;;;		    STB	    (R5)
;;;;		    GETB
;;;;		    INC	    R14
;;;;		    INC	    R5
;;;;		    INC	    R5
;;;;		    STB	    (R5)
;;;;		    INC	    R5
;;;;		    LOOP
;;;;		    INC	    R5
;;;;;;;;;
;;;;;;;;;-------------- S[Dn`lZbg ----------------------------------
;;;;;;;;		IBT	R0,#BANK GOAL_FSYR
;;;;;;;;		ROMB
;;;;;;;;;
;;;;;;;;		mLDW	R5,CENOAML,R1	;(R5) <-- OAM index
;;;;;;;;		INC	R5		;(R5) <-- OAM Y pos index
;;;;;;;;		INC	R5
;;;;;;;;;
;;;;;;;;		IBT	R7,#080H	;(R7)  <-- n`lNA[wW
;;;;;;;;		IWT	R8,#GOAL_FSYR	;(R8)  <-- S[Dhhf[^|C^[
;;;;;;;;		IBT	R9,#020H	;(R9)  <-- D̂xʒuZf[^
;;;;;;;;		IBT	R10,#030H	;(R10) <-- ԉ̕D̂xʒu
;;;;;;;;;
;;;;;;;;		CACHE
;;;;;;;;;
;;;;;;;;		IBT	R12,#8
;;;;;;;;		MOVE	R13,R15
;;;;;;;;M_GOAL0_020
;;;;;;;;		FROM	R10
;;;;;;;;		SUB	R3
;;;;;;;;		BCS	M_GOAL0_030	;OAM set ? ( yes:M_GOAL0_030 )
;;;;;;;;		FROM	R8
;;;;;;;;;
;;;;;;;;;-------------- S[DII --------------------------------------
;;;;;;;;		FROM	R7
;;;;;;;;		STW	(R5)
;;;;;;;;		BRA	M_GOAL0_040+1
;;;;;;;;		FROM	R4
;;;;;;;;;
;;;;;;;;;-------------- S[DhhZbg ----------------------------
;;;;;;;;M_GOAL0_030
;;;;;;;;		TO	R14		;(R14) <-- S[Dhhf[^|C^[
;;;;;;;;		ADD	R4
;;;;;;;;;
;;;;;;;;		TO	R11
;;;;;;;;		LDW	(R5)
;;;;;;;;		GETBS
;;;;;;;;		ADD	R11
;;;;;;;;		SUB	R10
;;;;;;;;		SBK
;;;;;;;;;
;;;;;;;;M_GOAL0_040
;;;;;;;;		FROM	R4
;;;;;;;;		ADD	#5
;;;;;;;;		TO	R4
;;;;;;;;		AND	#0FH
;;;;;;;;		WITH	R5
;;;;;;;;		ADD	#8
;;;;;;;;		WITH	R10
;;;;;;;;		ADD	R9
;;;;;;;;		LOOP
;;;;;;;;		FROM	R10		;[ dummy ]
;
;-------------- Wȍ̑Ɩڂ̂xW̕ύX ----------------------
M_GOAL1		EQU	$
		IBT	R0,#020H	;(R0) <-- Wo̍
		TO	R2		;(R2) <-- Wo̍~POOg
		SWAP
		WITH	R2		;(R2) <-- WǒvZ̍
		FMULT
		TO	R2		;(R2) <-- Wôւ񂾍
		SUB	R2
		SMS	R2,CWORK0	;(CWK0) <--	    "
;
		IBT	R4,#8		;(R4) <-- OAM index add data
;
		CACHE
;
		IBT	R12,#4
		MOVE	R13,R15
M_GOAL0_050
		LDW	(R5)
		ADD	R2		;Y pos change !!
		WITH	R5
		ADD	R4
		LOOP
		SBK
;
		IBT	R0,#8*4-2
		ADD	R5
		SMS	R0,CWORK1	;(CWK1) <-- Wôn`l|C^[
;
		STOP
		NOP
;
;************************************************************************
;*									*
;*		R[XC^CgEBhE				*
;*			in  : (R1) <-- EBhE			*
;*									*
;************************************************************************
;
WAVE_SIZE	EQU	020H		;g`R{
;
CORSIN_WIND	EQU	$
		IBT	R0,#BANK LCOS
		ROMB
;
		IBT	R0,#(WAVE_SIZE*040H)/100H
		WITH	R1		;(R1) <-- EBhE␳
		SUB	R0
;
		IBT	R2,#04H		;(R2) <-- g`^e{
		IBT	R3,#WAVE_SIZE	;(R3) <-- g`R{
		IWT	R4,#00FFH	;(R4) <-- EőʒuSEBhEf[^
		IWT	R5,#0FF00H	;(R5) <-- SJEBhEf[^
		IWT	R6,#WINDBF	;(R6) <-- EBhEobt@|C^[
		IBT	R7,#4		;(R7) <--	     h		     [Zf[^
		IWT	R8,#LCOS	;(R8) <-- g`f[^AhX
		IBT	R9,#00		;(R9) <--     h    |C^[
;
		MOVE	R14,R8
		GETB			;ŏ̔g`f[^ǂݍ
;
		CACHE
;
		IWT	R12,#0D2H
		MOVE	R13,R15
CORSIN_WIND_010
		WITH	R9
		ADD	R2
		WITH	R9
		LOB
		TO	R14
		FROM	R8
		ADD	R9
;
		MULT	R3
		SWAP
		SEX
		TO	R11
		ADD	R1
		BMI	CORSIN_WIND_020 ;SEBhEH ( yes:CORSIN_WIND_020 )
		FROM	R4
;
		SUB	R11
		BCC	CORSIN_WIND_020 ;EőʒuI[o[H ( yes:CORSIN_WIND_020 )
		FROM	R5
;
		FROM	R11
		SWAP
;
CORSIN_WIND_020
		STW	(R6)
		WITH	R6
		ADD	R7
;
		LOOP
		GETB
;
		STOP
		NOP
;
;
;****************************************************************
;*								*
;*	~ EBhE eXg vO				*
;*			in					*
;*			R0 <- EBhE f[^ AhX (B)	*
;*			R4 <-	"       "	"        (L,H)  *
;*			R1 <- S w W			*
;*			R2 <-	"  x W                      *
;*			R3 <- a				*
;****************************************************************
;;;;TESTCHIP	    EQU	    $
		FROM	R3		; ̔gX aZbg
		ASR
		AND	#00FH
		SWAP
		ASR
		ASR
		ASR
		TO	R11
		ASR
;
		FROM	R3
		ASR
		ASR
		ASR
		ASR
		TO	R5
		AND	#00FH		;	R5 <- R0 and #00f
		IBT	R0,#00DH
		SUB	R5		;	R0 = R0 - R5
		SMS	R0,CWORK0
;
		MOVE	R12,R3
		FROM	R2		; R5 <- q`lAhX Zbg
		SUB	R12		;	R0 = R0 + R12
		ADD	R0		;	R0 = R0 + R0
		IWT	R5,#WINDBF
		TO	R5
		ADD	R5		;	R5 = R0 + R5
		SMS	R5,CWORK1
		SMS	R3,CWORK2
;
		IBT	R7,#00		; R7 <- window data pointer
		IBT	R6,#00
		IWT	R10,#00FFH	; R10 <- E~bg f[^
;
		CACHE
;
		WITH	R12
		ADD	R12		;	R12 = R12 + R12
		MOVES	R8,R3		; a = 0 ?
		BNE	TEST_WIND_090	;  YES -> TEST_WIND_090
		NOP
		IWT	R15,#TEST_WIND_900
		NOP
;
;--------------- ~ EBhE Zbg ---------------------------
TEST_WIND_090
		IWT	R3,#DIVBUF     ; R3 <- Z f[^ AhX Zbg
		FROM	R12
		ADD	R3		;	R0 = R3 + R12
		TO	R3
		LDW	(R0)		; R3 <- read data step
;
		IWT	R13,#TEST_WIND_100
;
TEST_WIND_100
		IBT	R0,#01		; CIRCLE_W data bank address
		ROMB
		FROM	R7
		TO	R14
		ADD	R4		;	R14 = R7 + R4
		GETB			; data read
		UMULT	R8		;	R0 = R0(low 8bit) * R8(low 8bit)
		TO	R9
		HIB			; R9 <- R0(high)
;
		IBT	R0,#BANK LSIN
		ROMB
		IWT	R14,#LSIN	; R7 <- sin data read address
		WITH	R14
		ADD	R11		;	R14 = R14 + R11
		GETBS
		MULT	#0AH		;	R0 = R0 * #0a
		ASR			;
		ASR			;
		ASR			;
		ASR			;
		ASR			;
		TO	R2		;
		ASR			;
;
;--------------------------------------- ~f[^ Zbg !!
		FROM	R1
		SUB	R9		;	R0 = R1 - R9
		ADD	R2		;	R0 = R0 + R2
		BPL	TEST_WIND_120	; ~bg I[o[ ?
		NOP			;	NO -> TEST_WIND_120
;
		SUB	R0		; R0 <- #00
TEST_WIND_120				;  f[^ Zbg
		STB	(R5)		; R0 -> (R5)
		INC	R5
;
		FROM	R1
		ADD	R9		;	R0 = R14 + R9
		ADD	R2		;	R0 = R0 - R2
		SUB	R10		; E~bg I[o[ ?
		BMI	TEST_WIND_130	;	NO -> TEST_WIND_130
		ADD	R10
		FROM	R10		; max data set
TEST_WIND_130				; E f[^ Zbg
		STB	(R5)		; R0 -> (R5)
;
		WITH	R6		; ~ data read index inc.
		ADD	R3		;	R6 = R6 + R3
		FROM	R6
		HIB
		TO	R7
		ADD	R7		;	R7 = R0 + R7
		IWT	R0,#001FFH
		TO	R7
		AND	R7		; R7 <- R0(01FFH) and R7
;
		LMS	R2,CWORK0
		WITH	R11		;  Zbg
		ADD	R2		;	R11 = R2 + R11
		WITH	R11
		AND	R10		;	R11 <- R11 and R10(00FFH)
		WITH	R6
		AND	R10		;	R6 <- R6 and R10
;
		WITH	R5		; buffer next address set
		ADD	#03		;	R5 = R5 + #03
		IWT	R0,#WINDBF+348H-4	; R0 <- center window buffer address (down)
		SUB	R5		;	R0 - R5 = R0
		BCS	TEST_WIND_180	;  buffer down size over ?
		NOP			;	NO -> TEST_WIND_180
;
		IWT	R5,#WINDBF+348H-4	; R5 <- center window buffer address (down)
TEST_WIND_180
		LOOP
		NOP
;
		LMS	R6,CWORK1	; n_ AhX
		LMS	R1,CWORK2	; a
		FROM	R1
		ASR
		ASR
		ASR
		TO	R12
		ASR
		FROM	R1
		ADD	R0		;	R0 = R1 + R0
		IWT	R14,#LSIN
		TO	R14
		ADD	R14		;	R14 = R0 + R14
		GETBS
		MULT	R12
		ASR
		ASR
		ASR
		BPL	TEST_WIND_200
		ASR
		NOT			; rbg]
;
TEST_WIND_200
		MOVES	R12,R0
		BEQ	TEST_WIND_900
		NOP
		IWT	R13,#TEST_WIND_250
		IWT	R0,#000FFH
		IBT	R3,#04
TEST_WIND_250
		STW	(R5)		; R0 -> (R5)
		STW	(R6)		; R0 -> (R6)
		WITH	R5
		SUB	R3		;	R5 = R5 + #04
		WITH	R6
		ADD	R3		;	R6 = R6 + #04
		LOOP
		NOP
;
TEST_WIND_900
		STOP
		NOP
;
;
;
;************************************************************************
;*		LN^[gAkiTCY PQW~PQWj		*
;*				      iGA US~USj		*
;*			 F (R6)  <-- {iPOOgPDOj	*
;*				(R10) <-- LN^[AhXikCgj*
;*				(R11) <--	  h	       (aj	*
;*			o F (R4)  <-- Y[TCYt~POOg	*
;************************************************************************
;
C_128_ZOOM_64	EQU	$
		IWT	R1,#WOB7CHR
		SUB	R0
;
		CACHE
;
		IWT	R12,#2000H/2
		MOVE	R13,R15
C_128_ZOOM64_00 EQU	$
		STW	(R1)
		INC	R1
		LOOP
		INC	R1
;
;------------------------------------------------------------------------
;-		Z							-
;------------------------------------------------------------------------
		IBT	R4,#32		;(R4) <-- 폜
		SUB	R0		;(R0) <-- AL[^NA
		MOVE	R7,R0		;(R7) <-- NA
;
		IBT	R12,#32
		IWT	R13,#C_128_ZOOM64_10+1
C_128_ZOOM64_10
		WITH	R7		;փVtg
		ADD	R7
		WITH	R4		;폜փVtg
		ADD	R4
		ROL			;폜AL[^ɃVtg
		SUB	R6		;AL[^Ər
		BCC	C_128_ZOOM64_20 ;AL[^ł΁AZȗ
		ADD	R6
;
		SUB	R6		;AL[^珜
		INC	R7		;ɂP
C_128_ZOOM64_20
		LOOP
		WITH	R7		;(R7) <-- vbgX^[gʒu
;
;-------------- vbgX^[gWvZ --------------------------------
		IWT	R0,#64*100H
		SUB	R7
		TO	R3		;(R3) <-- vbgX^[gwW
		HIB
		MOVE	R2,R3		;(R2) <-- vbgX^[gxW
;
;-------------- Y[TCYtZbg ----------------------------------
		FROM	R7
		ADD	R7		;x2
		HIB
		TO	R4		;(R4) <-- Y[TCYt
		MULT	R0
;
;-------------- LN^[X^[g|C^[vZ ----------------------
		WITH	R7		;(R7) <-- LN^[f[^x|C^[
		LOB
		MOVE	R9,R7		;(R9) <-- LN^[f[^w|C^[
;
;-------------- ݃[h LN^[AhXZbg -------------
		IBT	R1,#01H		;(R1) <-- color mode initial set
		MOVE	R0,R10
		LSR			;(C) <-- color mode
		BCC	C_128_ZOOM64_30 ;hight bit color ? ( no:C_128_ZOOM64_30 )
		ADD	R0
;
		WITH	R1
		OR	#04H
C_128_ZOOM64_30
		FROM	R1
		CMODE			;color mode set
		MOVE	R10,R0		;(R10) <-- LN^[AhXikCgjZbg
;
;-------------- LN^[ ------------------------------------
		FROM	R11
		ROMB			;LN^[AhX (ajset
;
C_128_ZOOM64_40
		MOVE	R1,R3		;(R1) <-- plot start X pos set
		MOVE	R8,R9		;(R8) <-- PX
;
		MERGE
		BVS	C_128_ZOOM64_60 ;area over ? ( yes:C_128_ZOOM64_60 )
		TO	R14
;
C_128_ZOOM64_50
		ADD	R10
;
		WITH	R8
		ADD	R6
		GETC			;color set
		PLOT
;
		MERGE
		BVC	C_128_ZOOM64_50 ;area over ? ( no:C_128_ZOOM64_50 )
		TO	R14
;
		WITH	R7
		ADD	R6
		BRA	C_128_ZOOM64_40
		INC	R2		;Y pos +1
;
C_128_ZOOM64_60
		RPIX
;
		STOP
		NOP
;
;************************************************************************
;*									*
;*		~[WJfpn`lTCY̕ύX[`		*
;*									*
;************************************************************************
DM01_OAM_SIZE	EQU	$
		IWT	R1,#COAM_DX+5	;(R1) <-- n`lLmDigj̃|C^[
		IBT	R2,#8-1		;(R2) <-- n`lZf[^
		IBT	R3,#01H		;(R3) <-- n`lLmDigj`FbNpf[^
;
		CACHE
;
		IWT	R12,#128	;n`lő吔
		MOVE	R13,R15
DM01_OAM_SZ_10
		LDB	(R1)
		AND	R3
		BNE	DM01_OAM_SZ_20
		INC	R1
;
		SUB	R0
		STB	(R1)
DM01_OAM_SZ_20
		WITH	R1
		ADD	R2
		LOOP
		NOP
;
		STOP
		NOP
;
;
;****************************************************************
;*								*
;*		I[vjO f	()		*
;*				in				*
;*				R2 <-- window 1  px	*
;*				R3 <-- window 1 E px	*
;*				R4 <-- window 2  px	*
;*				R5 <-- window 2 E px	*
;*				R6 <-- window 1 start point	*
;*				R7 <-- window 1 start Epoint	*
;*				R8 <-- window 2 start point	*
;*				R9 <-- window 2 start Epoint	*
;*				R10 <- XN[ JE^[	*
;****************************************************************
OPDM_WINDOW	EQU	$
		IWT	R11,#HDMABF
		IBT	R12,#070H
		IWT	R13,#OPDM_WINDOW_010
		IWT	R14,#00100H
;
		CACHE			; LbV X^[g!!
;
OPDM_WINDOW_010
		FROM	R6		; EBhDP  Zbg
		HIB
		SUB	R10
		TO	R1
		AND	R14
		BEQ	OPDM_WINDOW_011
		NOP
		IBT	R0,#000
OPDM_WINDOW_011
		STB	(R11)
		INC	R11
;
		FROM	R7		; EBhDP E Zbg
		HIB
		SUB	R10
		TO	R1
		AND	R14
		BEQ	OPDM_WINDOW_012
		NOP
		IBT	R0,#000
OPDM_WINDOW_012
		STB	(R11)
		INC	R11
;
		FROM	R8		; EBhDQ  Zbg
		HIB
		SUB	R10
		TO	R1
		AND	R14
		BEQ	OPDM_WINDOW_013
		NOP
		IBT	R0,#000
OPDM_WINDOW_013
		STB	(R11)
		INC	R11
;
		FROM	R9		; EBhDQ E Zbg
		HIB
		SUB	R10
		TO	R1
		AND	R14
		BEQ	OPDM_WINDOW_014
		NOP
		IBT	R0,#000
OPDM_WINDOW_014
		STB	(R11)
		INC	R11
;
		WITH	R6
		ADD	R2
		BCC	OPDM_WINDOW_020
		NOP
		IWT	R6,#0FF00H
;
OPDM_WINDOW_020
		WITH	R7
		ADD	R3
		BCC	OPDM_WINDOW_030
		NOP
		IWT	R7,#0FF00H
;
OPDM_WINDOW_030
		WITH	R8
		ADD	R4
		BCC	OPDM_WINDOW_040
		NOP
		IWT	R8,#0FF00H
;
OPDM_WINDOW_040
		WITH	R9
		ADD	R5
		BCC	OPDM_WINDOW_050
		NOP
		IWT	R9,#0FF00H
;
OPDM_WINDOW_050
		LOOP
		NOP
;
		STOP
		NOP
;
;
;************************************************************************
;*									*
;*		kLJ[ Of[V obt@Zbg		*
;*			in :						*
;*				(R0) <-- J[p^[AhX(B)	*
;*				(R1) <--	   h	       (L,H)	*
;*									*
;*			out :						*
;*				(WOB7CHR) <-- Of[VJ[	*
;*									*
;************************************************************************
;;;;NUKCOL_BF_NO    EQU	    (724H/8)+0B2H
NUKCOL_BF_NO	EQU	(724H/8)+0D2H
;
GRADATION_SET	EQU	$
		ROMB			;J[p^[AhX(B) set
		MOVE	R14,R1		;	    h	       (L,H) set
;
;-------------- Of[VJ[Zbg ------------------------------
		GETB			;(R0) <-- ԏ̃J[
		INC	R14
		GETBH
		INC	R14
;
		IBT	R10,#01FH	;(R10) <-- J[qEfEaf[^
;
		TO	R3		;(R3) <-- ̂q
		AND	R10
		LSR
		LSR
		LSR
		LSR
		LSR
		TO	R4		;(R4) <-- ̂f
		AND	R10
		LSR
		LSR
		LSR
		LSR
		LSR
		TO	R5		;(R5) <-- ̂a
		AND	R10
;
		IWT	R1,#WOB7CHR+NUKCOL_BF_NO*3-1 ;(R1) <-- J[obt@|C^[iqEfj
		IWT	R2,#WOB7CHR+NUKCOL_BF_NO-1   ;(R2) <--		 h	       iaj
		IWT	R13,#GRADATION_ST_30
		IBT	R11,#24-1	;(R11) <-- J[f[^
;
		CACHE
;
GRADATION_ST_20
		GETB
		INC	R14
		MOVE	R6,R0
;
		IBT	R10,#01FH	 ;(R10) <-- J[qEfEaf[^
		AND	R10
		SUB	R3
		LOB
		TO	R7		;(R7) <-- ̂q܂ł̍
		SWAP
;
		WITH	R6
		GETBH
		INC	R14
;
		FROM	R6
		LSR
		LSR
		LSR
		LSR
		LSR
		AND	R10
		SUB	R4
		LOB
		TO	R8		;(R8) <-- ̂f܂ł̍
		SWAP
;
		FROM	R6
		SWAP
		LSR
		LSR
		AND	R10
		SUB	R5
		LOB
		TO	R9		;(R9) <-- ̂a܂ł̍
		SWAP
;
		IBT	R6,#00		;(R6)  <-- {
		IBT	R12,#010H	;(R12) <-- Of[VvZ
GRADATION_ST_30
		FROM	R7
		FMULT
		ADD	R3
		IBT	R10,#00100000B
		OR	R10
		STB	(R1)
		DEC	R1
;
		FROM	R8
		FMULT
		ADD	R4
		IBT	R10,#01000000B
		OR	R10
		STB	(R1)
		DEC	R1
;
		FROM	R9
		FMULT
		ADD	R5
		IBT	R10,#10000000B
		OR	R10
		STB	(R2)
;
		IBT	R0,#0100H/010H
		TO	R6
		ADD	R6
;
		LOOP
		DEC	R2
;
		FROM	R7
		SWAP
		TO	R3	;(R3) <-- ̂q
		ADD	R3
		FROM	R8
		SWAP
		TO	R4	;(R4) <-- ̂f
		ADD	R4
		FROM	R9
		SWAP
		TO	R5	;(R5) <-- ̂a
		ADD	R5
;
		DEC	R11
		BNE	GRADATION_ST_20+1
		GETB			;[ dummy ]
;
;-------------- [vp̃GAZbg ----------------------------------
		IBT	R0,#00100000B
		TO	R3
		OR	R3
		IBT	R0,#01000000B
		TO	R4
		OR	R4
		IBT	R0,#10000000B
		OR	R5
;
		IWT	R12,#NUKCOL_BF_NO-(10H*(24-1))
		MOVE	R13,R15
GRADATION_ST_10
		FROM	R3
		STB	(R1)
		DEC	R1
		FROM	R4
		STB	(R1)
		DEC	R1
		STB	(R2)
		LOOP
		DEC	R2
;
		STOP
		NOP
;
;************************************************************************
;*									*
;*		winain`lZbg					*
;*			in :						*
;*				(R1)  <-- \_w			*
;*				(R2)  <--    h	  x			*
;*				(R3)  <-- ~bgw			*
;*				(R4)  <--     h  x			*
;*				(R0)  <-- winaif[^AhX	*
;*				(R13) <--	     h			*
;*				(R10) <-- n`lZbg|C^[	*
;*				(R11) <-- LN^[mDZf[^	*
;*									*
;************************************************************************
;
BG_OBJ_OAMST	EQU	$
		ROMB
;
		IBT	R5,#0		;(R5) <-- w\ʒu
;;;;		    IWT	    R7,#0B2H+0FH    ;(R7) <-- x\`FbNpf[^
		IWT	R7,#0D2H+0FH	;(R7) <-- x\`FbNpf[^
;
		CACHE
;
		IBT	R6,#16+1	;[v
BG_OBJ_OAMST_10
		FROM	R2
		SUB	R4
		BCC	BG_OBJ_OAMST_20 ;~bgxI[o[H ( no:BG_OBJ_OAMST_20 )
		NOP
;
		MOVE	R2,R0
		BRA	BG_OBJ_OAMST_10+1
		FROM	R2
;
BG_OBJ_OAMST_20
		MOVE	R14,R13
;
BG_OBJ_OAMST_22
		FROM	R1
		SUB	R3
		BCC	BG_OBJ_OAMST_30 ;~bgwI[o[H ( no:BG_OBJ_OAMST_30 )
		NOP
;
		MOVE	R1,R0
		BRA	BG_OBJ_OAMST_22+1
		FROM	R1
;
BG_OBJ_OAMST_30
		GETB			;(R0) <-- ATT+size
		INC	R14
;
		MOVE	R8,R0		;(R8) <-- ATT+size
		SEX
		INC	R0		;[ CMP #0FFFFH ]
		BEQ	BG_OBJ_OAMST_80 ;f[^dmcH ( yes:BG_OBJ_OAMST_80 )
		FROM	R8
;
		BIC	#01H		;[ AND #0FFFEH ]
		SUB	R8
		BEQ	BG_OBJ_OAMST_40 ;TCYH ( no:BG_OBJ_OAMST_40 )
		SUB	R0
;
		INC	R0		;[ IBT R0,#01H ]
BG_OBJ_OAMST_40
		INC	R0
		TO	R9		;(R9) <-- TCYiWAPUj
		MULT	#8
;
		GETB			;(R0) <-- X pos
		INC	R14
;
		MULT	#8
		SUB	R1
		BEQ	BG_OBJ_OAMST_45 ;w\H ( yes:BG_OBJ_OAMST_45 )
		NOP
;
		BPL	BG_OBJ_OAMST_60 ;w\H ( no:BG_OBJ_OAMST_60 )
		ADD	R9
;
		BMI	BG_OBJ_OAMST_60 ;w\H ( no:BG_OBJ_OAMST_60 )
		SUB	R9
;
BG_OBJ_OAMST_45
		TO	R12		;(R12) <-- w\ʒu
		ADD	R5
;
		GETB			;(R0) <-- Y pos
		INC	R14
;
		MULT	#8
		SUB	R2
		ADD	#0FH
		BPL	BG_OBJ_OAMST_50 ;x~bgI[o[H ( no:BG_OBJ_OAMST_50 )
		NOP
;
		ADD	R4
BG_OBJ_OAMST_50
		SUB	R7
		BPL	BG_OBJ_OAMST_70 ;x\H ( no:BG_OBJ_OAMST_70 )
		ADD	R7
;
		SUB	#0FH		;(R0) <-- x\ʒu
;
;-------------- n`lZbg --------------------------------------------
		FROM	R12
		STW	(R10)		;wZbg
		INC	R10
		INC	R10
;
		STW	(R10)		;xZbg
		INC	R10
		INC	R10
;
		FROM	R8
		BIC	#01H		;[ AND #0FFFEH ]
		SWAP
;
		GETBL			;(R0) <-- LmD
		INC	R14
;
		ADD	R11		;LmDZ
		STW	(R10)		;LmDZbg
		INC	R10
		INC	R10
;
		FROM	R8
		AND	#01H
		ADD	R0
		IWT	R12,#04000H	;n`lDŉʂ
		OR	R12
		STW	(R10)		;TCYAtOZbg
		INC	R10
		BRA	BG_OBJ_OAMST_30
		INC	R10
;
BG_OBJ_OAMST_60
		INC	R14
BG_OBJ_OAMST_70
		BRA	BG_OBJ_OAMST_30
		INC	R14
;
BG_OBJ_OAMST_80
		IBT	R0,#010H
		TO	R1
		ADD	R1
		TO	R5
		ADD	R5
;
		DEC	R6
		BNE	BG_OBJ_OAMST_20+1
		MOVE	R14,R13		;[ dummy ]
;
		STOP
		NOP
;
;************************************************************************
;*									*
;*		J{XpafR̃X^[Zbg			*
;*			in :						*
;*				(R1)  <-- XN[JE^[		*
;*				(R2)  <-- X^[f[^|C^[	*
;*				(R3)  <--     h  			*
;*				(R4)  <--     h  U		*
;*				(R5)  <--     "   XΗiP1Ogj   *
;*				(R6)  <-- g|cl`obt@|C^[	*
;*				(R7)  <--	 h	    Zf[^	*
;*				(R12) <-- obt@ZbgC	*
;*									*
;************************************************************************
;
RASTER_SET	EQU	$
		IBT	R7,#2		;(R7)  <-- g|cl`obt@Zf[^
;;;;		    IWT	    R12,#0B2H	    ;(R12) <-- obt@ZbgC
		IWT	R12,#0D2H	;(R12) <-- obt@ZbgC
;
RASTER_SET_2	EQU	$
		IBT	R0,#BANK LCOS
		ROMB
;
		IBT	R10,#0		;(R10) <-- XΌvZpobt@
		IWT	R11,#LCOS	;(R11) <-- X^[f[^AhX
;
		CACHE
;
		IWT	R13,#RASTER_SET_010+1
RASTER_SET_010
		FROM	R2
		LOB
		TO	R14
		ADD	R11
;
		WITH	R2		;̂gX^[f[^|C^[Zbg
		ADD	R3
		WITH	R10		;XΌvZ
		ADD	R5
		FROM	R10
		DIV2
		DIV2
		DIV2
		TO	R9		;(R9) <-- XΕ
		DIV2
;
		GETB
;
		MULT	R4
		ADD	R0
		ADD	R0
		HIB
		SEX
		ADD	R1
		ADD	R9
		STW	(R6)
;
		WITH	R6
		ADD	R7
;
		LOOP
		FROM	R2
;
		STOP
		NOP
;
;************************************************************************
;*									*
;*		GЂԂ锚ʂn`lZbg			*
;*			in :						*
;*				(R1)  <-- \wW			*
;*				(R2)  <--   hx h			*
;*				(R0)  <-- n`lZbgʒuf[^AhX*
;*				(R14) <--	       h		*
;*				(R10) <-- n`lZbg|C^[	*
;*									*
;************************************************************************
;
BOMB_OAMST	EQU	$
		ROMB
		MOVE	R14,R14
;
		CACHE
;
;-------------- ]Ln`lf[^Rs[ ----------------------------
		FROM	R10
		TO	R3		;(R3) <-- Rs[n`lZbg|C^[
		ADD	#4
		IBT	R0,#4*8
		TO	R4		;(R4) <-- Rs[n`lZbg|C^[
		ADD	R3
		IBT	R11,#3
		IWT	R13,#BOMB_OAMST_020
BOMB_OAMST_010
		MOVE	R5,R3
		IBT	R12,#4
BOMB_OAMST_020
		LDW	(R5)
		STW	(R4)
		INC	R5
		INC	R5
		INC	R4
		INC	R4
		LDW	(R5)
		STW	(R4)
		WITH	R5
		ADD	#8-2
		WITH	R4
		ADD	#8-2
		LOOP
		NOP
;
		DEC	R11
		BNE	BOMB_OAMST_010
		NOP
;
;-------------- n`lZbgʒuZbg ----------------------------------
		IWT	R12,#4*4
		MOVE	R13,R15
BOMB_OAMST_030
		GETBS
		INC	R14
		ADD	R1
		STW	(R10)	;\wWZbg
		INC	R10
		INC	R10
;
		GETBS
		INC	R14
		ADD	R2
		STW	(R10)	;\xWZbg
		INC	R10
		INC	R10
		INC	R10
;
		TO	R3
		LDB	(R10)
		GETB
		INC	R14
		OR	R3
		STB	(R10)	;gCutbvZbg
		INC	R10
		INC	R10
		LOOP
		INC	R10
;
		STOP
		NOP
;
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		M_SM0SET	( ~jQ[@C̉Zbg )	x
;x									x
;x		initial R1 <-- wa					x
;x			R2 <-- xa					x
;x			R3 <-- n`lAhX				x
;x			R4 <-- px					x
;x			R5 <-- wW					x
;x			R6 <-- xW					x
;x									x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
M_SM0SET	EQU	$
		IWT	R7,#01999H	; R5 <-- ̊px
		IBT	R8,#000H
		IBT	R12,#010	; R12 <-- [v
;
		CACHE
		MOVE	R13,R15
;
M_SM0SET_050
		IBT	R0,#BANK LCOS	; R0 <-- kbnrf[^[AhXoNZbg
		ROMB
;
		FROM	R8
		TO	R11
		HIB
;
		IWT	R0,#LCOS
		TO	R14
		ADD	R11		; R14 <-- bnrf[^[Zbg
		GETB
		MULT	R1		; R1 <-- wWZbg
		TO	R9
		HIB
;
		IWT	R0,#LSIN
		TO	R14
		ADD	R11
		GETB
		MULT	R2
		TO	R10
		HIB
;
		IWT	R0,#LCOS
		TO	R14
		ADD	R4
		GETB
		MULT	R9
		ASR
		ASR
		ASR
		ASR
		ASR
		ASR
		ASR
		TO	R11
		ASR
;
		IWT	R0,#LSIN
		TO	R14
		ADD	R4
		GETB
		MULT	R10
		ASR
		ASR
		ASR
		ASR
		ASR
		ASR
		ASR
		ASR
		ADD	R11
		LM	R11,CESCCH1
		ADD	R11
		NOT
		INC	R0
		ADD	R5
		STW	(R3)		; (R3) <-- n`l@wWZbg
		INC	R3
		INC	R3
;
		IWT	R0,#LSIN
		TO	R14
		ADD	R4
		GETB
		MULT	R9
		ASR
		ASR
		ASR
		ASR
		ASR
		ASR
		ASR
		TO	R11
		ASR
;
		IWT	R0,#LCOS
		TO	R14
		ADD	R4
		GETB
		MULT	R10
		ASR
		ASR
		ASR
		ASR
		ASR
		ASR
		ASR
		ASR
		SUB	R11
		LM	R11,CESCCV1
		ADD	R11
		ADD	R6
		STW	(R3)		; (R3) <-- n`l@xWZbg
		WITH	R3
		ADD	#6
		WITH	R8
		ADD	R7		; R8 <-- ̃|C^[Zbg
		LOOP
		NOP
;
		STOP
		NOP
;
;
;----------------------------------------------------------------
;-	SC							-
;-		(R1) <- ENCHPT					-
;-		(R2) <- (̒)				-
;-		(R3) <- (̃|WVf[^AhX)		-
;-		(R4) <- (	 "           oN)            -
;----------------------------------------------------------------
TEPPOUGYOC	EQU	$
		BYTE	008H,000H	;[00]
		HEX	02,04,02
		BYTE	0F8H,000H
		HEX	00,04,02
		BYTE	0F8H,000H
		HEX	00,04,00
;
		BYTE	0F9H,000H	;[01]
		HEX	04,04,02
		BYTE	009H,000H
		HEX	02,04,02
		BYTE	009H,000H
		HEX	02,04,00
;
		BYTE	0F5H,000H	;[02]
		HEX	06,04,02
		BYTE	0F7H,000H
		HEX	00,04,02
		BYTE	007H,000H
		HEX	02,04,02
;
;
TEPPOUGYOOAM	EQU	$
		IBT	R0,#BANK TEPPOUGYOC
		ROMB
		SMS	CWORK0,R1
		SMS	CWORK1,R2
		SMS	CWORK2,R3
		SMS	CWORK3,R4
		FROM	R1
		TO	R2
		UMULT	#15
		IWT	R0,#TEPPOUGYOC
		TO	R14
		ADD	R2
		LM	R2,CENINDX
		mLDB	R1,CENCHRB,R2
		WITH	R1
		UMULT	#8
		mLDW	R3,CENOAML,R2
		mLDW	R4,CENMUKI,R2
		FROM	R4
		SWAP
		ADD	R0
		ADD	R0
		ADD	R0
		ADD	R0
		ADD	R0
		SMS	CWORK4,R0		; H tbvZ[u !!
		mLDW	R5,CENDSXL,R2
		mLDW	R6,CENDSYL,R2
		mLDW	R7,CENCLOR,R2
		WITH	R7
		SWAP
;
		CACHE
;
		IBT	R12,#03
		MOVE	R13,R15
TPOGOAM0000
		GETBS
		INC	R14
		DEC	R4
		BMI	TPOGOAM0040		; E ? [no->TPOGOAM0040]
		INC	R4
;
		NOT
		INC	R0
TPOGOAM0040
		TO	R8
		ADD	R5			; (R8) <- X |WV
		GETBS
		INC	R14
		TO	R9
		ADD	R6			; (R9) <- Y |WV
		GETB
		INC	R14
		GETBH
		INC	R14
		ADD	R1
		TO	R10
		XOR	R7			; (R10) <- LN^[io[Agr[g
		LMS	R0,CWORK4		; H tbv񃍁[h !!
		TO	R10
		XOR	R10			; (R10) <- LN^[io[Agr[g
		TO	R11
		GETB				; (R11) <- OAM SUB
		INC	R14
		DEC	R11
		BPL	TPOGOAM0080		; LN^[ [no->TPOGOAM0080]
		INC	R11
;
		DEC	R4
		BMI	TPOGOAM0080		; E ? [no->TPOGOAM0080]
		INC	R4
;
		WITH	R8
		ADD	#08
TPOGOAM0080
		FROM	R8
		STW	(R3)
		INC	R3
		INC	R3
		FROM	R9
		STW	(R3)
		INC	R3
		INC	R3
		FROM	R10
		STW	(R3)
		INC	R3
		INC	R3
		FROM	R11
		STW	(R3)
		INC	R3
		LOOP
		INC	R3
;
		IBT	R0,#02
		SMS	CWORK5,R0
		IBT	R0,#08
		SMS	CWORK6,R0
		IWT	R0,#0000011000001111B
		SMS	CWORK7,R0
TPOGOAM0088
		LMS	R12,CWORK1
		DEC	R12
		BMI	TPOGOAM00F0		;  ON ? [no->TPOGOAM00F0]
		INC	R12
;
		CACHE
;
		LMS	R0,CWORK3
		ROMB
		LMS	R14,CWORK2
		MOVE	R13,R15
TPOGOAM0090
		GETBS
		INC	R14
		INC	R14
		DEC	R4
		BMI	TPOGOAM00A0		; E ? [no->TPOGOAM00A0]
		INC	R4
;
		NOT
		INC	R0
		ADD	#08
TPOGOAM00A0
		TO	R8
		ADD	R5			; (R8) <- X |WV
		GETBS
		INC	R14
		INC	R14
		TO	R9
		ADD	R6			; (R9) <- Y |WV
		LMS	R0,CWORK7
		ADD	R1
		TO	R10
		XOR	R7			; (R10) <- LN^[io[Agr[g
		LMS	R0,CWORK4		; H tbv񃍁[h !!
		TO	R10
		XOR	R10			; (R10) <- LN^[io[Agr[g
		FROM	R12
		AND	#01
		ADD	R0
		UMULT	#8
		TO	R10
		ADD	R10			; (R10) <- LN^[io[Agr[g
		LM	R0,CFRCNT2
		LMS	R2,CWORK5
		AND	R2
		LMS	R2,CWORK6
		UMULT	R2
		TO	R10
		XOR	R10			; (R10) <- LN^[io[Agr[g
		IBT	R11,#00			; (R11) <- OAM SUB
;
		FROM	R8
		STW	(R3)
		INC	R3
		INC	R3
		FROM	R9
		STW	(R3)
		INC	R3
		INC	R3
		FROM	R10
		STW	(R3)
		INC	R3
		INC	R3
		FROM	R11
		STW	(R3)
		INC	R3
		LOOP
		INC	R3
TPOGOAM00F0
		STOP
		NOP
;
;
;----------------------------------------------------------------
;-	SC							-
;-		(R0)  <- (	  "           oN)           -
;-		(R1)  <- (̃|WVf[^AhX)		-
;-		(R12) <- (̒)				-
;-		vC[ɓ (io[ -> R11)	-
;-		    "       ĂȂ ( -1 -> R11)           -
;----------------------------------------------------------------
TEPPOUGYOCRCK	EQU	$
		ROMB
		MOVE	R14,R1
		DEC	R12
		BMI	TPGCRCK00F0		; oĂ邩 ? [no->TPGCRCK00F0]
		INC	R12
;
		LM	R1,CENINDX
		mLDW	R2,CENMUKI,R1
		mLDW	R3,CENXPSL,R1
		mLDW	R4,CENYPSL,R1
		LM	R5,CPCENTX
		LM	R6,CPCENTY
		LM	R7,CPWIDEX
		LM	R8,CPWIDEY
;
		CACHE
;
		IBT	R11,#01
		MOVE	R13,R15
TPGCRCK0000
		GETBS
		INC	R14
		INC	R14
		DEC	R2
		BMI	TPGCRCK0020		; E ? [no->TPGCRCK0020]
		INC	R2
;
		NOT
		INC	R0
TPGCRCK0020
		ADD	R3
		TO	R9
		ADD	#04			; (R9) <- Z^[ X |WV
		GETBS
		INC	R14
		INC	R14
		ADD	R4
		TO	R10
		ADD	#04			; (R10) <- Z^[ Y |WV
		FROM	R5
		SUB	R9
		BPL	TPGCRCK0040		; minus ? [no->TPGCRCK0040]
		NOP
;
		NOT
		INC	R0
TPGCRCK0040
		FROM	R7
		SUB	R0
		BMI	TPGCRCK0080		;  ? [no->TPGCRCK0080]
		NOP
;
		FROM	R6
		SUB	R10
		BPL	TPGCRCK0060		; minus ? [no->TPGCRCK0060]
		NOP
;
		NOT
		INC	R0
TPGCRCK0060
		FROM	R8
		SUB	R0
		BPL	TPGCRCK0100		; c ? [yes->TPGCRCK0100]
		NOP
;
TPGCRCK0080
		LOOP
		INC	R11
TPGCRCK00F0
		IBT	R11,#-1
TPGCRCK0100
		STOP
		NOP
;
;
;----------------------------------------------------------------
;-	mRmROAM						-
;-		CENWRK6 : mRmR^p^p^ {fBLN^	-
;-		CENWRK7 : tO				-
;----------------------------------------------------------------
NOKONOKOOAM	EQU	$
		LM	R1,CENINDX		; G̃CfbNX !!
		mLDB0	CENYUSN,R1
		SEX
		BMI	NKNKOAM01F0		; \H [no->NKNKOAM01F0]
		NOP
;
		mLDB0	CENMOD2+1,R1
		LSR
		LSR
		TO	R12
		LSR
		BEQ	NKNKOAM01F0		; OAM ZERO ? [yes->NKNKOAM01F0]
		NOP
;
		mLDW	R2,CENOAML,R1		; OAM̃CfbNX !!
		WITH	R2
		ADD	#04
		mLDB0	CENCLOR,R1
		TO	R3
		AND	#0EH			; J[̓ǂݍ !!
		IWT	R4,#001FFH		; LN^}XNf[^ !!
		mLDB	R5,CENWRK6,R1		; mRmR^p^p^tO !!
		mLDB	R6,CENWRK7,R1		; tO !!
		IWT	R7,#0FFF0H		; Agr[g}XNf[^ !!
		IWT	R8,#00001H<<9		; ŒJ[f[^ !!
		IWT	R9,#0F1FFH		; J[}XNf[^ !!
		mLDB0	CENCHRB,R1
		TO	R11
		UMULT	#08			; LN^io[ !!
;
		CACHE
;
		MOVE	R13,R15
NKNKOAM0040
		TO	R10
		LDW	(R2)			; OAM READ !!
		FROM	R10
		SWAP
		AND	#0EH
		CMP	R3
		BEQ	NKNKOAM0080		; J[`FW ? [no->NKNKOAM0080]
		FROM	R10
;
		AND	R9
		TO	R10
		OR	R8
NKNKOAM0080
		FROM	R6
		SUB	#00
		BEQ	NKNKOAM0100		;  ? [no->NKNKOAM0100]
		FROM	R10
;
		AND	R4
		SUB	R11
		CMP	R5
		BNE	NKNKOAM0100		; {fB ? [no->NKNKOAM0100]
		FROM	R10
;
		AND	R7
		OR	#04
		AND	R9
		OR	R8
NKNKOAM0100
		STW	(R2)			; OAM SET !!
		WITH	R2
		ADD	#08
		LOOP
		NOP
;
NKNKOAM01F0
		STOP
		NOP
;
;****************************************************************
;*								*
;*		[hQ htthobt@Zbg		*
;*			in :					*
;*				(R1) <-- U̕		*
;*				(R2) <-- gJE^[		*
;*								*
;****************************************************************
BG2OFST_FURA	EQU	$
		IBT	R0,#BANK SIN
		ROMB
;
		LMS	R7,CESCCH1	;(R7) <-- gXN[JE^[
		LMS	R8,CESCCV1	;(R8) <-- uXN[JE^[
;
;-------------- gItZbgf[^Zbg ------------------------
		IWT	R0,#2000H	;ItZbg[hCl[u
		OR	R7		;(R0) <-- gItZbgf[^
		SM	R0,CBG2OFH
		IWT	R9,#CBG2OFF	;(R9) <-- ItZbgf[^obt@|C^[
;
		CACHE
;
		IBT	R12,#020H
		MOVE	R13,R15
BG2OFST_FURA_10
		STW	(R9)
		INC	R9
		LOOP
		INC	R9
;
;-------------- uItZbgf[^Zbg ------------------------
		WITH	R2
		SWAP
		FROM	R7
		LSR			;1/8
		LSR			;
		LSR			;
		ADD	R2
		MOVE	R3,R0
		AND	#0FH
		MOVE	R7,R0		;(R7) <-- X^[gJE^[
;
		FROM	R3		;[ ʒPʂŎ̕f[^Ă ]
		LSR
		LSR
		LSR
		LSR
		TO	R5		;(R5) <-- X^[g}bv|C^[
		AND	#07H
		IWT	R0,#FURA_WAVE_MAP
		TO	R14
		ADD	R5
		GETB
		MOVE	R2,R0		;(R2) <-- ̕
;
		ADD	R0		;x10H
		ADD	R0
		ADD	R0
		ADD	R0
		TO	R10
		UMULT	R5
;
		FROM	R2		;x2
		ADD	R2
		IWT	R6,#DIVBUF
		ADD	R6
		TO	R6
		LDW	(R0)
		FROM	R1
		TO	R6		;(R6) <-- U̕
		FMULT
;
		FROM	R7
		UMULT	R2
		TO	R4		;(R4) <-- X^[gf[^|C^[
		ADD	R10
;
		IWT	R3,#SIN		;(R3)  <-- rhmf[^|C^[
		IWT	R10,#2000H	;(R10) <-- ItZbg[hCl[uf[^
		IWT	R11,#1FFFH	;(R11) <-- gXN[JE^[`mcf[^
;
		IBT	R12,#020H+1
		IWT	R13,#BG2OFST_FURA_20+1
BG2OFST_FURA_20
		FROM	R4
		LOB
		ADD	R0
		TO	R14
		ADD	R3
;
		GETB
		INC	R14
;
		WITH	R4
		ADD	R2
		INC	R7
;
		GETBH
		FMULT
		ADD	R8
		AND	R11
		OR	R10
;
		IBT	R14,#020H+1
		WITH	R14
		SUB	R12
		BNE	BG2OFST_FURA_30 ;Ԗڂ̃f[^H ( no:BG2OFST_FURA_30 )
		NOP
;
		SM	R0,CBG2OFV
		BRA	BG2OFST_FURA_40+1
		WITH	R7
;
BG2OFST_FURA_30
		STW	(R9)
		INC	R9
		INC	R9
;
BG2OFST_FURA_40
		WITH	R7
		AND	#0FH
		BNE	BG2OFST_FURA_50 ;̎}bv|C^[ցH ( no:BG2OFST_FURA_50 )
		NOP
;
		INC	R5
		WITH	R5
		AND	#07H
		IWT	R0,#FURA_WAVE_MAP
		TO	R14
		ADD	R5
		GETB
		MOVE	R2,R0		;(R2) <-- ̕
;
		ADD	R0		;x2
		IWT	R6,#DIVBUF
		ADD	R6
		TO	R6
		LDW	(R0)
		FROM	R1
		TO	R6		;(R6) <-- U̕
		FMULT
;
BG2OFST_FURA_50
		LOOP
		FROM	R4		;[ dummy ]
;
		STOP
		NOP
;
;
;----------------------------------------------------------------
;-	DOAM						-
;-		CENWRK0 : J[				-
;-		(R4)	: gtbvf[^			-
;----------------------------------------------------------------
FUSEN0OAM	EQU	$
		LM	R1,CENINDX		; G̃CfbNX !!
		mLDB0	CENYUSN,R1
		SEX
		BMI	FUSEN0_01F0		; \H [no->FUSEN0_01F0]
		NOP
;
		mLDB0	CENMOD2+1,R1
		LSR
		LSR
		TO	R12
		LSR
		BEQ	FUSEN0_01F0		; n`l̎gp O ? [yes->FUSEN0_01F0]
		NOP
;
		mLDB	R0,CENWRK0,R1
		TO	R3
		SWAP				; R3 <- J[
		mLDW	R2,CENOAML,R1		; R2 <- n`l̃CfbNX̓ǂݍ!!
		FROM	R12
		SUB	#01
		ADD	R0
		ADD	R0
		ADD	R0
		ADD	#04			; Agr[gLN^mD
		TO	R2
		ADD	R2			; R2 <- n`l̃CfbNX !!
		LDW	(R2)
		OR	R3			; J[
		XOR	R4			; 
		STW	(R2)
;
FUSEN0_01F0
		STOP
		NOP
;
;
;----------------------------------------------------------------
;-	DOAM						-
;-		CENWRK0 : J[				-
;-		CENWRK1 : J[				-
;-		CENWRK2 : J[				-
;-		CENWRK3 : 					-
;-		(R4)	: gtbvf[^			-
;-		(R0)	: f[^oN				-
;-		(R7)	: f[^AhX			-
;----------------------------------------------------------------
FUSEN1OAM	EQU	$
		ROMB
		MOVE	R14,R7			; f[^AhZbg !!
;
		LM	R1,CENINDX		; G̃CfbNX !!
		mLDB0	CENMOD2+1,R1
		LSR
		LSR
		TO	R12
		LSR
		BEQ	FUSEN1_01F0		; n`l̎gp O ? [yes->FUSEN0_01F0]
		NOP
;
		mLDB0	CENWRK0,R1
		SMS	R0,CWORK		; CWORK <- J[
		mLDB0	CENWRK1,R1
		SMS	R0,CWORK1		; CWORK1 <- J[
		mLDB0	CENWRK2,R1
		SMS	R0,CWORK2		; CWORK2 <- J[
;
		mLDW	R2,CENOAML,R1		; R2 <- n`l̃CfbNX̓ǂݍ!!
		FROM	R12
		SUB	#01
		ADD	R0
		ADD	R0
		ADD	R0
		ADD	#04			; Agr[gLN^mD
		TO	R2
		ADD	R2			; R2 <- n`l̃CfbNX !!
;
		mLDW	R7,CENDSXL,R1		; R7 <- w|WV[h !!
		mLDW	R8,CENDSYL,R1		; R8 <- x|WV[h !!
;
		CACHE
;
		IWT	R5,#CWORK
		IBT	R6,#03
		mLDB	R12,CENWRK3,R1
		MOVE	R13,R15
FUSEN1_0040
		LDB	(R5)
		INC	R5
		INC	R5
		SWAP
		BPL	FUSEN1_0060		; J[nm ? [yes->FUSEN1_0060]
		DEC	R6
		BNE	FUSEN1_0040		; [->FUSEN1_0040]
		NOP
;
FUSEN1_0060
		TO	R3
		ADD	R0
		LDW	(R2)
		OR	R3			; J[
		XOR	R4			; 
		STW	(R2)
		DEC	R2
		DEC	R2
;
		IBT	R9,#03
FUSEN1_0080
		GETBS
		DEC	R14
		ADD	R8
		STW	(R2)			; x|WVZbg !!
		DEC	R2
		DEC	R2
;
		GETBS
		DEC	R14
		ADD	R7
		STW	(R2)			; w|WVZbg !!
		WITH	R2
		SUB	#06
;
		DEC	R9
		BNE	FUSEN1_0080
		NOP
;
		INC	R2
		LOOP
		INC	R2
;
FUSEN1_01F0
		STOP
		NOP
;
;
;
;------------------------------------------------------------------------
;-		R[XChoJ{hEBhE			-
;------------------------------------------------------------------------
;>>>>>>>>>>
;SIN CURBE WRITE
;entry
; R1 LEFT  X POINT
; R2 RIGHT X POINT
;return
;<<<<<<<<<<

;;;WAVE_SIZE	EQU	(008H*004H)	;1char
;
W1BUF_SINSET	EQU	$
;
		IBT	R0,#BANK LCOS
		ROMB
;
		IWT	R10, #000FFH	;CLOSE WINDOW SETTING PRM.
		IWT	R6, #WINDBF	;HDMA DOUBLE BUFFER ADDRESS
		IBT	R7, #004H	;HDMA DOUBLE BUFFER ADDRESS PRM LENGTH
;
		FROM	R2		;X2 - X1
		SUB	R1		;
		BPL	W1BSSET_100	;NORMAL PROCESS
		NOP
;
		MOVE	R0, R10
;
		CACHE
;
		IWT	R12, #0D2H
		MOVE	R13, R15
W1BSSET_010
		STW	(R6)
		WITH	R6
		ADC	R7
		LOOP
		NOP
;
		STOP
		NOP
;
W1BSSET_100
;
;;		ROL			;*2
;;		ROL			;*4
		ADD	R0		;*2
		MOVE	R3, R0		;WAVE_SIZE
;
		FROM	R2		;WAVE CENTER CALC
		SUB	R1		;
		LSR			;
		TO	R1		;
		ADC	R1		;
;
;;;		IBT	R0,#BANK LCOS
;;;		ROMB
;
;;;		IBT	R0, #(WAVE_SIZE*040H)/0100H
;;;		WITH	R1
;;;		SUB	R0
;
		IBT	R2, #004H
;;;		IBT	R3, #WAVE_SIZE
;;;		IWT	R4, #000FFH
		IWT	R5, #0FF00H
;;;		IWT	R6, #WINDBF
;;;		IBT	R7, #004H
		IWT	R8, #LCOS
		IBT	R9, #000H
;
		MOVE	R14, R8
		GETB
;
		CACHE
;
		IWT	R12, #0D2H
		MOVE	R13, R15
W1BSSET_110
		WITH	R9
		ADD	R2
		WITH	R9
		LOB
		TO	R14
		FROM	R8
		ADD	R9
;
		MOVE	R11, R6
		SEX
		MOVE	R6, R3
		LMULT
		MOVE	R6, R11
		FROM	R4
		SWAP
		SEX
		TO	R11
		ADD	R1
		BMI	W1BSSET_120
		FROM	R10
;
		SUB	R11
		BCC	W1BSSET_120
		FROM	R5
;
		FROM	R11
		SWAP
;
W1BSSET_120
		STW	(R6)
		WITH	R6
		ADD	R7
;
		LOOP
		GETB
;
		STOP
		NOP

;
;
;----------------------------------------------------------------
;-	̖_							-
;-		ENCONT : px (XX.XX)				-
;-		  WRK0 : S̋				-
;-		  WRK2 : LN^p^[			-
;-								-
;-		(R5) <- Data Bank				-
;-		(R6) <- Data Address				-
;----------------------------------------------------------------
FIREBAROAM	EQU	$
		IBT	R0,#BANK LCOS
		ROMB
;
		LM	R1,CENINDX		; R1 <- G̃CfbNX
;
		mLDW0	CENCONT,R1
		TO	R2
		HIB				; R2 <- px
		IWT	R0,#LCOS
		TO	R14
		ADD	R2
;
		TO	R3
		GETB				; R3 <- Cos Data
;
		IWT	R0,#LSIN
		TO	R14
		ADD	R2
;
		TO	R4
		GETB				; R4 <- Sin Data
;
		FROM	R5
		ROMB
		mLDW0	CENWRK2,R1
		ADD	R0
		TO	R14
		ADD	R6
;
		CACHE
;
		IBT	R6,#018H
		IBT	R7,#01FH
		IWT	R11,#CWORK0
		mLDW	R5,CENWRK0,R1		; R5 <- S̋
		mLDB0	CENMOD2+1,R1
		ADD	R0
		ADD	R0
		ADD	R0
		ADD	R0
		ADD	R0
		SWAP
		TO	R9
		AND	R7			; R9 <- 
		MOVE	R12,R9			; R12 <- 
		MOVE	R13,R15
FIREBAROAM0080
		FROM	R5
		MULT	R3
		ADD	R0
		ADD	R0
		HIB
		SEX
		STW	(R11)			; X save !!
		INC	R11
		INC	R11
;
		FROM	R5
		MULT	R4
		ADD	R0
		ADD	R0
		HIB
		SEX
		ASR
		STW	(R11)			; Y save !!
		INC	R11
;
		WITH	R5
		ADD	R6
;
		LOOP
		INC	R11
;
		FROM	R2
		SEX
		BPL	FIREBAROAM00A0		; [->FIREBAROAM00A0]
		NOP
;
		WITH	R11
		SUB	#02
		FROM	R11
		TO	R10
		SUB	#02
		IBT	R7,#-4
		BRA	FIREBAROAM00E0
		NOP
;
FIREBAROAM00A0
		IBT	R10,#CWORK0
		IBT	R11,#CWORK0+2
		IBT	R7,#4
FIREBAROAM00E0
		TO	R6
		GETB				; R6 <- Character Number Low !!
		INC	R14
;
		mLDB0	CENCHRB,R1
		ADD	R0
		ADD	R0
		TO	R3
		ADD	R0
		mLDB0	CENCLOR,R1
		SWAP
		TO	R3
		OR	R3
		FROM	R6
		GETBH
		TO	R6
		ADD	R3			; R6 <- Character Number & Attribute !!
;
		mLDW0	CENDSXL,R1
		TO	R3
		ADD	#08			; R3 <- Sw
		mLDW0	CENDSYL,R1
		TO	R4
		ADD	#08			; R4 <- Sx
		mLDW	R5,CENOAML,R1		; R5 <- n`l̃CfbNX̓ǂݍ!!
;
		IBT	R8,#00
;
		MOVE	R12,R9			; R12 <- 
		MOVE	R13,R15
FIREBAROAM0100
		LDW	(R11)
		XOR	R8
		BPL	FIREBAROAM0140		; [->FIREBAROAM0140]
		NOP
;
		LM	R5,COAMIDX		; R5 <- n`l̃CfbNX̓ǂݍ!!
		TO	R8
		XOR	R8
FIREBAROAM0140
		LDW	(R10)
		ADD	R3
		SUB	#08
		STW	(R5)			; OAM_DX Set (X) !!
		INC	R5
		INC	R5
		LDW	(R11)
		ADD	R4
		SUB	#08
		STW	(R5)			; OAM_DX Set (Y) !!
		INC	R5
		INC	R5
		FROM	R6
		STW	(R5)			; OAM_DX Set (C) !!
		INC	R5
		INC	R5
		IBT	R0,#02
		STW	(R5)			; OAM_DX Set (D) !!
		INC	R5
;
		WITH	R10
		ADD	R7
		WITH	R11
		ADD	R7
;
		LOOP
		INC	R5
;
		FROM	R8
		ADD	R8
		BCC	FIREBAROAM01F0		; [->FIREBAROAM01F0]
		NOP
;
		SM	COAMIDX,R5
FIREBAROAM01F0
		mLDW	R3,CECENTX,R1		; R3 <- Sw
		mLDW0	CECENTY,R1
		TO	R4
		ADD	#03			; R4 <- Sx
		IBT	R10,#CWORK0
		IBT	R11,#CWORK0+2
;
		IBT	R8,#08H*2
;
		MOVE	R12,R9			; R12 <- 
		MOVE	R13,R15
FIREBARCRCK
		TO	R5
		LDW	(R11)
		FROM	R5
		ADD	#08H
		CMP	R8
		BCS	FIREBARCRCK00F0		; ͈͊O ? [yes->FIREBARCRCK00F0]
		NOP
;
		LM	R0,CPWIDEY
		TO	R6
		ADD	#03
		LM	R7,CPCENTY
		FROM	R5
		ADD	R4
		SUB	R7
		BPL	FIREBARCRCK0040		; Plus ? [yes->FIREBARCRCK0040]
		NOP
;
		NOT
		INC	R0
FIREBARCRCK0040
		SUB	R6
		BPL	FIREBARCRCK00F0		; Փ˂ ? [no->FIREBARCRCK00F0]
		NOP
;
		LM	R0,CPWIDEX
		TO	R6
		ADD	#04
		LM	R7,CPCENTX
		LDW	(R10)
		ADD	R3
		SUB	R7
		BPL	FIREBARCRCK0080		; Plus ? [yes->FIREBARCRCK0080]
		NOP
;
		NOT
		INC	R0
FIREBARCRCK0080
		SUB	R6
		BMI	FIREBARCRCK0100		; Փ˂ ? [yes->FIREBARCRCK0100]
		NOP
;
FIREBARCRCK00F0
		WITH	R10
		ADD	#04
		WITH	R11
		ADD	#04
;
		LOOP
		NOP
;
		STOP
		NOP
;
FIREBARCRCK0100
		IBT	R2,#-1
		mSTB	R2,CECRSFG,R1
		STOP
		NOP
;
;
;----------------------------------------------------------------
;-	nSC						-
;-		(R0) <- f[^ oN				-
;-		(R1) <- ENCHPT					-
;-		(R2) <- (̒)				-
;-		(R3) <- (̃|WVf[^AhX)		-
;-		(R4) <- (	 "           oN)            -
;-		(R5) <- f[^ AhX				-
;-		CWORK5 <- AND DATA				-
;-		CWORK6 <-  *  DATA				-
;-		CWORK7 <- CHARACTER & ATTRIBUTE DATA		-
;----------------------------------------------------------------
EX_OAM_GANFISH	EQU	$
		ROMB
		SMS	CWORK0,R1
		SMS	CWORK1,R2
		SMS	CWORK2,R3
		SMS	CWORK3,R4
;
		IBT	R6,#18
		LM	R2,CENINDX
		mLDB0	CENMOD2+1,R2
		LSR
		LSR
		LSR
		TO	R12
		SUB	R6
		FROM	R12
		UMULT	#05
		UMULT	R1
		TO	R14
		ADD	R5
;
		mLDB	R1,CENCHRB,R2
		WITH	R1
		UMULT	#8
		mLDW	R3,CENOAML,R2
		mLDW	R4,CENMUKI,R2
		FROM	R4
		SWAP
		ADD	R0
		ADD	R0
		ADD	R0
		ADD	R0
		ADD	R0
		SMS	CWORK4,R0		; H tbvZ[u !!
		mLDW	R5,CENDSXL,R2
		mLDW	R6,CENDSYL,R2
		mLDW	R7,CENCLOR,R2
		WITH	R7
		SWAP
;
		CACHE
;
		MOVE	R13,R15
GANFISH0000
		GETBS
		INC	R14
		DEC	R4
		BMI	GANFISH0040		; E ? [no->GANFISH0040]
		INC	R4
;
		NOT
		INC	R0
GANFISH0040
		TO	R8
		ADD	R5			; (R8) <- X |WV
		GETBS
		INC	R14
		TO	R9
		ADD	R6			; (R9) <- Y |WV
		GETB
		INC	R14
		GETBH
		INC	R14
		ADD	R1
		TO	R10
		XOR	R7			; (R10) <- LN^[io[Agr[g
		LMS	R0,CWORK4		; H tbv񃍁[h !!
		TO	R10
		XOR	R10			; (R10) <- LN^[io[Agr[g
		TO	R11
		GETB				; (R11) <- OAM SUB
		INC	R14
		DEC	R11
		BPL	GANFISH0080		; LN^[ [no->GANFISH0080]
		INC	R11
;
		DEC	R4
		BMI	GANFISH0080		; E ? [no->GANFISH0080]
		INC	R4
;
		WITH	R8
		ADD	#08
GANFISH0080
		FROM	R8
		STW	(R3)
		INC	R3
		INC	R3
		FROM	R9
		STW	(R3)
		INC	R3
		INC	R3
		FROM	R10
		STW	(R3)
		INC	R3
		INC	R3
		FROM	R11
		STW	(R3)
		INC	R3
		LOOP
		INC	R3
;
		IWT	R15,#TPOGOAM0088
		NOP
;
;
;************************************************************************
;*	o[eT							*
;*		ENCONT : {						*
;*		(R0) <- f[^oNiRj				*
;*		(R1) <- f[^AhXiRj				*
;*		(R2) <- tFCXio[				*
;************************************************************************
BALLOONTELESA	EQU	$
		ROMB
		MOVE	R14,R1			; AhXZbgI
;
		LM	R1,CENINDX		; G̃CfbNXI
;
		mLDW	R3,CENOAML,R1		; (R3) <- n`lCfbNXI
		mLDW	R4,CENDSXL,R1		; (R4) <- w |WVI
		mLDW	R5,CENDSYL,R1		; (R5) <- x |WVI
		mLDW	R9,CENMUKI,R1		; (R9) <- I
		mLDB0	CENCHRB,R1
		ADD	R0
		ADD	R0
		TO	R7
		ADD	R0			; (R7) <- LN^io[I
		mLDW0	CENCLOR,R1
		TO	R8
		SWAP
		FROM	R9
		SWAP
		ADD	R0
		ADD	R0
		ADD	R0
		ADD	R0
		ADD	R0
		TO	R8
		XOR	R8			; (R8) <- Agr[gI
;
		CACHE
;
		mLDW0	CENCHPT,R1
		DEC	R0
		BPL	BLTLSZOOM		; Y[H [yes->BLTLSZOOM]
		NOP
;
		IBT	R12,#02
		MOVE	R13,R15
BLTLS0030
		GETBS
		INC	R14
		DEC	R9
		BMI	BLTLS0040		; tbvH [no->BLTLS0040]
		INC	R9
;
		NOT
		INC	R0
		ADD	#08
BLTLS0040
		ADD	R4
		STW	(R3)			; w |WVZ[uI
		INC	R3
		INC	R3
		GETBS
		INC	R14
		ADD	R5
		SUB	#08
		STW	(R3)			; x |WVZ[uI
		INC	R3
		INC	R3
		GETB
		INC	R14
		GETBH
		INC	R14
		OR	R7
		XOR	R8
		STW	(R3)			; LN^Agr[gI
		WITH	R3
		ADD	#04
;
		LOOP
		NOP
;
		STOP
		NOP
;
BLTLSZOOM
		mLDW	R6,CENCONT,R1		; (R6) <- {I
		IBT	R12,#02
		MOVE	R13,R15
BLTLSZOOM0030
		GETBS
		INC	R14
		DEC	R9
		BMI	BLTLSZOOM0040		; tbvH [no->BLTLS0040]
		INC	R9
;
		NOT
		INC	R0
		ADD	#08
BLTLSZOOM0040
		ADD	R4
		STW	(R3)			; w |WVZ[uI
		INC	R3
		INC	R3
		GETB
		INC	R14
		SWAP
		FMULT
		ADD	R5
		STW	(R3)			; x |WVZ[uI
		INC	R3
		INC	R3
		GETB
		INC	R14
		GETBH
		INC	R14
		OR	R7
		XOR	R8
		STW	(R3)			; LN^Agr[gI
		WITH	R3
		ADD	#04
;
		LOOP
		NOP
;
		IWT	R0,#0FE00H
		DEC	R9
		BMI	BLTLSZOOM0080		; tbvH [no->BLTLSZOOM0080]
		INC	R9
;
		NOT
		INC	R0
BLTLSZOOM0080
		FMULT
		ADD	R4
		STW	(R3)			; w |WVZ[uI
		INC	R3
		INC	R3
		IWT	R0,#0FB00H
		FMULT
		ADD	R5
		STW	(R3)			; x |WVZ[uI
		INC	R3
		INC	R3
		IWT	R0,#(02<<9)
		OR	R7
		OR	R2
		XOR	R8
		STW	(R3)			; LN^Agr[gI
;
		STOP
		NOP
;
;>>>>>>>>>>
;RANDOM_ERASE
;entry
;R3 : X POINT
;R4 : Y POINT
;R5 : DELETE POINT DATA START OFFSET (0-3F)<NORMAL = 0>
;R12 : DELETE POINT NUMBER
;return
;NON
;<<<<<<<<<<
RANDOM_ERASE	EQU	$
;
		IBT	R0, #BANK RDELDT
		ROMB
;
		IWT	R6, #RDELDT
		FROM	R6
		TO	R14
		ADD	R5
;
		IBT	R0, #001H
		CMODE
;
		IBT	R8,  #007H
		IBT	R9,  #03FH
		IBT	R11, #008H
;
		IBT	R0, #000H
		COLOR
		CACHE
;
		MOVE	R13, R15
RERASE_010
		TO	R7
		GETB
;
		INC	R5		;address incriment
		WITH	R5		;
		AND	R9		;
		FROM	R6		;
		TO	R14		;
		ADD	R5		;
;
		FROM	R7		;X point get
		LSR		;>>1	;
		LSR		;>>2	;
		LSR		;>>3	;
		TO	R10		;
		ADD	R3		;
		FROM	R7		;y point get
		AND	#007H		;
		TO	R2		;
		ADD	R4		;
;
		MOVE	R1, R10
;
		PLOT			;P(0,0)
		WITH	R1		;
		ADD	R8		;
		PLOT			;P(1,0)
		WITH	R1		;
		ADD	R8		;
		PLOT			;P(2,0)
		WITH	R1		;
		ADD	R8		;
		PLOT			;P(3,0)
;
		MOVE	R1, R10
;
		WITH	R2		;
		ADD	R11		;
		PLOT			;P(0,1)
		WITH	R1		;
		ADD	R8		;
		PLOT			;P(1,1)
		WITH	R1		;
		ADD	R8		;
		PLOT			;P(2,1)
		WITH	R1		;
		ADD	R8		;
		PLOT			;P(3,1)
;
		MOVE	R1, R10
;
		WITH	R2		;
		ADD	R11		;
		PLOT			;P(0,2)
		WITH	R1		;
		ADD	R8		;
		PLOT			;P(1,2)
		WITH	R1		;
		ADD	R8		;
		PLOT			;P(2,2)
		WITH	R1		;
		ADD	R8		;
		PLOT			;P(3,2)
;
		MOVE	R1, R10
;
		WITH	R2		;
		ADD	R11		;
		PLOT			;P(0,3)
		WITH	R1		;
		ADD	R8		;
		PLOT			;P(1,3)
		WITH	R1		;
		ADD	R8		;
		PLOT			;P(2,3)
		WITH	R1		;
		ADD	R8		;
;
		LOOP			;
		PLOT			;P(3,3)
;
		RPIX
;
		STOP
		NOP
;
RDELDT
		BYTE	(0 << 3) + 6, (6 << 3) + 2, (0 << 3) + 1, (1 << 3) + 6
		BYTE	(7 << 3) + 6, (6 << 3) + 3, (6 << 3) + 7, (2 << 3) + 3
		BYTE	(3 << 3) + 4, (1 << 3) + 7, (5 << 3) + 7, (4 << 3) + 5
		BYTE	(2 << 3) + 0, (1 << 3) + 3, (2 << 3) + 4, (7 << 3) + 0
		BYTE	(6 << 3) + 1, (0 << 3) + 3, (0 << 3) + 4, (4 << 3) + 2
		BYTE	(3 << 3) + 2, (5 << 3) + 0, (3 << 3) + 3, (3 << 3) + 5
		BYTE	(2 << 3) + 1, (6 << 3) + 4, (4 << 3) + 1, (2 << 3) + 2
		BYTE	(0 << 3) + 2, (7 << 3) + 1, (1 << 3) + 1, (5 << 3) + 1
		BYTE	(0 << 3) + 7, (7 << 3) + 2, (5 << 3) + 5, (7 << 3) + 3
		BYTE	(5 << 3) + 2, (4 << 3) + 4, (5 << 3) + 3, (2 << 3) + 6
		BYTE	(4 << 3) + 3, (7 << 3) + 7, (7 << 3) + 5, (2 << 3) + 7
		BYTE	(5 << 3) + 4, (7 << 3) + 4, (6 << 3) + 0, (0 << 3) + 5
		BYTE	(6 << 3) + 6, (1 << 3) + 2, (2 << 3) + 5, (4 << 3) + 0
		BYTE	(0 << 3) + 0, (3 << 3) + 7, (4 << 3) + 6, (5 << 3) + 6
		BYTE	(4 << 3) + 7, (1 << 3) + 5, (1 << 3) + 0, (3 << 3) + 6
		BYTE	(6 << 3) + 5, (3 << 3) + 1, (3 << 3) + 0, (1 << 3) + 4
;
;
;>>>>>>>>>>
;function 32*32 bitmap  ׂĔŖ߂
;entry
;R1 : START X POINT
;R2 : START Y POINT
;return
;non
;<<<<<<<<<<
OMIT_FULL	EQU	$
;
		IBT	R0, #001H
		CMODE
;
		MOVE	R3, R1
		IBT	R4, #000H
		IBT	R5, #01FH
;
		IBT	R0, #000H
		COLOR
		PLOT
;
		IWT	R12, #020H*020H
		MOVE	R13, R15
OMITF_010
		INC	R4
;
		WITH	R4
		AND	R5
		BNE	OMITF_050
		NOP
;
		MOVE	R1, R3
		INC	R2
OMITF_050
		LOOP
		PLOT
;
		RPIX
;
		STOP
		NOP
;
;>>>>>>>>>>
;function 32 * 32 bitmap _ɓ]s
;entry
;R3  : output pattern bitmap point X pos.
;R4  : output pattern bitmap point Y pos.
;R5  : output point data start offset (0-3F)
;R6  : output pattern data address
;R7  : output pattern data bank
;R8  : hiniburu flg bitmode (hi=004H,low = 00H
;R12 : output point number (o͂s)
;return
;non
;<<<<<<<<<<
;
RANDOM_TRNS	EQU	$
;
		IBT	R0, #004H
		AND	R8
		IBT	R1, #001H
		OR	R1
		CMODE
;
		MOVE	R8, R12		;point counter back up
		IBT	R9, #03FH
;
		IBT	R0, #BANK RDELDT
		ROMB
;
		IWT	R10, #RDELDT
		FROM	R10
		TO	R14
		ADD	R5
;
		IBT	R11, #CWORK0
;
		GETB
;
		CACHE
;
		MOVE	R13, R15
RTRNS_010
		INC	R5
		WITH	R5
		AND	R9
		FROM	R10
		TO	R14
		ADD	R5
		STB	(R11)
		INC	R11
;
		LOOP
		GETB
;
		FROM	R7		;out put pattern data rom bank set
		ROMB
;
		IBT	R10, #07H
		IBT	R11, #CWORK0
;
		CACHE
;
		MOVE	R12, R8			;output point number
		MOVE	R13, R15
RTRNS_110
		IBT	R5, #004-1	;y loop
;
		TO	R9		;R9 = 00xx xyyy	 data get
		LDB	(R11)		;
		INC	R11		;
;
		FROM	R9
		AND	R10
		TO	R8
		SWAP
		FROM	R9
		LSR
		LSR
		LSR
		OR	R8
		MOVE	R9, R0
		TO	R14
		ADD	R6
;
		FROM	R9		;P(0,0) point calc
		LOB			;
		TO	R1		;
		ADD	R3		;
		FROM	R9		;
		HIB			;
		TO	R2		;
		ADD	R4		;
RTRNS_130
		GETC			;P(0,*) point set
		PLOT			;
;
		WITH	R14		;P(1,*) point
		ADD	R10		;
		INC	R14		;
		WITH	R1		;
		ADD	R10		;
		GETC			;P(1,*) point set
		PLOT			;
;
		WITH	R14		;P(2,*) point set
		ADD	R10		;
		INC	R14		;
		WITH	R1		;
		ADD	R10		;
		GETC			;
		PLOT			;
;
		WITH	R14		;P(3,*) point set
		ADD	R10		;
		INC	R14		;
		WITH	R1		;
		ADD	R10		;
		GETC			;
		PLOT			;
;					;
		IWT	R0, #007E8H	;R14 next line left
		WITH	R14		;
		ADD	R0		;
		IBT	R0, #018H+1	;R1 xp left line
		WITH	R1		;
		SUB	R0		;
		WITH	R2		;R2 yp next line
		ADD	R10		;
		INC	R2		;
;
		DEC	R5
		BPL	RTRNS_130
		NOP
;
		LOOP
		NOP
;
		RPIX
;
		STOP
		NOP
;
;
;************************************************************************
;*	`[bv̂n`lZbg					*
;*		CWORK0 : Ԃт獶i̎j ԂтEiE̎j	*
;*		CWORK1 : ԂтEi̎j Ԃт獶iE̎j	*
;*		CWORK2 : Ԃт獶i̎j ԂтEiE̎j	*
;*		CWORK3 : ԂтEi̎j Ԃт獶iE̎j	*
;*		CWORK4 : 						*
;*		CWORK5 : 牺						*
;************************************************************************
TULIP_OAM_SET	EQU	$
;
		CACHE
;
		IWT	R0,#BANK LCOS
		ROMB
;
		LM	R1,CENINDX		; qP <- G̃CfbNXI
		mLDB	R9,CENCONT+1,R1
		FROM	R9
		NOT
		TO	R2
		LOB				; qQ <- px̓ǂݍ݁I
		IWT	R0,#LCOS
		TO	R14
		ADD	R2
		FROM	R9
		LSR
		LSR
		TO	R9
		LSR
		IWT	R4,#LSIN
		GETBS
;
		FROM	R4
		TO	R14
		ADD	R2
;
		DIV2
		TO	R3
		DIV2				; qR <- x
;
		GETBS
		DIV2
		TO	R4
		DIV2				; qS <- w
;
		mLDW	R2,CENOAML,R1
		FROM	R2
		TO	R5
		ADD	#04
;
		IWT	R7,#0FE00H
		LMS	R6,CWORK4
		LDW	(R5)
		AND	R7
		OR	R6
		STW	(R5)
		WITH	R5
		ADD	#08
;
		LMS	R6,CWORK5
		LDW	(R5)
		AND	R7
		OR	R6
		STW	(R5)
		WITH	R5
		ADD	#08
;
		IBT	R6,#CWORK0
		IBT	R12,#8
		MOVE	R13,R15
;
		WITH	R6
		AND	#06
		TO	R8
		LDW	(R6)
		LDW	(R5)
		AND	R7
		OR	R8
		STW	(R5)
		WITH	R5
		ADD	#08
		INC	R6
;
		LOOP
		INC	R6
;
		FROM	R2
		TO	R5
		ADD	#02
		LDW	(R5)
		ADD	R9
		STW	(R5)
		WITH	R5
		ADD	#08
		LDW	(R5)
		ADD	R9
		STW	(R5)
;
		IWT	R0,#(8*2)
		TO	R5
		ADD	R2
		IWT	R0,#(8*6)
		TO	R6
		ADD	R2
;
		IBT	R12,#04
		MOVE	R13,R15
;
		LDW	(R5)
		SUB	R4
		STW	(R5)
		INC	R5
		INC	R5
		LDW	(R5)
		SUB	R3
		STW	(R5)
		WITH	R5
		ADD	#06
;
		LDW	(R6)
		ADD	R4
		STW	(R6)
		INC	R6
		INC	R6
		LDW	(R6)
		SUB	R3
		STW	(R6)
		WITH	R6
		ADD	#06
;
		LOOP
		NOP
;
		STOP
		NOP
;
;
;****************************************************************
;*	j{{̊						*
;*		in :						*
;*			ENCONT <- {				*
;*			R0  <- f[^oN			*
;*			R10 <- f[^AhX			*
;*			R12 <- 				*
;****************************************************************
HBNBN_OAM	EQU	$
		ROMB
		MOVE	R14,R10
;
		CACHE
;
		LM	R1,CENINDX		; G̃CfbNX̓ǂݍ݁II
		mLDW	R2,CENOAML,R1		;
		mLDW	R3,CENMUKI,R1		; ̓ǂݍ݁II
		mLDW0	CENCLOR,R1
		LSR
		LSR
		LSR
		LSR
		LSR
		LSR
		TO	R4
		AND	#02			; utbv̓ǂݍ݁II
		mLDW	R6,CENCONT,R1		; {̓ǂݍ݁II
		mLDW	R7,CENDSXL,R1		; w̓ǂݍ݁II
		mLDW	R8,CENDSYL,R1		; x̓ǂݍ݁II
;
		IWT	R5,#00800H
;
		MOVE	R13,R15
;
		GETB
		INC	R14
;
		SWAP
		DEC	R3
		BMI	HBNBN_OAM0040		; gtbvH [no->HBNBN_OAM0040]
		INC	R3
;
		NOT
		INC	R0
		SUB	R5
HBNBN_OAM0040
		FMULT
		ADD	#08
		ADD	R7
		STW	(R2)
		INC	R2
		INC	R2
;
		GETB
		INC	R14
;
		SWAP
		DEC	R4
		BMI	HBNBN_OAM0060		; utbvH [no->HBNBN_OAM0060]
		INC	R4
;
		NOT
		INC	R0
		SUB	R5
HBNBN_OAM0060
		FMULT
		ADD	#08
		ADD	R8
		STW	(R2)
		WITH	R2
		ADD	#06
;
		LOOP
		NOP
;
		STOP
		NOP
;
;************************************************************************
;*		LN^[]iTCY RQ~RQj			*
;*			 F (R2)  <-- rbg}bvWQx		*
;*				(R3)  <--	 h	  Qw		*
;*				(R11) <-- {iPOOgPDOj	*
;*				(R14) <-- ]pxiO`eej		*
;*				(R8)  <-- SQw			*
;*				(R9)  <--   hQx			*
;*				(R12) <-- LN^[AhXikCgj*
;*				(R13) <--	  h	       (aj	*
;************************************************************************
;
C_32_X_ROTE_X	EQU	$
;
		IBT	R0,#BANK COS
		ROMB
;
		MOVE	R6,R11
		IWT	R0,#COS
		ADD	R14
		TO	R14
		ADD	R14
		GETB
		INC	R14
		GETBH
		LMULT
		WITH	R4
		HIB
		LOB
		SWAP
		TO	R6		;(R6) <-- w{
		OR	R4
;
		mDJMP	C_32_ZOOM_XY
;
;>>>>>>>>>
;function
; 32*32̕ʂ𒆐S_ɌxW𒆐Sɂĉ]B
;name
; C_32_X_ROTE
;entry
; R0  : Xpos
; R1  : Ypos
; R2  : px (000H-0FFH)
; R3  : { (1.0 = 100H)
; R13 : rbg}bvf[^oN
; R14 : rbg}bvf[^AhX
;return
; R3  : X1
; R5  : Y1
; R7  : X2
; R8  : Y2
;work
;<<<<<<<<<<
;
CRT_ZPOS	EQU	(030H)		;ʂ̂yWʒu
OBJ_ZPOS	EQU	(030H)		;̂̉ʂ̂yWʒu
;
C_32_X_ROTE	EQU	$
;
		SMS	R13, REG13	;rbg}bvf[^oNZ[u
		SMS	R14, REG14	;rbg}bvf[^AhXZ[u
;
		SMS	R0, CWORK0
		SMS	R1, CWORK1
;
		IWT	R6, #OBJ_ZPOS*0100H	;{ɂyẄʒuύX
		IWT	R0, #DIVBUF
		ADD	R3
		ADD	R3
		LDW	(R0)		;R0 = 1 / Zoom = XX.XX
		TO	R12
		LMULT			;R6 = OBJ_ZPOS * R0
;
		IBT	R0, #BANK SIN
		ROMB
;
		IWT	R0, #COS
		ADD	R2
		TO	R14
		ADD	R2
;
		IWT	R0, #SIN
		ADD	R2
		TO	R2
		ADD	R2
;
		GETB
		INC	R14
		GETBH
		MOVE	R14, R2
		IBT	R6, #010H		;S_̋iwWj=  L = 10H
		LMULT				;R0  = X = L * COS(ANGLE) = XX.XX
;
		IWT	R6, #CRT_ZPOS*100H	;XX.XX = 20.00H
		FROM	R4
		TO	R10
		FMULT				;R10 = 020H * X = ϊp = XXXX.
;		
		GETB
		INC	R14
		GETBH
		IWT	R6, #01000H		;S_̋iwWj=  L = 10.00H
		TO	R11
		FMULT				;R11 = Z = L * SIN(ANGLE) = XXXX.
;
		IWT	R3, #DIVBUF
		FROM	R12			;R12 = ̂̒S
		ADD	R11			;R0  = R0 + R11	;E
		ADD	R0			;R0  = R0 * 2
		ADD	R3
		TO	R6
		LDW	(R0)			;R6  = 1 / Z = .XXXX
;
		FROM	R10
		TO	R7
		LMULT				;R7  = X = ϊwW = XXXX.
		DEC	R7
		BMI	C_32_X_ROTE_080
		INC	R7
		DEC	R7
C_32_X_ROTE_080
		IWT	R0, #CRT_ZPOS*010H
		TO	R8
		LMULT				;R8  = Y = ϊxW = XXXX.
;
		FROM	R12			;R12 = ̂̒S
		SUB	R11			;R0  = R0 - R11	;
		ADD	R0			;R0  = R0 * 2
		ADD	R3
		TO	R6
		LDW	(R0)
;
		FROM	R10
		NOT
		INC	R0
		TO	R3
		LMULT				;R3  = X = ϊwW = XXXX.
		DEC	R3
		BMI	C_32_X_ROTE_090
		INC	R3
		DEC	R3
C_32_X_ROTE_090
		IWT	R0, #CRT_ZPOS*010H
		TO	R5
		LMULT				;R5  = Y = ϊxW = XXXX.
;
		IBT	R9, #000H
		FROM	R7
		SUB	R3
		BPL	C_32_X_ROTE_100
		ADD	R3
;
		MOVE	R7, R3
		MOVE	R3, R0
		MOVE	R0, R8
		MOVE	R8, R5
		MOVE	R5, R0
;
		IBT	R9, #001H
C_32_X_ROTE_100
		NOP
		NOP
;
;>>>>>>>>>>
;function
; 32*32̃rbg}bvό`IuWFo͂B
;name
; TECSET_X
;entry
; R3     : X1
; R5     : Y1
; R7     : X2
; R8     : Y2
; R9     : \,0=\,1=
; CWORK0 : rbg}bvo͈ʒuiSA[POgj
; CWORK1 : rbg}bvo͈ʒuiSA[POgj
; REG13 : rbg}[vf[^qnloN
; REG14 : rbg}[vf[^qnlAhX
;return
;work
; R6  : x`pJE^
; R7  : rbg}bv擾pJE^ixWj
; R8  : YW / 20H * 100H = XX.XX   ixWkj
; R9  : rbg}bv擾pJE^iwWj
; R10 : XW / 20H * 100H = XX.XX   iwWkj
; R11 : YS / XS  * 100H = XX.XX   iXj
; R12 : w`pJE^
; R13 : wΕ`ʒu
; R14 : rbg}[vf[^qnlAhX
;<<<<<<<<<<
;
TECSET_X	EQU	$
;
		IBT	R0, #001H
		CMODE
;
		LMS	R1, CWORK0
		LMS	R2, CWORK1
;
		IBT	R12, #020H
;
		IBT	R0, #000H
		COLOR
;
		CACHE
;
		MOVE	R13, R15
TECSET_X_0
		IBT	R6, #004H
TECSET_X_1
		PLOT			;(0)
		PLOT			;(1)
		PLOT			;(2)
		PLOT			;(3)
		PLOT			;(4)
		PLOT			;(5)
		PLOT			;(6)
		DEC	R6
		BNE	TECSET_X_1
		PLOT			;(7)
;
		IWT	R4, #020H
		WITH	R1
		SUB	R4
		LOOP
		INC	R2
;
		NOP
		NOP
;
		IBT	R4, #010H
		LMS	R0, CWORK0
		ADD	R4
		SBK
;
		LMS	R0, CWORK1
		ADD	R4
		SBK
;
		IBT	R0, #000H
		CMODE
;
		IBT	R0,  #BANK TECSET_X_DT
		ROMB
;
		IWT	R0, #TECSET_X_DT
		TO	R14
		ADD	R9
		GETBS
		SMS	R0, CWORK2		;CWORK2 = LN^[f[^wZliEj
;
		FROM	R7
		TO	R13
		SUB	R3			;R13 = XS
		IWT	R0, #DIVBUF
		ADD	R13
		ADD	R13
		TO	R6
		LDW	(R0)			;R6 = 1 / XS = .XXXX
;
		FROM	R8
		SUB	R5
		LOB
		SWAP
		TO	R11
		LMULT				;R11 = YS / XS * 0100H = XX.XX = X
;
		LMS	R0,  REG13
		ROMB				;LN^[oNZbg
		LMS	R14, REG14		;LN^[AhXZbg
;
		IWT	R0, #01F0FH
		WITH	R14
		ADD	R0
		SMS	R14, CWORK3
;
;===E
;---E k߂
		MOVE	R0, R7
		INC	R0			;R0 = XR + 1 = XRW
		IWT	R4, #DIVBUF
		ADD	R0
		ADD	R4
		LDW	(R0)			;R0  = 1 / XRW = .XXXX
		IWT	R6, #010H*100H		;R6  = 010H * 100H
		TO	R10
		FMULT				;R10 = 10H / XRW * 100H = XX.XX = Ew̏k
;
		LMS	R1, CWORK0
;
		FROM	R3
		TO	R13
		NOT
;;;		INC	R13
		SMS	R13, CWORK5
;
		IBT	R9,  #000H		;rbg}bvp擾pJE^Zbg
		IBT	R12, #00FH
;
		CACHE		
;
TECSET_X_100	EQU	$
		INC	R13
		SMS	R14, CWORK4
;
		MOVE	R6, R11		;R11 = Y / X = XX.XX
		FROM	R13		;R13 = X CONTER = 00XX.
		LOB
		SWAP			;R0 = XX.00
		FMULT
		ADD	R5
;
		LMS	R4, CWORK1
		TO	R2
		ADD	R4
;
		INC	R0
		ADD	R0			;R0 = YW
		IWT	R4, #DIVBUF
		ADD	R0
		ADD	R4			;R0 = 1 / YW = .XXXX
		LDW	(R0)
		IWT	R6, #020H*100H		;R6 = 20H * 100H
		TO	R8
		FMULT				;R8 = 20H / YW * 100H = XX.XX = x̏k
;
		IBT	R6, #01FH
		IBT	R7, #000H
;
TECSET_X_200	EQU	$
		GETC
		PLOT
;
		DEC	R1
		DEC	R2
;
		WITH	R7
		ADD	R8
		IWT	R4, #0100H
TECSET_X_250	EQU	$
		FROM	R7
		SUB	R4			;擾|Cg
		BCC	TECSET_X_200
		NOP
		MOVE	R7, R0
		WITH	R14
		SUB	R4
		DEC	R6
		BPL	TECSET_X_250
		NOP
;
		LMS	R14, CWORK4
;
		INC	R1
;
		WITH	R9
		ADD	R10
		IWT	R4, #0100H
TECSET_X_270	EQU	$
		FROM	R9
		SUB	R4
		BCC	TECSET_X_100
		NOP
		MOVE	R9, R0
		LMS	R0, CWORK2
		WITH	R14
		ADD	R0
;
		DEC	R12
		BPL	TECSET_X_270
		NOP
;
;===
;--- k߂
		LMS	R14, CWORK3
;
;;		IWT	R4, #00100H
;;		WITH	R14
;;		SUB	R4
;
		FROM	R3
		NOT
		BPL	TECSET_X_280
		NOP
		INC	R0			;R0 = XL + 1 = XLW
TECSET_X_280
		IWT	R4, #DIVBUF
		ADD	R0
		ADD	R4
		LDW	(R0)			;R0  = 1 / XLW = .XXXX
		IWT	R6, #010H*100H		;R6  = 010H * 100H
		TO	R10
		FMULT				;R10 = 10H / XLW * 100H = XX.XX = Ew̏k
;
		LMS	R1, CWORK0
;
		DEC	R1
;
		LMS	R13, CWORK5
		INC	R13
;
		IBT	R9,  #000H		;rbg}bvp擾pJE^Zbg
		IBT	R12, #00FH
;
		CACHE		
;
TECSET_X_L100	EQU	$
		DEC	R13
		SMS	R14, CWORK4
;
		MOVE	R6, R11		;R11 = Y / X = XX.XX
		FROM	R13		;R13 = X CONTER = 00XX.
		LOB
		SWAP			;R0 = XX.00
		FMULT
		ADD	R5
;
		LMS	R4, CWORK1
		TO	R2
		ADD	R4
;
		INC	R0
		ADD	R0			;R0 = YW
		IWT	R4, #DIVBUF
		ADD	R0
		ADD	R4			;R0 = 1 / YW = .XXXX
		LDW	(R0)
		IWT	R6, #020H*100H		;R6 = 20H * 100H
		TO	R8
		FMULT				;R8 = 20H / YW * 100H = XX.XX = x̏k
;
		IBT	R6, #01FH
		IBT	R7, #000H
;
TECSET_X_L200	EQU	$
		GETC
		PLOT
;
		DEC	R1
		DEC	R2
;
		WITH	R7
		ADD	R8
		IWT	R4, #0100H
TECSET_X_L250	EQU	$
		FROM	R7
		SUB	R4			;擾|Cg
		BCC	TECSET_X_L200
		NOP
		MOVE	R7, R0
		WITH	R14
		SUB	R4
		DEC	R6
		BPL	TECSET_X_L250
		NOP
;
		LMS	R14, CWORK4
;
		DEC	R1
;
		WITH	R9
		ADD	R10
		IWT	R4, #0100H
TECSET_X_L270	EQU	$
		FROM	R9
		SUB	R4
		BCC	TECSET_X_L100
		NOP
		MOVE	R9, R0
		LMS	R0, CWORK2
		WITH	R14
		SUB	R0
;
		DEC	R12
		BPL	TECSET_X_L270
		NOP
;
		STOP
		NOP
;
TECSET_X_DT	EQU	$
		BYTE	001H, 0FFH		;\A	;Ȅꍇ̉Zl
;
;
;****************************************************************
;*								*
;*		[hQ nch obt@Zbg		*
;*					in			*
;*					R7 <- wave speed	*
;*					R8 <- scch1		*
;*					R9 <- sccv1		*
;*								*
;****************************************************************
SUINGDAT	EQU	$
;			[0] [1] [2] [3] [4] [5] [6] [7] [8] [9] [A] [B] [C] [D] [E] [F]
		BYTE	02H,03H,04H,03H,02H,03H,04H,04H,05H,06H,07H,08H,09H,0AH,0BH,0BH
		BYTE	0BH,0BH,0AH,09H,08H,07H,06H,05H,04H,05H,06H,07H,06H,05H,04H,03H
YGNSUING	EQU	$
		CACHE			; LbV X^[g !!
;
		SMS	R7,CWORK0
		SMS	R8,CWORK1
		SMS	R9,CWORK2
;
;-------------- H offset set ------------------------------------
		IWT	R0,#02000H
		TO	R3
		OR	R8		; R3 <- #02000H or scch1
		IWT	R2,#CBG2OFF
		IBT	R0,#00
		IWT	R5,#CBG2OFTBL
;
		IBT	R12,#020H
		MOVE	R13,R15
YGNSUING_000
		STB	(R5)		; chp
		INC	R5		;	e[u NA
		FROM	R3		; hp
		STW	(R2)		;	obt@ NA
		INC	R2
		LOOP
		INC	R2
		STB	(R5)
;
;-------------- ch `FbNp e[u Zbg ---------------
		IWT	R4,#CBG2OFST_CP
		FROM	R8		; scch1
		LSR			;  0000 0000 0000 0000
		LSR			;   |	  |	|
		LSR			;   +---+ +---+ +---+
		TO	R3		;	|     |	    |
		LSR			;  0000 0000 0000 0000
		FROM	R9		; sccv1
		LSR			;  0000 0000 0000 0000
		LSR			;   |	  |	|
		LSR			;   +---+ +---+ +---+
		TO	R10		;	|     |	    |
		LSR			;  0000 0000 0000 0000
;
		IBT	R12,#020
		MOVE	R13,R15
;
YGNSUING_100
		FROM	R4		; ʊO
		TO	R1		;	x`FbN
		ADD	#003H
		LDB	(R1)		; LDA  CBG2OFST_CP+3
		MOVE	R11,R0
		TO	R6
		ADD	#00BH		; R6 = #00B + R0
		MOVE	R1,R4
		INC	R1
		LDB	(R1)		; LDA  CBG2OFST_CP+1
		SUB	R10		; R0 = R0 - R10
		ADD	R11		; R0 = R0 + R11
		CMP	R6
		BEQ	YGNSUING_120
		NOP
		BCS	YGNSUING_150
		NOP
;
YGNSUING_120
		FROM	R4		; ʊO
		TO	R1		;	w`FbN
		ADD	#002		; R1 = #002 + R4
		LDB	(R1)		; LDA  CBG2OFST_CP+2
		MOVE	R11,R0
		TO	R6
		ADD	#00FH		; R6 = #00F + #001 + R0
		INC	R6		;
		LDB	(R4)		; LDA  CBG2OFST_CP
		SUB	R3		; R0 = R0 - R3
		MOVE	R5,R0
		ADD	R11		; R0 = R0 + R11
		CMP	R6
		BEQ	YGNSUING_125
		NOP
		BCS	YGNSUING_150
		NOP
;
YGNSUING_125
		IWT	R0,#CBG2OFTBL	; ItZbge[u
		IBT	R1,#032		;	GhAhXZbg
		TO	R6		;
		ADD	R1		; R6 = #CBG2OFTBL + #032
		DEC	R5
		WITH	R5
		ADD	R5		; R5 = R5 * 2
		TO	R5
		ADD	R5		; R5 = #CBG2OFTBL + R5
		INC	R11
		WITH	R11
		ADD	R11		; R11 = R11 * 2
		FROM	R8
		AND	#008
		BNE	YGNSUING_130
		INC	R5
		INC	R5
;
YGNSUING_130
		DEC	R11
		BMI	YGNSUING_150
		NOP
		IWT	R0,#CBG2OFTBL-1
		CMP	R5
		BEQ	YGNSUING_133
		NOP
		BCS	YGNSUING_135
		NOP
YGNSUING_133
		IBT	R0,#001
		STB	(R5)
YGNSUING_135
		FROM	R5
		CMP	R6
		BCC	YGNSUING_130
		INC	R5
;
YGNSUING_150
		WITH	R4
		ADD	#004		; R4 = #004 + R4
		LOOP
		NOP
;
;-------------- V offset set ------------------------------------
		IWT	R0,#02000H
		TO	R9
		OR	R9		; R9 <- #02000H or sccv1
		IBT	R0,#0F8H
		AND	R8		; R0 <- #0FFF8H and R8
		ADD	R0		; R0 = R0 * 2
		TO	R7
		ADD	R7		; R7 = R7 + R0
		IWT	R0,#000FFH
		AND	R7		; R0 <- #000FFH and R7
;
		IWT	R5,#CBG2OFTBL
		IBT	R12,#021H
		MOVE	R13,R15
;
YGNSUING_200
		TO	R1
		ADD	R0		; R1 = R0 * 2
;
		LDB	(R5)		; e[uf[^[h
		LOB			; ch nj?
		BNE	YGNSUING_220	;	NO -> YGNSUING_220
		NOP
		MOVE	R10,R9
		BRA	YGNSUING_240
		NOP
YGNSUING_220
		IWT	R0,#BANK SIN
		ROMB
		IWT	R14,#SIN
		WITH	R14
		ADD	R1		; R14 = R14 + R1
		GETB
		INC	R14
		TO	R6
		GETBH			; R6 <- sin data
		IWT	R0,#BANK SUINGDAT
		ROMB
		FROM	R7
		ADD	R7		; R0 = R7 * 2
		ADD	R0		; R0 = R0 * 2
		TO	R10
		SWAP
		IBT	R0,#01FH
		AND	R10		; R0 <- #01FH and R10
		IWT	R14,#SUINGDAT
		TO	R14
		ADD	R14		; R14 = R14 + R0
		GETB
		MOVE	R10,R0
		LMULT			; R4 = R0 * R6
		FROM	R4
		HIB
		ADD	R10		; R0 = R10 + R4
		LOB
		TO	R10
		ADD	R9		; R10 = R0 + R9(sccv1)
YGNSUING_240
		IBT	R0,#021H
		CMP	R12		; ЂƂ߂̃f[^Zbg ?
		BNE	YGNSUING_250	;	NO -> YGNSUING_250
		NOP
		IWT	R0,#CBG2OFV
		FROM	R10
		STW	(R0)
		BRA	YGNSUING_260
YGNSUING_250
		FROM	R10
		STW	(R2)
		INC	R2
		INC	R2
YGNSUING_260
		WITH	R8
		ADD	#008		; R8 = #008 + R8
		WITH	R7
		ADD	#00FH		; R7 = #00F + #001 + R7
		INC	R7		;
		IWT	R0,#000FFH
		AND	R7		; R0 <- #000FFH and R7
		LOOP
		INC	R5		; e[uAhX + 1
;
;;;;K;;;;		STOP
;;;;K;;;;		NOP
;
;
;****************************************************************
;*								*
;*		[hQ tJ obt@Zbg		*
;*				in				*
;*				cwrk0 : EF[u Xs[h	*
;*				cwrk1 : scch1			*
;*				cwrk2 : sccv1			*
;*								*
;****************************************************************
FKNSUING	EQU	$
;;;;K;;;;		CACHE			; LbV X^[g !!
;
;-------------- e[u obt@ NA ------------------------
		IWT	R5,#CBG2OFTBL
		IBT	R0,#000
		IBT	R12,#020H
		MOVE	R13,R15
FKNSUING_000
		STB	(R5)
		LOOP
		INC	R5
		STB	(R5)
;
;-------------- ch `FbNp e[u Zbg ---------------
		IWT	R4,#BG2FKN_CP
		LMS	R0,CWORK1	; scch1
		MOVE	R8,R0
		LSR			;  0000 0000 0000 0000
		LSR			;   |	  |	|
		LSR			;   +---+ +---+ +---+
		TO	R3		;	|     |	    |
		LSR			;  0000 0000 0000 0000
		LMS	R0,CWORK2	; sccv1
		LSR			;  0000 0000 0000 0000
		LSR			;   |	  |	|
		LSR			;   +---+ +---+ +---+
		TO	R10		;	|     |	    |
		LSR			;  0000 0000 0000 0000
;
		IBT	R12,#020
		MOVE	R13,R15
;
FKNSUING_100
		FROM	R4		; ʊO
		TO	R1		;	x`FbN
		ADD	#003H
		LDB	(R1)		; LDA  CBG2FKN_CP+3
		MOVE	R11,R0
		TO	R6
		ADD	#00BH		; R6 = #00B + R0
		MOVE	R1,R4
		INC	R1
		LDB	(R1)		; LDA  CBG2FKN_CP+1
		SUB	R10		; R0 = R0 - R10
		ADD	R11		; R0 = R0 + R11
		CMP	R6
		BEQ	FKNSUING_120
		NOP
		BCS	FKNSUING_150
		NOP
;
FKNSUING_120
		FROM	R4		; ʊO
		TO	R1		;	w`FbN
		ADD	#002		; R1 = #002 + R4
		LDB	(R1)		; LDA  CBG2FKN_CP+2
		MOVE	R11,R0
		TO	R6
		ADD	#00FH		; R6 = #00F + #001 + R0
		INC	R6		;
		LDB	(R4)		; LDA  CBG2FKN_CP
		SUB	R3		; R0 = R0 - R3
		MOVE	R5,R0
		ADD	R11		; R0 = R0 + R11
		CMP	R6
		BEQ	FKNSUING_125
		NOP
		BCS	FKNSUING_150
		NOP
;
FKNSUING_125
		IWT	R0,#CBG2OFTBL	; ItZbge[u
		IBT	R1,#032		;	GhAhXZbg
		TO	R6		;
		ADD	R1		; R6 = #CBG2OFTBL + #032
		WITH	R5
		ADD	R5		; R5 = R5 * 2
		TO	R5
		ADD	R5		; R5 = #CBG2OFTBL + R5
		INC	R11
		WITH	R11
		ADD	R11		; R11 = R11 * 2
		FROM	R8
		AND	#008
		BNE	FKNSUING_130
		DEC	R5
		INC	R5
;
FKNSUING_130
		FROM	R4
		ADD	#005
		TO	R9
		LDB	(R0)
FKNSUING_131
		DEC	R11
		BMI	FKNSUING_150
		NOP
		IWT	R0,#CBG2OFTBL-1
		CMP	R5
		BEQ	FKNSUING_133
		NOP
		BCS	FKNSUING_135
		NOP
FKNSUING_133
		FROM	R9		; ړʂ e[u obt@
		STB	(R5)		;	Zbg !!
FKNSUING_135
		FROM	R5
		CMP	R6
		BCC	FKNSUING_131
		INC	R5
;
FKNSUING_150
		WITH	R4
		ADD	#006		; R4 = #006 + R4
		LOOP
		NOP
;
;-------------- eړ f[^Zbg----------------------------
		IBT	R0,#BANK SIN
		ROMB
		LMS	R1,CWORK0
		IWT	R0,#001FEH
		AND	R1
		IWT	R1,#SIN
		TO	R14
		ADD	R1
		GETB
		INC	R14
		TO	R6
		GETBH			; R6 <- TC f[^
;
		IBT	R12,#020
		IWT	R0,#BG2FKN_CP
		TO	R5
		ADD	#004
		MOVE	R13,R15
;
FKNSUING_180
		MOVE	R1,R5
;
		LDB	(R1)		; R0 <- 
		SEX
		INC	R1
;
		LMULT
		FROM	R4
		HIB
		SEX
		STB	(R1)		; ړʃZbg
;
		WITH	R5
		ADD	#006		;  AhX Zbg
		LOOP
		NOP
;
;-------------- V offset set ------------------------------------
		IWT	R2,#CBG2OFF+040H-2	;ItZbg e[uAhX
		IWT	R5,#CBG2OFTBL
		IWT	R3,#CBG2OFV
		IWT	R0,#02000H
		LMS	R11,CWORK2	; R11 <- sccv1
		TO	R11
		OR	R11
		IBT	R12,#021H
		MOVE	R1,R12
		MOVE	R13,R15
;
FKNSUING_200
		LDB	(R5)		; e[uf[^[h !!
		SEX			; ch nj?
		BEQ	FKNSUING_255	;	NO -> FKNSUING_255
		TO	R10
		ADD	R11
		FROM	R1
		CMP	R12		; ЂƂ߂̃f[^Zbg ?
		BNE	FKNSUING_250	;	NO -> FKNSUING_250
		FROM	R10
		STW	(R3)
		BRA	FKNSUING_255
		NOP
FKNSUING_250
		STW	(R2)		; ItZbg@f[^Zbg
FKNSUING_255
		INC	R2
		INC	R2
FKNSUING_260
		LOOP
		INC	R5		; e[uAhX + 1
;
		STOP
		NOP
;
		mEND_NOP2
;
		END
;
