;************************************************************************
;*									*
;*	title name	: "yossy"					*
;*	proccess	: course BG write main				*
;*	file name	: ys_bgsc					*
;*									*
;************************************************************************
;
;
		SALL
;
		include		yst_header.inc
		include		../../../JPN/sfc/ys_unit.h
;
		XALL
;
;
;------------------------------------------------------------------------
;-		global symbol						-
;------------------------------------------------------------------------
		GLB	BG3SCK,RUTSET
		GLB	UNITCHG
;
;-------------- BG chenge no. ------------------------------------------
		GLB	BLK0,BGCG,DBG0	;DROP,DRCL
		GLB	KPCL,DWCG,BCG2,TGTM,CNCL
;
;------------------------------------------------------------------------
;-		extern symbol						-
;------------------------------------------------------------------------
;
;-------------< ys_main >------------------------------------------------
		EXT	BGSCWTL
;
;-------------< ys_rpro >------------------------------------------------
		EXT	CHIPON,NEWVMADL,VMADSPL
		EXT	BLUE_COIN_ST_SB
;
;-------------< ys_bgsc0 >-----------------------------------------------
		EXT	KOTEISB,KAHENSB
		EXT	CHKCHG_DAT0,CHKCHG_DAT1,CHKCHG_DAT2,CHKCHG_DAT3,CHKCHG_DAT4
;
;-------------< ys_unit >------------------------------------------------
		EXT	UNDTADD,UNDATA,RUTDATA
;
;-------------< ys_game >------------------------------------------------
		EXT	BGCIN_STCHK_ADR,BGCIN_STCHK_DAT
;
;------------------------------------------------------------------------
;-		define symbol						-
;------------------------------------------------------------------------
;;;;		EQU
;
;
;************************************************************************
;*									*
;*		program start						*
;*									*
;************************************************************************
;
;
		EXTEND
;
;
		MEM8
		IDX8
;
Group_0		GROUP	Bgsc_pro
Bgsc_pro	SECT	REL
;
;************************************************************************
;*		"mogura" course BG3 screen set check			*
;************************************************************************
;
BG3SCK		EQU	$
		LDA	BG3TYP
		CMP	#0AH
		BEQ	B3SC020		;"mogura" course ? ( yes:B3SC020 )
B3SC010		EQU	$
		RTL
;
B3SC020		EQU	$
		LDA	<BGWHF1
		ORA	<BGWVF1
		BEQ	B3SC010		;BG write timming ? ( no:B3SC010 )
;
		M16
;
		LDA	#0C07FH		;(R6) <-- convert AND data
		STA	R6
		LDA	#02100H		;(R7) <--    "    OR   "
		STA	R7
		LDA	<BGWAV1_00
		BIT	#0400H
		BEQ	B3SC022
		ORA	#020H
B3SC022		EQU	$
		AND	#03EH
		STA	R8	       ;(R8) <-- V scroll write start buffer pointer
;
		LDX	#BANK BG3SCST
		LDA	#BG3SCST
		JSL	>CHIPON
;
		PHB			;(DBR) save
		LDX	#BANK VRAMDX
		PHX
		PLB
;
		I16
;
		LDX	VRAMDX		;(X) <-- VRAMDX index
;
		LDA	<BGWHF1
		BEQ	B3SC040		;H scroll BG write ? ( no:B3SC040 )
;
;-------------- BG3 H scroll BG write ---------------------------
		LDA	<BGWAH1_0
		AND	#07FFH
		BIT	#0400H
		BEQ	BGSC030
		EOR	#0400H|020H
BGSC030		EQU	$
		LSR	A
		ORA	#3400H
		STA	0,X		;VRAM address set
		LDA	#10000001B+(00000001B*100H)
		STA	2,X		;inc mode & DMA parameter set
		LDA	#18H+(LOW BG3HSCRBF)*100H
		STA	4,X		;B bus address & A bus address(L) set
		LDA	#BG3HSCRBF/100H
		STA	6,X		;A bus address(H,B) set
		LDA	#020H*2
		STA	8,X		;number of byte
		TXA
		CLC
		ADC	#12
		STA	10,X		;next data address set
		TAX
;
B3SC040		EQU	$
		LDA	<BGWVF1
		BEQ	B3SC050		;V scroll BG write ? ( no:B3SC050 )
;
;-------------- BG3 V scroll BG write ---------------------------
		LDA	<BG3WSCV
		AND	#01F0H
		ASL	A
		ORA	#3400H
		STA	0,X		;VRAM address set
		LDA	#10000000B+(00000001B*100H)
		STA	2,X		;inc mode & DMA parameter set
		LDA	#18H+(LOW BG3VSCRBF)*100H
		STA	4,X		;B bus address & A bus address(L) set
		LDA	#BG3VSCRBF/100H
		STA	6,X		;A bus address(H,B) set
		LDA	#020H*2
		STA	8,X		;number of byte
		TXA
		CLC
		ADC	#12
		STA	10,X		;next data address set
		TAX
;
B3SC050		EQU	$
		STX	VRAMDX		;end address set
;
		PLB
;
		MI8
;
		RTL
;
;************************************************************************
;*		base unit data set					*
;************************************************************************
;
		MEM8
		IDX8
;
RUTSET		EQU	$
		LDA	#BANK RUT0200	;(WK2) <-- ram unit address(B)
		STA	<WORK2
;
		MI16
;
		LDX	#0		;(X) <-- base unit data set data pointer
RUTS010		EQU	$
		STX	<WORK3		;(WK3,4) <-- base unit data set data pointer
;
		LDA	>RUTDATA,X
		AND	#00FFH
		BEQ	RUTS050		;end ? ( yes:RUTS050 )
;
		TAY
		LDA	>RUTDATA+1,X
		STA	<WORK0		;(WK0,1,2) <-- ram unit address(L,H)
;
		LDA	BG1TYP
		ASL	A
;;;;		CLC
		ADC	<WORK3
		TAX
		LDA	>RUTDATA+3,X	;(A) <-- base unit course data
		TYX			;(X) <-- number of data byte
		LDY	#00		;(Y) <-- ram unit pointer
RUTS020		EQU	$
		STA	[<WORK0],Y
		INC	A
		INY
		INY
		DEX
		BNE	RUTS020
;
		LDA	<WORK3
		CLC
		ADC	#1+2+(2*16)	;[ 1:number of unit 2:ram unit address (2*8):unit data address ]
		TAX
		BRA	RUTS010
;
RUTS050		EQU	$
;
		MI8
;
		RTL
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		BG & unit_no. chenge program				x
;x			BGCGNO <--- chenge no.				x
;x			BGXPS1 <---    "   X_pos                        x
;x			BGYPS1 <---    "   Y_pos                        x
;x		      ( BGUTNO <--- chenge unit no. )			x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;
		MEM16
		IDX8
;
UNITCHG		EQU	$
		PHP			;(P) save
		PHB			;(DBR) save
		PHK			;(DBR) <-- (PBR)
		PLB
;
		PHD			;(D) save
		LDA	#0000		;(D) <-- 0
		TCD
;
		MI16			; memory , index 16bit mode
;
;-------------- afGA`FbN ------------------------------
		LDA	<BGXPS1
		AND	#0FFF0H
		SEC
		SBC	WRSCH1
		CLC
		ADC	#010H
		STA	<WORK12		;(WK12) <-- af`FbNw
;
		LDA	<BGYPS1
		AND	#0FFF0H
		SEC
		SBC	WRSCV1
		CLC
		ADC	#010H
		STA	<WORK14		;(WK14) <-- af`FbNx
;
		LDA	<BGYPS1
		TAY
		AND	#0700H
		LSR	A
		LSR	A
		LSR	A
		LSR	A
		STA	<WORK0
		TYA
		AND	#00F0H
		ASL	A
		STA	<WORK2
		ASL	A
		STA	<WORK7
;
		LDA	<BGXPS1
		TAY
		AND	#000F0H
		LSR	A
		LSR	A
		LSR	A
		TSB	<WORK2
		TYA
		AND	#001F0H
		LSR	A
		LSR	A
		LSR	A
		BIT	#00100H>>3
		BEQ	UNCNG010
;
		EOR	#0400H|(0100H>>3)
UNCNG010	EQU	$
		TSB	<WORK7		;(WK7) <-- uq`lAhX
;
		TYA
		AND	#0F00H
		XBA
		ORA	<WORK0
		STA	<WORK10		;(WK10) <-- tmate`c|C^[
		TAX
;
		LDA	UNBUFAD-1,X
		AND	#03F00H
		ASL	A
		TSB	<WORK2		;(WK2) <-- aftmhs|C^[
;
		LDA	<BGCGNO
		ASL	A
		TAX
		JSR	(!CHEGADD,X)
;
		PLD
		PLB
		PLP
		RTL
;
CHEGADD		EQU	$
BLOK0		WORD	BLK0EST		; eat block chenge set !!
BGCHG		WORD	BGCHGST		; BG change set
DWBG0		WORD	DWBG0ST		; ւݏ change set !!
;;;;DOROP	    WORD    DOROPST	    ; {[iXhAI[v
;;;;DORCL	    WORD    DORCLST	    ;	   "      N[Y
KPCLR		WORD	KPBGCLR		; Nbpaf
DWCHG		WORD	DWCHGST		; ̍YafāÂaf
BGCG2		WORD	BGCGST2		; BG change set ikLȂ珑j
TGTAMA		WORD	TOGETAMA	; Ƃ̋
BGCINCLS	WORD	BGCOINCLS	; afRC NA
;
;
BLK0		EQU	(BLOK0-CHEGADD)/2
BGCG		EQU	(BGCHG-CHEGADD)/2
DBG0		EQU	(DWBG0-CHEGADD)/2
;;;;DROP	    EQU	    (DOROP-CHEGADD)/2
;;;;DRCL	    EQU	    (DORCL-CHEGADD)/2
KPCL		EQU	(KPCLR-CHEGADD)/2
DWCG		EQU	(DWCHG-CHEGADD)/2
BCG2		EQU	(BGCG2-CHEGADD)/2
TGTM		EQU	(TGTAMA-CHEGADD)/2
CNCL		EQU	(BGCINCLS-CHEGADD)/2
;
;
		MEM16
		IDX16
;
;************************************************************************
;*		Hׂaf					*
;************************************************************************
;
BLK0EST		EQU	$
;
;-------------- Hׂaf --------------------------------------
		LDA	<WORK7
		STA	<WORK4
		LDA	<WORK12
		STA	<WORK16
		LDA	<WORK14
		STA	<WORK18
;
		LDX	<WORK2
		LDA	>BGUNIT,X
		TAY
		AND	#0FF00H
		XBA
		SEC
		SBC	#01AH
		CMP	#03H
		BCC	BKT000		; block unit_No. (H) ?
		RTS
;
BKT000		EQU	$
		PHB			  ;(DBR) save
;
		M8
;
		LDA	#BANK CHKCHG_DAT0 ;(DBR) <-- CHKCHG_DAT0(B)
		PHA
		PLB
;
		M16

		TYA
		AND	#00FFH
		ASL	A
		TAY
		LDA	!CHKCHG_DAT4,Y
		BEQ	BKT010		;kL ? ( yes:BKT010 )
;
		TAY
		LDA	0,Y
BKT010		EQU	$
		STA	>BGUNIT,X
		JSR	VRAMDST
;
;-------------- ̂af ----------------------------------------
		JSR	CHGBG_SET_UP
		LDA	<WORK0		; max over ?
		BNE	BKT200		;	YES -> BKT200
;
		LDA	>BGUNIT,X
		TAY
		AND	#0FF00H
		XBA
		SEC
		SBC	#01AH
		CMP	#03H
		BCS	BKT200		; unit_No. (H) = block ?
;					; Yes!
		TYA
		AND	#00FFH
		ASL	A
		TAY
		LDA	!CHKCHG_DAT0,Y
		TAY
		LDA	0,Y
		CMP	>BGUNIT,X
		BEQ	BKT200
;
		STA	>BGUNIT,X	; unit_No. set
		JSR	VRAMDST
;
;-------------- ̂af ----------------------------------------
BKT200		EQU	$
		JSR	CHGBG_SET_LFT
		LDA	<WORK0		; max over ?
		BNE	BKT400		;	YES -> BKT400
;
		LDA	>BGUNIT,X
		TAY
		AND	#0FF00H
		XBA
		SEC
		SBC	#01AH
		CMP	#03H
		BCS	BKT400		; block unit_No. (H) ?
;					; Yes!
		TYA
		AND	#00FFH
		ASL	A
		TAY
		LDA	!CHKCHG_DAT3,Y
		TAY
		LDA	0,Y
		CMP	>BGUNIT,X
		BEQ	BKT400
;
		STA	>BGUNIT,X	; change unit_No. set
		JSR	VRAMDST
;
;-------------- Êaf ----------------------------------------
BKT400		EQU	$
		JSR	CHGBG_SET_RIT
		LDA	<WORK0		; max over ?
		BNE	BKT600		;	YES -> BKT600
;
		LDA	>BGUNIT,X
		TAY
		AND	#0FF00H
		XBA
		SEC
		SBC	#01AH
		CMP	#03H
		BCS	BKT600
;
		TYA
		AND	#00FFH
		ASL	A
		TAY
		LDA	!CHKCHG_DAT2,Y
		TAY
		LDA	0,Y
		CMP	>BGUNIT,X
		BEQ	BKT600
;
		STA	>BGUNIT,X
		JSR	VRAMDST
;
;-------------- ̂af ----------------------------------------
BKT600		EQU	$
		JSR	CHGBG_SET_DWN
		LDA	<WORK0		; max over ?
		BNE	BKT800		;	YES -> BKT800
;
		LDA	>BGUNIT,X
		TAY
		AND	#0FF00H
		XBA
		SEC
		SBC	#01AH
		CMP	#03H
		BCS	BKT800
;
		TYA
		AND	#00FFH
		ASL	A
		TAY
		LDA	!CHKCHG_DAT1,Y
		TAY
		LDA	0,Y
		CMP	>BGUNIT,X
		BEQ	BKT800
;
		STA	>BGUNIT,X
		JSR	VRAMDST
;
BKT800		EQU	$
		LDA	>VRAMDSP
		TAX
		LDA	#0FFFFH
		STA	>VRAMDSP+2,X	;end code set
;
		PLB
		RTS
;
;
;
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+	̂af̃AhX`FbN  Zbg		+
;+			out				+
;+			wrk7,8	: uq`lAhX	+
;+			X	: unit buffer index	+
;+			wrk0,1	: max over chack	+
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
CHGBG_SET_UP	EQU	$
		LDA	<WORK18		;af`FbNxZbg
		SEC
		SBC	#010H
		STA	<WORK14
;
		STZ	<WORK0
		LDA	<WORK4
		SEC
		SBC	#00040H
		STA	<WORK7
		LDA	<WORK2
		SEC
		SBC	#010H*2
		TAX
		AND	#001E0H
		CMP	#001E0H
		BNE	CHGBG_UP_900
;
		LDA	<WORK10
		SEC
		SBC	#010H		; max over ?
		BPL	CHGBG_UP_100	;	NO -> CHGBG_UP_100
		INC	<WORK0
;
CHGBG_UP_100	EQU	$
		TXY
		TAX
		LDA	<WORK7
		CLC
		ADC	#00400H
		AND	#007FFH
		STA	<WORK7		; V-ram address set
		LDA	UNBUFAD-1,X
		AND	#3F00H
		ASL	A
		STA	<WORK9
		TYA
		AND	#01FFH
		ORA	<WORK9
		TAX			; unit buffer index set
;
CHGBG_UP_900	EQU	$
		RTS
;
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+	̂af̃AhX`FbN  Zbg		+
;+			out				+
;+			wrk7,8	: uq`lAhX	+
;+			X	: unit buffer index	+
;+			wrk0,1	: max over chack	+
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
CHGBG_SET_LFT	EQU	$
		LDA	<WORK16		;af`FbNwZbg
		SEC
		SBC	#010H
		STA	<WORK12
;
		STZ	<WORK0
		LDA	<WORK4
		DEC	A
		DEC	A
		STA	<WORK7
		LDA	<WORK2
		DEC	A
		DEC	A
		TAX
		AND	#0001EH
		CMP	#0001EH
		BNE	CHGBG_LFT_900
;
		LDA	<WORK10
		BIT	#0000FH		; max over ?
		BNE	CHGBG_LFT_100	;	NO -> CHGBG_LFT_100
		INC	<WORK0
;
CHGBG_LFT_100	EQU	$
		LDA	<WORK10
		DEC	A
		TXY
		TAX
		LDA	<WORK7
		CLC
		ADC	#0420H
		AND	#07FFH
		STA	<WORK7		; V-ram address set
		LDA	UNBUFAD-1,X
		AND	#3F00H
		ASL	A
		STA	<WORK9
		TYA
		CLC
		ADC	#0020H
		AND	#01FFH
		ORA	<WORK9
		TAX			; unit buffer index set
;
CHGBG_LFT_900	EQU	$
		RTS
;
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+	Êaf̃AhX`FbN  Zbg		+
;+			out				+
;+			wrk7,8	: uq`lAhX	+
;+			X	: unit buffer index	+
;+			wrk0,1	: max over chack	+
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
CHGBG_SET_RIT	EQU	$
		LDA	<WORK16		;af`FbNwZbg
		CLC
		ADC	#010H
		STA	<WORK12
;
		STZ	<WORK0
		LDA	<WORK4
		INC	A
		INC	A
		STA	<WORK7
		LDA	<WORK2
		INC	A
		INC	A
		TAX
		AND	#0001EH
		BNE	CHGBG_RIT_900
;
		LDA	<WORK10
		INC	A
		BIT	#0FH		; max over ?
		BNE	CHGBG_RIT_100	;	NO -> CHGBG_RIT_100
		INC	<WORK0
;
CHGBG_RIT_100	EQU	$
		TXY
		TAX
		LDA	<WORK7
		SEC
		SBC	#0420H
		AND	#07FFH
		STA	<WORK7		; V-ram address set
		LDA	UNBUFAD-1,X
		AND	#3F00H
		ASL	A
		STA	<WORK9
		TYA
		SEC
		SBC	#0020H
		AND	#01FFH
		ORA	<WORK9
		TAX			; unit buffer index set
;
CHGBG_RIT_900	EQU	$
		RTS
;
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+	̂af̃AhX`FbN  Zbg		+
;+			out				+
;+			wrk7,8	: uq`lAhX	+
;+			X	: unit buffer index	+
;+			wrk0,1	: max over chack	+
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
CHGBG_SET_DWN	EQU	$
		LDA	<WORK18		;af`FbNxZbg
		CLC
		ADC	#010H
		STA	<WORK14
;
		STZ	<WORK0
		LDA	<WORK4
		CLC
		ADC	#00040H
		STA	<WORK7
;
		LDA	<WORK2
		CLC
		ADC	#00020H
		TAX
		AND	#001E0H
		BNE	CHGBG_DWN_900
;
		LDA	<WORK10
		CLC
		ADC	#010H
		BIT	#070H		; max over ?
		BNE	CHGBG_DWN_100	;	NO -> CHGBG_DWN_100
		INC	<WORK0
;
CHGBG_DWN_100	EQU	$
		TXY
		TAX
;
		LDA	<WORK7
		SEC
		SBC	#00400H
		AND	#007FFH
		STA	<WORK7		; V-ram address set
		LDA	UNBUFAD-1,X
		AND	#3F00H
		ASL	A
		STA	<WORK9
		TYA
		AND	#01FFH
		ORA	<WORK9
		TAX			; unit buffer index set
;
CHGBG_DWN_900	EQU	$
		RTS
;
;************************************************************************
;*		ւݏaf					*
;************************************************************************
;
DWBG0ST		EQU	$
		LDY	#0
DWBG0ST_010	EQU	$
		LDX	<WORK2		;(X) <-- BG unit buffer pointer
		LDA	>BGUNIT,X
		STA	WORK20,Y	;(WK20-) <-- old unit no. set
		AND	#0FF00H
		CMP	#06100H
		BEQ	DWBG0ST_012	;ւݏH ( yes:DWBG0ST_012 )
		CMP	#06200H
		BEQ	DWBG0ST_012	;	      "
;
		LDA	#UT6108+1
		STA	WORK20,Y
		BRA	DWBG0ST_014
;
DWBG0ST_012	EQU	$
		LDA	BGUTNO		;(A) <-- change unit no.
		STA	>BGUNIT,X
		PHY			;(Y) save
		JSR	VRAMDST
		PLY			;(Y) load
;
DWBG0ST_014	EQU	$
		INC	BGUTNO		;next change unit no. set
;
		LDA	<WORK12		;af`FbNwZbg
		CLC
		ADC	#010H
		STA	<WORK12
;
		LDA	<WORK7
		INC	A
		INC	A
		STA	<WORK7
		LDA	<WORK2
		INC	A
		INC	A
		STA	<WORK2
		BIT	#0FH*2
		BNE	DWBG0ST_020	;X pos(H) change ? ( no:DWBG0ST_020 )
;
		SEC
		SBC	#10H*2
		AND	#01FFH
		STA	<WORK2
		LDA	<WORK7
		SEC
		SBC	#0420H
		AND	#07FFH
		STA	<WORK7
		LDX	<WORK10
		INX
		LDA	UNBUFAD-1,X
		AND	#3F00H
		ASL	A
		TSB	<WORK2
DWBG0ST_020	EQU	$
		INY
		INY
		CPY	#3*2
		BCC	DWBG0ST_010
;
		LDA	>VRAMDSP
		TAX
		LDA	#0FFFFH
		STA	>VRAMDSP+2,X	;end code set
		RTS
;
;************************************************************************
;*		Nbpaf					*
;************************************************************************
KPBGCK_UNIT	EQU	$
		WORD	UT9D05,UT9DAA,UT9DA3,UT9DA0,UT9DAD,UT9DA6,UT9DA9
KPBGCG_UNIT	EQU	$
		WORD	UTA562,UTA563,UTA561,UTA562,UTA563,UTA560,UTA561
;
KPBGCLR		EQU	$
		LDY	BGUTNO
KPBGCLR_0050	EQU	$
		PHY			;(Y) save
;
		LDX	<WORK2		;(X) <-- BG unit buffer pointer
		TYA
		BEQ	KPBGCLR_0100	;[H ( yes:KPBGCLR_0100 )
		CPY	BGUTNO
		BNE	KPBGCLR_0250	;E[H ( no:KPBGCLR_0250 )
;
;-------------- [jbg`FbN --------------------------------------
KPBGCLR_0100	EQU	$
		LDY	#KPBGCG_UNIT-KPBGCK_UNIT-2
		LDA	>BGUNIT,X
KPBGCLR_0150	EQU	$
		CMP	!KPBGCK_UNIT,Y
		BNE	KPBGCLR_0200
;
		LDA	!KPBGCG_UNIT,Y
		BRA	KPBGCLR_0300
;
KPBGCLR_0200	EQU	$
		DEY
		DEY
		BPL	KPBGCLR_0150
;
;-------------- ԃjbg --------------------------------------------
KPBGCLR_0250	EQU	$
		LDA	#UT0000
KPBGCLR_0300	EQU	$
		STA	>BGUNIT,X
		JSR	VRAMDST
;
		LDA	<WORK12		;af`FbNwZbg
		CLC
		ADC	#010H
		STA	<WORK12
;
		LDA	<WORK7
		INC	A
		INC	A
		STA	<WORK7
		LDA	<WORK2
		INC	A
		INC	A
		STA	<WORK2
		BIT	#0FH*2
		BNE	KPBGCLR_0350	;X pos(H) change ? ( no:KPBGCLR_0350 )
;
		SEC
		SBC	#10H*2
		AND	#01FFH
		STA	<WORK2
		LDA	<WORK7
		SEC
		SBC	#0420H
		AND	#07FFH
		STA	<WORK7
		LDX	<WORK10
		INX
		LDA	UNBUFAD-1,X
		AND	#3F00H
		ASL	A
		TSB	<WORK2
KPBGCLR_0350	EQU	$
		PLY			;(Y) load
;
		DEY
		DEY
		BMI	KPBGCLR_0400
		JMP	KPBGCLR_0050
;
KPBGCLR_0400	EQU	$
		LDA	>VRAMDSP
		TAX
		LDA	#0FFFFH
		STA	>VRAMDSP+2,X	;end code set
		RTS
;
;************************************************************************
;*		̍YafāÂaf			*
;************************************************************************
KUI_CHANGE_DOWN EQU	$
; ̃jbgmD ->	    UT6B00     UT6B01	  UT6B02     UT6B03
		BYTE	LOW UT6B00,LOW UT6B00,LOW UT6B03,LOW UT6B03
; ̃jbgmD ->	    UT6B10     UT6B11	  UT6B12     UT6B13
		BYTE	LOW UT6B10,LOW UT6B10,LOW UT6B13,LOW UT6B13
; ̃jbgmD ->	    UT6B20     UT6B21	  UT6B22     UT6B23
		BYTE	LOW UT6B20,LOW UT6B20,LOW UT6B23,LOW UT6B23
; ̃jbgmD ->	    UT6B30     UT6B31	  UT6B32     UT6B33
		BYTE	LOW UT6B30,LOW UT6B30,LOW UT6B33,LOW UT6B33
; ̃jbgmD ->	    UT6B60     UT6B61	  UT6B62     UT6B63
		BYTE	LOW UT6B60,LOW UT6B60,LOW UT6B63,LOW UT6B63
;
;
DWCHGST		EQU	$
		LDA	!DSPMOD
		CMP	#00009		; [hV̏ ?
		BNE	DWCHGST_000	;	NO -> DWCHGST_000
		JMP	MD7KUI_CHG
;
DWCHGST_000	EQU	$
		LDX	<WORK2		;(X) <-- BG unit buffer pointer
		LDA	>BGUNIT,X
		AND	#0FF00H
		CMP	#UTA300		; ԃRC ?
		BNE	DWCHGST_010	;	NO -> DWCHGST_010
		LDA	<WORK0
		PHA
		LDA	<WORK2
		PHA
		LDA	<WORK7
		PHA
		JSR	BG_BIT_ON
		JSL	>BLUE_COIN_ST_SB
		PLA
		STA	<WORK7
		PLA
		STA	<WORK2
		PLA
		STA	<WORK0
;
DWCHGST_010	EQU	$
		LDX	<WORK2		;(X) <-- BG unit buffer pointer
		LDA	<BGUTNO		;(A) <-- change unit no.
		STA	>BGUNIT,X
		JSR	VRAMDST
;
		LDA	<WORK7
		STA	<WORK4
		LDA	<WORK14
		STA	<WORK18
		JSR	CHGBG_SET_DWN
		LDA	<WORK0		; max over ?
		BNE	DWCHGST_090	;	YES -> DWCHGST_090
;
DWCHGST_020	EQU	$
		LDA	>BGUNIT,X
		AND	#000FFH
		TAY
		LDA	!KUI_CHANGE_DOWN,Y
		AND	#000FFH
		TAY
		LDA	>BGUNIT,X
		AND	#0FF00H
		CMP	#UT6B00		; ̃jbg͍Y H
		BEQ	DWCHGST_050	;	YES -> DWCHGST_050
		CMP	#UTA300		; ̃jbǵHY H
		BNE	DWCHGST_090	;	NO -> DWCHGST_030
		TYA
		ORA	#UTA300
		BRA	DWCHGST_055
;
DWCHGST_050	EQU	$
		TYA
		ORA	#UT6B00
DWCHGST_055	EQU	$
		STA	>BGUNIT,X
		JSR	VRAMDST
;
DWCHGST_090	EQU	$
		LDA	>VRAMDSP
		TAX
		LDA	#0FFFFH
		STA	>VRAMDSP+2,X	;end code set
		RTS
;
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+		[hV̏				+
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
MD7KUI_CHG_CMP	EQU	$
		WORD	005C8H,005DCH
		WORD	005D2H,007C6H
MD7KUI_CHG_END	EQU	$
;
MD7KI_CHG_DT00	EQU	$
		HEX	086H,086H,0B0H
		HEX	086H,086H,0B1H
;
MD7KI_CHG_DT01	EQU	$
		HEX	0B6H,0C6H,0C6H
		HEX	0B7H,0C6H,0C6H
;
MD7KI_CHG_DT02	EQU	$
		HEX	0C2H,08AH,08AH
		HEX	0C3H,08BH,08BH
;
MD7KI_CHG_DT03	EQU	$
		HEX	08AH,08AH,0BCH
		HEX	08BH,08BH,0BDH
;
MD7KI_CHG_DT10	EQU	$
		HEX	0ACH,0AEH,003H
		HEX	0ADH,0AFH,004H
;
MD7KI_CHG_DT11	EQU	$
		HEX	043H,0B2H,0B4H
		HEX	044H,0B3H,0B5H
;
MD7KI_CHG_DT12	EQU	$
		HEX	023H,0BEH,0BFH
		HEX	02CH,0C0H,0C1H
;
MD7KI_CHG_DT13	EQU	$
		HEX	0B8H,0B9H,01FH
		HEX	0BAH,0BBH,024H
;
MD7KI_CHG_ADR0	EQU	$
		WORD	00B9FH,0121FH
		WORD	00F25H,00F18H
;
MD7KI_CHG_ADR1	EQU	$
		WORD	00BA0H,01220H
		WORD	00FA5H,00F98H
;
;
MD7KI_CHG_CNT0	EQU	$
MD7KI_CHG_CNT1	EQU	$
		WORD	00000011B+(00000000B*100H)
		WORD	00000011B+(00000000B*100H)
		WORD	00000000B+(00000000B*100H)
		WORD	00000000B+(00000000B*100H)
;
MD7KI_CHG_DAT00 EQU	$
		WORD	MD7KI_CHG_DT00,MD7KI_CHG_DT01
		WORD	MD7KI_CHG_DT02,MD7KI_CHG_DT03
;
MD7KI_CHG_DAT01 EQU	$
		WORD	MD7KI_CHG_DT00+3,MD7KI_CHG_DT01+3
		WORD	MD7KI_CHG_DT02+3,MD7KI_CHG_DT03+3
;
MD7KI_CHG_DAT10 EQU	$
		WORD	MD7KI_CHG_DT10,MD7KI_CHG_DT11
		WORD	MD7KI_CHG_DT12,MD7KI_CHG_DT13
;
MD7KI_CHG_DAT11 EQU	$
		WORD	MD7KI_CHG_DT10+3,MD7KI_CHG_DT11+3
		WORD	MD7KI_CHG_DT12+3,MD7KI_CHG_DT13+3
;
;
MD7KUI_CHG	EQU	$
		LDX	<WORK2		; (X) <-- BG unit buffer pointer
		LDA	>BGUNIT,X
		BNE	MD7KUI_CHG_000
		JMP	MD7KUI_CHG_990
MD7KUI_CHG_000	EQU	$
		STA	<WORK0
		LDA	#UT0000
		STA	>BGUNIT,X
;
		LDA	#00002
		STA	!BOSSQ_KUI_ON
;
		TXA
		LDX	#00000
MD7KUI_CHG_220	EQU	$		; AhX T[` !!
		CMP	MD7KUI_CHG_CMP,X
		BEQ	MD7KUI_CHG_300
		INX
		INX
		CPX	#MD7KUI_CHG_CMP-MD7KUI_CHG_END
		BCC	MD7KUI_CHG_220
;
MD7KUI_CHG_300	EQU	$
		STX	<WORK8
		TXA
		EOR	#00002
		TAX
		LDA	MD7KUI_CHG_CMP,X
		TAX
;
		LDA	<WORK0
		STA	>BGUNIT,X
;
;------------------------------------------ Y
		LDY	<WORK8
		LDA	MD7KI_CHG_ADR0,Y
		STA	<WORK0		; uq`lAhX
		LDA	MD7KI_CHG_CNT0,Y
		STA	<WORK2		;CN[h  cl`p[^
		LDA	MD7KI_CHG_DAT00,Y
		STA	<WORK4		; `oX AhX
		JSR	MD7VRAMDX_SET
;
		LDY	<WORK8
		LDA	MD7KI_CHG_ADR1,Y
		STA	<WORK0		; uq`lAhX
		LDA	MD7KI_CHG_CNT0,Y
		STA	<WORK2		;CN[h  cl`p[^
		LDA	MD7KI_CHG_DAT01,Y
		STA	<WORK4		; `oX AhX
		JSR	MD7VRAMDX_SET
;
;------------------------------------------ Y
		LDA	<WORK8
		EOR	#00002
		TAY
		STA	<WORK8
		LDA	MD7KI_CHG_ADR0,Y
		STA	<WORK0		; uq`lAhX
		LDA	MD7KI_CHG_CNT1,Y
		STA	<WORK2		;CN[h  cl`p[^
		LDA	MD7KI_CHG_DAT10,Y
		STA	<WORK4		; `oX AhX
		JSR	MD7VRAMDX_SET
;
		LDY	<WORK8
		LDA	MD7KI_CHG_ADR1,Y
		STA	<WORK0		; uq`lAhX
		LDA	MD7KI_CHG_CNT1,Y
		STA	<WORK2		;CN[h  cl`p[^
		LDA	MD7KI_CHG_DAT11,Y
		STA	<WORK4		; `oX AhX
		JSR	MD7VRAMDX_SET
;
MD7KUI_CHG_990	EQU	$
		RTS
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	[hVp uq`lcwZbg		+
;++++++++++++++++++++++++++++++++++++++++++++++++
MD7VRAMDX_SET	EQU	$
		PHB
		PEA	VRAMDX/100H
		PLB
		PLB
;
		LDX	!VRAMDX
		LDA	<WORK0
		STA	0,X		; uq`lAhX
		LDA	<WORK2
		STA	2,X		; CN[h  cl`p[^
		LDA	#00018H
		STA	4,X		; aoX AhX
		LDA	#BANK MD7KI_CHG_DAT00
		STA	7,X		; `oX AhX (a)
		LDA	#00003
		STA	8,X		; oCg
		LDA	<WORK4
		STA	5,X		;	"         (g,k)
;
		TXA
		CLC
		ADC	#00012
		STA	10,X		; mdws hmcdw
		STA	!VRAMDX
;
		PLB
		RTS
;
;
BG_BIT_ON	EQU	$
		LDA	!CORSNO
		ASL	A
		TAX
		LDA	>BGCIN_STCHK_ADR,X
		STA	<WORK0
		LDX	<WORK10
		LDA	UNBUFAD,X
		AND	#0003FH
		ASL	A
		ADC	<WORK0
		STA	<WORK0		;ʃAhX Zbg
		LDA	<WORK2
		AND	#0001EH
		TAX
		LDA	>BGCIN_STCHK_DAT,X
		STA	<WORK4
		LDA	(<WORK0)
		ORA	<WORK4
		STA	(<WORK0)	;rbgnm !!
		RTS
;
;************************************************************************
;*		afRC NA					*
;************************************************************************
BGCOINCLS	EQU	$
		JSR	BG_BIT_ON
;
;************************************************************************
;*		af						*
;************************************************************************
;
BGCHGST		EQU	$
		LDX	<WORK2		;(X) <-- BG unit buffer pointer
		LDA	BGUTNO		;(A) <-- change unit no.
		STA	>BGUNIT,X
		JSR	VRAMDST
;
		LDA	>VRAMDSP
		TAX
		LDA	#0FFFFH
		STA	>VRAMDSP+2,X	;end code set
		RTS
;
;************************************************************************
;*		afikLȂ珑j			*
;************************************************************************
;
BGCGST2		EQU	$
		LDX	<WORK2		;(X) <-- BG unit buffer pointer
		LDA	>BGUNIT,X
		CMP	#UT0000
		BNE	BGCGST2_010	;H ( no:BGCGST2_010 )
;
		LDA	BGUTNO		;(A) <-- change unit no.
		STA	>BGUNIT,X
		JSR	VRAMDST
;
		LDA	>VRAMDSP
		TAX
		LDA	#0FFFFH
		STA	>VRAMDSP+2,X	;end code set
BGCGST2_010	EQU	$
		RTS
;
;************************************************************************
;*		Ƃ̋						*
;************************************************************************
TOGETAMA	EQU	$
		LDX	<WORK2
		LDA	>BGUNIT,X
		CMP	#UT7C00		; Ƃ̋ 邩 ?
		BEQ	TOGETAMA_000	;	YES -> TOGETAMA_000
		JMP	TOGETAMA_900
;
TOGETAMA_000	EQU	$
		STZ	<WORKE
		LDA	<WORK7
		STA	<WORK4
		LDA	<WORK12
		STA	<WORK16
		LDA	<WORK14
		STA	<WORK18
;
;-------------- ̂af ----------------------------------------
		JSR	CHGBG_SET_UP
		LDA	<WORK0		; max over ?
		BNE	TOGETAMA_100	;	YES -> TOGETAMA_100
;
		LDA	>BGUNIT,X
		AND	#0FF00H
		TAY
		CMP	#UT7C00		;  ?
		BNE	TOGETAMA_020	;	NO -> TOGETAMA_020
		LDA	#00008
		STA	<WORKE
		BRA	TOGETAMA_100
;
TOGETAMA_020	EQU	$
		TYA
		CMP	#UT7700
		BNE	TOGETAMA_100
		LDA	>BGUNIT,X
		DEC	A
		DEC	A
		DEC	A
		DEC	A
		CMP	#UT7781
		BCS	TOGETAMA_025
		LDA	#UT0000
TOGETAMA_025	EQU	$
		STA	>BGUNIT,X	; unit_No. set
		JSR	VRAMDST
;
;-------------- ̂af ----------------------------------------
TOGETAMA_100	EQU	$
		JSR	CHGBG_SET_LFT
		LDA	<WORK0		; max over ?
		BNE	TOGETAMA_200	;	YES -> TOGETAMA_200
;
		LDA	>BGUNIT,X
		AND	#0FF00H
		TAY
		CMP	#UT7C00		;  ?
		BNE	TOGETAMA_120	;	NO -> TOGETAMA_120
		LDA	<WORKE
		ORA	#00001
		STA	<WORKE
		BRA	TOGETAMA_200
;
TOGETAMA_120	EQU	$
		TYA
		CMP	#UT7700
		BNE	TOGETAMA_200
		LDA	>BGUNIT,X
		DEC	A
		DEC	A
		CMP	#UT7781
		BCS	TOGETAMA_125
		LDA	#UT0000
TOGETAMA_125	EQU	$
		STA	>BGUNIT,X	; unit_No. set
		JSR	VRAMDST
;
;-------------- Êaf ----------------------------------------
TOGETAMA_200	EQU	$
		JSR	CHGBG_SET_RIT
		LDA	<WORK0		; max over ?
		BNE	TOGETAMA_300	;	YES -> TOGETAMA_300
;
		LDA	>BGUNIT,X
		AND	#0FF00H
		TAY
		CMP	#UT7C00		;  ?
		BNE	TOGETAMA_220	;	NO -> TOGETAMA_220
		LDA	<WORKE
		ORA	#00002
		STA	<WORKE
		BRA	TOGETAMA_300
;
TOGETAMA_220	EQU	$
		TYA
		CMP	#UT7700
		BNE	TOGETAMA_300
		LDA	>BGUNIT,X
		DEC	A
		CMP	#UT7781
		BCS	TOGETAMA_225
		LDA	#UT0000
TOGETAMA_225	EQU	$
		STA	>BGUNIT,X	; unit_No. set
		JSR	VRAMDST
;
;-------------- ̂af ----------------------------------------
TOGETAMA_300	EQU	$
		JSR	CHGBG_SET_DWN
		LDA	<WORK0		; max over ?
		BNE	TOGETAMA_400	;	YES -> TOGETAMA_400
;
		LDA	>BGUNIT,X
		AND	#0FF00H
		TAY
		CMP	#UT7C00		;  ?
		BNE	TOGETAMA_320	;	NO -> TOGETAMA_320
		LDA	<WORKE
		ORA	#00004
		STA	<WORKE
		BRA	TOGETAMA_400
;
TOGETAMA_320	EQU	$
		TYA
		CMP	#UT7700
		BNE	TOGETAMA_400
		LDA	>BGUNIT,X
		SEC
		SBC	#00008
		CMP	#UT7781
		BCS	TOGETAMA_325
		LDA	#UT0000
TOGETAMA_325	EQU	$
		STA	>BGUNIT,X	; unit_No. set
		JSR	VRAMDST
;
;-------------- ʂ̂af ---------------------------------------
TOGETAMA_400	EQU	$
		LDX	<WORK2
		LDA	<WORK4
		STA	<WORK7
		LDA	<WORKE
		BEQ	TOGETAMA_425
		CLC
		ADC	#UT7781-1
TOGETAMA_425	EQU	$
		STA	>BGUNIT,X
		JSR	VRAMDST
;
TOGETAMA_900	EQU	$
		LDA	>VRAMDSP
		TAX
		LDA	#0FFFFH
		STA	>VRAMDSP+2,X	;end code set
		RTS
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		JSR	VRAMDST ( unit data vramd set sub )		x
;x			in  : (A) <-- unit no.				x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
VRAMDST		EQU	$
		TAY			;(Y) <-- (A)
;
		LDA	<WORK12
		CMP	#0130H
		BCS	VRAMDST_010	;afnjH ( yes:VRAMDST_010 )
		LDA	<WORK14
		CMP	#0100H
		BCS	VRAMDST_010	;afnjH ( yes:VRAMDST_010 )
;
		PHB			;(DBR) save
		PEA	VRAMDSP/100H	;(DBR) <-- VRAMDSP(B)
		PLB
		PLB
;
		LDA	<WORK7
		BIT	#0400H
		BEQ	VRAMDST_000
		EOR	#0400H|020H
VRAMDST_000	EQU	$
		TAX
		TYA
		STA	>BGCHECK_BUF,X
;
		TYA
		AND	#0FF00H
		XBA
		ASL	A
		TAX
		LDA	>UNDTADD,X
		STA	<WORK0
		TYA
		AND	#000FFH
		ASL	A
		ASL	A
		ASL	A
;;;;		    CLC
		ADC	<WORK0
		CLC
		ADC	#UNDATA
		STA	<WORK0
;
		LDY	!VRAMDSP
		LDA	<WORK7
		ORA	#06800H
		STA	!VRAMDSP+2,Y	; VRAM AhX Zbg
;
		LDA	<WORK0
		STA	!VRAMDSP+4,Y
;
		TYA
		CLC
		ADC	#00004
		STA	!VRAMDSP
;
		PLB
;
VRAMDST_010	EQU	$
		RTS
;
;++++++++++++++++++++++++++++++++++++++++
;+		_~[ !!		+
;++++++++++++++++++++++++++++++++++++++++
UNDO_GO		EQU	$
		BRA	UNDO_GO
		RTL
;
;
		MEM8
		IDX8
;
;
;
;
;
		END


