;
;
;****************************************************************
;*								*
;*	title name  ; yossy enmy data file set			*
;*	proccess    ; enmy file proccess			*
;*	file name   ; yst_en_file				*
;*								*
;****************************************************************
;
;
		SALL
;
		include yst_header.inc
;
		XALL
;
;
;---------------------------------------------------------------
;		Supar_Y enmy-edit-tool
;---------------------------------------------------------------
;
;
;=============================================== yst_en_file ===
		GLB	ENFLINT,ENFLMD
		GLB	FLPYSV,FLPYLD,FLPYDL,FLNMDSP
		GLB	FLPYFT,BGENINT,BGENSL,BGENFD
		GLB	ENBFST,ENBFCLS,MODINC,MODINC2
		GLB	UN_ENAME_SET
;
;=============================================== yst_main ======
		EXT	BLNKOF2,BLNKOFF
;
;=============================================== ys_init =======
		EXT	GMMDST
		EXT	GM00,ITSB
;
;=============================================== yst_init ======
		EXT	ENPLMD,FPSV,FPLD,FPDL,ENFILE,ENFMD,FLNM
		EXT	FPFT,ENITSB
;
;=============================================== yst_edit =======
		EXT	EN_SDPTCAL
;
;=============================================== yst_vma =======
		EXT	VRAMCL
;
;=============================================== yst_svld ======
		EXT	DTSHARE,EN_BUFFSET
;
;===============================================================
;
;
;
;************************************************************************
;*									*
;*		program start						*
;*									*
;************************************************************************
;
;
		EXTEND
;
;
		MEM8
		IDX8
;
Group_17	GROUP	En_file_pro
En_file_pro	SECT	REL
;
;
;****************************************************************
;*								*
;*	enmy data file initial mode				*
;*								*
;****************************************************************
ENFLINT		EQU	$
		PHB
		PHK
		PLB
;
		DEC	FADNO
		BMI	ENPASS
		JMP	ENFLIT9
ENPASS		EQU	$
		PHB
		PHK
		PLB
		JSL	>VRAMCL
;
;-------------- PPU Reg. initial set ----------------------------
		LDX	#GM00
		JSL	>GMMDST
		STZ	2105H
		LDA	#11H
		STA	MANSEL
		STA	212CH
		LDA	#74H
		STA	BG1SCF
		STA	2107H
;
		M16				; memory 16bit mode
;
		LDX	#000H
		LDA	!MOJBF0
		BNE	PPAASS00
		LDA	#02020H
		STA	!MOJBF0
		STA	!MOJBF0+2
		STA	!MOJBF0+4
		STA	!MOJBF0+6
		STX	!MJIDX0
;
PPAASS00	EQU	$
		LDA	!MOJBF1
		BNE	PPAASS11
		LDA	#02020H
		STA	!MOJBF1
		STA	!MOJBF1+2
		STA	!MOJBF1+4
		STA	!MOJBF1+6
		STX	!MJIDX1
;
PPAASS11	EQU	$
		LDA	!MOJBF2
		BNE	PPAASS22
		LDA	#02020H
		STA	!MOJBF2
		STA	!MOJBF2+2
		STA	!MOJBF2+4
		STA	!MOJBF2+6
		STX	!MJIDX2
;
PPAASS22	EQU	$
		LDA	!MOJBF3
		BNE	PPAASS33
		LDA	#02020H
		STA	!MOJBF3
		STA	!MOJBF3+2
		STA	!MOJBF3+4
		STA	!MOJBF3+6
		STX	!MJIDX3
;
PPAASS33	EQU	$
;
;-------------- mode 0 character set ----------------------------
		LDY	#10000000B
		STY	2115H			; inc mode set
		LDA	#0000H
		STA	2116H			; VRAM address set
		LDA	#00000001B+(18H*100H)
		STA	4300H			; DMA parameter & B bus address set
		LDA	#169800H
		STA	4302H			; A bus address(L,H) set
		LDY	#BANK 169800H
		STY	4304H			;	"       (B) set
		LDA	#01000H
		STA	4305H			; number of byte set
		LDX	#00000001B
		STX	420BH			; DMA "ON"
;
;-------------- mode 0 screen write -----------------------------
		LDA	#07400H
		STA	2116H			; VRAM address set
		LDA	#00000001B+(18H*100H)
		STA	4300H			; DMA parameter & B bus address set
		LDA	#16A800H
		STA	4302H			; A bus address(L,H) set
;;K;;		LDY	#BANK 16A800H
;;K;;		STY	4304H			;	"       (B) set
		LDA	#0800H
		STA	4305H			; number of byte set
		STX	420BH			; DMA "ON"
;
;-------------- mo-ji ka-e-ru -----------------------------------
		PHB
		PHK
		PLB
;
		LDA	#07441H
		STA	2116H		; VRAM address set
		LDA	#SCMJDT0
		STA	<WORK0
		JSR	MJSET0		; mo-ji set
;
		LDA	#07481H
		STA	2116H		; VRAM address set
		LDA	#SCMJDT1
		STA	<WORK0
		JSR	MJSET0		; mo-ji set
;
		LDA	#074C1H
		STA	2116H		; VRAM address set
		LDA	#SCMJDT2
		STA	<WORK0
		JSR	MJSET0		; mo-ji set
;
		LDA	#07501H
		STA	2116H		; VRAM address set
		LDA	#SCMJDT3
		STA	<WORK0
		JSR	MJSET0		; mo-ji set
;
		PLB
;
;-------------- OBJ character set -------------------------------
		LDA	#04000H
		STA	2116H			; VRAM address set
		LDA	#00000001B+(18H*100H)
		STA	4300H			; DMA parameter & B bus address set
		LDA	#168000H
		STA	4302H			; A bus address(L,H)
		LDY	#BANK 168000H
		STY	4304H			;	"       (B)
		LDA	#00400H
		STA	4305H			; number of byte set
		STX	420BH			; DMA "ON"
;
;-------------- mo-ji set ---------------------------------------
		LDA	#00000000B
		STA	2115H			; inc mode set
		LDA	#0744BH
		STA	2116H			; VRAM address set
		LDA	#00000000B+(18H*100H)
		STA	4300H			; DMA parameter & B bus address set
		LDA	#MOJBF0
		STA	4302H			; A bus address(L,H) set
		LDA	#BANK MOJBF0
		STA	4304H			;	"       (B) set
		LDA	#00008H
		STA	4305H			; number of byte set
		STX	420BH			; DMA "ON"
;
		LDA	#0748BH
		STA	2116H			; VRAM address set
		LDA	#00000000B+(18H*100H)
		STA	4300H			; DMA parameter & B bus address set
		LDA	#MOJBF1
		STA	4302H			; A bus address(L,H) set
;;;;K;;;;		LDY	#BANK MOJBF1
;;;;K;;;;		STY	4304H			;	"       (B) set
		LDA	#00008H
		STA	4305H			; number of byte set
		STX	420BH			; DMA "ON"
;
		LDA	#074CBH
		STA	2116H			; VRAM address set
		LDA	#00000000B+(18H*100H)
		STA	4300H			; DMA parameter & B bus address set
		LDA	#MOJBF2
		STA	4302H			; A bus address(L,H) set
;;;;K;;;;		LDY	#BANK MOJBF2
;;;;K;;;;		STY	4304H			;	"       (B) set
		LDA	#00008H
		STA	4305H			; number of byte set
		STX	420BH			; DMA "ON"
;
		LDA	#0750BH
		STA	2116H			; VRAM address set
		LDA	#00000000B+(18H*100H)
		STA	4300H			; DMA parameter & B bus address set
		LDA	#MOJBF3
		STA	4302H			; A bus address(L,H) set
;;;;K;;;;		LDY	#BANK MOJBF3
;;;;K;;;;		STY	4304H			;	"       (B) set
		LDA	#00008H
		STA	4305H			; number of byte set
		STX	420BH			; DMA "ON"
;
		M8				; memory 8bit mode
;
;-------------- color set ---------------------------------------
		STZ	2121H			; CGRAM address set
		M16				; memory 16bit mode
		LDA	#00000000B+(22H*100H)
		STA	4300H			; DMA parameter & B bus address set
		LDA	#16B000H
		STA	4302H			; A bus address(L,H) set
		LDA	#BANK 16B000H
		STA	4304H			;	"       (B) set
		LDA	#00200H
		STA	4305H			; number of byte set
		STX	420BH			; DMA "ON"
;
		LDA	<SCCH1
		STA	XTAIHI
		LDA	<SCCV1
		STA	YTAIHI
		STZ	<SCCH1
		STZ	<SCCH2
		STZ	<SCCH3
		STZ	<SCCV1
		STZ	<SCCV2
		STZ	<SCCV3
		STZ	CRXPSL2
		STZ	CRYPSL2
		STZ	!SCRLBF
;
		LDA	!ENDTPT
		STA	>ENMYDTBF
		M8				; memory 8bit mode
;
;-------------- file name buffer clear --------------------------
		JSR	FLNMCLR
;
;------------------------------------ use ram clear
		STZ	!ENMDFG0
		STZ	!ENMDFG1
		STZ	!RDFLDT
;
		JSL	>BLNKOF2
		INC	MODENO
		PLB
;
ENFLIT9		EQU	$
		PLB
		RTL
;
;
;++++++++++++++++++++++++++++++++++++++++
;+					+
;+	mo-ji set			+
;+					+
;++++++++++++++++++++++++++++++++++++++++
		MEM16
MJSET0		EQU	$
		LDY	#000H
MJSTLP		EQU	$
		LDA	(<WORK0),Y
		STA	2118H
		INY
		INY
		CPY	#02EH
		BNE	MJSTLP
		RTS
		MEM8
;
;
SCMJDT0		EQU	$
		WORD	00045H,0004EH,0004DH,00059H,000C3H,000DEH
		WORD	0002DH,000C0H,00020H,0005BH,00020H,00020H
		WORD	00020H,00020H,00020H,00020H,00020H,00020H
		WORD	0002EH,00045H,0004EH,00044H,0005DH
;
SCMJDT1		EQU	$
		WORD	000BAH,0002DH,000BDH,00020H,000C3H,000DEH
		WORD	0002DH,000C0H,00020H,0005BH,00020H,00020H
		WORD	00020H,00020H,00020H,00020H,00020H,00020H
		WORD	0002EH,00044H,00041H,00054H,0005DH
;
SCMJDT2		EQU	$
		WORD	00045H,0004EH,0004DH,00059H,00020H,0004EH
		WORD	00041H,0004DH,00045H,0005BH,00020H,00020H
		WORD	00020H,00020H,00020H,00020H,00020H,00020H
		WORD	0002EH,00045H,00054H,00042H,0005DH
;
SCMJDT3		EQU	$
		WORD	0004FH,00042H,0004AH,00020H,000C0H,000B2H
		WORD	000CCH,000DFH,00020H,0005BH,00020H,00020H
		WORD	00020H,00020H,00020H,00020H,00020H,00020H
		WORD	0002EH,0004FH,0004AH,00044H,0005DH
;
;
;****************************************************************
;*								*
;*	enmy data file mode					*
;*								*
;****************************************************************
ENFLMD		EQU	$
		PHB
		PHK
		PLB
		JSR	FLMSMV			; file mode mouse move
;
		LDA	!INKEY
		CMP	#F_1
		BNE	ENFL00_00
		LDX	#008H
		JMP	ENFL005_END
;
ENFL00_00	EQU	$
		LDA	MOUSEBT
		AND	#01000000B		; mouse left ON ?
		BNE	ENFL00			;	YES -> ENFL00
		JMP	ENFL999			;	NO  -> ENFL999
ENFL00		EQU	$
		LDA	CRXPSL2
		CMP	#0CEH
		BCC	ENFL10
		CMP	#0F4H
		BCS	ENFL10
		LDA	CRYPSL2
		SEC
		SBC	#00CH
		BMI	ENFL10
		CMP	#050H		; load
		BCS	ENFL10		; save
		AND	#0F0H		; delete
		LSR	A		; format
		LSR	A		; exit
		LSR	A		;	mode set
		TAX			;
		STA	!ENMDFG0	;
		CMP	#006H		; format mode ?
		BEQ	ENFL005		;	YES -> ENFL005
		CMP	#008H		; exit mode ?
		BEQ	ENFL005		;	YES -> ENFL005
		LDA	!RDFLDT		; select file OK ?
		BPL	ENFL10		;	NO -> ENFL10
		AND	#007H
		LSR	A
		TAY
		LDA	!MJIDX0,Y
		BEQ	ENFL10
ENFL005		EQU	$
		JSR	FLNMCLR		; file name buffer clear
ENFL005_END	EQU	$
		STZ	!SCRLBF
		STZ	!SCRLBF+1
		JSR	(ENFLMOD,X)
		JMP	ENFL999
;
ENFL10		EQU	$
		LDA	CRXPSL2
		CMP	#055H
		BCC	ENFL20
		CMP	#0BCH
		BCS	ENFL20
		LDA	CRYPSL2
		CMP	#00EH
		BCC	ENFL20
		CMP	#047H
		BCS	ENFL20
		AND	#008H
		BNE	ENFL20
		LDA	CRYPSL2
		SEC
		SBC	#00EH
		AND	#0F0H
		LSR	A
		LSR	A
		LSR	A
		PHA
		LDA	!RDFLDT
		AND	#00FH
		TAX
		STZ	<WORK2
		STZ	<WORK3
		JSR	FLNAME		; file name ha-n-te-n
		PLA
		TAX
		ORA	#080H
		STA	!RDFLDT
		LDA	#004H
		STA	<WORK2
		STA	<WORK3
		JSR	FLNAME		; file name ha-n-te-n
;
		M16			; memory 16bit mode
		LDX	!ENMDFG1
		STZ	<WORK2
		JSR	MDNAME		; mode name ha-n-te-n
		M8			; memory 8bit mode
;
		JSR	FLNMCLR		; file name buffer clear
		LDA	#FLNM
		STA	MODENO
		JMP	ENFL999
;
ENFL20		EQU	$
		LDA	MOUSEBT
		AND	#01000000B	; mouse left ON ?
		BEQ	ENFL30		;	N0 -> ENFL30
		LDA	!RDFLDT
		BPL	ENFL30
		LDA	CRXPSL2
		CMP	#020H
		BCC	ENFL30
		CMP	#0F0H
		BCS	ENFL30
		LDA	CRYPSL2
		CMP	#068H
		BCC	ENFL30
		CMP	#090H
		BCS	ENFL30
		AND	#008H
		BEQ	ENFL30
		JSR	FLNMSET		; file name set
;
ENFL30		EQU	$
		LDA	!FNBIDX
		CMP	#007H		; file name < 7 ?
		BCC	ENFL40		;	NO -> ENFL40
		LDA	MOUSEBT
		AND	#01000000B	; mouse left ON ?
		BEQ	ENFL40		;	N0 -> ENFL40
		LDA	CRXPSL2
		CMP	#009H
		BCC	ENFL40
		CMP	#017H
		BCS	ENFL40
		LDA	CRYPSL2
		CMP	#066H
		BCC	ENFL40
		CMP	#08FH
		BCS	ENFL40
		JSR	ENFLSCRL	; file name scroll
		JMP	ENFL999
;
ENFL40		EQU	$
		LDA	!RDFLDT
		BPL	ENFL50
		LDA	MOUSEBT
		AND	#01000000B	; mouse left ON ?
		BEQ	ENFL50		;	N0 -> ENFL50
		LDA	CRYPSL2
		CMP	#09CH
		BCC	ENFL50
		CMP	#0DCH
		BCS	ENFL50
		JSR	MJBFST		; mo-ji disp & buffer set
		JMP	ENFL999
;
ENFL50		EQU	$
;
ENFL999		EQU	$
		PLB
		RTL
;
;
ENFLMOD		EQU	$
		WORD	LODMOD	; load
		WORD	SAVMOD	; save
		WORD	DELMOD	; delete
		WORD	FRMTMOD ; format
		WORD	ENEXTMD ; exit
;
;
;****************************************************************
;*								*
;*	file mode mouse move					*
;*								*
;****************************************************************
FLMSMV		EQU	$
		PHB			;(DBR) save
		LDA	#BANK OAM	;(DBR) <-- OAM(B)
		PHA
		PLB
;
		M16				; memory 16bit mode
		LDA	>CRXPSL2
		CLC
		ADC	>MOUSEBX
		AND	#000FFH
		STA	>CRXPSL2
		SEC
		SBC	#00007H
		AND	#000FFH
		TAX
		STX	!OAM
;
		LDA	>CRYPSL2
		CLC
		ADC	>MOUSEBY
		AND	#000FFH
		STA	>CRYPSL2
		TAX
		STX	!OAM+1
;
		LDA	>MOUSEBB
		AND	#11000000B
		BEQ	FMV000
		LDA	#00002H
FMV000		EQU	$
		ORA	#03000H
		STA	!OAM+2
;
		M8				; memory 8bit mode
		LDA	#002H
		STA	!OAMSUB
;
		PLB
		RTS
;
;
;****************************************************************
;*								*
;*	load mode						*
;*								*
;****************************************************************
LODMOD		EQU	$
		M16			; memory 16bit mode
		LDX	!ENMDFG1
		STZ	<WORK2
		JSR	MDNAME		; mode name ha-n-te-n
;
		LDX	!ENMDFG0
		LDA	#00404H
		STA	<WORK2
		JSR	MDNAME		; mode name ha-n-te-n
;
		M8			; memory 8bit mode
		LDA	!ENMDFG0
		STA	!ENMDFG1
;
		JSR	YESNOOK
;
		LDA	#04CH		; "LOAD" set
		STA	!FLNMBF+018H+04H
		LDA	#04FH
		STA	!FLNMBF+018H+05H
		LDA	#041H
		STA	!FLNMBF+018H+06H
		LDA	#044H
		STA	!FLNMBF+018H+07H
;
		LDA	#04FH		; "OK" set
		STA	!FLNMBF+018H+09H
		LDA	#04BH
		STA	!FLNMBF+018H+0AH
;
		JSR	ENFLNMDP	; file name disp set
;
		LDA	#FPLD
		STA	MODENO
		RTS
;
;
;****************************************************************
;*								*
;*	save mode						*
;*								*
;****************************************************************
SAVMOD		EQU	$
		LDA	!RDFLDT
		AND	#007H		; J[\ʒu
		CMP	#004H		;	G̖Of[^ ?
		BNE	FTSV00_00	;	NO -> FTSV00_00
		JMP	SVMDPS
;
FTSV00_00	EQU	$
		CMP	#002H		; R[X f[^ ?
		BEQ	FTSV00_03	;	YES -> FTSV00_03
		CMP	#006H		; nai^Cv f[^ ?
		BEQ	FTSV00_05	;	YES -> FTSV00_05
		M16			; memory 16bit mode
		LDA	!ENDTPT		; Gf[^邩H
		BNE	FTSV00_05	;	YES -> FTSV00_05
		JMP	SVMDPS
;
FTSV00_03	EQU	$
		LDA	!DTPT		; R[X f[^邩H
		BNE	FTSV00_05	;	YES -> FTSV00_05
		JMP	SVMDPS
;
FTSV00_05	EQU	$
		M16			; memory 16bit mode
		LDX	!ENMDFG1
		STZ	<WORK2
		JSR	MDNAME		; mode name ha-n-te-n
;
		LDX	!ENMDFG0
		LDA	#00404H
		STA	<WORK2
		JSR	MDNAME		; mode name ha-n-te-n
;
		M8			; memory 8bit mode
		LDA	!ENMDFG0
		STA	!ENMDFG1
;
		JSR	YESNOOK		; cnrp[^ Zbg
;
		M16			; memory 16bit mode
		LDA	!RDFLDT
		AND	#00007H
		BEQ	FTSV00_30
		CMP	#006H		; nai^Cv f[^ ?
		BEQ	FTSV00_50	;	YES -> FTSV00_50
		LDA	!STDTPT
		CLC
		ADC	#0000AH+1
		STA	1EE0H+20	; R[X f[^ TCY Zbg
		M8			; memory 8bit mode
		JSL	>EN_BUFFSET
		BRA	FTSV00_50
;
		MEM16
FTSV00_30	EQU	$
		LDA	!ENDTPT
		STA	>ENMYDTBF
		ASL	A
		ASL	A
		ASL	A
		SEC
		SBC	!ENDTPT
		INC	A
		INC	A
		STA	1EF4H		; Gf[^ TCY Zbg
FTSV00_50	EQU	$
		M8			; memory 8bit mode
;
		LDX	#000H		; "DRIVE 1" set
FTSV00		EQU	$
		LDA	DRIVE1,X
		STA	!FLNMBF+18H,X
		INX
		CPX	#(DRIVE1E-DRIVE1)
		BNE	FTSV00
;
		LDA	!RDFLDT
		AND	#004
		BEQ	FTSV00_80
		LDA	!FLNMBF+01FH
		INC	A
		STA	!FLNMBF+01FH
;
FTSV00_80	EQU	$
		LDA	#053H		; "SAVE" set
		STA	!FLNMBF+030H+04H
		LDA	#041H
		STA	!FLNMBF+030H+05H
		LDA	#056H
		STA	!FLNMBF+030H+06H
		LDA	#045H
		STA	!FLNMBF+030H+07H
;
		LDA	#04FH		; "OK" set
		STA	!FLNMBF+030H+09H
		LDA	#04BH
		STA	!FLNMBF+030H+0AH
;
		JSR	ENFLNMDP	; file name disp set
;
		LDA	#FPSV
		STA	MODENO
;
SVMDPS		EQU	$
		M8			; memory 8bit mode
		RTS
;
;
;****************************************************************
;*								*
;*	delete mode						*
;*								*
;****************************************************************
DELMOD		EQU	$
		LDA	!RDFLDT
		AND	#007H
		BNE	DLMDPS
		M16			; memory 16bit mode
		LDX	!ENMDFG1
		STZ	<WORK2
		JSR	MDNAME		; mode name ha-n-te-n
;
		LDX	!ENMDFG0
		LDA	#00404H
		STA	<WORK2
		JSR	MDNAME		; mode name ha-n-te-n
;
		M8			; memory 8bit mode
		LDA	!ENMDFG0
		STA	!ENMDFG1
;
		JSR	YESNOOK
;
		LDA	#044H		; "DELETE" set
		STA	!FLNMBF+018H+02H
		LDA	#045H
		STA	!FLNMBF+018H+03H
		LDA	#04CH
		STA	!FLNMBF+018H+04H
		LDA	#045H
		STA	!FLNMBF+018H+05H
		LDA	#054H
		STA	!FLNMBF+018H+06H
		LDA	#045H
		STA	!FLNMBF+018H+07H
;
		LDA	#04FH		; "OK" set
		STA	!FLNMBF+018H+09H
		LDA	#04BH
		STA	!FLNMBF+018H+0AH
;
		JSR	ENFLNMDP	; file name disp set
;
		LDA	#FPDL
		STA	MODENO
;
DLMDPS		EQU	$
		RTS
;
;
;****************************************************************
;*								*
;*	format mode						*
;*								*
;****************************************************************
FRMTMOD		EQU	$
		M16			; memory 16bit mode
		LDX	!ENMDFG1
		STZ	<WORK2
		JSR	MDNAME		; mode name ha-n-te-n
;
		LDX	!ENMDFG0
		LDA	#00404H
		STA	<WORK2
		JSR	MDNAME		; mode name ha-n-te-n
;
		M8			; memory 8bit mode
		LDA	!ENMDFG0
		STA	!ENMDFG1
;
		JSR	YESNOOK
;
		LDX	#000H		; "DRIVE 1" set
FTMD00		EQU	$
		LDA	DRIVE1,X
		STA	!FLNMBF,X
		INX
		CPX	#(DRIVE1E-DRIVE1)
		BNE	FTMD00
;
		LDA	#046H		; "FORMAT" set
		STA	!FLNMBF+018H+03H
		LDA	#04FH
		STA	!FLNMBF+018H+04H
		LDA	#052H
		STA	!FLNMBF+018H+05H
		LDA	#04DH
		STA	!FLNMBF+018H+06H
		LDA	#041H
		STA	!FLNMBF+018H+07H
		LDA	#054H
		STA	!FLNMBF+018H+08H
;
		LDA	#04FH		; "OK" set
		STA	!FLNMBF+018H+0AH
		LDA	#04BH
		STA	!FLNMBF+018H+0BH
;
		JSR	ENFLNMDP	; file name disp set
;
		LDA	#FPFT
		STA	MODENO
		RTS
;
DRIVE1		EQU	$
		BYTE	020H,044H,052H,049H,056H,045H
		BYTE	020H,031H,020H,020H,020H,020H
DRIVE1E		EQU	$
;
;
;****************************************************************
;*								*
;*	exit mode						*
;*								*
;****************************************************************
ENEXTMD		EQU	$
		M16				; memory 16bit mode
		LDA	XTAIHI
		STA	<SCCH1
		STA	<SCCH2
		STA	<SCCH3
		LDA	YTAIHI
		STA	<SCCV1
		STA	<SCCV2
		STA	<SCCV3
		M8				; memory 8bit mode
		STZ	FADNO			;[go not display !!]
		LDA	#ITSB
		STA	MODENO
		RTS
;
;
;++++++++++++++++++++++++++++++++++++++++
;+					+
;+	"LOAD","SAVE","DEL" OK sub	+
;+					+
;++++++++++++++++++++++++++++++++++++++++
YESNOOK		EQU	$
		LDA	!RDFLDT
		AND	#007H
		ASL	A
		ASL	A
		TAY
		LDX	#000H
OK000		EQU	$		; mo-ji buffer ->
		LDA	!MOJBF0,Y	;	file buffer set
		STA	!FLNMBF,X
		INY
		INX
		CPX	#008H
		BNE	OK000
;
		LDA	!RDFLDT
		AND	#007H
		ASL	A
		TAY
OK010		EQU	$
		LDA	OKDATA,Y
		STA	!FLNMBF,X
		INX
		INY
		TYA
		AND	#003H
		BNE	OK010
;
		LDA	!RDFLDT
		AND	#004H
		LSR	A
		LSR	A
;;;;K;;;;		LDA	#0
		DOS	_SELDSK		; disk drive set
		LDA	#2
		DOS	_DSKRST		; disk mode set
;
		LDX	#000H
OK020		EQU	$
		LDA	!FLNMBF,X
		STA	1EE0H,X
		INX
		CPX	#008H
		BNE	OK020
;
		LDA	!FLNMBF+1,X
		STA	1EE0H,X
		LDA	!FLNMBF+2,X
		STA	1EE0H+1,X
		LDA	!FLNMBF+3,X
		STA	1EE0H+2,X
;
		LDA	!RDFLDT
		AND	#007H
		TAX
		M16			; memory 16bit mode
		LDA	ADDAT,X
		STA	1EF0H
		LDA	SZDAT,X
		STA	1EF4H
		STZ	1EF6H
		M8			; memory 8bit mode
		TXA
		LSR	A
		TAX
		LDA	BNKDAT,X
		STA	1EF2H
;
		RTS
;
;
OKDATA		EQU	$
		HEX	02EH,045H,04EH,044H
		HEX	02EH,044H,041H,054H
		HEX	02EH,045H,054H,042H
		HEX	02EH,04FH,04AH,044H
;
ADDAT		EQU	$
		WORD	ENMYDTBF,COURSEDT,ENNAMBF,CHRDTBF
;
SZDAT		EQU	$
		WORD	00702H,04000H,00A00H,00300H
;
BNKDAT		EQU	$
		BYTE	BANK ENMYDTBF,BANK COURSEDT
		BYTE	BANK ENNAMBF,BANK CHRDTBF
;
;
;****************************************************************
;*								*
;*	file name set						*
;*								*
;****************************************************************
FLNMSET		EQU	$
		LDX	#000H
		LDA	CRXPSL2
		CMP	#080H
		BCC	FLST20
		LDX	#00CH
		CMP	#090H
		BCS	FLST20
		BRA	FLST90
;
FLST20		EQU	$		; file name buffer
		LDA	CRYPSL2	       ;       ram address set
		SEC
		SBC	#068H
		LSR	A
		LSR	A
		LSR	A
		LSR	A
		TAY
		TXA
		CLC
		ADC	FLSTDT,Y
		MI16			; memory , index 16bit mode
		AND	#000FFH
		CLC
		ADC	!SCRLBF
		TAX
		M8			; memory 8bit mode
;
		LDY	#00000H
		LDA	!FLNMBF,X
		CMP	#020H
		BEQ	FLST90
		M16			; memory 16bit mode
		LDA	#00808H
		STA	<WORK0
		LDA	!RDFLDT
		AND	#00007H
		ASL	A
		ASL	A
		TAY
		M8			; memory 8bit mode
		PHY
FLST40		EQU	$		; file buffer ->
		LDA	!FLNMBF,X	;	mo-ji buffer set
		STA	!MOJBF0,Y
		INX
		INY
		DEC	<WORK0
		BNE	FLST40
		PLY
		I8			; index 8bit mode
		LDA	!RDFLDT
		AND	#007H
		LSR	A
		TAX
FLST45		EQU	$
		LDA	!MOJBF0,Y
		CMP	#020H
		BEQ	FLST50
		INY
		INC	!MJIDX0,X
		DEC	<WORK1
		BNE	FLST45
;
FLST50		EQU	$
		JSR	FLNMDMA		; 1 file name DMA set
;
FLST90		EQU	$
		RTS
;
;
FLSTDT		EQU	$
		HEX	000H,018H,030H
;
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+						+
;+	1 file name DMA set			+
;+		work 0,1 <- vram address	+
;+		     2,3 <- buffer address	+
;+						+
;++++++++++++++++++++++++++++++++++++++++++++++++
FLNMDMA		EQU	$
		PHX
		PHY
		LDA	!RDFLDT
		AND	#007H
		TAY
		LDA	MJADRS,Y
		STA	<WORK0
		LDA	MJADRS+1,Y
		STA	<WORK1
		TYA
		LSR	A
		TAY
		LDA	MJBFADL,Y
		STA	<WORK2
		LDA	MJBFADH,Y
		STA	<WORK3
;
		PHB
		LDA	#BANK VRAMDX
		PHA
		PLB
;
		MI16			; memory , index 16bit mode
		LDX	!VRAMDX
		LDA	<WORK0
		STA	0,X		; 2116H , 2117H set
		LDA	#00000H
		STA	2,X		; 2115H , 4300H set
		LDA	<WORK2
		STA	5,X		; 4302H , 4303H set
		LDA	#00008H
		STA	8,X		; 4305H , 4306H set
		M16			; memory 16bit mode
		TXA
		CLC
		ADC	#0000CH
		STA	10,X
		STA	!VRAMDX
		M8			; memory 8bit mode
		LDA	#018H
		STA	4,X		; 4301H set
		LDA	#BANK MOJBF0
		STA	7,X		; 4304H set
		I8			; index 8bit mode
;
		PLB
		PLY
		PLX
		RTS
;
;
MJADRS		EQU	$
		WORD	0744BH
		WORD	0748BH
		WORD	074CBH
		WORD	0750BH
;
;
MJBFADL		EQU	$
		BYTE	LOW MOJBF0,LOW MOJBF1,LOW MOJBF2,LOW MOJBF3
;
MJBFADH		EQU	$
		BYTE	HIGH MOJBF0,HIGH MOJBF1,HIGH MOJBF2,HIGH MOJBF3
;
;
;****************************************************************
;*								*
;*	file name ha-n-te-n					*
;*			( file name )				*
;*				X <------- adress read index	*
;*				work2,3 <- atori		*
;****************************************************************
FLNAME		EQU	$
		PHX
		M16			; memory 16bit mode
		LDA	FLNMAD,X
		STA	<WORK0
		PHB
		LDY	#BANK VRAMDX
		PHY
		PLB
		I16			; index 16bit mode
		LDX	!VRAMDX
		LDA	<WORK0
		STA	0,X		; 2116H , 2117H set
		LDA	#00980H
		STA	2,X		; 2115H , 4300H set
		LDA	#00019H
		STA	4,X		; 4301H set
		TXA
		CLC
		ADC	#0000CH
		STA	5,X		; 4302H , 4303H set
		LDA	#BANK VRAMDX
		STA	7,X		; 4304H set
		LDA	#00030H
		STA	8,X		; 4305H , 4306H set
		TXA
		CLC
		ADC	#0000EH
		STA	10,X		; next address set
		STA	!VRAMDX		; end address set
		LDA	<WORK2
		STA	12,X		; data set
;
		PLB
		STZ	!SCRLBF
		MI8			; memory , index 8bit mode
		PLX
		RTS
;
;
FLNMAD		EQU	$
		WORD	07440H
		WORD	07480H
		WORD	074C0H
		WORD	07500H
;
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+						+
;+	mode name ha-n-te-n			+
;+		( mode )			+
;+			X <- address read index +
;+		  WORK2,3 <- atori		+
;++++++++++++++++++++++++++++++++++++++++++++++++
		MEM16
MDNAME		EQU	$
		LDA	>MDNMAD,X
		STA	<WORK0		; adress set
		PHB
		LDX	#BANK VRAMDX
		PHX
		PLB
		I16			; index 16bit mode
		LDX	!VRAMDX
		LDA	<WORK0
		STA	0,X		; 2116H , 2117H set
		LDA	#00980H
		STA	2,X		; 2115H , 4300H set
		LDA	#00019H
		STA	4,X		; 4301H set
		TXA
		CLC
		ADC	#0000CH
		STA	5,X		; 4302H , 4303H set
		LDA	#BANK VRAMDX
		STA	7,X		; 4304H set
		LDA	#00008H
		STA	8,X		; 4305H , 4306H set
		TXA
		CLC
		ADC	#0000EH
		STA	10,X		; next address set
		STA	!VRAMDX		; end address set
		LDA	<WORK2
		STA	12,X		; data set
;
		I8			; index 8bit mode
		PLB
		RTS
		MEM8
;
;
MDNMAD		EQU	$
		WORD	0745AH
		WORD	0749AH
		WORD	074DAH
		WORD	0751AH
;
;
;****************************************************************
;*								*
;*	enmy data file initial mode				*
;*								*
;****************************************************************
FLNMDSP		EQU	$
		PHB
		PHK
		PLB
;
		LDA	!RDFLDT
		AND	#004
		LSR	A
		LSR	A
;;;;K;;;;		LDA	#0
		DOS	_SELDSK		; disk drive set
		LDA	#2
		DOS	_DSKRST		; floppy disk mode set
;
		LDX	#000H
		LDA	#03FH
FLNM000		EQU	$		; wild name "?" set
		STA	1EE0H,X
		INX
		CPX	#008H
		BCC	FLNM000
;
		LDA	!RDFLDT		; ka-ku-chi-yo-u-si set
		AND	#006H		;
		ASL	A		;
		TAX			;
		STA	<WORK0		;
		STZ	<WORK1		;
		LDA	KKCYUS+1,X	;
		STA	1EE8H		;
		LDA	KKCYUS+2,X	;
		STA	1EE9H		;
		LDA	KKCYUS+3,X	;
		STA	1EEAH		;
		DOS	_DIRFST
		TAX
		BNE	FLNM080
;
		LDX	#000H
FLNM010		EQU	$
		LDA	1EC0H,X		; file name read
		STA	!FLNMBF,X
		INX
		CPX	#008H
		BNE	FLNM010
		LDX	<WORK0
		M16			; memory 16bit mode
		LDA	KKCYUS,X
		STA	!FLNMBF+08
		LDA	KKCYUS+2,X
		STA	!FLNMBF+10
		M8			; memory 8bit mode
		INC	!FNBIDX
		LDA	#00CH
		STA	<WORKA
		STZ	<WORKB
;
FLNM020		EQU	$
		DOS	_DIRNXT
		TAX
		BNE	FLNM090
		I16			; index 16bit mode
		LDX	#00000H
		LDY	<WORKA
FLNM025		EQU	$
		LDA	1EC0H,X		; file name read
		STA	!FLNMBF,Y
		INY
		INX
		CPX	#00008H
		BNE	FLNM025
		LDX	<WORK0
		M16			; memory 16bit mode
		LDA	KKCYUS,X
		STA	!FLNMBF,Y
		LDA	KKCYUS+2,X
		STA	!FLNMBF+2,Y
		LDA	<WORKA
		CLC
		ADC	#0000CH
		STA	<WORKA
		MI8			; memory , index 8bit mode
		INC	!FNBIDX
		BRA	FLNM020
;
FLNM080		EQU	$
		STX	<WORKE
		JSR	ENERST		; error name set
		BRA	FLNM999
;
FLNM090		EQU	$
		STZ	!SCRLBF
		STZ	!SCRLBF+1
		LDA	!FNBIDX
		CMP	#007H
		BCC	FLNM095
		DEC	A
		AND	#0FEH
		TAX
		M16			; memory 16bit mode
		LDA	UPSCRLM,X
		STA	!SCRLBF
		M8			; memory 8bit mode
FLNM095		EQU	$
		JSR	ENFLNMDP	; file name disp set
;
FLNM999		EQU	$
		LDA	#ENFMD
		STA	MODENO
		PLB
		RTL
;
;
KKCYUS		EQU	$
		BYTE	02EH,045H,04EH,044H	; .END
		BYTE	02EH,044H,041H,054H	; .DAT
		BYTE	02EH,045H,054H,042H	; .ETB
		BYTE	02EH,04FH,04AH,044H	; .OJD
;
;
;++++++++++++++++++++++++++++++++++++++++
;+					+
;+	file name disp set		+
;+					+
;++++++++++++++++++++++++++++++++++++++++
ENFLNMDP	EQU	$
		I16			; index 16bit mode
		PHB
		LDA	#BANK VRAMDX
		PHA
		PLB
;
		STZ	<WORK0
		STZ	<WORK1
		STZ	<WORK2
		STZ	<WORK3
ENFLDP		EQU	$
		LDX	<WORK0
		LDY	!VRAMDX
		M16			; memory 16bit mode
		LDA	>ENFLAD,X	; vram address
		STA	0,Y		;	2116H , 2117H set
		LDA	#00000H
		STA	2,Y		; 2115H , 4300H set
		LDA	#FLNMBF
		CLC
		ADC	<WORK2
		CLC
		ADC	>SCRLBF
		STA	5,Y		; 4302H , 4303H set
		LDA	#0000CH
		STA	8,Y		; 4305H , 4306H set
		TYA
		CLC
		ADC	#0000CH
		STA	10,Y		; next address set
		STA	!VRAMDX		; end address set
		M8			; memory 8bit mode
		LDA	#00018H
		STA	4,Y		; 4301H set
		LDA	#BANK FLNMBF
		STA	7,Y		; 4304H set
;
		INC	<WORK0
		INC	<WORK0
		LDA	<WORK2
		CLC
		ADC	#00CH
		STA	<WORK2
		CMP	#048H
		BNE	ENFLDP
;
		M16			; memory 16bit mode
		LDX	!VRAMD
		LDA	#075B0H
		STA	!VRAMD+02,X
		LDA	#04003H
		STA	!VRAMD+04,X
		LDA	#00020H
		STA	!VRAMD+06,X
		LDA	#0FFFFH
		STA	!VRAMD+08,X
		LDA	!VRAMD
		CLC
		ADC	#00006H
		STA	!VRAMD
		M8			; memory 8bit mode
;
		PLB
		I8			; index 8bit mode
		RTS
;
;
ENFLAD		EQU	$
		WORD	075A4H
		WORD	075B2H
		WORD	075E4H
		WORD	075F2H
		WORD	07624H
		WORD	07632H
;
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+						+
;+	error name set				+
;+						+
;+		work E <- error code NO.	+
;+						+
;++++++++++++++++++++++++++++++++++++++++++++++++
ENERST		EQU	$
;
		JSR	ENFLNMDP	; file name disp set
;
		I16			; index 16bit mode
		PHB
		LDA	#BANK VRAMDX
		PHA
		PLB
		LDY	!VRAMDX
		M16			; memory 16bit mode
		LDA	#00000H
		STA	!VRAMD
		DEC	A
		STA	!VRAMD+2
		LDA	<WORKE
		AND	#0000FH
		ASL	A
		TAX
		LDA	#075A4H		; vram address
		STA	0,Y		;	2116H , 2117H set
		LDA	#00000H
		STA	2,Y		; 2115H , 4300H set
		LDA	>ERNMDT,X
		STA	5,Y		; 4302H , 4303H set
		LDA	>ERNMCT,X
		STA	8,Y		; 4305H , 4306H set
		TYA
		CLC
		ADC	#0000CH
		STA	10,Y		; next address set
		STA	!VRAMDX		; end address set
		M8			; memory 8bit mode
		LDA	#00018H
		STA	4,Y		; 4301H set
		LDA	#BANK ERNMDT
		STA	7,Y		; 4304H set
;
		PLB
		I8			; index 8bit mode
		RTS
;
;
ERNMDT		EQU	$-2
		WORD	ERDT01,ERDT02,ERDT03,ERDT04
		WORD	ERDT05,ERDT06,ERDT07,ERDT08
		WORD	ERDT09
;
ERNMCT		EQU	$-2
		WORD	ERDT02-ERDT01,ERDT03-ERDT02
		WORD	ERDT04-ERDT03,ERDT05-ERDT04
		WORD	ERDT06-ERDT05,ERDT07-ERDT06
		WORD	ERDT08-ERDT07,ERDT09-ERDT08
		WORD	ERDT0A-ERDT09
;
ERDT01	EQU	$
	HEX	044H,049H,053H,04BH,020H		; disk
	HEX	053H,045H,054H,020H			; set
	HEX	045H,052H,052H,04FH,052H		; error
;
ERDT02	EQU	$
	HEX	044H,049H,053H,04BH,020H		; disk
	HEX	049H,02FH,04FH,020H			; I/O
	HEX	045H,052H,052H,04FH,052H		; error
;
ERDT03	EQU	$
	HEX	044H,049H,053H,04BH,020H		; disk
	HEX	053H,059H,053H,054H,045H,04DH,020H	; system
	HEX	045H,052H,052H,04FH,052H		; error
;
ERDT04	EQU	$
	HEX	046H,049H,04CH,045H,020H		; file
	HEX	04EH,04FH,054H,020H			; not
	HEX	046H,04FH,055H,04EH,044H		; found
;
ERDT05	EQU	$
	HEX	046H,049H,04CH,045H,020H		; file
	HEX	04FH,050H,045H,04EH,020H		; open
	HEX	045H,052H,052H,04FH,052H		; error
;
ERDT06	EQU	$
	HEX	044H,049H,052H,045H			; dire
	HEX	043H,054H,04FH,052H,059H		; ctory
	HEX	020H,046H,055H,04CH,04CH		; full
;
ERDT07	EQU	$
	HEX	046H,049H,04CH,045H,020H		; file
	HEX	052H,045H,041H,044H,020H		; read
	HEX	04FH,04EH,04CH,059H			; only
;
ERDT08	EQU	$
	HEX	044H,049H,053H,04BH,020H		; disk
	HEX	046H,055H,04CH,04CH			; full
	HEX	020H,020H,020H,020H,020H
;
ERDT09	EQU	$
	HEX	046H,049H,04CH,045H,020H		; file
	HEX	041H,04CH,052H,045H,041H,044H,059H,020H ; already
	HEX	045H,058H,049H,053H,054H		; exist
;
ERDT0A	EQU	$
;
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+						+
;+	file name buffer clear			+
;+						+
;++++++++++++++++++++++++++++++++++++++++++++++++
FLNMCLR		EQU	$
		PHX
		STZ	!FNBIDX
		MI16			; memory , index 16bit mode
		LDX	#000FEH
		LDA	#02020H
FMCL		EQU	$
		STA	!FLNMBF+0000H,X
		STA	!FLNMBF+0100H,X
		STA	!FLNMBF+0200H,X
		STA	!FLNMBF+0300H,X
		STA	!FLNMBF+0400H,X
		DEX
		DEX
		BPL	FMCL
		MI8			; memory , index 8bit mode
		PLX
		RTS
;
;
;********************************************************
;*							*
;*	file name scroll				*
;*							*
;********************************************************
ENFLSCRL	EQU	$
		LDX	#000H
		LDA	CRYPSL2	       ; scroll
		CMP	#077H		;	(up) 000h -> X
		BCC	ENSL00		;     (down) 002h -> X
		CMP	#07EH
		BCC	ENSL90
		LDX	#002H
;
ENSL00		EQU	$
		M16			; memory 16bit mode
		TXY
		BNE	ENSL03
		LDA	!FNBIDX
		DEC	A
		AND	#000FEH
		TAY
		LDA	UPSCRLM,Y
		CMP	!SCRLBF		; up scroll limt ?
		BEQ	ENSL05		;	YES -> FLSL05
ENSL03		EQU	$
		LDA	!SCRLBF
		CLC
		ADC	FLSLCT,X
		STA	!SCRLBF		; down scroll limt ?
		BPL	ENSL05		;	NO -> FLSL05
		STZ	!SCRLBF
ENSL05		EQU	$
		M8			; memory 8bit mode
;
		JSR	ENFLNMDP	; file name disp set
;
ENSL90		EQU	$
		RTS
;
FLSLCT		EQU	$
		WORD	00018H,0FFE8H
;
UPSCRLM		EQU	$-6
		WORD	00018H,00030H,00048H,00060H,00078H,00090H
		WORD	000A8H,000C0H,000D8H,000F0H,00108H,00120H
		WORD	00138H,00150H,00168H,00180H,00198H,001B0H
		WORD	001C8H,001E0H,001F8H,00210H,00228H,00240H
		WORD	00258H,00270H,00288H,002A0H,002B8H,002D0H
		WORD	002E8H,00300H,00318H,00330H,00348H,00360H
		WORD	00378H,00390H,003A8H,003C0H,003D8H,003F0H
		WORD	00408H,00420H,00438H,00450H,00468H,00480H
		WORD	00498H,004B0H
;
;
;++++++++++++++++++++++++++++++++++++++++
;+					+
;+	mo-ji disp & buffer set		+
;+					+
;++++++++++++++++++++++++++++++++++++++++
MJBFST		EQU	$
		LDA	CRYPSL2
		CLC
		ADC	#004H
		SEC
		SBC	#0A0H
		AND	#0F0H
		STA	<WORK0
;
		LDA	CRXPSL2
		CLC
		ADC	#004H
		LSR	A
		LSR	A
		LSR	A
		LSR	A
		ORA	<WORK0
		TAX
;
		LDA	#004H
		STA	<WORK1
		LDA	MOJDAT,X	; mo-ji data read
		STA	<WORK0
		STA	<WORKE
		CMP	#0FCH		; no ?
		BEQ	MJBF90		;	YES -> MJBF90
		CMP	#0FEH		; yes ?
		BEQ	MJBF90		;	YES -> MJBF90
		CMP	#0FFH		; line clear ?
		BEQ	MJBF50		;	YES -> MJBF50
		CMP	#0FDH		; back specs ?
		BNE	MJBF00		;	NO -> MJBF00
		LDA	#020H
		STA	<WORK0
		LDA	!RDFLDT
		AND	#007H
		LSR	A
		TAX
		LDA	!MJIDX0,X
		BEQ	MJBF90
		DEC	!MJIDX0,X
;
MJBF00		EQU	$
		LDA	MODENO
		CMP	#FPSV		; Z[u ?
		BEQ	MJBF90		;	YES -> MJBF90
		CMP	#FPLD		; [h ?
		BEQ	MJBF90		;	YES -> MJBF90
		CMP	#FPDL		; f[g ?
		BEQ	MJBF90		;	YES -> MJBF90
		CMP	#ENITSB		; Tu CjV ?
		BEQ	MJBF90		;	YES -> MJBF90
		LDA	!RDFLDT		; address
		AND	#007H
		LSR	A
		TAX
		LDA	!MJIDX0,X
		CMP	#008H
		BCS	MJBF10
;
		LDA	!RDFLDT		; buffer set
		AND	#007H
		LSR	A
		TAY
		ASL	A
		ASL	A
		ASL	A
		CLC
		ADC	!MJIDX0,Y
		TAY
		LDA	<WORK0
		STA	!MOJBF0,Y
;
		JSR	FLNMDMA		; 1 file name DMA set
;
MJBF10		EQU	$
		LDA	<WORKE		; mo-ji data read
		CMP	#0FDH
		BEQ	MJBF90
		INC	!MJIDX0,X
		LDA	!MJIDX0,X
		CMP	#008H
		BCC	MJBF90
		LDA	#008H
		STA	!MJIDX0,X
		BRA	MJBF90
;
MJBF50		EQU	$
		JSR	LINCLS		; line clear
;
MJBF90		EQU	$
		RTS
;
;------------------------------------- line clear
LINCLS		EQU	$
		LDA	!RDFLDT
		AND	#007H
		LSR	A
		TAX
		LDA	!MJIDX0,X
		BEQ	LIN999
		STZ	!MJIDX0,X	; index clear
;
		LDA	!RDFLDT
		AND	#007H
		ASL	A
		ASL	A
		TAY
		LDX	#008H
		LDA	#020H
LIN000		EQU	$		; buffer clear
		STA	!MOJBF0,Y
		INY
		DEX
		BNE	LIN000
		JSR	FLNMDMA		; 1 file name DMA set
LIN999		EQU	$
		RTS
;
;
MOJDAT		EQU	$
;			0    1	  2    3    4	 5    6	   7
		HEX	000H,041H,042H,043H,044H,045H,046H,047H
;			8    9	  A    B    C	 D    E	   F
		HEX	048H,049H,04AH,0FFH,0FFH,0FEH,0FEH,0FEH
;
;			0    1	  2    3    4	 5    6	   7
		HEX	000H,04BH,04CH,04DH,04EH,04FH,050H,051H
;			8    9	  A    B    C	 D    E	   F
		HEX	052H,053H,054H,0FDH,0FDH,0FEH,0FEH,0FEH
;
;			0    1	  2    3    4	 5    6	   7
		HEX	000H,055H,056H,057H,058H,059H,05AH,020H
;			8    9	  A    B    C	 D    E	   F
		HEX	020H,02DH,05FH,020H,020H,020H,0FCH,0FCH
;
;			0    1	  2    3    4	 5    6	   7
		HEX	000H,030H,031H,032H,033H,034H,035H,036H
;			8    9	  A    B    C	 D    E	   F
		HEX	037H,038H,039H,020H,020H,020H,0FCH,0FCH
;
;
;****************************************************************
;*								*
;*	floppy disk data load mode				*
;*								*
;****************************************************************
FLPYLD		EQU	$
		PHB
		PHK
		PLB
		JSR	FLMSMV			; file mode mouse move
		LDA	MOUSEBT
		AND	#11000000B	; mouse right ON ?
		BPL	FPLD00		;	NO  -> FLP910
		JMP	FLP990		;	YES -> FLP990
FPLD00		EQU	$
		AND	#01000000B	; mouse left ON ?
		BNE	FPLD10		;	YES -> FPLD10
		JMP	FLP999		;	N0  -> FLP999
;
FPLD10		EQU	$
		JSR	YESNOST		; YES , NO set
		LDA	<WORK0
		BNE	FPLD15
		JMP	FLP999
FPLD15		EQU	$
		BPL	FPLD20
		JMP	FLP990
;
FPLD20		EQU	$
		DOS	_LOAD
;
		STA	<WORKE
		AND	#00FH		; G[ ?
		BNE	FPLD28		;	YES -> FPLD28
		LDA	!RDFLDT
		AND	#007H		; Gf[^ ?
		BEQ	FPLD25		;	YES -> FPLD25
		CMP	#004H		; G̖Of[^ ?
		BEQ	FPLD30		;	YES -> FPLD30
		CMP	#006H		; nai ^Cv f[^ ?
		BEQ	FPLD70		;	YES -> FPLD70
		JMP	FPLD60
FPLD25		EQU	$
		LDA	#07FH		; Gf[^
		STA	<WORK2
;
		JSR	ENBGBFCL	; buffer clear
;
		JSR	ENBGBFST	; buffer set
;
FPLD28		EQU	$
		LDA	<WORKE		; G[ !!
		JMP	DSSTOK
;
FPLD30		EQU	$		; G̖Of[^
		LDA	1EF8H		; ya-ri-za-n
		STA	4204H
		LDA	1EF9H
		STA	4205H
		LDA	#005H
		STA	4206H
		NOP
		NOP
		NOP
		NOP
		NOP
		NOP
		NOP
		NOP
		LDA	4214H
		STA	!ENNAMCT
		STA	>ENNAMCT_SB
		LDA	4215H
		STA	!ENNAMCT+1
		STA	>ENNAMCT_SB+1
		LDA	<WORKE
		JMP	DSSTOK
;
FPLD60		EQU	$		; R[Xf[^
		LDA	1EF0H
		STA	<WORK0
		LDA	1EF1H
		STA	<WORK1
		LDA	1EF2H
		STA	<WORK2
		LDA	#0FFH		; Gh R[h Zbg !!
		STA	[<WORK0]
		JSL	>DTSHARE
		JSL	>EN_SDPTCAL
FPLD70		EQU	$
		LDA	<WORKE
		JMP	DSSTOK
;
;
;****************************************************************
;*								*
;*	floppy disk data save mode				*
;*								*
;****************************************************************
FLPYSV		EQU	$
		PHB
		PHK
		PLB
		JSR	FLMSMV			; file mode mouse move
		LDA	MOUSEBT
		AND	#11000000B	; mouse right ON ?
		BPL	FPSV00		;	NO  -> FPSV00
		JMP	FLP990		;	YES -> FLP990
FPSV00		EQU	$
		AND	#01000000B	; mouse left ON ?
		BNE	FPSV10		;	YES -> FPSV10
		JMP	FLP999		;	N0  -> FLP999
;
FPSV10		EQU	$
		JSR	YESNOST		; YES , NO set
		LDA	<WORK0
		BNE	FPSV11
		JMP	FLP999
;
FPSV11		EQU	$
		BMI	FLP990
;
		DOS	_SAVE
		JMP	DSSTOK
;
;
;****************************************************************
;*								*
;*	floppy disk data delete mode				*
;*								*
;****************************************************************
FLPYDL		EQU	$
		PHB
		PHK
		PLB
		JSR	FLMSMV			; file mode mouse move
		LDA	MOUSEBT
		AND	#11000000B	; mouse right ON ?
		BPL	FPDL00		;	NO  -> FPDL00
		JMP	FLP990		;	YES -> FLP990
FPDL00		EQU	$
		AND	#01000000B	; mouse left ON ?
		BEQ	FLP999		;	N0 -> FLP999
;
		JSR	YESNOST		; YES , NO set
		LDA	<WORK0
		BNE	FPDL01
		JMP	FLP999
;
FPDL01		EQU	$
		BMI	FLP990
;
		DOS	_PURGE
		BRA	DSSTOK
;
;
;****************************************************************
;*								*
;*	floppy disk format mode					*
;*								*
;****************************************************************
FLPYFT		EQU	$
		PHB
		PHK
		PLB
		JSR	FLMSMV			; file mode mouse move
		LDA	MOUSEBT
		AND	#11000000B	; mouse right ON ?
		BMI	FLP990		;	YES -> FLP990
		AND	#01000000B	; mouse left ON ?
		BEQ	FLP999		;	N0 -> FLP999
;
		JSR	YESNOST		; YES , NO set
		LDA	<WORK0
		BEQ	FLP999
		BMI	FLP990
;
		DOS	_FORMAT
;
DSSTOK		EQU	$
		TAX
		BEQ	FLP900
		STA	<WORKE
		JSR	FLNMCLR		; file name buffer initial set
		JSR	ENERST		; error name set
		BRA	FLP995
;
FLP900		EQU	$
		LDX	#000H
		LDA	MODENO
		CMP	#FPSV		; Z[u ?
		BNE	FLP905		;	NO -> FLP905
		LDX	#018H
FLP905		EQU	$
		LDA	#04FH		; "OK" set
		STA	!FLNMBF+024H,X
		LDA	#04BH
		STA	!FLNMBF+024H+1,X
		JSR	ENFLNMDP	; file name disp set
		BRA	FLP995
;
FLP990		EQU	$
		JSR	FLNMCLR		; file name buffer clear
		JSR	ENFLNMDP	; file name disp set
FLP995		EQU	$
		M16			; memory 16bit mode
		LDX	!ENMDFG1
		STZ	<WORK2
		JSR	MDNAME		; mode name ha-n-te-n
		M8			; memory 16bit mode
		LDA	#ENFMD
		STA	MODENO
FLP999		EQU	$
		PLB
		RTL
;
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+						+
;+	YES , NO set				+
;+						+
;++++++++++++++++++++++++++++++++++++++++++++++++
YESNOST		EQU	$
		LDX	#000H
		LDA	CRXPSL2
		CMP	#0D6H
		BCC	YESNO99
		CMP	#0F4H
		BCS	YESNO99
;
		LDA	CRYPSL2
		CMP	#0A0H
		BCC	YESNO99
		CMP	#0D8H
		BCS	YESNO99
		CMP	#0B8H		; input "YES" ?
		BCC	YESNO10		;	YES -> YESNO10
		CMP	#0C0H		; input "NO" ?
		BCS	YESNO20		;	NO -> YESNO20
		BRA	YESNO99
;
YESNO10		EQU	$
		INX
		BRA	YESNO99
;
YESNO20		EQU	$
		DEX
;
YESNO99		EQU	$
		STX	<WORK0
		RTS
;
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+						+
;+	buffer clear				+
;+						+
;++++++++++++++++++++++++++++++++++++++++++++++++
ENBGBFCL	EQU	$
		PHB
		LDA	#BANK ENBGDTBF
		PHA
		PLB
		MI16			; memory , index 16bit mode
		LDX	#01000H-2
BFCLLP		EQU	$			; buffer clear
		STZ	!ENBGDTBF+00000H,X
		STZ	!ENBGDTBF+01000H,X
		STZ	!ENBGDTBF+02000H,X
		STZ	!ENBGDTBF+03000H,X
		STZ	!ENBGDTBF+04000H,X
		STZ	!ENBGDTBF+05000H,X
		STZ	!ENBGDTBF+06000H,X
		STZ	!ENBGDTBF+07000H,X
		DEX
		DEX
		BPL	BFCLLP
		MI8			; memory , index 8bit mode
		PLB
		RTS
;
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+						+
;+	buffer set				+
;+						+
;++++++++++++++++++++++++++++++++++++++++++++++++
ENBGBFST	EQU	$
		MI16			; memory , index 16bit mode
		LDA	>ENMYDTBF
		STA	!ENDTPT		; enmy data count set
		STA	<WORKA
		ASL	A
		ASL	A
		ASL	A
		SEC
		SBC	<WORKA
		TAX
		LDA	#0FFFFH
		STA	>ENDTBF,X
		LDX	#00000H
BFST00		EQU	$		; enmy data BG buffer set
		LDA	>ENDTBF,X
		CMP	#0FFFFH
		BEQ	BFST50
		JSR	ENNMSH		; enmy name search
;
		LDA	>ENDTBF+5,X
		AND	#000FEH
		ASL	A
		ASL	A
		ASL	A
		AND	#000F0H
		STA	<WORK0
		LDA	>ENDTBF+5,X
		LSR	A
		AND	#00070H
		XBA
		ORA	<WORK0
		STA	<WORK0
		LDA	>ENDTBF+5,X
		AND	#00F00H
		XBA
		ORA	<WORK0
		STA	<WORK0
		LDA	>ENDTBF+5,X
		AND	#0F000H
		LSR	A
		LSR	A
		LSR	A
		LSR	A
		ORA	<WORK0
		STA	<WORK0
;
		LDA	[<WORK0]
		INC	A
		STA	[<WORK0]
		TXA
		CLC
		ADC	#00007H
		TAX
		DEC	<WORKA
		BPL	BFST00
BFST50		EQU	$
		MI8			; memory , index 8bit mode
		RTS
;
ENBFST		EQU	$
		PHB
		PHK
		PLB
		LDA	#07FH
		STA	<WORK2
		JSR	ENBGBFCL	; buffer clear
		JSR	ENBGBFST	; buffer set
		PLB
		RTL
;
ENBFCLS		EQU	$
		JSR	ENBGBFCL	; buffer clear
		RTL
;
;
;++++++++++++++++++++++++++++++++++++++++
;+					+
;+	enmy name search		+
;+					+
;++++++++++++++++++++++++++++++++++++++++
		MEM16
		IDX16
ENNMSH		EQU	$
		LDA	!ENNAMCT
		BEQ	NMSH50
		ASL	A
		ASL	A
		ADC	!ENNAMCT
		STA	<WORK8
;
		M8			; memory 8bit mode
		PHB			; bank <- 7e
		LDA	#BANK ENNAMBF	;
		PHA			;
		PLB			;
		M16			; memory 16bit mode
;
		LDY	#00000H
NMSH00		EQU	$
		LDA	!ENDTBF,X
		CMP	!ENNAMBF,Y
		BNE	NMSH10
		LDA	!ENDTBF+2,X
		CMP	!ENNAMBF+2,Y
		BNE	NMSH10
		LDA	!ENDTBF+3,X
		CMP	!ENNAMBF+3,Y
		BEQ	NMSH50
NMSH10		EQU	$
		INY
		INY
		INY
		INY
		INY
		CPY	<WORK8
		BNE	NMSH00
;
		PHB
		PHX
		STX	<WORK8
		TXA
		CLC
		ADC	#ENDTBF
		TAY
		CLC
		ADC	#00007H
		TAX
		LDA	>ENDTPT
		ASL	A
		ASL	A
		ASL	A
		SEC
		SBC	>ENDTPT
		SEC
		SBC	<WORK8
		MVN	#BANK ENDTBF,#BANK ENDTBF
		PLX
		PLB
		DEC	<WORKA
		LDA	>ENDTPT
		DEC	A
;;;;K;;;;		STA	<WORKA
		STA	>ENDTPT
		STA	>ENMYDTBF
;
NMSH50		EQU	$
		PLB
;
		RTS
		MEM8
		IDX8
;
;-----------------------------------------------------------------------
;-----------------------------------------------------------------------
;
;****************************************************************
;*								*
;*	BG or enmy data set tool select initial mode		*
;*								*
;****************************************************************
BGENINT		EQU	$
		PHB
		PHK
		PLB
		JSL	>VRAMCL
;
;-------------- PPU Reg. initial set ----------------------------
		LDX	#GM00
		JSL	>GMMDST
		STZ	2105H
		LDA	#11H
		STA	MANSEL
		STA	212CH
		LDA	#68H
		STA	BG1SCF
		STA	2107H
		LDA	#070H
		STA	BG12CH
		STA	210BH
;
		M16			; memory 16bit mode
;
;-------------- mode 0 character set ----------------------------
		LDY	#10000000B
		STY	2115H		; inc mode set
		LDA	#00000H
		STA	2116H		; VRAM address set
		LDA	#00000001B+(18H*100H)
		STA	4300H		; DMA parameter & B bus address set
		LDA	#169800H
		STA	4302H		; A bus address(L,H) set
		LDY	#BANK 169800H
		STY	4304H		;	"       (B) set
		LDA	#01000H
		STA	4305H		; number of byte set
		LDX	#00000001B
		STX	420BH		; DMA "ON"
;
;-------------- OBJ character set -------------------------------
		LDA	#04000H
		STA	2116H		; VRAM address set
		LDA	#00000001B+(18H*100H)
		STA	4300H		; DMA parameter & B bus address set
		LDA	#168000H
		STA	4302H		; A bus address(L,H)
		LDY	#BANK 168000H
		STY	4304H		;	"       (B)
		LDA	#00400H
		STA	4305H		; number of byte set
		STX	420BH
;
;-------------- mo-ji set ---------------------------------------
		LDY	#00000000B
		STY	2115H		; inc mode set
		LDA	#0694AH
		STA	<WORK0
		LDA	#MJDAT0
		STA	<WORK2
		LDA	#MJDAT1-MJDAT0
		STA	<WORK4
		JSR	MJSTSB		; mo-ji data set sub
;
		LDA	#0698AH
		STA	<WORK0
		LDA	#MJDAT1
		STA	<WORK2
		LDA	#MJDAT2-MJDAT1
		STA	<WORK4
		JSR	MJSTSB		; mo-ji data set sub
;
		LDA	#06A2FH
		STA	<WORK0
		LDA	#MJDAT2
		STA	<WORK2
		LDA	#MJDAT3-MJDAT2
		STA	<WORK4
		JSR	MJSTSB		; mo-ji data set sub
;
		LDA	#06A4FH
		STA	<WORK0
		LDA	#MJDAT3
		STA	<WORK2
		LDA	#MJDAT4-MJDAT3
		STA	<WORK4
		JSR	MJSTSB		; mo-ji data set sub
;
		LDA	#06A6FH
		STA	<WORK0
		LDA	#MJDAT4
		STA	<WORK2
		LDA	#MJDAT5-MJDAT4
		STA	<WORK4
		JSR	MJSTSB		; mo-ji data set sub
;
		JSR	BACK_UP_CHK
		LDA	<WORK0
		ORA	<WORK2
		BEQ	BGENIT_600
;
		LDA	#069CAH
		STA	<WORK0
		LDA	#MJDAT5
		STA	<WORK2
		LDA	#MJDAT6-MJDAT5
		STA	<WORK4
		JSR	MJSTSB		; mo-ji data set sub
;
BGENIT_600	EQU	$
		M8			; memory 8bit mode
;
;-------------- color set ---------------------------------------
		STZ	2121H		; CGRAM address set
		M16			; memory 16bit mode
		LDA	#00000000B+(22H*100H)
		STA	4300H		; DMA parameter & B bus address set
		LDA	#16B000H
		STA	4302H		; A bus address(L,H) set
		LDY	#BANK 16B000H
		STY	4304H		;	"       (B) set
		LDA	#00200H
		STA	4305H		; number of byte set
		LDX	#00000001B
		STX	420BH
;
		STZ	<SCCH1
		STZ	<SCCH2
		STZ	<SCCH3
		STZ	<SCCV1
		STZ	<SCCV2
		STZ	<SCCV3
		LDA	#00040H
		STA	CRXPSL2
		STA	CRYPSL2
		M8			; memory 8bit mode
;
		LDA	#002H
		STA	!ENMDFG0
		STA	!ENMDFG1
		LDA	#080H
		STA	ENBGFLG
;
		LDA	#0FH
		STA	FADNO
;
;-------------- blanking "ON" & go to next mode -----------------
MODINC2		EQU	$
		JSL	>BLNKOFF	;blanking "OFF"
;
MODINC		EQU	$
		INC	MODENO
		PLB
		RTL
;
;
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+						+
;+	mo-ji data set sub			+
;+		    work0,1 <- VRAM address	+
;+			2,3 <- A bus address	+
;+			4,5 <- number of byte	+
;++++++++++++++++++++++++++++++++++++++++++++++++
		MEM16
MJSTSB		EQU	$
		LDA	<WORK0
		STA	2116H		; VRAM address set
		LDA	#00000000B+(18H*100H)
		STA	4300H		; DMA parameter & B bus address set
		LDA	<WORK2
		STA	4302H		; A bus address(L,H) set
		LDA	#BANK MJDAT1
		STA	4304H		;	"       (B) set
		LDA	<WORK4
		STA	4305H		; number of byte set
		LDX	#00000001B
		STX	420BH		; DMA "ON"
		RTS
		MEM8
;
;
MJDAT0		EQU	$
		BYTE	031H,02EH			; "1."
		BYTE	045H,04EH,04DH,059H,040H	; "ENMY "
		BYTE	044H,041H,054H,041H,040H	; "DATA "
		BYTE	053H,045H,054H			; "SET"
;
MJDAT1		EQU	$
		BYTE	032H,02EH			; "2."
		BYTE	042H,047H,040H			; "BG "
		BYTE	045H,044H,049H,054H		; "EDIT"
;
MJDAT2		EQU	$
		BYTE	080H,081H,081H,088H		; "+--+"
MJDAT3		EQU	$
		BYTE	083H,047H,04FH,083H		; "|GO|"
MJDAT4		EQU	$
		BYTE	085H,081H,081H,089H		; "+--+"
;
MJDAT5		EQU	$
		BYTE	033H,02EH			; "3."
		BYTE	055H,04EH,044H,04FH,040H	; "UNDO "
		BYTE	042H,041H,043H,04BH,02DH	; "BACK_"
		BYTE	055H,050H			; "UP"
;
MJDAT6		EQU	$
;
;
;****************************************************************
;*								*
;*	BG or enmy data set tool select mode			*
;*								*
;****************************************************************
BGENSL		EQU	$
		PHB
		PHK
		PLB
;
		JSR	FLMSMV
		LDA	#002H
		STA	>OAMSUB
;
		LDA	MOUSEBB
		AND	#01000000B	; mouse left ON ?
		BNE	BGENSL_000	;	YES -> BGENSL_000
		JMP	BGEN999		;	NO -> BGEN999
;
BGENSL_000	EQU	$
		LDA	ENBGFLG
		AND	#00FH
		BEQ	BGEN000
		LDA	CRYPSL2
		CMP	#08BH
		BCC	BGEN000
		CMP	#09BH
		BCS	BGEN000
		LDA	CRXPSL2
		CMP	#07DH
		BCC	BGEN000
		CMP	#095H
		BCS	BGEN000
		INC	MODENO	       ; goto edit mode
		JMP	BGEN999
;
BGEN000		EQU	$		; edit mode select
		LDA	CRXPSL2
		CMP	#050H
		BCC	BGEN999
		CMP	#0C9H
		BCS	BGEN999
		LDA	CRYPSL2
		CMP	#050H
		BCC	BGEN999
		CMP	#078H
		BCS	BGEN999
		AND	#008H
		BNE	BGEN999
;
		LDA	!CRYPSL2
		AND	#0F0H
		CMP	#070H
		BNE	BGEN050
		M16			; memory 16bit mode
		JSR	BACK_UP_CHK
		M8			; memory 8bit mode
		LDA	<WORK0
		ORA	<WORK1
		ORA	<WORK2
		ORA	<WORK3
		BEQ	BGEN999
BGEN050		EQU	$
;
		LDA	!ENMDFG0
		STA	!ENMDFG1
		LDA	CRYPSL2
		AND	#0F0H
		SEC
		SBC	#040H
		LSR	A
		LSR	A
		LSR	A
		STA	!ENMDFG0
		LSR	A
		ORA	#080H
		STA	ENBGFLG
;
		LDX	!ENMDFG1
		STZ	<WORK2
		STZ	<WORK3
		JSR	SLNMHT		; select name ha-n-te-n
;
		LDX	!ENMDFG0
		LDA	#004H
		STA	<WORK2
		STA	<WORK3
		JSR	SLNMHT		; select name ha-n-te-n
;
BGEN999		EQU	$
		PLB
		RTL
;
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+						+
;+	select name ha-n-te-n			+
;+						+
;++++++++++++++++++++++++++++++++++++++++++++++++
SLNMHT		EQU	$
		M16			; memory 16bit mode
		LDA	>SLNMAD,X
		STA	<WORK0
;
		PHB
		LDX	#BANK VRAMDX
		PHX
		PLB
		I16			; index 16bit mode
		LDX	!VRAMDX
		LDA	<WORK0
		STA	0,X		; 2116H , 2117H set
		LDA	#00980H
		STA	2,X		; 2115H , 4300H set
		LDA	#00019H
		STA	4,X		; 4301H set
		TXA
		CLC
		ADC	#0000CH
		STA	5,X		; 4302H , 4303H set
		LDA	#BANK VRAMDX
		STA	7,X		; 4304H set
		LDA	#00020H
		STA	8,X		; 4305H , 4306H set
		TXA
		CLC
		ADC	#0000EH
		STA	10,X		; next address set
		STA	!VRAMDX		; end address set
		LDA	<WORK2
		STA	12,X		; data set
;
		I8			; index 8bit mode
		PLB
		M8			; memory 16bit mode
		RTS
;
SLNMAD		EQU	$-2
		WORD	0694AH
		WORD	0698AH
		WORD	069CAH
;
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+		obNAbvf[^邩		+
;+				out			+
;+				wrk0,1 : BG data	+
;+				wrk2,3 : ENMY data	+
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
		MEM16
BACK_UP_CHK	EQU	$
		LDX	#000H
		STZ	<WORK0
		STZ	<WORK2
BAK_UP_CHK_LP	EQU	$
		LDA	>DTBUFF_BAK,X
		CLC
		ADC	<WORK0
		STA	<WORK0
		LDA	>ENMYDTBF_BAK,X
		CLC
		ADC	<WORK2
		STA	<WORK2
		DEX
		DEX
		BPL	BAK_UP_CHK_LP
		RTS
		MEM8
;
;
;****************************************************************
;*								*
;*	BG or enmy data set tool select feard mode		*
;*								*
;****************************************************************
BGENFD		EQU	$
		PHB
		PHK
		PLB
;
		STZ	BGBFPT	       ;BG unit buffer pointer clear
		LDA	#0FFH		;corse data clear
		STA	>DTBUFF
		STA	SRCHPT	       ;search point clear
		STA	SRCHPT+1
		STA	INSTPT	       ;insert	    "
		STA	INSTPT+1
;
		LDA	#0FFH
		STA	>ENDTBF
		STA	>ENDTBF+1
;
		DEC	FADNO
		BPL	BEFD90
		STZ	MODENO
		LDA	ENBGFLG
		DEC	A
		AND	#00FH
		STA	ENBGFLG
		BEQ	BGENFD_100
		CMP	#002
		BNE	BGENFD_200
		STZ	!ENBGFLG
		M16			; memory 16bit mode
		PHB
		JSR	BACK_UP_CHK
		I16			; index 16bit mode
		LDA	<WORK0
		BEQ	BGENFD_050
		LDX	#DTBUFF_BAK
		LDY	#COURSEDT
		LDA	#01000H-1
		MVN	#BANK DTBUFF_BAK,#BANK COURSEDT
BGENFD_050	EQU	$
		PLB
		PHB
		LDA	<WORK2
		BEQ	BGENFD_080
		LDX	#ENMYDTBF_BAK
		LDY	#ENMYDTBF
		LDA	#01000H-1
		MVN	#BANK ENMYDTBF_BAK,#BANK ENMYDTBF
		PLB
		LDA	>ENMYDTBF
		STA	!ENDTPT
BGENFD_080	EQU	$
		MI8			; memory , index 8bit mode
;
		LDA	#ENITSB
		STA	!MODENO
;
BGENFD_100	EQU	$
		JSR	ENAME_SET
BGENFD_200	EQU	$
		M16			; memory 16bit mode
		LDA	#00070H
		STA	CRXPSL1
		STA	CRXPSL2
		LDA	#00770H
		STA	CRYPSL1
		STA	CRYPSL2
		STZ	<SCCH1
		STZ	<SCCH2
		STZ	<SCCH3
		LDA	#00730H
		STA	<SCCV1
		STA	<SCCV2
		STA	<SCCV3
		M8			; memory 8bit mode
;
BEFD90		EQU	$
		PLB
		RTL
;
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+							+
;+	G̖O  IuWF^Cv f[^̓ǂݍ	+
;+							+
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
ENAME_DATA	EQU	$
		HEX	59,53,5F,45,4E,41,4D,45,45,54,42 ; YS_ENAME
		HEX	54,45,53,54,4F,42,4A,20,4F,4A,44 ; TESTOBJ
;
ENAME_DATA_IDX	EQU	$
		HEX	008,007
;
ENAME_SIZE	EQU	$
		WORD	00A00H,00300H
;
;
ENAME_SET	EQU	$
		DOS	_DOSRST		; SFX-DOS start !!
;
		LDA	#001
		DOS	_SELDSK
		LDA	#002
		DOS	_DSKRST
;
		LDX	#000
ENAME_100	EQU	$
		LDA	ENAME_DATA+00,X
		STA	1EE0H,X
		INX
		CPX	#(ENAME_DATA_IDX-ENAME_DATA)/2
		BCC	ENAME_100
;
		M16			; memory 16bit mode
		LDA	ENAME_SIZE+0
		STA	1EF4H
		LDA	#ENNAMBF
		STA	1EF0H
		M8			; memory 8bit mode
		LDA	#BANK ENNAMBF
		STA	1EF2H
;
		DOS	_LOAD
;
		TAX
		BNE	ENAME_200
ENAME_150	EQU	$
		LDA	ENAME_DATA+00,X
		STA	!MOJBF2,X
		INX
		CPX	#((ENAME_DATA_IDX-ENAME_DATA)/2)-3
		BCC	ENAME_150
		LDA	ENAME_DATA_IDX
		STA	!MJIDX2
		LDA	1EF8H
		STA	4204H
		LDA	1EF9H
		STA	4205H
		LDA	#005H
		STA	4206H
		NOP
		NOP
		NOP
		NOP
		NOP
		NOP
		NOP
		NOP
		LDA	4214H
		STA	!ENNAMCT
		STA	>ENNAMCT_SB
		LDA	4215H
		STA	!ENNAMCT+1
		STA	>ENNAMCT_SB+1
;
ENAME_200	EQU	$
		LDX	#000
ENAME_250	EQU	$
		LDA	ENAME_DATA+11,X
		STA	1EE0H,X
		INX
		CPX	#(ENAME_DATA_IDX-ENAME_DATA)/2
		BCC	ENAME_250
;
		M16			; memory 16bit mode
		LDA	ENAME_SIZE+2
		STA	1EF4H
		LDA	#CHRDTBF
		STA	1EF0H
		M8			; memory 8bit mode
		LDA	#BANK CHRDTBF
		STA	1EF2H
;
		DOS	_LOAD
;
		TAX
		BNE	ENAME_300
ENAME_280	EQU	$
		LDA	ENAME_DATA+11,X
		STA	!MOJBF3,X
		INX
		CPX	#((ENAME_DATA_IDX-ENAME_DATA)/2)-3
		BCC	ENAME_280
		LDA	ENAME_DATA_IDX+1
		STA	!MJIDX3
;
ENAME_300	EQU	$
		RTS
;
;
UN_ENAME_SET	EQU	$
		PHB
		PHK
		PLB
		JSR	ENAME_SET
		PLB
		RTL
;
;
		MEM8
		IDX8
;
;
;
;
		END
