;************************************************************************
;*									*
;*	title name	: "yossy"					*
;*	proccess	: system main					*
;*	file name	: ys_main					*
;*									*
;************************************************************************
;
;
		SALL
;
		include		yst_header.inc
;
		XALL
;
;
;------------------------------------------------------------------------
;-		global symbol						-
;------------------------------------------------------------------------
		GLB	BLNKON,BLNKOFF,BLNKOF2,DMA_M_M,DMA_D_M,RAMCLR,URAMCLR,VRAMCL
		GLB	VRAMCL2,OAMCLR,OAMCLR2,OAMDXCLR,OAMCHG
		GLB	JSRSUB,JSLSUB,JSRSUBL,RANDAM
		GLB	KYREAD,FADEST
		GLB	SOUND_3_ON
;
		GLB	VCLDAT
;
;------------------------------------------------------------------------
;-		extern symbol						-
;------------------------------------------------------------------------
;
;-------------< SFX-DOS >------------------------------------------------
		EXT	NMI_Entry,IRQ_Entry
;
;-------------< ys_rpro >------------------------------------------------
		EXT	RPRO_ROM
		EXT	NMISUB,IRQSUB,CHIPON
		EXT	VMADSPL,OBJDMA
;
		EXT	VTCL
;
;-------------< ys_init >------------------------------------------------
		EXT	VOICEST
;
;-------------< ys_game >------------------------------------------------
		EXT	GMINIT,GMPLAY
;
;=============================================== (bged_init) =============
		EXT	BGWTPL,ENWTPL,ENBGSLC
;
;------------------------------------------------------------------------
;-		define symbol						-
;------------------------------------------------------------------------
;;;;		EQU
;
;
;
;************************************************************************
;*									*
;*		interrupt vector					*
;*									*
;************************************************************************
;
		ORG	0DFF6H
;
		WORD	RTISUB		;break
		WORD	RTISUB		;abort
		WORD	00108H		;NMI
		WORD	RESET		;reset
		WORD	0010CH		;IRQ
;
;
;************************************************************************
;*									*
;*		program start						*
;*									*
;************************************************************************
;
;
		EXTEND
;
;
		MEM8
		IDX8
;
Group_0		GROUP	Main_pro
Main_pro	SECT	REL
;
;************************************************************************
;*		reset							*
;************************************************************************
;
RESET		EQU	$
		DOS	_DOSSTP		;sfx-dos stop !!
;
		STZ	420CH		;H-DMA "OFF"
;
		LDA	#00000001B	;B-RAM enable
		STA	3033H
		STZ	2106H		;mozaiku flag reset
		STZ	2140H		;sound port reset
		STZ	2141H		;	"
		STZ	2142H		;	"
		STZ	2143H		;	"
;
		LDA	#0FFH		;I/O port reset
		STA	4201H
		STZ	4207H		;H counter reset
		STZ	4208H
		STZ	4209H		;V	"
		STZ	420AH
		STZ	420BH		;M-DMA switch reset
		STZ	420CH		;H-	  "
		STZ	420DH		;memory access cycle reset (2.68MHz)
;
		M16
;
		LDA	#8000H		;OAM rotation reset
		STA	2102H
;
;-------------- RAM vecter set ------------------------------------------
		LDX	#(RMVCTTBLE-RMVCTTBL)-1
RESET010	EQU	$
		LDA	!RMVCTTBL,X
		STA	RAMVCT,X
		DEX
		DEX
		BPL	RESET010
;
;-------------- RAM program set -----------------------------------------
		LDA	#RPRO_RAM	;to memory address set
		STA	<WORK20
		LDY	#BANK RPRO_RAM
		STY	<WORK22
		LDA	#RPRO_ROM	;from memory address set
		STA	<WORK23
		LDY	#BANK RPRO_ROM
		STY	<WORK25
		LDA	#4000H		;(A) <-- number of byte set
		JSL	>DMA_M_M	;DMA "ON"
;
		MI8
;
;-------------- system RAM initial clear --------------------------------
		LDX	#SAVECK0-SYSRAM-1
RESET020	EQU	$
		STZ	SYSRAM,X
		DEX
		BPL	RESET020
;
		LDA	#00000001B	;M-chip 21MHz mode set
		STA	3039H
		LDA	#10100000B	;chip config set ( IRQ disable , mult speed up )
		STA	3037H
		LDA	#016H		;chip screen base initial set
		STA	CIPSCB
		LDA	#00111101B	;     "      size mode set
		STA	CIPSCR
;
		JSL	>RAMCLR		;all RAM clear !!
;
;-------------- save RAM check ------------------------------------------
		LDA	SAVECK0
		CMP	#35H
		BNE	RESET030	;check sum ok ? ( no:RESET030 )
		LDA	SAVECK1
		CMP	#53H
		BEQ	RESET040_00	;	"       ( yes:RESET050 )
;;;;K;;;;		BEQ	RESET050	;	"       ( yes:RESET050 )
;
;-------------- status data initial clear !! --------------------
RESET030	EQU	$
		LDX	#SAVERMN-1
RESET040	EQU	$
		STZ	SAVERM,X
		DEX
		BPL	RESET040
;
		PHB
		LDA	#BANK DTBUFF_BAK
		PHA
		PLB
		MI16			; memory , index 16bit mode
		LDX	#01000H-2
RESET045	EQU	$
		STZ	!DTBUFF_BAK,X
		STZ	!ENMYDTBF_BAK,X
		DEX
		DEX
		BPL	RESET045
		MI8			; memory , index 8bit mode
		PLB
;
		LDA	#35H
		STA	SAVECK0
		LDA	#53H
		STA	SAVECK1
;
;
;-------------- nai^Cv f[^obt@ NA ------------
RESET040_00	EQU	$
		M16			; memory 16bit mode
		PHB
		LDX	#BANK CHRDTBF
		PHX
		PLB
		LDX	#000H
INIT0045	EQU	$
		STZ	!CHRDTBF+0000H,X
		STZ	!CHRDTBF+0100H,X
		STZ	!CHRDTBF+0200H,X
		DEX
		DEX
		BNE	INIT0045
		PLB
		M8			; memory 8bit mode
;
;-------------- snnkobt@@q`lNA ------------------
		LDA	#BANK TOOL_BUF
		STA	<WORK22
		M16			; memory 16bit mode
		LDY	#000
		LDA	#TOOL_BUF
		STA	<WORK20
		JSL	>DMA_D_M
;
;-------------- G̖O̕\pobt@ NA -----------------
		PHB
		LDX	#BANK ENMDSPBUF
		PHX
		PLB
		I16			; index 16bit mode
		LDX	#00400H-2
		LDA	#02040H
INIT0048	EQU	$
		STA	!ENMDSPBUF+0000H,X
		STA	!ENMDSPBUF+0400H,X
		STA	!ENMDSPBUF+0800H,X
		STA	!ENMDSPBUF+0C00H,X
		STA	!ENMDSPBUF+1000H,X
		STA	!ENMDSPBUF+1400H,X
		STA	!ENMDSPBUF+1800H,X
		STA	!ENMDSPBUF+1C00H,X
		STA	!ENMDSPBUF+2000H,X
		STA	!ENMDSPBUF+2400H,X
		STA	!ENMDSPBUF+2800H,X
		STA	!ENMDSPBUF+2C00H,X
		DEX
		DEX
		BPL	INIT0048
		PLB
		MI8			; memory , index 8bit mode
;
;;;;K;;;;;-------------- tool reset initial set ----------------------------------
RESET050	EQU	$
;;;;K;;;;		STZ	BGBFPT	       ;BG unit buffer pointer clear
;;;;K;;;;;
;;;;K;;;;		LDA	#0FFH		;corse data clear
;;;;K;;;;		STA	>DTBUFF
;;;;K;;;;		STA	SRCHPT	       ;search point clear
;;;;K;;;;		STA	SRCHPT+1
;;;;K;;;;		STA	INSTPT	       ;insert	    "
;;;;K;;;;		STA	INSTPT+1
;
		LDA	#C_0		;BG type no. initial set
		STA	INPBUF
		STA	INPBUF+1
;
;------------------------------------------------------------------------
;-		game initial set					-
;------------------------------------------------------------------------
;
		MI16
;
		LDA	#0070H		;cursol pos set
		STA	CRXPSL1
		STA	CRXPSL2
		LDA	#0770H
		STA	CRYPSL1
		STA	CRYPSL2
;
		STZ	<SCCH1		;scroll counter set
		STZ	<SCCH2
		LDA	#0730H
		STA	<SCCV1
		STA	<SCCV2
;
		LDA	#0000
		LDX	#(200H*64)-2
INIT0000	EQU	$
		STA	>BGUNIT,X
		DEX
		DEX
		BPL	INIT0000
;
		MI8
;
;;;;K;;;;		LDA	#00
		LDA	#080H
		LDX	#16*8-1
INIT0010	EQU	$
		STA	!UNBUFAD,X
		DEX
		BPL	INIT0010
;
;-------------- enmy data set bg buffer initial set -------------
		PHB
		LDX	#BANK ENBGDTBF
		PHX
		PLB
		MI16			; memory , index 16bit mode
		LDX	#01000H-2
INIT0020	EQU	$
		STZ	!ENBGDTBF+00000H,X
		STZ	!ENBGDTBF+01000H,X
		STZ	!ENBGDTBF+02000H,X
		STZ	!ENBGDTBF+03000H,X
		STZ	!ENBGDTBF+04000H,X
		STZ	!ENBGDTBF+05000H,X
		STZ	!ENBGDTBF+06000H,X
		STZ	!ENBGDTBF+07000H,X
		DEX
		DEX
		BPL	INIT0020
		MI8			; memory , index 8bit mode
		PLB
;
;;;;K;;;;		LDA	#0FFH
;;;;K;;;;		STA	>ENDTBF
;;;;K;;;;		STA	>ENDTBF+1
;
;-------------- interrupt enable ----------------------------------------
;
		M16
;
		LDA	#00999
		STA	!T_TIMER
;
		LDX	#BANK CHIPINIT
		LDA	#CHIPINIT
		JSL	>CHIPON
;
		M8
;
		CLI			;IRQ enable
;
;************************************************************************
;*		game main (tool select)					*
;************************************************************************
;
GSTART		EQU	$
		LDA	!NMIFLG
		BMI	GSTART
;
		M16
;
		INC	<FRCNT		;frame counter set
;
		M8
;
		INC	<FRCNT		 ; frame count+1
;
		JSL	>OAMCLR2	 ; OAM clear
;
		JSL	>ENBGSLC	; main program
;
		DEC	!NMIFLG	       ; NMI flag clear!!
;
		LDA	!ENBGFLG
		BMI	GSTART
		CMP	#002H
		BEQ	GST100
;
;************************************************************************
;*		game main (enemy data tool)				*
;************************************************************************
;
GST050		EQU	$
		LDA	!NMIFLG
		BMI	GST050
;
		M16
;
		INC	<FRCNT		;frame counter set
;
		M8
;
		JSL	>ENWTPL		; main program
;
		DEC	!NMIFLG	       ; NMI flag clear!!
		LDA	!ENBGFLG
		BEQ	GST050
;
;************************************************************************
;*		game main (BG data tool)				*
;************************************************************************
;
GST100		EQU	$
		LDA	!NMIFLG
		BMI	GST100
;
		M16
;
		INC	<FRCNT		;frame counter set
;
		M8
;
		JSL	>BGWTPL		; main program
;
;;;;;;;;		JSR	OAMCHG		; OAM sub. set
;
		DEC	!NMIFLG	       ; NMI flag clear!!
		LDA	!ENBGFLG
		BEQ	GST050
		BRA	GST100
;
;;
;************************************************************************
;		RAM vecter data						*
;************************************************************************
RMVCTTBL	EQU	$
		RTI			;[100]
		NOP
		NOP
		NOP
;
		RTI			;[104] COP
		NOP
		NOP
		NOP
;
		JMP	>NMISUB		;[108] NMI
;
		JMP	>IRQSUB		;[10C] IRQ
;
;
		JMP	>NMI_Entry	;[110] SFX-DOS NMI
;
		JMP	>IRQ_Entry	;[114] SFX-DOS IRQ
;
RMVCTTBLE	EQU	$
;
;************************************************************************
;		interrapt return					*
;************************************************************************
RTISUB		EQU	$
		RTI
;
;
;************************************************************************
;*		blanking "ON"						*
;************************************************************************
BLNKON		EQU	$
		SEI			;IRQ disable
		STZ	4200H		;NMI disable
		STZ	1E00H
		STZ	420CH		;H-DMA "OFF"
		LDA	#10000000B	;blanking "ON"
		STA	2100H
		RTL
;
;************************************************************************
;*		blanking "OFF"						*
;************************************************************************
BLNKOF2		EQU	$
		LDA	#0FH
		STA	FADNO
;
BLNKOFF		EQU	$
		LDA	#10000001B	;NMI enable
		STA	4200H
		STA	1E00H
		CLI			;IRQ enable
		RTL
;
;************************************************************************
;*		OAM clear						*
;************************************************************************
OAMCLR		EQU	$
;
		M16
;
		LDX	#BANK OAM_CLR
		LDA	#OAM_CLR
		JSL	>CHIPON
;
		M8
;
		RTL
;
;************************************************************************
;*		OAM clear				(OAMCLR)	*
;************************************************************************
OAMCLR2		EQU	$
		PHB			;(DBR) save
		LDA	#BANK OAM	;(DBR) <-- OAM(B)
		PHA
		PLB
;
		LDX	#060H
OCL020		EQU	$
		LDA	#0F0H		; Ypos
		STA	!OAM+001H,X
		STA	!OAM+005H,X
		STA	!OAM+009H,X
		STA	!OAM+00DH,X
		STA	!OAM+011H,X
		STA	!OAM+015H,X
		STA	!OAM+019H,X
		STA	!OAM+01DH,X
		STA	!OAM+081H,X
		STA	!OAM+085H,X
		STA	!OAM+089H,X
		STA	!OAM+08DH,X
		STA	!OAM+091H,X
		STA	!OAM+095H,X
		STA	!OAM+099H,X
		STA	!OAM+09DH,X
		STA	!OAM+101H,X
		STA	!OAM+105H,X
		STA	!OAM+109H,X
		STA	!OAM+10DH,X
		STA	!OAM+111H,X
		STA	!OAM+115H,X
		STA	!OAM+119H,X
		STA	!OAM+11DH,X
		STA	!OAM+181H,X
		STA	!OAM+185H,X
		STA	!OAM+189H,X
		STA	!OAM+18DH,X
		STA	!OAM+191H,X
		STA	!OAM+195H,X
		STA	!OAM+199H,X
		STA	!OAM+19DH,X
		TXA
		SEC
		SBC	#020H
		TAX
		BPL	OCL020		; oam clear end ?
;
		M16
;
		LDX	#20H-2
OCL030		EQU	$
		STZ	OAMSUB,X
		DEX
		DEX
		BPL	OCL030
;
		M8
;
		PLB			  ; yes
		RTL
;
;************************************************************************
;*		OAM clear ( to game mode )				*
;************************************************************************
OAMDXCLR	EQU	$
;
		M16
;
		LDX	#BANK OAM_DXCLR
		LDA	#OAM_DXCLR
		JSL	>CHIPON
;
		M8
;
		RTL
;
;************************************************************************
;*		OAM convert & change					*
;************************************************************************
OAMCHG		EQU	$
;
		M16
;
		LDX	#BANK OAMCHG2
		LDA	#OAMCHG2
		JSL	>CHIPON
;
		M8
;
		RTL
;
;************************************************************************
;*		VRAM clear						*
;*			in  : (A) <-- VRAM clear data table pointer	*
;************************************************************************
NUK		EQU	0020H
VCLDAT		EQU	$
		WORD	6800H,4000H+800H-1
		WORD	NUK
		WORD	3800H,4000H+800H-1
		WORD	00482H
		WORD	3400H,4000H+1000H-1
		WORD	NUK
		WORD	0FFFFH
;
VRAMCL		EQU	$
		LDA	#VTCL
VRAMCL2		EQU	$
		STA	VRFLG		;VRAM clear data table pointer
;
		JSL	>BLNKON
;
;-------------- OAM intial --------------------------------------
		JSL	>OAMCLR2	 ;OAM clear
;
;-------------- VRAM clear --------------------------------------
		JMP	>VMADSPL
;
;************************************************************************
;*		memory DMA ( block transfer )				*
;*			in  : (WK20,21,22) <-- to memory address	*
;*			      (WK23,24,25) <-- from	 "              *
;*			      (A)	   <-- number of byte		*
;************************************************************************
;
		MEM16
		IDX8
;
DMA_M_M		EQU	$
		STA	4305H		;number of byte set
;
		LDA	<WORK20		;to memory address set
		STA	2181H		;	  "
		LDY	<WORK22
		STY	2183H
;
		LDA	#00000000B+(080H*100H)	;DMA parameter & B bus address set
		STA	4300H
		LDA	<WORK23		;A bus address set
		STA	4302H
		LDY	<WORK25
		STY	4304H
;
		LDY	#00000001B	;DMA "ON"
		STY	420BH
		RTL
;
;************************************************************************
;*		memory DMA ( 1 byte data fill )				*
;*			in  : (WK20,21,22) <-- to memory address	*
;*			      (A)	   <-- number of byte		*
;*			      (Y)	   <-- fill 1 byte data		*
;************************************************************************
;
		MEM16
		IDX8
;
DMA_D_M		EQU	$
		STA	4305H		;number of byte set
;
		STY	211BH
		LDX	#00
		STX	211BH
		INX			;x1
		STX	211CH
;
		LDA	#10000000B+(034H*100H)	;DMA parameter & B bus address set
		STA	4300H
		LDA	<WORK20		;A bus address set
		STA	4302H
		LDX	<WORK22
		STX	4304H
;
		LDX	#00000001B	;DMA "ON"
		STX	420BH
		RTL
;
		MEM8
;
;************************************************************************
;*		RAM clear						*
;************************************************************************
RAMCLR		EQU	$
		JSL	>BLNKON		;blanking "ON"
;
		M16
;
		LDY	#00			;(Y) <-- 0 clear data
;
;-------------< 000H - 0FFH >--------------------------------------------
		STZ	<WORK20			;to memory address set
		STZ	<WORK22
		LDA	#(0FFH-000H)+1		;(A) <-- number of byte
		JSL	>DMA_D_M		;DMA "ON"
;
;-------------< 0200H - 1DFFH >--------------------------------------
		LDA	#0200H			;to memory address set
		STA	<WORK20
		LDA	#(1DFFH-0200H)+1	;(A) <-- number of data
		JSL	>DMA_D_M		;DMA "ON"
;
;-------------< 7E4000H - 7EBFFFH >--------------------------------------
		LDA	#4000H			;to memory address set
		STA	<WORK20
		LDX	#07EH
		STX	<WORK22
		LDA	#(7EBFFFH-7E4000H)+1	;(A) <-- number of data
		JSL	>DMA_D_M		;DMA "ON"
;
;-------------< 7F0000H - 7FFFFFH >--------------------------------------
		STZ	<WORK20			;to memory address set
		LDX	#07FH
		STX	<WORK22
		LDA	#(7FFFFFH-7F0000H)+1	;(A) <-- number of data
		JSL	>DMA_D_M		;DMA "ON"
;
;-------------< 700000H - 7077FFH >--------------------------------------
		LDX	#070H			;to memory address set
		STX	<WORK22
		LDA	#(7077FFH-700000H)+1	;(A) <-- number of data
		JSL	>DMA_D_M		;DMA "ON"
;
;-------------< initial RAM set >----------------------------------------
		LDA	#0FFFFH		;BG write( VRAMD ) end code set
		STA	>VRAMD+2
		LDA	#VRAMDX+2	;    "   ( VRAMDX )      "
		STA	>VRAMDX
;
		M8
;
		RTL
;
;************************************************************************
;*		clear area RAM clear					*
;************************************************************************
URAMCLR		EQU	$
;
		M16
;
		LDY	#00		;(Y) <-- 0 clear data
;
;-------------- SFC ---------------------------------------------
		STZ	<WORK21		;to memory address set
		LDA	#CLRRM0_S
		STA	<WORK20
		LDA	#CLR0SE		;(A) <-- number of byte
		JSL	>DMA_D_M	;DMA "ON"
;
		LDA	#CLRRM1_S
		STA	<WORK20
		LDA	#CLR1SE		;(A) <-- number of byte
		JSL	>DMA_D_M	;DMA "ON"
;
;-------------- M-chip ------------------------------------------
		LDA	#MCLRRM0_S
		STA	<WORK20
		LDA	#MCLR0SE	;(A) <-- number of byte
		JSL	>DMA_D_M	;DMA "ON"
;
		LDA	#MCLRRM1_S
		STA	<WORK20
		LDA	#MCLR1SE	;(A) <-- number of byte
		JSL	>DMA_D_M	;DMA "ON"
;
		LDA	#MCLRRM2_S
		STA	<WORK20
		LDX	#BANK MCLRRM2_S
		STX	<WORK22
		LDA	#MCLR2SE	;(A) <-- number of byte
		JSL	>DMA_D_M	;DMA "ON"
;
		M8
;
		RTL
;
;************************************************************************
;*		call subroutine						*
;*			in  : (A) <- call no.				*
;************************************************************************
;
JSRSUB		EQU	$
		STY	<WORK+3		;(Y) save
;
		PLY
		STY	<WORK
;
		MI16
;
		AND	#00FFH
		ASL	A
		TAY
		PLA
		STA	<WORK+1
;
		INY
		LDA	[<WORK],Y
		STA	<WORK
;
		MI8
;
		LDY	<WORK+3		;(Y) load
		JML	(WORK)
;
;************************************************************************
;*		call subroutine ( long )				*
;*			in  : (A) <- call no.				*
;************************************************************************
;
JSLSUB		EQU	$
		STY	<WORK+5		;(Y) save
;
		PLY
		STY	<WORK+2
;
		MI16
;
		AND	#00FFH
		STA	<WORK+3
		ASL	A
		ADC	<WORK+3
		TAY
		PLA
		STA	<WORK+3
;
		INY
		LDA	[<WORK+2],Y
		STA	<WORK
		INY
		LDA	[<WORK+2],Y
		STA	<WORK+1
		XBA
;
		MI8
;
		PHB			;(DBR) save
;;;;		LDA	<WORK+2		;(DBR) <-- (PBR)
		PHA
		PLB
		LDY	<WORK+5		;(Y) load
		JML	(WORK)
;
;************************************************************************
;*		Long Subroutine index call		(JSRSUBL)	*
;************************************************************************
JSRSUBL		EQU	$
		STY	<WORK5		; (Y) push
;
		PLY
		STY	<WORK2
;
		MEM16
		IDX16
		REP	#00110000B	; memory,index 16bit mode
;
		AND	#000FFH
		STA	<WORK3		; A*3
		ASL	A
		ADC	<WORK3
		TAY
		PLA
		STA	<WORK3
;
		INY
		LDA	[<WORK2],Y
		STA	<WORK0
;
		INY
		LDA	[<WORK2],Y
		STA	<WORK1
;
		MEM8
		IDX8
		SEP	#00110000B	; memory,index 8bit mode
;
		LDY	<WORK5		; (Y) pull
		JML	(!WORK0)
;
;************************************************************************
;*		fade in/out						*
;************************************************************************
FADADD		EQU	$
		HEX	01,FF
FADCMP		EQU	$
		HEX	0F,00
;
FADEST		EQU	$
		LDX	FADMK
		LDA	FADNO
		CLC
		ADC	>FADADD,X
		STA	FADNO
		CMP	>FADCMP,X
		BNE	FAD010		;fade end ? ( no:FAD010 )
;
		TXA			;fade muki set
		EOR	#01H
		STA	FADMK
;
;-------------- go to next mode ---------------------------------
		INC	MODENO
;
FAD010		EQU	$
		RTL
;
;************************************************************************
;*		fade in/out ( timer type )				*
;************************************************************************
;
FADEST2		EQU	$
		DEC	FADTM
		BPL	FAD010		;wait ? ( yes:FAD010 )
;
		LDA	#02H		;wait timer set
		STA	FADTM
		BRA	FADEST
;
;************************************************************************
;*								*
;*			߂l	 i`jF				*
;************************************************************************
;
RANDAM		EQU	$
		PHP
;
		M8
;
		LDA	2137H
		LDA	213FH
;
		M16
;
		LDA	213CH
		CLC
		ADC	RANDM0
		STA	RANDM0
;
		PLP
		RTL
;
;
;
;
;
; <<<<<	 key input data table  >>>>>
ASKYBD1		EQU	$
;			  0   1	  2   3	  4   5	  6   7	  8   9	  A   B	  C   D	  E   F
		BYTE	NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,RTN,NUL,NUL ; 0
		BYTE	NUL,NUL,NUL,UPS,DWS,NUL,NUL,NUL,NUL,NUL,NUL,ESC,NUL,NUL,NUL,NUL ; 1
		BYTE	SPS,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL ; 2
		BYTE	SU0,SU1,SU2,SU3,SU4,SU5,SU6,SU7,SU8,SU9,NUL,NUL,NUL,NUL,NUL,NUL ; 3
		BYTE	NUL,L_A,L_B,L_C,L_D,L_E,L_F,L_G,L_H,L_I,L_J,L_K,L_L,L_M,L_N,L_O ; 4
		BYTE	L_P,L_Q,L_R,L_S,L_T,L_U,L_V,L_W,L_X,L_Y,L_Z,NUL,NUL,NUL,NUL,NUL ; 5
		BYTE	NUL,L_A,L_B,L_C,L_D,L_E,L_F,L_G,L_H,L_I,L_J,L_K,L_L,L_M,L_N,L_O ; 6
		BYTE	L_P,L_Q,L_R,L_S,L_T,L_U,L_V,L_W,L_X,L_Y,L_Z,NUL,NUL,NUL,NUL,NUL ; 7
		BYTE	NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL ; 8
		BYTE	NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL ; 9
		BYTE	NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL ; A
		BYTE	NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL ; B
		BYTE	NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL ; C
		BYTE	NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL ; D
		BYTE	NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL ; E
		BYTE	F_1,F_2,F_3,F_4,F_5,F_6,F_7,F_8,F_9,F_0,NUL,NUL,NUL,NUL,NUL,NUL ; F
;
ASKYBD2		EQU	$
;			  0   1	  2   3	  4   5	  6   7	  8   9	  A   B	  C   D	  E   F
		BYTE	NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,TAB,NUL,NUL,NUL,RTN,NUL,NUL ; 0
		BYTE	NUL,NUL,NUL,UPS,DWS,NUL,NUL,NUL,NUL,NUL,NUL,NUL,RIT,LEF,UPP,DWN ; 1
		BYTE	SPS,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL ; 2
		BYTE	NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL ; 3
		BYTE	NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL ; 4
		BYTE	NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL ; 5
		BYTE	NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL ; 6
		BYTE	NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL ; 7
		BYTE	NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL ; 8
		BYTE	NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL ; 9
		BYTE	NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL ; A
		BYTE	NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL ; B
		BYTE	NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL ; C
		BYTE	NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL ; D
		BYTE	NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL ; E
		BYTE	F_1,F_2,F_3,F_4,F_5,F_6,F_7,F_8,F_9,F_0,NUL,NUL,NUL,NUL,NUL,NUL ; F
;
ASKYBD3		EQU	$
;			  0   1	  2   3	  4   5	  6   7	  8   9	  A   B	  C   D	  E   F
		BYTE	NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,RTN,NUL,NUL ; 0
		BYTE	NUL,NUL,NUL,UPS,DWS,NUL,NUL,NUL,NUL,NUL,NUL,ESC,NUL,NUL,NUL,NUL ; 1
		BYTE	SPS,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,L_c,L_h,L_p,L_s ; 2
		BYTE	SU0,SU1,SU2,SU3,SU4,SU5,SU6,SU7,SU8,SU9,NUL,NUL,NUL,L_e,NUL,NUL ; 3
		BYTE	NUL,L_A,L_B,L_C,L_D,L_E,L_F,L_G,L_H,L_I,L_J,L_K,L_L,L_M,L_N,L_O ; 4
		BYTE	L_P,L_Q,L_R,L_S,L_T,L_U,L_V,L_W,L_X,L_Y,L_Z,NUL,NUL,NUL,NUL,L_u ; 5
		BYTE	NUL,L_A,L_B,L_C,L_D,L_E,L_F,L_G,L_H,L_I,L_J,L_K,L_L,L_M,L_N,L_O ; 6
		BYTE	L_P,L_Q,L_R,L_S,L_T,L_U,L_V,L_W,L_X,L_Y,L_Z,NUL,NUL,NUL,NUL,NUL ; 7
		BYTE	NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL ; 8
		BYTE	NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL ; 9
		BYTE	NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL ; A
		BYTE	NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL ; B
		BYTE	NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL ; C
		BYTE	NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL ; D
		BYTE	NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL ; E
		BYTE	F_1,F_2,F_3,F_4,F_5,F_6,F_7,F_8,F_9,F_0,NUL,NUL,NUL,NUL,NUL,NUL ; F
;
;;;;;;;
;
;
;
;***********************************************************
;*							   *
;*	 key input data pop				   *
;*							   *
;***********************************************************
;
		MEM8
		IDX8
;
KYREAD		EQU	$
		LDA	#NUL
		STA	INKEY
		STA	INKEY2
		STA	INKEY3	       ; key [NUL] set
;
		DOS	_CONSNS
		CMP	#000H
		BEQ	KYRD080		; Key-board key on ?
;					; yes
		DOS	_CONIN		; Key-board key-check
		TAX
		LDA	ASKYBD1,X
		STA	INKEY
;
		LDA	ASKYBD2,X
		STA	INKEY2
;
		LDA	ASKYBD3,X
		STA	INKEY3
KYRD080		EQU	$
		RTL
;
;************************************************************************
;*		TEhZbg_~[					*
;************************************************************************
SOUND_3_ON	EQU	$
		RTL
;
;
;
;
;
		END
