;************************************************************************
;*									*
;*	title name	: "yossy"					*
;*	proccess	: RAM program					*
;*	file name	: ys_rpro					*
;*									*
;************************************************************************
;
;
		SALL
;
		include		yst_header.inc
		include		../../../JPN/sfc/ys_unit.h
;
		XALL
;
;
;------------------------------------------------------------------------
;-		global symbol						-
;------------------------------------------------------------------------
		GLB	RPRO_ROM
		GLB	IRQSUB,NMISUB,CHIPON,CHIPON1,CHIPON_RAM_READ
		GLB	CHIPON_SPECIAL,CHIPON_C
		GLB	BGSCWTL,VMADSPL,NEWVMADL,OBJDMA,BGCDMA_L
		GLB	SFC_BGCLR_4_L,BLUE_COIN_ST_SB
;
		GLB	VTCL,B3CL,WNCL,B3WRCL
;
;------------------------------------------------------------------------
;-		extern symbol						-
;------------------------------------------------------------------------
;
;-------------< ys_main >------------------------------------------------
		EXT	VCLDAT
		EXT	GMIN
;
;-------------< ys_rpro >------------------------------------------------
		EXT	COS,SIN
;
;-------------< ys_map >-------------------------------------------------
		EXT	MPROGOCLR
;
;-------------< ys_game >------------------------------------------------
		EXT	BG3SCRCLR,BG3WANCLR,BG3WTRCLR
		EXT	Pause_move
;
;-------------< ys_play >------------------------------------------------
		EXT	TIMEUP_SET_S,TONNEL_INOUT_IN
		EXT	PFLP,PFAL,PYGN
;
;-------------< ys_enmy >------------------------------------------------
		EXT	ENINSR
		EXT	EGGKILL,PL_1UP_SET,PLFLST_S
		EXT	EX_COIN_SET_2,EX_COIN_SET_3
		EXT	ENCLEAR_NORETN
;
		EXT	COIN1,COINR
;
;-------------< ys_enmy2 >------------------------------------------------
		EXT	COIN1_GET
;
;-------------< ys_enmy6 >------------------------------------------------
		EXT	FLOWER_GET
;
;-------------< ys_enmy9 >------------------------------------------------
		EXT	COINR_GET
;
;-------------< ys_exst >------------------------------------------------
		EXT	EXINSR
		EXT	FLKIR
;
;-------------< ys_bgsc >------------------------------------------------
		EXT	UNITCHG
		EXT	BGCG,BLK0,DWCG,TGTM,CNCL
;
;-------------< ys_unit >------------------------------------------------
		EXT	UNDATA
;
;------------------------------------------------------------------------
;-		define symbol						-
;------------------------------------------------------------------------
;;;;		EQU
;
;
;************************************************************************
;*									*
;*		program start						*
;*									*
;************************************************************************
;
;
		EXTEND
;
;
		MEM8
		IDX8
;
Group_R		GROUP	Ram_pro
Ram_pro		SECT	REL
;
;************************************************************************
;*		RAM program						*
;************************************************************************
RPRO_ROM	EQU	$
;
;
;************************************************************************
;*		NMI							*
;************************************************************************
;
NMISUB		EQU	$+7E0000H
		SEI
;
		MEM16
		IDX16
		REP	#00111000B
;
		PHA
		PHX
		PHY
		PHD
		PHB
		LDA	#00000H
		TCD
;
		MI8
;
		PHA			;(DBR) <-- 00H
		PLB
;
		LDY	4210H
;
		LDX	NMITYP
		JSR	(!NMISEL,X)
;
NMIRTI		EQU	$
;
		MI16
;
		PLB
		PLD
		PLY
		PLX
		PLA
;
		RTI
;
		MEM8
		IDX8
;
;-------------- NMI program address table -----------------------
NMISEL		EQU	$		;[NMITYP]
		WORD	NMI000		;[0]  normal
		WORD	NMI100		;[2]  game( normal )
		WORD	NMI200		;[4]  game( offset )
		WORD	RTSSUB		;[6]  map
		WORD	RTSSUB		;[8]  ~[WJ
		WORD	NMI500		;[A]  game( mode 7 )
;;
;
;************************************************************************
;*		NMI ( normal )						*
;************************************************************************
;
NMI000		EQU	$
		LDY	#10000000B	;blanking "ON"
		STY	2100H
		STZ	420CH		;H-DMA "OFF"
;
		LDA	NMIFLG
		BNE	NMI0010		;timer over ? ( no:NMI0010 )
		JMP	NMI0020
;
NMI0010		EQU	$
		STZ	NMIFLG		;NMI flag "ON"
;
;-------------- DMA set -----------------------------------------
		JSR	NEWVMAD		;BG write
		JSR	VMADSP		;BG WRITE
;
		M16
;
		PHD			;(D) save
		LDA	#4300H		;0 page set ( 4300H- )
		TCD
;
		LDX	#00000001B	;(X) <-- DMA "ON" flag
;
		JSR	OBJDMA		;OBJ DMA set
;;;;;;;;		JSR	COLDMA		;color DMA set
;
		LDY	#10000000B	;VRAM address inc mode set
		STY	2115H
		LDA	#00000001B+(18H*100H)	;DMA parameter set
		STA	<4300H
;
		JSR	BGSCWT		;BG scroll screen DMA
;
		M8
;
		PLD			;(D) load
;
;-------------- joy-controller read -----------------------------
		JSR	CONT22		 ;controller read
;
;-------------- PPU Reg. set ------------------------------------
		LDA	WIND23
		STA	2123H
		LDA	WIND24
		STA	2124H
		LDA	WIND25
		STA	2125H		; window on/off set
		LDA	WIND30
		STA	2130H		; color window on/off set
		LDA	SUBADF
		STA	2131H		; add.&sub. set
;
		LDA	NUKCOL		;[ red ]
		AND	#00011111B
		ORA	#00100000B
		STA	2132H
;
		MEM16
		REP	#00100000B
;
		LDA	NUKCOL	       ;[ green ]
		LSR	A
		LSR	A
;
		MEM8
		SEP	#00100000B
;
		LSR	A
		LSR	A
		LSR	A
		AND	#00011111B
		ORA	#01000000B
		STA	2132H
;
		LDA	NUKCOL+1       ;[ blue ]
		LSR	A
		LSR	A
		ORA	#10000000B
		STA	2132H
;
		LDA	MANSEL
		STA	212CH		; display select main
		LDA	SUBSEL
		STA	212DH		;		 sub
;
		LDA	WMANSL
		STA	212EH		; window display main
		LDA	WSUBSL
		STA	212FH		;		 sub
;
;-------------- scroll counter set ------------------------------
		LDA	<SCCH1		;work BG1 scroll counter set
		STA	210DH
		LDA	<SCCH1+1
		STA	210DH
		LDA	<SCCV1
		STA	210EH
		LDA	<SCCV1+1
		STA	210EH
		LDA	<SCCH2		;BG2 scroll counter set
		STA	210FH
		LDA	<SCCH2+1
		STA	210FH
		LDA	<SCCV2
		STA	2110H
		LDA	<SCCV2+1
		STA	2110H
		LDA	<SCCH3		;BG3 scroll counter set
		STA	2111H
		LDA	<SCCH3+1
		STA	2111H
		LDA	<SCCV3
		STA	2112H
		LDA	<SCCV3+1
		STA	2112H
		LDA	<SCCH4		;BG4 scroll counter set
		STA	2113H
		LDA	<SCCH4+1
		STA	2113H
		LDA	<SCCV4
		STA	2114H
		LDA	<SCCV4+1
		STA	2114H
;
NMI0020		EQU	$
		LDA	FADNO		;blanking "OFF"
		STA	2100H
		LDA	HD420C		;H-DMA set
		STA	420CH
		RTS
;
;************************************************************************
;*		NMI ( game( normal ) )					*
;************************************************************************
;
NMI100		EQU	$
		RTS
;
;************************************************************************
;*		NMI ( game( offset ) )					*
;************************************************************************
;
NMI200		EQU	$
		RTS
;
;************************************************************************
;*		NMI ( game( mode 7 ) )					*
;************************************************************************
;
NMI500		EQU	$
		RTS
;
;************************************************************************
;*		IRQ							*
;************************************************************************
IRQSUB		EQU	$+7E0000H
		SEI
;
		MEM16
		IDX16
		REP	#00111000B
;
		PHA
		PHX
		PHY
		PHD
		PHB
;
		LDA	#0000H
		TCD
;
		MI8
;
		PHA			;(DBR) <-- 00H
		PLB
;
		LDA	4211H
;
		LDX	IRQTYP
		JSR	(!IRQSEL,X)
;
RTISET		EQU	$
;
		MI16
;
		PLB
		PLD
		PLY
		PLX
		PLA
;
		CLI
		RTI
;
		MEM8
		IDX8
;
;-------------- IRQ program address table -----------------------
IRQSEL		EQU	$		;[IRQTYP]
		WORD	IRQ000		;[0] game
;
;
;************************************************************************
;*		IRQ ( game( initial ) )					*
;************************************************************************
;
IRQ000		EQU	$
		LDA	IRQFLG
		BNE	IRQ010		;H-DMA "ON" IRQ ? ( no:IRQ010 )
;
;-------------- H-DMA "ON" IRQ ------------------------------------------
		LDA	HD420C
		STA	420CH		;H-DMA "ON"
		STZ	2100H		;fade "OFF"
;
;-------------- blanking "OFF" IRQ timer set --------------------
		LDA	#050H		;H counter set
		STA	4207H
		LDA	#08H		;V counter set
IRQ022		EQU	$
		INC	IRQFLG
;
IRQ_TIMER_SET	EQU	$
		STA	4209H
		LDA	#10110001B	;timer IRQ "ON"
		STA	4200H
RTSSUB		EQU	$
		RTS
;
IRQ010		EQU	$
		DEC	A
		BNE	IRQ030		;blanking "OFF" IRQ ? ( no:IRQ030 )
;
;-------------- blanking "OFF" IRQ --------------------------------------
		LDA	FADNO		;fade in
		STA	2100H
;
;-------------- NMI-IRQ timer set -------------------------------
		LDA	#070H		;H counter set
		STA	4207H
		LDA	#0D8H		;V counter set
;
		LDX	NMI_PROG_NO
		BNE	IRQ012		;񏈗H ( yes:IRQ012 )
		JMP	IRQ022
;
IRQ012		EQU	$
		JSR	IRQ022
;
		JMP	(!NMI_PROG_SEL,X)
;
;------------------------------------------------------------------------
;-		NMI-IRQ							-
;------------------------------------------------------------------------
IRQ030		EQU	$
		LDY	#10000000B	;blanking "ON"
		STY	2100H
		STZ	420CH		;H-DMA "OFF"
;
		LDX	NMITYP
		JMP	(!IRQ_NMI_SEL,X)
;
;-------------- NMI program address table -----------------------
IRQ_NMI_SEL	EQU	$		;[NMITYP]
		WORD	RTSSUB		;[0]  normal ( dummy )
		WORD	IRQ_NMI_00	;[2]  game( normal )
		WORD	IRQ_NMI_01	;[4]  game( offset )
		WORD	RTSSUB		;[6]  map ( dummy )
		WORD	RTSSUB		;[8]  ~[WJ
		WORD	IRQ_NMI_05	;[A]  game( mode 7 )
;
;----------------------------------------------------------------
;-		game( normal )					-
;----------------------------------------------------------------
IRQ_NMI_00	EQU	$
		LDA	NMIFLG
		BNE	IRQ_NMI_0010	;time over ? ( no:IRQ_NMI_0010 )
;
;-------------- ԃI[o[II --------------------------------
		JMP	IRQ_NMI_TMOV
;
;-------------- ԃI[o[II ----------------------------
IRQ_NMI_0010	EQU	$
;
;-------------- BG1 scroll counter set --------------------------
;
		M16
;
		LDA	<SCCV1		;BG1 scroll counter_V set
		CLC
		ADC	TILTAL
;
IRQ_NMI_SUB	EQU	$
		STA	NMISCV1		;NMI set scroll counter_V set
		LDA	<SCCH1		;NMI set scroll counter_H set
IRQ_NMI_SUB_2	EQU	$
		STA	NMISCH1
;
		M8
;
		STA	210EH
		XBA
		STA	210EH
;
		STZ	NMIFLG		;NMI flag "ON"
;
;-------------- DMA set -----------------------------------------
		JSR	NEWVMAD		;BG write
		JSR	VMADSP		;BG WRITE
;
		M16
;
		PHD			;(D) save
		LDA	#4300H		;0 page set ( 4300H- )
		TCD
;
		LDX	#00000001B	;(X) <-- DMA "ON" flag
;
		JSR	MEMDMA		;memory DMA set
		JSR	OBJDMA		;OBJ DMA set
		JSR	COLDMA		;color DMA set
;
		LDY	#10000000B	;VRAM address inc mode set
		STY	2115H
		LDA	#00000001B+(18H*100H)	;DMA parameter set
		STA	<4300H
;
		LDY	GMPAUSE
		BEQ	IRQ_NMI_0030	;game pause ? ( no:IRQ_NMI_0030 )
;
;-------------- game pause DMA set ----------------------
		CPY	#Pause_move
		BCC	IRQ_NMI_0050	;pause chara DMA timming ? ( no:IRQ_NMI_0050 )
;
		JSR	PASDMA		;pause chara DMA set
		BRA	IRQ_NMI_0050
;
;-------------- game play DMA set -----------------------
IRQ_NMI_0030	EQU	$
		JSR	PCHDMA		;player chara DMA set
		JSR	BGCDMA		;BG chara DMA set
		JSR	OB7DMA		;OBJ mode 7 chara DMA set
		LDY	MSGTRF
		BEQ	IRQ_NMI_0040	;massage bitmap transfer ? ( no:IRQ_NMI_0040 )
;
		JSR	MSGDMA		;massage bitmap DMA set
		STZ	MSGTRF		;	"       transfer flag clear !!
IRQ_NMI_0040	EQU	$
		JSR	BGSCWT		;BG screen write
		JSR	SP_VRAM_ST
;
IRQ_NMI_0050	EQU	$
		PLD			;(D) load
;
;-------------- Of[VJ[XN[Zbg ------------
		LDY	!GRDTN_FLG	; XyV Of[V nm ?
		BNE	IRQ_NMI_0055	;	YES -> IRQ_NMI_0055
;
		LDY	NUKINO
		CPY	#10H
		BCC	IRQ_NMI_0060	;Of[VJ[XN[H ( no:IRQ_NMI_0060 )
;
IRQ_NMI_0055	EQU	$
		LDA	NUKCOL_SCRL_B
		STA	>HDMAPR2+1
		CLC
		ADC	#069H
		STA	>HDMAPR2+4
		LDA	NUKCOL_SCRL_RG
		STA	>HDMAPR1+1
		CLC
		ADC	#069H*2
		STA	>HDMAPR1+4
IRQ_NMI_0060	EQU	$
;
		M8
;
;-------------- scroll counter set ------------------------------
		LDA	NMISCH1		;BG1 scroll counter set
		STA	210DH
		LDA	NMISCH1+1
		STA	210DH
		LDA	NMISCV1
		STA	210EH
		LDA	NMISCV1+1
		STA	210EH
		LDA	<SCCH2		;BG2 scroll counter set
		STA	210FH
		LDA	<SCCH2+1
		STA	210FH
		LDA	<SCCV2
		STA	2110H
		LDA	<SCCV2+1
		STA	2110H
		LDA	<SCCH3		;BG3 scroll counter set
		STA	2111H
		LDA	<SCCH3+1
		STA	2111H
		LDA	<SCCV3
		STA	2112H
		LDA	<SCCV3+1
		STA	2112H
;
		LDA	!DSPMOD
		CMP	#00AH		; [hO ?
		BNE	MODE0_PASS
		LDA	<SCCH4
		STA	2113H
		LDA	<SCCH4+1
		STA	2113H
		LDA	<SCCV4
		STA	2114H
		LDA	<SCCV4+1
		STA	2114H
;
;-------------- joy-controller read -----------------------------
MODE0_PASS	EQU	$
		JSR	CONT2		;controller read
;
IRQ_NMI_ON	EQU	$
;
;-------------- PPU Reg. set ------------------------------------
		LDA	MANSEL		;main select set
		STA	212CH
		LDA	SUBSEL		;sub	  "
		STA	212DH
		LDA	WMANSL		;window main select set
		STA	212EH
		LDA	WSUBSL		;   "   sub     "
		STA	212FH
		LDA	BG12CH		;BG1,2 character base address set
		STA	210BH
		LDA	BG1SCF		;BG1 screen base address set
		STA	2107H
		LDA	BGMODE		;BG mode set
		STA	2105H
;
		LDA	WIND23		;window "ON/OFF" set
		STA	2123H
		LDA	WIND24
		STA	2124H
		LDA	WIND25
		STA	2125H
		LDA	WIND30		;color window "ON/OFF" set
		STA	2130H
		LDA	SUBADF		;main & sub add set
		STA	2131H
		LDA	BG2SCF		;BG2 screen base address set
		STA	2108H
		LDA	BG3SCF		;BG3	      "
		STA	2109H
		LDA	MOZNO		;mozaiku set
		STA	2106H
;
;-------------- H-DMA initial start set -------------------------
;
		M16
;
		LDA	#4300H
		TCD
;
		LDA	<4312H		 ;H-DMA start table address set
		STA	<4318H
		LDA	<4322H
		STA	<4328H
		LDA	<4332H
		STA	<4338H
		LDA	<4342H
		STA	<4348H
		LDA	<4352H
		STA	<4358H
		LDA	<4362H
		STA	<4368H
		LDA	<4372H
		STA	<4378H
;
		M8
;
		LDA	#01H		;start line counter set
		STA	<431AH
		STA	<432AH
		STA	<433AH
		STA	<434AH
		STA	<435AH
		STA	<436AH
		STA	<437AH
;
		STZ	IRQFLG
;
		LDA	#0C0H		;H counter set
		STA	4207H
		LDA	#006H		;V counter set
		JMP	IRQ_TIMER_SET
;
;----------------------------------------------------------------
;-		game( offset )					-
;----------------------------------------------------------------
IRQ_NMI_01	EQU	$
		LDA	NMIFLG
		BNE	IRQ_NMI_0110	;timer over ? ( no:IRQ_NMI_0110 )
;
;-------------- ԃI[o[II --------------------------------
		JMP	IRQ_NMI_TMOV
;
;-------------- ԃI[o[II ----------------------------
IRQ_NMI_0110	EQU	$
;
;-------------- offset data set ---------------------------------
		LDA	#10000000B
		STA	2115H		;VRAM address inc mode set
;
		M16
;
		LDA	#3600H		;VRAM address set ( offset )
		STA	2116H
		LDA	#00000001B+(18H*100H)
		STA	4300H		;DMA parameter & B bus address set
		LDA	#BG2OFF		;A bus address
		STA	4302H
		LDY	#BANK BG2OFF
		STY	4304H
		LDY	#080H		;number of byte
		STY	4305H
		LDX	#00000001B	;DMA "ON" !!
		STX	420BH
;
		LDA	#0080H		;offset data address( 7600H- )
		STA	<SCCV3
		STZ	<SCCH3
;
		LDA	BG2OFV		;BG1 scroll counter_V set
		JMP	IRQ_NMI_SUB
;
		MEM8
;
;----------------------------------------------------------------
;-		game( mode 7 )					-
;----------------------------------------------------------------
IRQ_NMI_05	EQU	$
		LDA	NMIFLG
		BNE	IRQ_NMI_0510	;timer over ? ( no:IRQ_NMI_0510 )
;
;-------------- ԃI[o[II --------------------------------
		JMP	IRQ_NMI_TMOV
;
;-------------- ԃI[o[II ----------------------------
IRQ_NMI_0510	EQU	$
;
;-------------- mode 7 parameter set ----------------------------
		LDA	M7SEL		;mode 7 initial set flag set
		STA	211AH
		LDA	M7A		;mode 7 matrix_A set
		STA	211BH
		LDA	M7A+1
		STA	211BH
		LDA	M7B		;mode 7 matrix_B set
		STA	211CH
		LDA	M7B+1
		STA	211CH
		LDA	M7C		;mode 7 matrix_C set
		STA	211DH
		LDA	M7C+1
		STA	211DH
		LDA	M7D		;mode 7 matrix_D set
		STA	211EH
		LDA	M7D+1
		STA	211EH
		LDA	M7X		;mode 7 center_X set
		STA	211FH
		LDA	M7X+1
		STA	211FH
		LDA	M7Y		;mode 7 center_Y set
		STA	2120H
		LDA	M7Y+1
		STA	2120H
;
;-------------- [hVafhnm^neehZbg --------------
		LDA	OBJ_BG_FG
		ORA	#00010000B
		STA	>HDMABUF2+1
		STA	>HDMABUF2+4
;
;-------------- BG1 scroll counter set --------------------------
;
		M16
;
		LDA	<SCCH1		;BG1 scroll counter_H set
		STA	<SCCH2
		LDA	<SCCV1		;BG1 scroll counter_V set
		CLC
		ADC	TILTAL
		STA	<SCCV2
;
		LDA	<SCCV3
		STA	NMISCV1
		LDA	<SCCH3
		JMP	IRQ_NMI_SUB_2
;
;--------------------------------------------------------
;-		ԃI[o[II			-
;--------------------------------------------------------
IRQ_NMI_TMOV	EQU	$
		LDA	NMI_PROG_NO
		BEQ	IRQ_NMI_TMOV_10 ;荞݃vOH ( no:IRQ_NMI_TMOV_10 )
;
		M16
;
		PHD			;(D) save
		LDA	#4300H		;0 page set ( 4300H- )
		TCD
		LDX	#00000001B	;(X) <-- DMA "ON" flag
;
		JSR	MEMDMA		;memory DMA set
		JSR	OBJDMA		;OBJ DMA set
		JSR	COLDMA		;color DMA set
;
		LDY	#10000000B	;VRAM address inc mode set
		STY	2115H
		LDA	#00000001B+(18H*100H)	;DMA parameter set
		STA	<4300H
;
;-------------- game play DMA set -----------------------
		JSR	PCHDMA		;player chara DMA set
		JSR	OB7DMA		;OBJ mode 7 chara DMA set
;
		PLD			;(D) load
;
		M8
;
;-------------- BG1 scroll counter set --------------------------
IRQ_NMI_TMOV_10 EQU	$
		LDA	NMISCH1
		STA	210DH
		LDA	NMISCH1+1
		STA	210DH
		LDA	NMISCV1
		STA	210EH
		LDA	NMISCV1+1
		STA	210EH
		JMP	IRQ_NMI_ON
;
;----------------------------------------------------------------
;-		vOe[u				-
;----------------------------------------------------------------
;
		MEM8
		IDX8
;
NMI_PROG_SEL	EQU	$		;[NMI_PROG_NO]
		WORD	NMI_PROG_00	;[0] 
		WORD	NMI_PROG_01	;[2] R[XC^Cgf
;
;--------------------------------------------------------
;-							-
;--------------------------------------------------------
NMI_PROG_00	EQU	$
		RTS
;
;--------------------------------------------------------
;-		R[XC^Cgf			-
;--------------------------------------------------------
NMI_PROG_01	EQU	$
		RTS
;
;************************************************************************
;*		M-chip start						*
;************************************************************************
;
		MEM16
		IDX8
;
CHIPON		EQU	$+7E0000H
		STZ	3030H		;LVZbg
CHIPON_C	EQU	$+7E0000H
		LDY	CIPSCB
		STY	3038H
		LDY	CIPSCR
		STY	303AH
		STX	3034H
		STA	R15
;
		LDA	#00100000B
CHIPON10	EQU	$
		BIT	3030H
		BNE	CHIPON10	;chip move ? ( yes:CHIPON10 )
;
		LDY	#00
		STY	303AH		;SFC ROM use enable
		RTL
;
;************************************************************************
;*		M-chip start ( game )					*
;************************************************************************
;
		MEM16
		IDX8
;
CHIPON1		EQU	$+7E0000H
		PHB			;(DBR) save
;
;;;;K;;;;		LDY	PLNAGP		;^}Sp[Zbg
;;;;K;;;;		STY	NAGE_POW
;
		STZ	3030H		;LVZbg
		LDY	CIPSCB
		STY	3038H
		LDY	CIPSCR
		STY	303AH
		STX	3034H
		STA	R15
;
		PHK			;(DBR) <-- (PBR)
		PLB
		JSR	METERST
;
		PLB
;
		LDA	#00100000B
CHIPON110	EQU	$
		BIT	3030H
		BNE	CHIPON110	;chip move ? ( yes:CHIPON110 )
;
		LDY	#00
		STY	303AH		;SFC ROM use enable
		RTL
;
;************************************************************************
;*		M-chip start ( SFC-RAM read type )			*
;************************************************************************
;
		MEM16
		IDX8
;
CHIPON_RAM_READ EQU	$+7E0000H
		STZ	3030H		;LVZbg
		LDY	CIPSCB
		STY	3038H
		LDY	CIPSCR
		STY	303AH
		STX	3034H
		STA	R15
;
CHIPON_RR_10	EQU	$
;
		I16
;
		LDA	#00100000B
		TAY
CHIPON_RR_20	EQU	$
		BIT	3030H
		BNE	CHIPON_RR_20	;chip move ? ( yes:CHIPON_RR_20 )
;
		LDX	R0
		BEQ	CHIPON_RR_30	;SFC-RAM read ? ( no:CHIPON_RR_30 )
;
		LDA	>7F0000H,X
		STA	R0		;(R0) <-- read RAM data
		LDA	R15
		STA	R15		;return to M-chip !!
		TYA
		BRA	CHIPON_RR_20
;
CHIPON_RR_30	EQU	$
		LDY	#00
		STY	303AH		;SFC ROM use enable
;
		I8
;
		RTL
;
;************************************************************************
;*		M-chip start ( special type )				*
;************************************************************************
;
		MEM16
		IDX8
;
CHIPON_SPECIAL	EQU	$+7E0000H
		STZ	3030H		;LVZbg
		LDY	CIPSCB
		STY	3038H
		LDY	CIPSCR
		STY	303AH
		STX	3034H
		STA	R15
;
		I16
;
		LDA	#00100000B
		TAY
CHIPON_SP_20	EQU	$
		BIT	3030H
		BNE	CHIPON_SP_20	;chip move ? ( yes:CHIPON_SP_20 )
;
		LDX	R0
		BPL	CHIPON_SP_30	;RAM read ? ( no:CHIPON_SP_30 )
;
		LDA	>7F0000H,X
		STA	R0		;(R0) <-- read RAM data
		LDA	R15
		STA	R15		;return to M-chip !!
		TYA
		BRA	CHIPON_SP_20
;
CHIPON_SP_30	EQU	$
		BEQ	CHIPON_SP_40	;M-chip END ? ( yes:CHIPON_SP_40 )
;
		STZ	303AH		;SFC ROM use enable
;
		JSR	(!SPMODE_SUB-2,X)
;
		M8
;
		LDA	CIPSCR
		STA	303AH
;
		M16
;
		LDA	R15
		STA	R15		;return to M-chip !!
		TYA
		BRA	CHIPON_SP_20
;
CHIPON_SP_40	EQU	$
		LDY	#00
		STY	303AH		;SFC ROM use enable
;
		I8
;
		RTL
;
;------------------------------------------------------------------------
;-		XyV[h[`e[u			-
;------------------------------------------------------------------------
;
		MEM16
		IDX16
;
SPMODE_SUB	EQU	$		;[X]
		WORD	SFC_COIN	;[02] RC
		WORD	SFC_EATBLK	;[04] Hׂaf
		WORD	SFC_KUI		;[06] Ył݂af
		WORD	SFC_EGG_KILL	;[08] ^}SIvV
		WORD	SFC_BGCLR	;[0A] ʂaf
		WORD	SFC_BGCLR_4	;[0C] ʂafiSjbgj
		WORD	SFC_BGCHNG	;[0E] w胆jbgaf
		WORD	SFC_TNIO_IN	;[10] glhm^ntsfX^[gZbg
		WORD	SFC_PLDOWNST	;[12] vC[_EZbg
		WORD	SFC_PLFAILST	;[14] vC[_[WZbg
		WORD	SFC_GOTO_1W_1	;[16] Pv|PփZbg
		WORD	SFC_TOGEBLK	;[18] gQubNaf
		WORD	SFC_YOGAN_IN	;[1A] vC[n◎
		WORD	SFC_POINT_GET	;[1C] IuWFRCAY[t[
;
;----------------------------------------------------------------
;-		Pv|PփZbg				-
;----------------------------------------------------------------
SFC_GOTO_1W_1	EQU	$
		STZ	MAPOINT		;Pv|PZbg
		LDA	#GMIN
		STA	MODENO
;;;;K;;;;		LDA	#001
;;;;K;;;;		STA	!MPCLRTBL+INT_STAT
		RTS
;
;----------------------------------------------------------------
;-		RC					-
;-			in :					-
;-				(CWK0) <-- afwW	-
;-				(CWK1) <--	h     x  h	-
;----------------------------------------------------------------
SFC_COIN	EQU	$
		PHY			;(Y) save
;
		I8
;
		LDA	R6
		CMP	#UTA400
		BNE	SFC_COIN_0050	;RCH ( no:SFC_COIN_0050 )
;
		JSR	BLUE_COIN_SET
;
		I8
;
		BRA	SFC_COIN_0060
;
SFC_COIN_0050	EQU	$
;;;;		    INC	    COIN_ADD	    ;coin counter add !!
		LDA	CCWORK0		;wWZbg
		AND	#0FFF0H
		STA	WORK0
		LDA	CCWORK1		;xWZbg
		AND	#0FFF0H
		STA	WORK2
		JSL	>EX_COIN_SET_3
;
SFC_COIN_0060	EQU	$
		LDA	#FLKIR		;(A) <-- ʂmD
		JSL	>EXINSR		;ʃGAm
		LDA	WORK0
		STA	EXXPSL,Y	;wWZbg
		LDA	WORK2
		STA	EXYPSL,Y	;xWZbg
		LDA	#0CH
		STA	EXCHPT,Y	;p^[mDZbg
		LDA	#08H
		STA	EXTIM0,Y	;^C}[Zbg
;
		I16
;
;;;;K;;;;		PLY			;(Y) load
		LDA	#UT0000
		STA	BGUTNO		;BG change unit no.
		LDA	#CNCL
		BRA	SFC_COIN_PAS
;
SFC_BGCLR	EQU	$
		LDA	#UT0000
		STA	BGUTNO		;     "    unit no.
;
SFC_BG_WT	EQU	$
		PHY			;(Y) save
;
		LDA	#BGCG
;
SFC_COIN_PAS	EQU	$
		STA	BGCGNO		;BG change type no. set
		LDA	CCWORK0
		STA	BGXPS1		;BG write X pos set
		LDA	CCWORK1
		STA	BGYPS1		;    "    Y   "
		JSL	>UNITCHG
;
		PLY			;(Y) load
		RTS
;
;----------------------------------------------------------------
;-		naiRCZbg				-
;----------------------------------------------------------------
BLUE_COIN_SET	EQU	$
		INC	CORS_COIN	;RCJE^[
;
		LDA	#000000010B	;(A) <-- RCJ[
BLUE_COIN_I_010 EQU	$
		STA	WORK6
;
		I8			; index 8bit mode
;
		LDA	CCWORK0		;wWZbg
		AND	#0FFF0H
		STA	WORK0
		LDA	CCWORK1		;xWZbg
		AND	#0FFF0H
		JSL	>EX_COIN_SET_2
;
		I16			; index 16bit mode
;
		RTS
;
;
;----------------------------------------------------------------
;-		RCRCJE^[			-
;----------------------------------------------------------------
BLUE_COIN_ST_SB EQU	$
		JSR	BLUE_COIN_SET
		RTL
;
;----------------------------------------------------------------
;-		naim[}RCZbg			-
;----------------------------------------------------------------
COIN_SET	EQU	$
		LDA	#00000000B	;(A) <-- RCJ[
		BRA	BLUE_COIN_I_010
;
;----------------------------------------------------------------
;-		w胆jbgaf			-
;-			in :					-
;-				(R5)   <-- jbgmD	-
;-				(CWK0) <-- afwW	-
;-				(CWK1) <--	h     x  h	-
;----------------------------------------------------------------
SFC_BGCHNG	EQU	$
		LDA	R5
		STA	BGUTNO		;jbgmDZbg
		BRA	SFC_BG_WT
;
;----------------------------------------------------------------
;-		ʂafiSjbgj			-
;-			in :					-
;-				(CWK0) <-- afwW	-
;-				(CWK1) <--	h     x  h	-
;----------------------------------------------------------------
SFC_BGCLR_4_L	EQU	$
		JSR	SFC_BGCLR_4
		RTL
;
SFC_BGCLR_4	EQU	$
		JSR	SFC_BGCLR
;
		PHY			;(Y) save
;
		LDA	BGXPS1
		CLC
		ADC	#010H
		STA	BGXPS1		;BG write X pos set
		JSL	>UNITCHG
;
		LDA	BGYPS1
		CLC
		ADC	#010H
		STA	BGYPS1		;BG write Y pos set
		JSL	>UNITCHG
;
		LDA	CCWORK0
		STA	BGXPS1		;BG write X pos set
		JSL	>UNITCHG
;
		PLY			;(Y) load
		RTS
;
;----------------------------------------------------------------
;-		Hׂaf				-
;-			in :					-
;-				(CWK0) <-- afwW	-
;-				(CWK1) <--	h     x  h	-
;----------------------------------------------------------------
SFC_EATBLK	EQU	$
		PHY			;(Y) save
;
		LDA	CCWORK0
		STA	BGXPS1		;BG write X pos set
		LDA	CCWORK1
		STA	BGYPS1		;    "    Y   "
		LDA	#BLK0
		STA	BGCGNO		; " change type no. set
		JSL	>UNITCHG
;
		PLY			;(Y) load
		RTS
;
;----------------------------------------------------------------
;-		gQubNaf			-
;-			in :					-
;-				(CWK0) <-- afwW	-
;-				(CWK1) <--	h     x  h	-
;----------------------------------------------------------------
SFC_TOGEBLK	EQU	$
		PHY			;(Y) save
;
		LDA	CCWORK0
		STA	BGXPS1		;BG write X pos set
		LDA	CCWORK1
		STA	BGYPS1		;    "    Y   "
		LDA	#TGTM
		STA	BGCGNO		; " change type no. set
		JSL	>UNITCHG
;
		PLY			;(Y) load
		RTS
;
;----------------------------------------------------------------
;-		Ył݂af				-
;-			in :					-
;-				(CWK0) <-- afwW	-
;-				(CWK1) <--	h     x  h	-
;-				(R6)   <-- YjbgmD	-
;----------------------------------------------------------------
KUI_CHANGE_UP	EQU	$
; ̃jbgmD -> UT6B00 UT6B01 UT6B02 UT6B03
		WORD	UT0000,UT0000,UT0000,UT2A0D
; ̃jbgmD -> UT6B10 UT6B11 UT6B12,UT6B13
		WORD	UT0000,UT0000,UT0000,UT2A2D
; ̃jbgmD -> UT6B20 UT6B21,UT6B22 UT6B23
		WORD	UT0000,UT0000,UT0000,UT2A2D
; ̃jbgmD -> UT6B30 UT6B31 UT6B32 UT6B33
		WORD	UT0000,UT0000,UT0000,UT2A3D
; ̃jbgmD -> UT6B60 UT6B61 UT6B62 UT6B63
		WORD	UT0000,UT0000,UT0000,UT964C
;
;
SFC_KUI		EQU	$
		PHY			;(Y) save
;
		LDA	R6
		AND	#000FFH
		ASL	A
		TAX
		LDA	>KUI_CHANGE_UP,X
		STA	<BGUTNO
		LDA	CCWORK0
		STA	<BGXPS1		;BG write X pos set
		LDA	CCWORK1
		STA	<BGYPS1		;    "    Y   "
		LDA	#DWCG
		STA	<BGCGNO		; " change type no. set
		JSL	>UNITCHG
;
		PLY
		RTS
;
;----------------------------------------------------------------
;-		^}SIvV				-
;-			in :					-
;-				(R1) <-- ^}S̓GCfbNX -
;----------------------------------------------------------------
SFC_EGG_KILL	EQU	$
		PHY			;(Y) save
;
		LDX	R1		;(X) <-- ^}S̓GCfbNX
		JSL	>EGGKILL	;^}SIvV
;
		PLY			;(Y) load
		RTS
;
;----------------------------------------------------------------
;-		ibvZbg				-
;-			in :					-
;-				(R8) <-- G̃CfbNX	-
;----------------------------------------------------------------
SFC_ONE_UP	EQU	$
		PHY			;(Y) save

		I8
		LDX	R8
		LDA	ENXPSL,X
		STA	WORK0
		LDA	ENYPSL,X
		SEC
		SBC	#00008
		STA	WORK2
		LDA	#00005		;mrn
		STA	MSOUND3

		JSL	>PL_1UP_SET
		I16

		PLY
		RTS
;
;----------------------------------------------------------------
;-		glhm^ntsfX^[gZbg	-
;----------------------------------------------------------------
SFC_TNIO_IN	EQU	$
		LDA	BG3TYP
		CMP	#0AH
		BNE	SFC_TNIO_IN_010 ;afRO}XNR[XH ( no:SFC_TNIO_IN_010 )
;
		PHY			;(Y) save
;
		JSL	>TONNEL_INOUT_IN
;
		PLY			;(Y) load
;
SFC_TNIO_IN_010 EQU	$
		RTS
;
;----------------------------------------------------------------
;-		vC[_EZbg				-
;----------------------------------------------------------------
SFC_PLDOWNST	EQU	$
		PHY			;(Y) save
;
		LDA	#PFAL		;(A) <-- vC[_E[h
		JSL	>TIMEUP_SET_S
		LDA	#PFLP
		STA	PLWALK
		LDA	#022H
		STA	PLWKTM
		STZ	PCHNG_TM
;
		PLY			;(Y) load
		RTS
;
;----------------------------------------------------------------
;-		vC[_[WZbg			-
;----------------------------------------------------------------
SFC_PLFAILST	EQU	$
		PHY			;(Y) save
;
		I8
;
		JSL	>PLFLST_S
;
		I16
;
		PLY			;(Y) load
		RTS
;
;----------------------------------------------------------------
;-		vC[n◎				-
;----------------------------------------------------------------
YOGAN_IN_XSP	EQU	$
; PLCMKI -->
		WORD	00080H,0FF80H
;
SFC_YOGAN_IN	EQU	$
		LDA	PL_NO_DOWN
		BNE	SFC_YOGAN_IN_10 ;vC[_ELZH ( yes:SFC_YOGAN_IN_10 )
;
		PHY			;(Y) save
;
		LDA	#PYGN		;(A) <-- vC[n◎[h
		JSL	>TIMEUP_SET_S
		LDA	#0FB00H		;xXs[hZbg
		STA	PLYSPD
		LDX	PLCMKI
		LDA	>YOGAN_IN_XSP,X ;wXs[hZbg
		STA	PLXSPD
		LDA	#020H		;EFCg^C}[Zbg
		STA	PLWORKTM
;
		PLY			;(Y) load
;
SFC_YOGAN_IN_10 EQU	$
		RTS
;
;----------------------------------------------------------------
;-		IuWFRCAY[t[		-
;-			in :					-
;-				(CWK0) <-- ENINDX	-
;----------------------------------------------------------------
SFC_POINT_GET	EQU	$
		PHY			;(Y) save
;
		I8
;
		LDX	CCWORK0
		LDA	ENMYNO,X		;̂̓RC ?
		CMP	#COIN1			;
		BEQ	SFC_P_G0100		; yes: SFC_P_G0100
		CMP	#COINR			;
		BNE	SFC_P_G1000		;  no: SFC_P_G1000

		JSL	>COINR_GET
		BRA	SFC_P_G3000

SFC_P_G0100	EQU	$
		JSL	>COIN1_GET
		BRA	SFC_P_G2000

SFC_P_G1000	EQU	$
		JSL	>FLOWER_GET

SFC_P_G2000	EQU	$
		JSL	>ENCLEAR_NORETN
;
SFC_P_G3000	EQU	$
		I16
;
		PLY			;(Y) load
		RTS
;
;************************************************************************
;*		meter screen buffer set					*
;************************************************************************
TOKUDAT		EQU	$
		WORD	100,10
;
TIM_CNT_ADD	EQU	$
		WORD	00010,-00010
;
TIM_CNT_MAX	EQU	$
		WORD	00300,00000
;
;
METERST		EQU	$
		I16			; index 16bit mode
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		RCZbg				x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
MTRCINCNT	EQU	$
;;;;		    LDA	    !CRS_CIN_ADD
;;;;		    BEQ	    MTRCINCNT_200
;;;;		    CLC
;;;;		    ADC	    !CORS_COIN
;;;;		    STA	    !CORS_COIN
;;;;;
;;;;MTRCINCNT_200   EQU	    $
;;;;		    STZ	    !CRS_CIN_ADD
;;;;		    LDA	    !COIN_ADD
;;;;		    BEQ	    MTRCINCNT_900
;;;;		    CLC
;;;;		    ADC	    !COIN_CNT
;;;;		    CMP	    #00100
;;;;		    BCC	    MTRCINCNT_800
;;;;		    SEC
;;;;		    SBC	    #00100
;;;;		    INC	    !PLCONT
;;;;;
;;;;MTRCINCNT_800   EQU	    $
;;;;		    STA	    !COIN_CNT
;;;;MTRCINCNT_900   EQU	    $
;;;;		    STZ	    !COIN_ADD
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		vC[lZbg				x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
PLCNTST		EQU	$
		LDA	!PLCONT		; player counter load !!
		CMP	#01000
		BCC	PLCNTST_990
		LDA	#0999
		STA	!PLCONT
		LDA	!PLUPCT
		CMP	#01000
		BCC	PLCNTST_990
		LDA	#0999
		STA	!PLUPCT
PLCNTST_990	EQU	$
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		x Zbg					x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
COLOR_CHG	EQU	$
;;;;		    LDA	    !TIMER	    ; ^C}[  O ?
;;;;		    BEQ	    TIMERST	    ;	    YES -> TIMERST
;;;;		    CPY	    #00090	    ; x Zbg ?
;;;;		    BCS	    TIMERST	    ;	    NO -> TIMERST
;;;;		    LDX	    !GOAL_IN
;;;;		    BNE	    TIMERST
;;;;		    LDX	    #00029H
;;;;		    STX	    <SOUND3	    ;[]
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		timer set program				x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
TIMERST		EQU	$
		STZ	!TIMCHG
		INC	!MTR_CNT
		LDX	#00000
		LDA	!TIMCNT_UP	; timer inc. ?
		BEQ	TET000		;	NO -> TET000
		BPL	TIM_CNT_200
		INX
		INX
TIM_CNT_200	EQU	$
		LDA	!GOAL_IN
		BNE	TIM_CNT_230
		LDA	!MTR_CNT
		CMP	#00004
		BCC	TIM_CNT_310
TIM_CNT_230	EQU	$
		STZ	!MTR_CNT
		LDA	!TIMER
		CLC
		ADC	TIM_CNT_ADD,X
		BMI	TIM_CNT_250
		STA	!TIMER
		CMP	TIM_CNT_MAX,X
		BCC	TIM_CNT_300
TIM_CNT_250	EQU	$
		LDA	TIM_CNT_MAX,X
		STA	!TIMER
		STZ	!TIMCNT_UP
		JMP	TET050
TIM_CNT_300	EQU	$
		LDA	!TIMCNT_UP
		SEC
		SBC	TIM_CNT_ADD,X
		STA	!TIMCNT_UP
		INC	!TIMCHG		; ^C}[`FW !!
TIM_CNT_310	EQU	$
		BRA	TET050
;
TET000		EQU	$
		LDA	!BABYDWN	; ԂĂ ?
		BMI	TET005_50	;	JEgto ?	(YES -> TET005_50)
		BNE	TET050		;	YES -> TET050
		LDA	!GOAL_IN	; S[  Q[g
		ORA	!GATE_IN	; ^C}[Xgbv  bZ[W\
		ORA	!TIMER_STOP	;
		ORA	!MSGMOD		;	tO nmH
		BEQ	TET010		;	NO -> TET010
		BRA	TET050
;
TET005_50	EQU	$
		LDA	!TIMER
		CMP	#00109		; ^C}[  POȏ ?
		BCS	TET050		;	YES -> TET050
		INC	!TIMCNT_SB
		LDA	!TIMCNT_SB
		CMP	#00004*3	; JEgto nj ?
		BCC	TET050		;	NO -> TET050
		STZ	!TIMCNT_SB
		INC	!TIMER
		LDA	!TIMER
		CMP	#00100
		BNE	TET050
		LDA	#00032H
		STA	<SOUND_3
		BRA	TET050
;
TET010		EQU	$
		STZ	!TIMCNT_SB
		LDA	!CCHGMK		; ϐg H
		BNE	TETEND
;
		LDA	!TIMER		; timer = 0 ?
		BEQ	TETEND		;	YES -> TETEND
;
		INC	!TIMCNT
		LDA	!TIMCNT
		CMP	#00004
		BCC	TET050
		STZ	!TIMCNT
		DEC	!TIMER		; timer = 0 ?
;
		LDA	!TIMER
		CMP	#00090		; timer = 90 ?
		BCS	TET050		;	NO -> TET050
		LDA	!SND_SPUP
		AND	#000FFH
		BNE	TET050
		INC	!SND_SPUP
		LDX	<SOUND_3_P
		LDA	#00024H
		STA	<SOUND_3_BF,X	;[]
		INC	<SOUND_3_P
;
TET050		EQU	$
		LDX	#00000H
		LDA	!TIMER
		CMP	#01000		; ^C}[  POOO ?
		BCC	TET070		;	YES -> TET070
		LDA	#01000-1
		STA	!TIMER
;
TET070		EQU	$
		LDY	#00000H
;
TET100		EQU	$
		CMP	TOKUDAT,X
		BCC	TET150
		SBC	TOKUDAT,X
		INY
		BRA	TET100
;
TET150		EQU	$
		STY	<WORK0,X
		INX
		INX
		CPX	#00004
		BNE	TET070
;
		STA	<WORK0,X
		LDA	<WORK0
		STA	!TIMER_HI
		LDA	<WORK2
		STA	!TIMER_MID
		LDA	<WORK4
		STA	!TIMER_LOW	; ̈ʁO ?
		BNE	TETEND		;	NO -> TETEND
		LDA	!TIMCNT
		BNE	TETEND
		INC	!TIMCHG		; ^C}[`FW !!
;
TETEND		EQU	$
		I8			; index 8 bit mode !!
		RTS
;
		MEM8
		IDX8
;
;************************************************************************
;*		JSL type VRAM write sub ( VRAMD )			*
;************************************************************************
VMADSPL		EQU	$
		PHB			;(DBR) save
		PHK			;(DBR) <-- (PBR)
		PLB
;
		JSR	VMADSP
;
		PLB
		RTL
;
;************************************************************************
;*		VRAM write sub ( VRAMD )				*
;************************************************************************
VTABLE		EQU	$
VTB00		LWORD	VRAMD+2
VTB01		LWORD	VCLDAT		;VRAM clear data
VTB04		LWORD	BG3SCRCLR	;afRXN[NA[f[^
VTB05		LWORD	BG3WANCLR	;afRXN[NA[f[^iafRj
VTB06		LWORD	BG3WTRCLR	;afRXN[NA[f[^iafRAX`bNj
;
VTCL		EQU	VTB01-VTABLE
B3CL		EQU	VTB04-VTABLE
WNCL		EQU	VTB05-VTABLE
B3WRCL		EQU	VTB06-VTABLE
;
VMADSP		EQU	$
;
		I16
;
		LDY	VRFLG
		LDX	VTABLE,Y	;BG data address(L) set
		LDA	VTABLE+2,Y	;	"       (B) set
		JSR	VRAMTR		;VRAM write
;
		IDX8
;
		LDA	VRFLG
		BNE	VMD010		;VRAMD write ? ( no:VMD010 )
;
		STA	>VRAMD
		STA	>VRAMD+1
		DEC	A		;[ LDA	#0FFFFH ]
		STA	>VRAMD+3
VMD010		EQU	$
		STZ	VRFLG
;
		RTS
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		JSR	NEWVMAD ( new VMADSP sub )			x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
VRFLDAT		EQU	$
VRTB00		LWORD	VRAMDX
;
NEWVMADL	EQU	$
		PHB			;(DBR) save
		PHK
		PLB
;
		JSR	NEWVMAD
;
		PLB
		RTL
;
NEWVMAD		EQU	$
		I16
;
		LDX	VRFLG2
		LDY	!VRFLDAT,X	;BG data address(L) set
		LDA	!VRFLDAT+2,X	;	"       (B) set
		PHB
		PHA
		PLB
		STA	<WORK0
;
		M16
;
		LDA	0,Y
		STA	<WORK4		; end address set
		CMP	#VRAMDX+2
		BEQ	NVD150
		INY
		INY
;
NVD100		EQU	$
		LDA	0,Y
		STA	>2116H
;
		LDA	4,Y
		STA	>4301H
;
		LDA	6,Y
		STA	>4303H
;
		LDA	8,Y
		STA	>4305H
;
		LDA	2,Y
;
		M8
;
		STA	>2115H
		XBA
		STA	>4300H
;
		LDA	#00000001B
		STA	>420BH
;
		M16
;
		LDA	10,Y
		TAY
		CMP	<WORK4
		BNE	NVD100		; end ?
;					; Yes!
		LDA	>VRFLG2
		BNE	NVD150
;
		LDA	#VRAMDX+2
		STA	VRAMDX		; end code set
;
NVD150		EQU	$
		PLB
		STZ	VRFLG2
;
		MI8
;
		RTS
;
;****************************************************************
;*		VRAM transfer sub				*
;*			in  : (X) <-- data address(L,H)		*
;*			      (A) <--	    "     (B)           *
;****************************************************************
;
		IDX16
;
VRAMTR		EQU	$
		PHB			;(DBR) save
		PHA			;(DBR) <-- data bank
		PLB
		STA	<WORK		;(WK0) <-- data address(B)
;
		M16
;
VTR010		EQU	$
		LDY	0000,X
		BPL	VTR020		;end ? ( no:VTR020 )
;
;-------------- end return ------------------------------
		SEP	#00110000B	;memory,index 8 bit mode set
		PLB
		RTS
;
VTR020		EQU	$
		LDA	0002,X		;number 0f byte set
		AND	#01FFFH
		INC	A
		STA	<WORK+1		;(WK1,2) <-- number of byte
		STA	<WORK+3		;(WK3,4) <-- data index up add data
;
		LDA	#10000000B
		BIT	0002,X
		BPL	VTR030		;tate ? ( no:VTR030 )
;-------------- tate write set --------------------------
		LDA	#10000001B
VTR030		EQU	$
		STA	>2115H		;inc mode set
		STA	<WORK+5		;(WK5,6) <-- inc mode
		TYA
		STA	>2116H		;VRAM address set
;
		LDA	0002,X
		AND	#0010000000000000B
		BEQ	VTR040		;VRAM read ? ( no:VTR040 )
;-------------- VRAM read -------------------------------
		LDA	#0003H		;(WK3,4) <-- data index up add data
		STA	<WORK+3
		LDA	0004,X		;A bus address(L,H) set
		STA	>4302H
		LDA	0005,X		;      "      (B) set
		STA	>4303H
		LDA	>2139H		;read intial
		LDA	#10000001B+(39H*100H)
		BRA	VTR060
;
VTR040		EQU	$
		LDA	<WORK		;A bus address(B) set
		STA	>4304H
		LDY	#00000001B+(18H*100H)
		BVC	VTR050		;= data set ? ( no:VTR050 )
;-------------- = data set ------------------------------
		LSR	<WORK+1		;(number of byte)/2
		LDA	#0002H		;(WK3,4) <-- data index up add data
		STA	<WORK+3
		LDA	#00001000B+(19H*100H)	;control parameter & B bus address set
		STA	>4300H
		TXA				;A bus address(L,H) set
		CLC
		ADC	#0005H
		STA	>4302H
		LDA	<WORK+1		;number of byte set
		STA	>4305H
		LDA	#00000001B*100H ;DMA start
		STA	>420AH		;[ 420AH dummy ]
		LDA	<WORK+5
		AND	#01111111B
		STA	>2115H		;inc mode set
		LDA	0000,X
		STA	>2116H		;VRAM address set
		LDY	#00001000B+(18H*100H)
VTR050		EQU	$
		TXA				;A bus address(L,H) set
		CLC
		ADC	#0004H
		STA	>4302H
		TYA
VTR060		EQU	$
		STA	>4300H		;control parameter & B bus address set
		LDA	<WORK+1		;number of byte set
		STA	>4305H
		LDA	#00000001B*100H ;DMA start
		STA	>420AH		;[ 420AH dummy ]
		TXA
		CLC
		ADC	#0004H		;[ not (C)=1 !! if (C)=1 then error data !! ]
		ADC	<WORK+3
		TAX
		JMP	VTR010
;
;
;****************************************************************
;*								*
;*		X[p[ cl`] vO			*
;*								*
;****************************************************************
		MEM16
		IDX8
SP_VRAM_ST	EQU	$
		LDA	!VRAMDSP
		BEQ	SP_VRAM_END
		LDX	#080H		; uq`l AhX
		STX	2115H		;	CN [h
		LDX	#001H
		STX	<4300H		; cl` p[^
		LDX	#018H
		STX	<4301H		; aoX AhX
		LDX	#BANK UNDATA
		STX	<4304H		; `oX oNAhX
;
		LDY	#000H
		LDX	#001H
SP_VRAM_LOP	EQU	$
		LDA	!VRAMDSP+2,Y
		BMI	SP_VRAM_END
		PHA
		STA	2116H		; ] AhX
		LDA	!VRAMDSP+4,Y
		STA	<4302H		; ] AhX
		LDA	#00004H
		STA	<4305H		; ]oCg
		STX	420BH		; cl` "nm"!!
		PLA
		CLC
		ADC	#00020H
		STA	2116H		; ] AhX
		LDA	#00004H
		STA	<4305H		; ]oCg
		STX	420BH		; cl` "nm"!!
		INY
		INY
		INY
		INY
		BRA	SP_VRAM_LOP
;
SP_VRAM_END	EQU	$
		LDA	#00000H
		STA	!VRAMDSP
		DEC	A
		STA	!VRAMDSP+2
		RTS
;
		MEM8
		IDX8
;
;************************************************************************
;		joy-controller read					*
;************************************************************************
;
CONT2		EQU	$
		LDA	4212H
		LSR	A
		BCS	CONT2		;read ok ? ( no:CONT2 )
;
		MI16
;
		LDA	4218H		;1p controller
		BIT	#0000000000001111B
		BEQ	CONT2_010	;controler ok ? ( yes:CONT2_010 )
		LDA	#00
CONT2_010	EQU	$
		STA	KEYA1L
		TAY
		EOR	KEYABFL
		AND	KEYA1L
		STA	KEYA2L
		STY	KEYABFL
;
		LDA	421AH		;2p controller
		BIT	#0000000000001111B
		BEQ	CONT2_020	;controler ok ? ( yes:CONT2_020 )
		LDA	#00
CONT2_020	EQU	$
		STA	KEYB1L
		TAY
		EOR	KEYBBFL
		AND	KEYB1L
		STA	KEYB2L
		STY	KEYBBFL
;
		LDA	KEYA1L		;move controller set
		STA	<KEYC1L
		LDA	KEYA2L
		STA	<KEYC2L
;
		MI8
;
		RTS
;
;************************************************************************
;*		Key Read  &  Mouse Read			(CONT2)		*
;************************************************************************
CONT22		EQU	$
		LDA	04212H
		LSR	A
		BCS	CONT22		; key read ok ?
;					; yes
		MEM16
		IDX16
		REP	#00110000B	; memory,index 16bit mode
;
		LDA	04218H		; 1P CONTROLLER
		TAY
		AND	#0000FH
		CMP	#00001H
		BNE	MOUSE100	; mouse on ?
;					; yes
		MEM8
		IDX8
		SEP	#00110000B	; memory,index 8bit mode
;
		STY	MOUSEAS
		TYA
		EOR	MOUSEAB
		AND	MOUSEAS
		STA	MOUSEAT
		STY	MOUSEAB	       ; key set
;
		LDY	#00FH		; X Y SET
MOUSE20		EQU	$
		LDA	04016H
		LSR	A
		ROL	MOUSEAX
		ROL	MOUSEAY
		DEY
		BPL	MOUSE20		; mouse data read end ?
;					; yes
		LDA	MOUSEAX
		BPL	MOUSE40		; X(-) move ?
;					; yes
		EOR	#0FFH
		INC	A
		EOR	#080H
		STA	MOUSEAX
MOUSE40		EQU	$
		LDA	MOUSEAY
		BPL	MOUSE70		; Y(-) move ?
;					; yes
		EOR	#0FFH
		INC	A
		EOR	#080H
		STA	MOUSEAY
MOUSE70		EQU	$
		LDA	MOUSEAS
		LSR	A
		LSR	A
		LSR	A
		LSR	A
		AND	#003H
		CMP	MOUSESPA
		BEQ	MOUSE80		; speed change ?
;					; yes
		LDY	#000H
		JSR	MOUSE_SP
MOUSE80		EQU	$
		MEM16
		IDX16
		REP	#00110000B	; memory,index 16bit mode
;
		STZ	KEYA1L
		STZ	KEYA2L
		STZ	KEYABFL
		BRA	MOUSE200
;
MOUSE100	EQU	$
		STY	KEYA1L
		TYA
		EOR	KEYABFL
		AND	KEYA1L
		STA	KEYA2L
		STY	KEYABFL	       ; joy-controller set
		STZ	MOUSEAS	       ; MOUSE CLR
		STZ	MOUSEAX	       ; MOUSE CLR
		STZ	MOUSEAT	       ; MOUSE CLR
;
;
MOUSE200	EQU	$
		LDA	0421AH		; 2P CONTROLLER
		TAY
		AND	#0000FH
		CMP	#00001H
		BNE	MOUSE300	; mouse on ?
;					; yes
		MEM8
		IDX8
		SEP	#00110000B	; memory,index 8bit mode
;
		STY	MOUSEBS	       ;KEY SET
		TYA
		EOR	MOUSEBB
		AND	MOUSEBS
		STA	MOUSEBT
		STY	MOUSEBB
;
		LDY	#00FH		;X Y SET
MOUSE220	EQU	$
		LDA	04017H
		LSR	A
		ROL	MOUSEBX
		ROL	MOUSEBY
		DEY
		BPL	MOUSE220	; mouse data read end ?
;					; yes
		LDA	MOUSEBX
		BPL	MOUSE240	; X(-) ?
;					; yes
		EOR	#0FFH
		INC	A
		EOR	#080H
		STA	MOUSEBX
MOUSE240	EQU	$
		LDA	MOUSEBY
		BPL	MOUSE260	; Y(-) ?
;					; yes
		EOR	#0FFH
		INC	A
		EOR	#080H
		STA	MOUSEBY
MOUSE260	EQU	$
		LDA	MOUSEBS
		LSR	A
		LSR	A
		LSR	A
		LSR	A
		AND	#003H
		CMP	MOUSESPB
		BEQ	MOUSE280	; speed change ?
;					; yes
		LDY	#001H
		JSR	MOUSE_SP
MOUSE280	EQU	$
		MEM16
		IDX16
		REP	#00110000B
;
		STZ	KEYB1L
		STZ	KEYB2L
		STZ	KEYBBFL	       ; joy-controller clear
		SEP	#00110000B
		RTS
;
MOUSE300	EQU	$
		STY	KEYB1L
		TYA
		EOR	KEYBBFL
		AND	KEYB1L
		STA	KEYB2L
		STY	KEYBBFL	       ; joy-controller set
		STZ	MOUSEBS	       ;MOUSE CLR
		STZ	MOUSEBX	       ;MOUSE CLR
		STZ	MOUSEBT	       ;MOUSE CLR
;
		MEM8
		IDX8
		SEP	#00110000B
		RTS
;
;
;
MOUSE_SP	EQU	$			;SPEED CHNG.
		LDA	#001H
		STA	04016H
		LDA	04016H,Y
		STZ	04016H
;
		LDA	#001H
		STA	04016H
		STZ	04016H
;
		LDX	#010
MUE_SP10	EQU	$
		LDA	04016H,Y
		DEX
		BNE	MUE_SP10
;
		LDA	04016H,Y
		XBA
		LDA	04016H,Y
		LSR	A
		XBA
		ROL	A
		AND	#003H
		CMP	MOUSESPA,Y
		BNE	MOUSE_SP
;
		RTS
;
;************************************************************************
;*		OBJ DMA							*
;*			in  : (X) <-- DMA "ON" flag			*
;************************************************************************
;
		MEM16
		IDX8
;
OBJDMA		EQU	$
		STZ	2102H		;OAM address set ( 00~ )
;
		STZ	<4300H		;DMA control parameter
		LDA	#04+((OAM&0000FFH)*100H)			;DMA B bus address & A bus address(L)
		STA	<4301H
		LDA	#((OAM&00FF00H)/100H)+((OAM&0FF0000H)/100H)	;DMA A bus address(H,B)
		STA	<4303H
		LDA	#0220H		;DMA number of byte
		STA	<4305H
		STX	420BH
		RTS
;
;************************************************************************
;*		color DMA						*
;*			in  : (X) <-- DMA "ON" flag			*
;************************************************************************
;
COLDMA		EQU	$
;
;----------------------------------------------------------------
;-		constant color set				-
;----------------------------------------------------------------
		LDA	NUKCOL		;[ red ]
		AND	#00011111B
		ORA	#00100000B
		TAY
		STY	2132H
		LDA	NUKCOL		;[ green ]
		LSR	A
		LSR	A
		LSR	A
		LSR	A
		LSR	A
		AND	#00011111B
		ORA	#01000000B
		TAY
		STY	2132H
		LDA	NUKCOL+1	;[ blue ]
		LSR	A
		LSR	A
		ORA	#10000000B
		TAY
		STY	2132H
;
;----------------------------------------------------------------
;-		C.G RAM DMA set					-
;----------------------------------------------------------------
CGDMA		EQU	$
		LDY	#00
		STY	2121H			;C.G RAM address set
;
		LDA	#00000000B+(22H*100H)	;DMA parameter & B bus address set
		STA	<4300H
		LDA	#DATACOL		;A bus address(L,H) set
		STA	<4302H
		LDY	#BANK DATACOL		;	"     (B) set
		STY	<4304H
		LDA	#0200H			;number of byte
		STA	<4305H
		STX	420BH
		RTS
;
;************************************************************************
;*									*
;*		BG chara DMA set ( to initial set )			*
;*									*
;************************************************************************
BGCDMA_L	EQU	$
		PHB			;(DBR) save
		PHD			;(D) save
;
		PHK			;(DBR) <-- (PBR)
		PLB
;
		M16
;
		LDA	#4300H		;0 page set ( 4300H- )
		TCD
		LDX	#00000001B	;(X) <-- DMA "ON" flag
;
		LDY	#10000000B	;VRAM address inc mode set
		STY	2115H
		LDA	#00000001B+(18H*100H)	;DMA parameter set
		STA	<4300H
;
		LDA	#020H
		STA	WORK		;(WK0,1) <-- loop no
BGCDMA_L_010	EQU	$
		INC	FRCNT2
;
		JSR	BGCDMA
;
		DEC	WORK
		BNE	BGCDMA_L_010
;
		M8
;
		PLD
		PLB
		RTL
;
		MEM16
;
;************************************************************************
;*		BG chara DMA set					*
;*			in  : (X) <-- DMA "ON" flag			*
;************************************************************************
CHRTR_MAIN_VADR EQU	$
		WORD	1400H,		 1400H
		WORD	1440H,		 1440H
		WORD	1480H,		 1480H
		WORD	14C0H,		 14C0H
;
		WORD	1400H,		 1400H	;dummy
		WORD	1440H,		 1440H
		WORD	1480H,		 1480H
		WORD	14C0H,		 14C0H
;
		WORD	1400H,		 1400H	;dummy
		WORD	1440H,		 1440H
		WORD	1480H,		 1480H
		WORD	14C0H,		 14C0H
;
		WORD	1400H,		 1400H	;dummy
		WORD	1440H,		 1440H
		WORD	1480H,		 1480H
		WORD	14C0H,		 14C0H
;
CHRTR_MAIN_CADR EQU	$
		WORD	CHR34+(000H*20H),CHR34+(000H*20H)	;pattern.1 [ RC ]
		WORD	CHR34+(020H*20H),CHR34+(008H*20H)	;	   [ _ubN ]
		WORD	CHR34+(028H*20H),CHR34+(000H*20H)	;	   [ _RC ]
		WORD	CHR34+(108H*20H),CHR64+(144H*20H)	;	   [ }IubN ]
;
		WORD	CHR34+(004H*20H),CHR34+(004H*20H)	;pattern.2 [ RC ]
		WORD	CHR34+(024H*20H),CHR34+(00CH*20H)	;	   [ _ubN ]
		WORD	CHR34+(02CH*20H),CHR34+(004H*20H)	;	   [ _RC ]
		WORD	CHR34+(108H*20H),CHR64+(154H*20H)	;	   [ }IubN ]
;
		WORD	CHR34+(010H*20H),CHR34+(010H*20H)	;pattern.3 [ RC ]
		WORD	CHR34+(030H*20H),CHR34+(018H*20H)	;	   [ _ubN ]
		WORD	CHR34+(038H*20H),CHR34+(010H*20H)	;	   [ _RC ]
		WORD	CHR34+(108H*20H),CHR64+(164H*20H)	;	   [ }IubN ]
;
		WORD	CHR34+(014H*20H),CHR34+(014H*20H)	;pattern.4 [ RC ]
		WORD	CHR34+(034H*20H),CHR34+(01CH*20H)	;	   [ _ubN ]
		WORD	CHR34+(03CH*20H),CHR34+(014H*20H)	;	   [ _RC ]
		WORD	CHR34+(108H*20H),CHR64+(174H*20H)	;	   [ }IubN ]
;
CHRTR_MAIN_SWCK EQU	$	;XCb``FbNp`mcf[^
		WORD	00000000B,0	;[RC]
		WORD	00001000B,0	;[_ubN]
		WORD	00001000B,0	;[_RC]
		WORD	00010000B,0	;[}IubN]
;
		WORD	00000000B,0	;[RC]
		WORD	00001000B,0	;[_ubN]
		WORD	00001000B,0	;[_RC]
		WORD	00010000B,0	;[}IubN]
;
		WORD	00000000B,0	;[RC]
		WORD	00001000B,0	;[_ubN]
		WORD	00001000B,0	;[_RC]
		WORD	00010000B,0	;[}IubN]
;
		WORD	00000000B,0	;[RC]
		WORD	00001000B,0	;[_ubN]
		WORD	00001000B,0	;[_RC]
		WORD	00010000B,0	;[}IubN]
;
BGCDMA		EQU	$
		LDA	ENSTFG
		BNE	BGCDMA_000
		INC	!CHR_ANIME_TM
BGCDMA_000	EQU	$
;
;-------------- ւLN^[ -----------------------------------
		LDA	CHRTRP
		ASL	A
		TAX
		JSR    (!BGCDMA_TBL,X)
;
;-------------- 풓LN^[ ---------------------------------------
		LDA	FRCNT2
		AND	#0FH<<1
		ASL	A
		TAY
		LDA	SWITCH_1
		AND	!CHRTR_MAIN_SWCK,Y
		BEQ	BGCDMA_010	;XCb`hnmhH ( no:BGCDMA_010 )
		INY
		INY
BGCDMA_010	EQU	$
		LDA	!CHRTR_MAIN_VADR,Y
		STA	2116H		;VRAM address set
		LDA	!CHRTR_MAIN_CADR,Y
		STA	<4302H		;A bus address(L,H) set
		LDY	#BANK CHR34
		STY	<4304H		;	"     (B) set
		LDY	#080H
		STY	<4305H		;number of byte set
		STX	420BH		;DMA "ON"
;
;-------------- ւݏLN^[] --------------------------------
		LDA	BGCGWF
		BEQ	BGCDMA_050	;DMA ? ( no:BGCDMA_050 )
;
		LDA	#1280H
		STA	2116H		;VRAM address set
		LDA	#WOB7CHR+(46H*20H)
		STA	<4302H		;A bus address(L,H) set
		LDY	#BANK WOB7CHR
		STY	<4304H		;	"     (B) set
		LDA	#(20H*8)
		STA	<4305H		;number of byte set
		STX	420BH		;DMA "ON"
;
		STA	<4305H		;number of byte set
		LDA	#1380H
		STA	2116H		;VRAM address set
		LDA	#WOB7CHR+(56H*20H)
		STA	<4302H		;A bus address(L,H) set
		STX	420BH		;DMA "ON"
;
		STZ	BGCGWF
BGCDMA_050	EQU	$
		RTS
;
;-------------- BG chara DMA set pattern table data ---------------------
BGCDMA_TBL	EQU	$
		WORD	CHRTR_00	;[00] 
		WORD	CHRTR_01	;[01] afR
		WORD	CHRTR_02	;[02] afQ_
		WORD	CHRTR_03	;[03] afR_
		WORD	CHRTR_04	;[04] ܂
		WORD	CHRTR_05	;[05] afRAX`bN()
		WORD	CHRTR_06	;[06] n`
		WORD	CHRTR_07	;[07] JxR[X (n)
		WORD	CHRTR_08	;[08] R[X g
		WORD	CHRTR_09	;[09] afR 
		WORD	CHRTR_0A	;[0A] afR 𒹂̌Q
		WORD	CHRTR_0B	;[0B] afR eknvdq
		WORD	CHRTR_0C	;[0C] WOR[X 
		WORD	CHRTR_0D	;[0D] n`Ɨn
		WORD	CHRTR_0E	;[0E] n`ƃWOR[X 
		WORD	CHRTR_0F	;[0F] afR n`pXe _
		WORD	CHRTR_10	;[10] {X
		WORD	CHRTR_11	;[11] afR_ƃWOR[X 
;
;-------------- ] ------------------------------------------------
CHRTR_04	EQU	$
		PLA			;[ pull pull return !! ]
		LDX	#00000001B	;DMA "ON" data set
		RTS
;
CHRTR_00	EQU	$
		LDA	!FRCNT2
		AND	#00007H
		XBA
		LSR	A
		ORA	#01000H
;
		STA	2116H		; VRAM address set
		LDA	#CHR64+001A0H*020H
		STA	<4302H		; A bus address(L,H) set
		LDX	#BANK CHR64
		STX	<4304H		;	"       (B) set
		LDA	#00100H
		STA	<4305H		; number of byte set
		LDX	#00000001B
		STX	420BH		; DMA "ON" data set
		RTS
;
;-------------- afR ----------------------------------------------
CHRTR_01_CADR	EQU	$
		WORD	CHR3F+0800H
		WORD	CHR3F+0A00H
		WORD	CHR3F+0C00H
		WORD	CHR3F+0E00H
;
CHRTR_01	EQU	$
		LDA	#2F00H		;VRAM address set
		STA	2116H
		LDA	#200H		;number of byte set
		STA	<4305H
		LDY	#BANK CHR3F
		STY	<4304H		;A bus address(B) set
;
		LDA	FRCNT2
		LSR	A
		LSR	A
		AND	#03H*2
		TAY
		LDA	!CHRTR_01_CADR,Y
		STA	<4302H		;A bus address(L,H) set
		LDX	#00000001B
		STX	420BH		;DMA "ON"
		RTS
;
;-------------- afQ_ ------------------------------------------------
CHRTR_02_VADR0	EQU	$
		WORD	1000H
		WORD	1080H
		WORD	1200H
		WORD	1280H
CHRTR_02_VADR1	EQU	$
		WORD	1100H
		WORD	1180H
		WORD	1300H
		WORD	1380H
CHRTR_02_CADR	EQU	$
		WORD	CHR34+(080H*20H)	;pattern.1 [ _ij]
		WORD	CHR34+(0C0H*20H)	;	   [ hij]
		WORD	CHR34			;	   [	     ]
		WORD	CHR34			;	   [	     ]
;
		WORD	CHR34+(090H*20H)	;pattern.2 [ _ij]
		WORD	CHR34+(0D0H*20H)	;	   [ hij]
		WORD	CHR34			;	   [	     ]
		WORD	CHR34			;	   [	     ]
;
		WORD	CHR34+(0A0H*20H)	;pattern.3 [ _ij]
		WORD	CHR34+(0E0H*20H)	;	   [ hij]
		WORD	CHR34			;	   [	     ]
		WORD	CHR34			;	   [	     ]
;
		WORD	CHR34+(0B0H*20H)	;pattern.4 [ _ij]
		WORD	CHR34+(0F0H*20H)	;	   [ hij]
		WORD	CHR34			;	   [	     ]
		WORD	CHR34			;	   [	     ]
;
CHRTR_02	EQU	$
		LDA	FRCNT2
		AND	#0FH<<1
		TAY
		LDA	!CHRTR_02_CADR,Y
		STA	<4302H		;A bus address(L,H) set
		LDX	#BANK CHR34
		STX	<4304H		;A bus address(B) set
;
		TYA
		AND	#03H<<1
		TAY
		LDA	!CHRTR_02_VADR0,Y
		STA	2116H		;VRAM address set
		LDA	#0100H
		STA	<4305H		;number of byte set
		LDX	#00000001B
		STX	420BH		;DMA "ON"
;
		STA	<4305H		;number of byte set
		LDA	!CHRTR_02_VADR1,Y
		STA	2116H		;VRAM address set
		STX	420BH		;DMA "ON"
		RTS
;
;-------------- afR_ ------------------------------------------------
CHRTR_03_CADR	EQU	$
		WORD	CHR70			;pattern.1 [ _ ]
		WORD	CHR70			;	   [	]
		WORD	CHR70			;	   [	]
		WORD	CHR70			;	   [	]
;
		WORD	CHR70+(020H*10H)	;pattern.2 [ _ ]
		WORD	CHR70+(020H*10H)	;	   [	]
		WORD	CHR70+(020H*10H)	;	   [	]
		WORD	CHR70+(020H*10H)	;	   [	]
;
		WORD	CHR70+(040H*10H)	;pattern.3 [ _ ]
		WORD	CHR70+(040H*10H)	;	   [	]
		WORD	CHR70+(040H*10H)	;	   [	]
		WORD	CHR70+(040H*10H)	;	   [	]
;
		WORD	CHR70+(060H*10H)	;pattern.4 [ _ ]
		WORD	CHR70+(060H*10H)	;	   [	]
		WORD	CHR70+(060H*10H)	;	   [	]
		WORD	CHR70+(060H*10H)	;	   [	]
;
CHRTR_03	EQU	$
		LDA	FRCNT2
		AND	#0000FH
		ASL	A
		TAY
		LDA	CHRTR_03_CADR,Y
		STA	<4302H		;A bus address(L,H) set
		LDX	#BANK CHR70
		STX	<4304H		;A bus address(B) set
;
		LDA	#02F00H
		STA	2116H		;VRAM address set
		LDA	#0200H
		STA	<4305H		;number of byte set
		LDX	#00000001B
		STX	420BH		;DMA "ON"
		RTS
;
;-------------- afRAX`bN() --------------------
CHRTR_05_CADR	EQU	$
		WORD	CHR70+(080H*10H)
		WORD	CHR70+(0A0H*10H)
		WORD	CHR70+(0C0H*10H)
		WORD	CHR70+(0E0H*10H)
		WORD	CHR71+(000H*10H)
		WORD	CHR71+(020H*10H)
		WORD	CHR71+(040H*10H)
		WORD	CHR71+(060H*10H)
		WORD	CHR71+(040H*10H)
		WORD	CHR71+(020H*10H)
		WORD	CHR71+(000H*10H)
		WORD	CHR70+(0E0H*10H)
		WORD	CHR70+(0C0H*10H)
		WORD	CHR70+(0A0H*10H)
;
;
CHRTR_05	EQU	$
		LDA	!CHR_ANIME_CT
		INC	A
		CMP	#0000EH<<2
		BCC	CHRTR_05_100
		LDA	#00000
CHRTR_05_100	EQU	$
		STA	!CHR_ANIME_CT
		LSR	A
		AND	#000FEH
		TAY
CHRTR_05_SET	EQU	$
		LDA	CHRTR_05_CADR,Y
CHRTR_05_SET_SB EQU	$
		STA	<4302H		;A bus address(L,H) set
		LDX	#BANK CHR70
		STX	<4304H		;A bus address(B) set
		LDA	#02F00H
		STA	2116H		;VRAM address set
		LDA	#00200H
		STA	<4305H		;number of byte set
		LDX	#00000001B
		STX	420BH		;DMA "ON"
;
;;;;K;;;;		LDA	#01713H		; MANSEL <- 013H
;;;;K;;;;		STA	!MANSEL		; SUBSEL <- 017H
;;;;K;;;;		LDA	#07702H		; WIND30 <- 002H
;;;;K;;;;		STA	!WIND30		; SUBADF <- 077H
		RTS
;
;-------------- n`	-----------------------------------------
CHRTR_06	EQU	$
		LDA	!CHR_ANIME_TM
		CMP	#00006
		BCC	CHRTR_06_10
		STZ	!CHR_ANIME_TM
		LDA	!CHR_ANIME_CT
		INC	A
		INC	A
		AND	#00007H*2
		STA	!CHR_ANIME_CT
CHRTR_06_10	EQU	$
		LDY	!CHR_ANIME_CT
		LDA	!DSPMOD
		CMP	#0000AH		; _ueTpL] ?
		BNE	CHRTR_05_SET	;	NO -> CHRTR_05_SET
;
		LDA	CHRTR_05_CADR,Y
		STA	<4302H		;A bus address(L,H) set
		LDX	#BANK CHR70
		STX	<4304H		;A bus address(B) set
		LDA	#07F00H
		STA	2116H		;VRAM address set
		LDA	#00200H
		STA	<4305H		;number of byte set
		LDX	#00000001B
		STX	420BH		;DMA "ON"
		RTS
;
;-------------- JxR[X (n) -------------------------------
CHRTR_07_CADR0	EQU	$
		WORD	CHR34+(040H*020H)
		WORD	CHR34+(050H*020H)
		WORD	CHR34+(060H*020H)
		WORD	CHR34+(070H*020H)
		WORD	CHR119+(000H*020H)
		WORD	CHR119+(010H*020H)
		WORD	CHR119+(020H*020H)
		WORD	CHR119+(030H*020H)
;
CHRTR_07_CADR1	EQU	$
		WORD	CHR34+(048H*020H)
		WORD	CHR34+(058H*020H)
		WORD	CHR34+(068H*020H)
		WORD	CHR34+(078H*020H)
		WORD	CHR119+(008H*020H)
		WORD	CHR119+(018H*020H)
		WORD	CHR119+(028H*020H)
		WORD	CHR119+(038H*020H)
;
CHRTR_07_CADR2	EQU	$
		WORD	CHR34+(160H*020H)
		WORD	CHR34+(170H*020H)
		WORD	CHR34+(180H*020H)
		WORD	CHR34+(190H*020H)
		WORD	CHR119+(040H*020H)
		WORD	CHR119+(050H*020H)
		WORD	CHR119+(060H*020H)
		WORD	CHR119+(070H*020H)
;
CHRTR_07_CADR3	EQU	$
		WORD	CHR34+(168H*020H)
		WORD	CHR34+(178H*020H)
		WORD	CHR34+(188H*020H)
		WORD	CHR34+(198H*020H)
		WORD	CHR119+(048H*020H)
		WORD	CHR119+(058H*020H)
		WORD	CHR119+(068H*020H)
		WORD	CHR119+(078H*020H)
;
;
CHRTR_07	EQU	$
		LDA	!CHR_ANIME_TM
		CMP	#0000BH
		BCC	CHRTR_07_00
		STZ	!CHR_ANIME_TM
		LDA	!CHR_ANIME_CT
		INC	A
		AND	#00003
		STA	!CHR_ANIME_CT
CHRTR_07_00	EQU	$
		LDA	!CHR_ANIME_CT
		ASL	A
		TAY
;
		LDX	#BANK CHR34
		LDA	!BG1TYP
		CMP	#0000AH		; ؂̏邩 ?
		BNE	CHRTR_07_05	;	NO -> CHRTR_07_05
		TYA
		ORA	#00008
		TAY
		LDX	#BANK CHR119
;
CHRTR_07_05	EQU	$
		STX	<4304H		;A bus address(B) set
		LDX	#00000001B
		LDA	!FRCNT2
		AND	#00001
		BEQ	CHRTR_07_010
;
		LDA	CHRTR_07_CADR0,Y
		STA	<4302H
		LDA	#01000H
		STA	2116H		;VRAM address set
		LDA	#008H*020H
		STA	<4305H		;number of byte set
		STX	420BH		;DMA "ON"
;
		LDA	CHRTR_07_CADR1,Y
		STA	<4302H
		LDA	#01100H
		STA	2116H		;VRAM address set
		LDA	#008H*020H
		STA	<4305H		;number of byte set
		STX	420BH		;DMA "ON"
		RTS
;
CHRTR_07_010	EQU	$
		LDA	CHRTR_07_CADR2,Y
		STA	<4302H
		LDA	#01080H
		STA	2116H		;VRAM address set
		LDA	#008H*020H
		STA	<4305H		;number of byte set
		STX	420BH		;DMA "ON"
;
		LDA	CHRTR_07_CADR3,Y
		STA	<4302H
		LDA	#01180H
		STA	2116H		;VRAM address set
		LDA	#008H*020H
		STA	<4305H		;number of byte set
		STX	420BH		;DMA "ON"
		RTS
;
;-------------- R[X g -------------------------------------
CHRTR_08_CADR0	EQU	$
		WORD	CHR34+(0120H*020H)
		WORD	CHR34+(0130H*020H)
		WORD	CHR34+(0140H*020H)
		WORD	CHR34+(0150H*020H)
;
CHRTR_08_CADR1	EQU	$
		WORD	CHR34+(0128H*020H)
		WORD	CHR34+(0138H*020H)
		WORD	CHR34+(0148H*020H)
		WORD	CHR34+(0158H*020H)
;
;
CHRTR_08	EQU	$
		LDA	!CHR_ANIME_TM
		CMP	#00010H
		BCC	CHRTR_08_00
		STZ	!CHR_ANIME_TM
		LDA	!CHR_ANIME_CT
		INC	A
		AND	#00003
		STA	!CHR_ANIME_CT
CHRTR_08_00	EQU	$
		LDA	!CHR_ANIME_CT
		ASL	A
		TAY
		LDA	CHRTR_08_CADR0,Y
		STA	<4302H
		LDX	#BANK CHR34
		STX	<4304H		;A bus address(B) set
		LDA	#01000H
		STA	2116H		;VRAM address set
		LDA	#008H*020H
		STA	<4305H		;number of byte set
		LDX	#00000001B
		STX	420BH		;DMA "ON"
;
		LDA	CHRTR_08_CADR1,Y
		STA	<4302H
		LDA	#01100H
		STA	2116H		;VRAM address set
		LDA	#008H*020H
		STA	<4305H		;number of byte set
		STX	420BH		;DMA "ON"
		RTS
;
;-------------- afR  ------------------------------------
CHRTR_09	EQU	$
		LDA	!CHR_ANIME_TM
		CMP	#00009H
		BCC	CHRTR_09_100
		STZ	!CHR_ANIME_TM
		LDA	!CHR_ANIME_CT
		CLC
		ADC	#00200H
		AND	#00600H
		STA	!CHR_ANIME_CT
CHRTR_09_100	EQU	$
		LDA	#CHR3F
		CLC
		ADC	!CHR_ANIME_CT
		JMP	CHRTR_05_SET_SB
;
;-------------- afR 𒹂̌Q -----------------------------
CHRTR_0A	EQU	$
		LDA	!CHR_ANIME_TM
		CMP	#00008H
		BCC	CHRTR_0A_100
		STZ	!CHR_ANIME_TM
		LDA	!CHR_ANIME_CT
		CLC
		ADC	#00200H
		AND	#00E00H
		STA	!CHR_ANIME_CT
CHRTR_0A_100	EQU	$
		LDA	#CHR72
		CLC
		ADC	!CHR_ANIME_CT
		JMP	CHRTR_05_SET_SB
;
;-------------- afR eknvdq -----------------------------
CHRTR_0B_DAT	EQU	$
		WORD	CHR72+(000H*10H),CHR72+(020H*10H)
		WORD	CHR72+(040H*10H),CHR72+(060H*10H)
		WORD	CHR72+(080H*10H),CHR72+(0A0H*10H)
		WORD	CHR72+(0C0H*10H),CHR72+(0E0H*10H)
		WORD	CHR72+(0C0H*10H),CHR72+(0A0H*10H)
		WORD	CHR72+(080H*10H),CHR72+(060H*10H)
		WORD	CHR72+(040H*10H),CHR72+(020H*10H)
;
CHRTR_0B_CNT	EQU	$
		WORD	00010,00004,00004,00004
		WORD	00004,00004,00004,00010
		WORD	00004,00004,00004,00004
		WORD	00004,00004
;
;
CHRTR_0B	EQU	$
		LDA	!FRCNT2
		AND	#00001
		BNE	CHRTR_0B_100
		JSR	CHRTR_02
		RTS
;
CHRTR_0B_100	EQU	$
		LDA	!CHR_ANIME_CT
		AND	#0000FH
		ASL	A
		TAY
		LDA	!CHR_ANIME_TM
		CMP	CHRTR_0B_CNT,Y
		BCC	CHRTR_0B_150
		STZ	!CHR_ANIME_TM
		INC	!CHR_ANIME_CT
		LDA	!CHR_ANIME_CT
		CMP	#(CHRTR_0B-CHRTR_0B_CNT)/2
		BCC	CHRTR_0B_150
		STZ	!CHR_ANIME_CT
CHRTR_0B_150	EQU	$
		LDA	CHRTR_0B_DAT,Y
		JMP	CHRTR_05_SET_SB
;
;-------------- WOR[X  ---------------------------
CHRTR_0C_DAT0	EQU	$
		WORD	CHR34+(0100H*020H),CHR34+(0108H*020H)
		WORD	CHR34+(0110H*020H),CHR34+(0118H*020H)
		WORD	CHR34+(01A0H*020H),CHR34+(01A8H*020H)
		WORD	CHR34+(01B0H*020H),CHR34+(01B8H*020H)
		WORD	CHR34+(01A0H*020H),CHR34+(01A8H*020H)
		WORD	CHR34+(0110H*020H),CHR34+(0118H*020H)
;
CHRTR_0C_DAT1	EQU	$
		WORD	CHR34+(01C0H*020H),CHR34+(01C8H*020H)
		WORD	CHR34+(01D0H*020H),CHR34+(01D8H*020H)
		WORD	CHR34+(01E0H*020H),CHR34+(01E8H*020H)
		WORD	CHR34+(01F0H*020H),CHR34+(01F8H*020H)
		WORD	CHR34+(01E0H*020H),CHR34+(01E8H*020H)
		WORD	CHR34+(01D0H*020H),CHR34+(01D8H*020H)
;
CHRTR_0C_CMP	EQU	$
		WORD	00010H,0000CH,0000CH,00010H,0000CH,0000CH
;
;
CHRTR_0C	EQU	$
		LDX	!CHR_ANIME_CT
		LDA	!CHR_ANIME_TM
		CMP	CHRTR_0C_CMP,X
		BCC	CHRTR_0C_20
		STZ	!CHR_ANIME_TM
		LDA	!CHR_ANIME_CT
		INC	A
		INC	A
		CMP	#(CHRTR_0C_DAT1-CHRTR_0C_DAT0)/2
		BCC	CHRTR_0C_10
		LDA	#00000H
CHRTR_0C_10	EQU	$
		STA	!CHR_ANIME_CT
CHRTR_0C_20	EQU	$
		LDA	!CHR_ANIME_CT
		ASL	A
		TAY
		LDX	#BANK CHR34
		STX	<4304H		;A bus address(B) set
		LDX	#00000001B
		LDA	!FRCNT2
		AND	#00002
		BNE	CHRTR_0C_40
		LDA	CHRTR_0C_DAT0,Y
		STA	<4302H
		LDA	#01000H
		STA	2116H		;VRAM address set
		LDA	#008H*020H
		STA	<4305H		;number of byte set
		STX	420BH		;DMA "ON"
;
		LDA	CHRTR_0C_DAT0+2,Y
		STA	<4302H
		LDA	#01100H
		STA	2116H		;VRAM address set
		LDA	#008H*020H
		STA	<4305H		;number of byte set
		STX	420BH		;DMA "ON"
		RTS
;
CHRTR_0C_40	EQU	$
		LDA	CHRTR_0C_DAT1,Y
		STA	<4302H
		LDA	#01080H
		STA	2116H		;VRAM address set
		LDA	#008H*020H
		STA	<4305H		;number of byte set
		STX	420BH		;DMA "ON"
;
		LDA	CHRTR_0C_DAT1+2,Y
		STA	<4302H
		LDA	#01180H
		STA	2116H		;VRAM address set
		LDA	#008H*020H
		STA	<4305H		;number of byte set
		STX	420BH		;DMA "ON"
		RTS
;
;-------------- n`Ɨn ------------------------------------
CHRTR_0D	EQU	$
		INC	!CHR_AM_TM_SB
		LDA	!CHR_AM_TM_SB
		CMP	#00006
		BCS	CHRTR_0D_00
		JMP	CHRTR_07
;
CHRTR_0D_00	EQU	$
		STZ	!CHR_AM_TM_SB
		LDA	!CHR_AM_CT_SB
		INC	A
		INC	A
		AND	#00007H*2
		STA	!CHR_AM_CT_SB
		LDY	!CHR_AM_CT_SB
		JMP	CHRTR_05_SET
;
;-------------- n`ƃWOR[X  -------------------
CHRTR_0E	EQU	$
		INC	!CHR_AM_TM_SB
		LDA	!FRCNT2
		AND	#00001
		BEQ	CHRTR_0D_00
		JMP	CHRTR_0C
;
;-------------- afR n`pXe _ --------------------------
CHRTR_0F_DAT0	EQU	$
		WORD	CHR71+((2*8*16)*08H)
		WORD	CHR71+((2*8*16)*0AH)
		WORD	CHR71+((2*8*16)*0CH)
		WORD	CHR71+((2*8*16)*0EH)
;
;
CHRTR_0F	EQU	$
		LDA	!CHR_PAST_TM
		INC	A
		CMP	#00006
		BCC	CHRTR_0F_050
		INC	!CHR_PAST_CT
		LDA	#00000H
CHRTR_0F_050	EQU	$
		STA	!CHR_PAST_TM
		LDX	#00000001B
		LDY	!CHR_PAST_CT
		CMP	#00000H		; afR] ?
		BNE	CHRTR_0F_100	;	NO -> CHRTR_0F_100
;
		TYA
		AND	#00006H
		TAY
		LDA	CHRTR_0F_DAT0,Y
		JMP	CHRTR_05_SET_SB
;
CHRTR_0F_100	EQU	$
;
CHRTR_0F_990	EQU	$
		RTS
;
;-------------- afR {X ---------------------------------
CHRTR_10_DAT0	EQU	$
		WORD	CHR73+((2*8*16)*00H)+(2*8*0)
		WORD	CHR73+((2*8*16)*01H)+(2*8*0)
		WORD	CHR73+((2*8*16)*02H)+(2*8*0)
		WORD	CHR73+((2*8*16)*03H)+(2*8*0)
;
CHRTR_10_DAT1	EQU	$
		WORD	CHR73+((2*8*16)*00H)+(2*8*8)
		WORD	CHR73+((2*8*16)*01H)+(2*8*8)
		WORD	CHR73+((2*8*16)*02H)+(2*8*8)
		WORD	CHR73+((2*8*16)*03H)+(2*8*8)
;
;
CHRTR_10	EQU	$
		LDA	!CHR_ANIME_TM
		AND	#0000CH
		LSR	A
		TAY
		LDX	#BANK CHR73
		STX	<4304H		; A bus address(B) set
		LDA	CHRTR_10_DAT0,Y
		STA	<4302H		; A bus address(L,H) set
		LDA	#02F00H
		STA	2116H		; VRAM address set
		LDA	#2*8*8
		STA	<4305H		; number of byte set
		LDX	#00000001B
		STX	420BH		; DMA "ON"
;
		STA	<4305H		; number of byte set
		LDA	CHRTR_10_DAT1,Y
		STA	<4302H		; A bus address(L,H) set
		LDA	#02F80H
		STA	2116H		; VRAM address set
		STX	420BH		; DMA "ON"
		RTS
;
;-------------- afR_ƃWOR[X  ------------------------
CHRTR_11	EQU	$
		LDA	FRCNT2
		AND	#00003
		BNE	CHRTR_11_500
		JMP	CHRTR_03
;
CHRTR_11_500	EQU	$
		JMP	CHRTR_0C
;
;
;************************************************************************
;*		JSL type BG screen write sub ( edit mode )		*
;************************************************************************
;
BGSCWTL		EQU	$
;
		REP	#00100000B	;memory 16 bit mode
;
		PHD			;(D) save
		LDA	#4300H		;0 page set ( 4300H- )
		TCD
;
		LDA	#00000001B+(18H*100H)	;DMA parameter & B bus addres
		STA	4300H
		LDX	#00000001B	;(X) <-- DMA "ON" flag
		JSR	BGSCWT
;
		PLD			;(D) load
;
		SEP	#00100000B	;memory 8 bit mode
		RTL
;
;************************************************************************
;*		BG screen write ( edit mode )				*
;*			in  : (X) <-- DMA "ON" flag			*
;************************************************************************
;
BGSCWT		EQU	$
		LDY	#BANK BGHSCRBF	;A bus address(B) set
		STY	<4304H
;
;-------------- gXN[ ------------------------------------
		LDY	#10000001B	;inc mode set
		STY	2115H
;
;-------------- afP ------------------------------------------
		LDY	BGWHF1
		BEQ	BGSW10		;BG1 H write ? ( no:BGSW10 )
;
		LDA	#BGHSCRBF	;A bus address(L,H) set
		STA	4302H
;
		LDA	BGWAH1_0       ;VRAM address set
		STA	2116H
		LDA	#20H*2		;number of byte set
		STA	<4305H
		STX	420BH		;DMA "ON"
;
		LDA	BGWAH1_1       ;VRAM address set
		STA	2116H
		LDA	#20H*2		;number of byte set
		STA	<4305H
		STX	420BH		;DMA "ON"
;
		STZ	BGWHF1	       ;BG write end set
;
;-------------- uXN[ ------------------------------------
BGSW10		EQU	$
		LDY	#10000000B	;inc mode set
		STY	2115H
;
;-------------- afP ------------------------------------------
		LDY	BGWVF1
		BEQ	BGSW40		;BG V write ? ( no:BGSW40 )
;
		LDA	#BGVSCRBF	;A bus address(L,H) set
		STA	<4302H
;
		LDA	BGWAV1_00      ;VRAM address set
		STA	2116H
		LDA	BGWNO1_0       ;number of byte set
		STA	<4305H
		STX	420BH		;DMA "ON"
		LDA	BGWAV1_10      ;VRAM address set
		STA	2116H
		LDA	BGWNO1_1       ;number of byte set
		STA	<4305H
		STX	420BH		;DMA "ON"
;
		LDA	BGWAV1_01      ;VRAM address set
		STA	2116H
		LDA	BGWNO1_0       ;number of byte set
		STA	<4305H
		STX	420BH		;DMA "ON"
		LDA	BGWAV1_11      ;VRAM address set
		STA	2116H
		LDA	BGWNO1_1       ;number of byte set
		STA	<4305H
		STX	420BH		;DMA "ON"
;
		STZ	BGWVF1	       ;BG write end set
;
;-------------- enemy data BG write -------------------------------------
BGSW40		EQU	$
		LDA	#00000001B+(18H*100H)	; DMA parameter & B bus address set
		STA	<4300H
		LDY	#BANK B2ENWTH
		STY	<4304H		 ; A bus address(B) set
;
		LDY	B2WTHF		; BG2 write flag ON ?
		BEQ	BGSW70		;	NO -> BGSW70
		LDY	#10000001B	; inc mode set
		STY	2115H
		LDA	#B2ENWTH
		STA	<4302H		 ; A bus address(L,H) set
		LDA	B2WTADH
		STA	2116H		; VRAM address set
		LDA	#00040H
		STA	<4305H		 ; number of byte set
		STX	420BH		; DMA "ON"
		STZ	B2WTHF
;
BGSW70		EQU	$
		LDY	B2WTVF
		BEQ	BGSW80
		LDY	#10000000B	; inc mode set
		STY	2115H
		LDA	#B2ENWTV
		STA	<4302H		 ; A bus address(L,H) set
		LDA	!B2WTADV
		STA	2116H		; VRAM address set
		LDA	#00040H
		STA	<4305H		 ; number of byte set
		STX	420BH		; DMA "ON"
		STZ	B2WTVF
;
BGSW80		EQU	$
		RTS
;
;************************************************************************
;*		OBJ mode 7 chara DMA					*
;*			in  : (X) <-- DMA "ON" flag			*
;************************************************************************
;
OB7DMA		EQU	$
		LDA	OBM7WF
		BEQ	OB7DMA_050	;DMA set ? ( no:OB7DMA_050 )
;
		BPL	OB7DMA_010	;ʓ]H ( no:OB7DMA_010 )
;
		AND	#7FE0H
		STA	2116H
		LDA	#WOB7CHR+1000H	;A bus address(L,H) set
		BRA	OB7DMA_020
;
OB7DMA_010	EQU	$
		LDA	#5C00H		;VRAM address set
		STA	2116H
		LDA	#WOB7CHR	;A bus address(L,H) set
OB7DMA_020	EQU	$
		STA	<4302H
		LDY	#BANK WOB7CHR	;      "      (B) set
		STY	<4304H
		LDA	#0800H		;number of byte set
		STA	<4305H
		STX	420BH		;DMA "ON"
;
		STZ	OBM7WF
OB7DMA_050	EQU	$
		RTS
;
;************************************************************************
;*		pause chara DMA set					*
;*			in  : (X) <-- DMA "ON" flag			*
;************************************************************************
;
PASDMA		EQU	$
		LDA	#4E00H		;VRAM address set
		STA	2116H
		LDA	#WOB7CHR+(80H*20H)	;A bus address(L,H) set
		STA	<4302H
		LDY	#BANK WOB7CHR		;	"     (B) set
		STY	<4304H
		LDA	#(16*6)*20H		;number of byte set
		STA	<4305H
		STX	420BH			;DMA "ON" !!
		RTS
;
;************************************************************************
;*		massage bitmap chara DMA set				*
;*			in  : (X) <-- DMA "ON" flag			*
;************************************************************************
;
MSGDMA		EQU	$
		LDA	#3000H		;VRAM address set
		STA	2116H
		LDA	#MSGBITMP	;A bus address(L,H) set
		STA	<4302H
		LDY	#BANK MSGBITMP	;	"     (B) set
		STY	<4304H
		LDA	#0800H		;number of byte set
		STA	<4305H
		STX	420BH		;DMA "ON" !!
		RTS
;
;************************************************************************
;*		player chara DMA					*
;*			in  : (X) <-- DMA "ON" flag			*
;************************************************************************
;
PCHDMA		EQU	$
;
;-------------- player chara DMA set ----------------------------
		LDA	#04000H		;VRAM address set ( 4000H- )
		STA	2116H
;
		LDY	#0040H		;(Y) <-- number of byte data
;
		LDA	PCHNO0		;A bus address(L,H)
		STA	<4302H
		LDA	PCHNO0+2	;      "      (B)
		STA	<4304H
		STY	<4305H		;number of byte
		STX	420BH		;DMA ch "ON"
;
		LDA	PCHNO0+4	;A bus address(L,H)
		STA	<4302H
		LDA	PCHNO0+6	;      "      (B)
		STA	<4304H
		STY	<4305H		;number of byte
		STX	420BH		;DMA ch "ON"
;
		LDA	PCHNO0+8	;A bus address(L,H)
		STA	<4302H
		LDA	PCHNO0+10	;      "      (B)
		STA	<4304H
		STY	<4305H		;number of byte
		STX	420BH		;DMA ch "ON"
;
		LDA	PCHNO0+12	;A bus address(L,H)
		STA	<4302H
		LDA	PCHNO0+14	;      "      (B)
		STA	<4304H
		STY	<4305H		;number of byte
		STX	420BH		;DMA ch "ON"
;
		LDA	PCHNO0+16	;A bus address(L,H)
		STA	<4302H
		LDA	PCHNO0+18	;      "      (B)
		STA	<4304H
		STY	<4305H		;number of byte
		STX	420BH		;DMA ch "ON"
;
		LDA	PCHNO0+20	;A bus address(L,H)
		STA	<4302H
		LDA	PCHNO0+22	;      "      (B)
		STA	<4304H
		STY	<4305H		;number of byte
		STX	420BH		;DMA ch "ON"
;
;-------------- JEg_EpLN^[] --------------------
		LDA	PCHNO0+24	;A bus address(L,H)
		STA	<4302H
		LDA	PCHNO0+26	;      "      (B)
		STA	<4304H
		LDA	#0020H
		STA	<4305H		;number of byte
		STX	420BH		;DMA ch "ON"
;
		STA	<4305H		;number of byte
		LDA	PCHNO0+29	;      "      (B)
		STA	<4303H
		LDA	PCHNO0+28	;A bus address(L,H)
		STA	<4302H
		LDA	#0020H
		STX	420BH		;DMA ch "ON"
;
;-------------- vC[LN^[] ------------------------------
		LDA	#04100H		;VRAM address set ( 4100H- )
		STA	2116H
;
		LDA	PCHNO0		;A bus address(L)
		STA	<4302H
		LDA	PCHNO0+2	;      "      (H)(B)
		XBA
		STA	<4303H
		STY	<4305H		;number of byte
		STX	420BH		;DMA ch "ON"
;
		LDA	PCHNO0+4	;A bus address(L)
		STA	<4302H
		LDA	PCHNO0+6	;      "      (H)(B)
		XBA
		STA	<4303H
		STY	<4305H		;number of byte
		STX	420BH		;DMA ch "ON"
;
		LDA	PCHNO0+8	;A bus address(L)
		STA	<4302H
		LDA	PCHNO0+10	;      "      (H)(B)
		XBA
		STA	<4303H
		STY	<4305H		;number of byte
		STX	420BH		;DMA ch "ON"
;
		LDA	PCHNO0+12	;A bus address(L)
		STA	<4302H
		LDA	PCHNO0+14	;      "      (H)(B)
		XBA
		STA	<4303H
		STY	<4305H		;number of byte
		STX	420BH		;DMA ch "ON"
;
		LDA	PCHNO0+16	;A bus address(L)
		STA	<4302H
		LDA	PCHNO0+18	;      "      (H)(B)
		XBA
		STA	<4303H
		STY	<4305H		;number of byte
		STX	420BH		;DMA ch "ON"
;
		LDA	PCHNO0+20	;A bus address(L)
		STA	<4302H
		LDA	PCHNO0+22	;      "      (H)(B)
		XBA
		STA	<4303H
		STY	<4305H		;number of byte
		STX	420BH		;DMA ch "ON"
;
;-------------- JEg_EpLN^[] --------------------
		LDA	PCHNO0+24	;A bus address(L)
		STA	<4302H
		LDA	PCHNO0+26	;      "      (H)(B)
		XBA
		STA	<4303H
		LDA	#0020H
		STA	<4305H		;number of byte
		STX	420BH		;DMA ch "ON"
;
		STA	<4305H		;number of byte
		LDA	PCHNO0+28	;A bus address(L)
		STA	<4302H
		LDA	PCHNO0+30	;      "      (H)(B)
		XBA
		STA	<4303H
		STX	420BH		;DMA ch "ON"
;
;-------------- mario-baby chara DMA set ------------------------
		LDA	BABYTRF
		BEQ	PCHD010		;mario-baby chara DMA ? ( no:PCHD010 )
;
		LDA	#4620H		;VRAM address set ( 4620H- )
		STA	2116H
;
		LDA	BABYCH0		;A bus address(L,H)
		STA	<4302H
		LDA	#BANK CHR50	;      "      (B)
		STA	<4304H
		STY	<4305H		;number of byte
		STX	420BH		;DMA ch "ON"
;
		LDA	BABYCH0+4	 ;A bus address(L,H)
		STA	<4302H
		STY	<4305H		;number of byte
		STX	420BH		;DMA ch "ON"
;
		LDA	#4720H		;VRAM address set ( 4720H- )
		STA	2116H
;
		LDA	BABYCH0+2	;A bus address(L)
		STA	<4302H
		STY	<4305H		;number of byte
		STX	420BH		;DMA ch "ON"
;
		LDA	BABYCH0+6	;A bus address(L)
		STA	<4302H
		STY	<4305H		;number of byte
		STX	420BH		;DMA ch "ON"
;
		STZ	BABYTRF
;
;-------------- player spacial chara DMA set --------------------
PCHD010		EQU	$
		LDA	PCHTRF
		BEQ	PCHD020		;spacial chara DMA ? ( no:PCHD020 )
;
		STA	<4302H		;A bus address(L)
		LDY	#BANK CHR64
		STY	<4304H		;	"     (B)
		LDA	#04200H		;VRAM address set ( 4200H- )
		STA	2116H
;
		LDY	#01H		;number of byte
		STY	<4306H
		STX	420BH		;DMA ch "ON"
;
		LDA	#04300H		;VRAM address set ( 420BH- )
		STA	2116H
;
		STY	<4306H		;number of byte
		STX	420BH
;
		STZ	PCHTRF		;spacial chara DMA "OFF"
;
;
;-------------- player color set --------------------------------
PCHD020		EQU	$
;;;;		LDY	PCOLTR
;;;;		BEQ	PCHD020		;color change ? ( no:PCHD020 )
;;;;;
;;;;		LDA	!PLCOLAD,Y		;A bus address(L,H)
;;;;		STA	<4302H
;;;;		LDY	#BANK  COL_ADDRESS+PLAY_1_COL	;	"     (B)
;;;;		STY	<4304H
;;;;		LDY	#80H+51H		;C.G address set
;;;;		STY	2121H
;;;;		LDA	#00000000B+(22H*100H)	;DMA control & B bus address
;;;;		STA	<4300H
;;;;		LDA	#0FH*2			;number of byte
;;;;		STA	<4305H
;;;;		STX	420BH
;;;;;
;;;;PCHD030	    EQU	    $
		RTS
;
;************************************************************************
;*		memory DMA set						*
;*			M_DMA_BUF					*
;*			[xx],[xx],[xxx],[xxx],[xx],[xxx],[xxx]...,[00]	*
;*			 |    |	    |	  |				*
;*			 |    |	    |	  +-- ]AhX		*
;*			 |    |	    +--------	h   h		*
;*			 |    +--------------	hoCgiOŏI)	*	    *
;*			 +------------------- Zbg|C^[	*
;************************************************************************
;
		MEM16
;
MEMDMA		EQU	$
		LDA	#00000000B+(80H*100H)	;DMA parameter & B bus address set
		STA	<4300H
;
		LDY	#2
		LDA	M_DMA_BUF,Y
		BEQ	MDMA_020	;end ? ( yes:MDMA_020 )
;
MDMA_010	EQU	$
		STA	<4305H		;number of byte set
		LDA	M_DMA_BUF+2,Y
		STA	2181H		;to address set
		LDA	M_DMA_BUF+3,Y
		STA	2182H
		LDA	M_DMA_BUF+5,Y	;from address set
		STA	<4302H
		LDA	M_DMA_BUF+6,Y
		STA	<4303H
		STX	420BH		;DMA "ON"
;
		TYA
		CLC
		ADC	#8
		TAY
		LDA	M_DMA_BUF,Y
		BNE	MDMA_010	;end ? ( no:MDMA_010 )
;
		STZ	M_DMA_BUF	;next set pointer reset
		STZ	M_DMA_BUF+2	;end code set
;
MDMA_020	EQU	$
		RTS
;
		MEM8
		IDX8
;
;
;
;
;
;
		END
