;************************************************************************
;*									*
;*	title name	: "yossy map tool"				*
;*	proccess	: mario chip program				*
;*	file name	: ysm_chip0					*
;*									*
;************************************************************************
;
;
		include		../union/ysm_mram.asm
;
;
;------------------------------------------------------------------------
;-		define symbol						-
;------------------------------------------------------------------------
MPCIPCHR	EQU	560000H		;}bvrbg}bvLN^[Ah
MFCIPCHR	EQU	568000H		;H flip
;
;************************************************************************
;*									*
;*		program start						*
;*									*
;************************************************************************
;
;
Group_0		GROUP	S_chip_0
S_chip_0	SECT	REL
;
;
;************************************************************************
;*		M-chip initial set					*
;************************************************************************
CHIPINIT	EQU	$
		SUB	R0		;[ IBT R0,#0 ]
		RAMB
;
		STOP
		NOP
;
;************************************************************************
;*	f[^k					(DT_UNCOMPRESS) *
;*     mn	  @qSFf[^oNiSOg`Tegj		*
;*		  @qXF@@@@AhX				*
;*		  qPOF𓀐@AhX				*
;*									*
;*     mn qPOF𓀌  𓀐  AhX			*
;*									*
;*     mtnR0,R1,R2,R3,R4,R5,R6,R7,R9,R10,R11,R12,R13,R14,R15	*
;************************************************************************
DT_UNCOMPRESS	EQU	$
		FROM	R4
		ROMB				; b|qoNݒ
		MOVE	R14,R9			; qPSb|qAhXݒ
;
		MOVE	R9,R10			; (qX)   𓀐AhX(l)
		IWT	R5,#003FFH		;iqTj@f[^`FbNR[h
		IBT	R6,#0001FH		;iqUj@f[^`FbNR[h
		IWT	R7,#000E0H		;iqVj@f[^s`FbNR[h
		IWT	R8,#000FFH		;iqWj@f[^I`FbNR[h
		IWT	R11,#(DT_UNC000+1)	;iqPPjiloAhX
;
		CACHE				; LbV
;
DT_UNC000
		GETB				; qOqobt@
		INC	R14
		BNE	DT_UNC100+1		; moNH
;						; 
		SUB	R8
		ADD	R8
		INC	R4
		FROM	R4
		ROMB				; b|qoNZbg
		MOVE	R14,R14
DT_UNC100
		SUB	R8
		BNE	DT_UNC200		; f[^IH
;						; 
		ADD	R8
		STOP				; frtI
		NOP
;
;-----------------------------------------------; f[^`FbN
DT_UNC200
		TO	R2			; cqQ
		AND	R7			; qQf[^s
		SUB	R7
		BPL	DT_UNC300		; Pegȏf[^H
;						; 
		ADD	R7
		AND	R6			; qOif[^FPeȓj
		BRA	DT_UNC500+1
		INC	R0
;
DT_UNC300
		MOVE	R1,R0			; qO̓eqPɃZbg
		ADD	R0
		ADD	R0
		ADD	R0			; qOqOW@
		TO	R2			; cqQ
		AND	R7			; qQf[^s
;
		GETB				; qOqobt@
		INC	R14
		BNE	DT_UNC400+1		; moNH
;						; 
		WITH	R1			; rqP
		INC	R4
		FROM	R4
		ROMB				; b|qoNZbg
		MOVE	R14,R14
DT_UNC400
		WITH	R1			; rqP
		SWAP				; rik|gjcig|kj
		OR	R1
		AND	R5			; qOif[^FPeȏj
;
;-----------------------------------------------; f[^s`FbN
DT_UNC500
		INC	R0
		MOVE	R12,R0			; qPQɃf[^Zbg
		MOVES	R0,R2			; f[^s`FbN
		BEQ	DT_UNC1100		;i񋤒ʃf[^jH
;						; 
		SWAP
		BMI	DT_UNC1200		;iQƃf[^jH
;						; 
		ADD	R0
		BPL	DT_UNC1300		;iPʃf[^jH
;						; 
		ADD	R0
		BPL	DT_UNC1400		;iQʃf[^jH
;						; 
;-----------------------------------------------;ivXPf[^j
DT_UNC1000
		GETB				; qOqobt@
		INC	R14
		BNE	DT_UNC1040		; moNH
;						; 
		NOP
		INC	R4
		FROM	R4
		ROMB				; b|qoNZbg
		MOVE	R14,R14
DT_UNC1040
		MOVE	R13,R15			; frtvOJE^qPRɃZbg
;
		STB	(R10)			; b|qփf[^XgA
		INC	R0
		LOOP
		INC	R10
;
		JMP	R11			; iloicsQtmbOOO{Pj
		GETB
;
;-----------------------------------------------;i񋤒ʃf[^j
DT_UNC1100
		MOVE	R13,R15			; frtvOJE^qPRɃZbg
;
		GETB				; qOqobt@
		INC	R14
		BNE	DT_UNC1140		; moNH
;						; 
		NOP
		INC	R4
		FROM	R4
		ROMB				; b|qoNZbg
		MOVE	R14,R14
DT_UNC1140
		STB	(R10)			; b|qփf[^XgA
		LOOP
		INC	R10
;
		JMP	R11			; iloicsQtmbOOO{Pj
		GETB
;
;-----------------------------------------------;iQƃf[^j
DT_UNC1200
		WITH	R1			; cqP
		GETB				; qPqobt@
		INC	R14
		BNE	DT_UNC1220+1		; moNH
;						; 
		GETB				; qOqobt@
		INC	R4
		FROM	R4
		ROMB				; b|qoNZbg
		MOVE	R14,R14
DT_UNC1220
		GETB				; qOqobt@
		INC	R14
		BNE	DT_UNC1240+1		; moNH
;						; 
		WITH	R1			; rqP
		INC	R4
		FROM	R4
		ROMB				; b|qoNZbg
		MOVE	R14,R14
DT_UNC1240
		WITH	R1			; rqP
		SWAP				; rik|gjcig|kj
		TO	R2			; cqQ
		OR	R1			; qQQƃf[^AhX
		WITH	R2			; cqQ
		ADD	R9			; qQQƃf[^AhX
;
		MOVE	R13,R15			; frtvOJE^qPRɃZbg
;
		LDB	(R2)			; b|qf[^[h
		STB	(R10)			; b|qփf[^XgA
		INC	R2
		LOOP
		INC	R10
;
		JMP	R11			; iloicsQtmbOOO{Pj
		GETB
;
;-----------------------------------------------; iPʃf[^j
DT_UNC1300
		GETB				; qOqobt@
		INC	R14
		BNE	DT_UNC1340		; moNH
;						; 
		NOP
		INC	R4
		FROM	R4
		ROMB				; b|qoNZbg
		MOVE	R14,R14
DT_UNC1340
		MOVE	R13,R15			; frtvOJE^qPRɃZbg
;
		STB	(R10)			; b|qփf[^XgA
		LOOP
		INC	R10
;
		JMP	R11			; iloicsQtmbOOO{Pj
		GETB
;
;-----------------------------------------------; iQʃf[^j
DT_UNC1400
		INC	R14
		BNE	DT_UNC1420+1		; moNH
;						; 
		WITH	R1			; cqP
		INC	R4
		FROM	R4
		ROMB				; b|qoNZbg
		MOVE	R14,R14
DT_UNC1420
		WITH	R1			; cqP
		GETB				; qPqobt@
		INC	R14
		BNE	DT_UNC1440		; moNH
;						; 
		NOP
		INC	R4
		FROM	R4
		ROMB				; b|qoNZbg
		MOVE	R14,R14
DT_UNC1440
		MOVE	R13,R15			; frtvOJE^qPRɃZbg
;
		STB	(R10)			; b|qփf[^XgA
		INC	R10
		DEC	R12
		BEQ	DT_UNC1480		; f[^IH
;						; 
		FROM	R1
		STB	(R10)			; b|qփf[^XgA
		LOOP
		INC	R10
DT_UNC1480
		JMP	R11			; iloicsQtmbOOO{Pj
		GETB
;
;************************************************************************
;*		cos data						*
;************************************************************************
COS		EQU	$
		WORD	00100H,00100H,00100H,000FFH,000FFH,000FEH,000FDH,000FCH
		WORD	000FBH,000FAH,000F8H,000F7H,000F5H,000F3H,000F1H,000EFH
		WORD	000EDH,000EAH,000E7H,000E5H,000E2H,000DFH,000DCH,000D8H
		WORD	000D5H,000D1H,000CEH,000CAH,000C6H,000C2H,000BEH,000B9H
		WORD	000B5H,000B1H,000ACH,000A7H,000A2H,0009DH,00098H,00093H
		WORD	0008EH,00089H,00084H,0007EH,00079H,00073H,0006DH,00068H
		WORD	00062H,0005CH,00056H,00050H,0004AH,00044H,0003EH,00038H
		WORD	00032H,0002CH,00026H,0001FH,00019H,00013H,0000DH,00006H
;
SIN		EQU	$
		WORD	00000H,0FFFAH,0FFF3H,0FFEDH,0FFE7H,0FFE1H,0FFDAH,0FFD4H
		WORD	0FFCEH,0FFC8H,0FFC2H,0FFBCH,0FFB6H,0FFB0H,0FFAAH,0FFA4H
		WORD	0FF9EH,0FF98H,0FF93H,0FF8DH,0FF87H,0FF82H,0FF7CH,0FF77H
		WORD	0FF72H,0FF6DH,0FF68H,0FF63H,0FF5EH,0FF59H,0FF54H,0FF4FH
		WORD	0FF4BH,0FF47H,0FF42H,0FF3EH,0FF3AH,0FF36H,0FF32H,0FF2FH
		WORD	0FF2BH,0FF28H,0FF24H,0FF21H,0FF1EH,0FF1BH,0FF19H,0FF16H
		WORD	0FF13H,0FF11H,0FF0FH,0FF0DH,0FF0BH,0FF09H,0FF08H,0FF06H
		WORD	0FF05H,0FF04H,0FF03H,0FF02H,0FF01H,0FF01H,0FF00H,0FF00H
		WORD	0FF00H,0FF00H,0FF00H,0FF01H,0FF01H,0FF02H,0FF03H,0FF04H
		WORD	0FF05H,0FF06H,0FF08H,0FF09H,0FF0BH,0FF0DH,0FF0FH,0FF11H
		WORD	0FF13H,0FF16H,0FF19H,0FF1BH,0FF1EH,0FF21H,0FF24H,0FF28H
		WORD	0FF2BH,0FF2FH,0FF32H,0FF36H,0FF3AH,0FF3EH,0FF42H,0FF47H
		WORD	0FF4BH,0FF4FH,0FF54H,0FF59H,0FF5EH,0FF63H,0FF68H,0FF6DH
		WORD	0FF72H,0FF77H,0FF7CH,0FF82H,0FF87H,0FF8DH,0FF93H,0FF98H
		WORD	0FF9EH,0FFA4H,0FFAAH,0FFB0H,0FFB6H,0FFBCH,0FFC2H,0FFC8H
		WORD	0FFCEH,0FFD4H,0FFDAH,0FFE1H,0FFE7H,0FFEDH,0FFF3H,0FFFAH
		WORD	00000H,00006H,0000DH,00013H,00019H,0001FH,00026H,0002CH
		WORD	00032H,00038H,0003EH,00044H,0004AH,00050H,00056H,0005CH
		WORD	00062H,00068H,0006DH,00073H,00079H,0007EH,00084H,00089H
		WORD	0008EH,00093H,00098H,0009DH,000A2H,000A7H,000ACH,000B1H
		WORD	000B5H,000B9H,000BEH,000C2H,000C6H,000CAH,000CEH,000D1H
		WORD	000D5H,000D8H,000DCH,000DFH,000E2H,000E5H,000E7H,000EAH
		WORD	000EDH,000EFH,000F1H,000F3H,000F5H,000F7H,000F8H,000FAH
		WORD	000FBH,000FCH,000FDH,000FEH,000FFH,000FFH,00100H,00100H
		WORD	00100H,00100H,00100H,000FFH,000FFH,000FEH,000FDH,000FCH
		WORD	000FBH,000FAH,000F8H,000F7H,000F5H,000F3H,000F1H,000EFH
		WORD	000EDH,000EAH,000E7H,000E5H,000E2H,000DFH,000DCH,000D8H
		WORD	000D5H,000D1H,000CEH,000CAH,000C6H,000C2H,000BEH,000B9H
		WORD	000B5H,000B1H,000ACH,000A7H,000A2H,0009DH,00098H,00093H
		WORD	0008EH,00089H,00084H,0007EH,00079H,00073H,0006DH,00068H
		WORD	00062H,0005CH,00056H,00050H,0004AH,00044H,0003EH,00038H
		WORD	00032H,0002CH,00026H,0001FH,00019H,00013H,0000DH,00006H
;
;************************************************************************
;*		program start ( 32x32 )					*
;*			in  : (R14) <-- plot mode [ OBJMD73S ]		*
;************************************************************************
;
OBJMD73		EQU	$
		IBT	R14,#01H	;plot mode set
;
OBJMD73S	EQU	$
		CACHE
;
		LM	R0,OCHRADR+2	;chara data address(B)
		ROMB
;
;-------------- rotation pos calculate --------------------------
		LM	R6,OCENTX
		FROM	R6		;(R1) <-- CENTX*100H
		LOB
		TO	R1
		SWAP
		WITH	R6
		NOT
		INC	R6
		LM	R3,OMATA	;R3 <-- MATA
		FROM	R3
		LMULT
		MOVE	R9,R4		;R9  <-- SX*MATA
		LM	R5,OMATC	;R5 <-- MATC
		FROM	R5
		LMULT
		MOVE	R10,R4		;R10 <--- SX*MATC
;
		LM	R6,OCENTY
		FROM	R6		;(R2) <-- CENTY*100H
		LOB
		TO	R2
		SWAP
		WITH	R6
		NOT
		INC	R6
		LM	R0,OMATB
		TO	R11
		ASR
		LMULT
		FROM	R4
		ADD	R9
		ADD	R1
		TO	R9		;R9 <-- PX
		ADD	R11
		LM	R0,OMATD
		TO	R11
		ASR
		LMULT
		FROM	R4
		ADD	R10
		ADD	R2
		TO	R10		;R10 <-- PY
		ADD	R11
;
;-------------- plot intial set ---------------------------------
		LM	R0,OCHRADR
		LSR			;(C) <-- color mode
		BCC	OBM7300		;high bit color ? ( no:OBM7300 )
		ADD	R0		;[ ASL ]
;
		WITH	R14
		OR	#04H
OBM7300
		FROM	R14
		CMODE			;plot mode set
		MOVE	R11,R0		;R11 <-- chara data address(L,H)
;
		LM	R6,OBUFXPS	;R6 <-- plot start X pos set
		LM	R2,OBUFYPS	;R2 <--	    "     Y    "
		IWT	R13,#OBM7320
;
		IBT	R4,#32		;R4 <-- Y loop set
OBM7310
		MOVE	R1,R6		;R1 <-- plot start X pos set
		FROM	R3
		ASR
		TO	R8		;R8 <-- PX
		ADD	R9
		FROM	R5
		ASR
		TO	R7		;R7 <-- PY
		ADD	R10
		IBT	R12,#32		;X loop set
OBM7320
		MERGE
		BCC	OBM7330		;area over ? ( no:OBM7330 )
		TO	R14
;
		WITH	R8
		ADD	R3
		WITH	R7
		ADD	R5
		SUB	R0		;[ IBT	R0,#00 ]
		BRA	OBM7340
		COLOUR			;color set
;
OBM7330
		ADD	R11
;
		WITH	R8
		ADD	R3
		WITH	R7
		ADD	R5
		GETC			;color set
OBM7340
		LOOP
		PLOT			;pset
;
		LM	R0,OMATB
		TO	R9
		ADD	R9
		LM	R0,OMATD
		TO	R10
		ADD	R10
		DEC	R4
		BNE	OBM7310		;end ? ( no:OBM7310 )
		INC	R2		;Y pos +1
;
		STOP
		NOP
;
;************************************************************************
;*		normal OAM clear					*
;************************************************************************
;
OAM_CLR		EQU	$
		CACHE
;
		IBT	R0,#0F0H	;(R0)  <-- normal OAM clear Y pos data
		IWT	R1,#OAM-4+1	;(R1)  <--	"     address
		IBT	R2,#4		;(R2)  <--	    "         add data
		IWT	R12,#080H	;(R12) <-- loop no
		MOVE	R13,R15
OAMCL010
		WITH	R1
		ADD	R2
		LOOP
		STW	(R1)
;
		STOP
		NOP
;
;************************************************************************
;*		OAMCHG2							*
;************************************************************************
OAMCHG2		EQU	$
		CACHE
;
		IWT	R10,#OAMSB+80H-1	;R10 <-- COAM index
		IWT	R8,#OAMSUB+20H-1	;R8 <-- COAM sub index
		IBT	R12,#20H		;COAM sub loop set
		MOVE	R13,R15
OACG10
		LDB	(R10)
		DEC	R10
		ADD	R0		;[ ASL ]
		ADD	R0		;[ ASL ]
		TO	R1
		LDB	(R10)
		OR	R1
		DEC	R10
		ADD	R0		;[ ASL ]
		ADD	R0		;[ ASL ]
		TO	R1
		LDB	(R10)
		OR	R1
		DEC	R10
		ADD	R0		;[ ASL ]
		ADD	R0		;[ ASL ]
		TO	R1
		LDB	(R10)
		OR	R1
		DEC	R10
;
		STB	(R8)
		LOOP
		DEC	R8
;
		STOP
		NOP
;
;************************************************************************
;*		map bitmap buffer clear					*
;************************************************************************
;
MPBFCLR		EQU	$
		IWT	R1,#MPBITMAP	;(R1) <-- map bitmap buffer
		IBT	R0,#0
		IWT	R12,#4600H/2
;
		CACHE
;
		MOVE	R13,R15
MPBCL010
		STW	(R1)
		INC	R1
		LOOP
		INC	R1
;
		STOP
		NOP
;
;************************************************************************
;*		map bitmap buffer convert				*
;*			in  : (R0)  <-- convert status data address(B)	*
;*			      (R14) <--		      "            (L,H)*
;************************************************************************
;
MPBFCNV		EQU	$
		ROMB			;convert status data address(B) set
		MOVE	R14,R14		;	       "            (L,H) set
;
		IWT	R8,#280H-20H		;(R8)  <-- convert address change data
		IBT	R9,#10H			;(R9)  <-- 1 chara loop no
		IWT	R10,#MPCNVBF		;(R10)	<-- convert data set buffer
		IWT	R13,#MPBCV030
;
		CACHE
;
MPBCV010
		GETB
		INC	R14
		MOVE	R1,R0		;(R1) <-- up convert bitmap buffer pointer
		LSR
		BCS	MPBCV040	;end ? ( yes:MPBCV040 )
		WITH	R1
;
		GETBH
		INC	R14
;
		TO	R2		;(R2) <-- number of chara
		GETB
		INC	R14
;
MPBCV020
		MOVE	R12,R9
MPBCV030
		LDW	(R1)
		STW	(R10)
		INC	R1
		INC	R1
		INC	R10
		LOOP
		INC	R10
;
		WITH	R1
		ADD	R8
;
		DEC	R2
		BNE	MPBCV020+1
		MOVE	R12,R9		;[ dummy ]
;
		BRA	MPBCV010+1
		GETB			;[ dummy ]
;
MPBCV040
		STOP
		NOP
;
;************************************************************************
;*		map mode 7 pars data set				*
;************************************************************************
;
MPPARSST	EQU	$
;
;----------------------------------------------------------------
;-		cos & sin data get				-
;----------------------------------------------------------------
		IBT	R0,#BANK COS
		ROMB
;
		LM	R0,CMPANGLE
		TO	R11		;(R11) <-- angle
		ADD	R0
;
		IWT	R0,#COS
		TO	R14
		ADD	R11
		GETB
		INC	R14
		IWT	R6,#0E8H	;(R6) <-- mode 7 screen zoom flag set
		GETBH
		LMULT
		LOB
		SWAP
		WITH	R4
		HIB
		TO	R1		;(R1) <-- cos data
		OR	R4
;
		IWT	R0,#SIN
		TO	R14
		ADD	R11
		GETB
		INC	R14
		GETBH
		LMULT
		LOB
		SWAP
		WITH	R4
		HIB
		TO	R2		;(R2) <-- sin data
		OR	R4
;
;----------------------------------------------------------------
;-		mode 7 pars data calculate set			-
;----------------------------------------------------------------
MPWT0000
		IBT	R0,#BANK PARSDT
		ROMB
		IWT	R14,#PARSDT	;(R14) <-- pars data address
;
		IWT	R7,#CMPHDMAB0-2 ;(R7)  <-- X cos,sin  data set RAM pointer
		IWT	R8,#CMPHDMAB2-4 ;(R8)  <-- Y -sin,cos	  "
		IBT	R9,#6		;(R9)  <--     "      pointer add data
		IWT	R11,#PARSY	;(R11) <-- Y zoom data
;
		IBT	R12,#70H
;
		CACHE
;
		MOVE	R13,R15
MPWT0002
		GETB
		INC	R14
		INC	R7		;X cos data set RAM pointer up !!
		INC	R7
		WITH	R8
		ADD	R9
		MOVE	R6,R1		;(R6) <-- cos data
		GETBH
		INC	R14
		MOVE	R5,R0		;(R5) <-- pars data
;
		LMULT			;data x cos
		LOB
		SWAP
		WITH	R4
		HIB
		OR	R4
		STW	(R7)		;X cos data set
		INC	R7
		INC	R7
;
		MOVE	R6,R11
		LMULT
		LOB
		SWAP
		WITH	R4
		HIB
		OR	R4
		STW	(R8)		;Y cos data set
;
		MOVE	R0,R5		;(R0) <-- pars data
		MOVE	R6,R2		;(R6) <-- sin data
		LMULT			;data x cos
		LOB
		SWAP
		WITH	R4
		HIB
		OR	R4
		MOVE	R6,R0		;(R6) <-- X sin data
;
		NOT
		INC	R0
		DEC	R8
		DEC	R8
		STW	(R8)		;Y -sin data set
;
		FROM	R11
		LMULT
		LOB
		SWAP
		WITH	R4
		HIB
		OR	R4
		LOOP
		STW	(R7)		;-sin data set
;
		STOP
		NOP
;
;************************************************************************
;*		map bitmap plot						*
;************************************************************************
;
;-------------- map OBJ name --------------------------------------------
YAMA_H		EQU	01H
YAMA_M		EQU	02H
YAMA_L		EQU	03H
TOWER_T		EQU	04H
TOWER_G		EQU	05H
KAZAN		EQU	06H
SML_YAMA	EQU	07H
DAI		EQU	08H
SML_TOWER	EQU	09H
WID_TOWER	EQU	0AH
MIN_YAMA	EQU	0BH
SAKU		EQU	0CH
YANE		EQU	0DH
HOLL		EQU	0EH
TREE_1		EQU	0FH
TREE_2		EQU	10H
TREE_3		EQU	11H
TREE_4		EQU	12H
TREE_5		EQU	13H
IWA		EQU	14H
KUMO		EQU	15H
LAPUTA		EQU	16H
KEBLE		EQU	17H
KUSA		EQU	18H
FLOWER		EQU	19H
ISHI		EQU	1AH
LOPE		EQU	1BH
SMOKE_1		EQU	1CH
SMOKE_2		EQU	1DH
SMOKE_3		EQU	1EH
SMOKE_4		EQU	1FH
SMOKE_5		EQU	20H
SMOKE_6		EQU	21H
SMOKE_7		EQU	22H
KAMO_1		EQU	23H
KAMO_2		EQU	24H
KAMO_3		EQU	25H
KAMO_4		EQU	26H
KAMO_5		EQU	27H
KAMO_6		EQU	28H
KAMO_7		EQU	29H
KAMO_8		EQU	2AH
PLAYER_01	EQU	2BH
PLAYER_02	EQU	2CH
PLAYER_03	EQU	2DH
PLAYER_04	EQU	2EH
PLAYER_05	EQU	2FH
PLAYER_06	EQU	30H
PLAYER_07	EQU	31H
PLAYER_08	EQU	32H
PLAYER_09	EQU	33H
PLAYER_10	EQU	34H
PLAYER_11	EQU	35H
PLAYER_12	EQU	36H
PLAYER_13	EQU	37H
PLAYER_14	EQU	38H
PLAYER_15	EQU	39H
PLAYER_16	EQU	3AH
PLAYER_17	EQU	3BH
PLAYER_18	EQU	3CH
PLAYER_19	EQU	3DH
PLAYER_20	EQU	3EH
PLAYER_21	EQU	3FH
PLAYER_22	EQU	40H
PLAYER_23	EQU	41H
PLAYER_24	EQU	42H
PLAYER_25	EQU	43H
PLAYER_26	EQU	44H
PLAYER_27	EQU	45H
PLAYER_28	EQU	46H
PLAYER_29	EQU	47H
PLAYER_30	EQU	48H
PLAYER_31	EQU	49H
PLAYER_32	EQU	4AH
PLAYER_33	EQU	4BH
PLAYER_34	EQU	4CH
PLAYER_35	EQU	4DH
PLAYER_36	EQU	4EH
PLAYER_37	EQU	4FH
PLAYER_38	EQU	50H
PLAYER_39	EQU	51H
PLAYER_40	EQU	52H
PLAYER_41	EQU	53H
PLAYER_42	EQU	54H
PLAYER_43	EQU	55H
PLAYER_44	EQU	56H
PLAYER_45	EQU	57H
PLAYER_46	EQU	58H
PLAYER_47	EQU	59H
PLAYER_48	EQU	5AH
AYASHI_H	EQU	5BH
AYASHI_L	EQU	5CH
AYASHI_2	EQU	5DH
BIG_KINOKO	EQU	5EH
SML_KINOKO	EQU	5FH
ZENMAI		EQU	60H
BIG_CRYSTL	EQU	61H
SML_CRYSTL	EQU	62H
ISHI_T_1	EQU	63H
ISHI_T_2	EQU	64H
MIN_TOWER	EQU	65H
KINOKO_2	EQU	66H
KINOKO_3	EQU	67H
KINOKO_4	EQU	68H
KINOKO_6	EQU	69H
KINOKO_7	EQU	6AH
HOLL_MASK	EQU	6BH
AYA_WOD_L	EQU	8CH
AYA_WOD_S	EQU	8DH
IWA_L		EQU	8EH
IWA_S		EQU	8FH
J_TOWR_L	EQU	70H
J_TOWR_S	EQU	71H
GY_TOWR		EQU	72H
KUPA_TOWR	EQU	73H
BOOM_1		EQU	74H
BOOM_2		EQU	75H
BOOM_3		EQU	76H
BOOM_4		EQU	77H
BOOM_5		EQU	78H
BOOM_6		EQU	79H
BOOM_7		EQU	7AH
BOOM_8		EQU	7BH
BOOM_9		EQU	7CH
BOOM_A		EQU	7DH
HATA_01		EQU	7EH
HATA_02		EQU	7FH
HATA_03		EQU	80H
HATA_04		EQU	81H
HATA_05		EQU	82H
HATA_06		EQU	83H
HATA_07		EQU	84H
HATA_08		EQU	85H
HATA_09		EQU	86H
HATA_0A		EQU	87H
HATA_0B		EQU	88H
HATA_0C		EQU	89H
BRK_LPUT	EQU	8AH
YS_FRSH0	EQU	8BH
YS_FRSH1	EQU	8CH
YS_FRSH2	EQU	8DH
YS_FRSH3	EQU	8EH
YS_FRSH4	EQU	8FH
;
;
MPWRITE		EQU	$
;
;----------------------------------------------------------------
;-		cos & sin data get				-
;----------------------------------------------------------------
		IBT	R0,#BANK COS
		ROMB
;
		LM	R0,CMPANGLE
		TO	R11		;(R11) <-- angle
		ADD	R0
;
		IWT	R0,#COS
		TO	R14
		ADD	R11
		GETB
		INC	R14
		GETBH
		MOVE	R1,R0		;(R1) <-- cos data
;
		IWT	R0,#SIN
		TO	R14
		ADD	R11
		GETB
		INC	R14
		GETBH
		MOVE	R2,R0		;(R2) <-- sin data
;
;----------------------------------------------------------------
;-		2D convert position calculate			-
;----------------------------------------------------------------
		IBT	R0,#BANK PARSDV
		ROMB
;
		IWT	R9,#CMPOBJXPS	;(R9)  <-- point data pointer
		IWT	R10,#CMPWOBJXPS ;(R10) <-- 2D convert X,Y pos data pointer
		IWT	R11,#CMPWOBJZPS ;(R11) <--	"     Z         "
;
		LM	R12,CMPOBJSTN	;(R12) <-- number of point
;
		CACHE
;
		MOVE	R13,R15		;(R13) <-- loop address
MPWT0010
;
;-------------- position rotation -----------------------
		MOVE	R6,R1		;(R6) <-- cos data
;
		LDB	(R9)
		SEX
		INC	R9
		MOVE	R5,R0		;(R5) <-- X pos
		LMULT
		MOVE	R7,R4		;(R7) <-- (X * cos)
		LDB	(R9)
		SEX
		MOVE	R3,R0		;(R3) <-- Z pos
		LMULT
		MOVE	R8,R4		;(R8) <-- (Z * cos)
;
		MOVE	R6,R2		;(R6) <-- sin data
;
		FROM	R3
		LMULT			;(R4) <-- (Z * sin)
		FROM	R4
		ADD	R7		;(R0) <-- (X * cos) + (Z * sin)
		IWT	R14,#080H
		ADD	R14
		SWAP
		TO	R3		;(R3) <-- rotation X pos
		SEX
;
		FROM	R5
		LMULT			;(R4) <-- (X * sin)
		FROM	R8
		SUB	R4		;(R0) <-- (Z * cos) - (X * sin)
		ADD	R14
		SWAP
		SEX
		IWT	R5,#CENTZ
		ADD	R5
		STB	(R11)		;rotation Z pos set
;
;-------------- 2D pos calculate ------------------------
		ADD	R0
		IWT	R14,#PARSDV
		TO	R14		;(R14) <-- pars div data address
		ADD	R14
;
		INC	R9
		LDB	(R9)
		TO	R7		;(R7) <-- Y pos
		SEX
		BPL	MPWT0011	;chika ? ( no:MPWT0011 )
		INC	R9
;
;-------------- chika Z pos change !! -----------
		FROM	R7
		STB	(R11)
		INC	R7		;[ 0000- <-- FFFF- ]
MPWT0011
		INC	R9
;
		TO	R6		;(R6) <-- pars div data
		GETB
		INC	R14
;
		LM	R0,CMPOBJSTN
		SUB	R12
		INC	R11
		STB	(R11)		;Z pos sort index set
		INC	R11
;
		WITH	R6
		GETBH
;
		FROM	R3
		LOB
		SWAP
		FMULT
		IBT	R4,#20H
		ADD	R4
		ADD	R0		;[ ASL ]
		ADD	R0		;[ ASL ]
		SWAP
		SEX
		IBT	R4,#MPCENTX
		ADD	R4
		STB	(R10)		;2D convert X pos set
		INC	R10
;
		IWT	R0,#PARSYP
		ADD	R0		;[ ASL ]
		ADD	R0		;[ ASL ]
		FMULT
		IWT	R4,#MPCENTY
		ADC	R4
		SUB	R7
		STB	(R10)		;2D convert Y pos set
		INC	R10
;
		INC	R10
		LOOP
		INC	R10
;
;-------------- Z pos sort --------------------------------------
		IWT	R11,#CMPWORK	;(R11) <-- stack pointer
		MOVE	R12,R11		;(R12) <-- search end check data
		IWT	R1,#CMPWOBJZPS	;(R1)  <-- check start pointer
		LM	R0,CMPOBJSTN
		DEC	R0		;[-1]
		ADD	R0		;[x2]
		TO	R2		;(R2)  <--   "   end      "
		ADD	R1
;
		LDB	(R1)		;player Z pos
		DEC	R0
		SBK
MPWT0012
		MOVE	R3,R1		;(R3) <-- (R1)
		MOVE	R4,R2		;(R4) <-- (R2)
		FROM	R1
		ADD	R2
		LSR
		LSR
		ADD	R0
		TO	R5		;(R5) <-- search data
		LDB	(R0)
;
;-------------- max search ------------------------------
MPWT0014
		TO	R7		;(R7) <-- max search data
		LDB	(R3)
		FROM	R5
		SUB	R7
		BCS	MPWT0030	;max search end ? ( yes:MPWT0030 )
		INC	R3
;
MPWT0020
		INC	R3
		TO	R7		;(R7) <-- max search data
		LDB	(R3)
		FROM	R5
		SUB	R7
		BCC	MPWT0020	;max search end ? ( no:MPWT0020 )
		INC	R3
;
MPWT0030
		DEC	R3
;
;-------------- min serach ------------------------------
		LDB	(R4)
		SUB	R5
		BCS	MPWT0050	;min search end ? ( yes:MPWT0050 )
		ADD	R5
;
MPWT0040
		DEC	R4
		DEC	R4
		LDB	(R4)
		SUB	R5
		BCC	MPWT0040	;min search end ? ( no:MPWT0040 )
		ADD	R5
;
MPWT0050
		MOVE	R6,R0		;(R6) <-- min search data
;
;-------------- data change check -----------------------
		FROM	R4
		SUB	R3
		BCC	MPWT0062	;data change ? ( no:MPWT0062 )
		FROM	R7
;
		STB	(R4)
		FROM	R6
		STB	(R3)
		INC	R3
		INC	R4
		TO	R8
		LDB	(R4)
		LDB	(R3)
		STB	(R4)
		FROM	R8
		STB	(R3)
;
		INC	R3
		DEC	R4
		DEC	R4
		DEC	R4
;
MPWT0060
		FROM	R4
		SUB	R3
		BCS	MPWT0014	;next data change check ? ( yes:MPWT0014 )
MPWT0062
		FROM	R1
;
;-------------- data serach stack set check -------------
		SUB	R4
		BCS	MPWT0070	;stack set ? ( no:MPWT0070 )
		FROM	R1
;
		STW	(R11)
		INC	R11
		INC	R11
		FROM	R4
		STW	(R11)
		INC	R11
		INC	R11
;
MPWT0070
		FROM	R3
		SUB	R2
		BCS	MPWT0080	;stack set ? ( no:MPWT0080 )
		FROM	R3
;
		STW	(R11)
		INC	R11
		INC	R11
		FROM	R2
		STW	(R11)
		INC	R11
		INC	R11
MPWT0080
		DEC	R11
		FROM	R11
		SUB	R12
		BCC	MPWT0090	;sort end ? ( yes:MPWT0090 )
		DEC	R11
;
		TO	R2		;(R1) <-- check start pointer
		LDW	(R11)
		DEC	R11
		DEC	R11
		TO	R1		;(R2) <--   "   end      "
		LDW	(R11)
		BRA	MPWT0012+1
		MOVE	R3,R1		;[ dummy ]
;
;-------------- map OBJ write -----------------------------------
MPWT0090
;
;	93/07/26 angle roation delete ( then (R10) free !! )
;
		IWT	R11,#CMPSORTIDX ;(R11) <-- Z pos sort index pointer
;
		LM	R12,CMPOBJSTN	;number of point
;
		CACHE
;
		MOVE	R13,R15
MPWT0100
		IBT	R0,#BANK MPOBJDIN
		ROMB
;
		LDB	(R11)
		ADD	R0		;x4
		ADD	R0		;
		IWT	R1,#CMPWOBJXPS
		TO	R1		;(R1) <-- map OBJ 2D pos pointer
		ADD	R1
		IWT	R2,#CMPOBJTYP
		ADD	R2		;(R0) <-- map OBJ type no. pointer
		LDB	(R0)
		DEC	R0
		BPL	MPWT0102	;set ok OBJ ? ( yes:MPWT0102 )
		ADD	R0		;x2
;
		IWT	R15,#MPWT0140+1 ;[ JMP MPWT0140+1 ]
		INC	R11		;[ dummy ]
;
;-------------- OBJ set ---------------------------------
MPWT0102
		IWT	R14,#MPOBJDIN
		TO	R14		;(R14) <-- map OBJ status data index address
		ADD	R14
		GETB
		INC	R14
;
		SMS	R11,REG11	;(R11) save
		SMS	R12,REG12	;(R12) save
;
		IWT	R7,#080H	;(R7) <-- chara Y wide buffer
;
		GETBH
;
		MOVE	R14,R0		;(R14) <-- map OBJ status data address
;
		TO	R11		;(R11) <-- 2D X pos
		LDB	(R1)
		INC	R1
		TO	R2		;(R2) <-- 2D Y pos
		LDB	(R1)
;
		GETB
		INC	R14
		SBK			;(CMPWOBJYPS) <-- player VS cross check R set
		INC	R1
;
		LDW	(R1)
		LSR
		BNE	MPWT0104	;zoom size ok ? ( yes:MPWT0104 )
		TO	R6		;(R6) <-- zoom size
;
		IWT	R15,#MPWT0134	;[ JMP MPWT0134 ]
		LMS	R11,REG11	;[ dummy ]
;
MPWT0104
		ROL
		GETB			;(R0) <-- to center Y wide
		INC	R14
		SWAP
		FMULT
		TO	R2		;(R2) <-- plot start Y pos
		ADC	R2
;
		IWT	R0,#DIVBUF
		ADD	R6
		ADD	R6
		TO	R5		;(R5) <-- chara plot step
		LDW	(R0)
;
		GETB
		INC	R14
		TO	R3		;(R3) <-- chara X wide
		SWAP
		WITH	R3
		OR	R7
;
		INC	R0
MPWT0110
		LSR
		SWAP
		FMULT
		FROM	R11
		TO	R12		;(R12) <-- plot start X pos
		SUB	R0
;
		GETB
		INC	R14
		MOVE	R9,R14		;(R9) <-- (R14)
		SWAP
		TO	R7		;(R7) <-- chara Y wide
		ADD	R7
;
		TO	R4
		GETB
		INC	R14
;
		SUB	R0		;[ IBT R0,#0 ]
		MOVE	R8,R0		;(R8) <-- plot mode
;
		WITH	R4
		GETBH
;
		IBT	R0,#BANK MPCIPCHR	;chara data address(B) set
		ROMB
;
		FROM	R4
		LSR
		BCC	MPWT0112	;high bit color ? ( no:MPWT0112 )
		ADD	R0		;[ ASL ]
;
		IBT	R8,#04H
MPWT0112
		FROM	R8
		CMODE			;plot mode set
		MOVES	R4,R0		;(R4)  <-- chara data address
		BPL	MPWT0120+1	;H flip ? ( no:MPWT0120+1 )
;
;-------------- H flip chara data plot ----------
		MOVE	R1,R12		;[ to not H flip quit !! ]
;
		ADD	R0
		TO	R4		;(R4)  <-- chara data address
		LSR
		BEQ	MPWT0118	;<<spacial plot>> ? ( yes:MPWT118 )
		SUB	R0		;[ spacial plot quit !! ]
;
MPWT0114
		MOVE	R1,R12		;(R1) <-- plot start X pos
		IWT	R8,#080H	;(R8) <-- chara X wide
MPWT0116
		MERGE
		TO	R14		;(R14) <-- chara data address
		ADD	R4
;
		WITH	R8
		ADD	R5		;(N) <-- end flag
		FROM	R3
		SUB	R8
;
		GETC			;color get
		BPL	MPWT0116
		PLOT			;plot
;
		WITH	R7
		SUB	R5
		BPL	MPWT0114
		DEC	R2		;Y pos up !!
;
		BRA	MPWT0132+1
		IBT	R0,#BANK MPOBJDIN	;[ dummy ]
;
;-------------- spacial plot !! -----------------
MPWT0118
;;;;		    SUB	    R0		    ;[ IBT R0,#0 ]
		COLOUR			;plot color set ( nuki )
		INC	R0		;[ IBT R0,#01H ]
		CMODE			;plot mode set
MPWT01182
		MOVE	R1,R12		;(R1) <-- plot start X pos
		MOVE	R8,R3		;(R8) <-- chara X wide
MPWT01184
		MERGE
		TO	R14		;(R14) <-- chara data address
		ADD	R4
;
		WITH	R8
		SUB	R5
;
		GETB
		AND	#0FH
		BEQ	MPWT01186	;plot ? ( no:MPWT01186 )
		INC	R1
;
		DEC	R1
		PLOT			;plot
MPWT01186
		MOVES	R8,R8
		BPL	MPWT01184+1
		MERGE			;[ dummy ]
;
		WITH	R7
		SUB	R5
		BPL	MPWT01182
		DEC	R2		;Y pos up !!
;
		BRA	MPWT0132+1
		IBT	R0,#BANK MPOBJDIN	;[ dummy ]
;
;-------------- chara data plot -----------------
MPWT0120
		MOVE	R1,R12		;(R1) <-- plot start X pos
		MOVE	R8,R3		;(R8) <-- chara X wide
MPWT0130
		MERGE
		TO	R14		;(R14) <-- chara data address
		ADD	R4
;
		WITH	R8
		SUB	R5		;(N) <-- end flag
;
		GETC			;color get
		BPL	MPWT0130
		PLOT			;plot
;
		WITH	R7
		SUB	R5
		BPL	MPWT0120
		DEC	R2		;Y pos up !!
;
;-------------- next chara set check ------------
MPWT0132
		IBT	R0,#BANK MPOBJDIN
		ROMB
;
		MOVE	R14,R9		;(R14) <-- next status data address
		INC	R14
		INC	R14
		GETB
		INC	R14
		TO	R3		;(R3) <-- chara X wide
		SWAP
		BMI	MPWT0134	;next data nothing ? ( yes:MPWT0134 )
		INC	R0
;
		IWT	R15,#MPWT0110+1 ;[ JMP MPWT0110+1 ]
		LSR			;[ dummy ]
;
MPWT0134
		LMS	R11,REG11	;(R11) load
		LMS	R12,REG12	;(R12) load
;
MPWT0140
		INC	R11
		LOOP
		INC	R11
;
;-------------- last plot cancel ------------------------
		INC	R2
		RPIX
;
;
;-------------- player VS cross check ---------------------------
		IWT	R1,#CMPMVTYP	;(R1)  <-- map OBJ type no. pointer
		IWT	R2,#CMPMVXPS	;(R2)  <--    "    X pos pointer
		IWT	R5,#CMPMVYPS	;(R5)  <--    "    Y      "
		IWT	R3,#CMPWMVYPS	;(R3)  <--    "    cross check R pointer
		LM	R0,CMPPLXPOS
		HIB
		TO	R10		;(R10) <--  "  player X pos
		SEX
		LM	R0,CMPPLZPOS
		HIB
		TO	R11		;(R11) <--	"     Z  "
		SEX
;
		LM	R12,CMPOBJSTN
		DEC	R12
;
		CACHE
;
		MOVE	R13,R15
MPWT0150
		LDB	(R1)
		DEC	R0
		BMI	MPWT0160	;check ok ? ( no:MPWT0160 )
		NOP
;
;;;;		LDB	(R5)
;;;;		DEC	R0
;;;;		BPL	MPWT0160	;Y pos cross ok ? ( no:MPWT0160 )
;;;;		NOP
;
		LDB	(R3)
		MOVES	R6,R0
		BEQ	MPWT0160	;cross check ok ? ( no:MPWT0160 )
		NOP
;
		LMULT
		MOVE	R7,R4		;(R7) <-- cross check R * R
;
		LDB	(R2)
		SEX
		SUB	R10
		MOVE	R8,R0		;(R8) <-- SX
		MOVE	R6,R0
		LMULT			;(R4) <-- SX * SX
		WITH	R7
		SUB	R4
		BCC	MPWT0170	;cross ? ( no:MPWT0170 )
		INC	R2
;
		MOVE	R14,R4		;(R14) <-- SX * SX
		LDB	(R2)
		SEX
		SUB	R11
		MOVE	R9,R0		;(R9) <-- SZ
		MOVE	R6,R0
		LMULT			;(R4) <-- SZ * SZ
		FROM	R4
		SUB	R7
		BCS	MPWT0170+1	;cross ? ( no:MPWT0170+1 )
		INC	R2
;
		BRA	MPWT0180
		WITH	R14		;(R14) <-- ( SX * SX ) + ( SZ * SZ )
;
MPWT0160
		INC	R2
MPWT0170
		INC	R2
		INC	R2
		IBT	R0,#4
		TO	R1
		ADD	R1
		TO	R5
		ADD	R5
		TO	R3
		ADD	R3
		LOOP
		INC	R2
;
		STOP
		NOP
;
;-------------- cross !! --------------------------------
MPWT0180
;;;;		WITH	R14		;(R14) <-- ( SX * SX ) + ( SZ * SZ )
		ADD	R4
;
		LDB	(R1)
		SUB	#HOLL
		BNE	MPWT0182	;holl in ? ( no:MPWT0182 )
		SUB	R0		;(R0)  <-- calculate work
;
;-------------- holl in !! ----------------------
		LM	R0,CMPLMODE
		SUB	#0
		BNE	MPWT0181	;now holl in ? ( yes:MPWT0181 )
		INC	R0
;
		INC	R0
		SBK
MPWT0181
		STOP
		NOP
;
;-------------- player hosei ----------------------------
;
;-------------- sqr -----------------------------
MPWT0182
;;;;		SUB	R0		;(R0)  <-- calculate work
		MOVE	R6,R0		;(R6)  <-- root result
		IBT	R5,#2		;(R5)  <-- add data
		IBT	R12,#8+8	;(R12) <-- loop no.
		IWT	R13,#MPWT0190+1
MPWT0190
		WITH	R6		;[ ASL R6  ]
		ADD	R6
		WITH	R14		;[ ASL R14 ]
		ADD	R14
		ROL			;[ ROL R0  ]
		WITH	R14		;[ ASL R14 ]
		ADD	R14
		ROL			;[ ROL R0  ]
;
		TO	R1
		SBC	R6
		BCC	MPWT0200
		WITH	R6
;
		ADD	R5
		MOVE	R0,R1
MPWT0200
		LOOP
		WITH	R6
;
		LSR
;
		LDB	(R3)		;(R0) <-- cross check R
		ADD	R0		;x2
		IWT	R3,#DIVBUF
		ADD	R3
		LDW	(R0)
		FMULT
		ADD	R0		;x2
		ADD	R3
		TO	R6		;(R6) <-- hosei mult data
		LDW	(R0)
;
		FROM	R9
		SEX
		SWAP
		FMULT
		MOVE	R1,R0
		HIB
		SEX			;(R0) <-- integer add data
		TO	R1
		ADC	R1
		DEC	R2
		LDB	(R2)
		SEX
		SUB	R1
		SWAP
;;;;		SM	R0,CMPPLZPOS
;
		FROM	R8
		SEX
		SWAP
		FMULT
		MOVE	R1,R0
		HIB
		SEX			;(R0) <-- integer add data
		TO	R1
		ADC	R1
		DEC	R2
		LDB	(R2)
		SEX
		SUB	R1
		SWAP
;;;;		SM	R0,CMPPLXPOS
;
		STOP
		NOP
;
;------------------------------------------------------------------------
;-		map OBJ data						-
;------------------------------------------------------------------------
MPOBJDIN	EQU	$		;[MPOBJTYP]
		WORD	MPOBJDT01	;[01] yama.H
		WORD	MPOBJDT02	;[02]	" .M
		WORD	MPOBJDT03	;[03]	" .L
		WORD	MPOBJDT04	;[04] tower( tea )
		WORD	MPOBJDT05	;[05]	"  ( gray )
		WORD	MPOBJDT06	;[06] kazan
		WORD	MPOBJDT07	;[07] small yama
		WORD	MPOBJDT08	;[08] dai
		WORD	MPOBJDT09	;[09] small tower
		WORD	MPOBJDT0A	;[0A] wide tower
		WORD	MPOBJDT0B	;[0B] mini yama
		WORD	MPOBJDT0C	;[0C] saku
		WORD	MPOBJDT0D	;[0D] yane
		WORD	MPOBJDT0E	;[0E] holl
		WORD	MPOBJDT0F	;[0F] tree.1
		WORD	MPOBJDT10	;[10]	" .2
		WORD	MPOBJDT11	;[11]	" .3
		WORD	MPOBJDT12	;[12]	" .4
		WORD	MPOBJDT13	;[13]	" .5
		WORD	MPOBJDT14	;[14] iwa
		WORD	MPOBJDT15	;[15] kumo
		WORD	MPOBJDT16	;[16] laputa
		WORD	MPOBJDT17	;[17] keble
		WORD	MPOBJDT18	;[18] kusa
		WORD	MPOBJDT19	;[19] flower
		WORD	MPOBJDT1A	;[1A] ishi
		WORD	MPOBJDT1B	;[1B] lope
		WORD	MPOBJDT1C	;[1C] kazan smoke.1
		WORD	MPOBJDT1D	;[1D]	   "     .2
		WORD	MPOBJDT1E	;[1E]	   "     .3
		WORD	MPOBJDT1F	;[1F]	   "     .4
		WORD	MPOBJDT20	;[20]	   "     .5
		WORD	MPOBJDT21	;[21]	   "     .6
		WORD	MPOBJDT22	;[22]	   "     .7
		WORD	MPOBJDT23	;[23] kamome.1
		WORD	MPOBJDT24	;[24]	 "  .2
		WORD	MPOBJDT25	;[25]	 "  .3
		WORD	MPOBJDT26	;[26]	 "  .4
		WORD	MPOBJDT27	;[27]	 "  .5
		WORD	MPOBJDT28	;[28]	 "  .6
		WORD	MPOBJDT29	;[29]	 "  .7
		WORD	MPOBJDT2A	;[2A]	 "  .8
		WORD	MPOBJDT2B	;[2B] player.1
		WORD	MPOBJDT2C	;[2C]	 "  .2
		WORD	MPOBJDT2D	;[2D]	 "  .3
		WORD	MPOBJDT2E	;[2E]	 "  .4
		WORD	MPOBJDT2F	;[2F]	 "  .5
		WORD	MPOBJDT30	;[30]	 "  .6
		WORD	MPOBJDT31	;[31]	 "  .7
		WORD	MPOBJDT32	;[32]	 "  .8
		WORD	MPOBJDT33	;[33]	 "  .9
		WORD	MPOBJDT34	;[34]	 "  .10
		WORD	MPOBJDT35	;[35]	 "  .11
		WORD	MPOBJDT36	;[36]	 "  .12
		WORD	MPOBJDT37	;[37]	 "  .13
		WORD	MPOBJDT38	;[38]	 "  .14
		WORD	MPOBJDT39	;[39]	 "  .15
		WORD	MPOBJDT3A	;[3A]	 "  .16
		WORD	MPOBJDT3B	;[3B]	 "  .17
		WORD	MPOBJDT3C	;[3C]	 "  .18
		WORD	MPOBJDT3D	;[3D]	 "  .19
		WORD	MPOBJDT3E	;[3E]	 "  .20
		WORD	MPOBJDT3F	;[3F]	 "  .21
		WORD	MPOBJDT40	;[40]	 "  .22
		WORD	MPOBJDT41	;[41]	 "  .23
		WORD	MPOBJDT42	;[42]	 "  .24
		WORD	MPOBJDT43	;[43]	 "  .25
		WORD	MPOBJDT44	;[44]	 "  .26
		WORD	MPOBJDT45	;[45]	 "  .27
		WORD	MPOBJDT46	;[46]	 "  .28
		WORD	MPOBJDT47	;[47]	 "  .29
		WORD	MPOBJDT48	;[48]	 "  .30
		WORD	MPOBJDT49	;[49]	 "  .31
		WORD	MPOBJDT4A	;[4A]	 "  .32
		WORD	MPOBJDT4B	;[2B]	 "  .33
		WORD	MPOBJDT4C	;[4C]	 "  .34
		WORD	MPOBJDT4D	;[4D]	 "  .35
		WORD	MPOBJDT4E	;[4E]	 "  .36
		WORD	MPOBJDT4F	;[4F]	 "  .37
		WORD	MPOBJDT50	;[50]	 "  .38
		WORD	MPOBJDT51	;[51]	 "  .39
		WORD	MPOBJDT52	;[52]	 "  .40
		WORD	MPOBJDT53	;[53]	 "  .41
		WORD	MPOBJDT54	;[54]	 "  .42
		WORD	MPOBJDT55	;[55]	 "  .43
		WORD	MPOBJDT56	;[56]	 "  .44
		WORD	MPOBJDT57	;[57]	 "  .45
		WORD	MPOBJDT58	;[58]	 "  .46
		WORD	MPOBJDT59	;[59]	 "  .47
		WORD	MPOBJDT5A	;[5A]	 "  .48
		WORD	MPOBJDT5B	;[5B] ayashii.H
		WORD	MPOBJDT5C	;[5C]	 "   .L
		WORD	MPOBJDT5D	;[5D]	 "   .2
		WORD	MPOBJDT5E	;[5E] big   kinoko
		WORD	MPOBJDT5F	;[5F] small    "
		WORD	MPOBJDT60	;[60] zenmai
		WORD	MPOBJDT61	;[61] big   crystal
		WORD	MPOBJDT62	;[62] small    "
		WORD	MPOBJDT63	;[63] ishi (tea).1
		WORD	MPOBJDT64	;[64]	   "    .2
		WORD	MPOBJDT65	;[65] mini tower
		WORD	MPOBJDT66	;[66] high kinoko.2
		WORD	MPOBJDT67	;[67]	    "    .3
		WORD	MPOBJDT68	;[68]	    "    .4
		WORD	MPOBJDT69	;[69]	    "    .6
		WORD	MPOBJDT6A	;[6A]	    "    .7
		WORD	MPOBJDT6B	;[6B] holl mask
		WORD	MPOBJDT6C	;[6C] d ()
		WORD	MPOBJDT6D	;[6D] d ()
		WORD	MPOBJDT6E	;[6E] ()
		WORD	MPOBJDT6F	;[6F] ()
		WORD	MPOBJDT70	;[70] WO̓ ()
		WORD	MPOBJDT71	;[71]	"	"    ()
		WORD	MPOBJDT72	;[72] O[̓
		WORD	MPOBJDT73	;[73] Nbp
		WORD	MPOBJDT74	;[74] Aj[Vm.P
		WORD	MPOBJDT75	;[75]	"	"	m.Q
		WORD	MPOBJDT76	;[76]	"	"	m.R
		WORD	MPOBJDT77	;[77]	"	"	m.S
		WORD	MPOBJDT78	;[78]	"	"	m.T
		WORD	MPOBJDT79	;[79]	"	"	m.U
		WORD	MPOBJDT7A	;[7A]	"	"	m.V
		WORD	MPOBJDT7B	;[7B]	"	"	m.W
		WORD	MPOBJDT7C	;[7C]	"	"	m.X
		WORD	MPOBJDT7D	;[7D]	"	"	m.`
		WORD	MPOBJDT7E	;[7E] ͂߂ Aj[V m.P
		WORD	MPOBJDT7F	;[7F]	"	"	"	m.Q
		WORD	MPOBJDT80	;[80]	"	"	"	m.R
		WORD	MPOBJDT81	;[81]	"	"	"	m.S
		WORD	MPOBJDT82	;[82]	"	"	"	m.T
		WORD	MPOBJDT83	;[83]	"	"	"	m.U
		WORD	MPOBJDT84	;[84]	"	"	"	m.V
		WORD	MPOBJDT85	;[85]	"	"	"	m.W
		WORD	MPOBJDT86	;[86]	"	"	"	m.X
		WORD	MPOBJDT87	;[87]	"	"	"	m.`
		WORD	MPOBJDT88	;[88]	"	"	"	m.a
		WORD	MPOBJDT89	;[89]	"	"	"	m.b
		WORD	MPOBJDT8A	;[8A] j󂵂̓V
		WORD	MPOBJDT8B	;[8B] bV[ tbV m.O
		WORD	MPOBJDT8C	;[8C]	"	"	  m.P
		WORD	MPOBJDT8D	;[8D]	"	"	  m.Q
		WORD	MPOBJDT8E	;[8E]	"	"	  m.R
		WORD	MPOBJDT8F	;[8F]	"	"	  m.S
;
MPOBJDT01	EQU	$	;[ yama.H ]
;			[VS player cross check R ( 0:not cross ) ]
;			[to center Y wide]
;			[X wide],[Y wide]
;			[chara address]
		BYTE	02EH/2
		BYTE	006H
		BYTE	028H-1,01CH-1
		WORD	MPCIPCHR+0400H
		BYTE	028H-1,017H-1
		WORD	MPCIPCHR+0400H
		BYTE	028H-1,010H-1
		WORD	MPCIPCHR+1880H
		BYTE	028H-1,018H-1
		WORD	MPCIPCHR+0080H
		BYTE	008H-1,009H-1
		WORD	MPCIPCHR+3641H
		BYTE	0FFH
;
MPOBJDT02	EQU	$	;[ yama.M ]
		BYTE	02EH/2
		BYTE	006H
		BYTE	028H-1,01CH-1
		WORD	MPCIPCHR+0400H
		BYTE	028H-1,008H-1
		WORD	MPCIPCHR+0400H
		BYTE	028H-1,010H-1
		WORD	MPCIPCHR+1880H
		BYTE	028H-1,018H-1
		WORD	MPCIPCHR+0080H
		BYTE	0FFH
;
MPOBJDT03	EQU	$	;[ yama.L ]
		BYTE	02EH/2
		BYTE	006H
		BYTE	028H-1,018H-1
		WORD	MPCIPCHR+0800H
		BYTE	028H-1,010H-1
		WORD	MPCIPCHR+1880H
		BYTE	028H-1,018H-1
		WORD	MPCIPCHR+0080H
		BYTE	0FFH
;
MPOBJDT04	EQU	$	;[ tower( tea ) ]
		BYTE	012H/2
		BYTE	002H
		BYTE	010H-1,020H-1
		WORD	MFCIPCHR+00B0H
		BYTE	0FFH
;
MPOBJDT05	EQU	$	;[ tower( gray ) ]
		BYTE	016H/2
		BYTE	003H
		BYTE	010H-1,020H-1
		WORD	MFCIPCHR+00D0H
		BYTE	0FFH
;
MPOBJDT06	EQU	$	;[ kazan ]
		BYTE	024H/2
		BYTE	007H
		BYTE	020H-1,020H-1
		WORD	MFCIPCHR+00C1H
		BYTE	0FFH
;
MPOBJDT07	EQU	$	;[ small yama ]
		BYTE	024H/2
		BYTE	005H
		BYTE	020H-1,01BH-1
		WORD	MFCIPCHR+0081H
		BYTE	0FFH
;
MPOBJDT08	EQU	$	;[ dai ]
		BYTE	024H/2
		BYTE	006H
		BYTE	020H-1,020H-1
		WORD	MPCIPCHR+0021H
		BYTE	0FFH
;
MPOBJDT09	EQU	$	;[ small tower ]
		BYTE	00EH/2
		BYTE	001H
		BYTE	008H-1,010H-1
		WORD	MFCIPCHR+0051H
		BYTE	0FFH
;
MPOBJDT0A	EQU	$	;[ wide tower ]
		BYTE	016H/2
		BYTE	002H
		BYTE	010H-1,010H-1
		WORD	MFCIPCHR+2071H
		BYTE	0FFH
;
MPOBJDT0B	EQU	$	;[ mini yama ]
		BYTE	012H/2
		BYTE	003H
		BYTE	010H-1,00DH-1
		WORD	MFCIPCHR+0041H
		BYTE	0FFH
;
MPOBJDT0C	EQU	$	;[ saku ]
		BYTE	008H/2
		BYTE	000H
		BYTE	004H-1,004H-1
		WORD	MPCIPCHR+1B61H
		BYTE	0FFH
;
MPOBJDT0D	EQU	$	;[ yorozuya ]
		BYTE	010H/2
		BYTE	002H
		BYTE	010H-1,010H-1
		WORD	MFCIPCHR+2061H
		BYTE	0FFH
;
MPOBJDT0E	EQU	$	;[ holl ]
		BYTE	018H/2
		BYTE	003H
		BYTE	020H-1,008H-1
		WORD	MPCIPCHR+5801H
		BYTE	0FFH
;
MPOBJDT0F	EQU	$	;[ tree.1 ]
		BYTE	00EH/2
		BYTE	000H
		BYTE	010H-1,010H-1
		WORD	MPCIPCHR+30B1H
		BYTE	0FFH
;
MPOBJDT10	EQU	$	;[ tree.2 ]
		BYTE	00CH/2
		BYTE	000H
		BYTE	010H-1,010H-1
		WORD	MPCIPCHR+20F0H
		BYTE	0FFH
;
MPOBJDT11	EQU	$	;[ tree.3 ]
		BYTE	008H/2
		BYTE	000H
		BYTE	008H-1,00DH-1
		WORD	MPCIPCHR+0071H
		BYTE	0FFH
;
MPOBJDT12	EQU	$	;[ tree.4 ]
		BYTE	008H/2
		BYTE	000H
		BYTE	009H-1,00AH-1
		WORD	MPCIPCHR+0E71H
		BYTE	0FFH
;
MPOBJDT13	EQU	$	;[ tree.5 ]
		BYTE	00EH/2
		BYTE	000H
		BYTE	00FH-1,01BH-1
		WORD	MPCIPCHR+0061H
		BYTE	0FFH
;
MPOBJDT14	EQU	$	;[ iwa ]
		BYTE	012H/2
		BYTE	002H
		BYTE	010H-1,010H-1
		WORD	MFCIPCHR+20E0H
		BYTE	0FFH
;
MPOBJDT15	EQU	$	;[ kumo ]
		BYTE	000H/2
		BYTE	008H
		BYTE	018H-1,00FH-1
		WORD	MPCIPCHR+30E0H
		BYTE	0FFH
;
MPOBJDT16	EQU	$	;[ laputa ]
		BYTE	000H/2
		BYTE	00AH
		BYTE	020H-1,018H-1
		WORD	MPCIPCHR+00E0H
		BYTE	0FFH
;
MPOBJDT17	EQU	$	;[ keble ]
		BYTE	000H/2
		BYTE	008H
		BYTE	007H-1,009H-1
		WORD	MPCIPCHR+1779H
		BYTE	0FFH
;
MPOBJDT18	EQU	$	;[ kusa ]
		BYTE	000H/2
		BYTE	000H
		BYTE	007H-1,004H-1
		WORD	MPCIPCHR+1B65H
		BYTE	0FFH
;
MPOBJDT19	EQU	$	;[ flower ]
		BYTE	000H/2
		BYTE	000H
		BYTE	005H-1,006H-1
		WORD	MPCIPCHR+007BH
		BYTE	0FFH
;
MPOBJDT1A	EQU	$	;[ ishi ]
		BYTE	00CH/2
		BYTE	001H
		BYTE	006H-1,006H-1
		WORD	MPCIPCHR+067BH
		BYTE	0FFH
;
MPOBJDT1B	EQU	$	;[ lope ]
		BYTE	000H/2
		BYTE	001H
		BYTE	003H-1,003H-1
		WORD	MPCIPCHR+0C7BH
		BYTE	0FFH
;
MPOBJDT1C	EQU	$	;[ kazan smoke.1 ]
		BYTE	000H/2
		BYTE	000H
		BYTE	004H-1,003H-1
		WORD	MPCIPCHR+1A41H
		BYTE	0FFH
;
MPOBJDT1D	EQU	$	;[ kazan smoke.2 ]
		BYTE	000H/2
		BYTE	001H
		BYTE	006H-1,005H-1
		WORD	MPCIPCHR+1A45H
		BYTE	0FFH
;
MPOBJDT1E	EQU	$	;[ kazan smoke.3 ]
		BYTE	000H/2
		BYTE	002H
		BYTE	008H-1,007H-1
		WORD	MPCIPCHR+1A4BH
		BYTE	0FFH
;
MPOBJDT1F	EQU	$	;[ kazan smoke.4 ]
		BYTE	000H/2
		BYTE	002H
		BYTE	008H-1,007H-1
		WORD	MPCIPCHR+1A53H
		BYTE	0FFH
;
MPOBJDT20	EQU	$	;[ kazan smoke.5 ]
		BYTE	000H/2
		BYTE	002H
		BYTE	008H-1,007H-1
		WORD	MPCIPCHR+2141H
		BYTE	0FFH
;
MPOBJDT21	EQU	$	;[ kazan smoke.6 ]
		BYTE	000H/2
		BYTE	002H
		BYTE	008H-1,007H-1
		WORD	MPCIPCHR+2149H
		BYTE	0FFH
;
MPOBJDT22	EQU	$	;[ kazan smoke.7 ]
		BYTE	000H/2
		BYTE	002H
		BYTE	008H-1,007H-1
		WORD	MPCIPCHR+2151H
		BYTE	0FFH
;
MPOBJDT23	EQU	$	;[ kamome.1 ]
		BYTE	000H/2
		BYTE	000H
		BYTE	008H-1,008H-1
		WORD	MPCIPCHR+18E0H
		BYTE	0FFH
;
MPOBJDT24	EQU	$	;[ kamome.2 ]
		BYTE	000H/2
		BYTE	000H
		BYTE	008H-1,008H-1
		WORD	MPCIPCHR+18E8H
		BYTE	0FFH
;
MPOBJDT25	EQU	$	;[ kamome.3 ]
		BYTE	000H/2
		BYTE	000H
		BYTE	008H-1,008H-1
		WORD	MPCIPCHR+18F0H
		BYTE	0FFH
;
MPOBJDT26	EQU	$	;[ kamome.4 ]
		BYTE	000H/2
		BYTE	000H
		BYTE	008H-1,008H-1
		WORD	MPCIPCHR+18F8H
		BYTE	0FFH
;
MPOBJDT27	EQU	$	;[ kamome.5 ]
		BYTE	000H/2
		BYTE	000H
		BYTE	008H-1,008H-1
		WORD	MPCIPCHR+2841H
		BYTE	0FFH
;
MPOBJDT28	EQU	$	;[ kamome.6 ]
		BYTE	000H/2
		BYTE	000H
		BYTE	008H-1,008H-1
		WORD	MPCIPCHR+2849H
		BYTE	0FFH
;
MPOBJDT29	EQU	$	;[ kamome.7 ]
		BYTE	000H/2
		BYTE	000H
		BYTE	008H-1,008H-1
		WORD	MPCIPCHR+2851H
		BYTE	0FFH
;
MPOBJDT2A	EQU	$	;[ kamome.8 ]
		BYTE	000H/2
		BYTE	000H
		BYTE	008H-1,008H-1
		WORD	MPCIPCHR+2859H
		BYTE	0FFH
;
MPOBJDT2B	EQU	$	;[ player.1 ( <right> : stop ) ]
		BYTE	000H/2
		BYTE	000H
		BYTE	008H-1,008H-1
		WORD	MFCIPCHR+20F1H
		BYTE	0FFH
;
MPOBJDT2C	EQU	$	;[ player.2 ( <right> : walk.1 ) ]
		BYTE	000H/2
		BYTE	000H
		BYTE	00AH-1,008H-1
		WORD	MFCIPCHR+00EBH
		BYTE	0FFH
;
MPOBJDT2D	EQU	$	;[ player.3 ( <right> : walk.2 ) ]
		BYTE	000H/2
		BYTE	000H
		BYTE	00AH-1,008H-1
		WORD	MFCIPCHR+08EBH
		BYTE	0FFH
;
MPOBJDT2E	EQU	$	;[ player.4 ( <right> : walk.3 ) ]
		BYTE	000H/2
		BYTE	000H
		BYTE	00AH-1,008H-1
		WORD	MFCIPCHR+10EBH
		BYTE	0FFH
;
MPOBJDT2F	EQU	$	;[ player.5 ( <right> : walk.4 ) ]
		BYTE	000H/2
		BYTE	000H
		BYTE	00AH-1,008H-1
		WORD	MFCIPCHR+18EBH
		BYTE	0FFH
;
MPOBJDT30	EQU	$	;[ player.6 ( <up right> : stop ) ]
		BYTE	000H/2
		BYTE	000H
		BYTE	008H-1,008H-1
		WORD	MFCIPCHR+2059H
		BYTE	0FFH
;
MPOBJDT31	EQU	$	;[ player.7 ( <up right> : walk.1 ) ]
		BYTE	000H/2
		BYTE	000H
		BYTE	009H-1,008H-1
		WORD	MFCIPCHR+00E1H
		BYTE	0FFH
;
MPOBJDT32	EQU	$	;[ player.8 ( <up right> : walk.2 ) ]
		BYTE	000H/2
		BYTE	000H
		BYTE	009H-1,008H-1
		WORD	MFCIPCHR+08E1H
		BYTE	0FFH
;
MPOBJDT33	EQU	$	;[ player.9 ( <up right> : walk.3 ) ]
		BYTE	000H/2
		BYTE	000H
		BYTE	009H-1,008H-1
		WORD	MFCIPCHR+10E1H
		BYTE	0FFH
;
MPOBJDT34	EQU	$	;[ player.10 ( <up rightt> : walk.4 ) ]
		BYTE	000H/2
		BYTE	000H
		BYTE	009H-1,008H-1
		WORD	MFCIPCHR+18E1H
		BYTE	0FFH
;
MPOBJDT35	EQU	$	;[ player.11 ( <up> : stop ) ]
		BYTE	000H/2
		BYTE	000H
		BYTE	008H-1,008H-1
		WORD	MFCIPCHR+30F1H
		BYTE	0FFH
;
MPOBJDT36	EQU	$	;[ player.12 ( <up> : walk.1 ) ]
		BYTE	000H/2
		BYTE	000H
		BYTE	008H-1,008H-1
		WORD	MFCIPCHR+20E1H
		BYTE	0FFH
;
MPOBJDT37	EQU	$	;[ player.13 ( <up> : walk.2 ) ]
		BYTE	000H/2
		BYTE	000H
		BYTE	008H-1,008H-1
		WORD	MFCIPCHR+28E1H
		BYTE	0FFH
;
MPOBJDT38	EQU	$	;[ player.14 ( <up> : walk.3 ) ]
		BYTE	000H/2
		BYTE	000H
		BYTE	008H-1,007H-1
		WORD	MFCIPCHR+30E1H
		BYTE	0FFH
;
MPOBJDT39	EQU	$	;[ player.15 ( <up> : walk.4 ) ]
		BYTE	000H/2
		BYTE	000H
		BYTE	008H-1,007H-1
		WORD	MFCIPCHR+38E1H
		BYTE	0FFH
;
MPOBJDT3A	EQU	$	;[ player.16 ( <up left> : stop ) ]
		BYTE	000H/2
		BYTE	000H
		BYTE	009H-1,008H-1
		WORD	MPCIPCHR+2059H
		BYTE	0FFH
;
MPOBJDT3B	EQU	$	;[ player.17 ( <up left> : walk.1 ) ]
		BYTE	000H/2
		BYTE	000H
		BYTE	009H-1,008H-1
		WORD	MPCIPCHR+00E1H
		BYTE	0FFH
;
MPOBJDT3C	EQU	$	;[ player.18 ( <up left> : walk.2 ) ]
		BYTE	000H/2
		BYTE	000H
		BYTE	009H-1,008H-1
		WORD	MPCIPCHR+08E1H
		BYTE	0FFH
;
MPOBJDT3D	EQU	$	;[ player.19 ( <up left> : walk.3 ) ]
		BYTE	000H/2
		BYTE	000H
		BYTE	009H-1,008H-1
		WORD	MPCIPCHR+10E1H
		BYTE	0FFH
;
MPOBJDT3E	EQU	$	;[ player.20 ( <up left> : walk.4 ) ]
		BYTE	000H/2
		BYTE	000H
		BYTE	009H-1,008H-1
		WORD	MPCIPCHR+18E1H
		BYTE	0FFH
;
MPOBJDT3F	EQU	$	;[ player.21 ( <left> : stop ) ]
		BYTE	000H/2
		BYTE	000H
		BYTE	008H-1,008H-1
		WORD	MPCIPCHR+20F1H
		BYTE	0FFH
;
MPOBJDT40	EQU	$	;[ player.22 ( <left> : walk.1 ) ]
		BYTE	000H/2
		BYTE	000H
		BYTE	00AH-1,008H-1
		WORD	MPCIPCHR+00EBH
		BYTE	0FFH
;
MPOBJDT41	EQU	$	;[ player.23 ( <left> : walk.2 ) ]
		BYTE	000H/2
		BYTE	000H
		BYTE	00AH-1,008H-1
		WORD	MPCIPCHR+08EBH
		BYTE	0FFH
;
MPOBJDT42	EQU	$	;[ player.24 ( <left> : walk.3 ) ]
		BYTE	000H/2
		BYTE	000H
		BYTE	00AH-1,008H-1
		WORD	MPCIPCHR+10EBH
		BYTE	0FFH
;
MPOBJDT43	EQU	$	;[ player.25 ( <left> : walk.4 ) ]
		BYTE	000H/2
		BYTE	000H
		BYTE	00AH-1,008H-1
		WORD	MPCIPCHR+18EBH
		BYTE	0FFH
;
MPOBJDT44	EQU	$	;[ player.26 ( <down left> : stop ) ]
		BYTE	000H/2
		BYTE	000H
		BYTE	008H-1,008H-1
		WORD	MFCIPCHR+28F1H
		BYTE	0FFH
;
MPOBJDT45	EQU	$	;[ player.27 ( <down left> : walk.1 ) ]
		BYTE	000H/2
		BYTE	000H
		BYTE	009H-1,007H-1
		WORD	MFCIPCHR+00F5H
		BYTE	0FFH
;
MPOBJDT46	EQU	$	;[ player.28 ( <down left> : walk.2 ) ]
		BYTE	000H/2
		BYTE	000H
		BYTE	009H-1,007H-1
		WORD	MFCIPCHR+08F5H
		BYTE	0FFH
;
MPOBJDT47	EQU	$	;[ player.29 ( <down left> : walk.3 ) ]
		BYTE	000H/2
		BYTE	000H
		BYTE	009H-1,007H-1
		WORD	MFCIPCHR+0FF5H
		BYTE	0FFH
;
MPOBJDT48	EQU	$	;[ player.30 ( <down left> : walk.4 ) ]
		BYTE	000H/2
		BYTE	000H
		BYTE	009H-1,008H-1
		WORD	MFCIPCHR+17F5H
		BYTE	0FFH
;
MPOBJDT49	EQU	$	;[ player.31 ( <down> : stop ) ]
		BYTE	000H/2
		BYTE	000H
		BYTE	008H-1,008H-1
		WORD	MFCIPCHR+38F1H
		BYTE	0FFH
;
MPOBJDT4A	EQU	$	;[ player.32 ( <down> : walk.1 ) ]
		BYTE	000H/2
		BYTE	000H
		BYTE	008H-1,008H-1
		WORD	MFCIPCHR+20E9H
		BYTE	0FFH
;
MPOBJDT4B	EQU	$	;[ player.33 ( <down> : walk.2 ) ]
		BYTE	000H/2
		BYTE	000H
		BYTE	008H-1,007H-1
		WORD	MFCIPCHR+28E9H
		BYTE	0FFH
;
MPOBJDT4C	EQU	$	;[ player.34 ( <down> : walk.3 ) ]
		BYTE	000H/2
		BYTE	000H
		BYTE	008H-1,007H-1
		WORD	MFCIPCHR+30E9H
		BYTE	0FFH
;
MPOBJDT4D	EQU	$	;[ player.35 ( <down> : walk.4 ) ]
		BYTE	000H/2
		BYTE	000H
		BYTE	008H-1,007H-1
		WORD	MFCIPCHR+38E9H
		BYTE	0FFH
;
MPOBJDT4E	EQU	$	;[ player.36 ( <down right> : stop ) ]
		BYTE	000H/2
		BYTE	000H
		BYTE	008H-1,008H-1
		WORD	MPCIPCHR+28F1H
		BYTE	0FFH
;
MPOBJDT4F	EQU	$	;[ player.37 ( <down right> : walk.1 ) ]
		BYTE	000H/2
		BYTE	000H
		BYTE	009H-1,007H-1
		WORD	MPCIPCHR+00F5H
		BYTE	0FFH
;
MPOBJDT50	EQU	$	;[ player.38 ( <down right> : walk.2 ) ]
		BYTE	000H/2
		BYTE	000H
		BYTE	009H-1,007H-1
		WORD	MPCIPCHR+08F5H
		BYTE	0FFH
;
MPOBJDT51	EQU	$	;[ player.39 ( <down right> : walk.3 ) ]
		BYTE	000H/2
		BYTE	000H
		BYTE	009H-1,007H-1
		WORD	MPCIPCHR+0FF5H
		BYTE	0FFH
;
MPOBJDT52	EQU	$	;[ player.40 ( <down right> : walk.4 ) ]
		BYTE	000H/2
		BYTE	000H
		BYTE	009H-1,008H-1
		WORD	MPCIPCHR+17F5H
		BYTE	0FFH
;
MPOBJDT53	EQU	$	;[ player.12 ( <up> : walk.5 ) ]
		BYTE	000H/2
		BYTE	000H
		BYTE	008H-1,008H-1
		WORD	MPCIPCHR+20E1H
		BYTE	0FFH
;
MPOBJDT54	EQU	$	;[ player.13 ( <up> : walk.6 ) ]
		BYTE	000H/2
		BYTE	000H
		BYTE	008H-1,008H-1
		WORD	MPCIPCHR+28E1H
		BYTE	0FFH
;
MPOBJDT55	EQU	$	;[ player.14 ( <up> : walk.7 ) ]
		BYTE	000H/2
		BYTE	000H
		BYTE	008H-1,008H-1
		WORD	MPCIPCHR+30E1H
		BYTE	0FFH
;
MPOBJDT56	EQU	$	;[ player.15 ( <up> : walk.8 ) ]
		BYTE	000H/2
		BYTE	000H
		BYTE	008H-1,008H-1
		WORD	MPCIPCHR+38E1H
		BYTE	0FFH
;
MPOBJDT57	EQU	$	;[ player.32 ( <down> : walk.5 ) ]
		BYTE	000H/2
		BYTE	000H
		BYTE	008H-1,008H-1
		WORD	MPCIPCHR+20E9H
		BYTE	0FFH
;
MPOBJDT58	EQU	$	;[ player.33 ( <down> : walk.6 ) ]
		BYTE	000H/2
		BYTE	000H
		BYTE	008H-1,008H-1
		WORD	MPCIPCHR+28E9H
		BYTE	0FFH
;
MPOBJDT59	EQU	$	;[ player.34 ( <down> : walk.7 ) ]
		BYTE	000H/2
		BYTE	000H
		BYTE	008H-1,008H-1
		WORD	MPCIPCHR+30E9H
		BYTE	0FFH
;
MPOBJDT5A	EQU	$	;[ player.35 ( <down> : walk.8 ) ]
		BYTE	000H/2
		BYTE	000H
		BYTE	008H-1,008H-1
		WORD	MPCIPCHR+38E9H
		BYTE	0FFH
;
MPOBJDT5B	EQU	$	;[ ayashii.H ]
		BYTE	008H/2
		BYTE	000H
		BYTE	010H-1,020H-1
		WORD	MPCIPCHR+20A1H
		BYTE	0FFH
;
MPOBJDT5C	EQU	$	;[ ayashii.L ]
		BYTE	006H/2
		BYTE	000H
		BYTE	007H-1,00EH-1
		WORD	MPCIPCHR+12A1H
		BYTE	0FFH
;
MPOBJDT5D	EQU	$	;[ ayashii.2 ]
		BYTE	00CH/2
		BYTE	000H
		BYTE	008H-1,010H-1
		WORD	MPCIPCHR+30F8H
		BYTE	0FFH
;
MPOBJDT5E	EQU	$	;[ big kinoko ]
		BYTE	016H/2
		BYTE	001H
		BYTE	010H-1,010H-1
		WORD	MPCIPCHR+3071H
		BYTE	0FFH
;
MPOBJDT5F	EQU	$	;[ small kinoko ]
		BYTE	00AH/2
		BYTE	000H
		BYTE	00AH-1,009H-1
		WORD	MPCIPCHR+16A7H
		BYTE	0FFH
;
MPOBJDT60	EQU	$	;[ zenmai ]
		BYTE	008H/2
		BYTE	000H
		BYTE	008H-1,008H-1
		WORD	MPCIPCHR+1871H
		BYTE	0FFH
;
MPOBJDT61	EQU	$	;[ big crystal ]
		BYTE	00CH/2
		BYTE	000H
		BYTE	008H-1,00BH-1
		WORD	MPCIPCHR+00A9H
		BYTE	0FFH
;
MPOBJDT62	EQU	$	;[ small crystal ]
		BYTE	008H/2
		BYTE	000H
		BYTE	005H-1,005H-1
		WORD	MPCIPCHR+304FH
		BYTE	0FFH
;
MPOBJDT63	EQU	$	;[ ishi (tea).1 ]
		BYTE	00CH/2
		BYTE	000H
		BYTE	007H-1,006H-1
		WORD	MPCIPCHR+3041H
		BYTE	0FFH
;
MPOBJDT64	EQU	$	;[ ishi (tea).2 ]
		BYTE	00CH/2
		BYTE	000H
		BYTE	006H-1,006H-1
		WORD	MPCIPCHR+3049H
		BYTE	0FFH
;
MPOBJDT65	EQU	$	;[ mini tower ]
		BYTE	00AH/2
		BYTE	000H
		BYTE	007H-1,008H-1
		WORD	MPCIPCHR+3641H
		BYTE	0FFH
;
MPOBJDT66	EQU	$	;[ high kinoko.2 ]
		BYTE	00CH/2
		BYTE	000H
		BYTE	010H-1,010H-1
		WORD	MPCIPCHR+18B1H
		BYTE	0FFH
;
MPOBJDT67	EQU	$	;[ high kinoko.3 ]
		BYTE	00CH/2
		BYTE	000H
		BYTE	010H-1,018H-1
		WORD	MPCIPCHR+18B1H
		BYTE	0FFH
;
MPOBJDT68	EQU	$	;[ high kinoko.4 ]
		BYTE	00CH/2
		BYTE	000H
		BYTE	010H-1,008H-1
		WORD	MPCIPCHR+28B1H
		BYTE	010H-1,018H-1
		WORD	MPCIPCHR+18B1H
		BYTE	0FFH
;
MPOBJDT69	EQU	$	;[ high kinoko.6 ]
		BYTE	00CH/2
		BYTE	000H
		BYTE	010H-1,008H-1
		WORD	MPCIPCHR+28B1H
		BYTE	010H-1,008H-1
		WORD	MPCIPCHR+28B1H
		BYTE	010H-1,008H-1
		WORD	MPCIPCHR+28B1H
		BYTE	010H-1,018H-1
		WORD	MPCIPCHR+18B1H
		BYTE	0FFH
;
MPOBJDT6A	EQU	$	;[ high kinoko.7 ]
		BYTE	00CH/2
		BYTE	000H
		BYTE	010H-1,008H-1
		WORD	MPCIPCHR+28B1H
		BYTE	010H-1,008H-1
		WORD	MPCIPCHR+28B1H
		BYTE	010H-1,008H-1
		WORD	MPCIPCHR+28B1H
		BYTE	010H-1,008H-1
		WORD	MPCIPCHR+28B1H
		BYTE	010H-1,018H-1
		WORD	MPCIPCHR+18B1H
		BYTE	0FFH
;
MPOBJDT6B	EQU	$	;[ holl mask ]
		BYTE	000H/2
		BYTE	005H
		BYTE	028H-1,01EH-1
		WORD	MFCIPCHR+0000H
		BYTE	0FFH
;
MPOBJDT6C	EQU	$	;[d ()]
		BYTE	000H/2
		BYTE	000H
		BYTE	010H-1,020H-1
		WORD	MPCIPCHR+4000H
		BYTE	0FFH
;
MPOBJDT6D	EQU	$	;[d ()]
		BYTE	000H/2
		BYTE	000H
		BYTE	010H-1,010H-1
		WORD	MPCIPCHR+5010H
		BYTE	0FFH
;
MPOBJDT6E	EQU	$	;[ ()]
		BYTE	000H/2
		BYTE	000H
		BYTE	020H-1,020H-1
		WORD	MPCIPCHR+40E1H
		BYTE	0FFH
;
MPOBJDT6F	EQU	$	;[()]
		BYTE	000H/2
		BYTE	000H
		BYTE	010H-1,010H-1
		WORD	MPCIPCHR+4010H
		BYTE	0FFH
;
MPOBJDT70	EQU	$	;[ WO̓ ()]
		BYTE	000H/2
		BYTE	000H
		BYTE	010H-1,020H-1
		WORD	MPCIPCHR+00C0H
		BYTE	0FFH
;
MPOBJDT71	EQU	$	;[ WO̓ ()]
		BYTE	000H/2
		BYTE	000H
		BYTE	008H-1,016H-1
		WORD	MPCIPCHR+2AF9H
		BYTE	0FFH
;
MPOBJDT72	EQU	$	;[ O[̓ ]
		BYTE	000H/2
		BYTE	000H
		BYTE	010H-1,020H-1
		WORD	MPCIPCHR+20B0H
		BYTE	0FFH
;
MPOBJDT73	EQU	$	;[ Nbp  ]
		BYTE	000H/2
		BYTE	000H
		BYTE	020H-1,020H-1
		WORD	MPCIPCHR+4020H
		BYTE	0FFH
;
MPOBJDT74	EQU	$	;[Aj[Vm.P]
		BYTE	000H/2
		BYTE	000H
		BYTE	020H-1,020H-1
		WORD	MPCIPCHR+0040H
		BYTE	0FFH
;
MPOBJDT75	EQU	$	;[Aj[Vm.Q]
		BYTE	000H/2
		BYTE	000H
		BYTE	020H-1,020H-1
		WORD	MPCIPCHR+0001H
		BYTE	0FFH
;
MPOBJDT76	EQU	$	;[Aj[Vm.R]
		BYTE	000H/2
		BYTE	000H
		BYTE	020H-1,020H-1
		WORD	MPCIPCHR+2001H
		BYTE	0FFH
;
MPOBJDT77	EQU	$	;[Aj[Vm.S]
		BYTE	000H/2
		BYTE	000H
		BYTE	020H-1,020H-1
		WORD	MPCIPCHR+2021H
		BYTE	0FFH
;
MPOBJDT78	EQU	$	;[Aj[Vm.T]
		BYTE	000H/2
		BYTE	000H
		BYTE	020H-1,020H-1
		WORD	MPCIPCHR+2081H
		BYTE	0FFH
;
MPOBJDT79	EQU	$	;[Aj[Vm.U]
		BYTE	000H/2
		BYTE	000H
		BYTE	020H-1,020H-1
		WORD	MPCIPCHR+20C1H
		BYTE	0FFH
;
MPOBJDT7A	EQU	$	;[Aj[Vm.V]
		BYTE	000H/2
		BYTE	000H
		BYTE	020H-1,018H-1
		WORD	MPCIPCHR+4001H
		BYTE	0FFH
;
MPOBJDT7B	EQU	$	;[Aj[Vm.W]
		BYTE	000H/2
		BYTE	000H
		BYTE	020H-1,018H-1
		WORD	MPCIPCHR+4021H
		BYTE	0FFH
;
MPOBJDT7C	EQU	$	;[Aj[Vm.X]
		BYTE	000H/2
		BYTE	000H
		BYTE	010H-1,010H-1
		WORD	MPCIPCHR+3080H
		BYTE	0FFH
;
MPOBJDT7D	EQU	$	;[Aj[Vm.`]
		BYTE	000H/2
		BYTE	000H
		BYTE	010H-1,010H-1
		WORD	MPCIPCHR+3090H
		BYTE	0FFH
;
MPOBJDT7E	EQU	$	;[͂߂ Aj[V m.P]
		BYTE	000H/2
		BYTE	000H
		BYTE	020H-1,008H-1
		WORD	MFCIPCHR+5880H
		BYTE	0FFH
;
MPOBJDT7F	EQU	$	;[͂߂ Aj[V m.Q]
		BYTE	000H/2
		BYTE	000H
		BYTE	020H-1,010H-1
		WORD	MFCIPCHR+4080H
		BYTE	0FFH
;
MPOBJDT80	EQU	$	;[͂߂ Aj[V m.R]
		BYTE	000H/2
		BYTE	000H
		BYTE	020H-1,018H-1
		WORD	MFCIPCHR+48C0H
		BYTE	0FFH
;
MPOBJDT81	EQU	$	;[͂߂ Aj[V m.S]
		BYTE	000H/2
		BYTE	000H
		BYTE	020H-1,020H-1
		WORD	MFCIPCHR+40E0H
		BYTE	0FFH
;
MPOBJDT82	EQU	$	;[͂߂ Aj[V m.T]
		BYTE	000H/2
		BYTE	000H
		BYTE	020H-1,020H-1
		WORD	MFCIPCHR+4060H
		BYTE	0FFH
;
MPOBJDT83	EQU	$	;[͂߂ Aj[V m.U]
		BYTE	000H/2
		BYTE	000H
		BYTE	020H-1,020H-1
		WORD	MFCIPCHR+4040H
		BYTE	0FFH
;
MPOBJDT84	EQU	$	;[͂߂ Aj[V m.V]
		BYTE	000H/2
		BYTE	000H
		BYTE	020H-1,020H-1
		WORD	MFCIPCHR+20C0H
		BYTE	0FFH
;
MPOBJDT85	EQU	$	;[͂߂ Aj[V m.W]
		BYTE	000H/2
		BYTE	000H
		BYTE	020H-1,020H-1
		WORD	MFCIPCHR+0060H
		BYTE	0FFH
;
MPOBJDT86	EQU	$	;[͂߂ Aj[V m.X]
		BYTE	000H/2
		BYTE	000H
		BYTE	020H-1,020H-1
		WORD	MFCIPCHR+2040H
		BYTE	0FFH
;
MPOBJDT87	EQU	$	;[͂߂ Aj[V m.`]
		BYTE	000H/2
		BYTE	000H
		BYTE	020H-1,020H-1
		WORD	MFCIPCHR+2060H
		BYTE	0FFH
;
MPOBJDT88	EQU	$	;[͂߂ Aj[V m.a]
		BYTE	000H/2
		BYTE	000H
		BYTE	020H-1,020H-1
		WORD	MFCIPCHR+2000H
		BYTE	0FFH
;
MPOBJDT89	EQU	$	;[͂߂ Aj[V m.b]
		BYTE	000H/2
		BYTE	000H
		BYTE	020H-1,020H-1
		WORD	MFCIPCHR+2020H
		BYTE	0FFH
;
MPOBJDT8A	EQU	$	;[j󂵂̓V]
		BYTE	000H/2
		BYTE	00AH
		BYTE	020H-1,018H-1
		WORD	MPCIPCHR+4081H
		BYTE	0FFH
;
MPOBJDT8B	EQU	$	;[bV[ tbV m.O]
		BYTE	000H/2
		BYTE	000H
		BYTE	020H-1,020H-1
		WORD	MPCIPCHR+40C1H
		BYTE	0FFH
;
MPOBJDT8C	EQU	$	;[bV[ tbV m.P]
		BYTE	000H/2
		BYTE	000H
		BYTE	020H-1,020H-1
		WORD	MPCIPCHR+40A0H
		BYTE	0FFH
;
MPOBJDT8D	EQU	$	;[bV[ tbV m.Q]
		BYTE	000H/2
		BYTE	000H
		BYTE	020H-1,020H-1
		WORD	MPCIPCHR+4041H
		BYTE	0FFH
;
MPOBJDT8E	EQU	$	;[bV[ tbV m.R]
		BYTE	000H/2
		BYTE	000H
		BYTE	020H-1,020H-1
		WORD	MPCIPCHR+4061H
		BYTE	0FFH
;
MPOBJDT8F	EQU	$	;[bV[ tbV m.S]
		BYTE	000H/2
		BYTE	000H
		BYTE	020H-1,020H-1
		WORD	MPCIPCHR+40A1H
		BYTE	0FFH
;
;------------------------------------------------------------------------
;-		map pars data						-
;------------------------------------------------------------------------
PARSY		EQU	0300H
PARSDT		EQU	$
		WORD	00120H,0011FH,0011FH,0011EH,0011DH,0011CH,0011CH,0011BH
		WORD	0011AH,0011AH,00119H,00118H,00117H,00117H,00116H,00115H
		WORD	00115H,00114H,00113H,00113H,00112H,00111H,00111H,00110H
		WORD	0010FH,0010FH,0010EH,0010DH,0010DH,0010CH,0010CH,0010BH
		WORD	0010AH,0010AH,00109H,00108H,00108H,00107H,00107H,00106H
		WORD	00105H,00105H,00104H,00104H,00103H,00102H,00102H,00101H
		WORD	00101H,00100H,000FFH,000FFH,000FEH,000FEH,000FDH,000FDH
		WORD	000FCH,000FBH,000FBH,000FAH,000FAH,000F9H,000F9H,000F8H
		WORD	000F8H,000F7H,000F6H,000F6H,000F5H,000F5H,000F4H,000F4H
		WORD	000F3H,000F3H,000F2H,000F2H,000F1H,000F1H,000F0H,000F0H
		WORD	000EFH,000EFH,000EEH,000EEH,000EDH,000EDH,000ECH,000ECH
		WORD	000EBH,000EBH,000EAH,000EAH,000E9H,000E9H,000E8H,000E8H
		WORD	000E7H,000E7H,000E6H,000E6H,000E5H,000E5H,000E5H,000E4H
		WORD	000E4H,000E3H,000E3H,000E2H,000E2H,000E1H,000E1H,000E0H
;
PARSYP		EQU	01B9H
CENTZ		EQU	080H
PARSDV		EQU	$
		WORD	0468FH,04680H,04672H,04663H,04654H,04645H,04637H,04628H
		WORD	04619H,0460BH,045FCH,045EEH,045DFH,045D1H,045C2H,045B4H
		WORD	045A5H,04597H,04588H,0457AH,0456CH,0455DH,0454FH,04541H
		WORD	04533H,04524H,04516H,04508H,044FAH,044ECH,044DDH,044CFH
		WORD	044C1H,044B3H,044A5H,04497H,04489H,0447BH,0446DH,0445FH
		WORD	04451H,04444H,04436H,04428H,0441AH,0440CH,043FEH,043F1H
		WORD	043E3H,043D5H,043C8H,043BAH,043ACH,0439FH,04391H,04383H
		WORD	04376H,04368H,0435BH,0434DH,04340H,04332H,04325H,04318H
		WORD	0430AH,042FDH,042F0H,042E2H,042D5H,042C8H,042BAH,042ADH
		WORD	042A0H,04293H,04286H,04278H,0426BH,0425EH,04251H,04244H
		WORD	04237H,0422AH,0421DH,04210H,04203H,041F6H,041E9H,041DCH
		WORD	041CFH,041C2H,041B5H,041A9H,0419CH,0418FH,04182H,04175H
		WORD	04169H,0415CH,0414FH,04143H,04136H,04129H,0411DH,04110H
		WORD	04103H,040F7H,040EAH,040DEH,040D1H,040C5H,040B8H,040ACH
		WORD	0409FH,04093H,04087H,0407AH,0406EH,04061H,04055H,04049H
		WORD	0403DH,04030H,04024H,04018H,0400CH,03FFFH,03FF3H,03FE7H
		WORD	03FDBH,03FCFH,03FC3H,03FB7H,03FAAH,03F9EH,03F92H,03F86H
		WORD	03F7AH,03F6EH,03F62H,03F56H,03F4BH,03F3FH,03F33H,03F27H
		WORD	03F1BH,03F0FH,03F03H,03EF7H,03EECH,03EE0H,03ED4H,03EC8H
		WORD	03EBDH,03EB1H,03EA5H,03E9AH,03E8EH,03E82H,03E77H,03E6BH
		WORD	03E60H,03E54H,03E48H,03E3DH,03E31H,03E26H,03E1AH,03E0FH
		WORD	03E03H,03DF8H,03DEDH,03DE1H,03DD6H,03DCAH,03DBFH,03DB4H
		WORD	03DA8H,03D9DH,03D92H,03D87H,03D7BH,03D70H,03D65H,03D5AH
		WORD	03D4EH,03D43H,03D38H,03D2DH,03D22H,03D17H,03D0CH,03D00H
		WORD	03CF5H,03CEAH,03CDFH,03CD4H,03CC9H,03CBEH,03CB3H,03CA8H
		WORD	03C9DH,03C93H,03C88H,03C7DH,03C72H,03C67H,03C5CH,03C51H
		WORD	03C46H,03C3CH,03C31H,03C26H,03C1BH,03C11H,03C06H,03BFBH
		WORD	03BF0H,03BE6H,03BDBH,03BD0H,03BC6H,03BBBH,03BB1H,03BA6H
		WORD	03B9BH,03B91H,03B86H,03B7CH,03B71H,03B67H,03B5CH,03B52H
		WORD	03B47H,03B3DH,03B32H,03B28H,03B1EH,03B13H,03B09H,03AFEH
		WORD	03AF4H,03AEAH,03ADFH,03AD5H,03ACBH,03AC0H,03AB6H,03AACH
		WORD	03AA2H,03A98H,03A8DH,03A83H,03A79H,03A6FH,03A65H,03A5AH
;
MPCENTX		EQU	0E0H/2
MPCENTY		EQU	(070H+31H)-PARSYP-28H
;
;
;
;
;
;************************************************************************
;*		map data edit bitmap buffer clear			*
;************************************************************************
;
EDBFCLR		EQU	$
		IWT	R1,#MPBITMAP	;(R1) <-- map bitmap buffer
		IBT	R0,#0
		IWT	R12,#(20*20*20H)/2
;
		CACHE
;
		MOVE	R13,R15
EDBCL010
		STW	(R1)
		INC	R1
		LOOP
		INC	R1
;
		STOP
		NOP
;
;************************************************************************
;*		map data edit bitmap plot				*
;************************************************************************
;
EDWRITE		EQU	$
;
;-------------- map data edit OBJ write -------------------------
		LM	R6,CEDZOOM	;(R6)  <-- zoom flag
		IWT	R0,#(20*8/2)*100H
		TO	R10		;(R10) <-- display area size (R)
		FMULT
;
		MOVE	R5,R6		;(R5)  <-- zoom flag
		IWT	R0,#DIVBUF
		ADD	R5
		ADD	R5
		TO	R6		;(R6)  <-- 1 / zoom flag
		LDW	(R0)
;
		IWT	R11,#CMPOBJTYP	;(R11) <-- map OBJ data pointer
;
		LM	R12,CMPOBJSTN	;number of point
;
		CACHE
;
		MOVE	R13,R15
EDWT0010
		LDB	(R11)
		DEC	R0
		BPL	EDWT0020	;set ok OBJ ? ( yes:EDWT0020 )
		INC	R11
;
		INC	R11
		IWT	R15,#EDWT0100	;[ JMP EDWT0100 ]
		INC	R11		;[ dummy ]
;
;-------------- OBJ set ---------------------------------
EDWT0020
		IBT	R14,#BANK EDOBJDT
		FROM	R14
		ROMB
;
		ADD	R0		;x4
		ADD	R0
		IWT	R14,#EDOBJDT
		TO	R14		;(R14) <-- map OBJ status data index address
		ADD	R14
;
;-------------- display check -------------------
		LDB	(R11)
		SEX			;(R0) <-- map OBJ X pos
;
		TO	R3		;(R3) <-- map OBJ size
		GETB
		INC	R14
		FROM	R3
		TO	R8		;(R8) <--	"      (R)
		LSR
;
		LM	R1,CEDCENTX
		SUB	R1
		MOVE	R1,R0		;(R1) <-- to display center X size
		BPL	EDWT0030
		NOP
;
		NOT
		INC	R0
EDWT0030
		SUB	R10
		SUB	R8
		BMI	EDWT0040	;X display area ? ( yes:EDWT0040 )
		INC	R11
;
		IWT	R15,#EDWT0100	;[ JMP EDWT0100 ]
		INC	R11		;[ dummy ]
;
EDWT0040
		LDB	(R11)
		SEX			;(R0) <-- map OBJ Z pos
		LM	R2,CEDCENTY
		SUB	R2
		MOVE	R2,R0		;(R2) <-- to display center Z size
		BPL	EDWT0050
		NOP
;
		NOT
		INC	R0
EDWT0050
		SUB	R10
		SUB	R8
		BMI	EDWT0060	;Y display area ? ( yes:EDWT0060 )
		INC	R11
;
		IWT	R15,#EDWT0100	;[ JMP EDWT0100 ]
		NOP
;
;-------------- map OBJ write -------------------
EDWT0060
		TO	R9		;(R9) <-- chara data address
		GETB
		INC	R14
;
		FROM	R1
		SUB	R8
		LMULT
		LOB
		SWAP
		WITH	R4
		HIB
		OR	R4
		IBT	R7,#050H	;(R7) <-- center plot pos
		TO	R1		;(R1) <-- plot start X pos
		ADD	R7
;
		WITH	R9
		GETBH
;
		FROM	R2
		SUB	R8
		LMULT
		LOB
		SWAP
		WITH	R4
		HIB
		OR	R4
		FROM	R7
		TO	R2		;(R2) <-- plot start Y pos
		SUB	R0
;
;-------------- chara plot --------------
		IBT	R0,#BANK EDCIPCHR	;chara data address(B) set
		ROMB
;
		IBT	R7,#00		;(R7) <-- plot mode
		FROM	R9
		LSR
		BCC	EDWT0070	;high bit color ? ( no:EDWT0070 )
		ADD	R0		;[ ASL ]
;
		IBT	R7,#04H
EDWT0070
		FROM	R7
		CMODE			;plot mode set
		MOVES	R9,R0		;(R9)  <-- chara data address
;
		SMS	R6,REG6		;(R6) save
;
		MOVE	R4,R1		;(R4) <-- plot start X pos
		IWT	R6,#20*8	;(R6) <-- display area max
		DEC	R3
		WITH	R3
		SWAP
		MOVE	R7,R3		;(R7) <-- chara Y wide
EDWT0080
		MOVE	R1,R4		;(R1) <-- plot start X pos
		MOVE	R8,R3		;(R8) <-- chara X wide
EDWT0090
		FROM	R1
		SUB	R6
		BCS	EDWT0092	;X display area ? ( no:EDWT0092 )
		NOP
;
		FROM	R2
		SUB	R6
		BCC	EDWT0094	;Y	 "        ( yes:EDWT0094 )
		MERGE
;
;-------------- not display area plot ---
EDWT0092
		WITH	R8
		SUB	R5		;(N) <-- end flag
		BPL	EDWT0090
		INC	R1
;
		WITH	R7
		SUB	R5
		BPL	EDWT0080
		DEC	R2		;Y pos up !!
;
		BRA	EDWT0096+1
		LMS	R6,REG6		;[ dummy ] (R6) load
;
;-------------- display area plot -------
EDWT0094
;;;;		MERGE
		TO	R14		;(R14) <-- chara data address
		ADD	R9
;
		WITH	R8
		SUB	R5		;(N) <-- end flag
;
		GETC			;color get
		BPL	EDWT0090
		PLOT			;plot
;
		WITH	R7
		SUB	R5
		BPL	EDWT0080
		DEC	R2		;Y pos up !!
;
EDWT0096
		LMS	R6,REG6		;(R6) load
;
EDWT0100
		LOOP
		INC	R11
;
;-------------- last plot cancel ------------------------
		INC	R2
		RPIX
;
		STOP
		NOP
;
;
;****************************************************************
;*		map data edit cursol pos convert		*
;*			in  : R10 <-- cursol X pos		*
;*			      R11 <--	"   Z  "		*
;*			out : R10 <-- convert X pos		*
;*			      R11 <--	"   Z  "		*
;****************************************************************
POINTCNV	EQU	$
		LM	R0,CEDZOOM
		ADD	R0
		IWT	R1,#DIVBUF
		ADD	R1
		TO	R6
		LDW	(R0)
;
		FROM	R10
		LMULT
		LOB
		SWAP
		WITH	R4
		HIB
		OR	R4
		IWT	R1,#00080H
		TO	R10
		ADD	R1
;
		FROM	R11
		LMULT
		LOB
		SWAP
		WITH	R4
		HIB
		TO	R1
		OR	R4
		IBT	R0,#058H
		TO	R11
		SUB	R1
;
		STOP
		NOP
;
;
;
;************************************************************************
;*		map data edit cursol pos convert			*
;*			in  : (CCSRXPS)	 <-- cursol X pos		*
;*			      (CCSRYPS)	 <--	"   Z  "		*
;*			out : (CEDMPXPS) <-- convert X pos		*
;*			      (CEDMPZPS) <--	"   Z  "		*
;************************************************************************
;
EDPOSCNV	EQU	$
		LM	R6,CEDZOOM	;(R6) <-- zoom flag
		NOP
;
		LM	R0,CCSRXPS
		IWT	R1,#080H	;(R1) <-- display center X pos
		SUB	R1
		LMULT
		LOB
		SWAP
		WITH	R4
		HIB
		OR	R4
		LM	R3,CEDCENTX
		ADD	R3
		SM	R0,CEDMPXPS	;convert X pos set
;
		LM	R1,CCSRYPS
		IBT	R0,#050H+08H	;(R1) <-- display center Y pos
		SUB	R1
		LMULT
		LOB
		SWAP
		WITH	R4
		HIB
		OR	R4
		LM	R3,CEDCENTY
		ADD	R3
		SM	R0,CEDMPZPS	;convert Z pos set
;
		STOP
		NOP
;
;************************************************************************
;*		map data edit map pos convert [ edit pos <-- map pos ]	*
;*			in  : (R1) <-- map X wide			*
;*			      (R2) <--	"  Z  "				*
;*			out : (R1) <-- convert edit X wide		*
;*			      (R2) <--	     "      Z  "		*
;************************************************************************
;
EDMPCNV		EQU	$
		LM	R6,CEDZOOM	;(R6) <-- zoom flag
		IWT	R0,#DIVBUF
		ADD	R6
		ADD	R6
		TO	R6		;(R6) <-- 1/zoom flag
		LDW	(R0)
;
		FROM	R1
		SWAP
		TO	R1
		FMULT
;
		FROM	R2
		SWAP
		TO	R2
		FMULT
;
		STOP
		NOP
;
;************************************************************************
;*		map data edit parts search				*
;*			in  : (CEDMPXPS) <-- search X pos		*
;*			      (CEDMPZPS) <--	"   Z  "		*
;*			out : (R0)	 <-- search parts index		*
;************************************************************************
;
EDSARCH		EQU	$
;
;-------------- search pos zoom convert -------------------------
		LM	R1,CEDMPXPS	;(R1) <-- search X pos
		NOP
		LM	R2,CEDMPZPS	;(R2) <-- zoom convert search Y pos
;
;-------------- data search -------------------------------------
;;K;;		IWT	R11,#CMPOBJTYP+(16*4)	;(R11) <-- map OBJ data pointer
;
		LM	R0,CMPOBJSTN
		DEC	R0
		ADD	R0
		ADD	R0
		MOVE	R5,R0
		IWT	R0,#CMPOBJTYP
		TO	R5
		ADD	R5
;
		LM	R0,CMPOBJSTN
		IBT	R12,#16
		TO	R12		;(R12) <-- number of point
		SUB	R12
		BEQ	EDSR0102	;no data ? ( yes:EDSR0102 )
;
		CACHE
;
		MOVE	R13,R15
EDSR0010
		MOVE	R11,R5
;
		LDB	(R11)
		DEC	R0
		BPL	EDSR0020	;set ok OBJ ? ( yes:EDSR0020 )
		INC	R11
;
		INC	R11
		BRA	EDSR0100
		INC	R11		;[ dummy ]
;
;-------------- OBJ data read ---------------------------
EDSR0020
		IBT	R14,#BANK EDOBJDT
		FROM	R14
		ROMB
;
		ADD	R0		;x4
		ADD	R0
		IWT	R14,#EDOBJDT
		TO	R14		;(R14) <-- map OBJ status data index address
		ADD	R14
;
;-------------- data search -----------------------------
		LDB	(R11)
		SEX			;(R0) <-- map OBJ X pos
		SUB	R1
		MOVE	R6,R0
		LMULT
		ADC	#0
		BEQ	EDSR0030	;X search ok ? ( yes:EDSR0030 )
		INC	R11
;
		BRA	EDSR0100
		INC	R11		;[ dummy ]
;
EDSR0030
		GETB
		SUB	#0
		BEQ	EDSR0032	;not edit parts ? ( yes:EDSR0032 )
		LSR			;to R !!
;
		MULT	R0
		TO	R3		;(R3) <-- ( R * R ) - ( SX * SX )
		SUB	R4
		BCS	EDSR0040	;search ok data ? ( yes:EDSR0040 )
		NOP
;
EDSR0032
		BRA	EDSR0100
		INC	R11		;[ dummy ]
;
EDSR0040
		LDB	(R11)
		SEX			;(R0) <-- map OBJ Y pos
		SUB	R2
		MOVE	R6,R0
		LMULT
		ADC	#0
		BNE	EDSR0100	;Y search ok ? ( no:EDSR0100 )
		INC	R11
;
		FROM	R3
		SUB	R4
		BCS	EDSR0110	;search ok data ? ( yes:EDSR0110 )
		NOP
;
EDSR0100
		DEC	R5
		DEC	R5
		DEC	R5
		DEC	R5
		LOOP
		INC	R11
;
;-------------- not data search return set !! -----------
EDSR0102
		IBT	R0,#0FFH	;(R0) <-- not search index set !!
;
		STOP
		NOP
;
;-------------- search data return set !! ---------------
EDSR0110
;;K;;		LM	R0,CMPOBJSTN	;number of point
;;K;;		SUB	R12
;;K;;		ADD	R0		;(R0) <-- search data index
;;K;;		ADD	R0
;
		WITH	R11
		SUB	#3
		TO	R1		;(R1) <-- parts no.
		LDB	(R11)
;
		IWT	R0,#CMPOBJTYP
		FROM	R5
		SUB	R0		;(R0) <-- search data index
;
;;K;;		TO	R1		;(R1) <-- parts no.
;;K;;		LDB	(R5)
;
;
;************************************************************************
;*		map data edit 1 parts chara set				*
;*			in  : (R1) <-- parts no.			*
;************************************************************************
;
EDUNITWT	EQU	$
		SMS	R0,REG0		;(R0) save
;
;-------------- buffer clear ------------------------------------
		IWT	R5,#MPBITMAP+(20*20*20H)	;(R5) <-- clear start address
		SUB	R0				;(R0) <-- clear data
		IWT	R12,#((20*5-15)*20H)/2
		MOVE	R13,R15
EDUW0000
		STW	(R5)
		INC	R5
		LOOP
		INC	R5
;
;-------------- 1 parts chara set -------------------------------
		LM	R5,CEDZOOM	;(R5) <-- zoom flag
		FROM	R5
		ADD	R5
		IWT	R6,#DIVBUF
		ADD	R6
		TO	R6		;(R6) <-- 1 / zoom flag
		LDW	(R0)
;
		IBT	R0,#BANK EDOBJDT
		ROMB
;
		DEC	R1
		FROM	R1		;x4
		ADD	R1
		ADD	R0
		IWT	R14,#EDOBJDT
		TO	R14		;(R14) <-- map OBJ status data index address
		ADD	R14
;
		GETB
		INC	R14
		MOVE	R3,R0		;(R3) <-- map OBJ size
		LSR
		TO	R8		;(R8) <--	"      (R)
		SWAP
;
		GETB
		INC	R14
		GETBH
		MOVE	R9,R0		;(R9) <-- chara data address
;
		FROM	R8
		FMULT
		IBT	R7,#28H/2	;(R7) <-- 1 parts plot center pos
		FROM	R7
		TO	R4		;(R4) <-- plot start X offset set
		SUB	R0
;
		FROM	R8
		FMULT
		TO	R2		;(R2) <-- plot start Y set
		ADD	R7
;
;-------------- chara plot --------------
		IBT	R0,#BANK EDCIPCHR	;chara data address(B) set
		ROMB
;
		IBT	R7,#00		;(R7) <-- plot mode
		FROM	R9
		LSR
		BCC	EDUW0010	;high bit color ? ( no:EDUW0010 )
		ADD	R0		;[ ASL ]
;
		IBT	R7,#04H
EDUW0010
		FROM	R7
		CMODE			;plot mode set
		MOVES	R9,R0		;(R9)  <-- chara data address
;
		IBT	R10,#28H	;(R10) <-- display area max
		IWT	R0,#0A0H
		TO	R12		;(R12) <-- plot start X pos
		ADD	R4
		DEC	R3
		WITH	R3
		SWAP
		MOVE	R7,R3		;(R7) <-- chara Y wide
;
		CACHE
;
EDUW0020
		MOVE	R11,R4		;(R11) <-- plot start X offset
		MOVE	R1,R12		;(R1)  <-- plot satrt X pos
		MOVE	R8,R3		;(R8)  <-- chara X wide
EDUW0030
		FROM	R11
		SUB	R10
		BCS	EDUW0040	;X display area ? ( no:EDUW0040 )
		FROM	R2
;
		SUB	R10
		BCC	EDUW0050	;Y	 "        ( yes:EDUW0050 )
		MERGE
;
;-------------- not display area plot ---
EDUW0040
		INC	R1
		WITH	R8
		SUB	R5		;(N) <-- end flag
		BPL	EDUW0030
		INC	R11
;
		WITH	R7
		SUB	R5
		BPL	EDUW0020
		DEC	R2		;Y pos up !!
;
		LMS	R0,REG0		;(R0) load
;
		STOP
		NOP
;
;-------------- display area plot -------
EDUW0050
;;;;		MERGE
		TO	R14		;(R14) <-- chara data address
		ADD	R9
;
		INC	R11
;
		WITH	R8
		SUB	R5		;(N) <-- end flag
;
		GETC			;color get
		BPL	EDUW0030
		PLOT			;plot
;
		WITH	R7
		SUB	R5
		BPL	EDUW0020
		DEC	R2		;Y pos up !!
;
EDUW0060
		LMS	R0,REG0		;(R0) load
;
		STOP
		NOP
;
;************************************************************************
;*		map data edit parts search				*
;*			in  : (CEDMPXPS) <-- search X pos		*
;*			      (CEDMPZPS) <--	"   Z  "		*
;*			out : (R0)	 <-- search parts index		*
;************************************************************************
;
;------------------------------------------------------------------------
;-		map OBJ data						-
;------------------------------------------------------------------------
EDCIPCHR	EQU	0A8000H
;
EDOBJDT		EQU	$		;[MPOBJTYP]
;			[size]
;			[chara address]
;			[dummy]
		HEX	28		;[01] yama.H
		WORD	EDCIPCHR+0000H
		HEX	00
;
		HEX	28		;[02]	" .M
		WORD	EDCIPCHR+0028H
		HEX	00
;
		HEX	28		;[03]	" .L
		WORD	EDCIPCHR+5800H
		HEX	00
;
		HEX	10		;[04] tower( tea )
		WORD	EDCIPCHR+2090H
		HEX	00
;
		HEX	10		;[05]	"  ( gray )
		WORD	EDCIPCHR+20B0H
		HEX	00
;
		HEX	20		;[06] kazan
		WORD	EDCIPCHR+00E0H
		HEX	00
;
		HEX	20		;[07] small yama
		WORD	EDCIPCHR+2060H
		HEX	00
;
		HEX	20		;[08] dai
		WORD	EDCIPCHR+0060H
		HEX	00
;
		HEX	08		;[09] small tower
		WORD	EDCIPCHR+38D8H
		HEX	00
;
		HEX	10		;[0A] wide tower
		WORD	EDCIPCHR+30B0H
		HEX	00
;
		HEX	10		;[0B] mini yama
		WORD	EDCIPCHR+3050H
		HEX	00
;
		HEX	04		;[0C] saku
		WORD	EDCIPCHR+494AH
		HEX	00
;
		HEX	10		;[0D] yane
		WORD	EDCIPCHR+2080H
		HEX	00
;
		HEX	20		;[0E] holl
		WORD	EDCIPCHR+20E0H
		HEX	00
;
		HEX	10		;[0F] tree.1
		WORD	EDCIPCHR+10B0H
		HEX	00
;
		HEX	10		;[10]	" .2
		WORD	EDCIPCHR+20C0H
		HEX	00
;
		HEX	0A		;[11]	" .3
		WORD	EDCIPCHR+423AH
		HEX	00
;
		HEX	0A		;[12]	" .4
		WORD	EDCIPCHR+422AH
		HEX	00
;
		HEX	10		;[13]	" .5
		WORD	EDCIPCHR+10C0H
		HEX	00
;
		HEX	10		;[14] iwa
		WORD	EDCIPCHR+00D0H
		HEX	00
;
		HEX	18		;[15] kumo
		WORD	EDCIPCHR+4000H
		HEX	00
;
		HEX	20		;[16] laputa
		WORD	EDCIPCHR+0080H
		HEX	00
;
		HEX	08		;[17] keble
		WORD	EDCIPCHR+30C8H
		HEX	00
;
		HEX	07		;[18] kusa
		WORD	EDCIPCHR+39A8H
		HEX	00
;
		HEX	06		;[19] flower
		WORD	EDCIPCHR+425AH
		HEX	00
;
		HEX	08		;[1A] ishi
		WORD	EDCIPCHR+4850H
		HEX	00
;
		HEX	04		;[1B] lope
		WORD	EDCIPCHR+4262H
		HEX	00
;
		HEX	00		;[1C] kazan smoke.1
		WORD	EDCIPCHR+0000H
		HEX	00
;
		HEX	00		;[1D]	   "     .2
		WORD	EDCIPCHR+0000H
		HEX	00
;
		HEX	00		;[1E]	   "     .3
		WORD	EDCIPCHR+0000H
		HEX	00
;
		HEX	00		;[1F]	   "     .4
		WORD	EDCIPCHR+0000H
		HEX	00
;
		HEX	00		;[20]	   "     .5
		WORD	EDCIPCHR+0000H
		HEX	00
;
		HEX	00		;[21]	   "     .6
		WORD	EDCIPCHR+0000H
		HEX	00
;
		HEX	00		;[22]	   "     .7
		WORD	EDCIPCHR+0000H
		HEX	00
;
		HEX	07		;[23] kamome.1
		WORD	EDCIPCHR+3098H
		HEX	00
;
		HEX	00		;[24]	 "  .2
		WORD	EDCIPCHR+0000H
		HEX	00
;
		HEX	00		;[25]	 "  .3
		WORD	EDCIPCHR+0000H
		HEX	00
;
		HEX	00		;[26]	 "  .4
		WORD	EDCIPCHR+0000H
		HEX	00
;
		HEX	00		;[27]	 "  .5
		WORD	EDCIPCHR+0000H
		HEX	00
;
		HEX	00		;[28]	 "  .6
		WORD	EDCIPCHR+0000H
		HEX	00
;
		HEX	00		;[29]	 "  .7
		WORD	EDCIPCHR+0000H
		HEX	00
;
		HEX	00		;[2A]	 "  .8
		WORD	EDCIPCHR+0000H
		HEX	00
;
		HEX	00		;[2B] player.1
		WORD	EDCIPCHR+0000H
		HEX	00
;
		HEX	00		;[2C]	 "  .2
		WORD	EDCIPCHR+0000H
		HEX	00
;
		HEX	00		;[2D]	 "  .3
		WORD	EDCIPCHR+0000H
		HEX	00
;
		HEX	00		;[2E]	 "  .4
		WORD	EDCIPCHR+0000H
		HEX	00
;
		HEX	00		;[2F]	 "  .5
		WORD	EDCIPCHR+0000H
		HEX	00
;
		HEX	00		;[30]	 "  .6
		WORD	EDCIPCHR+0000H
		HEX	00
;
		HEX	00		;[31]	 "  .7
		WORD	EDCIPCHR+0000H
		HEX	00
;
		HEX	00		;[32]	 "  .8
		WORD	EDCIPCHR+0000H
		HEX	00
;
		HEX	00		;[33]	 "  .9
		WORD	EDCIPCHR+0000H
		HEX	00
;
		HEX	00		;[34]	 "  .10
		WORD	EDCIPCHR+0000H
		HEX	00
;
		HEX	00		;[35]	 "  .11
		WORD	EDCIPCHR+0000H
		HEX	00
;
		HEX	00		;[36]	 "  .12
		WORD	EDCIPCHR+0000H
		HEX	00
;
		HEX	00		;[37]	 "  .13
		WORD	EDCIPCHR+0000H
		HEX	00
;
		HEX	00		;[38]	 "  .14
		WORD	EDCIPCHR+0000H
		HEX	00
;
		HEX	00		;[39]	 "  .15
		WORD	EDCIPCHR+0000H
		HEX	00
;
		HEX	00		;[3A]	 "  .16
		WORD	EDCIPCHR+0000H
		HEX	00
;
		HEX	00		;[3B]	 "  .17
		WORD	EDCIPCHR+0000H
		HEX	00
;
		HEX	00		;[3C]	 "  .18
		WORD	EDCIPCHR+0000H
		HEX	00
;
		HEX	00		;[3D]	 "  .19
		WORD	EDCIPCHR+0000H
		HEX	00
;
		HEX	00		;[3E]	 "  .20
		WORD	EDCIPCHR+0000H
		HEX	00
;
		HEX	00		;[3F]	 "  .21
		WORD	EDCIPCHR+0000H
		HEX	00
;
		HEX	00		;[40]	 "  .22
		WORD	EDCIPCHR+0000H
		HEX	00
;
		HEX	00		;[41]	 "  .23
		WORD	EDCIPCHR+0000H
		HEX	00
;
		HEX	00		;[42]	 "  .24
		WORD	EDCIPCHR+0000H
		HEX	00
;
		HEX	00		;[43]	 "  .25
		WORD	EDCIPCHR+0000H
		HEX	00
;
		HEX	00		;[44]	 "  .26
		WORD	EDCIPCHR+0000H
		HEX	00
;
		HEX	00		;[45]	 "  .27
		WORD	EDCIPCHR+0000H
		HEX	00
;
		HEX	00		;[46]	 "  .28
		WORD	EDCIPCHR+0000H
		HEX	00
;
		HEX	00		;[47]	 "  .29
		WORD	EDCIPCHR+0000H
		HEX	00
;
		HEX	00		;[48]	 "  .30
		WORD	EDCIPCHR+0000H
		HEX	00
;
		HEX	00		;[49]	 "  .31
		WORD	EDCIPCHR+0000H
		HEX	00
;
		HEX	00		;[4A]	 "  .32
		WORD	EDCIPCHR+0000H
		HEX	00
;
		HEX	00		;[2B]	 "  .33
		WORD	EDCIPCHR+0000H
		HEX	00
;
		HEX	00		;[4C]	 "  .34
		WORD	EDCIPCHR+0000H
		HEX	00
;
		HEX	00		;[4D]	 "  .35
		WORD	EDCIPCHR+0000H
		HEX	00
;
		HEX	00		;[4E]	 "  .36
		WORD	EDCIPCHR+0000H
		HEX	00
;
		HEX	00		;[4F]	 "  .37
		WORD	EDCIPCHR+0000H
		HEX	00
;
		HEX	00		;[50]	 "  .38
		WORD	EDCIPCHR+0000H
		HEX	00
;
		HEX	00		;[51]	 "  .39
		WORD	EDCIPCHR+0000H
		HEX	00
;
		HEX	00		;[52]	 "  .40
		WORD	EDCIPCHR+0000H
		HEX	00
;
		HEX	00		;[53]	 "  .41
		WORD	EDCIPCHR+0000H
		HEX	00
;
		HEX	00		;[54]	 "  .42
		WORD	EDCIPCHR+0000H
		HEX	00
;
		HEX	00		;[55]	 "  .43
		WORD	EDCIPCHR+0000H
		HEX	00
;
		HEX	00		;[56]	 "  .44
		WORD	EDCIPCHR+0000H
		HEX	00
;
		HEX	00		;[57]	 "  .45
		WORD	EDCIPCHR+0000H
		HEX	00
;
		HEX	00		;[58]	 "  .46
		WORD	EDCIPCHR+0000H
		HEX	00
;
		HEX	00		;[59]	 "  .47
		WORD	EDCIPCHR+0000H
		HEX	00
;
		HEX	00		;[5A]	 "  .48
		WORD	EDCIPCHR+0000H
		HEX	00
;
		HEX	10		;[5B] ayashii.H
		WORD	EDCIPCHR+3080H
		HEX	00
;
		HEX	08		;[5C]	 "   .L
		WORD	EDCIPCHR+30A0H
		HEX	00
;
		HEX	08		;[5D]	 "   .2
		WORD	EDCIPCHR+30D0H
		HEX	00
;
		HEX	10		;[5E] big   kinoko
		WORD	EDCIPCHR+10D0H
		HEX	00
;
		HEX	0A		;[5F] small    "
		WORD	EDCIPCHR+431AH
		HEX	00
;
		HEX	08		;[60] zenmai
		WORD	EDCIPCHR+30D8H
		HEX	00
;
		HEX	08		;[61] big   crystal
		WORD	EDCIPCHR+30C0H
		HEX	00
;
		HEX	06		;[62] small    "
		WORD	EDCIPCHR+4250H
		HEX	00
;
		HEX	08		;[63] ishi (tea).1
		WORD	EDCIPCHR+4858H
		HEX	00
;
		HEX	07		;[64]	   "    .2
		WORD	EDCIPCHR+4148H
		HEX	00
;
		HEX	08		;[65] mini tower
		WORD	EDCIPCHR+3090H
		HEX	00
;
		HEX	10		;[66] high kinoko.2
		WORD	EDCIPCHR+20A0H
		HEX	00
;
		HEX	10		;[67]	    "    .3
		WORD	EDCIPCHR+10A0H
		HEX	00
;
		HEX	10		;[68]	    "    .4
		WORD	EDCIPCHR+00A0H
		HEX	00
;
		HEX	10		;[69]	    "    .6
		WORD	EDCIPCHR+00B0H
		HEX	00
;
		HEX	10		;[6A]	    "    .7
		WORD	EDCIPCHR+00C0H
		HEX	00
;
		HEX	00		;[6B] holl mask
		WORD	EDCIPCHR+0000H
		HEX	00
;
		HEX	10		;[6C] d ()
		WORD	EDCIPCHR+7038H
		HEX	00
;
		HEX	10		;[6D] d ()
		WORD	EDCIPCHR+7048H
		HEX	00
;
		HEX	20		;[6E] ()
		WORD	EDCIPCHR+5048H
		HEX	00
;
		HEX	10		;[6F] ()
		WORD	EDCIPCHR+7028H
		HEX	00
;
		HEX	10		;[70] WO̓ ()
		WORD	EDCIPCHR+1050H
		HEX	00
;
		HEX	08		;[71] WO̓()
		WORD	EDCIPCHR+3808H
		HEX	00
;
		HEX	10		;[72] O[̓
		WORD	EDCIPCHR+0050H
		HEX	00
;
		HEX	20		;[73] Nbp
		WORD	EDCIPCHR+5028H
		HEX	00
;
		HEX	00		;[74]	" .9
		WORD	EDCIPCHR+0000H
		HEX	00
;
		HEX	00		;[75]	" .10
		WORD	EDCIPCHR+0000H
		HEX	00
;
		HEX	00		;[76]	" .11
		WORD	EDCIPCHR+0000H
		HEX	00
;
		HEX	00		;[77]	" .12
		WORD	EDCIPCHR+0000H
		HEX	00
;
		HEX	00		;[78]	" .13
		WORD	EDCIPCHR+0000H
		HEX	00
;
		HEX	00		;[79]	" .14
		WORD	EDCIPCHR+0000H
		HEX	00
;
		HEX	00		;[7A] point display hand
		WORD	EDCIPCHR+0000H
		HEX	00
;
		HEX	10		;[7B] point.1
		WORD	EDCIPCHR+2800H
		HEX	00
;
;-------------- player walk point ---------------------------------------
		HEX	08		;[7C] player walk point.1
		WORD	EDCIPCHR+3800H
		HEX	00
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;R0		work
;R1	drow x pos.
;R2	drow y pos.
;R3	kakudo / cos R3
;R4	sin R3
;R5	rom data addr.
;R6	rom data y inc. data / rom data y relative pos.
;R7	rom data y relative pos.
;R8	rom data x relative pos.
;R9	rom data x inc. data / rom data x relative pos.
;R10	tate loop counter
;R11	drow start x pos. save
;R12	yoko loop counter
;R13	yoko loop addr.
;R14	rom pointer
;
;
;********************************************************
;*		drow revice culc.			*
;********************************************************
;REVOLTION DROW
EXP_DROW	EQU	$
;REV_DROW	EQU	$
		IBT	R0,#004H	;colour mode set
		CMODE			;

		IBT	R0,#BANK SIN	;sin cos data bank set
		ROMB

		WITH	R3
		LOB

		WITH	R3		;kakudo * 2
		ADD	R3

		IWT	R0,#SIN		;sin R3 set
		TO	R14		;
		ADD	R3		;
		GETBL			;
		INC	R14		;
		GETBH			;
		MOVE	R4,R0

		IWT	R0,#COS		;cos R3 set
		TO	R14		;
		ADD	R3		;
		GETBL			;
		INC	R14		;
		GETBH			;
		MOVE	R3,R0

		IWT	R6,#01000H
		IWT	R0,#00100H
		SUB	R3
		TO	R7
		FMULT

		MOVE	R0,R4
		FMULT
		TO	R8
		ADD	R7

		WITH	R7
		SUB	R0

		WITH	R7
		SWAP
		WITH	R8
		SWAP

		MOVE	R6,R7
		MOVE	R9,R8
;
		MOVE	R11,R1

		IBT	R0,#BANK MPCIPCHR	;dom bank set
		ROMB				;

		IWT	R5,#MPCIPCHR+0C0H	;rom data start addr. set

		IBT	R10,#020H	;tate loop counter set

		CACHE
REV_DROW0400
		IBT	R12,#020H	;yoko loop counter set

		MOVE	R13,R15		;loop addr. set

		IBT	R0,#000H	;drow colour clear
		COLOUR			;

		MERGE			;rom read relative pointer merge & range check
		BCS	REV_DROW0600	;check ng: REV_DROW0600
		NOP			;

		TO	R14		;rom read pointer culc.
		ADD	R5		;

		GETC			;rom data read

REV_DROW0600

		WITH	R8		;next rom data x relative pos. culc.
		ADD	R3		;

		WITH	R7		;next rom data y relative pos. culc
		ADD	R4		;

		LOOP			;yoko loop end
		PLOT			;drow point

		MOVE	R8,R9		;rom data x relative pos. reset
		WITH	R8
		SUB	R4
		MOVE	R9,R8

		MOVE	R7,R6		;rom data y relative pos. reset
		WITH	R7
		ADD	R3
		MOVE	R6,R7

		MOVE	R1,R11		;drow x pos. reset

		INC	R2

		DEC	R10		;tate loop end
		BPL	REV_DROW0400	;
		NOP			;

		STOP
		NOP
;
;
;
;
;
		END
