;************************************************************************
;*									*
;*	title name	: "yossy map tool"				*
;*	proccess	: map data edit					*
;*	file name	: ysm_edit					*
;*									*
;************************************************************************
;
;
		SALL
;
		include		ysm_header.inc
;
		XALL
;
;
;------------------------------------------------------------------------
;-		global symbol						-
;------------------------------------------------------------------------
		GLB	EDIT0IN,EDIT0MV
;
;------------------------------------------------------------------------
;-		extern symbol						-
;------------------------------------------------------------------------
;
;-------------< ysm_main >-----------------------------------------------
		EXT	VRAMCL,OAMCLR,BLNKON,BLNKOFF,URAMCLR,DMA_M_M
		EXT	MPTS,MNU0
;
;-------------< ysm_rpro >-----------------------------------------------
		EXT	NEWVMADL,CHIPON,BLNKON
		EXT	KYREAD
;
;-------------< ysm_init >-----------------------------------------------
		EXT	GMMDST,CHRSET,DIVDTST
		EXT	MPCHRST,MPCOLST
		EXT	ED00
;
;-------------< ysm_title >----------------------------------------------
		EXT	MODINC,MODINC2
;
;-------------< ysm_data >-----------------------------------------------
		EXT	COS,SIN
;
;-------------< ysm_file >-----------------------------------------------
		EXT	UNMPBF,MDBAD
;
;------------------------------------------------------------------------
;-		define symbol						-
;------------------------------------------------------------------------
;
;
;
;************************************************************************
;*									*
;*		program start						*
;*									*
;************************************************************************
;
;
;
		EXTEND
;
;
		MEM8
		IDX8
;
Group_1		GROUP	Edit_pro
Edit_pro	SECT	REL
;
;
;************************************************************************
;*		map data edit initial					*
;************************************************************************
;
;-------------- map color data address table ----------------------------
MPCOLTBL	EQU	$
		WORD	08D000H+(200H-1)	;[chijyo]
		WORD	08D200H+(200H-1)	;[chika]
;
;
;-------------- H-DMA set data ------------------------------------------
;
;-------------- H-DMA parameter data ( window ) -----------------
HDMAP0		EQU	$
		BYTE	00000001B	;DMA control parameter
		BYTE	26H		;    B bus address
		BYTE	LOW  HDMADB0	;    A	    "     (L)
		BYTE	HIGH HDMADB0	;	    "     (H)
		BYTE	BANK HDMADB0	;	    "     (B)
;
HDMAPD0		EQU	$
		BYTE	08H+00H		;line no.
		HEX	FF,00
		BYTE	50H+00H		;line no.
		HEX	30,CF
		BYTE	4FH+00H		;line no.
		HEX	30,CF
		BYTE	01H+80H		;line no.
		HEX	FF,00
		HEX	00		;end code
HDMAPD0E	EQU	$
;
;-------------- H-DMA parameter data ( BG mode ) ----------------
HDMAP1		EQU	$
		BYTE	00000000B	;DMA control parameter
		BYTE	05H		;    B bus address
		BYTE	LOW  HDMADB1	;    A	    "     (L)
		BYTE	HIGH HDMADB1	;	    "     (H)
		BYTE	BANK HDMADB1	;	    "     (B)
;
HDMAPD1		EQU	$
		BYTE	08H+00H		;line no.
		BYTE	00000000B	;	( BG mode 0 )
		BYTE	50H+00H		;line no.
		BYTE	00000111B	;	( BG mode 7 )
		BYTE	4FH+00H		;line no.
		BYTE	00000111B	;	( BG mode 7 )
		BYTE	01H+00H		;line no.
		BYTE	00000000B	;	( BG mode 0 )
		HEX	00		;end code
;
;-------------- H-DMA parameter data ( main select ) ------------
HDMAP2		EQU	$
		BYTE	00000000B	;DMA control parameter
		BYTE	2CH		;    B bus address
		BYTE	LOW  HDMADB2	;    A	    "     (L)
		BYTE	HIGH HDMADB2	;	    "     (H)
		BYTE	BANK HDMADB2	;	    "     (B)
;
HDMAPD2		EQU	$
		BYTE	08H+00H		;line no.
		BYTE	00010010B	;	( BG mode 0 )
		BYTE	50H+00H		;line no.
		BYTE	00010001B	;	( BG mode 7 )
		BYTE	4FH+00H		;line no.
		BYTE	00010001B	;	( BG mode 7 )
		BYTE	01H+00H		;line no.
		BYTE	00010010B	;	( BG mode 0 )
		HEX	00		;end code
;
EDIT0IN		EQU	$
		JSL	>VRAMCL		;VRAM clear
		JSL	>URAMCLR	;use RAM clear
;
;-------------- PPU Reg. initial set ----------------------------
		LDX	#ED00		;(X) <-- map mode type no.
		JSL	>GMMDST		;game mode set
;
;-------------- color set ---------------------------------------
;
		JSL	>MPCOLST	; }bvJ[ Zbg
;
		PHB			;(DBR) save
		LDA	#BANK DATACOL
		PHA
		PLB
;
		LDX	#020H-1
ED0IN021	EQU	$
		LDA	>8D200H+(10H*2),X
		STA	DATACOL+(20H*2),X
		DEX
		BPL	ED0IN021
;
		LDY	#00		;nuki color set
		STY	DATACOL
		STY	DATACOL+1
;
		PLB
;
;-------------- mode 0 character set ----------------------------
;
		M16
;
		LDY	#10000000B
		STY	2115H		;inc mode set
		LDA	#5B60H
		STA	2116H		;VRAM address set
		LDA	#00000001B+(18H*100H)
		STA	4300H		;DMA parameter & B bus address set
		LDA	#098400H
		STA	4302H		;A bus address(L,H) set
		LDY	#BANK 098400H
		STY	4304H		;	"     (B) set
		LDA	#0940H
		STA	4305H		;number of byte set
		LDX	#00000001B
		STX	420BH		;DMA "ON"
;
;-------------- mode 0 screen write -----------------------------
		LDA	#7C00H
		STA	2116H		;VRAM address set
		LDA	#00000001B+(18H*100H)
		STA	4300H		;DMA parameter & B bus address set
		LDA	#099000H
		STA	4302H		;A bus address(L,H) set
;;;;		LDY	#BANK 099000H
;;;;		STY	4304H		;	"     (B) set
		LDA	#0800H
		STA	4305H		;number of byte set
		STX	420BH		;DMA "ON"
;
;-------------- mode 7 screen set -------------------------------
		JSR	M7SETSUB
;
;-------------- map data edit initial RAM set -------------------
;
		M8
;
		JSL	>DIVDTST	;div data set
;
;-------------- cursol chara set --------------------------------
		PHB			;(DBR) save
		LDY	#BANK MPBITMAP
		PHY
		PLB			;(DBR) set
;
		I16
;
		LDX	#00		;(X) <-- cursol chara pointer
		LDY	#(20*25)*20H	;(Y) <-- bitmap buffer pointer
		LDA	#02H
		STA	<WORK		;(WK0,1) <-- set OBJ no ( 4 chara )
ED0IN062	EQU	$
		LDA	#02H
		STA	<WORK+2		;(WK2,3) <-- Y loop no
ED0IN064	EQU	$
		LDA	#02H
		STA	<WORK+4		;(WK4,5) <-- X loop no
ED0IN066	EQU	$
		LDA	#020H
		STA	<WORK+6		;(WK6,7) <-- 1 chara number of byte
ED0IN068	EQU	$
		LDA	>98000H,X
		STA	MPBITMAP,Y
		INX
		INY
		DEC	<WORK+6
		BNE	ED0IN068
;
		M16
;
		TYA
		CLC
		ADC	#(20-1)*32
		TAY
;
		M8
;
		DEC	<WORK+4
		BNE	ED0IN066
;
		M16
;
		SEC
		SBC	#(20*2-1)*32
		TAY
		TXA
		CLC
		ADC	#(16-2)*32
		TAX
;
		M8
;
		DEC	<WORK+2
		BNE	ED0IN064
;
		M16
;
		SEC
		SBC	#(16*2-2)*32
		TAX
;
		M8
;
		DEC	<WORK
		BNE	ED0IN062
;
;-------------- edit select initial buffer --------------------
		M16
		LDX	#09580H
		LDY	#EDITBF
		LDA	#0013FH
		MVN	#009H,#BANK EDITBF
		MI8
;
		STZ	!SLCTMD
;
;-------------- unit NO. initial set ----------------------------
		LDA	!UNTNOBF
		BEQ	UNNO005
		STA	!UNITNO
		STZ	!UNTNOBF
UNNO005		EQU	$
		MI16			; memory , index 16bit mode
		LDA	!UNITNO
		AND	#0000FH
		STA	<WORK0		; unit NO. low set
		CMP	#0000AH
		BCC	UNNO000
		SEC
		SBC	#0002AH
UNNO000		EQU	$
		CLC
		ADC	#00190H
		STA	!EDITBF+04AH
;
		LDA	!UNITNO		; unit NO. high set
		AND	#000F0H
		LSR	A
		LSR	A
		LSR	A
		LSR	A
		STA	<WORK2
		CMP	#0000AH
		BCC	UNNO010
		SEC
		SBC	#0002AH
UNNO010		EQU	$
		CLC
		ADC	#00190H
		STA	!EDITBF+048H
;
		PHB
		PHK
		PLB
		LDA	!UNITNO
		AND	#000FFH
		ASL	A
		TAX
		LDA	EDNMAD,X
		STA	<WORK4
		LDY	#00000H
UNNO020		EQU	$
		LDA	(<WORK4),Y
		STA	!EDITBF+106H,Y
		INY
		INY
		CPY	#00018H
		BNE	UNNO020
;
		M8			; memory 8bit mode
		STZ	<WORK1
		LDA	!EDZOOM
		LSR	A
		LSR	A
		LSR	A
		LSR	A
		STA	<WORK0
		LDA	!EDZOOM+1
		BNE	UNNO030
		LDA	#010H
		SEC
		SBC	<WORK0
		STA	<WORK0
UNNO030		EQU	$
		M16			; memory 16bit mode
		LDA	<WORK0
		ORA	#00190H
		STA	!EDITBF+056H
		LDA	<WORK0
		BNE	UNNO040
		LDX	#000H
		BRA	UNNO050
UNNO040		EQU	$
		LDA	!EDZOOM+1
		AND	#00001H
		ASL	A
		TAX
UNNO050		EQU	$
		LDA	ZOMDAT,X
		STA	!EDITBF+054H
;
		PLB
		MI8			; memory , index 8bit mode
;
		PLB
		LDA	#001H
		STA	!SLTMDS
		STZ	!ZRXPOS
		STZ	!ZRZPOS
;
		M16			; memory 16bit mode
		LDA	!MPTCNT0
		CLC
		ADC	!MPTCNT1
		STA	!MPOBJSTN
		M8			; memory 8bit mode
;
		LDX	#000H
		JSR	EMNST		; edit mode name set
;
		LDA	!POINTFG	; point edit mode ?
		BEQ	UNNO060		;	NO -> UNNO060
		LDA	#07CH
		STA	!UNITNO
		MI16			; memory , index 16bit mode
		LDA	!QSTPOS		; quest point
		AND	#00003H
		STA	<WORK0
		LDA	#00000H
		LDX	!MENUNO
		BEQ	UNNO055
UNNO053		EQU	$
		CLC
		ADC	#0010EH
		DEX
		BNE	UNNO053
UNNO055		EQU	$
		STA	<WORK2
		CLC
		ADC	<WORK0
		TAX
		LDA	>MPTQT1,X
		AND	#0000FH
		STA	<WORK0
		CLC
		ADC	#00150
		STA	!MPOBJSTN
;
		JSR	MPOBJ		; map obj set (150 ->)
;
		LDX	#00000H
		LDA	#0018FH
UNNO058		EQU	$
		STA	!EDITBF+064H,X
		INX
		INX
		CPX	#01AH
		BCC	UNNO058
;
		LDA	#002E0H
		STA	>DATACOL+046H
		LDA	#001E0H
		STA	>DATACOL+04CH
;
		MI8			; memory , index 8bit mode
;
		LDX	#002H
		LDA	!NXTFLG
		BNE	UNNO059
		LDX	#003H
UNNO059		EQU	$
		JSR	EMNST		; edit mode name set
;
UNNO060		EQU	$
;
;-------------- unit no. parts chara set ------------------------
		JSR	UNITCHST
;
;-------------- map data change initial set ---------------------
		PHB
		PHK
		PLB
		LDX	!MPCHGFG
		M16			; memory 16bit mode
		LDA	MPDTDT,X
		STA	<WORK0
		M8			; memory 8bit mode
		LDA	#001H
		STA	(<WORK)
;
		PLB
;
;-------------- map select DMA set ------------------------------
		M16			; memory 16bit mode
		LDY	#10000000B
		STY	2115H		; inc mode set
		LDA	#07EC0H
		STA	2116H		; address set
		LDA	#00000001B+(18H*100H)
		STA	4300H		; DMA parameter & B bus address set
		LDA	#EDITBF
		STA	4302H		; A bus address(L,H) set
		LDY	#BANK EDITBF
		STY	4304H		;	 "     (B) set
		LDA	#00140H
		STA	4305H		; number of byte set
		LDY	#00000001B
		STY	420BH		; DMA "ON" !!
;
;-------------- edit mode name set ------------------------------
		LDA	#07EA4H
		STA	2116H		; address set
		LDA	#00000001B+(18H*100H)
		STA	4300H		; DMA parameter & B bus address set
		LDA	#EDNMBF
		STA	4302H		; A bus address(L,H) set
		LDX	#BANK EDNMBF
		STX	4304H		;	 "     (B) set
		LDA	#00032H
		STA	4305H		; number of byte set
		STY	420BH		; DMA "ON" !!
		M8			; memory 8bit mode
;
;-------------- map mode 7 matrix H-DMA initial set -------------
		LDX	#04
ED0IN070	EQU	$
		LDA	!HDMAP0,X
		STA	4370H,X
		LDA	!HDMAP1,X
		STA	4360H,X
		LDA	!HDMAP2,X
		STA	4350H,X
		DEX
		BPL	ED0IN070
;
		LDX	#HDMAPD0E-HDMAPD0-1
ED0IN080	EQU	$
		LDA	!HDMAPD0,X
		STA	>HDMADB0,X
		LDA	!HDMAPD1,X
		STA	>HDMADB1,X
		LDA	!HDMAPD2,X
		STA	>HDMADB2,X
		DEX
		BPL	ED0IN080
;
		LDA	#11100000B
		STA	HD420C		;H-DMA "ON" !!
;
;-------------- OAM set -----------------------------------------
;
		MI16
;
		LDX	#EDIT0OAME-EDIT0OAM-2
ED0IN090	EQU	$
		LDA	!EDIT0OAM,X
		STA	>OAM,X
		DEX
		DEX
		BPL	ED0IN090
;
		MI8
;
		LDX	#EDIT0OAMSBE-EDIT0OAMSB-1
ED0IN100	EQU	$
		LDA	!EDIT0OAMSB,X
		STA	>OAMSUB,X
		DEX
		BPL	ED0IN100
;
;-------------- 1st map set -------------------------------------
		JSL	>BLNKOFF	;NMI enable
;
		JSL	>EDIT0MV0	;1st map set
;
		LDA	#03H
		STA	MPDMAFG		;bitmap chara DMA "ON" !!
;
ED0IN110	EQU	$
		LDA	MPDMAFG
		BNE	ED0IN110	;bitmap chara DMA end ? ( no:ED0IN110 )
;
		LDA	MPBANK		;OBJ chara bank change
		EOR	#01H
		STA	MPBANK
;
;-------------- go to next mode !! ------------------------------
		JMP	>MODINC		;go to next mode !!
;
;
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+	[hV XN[ f[^ Zbg		+
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
M7SETSUB_DAT	EQU	$
		WORD	0D800H,0B000H,0C000H,0DC00H
		WORD	0D800H,0D800H,0D800H,0D800H
;
M7SETSUB_BANK	EQU	$
		BYTE	008H,008H,008H,008H,008H,008H,008H,008H
;
;
		MEM16
M7SETSUB	EQU	$
		LDY	#000H
		STY	2115H
		LDA	!MPTYPE
		TAY
		LSR	A
		TAX
		LDA	M7SETSUB_DAT,Y	; XN[
		STA	<WORK4		;	AhXf[^ Zbg
;
		LDA	#00000000B+(18H*100H)
		STA	4300H		;DMA parameter & B bus address set
		LDY	M7SETSUB_BANK,X
		STY	4304H		;A bus address(B) set
		LDA	#(100H/8)*(20H*4)
		STA	<WORK0		;(WK0,1) <-- start VRAM address
		LDX	#00000001B	;(X) <-- DMA "ON" data
		LDA	#32
		TAY			;(Y) <-- number of byte
		STA	<WORK2		;(WK2,3) <-- V loop no
M7SETSUB_LOP	EQU	$
		LDA	<WORK0
		STA	2116H		;VRAM address set
		CLC
		ADC	#20H*4
		STA	<WORK0
		LDA	<WORK4
		STA	4302H		;A bus address(L,H) set
		CLC
		ADC	#32
		STA	<WORK4
		STY	4305H		;number of byte set
		STX	420BH
		DEC	<WORK2
		BNE	M7SETSUB_LOP
;
		RTS
		MEM8
;
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	map point obj initial set (150 ->)	+
;+			in			+
;+			work0,1 <- quest count	+
;++++++++++++++++++++++++++++++++++++++++++++++++
		MEM16
		IDX16
MPOBJ		EQU	$
		STZ	!MPOBJTYP+0150+00H
		STZ	!MPOBJTYP+0150+02H
		STZ	!MPOBJTYP+0150+04H
		STZ	!MPOBJTYP+0150+06H
		STZ	!MPOBJTYP+0150+08H
		STZ	!MPOBJTYP+0150+0AH
		STZ	!MPOBJTYP+0150+0CH
		STZ	!MPOBJTYP+0150+0EH
;
		LDA	!QSTPOS
		AND	#00003H
		STA	<WORKA
		LDA	<WORK2
		LDX	<WORKA
		BEQ	MOBJ100
MOBJ000		EQU	$
		CLC
		ADC	#00041H
		DEX
		BNE	MOBJ000
MOBJ100		EQU	$
		TAX
		LDA	<WORK0
		BEQ	MOBJ900
		LDY	#00150*4
		M8			; memory 8bit mode
MOBJ150		EQU	$
		LDA	#07CH		; unit NO.
		STA	!MPOBJTYP,Y
		LDA	>MPT11X,X
		STA	!MPOBJTYP+1,Y
		LDA	>MPT11Z,X
		STA	!MPOBJTYP+2,Y
		LDA	>MPT11Y,X
		STA	!MPOBJTYP+3,Y
		INY
		INY
		INY
		INY
		INX
		INX
		INX
		INX
		DEC	<WORK0
		BNE	MOBJ150
		M16			; memory 16bit mode
;
MOBJ900		EQU	$
		RTS
		MEM8
		IDX8
;
;
;************************************************************************
;*		map data edit move					*
;************************************************************************
;
;-------------- map test OAM data -------------------------------
EDOBX		EQU	30H
EDOBY		EQU	07H
;
EDIT0OAM	EQU	$
		BYTE	0F9H,000H,08EH,31H		;[00] mouse cursol
;
		BYTE	008H,070H,084H,3FH		;[01] move parts
		BYTE	018H,070H,086H,3FH		;[02]
		BYTE	020H,070H,087H,3FH		;[03]
		BYTE	008H,080H,089H,3FH		;[04]
		BYTE	018H,080H,08BH,3FH		;[05]
		BYTE	020H,080H,08CH,3FH		;[06]
		BYTE	008H,088H,099H,3FH		;[07]
		BYTE	018H,088H,09BH,3FH		;[08]
		BYTE	020H,088H,09CH,3FH		;[09]
;
EDIT0NTPS	EQU	$
		BYTE	000H,0F0H,08EH,091H		;[10] my point
		BYTE	000H,0F0H,08EH,095H		;[11]
;
		BYTE	000H+EDOBX,000H+EDOBY,000H,3EH	;[12] bitmap
		BYTE	020H+EDOBX,000H+EDOBY,004H,3EH	;[13]
		BYTE	040H+EDOBX,000H+EDOBY,008H,3EH	;[14]
		BYTE	060H+EDOBX,000H+EDOBY,00CH,3EH	;[15]
		BYTE	080H+EDOBX,000H+EDOBY,040H,3FH	;[16]
;
		BYTE	000H+EDOBX,020H+EDOBY,040H,3EH	;[17]
		BYTE	020H+EDOBX,020H+EDOBY,044H,3EH	;[18]
		BYTE	040H+EDOBX,020H+EDOBY,048H,3EH	;[19]
		BYTE	060H+EDOBX,020H+EDOBY,04CH,3EH	;[20]
		BYTE	080H+EDOBX,020H+EDOBY,044H,3FH	;[21]
;
		BYTE	000H+EDOBX,040H+EDOBY,080H,3EH	;[22]
		BYTE	020H+EDOBX,040H+EDOBY,084H,3EH	;[23]
		BYTE	040H+EDOBX,040H+EDOBY,088H,3EH	;[24]
		BYTE	060H+EDOBX,040H+EDOBY,08CH,3EH	;[25]
		BYTE	080H+EDOBX,040H+EDOBY,048H,3FH	;[26]
;
		BYTE	000H+EDOBX,060H+EDOBY,0C0H,3EH	;[27]
		BYTE	020H+EDOBX,060H+EDOBY,0C4H,3EH	;[28]
		BYTE	040H+EDOBX,060H+EDOBY,0C8H,3EH	;[29]
		BYTE	060H+EDOBX,060H+EDOBY,0CCH,3EH	;[30]
		BYTE	080H+EDOBX,060H+EDOBY,04CH,3FH	;[31]
;
		BYTE	000H+EDOBX,080H+EDOBY,000H,3FH	;[32]
		BYTE	020H+EDOBX,080H+EDOBY,004H,3FH	;[33]
		BYTE	040H+EDOBX,080H+EDOBY,008H,3FH	;[34]
		BYTE	060H+EDOBX,080H+EDOBY,00CH,3FH	;[35]
		BYTE	080H+EDOBX,080H+EDOBY,080H,3FH	;[36]
EDIT0OAME	EQU	$
;
EDIT0OAMSB	EQU	$
		WORD	0000000000000000B		;[00-07]
		WORD	1010101000000000B		;[08-15]
		WORD	1010101010101010B		;[16-23]
		WORD	1010101010101010B		;[24-31]
		WORD	0000001010101010B		;[32-39]
EDIT0OAMSBE	EQU	$
;
;-------------- map test bitmap data convert status data --------
EDCNVST		EQU	$
		WORD	EDCNVST0
		WORD	EDCNVST1
		WORD	EDCNVST2
		WORD	EDCNVST3
EDCNVBP		EQU	$
		WORD	MPDMABF
		WORD	MPDMABF+0E00H
		WORD	MPDMABF+0E00H*2
		WORD	MPDMABF+0E00H*3
;
;				  X	Y	number of chara
EDCNVST0	WORD	MPBITMAP+(00*20+00)*20H
		BYTE	08*2				;(1)
		WORD	MPBITMAP+(00*20+01)*20H
		BYTE	08*2				;(2)
		WORD	MPBITMAP+(00*20+02)*20H
		BYTE	08*2				;(3)
		WORD	MPBITMAP+(00*20+03)*20H
		BYTE	08*2				;(4)
		WORD	MPBITMAP+(00*20+04)*20H
		BYTE	08*2				;(5)
		WORD	MPBITMAP+(00*20+05)*20H
		BYTE	08*2				;(6)
		WORD	MPBITMAP+(00*20+06)*20H
		BYTE	08*2				;(7)
		HEX	FF
;
EDCNVST1	WORD	MPBITMAP+(00*20+07)*20H
		BYTE	08*2				;(8)
		WORD	MPBITMAP+(00*20+08)*20H
		BYTE	08*2				;(9)
		WORD	MPBITMAP+(00*20+09)*20H
		BYTE	08*2				;(10)
		WORD	MPBITMAP+(00*20+10)*20H
		BYTE	08*2				;(11)
		WORD	MPBITMAP+(00*20+11)*20H
		BYTE	08*2				;(12)
		WORD	MPBITMAP+(00*20+12)*20H
		BYTE	08*2				;(13)
		WORD	MPBITMAP+(00*20+13)*20H
		BYTE	08*2				;(14)
		HEX	FF
;
EDCNVST2	WORD	MPBITMAP+(00*20+14)*20H
		BYTE	08*2				;(15)
		WORD	MPBITMAP+(00*20+15)*20H
		BYTE	08*2				;(16)
		WORD	MPBITMAP+(00*20+16)*20H
		BYTE	08*2				;(17)
		WORD	MPBITMAP+(00*20+17)*20H
		BYTE	08*2				;(18)
		WORD	MPBITMAP+(00*20+18)*20H
		BYTE	08*2				;(19)
		WORD	MPBITMAP+(00*20+19)*20H
		BYTE	08*2				;(20)
		WORD	MPBITMAP+(16*20+00)*20H
		BYTE	02*2				;(21)
		WORD	MPBITMAP+(16*20+04)*20H
		BYTE	02*2				;(22)
		WORD	MPBITMAP+(16*20+08)*20H
		BYTE	02*2				;(23)
		WORD	MPBITMAP+(16*20+12)*20H
		BYTE	02*2				;(24)
		HEX	FF
;
EDCNVST3	WORD	MPBITMAP+(16*20+01)*20H
		BYTE	02*2				;(25)
		WORD	MPBITMAP+(16*20+05)*20H
		BYTE	02*2				;(26)
		WORD	MPBITMAP+(16*20+09)*20H
		BYTE	02*2				;(27)
		WORD	MPBITMAP+(16*20+13)*20H
		BYTE	02*2				;(28)
		WORD	MPBITMAP+(16*20+02)*20H
		BYTE	02*2				;(29)
		WORD	MPBITMAP+(16*20+06)*20H
		BYTE	02*2				;(30)
		WORD	MPBITMAP+(16*20+10)*20H
		BYTE	02*2				;(31)
		WORD	MPBITMAP+(16*20+14)*20H
		BYTE	02*2				;(32)
		WORD	MPBITMAP+(16*20+03)*20H
		BYTE	02*2				;(33)
		WORD	MPBITMAP+(16*20+07)*20H
		BYTE	02*2				;(34)
		WORD	MPBITMAP+(16*20+11)*20H
		BYTE	02*2				;(35)
		WORD	MPBITMAP+(16*20+15)*20H
		BYTE	02*2				;(36)
		WORD	MPBITMAP+(16*20+16)*20H
		BYTE	02*2				;(37)
		WORD	MPBITMAP+(20*20+00)*20H
		BYTE	05				;(38)
		WORD	MPBITMAP+(20*20+02)*20H
		BYTE	05				;(39)
		WORD	MPBITMAP+(25*20+00)*20H
		BYTE	01*2				;(40)
		WORD	MPBITMAP+(16*20+17)*20H
		BYTE	02*2				;(41)
		WORD	MPBITMAP+(20*20+01)*20H
		BYTE	05				;(42)
		WORD	MPBITMAP+(20*20+03)*20H
		BYTE	05				;(43)
		WORD	MPBITMAP+(25*20+01)*20H
		BYTE	01*2				;(44)
		WORD	MPBITMAP+(16*20+18)*20H
		BYTE	02*2				;(45)
		WORD	MPBITMAP+(25*20+02)*20H
		BYTE	01*2				;(46)
		WORD	MPBITMAP+(24*20+05)*20H
		BYTE	03				;(47)
		WORD	MPBITMAP+(20*20+04)*20H
		BYTE	05				;(48)
		WORD	MPBITMAP+(25*20+04)*20H
		BYTE	01*2				;(49)
		WORD	MPBITMAP+(16*20+19)*20H
		BYTE	02*2				;(50)
		WORD	MPBITMAP+(25*20+03)*20H
		BYTE	01*2				;(51)
		HEX	FF
;
;-------------- 1 parts convert data ------------------------------------
EDCNVSTX	WORD	MPBITMAP+(20*20+00)*20H
		BYTE	05				;(1)
		WORD	MPBITMAP+(20*20+02)*20H
		BYTE	05				;(2)
		WORD	MPBITMAP+(20*20+01)*20H
		BYTE	05				;(3)
		WORD	MPBITMAP+(20*20+03)*20H
		BYTE	05				;(4)
		WORD	MPBITMAP+(20*20+04)*20H
		BYTE	05				;(5)
		HEX	FF
;
;-------------- edit program table --------------------------------------
EDITSUB		EQU	$		;[EDITMOD]
		WORD	ED0MV1000	;[00]
		WORD	ED0MV0000	;[02]
		WORD	ILAND_1000	;[04]
		WORD	ILAND_2000	;[06]
		WORD	ILAND_3000	;[08]
		WORD	ILAND_4000	;[10]
		WORD	ILAND_5000	;[12]
;
EDIT0MV0	EQU	$
		PHB			;(DBR) save
		PHK			;(DBR) <-- (PBR)
		PLB
;
EDIT0MV		EQU	$
		LDX	EDITMOD
		JSR	(!EDITSUB,X)
;
		PLB
		RTL
;
;----------------------------------------------------------------
;-		edit mode					-
;----------------------------------------------------------------
ED0CTMX		EQU	$-2
		WORD	00070H,0FF90H,00070H,0FF90H
ED0CTAD		EQU	$-2
		WORD	00004H,0FFFCH,00004H,0FFFCH
;
ED0MV0000	EQU	$
;
;-------------- map scroll check ------------------------
;
		M16
;
		LDA	KEYA1
		AND	#00000011B
		BEQ	ED0MV0002	;map H scroll ? ( no:ED0MV0002 )
;
		ASL	A
		TAX
		LDA	EDCENTX
		CMP	!ED0CTMX,X
		BEQ	ED0MV0002
		CLC
		ADC	!ED0CTAD,X
		STA	EDCENTX
		STZ	EDITMOD		;bit map write "ON" !!
;
ED0MV0002	EQU	$
		LDA	KEYA1
		AND	#00001100B
		BEQ	ED0MV0004	;map V scroll ? ( no:ED0MV0004 )
;
		LSR	A
		TAX
		LDA	EDCENTY
		CMP	!ED0CTMX+2,X
		BEQ	ED0MV0004
		CLC
		ADC	!ED0CTAD+2,X
		STA	EDCENTY
		STZ	EDITMOD		;bit map write "ON" !!
;
;
ED0MV0004	EQU	$
		M8			; memory 8bit mode
;
;-------------- mouse cursol set --------------------------------
ED0MV0005	EQU	$
		LDA	!CSRXPS
		CLC
		ADC	<MOUSEBX
		STA	!CSRXPS
		SEC
		SBC	#07H
		STA	>OAM
		LDA	!CSRYPS
		CLC
		ADC	<MOUSEBY
		STA	!CSRYPS
		STA	>OAM+1
;
		LDY	#08EH		;(Y) <-- mouse bottom "OFF" chara no.
		LDA	<MOUSEBS
		AND	#11000000B
		BEQ	ED0MV0010	;bottom "ON" ? ( no:ED0MV0010 )
		LDY	#0A4H		;(Y) <-- mouse bottom "OFF" chara no.
ED0MV0010	EQU	$
		TYA
		STA	>OAM+2
;
;-------------- mouse ------------------------------------------
		JSR	OBITST		; obj initial point set sub
ED0MV0011	EQU	$
		LDA	!CSRYPS
		CMP	#007H
		BCC	ED0MV0020
		CMP	#0A7H
		BCS	ED0MV0020
		JSR	MVOBST
ED0MV0012	EQU	$
		LDA	!CSRXPS
		CMP	#030H
		BCC	ED0MV0020
		CMP	#0D0H
		BCS	ED0MV0020
ED0MV0013	EQU	$
		JSR	PSDSST
		JMP	ED0MV0999
;
ED0MV0020	EQU	$
		LDA	<MOUSEBT
		AND	#11000000B
		BEQ	ED0MV0900
		LDA	!CSRYPS
		CMP	#0B0H
		BCC	ED0MV0900
		CMP	#0F0H
		BCS	ED0MV0900
		LDA	!CSRXPS		; mouse point
		LSR	A		;
		LSR	A		;
		LSR	A		;
		STA	<WORK0		;
		LDA	!CSRYPS		;
		AND	#0F8H		;
		SEC			;
		SBC	#0B0H		;
		ASL	A		;
		ASL	A		;
		ORA	<WORK0		;
		TAX			;
;
		LDA	ED0MV0DT,X	; mode set data read
		STA	!SLCTMD
;
ED0MV0900	EQU	$
		LDA	!SLCTMD
		BEQ	ED0MV0999
		ASL	A
		TAX
		JSR	(ED0MV0SB,X)
;
ED0MV0999	EQU	$
		RTS
;
;
;
ED0MV0SB	EQU	$-2
		WORD	PUTMD		; 1
		WORD	MOVEMD		; 2
		WORD	CLRMD		; 3
		WORD	PSETMD		; 4
		WORD	MAPMD		; 5
		WORD	FILEMD		; 6
		WORD	MENUMD		; 7
		WORD	INSMD		; 8
		WORD	SIFTMD		; 9
		WORD	UTNOSTH		; A
		WORD	UTNOSTL		; B
		WORD	ZOMSZST		; C
		WORD	SFXYZ05		; D
		WORD	SFXYZ15		; E
		WORD	SFXYZ25		; F
;
		WORD	SFXYZ05		; 10
		WORD	SFXYZ15		; 11
		WORD	SFXYZ25		; 12
		WORD	UTNOINT		; 13
		WORD	MPDTCHG		; 14
		WORD	MPDTCHG		; 15
		WORD	MPDTCHG		; 16
		WORD	MPDTCHG		; 17
		WORD	MPDTCHG		; 18
		WORD	MPDTCHG		; 19
		WORD	MPDTCHG		; 1A
		WORD	MPDTCHG		; 1B
;
;
;****************************************************************
;*								*
;*	PUT , MOVE , CLR mode					*
;*								*
;****************************************************************
PUTMD		EQU	$
MOVEMD		EQU	$
CLRMD		EQU	$
PSETMD		EQU	$
MAPMD		EQU	$
FILEMD		EQU	$
MENUMD		EQU	$
INSMD		EQU	$
SIFTMD		EQU	$
		LDA	!POINTFG	; map point data set mode ON ?
		BEQ	PMC007		;	NO -> PMC007
		LDA	!NXTFLG		; next point set flag ON ?
		BEQ	PMC0059		;	NO -> PMC0059
		LDA	!SLCTMD
		CMP	#001H
		BEQ	PMC0059
		CMP	#007H
		BEQ	PMC0059
		JMP	PMC999
PMC0059		EQU	$
		LDA	!SLCTMD
		CMP	#004H
		BEQ	PMC006
		CMP	#005H
		BEQ	PMC006
		CMP	#006H
		BNE	PMC007
PMC006		EQU	$
		JMP	PMC999
PMC007		EQU	$
		LDA	!SLCTMD
		CMP	!SLTMDS
		BNE	PMC008
		JMP	PMC999
PMC008		EQU	$
		CMP	#006H
		BCS	JJJJJJ
		STZ	!SFTFLG
;
JJJJJJ		EQU	$
		LDA	!UTONFG
		BEQ	PMC009
;;;;K;;;;		BEQ	MDSET
		STZ	!UTONFG
		STZ	!ZRXPOS
		STZ	!ZRZPOS
		LDA	!SLTMDS
		CMP	#002H
		BNE	PMC009
;;;;K;;;;		BNE	MDSET
		I16				; index 16bit mode
		LDX	!UTPSAD
		LDA	!UNITNO			; UNIT data set
		STA	!MPOBJTYP+000H,X	;
		STZ	!EDITMOD
		I8				; index 8bit mode
;
PMC009		EQU	$
		LDA	!SLCTMD
		CMP	#001H		; "PUT" mode ?
		BNE	MDSET		;	NO -> MDSET
;;;;K;;;;		BNE	PMC050
;;;;K;;;;		LDX	!SLTMDS
;;;;K;;;;		CPX	#004H
;;;;K;;;;		BNE	PMC050
		LDA	!UNTNOBF
		BEQ	MDSET
		STA	!UNITNO
		JSR	UTNOIT		; unit NO. mo-do-su
		STZ	!UNTNOBF
		LDX	#000H
		JSR	EMNST		; edit mode name set
;;K;;		BRA	PMC090
;
MDSET		EQU	$
		LDA	!SLTMDS
		DEC	A
		TAX
		ASL	A
		ASL	A
		ASL	A
		TAY
		LDA	PMCADR,X
		TAX
		M16			; memory 16bit mode
		LDA	#PMCDT0
		STA	<WORK0
		JSR	PMC000
		M8			; memory 8bit mode
		STZ	!INSFLG
		LDA	#0FFH
		STA	!INSFLG+1
;
		LDA	!SLCTMD
		DEC	A
		TAX
		ASL	A
		ASL	A
		ASL	A
		TAY
		LDA	PMCADR,X
		TAX
		M16			; memory 16bit mode
		LDA	#PMCDT1
		STA	<WORK0
		JSR	PMC000
		M8			; memory 8bit mode
;
PMC050		EQU	$
		LDA	#07FH
		STA	>DATACOL+105H
		LDA	!SLCTMD
		CMP	#004H		; "P.SET" mode ?
		BNE	PMC060		;	NO -> PMC060
		LDA	!UNITNO
		STA	!UNTNOBF
		LDA	#07BH
		STA	!UNITNO
		JSR	UTNOIT		; "P.SET" unit NO. set
		LDX	#001H
		JSR	EMNST		; edit mode name set
		BRA	PMC080
;
PMC060		EQU	$
		CMP	#006H		; "FILE" mode ?
		BNE	PMC070		;	NO -> PMC070
		INC	!MODENO
		JSR	OBJMPBF		; obj -> map data buffer set
		JMP	PMC999
;
PMC070		EQU	$
		CMP	#005H		; "MAP" mode ?
		BNE	PMC080		;	NO -> PMC080
		STZ	!MPLMODE
		LDA	#MPTS
		STA	!MODENO
;
PMC080		EQU	$
		CMP	#007H		; "MENU" mode ?
		BNE	PMC090		;	NO -> PMC090
		LDA	#MNU0
		STA	!MODENO
;
PMC090		EQU	$
		CMP	#008H
		BNE	PMC093
		LDA	#000H
		STA	>DATACOL+105H
;
PMC093		EQU	$
		LDA	!SLCTMD
		STA	!SLTMDS
		INC	!EDTBFFG
;
		LDA	!POINTFG
		BNE	PMC999
		LDX	#000H
		LDA	!UNTNOBF
		BEQ	PMC095
		LDX	#004H
PMC095		EQU	$
		M16			; memory 16bit mode
		LDA	COLORDT,X
		STA	>DATACOL+046H
		LDA	COLORDT+2,X
		STA	>DATACOL+04CH
		M8			; memory 16bit mode
;
PMC999		EQU	$
		STZ	!SLCTMD
		RTS
;
;-------------------------- mode set sub
		MEM16
PMC000		EQU	$
		LDA	#00004H
		STA	<WORK2
PMC010		EQU	$
		LDA	(<WORK0),Y
		STA	!EDITBF,X
		INX
		INX
		INY
		INY
		DEC	<WORK2
		BNE	PMC010
		RTS
		MEM8
;---------------------------
;
PMCADR		EQU	$
		BYTE	024H,02CH,034H
		BYTE	064H,06CH,074H
		BYTE	0A4H,0ACH,0B4H
;
PMCDT0		EQU	$				; OFF
		WORD	005B4H,005B5H,005B6H,005B7H	; 1 PUT
		WORD	005A4H,005A5H,005A6H,005A7H	; 2 MOVE
		WORD	005BCH,005BDH,005BEH,005BFH	; 3 CLR
		WORD	005A0H,005A1H,005A2H,005A3H	; 4 P.SET
		WORD	005FAH,005FBH,005FCH,005FDH	; 5 MAP
		WORD	005F6H,005F7H,005F8H,005F9H	; 6 FILE
		WORD	005B0H,005B1H,005B2H,005B3H	; 7 MENU
		WORD	005B8H,005B9H,005BAH,005BBH	; 8 INS
		WORD	005F2H,005F3H,005F4H,005F5H	; 9 SIFT
;
PMCDT1		EQU	$				; ON
		WORD	001B4H,001B5H,001B6H,001B7H	; 1 PUT
		WORD	001A4H,001A5H,001A6H,001A7H	; 2 MOVE
		WORD	001BCH,001BDH,001BEH,001BFH	; 3 CLR
		WORD	001A0H,001A1H,001A2H,001A3H	; 4 P.SET
		WORD	001FAH,001FBH,001FCH,001FDH	; 5 MAP
		WORD	001F6H,001F7H,001F8H,001F9H	; 6 FILE
		WORD	001B0H,001B1H,001B2H,001B3H	; 7 MENU
		WORD	001B8H,001B9H,001BAH,001BBH	; 8 INS
		WORD	001F2H,001F3H,001F4H,001F5H	; 9 SIFT
;
COLORDT		EQU	$
		WORD	06E8DH,055A3H	; a-o
		WORD	0811FH,00918H	; a-ka
;
;
;****************************************************************
;*								*
;*	UINIT NO. set						*
;*								*
;****************************************************************
UTLMT		EQU	$
		BYTE	07AH,08AH	; unit NO. limt
;
HIDAT		EQU	$
		BYTE	0F0H,010H
;
HISTA		EQU	$
		BYTE	000H,070H
;
LOWDAT		EQU	$
		BYTE	0FFH,001H
;
LOWSTA		EQU	$
		BYTE	079H,001H
;--------------------------------------- high set
UTNOSTH		EQU	$
		LDA	!POINTFG	; point set mode ?
		BNE	UTNOSTL		;	YES -> UTNOSTL
		LDA	!SFTFLG
		BEQ	UTNOH005
		JMP	UTNOL90
UTNOH005	EQU	$
		LDA	<MOUSEBT
		AND	#11000000B
		BNE	UTNOH00
		JMP	UTNOL90
;
UTNOH00		EQU	$
		ROL	A
		ROL	A
		ROL	A
		AND	#00000001B
		TAX
		LDY	!SLTMDS
		CPY	#004H		; "P.SET" mode ?
		BEQ	UTNOL13		;	YES -> UTNOL13
		LDA	!UNITNO
		CLC
		ADC	HIDAT,X
		STA	!UNITNO
		BNE	UTNOH05
		LDA	#001H
		BRA	UTNOH08
UTNOH05		EQU	$
		CMP	UTLMT
		BCC	UTNOH90
		AND	#00FH
		ORA	HISTA,X
UTNOH08		EQU	$
		STA	!UNITNO
;
UTNOH90		EQU	$
		JMP	UTNOHL
;
;--------------------------------------- low set
UTNOSTL		EQU	$
		LDA	!POINTFG	; point set mode ?
		BNE	UTNOL003	;	YES -> UTNOL90
		LDA	!SFTFLG
		BEQ	UTNOL005
UTNOL003	EQU	$
		JMP	UTNOL90
UTNOL005	EQU	$
		LDA	<MOUSEBT
		AND	#11000000B
		BNE	UTNOL10
		JMP	UTNOL90
;
UTNOL10		EQU	$
		ROL	A
		ROL	A
		ROL	A
		AND	#00000001B
		TAX
UTNOL13		EQU	$
		LDA	!UNITNO
		CLC
		ADC	LOWDAT,X
		STA	!UNITNO
		LDY	!SLTMDS
		CPY	#004H		; "P.SET" mode ?
		BEQ	UTNOL30		;	YES -> UTNOL30
		LDA	!UNITNO
		BEQ	UTNOL15
		CMP	UTLMT
		BCC	UTNOHL
UTNOL15		EQU	$
		LDA	LOWSTA,X
		STA	!UNITNO
		BRA	UTNOHL
;
UTNOL30		EQU	$		; "P.SET" mode limt check
		LDA	#07BH
		STA	!UNITNO
;
;;;;K;;;;		TXA
;;;;K;;;;		BEQ	UTNOL35
;;;;K;;;;		LDA	!UNITNO
;;;;K;;;;		CMP	UTLMT+1
;;;;K;;;;		BCC	UTNOHL
;;;;K;;;;		LDA	UTLMT
;;;;K;;;;		STA	!UNITNO
;;;;K;;;;		BRA	UTNOHL
;;;;K;;;;UTNOL35		EQU	$
;;;;K;;;;		LDA	!UNITNO
;;;;K;;;;		CMP	UTLMT
;;;;K;;;;		BCS	UTNOHL
;;;;K;;;;		LDA	UTLMT+1
;;;;K;;;;		STA	!UNITNO
;
UTNOHL		EQU	$
;
;-------------- 1 parts chara set -----------------------
		JSR	UNITCHST
;
		M16
;
		LDA	#EDCNVSTX
		STA	>R14		;convert status data address(L,H)
		LDA	#BANK EDCNVSTX
		STA	>R0		;		"           (B)
		LDX	#BANK MPBFCNV
		LDA	#MPBFCNV
		JSL	>CHIPON
;
		M8
;
		INC	EDDMAFG		;1 parts DMA "ON" !!
;
;-------------- aada kooda ------------------------------
;
		LDA	!SFTFLG		; sift mode ?
		BEQ	SFUT00		;	NO -> SFUT00
		I16			; index 16bit mode
		LDX	!UTPSAD
		LDA	!UNITNO
		STA	!MPOBJTYP,X
		I8			; index 8bit mode
		STZ	!EDITMOD	; bit map write "ON" !!
		BRA	UTNODSP
;
SFUT00		EQU	$
		LDA	!SLTMDS
		CMP	#004H		; "P.SET" mode ?
		BEQ	UTNODSP		;	YES -> UTNODSP
		CMP	#008H		; "INS" mode ?
		BEQ	UTNODSP		;	YES -> UTNODSP
		LDA	!SLCTMD
		CMP	#001H		; "PUT" mode ?
		BEQ	UTNODSP		;	YES -> UTNODSP
		LDA	#001H
		STA	!SLCTMD
		JSR	MDSET		; mode initial set
;
UTNODSP		EQU	$
		M16			; memory 16bit mode
		LDA	!UNITNO
		AND	#0000FH
		STA	<WORK0
		LDA	!UNITNO
		AND	#000F0H
		LSR	A
		LSR	A
		LSR	A
		LSR	A
		STA	<WORK2
;
		LDA	<WORK0
		CMP	#0000AH
		BCC	UTNO000
		SEC
		SBC	#0000AH
		ORA	#00170H
		BRA	UTNO010
UTNO000		EQU	$
		ORA	#00190H
UTNO010		EQU	$
		STA	!EDITBF+04AH
;
		LDA	<WORK2
		CMP	#0000AH
		BCC	UTNO050
		SEC
		SBC	#0000AH
		ORA	#00170H
		BRA	UTNO060
UTNO050		EQU	$
		ORA	#00190H
UTNO060		EQU	$
		STA	!EDITBF+048H
;
		I16			; index 16bit mode
		LDA	!UNITNO		; UNIT name set
		AND	#000FFH
		ASL	A
		TAX
		LDA	EDNMAD,X
		STA	<WORK0
		LDY	#00000H
UTNO100		EQU	$
		LDA	(<WORK0),Y
		STA	!EDITBF+106H,Y
		INY
		INY
		CPY	#00018H
		BNE	UTNO100
		MI8			; memory , index 8bit mode
;
		INC	<EDTBFFG
UTNOL90		EQU	$
		RTS
;
;
;****************************************************************
;*								*
;*	ZOOM SIZE set						*
;*								*
;****************************************************************
ZOMSZST		EQU	$
		LDA	<MOUSEBT
		AND	#11000000B
		BEQ	ZOM999
;
		CLC
		ROL	A
		ROL	A
		ROL	A
		ROL	A
		TAX
		M16			; memory 16bit mode
		LDA	!EDZOOM
		CMP	ED0ZMMX,X
		BEQ	ZOM000
		CLC
		ADC	ED0ZMAD,X
		STA	!EDZOOM
		STZ	!EDITMOD	; bit map write "ON" !!
;-------------- unit no. parts chara set ------------------------
		JSR	UNITCHST
;
ZOM000		EQU	$
		M8			; memory 8bit mode
;
ZOM500		EQU	$
		STZ	<WORK1
		LDA	!EDZOOM
		LSR	A
		LSR	A
		LSR	A
		LSR	A
		STA	<WORK0
		LDA	!EDZOOM+1
		BNE	ZOM510
		LDA	#010H
		SEC
		SBC	<WORK0
		STA	<WORK0
ZOM510		EQU	$
		M16			; memory 16bit mode
		LDA	<WORK0
		ORA	#00190H
		STA	!EDITBF+056H
		LDA	<WORK0
		BNE	ZOM520
		LDX	#000H
		BRA	ZOM530
ZOM520		EQU	$
		LDA	!EDZOOM+1
		ASL	A
		TAX
ZOM530		EQU	$
		LDA	ZOMDAT,X
		STA	!EDITBF+054H
		M8			; memory 8bit mode
		INC	!EDTBFFG
;
ZOM999		EQU	$
		RTS
;
;
ED0ZMMX		EQU	$-2
		WORD	00080H,00180H,00080H
ED0ZMAD		EQU	$-2
		WORD	0FFF0H,00010H,0FFF0H
ZOMDAT		EQU	$
		WORD	0018EH,0018DH
;
;
;****************************************************************
;*								*
;*	sift X Y Z point set					*
;*								*
;****************************************************************
SFXYZ05		EQU	$
		LDA	<MOUSEBT
		AND	#11000000B
		BNE	SFXYZ055
		JMP	SFXYZ99
SFXYZ055	EQU	$
		LDX	!SFTFLG
		BNE	SFXYZ058
		JMP	SFXYZ99
SFXYZ058	EQU	$
		I16			; index 16bit mode
		JSR	PTSIFT_SB
		LDX	!UTPSAD
		JSR	SFXYZSB
SFXYZ0		EQU	$		; X point set
		STZ	<WORK4
		LDX	!UTPSAD
		LDY	!MPOBJTYP+1,X
		LDX	#00000H
		BRA	SFXYZ
;
;
SFXYZ15		EQU	$
		LDA	<MOUSEBT
		AND	#11000000B
		BEQ	SFXYZ99
		LDX	!SFTFLG
		BEQ	SFXYZ99
		I16			; index 16bit mode
		JSR	PTSIFT_SB
		TYA
		BMI	SFXYZ15_00
		INY
		INY
SFXYZ15_00	EQU	$
		LDX	!UTPSAD
		INX
		INX
		JSR	SFXYZSB
SFXYZ1		EQU	$		; Y point set
		STZ	<WORK4
		LDX	!UTPSAD
		LDY	!MPOBJTYP+3,X
		LDX	#00002H
		BRA	SFXYZ
;
;
SFXYZ25		EQU	$
		LDA	<MOUSEBT
		AND	#11000000B
		BEQ	SFXYZ99
		LDX	!SFTFLG
		BEQ	SFXYZ99
		I16			; index 16bit mode
		JSR	PTSIFT_SB
		TYA
		BMI	SFXYZ25_00
		INY
SFXYZ25_00	EQU	$
		LDX	!UTPSAD
		INX
		JSR	SFXYZSB
SFXYZ2		EQU	$		; Z point set
		STZ	<WORK4
		LDX	!UTPSAD
		LDY	!MPOBJTYP+2,X
		LDX	#00004H
;
SFXYZ		EQU	$
		JSR	SFXYZST
		LDA	!POINTFG
		BEQ	SFXYZ99
		MI16			; memory , index 16bit mode
		LDA	!UTPSAD
		AND	#0FFFCH
		TAX
		STZ	!ZRXPOS
		STZ	!ZRZPOS
		M8			; memory 8bit mode
		LDA	!MPOBJTYP+1,X
		STA	!EDMPXPS
		LDA	!MPOBJTYP+2,X
		STA	!EDMPZPS
		LDA	!MPOBJTYP+3,X
		STA	!EDMPYPS
		I8			; index 8bit mode
		JSR	PTMVST		; point set mode move set
SFXYZ99		EQU	$
		RTS
;
;
;------------------ sift inc. dec.  ------------------
		IDX16
SFXYZSB		EQU	$
		LDA	<MOUSEBT
		AND	#01000000B	; left ON ?
		BEQ	SFSB50		;	NO -> SFSB50
		LDA	!SLCTMD
		CMP	#010H
		BCC	SFSB45
		LDA	!MPOBJTYP+1,X
		CLC
		ADC	#010H
		STA	!MPOBJTYP+1,X
		TYA
		BMI	SFSB99
		TYX
		LDA	>MPTDAT+1,X
		CLC
		ADC	#010H
		STA	>MPTDAT+1,X
		BRA	SFSB99
SFSB45		EQU	$
		INC	!MPOBJTYP+1,X
		TYA
		BMI	SFSB99
		TYX
		LDA	>MPTDAT+1,X
		CLC
		ADC	#001H
		STA	>MPTDAT+1,X
		BRA	SFSB99
SFSB50		EQU	$
		LDA	!SLCTMD
		CMP	#010H
		BCC	SFSB55
		LDA	!MPOBJTYP+1,X
		SEC
		SBC	#010H
		STA	!MPOBJTYP+1,X
		TYA
		BMI	SFSB99
		TYX
		LDA	>MPTDAT+1,X
		SEC
		SBC	#010H
		STA	>MPTDAT+1,X
		BRA	SFSB99
SFSB55		EQU	$
		DEC	!MPOBJTYP+1,X
		TYA
		BMI	SFSB99
		TYX
		LDA	>MPTDAT+1,X
		SEC
		SBC	#001H
		STA	>MPTDAT+1,X
SFSB99		EQU	$
		STZ	!EDITMOD	; bit map write "ON" !!
		RTS
		IDX8
;
;
;------------------ X Y Z disp set ------------------
SFXYZST		EQU	$
		I8			; index 8bit mode
		TYA
		BPL	SFXYZPS
		EOR	#0FFH
		INC	A
		INC	<WORK4
		INC	<WORK4
SFXYZPS		EQU	$
		TAY
		AND	#00FH
		STA	<WORK0
		STZ	<WORK1
		TYA
		AND	#0F0H
		LSR	A
		LSR	A
		LSR	A
		LSR	A
		STA	<WORK2
		STZ	<WORK3
		STZ	<WORK5
;
		MI16			; memory , index 16bit mode
		LDY	PSDSDAT,X
		JSR	XYZDSP
		MI8			; memory , index 8bit mode
		LDA	#001H
		STA	!EDTBFFG
		RTS
;
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	v[[ړf[^ (Vtg[h)	+
;+			out			+
;+			Y <- MPTDAT index	+
;++++++++++++++++++++++++++++++++++++++++++++++++
		IDX16
PTSIFT_SB	EQU	$
		LDY	!UTPSAD
		LDX	#00000H
		LDA	!MPOBJTYP,Y
		CMP	#07BH
		BNE	PTSIFT_SB_30
		M16			; memory 16bit mode
		LDA	!MPTCNT1
		ASL	A
		ASL	A
		STA	<WORK0
		LDA	!MPOBJTYP+1,Y
PTSIFT_SB_10	EQU	$
		CMP	>MPTDAT+1,X
		BEQ	PTSIFT_SB_90
		INX
		INX
		INX
		INX
		CPX	<WORK0
		BCC	PTSIFT_SB_10
		M8			; memory 8bit mode
PTSIFT_SB_30	EQU	$
		LDX	#0FFFFH
;
PTSIFT_SB_90	EQU	$
		TXY
		M8			; memory 8bit mode
		RTS
		IDX8
;
;
;****************************************************************
;*								*
;*	point disp set						*
;*								*
;****************************************************************
UTNOINT		EQU	$
		LDA	!POINTFG
		BNE	UTNOIT9
		LDA	!SLTMDS
		CMP	#009H		; now "SIFT" mode ?
		BEQ	UTNOIT9		;	YES -> UTNOIT9
		CMP	#004H		; 'P.SET" mode ?
		BNE	UTNOIT0		;	NO -> UTNOIT0
		LDA	#07BH
		STA	!UNITNO
		BRA	UTNOIT
UTNOIT0		EQU	$
		LDA	#001H
		STA	!UNITNO
;
UTNOIT		EQU	$
		JSR	UTNODSP		; unit NO. set
;
		JSR	UNITCHST	; unit no. parts chara set
;
		M16
;
		LDA	#EDCNVSTX
		STA	>R14		;convert status data address(L,H)
		LDA	#BANK EDCNVSTX
		STA	>R0		;		"           (B)
		LDX	#BANK MPBFCNV
		LDA	#MPBFCNV
		JSL	>CHIPON
;
		M8
;
		INC	EDDMAFG		;1 parts DMA "ON" !!
;
UTNOIT9		EQU	$
		RTS
;
;
;****************************************************************
;*								*
;*	map data change						*
;*								*
;****************************************************************
MPDTCHG		EQU	$
;;;;K;;;;		LDA	!POINTFG
;;;;K;;;;		BNE	MDCH99
		JSR	OBJMPBF		; obj -> map data buffer set
;
		LDA	#005H
		STA	!EDITBF+05BH
		STA	!EDITBF+05DH
		STA	!EDITBF+05FH
		STA	!EDITBF+061H
		STA	!EDITBF+09BH
		STA	!EDITBF+09DH
		STA	!EDITBF+09FH
		STA	!EDITBF+0A1H
;
		LDA	!SLCTMD
		SEC
		SBC	#014H
		ASL	A
		TAX
		STX	!MPCHGFG
		STX	!MPTYPE		; map type set
		M16			; memory 16bit mode
		LDA	MPDTDT,X
		STA	<WORK0
		M8			; memory 8bit mode
		LDA	#001H
		STA	(<WORK)
;
		JSL	>UNMPBF		; map data buffer set
;
		LDA	#004H
		STA	!EDITMOD	; `FW [h !!
		INC	<EDTBFFG
MDCH99		EQU	$
		RTS
;
MPDTDT		EQU	$
		WORD	EDITBF+05BH,EDITBF+05DH,EDITBF+05FH
		WORD	EDITBF+061H,EDITBF+09BH,EDITBF+09DH
		WORD	EDITBF+09FH,EDITBF+0A1H
;
;
;****************************************************************
;*								*
;*		`FW					*
;*				tF[h C			*
;****************************************************************
ILAND_1000	EQU	$
		DEC	!FADNO
		BNE	ILAND_1900
		LDA	#080H
		STA	!FADNO
		INC	!EDITMOD
		INC	!EDITMOD
;
ILAND_1900	EQU	$
		RTS
;
;
;****************************************************************
;*								*
;*		`FW					*
;*				J[ `FW			*
;****************************************************************
ILAND_2000	EQU	$
		JSL	>BLNKON
;
		JSL	>MPCOLST	; }bvJ[ Zbg
;
		PHB			;(DBR) save
		LDA	#BANK DATACOL
		PHA
		PLB
		M16			; memory 16bit mode
		LDX	#000H
ILAND_2050	EQU	$
		LDA	>8D200H+(10H*2),X
		STA	DATACOL+(20H*2),X
		INX
		INX
		CPX	#020H
		BCC	ILAND_2050
		LDA	#00000H
		STA	!DATACOL	; nuki color set
		M8			; memory 8bit mode
		PLB
;
		INC	!EDITMOD
		INC	!EDITMOD
		JSL	>BLNKOFF
		RTS
;
;
;****************************************************************
;*								*
;*		`FW					*
;*				LN^[ `FW		*
;****************************************************************
ILAND_3000	EQU	$
		JSL	>BLNKON
;
		JSL	>MPCHRST	; }bvLN^[ Zbg
;
		JSR	UNITCHST
;
		INC	!EDITMOD
		INC	!EDITMOD
		JSL	>BLNKOFF
		RTS
;
;
;****************************************************************
;*								*
;*		`FW					*
;*				XN[ `FW		*
;****************************************************************
ILAND_4000	EQU	$
		JSL	>BLNKON
;
		M16			; memory 16bit mode
		JSR	M7SETSUB	; mode 7 screen set
		M8			; memory 8bit mode
;
		STZ	!FADNO
		INC	!EDITMOD
		INC	!EDITMOD
		JSL	>BLNKOFF
		RTS
;
;
;****************************************************************
;*								*
;*		`FW					*
;*				tF[h AEg			*
;****************************************************************
ILAND_5000	EQU	$
		INC	!FADNO
		LDA	!FADNO
		AND	#00FH
		STA	!FADNO
		CMP	#00FH
		BCC	ILAND_4900
		LDA	#001
		STA	!SLCTMD
		STZ	!EDITMOD	; bit map write "ON" !!
;
ILAND_4900	EQU	$
		RTS
;
;
;********************************************************
;*							*
;*	point disp set					*
;*							*
;********************************************************
PSDSST		EQU	$
		M16			; memory 16bit mode
		LDX	#BANK EDPOSCNV
		LDA	#EDPOSCNV
		JSL	>CHIPON
		I16			; index 16bit mode
		STZ	<WORK8
		LDA	!SFTFLG
		AND	#000FFH
		BNE	PSDSL90
		LDA	!EDMPXPS	; mouse cursol X point set
		BPL	PSDS50
		EOR	#000FFH
		INC	A
PSDS50		EQU	$
		STA	<WORKA
		LDA	!EDMPYPS	; mouse cursol Y point set
		BPL	PSDS60
		EOR	#000FFH
		INC	A
PSDS60		EQU	$
		STA	<WORKC
		LDA	!EDMPZPS	; mouse cursol Z point set
		BPL	PSDS70
		EOR	#000FFH
		INC	A
PSDS70		EQU	$
		STA	<WORKE
PSDSLOP		EQU	$		; mouse cursol disp set
		LDX	<WORK8
		LDA	<WORKA,X
		AND	#0000FH
		STA	<WORK0
		LDA	<WORKA,X
		AND	#000F0H
		LSR	A
		LSR	A
		LSR	A
		LSR	A
		STA	<WORK2
		STZ	<WORK4
		LDA	<WORKA,X
		BPL	PSDSL00
		INC	<WORK4
		INC	<WORK4
PSDSL00		EQU	$
		LDY	PSDSDAT,X
		JSR	XYZDSP
		INC	<WORK8
		INC	<WORK8
		LDA	<WORK8
		CMP	#00006H
		BNE	PSDSLOP
;
PSDSL90		EQU	$
		MI8			; memory , index 8bit mode
		LDA	!SLTMDS
		ASL	A
		TAX
		JSR	(PMCMFMD,X)
		INC	!EDTBFFG
		RTS
;
		MEM16
		IDX16
XYZDSP		EQU	$		; X,Y,Z disp set sub
		LDX	<WORK4
		LDA	XYZDAT,X
		STA	!EDITBF,Y
		LDA	<WORK2
		CMP	#0000AH
		BCS	XYZ000
		ORA	#00190H
		BRA	XYZ010
XYZ000		EQU	$
		SEC
		SBC	#0000AH
		ORA	#00170H
XYZ010		EQU	$
		STA	!EDITBF+02H,Y
;
		LDA	<WORK0
		CMP	#0000AH
		BCS	XYZ020
		ORA	#00190H
		BRA	XYZ030
XYZ020		EQU	$
		SEC
		SBC	#0000AH
		ORA	#00170H
XYZ030		EQU	$
		STA	!EDITBF+04H,Y
		RTS
;
		MEM8
		IDX8
;
PSDSDAT		EQU	$
		WORD	00126H,0012EH,00136H
;
XYZDAT		EQU	$
		WORD	0018EH,0018DH
;
PMCMFMD		EQU	$-2
		WORD	PTSET	; 1
		WORD	MVSET	; 2
		WORD	CRSET	; 3
		WORD	PSET	; 4
		WORD	MPSET	; 5
		WORD	FLSET	; 6
		WORD	MNSET	; 7
		WORD	INSST	; 8
		WORD	SFINT	; 9
;
;
;################################################
;#						#
;#	put mode				#
;#						#
;################################################
PTSET		EQU	$
		LDA	!UTONFG
		BEQ	PT500
		LDA	<MOUSEBT
		AND	#11000000B
		BEQ	PT990
		AND	#10000000B
		BNE	PT900
;
		I16			; index 16bit mode
		LDA	!POINTFG
		BEQ	PT300
		LDX	!MPOBJSTN
		CPX	#MPOBJN
		BCS	PT990
		JSR	POTSET		; point data set
		BRA	PT990
PT300		EQU	$
		LDX	!MPTCNT0
		CPX	#MPOBJN-16
		BCS	PT990
		M16			; memory 16bit mode
;;;;K;;;;		LDA	!MPOBJSTN
		LDA	!MPTCNT0
		ASL	A
		ASL	A
		TAX
		M8			; memory 8bit mode
		LDA	!UNITNO			; UNIT data set
		STA	!MPOBJTYP+000H,X	;
		LDA	!EDMPXPS		;
		STA	!MPOBJTYP+001H,X	;
		LDA	!EDMPZPS		;
		STA	!MPOBJTYP+002H,X	;
		LDA	!EDMPYPS		;
		STA	!MPOBJTYP+003H,X	;
		INC	!MPTCNT0
		STZ	<WORKE
		JSR	MPDPNT		; map data , point data	 marge
		BRA	PT999
PT900		EQU	$
		STZ	!UTONFG
		STZ	!ZRXPOS
		STZ	!ZRZPOS
PT990		EQU	$
		I8			; index 8bit mode
		JMP	PT999
;
;
PT500		EQU	$
		LDA	<MOUSEBT
		AND	#01000000B	; mouse left ON ?
		BEQ	PT999		;	NO -> PT999
		M16			; memory 16bit mode
		LDX	#BANK EDPOSCNV
		LDA	#EDPOSCNV
		JSL	>CHIPON
;
		LDX	#BANK EDSARCH
		LDA	#EDSARCH
		JSL	>CHIPON
;
		I16			; index 16bit mode
		LDA	>R0
		TAX
		M8			; memory 8bit mode
		CPX	#0FFFFH
		BEQ	PT999
		STX	<WORK0
;
		LDA	!NXTFLG		; next point set flag ON ?
		BNE	PT580		;	YES -> PT580
		LDA	!MPOBJTYP,X
		STA	!UNITNO
		BRA	PT800
;
PT580		EQU	$
		JSR	NXTSET		; next point set
;
PT800		EQU	$
		I8			; index 8bit mode
;
		JSR	UTNODSP
		JSR	UNITCHST	; unit no. parts chara set
;
		M16			; memory 16bit mode
		LDA	#EDCNVSTX
		STA	>R14		;convert status data address(L,H)
		LDA	#BANK EDCNVSTX
		STA	>R0		;		"           (B)
		LDX	#BANK MPBFCNV
		LDA	#MPBFCNV
		JSL	>CHIPON
		M8			; memory 8bit mode
;
		INC	EDDMAFG		;1 parts DMA "ON" !!
;
PT999		EQU	$
		I8			; index 8bit mode
		RTS
;
;
;################################################
;#						#
;#	move mode				#
;#						#
;################################################
MVSET		EQU	$
		LDA	!NXTFLG
		BNE	MV000
		LDA	!UTONFG
		BNE	MV500
		LDA	<MOUSEBT
		AND	#01000000B
		BNE	MV005
MV000		EQU	$
		JMP	MV999
MV005		EQU	$
		M16			; memory 16bit mode
		LDX	#BANK EDPOSCNV
		LDA	#EDPOSCNV
		JSL	>CHIPON
;
		LDX	#BANK EDSARCH
		LDA	#EDSARCH
		JSL	>CHIPON
;
		I16			; index 16bit mode
		LDA	>R0
		TAX
		M8			; memory 8bit mode
		CPX	#0FFFFH
		BEQ	MV099
;;;;K;;;;		BEQ	MV999
		LDA	!POINTFG	; point set mode ?
		BEQ	MV100		;	NO -> MV100
		CPX	#00258H		; index > 258h ?
		BCS	MV100		;	YES -> MV100
MV099		EQU	$
		JMP	MV999
MV100		EQU	$
		STX	!UTPSAD
;
		JSR	MVZRST		; zu-re point set
;
		JSR	PTMVADRSHC	; player move point data adress
;
		I16			; index 16bit mode
		LDX	!UTPSAD
		STZ	!MPOBJTYP,X
		STZ	!EDITMOD
		JSR	UTNODSP
		INC	!UTONFG
		JMP	MV999
;
MV500		EQU	$
		LDA	<MOUSEBT
		AND	#11000000B
		BEQ	MV999
		AND	#01000000B
		BEQ	MV600
;
		LDA	!POINTFG
		BEQ	MV550
		JSR	PTMVST		; point set mode move set
;
MV550		EQU	$
		I16			; index 16bit mode
		LDA	!UNITNO
		CMP	#07BH		;v[[ړ f[^ ?
		BNE	MV550_50	;	NO -> MV550_50
		JSR	PTMVDTST
;
MV550_50	EQU	$
		LDX	!UTPSAD
		LDA	!UNITNO			; UNIT data set
		STA	!MPOBJTYP+000H,X	;
		LDA	!EDMPXPS		;
		CLC				;
		ADC	!ZRXPOS			;
		STA	!MPOBJTYP+001H,X	;
		LDA	!ZRZPOS			;
		CLC				;
		ADC	!EDMPZPS		;
		STA	!MPOBJTYP+002H,X	;
		LDA	!EDMPYPS		;
		STA	!MPOBJTYP+003H,X	;
		BRA	MV990
;
MV600		EQU	$
		I16			; index 16bit mode
		LDX	!UTPSAD
		LDA	!UNITNO			; UNIT data set
		STA	!MPOBJTYP+000H,X	;
;
MV990		EQU	$
		STZ	!EDITMOD
		STZ	!UTONFG
		STZ	!ZRXPOS
		STZ	!ZRZPOS
;
MV999		EQU	$
		I8			; index 8bit mode
		RTS
;
;
		IDX16
MVZRST		EQU	$
		LDA	!MPOBJTYP,X
		STA	!UNITNO
		LDA	!MPOBJTYP+001H,X
		SEC
		SBC	!EDMPXPS
		STA	!ZRXPOS		; X point zu-re set
		LDA	!MPOBJTYP+002H,X
		SEC
		SBC	!EDMPZPS
		STA	!ZRZPOS		; Z point zu-re set
		RTS
		IDX8
;
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	v[[̈ړf[^̈ړ		+
;++++++++++++++++++++++++++++++++++++++++++++++++
		IDX16
PTMVDTST	EQU	$
		M16			; memory 16bit mode
		LDA	!MPTCNT1
		ASL	A
		ASL	A
		STA	<WORK0
		LDY	!UTPSAD
		LDX	#00000H
PTMVDTST_10	EQU	$
		LDA	!MPOBJTYP+001H,Y
		CMP	>MPTDAT+1,X
		BEQ	PTMVDTST_20
		INX
		INX
		INX
		INX
		CPX	<WORK0
		BCC	PTMVDTST_10
		BRA	PTMVDTST_90
;
PTMVDTST_20	EQU	$
		M8			; memory 8bit mode
		LDA	!MPOBJTYP+003H,Y
		CMP	>MPTDAT+3,X
		BNE	PTMVDTST_10
		LDA	!EDMPXPS
		CLC
		ADC	!ZRXPOS
		STA	>MPTDAT+1,X
		LDA	!ZRZPOS
		CLC
		ADC	!EDMPZPS
		STA	>MPTDAT+2,X
		LDA	!EDMPYPS
		STA	>MPTDAT+3,X
;
PTMVDTST_90	EQU	$
		M8			; memory 8bit mode
		RTS
		IDX8
;
;
;################################################
;#						#
;#	clear mode				#
;#						#
;################################################
CRSET		EQU	$
		LDA	!NXTFLG
		BNE	CR050
		LDA	<MOUSEBT
		AND	#01000000B
		BNE	CR100
CR050		EQU	$
		JMP	CR500
CR100		EQU	$
		M16			; memory 16bit mode
		LDX	#BANK EDPOSCNV
		LDA	#EDPOSCNV
		JSL	>CHIPON
;
		LDX	#BANK EDSARCH
		LDA	#EDSARCH
		JSL	>CHIPON
;
		I16			; index 16bit mode
		LDA	>R0
		STA	<WORK4
		TAX
		LDA	!POINTFG
		AND	#000FFH
		BEQ	CR300
		CPX	#00258H
		BCS	CR300
		JMP	CR500
CR300		EQU	$
		LDA	!MPOBJTYP+1,X
		STA	<WORKA
		M8			; memory 8bit mode
		CPX	#0FFFFH
		BEQ	CR999
		LDA	!MPOBJTYP,X
		STA	!UNITNO
		CMP	#07BH
		BNE	CR400
		JSR	MPTCLR		; map point data clear
;
CR400		EQU	$
		PHB
		M16			; memory 16bit mode
		LDA	<WORK4		; obj data ma-e tu-me-ru
		CLC
		ADC	#MPOBJTYP
		STA	<WORK0
		INC	A
		INC	A
		INC	A
		INC	A
		STA	<WORK2
		LDA	!MPOBJSTN
		ASL	A
		ASL	A
		SEC
		SBC	<WORK4
		DEC	A
		STA	<WORK4
		LDX	<WORK2
		LDY	<WORK0
		LDA	<WORK4
		MVN	#BANK MPOBJTYP,#BANK MPOBJTYP
		MI8			; memory , index 8bit mode
		PLB
		LDA	!POINTFG
		BEQ	CR430
		JSR	PTDLST		; point data delete
		MI16			; memory , index 16bit mode
		JSR	PTIDXSB		; point data set index sub
		LDA	!QSTPOS
		AND	#0000FH
		CLC
		ADC	<WORK0
		TAX
		LDA	>MPTQT1,X
		DEC	A
		STA	>MPTQT1,X
		MI8			; memory , index 8bit mode
		DEC	!MPOBJSTN
		STZ	!EDITMOD
		BRA	CR999
;
CR430		EQU	$
		LDX	#000H
		LDA	!UNITNO
		CMP	#07AH
		BCC	CR450
		INX
		INX
CR450		EQU	$
		DEC	!MPTCNT0,X
		LDA	#001H
		STA	<WORKE
		JSR	MPDPNT		; map data , point data	 marge
		JSR	UTNODSP
;
CR500		EQU	$
		M8			; memory 8bit mode
;
CR999		EQU	$
		I8			; index 8bit mode
		RTS
;
;
;################################################
;#						#
;#	p.set mode				#
;#						#
;################################################
PSET		EQU	$
		LDA	!UTONFG
		BEQ	PSET500
		LDA	<MOUSEBT
		AND	#11000000B	; mouse ON ?
		BEQ	PSET499		;	NO -> PSET499
		AND	#10000000B	; mouse right ON ?
		BNE	PSET490		;	YES -> PSET490
;
		LDA	!PTLMTCT
		CMP	#0100
		BCS	PSET490
		LDA	!MPTCNT0
		CLC
		ADC	!MPTCNT1
		CMP	#MPOBJN
		BCS	PSET499
		MI16			; memory , index 16bit mode
		ASL	A
		ASL	A
		TAY
		LDA	!MPTCNT1
		ASL	A
		ASL	A
		TAX
		M8			; memory 8bit mode
		LDA	!UNITNO
		STA	!MPOBJTYP+000H,Y
		STA	>MPTDAT+000H,X
		LDA	!EDMPXPS
		STA	!MPOBJTYP+001H,Y
		STA	>MPTDAT+001H,X
		LDA	!EDMPZPS
		STA	!MPOBJTYP+002H,Y
		STA	>MPTDAT+002H,X
		LDA	!EDMPYPS
		STA	!MPOBJTYP+003H,Y
		STA	>MPTDAT+003H,X
		I8			; index 8bit mode
;
		JSR	MPTDST		; map point data set
;
		INC	!MPTCNT1
		LDA	!MPTCNT0
		CLC
		ADC	!MPTCNT1
		STA	!MPOBJSTN
		STZ	!EDITMOD
		BRA	PSET499
;
PSET490		EQU	$
		STZ	!UTONFG
;
PSET499		EQU	$
		BRA	PSET999
;
PSET500		EQU	$
;
PSET999		EQU	$
		RTS
;
;
;################################################
;#						#
;#	file & map mode				#
;#						#
;################################################
MPSET		EQU	$
FLSET		EQU	$
MNSET		EQU	$
		RTS
;
;
;################################################
;#						#
;#	insert mode				#
;#						#
;################################################
INSST		EQU	$
		LDA	!INSFLG
		BNE	INS100
		LDA	!INSFLG+1
		BPL	INS100
		LDA	<MOUSEBT
		AND	#01000000B	; mouse botton ON ?
		BEQ	INS099		;	NO -> INS099
		LDA	!POINTFG	; point set mode ?
		BEQ	INS999		;	NO -> INS999
;
		STZ	!INSFLG
		LDA	#0FFH
		STA	!INSFLG+1
		M16			; memory 16bit mode
		LDX	#BANK EDPOSCNV
		LDA	#EDPOSCNV
		JSL	>CHIPON
		LDX	#BANK EDSARCH
		LDA	#EDSARCH
		JSL	>CHIPON
		LDA	>R0
		CMP	#0FFFFH
		BEQ	INS099
		CMP	#00258H
		BCC	INS099
		CMP	#00298H
		BCS	INS099
		STA	!INSFLG
;
		JSR	INSSUB
INS099		EQU	$
		M8			; memory 8bit mode
		JMP	INS999
;
INS100		EQU	$
		LDA	<MOUSEBT
		AND	#11000000B	; mouse botton ON ?
		BEQ	INS999		;	NO -> INS999
		AND	#10000000B	; right ON ?
		BNE	INS900		;	YES -> INS900
		LDA	!UTONFG
		BNE	INS105
		JSR	PT500
		BRA	INS999
INS105		EQU	$
		LDA	!MPOBJSTN
		CMP	#0A6H
		BCS	INS900
		JSR	INSMAN		; insert !!
		BRA	INS999
;
INS900		EQU	$
		LDA	#000H
		STA	>DATACOL+105H
		STZ	!UTONFG
		STZ	!INSFLG
		LDA	#0FFH
		STA	!INSFLG+1
		STZ	!ZRXPOS
		STZ	!ZRZPOS
INS999		EQU	$
		RTS
;
;
;################################################
;#						#
;#	sift mode				#
;#						#
;################################################
SFINT		EQU	$
		LDA	!NXTFLG
		BEQ	SFIT05
		JMP	SFIT99
SFIT05		EQU	$
		LDA	<MOUSEBT
		AND	#01000000B
		BEQ	SFIT50
		M16			; memory 16bit mode
		LDX	#BANK EDPOSCNV
		LDA	#EDPOSCNV
		JSL	>CHIPON
;
		LDX	#BANK EDSARCH
		LDA	#EDSARCH
		JSL	>CHIPON
;
		I16			; index 16bit mode
		LDA	>R0
		TAX
		M8			; memory 8bit mode
		CPX	#0FFFFH
		BEQ	SFIT40
		LDA	!POINTFG	; point set mode ?
		BEQ	SFIT10		;	NO -> SFIT10
		CPX	#00258H		; index > 0258h ?
		BCC	SFIT40		;	NO -> SFIT40
SFIT10		EQU	$
		STX	!UTPSAD
		LDA	!MPOBJTYP,X
		STA	!UNITNO
		STZ	!EDITMOD
;
		JSR	PTMVADRSHC	; player move point data adress
;
		I8			; index 8bit mode
		JSR	UTNODSP
		I16			; index 16bit mode
		JSR	SFXYZ0		; X point disp set
		I16			; index 16bit mode
		JSR	SFXYZ1		; Y point disp set
		I16			; index 16bit mode
		JSR	SFXYZ2		; Z point disp set
		LDA	#001H
		STA	!SFTFLG
SFIT40		EQU	$
		I8			; index 8bit mode
		BRA	SFIT99
;
SFIT50		EQU	$
		LDA	<MOUSEBT
		AND	#10000000B
		BEQ	SFIT99
		STZ	!SFTFLG
		LDA	#001H
		STA	!SLCTMD
;;;;K;;;;		STA	!SLTMDS
		JSR	MDSET		; mode disp set
;
SFIT99		EQU	$
		RTS
;
;
;################################################
;#						#
;#	obj initial point set sub		#
;#						#
;################################################
OBITST		EQU	$
		M16			; memory 16bit mode
		LDX	#000H
OBIT00		EQU	$
		LDA	EDIT0OAM+04H,X
		STA	>OAM+04H,X
		INX
		INX
		INX
		INX
		CPX	#024H
		BNE	OBIT00
		M8			; memory 8bit mode
		RTS
;
;
;################################################
;#						#
;#	move obj set				#
;#						#
;################################################
MVOBST		EQU	$
		LDA	!NXTFLG		; next point flag ON ?
		BNE	MVOB005		;	YES -> MVOB005
		LDA	!UTONFG		; unit move flag ON ?
		BNE	MVOB00		;	YES -> MVOB00
		LDA	!SLTMDS
		CMP	#001H		; "PUT" mode ?
		BEQ	MVOB05		;	YES -> MVOB05
		CMP	#004H		; "P.SET" mode ?
		BEQ	MVOB05		;	YES -> MVOB05
		LDA	!POINTFG	; point set mode ?
		BEQ	MVOB005		;	NO -> MVOB005
		LDA	!SLTMDS
		CMP	#008H		; "INS" mode ?
		BNE	MVOB005		;	NO -> MVOB005
		LDA	!INSFLG
		BNE	MVOB05
		LDA	!INSFLG+1
		BPL	MVOB05
MVOB005		EQU	$
		JMP	MVOB99
MVOB05		EQU	$
		LDA	<MOUSEBT
		AND	#01000000B	; left ON ?
		BNE	MVOB08		;	ON -> MVOB99
		JMP	MVOB99
;
MVOB08		EQU	$
		LDA	!CSRYPS
		CMP	#073H
		BCC	MVOB99
		CMP	#097H
		BCS	MVOB99
		LDA	!CSRXPS
		CMP	#00AH
		BCC	MVOB99
		CMP	#02EH
		BCS	MVOB99
;
		INC	!UTONFG
MVOB00		EQU	$
		JSR	OBJZR
		LDA	!CSRXPS		; X pos set
		SEC
		SBC	#014H
		CLC
		ADC	>R1
		STA	>OAM+004H
		STA	>OAM+010H
		STA	>OAM+01CH
		CLC
		ADC	#010H
		STA	>OAM+008H
		STA	>OAM+014H
		STA	>OAM+020H
		CLC
		ADC	#008H
		STA	>OAM+00CH
		STA	>OAM+018H
		STA	>OAM+024H
		LDA	!CSRYPS		; Y pos set
		SEC
		SBC	#015H
		SEC
		SBC	>R2
		STA	>OAM+005H
		STA	>OAM+009H
		STA	>OAM+00DH
		CLC
		ADC	#010H
		STA	>OAM+011H
		STA	>OAM+015H
		STA	>OAM+019H
		CLC
		ADC	#008H
		STA	>OAM+01DH
		STA	>OAM+021H
		STA	>OAM+025H
MVOB99		EQU	$
		RTS
;
;
;++++++++++++++++++++++++++++++++++++++++
;+					+
;+	obj zu-re set			+
;+					+
;++++++++++++++++++++++++++++++++++++++++
OBJZR		EQU	$
		M16			; memory 16bit mode
		LDA	!ZRXPOS
		AND	#000FFH
		STA	>R1
		LDA	!ZRZPOS
		AND	#000FFH
		STA	>R2
		LDX	#BANK EDMPCNV
		LDA	#EDMPCNV
		JSL	>CHIPON
		M8			; memory 8bit mode
		RTS
;
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+						+
;+	insert !!				+
;+						+
;++++++++++++++++++++++++++++++++++++++++++++++++
INSMAN		EQU	$
		MI16			; memory , index 16bit mode
		LDA	!MPOBJSTN
		ASL	A
		ASL	A
		TAX
		M8			; memory 8bit mode
		LDA	!UNITNO
		STA	!MPOBJTYP+000H,X
		LDA	!EDMPXPS
		STA	!MPOBJTYP+001H,X
		LDA	!EDMPZPS
		STA	!MPOBJTYP+002H,X
		LDA	!EDMPYPS
		STA	!MPOBJTYP+003H,X
;
		M16			; memory 16bit mode
		JSR	PTIDXSB		; point data set index sub
		LDX	!MENUNO
		LDA	!QSTCNT,X
		AND	#000FFH
		CLC
		ADC	<WORK0
		TAX
		LDA	>MPTQT1,X
		INC	A
		STA	>MPTQT1,X
		LDA	<WORK2
		CLC
		ADC	#00040H-1
		ADC	#MPT11P
;;K;;		ADC	#MPTNAM
		STA	<WORK0
		DEC	A
		DEC	A
		DEC	A
		DEC	A
		STA	<WORK2
		LDA	<WORK0
		CLC
		SBC	!INSFLG
		CLC
		SBC	#MPT11P+2
		STA	<WORK4
		PHB
		LDX	<WORK2
		LDY	<WORK0
		LDA	<WORK4
		MVP	#BANK MPT11P,#BANK MPT11P
		PLB
		M8			; memory 8bit mode
;
		LDX	!INSFLG
		LDA	#000H		; player type set
		STA	>MPT11P,X
		LDA	!EDMPXPS
		STA	>MPT11X,X
		LDA	!EDMPZPS
		STA	>MPT11Z,X
		LDA	!EDMPYPS
		STA	>MPT11Y,X
;
		M16			; memory 16bit mode
		INC	!INSFLG
		INC	!INSFLG
		INC	!INSFLG
		INC	!INSFLG
		MI8			; memory , index 8bit mode
		INC	!MPOBJSTN
		STZ	!EDITMOD
		RTS
;
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+						+
;+	insert sub				+
;+						+
;++++++++++++++++++++++++++++++++++++++++++++++++
		MEM16
INSSUB		EQU	$
		I16			; index 16bit mode
		LDX	!INSFLG
		LDA	!MPOBJTYP+1,X
		STA	<WORKA
;
		JSR	PTIDXSB
;
		LDX	!MENUNO
		LDA	!QSTCNT,X
		CLC
		ADC	<WORK0
		STA	<WORKC
		LDX	<WORK2
		LDY	#00000H
ISSB00		EQU	$
		LDA	>MPT11X,X
		CMP	<WORKA
		BEQ	ISSB10
		INX
		INX
		INX
		INX
		INY
		CPY	<WORKC
		BRA	ISSB00
ISSB10		EQU	$
		STX	!INSFLG
		LDA	#07FFFH
		STA	>DATACOL+104H
		I8			; index 8bit mode
		RTS
		MEM8
;
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+						+
;+	next point set				+
;+						+
;++++++++++++++++++++++++++++++++++++++++++++++++
		IDX16
NXTSET		EQU	$
		M16			; memory 16bit mode
		LDA	<WORK0
		LSR	A
		LSR	A
		STA	<WORKC
		STZ	<WORKE
		LDX	#00000H
NXTSET_010	EQU	$
		LDA	>MPTTYP,X
		AND	#000FFH
		CMP	!MPTYPE
		BNE	NXTSET_018
		LDA	>MPTPOS,X
		AND	#000FFH
		CMP	<WORKC
		BEQ	NXTSET_100
NXTSET_018	EQU	$
		INC	<WORKE
		TXA
		CLC
		ADC	#0010EH
		TAX
		CMP	#0010EH*100
		BCC	NXTSET_010
		M8			; memory 8bit mode
		BRA	NXT999
;
		MEM16
NXTSET_100	EQU	$
		JSR	PTIDXSB		; point data set index sub
		M8			; memory 8bit mode
		LDX	<WORK0
		LDA	>MPTPOS,X
		CMP	<WORKC		;  POINT ?
		BEQ	NXT999		;	YES -> NXT999
		LDX	<WORK2
		LDA	<WORKE
		STA	>MPTQNT,X
		STZ	!NXTFLG
;
;----------- v[[̎̃|Cg̉ʈʒuZbg -----------
		JSR	PLYRGOTOPS_50
;
		I8			; index 8bit mode
		LDX	#003H
		JSR	EMNST		; edit mode name set
		I16			; index 16bit mode
;
NXT999		EQU	$
		RTS
		IDX8
;
NXTDAT		EQU	$
		BYTE	000H,041H,082H,0C3H
;
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+						+
;+	point data set				+
;+						+
;++++++++++++++++++++++++++++++++++++++++++++++++
POTSET		EQU	$
		MI16			; memory , index 16bit mode
		LDA	!MPOBJSTN
		ASL	A
		ASL	A
		TAX
		M8			; memory 16bit mode
		LDA	!UNITNO
		STA	!MPOBJTYP+000H,X
		LDA	!EDMPXPS
		STA	!MPOBJTYP+001H,X
		LDA	!EDMPZPS
		STA	!MPOBJTYP+002H,X
		LDA	!EDMPYPS
		STA	!MPOBJTYP+003H,X
		M16			; memory 16bit mode
		INC	!MPOBJSTN
		JSR	PTIDXSB		; point data set index sub
		M8			; memory 8bit mode
		LDA	#000H
		STA	>MPT11P,X	;v[[
		LDA	!EDMPXPS
		STA	>MPT11X,X	;wW
		LDA	!EDMPZPS
		STA	>MPT11Z,X	;yW
		LDA	!EDMPYPS
		STA	>MPT11Y,X	;xW
		M16			; memory 16bit mode
;
		LDA	!QSTPOS
		AND	#0000FH
		CLC
		ADC	<WORK0
		TAX
		LDA	>MPTQT1,X
		INC	A
		STA	>MPTQT1,X
		MI8			; memory , index 8bit mode
		STZ	!EDITMOD
		RTS
;
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+						+
;+	bV[ړ|Cg			+
;+				(move mode)	+
;+						+
;++++++++++++++++++++++++++++++++++++++++++++++++
PTMVST		EQU	$
;
		I16			; index 16bit mode
		LDX	!PTMVAD
		LDA	!EDMPXPS
		CLC
		ADC	!ZRXPOS
		STA	>MPT11X,X
		LDA	!ZRZPOS
		CLC
		ADC	!EDMPZPS
		STA	>MPT11Z,X
		LDA	!EDMPYPS
		STA	>MPT11Y,X
		I8			; index 8bit mode
		RTS
;
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+						+
;+	point data delete			+
;+			in			+
;+			worka.b <- serach data	+
;++++++++++++++++++++++++++++++++++++++++++++++++
PTDLST		EQU	$
		MI16			; memory , index 16bit mode
		JSR	PTIDXSB		; point data set index sub
		LDX	<WORK2
		LDA	<WORKA
PTDL00		EQU	$		; data serach !!
		CMP	>MPT11X,X
		BEQ	PTDL10
		INX
		INX
		INX
		INX
		BRA	PTDL00
PTDL10		EQU	$
		TXA
		CLC
		ADC	#MPT11P
		STA	<WORK4
		TAX
		TXY
		INX
		INX
		INX
		INX
		PHB
		LDA	<WORK2
		CLC
		ADC	#MPTQNT
		CLC
		ADC	#00040H-4
		SEC
		SBC	<WORK4
		MVN	#BANK MPT11P,#BANK MPT11P
		PLB
;
		LDA	<WORK2
		CLC
		ADC	#00040H-4
		TAX
		LDA	#00000H
		STA	>MPT11P,X
		STA	>MPT11Z,X
		MI8			; memory , index 8bit mode
		RTS
;
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+						+
;+	map point data clear			+
;+						+
;++++++++++++++++++++++++++++++++++++++++++++++++
		IDX16
MPTCLR		EQU	$
		LDA	#BANK MAPPTBF
		STA	<WORKF
;
		M16			; memory 16bit mode
		LDA	>MPOBJTYP+1,X	; map point data index search
		STA	<WORK0
		LDX	#00000H
MPTCR60		EQU	$
		LDA	>MPTDAT+1,X
		CMP	<WORK0
		BEQ	MPTCR68
		INX
		INX
		INX
		INX
		BRA	MPTCR60
MPTCR68		EQU	$
		TXA
		LSR	A
		LSR	A
		STA	<WORK8
;
		PHB
		LDA	!MPTCNT0
		AND	#000FFH
		ASL	A
		ASL	A
		STA	<WORK0
		LDA	<WORK4
		SEC
		SBC	<WORK0
		STA	<WORK0
		CLC
		ADC	#MPTDAT
		TAY
		INC	A
		INC	A
		INC	A
		INC	A
		TAX
		LDA	!MPTCNT1
		AND	#000FFH
		ASL	A
		ASL	A
		SEC
		SBC	<WORK0
		DEC	A
		MVN	#BANK MPTDAT,#BANK MPTDAT
		PLB
;
		LDA	#MPTTYP
		STA	<WORKD
		LDA	<WORK4
		LSR	A
		LSR	A
		STA	<WORKB		; parts pointer set
		MI8			; memory , index 8bit mode
		LDA	!PTLMTCT	;|Cg f[^ 邩?
		BNE	MPTCR50_000	;	YES -> MPTCR50_000
		JMP	MPTCR90_END	;	NO --> MPTCR90_END
MPTCR50_000	EQU	$
		STA	<WORKA		; point data count set
		LDA	!MPCHGFG
;;;;K;;;;		LSR	A
		STA	<WORKC		; map type set
MPTCR50		EQU	$
		LDA	[<WORKD]
		CMP	<WORKC		; map type OK ?
		BNE	MPTCR53		;	NO -> MPTCR53
		LDY	#001H
		LDA	[<WORKD],Y	; parts pointer check
		CMP	<WORKB
		BNE	MPTCR52
		PHA
		M16			; memory 16bit mode
		LDA	<WORKD
		SEC
		SBC	#00012
		STA	<WORK6
		M8			; memory 8bit mode
		PLA
MPTCR52		EQU	$
		BCC	MPTCR53
		DEC	A
		STA	[<WORKD],Y
MPTCR53		EQU	$
		M16			; memory 16bit mode
		LDA	<WORKD
		CLC
		ADC	#0010EH
		STA	<WORKD
		M8			; memory 8bit mode
		DEC	<WORKA
		BNE	MPTCR50
		MI16			; memory , index 16bit mode
;
		PHB
		LDY	<WORK6
		CPY	#0010EH*99
		BCS	MPTCR55
		TYA
		CLC
		ADC	#0010EH
		TAX
		LDA	#0010EH*100+2
		SEC
		SBC	<WORK6
		MVN	#BANK MAPPTBF,#BANK MAPPTBF
;
MPTCR55		EQU	$
		M8			; memory 8bit mode
		PLB
;
		LDX	#00000H		; next goto point NO.
		TXY			;	check & clear
MPTCR70		EQU	$
		LDA	>MPTQNT+000H,X
		CMP	<WORK8
		BNE	MPTCR73
		LDA	#0FFH
		STA	>MPTQNT+000H,X
		LDA	#000H
		STA	>MPTQT1,X
		JSR	MPTCR70_SUB
		BRA	MPTCR90
MPTCR73		EQU	$
		LDA	>MPTQNT+041H,X
		CMP	<WORK8
		BNE	MPTCR75
		LDA	#0FFH
		STA	>MPTQNT+041H,X
		LDA	#000H
		STA	>MPTQT2,X
		JSR	MPTCR73_SUB
		BRA	MPTCR90
MPTCR75		EQU	$
		LDA	>MPTQNT+082H,X
		CMP	<WORK8
		BNE	MPTCR78
		LDA	#0FFH
		STA	>MPTQNT+082H,X
		JSR	MPTCR75_SUB
		LDA	#000H
		STA	>MPTQT3,X
		BRA	MPTCR90
MPTCR78		EQU	$
		LDA	>MPTQNT+0C3H,X
		CMP	<WORK8
		BNE	MPTCR80
		LDA	#0FFH
		STA	>MPTQNT+0C3H,X
		JSR	MPTCR78_SUB
		LDA	#000H
		STA	>MPTQT4,X
		BRA	MPTCR90
MPTCR80		EQU	$
		TYA
		CMP	>MPPTCNT
		BCS	MPTCR90
		INY
		M16				; memory 16bit mode
		TXA
		CLC
		ADC	#0010EH
		TAX
		M8				; memory 8bit mode
		BRA	MPTCR70
;
MPTCR90		EQU	$
		DEC	!PTLMTCT
		LDA	!PTLMTCT
		STA	>MPPTCNT
MPTCR90_END	EQU	$
		RTS
;
;
;++++++++++++++++++++++++++++++++++++++++
;+	ړf[^ NATu O	+
;++++++++++++++++++++++++++++++++++++++++
MPTCR70_SUB	EQU	$
		PHX
		PHY
		LDY	#00000H
		M16			; memory 16bit mode
MPTCR70_SUB_LP	EQU	$
		LDA	#00080H
		STA	>MPT11P+000H,X
		LDA	#00000H
		STA	>MPT11Z+000H,X
		INX
		INX
		INX
		INX
		INY
		CPY	#00010H
		BCC	MPTCR70_SUB_LP
		M8			; memory 8bit mode
		PLY
		PLX
		RTS
;
;
;++++++++++++++++++++++++++++++++++++++++
;+	ړf[^ NATu P	+
;++++++++++++++++++++++++++++++++++++++++
MPTCR73_SUB	EQU	$
		PHX
		PHY
		LDY	#00000H
		M16			; memory 16bit mode
MPTCR73_SUB_LP	EQU	$
		LDA	#00080H
		STA	>MPT11P+040H,X
		LDA	#00000H
		STA	>MPT11Z+040H,X
		INX
		INX
		INX
		INX
		INY
		CPY	#00010H
		BCC	MPTCR73_SUB_LP
		M8			; memory 8bit mode
		PLY
		PLX
		RTS
;
;
;++++++++++++++++++++++++++++++++++++++++
;+	ړf[^ NATu Q	+
;++++++++++++++++++++++++++++++++++++++++
MPTCR75_SUB	EQU	$
		PHX
		PHY
		LDY	#00000H
		M16			; memory 16bit mode
MPTCR75_SUB_LP	EQU	$
		LDA	#00080H
		STA	>MPT11P+080H,X
		LDA	#00000H
		STA	>MPT11Z+080H,X
		INX
		INX
		INX
		INX
		INY
		CPY	#00010H
		BCC	MPTCR75_SUB_LP
		M8			; memory 8bit mode
		PLY
		PLX
		RTS
;
;
;++++++++++++++++++++++++++++++++++++++++
;+	ړf[^ NATu R	+
;++++++++++++++++++++++++++++++++++++++++
MPTCR78_SUB	EQU	$
		PHX
		PHY
		LDY	#00000H
		M16			; memory 16bit mode
MPTCR78_SUB_LP	EQU	$
		LDA	#00080H
		STA	>MPT11P+0C0H,X
		LDA	#00000H
		STA	>MPT11Z+0C0H,X
		INX
		INX
		INX
		INX
		INY
		CPY	#00010H
		BCC	MPTCR78_SUB_LP
		M8			; memory 8bit mode
		PLY
		PLX
		RTS
		IDX8
;
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+						+
;+	obj -> map data buffer set		+
;+						+
;++++++++++++++++++++++++++++++++++++++++++++++++
OBJMPBF		EQU	$
		LDA	#BANK MPDTBFA
		STA	<WORK2
		M16			; memory 16bit mode
		LDX	!MPCHGFG
		LDA	>MDBAD,X
		STA	<WORK0
;
		LDA	!MPOBJSTN
		STA	[<WORK0]
		ASL	A
		ASL	A
		STA	<WORK4
		INC	<WORK0
		INC	<WORK0
;
		I16			; index 16bit mode
		LDY	#00000H
OBJMP00		EQU	$
		LDA	!MPOBJTYP,Y
		STA	[<WORK0],Y
		INY
		INY
		CPY	<WORK4
		BNE	OBJMP00
		CPY	#00258H
		BCS	OBJMP20
;
		LDA	#00000H
OBJMP10		EQU	$
		STA	[<WORK0],Y
		INY
		INY
		CPY	#00258H
		BNE	OBJMP10
;
OBJMP20		EQU	$
		MI8			; memory , index 8bit mode
		RTS
;
;
;++++++++++++++++++++++++++++++++++++++++
;+	player move point data adress	+
;++++++++++++++++++++++++++++++++++++++++
PTMVADRSHC	EQU	$
		LDA	!POINTFG
		BEQ	PTMVADRSHC_90
		MI16			; memory , index 16bit mode
		JSR	PTIDXSB		; point data set index sub
		LDX	<WORK2
		LDY	!UTPSAD
		LDA	!MPOBJTYP+1,Y
		STA	<WORK0
		LDA	!MPOBJTYP+2,Y
		STA	<WORK2
		LDY	#00000H
PTMVADRSHC_10	EQU	$		;ړf[^ T[`
		LDA	<WORK0
		CMP	>MPT11X,X
		BEQ	PTMVADRSHC_15
PTMVADRSHC_13	EQU	$
		INX
		INX
		INX
		INX
		INY
		CPY	#00010H
		BCC	PTMVADRSHC_10
PTMVADRSHC_15	EQU	$
		LDA	<WORK2
		CMP	>MPT11Z,X
		BNE	PTMVADRSHC_13
		STX	!PTMVAD
		MI8			; memory , index 8bit mode
PTMVADRSHC_90	EQU	$
		RTS
;
;
;++++++++++++++++++++++++++++++++++++++++
;+					+
;+	point data set index sub	+
;+	     out			+
;+	  work0,1 <- data start		+
;+	    " 2,3 <- quest start	+
;+		X <- player move data	+
;+		    (clear data index)	+
;++++++++++++++++++++++++++++++++++++++++
		MEM16
		IDX16
PTIDXSB		EQU	$
		LDA	#00000H
		LDX	!MENUNO
		BEQ	POT100
POT000		EQU	$
		CLC
		ADC	#0010EH
		DEX
		BNE	POT000
POT100		EQU	$
		STA	<WORK0
		STA	<WORK2
;
		LDA	!QSTPOS
		AND	#00003H
		TAX
		TXY
		BEQ	POT200
		LDA	<WORK0
POT110		EQU	$
		CLC
		ADC	#00041H
		DEY
		BNE	POT110
		STA	<WORK2
;
POT200		EQU	$
		TXA
		CLC
		ADC	<WORK0
		TAX
		LDA	>MPTQT1,X
		AND	#0000FH
		ASL	A
		ASL	A
		CLC
		ADC	<WORK2
		TAX
		RTS
		MEM8
		IDX8
;
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+						+
;+	map point data set			+
;+						+
;++++++++++++++++++++++++++++++++++++++++++++++++
MPTDST		EQU	$
		LDA	#BANK MAPPTBF
		STA	<WORKF		; BANK MAPPTBF set
		LDY	#00000H
		MI16			; memory , index 16bit mode
		LDA	#MAPPTBF
		STA	<WORKD		; address MAPPTBF (low)(high) set
		LDA	!PTLMTCT
		AND	#000FFH
		STA	<WORK0
		BEQ	PTD010
PTD000		EQU	$		; buffer address set
		LDA	<WORKD
		CLC
		ADC	#0010EH
		STA	<WORKD
		DEC	<WORK0
		BNE	PTD000
;
PTD010		EQU	$
		M8			; memory 8bit mode
;
		LDA	!MPCHGFG	; map type
		LSR	A
		STA	[<WORKD],Y
;
		INY			; map parts pointer
		LDA	!MPOBJSTN
		STA	[<WORKD],Y
;
		INY			; cours data table NO.
;
		INY			; timer etc..
;
		INY			; player set X pos
;
		INY			; player set Y pos
;
		INY			; 1 quest data pointer
		LDA	#000H		;	(quest count)
		STA	[<WORKD],Y
;
		INY			; 2 quest data pointer
		STA	[<WORKD],Y
;
		INY			; 3 quest data pointer
		STA	[<WORKD],Y
;
		INY			; 4 quest data pointer
		STA	[<WORKD],Y
;
		INY			; next goto point NO.
		PHY
ITNTLP		EQU	$
		LDA	#0FFH
		STA	[<WORKD],Y
		PHY
		INY
		JSR	ITNTLP_SUB
		PLY
		M16			; memory 16bit mode
		TYA
		CLC
		ADC	#00041H
		TAY
		M8			; memory 8bit mode
		CPY	#00100H
		BCC	ITNTLP
		PLY
;
		INY			; player move data 1
;
		INC	!PTLMTCT
;
		M16			; memory 16bit mode
		LDA	!PTLMTCT
		AND	#000FFH
		STA	>MPPTCNT
		M8			; memory 8bit mode
;
		I8			; index 8bit mode
		RTS
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	v[[ CjV Zbg	+
;++++++++++++++++++++++++++++++++++++++++++++++++
		IDX16
ITNTLP_SUB	EQU	$
		LDA	#080H
		LDX	#00000H
ITNTLP_SUB_LOP	EQU	$
		STA	[<WORKD],Y
		INY
		INY
		INY
		INY
		INX
		CPX	#00016
		BCC	ITNTLP_SUB_LOP
		RTS
		IDX8
;
;
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+							+
;+	map data , point data  marge			+
;+							+
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
MPDPNT		EQU	$
		PHB
		MI16			; memory , index 16bit mode
		LDA	!MPTCNT0
		CLC
		ADC	!MPTCNT1
		STA	!MPOBJSTN
		LDA	!MPTCNT1
		BEQ	MPPT50
		ASL	A
		ASL	A
		DEC	A
		STA	<WORK2
		LDA	!MPTCNT0
		ASL	A
		ASL	A
		CLC
		ADC	#MPOBJTYP
		TAY
		LDX	#MPTDAT
		LDA	<WORK2
		MVN	#BANK MPTDAT,#BANK MPOBJTYP
MPPT50		EQU	$
		MI8			; memory , index 8bit mode
		PLB
;
		LDA	!UNITNO
		CMP	#07AH
		BCS	MPPT90
		I16			; index 16bit mode
		LDX	!MPTCNT1
		BEQ	MPPT90
		STZ	<WORKF
		LDY	<WORKE
		LDA	!MPCHGFG
		LSR	A
		STA	<WORK0
		LDA	!PTLMTCT
		STA	<WORK2
		LDX	#00000H
MPPT60		EQU	$
		DEC	<WORK2
		BMI	MPPT90
		LDA	>MPTTYP,X
		CMP	<WORK0
		BNE	MPPT70
		LDA	>MPTPOS,X
		CLC
		ADC	MPPTDT,Y
		STA	>MPTPOS,X
MPPT70		EQU	$
		M16			; memory 16bit mode
		TXA
		CLC
		ADC	#0010EH
		TAX
		M8			; memory 8bit mode
		BRA	MPPT60
MPPT90		EQU	$
		I8			; index 8bit mode
;
		STZ	!EDITMOD
		RTS
;
MPPTDT		EQU	$
		BYTE	001H,0FFH
;
;
;----------------------------------------------------------------
;-		bitmap write					-
;----------------------------------------------------------------
ED0MV1000	EQU	$
;
		M16
;
;-------------- map bitmap buffer clear -------------------------
		LDX	#BANK EDBFCLR
		LDA	#EDBFCLR
		JSL	>CHIPON
;
;-------------- map bitmap buffer set ---------------------------
		LDA	EDCENTX
		CLC
		ADC	#080H
		STA	CENTX		;mode 7 center X pos set
		SEC
		SBC	#080H
		STA	<SCCH1
		LDA	#0180H
		SEC
		SBC	EDCENTY
		STA	CENTY		;mode 7 cebter Y pos set
		SEC
		SBC	#050H+08H
		STA	<SCCV1
		LDA	EDZOOM		;mode 7 matrix set
		STA	MATA
		STA	MATD
		STZ	MATB
		STZ	MATC
;
		LDX	#BANK EDWRITE
		LDA	#EDWRITE
		JSL	>CHIPON
;
;-------------- bitmap data convert -----------------------------
;
;-------------- memory DMA timming check ----------------
ED0MV1010	EQU	$
		LDX	4212H
		BPL	ED0MV1010
ED0MV1012	EQU	$
		LDX	4212H
		BMI	ED0MV1012
;
;-------------- memory DMA start ------------------------
		LDA	#MPCNVBF	;(WK23,24,25) <-- from address
		STA	<WORK23
		LDA	#BANK MPCNVBF
		STA	<WORK25
;
		LDX	#(4-1)*2
ED0MV1020	EQU	$
		STX	<WORK		;(WK0,1) <-- loop no
;
		LDA	>EDCNVST,X
		STA	>R14		;convert status data address(L,H)
		LDA	#BANK EDCNVST0
		STA	>R0		;		"           (B)
		LDX	#BANK MPBFCNV
		LDA	#MPBFCNV
		JSL	>CHIPON
;
		LDX	<WORK
		LDA	#MPDMABF/100H	;(WK20,21,22) <-- to address
		STA	<WORK21
		LDA	>EDCNVBP,X
		STA	<WORK20
;
;-------------- memory DMA timming check ----------------
;
		M8
;
ED0MV1026	EQU	$
		BIT	4212H
		BVC	ED0MV1026
ED0MV1028	EQU	$
		BIT	4212H
		BVS	ED0MV1028
		LDY	#04H
ED0MV1029	EQU	$
		DEY
		BNE	ED0MV1029
;
		M16
;
		LDA	#0E00H		;(A) <-- number of byte
		JSL	>DMA_M_M
;
		DEX
		DEX
		BPL	ED0MV1020
;
		M8
;
		LDA	#03H		;DMA start "ON" !!
		STA	MPDMAFG
;
ED0MV1030	EQU	$
		LDA	MPDMAFG
		BNE	ED0MV1030	;bitmap chara DMA end ? ( no:ED0MV1030 )
;
;----------- v[[̎̃|Cg̉ʈʒuZbg -----------
		JSR	PLYRGOTOPS
;
		LDA	MPBANK		;chara bank change
		EOR	#001H
		AND	#001H
		STA	MPBANK
		INC	EDITMOD		;return edit mode !!
		INC	EDITMOD
		RTS
;
;
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+	v[[̎̃|Cg̉ʈʒuZbg	+
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
PLYRGOTOPS	EQU	$
		LDA	!POINTFG
		BNE	PLYRGOTOPS_00
		JMP	PLYRGOTOPS_99
PLYRGOTOPS_00	EQU	$
		MI16			; memory , index 16bit mode
		LDA	EDIT0NTPS
		STA	>OAM+(EDIT0NTPS-EDIT0OAM)
		LDA	EDIT0NTPS+2
		STA	>OAM+(EDIT0NTPS-EDIT0OAM)+2
		JSR	PTIDXSB		; point data set index sub
		LDX	<WORK0
		LDA	>MPTTYP,X
		AND	#000FFH
		CMP	!MPTYPE
		BNE	PLYRGOTOPS_49
		LDA	>MPTPOS,X
		ASL	A
		ASL	A
		TAX
		LDA	!MPOBJTYP+1,X
		AND	#000FFH
		CMP	#00080H
		BCC	PLYRGOTOPS_05
		ORA	#0FF00H
PLYRGOTOPS_05	EQU	$
		SEC
		SBC	#00007
		SEC
		SBC	!EDCENTX
		STA	>R10		; X set
		LDA	!MPOBJTYP+2,X
		AND	#000FFH
		CMP	#00080H
		BCC	PLYRGOTOPS_08
		ORA	#0FF00H
PLYRGOTOPS_08	EQU	$
		CLC
		ADC	#00010H
		SEC
		SBC	!EDCENTY
		STA	>R11		; Y set
;
		I8			; index 8bit mode
		LDX	#BANK POINTCNV
		LDA	#POINTCNV
		JSL	>CHIPON
		LDA	<WORK2
		PHA
		LDA	>R10
		STA	<WORK0
		LDA	>R11
		STA	<WORK1
		PLA
		STA	<WORK2
;
		LDA	>R10
		ORA	>R11
		AND	#0FF00H
		BEQ	PLYRGOTOPS_09
		LDA	#0F000H
		STA	<WORK0
;
PLYRGOTOPS_09	EQU	$
		LDA	<WORK0
		STA	>OAM+(EDIT0NTPS-EDIT0OAM)
PLYRGOTOPS_49	EQU	$
		MI8			; memory , index 8bit mode
;
PLYRGOTOPS_50	EQU	$
		LDA	!NXTFLG
		BEQ	PLYRGOTOPS_60
		JMP	PLYRGOTOPS_99
PLYRGOTOPS_60	EQU	$
		MI16			; memory , index 16bit mode
		LDX	<WORK2
		LDA	>MPTQNT,X
		AND	#000FFH
		CMP	#000FFH
		BEQ	PLYRGOTOPS_99
		TAY
		LDA	#00000H
PLYRGOTOPS_63	EQU	$
		CLC
		ADC	#0010EH
		DEY
		BNE	PLYRGOTOPS_63
		TAX
		LDA	>MPTPOS,X
		ASL	A
		ASL	A
		TAX
		LDA	!MPOBJTYP+1,X
		AND	#000FFH
		CMP	#00080H
		BCC	PLYRGOTOPS_65
		ORA	#0FF00H
PLYRGOTOPS_65	EQU	$
		SEC
		SBC	#00007
		SEC
		SBC	!EDCENTX
		STA	>R10		; X set
		LDA	!MPOBJTYP+2,X
		AND	#000FFH
		CMP	#00080H
		BCC	PLYRGOTOPS_68
		ORA	#0FF00H
PLYRGOTOPS_68	EQU	$
		CLC
		ADC	#00010H
		SEC
		SBC	!EDCENTY
		STA	>R11		; Y set
;
		I8			; index 8bit mode
		LDX	#BANK POINTCNV
		LDA	#POINTCNV
		JSL	>CHIPON
		LDA	>R10
		STA	<WORK0
		LDA	>R11
		STA	<WORK1
;
		LDA	>R10
		ORA	>R11
		AND	#0FF00H
		BEQ	PLYRGOTOPS_69
		LDA	#0F000H
		STA	<WORK0
;
PLYRGOTOPS_69	EQU	$
		LDA	<WORK0
		STA	>OAM+(EDIT0NTPS-EDIT0OAM)+4
PLYRGOTOPS_99	EQU	$
		MI8			; memory , index 8bit mode
		RTS
;
;----------------------------------------------------------------
;-		unit no. parts chara set			-
;----------------------------------------------------------------
UNITCHST	EQU	$
		PHP			;(P) save
;
		M16
		I8
;
		LDA	!UNITNO
		AND	#00FFH
		STA	>R1		;(R1) <-- parts no.
		LDX	#BANK EDUNITWT
		LDA	#EDUNITWT
		JSL	>CHIPON
;
		PLP			;(P) load
		RTS
;
		MEM8
;
;
;SSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSS
;S								S
;S	edit mode name set					S
;S			in					S
;S			X <- name data read index		S
;SSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSS
EMNST		EQU	$
		TXA
		ASL	A
		TAX
		M16			; memory 16bit mode
		LDA	MODEDT,X
		STA	<WORK0
;
		LDY	#000H
EMNST00		EQU	$
		LDA	(<WORK0),Y
		STA	!EDNMBF,Y
		INY
		INY
		CPY	#MDDAT1-MDDAT0
		BNE	EMNST00
;
		M8			; memory 8bit mode
		RTS
;
;
;XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
;X						X
;X	mouse mode set data			X
;X						X
;XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
ED0MV0DT	EQU	$
; 00
		BYTE	000H,013H,013H,000H,000H,000H,000H,000H ; 000
		BYTE	000H,000H,000H,000H,000H,000H,000H,000H ; 008
		BYTE	000H,000H,001H,001H,001H,001H,002H,002H ; 010
		BYTE	002H,002H,003H,003H,003H,003H,000H,000H ; 018
; 01
		BYTE	000H,013H,013H,000H,00AH,00BH,000H,000H ; 000
		BYTE	000H,000H,00CH,00CH,000H,014H,015H,016H ; 008
		BYTE	017H,000H,004H,004H,004H,004H,005H,005H ; 010
		BYTE	005H,005H,006H,006H,006H,006H,000H,000H ; 018
; 02
		BYTE	000H,000H,000H,000H,000H,000H,000H,000H ; 000
		BYTE	000H,000H,000H,000H,000H,018H,019H,01AH ; 008
		BYTE	01BH,000H,007H,007H,007H,007H,008H,008H ; 010
		BYTE	008H,008H,009H,009H,009H,009H,000H,000H ; 018
; 03
		BYTE	000H,000H,000H,000H,000H,000H,000H,000H ; 000
		BYTE	000H,000H,000H,000H,000H,000H,000H,000H ; 008
		BYTE	000H,000H,000H,000H,000H,000H,000H,000H ; 010
		BYTE	000H,000H,000H,000H,000H,000H,000H,000H ; 018
; 04
		BYTE	000H,000H,000H,000H,000H,000H,000H,000H ; 000
		BYTE	000H,000H,000H,000H,000H,000H,000H,000H ; 008
		BYTE	000H,000H,000H,000H,010H,00DH,000H,000H ; 010
		BYTE	011H,00EH,000H,000H,012H,00FH,000H,000H ; 018
; 05
		BYTE	000H,000H,000H,000H,000H,000H,000H,000H ; 000
		BYTE	000H,000H,000H,000H,000H,000H,000H,000H ; 008
		BYTE	000H,000H,000H,000H,000H,000H,000H,000H ; 010
		BYTE	000H,000H,000H,000H,000H,000H,000H,000H ; 018
;
;
;
;
;
ED_AA		EQU	001C0H
ED_II		EQU	001C1H
ED_UU		EQU	001C2H
ED_EE		EQU	001C3H
ED_OO		EQU	001C4H
ED_KA		EQU	001C5H
ED_KI		EQU	001C6H
ED_KU		EQU	001C7H
ED_KE		EQU	001C8H
ED_KO		EQU	001C9H
ED_SA		EQU	001CAH
ED_SI		EQU	001CBH
ED_SU		EQU	001CCH
ED_SE		EQU	001CDH
ED_SO		EQU	001CEH
ED_TA		EQU	001CFH
ED_TI		EQU	001D0H
ED_TU		EQU	001D1H
ED_TE		EQU	001D2H
ED_TO		EQU	001D3H
ED_NA		EQU	001D4H
ED_NI		EQU	001D5H
ED_NU		EQU	001D6H
ED_NE		EQU	001D7H
ED_NO		EQU	001D8H
ED_HA		EQU	001D9H
ED_HI		EQU	001DAH
ED_HU		EQU	001DBH
ED_HE		EQU	001DCH
ED_HO		EQU	001DDH
ED_MA		EQU	001DEH
ED_MI		EQU	001DFH
ED_MU		EQU	001E0H
ED_ME		EQU	001E1H
ED_MO		EQU	001E2H
ED_YA		EQU	001E3H
ED_YU		EQU	001E4H
ED_YO		EQU	001E5H
ED_RA		EQU	001E6H
ED_RI		EQU	001E7H
ED_RU		EQU	001E8H
ED_RE		EQU	001E9H
ED_RO		EQU	001EAH
ED_WA		EQU	001EBH
ED_NN		EQU	001ECH
ED_YAA		EQU	001EDH
ED_YUU		EQU	001EEH
ED_YOO		EQU	001EFH
ED_LK		EQU	041ABH	; left ka-ko
ED_RK		EQU	001ABH	; right ka-ko
ED_TT		EQU	001ACH	; da-ku-te-n
ED_ML		EQU	001ADH	; e-n
ED_DK		EQU	0018FH	; ku-ro be-ta
ED_TUU		EQU	001A8H
ED_UO		EQU	001A9H
;
;
EDNMAD		EQU	$
		WORD	00000H,EDNM001,EDNM002,EDNM003
		WORD	EDNM004,EDNM005,EDNM006,EDNM007
		WORD	EDNM008,EDNM009,EDNM00A,EDNM00B
		WORD	EDNM00C,EDNM00D,EDNM00E,EDNM00F
;
		WORD	EDNM010,EDNM011,EDNM012,EDNM013
		WORD	EDNM014,EDNM015,EDNM016,EDNM017
		WORD	EDNM018,EDNM019,EDNM01A,EDNM01B
		WORD	EDNM01C,EDNM01D,EDNM01E,EDNM01F
;
		WORD	EDNM020,EDNM021,EDNM022,EDNM023
		WORD	EDNM024,EDNM025,EDNM026,EDNM027
		WORD	EDNM028,EDNM029,EDNM02A,EDNM02B
		WORD	EDNM02C,EDNM02D,EDNM02E,EDNM02F
;
		WORD	EDNM030,EDNM031,EDNM032,EDNM033
		WORD	EDNM034,EDNM035,EDNM036,EDNM037
		WORD	EDNM038,EDNM039,EDNM03A,EDNM03B
		WORD	EDNM03C,EDNM03D,EDNM03E,EDNM03F
;
		WORD	EDNM040,EDNM041,EDNM042,EDNM043
		WORD	EDNM044,EDNM045,EDNM046,EDNM047
		WORD	EDNM048,EDNM049,EDNM04A,EDNM04B
		WORD	EDNM04C,EDNM04D,EDNM04E,EDNM04F
;
		WORD	EDNM050,EDNM051,EDNM052,EDNM053
		WORD	EDNM054,EDNM055,EDNM056,EDNM057
		WORD	EDNM058,EDNM059,EDNM05A,EDNM05B
		WORD	EDNM05C,EDNM05D,EDNM05E,EDNM05F
;
		WORD	EDNM060,EDNM061,EDNM062,EDNM063
		WORD	EDNM064,EDNM065,EDNM066,EDNM067
		WORD	EDNM068,EDNM069,EDNM06A,EDNM06B
		WORD	EDNM06C,EDNM06D,EDNM06E,EDNM06F
;
		WORD	EDNM070,EDNM071,EDNM072,EDNM073
		WORD	EDNM074,EDNM075,EDNM076,EDNM077
		WORD	EDNM078,EDNM079,EDNM07A,EDNM07B
		WORD	EDNM07C,EDNM07D,EDNM07E,EDNM07F
;
		WORD	EDNM080,EDNM081,EDNM082,EDNM083
		WORD	EDNM084,EDNM085,EDNM086,EDNM087
		WORD	EDNM088,EDNM089
;
;
;
EDNM001		EQU	$
		WORD	ED_NO,ED_TUU,ED_HO,ED_ML,ED_YA,ED_MA
		WORD	ED_DK,ED_LK,ED_TA,ED_TT,ED_II,ED_RK
;
EDNM002		EQU	$
		WORD	ED_NO,ED_TUU,ED_HO,ED_ML,ED_YA,ED_MA
		WORD	ED_DK,ED_LK,ED_TI,ED_YUU,ED_UU,ED_RK
;
EDNM003		EQU	$
		WORD	ED_NO,ED_TUU,ED_HO,ED_ML,ED_YA,ED_MA
		WORD	ED_DK,ED_LK,ED_SI,ED_YOO,ED_UU,ED_RK
;
EDNM004		EQU	$
		WORD	ED_NO,ED_TUU,ED_HO,ED_ML,ED_TO,ED_UU
		WORD	ED_DK,ED_DK,ED_DK,ED_DK,ED_DK,ED_DK
;
EDNM005		EQU	$
		WORD	ED_RE,ED_NN,ED_KA,ED_TT,ED_TO,ED_UU
		WORD	ED_DK,ED_DK,ED_DK,ED_DK,ED_DK,ED_DK
;
EDNM006		EQU	$
		WORD	ED_KA,ED_SA,ED_TT,ED_NN,ED_DK,ED_DK
		WORD	ED_DK,ED_DK,ED_DK,ED_DK,ED_DK,ED_DK
;
EDNM007		EQU	$
		WORD	ED_OO,ED_WA,ED_NN,ED_YA,ED_MA,ED_DK
		WORD	ED_LK,ED_TA,ED_TT,ED_II,ED_RK,ED_DK
;
EDNM008		EQU	$
		WORD	ED_TA,ED_TT,ED_II,ED_TI,ED_DK,ED_DK
		WORD	ED_DK,ED_DK,ED_DK,ED_DK,ED_DK,ED_DK
;
EDNM009		EQU	$
		WORD	ED_TO,ED_RI,ED_TE,ED_TT,ED_DK,ED_LK
		WORD	ED_SI,ED_YOO,ED_UU,ED_RK,ED_DK,ED_DK
;
EDNM00A		EQU	$
		WORD	ED_TO,ED_RI,ED_TE,ED_TT,ED_DK,ED_LK
		WORD	ED_TA,ED_TT,ED_II,ED_RK,ED_DK,ED_DK
;
EDNM00B		EQU	$
		WORD	ED_OO,ED_WA,ED_NN,ED_YA,ED_MA,ED_DK
		WORD	ED_LK,ED_SI,ED_YOO,ED_UU,ED_RK,ED_DK
;
EDNM00C		EQU	$
		WORD	ED_II,ED_WA,ED_DK,ED_LK,ED_SI,ED_YOO
		WORD	ED_UU,ED_RK,ED_DK,ED_DK,ED_DK,ED_DK
;
EDNM00D		EQU	$
		WORD	ED_AA,ED_TU,ED_TT,ED_MA,ED_YA,ED_DK
		WORD	ED_DK,ED_DK,ED_DK,ED_DK,ED_DK,ED_DK
;
EDNM00E		EQU	$
		WORD	ED_AA,ED_NA,ED_DK,ED_DK,ED_DK,ED_DK
		WORD	ED_DK,ED_DK,ED_DK,ED_DK,ED_DK,ED_DK
;
EDNM00F		EQU	$
		WORD	ED_MO,ED_KO,ED_MO,ED_KO,ED_NO,ED_KI
		WORD	ED_DK,ED_DK,ED_DK,ED_DK,ED_DK,ED_DK
;
EDNM010		EQU	$
		WORD	ED_KI,ED_II,ED_RO,ED_NO,ED_KI,ED_DK
		WORD	ED_DK,ED_DK,ED_DK,ED_DK,ED_DK,ED_DK
;
EDNM011		EQU	$
		WORD	ED_MO,ED_KO,ED_MO,ED_KO,ED_NO,ED_KI
		WORD	ED_DK,ED_LK,ED_SI,ED_YOO,ED_UU,ED_RK
;
EDNM012		EQU	$
		WORD	ED_SU,ED_KI,ED_TT,ED_DK,ED_LK,ED_SI
		WORD	ED_YOO,ED_UU,ED_RK,ED_DK,ED_DK,ED_DK
;
EDNM013		EQU	$
		WORD	ED_SU,ED_KI,ED_TT,ED_DK,ED_LK,ED_TA
		WORD	ED_TT,ED_II,ED_RK,ED_DK,ED_DK,ED_DK
;
EDNM014		EQU	$
		WORD	ED_II,ED_WA,ED_YA,ED_MA,ED_DK,ED_DK
		WORD	ED_DK,ED_DK,ED_DK,ED_DK,ED_DK,ED_DK
;
EDNM015		EQU	$
		WORD	ED_KU,ED_MO,ED_DK,ED_DK,ED_DK,ED_DK
		WORD	ED_DK,ED_DK,ED_DK,ED_DK,ED_DK,ED_DK
;
EDNM016		EQU	$
		WORD	ED_TE,ED_NN,ED_KU,ED_UU,ED_SI,ED_TT
		WORD	ED_YOO,ED_UU,ED_DK,ED_DK,ED_DK,ED_DK
;
EDNM017		EQU	$
		WORD	ED_KO,ED_TT,ED_NN,ED_TO,ED_TT,ED_RA
		WORD	ED_DK,ED_DK,ED_DK,ED_DK,ED_DK,ED_DK
;
EDNM018		EQU	$
		WORD	ED_KU,ED_SA,ED_DK,ED_DK,ED_DK,ED_DK
		WORD	ED_DK,ED_DK,ED_DK,ED_DK,ED_DK,ED_DK
;
EDNM019		EQU	$
		WORD	ED_HA,ED_NA,ED_DK,ED_DK,ED_DK,ED_DK
		WORD	ED_DK,ED_DK,ED_DK,ED_DK,ED_DK,ED_DK
;
EDNM01A		EQU	$
		WORD	ED_II,ED_WA,ED_DK,ED_LK,ED_TA,ED_TT
		WORD	ED_II,ED_RK,ED_DK,ED_DK,ED_DK,ED_DK
;
EDNM01B		EQU	$
		WORD	ED_RO,ED_UU,ED_HU,ED_ML,ED_DK,ED_DK
		WORD	ED_DK,ED_DK,ED_DK,ED_DK,ED_DK,ED_DK
;
EDNM01C		EQU	$
EDNM01D		EQU	$
EDNM01E		EQU	$
EDNM01F		EQU	$
EDNM020		EQU	$
EDNM021		EQU	$
EDNM022		EQU	$
EDNM023		EQU	$
EDNM024		EQU	$
EDNM025		EQU	$
EDNM026		EQU	$
EDNM027		EQU	$
EDNM028		EQU	$
EDNM029		EQU	$
EDNM02A		EQU	$
EDNM02B		EQU	$
EDNM02C		EQU	$
EDNM02D		EQU	$
EDNM02E		EQU	$
EDNM02F		EQU	$
EDNM030		EQU	$
EDNM031		EQU	$
EDNM032		EQU	$
EDNM033		EQU	$
EDNM034		EQU	$
EDNM035		EQU	$
EDNM036		EQU	$
EDNM037		EQU	$
EDNM038		EQU	$
EDNM039		EQU	$
EDNM03A		EQU	$
EDNM03B		EQU	$
EDNM03C		EQU	$
EDNM03D		EQU	$
EDNM03E		EQU	$
EDNM03F		EQU	$
EDNM040		EQU	$
EDNM041		EQU	$
EDNM042		EQU	$
EDNM043		EQU	$
EDNM044		EQU	$
EDNM045		EQU	$
EDNM046		EQU	$
EDNM047		EQU	$
EDNM048		EQU	$
EDNM049		EQU	$
EDNM04A		EQU	$
EDNM04B		EQU	$
EDNM04C		EQU	$
EDNM04D		EQU	$
EDNM04E		EQU	$
EDNM04F		EQU	$
EDNM050		EQU	$
EDNM051		EQU	$
EDNM052		EQU	$
EDNM053		EQU	$
EDNM054		EQU	$
EDNM055		EQU	$
EDNM056		EQU	$
EDNM057		EQU	$
EDNM058		EQU	$
EDNM059		EQU	$
EDNM05A		EQU	$
EDNM06B		EQU	$
EDNM074		EQU	$
EDNM075		EQU	$
EDNM076		EQU	$
EDNM077		EQU	$
EDNM078		EQU	$
EDNM079		EQU	$
		WORD	ED_DK,ED_DK,ED_DK,ED_DK,ED_DK,ED_DK
		WORD	ED_DK,ED_DK,ED_DK,ED_DK,ED_DK,ED_DK
;
EDNM05B		EQU	$
		WORD	ED_AA,ED_YA,ED_SI,ED_II,ED_SI,ED_YOO
		WORD	ED_KU,ED_HU,ED_TT,ED_TU,ED_DK,ED_DK
;
EDNM05C		EQU	$
		WORD	ED_AA,ED_YA,ED_SI,ED_II,ED_KI,00171H
		WORD	ED_DK,ED_DK,ED_DK,ED_DK,ED_DK,ED_DK
;
EDNM05D		EQU	$
		WORD	ED_AA,ED_YA,ED_SI,ED_II,ED_KI,00170H
		WORD	ED_DK,ED_DK,ED_DK,ED_DK,ED_DK,ED_DK
;
EDNM05E		EQU	$
		WORD	ED_AA,ED_KA,ED_KI,ED_NO,ED_KO,ED_DK
		WORD	ED_DK,ED_DK,ED_DK,ED_DK,ED_DK,ED_DK
;
EDNM05F		EQU	$
		WORD	ED_KI,ED_NO,ED_KO,ED_DK,ED_LK,ED_SI
		WORD	ED_YOO,ED_UU,ED_RK,ED_DK,ED_DK,ED_DK
;
EDNM060		EQU	$
		WORD	ED_SE,ED_TT,ED_NN,ED_MA,ED_II,ED_DK
		WORD	ED_DK,ED_DK,ED_DK,ED_DK,ED_DK,ED_DK
;
EDNM061		EQU	$
		WORD	ED_SU,ED_II,ED_SI,ED_YOO,ED_UU,ED_DK
		WORD	ED_LK,ED_TA,ED_TT,ED_II,ED_RK,ED_DK
;
EDNM062		EQU	$
		WORD	ED_SU,ED_II,ED_SI,ED_YOO,ED_UU,ED_DK
		WORD	ED_LK,ED_SI,ED_YOO,ED_UU,ED_RK,ED_DK
;
EDNM063		EQU	$
		WORD	ED_II,ED_SI,ED_DK,ED_LK,ED_TA,ED_TT
		WORD	ED_II,ED_RK,ED_DK,ED_DK,ED_DK,ED_DK
;
EDNM064		EQU	$
		WORD	ED_II,ED_SI,ED_DK,ED_LK,ED_SI,ED_YOO
		WORD	ED_UU,ED_RK,ED_DK,ED_DK,ED_DK,ED_DK
;
EDNM065		EQU	$
		WORD	ED_YA,ED_MA,ED_NO,ED_II,ED_EE,ED_DK
		WORD	ED_DK,ED_DK,ED_DK,ED_DK,ED_DK,ED_DK
;
EDNM066		EQU	$
		WORD	ED_AA,ED_OO,ED_KI,ED_NO,ED_KO,00192H
		WORD	ED_DK,ED_DK,ED_DK,ED_DK,ED_DK,ED_DK
;
EDNM067		EQU	$
		WORD	ED_AA,ED_OO,ED_KI,ED_NO,ED_KO,00193H
		WORD	ED_DK,ED_DK,ED_DK,ED_DK,ED_DK,ED_DK
;
EDNM068		EQU	$
		WORD	ED_AA,ED_OO,ED_KI,ED_NO,ED_KO,00194H
		WORD	ED_DK,ED_DK,ED_DK,ED_DK,ED_DK,ED_DK
;
EDNM069		EQU	$
		WORD	ED_AA,ED_OO,ED_KI,ED_NO,ED_KO,00196H
		WORD	ED_DK,ED_DK,ED_DK,ED_DK,ED_DK,ED_DK
;
EDNM06A		EQU	$
		WORD	ED_AA,ED_OO,ED_KI,ED_NO,ED_KO,00198H
		WORD	ED_DK,ED_DK,ED_DK,ED_DK,ED_DK,ED_DK
;
EDNM06C		EQU	$
		WORD	ED_AA,ED_YA,ED_SI,ED_II,ED_KI,00198H
		WORD	ED_DK,ED_LK,ED_TA,ED_TT,ED_II,ED_RK
;
EDNM06D		EQU	$
		WORD	ED_AA,ED_YA,ED_SI,ED_II,ED_KI,00198H
		WORD	ED_DK,ED_LK,ED_SI,ED_YOO,ED_UU,ED_RK
;
EDNM06E		EQU	$
		WORD	ED_II,ED_WA,ED_DK,ED_LK,ED_TA,ED_TT
		WORD	ED_II,ED_RK,ED_DK,ED_DK,ED_DK,ED_DK
;
EDNM06F		EQU	$
		WORD	ED_II,ED_WA,ED_DK,ED_LK,ED_SI,ED_YOO
		WORD	ED_UU,ED_RK,ED_DK,ED_DK,ED_DK,ED_DK
;
EDNM070		EQU	$
		WORD	ED_SI,ED_TT,ED_YAA,ED_NN,ED_KU,ED_RU
		WORD	ED_NO,ED_TO,ED_UU,ED_TA,ED_TT,ED_II
;
EDNM071		EQU	$
		WORD	ED_SI,ED_TT,ED_YAA,ED_NN,ED_KU,ED_RU
		WORD	ED_NO,ED_TO,ED_UU,ED_SI,ED_YOO,ED_UU
;
EDNM072		EQU	$
		WORD	ED_KU,ED_TT,ED_RE,ED_II,ED_NO,ED_TO
		WORD	ED_UU,ED_DK,ED_DK,ED_DK,ED_DK,ED_DK
;
EDNM073		EQU	$
		WORD	ED_KU,ED_TUU,ED_HA,ED_ML,ED_SI,ED_TT
		WORD	ED_YOO,ED_UU,ED_DK,ED_DK,ED_DK,ED_DK
;
EDNM07A		EQU	$
		WORD	ED_HO,ED_ML,ED_II,ED_NN,ED_TO,ED_DK
		WORD	00190H,ED_DK,ED_DK,ED_DK,ED_DK,ED_DK
;
EDNM07B		EQU	$
		WORD	ED_HO,ED_ML,ED_II,ED_NN,ED_TO,ED_DK
		WORD	00191H,ED_DK,ED_DK,ED_DK,ED_DK,ED_DK
;
EDNM07C		EQU	$
		WORD	ED_HO,ED_ML,ED_II,ED_NN,ED_TO,ED_DK
		WORD	00192H,ED_DK,ED_DK,ED_DK,ED_DK,ED_DK
;
EDNM07D		EQU	$
		WORD	ED_HO,ED_ML,ED_II,ED_NN,ED_TO,ED_DK
		WORD	00193H,ED_DK,ED_DK,ED_DK,ED_DK,ED_DK
;
EDNM07E		EQU	$
		WORD	ED_HO,ED_ML,ED_II,ED_NN,ED_TO,ED_DK
		WORD	00194H,ED_DK,ED_DK,ED_DK,ED_DK,ED_DK
;
EDNM07F		EQU	$
		WORD	ED_HO,ED_ML,ED_II,ED_NN,ED_TO,ED_DK
		WORD	00195H,ED_DK,ED_DK,ED_DK,ED_DK,ED_DK
;
EDNM080		EQU	$
		WORD	ED_HO,ED_ML,ED_II,ED_NN,ED_TO,ED_DK
		WORD	00196H,ED_DK,ED_DK,ED_DK,ED_DK,ED_DK
;
EDNM081		EQU	$
		WORD	ED_HO,ED_ML,ED_II,ED_NN,ED_TO,ED_DK
		WORD	00197H,ED_DK,ED_DK,ED_DK,ED_DK,ED_DK
;
EDNM082		EQU	$
		WORD	ED_HO,ED_ML,ED_II,ED_NN,ED_TO,ED_DK
		WORD	00198H,ED_DK,ED_DK,ED_DK,ED_DK,ED_DK
;
EDNM083		EQU	$
		WORD	ED_HO,ED_ML,ED_II,ED_NN,ED_TO,ED_DK
		WORD	00199H,ED_DK,ED_DK,ED_DK,ED_DK,ED_DK
;
EDNM084		EQU	$
		WORD	ED_HO,ED_ML,ED_II,ED_NN,ED_TO,ED_DK
		WORD	00170H,ED_DK,ED_DK,ED_DK,ED_DK,ED_DK
;
EDNM085		EQU	$
		WORD	ED_HO,ED_ML,ED_II,ED_NN,ED_TO,ED_DK
		WORD	00171H,ED_DK,ED_DK,ED_DK,ED_DK,ED_DK
;
EDNM086		EQU	$
		WORD	ED_HO,ED_ML,ED_II,ED_NN,ED_TO,ED_DK
		WORD	00172H,ED_DK,ED_DK,ED_DK,ED_DK,ED_DK
;
EDNM087		EQU	$
		WORD	ED_HO,ED_ML,ED_II,ED_NN,ED_TO,ED_DK
		WORD	00173H,ED_DK,ED_DK,ED_DK,ED_DK,ED_DK
;
EDNM088		EQU	$
		WORD	ED_HO,ED_ML,ED_II,ED_NN,ED_TO,ED_DK
		WORD	00174H,ED_DK,ED_DK,ED_DK,ED_DK,ED_DK
;
EDNM089		EQU	$
		WORD	ED_HO,ED_ML,ED_II,ED_NN,ED_TO,ED_DK
		WORD	00175H,ED_DK,ED_DK,ED_DK,ED_DK,ED_DK
;
;
MODEDT		EQU	$
		WORD	MDDAT0,MDDAT1,MDDAT2,MDDAT3
;
MDDAT0	EQU	$
	WORD	0018FH,0018FH,0018FH,0018FH
	WORD	0017CH,00170H,0017FH,0018FH		; "MAP "
	WORD	00184H,0017DH,00178H,00183H,0018FH	; "UNIT "
	WORD	00182H,00174H,00183H,0018FH		; "SET "
	WORD	0017CH,0017EH,00173H,00174H		; "MODE"
	WORD	0018FH,0018FH,0018FH,0018FH
;
MDDAT1	EQU	$
	WORD	0018FH
	WORD	0017CH,00170H,0017FH,0018FH		; " MAP "
	WORD	0017FH,0017EH,00178H,0017DH,00183H	; "POINT"
	WORD	0018FH,00173H,00170H,00183H,00170H	; " DATA"
	WORD	0018FH,00182H,00174H,00183H,0018FH	; " SET "
	WORD	0017CH,0017EH,00173H,00174H		; "MODE"
	WORD	0018FH,0018FH
;
MDDAT2	EQU	$
	WORD	0017DH,00174H,00187H,00183H,0018FH	; "NEXT "
	WORD	00176H,0017EH,00183H,0017EH,0018FH	; "GOTO "
	WORD	0017FH,0017EH,00178H,0017DH,00183H	; "POINT"
	WORD	0018FH,00182H,00174H,00183H,0018FH	; " SET "
	WORD	0017CH,0017EH,00173H,00174H,0018FH	; "MODE "
;
MDDAT3	EQU	$
	WORD	0017FH,0017BH,00170H,00188H,00174H,00181H ; "PLAYER"
	WORD	0018FH,0017CH,0017EH,00185H,00174H	; " MOVE"
	WORD	0018FH,00173H,00170H,00183H,00170H	; " DATA"
	WORD	0018FH,00182H,00174H,00183H,0018FH	; " SET "
	WORD	0017CH,0017EH,00173H,00174H		; "MODE"
;
;
;
;
;
		END
