;************************************************************************
;*									*
;*	title name	: "yossy map tool"				*
;*	proccess	: system main					*
;*	file name	: ysm_main					*
;*									*
;************************************************************************
;
;
		SALL
;
		include		ysm_header.inc
;
		XALL
;
;
;------------------------------------------------------------------------
;-		global symbol						-
;------------------------------------------------------------------------
		GLB	BLNKON,BLNKOFF,DMA_M_M,DMA_D_M,RAMCLR,URAMCLR,VRAMCL
		GLB	OAMCLR,OAMCHG,JSRSUB,JSLSUB
;
		GLB	VCLDAT
;
		GLB	MPTS,MPT2,EDT0,MNU0
;
;------------------------------------------------------------------------
;-		extern symbol						-
;------------------------------------------------------------------------
;
;-------------< SFX-DOS >------------------------------------------------
		EXT	NMI_Entry,IRQ_Entry
;
;-------------< ysm_rpro >-----------------------------------------------
		EXT	RPRO_ROM
		EXT	NMISUB,IRQSUB,CHIPON
		EXT	VMADSPL
;
		EXT	VTCL
;
;-------------< ysm_init >-----------------------------------------------
;
;-------------< ysm_title >----------------------------------------------
		EXT	TLINIT,TLPLAY
;
;-------------< ysm_map >------------------------------------------------
		EXT	MPTSIN,MPTEST,MPTSIN2
;
;-------------< ysm_edit >-----------------------------------------------
		EXT	EDIT0IN,EDIT0MV
;
;-------------< ysm_file >-----------------------------------------------
		EXT	FILEIN,FILEMV
;
;-------------< ysm_file >-----------------------------------------------
		EXT	MENUIN,MENUMV
;
;------------------------------------------------------------------------
;-		define symbol						-
;------------------------------------------------------------------------
;;;;		EQU
;
;
;
;************************************************************************
;*									*
;*		interrupt vector					*
;*									*
;************************************************************************
;
		ORG	0DFF6H
;
		WORD	RTISUB		;break
		WORD	RTISUB		;abort
		WORD	00108H		;NMI
		WORD	RESET		;reset
		WORD	0010CH		;IRQ
;
;
;************************************************************************
;*									*
;*		program start						*
;*									*
;************************************************************************
;
;
;;;;K;;;;		ORG	08000H
;
;
		EXTEND
;
;
		MEM8
		IDX8
;
Group_0		GROUP	Main_pro
Main_pro	SECT	REL
;
;************************************************************************
;*		reset							*
;************************************************************************
;
RESET		EQU	$
		DOS	_DOSSTP		;sfx-dos stop !!
;
		STZ	420CH		;H-DMA "OFF"
;
		LDA	#00000001B	;B-RAM enable
		STA	3033H
		STZ	2106H		;mozaiku flag reset
		STZ	2140H		;sound port reset
		STZ	2141H		;	"
		STZ	2142H		;	"
		STZ	2143H		;	"
;
		LDA	#0FFH		;I/O port reset
		STA	4201H
		STZ	4207H		;H counter reset
		STZ	4208H
		STZ	4209H		;V	"
		STZ	420AH
		STZ	420BH		;M-DMA switch reset
		STZ	420CH		;H-	  "
		STZ	420DH		;memory access cycle reset (
;
		M16
;
		LDA	#8000H		;OAM rotation reset
		STA	2102H
;
;-------------- RAM vecter set ------------------------------------------
		LDX	#(RMVCTTBLE-RMVCTTBL)-1
RESET010	EQU	$
		LDA	!RMVCTTBL,X
		STA	RAMVCT,X
		DEX
		DEX
		BPL	RESET010
;
;-------------- RAM program set -----------------------------------------
		LDA	#RPRO_RAM	;to memory address set
		STA	<WORK20
		LDY	#BANK RPRO_RAM
		STY	<WORK22
		LDA	#RPRO_ROM	;from memory address set
		STA	<WORK23
		LDY	#BANK RPRO_ROM
		STY	<WORK25
		LDA	#4000H		;(A) <-- number of byte set
		JSL	>DMA_M_M	;DMA "ON"
;
		MI8
;
;-------------- system RAM initial clear --------------------------------
		LDX	#STACK-SYSRAM-1
RESET020	EQU	$
		STZ	SYSRAM,X
		DEX
		BPL	RESET020
;
		LDA	#00000000B	;M-chip 10MHz mode set
		STA	3039H
		LDA	#10100000B	;chip config set ( IRQ disab
		STA	3037H
		LDA	#018H		;chip screen base initial set
		STA	CIPSCB
		LDA	#00111101B	;     "      size mode set
		STA	CIPSCR
;
		JSL	>RAMCLR		;all RAM clear !!
;
;-------------- interrupt enable ----------------------------------------
;
		M16
;
		LDX	#BANK CHIPINIT
		LDA	#CHIPINIT
		JSL	>CHIPON
;
		M8
;
		CLI			;IRQ enable
;
;************************************************************************
;*		game main						*
;************************************************************************
;
GSTART		EQU	$
		LDA	NMIFLG
		BMI	GSTART
;
;-------------- pause check -----------------------------
		LDA	<KEYC2
		AND	#00010000B
		BEQ	GST010
		LDA	PAUSE
		EOR	#01
		STA	PAUSE
GST010		EQU	$
		LDA	PAUSE
		BEQ	GST040
;
		LDY	#20H
		LDA	<KEYC2L
		AND	#00010000B
		BNE	GST032
;
		LDA	<KEYC1L
		AND	#00110000B
		BNE	GST020
;
		STZ	PASTM
		BRA	GST050
;
GST020		EQU	$
		LDA	PASTM
		BEQ	GST030
		DEC	PASTM
		BRA	GST050
;
GST030		EQU	$
		LDY	#04H
GST032		EQU	$
		STY	PASTM
;
GST040		EQU	$
;--------------------------------------------------------
;
		M16
;
		INC	<FRCNT		;frame counter set
;
		M8
;
		JSL	>MODESEL	;game mode select
;
GST050		EQU	$
		DEC	NMIFLG
		BRA	GSTART
;
;
;************************************************************************
;		RAM vecter data						*
;************************************************************************
RMVCTTBL	EQU	$
		RTI			;[100]
		NOP
		NOP
		NOP
;
		RTI			;[104] COP
		NOP
		NOP
		NOP
;
		JMP	>NMISUB		;[108] NMI
;
		JMP	>IRQSUB		;[10C] IRQ
;
		JMP	>NMI_Entry	;[110] SFX-DOS NMI
;
		JMP	>IRQ_Entry	;[114] SFX-DOS IRQ
;
RMVCTTBLE	EQU	$
;
;************************************************************************
;		interrapt return					*
;************************************************************************
RTISUB		EQU	$
		RTI
;
;
;
;************************************************************************
;		game mode select					*
;************************************************************************
;
MODESEL		EQU	$
		LDA	MODENO
		ASL	A
;;;;		CLC
		ADC	MODENO
		TAX
		PHB			;(DBR) save
		LDA	!MODETBL+2,X
		PHA
		PHA
		PLB			;(DBR) <-- (PBR)
		LDA	>MODETBL+1,X
		PHA
		LDA	>MODETBL,X
		PHA
		RTL
;
;-------------- game mode program address table -----------------
MODETBL		EQU	$
TTLIN		LWORD	TLINIT-1	;title initial
		LWORD	FADEST2-1	;fade "in/out" ( timer type ) set
TTLPL		LWORD	TLPLAY-1	;title play
EDIT0		LWORD	FADEST-1	;fade "in/out" set
		LWORD	EDIT0IN-1	;map data edit initial
		LWORD	FADEST-1	;fade "in/out" set
		LWORD	EDIT0MV-1	;map data edit play
FILEI		LWORD	FADEST-1	;fade "in/out" set
		LWORD	FILEIN-1	;map data edit file mode initial
		LWORD	FADEST-1	;fade "in/out" set
		LWORD	FILEMV-1	;map data edit file mode play
MPTES		LWORD	FADEST-1	;fade "in/out" set
		LWORD	MPTSIN-1	;map test initial
MPTS2		LWORD	MPTSIN2-1	;	"         ( no blanking )
		LWORD	MPTEST-1	;    "    play
;
MENU0		LWORD	FADEST-1	; fade "in/out" set
		LWORD	MENUIN-1	; menu initial mode
		LWORD	FADEST-1	; fade "in/out" set
		LWORD	MENUMV-1	; menu move mode
;
;
TLIN		EQU	(TTLIN-MODETBL)/3
TLPL		EQU	(TTLPL-MODETBL)/3
EDT0		EQU	(EDIT0-MODETBL)/3
FILE		EQU	(FILEI-MODETBL)/3
MPTS		EQU	(MPTES-MODETBL)/3
MPT2		EQU	(MPTS2-MODETBL)/3
MNU0		EQU	(MENU0-MODETBL)/3
;
;************************************************************************
;*		blanking "ON"						*
;************************************************************************
BLNKON		EQU	$
		SEI
		STZ	4200H		;NMI disable
		STZ	1E00H		;     "
		STZ	420CH		;H-DMA "OFF"
		LDA	#10000000B	;blanking "ON"
		STA	2100H
		RTL
;
;************************************************************************
;*		blanking "OFF"						*
;************************************************************************
BLNKOFF		EQU	$
		LDA	#10000001B	;NMI enable
		STA	4200H
		STA	1E00H
		CLI
		RTL
;
;************************************************************************
;*		OAM clear						*
;************************************************************************
OAMCLR		EQU	$
;
		M16
;
		LDX	#BANK OAM_CLR
		LDA	#OAM_CLR
		JSL	>CHIPON
;
		M8
;
		RTL
;
;************************************************************************
;*		OAM convert & change					*
;************************************************************************
OAMCHG		EQU	$
;
		M16
;
		LDX	#BANK OAMCHG2
		LDA	#OAMCHG2
		JSL	>CHIPON
;
		M8
;
		RTL
;
;************************************************************************
;*		VRAM clear						*
;************************************************************************
NUK		EQU	0000H
VCLDAT		EQU	$		;screen all clear data !!
		WORD	0FFFFH
;
VRAMCL		EQU	$
		JSL	>BLNKON
;
;-------------- OAM intial --------------------------------------
		JSL	>OAMCLR		;OAM clear
;
;-------------- BG clear ----------------------------------------
		LDA	#VTCL
		STA	VRFLG
VCL010		EQU	$
		JMP	>VMADSPL
;
;************************************************************************
;*		memory DMA ( block transfer )				*
;*			in  : (WK20,21,22) <-- to memory address	*
;*			      (WK23,24,25) <-- from	 "              *
;*			      (A)	   <-- number of byte		*
;************************************************************************
;
		MEM16
		IDX8
;
DMA_M_M		EQU	$
		STA	4305H		;number of byte set
;
		LDA	<WORK20		;to memory address set
		STA	2181H		;	  "
		LDY	<WORK22
		STY	2183H
;
		LDA	#00000000B+(080H*100H)	;DMA parameter & B bus address set
		STA	4300H
		LDA	<WORK23		;A bus address set
		STA	4302H
		LDY	<WORK25
		STY	4304H
;
		LDY	#00000001B	;DMA "ON"
		STY	420BH
		RTL
;
;************************************************************************
;*		memory DMA ( 1 byte data fill )				*
;*			in  : (WK20,21,22) <-- to memory address	*
;*			      (A)	   <-- number of byte		*
;*			      (Y)	   <-- fill 1 byte data		*
;************************************************************************
;
		MEM16
		IDX8
;
DMA_D_M		EQU	$
		STA	4305H		;number of byte set
;
		STY	211BH
		LDX	#00
		STX	211BH
		INX			;x1
		STX	211CH
;
		LDA	#10000000B+(034H*100H)	;DMA parameter & B bus address set
		STA	4300H
		LDA	<WORK20		;A bus address set
		STA	4302H
		LDX	<WORK22
		STX	4304H
;
		LDX	#00000001B	;DMA "ON"
		STX	420BH
		RTL
;
		MEM8
;
;************************************************************************
;*		RAM clear						*
;************************************************************************
RAMCLR		EQU	$
		JSL	>BLNKON		;blanking "ON"
;
		M16
;
		LDY	#00			;(Y) <-- 0 clear data
;
;-------------< 000H - 0FFH >--------------------------------------------
		STZ	<WORK20			;to memory address set
		STZ	<WORK22
		LDA	#(0FFH-000H)+1		;(A) <-- number of byte
		JSL	>DMA_D_M		;DMA "ON"
;
;-------------< 0200H - 1DFFH >--------------------------------------
		LDA	#0200H			;to memory address set
		STA	<WORK20
		LDA	#(1DFFH-0200H)+1	;(A) <-- number of data
		JSL	>DMA_D_M		;DMA "ON"
;
;-------------< 7E4000H - 7EBFFFH >--------------------------------------
		LDA	#4000H			;to memory address set
		STA	<WORK20
		LDX	#07EH
		STX	<WORK22
		LDA	#(7EBFFFH-7E4000H)+1	;(A) <-- number of data
		JSL	>DMA_D_M		;DMA "ON"
;
;-------------< 7F0000H - 7FFFFFH >--------------------------------------
		STZ	<WORK20			;to memory address set
		LDX	#07FH
		STX	<WORK22
		LDA	#(7FFFFFH-7F0000H)+1	;(A) <-- number of data
		JSL	>DMA_D_M		;DMA "ON"
;
;-------------< 700000H - 707FFFH >--------------------------------------
		LDX	#070H			;to memory address set
		STX	<WORK22
		LDA	#(707FFFH-700000H)+1	;(A) <-- number of data
		JSL	>DMA_D_M		;DMA "ON"
;
;-------------< initial RAM set >----------------------------------------
		LDA	#0FFFFH		;BG write( VRAMD ) end code set
		STA	>VRAMD+2
		LDA	#VRAMDX+2	;    "   ( VRAMDX )      "
		STA	>VRAMDX
;
		M8
;
		RTL
;
;************************************************************************
;*		clear area RAM clear					*
;************************************************************************
URAMCLR		EQU	$
;
		M16
;
		LDY	#00		;(Y) <-- 0 clear data
;
;-------------- SFC ---------------------------------------------
		STZ	<WORK21		;to memory address set
		LDA	#CLRRM0_S
		STA	<WORK20
		LDA	#CLR0SE		;(A) <-- number of byte
		JSL	>DMA_D_M	;DMA "ON"
;
		LDA	#CLRRM1_S
		STA	<WORK20
		LDA	#CLR1SE		;(A) <-- number of byte
		JSL	>DMA_D_M	;DMA "ON"
;
;-------------- M-chip ------------------------------------------
		LDA	#MCLRRM0_S
		STA	<WORK20
		LDA	#MCLR0SE	;(A) <-- number of byte
		JSL	>DMA_D_M	;DMA "ON"
;
		LDA	#MCLRRM1_S
		STA	<WORK20
		LDA	#MCLR1SE	;(A) <-- number of byte
		JSL	>DMA_D_M	;DMA "ON"
;
		LDA	#MCLRRM2_S
		STA	<WORK20
		LDX	#BANK MCLRRM2_S
		STX	<WORK22
		LDA	#MCLR2SE	;(A) <-- number of byte
		JSL	>DMA_D_M	;DMA "ON"
;
		M8
;
		RTL
;
;************************************************************************
;*		call subroutine						*
;*			in  : (A) <- call no.				*
;************************************************************************
;
JSRSUB		EQU	$
		STY	<WORK+3		;(Y) save
;
		PLY
		STY	<WORK
;
		MI16
;
		AND	#00FFH
		ASL	A
		TAY
		PLA
		STA	<WORK+1
;
		INY
		LDA	[<WORK],Y
		STA	<WORK
;
		MI8
;
		LDY	<WORK+3		;(Y) load
		JML	(WORK)
;
;************************************************************************
;*		call subroutine ( long )				*
;*			in  : (A) <- call no.				*
;************************************************************************
;
JSLSUB		EQU	$
		STY	<WORK+5		;(Y) save
;
		PLY
		STY	<WORK+2
;
		MI16
;
		AND	#00FFH
		STA	<WORK+3
		ASL	A
		ADC	<WORK+3
		TAY
		PLA
		STA	<WORK+3
;
		INY
		LDA	[<WORK+2],Y
		STA	<WORK
		INY
		LDA	[<WORK+2],Y
		STA	<WORK+1
		XBA
;
		MI8
;
		PHB			;(DBR) save
;;;;		LDA	<WORK+2		;(DBR) <-- (PBR)
		PHA
		PLB
		LDY	<WORK+5		;(Y) load
		JML	(WORK)
;
;************************************************************************
;*		fade in/out						*
;************************************************************************
FADADD		EQU	$
		HEX	01,FF
FADCMP		EQU	$
		HEX	0F,00
;
FADEST		EQU	$
		LDX	FADMK
		LDA	FADNO
		CLC
		ADC	!FADADD,X
		STA	FADNO
		CMP	!FADCMP,X
		BNE	FAD010		;fade end ? ( no:FAD010 )
;
		TXA			;fade muki set
		EOR	#01H
		STA	FADMK
;
;-------------- go to next mode ---------------------------------
		INC	MODENO
;
FAD010		EQU	$
		PLB
		RTL
;
;************************************************************************
;*		fade in/out ( timer type )				*
;************************************************************************
;
FADEST2		EQU	$
		DEC	FADTM
		BPL	FAD010		;wait ? ( yes:FAD010 )
;
		LDA	#02H		;wait timer set
		STA	FADTM
		BRA	FADEST
;
;
;
;
;
		END
