;****************************************************************
;*								*
;*	title name	: "yossy map tool"			*
;*	proccess	: map data edit menu mode		*
;*	file name	: ysm_menu				*
;*								*
;****************************************************************
;
;
		SALL
;
		include		ysm_header.inc
;
		XALL
;
;
;----------------------------------------------------------------
;-		global symbol					-
;----------------------------------------------------------------
		GLB	MENUIN,MENUMV
;
;----------------------------------------------------------------
;-		extern symbol					-
;----------------------------------------------------------------
;
;-------------< ysm_main >---------------------------------------
		EXT	VRAMCL,URAMCLR
		EXT	EDT0,MPTS
;
;-------------< ysm_map >---------------------------------------
		EXT	PFGON
;
;-------------< ysm_rpro >---------------------------------------
		EXT	KYREAD
;
;-------------< ysm_init >---------------------------------------
		EXT	GMMDST
		EXT	FL00
;
;-------------< ysm_title >--------------------------------------
		EXT	MODINC,MODINC2
;
;----------------------------------------------------------------
;-		define symbol					-
;----------------------------------------------------------------
;
;
;
;****************************************************************
;*								*
;*	program start						*
;*								*
;****************************************************************
;
;
;
		EXTEND
;
;
		MEM8
		IDX8
;
Group_1		GROUP	Menu_pro
Menu_pro	SECT	REL
;
;
;****************************************************************
;*	map data edit menu mode initial				*
;****************************************************************
;
MENUIN		EQU	$
		JSL	>VRAMCL		; VRAM clear
		JSL	>URAMCLR	; use RAM clear
;
;-------------- PPU Register initial set ------------------------
		LDX	#FL00		; (X) <-- map mode type no.
		JSL	>GMMDST		; game mode set
		LDA	#079H
		STA	2107H
		LDA	#005H
		STA	210BH
;
;-------------- mode 0 character set ----------------------------
;
		M16			; memory 16bit mode
;
		LDY	#10000000B
		STY	2115H		; inc mode set
		LDA	#5000H
		STA	2116H		; VRAM address set
		LDA	#00000001B+(18H*100H)
		STA	4300H		; DMA parameter & B bus address set
		LDA	#099800H
		STA	4302H		; A bus address(L,H) set
		LDY	#BANK 099800H
		STY	4304H		;        "     (B) set
		LDA	#02000H
		STA	4305H		; number of byte set
		LDX	#00000001B
		STX	420BH		; DMA "ON"
;
;-------------- mode 0 screen write -----------------------------
		LDA	#07800H
		STA	2116H		; VRAM address set
		LDA	#00000001B+(18H*100H)
		STA	4300H		; DMA parameter & B bus address set
		LDA	#09C000H
		STA	4302H		; A bus address(L,H) set
;;K;;		LDY	#BANK 09C000H
;;K;;		STY	4304H		;        "     (B) set
		LDA	#0800H
		STA	4305H		; number of byte set
		STX	420BH		; DMA "ON"
;
		LDA	#07C00H
		STA	2116H		; VRAM address set
		LDA	#00000001B+(18H*100H)
		STA	4300H		; DMA parameter & B bus address set
		LDA	#09C800H
		STA	4302H		; A bus address(L,H) set
;;K;;		LDY	#BANK 09C800H
;;K;;		STY	4304H		;        "     (B) set
		LDA	#0800H
		STA	4305H		; number of byte set
		STX	420BH		; DMA "ON"
;
;-------------- OBJ character set -------------------------------
		LDA	#4000H
		STA	2116H		; VRAM address set
		LDA	#00000001B+(18H*100H)
		STA	4300H		; DMA parameter & B bus address set
		LDA	#098000H
		STA	4302H		; A bus address(L,H) set
;;K;;		LDY	#BANK 098000H
;;K;;		STY	4304H		;        "     (B) set
		LDA	#0400H
		STA	4305H		; number of byte set
		STX	420BH		; DMA "ON"
;
;-------------- used ram initial set ----------------------------
;;;;K;;;;		STZ	!MENUNO
		STZ	!DATAFG
		STZ	<DMDFLG
;
;-------------- map point data initial set ----------------------
;
		I16			; index 16bit mode
;
		LDA	!PTLMTCT
		AND	#000FFH
		BEQ	MNIN400
		STA	<WORK0
		LDX	#00000H
		TXY
MNIN300		EQU	$
		LDA	BTHTAD,Y
		INC	A
		INC	A
		INC	A
		STA	2116H
;					; quest count set
		TYA
		LSR	A
		TAY
		LDA	!QSTCNT,Y
		AND	#000FFH
		CLC
		ADC	#00030H
		STA	2118H
		TYA
		ASL	A
		TAY
;					; map type set
		LDA	>MPTTYP,X
		AND	#000FFH
		CLC
		ADC	#00041H
		STA	2118H
		INY
		INY
		TXA
		CLC
		ADC	#0010EH
		TAX
		DEC	<WORK0
		BNE	MNIN300
;
MNIN400		EQU	$		; goal count set
		I8			; index 8bit mode
		LDA	#07B08H
		STA	2116H
		LDX	!MENUNO
		LDA	!QSTCNT,X
		AND	#00007H
		INC	A
		INC	A
		ASL	A
		STA	<WORK0
		STZ	!GOLCNT
		STZ	!GOLCNT+2
		STZ	!GOLCNT+4
		STZ	!GOLCNT+6
		LDY	#000H
MNIN410		EQU	$
		LDA	GLDATA,Y
		BEQ	MNIN420
		STA	2118H
		STA	!GOLCNT,Y
		INY
		INY
		CPY	<WORK0
		BCC	MNIN410
;
;-------------- map point 1 data initial set --------------------
MNIN420		EQU	$
		MI16			; memory , index 16bit mode
		PHB
		LDX	#09C880H
		LDY	#DTMDDT
		LDA	#003FFH
		MVN	#009H,#BANK DTMDDT
		PLB
;
		LDA	#00000H
		LDX	!MENUNO
		BEQ	MNIN510
MNIN500		EQU	$
		CLC
		ADC	#0010EH
		DEX
		BNE	MNIN500
		TAX
;
MNIN510		EQU	$
		STX	<WORK0
		STX	<WORK2
;
		LDX	<WORK2		; type
		LDA	>MPTTYP,X
		AND	#000FFH
		CLC
		ADC	#00041H
		STA	!DTMDTP
;
		LDA	#00030H		; parts point
		STA	<WORKA
		STA	<WORKC
		LDA	>MPTPOS,X
		AND	#000FFH
		JSR	H16D10		; 16h -> 10d
		LDA	<WORKA
		STA	!DTMDPT+0
		LDA	<WORKC
		STA	!DTMDPT+2
		LDA	<WORKE
		STA	!DTMDPT+4
;
		LDA	>MPTTNO,X	; data table NO.
		AND	#000FFH
		STA	<WORK0
		JSR	H16DMA		; 16h DMA set
		LDA	<WORK2
		STA	!DTMDTB+0
		LDA	<WORK4
		STA	!DTMDTB+2
;
		LDA	>MPTTIM,X	; timer
		AND	#000FFH
		STA	<WORK0
		JSR	H16DMA		; 16h DMA set
		LDA	<WORK2
		STA	!DTMDTM+0
		LDA	<WORK4
		STA	!DTMDTM+2
;
		LDA	>MPTPLX,X	; player X point
		AND	#000FFH
		STA	<WORK0
		JSR	H16DMA		; 16h DMA set
		LDA	<WORK2
		STA	!DTMDPX+0
		LDA	<WORK4
		STA	!DTMDPX+2
;
		LDA	>MPTPLY,X	; player Y point
		AND	#000FFH
		STA	<WORK0
		JSR	H16DMA		; 16h DMA set
		LDA	<WORK2
		STA	!DTMDPY+0
		LDA	<WORK4
		STA	!DTMDPY+2
;
		LDA	!QSTPOS		; quest clear data NO.
		AND	#00003H
		ORA	#000F0H
		STA	!DTMDCR
;
		M8			; memory 8bit mode
		LDA	!QSTPOS
		AND	#003H
		STA	<WORKA
		CLC
		ROR	A
		ROR	A
		ROR	A
		ADC	<WORKA
		STA	<WORKA
		STZ	<WORKB
		M16			; memory 16bit mode
		TXA
		CLC
		ADC	<WORKA
		TAX
;
		LDA	>MPTQNT,X	; next goto point NO.
		AND	#000FFH
		STA	<WORK0
		M8			;  memory 8bit mode
		STZ	!NXTFLG
		LDA	<WORK0
		BPL	ITNXPS
		INC	!NXTFLG
ITNXPS		EQU	$
		M16			;  memory 16bit mode
		JSR	H16DMA		; 16h DMA set
		LDA	<WORK2
		STA	!DTMDNT+0
		LDA	<WORK4
		STA	!DTMDNT+2
;
		LDA	!QSTPOS		; player move data NO.
		AND	#00003H
		ORA	#000F0H
		STA	!DTMDMV
;
		LDA	>MPT11P,X	; player type
		AND	#000FFH
		STA	<WORK0
		JSR	H16DMA		; 16h DMA set
		LDA	<WORK2
		STA	!DTMDPL+0
		LDA	<WORK4
		STA	!DTMDPL+2
;
		LDA	>MPT11X,X	; X point
		AND	#000FFH
		STA	<WORK0
		JSR	H16DMA		; 16h DMA set
		LDA	<WORK2
		STA	!DTMDPLX+0
		LDA	<WORK4
		STA	!DTMDPLX+2
;
		LDA	>MPT11Y,X	; Y point
		AND	#000FFH
		STA	<WORK0
		JSR	H16DMA		; 16h DMA set
		LDA	<WORK2
		STA	!DTMDPLY+0
		LDA	<WORK4
		STA	!DTMDPLY+2
;
		LDA	>MPT11Z,X	; Z point
		AND	#000FFH
		STA	<WORK0
		JSR	H16DMA		; 16h DMA set
		LDA	<WORK2
		STA	!DTMDPLZ+0
		LDA	<WORK4
		STA	!DTMDPLZ+2
;
;-------------- map point 1 data initial DMA set ----------------
		I8			; index 8bit mode
		LDY	#10000000B
		STY	2115H		; inc mode set
		LDA	#07C40H
		STA	2116H		; VRAM address set
		LDA	#00000001B+(18H*100H)
		STA	4300H		; DMA parameter & B bus address set
		LDA	#DTMDDT
		STA	4302H		; A bus address(L,H) set
		LDY	#BANK DTMDDT
		STY	4304H		;        "     (B) set
		LDA	#00400H
		STA	4305H		; number of byte set
		LDY	#00000001B
		STY	420BH		; DMA "ON"
		M8			; memory 8bit mode
		I16			; index 16bit mode
;
;-------------- color set ---------------------------------------
		LDX	#200H-1
MNIN900		EQU	$
		LDA	>09D200H,X
		STA	>DATACOL,X
		DEX
		BPL	MNIN900
;
		I8			; index 8bit mode
;
		LDA	!POINTFG
		BNE	MNIN990
		STZ	!MENUNO
		BRA	MNIN999
MNIN990		EQU	$
		STA	<SCCH1+1
		STA	!DATAFG
		LDA	#004H
		STA	<SCCH1
;
;--------------	go to next mode !! ------------------------------
MNIN999		EQU	$
		JMP	>MODINC2	; go to next mode !!
;
;
;++++++++++++++++++++++++++++++++++++++++
;+	16h DMA set			+
;+		   WORKA <- address	+
;+		   WORK0 <- data	+
;++++++++++++++++++++++++++++++++++++++++
		MEM16
		IDX16
H16DMA		EQU	$
		LDA	<WORK0
		AND	#000F0H
		LSR	A
		LSR	A
		LSR	A
		LSR	A
		ORA	#000F0H
		STA	<WORK2
		LDA	<WORK0
		AND	#0000FH
		ORA	#000F0H
		STA	<WORK4
		RTS
		MEM8
		IDX8
;
;
;++++++++++++++++++++++++++++++++++++++++
;+	16h -> 10d			+
;+			A <- data	+
;++++++++++++++++++++++++++++++++++++++++
		MEM16
		IDX16
H16D10		EQU	$		; "100"
		CMP	#00100
		BCC	MNIN523
		INC	<WORKA
		SEC
		SBC	#00100
		BRA	H16D10
MNIN523		EQU	$		: "10"
		CMP	#00010
		BCC	MNIN525
		SEC
		SBC	#00010
		INC	<WORKC
		BRA	MNIN523
MNIN525		EQU	$
		CLC
		ADC	#00030H
		STA	<WORKE		; "1"
		RTS
		MEM8
		IDX8
;
;
GLDATA		EQU	$
		WORD	00030H,00031H,00032H,00033H,00000H
;
;
;****************************************************************
;*		map data edit menu mode move			*
;****************************************************************
MENUMV		EQU	$
;
;-------------- key input ---------------------------------------
		JSL	>KYREAD
;
;-------------- mouse cursol set --------------------------------
		LDA	!CSRXPS
		CLC
		ADC	!MOUSEBX
		STA	!CSRXPS
		SEC
		SBC	#007H
		STA	>OAM
		STA	>OAM+4
		LDA	!CSRYPS
		CLC
		ADC	!MOUSEBY
		STA	!CSRYPS
		STA	>OAM+1
		STA	>OAM+4+1
		LDA	#030H
		STA	>OAM+3
		STA	>OAM+4+3
;
		LDA	<MOUSEBS
		AND	#11000000B	; mouse key ON ?
		BEQ	MN000		;	NO -> MN000
		LDA	#002H
MN000		EQU	$
		STA	>OAM+2
		STA	>OAM+4+2
;
		LDA	#00001110B
		STA	>OAMSUB
;
;-------------- point check -------------------------------------
		LDA	!DATAFG
		BNE	MN050
		JSR	MN100		; menu mode point check
		BRA	MN9999
;
MN050		EQU	$
		JSR	MN500		; data mode point check
;
MN9999		EQU	$
		PLB
		RTL
;
;
;****************************************************************
;*								*
;*	menu mode point check					*
;*								*
;****************************************************************
MN100		EQU	$
		LDA	<MOUSEBS
		AND	#11000000B	; mouse key ON ?
		BNE	MN105		;	YES -> MN105
		JMP	MN490
MN105		EQU	$
		LDA	!CSRYPS
		CMP	#018H
		BCC	MN200
		CMP	#0B8H
		BCS	MN200
		MI16			; memory , index 16bit mode
		AND	#000F8H
		SEC
		SBC	#00018H
		ASL	A
		ASL	A
		STA	<WORK0
		LDA	!CSRXPS
		AND	#000FFH
		LSR	A
		LSR	A
		LSR	A
		ORA	<WORK0
		TAX
		M8			; memory 8bit mode
		LDA	MOUSPOS,X
		BEQ	MN150
		DEC	A
		CMP	!PTLMTCT
		BCS	MN150
		PHA
		STZ	<WORK2
		STZ	<WORK3
		JSR	BTHNTN		; bit ha-n-te-n VRAMDX set
		PLA
		STA	!MENUNO
		LDA	#004H
		STA	<WORK2
		JSR	BTHNTN		; bit ha-n-te-n VRAMDX set
		I8			; index 8bit mod
		JSR	GOLINT		; goal pointer initial set
		JSR	MPTINT		; map point data initial set
		JMP	MN499
MN150		EQU	$
		I8			; index 8bit mod
;
MN200		EQU	$
		LDA	<MOUSEBT
		AND	#11000000B
		BNE	MN205
		JMP	MN300
MN205		EQU	$
		LDA	!CSRYPS		; "EXIT" or ""DATA" ON ?
		CMP	#0C4H		;	NO -> MN300
		BCC	MN300
		CMP	#0D3H
		BCS	MN300
		LDA	!CSRXPS
		CMP	#0A5H
		BCC	MN300
		CMP	#0F4H
		BCS	MN300
		CMP	#0CDH		; "EXIT" ON goto MN250
		BCS	MN250
		LDA	!PTLMTCT
		BEQ	MN300
		LDA	#004H		; "DATA" ON
		STA	!SCCH1
		LDA	#001H
		STA	!SCCH1+1
		STA	!DATAFG
		STA	!POINTFG
		STZ	!DTSBPOS
		BRA	MN300
;
MN250		EQU	$
		LDA	#EDT0
		STA	!MODENO
		STZ	!POINTFG
		STZ	!NXTFLG
		LDA	#001H
		STA	!UNITNO
		BRA	MN490
;
MN300		EQU	$
		LDA	!CSRYPS
		CMP	#0C0H
		BCC	MN490
		CMP	#0C8H
		BCS	MN490
		LDA	!CSRXPS
		CMP	#040H
		BCC	MN490
		CMP	#060H
		BCS	MN490
		JSR	GOALST		; goal pointer set
		JSR	QCL100		; quest clear data set
		JSR	GOLINT		; goal pointer initial set
;
MN490		EQU	$
		LDA	<FRCNT
		AND	#010H
		LSR	A
		LSR	A
		STA	<WORK2
		STZ	<WORK3
		JSR	BTHNTN		; bit ha-n-te-n VRAMDX set
MN499		EQU	$
		RTS
;
;
;********************************************************
;*							*
;*	bit ha-n-te-n VRAMDX set			*
;*							*
;********************************************************
BTHNTN		EQU	$
		MI16			; memory , index 16bit mode
		LDA	!MENUNO
		ASL	A
		TAX
		M8			; memory 8bit mode
		PHB
		LDA	#BANK VRAMDX
		PHA
		PLB
		M16			; memory 16bit mode
		LDY	!VRAMDX
		LDA	>BTHTAD,X
		STA	0,Y		; 2116H , 2117H set
		LDA	#00980H
		STA	2,Y		; 2115H , 4300H set
		LDA	#00019H
		STA	4,Y		; 4301H set
		TYA
		CLC
		ADC	#0000CH
		STA	5,Y		; 4302H , 4303H set
		LDA	#0007EH
		STA	7,Y		; 4304H set
		LDA	#0000AH
		STA	8,Y		; 4305H , 4306H set
		LDA	!MENUNO
		AND	#000FFH
		CMP	#00051H		; 81D < A ?
		BCC	BTHTPS		;	YES -> BTHTPS
		LDA	#0000CH
		STA	8,Y
BTHTPS		EQU	$
		TYA
		CLC
		ADC	#0000EH
		STA	10,Y		; next address set
		STA	!VRAMDX		; end address set
		LDA	<WORK2
		STA	12,Y		; data set
		MI8			; memory , index 8bit mode
		PLB
		RTS
;
;
;********************************************************
;*							*
;*	goal pointer initial set			*
;*							*
;********************************************************
GOLINT		EQU	$
		M16			; memory 16bit mode
		LDA	#00030H
		STA	!GOLCNT
		LDA	#00020H
		STA	!GOLCNT+2
		STA	!GOLCNT+4
		STA	!GOLCNT+6
		M8			; memory 8bit mode
		LDX	!MENUNO
		LDA	!QSTCNT,X
		INC	A
		CMP	#00004H
		BCC	GLIT05
		LDA	#00003H
GLIT05		EQU	$
		ASL	A
		TAY
GLIT10		EQU	$
		LDA	GALDAT,Y
		STA	!GOLCNT,Y
		DEY
		DEY
		BNE	GLIT10
;
		PHB
		LDA	#BANK VRAMDX
		PHA
		PLB
		MI16			; memory , index 16bit mode
;
		LDY	!VRAMDX
		LDA	#07B08H
		STA	0,Y		; 2116H , 2117H set
		LDA	#00180H
		STA	2,Y		; 2115H , 4300H set
		LDA	#00018H
		STA	4,Y		; 4301H set
		LDA	#BANK GOLCNT
		STA	7,Y		; 4304H set
		LDA	#00008H
		STA	8,Y		; 4305H , 4306H set
		LDA	#GOLCNT
		STA	5,Y		; 4302H , 4303H set
		TYA
		CLC
		ADC	#0000CH
		STA	10,Y
		STA	!VRAMDX
;
		MI8			; memory , index 8bit mode
		PLB
		RTS
;
GALDAT		EQU	$-2
		WORD	00031H,00032H,00033H
;
;
;********************************************************
;*							*
;*	goal pointer set				*
;*							*
;********************************************************
GOALST		EQU	$
		LDX	!MENUNO
		LDA	!CSRXPS
		AND	#018H
		LSR	A
		LSR	A
		LSR	A
		STA	!QSTCNT,X
		STA	<WORK0
;
GOALSB		EQU	$
		M16			; memory 16bit mode
		LDA	>VRAMD
		TAX
		LDA	<WORK0
		AND	#0000FH
		ORA	#00030H
		STA	>VRAMD+6,X
		PHX
		LDA	!MENUNO
		AND	#000FFH
		TAY
		ASL	A
		TAX
		LDA	>BTHTAD,X
		INC	A
		INC	A
		INC	A
		CPY	#00051H		; 81D < A?
		BCC	GAL100		;	YES -> GAL100
		INC	A
GAL100		EQU	$
		PLX
		STA	>VRAMD+2,X
		LDA	#00001H
		STA	>VRAMD+4,X
		LDA	#0FFFFH
		STA	>VRAMD+8,X
		LDA	>VRAMD
		CLC
		ADC	#00006H
		STA	>VRAMD
		M8			; memory 8bit mode
		STZ	<WORK1
		LDA	<WORK0
		ORA	#0F0H
		STA	<WORK0
		RTS
;
;
;********************************************************
;*							*
;*	map point data initial set			*
;*							*
;********************************************************
MPTINT		EQU	$
		MI16			; memory , index 16bit mode
		JSR	MNNOSB		; map point data index set
;
		LDA	>MPTTYP,X	; type
		AND	#0000FH
		INC	A
		ORA	#00040H
		STA	!DTMDTP
;
		LDA	#00030H
		STA	<WORKA
		STA	<WORKC
		STA	<WORKE
		LDA	>MPTPOS,X	; parts point
		AND	#000FFH
		JSR	H16D10		; 16h -> 10d
		LDA	<WORKE
		STA	!DTMDPT+4
		LDA	<WORKC
		STA	!DTMDPT+2
		LDA	<WORKA
		STA	!DTMDPT
;
		LDA	>MPTTNO,X	; course data table NO.
		JSR	H16WRK		; DMA character work area set
		LDA	<WORK0
		STA	!DTMDTB+2
		LDA	<WORK2
		STA	!DTMDTB
;
		LDA	>MPTTIM,X	; timer
		JSR	H16WRK		; DMA character work area set
		LDA	<WORK0
		STA	!DTMDTM+2
		LDA	<WORK2
		STA	!DTMDTM
;
		LDA	>MPTPLX,X	; player X point
		JSR	H16WRK		; DMA character work area set
		LDA	<WORK0
		STA	!DTMDPX+2
		LDA	<WORK2
		STA	!DTMDPX
;
		LDA	>MPTPLY,X	; player Y point
		JSR	H16WRK		; DMA character work area set
		LDA	<WORK0
		STA	!DTMDPY+2
		LDA	<WORK2
		STA	!DTMDPY
;
		LDA	#000F0H		; quest clear data NO.
		STA	!DTMDCR
;
		LDA	>MPTQNT,X	; next goto point NO.
		STA	<WORK0
		M8			; memory 8bit mode
		STZ	!NXTFLG
		LDA	<WORK0
		BPL	NXTPAS
		INC	!NXTFLG
NXTPAS		EQU	$
		M16			; memory 16bit mode
		LDA	<WORK0
		JSR	H16WRK		; DMA character work area set
		LDA	<WORK0
		STA	!DTMDNT+2
		LDA	<WORK2
		STA	!DTMDNT
;
		LDA	#000F0H		; player move data NO.
		STA	!DTMDMV
;
		LDA	>MPT11P,X	; player type
		JSR	H16WRK		; DMA character work area set
		LDA	<WORK0
		STA	!DTMDPL+2
		LDA	<WORK2
		STA	!DTMDPL
;
		LDA	>MPT11X,X	;  X point
		JSR	H16WRK		; DMA character work area set
		LDA	<WORK0
		STA	!DTMDPLX+2
		LDA	<WORK2
		STA	!DTMDPLX
;
		LDA	>MPT11Z,X	; Z point
		JSR	H16WRK		; DMA character work area set
		LDA	<WORK0
		STA	!DTMDPLZ+2
		LDA	<WORK2
		STA	!DTMDPLZ
;
		LDA	>MPT11Z,X	; Y point
		JSR	H16WRK		; DMA character work area set
		LDA	<WORK0
		STA	!DTMDPLY+2
		LDA	<WORK2
		STA	!DTMDPL
;
		MI8			; memory , index 8bit mode
		LDX	!MENUNO
		LDA	!QSTCNT,X
		STA	!QSTPOS
		INC	<DMDFLG
		RTS
;
;
;++++++++++++++++++++++++++++++++++++++++
;+	DMA character work area set	+
;++++++++++++++++++++++++++++++++++++++++
		MEM16
		IDX16
H16WRK		EQU	$
		AND	#000FFH
		PHA
		AND	#0000FH
		ORA	#000F0H
		STA	<WORK0
		PLA
		LSR	A
		LSR	A
		LSR	A
		LSR	A
		ORA	#000F0H
		STA	<WORK2
		RTS
		MEM8
		IDX8
;
;
;****************************************************************
;*								*
;*	data mode point check					*
;*								*
;****************************************************************
MN500		EQU	$
		LDA	<MOUSEBT
		AND	#11000000B	; mouse key ON ?
		BNE	MN505		;	YES -> MN505
		JMP	MN800
;
MN505		EQU	$
		LDA	!CSRXPS
		CMP	#0A9H
		BCC	MN600
		CMP	#0D0H
		BCS	MN600
		LDA	!CSRYPS		; goto "MENU" ?
		CMP	#094H		;	NO -> MN550
		BCC	MN550
		CMP	#0A2H
		BCS	MN580
		STZ	!DATAFG
		STZ	!SCCH1
		STZ	!SCCH1+1
		JSR	ERRFLG_CLR	; G[tO NA
		JMP	MN999
;
MN550		EQU	$
		LDA	!CSRYPS		; goto "MAP" ?
		CMP	#084H		;	NO -> MN600
		BCC	MN580
		CMP	#092H
		BCS	MN580
		JSR	GOMPCK		; goto map OK check
		JSR	ERRFLG_CLR	; G[tO NA
		JMP	MN999
;
MN580		EQU	$
		CMP	#0A4H
		BCC	MN600
		CMP	#0B2H
		BCS	MN600
		LDA	!NXTFLG		; next goto point set OK ?
		BNE	MN599		;	NO -> MN600
		LDA	#MPTS		; "MAP MODE"
		STA	!MODENO
		LDA	#PFGON
		STA	!MPLMODE
		STZ	!MPFGONCT
		JMP	MN999
;
MN599		EQU	$
		LDA	#001H		; G[ !!
		STA	!ERRFLG		;	(next goto point set)
		JMP	MN999
;
MN600		EQU	$
		LDA	!CSRXPS
		CMP	#028H
		BCC	MN700
		CMP	#0A8H
		BCS	MN700
		LDA	!CSRYPS
		CMP	#084H
		BCC	MN700
		CMP	#0B2H
		BCS	MN700
;
		JSR	MN600_SB	; Zbg
;
MN650		EQU	$
		LDA	!DTSBPOS
		BEQ	MN700
		DEC	A
		ASL	A
		TAX
		JSR	(DATSET,X)	; data set
		JMP	MN800
;
MN700		EQU	$
		LDA	!CSRYPS
		CMP	#018H
		BCC	MN800
		CMP	#078H
		BCS	MN800
		MI16			; memory , index 16bit mode
		AND	#000F8H
		SEC
		SBC	#00018H
		ASL	A
		ASL	A
		STA	<WORK0
		LDA	!CSRXPS
		DEC	A
		DEC	A
		DEC	A
		DEC	A
		AND	#000F8H
		LSR	A
		LSR	A
		LSR	A
		ORA	<WORK0
		TAX
		M8			; memory 8bit mode
		LDA	DATSUB,X
		BEQ	MN800
		PHA
		STZ	<WORK0
		STZ	<WORK1
		JSR	DMCSLST		; data mode cursol set
		PLA
		STA	!DTSBPOS
		LDA	#004H
		STA	<WORK0
		JSR	DMCSLST		; data mode cursol set
		I8			; index 8bit mode
		JSR	ERRFLG_CLR	; G[tO NA
		JMP	MN999
;
MN800		EQU	$
		I8			; index 8bit mode
		LDA	!DTSBPOS
		BEQ	MN900
		LDA	<FRCNT
		AND	#010H
		LSR	A
		LSR	A
		STA	<WORK0
		STZ	<WORK1
		I16			; index 16bit mode
		JSR	DMCSLST		; data mode cursol set
		I8			; index 8bit mode
;
MN900		EQU	$
;
MN999		EQU	$
		LDA	!ERRFLG
		BEQ	MN999_999
		JSR	ERRSET		; G[ Zbg
MN999_999	EQU	$
		RTS
;
;
DATSET		EQU	$
		WORD	TYPDT
		WORD	PRSDT,PRSDT,PRSDT
		WORD	TBLDT,TBLDT
		WORD	TIMDT,TIMDT
		WORD	PLXDT,PLXDT
		WORD	PLYDT,PLYDT
		WORD	QCLDT
		WORD	NXTDT,NXTDT
		WORD	PMVDT
		WORD	PTPDT,PTPDT
		WORD	PXPDT,PXPDT
		WORD	PYPDT,PYPDT
		WORD	PZPDT,PZPDT
;
;
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+		G[tO NA			+
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
ERRFLG_CLR	EQU	$
		M16			; memory 16bit mode
		STZ	!ERRFLG
		STZ	!ERRTIM
		M8			; memory 8bit mode
		JSR	ERRSET
		RTS
;
;
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+		G[ Zbg			+
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
ERRDAT_ADR	EQU	$-2
		WORD	ERRDAT_01
;
ERRDAT_00	EQU	$
		WORD	0020H,0020H,0020H,0020H,0020H,0020H,0020H,0020H
		WORD	0020H,0020H,0020H,0020H,0020H,0020H,0020H,0020H
		WORD	0020H,0020H,0020H,0020H,0020H,0020H,0020H,0020H
		WORD	0020H,0020H,0020H,0020H,0020H,0020H,0020H,0020H
;
ERRDAT_01	EQU	$
		WORD	0020H,0020H,0020H,0020H,0020H,004EH,0045H,0058H
		WORD	0054H,0020H,0050H,004FH,0049H,004EH,0054H,01ABH
		WORD	0020H,00BEH,00AFH,00C4H,01BCH,01C3H,01B8H,01C0H
		WORD	00DEH,01BBH,01B2H,0020H,0020H,0020H,0020H,0020H
;
;
ERRSET		EQU	$
		M16			; memory 16bit mode
		LDA	#ERRDAT_00
		STA	<WORK0
		LDA	!ERRTIM
		AND	#00010H
		BEQ	ERRSET_300
;
		LDA	!ERRFLG
		ASL	A
		TAY
		LDA	ERRDAT_ADR,Y
		STA	<WORK0		; data adress set
;
ERRSET_300	EQU	$
		I16			; index 16bit mode
		PHB			;(DBR) save
		PEA	VRAMDX/100H	;(DBR) <-- VRAMDX(B)
		PLB
		PLB
;
		LDX	!VRAMDX		;(X) <-- VRAMDX set pointer
		LDA	#07F00H
		STA	0,X		;VRAM address set
		LDA	#10000000B+(00000001B*100H)
		STA	2,X		;VRAM address inc mode & DMA parameter set
		LDA	#18H
		STA	4,X		;B bus address set
		LDA	#BANK ERRDAT_ADR
		STA	7,X		;A bus address(B) set
		LDA	<WORK0
		STA	5,X		;	"     (L,H) set
		LDA	#00040H
		STA	8,X		;number of byte set
		TXA
		CLC
		ADC	#12
		STA	10,X		;next data address set
		STA	!VRAMDX		;end address set
;
		PLB
		I8			; index 8bit mode
;
		INC	!ERRTIM
		LDA	!ERRTIM
		AND	#000FFH
		STA	!ERRTIM
		BNE	ERRSET_990
		STZ	!ERRFLG
ERRSET_990	EQU	$
		M8			; memory 8bit mode
		RTS
;
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	LN^[ Zbg			+
;++++++++++++++++++++++++++++++++++++++++++++++++
MN600_SB	EQU	$
		LDA	!CSRXPS
		SEC
		SBC	#028H
		LSR	A
		LSR	A
		LSR	A
		LSR	A
		STA	<WORK0
;
		LDA	!CSRYPS
		CMP	#094H
		BCC	MN600_SB_PAS
		CMP	#0A4H
		BCS	MN600_SB_CLR
		LDA	<WORK0
		ORA	#008H
		STA	<WORK0
		BRA	MN600_SB_PAS
MN600_SB_CLR	EQU	$
		LDA	!DTSBPOS
		CMP	#00EH
		BEQ	MN600_SB_CLR_00
		CMP	#00FH
		BNE	MN600_SB_PAS
MN600_SB_CLR_00	EQU	$
		LDA	!CSRXPS
		CMP	#088H
		BCC	MN600_SB_PAS
		CMP	#0A8H
		BCS	MN600_SB_PAS
		LDA	#002H		; next goto RAM clear !!
		BRA	MN600_SB_PASS
MN600_SB_PAS	EQU	$
		LDA	<WORK0
		ORA	#0F0H
MN600_SB_PASS	EQU	$
		STA	<WORK0
		RTS
;
;
;********************************************************
;*	goto map OK check				*
;********************************************************
GOMPCK		EQU	$
		MI16			; memory , index 16bit mode
		JSR	MNNOSB		; map point data index set
		M8			; memory 8bit mode
		LDA	>MPTTYP,X
		ASL	A
		CMP	!MPCHGFG	; map type OK ?
		BNE	GMCK99		;	NO -> GMCK99
		LDA	#EDT0
		STA	!MODENO
		LDA	#07CH
		STA	!UNITNO
GMCK99		EQU	$
		I8			; index 8bit mode
		RTS
;
;
;************************************************
;*						*
;*	map type set				*
;*						*
;************************************************
TYPDT		EQU	$
;
		RTS
;
;
;************************************************
;*						*
;*	parts point set				*
;*						*
;************************************************
PRSDT		EQU	$
;
		RTS
;
;
;************************************************
;*						*
;*	data table NO. set			*
;*						*
;************************************************
TBLDT		EQU	$
;
		RTS
;
;
;************************************************
;*						*
;*	timer count set				*
;*						*
;************************************************
TIMDT		EQU	$
		LDA	#BANK MPTTIM
		STA	<WORK6
		M16			; memory 16bit mode
		LDA	#DTMDTM
		STA	<WORK2
		LDA	#MPTTIM
		STA	<WORK4
		LDA	!DTSBPOS
		AND	#00002H
		EOR	#00002H
		TAY
		JSR	MPTDTST		; map point data set
		M8			; memory 8bit mode
		RTS
;
;
;************************************************
;*						*
;*	player X point				*
;*						*
;************************************************
PLXDT		EQU	$
		LDA	#BANK MPTPLX
		STA	<WORK6
		M16			; memory 16bit mode
		LDA	#DTMDPX
		STA	<WORK2
		LDA	#MPTPLX
		STA	<WORK4
		LDA	!DTSBPOS
		EOR	#00001H
		AND	#00001H
		ASL	A
		TAY
		JSR	MPTDTST		; map point data set
		M8			; memory 8bit mode
		RTS
;
;
;************************************************
;*						*
;*	player Y point				*
;*						*
;************************************************
PLYDT		EQU	$
		LDA	#BANK MPTPLY
		STA	<WORK6
		M16			; memory 16bit mode
		LDA	#DTMDPY
		STA	<WORK2
		LDA	#MPTPLY
		STA	<WORK4
		LDA	!DTSBPOS
		EOR	#00001H
		AND	#00001H
		ASL	A
		TAY
		JSR	MPTDTST		; map point data set
		M8			; memory 8bit mode
		RTS
;
;
;************************************************
;*						*
;*	quest clear data NO. set		*
;*						*
;************************************************
QCLDT		EQU	$
		LDA	!QSTPOS
		INC	A
		STA	<WORKA
		LDA	<WORK0
		AND	#00FH
		CMP	<WORKA
		BEQ	QCL100
		BCS	QCL999
QCL100		EQU	$
		LDA	<WORK0
		STA	!DTMDCR
		AND	#003H
		STA	!QSTPOS
		LDX	!MENUNO
		STA	!QSTCNT,X
		JSR	GOALSB		; goal pointer set sub
		JSR	GOLINT		; goal pointer initial set
		LDA	#0F0H
		STA	!DTMDMV
		JSR	PMV000		; player move data NO. set
		MI16			; memory , index 16bit mode
		JSR	MNNOSB		; map point data index set
		TXY
		LDA	!QSTPOS
		AND	#000FFH
		ASL	A
		TAX
		TYA
		CLC
		ADC	QTPSADD,X
		TAX
		LDA	>MPTQNT,X
		STA	<WORK0
		PHA
		AND	#0000FH
		ORA	#000F0H
		STA	!DTMDNT+2
		PLA
		AND	#000F0H
		LSR	A
		LSR	A
		LSR	A
		LSR	A
		ORA	#000F0H
		STA	!DTMDNT
		MI8			; memory , index 8bit mode
		STZ	!NXTFLG
		LDA	<WORK0
		BPL	QCL150
		INC	!NXTFLG
QCL150		EQU	$
;
QCL999		EQU	$
		RTS
;
QTPSADD		EQU	$
		WORD	00000H,00041H,00082H,000C3H
;
;
;************************************************
;*						*
;*	next goto point NO. clear		*
;*			in			*
;*			wrk0 <- 2		*
;************************************************
NXTDT		EQU	$
		LDA	<WORK0
		CMP	#002H
		BNE	NXT999
		M16			; memory 16bit mode
		LDA	#000FFH
		STA	>DTMDNT+00
		STA	>DTMDNT+02
		I16			; index 16bit mode
		JSR	MNNOSB		; menu NO. -> map point data index
		LDA	!MENUNO
		AND	#000FFH
		TAY
		LDA	!QSTCNT,Y
		AND	#00003H
		ASL	A
		TAY
		PHX
		TXA
		CLC
		ADC	QTPSADD,Y
		TAX
		M8			; memory 8bit mode
		LDA	#0FFH
		STA	>MPTQNT,X
		LDY	#00010H
NXTDT_LOP	EQU	$
		LDA	#080H
		STA	>MPT11P,X
		LDA	#000H
		STA	>MPT11X,X
		STA	>MPT11Z,X
		STA	>MPT11Y,X
		INX
		INX
		INX
		INX
		DEY
		BNE	NXTDT_LOP
		PLX
		LDA	#000H
		STA	>MPTQT1,X
		I8			; index 8bit mode
		LDA	#001H
		STA	<DMDFLG
		STA	!NXTFLG
NXT999		EQU	$
		RTS
;
;
;************************************************
;*						*
;*	player move data NO. set		*
;*						*
;************************************************
PMVDT		EQU	$
		LDA	<WORK0
		STA	!DTMDMV
PMV000		EQU	$
		AND	#000FH
		ASL	A
		ASL	A
		STA	<WORK0
		STZ	<WORK1
		LDA	!DTMDCR
		AND	#00FH
		STA	<WORK8
		CLC
		ROR	A
		ROR	A
		ROR	A
		CLC
		ADC	<WORK8
		STA	<WORK2
		STZ	<WORK3
;
		MI16			; memory , index 16bit mode
		JSR	MNNOSB		; map point data index set
		TXA
		CLC
		ADC	<WORK0
		CLC
		ADC	<WORK2
		TAX
		LDY	#00000H
PMV100		EQU	$
		LDA	>MPT11P,X
		PHA
		AND	#0000FH
		ORA	#000F0H
		STA	!DTMDPL+2,Y
		PLA
		AND	#000F0H
		LSR	A
		LSR	A
		LSR	A
		LSR	A
		ORA	#000F0H
		STA	!DTMDPL,Y
		INX
		TYA
		CLC
		ADC	#00040H
		TAY
		CPY	#00100H
		BCC	PMV100
		MI8			; memory , index 8bit mode
		INC	<DMDFLG
;
PMV999		EQU	$
		RTS
;
;
;************************************************
;*						*
;*	player type set				*
;*						*
;************************************************
PTPDT		EQU	$
		LDA	#BANK MPT11P
		STA	<WORK6
		M16			; memory 16bit mode
		LDA	#DTMDPL
		STA	<WORK2
		LDA	#MPT11P
		STA	<WORK4
		LDA	!DTSBPOS
		EOR	#00001H
		AND	#00001H
		ASL	A
		TAY
		JSR	MPTDTST		; map point data set
		M8			; memory 8bit mode
		RTS
;
;
;************************************************
;*						*
;*	player X point				*
;*						*
;************************************************
PXPDT		EQU	$
;
		RTS
;
;
;************************************************
;*						*
;*	player Y point				*
;*						*
;************************************************
PYPDT		EQU	$
;
		RTS
;
;
;************************************************
;*						*
;*	player Z point				*
;*						*
;************************************************
PZPDT		EQU	$
;
		RTS
;
;
;++++++++++++++++++++++++++++++++++++++++
;+	map point data set		+
;++++++++++++++++++++++++++++++++++++++++
MPTDTST		EQU	$
		MI16			; memory , index 16bit mode
		TYA
		AND	#00002H
		TAY
		LDA	<WORK0
		STA	(<WORK2),Y
;
		AND	#0000FH
		TYX
		BNE	MDS100
		ASL	A
		ASL	A
		ASL	A
		ASL	A
MDS100		EQU	$
		STA	<WORKA
		JSR	MNNOSB		; menu NO. -> map point data index
		TXA
		CLC
		ADC	<WORK4
		STA	<WORK4
		M8			; memory 8bit mode
		LDA	[<WORK4]
		AND	TIMAND,Y
		ORA	<WORKA
		STA	[<WORK4]
;
		I8			; index 8bit mode
		INC	<DMDFLG
		LDA	!DTSBPOS
		AND	#001H
		BEQ	MDS999
		INC	!DTSBPOS
;
MDS999		EQU	$
		RTS
;
TIMAND		EQU	$
		HEX	00FH,000H,0F0H
;
;
;++++++++++++++++++++++++++++++++++++++++
;+					+
;+	menu NO. -> map point data index+
;+			out		+
;+			 X <- index	+
;++++++++++++++++++++++++++++++++++++++++
		MEM16
		IDX16
MNNOSB		EQU	$
		LDA	#00000H
		LDX	!MENUNO
		BEQ	MNSBED
MNSBLP		EQU	$
		CLC
		ADC	#0010EH
		DEX
		BNE	MNSBLP
MNSBED		EQU	$
		TAX
		RTS
		MEM8
		IDX8
;
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+						+
;+	f[^ [h		(J[\_)	+
;+						+
;++++++++++++++++++++++++++++++++++++++++++++++++
DMCSLST_ADR	EQU	$-2
		WORD	DTMDTP+1		;}bv ^Cv
		WORD	DTMDPT+1,DTMDPT+3,DTMDPT+5	;p[c |Cg
		WORD	DTMDTB+1,DTMDTB+3	;R[X mn.
		WORD	DTMDTM+1,DTMDTM+3	;^C}[mn.
		WORD	DTMDPX+1,DTMDPX+3	;vC[ wʒu
		WORD	DTMDPY+1,DTMDPY+3	;	"   xʒu
;
		WORD	DTMDCR+1		;ȂNAf[^
		WORD	DTMDNT+1,DTMDNT+3	;̃|Cgmn.
		WORD	DTMDMV+1		;ȂNAf[^mn.
		WORD	DTMDPL+1,DTMDPL+3	;vC[ ^Cv
		WORD	DTMDPLX+1,DTMDPLX+3	;wʒu
		WORD	DTMDPLZ+1,DTMDPLZ+3	;yʒu
		WORD	DTMDPLY+1,DTMDPLY+3	;xʒu
;
		IDX16
DMCSLST		EQU	$
		M16			; memory 16bit mode
		LDA	!DTSBPOS
		AND	#000FFH
		ASL	A
		TAX
		LDA	DMCSLST_ADR,X
		STA	<WORKE
		M8			; memory 8bit mode
;
		LDA	<WORK0
		STA	(<WORKE)
		INC	<DMDFLG
;
		RTS
		IDX8
;
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+						+
;+	data set sub read index			+
;+						+
;++++++++++++++++++++++++++++++++++++++++++++++++
DATSUB		EQU	$
		BYTE	000H,001H,001H,001H,001H,001H,001H,001H	;0
		BYTE	001H,000H,000H,000H,000H,000H,00DH,00DH
		BYTE	00DH,00DH,00DH,00DH,00DH,00DH,00DH,00DH
		BYTE	00DH,00DH,00DH,00DH,00DH,00DH,000H,000H
;
		BYTE	000H,000H,000H,000H,000H,000H,001H,001H	;1
		BYTE	001H,001H,001H,001H,000H,000H,000H,00DH
		BYTE	00DH,00DH,00DH,00DH,001H,000H,000H,000H
		BYTE	000H,000H,000H,000H,000H,000H,000H,000H
;
		BYTE	000H,003H,002H,002H,002H,002H,002H,002H	;2
		BYTE	002H,002H,002H,002H,000H,000H,00EH,00EH
		BYTE	00EH,00EH,00EH,00EH,00EH,00EH,00EH,000H
		BYTE	000H,000H,000H,000H,000H,000H,000H,000H
;
		BYTE	000H,000H,000H,000H,000H,000H,000H,002H	;3
		BYTE	003H,004H,000H,000H,000H,000H,000H,00EH
		BYTE	00EH,00EH,00EH,00EH,00EH,00EH,00EH,00EH
		BYTE	00EH,00EH,00FH,000H,000H,000H,000H,000H
;
		BYTE	000H,005H,005H,005H,005H,000H,000H,000H	;4
		BYTE	000H,000H,000H,000H,000H,000H,000H,000H
		BYTE	000H,000H,000H,000H,000H,000H,000H,000H
		BYTE	000H,000H,000H,000H,000H,000H,000H,000H
;
		BYTE	000H,000H,000H,005H,005H,005H,000H,000H	;5
		BYTE	005H,006H,000H,000H,000H,000H,010H,010H
		BYTE	010H,010H,010H,010H,010H,010H,010H,010H
		BYTE	010H,010H,010H,010H,010H,010H,000H,000H
;
		BYTE	000H,007H,007H,007H,007H,007H,000H,000H	;6
		BYTE	000H,000H,000H,000H,000H,000H,000H,010H
		BYTE	010H,010H,010H,010H,010H,010H,010H,000H
		BYTE	000H,000H,000H,000H,000H,000H,000H,000H
;
		BYTE	000H,000H,000H,007H,007H,007H,000H,000H	;7
		BYTE	007H,008H,000H,000H,000H,000H,011H,011H
		BYTE	011H,011H,011H,011H,000H,000H,000H,000H
		BYTE	000H,000H,000H,000H,000H,000H,000H,000H
;
		BYTE	000H,009H,009H,009H,009H,009H,009H,009H	;8
		BYTE	009H,009H,009H,009H,009H,000H,000H,011H
		BYTE	011H,011H,011H,000H,000H,000H,000H,011H
		BYTE	012H,000H,000H,000H,000H,000H,000H,000H
;
		BYTE	000H,000H,000H,000H,000H,000H,000H,000H	;9
		BYTE	009H,00AH,000H,000H,000H,000H,013H,013H
		BYTE	013H,013H,013H,013H,000H,000H,000H,013H
		BYTE	014H,000H,000H,000H,000H,000H,000H,000H
;
		BYTE	000H,000H,000H,000H,000H,000H,000H,000H	;A
		BYTE	00BH,00CH,000H,000H,000H,000H,015H,015H
		BYTE	015H,015H,015H,015H,000H,000H,000H,015H
		BYTE	016H,000H,000H,000H,000H,000H,000H,000H
;
		BYTE	000H,000H,000H,000H,000H,000H,000H,000H	;B
		BYTE	000H,000H,000H,000H,000H,000H,017H,017H
		BYTE	017H,017H,017H,017H,000H,000H,000H,017H
		BYTE	018H,000H,000H,000H,000H,000H,000H,000H
;
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+						+
;+	bit ha-n-te-n set address		+
;+						+
;++++++++++++++++++++++++++++++++++++++++++++++++
BTHTAD	EQU	$
	WORD	07861H,07881H,078A1H,078C1H,078E1H
	WORD	07901H,07921H,07941H,07961H,07981H
	WORD	079A1H,079C1H,079E1H,07A01H,07A21H
	WORD	07A41H,07A61H,07A81H,07AA1H,07AC1H
;
	WORD	07867H,07887H,078A7H,078C7H,078E7H
	WORD	07907H,07927H,07947H,07967H,07987H
	WORD	079A7H,079C7H,079E7H,07A07H,07A27H
	WORD	07A47H,07A67H,07A87H,07AA7H,07AC7H
;
	WORD	0786DH,0788DH,078ADH,078CDH,078EDH
	WORD	0790DH,0792DH,0794DH,0796DH,0798DH
	WORD	079ADH,079CDH,079EDH,07A0DH,07A2DH
	WORD	07A4DH,07A6DH,07A8DH,07AADH,07ACDH
;
	WORD	07873H,07893H,078B3H,078D3H,078F3H
	WORD	07913H,07933H,07953H,07973H,07993H
	WORD	079B3H,079D3H,079F3H,07A13H,07A33H
	WORD	07A53H,07A73H,07A93H,07AB3H,07AD3H
;
	WORD	0787AH,0789AH,078BAH,078DAH,078FAH
	WORD	0791AH,0793AH,0795AH,0797AH,0799AH
	WORD	079BAH,079DAH,079FAH,07A1AH,07A3AH
	WORD	07A5AH,07A7AH,07A9AH,07ABAH,07ADAH
;
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+						+
;+	mouse point read data			+
;+						+
;++++++++++++++++++++++++++++++++++++++++++++++++
MOUSPOS		EQU	$
;1
		BYTE	000,001,001,001,001,001,000,021
		BYTE	021,021,021,021,000,041,041,041
		BYTE	041,041,000,061,061,061,061,061
		BYTE	000,000,081,081,081,081,081,000
;2
		BYTE	000,002,002,002,002,002,000,022
		BYTE	022,022,022,022,000,042,042,042
		BYTE	042,042,000,062,062,062,062,062
		BYTE	000,000,082,082,082,082,082,000
;3
		BYTE	000,003,003,003,003,003,000,023
		BYTE	023,023,023,023,000,043,043,043
		BYTE	043,043,000,063,063,063,063,063
		BYTE	000,000,083,083,083,083,083,000
;4
		BYTE	000,004,004,004,004,004,000,024
		BYTE	024,024,024,024,000,044,044,044
		BYTE	044,044,000,064,064,064,064,064
		BYTE	000,000,084,084,084,084,084,000
;5
		BYTE	000,005,005,005,005,005,000,025
		BYTE	025,025,025,025,000,045,045,045
		BYTE	045,045,000,065,065,065,065,065
		BYTE	000,000,085,085,085,085,085,000
;6
		BYTE	000,006,006,006,006,006,000,026
		BYTE	026,026,026,026,000,046,046,046
		BYTE	046,046,000,066,066,066,066,066
		BYTE	000,000,086,086,086,086,086,000
;7
		BYTE	000,007,007,007,007,007,000,027
		BYTE	027,027,027,027,000,047,047,047
		BYTE	047,047,000,067,067,067,067,067
		BYTE	000,000,087,087,087,087,087,000
;8
		BYTE	000,008,008,008,008,008,000,028
		BYTE	028,028,028,028,000,048,048,048
		BYTE	048,048,000,068,068,068,068,068
		BYTE	000,000,088,088,088,088,088,000
;9
		BYTE	000,009,009,009,009,009,000,029
		BYTE	029,029,029,029,000,049,049,049
		BYTE	049,049,000,069,069,069,069,069
		BYTE	000,000,089,089,089,089,089,000
;10
		BYTE	000,010,010,010,010,010,000,030
		BYTE	030,030,030,030,000,050,050,050
		BYTE	050,050,000,070,070,070,070,070
		BYTE	000,000,090,090,090,090,090,000
;11
		BYTE	000,011,011,011,011,011,000,031
		BYTE	031,031,031,031,000,051,051,051
		BYTE	051,051,000,071,071,071,071,071
		BYTE	000,000,091,091,091,091,091,000
;12
		BYTE	000,012,012,012,012,012,000,032
		BYTE	032,032,032,032,000,052,052,052
		BYTE	052,052,000,072,072,072,072,072
		BYTE	000,000,092,092,092,092,092,000
;13
		BYTE	000,013,013,013,013,013,000,033
		BYTE	033,033,033,033,000,053,053,053
		BYTE	053,053,000,073,073,073,073,073
		BYTE	000,000,093,093,093,093,093,000
;14
		BYTE	000,014,014,014,014,014,000,034
		BYTE	034,034,034,034,000,054,054,054
		BYTE	054,054,000,074,074,074,074,074
		BYTE	000,000,094,094,094,094,094,000
;15
		BYTE	000,015,015,015,015,015,000,035
		BYTE	035,035,035,035,000,055,055,055
		BYTE	055,055,000,075,075,075,075,075
		BYTE	000,000,095,095,095,095,095,000
;16
		BYTE	000,016,016,016,016,016,000,036
		BYTE	036,036,036,036,000,056,056,056
		BYTE	056,056,000,076,076,076,076,076
		BYTE	000,000,096,096,096,096,096,000
;17
		BYTE	000,017,017,017,017,017,000,037
		BYTE	037,037,037,037,000,057,057,057
		BYTE	057,057,000,077,077,077,077,077
		BYTE	000,000,097,097,097,097,097,000
;18
		BYTE	000,018,018,018,018,018,000,038
		BYTE	038,038,038,038,000,058,058,058
		BYTE	058,058,000,078,078,078,078,078
		BYTE	000,000,098,098,098,098,098,000
;19
		BYTE	000,019,019,019,019,019,000,039
		BYTE	039,039,039,039,000,059,059,059
		BYTE	059,059,000,079,079,079,079,079
		BYTE	000,000,099,099,099,099,099,000
;20
		BYTE	000,020,020,020,020,020,000,040
		BYTE	040,040,040,040,000,060,060,060
		BYTE	060,060,000,080,080,080,080,080
		BYTE	000,000,064H,064H,064H,064H,064H,000
;
;
;
;
;
;
		END
