;************************************************************************
;*									*
;*	title name	: "yossy map tool"				*
;*	proccess	: RAM program					*
;*	file name	: ysm_rpro					*
;*									*
;************************************************************************
;
;
		SALL
;
		include		ysm_header.inc
;
		XALL
;
;
;------------------------------------------------------------------------
;-		global symbol						-
;------------------------------------------------------------------------
		GLB	RPRO_ROM
		GLB	IRQSUB,NMISUB,CHIPON
		GLB	VMADSPL,NEWVMADL
		GLB	KYREAD
;
;;;;K;;;;		GLB	CSNMITL
;
		GLB	VTCL
;
;------------------------------------------------------------------------
;-		extern symbol						-
;------------------------------------------------------------------------
;
;-------------< ysm_main >-----------------------------------------------
		EXT	VCLDAT
		EXT	JSRSUB,JSLSUB
;
;
;------------------------------------------------------------------------
;-		define symbol						-
;------------------------------------------------------------------------
;;;;		EQU
;
;
;************************************************************************
;*									*
;*		program start						*
;*									*
;************************************************************************
;
;
		ORG	0C000H
;
;
		EXTEND
;
;
		MEM8
		IDX8
;
;************************************************************************
;*		RAM program						*
;************************************************************************
RPRO_ROM	EQU	$
;
;
;************************************************************************
;*		NMI							*
;************************************************************************
;
NMISUB		EQU	$&(00FFFFH)|(7E0000H)
		SEI
;
		MEM16
		IDX16
		REP	#00111000B
;
		PHA
		PHX
		PHY
		PHD
		PHB
		LDA	#00000H
		TCD
;
		I8
;
		PHA			;(DBR) <-- 00H
		PLB
		PLB
;
		LDY	4210H
;
		LDY	#10000000B	;blanking "ON"
		STY	2100H
		STZ	420CH		;H-DMA "OFF"
;
		LDX	NMITYP
		LDA	>NMISEL,X
		STA	NMIJMP
;
		M8
;
		PER	2		;[ JSR (NMISEL,X) ]
		JMP	(NMIJMP)	;	  "
;
		LDA	FADNO		;blanking "OFF"
		STA	2100H
		LDA	HD420C		;H-DMA set
		STA	420CH
;
		MI16
;
		PLB
		PLD
		PLY
		PLX
		PLA
;
		RTI
;
		MEM8
		IDX8
;
;-------------- NMI program address table -----------------------
NMISEL		EQU	$&(00FFFFH)|(7E0000H)	;[NMITYP]
		WORD	NMI000			;[0]  normal
		WORD	NMI300			;[2]  map
		WORD	NMI400			;[4]  map data edit
;
;
;************************************************************************
;*		NMI ( normal )						*
;************************************************************************
;
NMI000		EQU	$
		LDA	NMIFLG
		BNE	NMI0010		;timer over ? ( no:NMI0010 )
		JMP	NMI0020
;
NMI0010		EQU	$
		STZ	NMIFLG		;NMI flag "ON"
;
;-------------- DMA set -----------------------------------------
		JSR	COLDMA		;color DMA set
		JSR	NEWVMAD		;BG write
		JSR	VMADSP		;BG WRITE
		JSR	OBJDMA		;OBJ DMA set
;
;-------------- joy-controller read -----------------------------
		JSR	CONT22		;controller read
;
;-------------- PPU Reg. set ------------------------------------
;
;-------------- scroll counter set ------------------------------
		LDA	<SCCH1		;work BG1 scroll counter set
		STA	210DH
		LDA	<SCCH1+1
		STA	210DH
		LDA	<SCCV1
		STA	210EH
		LDA	<SCCV1+1
		STA	210EH
		LDA	<SCCH2		;BG2 scroll counter set
		STA	210FH
		LDA	<SCCH2+1
		STA	210FH
		LDA	<SCCV2
		STA	2110H
		LDA	<SCCV2+1
		STA	2110H
		LDA	<SCCH3		;BG3 scroll counter set
		STA	2111H
		LDA	<SCCH3+1
		STA	2111H
		LDA	<SCCV3
		STA	2112H
		LDA	<SCCV3+1
		STA	2112H
;
;-------------- data mode data set ------------------------------
		LDA	<DMDFLG
		BEQ	NMI0020
		M16			; memory 16bit mode
		LDY	#10000000B
		STY	2115H		; inc mode set
		LDA	#07C40H
		STA	2116H		; VRAM address set
		LDA	#00000001B+(18H*100H)
		STA	4300H		; DMA parameter & B bus address set
		LDA	#DTMDDT
		STA	4302H		; A bus address(L,H) set
		LDY	#BANK DTMDDT
		STY	4304H		;	 "     (B) set
		LDA	#00400H
		STA	4305H		; number of byte set
		LDY	#00000001B
		STY	420BH		; DMA "ON"
		M8			; memory 8bit mode
		STZ	<DMDFLG
;
NMI0020		EQU	$
		RTS
;
;************************************************************************
;*		NMI ( map )						*
;************************************************************************
MPDMAVAD	EQU	($-1*4)&(00FFFFH)|(7E0000H)
; MPBANK -->		 [0]   [1]			;[MPDMAFG]
		WORD	4000H,6000H			;[1]
		WORD	4700H,6700H			;[2]
		WORD	5180H,7180H			;[3]
MPDMABAD	EQU	($-1*4)&(00FFFFH)|(7E0000H)
		WORD	MPDMABF,MPDMABF			;[1]
		WORD	MPDMABF+0E00H,MPDMABF+0E00H	;[2]
		WORD	MPDMABF+2300H,MPDMABF+2300H	;[3]
MPDMABYT	EQU	($-1*4)&(00FFFFH)|(7E0000H)
		WORD	0E00H,0E00H			;[1]
		WORD	1500H,1500H			;[2]
		WORD	1500H,1500H			;[3]
MPOBJBNK	EQU	$&(00FFFFH)|(7E0000H)
		BYTE	01100011B,01100010B
;
NMI300		EQU	$
		INC	NMICONT
;
		MI8			; memory , index 8bit mode
;
;-------------- bitmap chara DMA --------------------------------
		LDA	MPDMAFG
		BEQ	NMI0320		;bitmap chara DMA ? ( no:NMI0320 )
;
		ASL	A
		ORA	MPBANK
		ASL	A
		TAX
;
		M16
;
		LDY	#10000000B		;inc mode set
		STY	2115H
		LDA	>MPDMAVAD,X		;VRAM address set
		STA	2116H
		LDA	#00000001B+(18H*100H)	;DMA parameter & B bus address set
		STA	4300H
		LDA	>MPDMABAD,X		;A bus address(L,H) set
		STA	4302H
		LDA	>MPDMABYT,X		;number of byte ser
		STA	4305H
		LDX	#BANK MPDMABF		;	"     (B) set
		STX	4304H
		LDY	#00000001B		;DMA "ON" !!
		STY	420BH
;
		M8
;
		DEC	MPDMAFG
		BNE	NMI0330		;bitmap chara DMA end ? ( no:NMI0330 )
;
;-------------- normal NMI ----------------------------------------------
NMI0320		EQU	$
		LDA	NMIFLG
		BNE	NMI0340		;time over ? ( no:NMI0340 )
;
NMI0330		EQU	$
		JMP	NMI0360
;
NMI0340		EQU	$
		STZ	NMIFLG		;NMI flag "ON"
;
		LDA	NMICONT
		STZ	NMICONT
;
		LDA	MPWDMAFG
		STZ	MPWDMAFG
		STA	MPDMAFG		;bitmap chara DMA flag "ON" !!
;
;-------------- normal DMA set ----------------------------------
		JSR	COLDMA		;color DMA set
		JSR	OBJDMA		;OBJ DMA set
;
;-------------- PPU Reg. set ------------------------------------
		LDY	MPBANK		;OBJ chara bank set
		LDA	!MPOBJBNK,Y
		STA	2101H
		LDA	SUBADF		;sub & add flag set
		STA	2131H
;
;-------------- mode 7 screen write -----------------------------
;
		M16
;
		LDA	MPM7SCRF
		BEQ	NMI0348		;mode 7 sceen write ? ( no:NMI0348 )
;
		LDY	#00000000B
		STY	2115H		;inc mode sey
		LDA	#00000000B+(18H*100H)
		STA	4300H		;DMA parameter & B bus address set
		LDY	#BANK 1A0000H
		STY	4304H		;A bus address(B) set
		LDA	#(100H/8)*(20H*4)
		STA	<WORK		;(WK0,1) <-- start VRAM address
		LDY	#32		;(Y) <-- number of byte
		LDX	#00000001B	;(X) <-- DMA "ON" data
		LDA	#32
		STA	<WORK+2		;(WK2,3) <-- V loop no
NMI0342		EQU	$
		LDA	<WORK
		STA	2116H		;VRAM address set
		CLC
		ADC	#20H*4
		STA	<WORK
		LDA	MPM7SCRF
		STA	4302H		;A bus address(L,H) set
		CLC
		ADC	#32
		STA	MPM7SCRF
		STY	4305H		;number of byte set
		STX	420BH
		DEC	<WORK+2
		BNE	NMI0342
;
		STZ	MPM7SCRF	;mode 7 sceen write cancel !!
;
;-------------- mode 7 parameter H-DMA buffer transfer ----------
NMI0348		EQU	$
		LDA	#MPHDMABF0		;to address set
		STA	2181H
		LDY	#BANK MPHDMABF0
		STY	2183H
		LDA	#00000000B+(80H*100H)
		STA	4300H		;DMA parameter & B bus address set
		LDA	#MPHDMAB0
		STA	4302H		;from address(L,H) set
		LDY	#BANK MPHDMAB0
		STY	4304H		;      "     (B) set
		LDA	#(70H*2)*4
		STA	4305H		;number of byte set
		LDX	#00000001B
		STX	420BH		;DMA "ON"
;
		M8
;
;-------------- joy-controller read -----------------------------
		JSR	CONT22		;controller read
;
;-------------- scroll counter set ------------------------------
NMI0350		EQU	$
		LDA	<SCCH1		;mode 7 scroll counter set
		STA	210DH
		LDA	<SCCH1+1
		STA	210DH
		LDA	<SCCV1
		STA	210EH
		LDA	<SCCV1+1
		STA	210EH
		LDA	CENTX		;center pos set
		STA	211FH
		LDA	CENTX+1
		STA	211FH
		LDA	CENTY
		STA	2120H
		LDA	CENTY+1
		STA	2120H
;
		LDA	<SCCH2		;mode 0 BG2 scroll counter set
		STA	210FH
		LDA	<SCCH2+1
		STA	210FH
		LDA	<SCCV2
		STA	2110H
		LDA	<SCCV2+1
		STA	2110H
;
;-------------- 1st rotation scroll counter set -----------------
;
		M16
;
		LDA	<SCCH3
		CLC
		ADC	MPBG3AD
		STA	<SCCH3
		LDA	<SCCH4
		CLC
		ADC	MPBG4AD
		STA	<SCCH4
;
;-------------- 1st rotation move data set ----------------------
		LDA	MPWBG3AD
		STA	MPBG3AD
		LDA	MPWBG4AD
		STA	MPBG4AD
;
		M8
;
NMI0360		EQU	$
;
;-------------- BG3,4 scroll counter set ------------------------
;
		M16
;
		LDA	<SCCH4		;mode 0 BG4 scroll counter set
		CLC
		ADC	MPBG4SP
		STA	<SCCH4
		LSR	A
		STA	MPSCH47		;1/2
		LSR	A
		LSR	A
		LSR	A
		STA	MPSCH40
		ADC	MPSCH47
		STA	MPSCH46		;9/16 <-- 1/2 + 1/16
		ADC	MPSCH40
		STA	MPSCH45		;10/16 <-- 9/16 + 1/16
		ADC	MPSCH40
		STA	MPSCH44		;11/16 <-- 10/16 + 1/16
		ADC	MPSCH40
		STA	MPSCH43		;12/16 <-- 11/16 + 1/16
		ADC	MPSCH40
		STA	MPSCH42		;13/16 <-- 12/16 + 1/16
		ADC	MPSCH40
		STA	MPSCH41		;14/16 <-- 13/16 + 1/16
		ADC	MPSCH40
		STA	MPSCH40		;15/16 <-- 14/16 + 1/16
;
		LDA	<SCCH3		;mode 0 BG3 scroll counter set
		CLC
		ADC	MPBG3SP
		STA	<SCCH3
;
		M8
;
		STA	2111H
		XBA
		STA	2111H
		LDA	<SCCV3
		STA	2112H
		LDA	<SCCV3+1
		STA	2112H
;
		LDA	<SCCV4
		STA	2114H
		LDA	<SCCV4+1
		STA	2114H
;
;-------------- V-blank process end -----------------------------
		LDA	FADNO		;blanking "OFF"
		STA	2100H
		LDA	HD420C		;H-DMA set
		STA	420CH
;
;-------------- constant color fade check -----------------------
;;;;K;;;;;
;;;;K;;;;;-------------- course name set ---------------------------------
;;;;K;;;;		JSR	CSNMST
;
		MI16
;
		PLA			;[ pull pull return !! ]
;
		PLB
		PLD
		PLY
		PLX
		PLA
;
		RTI
;
		MEM8
		IDX8
;
;************************************************************************
;*		NMI ( map data edit )					*
;************************************************************************
EDDMAVAD	EQU	($-1*4)&(00FFFFH)|(7E0000H)
; MPBANK -->		 [0]   [1]			;[MPDMAFG]
		WORD	4000H,6000H			;[1]
		WORD	4660H,6660H			;[2]
		WORD	50E0H,70E0H			;[3]
EDDMABAD	EQU	($-1*4)&(00FFFFH)|(7E0000H)
		WORD	MPDMABF,MPDMABF			;[1]
		WORD	MPDMABF+0CC0H,MPDMABF+0CC0H	;[2]
		WORD	MPDMABF+21C0H,MPDMABF+21C0H	;[3]
EDDMABYT	EQU	($-1*4)&(00FFFFH)|(7E0000H)
		WORD	0CC0H,0CC0H			;[1]
		WORD	1500H,1500H			;[2]
		WORD	1500H,1500H			;[3]
EDOBJBNK	EQU	$&(00FFFFH)|(7E0000H)
		BYTE	01100011B,01100010B
;
EDDMAAD0	EQU	$
		WORD	6000H+(184H*20H/2),4000H+(184H*20H/2)
EDDMANO0	EQU	$
		WORD	10*20H,10*20H
EDDMAAD1	EQU	$
		WORD	6000H+(194H*20H/2),4000H+(194H*20H/2)
EDDMANO1	EQU	$
		WORD	10*20H,10*20H
EDDMAAD2	EQU	$
		WORD	6000H+(1A9H*20H/2),4000H+(1A9H*20H/2)
EDDMANO2	EQU	$
		WORD	5*20H,5*20H
;
NMI400		EQU	$
		INC	NMICONT
;
;-------------- bitmap chara DMA --------------------------------
		LDA	MPDMAFG
		BEQ	NMI0420		;bitmap chara DMA ? ( no:NMI0420 )
;
		ASL	A
		ORA	MPBANK
		ASL	A
		TAX
;
		M16
;
		LDY	#10000000B		;inc mode set
		STY	2115H
		LDA	>EDDMAVAD,X		;VRAM address set
		STA	2116H
		LDA	#00000001B+(18H*100H)	;DMA parameter & B bus address set
		STA	4300H
		LDA	>EDDMABAD,X		;A bus address(L,H) set
		STA	4302H
		LDA	>EDDMABYT,X		;number of byte ser
		STA	4305H
		LDX	#BANK MPDMABF		;	"     (B) set
		STX	4304H
		LDY	#00000001B		;DMA "ON" !!
		STY	420BH
;
		M8
;
		DEC	MPDMAFG
		RTS
;
;-------------- normal NMI ----------------------------------------------
NMI0420		EQU	$
		LDA	NMIFLG
		BNE	NMI0430		;time over ? ( no:NMI0430 )
		JMP	NMI0440
;
NMI0430		EQU	$
		STZ	NMIFLG		;NMI flag "ON"
;
		LDA	NMICONT
		STZ	NMICONT
;
;-------------- normal DMA set ----------------------------------
		JSR	COLDMA		;color DMA set
		JSR	OBJDMA		;OBJ DMA set
;
;-------------- DMA ---------------------------------------------
		LDA	<EDTBFFG
		BEQ	NMI0435
;
		M16				; memory 16bit mode
		LDY	#10000000B		;inc mode set
		STY	2115H
		LDA	#07EC0H			; address set
		STA	2116H
		LDA	#00000001B+(18H*100H)	; DMA parameter & B bus address set
		STA	4300H
		LDA	#EDITBF			; A bus address(L,H) set
		STA	4302H
		LDY	#BANK EDITBF		;	 "     (B) set
		STY	4304H
		LDA	#00140H			; number of byte ser
		STA	4305H
		LDY	#00000001B		; DMA "ON" !!
		STY	420BH
;
		LDA	#07EA4H
		STA	2116H		; address set
		LDA	#00000001B+(18H*100H)
		STA	4300H		; DMA parameter & B bus address set
		LDA	#EDNMBF
		STA	4302H		; A bus address(L,H) set
		LDX	#BANK EDNMBF
		STX	4304H		;	 "     (B) set
		LDA	#00032H
		STA	4305H		; number of byte set
		STY	420BH		; DMA "ON" !!
		M8			; memory 8bit mode
;
		STZ	<EDTBFFG
;
;-------------- 1 parts chara DMA -------------------------------
NMI0435		EQU	$
		LDA	EDDMAFG
		BEQ	NMI0436		;DMA timming ? ( no:NMI0436 )
;
		LDA	MPBANK
		ASL	A
		TAY			;(Y) <-- OBJ chara bank
;
		M16
;
		LDX	#10000000B		;inc mode set
		STX	2115H
		LDA	#00000001B+(18H*100H)	;DMA parameter & B bus address
		STA	4300H
		LDA	#MPCNVBF		;A bus address(L,H) set
		STA	4302H
		LDX	#BANK MPCNVBF		;	"     (B) set
		STX	4304H
;
		LDA	!EDDMAAD0,Y	;VRAM address set
		STA	2116H
		LDA	!EDDMANO0,Y	;number of byte set
		STA	4305H
		LDX	#00000001B
		STX	420BH		;DMA "ON"
;
		LDA	!EDDMAAD1,Y	;VRAM address set
		STA	2116H
		LDA	!EDDMANO1,Y	;number of byte set
		STA	4305H
		STX	420BH		;DMA "ON"
;
		LDA	!EDDMAAD2,Y	;VRAM address set
		STA	2116H
		LDA	!EDDMANO2,Y	;number of byte set
		STA	4305H
		STX	420BH		;DMA "ON"
;
		M8
;
		STZ	EDDMAFG		;DMA flag cancel !!
;
;-------------- PPU Reg. set ------------------------------------
NMI0436		EQU	$
		LDY	MPBANK		;OBJ chara bank set
		LDA	!EDOBJBNK,Y
		STA	2101H
		LDA	SUBADF		;sub & add flag set
		STA	2131H
;
;-------------- joy-controller read -----------------------------
		JSR	CONT22		;controller read
;
;-------------- scroll counter set ------------------------------
		LDA	<SCCH1		;mode 7 scroll counter set
		STA	210DH
		LDA	<SCCH1+1
		STA	210DH
		LDA	<SCCV1
		STA	210EH
		LDA	<SCCV1+1
		STA	210EH
		LDA	<SCCH2
		STA	210FH
		LDA	<SCCH2+1
		STA	210FH
		LDA	<SCCV2
		STA	2110H
		LDA	<SCCV2+1
		STA	2110H
;
;-------------- mode 7 parameter set ----------------------------
		LDA	MATA		;matrix set
		STA	211BH
		LDA	MATA+1
		STA	211BH
		LDA	MATB
		STA	211CH
		LDA	MATB+1
		STA	211CH
		LDA	MATC
		STA	211DH
		LDA	MATC+1
		STA	211DH
		LDA	MATD
		STA	211EH
		LDA	MATD+1
		STA	211EH
		LDA	CENTX		;center pos set
		STA	211FH
		LDA	CENTX+1
		STA	211FH
		LDA	CENTY
		STA	2120H
		LDA	CENTY+1
		STA	2120H
;
NMI0440		EQU	$
		RTS
;
;************************************************************************
;*		IRQ							*
;************************************************************************
IRQSUB		EQU	$&(00FFFFH)|(7E0000H)
		SEI
;
		MEM16
		IDX16
		REP	#00111000B
;
		PHA
		PHX
		PHY
		PHD
		PHB
;
		LDA	#0000H
		TCD
;
		MI8
;
		PHA			;(DBR) <-- 00H
		PLB
;
		LDA	4211H
;
		M16
;
		LDX	IRQTYP
		LDA	>IRQSEL,X
		STA	IRQJMP
;
		M8
;
		PER	2		;[ JSR (IRQSEL,X) ]
		JMP	(IRQJMP)	;
;
RTISET		EQU	$
;
		MI16
;
		PLB
		PLD
		PLY
		PLX
		PLA
;
		CLI
		RTI
;
		MEM8
		IDX8
;
;-------------- IRQ program address table -----------------------
IRQSEL		EQU	$&(00FFFFH)|(7E0000H)	;[IRQTYP]
		WORD	IRQ000			;[0] dummy
;
;
;************************************************************************
;*		IRQ							*
;************************************************************************
;
IRQ000		EQU	$
		RTS
;
;
;
;
;************************************************************************
;*		chip start						*
;************************************************************************
;
		MEM16
;
CHIPON		EQU	$&(00FFFFH)|(7E0000H)
		LDY	CIPSCB
		STY	3038H
		LDY	CIPSCR
		STY	303AH
		STX	3034H
		STA	R15
;
		LDA	#00100000B
CHIPON10	EQU	$
		BIT	3030H
		BNE	CHIPON10	;chip move ? ( yes:CHIPON10 )
;
		STZ	303AH		;SFC ROM use enable
		RTL
;
		MEM8
;
;************************************************************************
;*		color DMA						*
;************************************************************************
;
COLDMA		EQU	$
		STZ	2121H			;C.G RAM address set
;
		M16
;
		LDA	#00000000B+(22H*100H)	;DMA parameter & B bus address set
		STA	4300H
		LDA	#DATACOL		;A bus address(L,H) set
		STA	4302H
		LDY	#BANK DATACOL		;	"     (B) set
		STY	4304H
		LDA	#0200H			;number of byte
		STA	4305H
		LDX	#00000001B		;DMA "ON"
		STX	420BH
;
		M8
;
;----------------------------------------------------------------
;-		constant color set				-
;----------------------------------------------------------------
		LDA	NUKCOL		;[ red ]
		AND	#00011111B
		ORA	#00100000B
		STA	2132H
;
		M16
;
		LDA	NUKCOL		;[ green ]
		LSR	A
		LSR	A
;
		M8
;
		LSR	A
		LSR	A
		LSR	A
		AND	#00011111B
		ORA	#01000000B
		STA	2132H
;
		LDA	NUKCOL+1	;[ blue ]
		LSR	A
		LSR	A
		ORA	#10000000B
		STA	2132H
		RTS
;
;************************************************************************
;*		OBJ DMA							*
;************************************************************************
;
OBJDMA		EQU	$
		STZ	4300H		;DMA control parameter
;
		M16
;
		STZ	2102H		;OAM address set ( 00~ )
;
		LDA	#04+((OAM&0000FFH)*100H)			;DMA B bus address & A bus address(L)
		STA	4301H
		LDA	#((OAM&00FF00H)/100H)+((OAM&0FF0000H)/100H)	;DMA A bus address(H,B)
		STA	4303H
		LDA	#0220H		;DMA number of byte
		STA	4305H
		LDY	#00000001B	;DMA ch "ON"
		STY	420BH
;
		M8
;
		RTS
;
;************************************************************************
;*		JSL type VRAM write sub ( VRAMD )			*
;************************************************************************
VMADSPL		EQU	$
		PHB			;(DBR) save
		PHK			;(DBR) <-- (PBR)
		PLB
;
		JSR	VMADSP
;
		PLB
		RTL
;
;************************************************************************
;*		VRAM write sub ( VRAMD )				*
;************************************************************************
VTABLE		EQU	$
VTB00		LWORD	VRAMD+2
VTB01		LWORD	VCLDAT
;
VTCL		EQU	VTB01-VTABLE
;
VMADSP		EQU	$
;
		I16
;
		LDY	VRFLG
		LDX	VTABLE,Y	;BG data address(L) set
		LDA	VTABLE+2,Y	;	"       (B) set
		JSR	VRAMTR		;VRAM write
;
		IDX8
;
		LDA	VRFLG
		BNE	VMD010		;VRAMD write ? ( no:VMD010 )
;
		STA	>VRAMD
		STA	>VRAMD+1
		DEC	A		;[ LDA	#0FFFFH ]
		STA	>VRAMD+3
VMD010		EQU	$
		STZ	VRFLG
		RTS
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		JSR	NEWVMAD ( new VMADSP sub )			x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
VRFLDAT		EQU	$
VRTB00		LWORD	VRAMDX
;
NEWVMADL	EQU	$
		PHB			;(DBR) save
		PHK
		PLB
;
		JSR	NEWVMAD
;
		PLB
		RTL
;
NEWVMAD		EQU	$
		I16
;
		LDY	VRFLG2
		LDX	!VRFLDAT,Y	;BG data address(L) set
		LDA	!VRFLDAT+2,Y	;	"       (B) set
		PHB
		PHA
		PLB
		STA	<WORK0
;
		M16
;
		LDA	0,X
		STA	<WORK4		; end address set
		CMP	#VRAMDX+2
		BEQ	NVD150
		INX
		INX
;
NVD100		EQU	$
		LDA	0,X
		STA	>2116H
;
		LDA	4,X
		STA	>4301H
;
		LDA	6,X
		STA	>4303H
;
		LDA	8,X
		STA	>4305H
;
		LDA	2,X
;
		M8
;
		STA	>2115H
		XBA
		STA	>4300H
;
		LDA	#00000001B
		STA	>420BH
;
		M16
;
		LDA	10,X
		TAX
		CMP	<WORK4
		BNE	NVD100		; end ?
;					; Yes!
		LDA	>VRFLG2
		BNE	NVD150
;
		LDA	#VRAMDX+2
		STA	VRAMDX		; end code set
;
NVD150		EQU	$
		PLB
		STZ	VRFLG2
;
		MI8
;
		RTS
;
;****************************************************************
;*		VRAM transfer sub				*
;*			in  : (X) <-- data address(L,H)		*
;*			      (A) <--	    "     (B)           *
;****************************************************************
;
		IDX16
;
VRAMTR		EQU	$
		PHB			;(DBR) save
		PHA			;(DBR) <-- data bank
		PLB
		STA	<WORK		;(WK0) <-- data address(B)
;
		M16
;
VTR010		EQU	$
		LDY	0000,X
		BPL	VTR020		;end ? ( no:VTR020 )
;
;-------------- end return ------------------------------
		SEP	#00110000B	;memory,index 8 bit mode set
		PLB
		RTS
;
VTR020		EQU	$
		LDA	0002,X		;number 0f byte set
		AND	#01FFFH
		INC	A
		STA	<WORK+1		;(WK1,2) <-- number of byte
		STA	<WORK+3		;(WK3,4) <-- data index up add data
;
		LDA	#10000000B
		BIT	0002,X
		BPL	VTR030		;tate ? ( no:VTR030 )
;-------------- tate write set --------------------------
		LDA	#10000001B
VTR030		EQU	$
		STA	>2115H		;inc mode set
		STA	<WORK+5		;(WK5,6) <-- inc mode
		TYA
		STA	>2116H		;VRAM address set
;
		LDA	0002,X
		AND	#0010000000000000B
		BEQ	VTR040		;VRAM read ? ( no:VTR040 )
;-------------- VRAM read -------------------------------
		LDA	#0003H		;(WK3,4) <-- data index up add data
		STA	<WORK+3
		LDA	0004,X		;A bus address(L,H) set
		STA	>4302H
		LDA	0005,X		;      "      (B) set
		STA	>4303H
		LDA	>2139H		;read intial
		LDA	#10000001B+(39H*100H)
		BRA	VTR060
;
VTR040		EQU	$
		LDA	<WORK		;A bus address(B) set
		STA	>4304H
		LDY	#00000001B+(18H*100H)
		BVC	VTR050		;= data set ? ( no:VTR050 )
;-------------- = data set ------------------------------
		LSR	<WORK+1		;(number of byte)/2
		LDA	#0002H		;(WK3,4) <-- data index up add data
		STA	<WORK+3
		LDA	#00001000B+(19H*100H)	;control parameter & B bus address set
		STA	>4300H
		TXA				;A bus address(L,H) set
		CLC
		ADC	#0005H
		STA	>4302H
		LDA	<WORK+1		;number of byte set
		STA	>4305H
		LDA	#00000001B*100H ;DMA start
		STA	>420AH		;[ 420AH dummy ]
		LDA	<WORK+5
		AND	#01111111B
		STA	>2115H		;inc mode set
		LDA	0000,X
		STA	>2116H		;VRAM address set
		LDY	#00001000B+(18H*100H)
VTR050		EQU	$
		TXA				;A bus address(L,H) set
		CLC
		ADC	#0004H
		STA	>4302H
		TYA
VTR060		EQU	$
		STA	>4300H		;control parameter & B bus address set
		LDA	<WORK+1		;number of byte set
		STA	>4305H
		LDA	#00000001B*100H ;DMA start
		STA	>420AH		;[ 420AH dummy ]
		TXA
		CLC
		ADC	#0004H		;[ not (C)=1 !! if (C)=1 then error data !! ]
		ADC	<WORK+3
		TAX
		JMP	VTR010
;
		MEM8
		IDX8
;
;************************************************************************
;		joy-controller read					*
;************************************************************************
;
CONT2		EQU	$
		LDA	4212H
		LSR	A
		BCS	CONT2			;read ok ? ( no:CONT2 )
;
		MI16
;
		LDA	4218H			;1p controller
		AND	#1111111111110000B
		STA	KEYA1L
		TAY
		EOR	KEYABFL
		AND	KEYA1L
		STA	KEYA2L
		STY	KEYABFL
;
		LDA	421AH			;2p controller
		AND	#1111111111110000B
		STA	KEYB1L
		TAY
		EOR	KEYBBFL
		AND	KEYB1L
		STA	KEYB2L
		STY	KEYBBFL
;
		LDA	KEYA1L			;move controller set
		STA	<KEYC1L
		LDA	KEYA2L
		STA	<KEYC2L
;
		MI8
;
		RTS
;
;************************************************************************
;*		Key Read  &  Mouse Read			(CONT2)		*
;************************************************************************
CONT22		EQU	$
		LDA	04212H
		LSR	A
		BCS	CONT22		; key read ok ?
;					; yes
		MEM16
		IDX16
		REP	#00110000B	; memory,index 16bit mode
;
		LDA	04218H		; 1P CONTROLLER
		TAY
		AND	#0000FH
		CMP	#00001H
		BNE	MOUSE100	; mouse on ?
;					; yes
		MEM8
		IDX8
		SEP	#00110000B	; memory,index 8bit mode
;
		STY	<MOUSEAS
		TYA
		EOR	<MOUSEAB
		AND	<MOUSEAS
		STA	<MOUSEAT
		STY	<MOUSEAB	; key set
;
		LDY	#00FH		; X Y SET
MOUSE20		EQU	$
		LDA	04016H
		LSR	A
		ROL	<MOUSEAX
		ROL	<MOUSEAY
		DEY
		BPL	MOUSE20		; mouse data read end ?
;					; yes
		LDA	<MOUSEAX
		BPL	MOUSE40		; X(-) move ?
;					; yes
		EOR	#0FFH
		INC	A
		EOR	#080H
		STA	<MOUSEAX
MOUSE40		EQU	$
		LDA	<MOUSEAY
		BPL	MOUSE70		; Y(-) move ?
;					; yes
		EOR	#0FFH
		INC	A
		EOR	#080H
		STA	<MOUSEAY
MOUSE70		EQU	$
		LDA	<MOUSEAS
		LSR	A
		LSR	A
		LSR	A
		LSR	A
		AND	#003H
		CMP	<MOUSESPA
		BEQ	MOUSE80		; speed change ?
;					; yes
		LDY	#000H
		JSR	MOUSE_SP
MOUSE80		EQU	$
		MEM16
		IDX16
		REP	#00110000B	; memory,index 16bit mode
;
		STZ	KEYA1L
		STZ	KEYA2L
		STZ	KEYABFL
		BRA	MOUSE200
;
MOUSE100	EQU	$
		STY	KEYA1L
		TYA
		EOR	KEYABFL
		AND	KEYA1L
		STA	KEYA2L
		STY	KEYABFL		; joy-controller set
		STZ	<MOUSEAS	; MOUSE CLR
		STZ	<MOUSEAX	; MOUSE CLR
		STZ	<MOUSEAT	; MOUSE CLR
;
;
MOUSE200	EQU	$
		LDA	0421AH		; 2P CONTROLLER
		TAY
		AND	#0000FH
		CMP	#00001H
		BNE	MOUSE300	; mouse on ?
;					; yes
		MEM8
		IDX8
		SEP	#00110000B	; memory,index 8bit mode
;
		STY	<MOUSEBS	;KEY SET
		TYA
		EOR	<MOUSEBB
		AND	<MOUSEBS
		STA	<MOUSEBT
		STY	<MOUSEBB
;
		LDY	#00FH		;X Y SET
MOUSE220	EQU	$
		LDA	04017H
		LSR	A
		ROL	<MOUSEBX
		ROL	<MOUSEBY
		DEY
		BPL	MOUSE220	; mouse data read end ?
;					; yes
		LDA	<MOUSEBX
		BPL	MOUSE240	; X(-) ?
;					; yes
		EOR	#0FFH
		INC	A
		EOR	#080H
		STA	<MOUSEBX
MOUSE240	EQU	$
		LDA	<MOUSEBY
		BPL	MOUSE260	; Y(-) ?
;					; yes
		EOR	#0FFH
		INC	A
		EOR	#080H
		STA	<MOUSEBY
MOUSE260	EQU	$
		LDA	<MOUSEBS
		LSR	A
		LSR	A
		LSR	A
		LSR	A
		AND	#003H
		CMP	<MOUSESPB
		BEQ	MOUSE280	; speed change ?
;					; yes
		LDY	#001H
		JSR	MOUSE_SP
MOUSE280	EQU	$
		MEM16
		IDX16
		REP	#00110000B
;
		STZ	KEYB1L
		STZ	KEYB2L
		STZ	KEYBBFL		; joy-controller clear
		SEP	#00110000B
		RTS
;
MOUSE300	EQU	$
		STY	KEYB1L
		TYA
		EOR	KEYBBFL
		AND	KEYB1L
		STA	KEYB2L
		STY	KEYBBFL		; joy-controller set
		STZ	<MOUSEBS	;MOUSE CLR
		STZ	<MOUSEBX	;MOUSE CLR
		STZ	<MOUSEBT	;MOUSE CLR
;
		MEM8
		IDX8
		SEP	#00110000B
		RTS
;
;
;
MOUSE_SP	EQU	$			;SPEED CHNG.
		LDA	#001H
		STA	04016H
		LDA	04016H,Y
		STZ	04016H
;
		LDA	#001H
		STA	04016H
		STZ	04016H
;
		LDX	#010
MUE_SP10	EQU	$
		LDA	04016H,Y
		DEX
		BNE	MUE_SP10
;
		LDA	04016H,Y
		XBA
		LDA	04016H,Y
		LSR	A
		XBA
		ROL	A
		AND	#003H
		CMP	MOUSESPA,Y
		BNE	MOUSE_SP
;
		RTS
;
;
;
;
;
;
; <<<<<	 key input data table  >>>>>
ASKYBD1		EQU	$
;			  0   1	  2   3	  4   5	  6   7	  8   9	  A   B	  C   D	  E   F
		BYTE	NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,RTN,NUL,NUL ; 0
		BYTE	NUL,NUL,NUL,UPS,DWS,NUL,NUL,NUL,NUL,NUL,NUL,ESC,NUL,NUL,NUL,NUL ; 1
		BYTE	SPS,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL ; 2
		BYTE	SU0,SU1,SU2,SU3,SU4,SU5,SU6,SU7,SU8,SU9,NUL,NUL,NUL,NUL,NUL,NUL ; 3
		BYTE	NUL,L_A,L_B,L_C,L_D,L_E,L_F,L_G,L_H,L_I,L_J,L_K,L_L,L_M,L_N,L_O ; 4
		BYTE	L_P,L_Q,L_R,L_S,L_T,L_U,L_V,L_W,L_X,L_Y,L_Z,NUL,NUL,NUL,NUL,NUL ; 5
		BYTE	NUL,L_A,L_B,L_C,L_D,L_E,L_F,L_G,L_H,L_I,L_J,L_K,L_L,L_M,L_N,L_O ; 6
		BYTE	L_P,L_Q,L_R,L_S,L_T,L_U,L_V,L_W,L_X,L_Y,L_Z,NUL,NUL,NUL,NUL,NUL ; 7
		BYTE	NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL ; 8
		BYTE	NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL ; 9
		BYTE	NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL ; A
		BYTE	NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL ; B
		BYTE	NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL ; C
		BYTE	NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL ; D
		BYTE	NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL ; E
		BYTE	F_1,F_2,F_3,F_4,F_5,F_6,F_7,F_8,F_9,F_0,NUL,NUL,NUL,NUL,NUL,NUL ; F
;
ASKYBD2		EQU	$
;			  0   1	  2   3	  4   5	  6   7	  8   9	  A   B	  C   D	  E   F
		BYTE	NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,TAB,NUL,NUL,NUL,RTN,NUL,NUL ; 0
		BYTE	NUL,NUL,NUL,UPS,DWS,NUL,NUL,NUL,NUL,NUL,NUL,NUL,RIT,LEF,UPP,DWN ; 1
		BYTE	SPS,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL ; 2
		BYTE	NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL ; 3
		BYTE	NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL ; 4
		BYTE	NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL ; 5
		BYTE	NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL ; 6
		BYTE	NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL ; 7
		BYTE	NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL ; 8
		BYTE	NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL ; 9
		BYTE	NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL ; A
		BYTE	NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL ; B
		BYTE	NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL ; C
		BYTE	NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL ; D
		BYTE	NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL ; E
		BYTE	F_1,F_2,F_3,F_4,F_5,F_6,F_7,F_8,F_9,F_0,NUL,NUL,NUL,NUL,NUL,NUL ; F
;
ASKYBD3		EQU	$
;			  0   1	  2   3	  4   5	  6   7	  8   9	  A   B	  C   D	  E   F
		BYTE	NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,RTN,NUL,NUL ; 0
		BYTE	NUL,NUL,NUL,UPS,DWS,NUL,NUL,NUL,NUL,NUL,NUL,ESC,NUL,NUL,NUL,NUL ; 1
		BYTE	SPS,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,L_c,L_h,L_p,L_s ; 2
		BYTE	SU0,SU1,SU2,SU3,SU4,SU5,SU6,SU7,SU8,SU9,NUL,NUL,NUL,L_e,NUL,NUL ; 3
		BYTE	NUL,L_A,L_B,L_C,L_D,L_E,L_F,L_G,L_H,L_I,L_J,L_K,L_L,L_M,L_N,L_O ; 4
		BYTE	L_P,L_Q,L_R,L_S,L_T,L_U,L_V,L_W,L_X,L_Y,L_Z,NUL,NUL,NUL,NUL,L_u ; 5
		BYTE	NUL,L_A,L_B,L_C,L_D,L_E,L_F,L_G,L_H,L_I,L_J,L_K,L_L,L_M,L_N,L_O ; 6
		BYTE	L_P,L_Q,L_R,L_S,L_T,L_U,L_V,L_W,L_X,L_Y,L_Z,NUL,NUL,NUL,NUL,NUL ; 7
		BYTE	NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL ; 8
		BYTE	NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL ; 9
		BYTE	NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL ; A
		BYTE	NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL ; B
		BYTE	NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL ; C
		BYTE	NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL ; D
		BYTE	NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL ; E
		BYTE	F_1,F_2,F_3,F_4,F_5,F_6,F_7,F_8,F_9,F_0,NUL,NUL,NUL,NUL,NUL,NUL ; F
;
;;;;;;;
;
;
;
;***********************************************************
;*							   *
;*	 key input data pop				   *
;*							   *
;***********************************************************
KYREAD		EQU	$
		LDA	#NUL
		STA	<INKEY
		STA	<INKEY2
		STA	<INKEY3		; key [NUL] set
;
		DOS	_CONSNS
		CMP	#000H
		BEQ	KYRD080		; Key-board key on ?
;					; yes
		DOS	_CONIN		; Key-board key-check
		TAX
		LDA	ASKYBD1,X
		STA	<INKEY
;
		LDA	ASKYBD2,X
		STA	<INKEY2
;
		LDA	ASKYBD3,X
		STA	<INKEY3
KYRD080		EQU	$
		RTL
;
;
;
;
;
;
;
;
		END
