;************************************************************************
;*									*
;*	title name	: "yossy map tool"				*
;*	proccess	: mchip ram name				*
;*	file name	: ysm_mram.asm					*
;*									*
;************************************************************************
;
;
;-------------< LN^[f[^AhX >-----------------------------
NO_PRES		EQU	20		;񈳏koN
;
CHR50		EQU	520000H		;[ vC[]pLN^[		    ]
CHR64		EQU	528000H		;[		 h			    ]
CHR64P		EQU	CHR64+3000H	;[ ACegp֎~LN^[		    ]
CHR34		EQU	52C000H		;[ af]pSrbgLN^[	    ]
CHR80		EQU	530000H		;[ }bvpACRrbg}bvLN^[ ]
CHR88		EQU	538000H		;[		      h		    ]
CHRE0		EQU	53C000H		;[ ~[WJf]LN^[	    ]
CHR28		EQU	540000H		;[ rbg}bvLN^[		    ]
CHR68		EQU	548000H		;[	      h			    ]
CHR98		EQU	550000H		;[	      h			    ]
CHR11A		EQU	558000H		;[ GfBOprbg}bvLN^[   ]
CHR90		EQU	560000H		;[ }bvprbg}bvLN^[	    ]
CHR8C		EQU	566000H		;[ rbg}bvLN^[		    ]
CHR3F		EQU	568000H		;[ af]pQrbgLN^[	    ]
CHR70		EQU	569000H		;[		h			    ]
CHR71		EQU	56A000H		;[		h			    ]
CHR72		EQU	56B000H		;[		h			    ]
CHR73		EQU	56C000H		;[		h			    ]
CHR74		EQU	56D000H		;[ XRA[{[h]pLN^[	    ]
CHR32		EQU	56E800H		;[ [^[ϐg^CvLN^[	    ]
CHR119		EQU	56EC00H		;[nR[X]pLN^[		    ]
;
;
CIPCHD		EQU	CHR28
CIPCHD2		EQU	CHR68
CIPCHD3		EQU	CHR98
CIPCHD4		EQU	CHR8C
CIPCHD5		EQU	CHR11A
;
;
;-------------< J[f[^AhX >-----------------------------------
COL_ADDRESS	EQU	0F8000H
;
;
;
;
;************************************************************************
;*									*
;*		mario chip == SFC RAM					*
;*									*
;************************************************************************
;
;************************************************************************
;*		mario chip						*
;************************************************************************
;
;========================================================================
;=		0 page RAM						=
;========================================================================
;
;-------------< work RAM >-----------------------------------------------
CWORK		EQU	000000H
CWORK0		EQU	CWORK
CWORK1		EQU	CWORK0+2
CWORK2		EQU	CWORK1+2
CWORK3		EQU	CWORK2+2
CWORK4		EQU	CWORK3+2
CWORK5		EQU	CWORK4+2
CWORK6		EQU	CWORK5+2
CWORK7		EQU	CWORK6+2
CWORK8		EQU	CWORK7+2
CWORK9		EQU	CWORK8+2
CWORKA		EQU	CWORK9+2
CWORKB		EQU	CWORKA+2
CWORKC		EQU	CWORKB+2
CWORKD		EQU	CWORKC+2
CWORKE		EQU	CWORKD+2
CWORKF		EQU	CWORKE+2
;
CWORK10		EQU	CWORKF+2
CWORK11		EQU	CWORK10+2
CWORK12		EQU	CWORK11+2
CWORK13		EQU	CWORK12+2
CWORK14		EQU	CWORK13+2
CWORK15		EQU	CWORK14+2
CWORK16		EQU	CWORK15+2
CWORK17		EQU	CWORK16+2
CWORK18		EQU	CWORK17+2
CWORK19		EQU	CWORK18+2
CWORK1A		EQU	CWORK19+2
CWORK1B		EQU	CWORK1A+2
CWORK1C		EQU	CWORK1B+2
CWORK1D		EQU	CWORK1C+2
CWORK1E		EQU	CWORK1D+2
CWORK1F		EQU	CWORK1E+2
;
;-------------< register save RAM >--------------------------------------
REG0		EQU	CWORK1F+2
REG1		EQU	REG0+2
REG2		EQU	REG1+2
REG3		EQU	REG2+2
REG4		EQU	REG3+2
REG5		EQU	REG4+2
REG6		EQU	REG5+2
REG7		EQU	REG6+2
REG8		EQU	REG7+2
REG9		EQU	REG8+2
REG10		EQU	REG9+2
REG11		EQU	REG10+2
REG12		EQU	REG11+2
REG13		EQU	REG12+2
REG14		EQU	REG13+2
REG15		EQU	REG14+2
;
;-------------< R11 ( return address ) save RAM >------------------------
RTS0		EQU	REG15+2
RTS1		EQU	RTS0+2
RTS2		EQU	RTS1+2
RTS3		EQU	RTS2+2
RTS4		EQU	RTS3+2
RTS5		EQU	RTS4+2
RTS6		EQU	RTS5+2
RTS7		EQU	RTS6+2
RTS8		EQU	RTS7+2
RTS9		EQU	RTS8+2
;
;
;........................................................................
;.		extern RAM						.
;........................................................................
CMSTATIC0	EQU	RTS9+2
;
;
;------------------------------------------------------------------------
;-		clear RAM.0						-
;------------------------------------------------------------------------
;
CMCLRRM0_S	EQU	CMSTATIC0
;
;
CMCLRRM0_E	EQU	CMCLRRM0_S+1
CMCLR0SE	EQU	CMCLRRM0_E-CMCLRRM0_S
;
;------------------------------------------------------------------------
;-		clear RAM.0 end						-
;------------------------------------------------------------------------
;
;
;========================================================================
;=		!=0 page RAM						=
;========================================================================
;
;-------------< map flag RAM >-------------------------------------------
CMPTYPE		EQU	200H			;map type
CMPLMODE	EQU	CMPTYPE+2		;player mode
;
;-------------- map data edit RAM -------------------------------
CEDZOOM		EQU	CMPLMODE+2		;map data edit zoom flag
CEDCENTX	EQU	CEDZOOM+2
CEDCENTY	EQU	CEDCENTX+2
;
CCSRXPS		EQU	CEDCENTY+2		;cursol X pos
CCSRYPS		EQU	CCSRXPS+2		;   "   Y  "
CEDMPXPS	EQU	CCSRYPS+2		;map edit set X pos
CEDMPZPS	EQU	CEDMPXPS+2		;	"     Z  "
CEDMPYPS	EQU	CEDMPZPS+2		;	"     Y  "
;
;
;........................................................................
;.		static RAM ( map )					.
;........................................................................
CMSTATIC1	EQU	CEDMPYPS+2
;
;
MPOBJN		EQU	150+16			;map OBJ max no
;
;
;------------------------------------------------------------------------
;-		clear RAM.1						-
;------------------------------------------------------------------------
CMCLRRM1_S	EQU	CMSTATIC1
;
;
;-------------< H-DMA buffer >-------------------------------------------
CMPHDMAB0	EQU	CMCLRRM1_S	;H-DMA buffer.0 ( X  cos )
CMPHDMAB1	EQU	CMPHDMAB0+70H*2 ;	"    .1 ( X  sin )
CMPHDMAB2	EQU	CMPHDMAB1+70H*2 ;	"    .2 ( Y -sin )
CMPHDMAB3	EQU	CMPHDMAB2+70H*2 ;	"    .3 ( Y  cos )
;
;-------------- map work RAM ------------------------------------
CMPWORK		EQU	CMPHDMAB3+70H*2
;
;
CMCLRRM1_E	EQU	CMPWORK+(MPOBJN/2)*4
CMCLR1SE	EQU	CMCLRRM1_E-CMCLRRM1_S
;
;------------------------------------------------------------------------
;-		clear RAM.1 end						-
;------------------------------------------------------------------------
;
;
;-------------< map OBJ RAM >--------------------------------------------
CMPANGLE	EQU	CMCLRRM1_E		;map angle
;
CMPPLXPOS	EQU	CMPANGLE+2		;player long X pos
CMPPLZPOS	EQU	CMPPLXPOS+2		;     "      Z  "
CMPPLYPOS	EQU	CMPPLZPOS+2		;     "      Y  "
;
;-------------- map clear RAM -----------------------------------
CMMPCLRRM_S	EQU	CMPPLYPOS+2
;
CMPOBJSTN	EQU	CMMPCLRRM_S		;map OBJ set no
;
CMPOBJTYP	EQU	CMPOBJSTN+2		;    "   type no.
CMPOBJXPS	EQU	CMPOBJTYP+1		;    "   X pos
CMPOBJZPS	EQU	CMPOBJXPS+1		;    "   Z  "
CMPOBJYPS	EQU	CMPOBJZPS+1		;    "   Y  "
;
CMPWOBJXPS	EQU	CMPOBJTYP+MPOBJN*4	;map work OBJ X pos
CMPWOBJYPS	EQU	CMPWOBJXPS+1		;      "      Y  "
CMPWOBJSIZ	EQU	CMPWOBJYPS+1		;      "      zoom size
;
CMPWOBJZPS	EQU	CMPWOBJXPS+MPOBJN*4	;      "      Z pos
CMPSORTIDX	EQU	CMPWOBJZPS+1		;	  "         sort index buffer
;
CMMPCLRRM_E	EQU	CMPWOBJZPS+MPOBJN*2
;
;
;-------------- map player RAM define -------------------
CMPPLTYP	EQU	CMPOBJTYP		;player type no.
CMPPLXPS	EQU	CMPOBJXPS		;   "   X pos
CMPPLZPS	EQU	CMPOBJZPS		;   "   Z  "
CMPPLYPS	EQU	CMPOBJYPS		;   "   Y  "
CMPPLSIZ	EQU	CMPWOBJSIZ		;   "   zoom size
;
;-------------- move OBJ RAM define ---------------------
CMPMVTYP	EQU	CMPOBJTYP+4		;move OBJ type no.
CMPMVXPS	EQU	CMPOBJXPS+4		;    "    X pos
CMPMVZPS	EQU	CMPOBJZPS+4		;    "    Z  "
CMPMVYPS	EQU	CMPOBJYPS+4		;    "    Y  "
CMPWMVYPS	EQU	CMPWOBJYPS+4		;    "    work Y pos
CMPMVSIZ	EQU	CMPWOBJSIZ+4		;    "    zoom size
;
;
;************************************************************************
;*		SFC							*
;************************************************************************
;
;========================================================================
;=		0 page RAM						=
;========================================================================
;
;-------------< work RAM >-----------------------------------------------
CCWORK		EQU	06000H
CCWORK0		EQU	CCWORK
CCWORK1		EQU	CCWORK0+2
CCWORK2		EQU	CCWORK1+2
CCWORK3		EQU	CCWORK2+2
CCWORK4		EQU	CCWORK3+2
CCWORK5		EQU	CCWORK4+2
CCWORK6		EQU	CCWORK5+2
CCWORK7		EQU	CCWORK6+2
CCWORK8		EQU	CCWORK7+2
CCWORK9		EQU	CCWORK8+2
CCWORKA		EQU	CCWORK9+2
CCWORKB		EQU	CCWORKA+2
CCWORKC		EQU	CCWORKB+2
CCWORKD		EQU	CCWORKC+2
CCWORKE		EQU	CCWORKD+2
CCWORKF		EQU	CCWORKE+2
;
CCWORK10	EQU	CCWORKF+2
CCWORK11	EQU	CCWORK10+2
CCWORK12	EQU	CCWORK11+2
CCWORK13	EQU	CCWORK12+2
CCWORK14	EQU	CCWORK13+2
CCWORK15	EQU	CCWORK14+2
CCWORK16	EQU	CCWORK15+2
CCWORK17	EQU	CCWORK16+2
CCWORK18	EQU	CCWORK17+2
CCWORK19	EQU	CCWORK18+2
CCWORK1A	EQU	CCWORK19+2
CCWORK1B	EQU	CCWORK1A+2
CCWORK1C	EQU	CCWORK1B+2
CCWORK1D	EQU	CCWORK1C+2
CCWORK1E	EQU	CCWORK1D+2
CCWORK1F	EQU	CCWORK1E+2
;
;-------------< register save RAM >--------------------------------------
CREG0		EQU	CCWORK1F+2
CREG1		EQU	CREG0+2
CREG2		EQU	CREG1+2
CREG3		EQU	CREG2+2
CREG4		EQU	CREG3+2
CREG5		EQU	CREG4+2
CREG6		EQU	CREG5+2
CREG7		EQU	CREG6+2
CREG8		EQU	CREG7+2
CREG9		EQU	CREG8+2
CREG10		EQU	CREG9+2
CREG11		EQU	CREG10+2
CREG12		EQU	CREG11+2
CREG13		EQU	CREG12+2
CREG14		EQU	CREG13+2
CREG15		EQU	CREG14+2
;
;-------------< R11 ( return address ) save RAM >------------------------
CRTS0		EQU	CREG15+2
CRTS1		EQU	CRTS0+2
CRTS2		EQU	CRTS1+2
CRTS3		EQU	CRTS2+2
CRTS4		EQU	CRTS3+2
CRTS5		EQU	CRTS4+2
CRTS6		EQU	CRTS5+2
CRTS7		EQU	CRTS6+2
CRTS8		EQU	CRTS7+2
CRTS9		EQU	CRTS8+2
;
;
;........................................................................
;.		extern RAM						.
;........................................................................
MSTATIC0	EQU	CRTS9+2
;
;
;------------------------------------------------------------------------
;-		clear RAM.0						-
;------------------------------------------------------------------------
;
MCLRRM0_S	EQU	MSTATIC0
;
;
MCLRRM0_E	EQU	MCLRRM0_S+1
MCLR0SE		EQU	MCLRRM0_E-MCLRRM0_S
;
;------------------------------------------------------------------------
;-		clear RAM.0 end						-
;------------------------------------------------------------------------
;
;
;========================================================================
;=		!=0 page RAM						=
;========================================================================
;
;-------------< map flag RAM >-------------------------------------------
MPTYPE		EQU	6200H		;map type
MPLMODE		EQU	MPTYPE+2	; "  player mode
;
;-------------- map data edit RAM -------------------------------
EDZOOM		EQU	MPLMODE+2	;map data edit zoom flag
EDCENTX		EQU	EDZOOM+2
EDCENTY		EQU	EDCENTX+2
;
CSRXPS		EQU	EDCENTY+2		;cursol X pos
CSRYPS		EQU	CSRXPS+2		;   "   Y  "
EDMPXPS		EQU	CSRYPS+2		;map edit set X pos
EDMPZPS		EQU	EDMPXPS+2		;	"     Z  "
EDMPYPS		EQU	EDMPZPS+2		;	"     Y  "
;
;
;........................................................................
;.		static RAM ( map )					.
;........................................................................
MSTATIC1	EQU	EDMPYPS+2
;
;
;------------------------------------------------------------------------
;-		clear RAM.1						-
;------------------------------------------------------------------------
MCLRRM1_S	EQU	MSTATIC1
;
;
;-------------< H-DMA buffer >-------------------------------------------
MPHDMAB0	EQU	MCLRRM1_S	;H-DMA buffer.0 ( X  cos )
MPHDMAB1	EQU	MPHDMAB0+70H*2	;	"    .1 ( X  sin )
MPHDMAB2	EQU	MPHDMAB1+70H*2	;	"    .2 ( Y -sin )
MPHDMAB3	EQU	MPHDMAB2+70H*2	;	"    .3 ( Y  cos )
;
;-------------- map work RAM ------------------------------------
MPWORK		EQU	MPHDMAB3+70H*2
;
;
MCLRRM1_E	EQU	MPWORK+(MPOBJN/2)*4
MCLR1SE		EQU	MCLRRM1_E-MCLRRM1_S
;
;------------------------------------------------------------------------
;-		clear RAM.1 end						-
;------------------------------------------------------------------------
;
;
;-------------< map OBJ RAM >--------------------------------------------
MPANGLE		EQU	MCLRRM1_E		;map angle
;
MPPLXPOS	EQU	MPANGLE+2		;player long X pos
MPPLZPOS	EQU	MPPLXPOS+2		;     "      Z  "
MPPLYPOS	EQU	MPPLZPOS+2		;     "      Y  "
;
;-------------- map clear RAM -----------------------------------
MMPCLRRM_S	EQU	MPPLYPOS+2
;
MPOBJSTN	EQU	MMPCLRRM_S		;map OBJ set no
;
MPOBJTYP	EQU	MPOBJSTN+2		;    "   type no.
MPOBJXPS	EQU	MPOBJTYP+1		;    "   X pos
MPOBJZPS	EQU	MPOBJXPS+1		;    "   Z  "
MPOBJYPS	EQU	MPOBJZPS+1		;    "   Y  "
;
MPWOBJXPS	EQU	MPOBJTYP+MPOBJN*4	;map work OBJ X pos
MPWOBJYPS	EQU	MPWOBJXPS+1		;      "      Y  "
MPWOBJSIZ	EQU	MPWOBJYPS+1		;      "      zoom size
;
MPWOBJZPS	EQU	MPWOBJXPS+MPOBJN*4	;      "      Z pos
MPSORTIDX	EQU	MPWOBJZPS+1		;	  "         sort index buffer
;
MMPCLRRM_E	EQU	MPWOBJZPS+MPOBJN*2
MMPCLRSE	EQU	MMPCLRRM_E-MMPCLRRM_S
;
;
;-------------- map player RAM define -------------------
MPPLTYP		EQU	MPOBJTYP		;player type no.
MPPLXPS		EQU	MPOBJXPS		;   "   X pos
MPPLZPS		EQU	MPOBJZPS		;   "   Z  "
MPPLYPS		EQU	MPOBJYPS		;   "   Y  "
MPPLSIZ		EQU	MPWOBJSIZ		;   "   zoom size
;
;-------------- move OBJ RAM define ---------------------
MPMVTYP		EQU	MPOBJTYP+4		;move OBJ type no.
MPMVXPS		EQU	MPOBJXPS+4		;    "    X pos
MPMVZPS		EQU	MPOBJZPS+4		;    "    Z  "
MPMVYPS		EQU	MPOBJYPS+4		;    "    Y  "
MPWMVYPS	EQU	MPWOBJYPS+4		;    "    work Y pos
MPMVSIZ		EQU	MPWOBJSIZ+4		;    "    zoom size
;
;
;
;
;
;************************************************************************
;*									*
;*		only mario chip RAM					*
;*									*
;************************************************************************
;
;........................................................................
;.		extern RAM						.
;........................................................................
;
;-------------< OAM >----------------------------------------------------
OAM		EQU	702000H
OAMSUB		EQU	OAM+200H
OAMSB		EQU	OAMSUB+20H
;
;-------------< color data buffer >--------------------------------------
DATACOL		EQU	OAMSB+080H	;now color data
;
;-------------< div data RAM >-------------------------------------------
DIVBUF		EQU	DATACOL+200H	;[ map:0-3AE becorse bitmap buffer use ]
;
;
;........................................................................
;.		static RAM ( map )					.
;........................................................................
;
;------------------------------------------------------------------------
;-		clear RAM.2						-
;------------------------------------------------------------------------
MCLRRM2_S	EQU	DIVBUF+256*2*4+2
;
;........................................................................
;.		static RAM ( title )					.
;........................................................................
MSTATIC2	EQU	MCLRRM2_S
;
;-------------< software sprite RAM >------------------------------------
OSCCH		EQU	MSTATIC2
OSCCV		EQU	OSCCH+2
OCENTX		EQU	OSCCV+2
OCENTY		EQU	OCENTX+2
OMATA		EQU	OCENTY+2
OMATB		EQU	OMATA+2
OMATC		EQU	OMATB+2
OMATD		EQU	OMATC+2
OCHRADR		EQU	OMATD+2
OBUFXPS		EQU	OCHRADR+4
OBUFYPS		EQU	OBUFXPS+2
OBM7CNT		EQU	OBUFYPS+2
OBM7R01		EQU	OBM7CNT+2
OBM7R02		EQU	OBM7R01+2
OBM7R03		EQU	OBM7R02+2
OBM7R05		EQU	OBM7R03+2
OBM7R07		EQU	OBM7R05+2
OBM7R08		EQU	OBM7R07+2
OBM7R09		EQU	OBM7R08+2
OBM7R10		EQU	OBM7R09+2
;
;-------------< software sprite chara buffer >---------------------------
WOB7CHR		EQU	706000H
;			   |
;			   V
;			707FFFH
;
;
MCLRRM2_E	EQU	708000H
MCLR2SE		EQU	MCLRRM2_E-MCLRRM2_S-1
;
;
;------------------------------------------------------------------------
;-		clear RAM.2 end						-
;------------------------------------------------------------------------
;
;
;
;
;-------------< map bitmap buffer >--------------------------------------
MPBITMAP	EQU	702C00H
;
;-------------< map bitmap buffer convert work buffer >------------------
MPCNVBF		EQU	MPBITMAP+4600H		;[ 28 x 20 ]
;;;;		EQU	MPCNVBF+0E00H		;[ 3800H/4 ]
;
;
;
;
;
