;************************************************************************
;*									*
;*	title name	: "yossy map tool"				*
;*	proccess	: ram name					*
;*	file name	: ysm_ram					*
;*									*
;************************************************************************
;
;
;
;
;========================================================================
;=		0 page RAM						=
;========================================================================
;
;-------------< work RAM >-----------------------------------------------
WORK		EQU	000000H
WORK0		EQU	WORK
WORK1		EQU	WORK0+1
WORK2		EQU	WORK1+1
WORK3		EQU	WORK2+1
WORK4		EQU	WORK3+1
WORK5		EQU	WORK4+1
WORK6		EQU	WORK5+1
WORK7		EQU	WORK6+1
WORK8		EQU	WORK7+1
WORK9		EQU	WORK8+1
WORKA		EQU	WORK9+1
WORKB		EQU	WORKA+1
WORKC		EQU	WORKB+1
WORKD		EQU	WORKC+1
WORKE		EQU	WORKD+1
WORKF		EQU	WORKE+1
WORK10		EQU	WORKF+1
WORK11		EQU	WORK10+1
WORK12		EQU	WORK11+1
WORK13		EQU	WORK12+1
WORK14		EQU	WORK13+1
WORK15		EQU	WORK14+1
WORK16		EQU	WORK15+1
WORK17		EQU	WORK16+1
WORK18		EQU	WORK17+1
WORK19		EQU	WORK18+1
WORK1A		EQU	WORK19+1
WORK1B		EQU	WORK1A+1
WORK1C		EQU	WORK1B+1
WORK1D		EQU	WORK1C+1
WORK1E		EQU	WORK1D+1
WORK1F		EQU	WORK1E+1
WORK20		EQU	WORK1F+1
WORK21		EQU	WORK20+1
WORK22		EQU	WORK21+1
WORK23		EQU	WORK22+1
WORK24		EQU	WORK23+1
WORK25		EQU	WORK24+1
WORK26		EQU	WORK25+1
WORK27		EQU	WORK26+1
WORK28		EQU	WORK27+1
WORK29		EQU	WORK28+1
WORK2A		EQU	WORK29+1
WORK2B		EQU	WORK2A+1
WORK2C		EQU	WORK2B+1
WORK2D		EQU	WORK2C+1
WORK2E		EQU	WORK2D+1
WORK2F		EQU	WORK2E+1
;
;
;........................................................................
;.		extern RAM						.
;........................................................................
;
FRCNT		EQU	WORK2F+1	;frame counter
;
;
;------------------------------------------------------------------------
;-		clear RAM.0						-
;------------------------------------------------------------------------
CLRRM0_S	EQU	FRCNT+1
;
;
;-------------< joy-controller >-----------------------------------------
KEYC1L		EQU	CLRRM0_S	;move controller(L)
KEYC1		EQU	KEYC1L+1	;	"       (H)
KEYC2L		EQU	KEYC1+1		;	"       (L) [ triger ]
KEYC2		EQU	KEYC2L+1	;	"       (H)
;
;-------------< scroll counter >-----------------------------------------
SCCH1		EQU	KEYC2+1		;BG1_H
SCCV1		EQU	SCCH1+2		;   _V
SCCH2		EQU	SCCV1+2		;BG2_H
SCCV2		EQU	SCCH2+2		;   _V
SCCH3		EQU	SCCV2+2		;BG3_H
SCCV3		EQU	SCCH3+2		;   _V
SCCH4		EQU	SCCV3+2		;BG4_H
SCCV4		EQU	SCCH4+2		;   _V
;
;
;........................................................................
;.		static RAM ( map data edit )				.
;........................................................................
STATIC0		EQU	SCCV4+2
;
;
;-------------- mouse data ----------------------------------------------
MOUSEAS		EQU	STATIC0		;MOUSE A KEY
MOUSEAX		EQU	MOUSEAS+1	;MOUSE A X
MOUSEAY		EQU	MOUSEAX+1	;MOUSE A Y
MOUSEBS		EQU	MOUSEAY+1	;MOUSE B KEY
MOUSEBX		EQU	MOUSEBS+1	;MOUSE B X
MOUSEBY		EQU	MOUSEBX+1	;MOUSE B Y
MOUSESPA	EQU	MOUSEBY+1	;MOUSE A SPEED
MOUSESPB	EQU	MOUSESPA+1	;MOUSE A SPEED
MOUSEAT		EQU	MOUSESPB+1	;MOUSE A KEY(TRIGER)
MOUSEAB		EQU	MOUSEAT+1	;MOUSE A KEY(TRIGER WORK)
MOUSEBT		EQU	MOUSEAB+1	;MOUSE B KEY(TRIGER)
MOUSEBB		EQU	MOUSEBT+1	;MOUSE B KEY(TRIGER WORK)
MUSECTX		EQU	MOUSEBB+1	; mouse move check count
MUSECTY		EQU	MUSECTX+1	; mouse move check count
;
;-------------- key input RAM -------------------------------------------
INKEY		EQU	MUSECTY+1	; key data
INKEY2		EQU	INKEY+1		;
INKEY3		EQU	INKEY2+1	;
;
;
;-------------- map data edit RAM ---------------------------------------
;******** AADA USED RAM ********
EDTBFFG		EQU	INKEY3+1
DMDFLG		EQU	EDTBFFG+1
;;;;;		EQU	DTMDAD+1
;
;
CLRRM0_E	EQU	100H
CLR0SE		EQU	CLRRM0_E-CLRRM0_S
;
;
;------------------------------------------------------------------------
;-		clear RAM.0 end						-
;------------------------------------------------------------------------
;
;
;
;========================================================================
;=		!=0 page RAM						=
;========================================================================
;
;........................................................................
;.		extern RAM						.
;........................................................................
;
;-------------< RAM vector >---------------------------------------------
RAMVCT		EQU	100H
RTISUB0		EQU	100H		;RTISUB
COPSUB0		EQU	104H		;COP
INTSUB0		EQU	108H		;NMI
IRQSUB0		EQU	10CH		;IRQ
;
;
;-------------< system RAM >---------------------------------------------
SYSRAM		EQU	118H
;
;-------------< mode flag >----------------------------------------------
MODENO		EQU	SYSRAM		;main mode no.
NMIFLG		EQU	MODENO+1	;NMI flag
NMITYP		EQU	NMIFLG+1	; "  type no.
NMIJMP		EQU	NMITYP+1	; "  program jump address buffer
IRQFLG		EQU	NMIJMP+2	;IRQ flag
IRQTYP		EQU	IRQFLG+1	; "  type no.
IRQJMP		EQU	IRQTYP+1	; "  program jump address buffer
VRFLG		EQU	IRQJMP+2	;BG write flag ( VRAMD )
VRFLG2		EQU	VRFLG+2		;	"      ( VRAMDX )
;
;-------------< chip controll ram >--------------------------------------
CIPSCB		EQU	VRFLG2+2	;[3038] chip screen base
CIPSCR		EQU	CIPSCB+1	;[303A]	      "     size mode
;
;-------------< pause flag >---------------------------------------------
PAUSE		EQU	CIPSCR+1	;pause flag
PASTM		EQU	PAUSE+1		;   "  timer
;
NMICONT		EQU	PASTM+1
;
;-------------< stack RAM >----------------------------------------------
STACK		EQU	PASTM+1		;stack area
;			  |		;
;			  V		;
;			1FFH		;
;
;
;-------------< static RAM >---------------------------------------------
FADNO		EQU	200H		;[2100] fade no. & blanking flag
FADMK		EQU	FADNO+1		;	  "  muki
FADTM		EQU	FADMK+1		;	  "  timer
MOZNO		EQU	FADTM+1		;[2106] mozaiku no.
MOZMK		EQU	MOZNO+1		;	   "    muki
;
;-------------< mode 7 parameter RAM >-----------------------------------
CENTX		EQU	MOZMK+1		;mode 7 center X pos
CENTY		EQU	CENTX+2		;	"      Y  "
;
MATA		EQU	CENTY+2		;matrix A
MATB		EQU	MATA+2		;   "   B
MATC		EQU	MATB+2		;   "   C
MATD		EQU	MATC+2		;   "   D
;
;------------------------------------------------------------------------
;-		clear RAM.1						-
;------------------------------------------------------------------------
CLRRM1_S	EQU	MATD+2
;
;
;-------------< joy-controller >-----------------------------------------
KEYA1L		EQU	CLRRM1_S	;controller_1(L)
KEYA1		EQU	KEYA1L+1	;    "       (H)
KEYA2L		EQU	KEYA1+1		;    "       (L) [ triger ]
KEYA2		EQU	KEYA2L+1	;    "       (H)
KEYB1L		EQU	KEYA2+1		;    "     _2(L)
KEYB1		EQU	KEYB1L+1	;    "       (H)
KEYB2L		EQU	KEYB1+1		;    "       (L) [ triger ]
KEYB2		EQU	KEYB2L+1	;    "       (H)
KEYABFL		EQU	KEYB2+1		;to triger check work_1(L)
KEYABF		EQU	KEYABFL+1	;	   "           (H)
KEYBBFL		EQU	KEYABF+1	;	   "         _2(L)
KEYBBF		EQU	KEYBBFL+1	;	   "           (H)
;
;-------------< PPU register set RAM >-----------------------------------
NUKCOL		EQU	KEYBBF+1	;[2132] nuki color
HD420C		EQU	NUKCOL+2	;[420C] H-DMA "ON/OFF" flag
;
;.............< game mode RAM >..........................................
GMMDRM		EQU	HD420C+1
;
BGMODE		EQU	HD420C+1	;[2105] BG mode
BG1SCF		EQU	BGMODE+1	;[2107] BG1 screen status
BG2SCF		EQU	BG1SCF+1	;[2108] BG2	   "
BG3SCF		EQU	BG2SCF+1	;[2109] BG3	   "
BG12CH		EQU	BG3SCF+1	;[210B] BG1,2 chara address
BG34CH		EQU	BG12CH+1	;[210C] BG3,4	   "
WIND23		EQU	BG34CH+1	;[2123] window "ON/OFF" flag ( BG1,2 )
WIND24		EQU	WIND23+1	;[2124]		   "         ( BG3,4 )
WIND25		EQU	WIND24+1	;[2125]		   "         ( OBJ,COLOR )
MANSEL		EQU	WIND25+1	;[212C] main select flag
SUBSEL		EQU	MANSEL+1	;[212D] sub	   "
WMANSL		EQU	SUBSEL+1	;[212E] window main select flag
WSUBSL		EQU	WMANSL+1	;[212F]	   "   sub       "
WIND30		EQU	WSUBSL+1	;[2130] color window "ON/OFF" flag
SUBADF		EQU	WIND30+1	;[2131] main & sub add select flag
;
GMMDRME		EQU	SUBADF+1
GMMDNO		EQU	GMMDRME-GMMDRM
;
;
;........................................................................
;.		static RAM ( map )					.
;........................................................................
STATIC1		EQU	GMMDRME
;
MPPLANG		EQU	STATIC1
MPPLRSZ		EQU	MPPLANG+1
MPPLGPW		EQU	MPPLRSZ+1
MPDMAFG		EQU	MPPLGPW+1
MPWDMAFG	EQU	MPDMAFG+2
MPBANK		EQU	MPWDMAFG+2
MPGOTYPE	EQU	MPBANK+2
MPM7SCRF	EQU	MPGOTYPE+2
MPFADFG		EQU	MPM7SCRF+2
MPFADR		EQU	MPFADFG+2
MPFADG		EQU	MPFADR+2
MPFADB		EQU	MPFADG+2
MPFADRTM	EQU	MPFADB+2
MPFADGTM	EQU	MPFADRTM+2
MPFADBTM	EQU	MPFADGTM+2
;
MPBG3SP		EQU	MPFADBTM+2
MPBG4SP		EQU	MPBG3SP+2
MPBG3AD		EQU	MPBG4SP+2
MPWBG3AD	EQU	MPBG3AD+2
MPBG4AD		EQU	MPWBG3AD+2
MPWBG4AD	EQU	MPBG4AD+2
;
MPSCH40		EQU	MPWBG4AD+2
MPSCH41		EQU	MPSCH40+2
MPSCH42		EQU	MPSCH41+2
MPSCH43		EQU	MPSCH42+2
MPSCH44		EQU	MPSCH43+2
MPSCH45		EQU	MPSCH44+2
MPSCH46		EQU	MPSCH45+2
MPSCH47		EQU	MPSCH46+2
;
;-------------- map data edit RAM ---------------------------------------
EDITMOD		EQU	MPSCH47+2
EDDMAFG		EQU	EDITMOD+2
;
CLRRM1_E	EQU	EDDMAFG+2
CLR1SE		EQU	CLRRM1_E-CLRRM1_S
;
;------------------------------------------------------------------------
;-		clear RAM.1 end						-
;------------------------------------------------------------------------
;
;
;-------------- map clear RAM -------------------------------------------
MPCLRRM_S	EQU	CLRRM1_E
;
MPMVOBN		EQU	16
MPMVOBJNO	EQU	MPCLRRM_S
MPMVOBWK0	EQU	MPMVOBJNO+1
MPMVOBWK1	EQU	MPMVOBWK0+1
MPMVOBTM0	EQU	MPMVOBWK1+1
;
MPCLRRM_E	EQU	MPMVOBTM0+(MPMVOBN*4)
MPCLRSE		EQU	MPCLRRM_E-MPCLRRM_S
;
;-------------- map course name RAM -------------------------------------
; **** AADA used ram ****
KWORK0		EQU	MPCLRRM_E
KWORK1		EQU	KWORK0+1
KWORK2		EQU	KWORK1+1
KWORK3		EQU	KWORK2+1
KWORK4		EQU	KWORK3+1
;
;
;--------------- edit buffer ram ----------------------------------------
;******** AADA USED RAM ********
EDITBF		EQU	01000H		; edit buffer
SLCTMD		EQU	EDITBF+0A0H*2	; select mode
SLTMDS		EQU	SLCTMD+1	;	"     set
UTONFG		EQU	SLTMDS+1	; unit obj move ON(1) , OFF(0) flag
UTPSAD		EQU	UTONFG+1
SFTFLG		EQU	UTPSAD+2	; sift on flag
FILFLG		EQU	SFTFLG+1	; file flag
FILFGS		EQU	FILFLG+2	; file flag2
MOJBFA		EQU	FILFGS+2	; mo-ji buffer A
MOJBFB		EQU	MOJBFA+08H	; mo-ji buffer B
MOJBFC		EQU	MOJBFB+08H	; mo-ji buffer C
MOJBFD		EQU	MOJBFC+08H	; mo-ji buffer D
MOJBFE		EQU	MOJBFD+08H	; mo-ji buffer E
MOJBFF		EQU	MOJBFE+08H	; mo-ji buffer F
MOJBFG		EQU	MOJBFF+08H	; mo-ji buffer G
MOJBFH		EQU	MOJBFG+08H	; mo-ji buffer H
MOJBFP		EQU	MOJBFH+08H	; mo-ji buffer P
ZRXPOS		EQU	MOJBFP+08H	; X point zu-re
ZRYPOS		EQU	ZRXPOS+1	; Y point zu-re
ZRZPOS		EQU	ZRYPOS+1	; Z point zu-re
MJIDXA		EQU	ZRZPOS+1	; mo-ji index A
MJIDXB		EQU	MJIDXA+1	; mo-ji index B
MJIDXC		EQU	MJIDXB+1	; mo-ji index C
MJIDXD		EQU	MJIDXC+1	; mo-ji index D
MJIDXE		EQU	MJIDXD+1	; mo-ji index E
MJIDXF		EQU	MJIDXE+1	; mo-ji index F
MJIDXG		EQU	MJIDXF+1	; mo-ji index G
MJIDXH		EQU	MJIDXG+1	; mo-ji index H
MJIDXP		EQU	MJIDXH+1	; mo-ji index P
MDSTFG		EQU	MJIDXP+1	; mode set flag
FLBFIDX		EQU	MDSTFG+1	; file name buffer index
SRCFLG		EQU	FLBFIDX+1	; surch ON , OFF flag
SCRLBF		EQU	SRCFLG+1	; file name scroll
UNITNO		EQU	SCRLBF+2	; unit NO.
MPCHGFG		EQU	UNITNO+1	; map data change flag
MPTCNT0		EQU	MPCHGFG+1	; map obj count 0
MPTCNT1		EQU	MPTCNT0+2	;	"       1
UNTNOBF		EQU	MPTCNT1+2	; unit NO. buffer
PTLMTCT		EQU	UNTNOBF+1	; map point limt count
MENUNO		EQU	PTLMTCT+1	; menu NO.
QSTCNT		EQU	MENUNO+2	; quest count
POINTFG		EQU	QSTCNT+100	; point set ON flag
GOLCNT		EQU	POINTFG+1	; goal count
QSTPOS		EQU	GOLCNT+8	; quest data pointer count
DATAFG		EQU	QSTPOS+1	; data set flag
DTSBPOS		EQU	DATAFG+1	; data set sub point
NXTFLG		EQU	DTSBPOS+1	; map point data next point set flag
EDNMBF		EQU	NXTFLG+1	; edit mode name buffer
INSFLG		EQU	EDNMBF+32H	; insert search flag
ERRFLG		EQU	INSFLG+2	; G[ tO
ERRTIM		EQU	ERRFLG+2	; G[ Zbg ^C}[
PTMVAD		EQU	ERRTIM+2	; |Cgړf[^ AhX
;;;;;		EQU	PTMVAD+2	; vC[X^[gʒu wTCY
;
;---------------- }bv [h (v[[ I[gړ) ----------------
MPFGONPT	EQU	01500H		;p[c |C^[
MPFGONTY	EQU	MPFGONPT+2	;p[c ^Cv
MPFGONCT	EQU	MPFGONTY+2	;Y[ J[\
MPGOTOXP	EQU	MPFGONCT+2	;vC[ wW
MPGOTOZP	EQU	MPGOTOXP+2	;	"   yW
MPGOTOYP	EQU	MPGOTOZP+2	;	"   xW
MPGOTOCT	EQU	MPGOTOYP+2	;	"   EH[N JE^[
MPPLWLK		EQU	MPGOTOCT+2	;	"   EH[N p^[
MPPLXSPD	EQU	MPPLWLK+2	;	"   wXs[h
MPPLZSPD	EQU	MPPLXSPD+2	;	"   yXs[h
MPPLYSPD	EQU	MPPLZSPD+2	;	"   xXs[h
MPCLRPT		EQU	MPPLYSPD+2	;f[^ X^[g |Cg
;;;;;		EQU	MPCLRPT+2
;
;
DTMDDT		EQU	01800H		; map point data DMA set ram
DTMDTP		EQU	DTMDDT+0092H	; type
DTMDPT		EQU	DTMDDT+0110H	; parts point
DTMDTB		EQU	DTMDDT+0192H	; data table NO.
DTMDTM		EQU	DTMDDT+0212H	; timer
DTMDPX		EQU	DTMDDT+0292H	; player X point
DTMDPY		EQU	DTMDDT+02D2H	; player Y point
DTMDCR		EQU	DTMDDT+00A8H	; quest clear data NO.
DTMDNT		EQU	DTMDDT+0134H	; next goto point NO.
DTMDMV		EQU	DTMDDT+01E8H	; player move data NO.
DTMDPL		EQU	DTMDDT+0270H	; player type
DTMDPLX		EQU	DTMDDT+02B0H	; X point
DTMDPLZ		EQU	DTMDDT+02F0H	; Z point
DTMDPLY		EQU	DTMDDT+0330H	; Y point
;
FILBF0		EQU	01C00H		; 0 file name buffer
FILBF1		EQU	FILBF0+12	; 1
FILBF2		EQU	FILBF1+12	; 2
FILBF3		EQU	FILBF2+12	; 3
FILBF4		EQU	FILBF3+12	; 4
FILBF5		EQU	FILBF4+12	; 5
FILBF6		EQU	FILBF5+12	; 6
FILBF7		EQU	FILBF6+12	; 7
FILBF8		EQU	FILBF7+12	; 8
FILBF9		EQU	FILBF8+12	; 9
FILBFA		EQU	FILBF9+12	; A
FILBFB		EQU	FILBFA+12	; B
FILBFC		EQU	FILBFB+12	; C
FILBFD		EQU	FILBFC+12	; D
FILBFE		EQU	FILBFD+12	; E
FILBFF		EQU	FILBFE+12	; F
;
;
;========================================================================
;=		!=0 bank RAM						=
;========================================================================
;
;-------------< VRAM write buffer ( normal ) >---------------------------
VRAMD		EQU	7E4000H
;
;-------------< VRAM write buffer ( DMA type ) >-------------------------
VRAMDX		EQU	VRAMD+0800H
;
;-------------< map H-DMA buffer >---------------------------------------
MPHDMABF0	EQU	VRAMDX+0800H
MPHDMABF1	EQU	MPHDMABF0+070H*2
MPHDMABF2	EQU	MPHDMABF1+070H*2
MPHDMABF3	EQU	MPHDMABF2+070H*2
;
;
HDMADB0		EQU	MPHDMABF3+1C0H
HDMADB1		EQU	HDMADB0+080H
HDMADB2		EQU	HDMADB1+080H
;
HDMAPR0		EQU	HDMADB2+80H
HDMAPR1		EQU	HDMAPR0+80H
HDMAPR2		EQU	HDMAPR1+80H
HDMAPR3		EQU	HDMAPR2+80H
HDMAPR4		EQU	HDMAPR3+80H
;
;************ AADA USED RAM *****************************
MPDTBFA		EQU	7E5A00H		; map data buffer A
MPDTBFB		EQU	MPDTBFA+025AH	;	"         B
MPDTBFC		EQU	MPDTBFB+025AH	;	"         C
MPDTBFD		EQU	MPDTBFC+025AH	;	"         D
MPDTBFE		EQU	MPDTBFD+025AH	;	"         E
MPDTBFF		EQU	MPDTBFE+025AH	;	"         F
MPDTBFG		EQU	MPDTBFF+025AH	;	"         G
MPDTBFH		EQU	MPDTBFG+025AH	;	"         H
MPTDAT		EQU	MPDTBFH+025AH	; map point buffer
;;;;;		EQU	MPTDAT+025AH
;
;-------------< big work buffer >----------------------------------------
WORKBF		EQU	7E7000H		;pless data convert buffer
;
;
;-------------< RAM program >--------------------------------------------
RPRO_RAM	EQU	7EC000H
;			   |
;			   V
;			7EDFFFH
;
;************ AADA USED RAM *****************************
MPPTCNT		EQU	7F0000H		; map point data counter
MAPPTBF		EQU	7F0002H		; map point data buffer
;			  |
;			7F7FFFH
;
;-----------------------------------------------------------------------+
MPTTYP		EQU	7F0002H		; type				|
MPTPOS		EQU	MPTTYP+1	; parts pointer			|
MPTTNO		EQU	MPTPOS+1	; course data table NO.		|
MPTTIM		EQU	MPTTNO+1	; timer				|
MPTPLX		EQU	MPTTIM+1	; player X pos			|
MPTPLY		EQU	MPTPLX+1	;   "    Y pos                  |
MPTQT1		EQU	MPTPLY+1	; qest clear data pointer 1	|
MPTQT2		EQU	MPTQT1+1	; qest clear data pointer 2	|
MPTQT3		EQU	MPTQT2+1	; qest clear data pointer 3	|
MPTQT4		EQU	MPTQT3+1	; qest clear data pointer 4	|
MPTQNT		EQU	MPTQT4+1	; qest 1 next goto point NO.	|
MPT11P		EQU	MPTQNT+1	;  "   " player type		|
MPT11X		EQU	MPT11P+1	;  "   " X pos			|
MPT11Z		EQU	MPT11X+1	;  "   " Z pos			|
MPT11Y		EQU	MPT11Z+1	;  "   " Y pos			|
;-----------------------------------------------------------------------+
;
;........................................................................
;.		static RAM ( map )					.
;........................................................................
STATIC2		EQU	7F8000H
;
MPDMABF		EQU	STATIC2			;[convert bitmap data buffer]
;
MPRTRSB		EQU	MPDMABF+3800H		;[RAM transfer program]
;;;;		EQU	(7*700H)+1
;
;
;
;
;************************************************************************
;									*
;		mario chip register					*
;									*
;************************************************************************
R0		EQU	3000H		; default
R1		EQU	3002H		; PLOT X position
R2		EQU	3004H		;  "   Y    "
R3		EQU	3006H
R4		EQU	3008H		; LMULT no kekka no low word
R5		EQU	300AH
R6		EQU	300CH		; FMULT,LMULT no Hi-jyousuu
R7		EQU	300EH		; MERGE source-1
R8		EQU	3010H		;   "      "   2
R9		EQU	3012H
R10		EQU	3014H
R11		EQU	3016H		; LINK no kekka-address
R12		EQU	3018H		; LOOP no loop kai suu
R13		EQU	301AH		;  "   "  bunki saki address
R14		EQU	301CH		; ROM pointer
R15		EQU	301EH		; program counter
;
;
;
;
;
