;************************************************************************
;*									*
;*	title name	: "yossy tool"					*
;*	proccess	: used map area display				*
;*	file name	: yst_dmap					*
;*									*
;************************************************************************
;
;
		SALL
;
		include		yst_header.inc
;
		XALL
;
;
;------------------------------------------------------------------------
;
;		Super_Y edit-tool		1992.03.05(THU)
;
;------------------------------------------------------------------------
;
		ORG	02C000H
;
;=============================================== (syt_dmap) =============
		GLB	DTDISP
;=============================================== (syt_main) =============
		EXT	JSRSUB
;=============================================== (syt_init) =============
		EXT	BGWR
;=============================================== (syt_edit) =============
		EXT	PSCTDT1
;=========================================================================
;
		EXTEND
		MEM8
		IDX8
;
;
;
;
;
;
;************************************************************************
;*		Data display mode			(DTDISP)	*
;************************************************************************
MAPDT0		EQU	$
		WORD	00194H,00180H,00181H,00185H
		WORD	00194H,00180H,00181H,00185H
		WORD	00194H,00180H,00181H,00185H
		WORD	00194H,00180H,00181H,00185H
;
;
DTDISP		EQU	$
		JSR	DTDISP1
		RTL
;
;
DTDISP1		EQU	$
		LDA	<MPDSFG
		JSL	>JSRSUB
		WORD	DTDP000			;00
		WORD	DTDP200			;01
;
DDSIN		EQU	000H
DDSPL		EQU	001H
;
;
;========================================================================
;=		Init. display				(DTDP000)	=
;========================================================================
DTDP000		EQU	$
;
;--------------	BG color set ----------------------------
		STZ	2121H			;CGRAM address set
;
		M16
;
		LDA	#00000000B+(22H*100H)	;DMA parameter & B bus address
		STA	4300H
		LDA	#1CC000H		;A bus address(L,H)
		STA	4302H
		LDY	#BANK 1CC000H		;	"     (B)
		STY	4304H
		LDA	#0100H			;number of byte
		STA	4305H
		LDX	#00000001B
		STX	420BH			;DMA "ON"
;
;--------------	BG3 screen set --------------------------
		LDY	#10000000B	;inc mode
		STY	2115H
		LDA	#7400H
		STA	2116H		; VRAM address set
		LDA	#00000001B+(18H*100H)
		STA	4300H		; parameter & B bus address
		LDA	#1CA800H
		STA	4302H		; A bus address (L,H)
		LDY	#BANK 1CA800H
		STY	4304H		;               (B)
		LDA	#0800H
		STA	4305H		; number of byte
		STX	420BH		; DMA "on"
;
;--------------	use area BG set -------------------------
;
		I16
;
		LDX	#00		;(X) <-- use buffer map pointer
		LDY	VRAMD
		LDA	#7400H+(04H+08H*20H)	;(WK0,1) <-- start VRAM address set
		STA	<WORK
		LDA	#8
		STA	<WORK+2		;(WK2,3) <-- Y loop no
DTDP010		EQU	$
		LDA	<WORK
		STA	VRAMD+2,Y	;VRAM address set
		CLC
		ADC	#020H
		STA	<WORK
		LDA	#16*2-1
		STA	VRAMD+4,Y	;number of byte set
		LDA	#16
		STA	<WORK+4		;(WK4,5) <-- X loop no
DTDP020		EQU	$
		LDA	>UNBUFAD,X
		AND	#00FFH
		BEQ	DTDP030		;use ? ( no:DTDP030 )
		LDA	#08AH-06AH
DTDP030		EQU	$
		CLC
		ADC	#01C6AH
		STA	VRAMD+6,Y	;chara no. set
		INY
		INY
		INX
		DEC	<WORK+4
		BNE	DTDP020
		INY
		INY
		INY
		INY
		DEC	<WORK+2
		BNE	DTDP010
;
		STY	VRAMD		;next index set
		LDA	#0FFFFH
		STA	VRAMD+2,Y	;end code set
;
		MI8
;
;--------------	map mode initial flag set ---------------
		LDA	#00010100B	;main select ( BG3,OBJ )
		STA	<MANSEL
		STZ	<WMANSL		;window "OFF"
		STZ	WIND23
		STZ	WIND24
		STZ	WIND25
;
		STZ	<SCCH3		;BG3 scroll counter set
		STZ	<SCCH3+1
		STZ	<SCCV3
		STZ	<SCCV3+1
;
		LDA	#078H		;cursol pos initial set
		STA	<CRXPSL2
		LDA	#040H
		STA	<CRYPSL2
;
		LDA	#00001111B
		STA	<BLKFLG
		INC	<MPDSFG
		RTS
;
;========================================================================
;=		Move					(DTDP200)	=
;========================================================================
MPOFX		EQU	020H
MPOFY		EQU	040H
;
DTDP200		EQU	$
;
;-------------- cursol move -----------------------------
		LDA	<MOUSEBX
		CLC
		ADC	<CRXPSL2
		STA 	<CRXPSL2
		STA 	!ARROAM		; x-pos. set
;
		LDA	<MOUSEBY
		CLC
		ADC	<CRYPSL2
		STA 	<CRYPSL2
		STA	!ARROAM+1	; y-pos. set
;
		LDA	#088H
		STA	!ARROAM+2	; char. no. set
		LDA	#034H
		STA	!ARROAM+3	; attribute set
;
		LDA	#00000010B	;OAM sub set
		STA	OAMSUB
;
;--------------	input check -----------------------------
		LDA	<INKEY
		CMP	#UNT
		BEQ	DTDP202		;return ? ( yes:DTDP202 )
		LDA	<MOUSEBT
		AND	#10000000B
		BEQ	DTDP210		;    "	  ( no:DTDP210 )
;
;-------------- return set ----------------------
DTDP202		EQU	$
;
		M16
;
		LDA	<CRXPSL1
		STA	<CRXPSL2
		LDA	<CRYPSL1
		STA	<CRYPSL2
;
		M8
;
		LDA	#BGWR
		STA	<GMMODE
		RTS
;
DTDP210		EQU	$
		LDA	<MOUSEBT
		AND	#01000000B
		BEQ	DTDP220		;mouse [L] key ? ( no:DTDP220 )
;
;--------------	now pos change ------------------
		LDA	<CRXPSL2
		SEC
		SBC	#MPOFX
		CMP	#8*16
		BCS	DTDP220		;X pos over ? ( yes:DTDP210 )
;
		STA	<WORK
		LDA	<CRYPSL2
		SEC
		SBC	#MPOFY
		CMP	#8*8
		BCS	DTDP220		;Y pos over ? ( yes:DTDP210 )
;
		LSR	A
		LSR	A
		LSR	A
		STA	<CRYPSH1
		STA	<SCCV1+1
		STZ	<CRYPSL1	;(L) clear !!
		STZ	<SCCV1		;     "
;
		LDA	<WORK
		LSR	A
		LSR	A
		LSR	A
		STA	<CRXPSH1
		STA	<SCCH1+1
		STZ	<CRXPSL1	;(L) clear !!
		STZ	<SCCH1		;     "
;
;--------------	now pos display -------------------------
DTDP220		EQU	$
		LDA	<FRCNT
		AND	#010H
		BEQ	DTDP230		;display timming ? ( no:DTDP230 )
;
		LDA	<CRXPSH1
		ASL	A
		ASL	A
		ASL	A
;;;;		CLC
		ADC	#MPOFX
		STA	AR1OAM		;X pos set
		LDA	<CRYPSH1
		ASL	A	
		ASL	A	
		ASL	A	
;;;;		CLC
		ADC	#MPOFY-1
		STA	AR1OAM+1	;Y pos set
		LDA	#08EH
		STA	AR1OAM+2	;chara no. set
		LDA	#034H
		STA	AR1OAM+3	;att set
;
;--------------	BG set ----------------------------------
DTDP230		EQU	$
;
		M16
;
		LDY	VRAMD
		LDA	#7400H+(1BH+0AH*20H)	;VRAM address set
		STA	VRAMD+2,Y
		LDA	#7400H+(1BH+0FH*20H)
		STA	VRAMD+2+8,Y
		LDA	#7400H+(1BH+10H*20H)
		STA	VRAMD+2+16,Y
		LDA	#7400H+(0FH+13H*20H)
		STA	VRAMD+2+24,Y
		LDA	#7400H+(0FH+14H*20H)
		STA	VRAMD+2+32,Y
		LDA	#7400H+(1BH+19H*20H)
		STA	VRAMD+2+40,Y
		LDA	#7400H+(19H+19H*20H)
		STA	VRAMD+2+48,Y
		LDA	#04H-1			;number of byte set
		STA	VRAMD+4,Y
		STA	VRAMD+4+8,Y
		STA	VRAMD+4+16,Y
		STA	VRAMD+4+24,Y
		STA	VRAMD+4+32,Y
		STA	VRAMD+4+40,Y
		STA	VRAMD+4+48,Y
		LDA	#0FFFFH
		STA	VRAMD+2+(7*8),Y		;end code set		
;
		M8
;
		LDA	#030H		;(WKE,F) <-- "0" chara no. set !!
		STA	<WORKE
;
		LDA	#63		;number of result buffer set
		SEC
		SBC	<BGBFPT
		JSR	BGDSSB
;
		LDA	<CRXPSH1	;now X pos set
		JSR	BGDSSB
;
		LDA	<CRYPSH1	;now Y pos set
		JSR	BGDSSB
;
		LDA	<CRXPSL2	;cursol X pos set
		SEC
		SBC	#MPOFX
		BCS	DTDP240
		LDA	#00
DTDP240		EQU	$
		LSR	A
		LSR	A
		LSR	A
		CMP	#10H
		BCC	DTDP250
		LDA	#0FH
DTDP250		EQU	$
		JSR	BGDSSB
;
		LDA	<CRYPSL2	;cursol Y pos set
		SEC
		SBC	#MPOFY
		BCS	DTDP260
		LDA	#00
DTDP260		EQU	$
		LSR	A
		LSR	A
		LSR	A
		CMP	#08H
		BCC	DTDP270
		LDA	#07H
DTDP270		EQU	$
		JSR	BGDSSB
;
;--------------	decimal <- hex convert --------------------------
;
		M16
;
		LDA	<STDTPT		;number of byte set
		CLC
		ADC	#10
		STA	<WORK0		;(WK0,1) <-- hex data
;
		SED
;
		STZ	<WORK2		;(WK2,3) <-- decimal data
		LDA	#01H
		STA	<WORK4		;(WK4,5) <-- decimal change data
		LDX	#16
DTDP280		EQU	$
		LSR	<WORK0
		BCC	DTDP290
		LDA	<WORK4
		CLC
		ADC	<WORK2
		STA	<WORK2
DTDP290		EQU	$
		LDA	<WORK4
		CLC
		ADC	<WORK4
		STA	<WORK4
		DEX
		BNE	DTDP280		
;
		CLD
;
;----------------------------------------------------------------
;
		LDA	<WORK2
;
		M8
;
		JSR	BGDSSB
;
		LDA	#0FFH
		STA	<WORKE
;
		XBA
BGDSSB		EQU	$
		PHA
		LSR	A
		LSR	A
		LSR	A
		LSR	A
		TAX
		BNE	BGDSB010
		LDA	<WORKE
		BRA	BGDSB020
;
BGDSB010	EQU	$
		LDA	>PSCTDT1,X
BGDSB020	EQU	$
		STA	VRAMD+6,Y	;chara no. set
		PLA
		AND	#0FH
		BNE	BGDSB030
		CPX	#0
		BNE	BGDSB030	
		LDA	<WORKE
		BRA	BGDSB040
;
BGDSB030	EQU	$
		TAX
		LDA	>PSCTDT1,X
BGDSB040	EQU	$
		STA	VRAMD+8,Y	;	"
		LDA	#01CH
		STA	VRAMD+7,Y	;att set
		STA	VRAMD+9,Y	;   "
		TYA
		CLC
		ADC	#08H
		TAY
		STY	VRAMD		;next index set
		RTS
;
;
;
;
;
		MEM16
		IDX16
;
;************************************************************************
;*									*
;************************************************************************
;
;
       		END
