;************************************************************************
;*									*
;*	title name	: "yossy tool"					*
;*	proccess	: main process					*
;*	file name	: yst_main					*
;*									*
;************************************************************************
;
;
		SALL
;
		include		yst_header.inc
;
		XALL
;
;
;------------------------------------------------------------------------
;
;		Super_Y edit-tool		1992.03.05(THU)
;
;------------------------------------------------------------------------
;
		ORG	08000H
;
;=============================================== (bged_main) =============
		GLB	JSRSUB,JSRSUBL,OAMCLR,OAMCHG
		GLB	KYREAD
;=============================================== (bged_init) =============
		EXT	BGWTPL,ENWTPL,ENBGSLC
;=============================================== (bged_vma) ==============
		EXT	VMADSP,NEWVMAD,BGSCWT,OBJDMA
;========================================================================
;
		EXTEND
		MEM8
		IDX8
;
;************************************************************************
;*		SFX  Game  Start					*
;************************************************************************
;
;===============  System initialize 1  ==================================
;
		EMULATION
;
GSTART		EQU	$
		SEI			; IRQ disable
		STZ	4200H		; NMI	 "
		STZ	1E00H		; SFX-DOS
		STZ	420CH		; HDMA	 "
		STZ	420BH		; DMA	 "
		LDA	#10000000B
		STA	2100H		; branking on!!
		STZ	2106H		; mozaiku flag reset
		CLC
;------------------------------------------------------------------------
		NATIVE
;
		XCE			; Set Native mode
;
		MEM16
		IDX16
		REP	#00101000B	; memory,index 16bit mode & BCD mode off
;
		LDA	#00000H
		TCD			; direct register set (00~FF)
		LDA	#001FFH
		TCS			; stack pointer init. set
;
;===============  System initalize 2  ===================================
		MEM8
		IDX8
		SEP	#00110000B	; momory,index 8bit mode
;
		JSR	RAMCLR		; ram clear
;
		LDA	SAVECK0
		CMP	#35H
		BNE	GST010		;check sum ok ? ( no:GST010 )
		LDA	SAVECK1
		CMP	#53H
		BEQ	GST030		;	"       ( yes:GST030 )
;
;-------------- status data initial clear !! --------------------
GST010		EQU	$
		LDX	#SAVERMN-1
GST020		EQU	$
		STZ	SAVERM,X
		DEX
		BPL	GST020
		LDA	#35H
		STA	SAVECK0
		LDA	#53H
		STA	SAVECK1
;
GST030		EQU	$
;
		JSL	>OAMCLR		; oam clear
;
;-------------- NMI & IRQ type no. reset --------------------------------
;
		M16
;
		STZ	NMITYP
		STZ	IRQTYP
;
		M8
;
;-------------- tool reset initial set ----------------------------------
		STZ	<BGBFPT		;BG unit buffer pointer clear
;
		LDA	#0FFH		;corse data clear
		STA	>DTBUFF
		STA	<SRCHPT		;search point clear
		STA	<SRCHPT+1
		STA	<INSTPT		;insert	     "
		STA	<INSTPT+1
;
		LDA	#C_0		;BG type no. initial set
		STA	<INPBUF
		STA	<INPBUF+1
;
;------------------------------------------------------------------------
;-		game initial set					-
;------------------------------------------------------------------------
;
		MI16
;
		LDA	#0070H		;cursol pos set
		STA	<CRXPSL1
		STA	<CRXPSL2
		LDA	#0770H
		STA	<CRYPSL1
		STA	<CRYPSL2
;
		STZ	<SCCH1		;scroll counter set
		STZ	<SCCH2
		LDA	#0730H
		STA	<SCCV1
		STA	<SCCV2
;
		LDA	#0000
		LDX	#(200H*64)-2
INIT0000	EQU	$
		STA	>BGUNIT,X
		DEX
		DEX
		BPL	INIT0000
;
		MI8
;
		LDA	#00
		LDX	#16*8-1
INIT0010	EQU	$
		STA	>UNBUFAD,X
		DEX
		BPL	INIT0010
;
		MI8
;
;-------------- enmy data set bg buffer initial set -------------
		PHB
		LDA	#BANK ENBGDTBF
		PHA
		PLB
		MI16			; memory , index 16bit mode
		LDX	#01000H-2
INIT0020	EQU	$
		STZ	!ENBGDTBF+00000H,X
		STZ	!ENBGDTBF+01000H,X
		STZ	!ENBGDTBF+02000H,X
		STZ	!ENBGDTBF+03000H,X
		STZ	!ENBGDTBF+04000H,X
		STZ	!ENBGDTBF+05000H,X
		STZ	!ENBGDTBF+06000H,X
		STZ	!ENBGDTBF+07000H,X
		DEX
		DEX
		BPL	INIT0020
		MI8			; memory , index 8bit mode
		PLB
;
		LDA	#0FFH
		STA	>ENDTBF
		STA	>ENDTBF+1
;
;------------------------------------------------------------------------
		LDA	#10000000B	;blanking "ON" !!
		STA	<BLKFLG
		LDA	#10000001B	; ket bored dievble
		STA	4200H		; NMI enable
		STA	1E00H		; SFX-DOS
;
;************************************************************************
;*		SFX  Game	(Enmy)					*
;************************************************************************
GST040		EQU	$
		LDA	<NMIFLG
		BEQ	GST040		; V-blank NMI?
;					; yes
		CLI			; IRQ "on"
;
		INC	<FCNT		; frame count+1
;
		JSL	>OAMCLR		; OAM clear
;
		JSL	>ENBGSLC	; main program
;
		STZ	<NMIFLG		; NMI flag clear!!
		LDA	<ENBGFLG
		BMI	GST040
		CMP	#002H
		BEQ	GST100
;
;************************************************************************
;*		SFX  Game	(Enmy)					*
;************************************************************************
GST050		EQU	$
		LDA	<NMIFLG
		BEQ	GST050		; V-blank NMI?
;					; yes
		CLI			; IRQ "on"
;
		INC	<FCNT		; frame count+1
;
		JSL	>OAMCLR		; OAM clear
;
		JSL	>ENWTPL		; main program
;
		STZ	<NMIFLG		; NMI flag clear!!
		BRA	GST050
;
;************************************************************************
;*		SFX  Game						*
;************************************************************************
GST100		EQU	$
		LDA	<NMIFLG
		BEQ	GST100		; V-blank NMI?
;					; yes
		CLI			; IRQ "on"
;
		INC	<FCNT		; frame count+1
;
		JSL	>OAMCLR		; OAM clear
;
		JSL	>BGWTPL		; main program
;
;;;;;;;;		JSR	OAMCHG		; OAM sub. set
;
		STZ	<NMIFLG		; NMI flag clear!!
		BRA	GST100
;
;************************************************************************
;*		NMI  Routine				(INTSUB)	*
;************************************************************************
NMI000		EQU	$
		LDA	<NMIFLG
		BEQ	INT010		; NMI flag on?
		JMP	INT040
;					; no
INT010		EQU	$
		INC	<NMIFLG		; NMI flag on
;
;---------------  DMA  --------------------------------------------------
		JSR	BGSCWT		; BG scroll screen DMA
		JSR	VMADSP		; character DMA & VMA
		JSR	NEWVMAD		;	  "          ( farst type )
		JSR	OBJDMA		;OAM DMA
;
;---------------  Key data input  ---------------------------------------
		JSR	CONT2		; Key Read
;
;---------------  Scroll counter set  -----------------------------------
		LDA	<WIND23
		STA	2123H
		LDA	<WIND24
		STA	2124H
		LDA	<WIND25
		STA	2125H		; window on/off set
		LDA	<WIND30
		STA	2130H		; color window on/off set
		LDA	<SUBADF
		STA	2131H		; add.&sub. set
;
		LDA	!NUKCOL		;[ red ]
		AND	#00011111B
		ORA	#00100000B
		STA	002132H
;
		MEM16
		REP	#00100000B
;
		LDA	!NUKCOL		;[ green ]
		LSR	A
		LSR	A
;
		MEM8
		SEP	#00100000B
;
		LSR	A
		LSR	A
		LSR	A
		AND	#00011111B
		ORA	#01000000B
		STA	002132H
;
		LDA	!NUKCOL+1	;[ blue ]
		LSR	A
		LSR	A
		ORA	#10000000B
		STA	002132H
;
		LDA	<MANSEL
		STA	212CH		; display select main
		LDA	<SUBSEL
		STA	212DH		;		 sub
;
		LDA	<WMANSL
		STA	212EH		; window display main
		LDA	<WSUBSL
		STA	212FH		;		 sub
;
		LDA	<SCCH1
		STA	210DH
		LDA	<SCCH1+1
		STA	210DH		; SCCH1 set
		LDA	<SCCV1
		STA	210EH
		LDA	<SCCV1+1
		STA	210EH		; SCCV1 set
;
		LDA	<SCCH2
		STA	210FH
		LDA	<SCCH2+1
		STA	210FH		; SCCH2 set
		LDA	<SCCV2
		STA	2110H
		LDA	<SCCV2+1
		STA	2110H		; SCCV2 set
;
		LDA	<SCCH3
		STA	2111H
		LDA	<SCCH3+1
		STA	2111H		; SCCH3 set
		LDA	<SCCV3
		STA	2112H
		LDA	<SCCV3+1
		STA	2112H		; SCCV3 set
;
		LDA	<SCCH4
		STA	2113H
		LDA	<SCCH4+1
		STA	2113H		; SCCH3 set
		LDA	<SCCV4
		STA	2114H
		LDA	<SCCV4+1
		STA	2114H		; SCCV3 set
;
;---------------  Blanking check  ---------------------------------------
INT040		EQU	$
		RTS
;
;************************************************************************
;*		OAM clear				(OAMCLR)	*
;************************************************************************
OAMCLR		EQU	$
		LDX	#060H
OCL020		EQU	$
		LDA	#0F0H		; Ypos
		STA	!OAM+001H,X
		STA	!OAM+005H,X
		STA	!OAM+009H,X
		STA	!OAM+00DH,X
		STA	!OAM+011H,X
		STA	!OAM+015H,X
		STA	!OAM+019H,X
		STA	!OAM+01DH,X
		STA	!OAM+081H,X
		STA	!OAM+085H,X
		STA	!OAM+089H,X
		STA	!OAM+08DH,X
		STA	!OAM+091H,X
		STA	!OAM+095H,X
		STA	!OAM+099H,X
		STA	!OAM+09DH,X
		STA	!OAM+101H,X
		STA	!OAM+105H,X
		STA	!OAM+109H,X
		STA	!OAM+10DH,X
		STA	!OAM+111H,X
		STA	!OAM+115H,X
		STA	!OAM+119H,X
		STA	!OAM+11DH,X
		STA	!OAM+181H,X
		STA	!OAM+185H,X
		STA	!OAM+189H,X
		STA	!OAM+18DH,X
		STA	!OAM+191H,X
		STA	!OAM+195H,X
		STA	!OAM+199H,X
		STA	!OAM+19DH,X
		TXA
		SEC
		SBC	#020H
		TAX
		BPL	OCL020		; oam clear end ?
;					; yes
		RTL
;
;
;************************************************************************
;*		OAM change				(OAMCHG)	*
;************************************************************************
OAMCHG		EQU	$
		LDY	#01CH
OACG10		EQU	$
		TYA
		ASL	A
		ASL	A
		TAX
;
		LDA	!OAMSB+3,X
		ASL	A
		ASL	A
		ORA	!OAMSB+2,X
		ASL	A
		ASL	A
		ORA	!OAMSB+1,X
		ASL	A
		ASL	A
		ORA	!OAMSB+0,X
		STA	!OAMSUB+0,Y
;
		LDA	!OAMSB+7,X
		ASL	A
		ASL	A
		ORA	!OAMSB+6,X
		ASL	A
		ASL	A
		ORA	!OAMSB+5,X
		ASL	A
		ASL	A
		ORA	!OAMSB+4,X
		STA	!OAMSUB+1,Y
;
		LDA	!OAMSB+11,X
		ASL	A
		ASL	A
		ORA	!OAMSB+10,X
		ASL	A
		ASL	A
		ORA	!OAMSB+9,X
		ASL	A
		ASL	A
		ORA	!OAMSB+8,X
		STA	!OAMSUB+2,Y
;
		LDA	!OAMSB+15,X
		ASL	A
		ASL	A
		ORA	!OAMSB+14,X
		ASL	A
		ASL	A
		ORA	!OAMSB+13,X
		ASL	A
		ASL	A
		ORA	!OAMSB+12,X
		STA	!OAMSUB+3,Y
;
		DEY
		DEY
		DEY
		DEY
		BPL	OACG10		; set end ?
;					; yes
		RTL
;
;
;
;************************************************************************
;*		Subroutine index call			(JSRSUB)	*
;************************************************************************
JSRSUB		EQU	$
		STY	<WORK3		; (Y) push
;
		PLY
		STY	<WORK0
;
		MEM16
		IDX16
		REP	#00110000B	; memory,index 16bit mode
;
		AND	#000FFH
		ASL	A
		TAY
		PLA
		STA	<WORK1
;
		INY
		LDA	[<WORK0],Y
		STA	<WORK0
;
		MEM8
		IDX8
		SEP	#00110000B	; memory,index 8bit mode
;
		LDY	<WORK3		; (Y) pull
		JML	(!WORK0)
;
;
;************************************************************************
;*		Long Subroutine index call		(JSRSUBL)	*
;************************************************************************
JSRSUBL		EQU	$
		STY	<WORK5		; (Y) push
;
		PLY
		STY	<WORK2
;
		MEM16
		IDX16
		REP	#00110000B	; memory,index 16bit mode
;
		AND	#000FFH
		STA	<WORK3		; A*3
		ASL	A
		ADC	<WORK3
		TAY
		PLA
		STA	<WORK3
;
		INY
		LDA	[<WORK2],Y
		STA	<WORK0
;
		INY
		LDA	[<WORK2],Y
		STA	<WORK1
;
		MEM8
		IDX8
		SEP	#00110000B	; memory,index 8bit mode
;
		LDY	<WORK5		; (Y) pull
		JML	(!WORK0)
;
;
;
;************************************************************************
;*		RAM clear				(RAMCLR)	*
;************************************************************************
RAMCLR		EQU	$
		IDX16
		MEM16
		REP	#00110000B
;
		LDX	#01DFEH
RMR050		EQU	$
		STZ	<WORK,X
		CPX	#0200H
		BNE	RMR060
		LDX	#0100H
RMR060		EQU	$
		DEX
		DEX
		BPL	RMR050		; ram clear end ?
;					; yes
		LDA	#0FFFFH		;VRAMD end code set
		STA	VRAMD+2
		LDA	#VRAMDX+2	;VRAMDX end code set
		STA	VRAMDX
;
		IDX8
		MEM8
		SEP	#00110000B	; memory,index 8bit mode
;
		LDA	#10000000B
		STA	<BLKFLG		; blanking flag set
		RTS
;
;
;
;
;************************************************************************
;*		Key Read  &  Mouse Read			(CONT2)		*
;************************************************************************
CONT2		EQU	$
		LDA	04212H
		LSR	A
		BCS	CONT2		; key read ok ?
;					; yes
		MEM16
		IDX16
		REP	#00110000B	; memory,index 16bit mode
;
		LDA	04218H		; 1P CONTROLLER
		TAY
		AND	#0000FH
		CMP	#00001H
		BNE	MOUSE100	; mouse on ?
;					; yes
		MEM8
		IDX8
		SEP	#00110000B	; memory,index 8bit mode
;
		STY	<MOUSEAS
		TYA
		EOR	<MOUSEAB
		AND	<MOUSEAS
		STA	<MOUSEAT
		STY	<MOUSEAB	; key set
;
		LDY	#00FH		; X Y SET
MOUSE20		EQU	$
		LDA	04016H
		LSR	A
		ROL	<MOUSEAX
		ROL	<MOUSEAY
		DEY
		BPL	MOUSE20		; mouse data read end ?
;					; yes
		LDA	<MOUSEAX
		BPL	MOUSE40		; X(-) move ?
;					; yes
		EOR	#0FFH
		INC	A
		EOR	#080H
		STA	<MOUSEAX
MOUSE40		EQU	$
		LDA	<MOUSEAY
		BPL	MOUSE70		; Y(-) move ?
;					; yes
		EOR	#0FFH
		INC	A
		EOR	#080H
		STA	<MOUSEAY
MOUSE70		EQU	$
		LDA	<MOUSEAS
		LSR	A
		LSR	A
		LSR	A
		LSR	A
		AND	#003H
		CMP	<MOUSESPA
		BEQ	MOUSE80		; speed change ?
;					; yes
		LDY	#000H
		JSR	MOUSE_SP
MOUSE80		EQU	$
		MEM16
		IDX16
		REP	#00110000B	; memory,index 16bit mode
;
		STZ	<KEYA1L
		STZ	<KEYA2L
		STZ	<KEYABFL
		BRA	MOUSE200
;
MOUSE100	EQU	$
		STY	<KEYA1L
		TYA
		EOR	<KEYABFL
		AND	<KEYA1L
		STA	<KEYA2L
		STY	<KEYABFL	; joy-controller set
		STZ	<MOUSEAS	; MOUSE CLR
		STZ	<MOUSEAX	; MOUSE CLR
		STZ	<MOUSEAT	; MOUSE CLR
;
;
MOUSE200	EQU	$
		LDA	0421AH		; 2P CONTROLLER
		TAY
		AND	#0000FH
		CMP	#00001H
		BNE	MOUSE300	; mouse on ?
;					; yes
		MEM8
		IDX8
		SEP	#00110000B	; memory,index 8bit mode
;
		STY	<MOUSEBS	;KEY SET
		TYA
		EOR	<MOUSEBB
		AND	<MOUSEBS
		STA	<MOUSEBT
		STY	<MOUSEBB
;
		LDY	#00FH		;X Y SET
MOUSE220	EQU	$
		LDA	04017H
		LSR	A
		ROL	<MOUSEBX
		ROL	<MOUSEBY
		DEY
		BPL	MOUSE220	; mouse data read end ?
;					; yes
		LDA	<MOUSEBX
		BPL	MOUSE240	; X(-) ?
;					; yes
		EOR	#0FFH
		INC	A
		EOR	#080H
		STA	<MOUSEBX
MOUSE240	EQU	$
		LDA	<MOUSEBY
		BPL	MOUSE260	; Y(-) ?
;					; yes
		EOR	#0FFH
		INC	A
		EOR	#080H
		STA	<MOUSEBY
MOUSE260	EQU	$
		LDA	<MOUSEBS
		LSR	A
		LSR	A
		LSR	A
		LSR	A
		AND	#003H
		CMP	<MOUSESPB
		BEQ	MOUSE280	; speed change ?
;					; yes
		LDY	#001H
		JSR	MOUSE_SP
MOUSE280	EQU	$
		MEM16
		IDX16
		REP	#00110000B
;
		STZ	<KEYB1L
		STZ	<KEYB2L
		STZ	<KEYBBFL	; joy-controller clear
		SEP	#00110000B
		RTS
;
MOUSE300	EQU	$
		STY	<KEYB1L
		TYA
		EOR	<KEYBBFL
		AND	<KEYB1L
		STA	<KEYB2L
		STY	<KEYBBFL	; joy-controller set
		STZ	<MOUSEBS	;MOUSE CLR
		STZ	<MOUSEBX	;MOUSE CLR
		STZ	<MOUSEBT	;MOUSE CLR
;
		MEM8
		IDX8
		SEP	#00110000B
		RTS
;
;
;
MOUSE_SP	EQU	$			;SPEED CHNG.
		LDA	#001H
		STA	04016H
		LDA	04016H,Y
		STZ	04016H
;
		LDA	#001H
		STA	04016H
		STZ	04016H
;
		LDX	#010
MUE_SP10	EQU	$
		LDA	04016H,Y
		DEX
		BNE	MUE_SP10
;
		LDA	04016H,Y
		XBA
		LDA	04016H,Y
		LSR	A
		XBA
		ROL	A
		AND	#003H
		CMP	MOUSESPA,Y
		BNE	MOUSE_SP
;
		RTS
;
;
;
;
;
;
; <<<<<	 key input data table  >>>>>
ASKYBD1		EQU	$
;			  0   1	  2   3	  4   5	  6   7	  8   9	  A   B	  C   D	  E   F
		BYTE	NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,RTN,NUL,NUL ; 0
		BYTE	NUL,NUL,NUL,UPS,DWS,NUL,NUL,NUL,NUL,NUL,NUL,ESC,NUL,NUL,NUL,NUL ; 1
		BYTE	SPS,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL ; 2
		BYTE	SU0,SU1,SU2,SU3,SU4,SU5,SU6,SU7,SU8,SU9,NUL,NUL,NUL,NUL,NUL,NUL ; 3
		BYTE	NUL,L_A,L_B,L_C,L_D,L_E,L_F,L_G,L_H,L_I,L_J,L_K,L_L,L_M,L_N,L_O ; 4
		BYTE	L_P,L_Q,L_R,L_S,L_T,L_U,L_V,L_W,L_X,L_Y,L_Z,NUL,NUL,NUL,NUL,NUL ; 5
		BYTE	NUL,L_A,L_B,L_C,L_D,L_E,L_F,L_G,L_H,L_I,L_J,L_K,L_L,L_M,L_N,L_O ; 6
		BYTE	L_P,L_Q,L_R,L_S,L_T,L_U,L_V,L_W,L_X,L_Y,L_Z,NUL,NUL,NUL,NUL,NUL ; 7
		BYTE	NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL ; 8
		BYTE	NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL ; 9
		BYTE	NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL ; A
		BYTE	NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL ; B
		BYTE	NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL ; C
		BYTE	NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL ; D
		BYTE	NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL ; E
		BYTE	F_1,F_2,F_3,F_4,F_5,F_6,F_7,F_8,F_9,F_0,NUL,NUL,NUL,NUL,NUL,NUL ; F
;
ASKYBD2		EQU	$
;			  0   1	  2   3	  4   5	  6   7	  8   9	  A   B	  C   D	  E   F
		BYTE	NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,TAB,NUL,NUL,NUL,RTN,NUL,NUL ; 0
		BYTE	NUL,NUL,NUL,UPS,DWS,NUL,NUL,NUL,NUL,NUL,NUL,NUL,RIT,LEF,UPP,DWN ; 1
		BYTE	SPS,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL ; 2
		BYTE	NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL ; 3
		BYTE	NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL ; 4
		BYTE	NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL ; 5
		BYTE	NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL ; 6
		BYTE	NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL ; 7
		BYTE	NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL ; 8
		BYTE	NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL ; 9
		BYTE	NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL ; A
		BYTE	NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL ; B
		BYTE	NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL ; C
		BYTE	NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL ; D
		BYTE	NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL ; E
		BYTE	F_1,F_2,F_3,F_4,F_5,F_6,F_7,F_8,F_9,F_0,NUL,NUL,NUL,NUL,NUL,NUL ; F
;
ASKYBD3		EQU	$
;			  0   1	  2   3	  4   5	  6   7	  8   9	  A   B	  C   D	  E   F
		BYTE	NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,RTN,NUL,NUL ; 0
		BYTE	NUL,NUL,NUL,UPS,DWS,NUL,NUL,NUL,NUL,NUL,NUL,ESC,NUL,NUL,NUL,NUL ; 1
		BYTE	SPS,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,L_c,L_h,L_p,L_s ; 2
		BYTE	SU0,SU1,SU2,SU3,SU4,SU5,SU6,SU7,SU8,SU9,NUL,NUL,NUL,L_e,NUL,NUL ; 3
		BYTE	NUL,L_A,L_B,L_C,L_D,L_E,L_F,L_G,L_H,L_I,L_J,L_K,L_L,L_M,L_N,L_O ; 4
		BYTE	L_P,L_Q,L_R,L_S,L_T,L_U,L_V,L_W,L_X,L_Y,L_Z,NUL,NUL,NUL,NUL,L_u ; 5
		BYTE	NUL,L_A,L_B,L_C,L_D,L_E,L_F,L_G,L_H,L_I,L_J,L_K,L_L,L_M,L_N,L_O ; 6
		BYTE	L_P,L_Q,L_R,L_S,L_T,L_U,L_V,L_W,L_X,L_Y,L_Z,NUL,NUL,NUL,NUL,NUL ; 7
		BYTE	NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL ; 8
		BYTE	NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL ; 9
		BYTE	NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL ; A
		BYTE	NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL ; B
		BYTE	NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL ; C
		BYTE	NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL ; D
		BYTE	NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL ; E
		BYTE	F_1,F_2,F_3,F_4,F_5,F_6,F_7,F_8,F_9,F_0,NUL,NUL,NUL,NUL,NUL,NUL ; F
;
;;;;;;;
;
;
;
;***********************************************************
;*							   *
;*	 key input data pop				   *
;*							   *
;***********************************************************
KYREAD		EQU	$
		LDA	#NUL
		STA	<INKEY
		STA	<INKEY2
		STA	<INKEY3		; key [NUL] set
;
		DOS	_CONSNS
		CMP	#000H
		BEQ	KYRD080		; Key-board key on ?
;					; yes
		DOS	_CONIN		; Key-board key-check
		TAX
		LDA	ASKYBD1,X
		STA	<INKEY
;
		LDA	ASKYBD2,X
		STA	<INKEY2
;
		LDA	ASKYBD3,X
		STA	<INKEY3
KYRD080		EQU	$
		RTL
;
;
;
;
;
;************************************************************************
;*		NMI							*
;************************************************************************
;
NMISUB		EQU	$
		SEI
;
		MEM16
		IDX16
		REP	#00111000B
;
		PHA
		PHX
		PHY
		PHD
		PHB
;
		LDA	#0000H
		TCD		;(D) <-- 0
		PHK		;(DBR) <-- (PBR)
		PLB
;
		MI8
;
		LDY	4210H
;
		LDY	#10000000B	;blanking "ON"
		STY	2100H
		STZ	420CH		;H-DMA "OFF"
;
		LDX	NMITYP
		JSR	(NMISEL,X)
;
		LDA	<BLKFLG		;blanking "OFF"
		STA	2100H
		LDA	<HD420C		;H-DMA set
		STA	420CH
;
		MI16
;
		PLB
		PLD
		PLY
		PLX
		PLA
;
RTISUB		EQU	$
		RTI
;
		MEM8
		IDX8
;
;-------------- NMI program address table -----------------------
NMISEL		EQU	$&(00FFFFH)|(7E0000H)	;[NMITYP]
		WORD	NMI000			;[0]  normal
		WORD	NMI100			;[2]  game( normal )
		WORD	NMI200			;[4]  game( offset )
;
;
;************************************************************************
;*		NMI ( game( normal ) )					*
;************************************************************************
;
NMI100		EQU	$
NMI200		EQU	$
		LDA	<NMIFLG
		BEQ	NMI1010		;timer over ? ( no:NMI1010 )
		JMP	NMI1020
;
NMI1010		EQU	$
		INC	<NMIFLG		; NMI flag on
;
;-------------- BG3 scroll counter set --------------------------
		LDA	<SCCH3		;BG3 scroll counter set
		STA	2111H
		LDA	<SCCH3+1
		STA	2111H
		LDA	<SCCV3
		STA	2112H
		LDA	<SCCV3+1
		STA	2112H
;
;-------------- DMA set -----------------------------------------
NMIGMSB		EQU	$
		JSR	NEWVMAD		;BG write
		JSR	VMADSP		;BG WRITE
		JSR	OBJDMA		;OBJ DMA set
;;;;		JSR	PCHDMA		;player chara DMA set
;;;;		JSR	BGCDMA		;BG chara DMA set
		JSR	BGSCWT		;BG screen write
;;;;		JSR	OB7DMA		;OBJ mode 7 chara DMA set
;;;;		JSR	MEDA_DMA
;
;-------------- joy-controller read -----------------------------
		JSR	CONT2		;controller read
;
;-------------- PPU Reg. set ------------------------------------
		LDA	WIND23		;window "ON/OFF" set
		STA	2123H
		LDA	WIND24
		STA	2124H
		LDA	WIND25
		STA	2125H
		LDA	WIND30		;color window "ON/OFF" set
		STA	2130H
		LDA	SUBADF		;main & sub add set
		STA	2131H
;
		LDA	BG2SCF		;BG2 screen base address set
		STA	2108H
		LDA	BG3SCF		;BG3	      "
		STA	2109H
;
;;;;		LDA	MOZNO		;mozaiku set
;;;;		STA	2106H
;
;-------------- scroll counter set ------------------------------
;
		M16
;
		LDA	<SCCH1		;work BG1 scroll counter set
		STA	WSCCH1
		LDA	<SCCV1
		STA	WSCCV1
;
		M8
;
		LDA	<SCCH2		;BG2 scroll counter set
		STA	210FH
		LDA	<SCCH2+1
		STA	210FH
		LDA	<SCCV2
		STA	2110H
		LDA	<SCCV2+1
		STA	2110H
;
;-------------- V part scroll IRQ timer set ---------------------
NMI1020		EQU	$
		LDA	#026H		;V timer set
		STA	4209H
		STZ	490AH
		LDA	#10100001B	;timer IRQ "ON"
		STA	4200H
		STA	1E00H
;
		LDA	#01H		;mater main select set
		STA	212CH
		STZ	212DH		;  "   sub      "
		LDA	#06H
		STA	210BH		;BG1 character base address set ( 6000H- )
		STA	210CH		;BG3		 "
		LDA	#078H		;BG1 screen base address set ( 7800H- )
		STA	2107H
		LDA	#01H		;BG mode set ( mode 1 )
		STA	2105H
		STZ	210DH		;BG1 scroll counter set
		STZ	210DH
		STZ	210EH
		STZ	210EH
		RTS
;
;************************************************************************
;*		IRQ							*
;************************************************************************
IRQSUB		EQU	$
		SEI
;
		MEM16
		IDX16
		REP	#00111000B
;
		PHA
		PHX
		PHY
		PHD
		PHB
;
		LDA	#0000H
		TCD		;(D) <-- 0
		PHK		;(DBR) <-- *PBR)
		PLB
;
		MI8
;
		LDA	4211H
;
		LDX	IRQTYP
		JSR	(IRQSEL,X)
;
RTISET		EQU	$
;
		MI16
;
		PLB
		PLD
		PLY
		PLX
		PLA
;
		CLI
		RTI
;
		MEM8
		IDX8
;
;-------------- IRQ program address table -----------------------
IRQSEL		EQU	$&(00FFFFH)|(7E0000H)	;[IRQTYP]
		WORD	IRQ000			;[0] game( normal )
		WORD	IRQ100			;[2] game( offset )
;
;
;************************************************************************
;*		IRQ ( game( normal ) )					*
;************************************************************************
;
IRQ000		EQU	$
IRQ100		EQU	$
		LDA	2137H
		LDA	213FH
		LDA	213DH
		CMP	#027H
		BCC	IRQ000		;V pos ok ? ( no:IRQ000 )
IRQ002		EQU	$
		BIT	4212H
		BVC	IRQ002		;now H blank ? ( no:IRQ002 )
		STZ	2100H		;not display set
;
;-------------- meter IRQ set -----------------------------------
		LDA	WSCCV1		;BG1 scroll counter_V set
		STA	210EH
		LDA	WSCCV1+1
		STA	210EH
;
IRQGMSB		EQU	$
		LDA	MANSEL		;main select set
		STA	212CH
		LDA	SUBSEL		;sub	  "
		STA	212DH
		LDA	BG12CH		;BG1,2 character base address set
		STA	210BH
		LDA	BG1SCF		;BG1 screen base address set
		STA	2107H
		LDA	BGMODE		;BG mode set
		STA	2105H
		LDA	WSCCH1		;BG1 scroll counter_H set
		STA	210DH
		LDA	WSCCH1+1
		STA	210DH
;
IRQ010		EQU	$
		BIT	4212H
		BVC	IRQ010		;now H blank ? ( no:IRQ010 )
		LDA	<BLKFLG
		STA	2100H		;display set
		RTS
;
;
;
;
;
;************************************************************************
;*		VECTOR							*
;************************************************************************
		ORG	0DFF6H
;
		WORD	RTISUB		;Break
		WORD	RTISUB		;About
		WORD	NMISUB		;NMI
		WORD	GSTART		;Reset
		WORD	IRQSUB		;IRQ
;
;
;
		END

