;************************************************************************
;*									*
;*	title name	: "yossy tool"					*
;*	proccess	: VRAM set process				*
;*	file name	: yst_vma					*
;*									*
;************************************************************************
;
;
		SALL
;
		include		yst_header.inc
;
		XALL
;
;
;--------------------------------------------------------------------
;
;		Super_Y edit-tool		1992.03.05(THU)
;
;--------------------------------------------------------------------
;
		ORG	09000H
;
;=============================================== (gbz_vma) ==============
		GLB	VMADSP,NEWVMAD,VRAMCL,BGSCWT,BGSCWTL,OBJDMA
;
		GLB	VTCL
;=============================================== (gbz_init) =============
		EXT	BGSCWTL1
;========================================================================
;
		EXTEND
		MEM8
		IDX8
;
;
;************************************************************************
;*		VMA					(VMADSP)	*
;************************************************************************
VTABLE		EQU	$
VTB00		LWORD	VRAMD+2
VTB01		LWORD	VCLDAT
;
VTCL		EQU	VTB01-VTABLE
;
VMADSPL		EQU	$
		PHB
		PHK
		PLB
;
		JSR	VMADSP
;
		PLB
		RTL
;
VMADSP		EQU	$
;
		I16
;
		LDY	VRFLG
		LDX	VTABLE,Y	;BG data address(L) set
		LDA	VTABLE+2,Y	;	"       (B) set
		JSR	VRAMTR		;VRAM write
;
		IDX8
;
		LDA	VRFLG
		BNE	VMD010		;VRAMD write ? ( no:VMD010 )
;
		STA	>VRAMD
		STA	>VRAMD+1
		DEC	A		;[ LDA	#0FFFFH ]
		STA	>VRAMD+3
VMD010		EQU	$
		STZ	VRFLG
		RTS
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		JSR	NEWVMAD ( new VMADSP sub )			x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
VRFLDAT		EQU	$
VRTB00		LWORD	VRAMDX
;
NEWVMADL	EQU	$
		PHB			;(DBR) save
		PHK
		PLB
;
		JSR	NEWVMAD
;
		PLB
		RTL
;
NEWVMAD		EQU	$
		I16
;
		LDY	VRFLG2
		LDX	!VRFLDAT,Y	;BG data address(L) set
		LDA	!VRFLDAT+2,Y	;	"       (B) set
		PHB
		PHA
		PLB
		STA	<WORK0
;
		M16
;
		LDA	0,X
		STA	<WORK4		; end address set
		CMP	#VRAMDX+2
		BEQ	NVD150
		INX
		INX
;
NVD100		EQU	$
		LDA	0,X
		STA	>2116H
;
		LDA	4,X
		STA	>4301H
;
		LDA	6,X
		STA	>4303H
;
		LDA	8,X
		STA	>4305H
;
		LDA	2,X
;
		M8
;
		STA	>2115H
		XBA
		STA	>4300H
;
		LDA	#00000001B
		STA	>420BH
;
		M16
;
		LDA	10,X
		TAX
		CMP	<WORK4
		BNE	NVD100		; end ?
;					; Yes!
		LDA	>VRFLG2
		BNE	NVD150
;
		LDA	#VRAMDX+2
		STA	VRAMDX		; end code set
;
NVD150		EQU	$
		PLB
		STZ	VRFLG2
;
		MI8
;
		RTS
;
;****************************************************************
;*	vram transfer sub					*
;*		in  : (X) <-- data address(L,H)			*
;*		      (A) <--	    "     (B)                   *
;****************************************************************
;
		IDX16
;
VRAMTR		EQU		$
		PHB				;(DBR) save
		PHA				;(DBR) <-- data bank
		PLB
		STA		<WORK		;(WK0) <-- data address(B)
;
		MEM16
		REP		#00100000B
;
VTR010		EQU		$
		LDY		0000,X
		BPL		VTR020		;end ? ( no:VTR020 )
;
;------ end return ------------------------------
		SEP		#00110000B	;memory,index 8 bit mode set
		PLB
		RTS
;
VTR020		EQU		$
		LDA		0002,X		;number 0f byte set
		AND		#01FFFH
		INC		A
		STA		<WORK+1		;(WK1,2) <-- number of byte
		STA		<WORK+3		;(WK3,4) <-- data index up add data
;
		LDA		#10000000B
		BIT		0002,X
		BPL		VTR030		;tate ? ( no:VTR030 )
;------ tate write set --------------------------
		LDA		#10000001B
VTR030		EQU		$
		STA		>2115H		;inc mode set
		STA		<WORK+5		;(WK5,6) <-- inc mode
		TYA
		STA		>2116H		;VRAM address set
;
		LDA		0002,X
		AND		#0010000000000000B
		BEQ		VTR040		;VRAM read ? ( no:VTR040 )
;------ VRAM read -------------------------------
		LDA		#0003H		;(WK3,4) <-- data index up add data
		STA		<WORK+3
		LDA		0004,X		;A bus address(L,H) set
		STA		>4302H
		LDA		0005,X		;      "      (B) set
		STA		>4303H
		LDA		>2139H		;read intial
		LDA		#10000001B+(39H*100H)
		BRA		VTR060
;
VTR040		EQU	$
		LDA		<WORK		;A bus address(B) set
		STA		>4304H
		LDY		#00000001B+(18H*100H)
		BVC		VTR050		;= data set ? ( no:VTR050 )
;------ = data set ------------------------------
		LSR		<WORK+1		;(number of byte)/2
		LDA		#0002H		;(WK3,4) <-- data index up add data
		STA		<WORK+3
		LDA		#00001000B+(19H*100H)	;control parameter & B bus address set
		STA		>4300H
		TXA				;A bus address(L,H) set
		CLC
		ADC		#0005H
		STA		>4302H
		LDA		<WORK+1		;number of byte set
		STA		>4305H
		LDA		#00000001B*100H ;DMA start
		STA		>420AH		;[ 420AH dummy ]
		LDA		<WORK+5
		AND		#01111111B
		STA		>2115H		;inc mode set
		LDA		0000,X
		STA		>2116H		;VRAM address set
		LDY		#00001000B+(18H*100H)
VTR050		EQU		$
		TXA				;A bus address(L,H) set
		CLC
		ADC		#0004H
		STA		>4302H
		TYA
VTR060		EQU		$
		STA		>4300H		;control parameter & B bus address set
		LDA		<WORK+1		;number of byte set
		STA		>4305H
		LDA		#00000001B*100H ;DMA start
		STA		>420AH		;[ 420AH dummy ]
		TXA
		CLC
		ADC		#0004H		;[ not (C)=1 !! if (C)=1 then error data !! ]
		ADC		<WORK+3
		TAX
		JMP		VTR010
;
		MEM8
		IDX8
;
;************************************************************************
;*		VRAM clear				(VRAMCL)	*
;************************************************************************
NUK		EQU	0020H
VCLDAT		EQU	$
		WORD	7400H,4000H+800H-1
		WORD	NUK
		WORD	7800H,4000H+800H-1
		WORD	NUK
		WORD	7E00H,4000H+800H-1
		WORD	NUK
		WORD	0FFFFH
;
VRAMCL		EQU	$
		LDA	#10000000B
		STA	<BLKFLG
		STA	2100H		; blanking on
		STZ	420CH		; H-DMA disable
;
		STZ	4200H
		STZ	1E00H
;
		STZ	NMITYP		;NMI type no. set
;
		LDA	#10000001B
		STA	4200H
		STA	1E00H
;
		DOS	_DOSRST
;
		LDA	#VTCL
		STA	<VRFLG
		JSL	>VMADSPL
		RTL
;
;************************************************************************
;*		JSL type BG screen write sub				*
;************************************************************************
;
BGSCWTL		EQU	$
		JSR	BGSCWT
		RTL
;
;************************************************************************
;*		BG screen write						*
;*			in  : (X) <-- DMA "ON" flag			*
;************************************************************************
;
BGSCWT		EQU	$
;
		M16
;
		LDA	#00000001B+(18H*100H)	;DMA parameter & B bus address set
		STA	4300H
		LDX	#00000001B	;(X) <-- DMA "ON" flag
;
		LDY	#BANK BGHSCRBF	;A bus address(B) set
		STY	4304H
;
		LDY	BGWHF1
		BEQ	BGSW10		;BG H write ? ( no:BGSW10 )
;
		LDY	#10000001B	;inc mode set
		STY	2115H
		LDA	#BGHSCRBF	;A bus address(L,H) set
		STA	4302H
;
		LDA	BGWAH1_0	;VRAM address set
		STA	2116H
		LDA	#20H*2		;number of byte set
		STA	4305H
		STX	420BH		;DMA "ON"
;
		LDA	BGWAH1_1	;VRAM address set
		STA	2116H
		LDA	#20H*2		;number of byte set
		STA	4305H
		STX	420BH		;DMA "ON"
;
		STZ	BGWHF1		;BG write end set
BGSW10		EQU	$
		LDY	BGWVF1
		BEQ	BGSW20		;BG V write ? ( no:BGSW20 )
;
		LDY	#10000000B	;inc mode set
		STY	2115H
		LDA	#BGVSCRBF	;A bus address(L,H) set
		STA	4302H
;
		LDA	BGWAV1_00	;VRAM address set
		STA	2116H
		LDA	BGWNO1_0	;number of byte set
		STA	4305H
		STX	420BH		;DMA "ON"
		LDA	BGWAV1_10	;VRAM address set
		STA	2116H
		LDA	BGWNO1_1	;number of byte set
		STA	4305H
		STX	420BH		;DMA "ON"
;
		LDA	BGWAV1_01	;VRAM address set
		STA	2116H
		LDA	BGWNO1_0	;number of byte set
		STA	4305H
		STX	420BH		;DMA "ON"
		LDA	BGWAV1_11	;VRAM address set
		STA	2116H
		LDA	BGWNO1_1	;number of byte set
		STA	4305H
		STX	420BH		;DMA "ON"
;
		STZ	BGWVF1		;BG write end set
;
;-------------- enemy data BG write -------------------------------------
BGSW20		EQU	$
		LDA	#00000001B+(18H*100H)	; DMA parameter & B bus address set
		STA	4300H
		LDY	#BANK B2ENWTH
		STY	4304H		; A bus address(B) set
;
		LDY	<B2WTHF		; BG2 write flag ON ?
		BEQ	BGSW30		;	NO -> BGSW30
		LDY	#10000001B	; inc mode set
		STY	2115H
		LDA	#B2ENWTH
		STA	4302H		; A bus address(L,H) set
		LDA	!B2WTADH
		STA	2116H		; VRAM address set
		LDA	#00040H
		STA	4305H		; number of byte set
		STX	420BH		; DMA "ON"
		STZ	<B2WTHF
;
BGSW30		EQU	$
		LDY	<B2WTVF
		BEQ	BGSW40
		LDY	#10000000B	; inc mode set
		STY	2115H
		LDA	#B2ENWTV
		STA	4302H		; A bus address(L,H) set
		LDA	!B2WTADV
		STA	2116H		; VRAM address set
		LDA	#00040H
		STA	4305H		; number of byte set
		STX	420BH		; DMA "ON"
		STZ	<B2WTVF
;
BGSW40		EQU	$
;
		M8
;
		RTS
;
;****************************************************************
;*		OAM DMA						*
;****************************************************************
OBJDMA		EQU	$
;
		M16
;
		STZ	2102H		; OAM address set
		LDA	#00400H
		STA	4300H		; B bus addess & control paramater
		LDA	#OAM
		STA	4302H		; A bus address (L,H)
		STZ	4304H		;		(B)
		LDA	#00220H
		STA	4305H		; OBJ_DMA paramater set
;
		M8
;
		LDA	#00000001B
		STA	420BH		; DMA ch "ON"
		RTS
;
;
;
;
;
;
		END

