;************************************************************************
;*	Super Famicom Disk Operation Sysytem  CCP main routine		*
;*		    Programmed by Y.Nishida				*
;*						[ Aug.26, 1991 ]	*
;************************************************************************

		native
		extend

		include		PPUregs.h
		include		CPUregs.h
		include		doscall.h

CCP_main	sect		rel
BANK0		group		CCP_main

		dpage		0000H
		dbank		0000H

;=============== Cross Reference ========================================

		extern		CON_Driver

;=============== Define Variable ========================================

work0		equ		0000H
work1		equ		0002H
work2		equ		0004H
work3		equ		0006H
;------------------------------------------------------------------------
dividend	equ		0010H
divisor		equ		0014H
rest		equ		0016H
divide		equ		0010H
;------------------------------------------------------------------------
stick_status_1	equ		0020H
stick_backst_1	equ		0022H
stick_trigger_1	equ		0024H
stick_status_2	equ		0026H
stick_backst_2	equ		0028H
stick_trigger_2	equ		002AH
NMI_flag	equ		002CH
;------------------------------------------------------------------------
current_drive	equ		0080H			;  1 byte	: Current drive
select_drive	equ		0081H			;  1 byte	; Select drive

delimitor	equ		00DEH			;  1 byte	: token delimit character
token_pointer	equ		00DFH			;  1 byte	: get token pointer
string_buffer	equ		00C0H			; 64 bytes	: String buffer
;------------------------------------------------------------------------
NMI_switch	equ		1E00H			;  1 byte
Line_buffer	equ		1EC0H			; 64 bytes	: Input buffer
directory_entry	equ		1EC0H			; 32 bytes	: directory entry
access_fname	equ		1EE0H			; 32 bytes	: Access file name buffer

;-------------- iwa test ------------------------------------------------
txt_buffer	equ		1000H			;text data buffer
asc_buffer	equ		1200H			;ascll data buffer
asc_count	equ		1A00H			;charcter counter
lin_count	equ		1A02H			;line counter
cg_dat		equ		1A04H			;character color No.
nwork0		equ		1B02H			;work
nwork1		equ		1B04H			;
nwork2		equ		1B06H			;
nwork3		equ		1B08H			;
nwork4		equ		1B0AH			;
nwork5		equ		1B0CH			;
nwork6		equ		1B0EH			;

;************************************************************************
;*	CCP Entry							*
;*									*
;************************************************************************

		mem8
		idx8
CCP_Entry
		stz		<current_drive
		DOS		_TXTRST
;------------------------------------------------------------------------
		lda		#10000001B
		sta		NMI_switch
		sta		Int_control		; Enable NMI
		cli
		mem16
		rep		#00100000B		; Memory 16 bit mode
		lda		#Boot_message
		DOS		_PRINT

;------------------------------------------------------------------------
		sep		#00110000B
		ldx		#0
Repeat$		lda		Test_data,x
		beq		CCP_main
		DOS		_AUXOUT
		inx
		bra		Repeat$

Test_data	ascii		'RS232C Test'
		byte		0

;************************************************************************
;*	CCP main routine						*
;*									*
;************************************************************************

		mem16
		idx8
CCP_main
		rep		#00100000B		; Memory 16 bit mode
		lda		#01FFH
		tcs
		mem8
		sep		#00110001B		; Memory,Index 8 bit mode
		lda		#'@'
		adc		<current_drive
		DOS		_CONOUT
		lda		#'>'
		DOS		_CONOUT
;------------------------------------------------------------------------
		DOS		_INPUT
		lda		#0AH
		DOS		_CONOUT
;------------------------------------------------------------------------
		lda		Line_buffer
		beq		CCP_main

;===============  Check command name  ====================================
CCP_main_10
		jsr		Upcase_linbuf
		lda		<current_drive
		sta		<select_drive
		ldy		#00H
		jsr		Get_Token
		sta		<delimitor
		sty		<token_pointer
		cpx		#00H
		bne		CCP_main_20
		jmp		Command_error_1

;===============  Set drive number  =====================================
CCP_main_20
		cmp		#':'
		bne		CCP_main_30
		cpx		#1
		beq		Skip1$
		jmp		Command_error_2
;------------------------------------------------------------------------
Skip1$		lda		<string_buffer+1
		sec
		sbc		#'A'
		cmp		#2
		bcc		Skip$
		jmp		Command_error_2
Skip$		sta		<select_drive
;------------------------------------------------------------------------
		iny
		jsr		Get_Token
		sta		<delimitor
		sty		<token_pointer
		cpx		#00H
		bne		CCP_main_30
		lda		<select_drive
		sta		<current_drive		; Change current drive
		jmp		CCP_main

;===============  Check built in command  ===============================
CCP_main_30
		jsr		Search_Command
		cmp		#00H
		bne		CCP_main_40
		jmp		Command_error_1

;===============  Jump command process  =================================
CCP_main_40
		mem8
		dec		a
		asl		a
		tax
		jmp		(Command_process,x)

;************************************************************************
;*	Get token							*
;*									*
;************************************************************************

		mem8
		idx8
Get_Token
		ldx		#0FFH
;------------------------------------------------------------------------
Repeat$		inx
		iny
		lda		Line_buffer,y
		sta		<string_buffer+1,x
		jsr		isfname
		bcs		Repeat$
;------------------------------------------------------------------------
Exit$		pha
		lda		#00H
		sta		<string_buffer+1,x
		stx		<string_buffer+0
		pla
		rts

;************************************************************************
;*	Get hex digit							*
;*									*
;************************************************************************

		mem8
		idx8
Get_xdigit
		rep		#00100000B		; Memory 16 bit mode
		stz		<work0
		stz		<work1
;------------------------------------------------------------------------
Repeat$		sep		#00100000B		; Memory 8 bit mode
		lda		Line_buffer,y
		jsr		isxdigit
		bcc		Exit$
		rep		#00100000B		; Memory 16 bit mode
		asl		<work0
		rol		<work1
		asl		<work0
		rol		<work1
		asl		<work0
		rol		<work1
		asl		<work0
		rol		<work1
		sep		#00100000B		; Memory 8 bit mode
		ora		<work0
		sta		<work0
		iny
		bra		Repeat$
;------------------------------------------------------------------------
Exit$		rts

;************************************************************************
;*	Check file name character					*
;************************************************************************

		mem8
isfname
		cmp		#60H
		beq		cannot_use$
		cmp		#7FH
		beq		cannot_use$
		cmp		#'.'
		beq		cannot_use$
		cmp		#':'
		beq		cannot_use$
		cmp		#'/'
		beq		cannot_use$
		cmp		#'\'
		beq		cannot_use$
		cmp		#21H
		bcs		can_use$
;------------------------------------------------------------------------
cannot_use$	clc
can_use$	rts

;************************************************************************
;*	Check hex digit character					*
;************************************************************************

		mem8
isxdigit
		cmp		#'0'
		bcc		No$
		cmp		#':'
		bcc		Yes1$
		cmp		#'A'
		bcc		No$
		cmp		#'G'
		bcc		Yes2$
;------------------------------------------------------------------------
No$		clc
		rts
;------------------------------------------------------------------------
Yes1$		sec
		sbc		#30H
		rts
;------------------------------------------------------------------------
Yes2$		sec
		sbc		#41H-10
		rts

;************************************************************************
;*	Upcase character in line buffer					*
;************************************************************************

		mem8
		idx8
Upcase_linbuf
		ldx		Line_buffer+0
Repeat$		lda		Line_buffer,x
		cmp		#'{'
		bcs		Skip$
		cmp		#'a'
		bcc		Skip$
		sbc		#20H
		sta		Line_buffer,x
Skip$		dex
		bne		Repeat$
		rts

;************************************************************************
;*	SKip space code							*
;*									*
;************************************************************************

		mem8
		idx8
Skip_space
		iny
		lda		Line_buffer,y
		beq		Exit$
		cmp		#20H
		beq		Skip_space
		cmp		#09H
		beq		Skip_space
Exit$		rts

;************************************************************************
;*	Search command table						*
;*									*
;************************************************************************

		mem8
		idx8
Search_Command
		stz		<work1			; work1 = command number
		ldy		#00H			; IY = table pointer

;===============  Command search  =======================================
Search_comm_10
		inc		<work1
		lda		<string_buffer+0
		cmp		Command_table,y		; the same length ?
		bne		Search_comm_20		; no.
;------------------------------------------------------------------------
		ldx		#01H
		phy
		sta		<work2			; work2 = length of command
;------------------------------------------------------------------------
Compare$	iny
		lda		<string_buffer,x
		cmp		Command_table,y
		bne		Different$
		inx
		dec		<work2
		bne		Compare$
;------------------------------------------------------------------------
The_same$	ply
		lda		<work1
		rts
;------------------------------------------------------------------------
Different$	ply

;===============  Next command  =========================================
Search_comm_20
		sty		<work2
		lda		Command_table,y
		sec					; plus 1
		adc		<work2
		tay					; IY = next command
		lda		Command_table,y
		bne		Search_comm_10
		rts

;===============  Command table  ========================================

Command_table	byte		3
		ascii		'CLS'
		byte		3
		ascii		'DIR'
		byte		3
		ascii		'DEL'
		byte		3
		ascii		'REN'
		byte		6
		ascii		'CHDISK'
		byte		6
		ascii		'FORMAT'
		byte		4
		ascii		'LOAD'
		byte		4
		ascii		'SAVE'
		byte		6
		ascii		'DOSCUT'
;-------------- iwa test ------------------------------------------------
		byte		4
		ascii		'MORE'

		byte		0

Command_process	word		Screen_Clear
		word		Directory
		word		Delete_File
		word		Rename_File
		word		Change_Disk
		word		Format_Disk
		word		Load_Data
		word		Save_Data
		word		DOS_Cut
;-------------- iwa test ------------------------------------------------
		word		More

;************************************************************************
;*	DOS Cut test							*
;*									*
;************************************************************************

		mem16
		idx8
DOS_Cut
		rep		#00100000B
		lda		#DOS_Cut_message
		DOS		_PRINT
;------------------------------------------------------------------------
		lda		#10000
Wait$		dec		a
		bne		Wait$
;------------------------------------------------------------------------
		DOS		_DOSSTP
		sep		#00100000B
;------------------------------------------------------------------------
Repeat$		stz		<NMI_flag
Wait_NMI$	lda		<NMI_flag
		beq		Wait_NMI$
		lda		<stick_trigger_1+1
		bpl		Repeat$
;------------------------------------------------------------------------
		rep		#00100000B
		DOS		_DOSRST
		DOS		_TXTRST
		lda		#DOS_Rst_message
		DOS		_PRINT
		nop
		nop
		nop
		jmp		CCP_main

;************************************************************************
;*	Screen clear							*
;*									*
;************************************************************************

		mem8
Screen_Clear
		lda		#0CH
		DOS		_CONOUT
		jmp		CCP_main

;************************************************************************
;*	Change disk							*
;*									*
;************************************************************************

		mem8
		idx8
Change_Disk
		lda		<delimitor
		cmp		#' '
		beq		Change_Disk_100
		cmp		#09H
		bne		Change_Disk_300

;=============== Check disk type ========================================
Change_Disk_100
		ldy		<token_pointer
		jsr		Skip_space
;------------------------------------------------------------------------
		lda		Line_buffer,y
		iny
		cmp		#'H'
		beq		HD_Disk$
		cmp		#'D'
		bne		Change_Disk_300
;------------------------------------------------------------------------
DD_Disk$	lda		Line_buffer,y
		iny
		cmp		#'D'
		bne		Change_Disk_300
		ldx		#01H
		lda		Line_buffer,y
		cmp		#'9'
		bne		Change_Disk_200
		inx
		iny
		bra		Change_Disk_200
;------------------------------------------------------------------------
HD_Disk$	lda		Line_buffer,y
		iny
		cmp		#'D'
		bne		Change_Disk_300
		ldx		#00H

;=============== Change disk type =======================================
Change_Disk_200
		lda		Line_buffer,y
		bne		Change_Disk_300
		txa
		DOS		_DSKRST
		jmp		CCP_main
Change_Disk_300	jmp		Bad_Disk_Type

;************************************************************************
;*	Disk Format							*
;*									*
;************************************************************************

		mem8
		idx8
Format_Disk
		DOS		_FORMAT
		cmp		#0
		bne		Disk_err$
		jmp		CCP_main
Disk_err$	jmp		Disk_error

;************************************************************************
;*	Load data							*
;*									*
;************************************************************************

		mem8
		idx8
Load_Data
		lda		<delimitor
		cmp		#' '
		beq		Load$
		cmp		#09H
		bne		Error1$
;------------------------------------------------------------------------
Load$		ldy		<token_pointer
		jsr		Skip_space
		jsr		Set_filename
;------------------------------------------------------------------------
		jsr		Skip_space
		jsr		isxdigit
		bcc		Error2$
		jsr		Get_xdigit
		rep		#00100000B		; Memory 16 bit mode
		lda		<work0
		sta		<string_buffer+10H
		lda		<work1
		sta		<string_buffer+12H
		sep		#00100000B		; Memory 8 bit mode
;------------------------------------------------------------------------
		jsr		Skip_space
		jsr		isxdigit
		bcc		Error2$
		jsr		Get_xdigit
		rep		#00100000B		; Memory 16 bit mode
		lda		<work0
		sta		<string_buffer+14H
		lda		<work1
		sta		<string_buffer+16H
		sep		#00100000B		; Memory 8 bit mode
;------------------------------------------------------------------------
		jsr		Copy_filename
		DOS		_LOAD
		cmp		#0
		bne		Error0$
		jmp		CCP_main
;------------------------------------------------------------------------
Error0$		jmp		Disk_error
Error1$		jmp		Bad_filename
Error2$		jmp		Bad_xdigit

;************************************************************************
;*	Save data							*
;*									*
;************************************************************************

		mem8
		idx8
Save_Data
		lda		<delimitor
		cmp		#' '
		beq		Save$
		cmp		#09H
		bne		Error1$
;------------------------------------------------------------------------
Save$		ldy		<token_pointer
		jsr		Skip_space
		jsr		Set_filename
;------------------------------------------------------------------------
		jsr		Skip_space
		jsr		isxdigit
		bcc		Error2$
		jsr		Get_xdigit
		rep		#00100000B		; Memory 16 bit mode
		lda		<work0
		sta		<string_buffer+10H
		lda		<work1
		sta		<string_buffer+12H
		sep		#00100000B		; Memory 8 bit mode
;------------------------------------------------------------------------
		jsr		Skip_space
		jsr		isxdigit
		bcc		Error2$
		jsr		Get_xdigit
		rep		#00100000B		; Memory 16 bit mode
		lda		<work0
		sta		<string_buffer+14H
		lda		<work1
		sta		<string_buffer+16H
		sep		#00100000B		; Memory 8 bit mode
;------------------------------------------------------------------------
		jsr		Copy_filename
		DOS		_SAVE
		cmp		#0
		bne		Error0$
		jmp		CCP_main
;------------------------------------------------------------------------
Error0$		jmp		Disk_error
Error1$		jmp		Bad_filename
Error2$		jmp		Bad_xdigit

;************************************************************************
;*	Directory							*
;*									*
;************************************************************************

		mem8
		idx8
Directory
		ldx		#0
Repeat$		lda		Full_sch_fname,x
		sta		access_fname,x
		inx
		cmp		#0FFH
		bne		Repeat$

;=============== Search first file ======================================
Directory_50
		lda		<select_drive
		DOS		_SELDSK
		and		#00100000B
		bne		Drive_ready$
		jmp		Disk_Set_Error
;------------------------------------------------------------------------
Drive_ready$	DOS		_DIRFST
		cmp		#00H
		beq		Directory_61
		cmp		#04H
		beq		Skip$
		jmp		Disk_error
;------------------------------------------------------------------------
		mem16
Skip$		rep		#00100000B		; Memory 16 bit mode
		lda		#no_file
		DOS		_PRINT
		sep		#00100000B		; Memory 8 bit mode
		bra		Directory_62

;=============== Search next file =======================================
Directory_60
		mem8
		DOS		_DIRNXT
		cmp		#00H
		beq		Directory_61
		cmp		#04H
		beq		Directory_62
		jmp		Disk_error
;------------------------------------------------------------------------
Directory_61	jsr		Display_fname
		jsr		Display_fsize
		bra		Directory_60
;------------------------------------------------------------------------
Directory_62	DOS		_DSKFRE
		cmp		#00H
		bne		Skip$
		jsr		Display_free
Skip$		jmp		CCP_main

;=============== All search file name ===================================

Full_sch_fname	ascii		'???????????'
		byte		0FFH

;************************************************************************
;*	Display file name						*
;************************************************************************

		mem16
		idx8
Display_fname
		rep		#00100000B		; Memory 16 bit mode
;------------------------------------------------------------------------
		ldx		directory_entry+8
		ldy		directory_entry+9
		lda		#002EH
		sta		directory_entry+8
		lda		#directory_entry+0
		DOS		_PRINT
		stx		directory_entry+8
		sty		directory_entry+9
;------------------------------------------------------------------------
		ldx		directory_entry+11
		ldy		#00H
		sty		directory_entry+11
		lda		#directory_entry+8
		DOS		_PRINT
		stx		directory_entry+11
;------------------------------------------------------------------------
		mem8
		sep		#00100000B		; Memory 8 bit mode
		lda		#' '
		DOS		_CONOUT
		lda		#' '
		DOS		_CONOUT
		rts

;************************************************************************
;*	Display file size						*
;************************************************************************

		mem16
		idx8
Display_fsize
		rep		#00100000B		; Memory 16 bit mode
		lda		directory_entry+28
		sta		<dividend+0
		lda		directory_entry+30
		sta		<dividend+2
		ldx		#8
		jsr		Display_number
;------------------------------------------------------------------------
		lda		#carriage_return
		DOS		_PRINT
		sep		#00100000B		; Memory 8 bit mode
		rts

;************************************************************************
;*	Display disk free size						*
;************************************************************************

		mem16
		idx8
Display_free
		rep		#00100000B		; Memory 16 bit mode
		lda		#carriage_return
		DOS		_PRINT
;------------------------------------------------------------------------
		stz		<dividend+0
		stz		<dividend+2
		lda		Line_buffer+0
		sta		<dividend+1
		asl		<dividend+0
		rol		<dividend+2
		asl		<dividend+0
		rol		<dividend+2
		ldx		#1
		jsr		Display_number
;------------------------------------------------------------------------
		lda		#bytes_free
		DOS		_PRINT
		sep		#00100000B		; Memory 8 bit mode
		rts

;************************************************************************
;*	Display number							*
;************************************************************************

		mem8
		idx8
Display_number
		php
		sep		#00110000B		; Memory,Index 8 bit mode
;------------------------------------------------------------------------		
		stx		<work0
		ldx		#3EH
		lda		#10
		sta		<divisor+0
		stz		<divisor+1

;=============== Store number to string buffer ==========================
Disp_number_10
		phx
		jsr		Division
		lda		<rest
		ora		#30H
		plx
		sta		<string_buffer,x
		dex
		lda		<divide+0
		ora		<divide+1
		ora		<divide+2
		ora		<divide+3
		bne		Disp_number_10

;=============== Store space ============================================
Disp_number_20
		txa
		eor		#0FFH
		sec
		adc		#3EH
		cmp		<work0
		bcs		Disp_number_30
;------------------------------------------------------------------------
		tay
		lda		#' '
Repeat$		sta		<string_buffer,x
		dex
		iny
		cpy		<work0
		bcc		Repeat$

;=============== Display number =========================================
Disp_number_30
		lda		#00H
		sta		<string_buffer+3FH
		xba
		txa
		sec
		adc		#string_buffer
		DOS		_PRINT
		plp
		rts

;************************************************************************
;*	Unsigned division						*
;************************************************************************

		mem16
		idx8
Division
		php
		rep		#00100000B		; Memory 16 bit mode
		sep		#00010000B		; Index 8 bit mode
		ldx		#32
		lda		#0000H
;------------------------------------------------------------------------
Repeat$		asl		<dividend+0
		rol		<dividend+2
		rol		a
		cmp		<divisor
		bcc		Skip$
		sbc		<divisor
		inc		<dividend+0
Skip$		dex
		bne		Repeat$
;------------------------------------------------------------------------
		sta		<rest
		plp
		rts

;************************************************************************
;*	Delete file							*
;*									*
;************************************************************************

		mem8
		idx8
Delete_File
		lda		<delimitor
		cmp		#' '
		beq		Delete$
		cmp		#09H
		bne		Error$
;-----------------------------------------------------------------------
Delete$		ldy		<token_pointer
		jsr		Skip_space
		jsr		Set_filename
		jsr		Copy_filename
		DOS		_PURGE
		cmp		#0
		bne		Disk_err$
		jmp		CCP_main
Disk_err$	jmp		Disk_error
Error$		jmp		Bad_filename

;************************************************************************
;*	Rename File							*
;*									*
;************************************************************************

		mem8
		idx8
Rename_File
		lda		<delimitor
		cmp		#' '
		beq		Old_fname$
		cmp		#09H
		bne		Error$
;------------------------------------------------------------------------
Old_fname$	ldy		<token_pointer
		jsr		Skip_space
		jsr		Set_filename
		sty		<token_pointer
		sta		<delimitor
		jsr		Swap_filename
;------------------------------------------------------------------------
		lda		<delimitor
		cmp		#' '
		beq		New_fname$
		cmp		#09H
		bne		Error$
;------------------------------------------------------------------------
New_fname$	ldy		<token_pointer
		jsr		Skip_space
		jsr		Set_filename
		jsr		Swap_filename
;------------------------------------------------------------------------
		jsr		Copy_filename
		DOS		_RENAME
		cmp		#0
		bne		Disk_err$
		jmp		CCP_main
Disk_err$	jmp		Disk_error
Error$		jmp		Bad_filename

;************************************************************************
;*	Set file name							*
;*									*
;************************************************************************

		mem8
		idx8
Set_filename
		ldx		#11
		lda		#' '
Repeat$		sta		<string_buffer-1,x
		dex
		bne		Repeat$

;=============== Set file name ==========================================
Set_filename_10
		lda		Line_buffer,y
		cmp		#21H
		bcc		Set_filename_30
		cmp		#'.'
		beq		Extend$
		cmp		#'*'
		beq		Wild_card$
		sta		<string_buffer,x
		inx
		iny
		cpx		#8
		bne		Set_filename_10
		bra		Delimitor$
;------------------------------------------------------------------------
Wild_card$	lda		#'?'
		sta		<string_buffer,x
		inx
		cpx		#8
		bne		Wild_card$
		iny
;------------------------------------------------------------------------
Delimitor$	lda		Line_buffer,y
		beq		Set_filename_30
		iny
		cmp		#'.'
		beq		Set_filename_20
Bad_fname$	jmp		Bad_filename
;------------------------------------------------------------------------
Extend$		cpx		#0
		beq		Bad_fname$
		ldx		#08H
		iny

;=============== Set extend =============================================
Set_filename_20
		lda		Line_buffer,y
		cmp		#21H
		bcc		Set_filename_30
		cmp		#'*'
		beq		Wild_card$
		sta		<string_buffer,x
		inx
		iny
		cpx		#11
		bne		Set_filename_20
		bra		Delimitor$
;------------------------------------------------------------------------
Wild_card$	lda		#'?'
		sta		<string_buffer,x
		inx
		cpx		#11
		bne		Wild_card$
		iny
;------------------------------------------------------------------------
Delimitor$	lda		Line_buffer,y
		cmp		#21H
		bcc		Set_filename_30
		jmp		Bad_filename

;=============== Check file name ========================================
Set_filename_30
		cpx		#0
		bne		Skip$
		jmp		Bad_filename
Skip$		rts

;************************************************************************
;*	Copy file name							*
;*									*
;************************************************************************

		mem16
		idx16
Copy_filename
		rep		#00110000B		; Memory,Index 16 bit mode
		ldx		#string_buffer
		ldy		#access_fname
		lda		#31
		mvn		#0,#0
		sep		#00110000B		; Memory,Index 8 bit mode
		rts

;************************************************************************
;*	Swap file name							*
;*									*
;************************************************************************

		mem8
		idx8
Swap_filename
		ldx		#10
Repeat$		lda		<string_buffer,x
		xba
		lda		<string_buffer+16,x
		sta		<string_buffer,x
		xba
		sta		<string_buffer+16,x
		dex
		bpl		Repeat$
		rts

;************************************************************************
;*	More data ( iwa test )						*
;*									*
;************************************************************************

		mem8
		idx8
More
		lda		<delimitor
		cmp		#' '
		beq		More0$
		cmp		#09H
		bne		Error1$
;------------------------------------------------------------------------
More0$		ldy		<token_pointer
		jsr		Skip_space
		jsr		Set_filename
;------------------------------------------------------------------------
		mem16
		rep		#00100000B		; Memory 16 bit mode
		lda		#txt_buffer
		sta		<string_buffer+10H
		lda		#200H
		sta		<string_buffer+14H
		mem8
		sep		#00100000B		; Memory 8 bit mode
;------------------------------------------------------------------------
		jsr		Copy_filename
		DOS		_LOAD
		cmp		#0
		bne		Error0$
;------------------------------------------------------------------------
		jsr		Asccov
;		mem16
;		rep		#00100000B		; Memory 16 bit mode
;		LDA		#asc_buffer
;		DOS		_PRINT
		jmp		CCP_main
;------------------------------------------------------------------------
Error0$		jmp		Disk_error
Error1$		jmp		Bad_filename

;************************************************************************
;*	Ascll convert	(nomo test)					*
;*									*
;************************************************************************
		mem8
Ascdat		equ		$
		byte		030H	;0		; ascll data		
		byte		031H	;1
		byte		032H	;2
		byte		033H	;3
		byte		034H	;4
		byte		035H	;5
		byte		036H	;6
		byte		037H	;7
		byte		038H	;8
		byte		039H	;9
		byte		041H	;A
		byte		042H	;B
		byte		043H	;C
		byte		044H	;D
		byte		045H	;E
		byte		046H	;F
Asccov		equ		$
		mem16
		idx16
		rep		#00110000B		; Memory 16 bit mode
		ldx		#00H
acv005		equ		$			;;;-> initial set
		stz		asc_buffer,x			; char ram clear
		inx
		cpx		#800H
		bne		acv005			; clear ok?
;
		lda		#0004H
		sta		nwork0			; 1gyo counter set		
		stz		lin_count		; line counter clear
		stz		nwork1			; register clear
		stz		cg_dat			; ram clear
		lda		1EF8H
		sta		asc_count		; total count set
		ldx		#00H
		txy
acv010		equ		$			;;;-> main ram set
		ldx		nwork1
		lda		txt_buffer,x		; real data set (2byte)
		pha
		and		#0F0F0H			; Hi index change	
		lsr		a
		lsr		a
		lsr		a
		lsr		a			
		sta		nwork2			; Hi index set
		pla
		and		#00F0FH
		sta		nwork3			; Low index set
		phy					; Y register taihi
		mem8
		idx8
		sep		#00110000B		; Memory 8 bit mode
		ldx		nwork2
		lda		Ascdat,x		
		sta		nwork4			; data 0 Hi  ascll code set
		ldx		nwork3
		lda		Ascdat,x
		sta		nwork4+1		; data 0 Low ascll code set
		ldx		nwork2+1
		lda		Ascdat,x
		sta		nwork5			; data 1 Hi  ascll code set
		ldx		nwork3+1
		lda		Ascdat,x
		sta		nwork5+1		; data 1 Low ascll code set
		mem16
		idx16
		rep		#00110000B		; Memory 16 bit mode
		ply					; Y register futtkatsu
		lda		nwork4
		sta		asc_buffer,y		; data 0 ram set
		lda		#0020H
		sta		asc_buffer+2,y		; space code set
		lda		nwork5
		sta		asc_buffer+3,y		; data 1 ram set
		lda		#0020H
		sta		asc_buffer+5,y		; space code set
		dec		asc_count
		dec		asc_count		; total count minus
		bmi		acv020			; set end?
;
		inc		nwork1
		inc		nwork1			; real data index plus
		iny
		iny
		iny
		iny
		iny
		iny					; data ram index plus
		dec		nwork0
		bne		acv010			; 1gyo end?
;
		inc		lin_count
		lda		#0A0DH
		sta		asc_buffer,y		; esc sikence set (kaigyo,cursor top)
		phy
		jsr    		Keychk
		ply
		lda		#asc_buffer
		DOS		_PRINT
		lda		#0004H			
		sta		nwork0			; 1gyo counter sai set
		ldy		#00H
		jmp		acv010			
acv020		equ		$			;;;-> end code syori
;		lda		#0A0DH
;		sta		asc_buffer+6,y		; esc sikence set (kaigyo,cursor top)
;		lda		#00H
;		sta		asc_buffer+8,y		; end code set
		lda		#431BH
		sta		asc_buffer,y
		lda		#0A33H
		sta		asc_buffer+2,y
		lda		#000DH			
		sta		asc_buffer+4,y		 
		lda		#asc_buffer
		DOS		_PRINT
		idx8
		mem8
		sep		#00110000B		; Memory 8 bit mode
		rts						
;
;************************************************************************
;*	Ascll convert sub	(nomo test)				*
;*		<key check>						*
;************************************************************************
		mem16
		idx16
		rep		#00110000B		; Memory 16 bit mode
Keychk		equ		$
		lda		lin_count
		cmp		#10H
		bne		kck030
;
		lda		#431BH
		sta		asc_buffer+2,y
		lda		cg_dat
		cmp		#03H
		bcc		kck005

		and		#0003H
		sta		cg_dat
kck005		equ		$
		lda		#00D30H
		clc
		adc		cg_dat
		sta		asc_buffer+4,y
		inc		cg_dat
kck010		equ		$
		mem8
		idx8
		sep		#00110000B		; Memory 8 bit mode
		DOS		_CONIN
		cmp		#00DH
		beq		kck020
;
		cmp		#020H
		bne		kck010
;
		mem16
		idx16
		rep		#00110000B		; Memory 16 bit mode
		stz		lin_count
		rts
kck020		equ		$
		mem16
		idx16
		rep		#00110000B		; Memory 16 bit mode
		lda		#0FH
		sta		lin_count
kck030		equ		$
		rts
;	
;;;//H3.11.12//;;;;************************************************************************
;;;//H3.11.12//;;;;*	Ascll convert	(nomo test)					*
;;;//H3.11.12//;;;;*									*
;;;//H3.11.12//;;;;************************************************************************
;;;//H3.11.12//;;;		mem8
;;;//H3.11.12//;;;Ascdat		equ		$
;;;//H3.11.12//;;;		byte		030H	;0		; ascll data		
;;;//H3.11.12//;;;		byte		031H	;1
;;;//H3.11.12//;;;		byte		032H	;2
;;;//H3.11.12//;;;		byte		033H	;3
;;;//H3.11.12//;;;		byte		034H	;4
;;;//H3.11.12//;;;		byte		035H	;5
;;;//H3.11.12//;;;		byte		036H	;6
;;;//H3.11.12//;;;		byte		037H	;7
;;;//H3.11.12//;;;		byte		038H	;8
;;;//H3.11.12//;;;		byte		039H	;9
;;;//H3.11.12//;;;		byte		041H	;A
;;;//H3.11.12//;;;		byte		042H	;B
;;;//H3.11.12//;;;		byte		043H	;C
;;;//H3.11.12//;;;		byte		044H	;D
;;;//H3.11.12//;;;		byte		045H	;E
;;;//H3.11.12//;;;		byte		046H	;F
;;;//H3.11.12//;;;Asccov		equ		$
;;;//H3.11.12//;;;		mem16
;;;//H3.11.12//;;;		idx16
;;;//H3.11.12//;;;		rep		#00110000B		; Memory 16 bit mode
;;;//H3.11.12//;;;		ldx		#00H
;;;//H3.11.12//;;;acv005		equ		$			;;;-> initial set
;;;//H3.11.12//;;;		stz		1200H,x			; char ram clear
;;;//H3.11.12//;;;		inx
;;;//H3.11.12//;;;		cpx		#800H
;;;//H3.11.12//;;;		bne		acv005			; clear ok?
;;;//H3.11.12//;;;;
;;;//H3.11.12//;;;		lda		#0004H
;;;//H3.11.12//;;;		sta		nwork0			; 1gyo counter set		
;;;//H3.11.12//;;;		lda		1EF8H
;;;//H3.11.12//;;;		sta		asc_count		; total count set
;;;//H3.11.12//;;;		ldx		#00H
;;;//H3.11.12//;;;		txy
;;;//H3.11.12//;;;		stx		nwork1			; register clear
;;;//H3.11.12//;;;acv010		equ		$			;;;-> main ram set
;;;//H3.11.12//;;;		ldx		nwork1
;;;//H3.11.12//;;;		lda		txt_buffer,x		; real data set (2byte)
;;;//H3.11.12//;;;		pha
;;;//H3.11.12//;;;		and		#0F0F0H			; Hi index change	
;;;//H3.11.12//;;;		lsr		a
;;;//H3.11.12//;;;		lsr		a
;;;//H3.11.12//;;;		lsr		a
;;;//H3.11.12//;;;		lsr		a			
;;;//H3.11.12//;;;		sta		nwork2			; Hi index set
;;;//H3.11.12//;;;		pla
;;;//H3.11.12//;;;		and		#00F0FH
;;;//H3.11.12//;;;		sta		nwork3			; Low index set
;;;//H3.11.12//;;;		phy					; Y register taihi
;;;//H3.11.12//;;;		mem8
;;;//H3.11.12//;;;		idx8
;;;//H3.11.12//;;;		sep		#00110000B		; Memory 8 bit mode
;;;//H3.11.12//;;;		ldx		nwork2
;;;//H3.11.12//;;;		lda		Ascdat,x		
;;;//H3.11.12//;;;		sta		nwork4			; data 0 Hi  ascll code set
;;;//H3.11.12//;;;		ldx		nwork3
;;;//H3.11.12//;;;		lda		Ascdat,x
;;;//H3.11.12//;;;		sta		nwork4+1		; data 0 Low ascll code set
;;;//H3.11.12//;;;		ldx		nwork2+1
;;;//H3.11.12//;;;		lda		Ascdat,x
;;;//H3.11.12//;;;		sta		nwork5			; data 1 Hi  ascll code set
;;;//H3.11.12//;;;		ldx		nwork3+1
;;;//H3.11.12//;;;		lda		Ascdat,x
;;;//H3.11.12//;;;		sta		nwork5+1		; data 1 Low ascll code set
;;;//H3.11.12//;;;		mem16
;;;//H3.11.12//;;;		idx16
;;;//H3.11.12//;;;		rep		#00110000B		; Memory 16 bit mode
;;;//H3.11.12//;;;		ply					; Y register futtkatsu
;;;//H3.11.12//;;;		lda		nwork4
;;;//H3.11.12//;;;		sta		asc_buffer,y		; data 0 ram set
;;;//H3.11.12//;;;		lda		#0020H
;;;//H3.11.12//;;;		sta		asc_buffer+2,y		; space code set
;;;//H3.11.12//;;;		lda		nwork5
;;;//H3.11.12//;;;		sta		asc_buffer+3,y		; data 1 ram set
;;;//H3.11.12//;;;		lda		#0020H
;;;//H3.11.12//;;;		sta		asc_buffer+5,y		; space code set
;;;//H3.11.12//;;;		dec		asc_count
;;;//H3.11.12//;;;		dec		asc_count		; total count minus
;;;//H3.11.12//;;;		beq		acv020			; set end?
;;;//H3.11.12//;;;;
;;;//H3.11.12//;;;		inc		nwork1
;;;//H3.11.12//;;;		inc		nwork1			; real data index plus
;;;//H3.11.12//;;;		iny
;;;//H3.11.12//;;;		iny
;;;//H3.11.12//;;;		iny
;;;//H3.11.12//;;;		iny
;;;//H3.11.12//;;;		iny
;;;//H3.11.12//;;;		iny					; data ram index plus
;;;//H3.11.12//;;;		dec		nwork0
;;;//H3.11.12//;;;		bne		acv010			; 1gyo end?
;;;//H3.11.12//;;;;
;;;//H3.11.12//;;;		lda		#0004H			
;;;//H3.11.12//;;;		sta		nwork0			; 1gyo counter sai set
;;;//H3.11.12//;;;		lda		#0A0DH
;;;//H3.11.12//;;;		sta		asc_buffer,y		; esc sikence set (kaigyo,cursor top)
;;;//H3.11.12//;;;		iny
;;;//H3.11.12//;;;		iny					; data ram index plus
;;;//H3.11.12//;;;		jmp		acv010			
;;;//H3.11.12//;;;acv020		equ		$			;;;-> end code syori
;;;//H3.11.12//;;;		lda		#00A0DH			
;;;//H3.11.12//;;;		sta		asc_buffer+6,y		; esc sikence set (kaigyo,cursor top)
;;;//H3.11.12//;;;		lda		#00H
;;;//H3.11.12//;;;		sta		asc_buffer+8,y		; end code set
;;;//H3.11.12//;;;		idx8
;;;//H3.11.12//;;;		mem8
;;;//H3.11.12//;;;		sep		#00110000B		; Memory 8 bit mode
;;;//H3.11.12//;;;		rts						
;************************************************************************
;*	Error								*
;*									*
;************************************************************************

		mem16
		idx8
Disk_error
		sep		#00110000B		; Memory,Index 8 bit mode
		dec		a
		asl		a
		tax
		rep		#00100000B		; Memory 16 bit mode
		lda		Disk_error_msg,x
		DOS		_PRINT
		jmp		CCP_main
;------------------------------------------------------------------------
Disk_error_msg	word		disk_set_error
		word		Disk_IO_Error
		word		Disk_Sys_Error
		word		File_Not_Found
		word		File_Open_Error
		word		Directory_Full
		word		File_Read_Only
		word		Disk_Full
		word		File_Exist
;------------------------------------------------------------------------
Command_error_1	rep		#00100000B		; Memory 16 bit mode
		lda		#unknown_command
		bra		Print_error
;------------------------------------------------------------------------
Command_error_2	rep		#00100000B		; Memory 16 bit mode
		lda		#bad_drive
		bra		Print_error
;------------------------------------------------------------------------
Disk_Set_Error	rep		#00100000B		; Memory 16 bit mode
		lda		#disk_set_error
		bra		Print_error
;------------------------------------------------------------------------
Bad_filename	rep		#00100000B		; Memory 16 bit mode
		lda		#bad_filename
		bra		Print_error
;------------------------------------------------------------------------
Bad_Disk_Type	rep		#00100000B		; Memory 16 bit mode
		lda		#bad_disk_type
		bra		Print_error
;------------------------------------------------------------------------
Bad_xdigit	rep		#00100000B		; Memory 16 bit mode
		lda		#bad_xdigit
;------------------------------------------------------------------------
Print_error	DOS		_PRINT
		jmp		CCP_main

;************************************************************************
;*	Message								*
;*									*
;************************************************************************

Boot_message	byte		1BH
		ascii		'C1Super Famicom DOS  Ver 0.10'
		byte		0DH,0AH,1BH
		ascii		'C2Copyright (C) 1991 Nintendo'
		byte		1BH
		ascii		'C3'
		byte		0DH,0AH,0AH,00H

DOS_Cut_message	ascii		'Halt Super Famicom DOS'
		byte		0
DOS_Rst_message	ascii		'Reset Super Famicom DOS'
		byte		0DH,0AH,0AH,0

unknown_command	ascii		'unknown command.'
carriage_return	byte		0DH,0AH,00H
bad_drive	ascii		'bad drive number.'
		byte		0DH,0AH,00H
no_file		ascii		'no file.'
		byte		0DH,0AH,00H
bytes_free	ascii		' byte(s) free'
		byte		0DH,0AH,0AH,00H
bad_filename	ascii		'bad file name'
		byte		0DH,0AH,00H
bad_disk_type	ascii		'bad disk type'
		byte		0DH,0AH,00H
disk_set_error	ascii		'drive not ready'
		byte		0DH,0AH,00H
Disk_IO_Error	ascii		'disk I/O error'
		byte		0DH,0AH,00H
Disk_Sys_Error	ascii		'disk system I/O error'
		byte		0DH,0AH,00H
File_Not_Found	ascii		'file not found'
		byte		0DH,0AH,00H
File_Open_Error	ascii		'file open error'
		byte		0DH,0AH,00H
Directory_Full	ascii		'directory full'
		byte		0DH,0AH,00H
File_Read_Only	ascii		'file read only'
		byte		0DH,0AH,00H
Disk_Full	ascii		'disk full'
		byte		0DH,0AH,00H
File_Exist	ascii		'file already exist'
		byte		0DH,0AH,00H
bad_xdigit	ascii		'bad address or data length'
		byte		0DH,0AH,00H

;************************************************************************
;*	NMI routine							*
;*									*
;************************************************************************

		mem16
		idx16
NMI_Entry
		rep		#00110000B		; Memory,Index 16 bit mode
;------------------------------------------------------------------------
		pha
		phx
		phy
		phd
		phb
		phk
;------------------------------------------------------------------------
		plb
		lda		#0
		tcd
;------------------------------------------------------------------------
		mem8
		idx8
		sep		#00110000B		; Memory,Index 8 bit mode
		lda		NMI_status		; Reset hardware NMI flag
		lda		#0FFH
		sta		<NMI_flag
		jsr		Scan_controller
;------------------------------------------------------------------------
		rep		#00110000B		; Memory,Index 16 bit mode
		plb
		pld
		ply
		plx
		pla
		rti

;************************************************************************
;*	Scan controller							*
;************************************************************************
 
		mem16
Scan_controller
		lda		Blank_status
		lsr		a
		bcs		Scan_controller
		rep		#00100000B		; Memory 16 bit mode

;===============  Scan Joy controller I  ================================
Controller_1
		lda		Joy_controller1
		sta		<stick_status_1		; Set controller status 
		eor		<stick_backst_1
		and		<stick_status_1
		sta		<stick_trigger_1	; Set controller trigger
;------------------------------------------------------------------------
		lda		<stick_status_1
		sta		<stick_backst_1		; Set controller back status

;===============  Scan Joy controller II  ===============================
Controller_2
		lda		Joy_controller2
		sta		<stick_status_2		; Set controller status 
		eor		<stick_backst_2
		and		<stick_status_2
		sta		<stick_trigger_2	; Set controller trigger
;------------------------------------------------------------------------
		lda		<stick_status_2
		sta		<stick_backst_2		; Set controller back status
;------------------------------------------------------------------------
		sep		#00100000B		; Memory 8 bit mode
		rts

;************************************************************************
;*	Not use interrupt						*
;*									*
;************************************************************************

BRK_Entry
ABT_Entry
IRQ_Entry	rti

;************************************************************************
;*	User interrupt vector						*
;*									*
;************************************************************************

		org		0DFF6H

		word		BRK_Entry		; BRK
		word		ABT_Entry		; Abort
		word		NMI_Entry		; NMI
		word		CCP_Entry		; Rset
		word		IRQ_Entry		; IRQ

		end
