;************************************************************************
;*		SFX Besic I/O system include file			*
;************************************************************************

bios_work	equ		1D00H
work0		equ		bios_work+000H		;     2 bytes	: temporary work 0
work1		equ		bios_work+002H		;     2 bytes	: temporary work 0
work2		equ		bios_work+004H		;     2 bytes	: temporary work 0
work3		equ		bios_work+006H		;     2 bytes	: temporary work 0
screen_frame	equ		bios_work+008H		;     1 byte	: Bit map emulation counter
frame_counter	equ		bios_work+009H		;     1 byte	: Frame counter
table_address	equ		bios_work+00AH		;     2 bytes	: Table address
;------------------------------------------------------------------------
stick_status_1	equ		bios_work+0010H		;     2 bytes	: Controller 1 status
stick_backst_1	equ		bios_work+0012H		;     2 bytes	: Controller 1 back status
stick_trigger_1	equ		bios_work+0014H		;     2 bytes	: Controller 1 trigger
stick_status_2	equ		bios_work+0016H		;     2 bytes	: Controller 2 status
stick_backst_2	equ		bios_work+0018H		;     2 bytes	: Controller 2 back status
stick_trigger_2	equ		bios_work+001AH		;     2 bytes	: Controller 2 trigger
;------------------------------------------------------------------------
;------------------------------------------------------------------------
cursor_posx	equ		bios_work+0060H		;      1 byte	: Cursor position x
cursor_posy	equ		bios_work+0061H		;      1 byte	: Cursor position y
cursor_addr	equ		bios_work+0062H		;      2 byte	: Cursor position VRAM address
cursor_count	equ		bios_work+0064H		;      1 byte	: Cursor blink counter
cursor_flag	equ		bios_work+0065H		;      1 byte	: Cursor on/off flag
cursor_switch	equ		bios_work+0066H		;      1 byte	: Cursor on/off switch
;------------------------------------------------------------------------
serial_error	equ		bios_work+0067H		;      1 byte	: RS232C input error status
serial_cnt	equ		bios_work+0068H		;      1 byte	: RS232C buffer Data counter
serial_put	equ		bios_work+0069H		;      1 byte	: RS232C buffer Put pointer
serial_get	equ		bios_work+006AH		;      1 byte	: RS232C buffer Get pointer
keybuff_cnt	equ		bios_work+006BH		;      1 byte	: Keyboard buffer Data counter 
keybuff_put	equ		bios_work+006CH		;      1 byte	: Keyboard buffer Put pointer
keybuff_get	equ		bios_work+006DH		;      1 byte	: Keyboard buffer Get pointer
capital_lock	equ		bios_work+006EH		;      1 byte	: Keyboard capital lock flag
shift_flag	equ		bios_work+006FH		;      1 byte	: Keyboard shift flag
;------------------------------------------------------------------------
RS232C_baurate	equ		bios_work+0070H		;      1 byte	: RS232C baurate
RS232C_status	equ		bios_work+0071H		;      1 byte	: RS232C status
;------------------------------------------------------------------------
line_buffer	equ		bios_work+0080H		;    128 bytes  : Iine buffer

;===============  Define Buffer  ========================================

RS232C_buffer	equ		001E00H			;   256 bytes	: RS232C input buffer
Keyboard_buffer	equ		001F00H			;   256 bytes	: Keyboard input buffer
Bitmap_buffer	equ		7E2000H			; 12288 bytes	: Bitmap emulation character
Screen_buffer	equ		7E5000H			;  2048 bytes	: Bitmap emulation screen

