;************************************************************************
;*									*
;*	title name	: "yossy"					*
;*	proccess	: mario chip player data			*
;*	file name	: ys_mpldt					*
;*									*
;************************************************************************
;
;
		SALL
;
		include		ys_chip.inc
;
		XALL
;
;
;------------------------------------------------------------------------
;-		global symbol						-
;------------------------------------------------------------------------
		GLB	PLAYER_DATA
;
		GLB	MOVE_SOUND
;
		GLB	ON_SOAP,ON_WATR,ON_ICEB,ON_YUKI,ON_DORO,ON_SKI
;
		GLB	DOSN_PATN,DOSN_DOWN,DOSN_END,DOSN_TMDT,DUST0_SET_POS
		GLB	DOSN_DOWN_P,DOSN_END_P
;
		GLB	SWIM_INDT,SWIM_PATN,SWIM_DW_PATN
		GLB	WTUP1_STDT
;
;;;;		    GLB	    DSMK0_SET_TM,DSMK0_SET_PS
;
		GLB	PLBGCK_POINT,PLBGCK_POINT_00,PLBGCK_POINT_01,PLBGCK_POINT_SW
		GLB	PLBGCK_POINT_HR,PLBGCK_POINT_MG,PLBGCK_POINT_TR
		GLB	PLBGCK_POINT_MR,PLBGCK_POINT_MR0,PLBGCK_POINT_MR1
		GLB	DOKAN_TYPE
		GLB	KAIDAN_PATN
		GLB	DSMK1_STCK
		GLB	WALK_SP,DASH_SP
		GLB	MAX_SPEED,MAX_DASH,ADD_SPEED,MIN_SPEED,SUB_SPEED
		GLB	CAR_MAX_DASH
;
		GLB	EAT_OFST_POS,BERO_SHOT_DT,BERO_PATN,EAT_END_PT
		GLB	EAT_END_PT_END,EATEND,EATEGGEND,SPSHOT_ENNO
		GLB	BERO_BIRI_PATN,BERO_BIRI_P
;
		GLB	FIRE_SET_XY
		GLB	FIRE_ST_P,FIRE_ST_M
;
		GLB	SOAP_SET_TMG,SOAP_SET_TMG_NO
		GLB	SOAP_SET_XY
		GLB	SOAP_ST_P,SOAP_ST_M
;
		GLB	SUIKA_SET_XY
		GLB	SUIKA_ST_P,SUIKA_ST_M
;
		GLB	FAIL_KYORO_PATN,SUIKA_SHOT_PATN
		GLB	ROTATION_PATN,ROT_DOWN_PATN,ROT_DOWN_TIM,ROT_DOWN_P
		GLB	NAGE_PATN,NAGE_P,NAGE_PATN_TMDT,SIT_PATN,SDBOYO_PATN,HDBOYO_PATN
		GLB	SPJMP_PATN,SPJMP_NAGE_PATN,JMPEND_PATN,JMPEND_PATN_E,JPET,SLIP_PATN
		GLB	NAGE_SLIP_PATN,PUSH_PATN,PLSTOP_PATN,MABATAKI,PORIPORI,KYORKYOR
		GLB	TANTAN,PLSTOP_PATN_E,PLSTOP_TMDT,PLSTOP_PTIN,WALK_TMDT
		GLB	BGWK00,BGWK01,BGWK02,BGWK03,BGWK04,WALK_TMDT_E
		GLB	BGWK05,BGWK06,BGWK07,BGWK08,BGWK09,BGWK0A
		GLB	WLKMX,WLKMX_C,WLKMX_Cx2,WLKMX_Cw2,WALK_SOUND,WALK_TMIN,WALK_PATN
		GLB	FR_CK,FR_MV,FURA_TMDT,FURA_PATN,FURA_EGG_PATN
		GLB	BURAN_PATN,BURAN_P
;
		GLB	HR_MKCG_PT,HR_MOVE_DT
		GLB	SB_MOVE_DT
;
		GLB	PLBGCK_POINT_CR,CAR_CHAR,CAR_TIRE_XREV
;
		GLB	MG_MVKEY,MG_FOOTBGP,MG_HEADBGP,MG_SIDEBGP,MG_DWMKCHG
		GLB	MG_UPMKCHG,MG_FOOTHSD,MG_POSCNV,MG_KEYCNV,MG_MVANGL
;
		GLB	MR_WLK_CHRDT,MR_HOB_CHRDT
		GLB	MR_WK0_CHR,MR_WK1_CHR,MR_WK2_CHR,MR_WK3_CHR
		GLB	MR_SIT_CHR,MR_JMP_CHR,MR_STP_CHR,MR_HOB_CHR
		GLB	MR_PCE_CHR,MR_SLP_CHR
;
		GLB	MR_MANT_JMPUP,MR_MANT_JMPDW,MR_MANT_NOJMP
		GLB	MR_CHR_TYPE,MR_MANT_PATN
		GLB	MR_P_STOP,MR_P_SITD,MR_P_UPJP,MR_P_DWJP,MR_P_SLIP
		GLB	MR_P_WLK0,MR_P_WLK1,MR_P_WLK2,MR_P_WLK3
;
		GLB	TR_CHR_ADRS,GO_RALE_KEY,RALE_BIT_AND,RALE_BIT_DATA
		GLB	GO_RALE_HSDT,RALE_HS_ANAD,TR_KEY_ANGL
;
;------------------------------------------------------------------------
;-		extern symbol						-
;------------------------------------------------------------------------
;
;-------------< GmD >---------------------------------------
		EXT	FIRE0,SOPB0,SUIKA,COLD0
;
;
;------------------------------------------------------------------------
;-		define symbol						-
;------------------------------------------------------------------------
;
;************************************************************************
;*									*
;*		program start						*
;*									*
;************************************************************************
;
;
Group_A		GROUP	S_play_data
S_play_data	SECT	REL
;
;
;************************************************************************
;*									*
;*		vC[f[^					*
;*									*
;************************************************************************
;
PLAYER_DATA
;
;
;------------------------------------------------------------------------
;-		vC[ړTEhtOf[^			-
;------------------------------------------------------------------------
MOVE_SOUND
		BYTE	00000000B	;ʂ̃bV[
		BYTE	01000100B	;N}
		BYTE	10000100B	;O
		BYTE	00000100B	;wRv^[
;;;;		    BYTE    10100100B	    ;D
		BYTE	00000000B	;D
		BYTE	00000000B	;LmR
		BYTE	01100100B	;
		BYTE	00000000B	;XL[
		BYTE	00000000B	;}I
		BYTE	00000000B	;^}S
;
;------------------------------------------------------------------------
;-		hhX[IIhpf[^				-
;------------------------------------------------------------------------
;
;-------------- hhX[IIhp^[f[^ --------------------------
DOSN_PATN
		WORD	PD09,PD0A,PD0B,PD0C,PD0D,PD0E,PD0F ;]
		WORD	PD0F				   ;
DOSN_DOWN	WORD	PD10,PD11,PD12,PD11,PD10	   ;n
DOSN_END
DOSN_DOWN_P	EQU	(DOSN_DOWN-DOSN_PATN-2)/2
DOSN_END_P	EQU	(DOSN_END-DOSN_PATN-2)/2
;
;-------------- hhX[IIhp^[؂ւ^C}[f[^ ----------
DOSN_TMDT
		WORD	     03,  02,  02,  02,	 02,  08
		WORD	00
		WORD	01,  01,  02,  01,  01,	 00
;
;-------------- hhX[IIhʃZbgʒuf[^ ----------------
DUST0_SET_POS
; player pos + -->	 X  Y	 [RANDM0&07H]
		HEX	F8,18	;[0]
		HEX	FC,1C	;[1]
		HEX	00,08	;[2]
		HEX	04,14	;[3]
		HEX	08,06	;[4]
		HEX	02,06	;[5]
		HEX	FE,1A	;[6]
		HEX	02,0E	;[7]
;
;
;------------------------------------------------------------------------
;-		jZbgf[^				-
;------------------------------------------------------------------------
SWIM_INDT
		HEX	C0,04
		WORD	      SW1E
		HEX	FF,00
		WORD	      SW1F
;
;------------------------------------------------------------------------
;-		jp^[f[^					-
;------------------------------------------------------------------------
SWIM_PATN			   ;[PLWALK]
		WORD	MZ00,MZ0B  ;[0]
		WORD	MZ01,MZ0E  ;[1]
		WORD	MZ02,MZ0E  ;[2]
		WORD	MZ03,MZ0F  ;[3]
		WORD	MZ04,MZ0C  ;[4]
		WORD	MZ05,MZ0D  ;[5]
		WORD	MZ06,MZ0E  ;[6]
		WORD	MZ07,MZ0F  ;[7]
;
SWIM_DW_PATN
; PLDWFG -->		 [1]  [2]  [3]	[4]  [5]  [6]  [7]  [8]	 [9]
		WORD	MZ09,MZ09,MZ09,MZ09,MZ0A,MZ0A,MZ0A,MZ0A,MZ0B
;
;------------------------------------------------------------------------
;-		hs`s`hʃZbgf[^			-
;------------------------------------------------------------------------
WTUP1_STDT	EQU	$
;			TM Ya	;[PLXSPD/100H]
		HEX	0F,08	;[0]
		HEX	07,06	;[1]
		HEX	07,04	;[2]
		HEX	07,04	;[3]
		HEX	03,04	;[4]
		HEX	03,04	;[5]
		HEX	01,04	;[6]
		HEX	01,04	;[7]
		HEX	00,04	;[8]
;
;;;;;------------------------------------------------------------------------
;;;;;-		    ߃_bVڂZbgpf[^			    -
;;;;;------------------------------------------------------------------------
;;;;;
;;;;;-------------- ڂZbg^C~Of[^ --------------------------
;;;;DSMK0_SET_TM
;;;;; PLMVSP/100H -->	    0  1  2  3	4  5  6	 7  8
;;;;		    HEX	    00,0F,0F,07,07,03,03,01,01
;;;;;
;;;;;-------------- ڂZbgʒuf[^ --------------------------------
;;;;DSMK0_SET_PS
;;;;; PLCMKI -->		      [0]		       [2]
;;;;		    WORD     0FCH+(016H*100H),00000H, 004H+(016H*100H),00000H  ;[0]
;;;;		    WORD     0F8H+(015H*100H),0FF80H, 008H+(015H*100H),0FF80H  ;[1]
;;;;		    WORD     0F6H+(013H*100H),0FF60H, 00AH+(013H*100H),0FF60H  ;[2]
;;;;		    WORD     0FCH+(014H*100H),0FF00H, 004H+(014H*100H),0FF00H  ;[3]
;;;;		    WORD     0F6H+(013H*100H),0FF80H, 00AH+(013H*100H),0FF80H  ;[4]
;;;;		    WORD     0FAH+(016H*100H),0FFB0H, 006H+(016H*100H),0FFB0H  ;[5]
;;;;		    WORD     0FEH+(017H*100H),0FF40H, 002H+(017H*100H),0FF40H  ;[6]
;;;;		    WORD     0F8H+(014H*100H),00000H, 008H+(014H*100H),00000H  ;[7]
;
;
;------------------------------------------------------------------------
;-		af`FbNpf[^					-
;------------------------------------------------------------------------
;
;----------------------------------------------------------------
;-		af`FbN|Cgf[^			-
;----------------------------------------------------------------
PLBGCK_POINT
;
PLBGCK_POINT_00			;Ă郈bV[
		HEX	01,09	;(up  left side)
		HEX	01,17	;(low	 "     )
		HEX	0F,09	;(up  right  " )
		HEX	0F,17	;(low	 "     )
		HEX	06,04	;(left hed)
		HEX	0A,04	;(right " )
		HEX	03,20	;(left foot)
		HEX	08,20	;(center foot)
		HEX	0D,20	;(right	 " )
;
PLBGCK_POINT_01			;Ă郈bV[
		HEX	01,16	;(up  left side)
		HEX	01,17	;(low	 "     )
		HEX	0F,16	;(up  right  " )
		HEX	0F,17	;(low	 "     )
		HEX	06,10	;(left hed)
		HEX	0A,10	;(right " )
		HEX	03,20	;(left foot)
		HEX	08,20	;(center foot)
		HEX	0D,20	;(right	 " )
;
PLBGCK_POINT_SW			;jbV[
		HEX	01,0C	;(up  left side)
		HEX	01,16	;(low	 "     )
		HEX	0F,0C	;(up  right  " )
		HEX	0F,16	;(low	 "     )
		HEX	06,04	;(left hed)
		HEX	0A,04	;(right " )
		HEX	03,20	;(left foot)
		HEX	08,20	;(center foot)
		HEX	0D,20	;(right	 " )
;
PLBGCK_POINT_HR			;wRv^[
		HEX	01,14	;(up  left side)
		HEX	01,16	;(low	 "     )
		HEX	0F,14	;(up  right  " )
		HEX	0F,16	;(low	 "     )
		HEX	06,10	;(left hed)
		HEX	0A,10	;(right " )
		HEX	03,20	;(left foot)
		HEX	08,20	;(center foot)
		HEX	0D,20	;(right	 " )
;
PLBGCK_POINT_CR			;܂
		HEX	F3,F8	;(high left  side)
		HEX	F3,00	;(low	  "      )
		HEX	0C,F8	;(high right  "  )
		HEX	0C,00	;(low	   "     )
		HEX	F7,F4	;(left	 hed)
		HEX	00,F4	;(center  " )
		HEX	09,F4	;(right	  " )
		HEX	F7,08	;(left	 foot)
		HEX	00,08	;(center  "  )
		HEX	09,08	;(right	  "  )
;
PLBGCK_POINT_MG			;O
		HEX	FC,0C	;(up  left side)
		HEX	FC,18	;(low	 "     )
		HEX	13,0C	;(up  right  " )
		HEX	13,17	;(low	 "     )
		HEX	07,0C	;(center hed)
		HEX	FC,23	;(left foot)
		HEX	08,23	;(center foot)
		HEX	13,23	;(right	 " )
;
;;;;		    HEX	    FC,0C   ;(up  left side)
;;;;		    HEX	    FD,18   ;(low    "     )
;;;;		    HEX	    13,0C   ;(up  right	 " )
;;;;		    HEX	    12,17   ;(low    "     )
;;;;		    HEX	    07,0D   ;(center hed)
;;;;		    HEX	    FC,23   ;(left foot)
;;;;		    HEX	    08,22   ;(center foot)
;;;;		    HEX	    13,23   ;(right  " )
;
PLBGCK_POINT_MR			;}Ii\jbN[hj
		BYTE	02H-08H,0BH-20H	  ;(up	left side)
		BYTE	02H-08H,10H-20H	  ;(low	   "     )
		BYTE	0EH-08H,0BH-20H	  ;(up	right  " )
		BYTE	0EH-08H,10H-20H	  ;(low	   "     )
		BYTE	08H-08H,08H-20H	  ;(hed)
		BYTE	08H-08H,20H-20H	  ;(foot)
;
PLBGCK_POINT_MR0		;Ă}I
		HEX	01,0B	;(up  left side)
		HEX	01,16	;(low	 "     )
		HEX	0F,0B	;(up  right  " )
		HEX	0F,16	;(low	 "     )
		HEX	06,07	;(left hed)
		HEX	0A,07	;(right " )
		HEX	03,20	;(left foot)
		HEX	08,20	;(center foot)
		HEX	0D,20	;(right	 " )
;
PLBGCK_POINT_MR1		;Ă}I
		HEX	01,16	;(up  left side)
		HEX	01,16	;(low	 "     )
		HEX	0F,16	;(up  right  " )
		HEX	0F,16	;(low	 "     )
		HEX	06,10	;(left hed)
		HEX	0A,10	;(right " )
		HEX	03,20	;(left foot)
		HEX	08,20	;(center foot)
		HEX	0D,20	;(right	 " )
;
PLBGCK_POINT_TR			;D
		HEX	FE,08	;(up  left side)
		HEX	FE,16	;(low	 "     )
		HEX	12,08	;(up  right  " )
		HEX	12,16	;(low	 "     )
		HEX	02,04	;(left hed)
		HEX	0E,04	;(right " )
		HEX	00,20	;(left foot)
		HEX	08,20	;(center foot)
		HEX	10,20	;(right	 " )
;
;----------------------------------------------------------------
;-		hJ^Cv`FbNf[^			-
;----------------------------------------------------------------
DOKAN_TYPE
		BYTE	00000000B,00000001B,00000100B,10000100B ;[0]
		BYTE	00000000B,00000010B,00001000B,10001000B ;[4]
;
		BYTE	00000100B,10000100B,00001000B,10001000B ;[9]
;
		BYTE	01000000B,01000000B,01000000B,01000010B ;[10]
		BYTE	01000000B,01000000B,01000001B,01000000B ;[14]
		BYTE	01000000B,01000000B,01001000B,11001000B ;[18]
		BYTE	01000100B,11000100B,01000000B,01000000B ;[1C]
;
		BYTE		  00000100B,10000100B,00000000B ;[21]
		BYTE	00000001B,10000000B,00000010B,00000100B ;[24]
		BYTE	10000100B,00000100B,10000100B		;[28]
;
;----------------------------------------------------------------
;-		Kip^[f[^				-
;----------------------------------------------------------------
KAIDAN_PATN				;[PLYPSL&0F]
		WORD	KU0F,KD00	;[0]
		WORD	KU0E,KD01	;[1]
		WORD	KU0D,KD02	;[2]
		WORD	KU0C,KD03	;[3]
		WORD	KU0B,KD04	;[4]
		WORD	KU0A,KD05	;[5]
		WORD	KU09,KD06	;[6]
		WORD	KU08,KD07	;[7]
		WORD	KU07,KD08	;[8]
		WORD	KU06,KD09	;[9]
		WORD	KU05,KD0A	;[A]
		WORD	KU04,KD0B	;[B]
		WORD	KU03,KD0C	;[C]
		WORD	KU02,KD0D	;[D]
		WORD	KU01,KD0E	;[E]
		WORD	KU00,KD0F	;[F]
;
;----------------------------------------------------------------
;-		_bVyނZbg^C~Of[^		-
;----------------------------------------------------------------
DSMK1_STCK
; X speed / 100H -->	0  1  2	 3  4  5  6  7	8
		HEX	00,00,00,00,1F,0F,07,03,03
;
;
;------------------------------------------------------------------------
;-		ړXs[hf[^					-
;------------------------------------------------------------------------
;;;;WALK_SP	    EQU	    0280H   ;nł̕Xs[h
WALK_SP		EQU	0300H	;nł̕Xs[h
DASH_SP		EQU	0800H	;    h	 ߃_bVXs[h
FURA_SP		EQU	0080H	;htthXs[h
WFLR_SP		EQU	0200H	;ꏰł̃Xs[h
;
WATR_SP		EQU	0180H	;ł̃Xs[h
YUKI_SP		EQU	0290H	;̏ł̃Xs[h
DORO_SP		EQU	0100H	;D̏ł̃Xs[h
DORO_SK		EQU	0080H	;	 "         ij
;
CRDS_SP		EQU	0800H	;܂̗߃_bVXs[h
;
;----------------------------------------------------------------
;-		l`wXs[hf[^				-
;----------------------------------------------------------------
ON_WATR		EQU	1
ON_SOAP		EQU	2
ON_ICEB		EQU	3
ON_YUKI		EQU	4
ON_DORO		EQU	5
ON_SKI		EQU	6
;
MAX_SPEED
; ړ -->		iEj	 ij		;[PLBGNO]	[PLANGL/10H]
		WORD	WALK_SP,-WALK_SP	;[0] ʂ̏	[0]
		WORD	WALK_SP,-WALK_SP	;		[1]
		WORD	WALK_SP,-WALK_SP	;    Wv	[2]
		WORD	WALK_SP,-WALK_SP	;		[3]
		WORD	WALK_SP,-WALK_SP	;		[4]
		WORD	WALK_SP,-WALK_SP	;		[5]
		WORD	WALK_SP,-WALK_SP	;		[6]
		WORD	WALK_SP,-WALK_SP	;		[7]
		WORD	WALK_SP,-WALK_SP	;		[8]
		WORD	WALK_SP,-WALK_SP	;		[9]
		WORD	WALK_SP,-WALK_SP	;		[A]
		WORD	WALK_SP,-WALK_SP	;		[B]
		WORD	WALK_SP,-WALK_SP	;		[C]
		WORD	WALK_SP,-WALK_SP	;		[D]
		WORD	WALK_SP,-WALK_SP	;		[E]
		WORD	WALK_SP,-WALK_SP	;		[F]
;
		WORD	WATR_SP,-WATR_SP	;[1] 	[0]
		WORD	WATR_SP,-WATR_SP	;		[1]
		WORD	WATR_SP,-WATR_SP	;		[2]
		WORD	WATR_SP,-WATR_SP	;		[3]
		WORD	WATR_SP,-WATR_SP	;		[4]
		WORD	WATR_SP,-WATR_SP	;		[5]
		WORD	WATR_SP,-WATR_SP	;		[6]
		WORD	WATR_SP,-WATR_SP	;		[7]
		WORD	WATR_SP,-WATR_SP	;		[8]
		WORD	WATR_SP,-WATR_SP	;		[9]
		WORD	WATR_SP,-WATR_SP	;		[A]
		WORD	WATR_SP,-WATR_SP	;		[B]
		WORD	WATR_SP,-WATR_SP	;		[C]
		WORD	WATR_SP,-WATR_SP	;		[D]
		WORD	WATR_SP,-WATR_SP	;		[E]
		WORD	WATR_SP,-WATR_SP	;		[F]
;
		WORD	WALK_SP,-WALK_SP	;[2] 	[0]
		WORD	WALK_SP,-WALK_SP	;		[1]
		WORD	WALK_SP,-WALK_SP	;		[2]
		WORD	WALK_SP,-WALK_SP	;		[3]
		WORD	WALK_SP,-WALK_SP	;		[4]
		WORD	WALK_SP,-WALK_SP	;		[5]
		WORD	WALK_SP,-WALK_SP	;		[6]
		WORD	WALK_SP,-WALK_SP	;		[7]
		WORD	WALK_SP,-WALK_SP	;		[8]
		WORD	WALK_SP,-WALK_SP	;		[9]
		WORD	WALK_SP,-WALK_SP	;		[A]
		WORD	WALK_SP,-WALK_SP	;		[B]
		WORD	WALK_SP,-WALK_SP	;		[C]
		WORD	WALK_SP,-WALK_SP	;		[D]
		WORD	WALK_SP,-WALK_SP	;		[E]
		WORD	WALK_SP,-WALK_SP	;		[F]
;
		WORD	WALK_SP,-WALK_SP	;[3] XubN [0]
		WORD	WALK_SP,-WALK_SP	;		[1]
		WORD	WALK_SP,-WALK_SP	;		[2]
		WORD	WALK_SP,-WALK_SP	;		[3]
		WORD	WALK_SP,-WALK_SP	;		[4]
		WORD	WALK_SP,-WALK_SP	;		[5]
		WORD	WALK_SP,-WALK_SP	;		[6]
		WORD	WALK_SP,-WALK_SP	;		[7]
		WORD	WALK_SP,-WALK_SP	;		[8]
		WORD	WALK_SP,-WALK_SP	;		[9]
		WORD	WALK_SP,-WALK_SP	;		[A]
		WORD	WALK_SP,-WALK_SP	;		[B]
		WORD	WALK_SP,-WALK_SP	;		[C]
		WORD	WALK_SP,-WALK_SP	;		[D]
		WORD	WALK_SP,-WALK_SP	;		[E]
		WORD	WALK_SP,-WALK_SP	;		[F]
;
		WORD	YUKI_SP,-YUKI_SP	;[4] ̏	[0]
		WORD	YUKI_SP,-YUKI_SP	;		[1]
		WORD	YUKI_SP,-YUKI_SP	;		[2]
		WORD	YUKI_SP,-YUKI_SP	;		[3]
		WORD	YUKI_SP,-YUKI_SP	;		[4]
		WORD	YUKI_SP,-YUKI_SP	;		[5]
		WORD	YUKI_SP,-YUKI_SP	;		[6]
		WORD	YUKI_SP,-YUKI_SP	;		[7]
		WORD	YUKI_SP,-YUKI_SP	;		[8]
		WORD	YUKI_SP,-YUKI_SP	;		[9]
		WORD	YUKI_SP,-YUKI_SP	;		[A]
		WORD	YUKI_SP,-YUKI_SP	;		[B]
		WORD	YUKI_SP,-YUKI_SP	;		[C]
		WORD	YUKI_SP,-YUKI_SP	;		[D]
		WORD	YUKI_SP,-YUKI_SP	;		[E]
		WORD	YUKI_SP,-YUKI_SP	;		[F]
;
		WORD	DORO_SP,-DORO_SP	;[5] D		[0]
		WORD	DORO_SP,-DORO_SP	;		[1]
		WORD	DORO_SK,-WALK_SP	;		[2]
		WORD	DORO_SP,-DORO_SP	;		[3]
		WORD	DORO_SP,-DORO_SP	;		[4]
		WORD	DORO_SP,-DORO_SP	;		[5]
		WORD	DORO_SP,-DORO_SP	;		[6]
		WORD	DORO_SP,-DORO_SP	;		[7]
		WORD	DORO_SP,-DORO_SP	;		[8]
		WORD	DORO_SP,-DORO_SP	;		[9]
		WORD	DORO_SP,-DORO_SP	;		[A]
		WORD	DORO_SP,-DORO_SP	;		[B]
		WORD	DORO_SP,-DORO_SP	;		[C]
		WORD	DORO_SP,-DORO_SP	;		[D]
		WORD	WALK_SP,-DORO_SK	;		[E]
		WORD	DORO_SP,-DORO_SP	;		[F]
;
MAX_DASH	WORD	DASH_SP,-DASH_SP	;߃_bV
;
CAR_MAX_DASH	WORD	CRDS_SP,-CRDS_SP	;܂̗߃_bV
;
;----------------------------------------------------------------
;-		lf[^					-
;----------------------------------------------------------------
ADD_SPEED
;		       ij,iXbvj ;[PLBGNO]	 [PLANGL/10H]
		WORD	 010H,038H,-010H,-038H	 ;[0] ʂ̏	 [0]
		WORD	 010H,038H,-010H,-038H	 ;	 	 [1]
		WORD	 010H,038H,-010H,-038H	 ;    Wv	 [2]
		WORD	 010H,038H,-010H,-038H	 ;		 [3]
		WORD	 010H,038H,-010H,-038H	 ;		 [4]
		WORD	 010H,038H,-010H,-038H	 ;		 [5]
		WORD	 010H,038H,-010H,-038H	 ;		 [6]
		WORD	 010H,038H,-010H,-038H	 ;		 [7]
		WORD	 010H,038H,-010H,-038H	 ;		 [8]
		WORD	 010H,038H,-010H,-038H	 ;		 [9]
		WORD	 010H,038H,-010H,-038H	 ;		 [A]
		WORD	 010H,038H,-010H,-038H	 ;		 [B]
		WORD	 010H,038H,-010H,-038H	 ;		 [C]
		WORD	 010H,038H,-010H,-038H	 ;		 [D]
		WORD	 010H,038H,-010H,-038H	 ;		 [E]
		WORD	 010H,038H,-010H,-038H	 ;		 [F]
;
		WORD	 006H,00AH,-006H,-00AH	 ;[1] 	 [0]
		WORD	 006H,00AH,-006H,-00AH	 ;		 [1]
		WORD	 006H,00AH,-006H,-00AH	 ;		 [2]
		WORD	 006H,00AH,-006H,-00AH	 ;		 [3]
		WORD	 006H,00AH,-006H,-00AH	 ;		 [4]
		WORD	 006H,00AH,-006H,-00AH	 ;		 [5]
		WORD	 006H,00AH,-006H,-00AH	 ;		 [6]
		WORD	 006H,00AH,-006H,-00AH	 ;		 [7]
		WORD	 006H,00AH,-006H,-00AH	 ;		 [8]
		WORD	 006H,00AH,-006H,-00AH	 ;		 [9]
		WORD	 006H,00AH,-006H,-00AH	 ;		 [A]
		WORD	 006H,00AH,-006H,-00AH	 ;		 [B]
		WORD	 006H,00AH,-006H,-00AH	 ;		 [C]
		WORD	 006H,00AH,-006H,-00AH	 ;		 [D]
		WORD	 006H,00AH,-006H,-00AH	 ;		 [E]
		WORD	 006H,00AH,-006H,-00AH	 ;		 [F]
;
		WORD	 002H,003H,-002H,-003H	 ;[2] 	 [0]
		WORD	 002H,003H,-002H,-003H	 ;		 [1]
		WORD	 002H,003H,-002H,-003H	 ;		 [2]
		WORD	 002H,003H,-002H,-003H	 ;		 [3]
		WORD	 002H,003H,-002H,-003H	 ;		 [4]
		WORD	 002H,003H,-002H,-003H	 ;		 [5]
		WORD	 002H,003H,-002H,-003H	 ;		 [6]
		WORD	 002H,003H,-002H,-003H	 ;		 [7]
		WORD	 002H,003H,-002H,-003H	 ;		 [8]
		WORD	 002H,003H,-002H,-003H	 ;		 [9]
		WORD	 002H,003H,-002H,-003H	 ;		 [A]
		WORD	 002H,003H,-002H,-003H	 ;		 [B]
		WORD	 002H,003H,-002H,-003H	 ;		 [C]
		WORD	 002H,003H,-002H,-003H	 ;		 [D]
		WORD	 002H,003H,-002H,-003H	 ;		 [E]
		WORD	 002H,003H,-002H,-003H	 ;		 [F]
;
		WORD	 004H,008H,-004H,-008H	 ;[3] XubN [0]
		WORD	 004H,008H,-004H,-008H	 ;		 [1]
		WORD	 004H,008H,-004H,-008H	 ;		 [2]
		WORD	 004H,008H,-004H,-008H	 ;		 [3]
		WORD	 004H,008H,-004H,-008H	 ;		 [4]
		WORD	 004H,008H,-004H,-008H	 ;		 [5]
		WORD	 004H,008H,-004H,-008H	 ;		 [6]
		WORD	 004H,008H,-004H,-008H	 ;		 [7]
		WORD	 004H,008H,-004H,-008H	 ;		 [8]
		WORD	 004H,008H,-004H,-008H	 ;		 [9]
		WORD	 004H,008H,-004H,-008H	 ;		 [A]
		WORD	 004H,008H,-004H,-008H	 ;		 [B]
		WORD	 004H,008H,-004H,-008H	 ;		 [C]
		WORD	 004H,008H,-004H,-008H	 ;		 [D]
		WORD	 004H,008H,-004H,-008H	 ;		 [E]
		WORD	 004H,008H,-004H,-008H	 ;		 [F]
;
		WORD	 008H,038H,-008H,-038H	 ;[4] ̏	 [0]
		WORD	 008H,038H,-008H,-038H	 ;		 [1]
		WORD	 008H,038H,-008H,-038H	 ;		 [2]
		WORD	 008H,038H,-008H,-038H	 ;		 [3]
		WORD	 008H,038H,-008H,-038H	 ;		 [4]
		WORD	 008H,038H,-008H,-038H	 ;		 [5]
		WORD	 008H,038H,-008H,-038H	 ;		 [6]
		WORD	 008H,038H,-008H,-038H	 ;		 [7]
		WORD	 008H,038H,-008H,-038H	 ;		 [8]
		WORD	 008H,038H,-008H,-038H	 ;		 [9]
		WORD	 008H,038H,-008H,-038H	 ;		 [A]
		WORD	 008H,038H,-008H,-038H	 ;		 [B]
		WORD	 008H,038H,-008H,-038H	 ;		 [C]
		WORD	 008H,038H,-008H,-038H	 ;		 [D]
		WORD	 008H,038H,-008H,-038H	 ;		 [E]
		WORD	 008H,038H,-008H,-038H	 ;		 [F]
;
		WORD	 006H,00AH,-006H,-00AH	 ;[5] D	 [0]
		WORD	 006H,004H,-006H,-00AH	 ;		 [1]
		WORD	 002H,004H,-008H,-010H	 ;		 [2]
		WORD	 006H,00AH,-006H,-00AH	 ;		 [3]
		WORD	 006H,00AH,-006H,-00AH	 ;		 [4]
		WORD	 006H,00AH,-006H,-00AH	 ;		 [5]
		WORD	 006H,00AH,-006H,-00AH	 ;		 [6]
		WORD	 006H,00AH,-006H,-00AH	 ;		 [7]
		WORD	 006H,00AH,-006H,-00AH	 ;		 [8]
		WORD	 006H,00AH,-006H,-00AH	 ;		 [9]
		WORD	 006H,00AH,-006H,-00AH	 ;		 [A]
		WORD	 006H,00AH,-006H,-00AH	 ;		 [B]
		WORD	 006H,00AH,-006H,-00AH	 ;		 [C]
		WORD	 006H,00AH,-006H,-00AH	 ;		 [D]
		WORD	 008H,010H,-002H,-004H	 ;		 [E]
		WORD	 006H,00AH,-006H,-00AH	 ;		 [F]
;
;----------------------------------------------------------------
;-		lhmXs[hf[^				-
;----------------------------------------------------------------
MIN_SPEED
;					;[PLBGNO]	[PLANGL/10H]
		WORD	00000H		;[0] ʂ̏	[0]
		WORD	00000H		;		[1]
		WORD	00000H		;    Wv	[2]
		WORD	00000H		;		[3]
		WORD	00000H		;		[4]
		WORD	00000H		;		[5]
		WORD	00000H		;		[6]
		WORD	00000H		;		[7]
		WORD	00000H		;		[8]
		WORD	00000H		;		[9]
		WORD	00000H		;		[A]
		WORD	00000H		;		[B]
		WORD	00000H		;		[C]
		WORD	00000H		;		[D]
		WORD	00000H		;		[E]
		WORD	00000H		;		[F]
;
		WORD	00000H		;[1] 	[0]
		WORD	00000H		;		[1]
		WORD	00000H		;		[2]
		WORD	00000H		;		[3]
		WORD	00000H		;		[4]
		WORD	00000H		;		[5]
		WORD	00000H		;		[6]
		WORD	00000H		;		[7]
		WORD	00000H		;		[8]
		WORD	00000H		;		[9]
		WORD	00000H		;		[A]
		WORD	00000H		;		[B]
		WORD	00000H		;		[C]
		WORD	00000H		;		[D]
		WORD	00000H		;		[E]
		WORD	00000H		;		[F]
;
		WORD	00000H		;[2] 	[0]
		WORD	00000H		;		[1]
		WORD	00000H		;		[2]
		WORD	00000H		;		[3]
		WORD	00000H		;		[4]
		WORD	00000H		;		[5]
		WORD	00000H		;		[6]
		WORD	00000H		;		[7]
		WORD	00000H		;		[8]
		WORD	00000H		;		[9]
		WORD	00000H		;		[A]
		WORD	00000H		;		[B]
		WORD	00000H		;		[C]
		WORD	00000H		;		[D]
		WORD	00000H		;		[E]
		WORD	00000H		;		[F]
;
		WORD	00000H		;[3] XubN [0]
		WORD	00000H		;		[1]
		WORD	00000H		;		[2]
		WORD	00000H		;		[3]
		WORD	00000H		;		[4]
		WORD	00000H		;		[5]
		WORD	00000H		;		[6]
		WORD	00000H		;		[7]
		WORD	00000H		;		[8]
		WORD	00000H		;		[9]
		WORD	00000H		;		[A]
		WORD	00000H		;		[B]
		WORD	00000H		;		[C]
		WORD	00000H		;		[D]
		WORD	00000H		;		[E]
		WORD	00000H		;		[F]
;
		WORD	00000H		;[4] ̏    [0]
		WORD	00000H		;		[1]
		WORD	00000H		;		[2]
		WORD	00000H		;		[3]
		WORD	00000H		;		[4]
		WORD	00000H		;		[5]
		WORD	00000H		;		[6]
		WORD	00000H		;		[7]
		WORD	00000H		;		[8]
		WORD	00000H		;		[9]
		WORD	00000H		;		[A]
		WORD	00000H		;		[B]
		WORD	00000H		;		[C]
		WORD	00000H		;		[D]
		WORD	00000H		;		[E]
		WORD	00000H		;		[F]
;
		WORD	00000H		;[5] D	       [0]
		WORD	00000H		;		[1]
		WORD	0FF00H		;		[2]
		WORD	00000H		;		[3]
		WORD	00000H		;		[4]
		WORD	00000H		;		[5]
		WORD	00000H		;		[6]
		WORD	00000H		;		[7]
		WORD	00000H		;		[8]
		WORD	00000H		;		[9]
		WORD	00000H		;		[A]
		WORD	00000H		;		[B]
		WORD	00000H		;		[C]
		WORD	00000H		;		[D]
		WORD	00100H		;		[E]
		WORD	00000H		;		[F]
;
		WORD	00380H		;[6] XL[ [0]
		WORD	00340H		;		[1]
		WORD	00300H		;		[2]
		WORD	00300H		;		[3]
		WORD	00480H		;		[4]
		WORD	00480H		;		[5]
		WORD	00480H		;		[6]
		WORD	00480H		;		[7]
		WORD	00480H		;		[8]
		WORD	00480H		;		[9]
		WORD	00480H		;		[A]
		WORD	00480H		;		[B]
		WORD	00480H		;		[C]
		WORD	00480H		;		[D]
		WORD	00480H		;		[E]
		WORD	00400H		;		[F]
;
;----------------------------------------------------------------
;-		lf[^					-
;----------------------------------------------------------------
SUB_SPEED
;  -->		iEjij	;[PLBGNO]	[PLANGL/10H]
		WORD	-020H, 020H	;[0] ʂ̏	[0]
		WORD	-020H, 020H	;		[1]
		WORD	-020H, 020H	;    Wv	[2]
		WORD	-020H, 020H	;		[3]
		WORD	-020H, 020H	;		[4]
		WORD	-020H, 020H	;		[5]
		WORD	-020H, 020H	;		[6]
		WORD	-020H, 020H	;		[7]
		WORD	-020H, 020H	;		[8]
		WORD	-020H, 020H	;		[9]
		WORD	-020H, 020H	;		[A]
		WORD	-020H, 020H	;		[B]
		WORD	-020H, 020H	;		[C]
		WORD	-020H, 020H	;		[D]
		WORD	-020H, 020H	;		[E]
		WORD	-020H, 020H	;		[F]
;
		WORD	-003H, 003H	;[1] 	[0]
		WORD	-003H, 003H	;		[1]
		WORD	-003H, 003H	;		[2]
		WORD	-003H, 003H	;		[3]
		WORD	-003H, 003H	;		[4]
		WORD	-003H, 003H	;		[5]
		WORD	-003H, 003H	;		[6]
		WORD	-003H, 003H	;		[7]
		WORD	-003H, 003H	;		[8]
		WORD	-003H, 003H	;		[9]
		WORD	-003H, 003H	;		[A]
		WORD	-003H, 003H	;		[B]
		WORD	-003H, 003H	;		[C]
		WORD	-003H, 003H	;		[D]
		WORD	-003H, 003H	;		[E]
		WORD	-003H, 003H	;		[F]
;
		WORD	-001H, 001H	;[2] 	[0]
		WORD	-001H, 001H	;		[1]
		WORD	-001H, 001H	;		[2]
		WORD	-001H, 001H	;		[3]
		WORD	-001H, 001H	;		[4]
		WORD	-001H, 001H	;		[5]
		WORD	-001H, 001H	;		[6]
		WORD	-001H, 001H	;		[7]
		WORD	-001H, 001H	;		[8]
		WORD	-001H, 001H	;		[9]
		WORD	-001H, 001H	;		[A]
		WORD	-001H, 001H	;		[B]
		WORD	-001H, 001H	;		[C]
		WORD	-001H, 001H	;		[D]
		WORD	-001H, 001H	;		[E]
		WORD	-001H, 001H	;		[F]
;
		WORD	-004H, 004H	;[3] XubN [0]
		WORD	-004H, 004H	;		[1]
		WORD	-004H, 004H	;		[2]
		WORD	-004H, 004H	;		[3]
		WORD	-004H, 004H	;		[4]
		WORD	-004H, 004H	;		[5]
		WORD	-004H, 004H	;		[6]
		WORD	-004H, 004H	;		[7]
		WORD	-004H, 004H	;		[8]
		WORD	-004H, 004H	;		[9]
		WORD	-004H, 004H	;		[A]
		WORD	-004H, 004H	;		[B]
		WORD	-004H, 004H	;		[C]
		WORD	-004H, 004H	;		[D]
		WORD	-004H, 004H	;		[E]
		WORD	-004H, 004H	;		[F]
;
		WORD	-030H, 030H	;[4] ̏	[0]
		WORD	-030H, 030H	;		[1]
		WORD	-030H, 030H	;		[2]
		WORD	-030H, 030H	;		[3]
		WORD	-030H, 030H	;		[4]
		WORD	-030H, 030H	;		[5]
		WORD	-030H, 030H	;		[6]
		WORD	-030H, 030H	;		[7]
		WORD	-030H, 030H	;		[8]
		WORD	-030H, 030H	;		[9]
		WORD	-030H, 030H	;		[A]
		WORD	-030H, 030H	;		[B]
		WORD	-030H, 030H	;		[C]
		WORD	-030H, 030H	;		[D]
		WORD	-030H, 030H	;		[E]
		WORD	-030H, 030H	;		[F]
;
		WORD	-008H, 008H	;[5] D		[0]
		WORD	-008H, 008H	;		[1]
		WORD	-030H, 008H	;		[2]
		WORD	-008H, 008H	;		[3]
		WORD	-008H, 008H	;		[4]
		WORD	-008H, 008H	;		[5]
		WORD	-008H, 008H	;		[6]
		WORD	-008H, 008H	;		[7]
		WORD	-008H, 008H	;		[8]
		WORD	-008H, 008H	;		[9]
		WORD	-008H, 008H	;		[A]
		WORD	-008H, 008H	;		[B]
		WORD	-008H, 008H	;		[C]
		WORD	-008H, 008H	;		[D]
		WORD	-008H, 030H	;		[E]
		WORD	-008H, 008H	;		[F]
;
		WORD	-004H, 004H	;[6] XL[ [0]
		WORD	-004H, 004H	;		[1]
		WORD	-008H, 008H	;		[2]
		WORD	-008H, 008H	;		[3]
		WORD	-020H, 020H	;		[4]
		WORD	-020H, 020H	;		[5]
		WORD	-020H, 020H	;		[6]
		WORD	-020H, 020H	;		[7]
		WORD	-020H, 020H	;		[8]
		WORD	-020H, 020H	;		[9]
		WORD	-020H, 020H	;		[A]
		WORD	-020H, 020H	;		[B]
		WORD	-008H, 008H	;		[C]
		WORD	-008H, 008H	;		[D]
		WORD	-008H, 008H	;		[E]
		WORD	-004H, 004H	;		[F]
;
;------------------------------------------------------------------------
;-		Vbgpf[^					-
;------------------------------------------------------------------------
;
;-------------- HׂĂ̂̃ItZbgf[^ --------------------------
EAT_OFST_POS
; PLCMKI -->		 [0]	[2]	;[BERFLG]
		HEX	0C,FE, F4,FE	;[1] 
		HEX	00,FA, 00,FA	;[3] 
;
;-------------- Lkf[^ --------------------------------------------
BERO_SHOT_DT
; PLCMKI -->			[0]			  [2]
;			X add Y add max	  min	  X add Y add max   min
		HEX	08,   00,   38,	  20,	  F8,	00,   C8,   E0	;[]
		HEX	F8,   00,   00,	  39,	  08,	00,   00,   C7
		HEX	00,   F8,   C8,	  E0,	  00,	F8,   C8,   E0	;[c]
		HEX	00,   08,   00,	  C7,	  00,	08,   00,   C7
;
;-------------- Vbgp^[f[^ --------------------------------
BERO_PATN
;					[jł鎞]
		WORD	BE06,		SB03	   ;[]
		WORD	BE12,		SB0C	   ;[]
;
;-------------- rrp^[f[^ --------------------------------
BERO_BIRI_PATN
;			[] []
		WORD	GU14,GU16
		WORD	GU15,GU17
		WORD	GU15,GU17
		WORD	GU15,GU17
		WORD	GU15,GU17
		WORD	GU15,GU17
		WORD	GU15,GU17
		WORD	GU15,GU17
		WORD	GU15,GU17
		WORD	GU14,GU16
BERO_BIRI_PATN_E
BERO_BIRI_P	EQU	(BERO_BIRI_PATN_E-BERO_BIRI_PATN)/2
;
;-------------- ݍ݃p^[f[^ ----------------------------------
;;;;EAT_END_PT	    EQU	    $-(7*3)
EAT_END_PT
;					[jł鎞]
		LWORD	03H+(BE0D*100H),03H+(SB07*100H) ;[] [p^[P]
		LWORD	03H+(BE1A*100H),03H+(SB10*100H) ;[]
		LWORD	03H+(BE0E*100H),03H+(SB08*100H) ;[] [p^[Q]
		LWORD	03H+(BE1B*100H),03H+(SB08*100H) ;[]
		LWORD	03H+(BE0F*100H),03H+(SB09*100H) ;[] [p^[R]
		LWORD	03H+(BE0F*100H),03H+(SB09*100H) ;[]
		LWORD	08H+(BE10*100H),08H+(SB0A*100H) ;[] [p^[S]
		LWORD	08H+(BE10*100H),08H+(SB0A*100H) ;[]
		LWORD	06H+(BE11*100H),06H+(SB0B*100H) ;[] [p^[T]
		LWORD	06H+(BE11*100H),06H+(SB0B*100H) ;[]
		LWORD	02H+(P00E*100H),02H+(SW00*100H) ;[] [p^[U]
		LWORD	02H+(P00E*100H),02H+(SW00*100H) ;[]
		LWORD	02H+(P00F*100H),02H+(SW00*100H) ;[] [p^[V]
		LWORD	02H+(P00F*100H),02H+(SW00*100H) ;[]
		LWORD	02H+(P014*100H),02H+(SB0B*100H) ;[] [p^[W]
		LWORD	02H+(P014*100H),02H+(SB0B*100H) ;[]
		LWORD	02H+(P015*100H),02H+(SB0B*100H) ;[] [p^[X]
		LWORD	02H+(P015*100H),02H+(SB0B*100H) ;[]
EAT_END_PT_END
		LWORD	03H+(BE0D*100H),03H+(SB07*100H) ;[] [p^[P]
		LWORD	03H+(BE1A*100H),03H+(SB10*100H) ;[]
		LWORD	03H+(BE0E*100H),03H+(SB08*100H) ;[] [p^[Q]
		LWORD	03H+(BE1B*100H),03H+(SB08*100H) ;[]
		LWORD	03H+(BE0F*100H),03H+(SB09*100H) ;[] [p^[R]
		LWORD	03H+(BE0F*100H),03H+(SB09*100H) ;[]
		LWORD	08H+(BE10*100H),08H+(SB0A*100H) ;[] [p^[S]
		LWORD	08H+(BE10*100H),08H+(SB0A*100H) ;[]
		LWORD	03H+(TU07*100H),04H+(TU07*100H) ;[] [p^[T]
		LWORD	03H+(TU07*100H),04H+(TU07*100H) ;[]
		LWORD	04H+(TU03*100H),06H+(TU03*100H) ;[] [p^[X]
		LWORD	04H+(TU03*100H),06H+(TU03*100H) ;[]
		LWORD	02H+(TU08*100H),02H+(TU08*100H) ;[] [p^[X]
		LWORD	02H+(TU08*100H),02H+(TU08*100H) ;[]
		LWORD	02H+(TU04*100H),03H+(TU04*100H) ;[] [p^[X]
		LWORD	02H+(TU04*100H),03H+(TU04*100H) ;[]
		LWORD	03H+(TU09*100H),04H+(TU09*100H) ;[] [p^[X]
		LWORD	03H+(TU09*100H),04H+(TU09*100H) ;[]
EAT_EGG_PT_END
;
EATEND		EQU	(EAT_END_PT_END-EAT_END_PT)/3
EATEGGEND	EQU	(EAT_EGG_PT_END-EAT_END_PT)/3
;
;------------------------------------------------------------------------
;-		XyVVbg؂̎GmDf[^			-
;------------------------------------------------------------------------
SPSHOT_ENNO
		WORD	FIRE0,SOPB0,SUIKA,COLD0
;
;------------------------------------------------------------------------
;-		t@C[VbgZbgʒuf[^			-
;------------------------------------------------------------------------
FIRE_SET_XY
;			X  Y	;	 PLCMKI
		HEX	05,FA	;R	  [0]
		HEX	15,FA
		HEX	25,FA
		HEX	35,FA
		HEX	45,FA
		HEX	55,FA
FIRE_SET_M	HEX	EB,FA	;	  [2]
		HEX	DB,FA
		HEX	CB,FA
		HEX	BB,FA
		HEX	AB,FA
		HEX	9B,FA
		HEX	05,F6	;Wv [0]
		HEX	15,F6
		HEX	25,F6
		HEX	35,F6
		HEX	45,F6
		HEX	55,F6
		HEX	EB,F6	;	  [2]
		HEX	DB,F6
		HEX	CB,F6
		HEX	BB,F6
		HEX	AB,F6
		HEX	9B,F6
FIRE_SET_P	HEX	F4,E2	;	  [0] 
		HEX	F4,D2
		HEX	F4,C2
		HEX	F4,B2
		HEX	F4,A2
		HEX	F4,92
		HEX	FC,E2	;	  [2]
		HEX	FC,D2
		HEX	FC,C2
		HEX	FC,B2
		HEX	FC,A2
		HEX	FC,92
;
FIRE_ST_M	EQU	(FIRE_SET_M-FIRE_SET_XY)/2
FIRE_ST_P	EQU	FIRE_SET_P-FIRE_SET_XY
;
;------------------------------------------------------------------------
;-		ڂʃVbgpf[^				-
;------------------------------------------------------------------------
;
;-------------- ڂʃZbg^C~Of[^ ------------------------
SOAP_SET_TMG
		HEX	02,04,09,10
SOAP_SET_TMG_E
SOAP_SET_TMG_NO EQU	SOAP_SET_TMG_E-SOAP_SET_TMG
;
;-------------- ڂʃZbgʒuf[^ ------------------------------
SOAP_SET_XY
;			 X     Y	  Xsp	 Ysp	;	 PLCMKI
		WORD	005H+(0F5H*100H),00340H,00050H
		WORD			 00380H,00050H	;R	  [0]
		WORD			 003C0H,00050H
		WORD			 00400H,00050H
SOAP_SET_M	WORD	0ECH+(0F5H*100H),0FCC0H,00050H
		WORD			 0FC80H,00050H	;	  [2]
		WORD			 0FC40H,00050H
		WORD			 0FC00H,00050H
		WORD	004H+(0F4H*100H),00340H,00050H
		WORD			 00380H,00050H	;Wv [0]
		WORD			 003C0H,00050H
		WORD			 00400H,00050H
		WORD	0EDH+(0F4H*100H),0FCC0H,00050H
		WORD			 0FC80H,00050H	;	  [2]
		WORD			 0FC40H,00050H
		WORD			 0FC00H,00050H
SOAP_SET_P	WORD	0F6H+(0EDH*100H),00000H,0FC00H
		WORD			 00000H,0FC00H	;	  [0] 
		WORD			 00000H,0FC00H
		WORD			 00000H,0FC00H
		WORD	0FAH+(0EDH*100H),00000H,0FC00H
		WORD			 00000H,0FC00H	;	  [2]
		WORD			 00000H,0FC00H
		WORD			 00000H,0FC00H
;
SOAP_ST_M	EQU	(SOAP_SET_M-SOAP_SET_XY)/2
SOAP_ST_P	EQU	SOAP_SET_P-SOAP_SET_XY
;
;------------------------------------------------------------------------
;-		XCJVbgpf[^					-
;------------------------------------------------------------------------
;
;-------------- XCJZbgʒuf[^ --------------------------------
SUIKA_SET_XY
;			 X     Y	  Xsp	 Ysp	;	 PLCMKI
		WORD	004H+(0F4H*100H),00400H,0FF10H
		WORD			 00400H,00000H	;R	  [0]
		WORD			 00400H,00030H
		WORD			 00400H,0FF70H
		WORD			 00400H,000F0H
		WORD			 00400H,0FFD0H
		WORD			 00400H,00090H
SUIKA_SET_M	WORD	0ECH+(0F4H*100H),0FC00H,0FF10H
		WORD			 0FC00H,00000H	;	  [2]
		WORD			 0FC00H,00030H
		WORD			 0FC00H,0FF70H
		WORD			 0FC00H,000F0H
		WORD			 0FC00H,0FFD0H
		WORD			 0FC00H,00090H
		WORD	0FDH+(0F4H*100H),00400H,0FF10H
		WORD			 00400H,00000H	;Wv [0]
		WORD			 00400H,00030H
		WORD			 00400H,0FF70H
		WORD			 00400H,000F0H
		WORD			 00400H,0FFD0H
		WORD			 00400H,00090H
		WORD	0F3H+(0F4H*100H),0FC00H,0FF10H
		WORD			 0FC00H,00000H	;	  [2]
		WORD			 0FC00H,00030H
		WORD			 0FC00H,0FF70H
		WORD			 0FC00H,000F0H
		WORD			 0FC00H,0FFD0H
		WORD			 0FC00H,00090H
SUIKA_SET_P	WORD	0F6H+(0EDH*100H),0FF10H,0FC00H
		WORD			 00000H,0FC00H	;	  [0] 
		WORD			 00030H,0FC00H
		WORD			 0FF70H,0FC00H
		WORD			 000F0H,0FC00H
		WORD			 0FFD0H,0FC00H
		WORD			 00090H,0FC00H
		WORD	0FAH+(0EDH*100H),000F0H,0FC00H
		WORD			 00000H,0FC00H	;	  [2]
		WORD			 0FFD0H,0FC00H
		WORD			 00090H,0FC00H
		WORD			 0FF10H,0FC00H
		WORD			 00030H,0FC00H
		WORD			 0FF70H,0FC00H
;
SUIKA_ST_M	EQU	(SUIKA_SET_M-SUIKA_SET_XY)/2
SUIKA_ST_P	EQU	SUIKA_SET_P-SUIKA_SET_XY
;
;------------------------------------------------------------------------
;-		p^[mDZbgpf[^				-
;------------------------------------------------------------------------
;
;-------------- _[W̃LLp^[f[^ ------------------
FAIL_KYORO_PATN
		WORD	P000,OS0C,OS0D,OS0E,OS0F,OS0E,OS0D,OS0C
;
;-------------- ]p^[f[^ --------------------------------------
ROTATION_PATN
		WORD	DM0A,DM09,DM08,DM07,DM06,DM05
;
;-------------- ]_Ep^[f[^ --------------------------------
ROT_DOWN_PATN
		WORD	DM04,DM04,DM03,DM04,DM03,DM02
ROT_DOWN_TIM
		HEX	000, 040, 005, 002, 002, 002
ROT_DOWN_P	EQU	(ROT_DOWN_TIM-ROT_DOWN_PATN)/2
;
;-------------- XCJVbgp^[f[^ ----------------------------
SUIKA_SHOT_PATN
		WORD	SU0C,SU0D,SU0E,SU0F,SU0E,SU0D	;[0]	 R
		WORD	SU07,SU06,SU05,SU04,SU05,SU06	;[6*2]	 Wv
		WORD	SU08,SU09,SU0A,SU0B,SU0A,SU09	;[6*2*2] R
;
;-------------- ^}Sp^[mDf[^ --------------------------
NAGE_PATN
		WORD	TN0A,TN09,TN08,TN07,TN06,TN05,TN04,TN03
		WORD	TN02,TN01
NAGE_PATN_E
NAGE_P		EQU	(NAGE_PATN_E-NAGE_PATN)/2
;
;-------------- ^}Sp^[؂ւ^C}[f[^ ----------------
NAGE_PATN_TMDT
; PLNAGE -->		 0  1  2  3  4	5  6  7	 8  9
;;;;		    HEX	    00,05,01,01,01,04,08,01,04,01
		HEX	00,0C,01,01,01,02,04,01,02,01
;
;-------------- p^[mDf[^ ------------------------------
SIT_PATN
		WORD	P011,P012,P101,P101,P101
;
;-------------- Wvh{`hp^[mDf[^ ------
SDBOYO_PATN
		WORD	BY13,BY09
;
;-------------- Wvh{`hp^[mDf[^ ------
HDBOYO_PATN
		WORD	BY0B,BY13,BY0A,BY13
;
;-------------- hu`hp^[mDf[^ ------------------------
BURAN_PATN
		WORD	SJ04,SJ03,SJ02
		WORD	DU0B,DU0A,DU09,DU08,DU07,DU06,DU05,DU04
		WORD	DU03,DU02,DU01
BURAN_PATN_E
BURAN_P		EQU	BURAN_PATN_E-BURAN_PATN
;
;-------------- W^o^Wvp^[mDf[^ --------------------
SPJMP_PATN
		WORD	SJ01		;[start pattern]
		WORD	SJ02,SJ03,SJ04	;["pata pata" pattern]
SPJMP_NAGE_PATN
		WORD	TN08		;[start pattern]
		WORD	JN02,JN03,JN04	;["pata pata" pattern]
;
;-------------- Wvnp^[mDf[^ ------------------------
JMPEND_PATN
		WORD	P011,P012,P011
JMPEND_PATN_E
JPET		EQU	(JMPEND_PATN_E-JMPEND_PATN)
;
;-------------- Xbvp^[mDf[^ ----------------------------
SLIP_PATN	EQU	$
		WORD	SL01,SL02,SL03,SL03,SL02,SL01,SL01,SL01
NAGE_SLIP_PATN
		WORD	ON01,ON02,ON03,ON03,ON02,ON01,ON01,ON01
;
;-------------- ǉp^[mDf[^ ----------------------------
PUSH_PATN
		WORD	OS01,OS02,OS03,OS04,OS05
;
;-------------- ~܂Ă鎞̃p^[mDf[^ ----------------------
PLSTOP_PATN
MABATAKI	WORD	P107,P107,P107,P107
PORIPORI	WORD	P018,P018,P018,P018
		WORD	P017,P017,P017,P017,P017,P017,P017,P017
		WORD	P016,P016,P016,P016,P016,P016
		WORD	P017,P017,P017,P017,P017,P017,P017,P017
		WORD	P016,P016,P016,P016,P016,P016
		WORD	P017,P017,P017,P017,P017,P017,P017,P017
		WORD	P016,P016,P016,P016,P016,P016
		WORD	P018,P018,P018,P018,P018,P018,P018,P018
KYORKYOR	WORD	OS0C,OS0D,OS0E
		WORD	OS0F,OS0F,OS0F,OS0F,OS0F,OS0F,OS0F,OS0F
		WORD	OS0F,OS0F,OS0F,OS0F,OS0F,OS0F,OS0F,OS0F
		WORD	OS0F,OS0F,OS0F,OS0F
		WORD	OS0E,OS0D,OS0C
TANTAN		WORD	OS1A,OS1A,OS1A,OS1A,OS1A,OS1A
		WORD	OS1B,OS1B,OS1B,OS1B,OS1B,OS1B
		WORD	OS1A,OS1A,OS1A,OS1A,OS1A,OS1A
		WORD	P107,P107,P107,P107,P107,P107
		WORD	OS18,OS18,OS18,OS18,OS18,OS18
		WORD	OS19,OS19,OS19,OS19,OS19,OS19
		WORD	OS18,OS18,OS18,OS18,OS18,OS18
PLSTOP_PATN_E
;
;-------------- ~܂Ă鎞̃p^[؂ւp^C}[f[^ ----------
PLSTOP_TMDT
		BYTE	(PLSTOP_PATN_E-TANTAN)/2-1 ;[0:"tan tan"]
		BYTE	(PORIPORI-MABATAKI)/2-1	   ;[1:"mabataki"]
		BYTE	(KYORKYOR-PORIPORI)/2-1	   ;[2:"pori pori"]
		BYTE	(TANTAN-KYORKYOR)/2-1	   ;[3:"kyoro kyoro"]
;
;-------------- ~܂Ă鎞̃p^[f[^|C^[f[^ ------------
PLSTOP_PTIN
		WORD	TANTAN-PLSTOP_PATN	   ;[0:"tan tan"]
		WORD	MABATAKI-PLSTOP_PATN	   ;[1:"mabataki"]
		WORD	PORIPORI-PLSTOP_PATN	   ;[2:"pori pori"]
		WORD	KYORKYOR-PLSTOP_PATN	   ;[3:"kyoro kyoro"]
;
;-------------- TEhf[^ --------------------------------------
WALK_SOUND
		HEX	00	;[0] ʂ̏
		HEX	00	;[1] 
		HEX	00	;[2] 
		HEX	75	;[3] XubN
;;;;		    HEX	    98	    ;[4] ̏
		HEX	00	;[4] ̏
		HEX	00	;[5] D
;
;-------------- p^[؂ւp^C}[f[^ --------------------
WALK_TMDT
; PLXSPD/4 -->		 0  4  8  C 10 14 18 1C 20 24 28 2C 30 34 38 3C ;[PLWALK]
YUKA_WALK
		HEX	04,03,02,02,02,01,00,00,00,00,00,00,00,00,00,00 ;[01]
		HEX	04,03,02,02,02,01,00,00,00,00,00,00,00,00,00,00 ;[02]
		HEX	04,03,02,02,02,01,00,00,00,00,00,00,00,00,00,00 ;[03]
		HEX	04,03,02,02,02,01,00,00,00,00,00,00,00,00,00,00 ;[04]
		HEX	04,03,02,02,02,01,00,00,00,00,00,00,00,00,00,00 ;[05]
		HEX	04,03,02,02,02,01,00,00,00,00,00,00,00,00,00,00 ;[06]
		HEX	04,03,02,02,02,01,00,00,00,00,00,00,00,00,00,00 ;[07]
		HEX	04,03,02,02,02,01,00,00,00,00,00,00,00,00,00,00 ;[08]
		HEX	04,03,02,02,02,01,00,00,00,00,00,00,00,00,00,00 ;[09]
		HEX	04,03,02,02,02,01,00,00,00,00,00,00,00,00,00,00 ;[10]
WALK_TMDT_E
WATR_WALK
YUKI_WALK
		HEX	06,05,04,03,03,02,01,01,01,00,00,00,00,00,00,00 ;[01]
		HEX	06,05,04,03,03,02,01,01,01,00,00,00,00,00,00,00 ;[02]
		HEX	06,05,04,03,03,02,01,01,01,00,00,00,00,00,00,00 ;[03]
		HEX	06,05,04,03,03,02,01,01,01,00,00,00,00,00,00,00 ;[04]
		HEX	06,05,04,03,03,02,01,01,01,00,00,00,00,00,00,00 ;[05]
		HEX	06,05,04,03,03,02,01,01,01,00,00,00,00,00,00,00 ;[06]
		HEX	06,05,04,03,03,02,01,01,01,00,00,00,00,00,00,00 ;[07]
		HEX	06,05,04,03,03,02,01,01,01,00,00,00,00,00,00,00 ;[08]
		HEX	06,05,04,03,03,02,01,01,01,00,00,00,00,00,00,00 ;[09]
		HEX	06,05,04,03,03,02,01,01,01,00,00,00,00,00,00,00 ;[10]
SOAP_WALK
		HEX	01,02,02,01,01,01,01,01,01,00,00,00,00,00,00,00 ;[01]
		HEX	01,02,02,01,01,01,01,01,01,00,00,00,00,00,00,00 ;[02]
		HEX	01,02,02,01,01,01,01,01,01,00,00,00,00,00,00,00 ;[03]
		HEX	01,02,02,01,01,01,01,01,01,00,00,00,00,00,00,00 ;[04]
		HEX	01,02,02,01,01,01,01,01,01,00,00,00,00,00,00,00 ;[05]
		HEX	01,02,02,01,01,01,01,01,01,00,00,00,00,00,00,00 ;[06]
		HEX	01,02,02,01,01,01,01,01,01,00,00,00,00,00,00,00 ;[07]
		HEX	01,02,02,01,01,01,01,01,01,00,00,00,00,00,00,00 ;[08]
		HEX	01,02,02,01,01,01,01,01,01,00,00,00,00,00,00,00 ;[09]
		HEX	01,02,02,01,01,01,01,01,01,00,00,00,00,00,00,00 ;[10]
DORO_WALK
		HEX	01,02,03,02,02,02,02,01,01,00,00,00,00,00,00,00 ;[01]
		HEX	01,02,03,02,02,02,02,01,01,00,00,00,00,00,00,00 ;[02]
		HEX	01,02,03,02,02,02,02,01,01,00,00,00,00,00,00,00 ;[03]
		HEX	01,02,03,02,02,02,02,01,01,00,00,00,00,00,00,00 ;[04]
		HEX	01,02,03,02,02,02,02,01,01,00,00,00,00,00,00,00 ;[05]
		HEX	01,02,03,02,02,02,02,01,01,00,00,00,00,00,00,00 ;[06]
		HEX	01,02,03,02,02,02,02,01,01,00,00,00,00,00,00,00 ;[07]
		HEX	01,02,03,02,02,02,02,01,01,00,00,00,00,00,00,00 ;[08]
		HEX	01,02,03,02,02,02,02,01,01,00,00,00,00,00,00,00 ;[09]
		HEX	01,02,03,02,02,02,02,01,01,00,00,00,00,00,00,00 ;[10]
;
WLKMX		EQU	(WALK_TMDT_E-WALK_TMDT)/10H
WLKMX_C		EQU	(WLKMX-1)*2
WLKMX_Cx2	EQU	WLKMX_C*2
WLKMX_Cw2	EQU	WLKMX*2/2
;
;-------------- p^[؂ւp^C}[f[^|C^[f[^ ----
WALK_TMIN					;[PLBGNO]
		WORD	YUKA_WALK-WALK_TMDT	;[0] ʂ̏
		WORD	WATR_WALK-WALK_TMDT	;[1] 
		WORD	SOAP_WALK-WALK_TMDT	;[2] 
		WORD	SOAP_WALK-WALK_TMDT	;[3] XubN
		WORD	YUKI_WALK-WALK_TMDT	;[4] ̏
		WORD	DORO_WALK-WALK_TMDT	;[5] D
;
;-------------- p^[mDf[^ --------------------------------
WALK_PATN
		WORD	P001	;[01]
		WORD	P002	;[02]
		WORD	P003	;[03]
		WORD	P004	;[04]
		WORD	P005	;[05]
		WORD	P009	;[06]
		WORD	P00A	;[07]
		WORD	P00B	;[08]
		WORD	P00C	;[09]
		WORD	P010	;[10]
;
		WORD	NR01	;[01] ^}S
		WORD	NR02	;[02]
		WORD	NR03	;[03]
		WORD	NR04	;[04]
		WORD	NR05	;[05]
		WORD	NR01	;[06]
		WORD	NR02	;[07]
		WORD	NR03	;[08]
		WORD	NR04	;[09]
		WORD	NR05	;[10]
;
;-------------- htth ----------------------------------
		WORD	FR09	;[01]		;Oi
		WORD	FR0A	;[02]
		WORD	FR0B	;[03]
		WORD	FR0C	;[04]
		WORD	FR0D	;[05]
		WORD	FR09	;[06]
		WORD	FR0A	;[07]
		WORD	FR0B	;[08]
		WORD	FR0C	;[09]
		WORD	FR0D	;[10]
;
		WORD	FE09	;[01] ^}S
		WORD	FE0A	;[02]
		WORD	FE0B	;[03]
		WORD	FE0C	;[04]
		WORD	FE0D	;[05]
		WORD	FE09	;[06]
		WORD	FE0A	;[07]
		WORD	FE0B	;[08]
		WORD	FE0C	;[09]
		WORD	FE0D	;[10]
;
		WORD	FR19	;[01]		;i
		WORD	FR1A	;[02]
		WORD	FR1B	;[03]
		WORD	FR1C	;[04]
		WORD	FR1D	;[05]
		WORD	FR19	;[06]
		WORD	FR1A	;[07]
		WORD	FR1B	;[08]
		WORD	FR1C	;[09]
		WORD	FR1D	;[10]
;
		WORD	FE19	;[01] ^}S
		WORD	FE1A	;[02]
		WORD	FE1B	;[03]
		WORD	FE1C	;[04]
		WORD	FE1D	;[05]
		WORD	FE19	;[06]
		WORD	FE1A	;[07]
		WORD	FE1B	;[08]
		WORD	FE1C	;[09]
		WORD	FE1D	;[10]
;
;-------------- htthJE^[؂ւ^C}[f[^  -----------
FURA_PATN	EQU	$
;
;-------------- ^}SĂȂ ------------------------------
		WORD	FR17					;[MV]
		WORD	FR18,FR17,FR16,FR17,FR18		;[-]
		WORD	FR17,FR16,FR15,FR14,FR13,FR12,FR11
FURA_ST		WORD	FR00					;[0]
		WORD	FR01,FR02,FR03,FR04,FR05,FR06,FR07
FURA_CK		WORD	FR08,FR07,FR06,FR07,FR08		;[+]
FURA_MV		WORD	FR07					;[MV]
;-------------- ^}SĂ鎞 --------------------------------
FURA_EGG_PATN	WORD	FE17					;[MV]
		WORD	FE18,FE17,FE16,FE17,FE18		;[-]
		WORD	FE17,FE16,FE15,FE14,FE13,FE12,FE11
		WORD	FE00					;[0]
		WORD	FE01,FE02,FE03,FE04,FE05,FE06,FE07
		WORD	FE08,FE07,FE06,FE07,FE08		;[+]
		WORD	FE07					;[MV]
;
FURA_TMDT	EQU	$
		HEX	20					;[MV]
		HEX	14,  04,  10,  04,  13			;[-]
		HEX	07,  03,  03,  03,  03,	 03,  03
		HEX	04					;[0]
		HEX	04,  04,  04,  04,  04,	 04,  08
		HEX	11,  04,  08,  04,  11			;[+]
		HEX	20					;[MV]
;
FR_CK		EQU	FURA_CK-FURA_ST
FR_MV		EQU	FURA_MV-FURA_ST
;
;------------------------------------------------------------------------
;-		wRv^[ f[^					-
;------------------------------------------------------------------------
;
;-------------- Up^[LN^[AhXf[^ --------------
HR_MKCG_PT
; CPHR_MKCG -->		    [1]		 [2]	      [3]	   [4]
		WORD	CIPCHD+40A0H,CIPCHD+2080H,CIPCHD+2080H,CIPCHD+40A0H
;
;-------------- ړpf[^ --------------------------------------------
HR_MOVE_DT
;			[to angl] [to Xsp] [to Ysp]	 [KEYC1 & 1111B]
		HEX	E0				;[0001]
		WORD		  00200H*2,00000H*2
		HEX	E0				;[0010]
		WORD		  0FE00H*2,00000H*2
		HEX	E0				;[0011]
		WORD		  0FE00H*2,00000H*2
		HEX	00				;[0100]
		WORD		  00000H*2,00200H*2
		HEX	D0				;[0101]
		WORD		  0016AH*2,0016AH*2
		HEX	D0				;[0110]
		WORD		  0FE96H*2,0016AH*2
		HEX	D0				;[0111]
		WORD		  0FE96H*2,0016AH*2
		HEX	00				;[1000]
		WORD		  00000H*2,0FE00H*2
		HEX	F0				;[1001]
		WORD		  0016AH*2,0FE96H*2
		HEX	F0				;[1010]
		WORD		  0FE96H*2,0FE96H*2
		HEX	F0				;[1011]
		WORD		  0FE96H*2,0FE96H*2
		HEX	00				;[1100]
		WORD		  00000H*2,0FE00H*2
		HEX	F0				;[1101]
		WORD		  0016AH*2,0FE96H*2
		HEX	F0				;[1110]
		WORD		  0FE96H*2,0FE96H*2
		HEX	F0				;[1111]
		WORD		  0FE96H*2,0FE96H*2
;
;
;------------------------------------------------------------------------
;-		 f[^						-
;------------------------------------------------------------------------
;
;-------------- ړpf[^ --------------------------------------------
SB_MOVE_DT
;			[to angl] [to Xsp] [to Ysp]	 [KEYC1 & 1111B]
		HEX	00				;[0000]
		WORD		  00000H,  00000H
		HEX	00				;[0001]
		WORD		  00180H,  00000H
		HEX	00				;[0010]
		WORD		  0FE80H,  00000H
		HEX	00				;[0011]
		WORD		  0FE80H,  00000H
		HEX	40				;[0100]
		WORD		  00000H,  00180H
		HEX	20				;[0101]
		WORD		  00110H,  00110H
		HEX	20				;[0110]
		WORD		  0FEF0H,  00110H
		HEX	20				;[0111]
		WORD		  0FEF0H,  00110H
		HEX	C0				;[1000]
		WORD		  00000H,  0FE80H
		HEX	E0				;[1001]
		WORD		  00110H,  0FEF0H
		HEX	E0				;[1010]
		WORD		  0FEF0H,  0FEF0H
		HEX	E0				;[1011]
		WORD		  0FEF0H,  0FEF0H
		HEX	C0				;[1100]
		WORD		  00000H,  0FE80H
		HEX	E0				;[1101]
		WORD		  00110H,  0FEF0H
		HEX	E0				;[1110]
		WORD		  0FEF0H,  0FEF0H
		HEX	E0				;[1111]
		WORD		  0FEF0H,  0FEF0H
;
;
;------------------------------------------------------------------------
;-		܁@悵̃LAhX				-
;------------------------------------------------------------------------
CAR_CHAR
		WORD	CIPCHD+60A0H+000
		WORD	CIPCHD+60C0H+000
;
;------------------------------------------------------------------------
;-		܁@悵̃^Cʒu␳l			-
;------------------------------------------------------------------------
CAR_TIRE_XREV
;			[L] [C] [R]
		HEX	0FF,0FC,0F9,000		;E
		HEX	007,003,001,000		;
;
;------------------------------------------------------------------------
;-		Opf[^						-
;------------------------------------------------------------------------
;
;-------------- ړpxf[^ --------------------------------------
MG_MVANGL	;		 [PMG_MVMK]
		HEX	00	;[0]
		HEX	C0	;[1]
		HEX	80	;[2]
		HEX	40	;[3]
;
;-------------- ړL[f[^ ------------------------------------------
MG_MVKEY	;	  E	     	 [PMG_MVMK]
		BYTE	00000011B,00000010B	;[0] 
		BYTE	00001100B,00001000B	;[1] 
		BYTE	00000011B,00000001B	;[2] 
		BYTE	00001100B,00000100B	;[3] E
;
;-------------- ړL[ϊf[^ --------------------------------------
MG_KEYCNV
; PMG_MVMK		[0] [1] [2] [3]
		BYTE	00B,10B,11B,01B ;[ 1:] ]
;
;-------------- af`FbNpWnϊf[^ --------------------------
MG_POSCNV
; PMG_MVMK		[0] [1] [2] [3]
		BYTE	00B,01B,11B,10B ;[ 1:] ]
;
;-------------- ␳`FbNf[^ ------------------------------------
MG_FOOTBGP	;	  S_     TCh  TCh	 TCh TCh	[PMG_MVMK]
		WORD	000000010B,000000101B,010100000B,000000100B,101000000B ;[0] 
		WORD	010000000B,100000100B,000011010B,100000000B,001000001B ;[1] 
		WORD	000011000B,101000000B,010100000B,001000000B,010100000B ;[2] 
		WORD	000100000B,001000001B,000011010B,000000001B,000011010B ;[3] E
;
;-------------- ␳`FbNf[^ ------------------------------------
MG_HEADBGP	;	  S_    TCh  TCh  [PMG_MVMK]
		WORD	000011000B,111100000B,110000000B ;[0] 
		BYTE	00000000B ;L[
		WORD	000100000B,001011011B,001011000B ;[1] 
		BYTE	00000001B ;L[
		WORD	000000010B,010100101B,000100001B ;[2] 
		BYTE	00000100B ;L[
		WORD	010000000B,100011110B,000000110B ;[3] E
		BYTE	00000010B ;L[
;
;-------------- TCh␳`FbNf[^ --------------------------------
MG_SIDEBGP	;	TCh_ TCh_ ETCh_ S_     MKEYC1 & E ETCh TCh[PMG_MVMK]
		WORD	010100000B,010000000B,000100000B,000011010B,00000010B,00000001B,000000001B,000000100B ;[0] 
		WORD	000011010B,000011000B,000000010B,010100000B,00001000B,00000100B,000000100B,100000000B ;[1] 
		WORD	010100000B,000100000B,010000000B,000011010B,00000001B,00000010B,100000000B,001000000B ;[2] 
		WORD	000011010B,000000010B,000011000B,010100000B,00000100B,00001000B,001000000B,000000001B ;[3] E
;
;-------------- ␳S_af薳ړύX`FbNf[^ --
MG_DWMKCHG	;	MKEYC1 &	 [PMG_MVMK]
		BYTE	00000100B	;[0] 
		BYTE	00000010B	;[1] 
		BYTE	00001000B	;[2] 
		BYTE	00000001B	;[3] E
;
;-------------- S_af薳ړύX`FbNf[^ ------
MG_UPMKCHG	;	MKEYC1 &	 [PMG_MVMK]
		BYTE	00001000B	;[0] 
		BYTE	00000001B	;[1] 
		BYTE	00000100B	;[2] 
		BYTE	00000010B	;[3] E
;
;-------------- ␳ʃf[^ ------------------------------------------
MG_FOOTHSD	;	pxZl ␳l	 [PL[XY]PSL&0FH]
		HEX	    10,	      5		;[0] ^
		HEX	    0A,	      4		;[1] |
		HEX	    08,	      3		;[2] |
		HEX	    06,	      2		;[3] |
		HEX	    04,	      2		;[4] |
		HEX	    02,	      1		;[5] |
		HEX	    01,	      1		;[6] |
		HEX	    00,	      0		;[7] +
;
		HEX	    30,	      D		;[8] ^
		HEX	    2C,	      C		;[9] |
		HEX	    28,	      B		;[A] |
		HEX	    24,	      A		;[B] |
		HEX	    20,	      9		;[C] |
		HEX	    1C,	      8		;[D] |
		HEX	    18,	      7		;[E] |
		HEX	    14,	      6		;[F] |
;
;
;------------------------------------------------------------------------
;-		}Ipf[^						-
;------------------------------------------------------------------------
MR_WK0_CHR	EQU	CIPCHD+0060H+1
MR_WK1_CHR	EQU	CIPCHD+6020H+1
MR_WK2_CHR	EQU	CIPCHD+6040H+1
MR_WK3_CHR	EQU	CIPCHD+6060H+1
MR_SIT_CHR	EQU	CIPCHD+40E0H+1
MR_UJP_CHR	EQU	CIPCHD+6080H+1
MR_DJP_CHR	EQU	CIPCHD+0080H+1
MR_STP_CHR	EQU	CIPCHD+60A0H+1
MR_PCE_CHR	EQU	CIPCHD+00A0H+1
MR_SLP_CHR	EQU	CIPCHD+40A0H+1
;
;-------------- p^[^Cvf[^ --------------------------------
MR_WLK_CHRDT
		BYTE	MR_P_WLK0
		BYTE	MR_P_WLK1
		BYTE	MR_P_WLK2
		BYTE	MR_P_WLK3
;
;-------------- zoOp^[^Cvf[^ --------------------------
MR_HOB_CHRDT
		BYTE	MR_P_HOB0
		BYTE	MR_P_HOB1
		BYTE	MR_P_HOB2
;
;-------------- }gp^[؂ւf[^ ----------------------------
MR_MANT_PATN
; PMR_MANT -->
		WORD	MR08,MR07,MR0B,MR0A,MR09,MR0A,MR06,MR05
		WORD	MR04,MR03,MR02,MR01,MR02
MR_MANT_JMPUP
; PMR_MANT -->		 [0/8]	[1/9]  [2/A]  [3/B]  [4/C]  [5/D]  [6/E]  [7/F]
		BYTE	 2*2,4, 1*2,4, 1*2,4, 1*2,4, 1*2,4,-3*2,4,-6*2,4,-1*2,4
		BYTE	-1*2,4,-1*2,4,-1*2,4,-2*2,4,-1*2,4
MR_MANT_JMPDW
		BYTE	 1*2,4, 5*2,4, 4*2,4, 3*2,4, 2*2,4, 1*2,4, 1*2,4, 1*2,4
		BYTE	 1*2,4, 1*2,4, 1*2,4, 1*2,4,-3*2,4
MR_MANT_NOJMP
		BYTE	 0*2,0,-1*2,4,-1*2,4,-2*2,4,-3*2,4,-4*2,4,-5*2,4,-1*2,4
		BYTE	-1*2,4, 2*2,4, 1*2,4,-3*2,4,-1*2,4
;
;-------------- p^[^Cv --------------------------------------
MR_CHR_TYPE				;[PMR_CTYP]
MR_PT_STOP	WORD	MR_STP_CHR	;LN^[AhXikCgj
		BYTE	0		;gAkLN^[Zbg
		WORD	0		;p^[mD
;
MR_PT_SITD	WORD	MR_SIT_CHR	;LN^[AhXikCgj
		BYTE	0		;gAkLN^[Zbg
		WORD	0		;p^[mD
;
MR_PT_UPJP	WORD	MR_UJP_CHR	;LN^[AhXikCgj
		BYTE	0		;gAkLN^[Zbg
		WORD	0		;p^[mD
;
MR_PT_DWJP	WORD	MR_DJP_CHR	;LN^[AhXikCgj
		BYTE	0		;gAkLN^[Zbg
		WORD	0		;p^[mD
;
MR_PT_SLIP	WORD	MR_SLP_CHR	;LN^[AhXikCgj
		BYTE	1		;gAkLN^[Zbg
		WORD	MR00		;p^[mD
;
MR_PT_WLK0	WORD	MR_WK0_CHR	;LN^[AhXikCgj
		BYTE	1		;gAkLN^[Zbg
		WORD	MR00		;p^[mD
;
MR_PT_WLK1	WORD	MR_WK1_CHR	;LN^[AhXikCgj
		BYTE	1		;gAkLN^[Zbg
		WORD	MR00		;p^[mD
;
MR_PT_WLK2	WORD	MR_WK2_CHR	;LN^[AhXikCgj
		BYTE	1		;gAkLN^[Zbg
		WORD	MR00		;p^[mD
;
MR_PT_WLK3	WORD	MR_WK3_CHR	;LN^[AhXikCgj
		BYTE	1		;gAkLN^[Zbg
		WORD	MR00		;p^[mD
;
MR_PT_HOB0	WORD	MR_DJP_CHR	;LN^[AhXikCgj
		BYTE	1		;gAkLN^[Zbg
		WORD	MR0C		;p^[mD
;
MR_PT_HOB1	WORD	MR_DJP_CHR	;LN^[AhXikCgj
		BYTE	1		;gAkLN^[Zbg
		WORD	MR0D		;p^[mD
;
MR_PT_HOB2	WORD	MR_DJP_CHR	;LN^[AhXikCgj
		BYTE	1		;gAkLN^[Zbg
		WORD	MR0E		;p^[mD
;
MR_P_STOP	EQU	MR_PT_STOP-MR_CHR_TYPE
MR_P_SITD	EQU	MR_PT_SITD-MR_CHR_TYPE
MR_P_UPJP	EQU	MR_PT_UPJP-MR_CHR_TYPE
MR_P_DWJP	EQU	MR_PT_DWJP-MR_CHR_TYPE
MR_P_SLIP	EQU	MR_PT_SLIP-MR_CHR_TYPE
MR_P_WLK0	EQU	MR_PT_WLK0-MR_CHR_TYPE
MR_P_WLK1	EQU	MR_PT_WLK1-MR_CHR_TYPE
MR_P_WLK2	EQU	MR_PT_WLK2-MR_CHR_TYPE
MR_P_WLK3	EQU	MR_PT_WLK3-MR_CHR_TYPE
MR_P_HOB0	EQU	MR_PT_HOB0-MR_CHR_TYPE
MR_P_HOB1	EQU	MR_PT_HOB1-MR_CHR_TYPE
MR_P_HOB2	EQU	MR_PT_HOB2-MR_CHR_TYPE
;
;------------------------------------------------------------------------
;-		Dԗpf[^						-
;------------------------------------------------------------------------
;
;-------------- DԃLN^[f[^|C^[ ------------------------
TR_CHR_ADRS
; CPTR_PTNO -->		     [0]	  [2]
		WORD	CIPCHD+2000H,CIPCHD+2020H  ;[[O[h]
		WORD	CIPCHD+40C0H,CIPCHD+0080H  ;[[[h]
;
;-------------- f[[hL[`FbNf[^ ------------------
GO_RALE_KEY
		BYTE	00001000B,0C0H	;[] 
		BYTE	00001000B,0C0H	;[]
		BYTE	00000001B,000H	;[^] low
		BYTE	00000000B,000H	;[^] high
		BYTE	00000000B,000H	;[_] high
		BYTE	00000010B,080H	;[_] low
		BYTE	00000000B,000H	;[]
		BYTE	00000000B,000H	;[]
		BYTE	00000000B,000H	;[]
		BYTE	00000000B,000H	;[]
		BYTE	00000000B,000H	;[]
;
;-------------- f[[h␳f[^ --------------------------
GO_RALE_HSDT
;			X Y	;[PTR_TOAN]
		HEX	0,08	;[0000]
		HEX	0,00	;[2000]
		HEX	8,10	;[4000]
		HEX	0,00	;[6000]
		HEX	0,08	;[8000]
		HEX	0,00	;[A000]
		HEX	8,08	;[C000]
		HEX	0,00	;[E000]
;
;-------------- [ւ̕␳`FbNf[^ ----------------------------
RALE_HS_ANAD
;			X  Y	 [PTR_ANGL]
		HEX	01,00	;[0000]
		HEX	01,01	;[2000]
		HEX	00,01	;[4000]
		HEX	FF,01	;[6000]
		HEX	FF,00	;[8000]
		HEX	FF,FF	;[A000]
		HEX	00,FF	;[C000]
		HEX	01,FF	;[E000]
;
TR_KEY_ANGL			;[MKEYC1 & 00001111B]
		HEX	00	;[0001]
		HEX	80	;[0010]
		HEX	00	;[0011]
		HEX	40	;[0100]
		HEX	60	;[0101]
		HEX	20	;[0110]
		HEX	60	;[0111]
		HEX	C0	;[1000]
		HEX	A0	;[1001]
		HEX	E0	;[1010]
		HEX	A0	;[1011]
		HEX	40	;[1100]
		HEX	60	;[1101]
		HEX	20	;[1110]
		HEX	60	;[1111]
;
;-------------- Hrbg`FbN`mcf[^ --------------------------
RALE_BIT_AND
		BYTE	10000000B	;[0]
		BYTE	01000000B	;[1]
		BYTE	00100000B	;[2]
		BYTE	00010000B	;[3]
		BYTE	00001000B	;[4]
		BYTE	00000100B	;[5]
		BYTE	00000010B	;[6]
		BYTE	00000001B	;[7]
;
;-------------- Hrbgf[^ ----------------------------------------
RALE_BIT_DATA
		BYTE	00001000B	;[] 
		BYTE	00001000B
		BYTE	00001000B
		BYTE	00001000B
		BYTE	00001000B
		BYTE	00001000B
		BYTE	00001000B
		BYTE	00001000B
;
		BYTE	00001000B	;[]
		BYTE	00001000B
		BYTE	00001000B
		BYTE	00001000B
		BYTE	00001000B
		BYTE	00001000B
		BYTE	00001000B
		BYTE	00001000B
;
		BYTE	00000000B	;[^] low
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000001B
		BYTE	00000010B
		BYTE	00000100B
		BYTE	00001000B
;
		BYTE	00010000B	;[^] high
		BYTE	00100000B
		BYTE	01000000B
		BYTE	10000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
;
		BYTE	00001000B	;[_] high
		BYTE	00000100B
		BYTE	00000010B
		BYTE	00000001B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
;
		BYTE	00000000B	;[_] low
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	10000000B
		BYTE	01000000B
		BYTE	00100000B
		BYTE	00010000B
;
		BYTE	00000000B	;[]
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	11111111B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
;
		BYTE	00001000B	;[]
		BYTE	00001000B
		BYTE	00001000B
		BYTE	00001000B
		BYTE	11111111B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
;
		BYTE	00001000B	;[]
		BYTE	00001000B
		BYTE	00001000B
		BYTE	00001000B
		BYTE	00001111B
		BYTE	00001000B
		BYTE	00001000B
		BYTE	00001000B
;
		BYTE	00001000B	;[]
		BYTE	00001000B
		BYTE	00001000B
		BYTE	00001000B
		BYTE	11111000B
		BYTE	00001000B
		BYTE	00001000B
		BYTE	00001000B
;
		BYTE	00000000B	;[]
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	11111111B
		BYTE	00001000B
		BYTE	00001000B
		BYTE	00001000B
;
;;;;;-------------- Hrbg`FbN`mcf[^ --------------------------
;;;;RALE_BIT_AND
;;;;		    WORD    1000000000000000B	    ;[0]
;;;;		    WORD    0100000000000000B	    ;[1]
;;;;		    WORD    0010000000000000B	    ;[2]
;;;;		    WORD    0001000000000000B	    ;[3]
;;;;		    WORD    0000100000000000B	    ;[4]
;;;;		    WORD    0000010000000000B	    ;[5]
;;;;		    WORD    0000001000000000B	    ;[6]
;;;;		    WORD    0000000100000000B	    ;[7]
;;;;		    WORD    0000000010000000B	    ;[8]
;;;;		    WORD    0000000001000000B	    ;[9]
;;;;		    WORD    0000000000100000B	    ;[A]
;;;;		    WORD    0000000000010000B	    ;[B]
;;;;		    WORD    0000000000001000B	    ;[C]
;;;;		    WORD    0000000000000100B	    ;[D]
;;;;		    WORD    0000000000000010B	    ;[E]
;;;;		    WORD    0000000000000001B	    ;[F]
;;;;;
;;;;;-------------- Hrbgf[^ ----------------------------------------
;;;;RALE_BIT_DATA
;;;;		    WORD    0000000010000000B	    ;[] 
;;;;		    WORD    0000000010000000B
;;;;		    WORD    0000000010000000B
;;;;		    WORD    0000000010000000B
;;;;		    WORD    0000000010000000B
;;;;		    WORD    0000000010000000B
;;;;		    WORD    0000000010000000B
;;;;		    WORD    0000000010000000B
;;;;		    WORD    0000000010000000B
;;;;		    WORD    0000000010000000B
;;;;		    WORD    0000000010000000B
;;;;		    WORD    0000000010000000B
;;;;		    WORD    0000000010000000B
;;;;		    WORD    0000000010000000B
;;;;		    WORD    0000000010000000B
;;;;		    WORD    0000000010000000B
;;;;;
;;;;		    WORD    0000000010000000B	    ;[]
;;;;		    WORD    0000000010000000B
;;;;		    WORD    0000000010000000B
;;;;		    WORD    0000000010000000B
;;;;		    WORD    0000000010000000B
;;;;		    WORD    0000000010000000B
;;;;		    WORD    0000000010000000B
;;;;		    WORD    0000000010000000B
;;;;		    WORD    0000000010000000B
;;;;		    WORD    0000000010000000B
;;;;		    WORD    0000000010000000B
;;;;		    WORD    0000000010000000B
;;;;		    WORD    0000000010000000B
;;;;		    WORD    0000000010000000B
;;;;		    WORD    0000000010000000B
;;;;		    WORD    0000000010000000B
;;;;;
;;;;		    WORD    0000000000000000B	    ;[^] low
;;;;		    WORD    0000000000000000B
;;;;		    WORD    0000000000000000B
;;;;		    WORD    0000000000000000B
;;;;		    WORD    0000000000000000B
;;;;		    WORD    0000000000000000B
;;;;		    WORD    0000000000000000B
;;;;		    WORD    0000000000000000B
;;;;		    WORD    0000000000000001B
;;;;		    WORD    0000000000000010B
;;;;		    WORD    0000000000000100B
;;;;		    WORD    0000000000001000B
;;;;		    WORD    0000000000010000B
;;;;		    WORD    0000000000100000B
;;;;		    WORD    0000000001000000B
;;;;		    WORD    0000000010000000B
;;;;;
;;;;		    WORD    0000000100000000B	    ;[^] high
;;;;		    WORD    0000001000000000B
;;;;		    WORD    0000010000000000B
;;;;		    WORD    0000100000000000B
;;;;		    WORD    0001000000000000B
;;;;		    WORD    0010000000000000B
;;;;		    WORD    0100000000000000B
;;;;		    WORD    1000000000000000B
;;;;		    WORD    0000000000000000B
;;;;		    WORD    0000000000000000B
;;;;		    WORD    0000000000000000B
;;;;		    WORD    0000000000000000B
;;;;		    WORD    0000000000000000B
;;;;		    WORD    0000000000000000B
;;;;		    WORD    0000000000000000B
;;;;		    WORD    0000000000000000B
;;;;;
;;;;		    WORD    0000000010000000B	    ;[_] high
;;;;		    WORD    0000000001000000B
;;;;		    WORD    0000000000100000B
;;;;		    WORD    0000000000010000B
;;;;		    WORD    0000000000001000B
;;;;		    WORD    0000000000000100B
;;;;		    WORD    0000000000000010B
;;;;		    WORD    0000000000000001B
;;;;		    WORD    0000000000000000B
;;;;		    WORD    0000000000000000B
;;;;		    WORD    0000000000000000B
;;;;		    WORD    0000000000000000B
;;;;		    WORD    0000000000000000B
;;;;		    WORD    0000000000000000B
;;;;		    WORD    0000000000000000B
;;;;		    WORD    0000000000000000B
;;;;;
;;;;		    WORD    0000000000000000B	    ;[_] low
;;;;		    WORD    0000000000000000B
;;;;		    WORD    0000000000000000B
;;;;		    WORD    0000000000000000B
;;;;		    WORD    0000000000000000B
;;;;		    WORD    0000000000000000B
;;;;		    WORD    0000000000000000B
;;;;		    WORD    0000000000000000B
;;;;		    WORD    1000000000000000B
;;;;		    WORD    0100000000000000B
;;;;		    WORD    0010000000000000B
;;;;		    WORD    0001000000000000B
;;;;		    WORD    0000100000000000B
;;;;		    WORD    0000010000000000B
;;;;		    WORD    0000001000000000B
;;;;		    WORD    0000000100000000B
;;;;;
;;;;		    WORD    0000000000000000B	    ;[]
;;;;		    WORD    0000000000000000B
;;;;		    WORD    0000000000000000B
;;;;		    WORD    0000000000000000B
;;;;		    WORD    0000000000000000B
;;;;		    WORD    0000000000000000B
;;;;		    WORD    0000000000000000B
;;;;		    WORD    0000000000000000B
;;;;		    WORD    1111111111111111B
;;;;		    WORD    0000000000000000B
;;;;		    WORD    0000000000000000B
;;;;		    WORD    0000000000000000B
;;;;		    WORD    0000000000000000B
;;;;		    WORD    0000000000000000B
;;;;		    WORD    0000000000000000B
;;;;		    WORD    0000000000000000B
;;;;;
;;;;		    WORD    0000000010000000B	    ;[]
;;;;		    WORD    0000000010000000B
;;;;		    WORD    0000000010000000B
;;;;		    WORD    0000000010000000B
;;;;		    WORD    0000000010000000B
;;;;		    WORD    0000000010000000B
;;;;		    WORD    0000000010000000B
;;;;		    WORD    1111111111111111B
;;;;		    WORD    0000000000000000B
;;;;		    WORD    0000000000000000B
;;;;		    WORD    0000000000000000B
;;;;		    WORD    0000000000000000B
;;;;		    WORD    0000000000000000B
;;;;		    WORD    0000000000000000B
;;;;		    WORD    0000000000000000B
;;;;		    WORD    0000000000000000B
;;;;;
;;;;		    WORD    0000000010000000B	    ;[]
;;;;		    WORD    0000000010000000B
;;;;		    WORD    0000000010000000B
;;;;		    WORD    0000000010000000B
;;;;		    WORD    0000000010000000B
;;;;		    WORD    0000000010000000B
;;;;		    WORD    0000000010000000B
;;;;		    WORD    0000000010000000B
;;;;		    WORD    0000000011111111B
;;;;		    WORD    0000000010000000B
;;;;		    WORD    0000000010000000B
;;;;		    WORD    0000000010000000B
;;;;		    WORD    0000000010000000B
;;;;		    WORD    0000000010000000B
;;;;		    WORD    0000000010000000B
;;;;		    WORD    0000000010000000B
;;;;;
;;;;		    WORD    0000000010000000B	    ;[]
;;;;		    WORD    0000000010000000B
;;;;		    WORD    0000000010000000B
;;;;		    WORD    0000000010000000B
;;;;		    WORD    0000000010000000B
;;;;		    WORD    0000000010000000B
;;;;		    WORD    0000000010000000B
;;;;		    WORD    0000000010000000B
;;;;		    WORD    1111111110000000B
;;;;		    WORD    0000000010000000B
;;;;		    WORD    0000000010000000B
;;;;		    WORD    0000000010000000B
;;;;		    WORD    0000000010000000B
;;;;		    WORD    0000000010000000B
;;;;		    WORD    0000000010000000B
;;;;		    WORD    0000000010000000B
;;;;;
;;;;		    WORD    0000000000000000B	    ;[]
;;;;		    WORD    0000000000000000B
;;;;		    WORD    0000000000000000B
;;;;		    WORD    0000000000000000B
;;;;		    WORD    0000000000000000B
;;;;		    WORD    0000000000000000B
;;;;		    WORD    0000000000000000B
;;;;		    WORD    0000000000000000B
;;;;		    WORD    1111111111111111B
;;;;		    WORD    0000000010000000B
;;;;		    WORD    0000000010000000B
;;;;		    WORD    0000000010000000B
;;;;		    WORD    0000000010000000B
;;;;		    WORD    0000000010000000B
;;;;		    WORD    0000000010000000B
;;;;		    WORD    0000000010000000B
;;;;;
;
;
;
;
;
		END
