;************************************************************************
;*									*
;*	title name	: "yossy"					*
;*	proccess	: mini game 3					*
;*	file name	: ys_mini2					*
;*									*
;************************************************************************
;
;
		SALL
;
		include		ys_header.inc
		include		ys_color.h
		include		../union/ys_mapobj.h
		include		ys_presno.h
;
		XALL
;
;
;
;------------------------------------------------------------------------
;-		global symbol						-
;------------------------------------------------------------------------
;
		GLB	MINIINT1_3,MINIMOV1_3,M_PTRIN,M_PTRMV,M_ETRIN
		GLB	M_ETRMV,M_EGGIN,M_EGGMV
;
;------------------------------------------------------------------------
;-		extern symbol						-
;------------------------------------------------------------------------
;-------------< ys_main >------------------------------------------------
		EXT	OAMDXCLR,RANDAM
		EXT	SOUND_3_ON
;
;-------------< ys_init >------------------------------------------------
		EXT	VRAMDX_ST
		EXT	MINIT
;
;-------------< ys_rpro >------------------------------------------------
		EXT	CHIPON
;
;-------------< ys_play >------------------------------------------------
		EXT	PLAYER,PLCSET,HERI_INITL
		EXT	PSCRL_INIT,PLSCRL
;
;-------------< ys_enmy >------------------------------------------------
		EXT	ENEMY_IN,ENCSET_DM,ENRAMCLR,ENINSR_I,TROBJ_SR_4x4
		EXT	TROBJ_OAM_4x4_I,ENCLEAR,BEAT_P_SET
;
		EXT	TROBJ_PLOT_X,TROBJ_PLOT_Y
;
		EXT	M_PTR,M_ETR,M_EGG
;
		EXT	EMOVE,EMGNT
		EXT	ENMDCK
		EXT	ATSCRL_XYCL_L,EMGNT_CANCEL
;-------------< ys_mini >------------------------------------------------
		EXT	BACK_GAME
;-------------< ys_game >------------------------------------------------
		EXT	INHDMA
;-------------< ys_data >------------------------------------------------
		EXT	COS,SIN
;
;------------------------------------------------------------------------
;-		define symbol						-
;------------------------------------------------------------------------
;
;
;
;************************************************************************
;*									*
;*		program start						*
;*									*
;************************************************************************
;
;
;
		EXTEND
;
;
		MEM8
		IDX8
;
Group_11	GROUP	Mini2_pro
Mini2_pro	SECT	REL
;
;----------------------------------------------------------------
;
;
;****************************************************************
;*								*
;*		~j Q[ CjV Zbg			*
;*								*
;****************************************************************
;
;
MINIINT1_3	EQU	$
;-------------- XN[l NA -----------------------------
		M16			; memory 16 bit mode !!
;
		STZ	<SCCH1
		STZ	!ESCCH1
		STZ	!ATSCRL_XSPD
		STZ	!ATSCRL_SCCH1L
		STZ	!ATSCRL_SCCH1H
;
		STZ	<SCCV1
		STZ	<SCCH2
		STZ	<SCCV2
		STZ	<SCCH3
		STZ	<SCCV3
;
		M8			; memory 8bit mode
;
		LDA	#069H
		STA	!BG1SCF
		STA	2107H
;;;		LDA	#039H
		LDA	#038H
		STA	!BG2SCF
		STA	2108H
		LDA	#029H
		STA	BGMODE
		STA	2105H
		LDA	#020H
		STA	SUBADF
		STZ	!WIND25
;
;-------------- Q[ CjV -----------------------------------
		MI16			; memory,index 8 bit mode !!
;
		LDA	#00020H
		STA	PLYPSL		; player Y initial set !!
		LDA	#00030H
		STA	PLXPSL		; player X initial set !!
		STZ	UNBUFAD
		STA	TIMER
		LDA	#P_HERI
		STA	PLTYPE		; wRv^[[hZbg
		JSL	>HERI_INITL	; wRv^[[hCjV
;
		LDA	#00050H
		STA	MNTIME		; ~jQ[^C}[Zbg
		LDA	#00001
		STA	MNTMCT		; ~jQ[^C}[JE^[Zbg
;
		LDA	#01C0H
		STA	!TRENDTIM	; geme over timer set
		STZ	!TRKYORI	;  NA[
;
		LDA	#00018H
		STA	!NUKINO
;
		MEM8
		SEP	#00100000B	; memory 8bit mode
;
		STZ	!TRAKCCNT	; Ԃ CjV  JEg
		LDA	#006H
		STA	!TRDRBCNT	; D_ CjV  JEg
		STZ	!TRBGONFG
		STZ	!TRGMOVER
;
		MEM16
		REP	#00100000B	; memory 16bit mode
;
;;;;K;;;;		LDA	#0FFFFH
;;;;K;;;;		STA	OBJCHR_BNK
;;;;K;;;;		STA	OBJCHR_BNK+2
;;;;K;;;;		STA	OBJCHR_BNK+4
;
		LDX	#001FEH
		LDA	#00000
;
MINIINT1_3_050	EQU	$
		STA	>BGUNIT,X
		STA	>BGUNIT+200H,X
		STA	>BGUNIT+400H,X
		STA	>BGUNIT+600H,X
		STA	>BGUNIT+800H,X
		STA	>BGUNIT+0A00H,X
		STA	>BGUNIT+0C00H,X
		DEX
		DEX
		BPL	MINIINT1_3_050	; BG unit buffer clear end ?
;					; Yes !!
		LDX	#00FH*2
		LDA	#00100H
;
MINIINT1_3_100	EQU	$
		STA	>BGUNIT+000H,X
		STA	>BGUNIT+160H,X
		STA	>BGUNIT+200H,X
		STA	>BGUNIT+360H,X
		STA	>BGUNIT+400H,X
		STA	>BGUNIT+560H,X
		STA	>BGUNIT+600H,X
		STA	>BGUNIT+760H,X
		STA	>BGUNIT+800H,X
		STA	>BGUNIT+960H,X
		STA	>BGUNIT+0A00H,X
		STA	>BGUNIT+0B60H,X
		STA	>BGUNIT+0C00H,X
		STA	>BGUNIT+0D60H,X
		DEX
		DEX
		BPL	MINIINT1_3_100
;
		I8			; index 8 bit mode !!
;
		LDA	#M_PTR
		JSL	>ENINSR_I
		LDA	#M_ETR
		JSL	>ENINSR_I
;
;;;;MINIINT1_3_200	EQU	$
		LDA	#M_EGG
		JSL	>ENINSR_I
;;;		INC	ENTMCT
;;;		LDA	ENTMCT
;;;		CMP	#006H
;;;		BNE	MINIINT1_3_200
;
		MI8			; memory,index 8 bit mode !!
;
;;;;K;;;;		JSL	>INHDMA
;
		JSL	>ENEMY_IN
;
		RTS
;
;
;****************************************************************
;*								*
;*		~j Q[					*
;*								*
;****************************************************************
M_E_LMAX	EQU	0FFC0H		; D_ gbR   
;
M_E_RMAX	EQU	00180H		; D_ gbR E  
;
TRBGMDT		EQU	$
;NOM;		HEX	00C,009,00B
		HEX	005,004,005
;
MINIMOV1_3	EQU	$
		LDA	!MSGMOD		; bZ[W EBhD nm ?
		BEQ	MNMV_3_000	;	NO -> MNMV_3_000
		JMP	MNMV_3_600
;
MNMV_3_000	EQU	$
		MI16			; memory , index 16bit mode
;
		JSR	B3MTTRSB	; BG3 [^[ Tu
;
		LDA	!ATSCRL_SCCH1
		STA	!TRB1SCBK	; BG1 X possition back set
;
		LDA	#001C0H
		STA	!ATSCRL_XSPD
		STA	!SCRL_XSPD
		LDA	!PLXPSL
		SEC
		SBC	<SCCH1		; vC[  |WV
		STA	<WORK2
		CMP	#00080H
		BMI	MNMV_3_230	; vC[  |WV EH
;					; yes
		LDA	#00380H
		STA	!ATSCRL_XSPD	; Xs[hto
		STA	!SCRL_XSPD
MNMV_3_230	EQU	$
;
		JSL	>ATSCRL_XYCL_L	; I[gXN[ Tu
;
		IDX8
		SEP	#00010000B	; index 8bit mode
;
		LDY	!TRGMOVER
		BPL	MNMV_3_270	; Q[ I[o[ tO nmH
;					; yes
		DEC	!TRENDTIM
		BNE	MNMV_3_260
;
		INC	!TRENDTIM
		LDY	!TRGMKEKA
		CPY	#001H
		BEQ	MNMV_3_250
;
;;;;K;;;;		LDA	!MINIMD
;;;;K;;;;		INC	A
;;;;K;;;;		CMP	#00003H
;;;;K;;;;		BEQ	MNMV_3_250
;;;;K;;;;;
;;;;K;;;;		LDA	#MINIT
;;;;K;;;;		STA	!MODENO
;;;;K;;;;		BRA	MNMV_3_260
MNMV_3_250	EQU	$
		JSL	>BACK_GAME
		MI8
		RTS
;;;;K;;;;		LDA	#HMPIN
;;;;K;;;;		STA	!MODENO
		MEM16
MNMV_3_260	EQU	$
		JMP	MNMV_3_390
;
MNMV_3_270	EQU	$
		LDY	!TRDRBIDX
		LDA	!ENXPSL,Y
		SEC
		SBC	!ATSCRL_SCCH1
		CMP	#M_E_RMAX
		BMI	MNMV_3_290
;
		SEC
		SBC	#M_E_RMAX
		STA	<WORK0
		LDA	!ATSCRL_SCCH1
		CLC
		ADC	<WORK0
		STA	!ATSCRL_SCCH1
		LDA	!ENXSPD,Y
		STA	!SCRL_XSPD
		BRA	MNMV_3_300
MNMV_3_290	EQU	$
		CMP	#M_E_LMAX
		BPL	MNMV_3_300
;
		SEC
		SBC	#M_E_LMAX
		STA	<WORK0
		LDA	!ATSCRL_SCCH1
		CLC
		ADC	<WORK0
		STA	!ATSCRL_SCCH1
		LDA	!ENXSPD,Y
		STA	!SCRL_XSPD
MNMV_3_300	EQU	$
		LDY	!TRDRBCNT
		BEQ	MNMV_3_310	; Q[IH (D_gbR O ?)
;					; no
		LDA	!ATSCRL_SCCH1
		SEC
		SBC	!TRB1SCBK
		STA	<WORK0		; Ot[ƍ̂w̍
;
		LDA	!TRKYORI
		CLC
		ADC	<WORK0
		CMP	#02C04H
		BCC	MNMV_3_350	; Q[IH (move possition end ?)
;					; yes
MNMV_3_310	EQU	$
		LDX	!TRAKCIDX
		LDY	!TRDRBIDX
		LDA	#00500H
		STA	!ENXMAX,X	; Q[dmc Xs[hto
		STA	!ENXMAX,Y	; Q[dmc Xs[hto
;
		MEM8
		SEP	#00100000B	; memory 8bit mode
;
		LDY	#000H
		LDA	!TRAKCCNT
		CMP	!TRDRBCNT
		BEQ	MNMV_3_340	;  H
;					; no
		PHP
;
		INY
;
		PLP
;
		BCC	MNMV_3_340	; vC[vhm H
;					; yes
		INY
MNMV_3_340	EQU	$
		STY	!TRGMKEKA	; Q[  Zbg
		LDA	TRBGMDT,Y
		STA	!SOUND_0	; Q[dmc TEh Zbg
;NOM;		STA	<SOUND2		; Q[dmc TEh Zbg
		TYA
		ORA	#080H
		STA	!TRGMOVER	; Q[dmc tO Zbg
;
		MEM16
		REP	#00100000B	; memory 16bit mode
;
		BRA	MNMV_3_390
MNMV_3_350	EQU	$
		STA	!TRKYORI
;
;
		LDY	#000H		;  BG set flag clear
		AND	#0FFF4H
		CMP	#01780H
		BNE	MNMV_3_360	; ԃ|CgPH
;					; yes
		INY			;  BG set flag on
		BRA	MNMV_3_380
MNMV_3_360	EQU	$
		CMP	#01900H
		BNE	MNMV_3_370	;  BG clear ?
;					; yes
		INY
		INY			;  BG clear flag on
		BRA	MNMV_3_380
MNMV_3_370	EQU	$
		CMP	#02380H
		BNE	MNMV_3_375	; ԃ|CgQH
;					; yes
		INY			;  BG set flag on
		BRA	MNMV_3_380
MNMV_3_375	EQU	$
		CMP	#02500H
		BNE	MNMV_3_380	;  BG clear ?
;					; yes
		INY
		INY			;  BG clear flag on
MNMV_3_380	EQU	$
		STY	!TRBGONFG	; flag set
;
;
MNMV_3_390	EQU	$
		LDA	!ATSCRL_SCCH1
		SEC
		SBC	!TRB1SCBK
		LSR	A
		STA	<WORK0		; Ot[ƍ̂w̍
		LDA	<SCCH2
		CLC
		ADC	<WORK0
		STA	<SCCH2
;
		LDA	!ATSCRL_SCCH1
;
;
		CMP	#00400H
		BCC	MNMV_3_500	; max BG scroll ?
;					; yes
		SEC
		SBC	#00200H		; scroll return
;
		PHA
;
		LDA	!PLXPSL
		SEC
		SBC	#00200H
		STA	!PLXPSL		; player possition ␳
;
		LDX	#PHR_MG_NO*(3-1)
MOMUSU_010	EQU	$
		LDA	>PHR_MGXPSL,X
		SEC
		SBC	#00200H
		STA	>PHR_MGXPSL,X
		TXA
		SEC
		SBC	#PHR_MG_NO
		TAX
		BPL	MOMUSU_010	; player  possition ␳
;
		LDX	#(ENNO-1)*4
MNMV_3_400	EQU	$
		LDA	!ENMODE,X
		BEQ	MNMV_3_450	; move enmy ?
;					; yes
		LDA	!ENXPSL,X
		SEC
		SBC	#00200H
		STA	!ENXPSL,X	; ␳
MNMV_3_450	EQU	$
		DEX
		DEX
		DEX
		DEX
		BPL	MNMV_3_400	; all check ok ?
;					; yes
MNMV_3_460	EQU	$
		PLA
;
MNMV_3_500	EQU	$
		STA	<SCCH1		; BG1 scroll counter move
		STA	!ESCCH1		; enmy use BG1 scroll counter move
		STA	!ATSCRL_SCCH1
;
;
MNMV_3_600	EQU	$
;
		M8
;
		JSR	B3MSGST		; Q[ I[o[ bZ[W Zbg
;
		JSL	>OAMDXCLR	; OAM clear sub !!
		JSL	>PLCSET		; player char set sub !!
		JSL	>ENCSET_DM	; enemy char set sub !!
;
		JSL	>PLAYER		; player move sub !!
		LDA	!MSGMOD		; bZ[W EBhD nm ?
		BNE	MNMV_3_630	;	YES -> MNMV_3_630
		JSL	>ENEMY_IN	; enemy move sub !!
;
MNMV_3_630	EQU	$
		M16			; memory 16 bit mode !!
;
		M_CHIP	DX_OAM		; SOAM_DX => OAM convert
;
		JSR	YAJISET		;  BG set sub !!
;
		M8			; memory 8 bit mode !!
;
;
		JSR	MARKSET		;  char set sub !!
;
		RTS
;
		MEM16
		IDX16
;%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
;%	    BG3 [^[ Tu					%
;%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
;
SUZIDATU	EQU	$
		WORD	02900H,02901H,02902H,02903H,02904H	; f[^ij
		WORD	02905H,02906H,02907H,02908H,02909H
SUZIDATD	EQU	$
		WORD	02910H,02911H,02912H,02913H,02914H	; f[^ij
		WORD	02915H,02916H,02917H,02918H,02919H
;
SZCHGVDT	EQU	$
		WORD	03485H,08003H			; Ԃ JEg PǑ
		WORD	020FEH,020FEH
;
		WORD	03486H,08003H
		WORD	020FEH,020FEH			; Ԃ JEg P̌
;
;
		WORD	03499H,08003H
		WORD	020FEH,020FEH			; D_ JEg PǑ
;
		WORD	0349AH,08003H
		WORD	020FEH,020FEH			; D_ JEg P̌
;
		WORD	0FFFFH
SZCHGVDTE	EQU	$
;
ADRMNDT		EQU	$
		WORD	0001CH,00014H,0000CH,00004H	; address minus data
;
;
;
B3MTTRSB	EQU	$
		STZ	<WORK0		; Ԃ PǑ f[^ CfbNX
		STZ	<WORK2		; Ԃ P̌ f[^ CfbNX
		STZ	<WORK4		; D_ PǑ f[^ CfbNX
		STZ	<WORK6		; D_ P̌ f[^ CfbNX
		LDA	#00001H
		STA	<WORKE		; loop count
;
		LDY	#00000H
		TYX			;;;
BMTS_100	EQU	$
		LDA	!TRAKCCNT,Y
		AND	#00FFH
BMTS_200	EQU	$
		STA	<WORK2,X
		SEC
		SBC	#000AH
		BMI	BMTS_300	; POȏH
;
		INC	<WORK0,X	; PǑ {P
		BRA	BMTS_200
BMTS_300	EQU	$
		INY
		INX
		INX
		INX
		INX
		DEC	<WORKE
		BPL	BMTS_100	; Ԃ,D_ Zbg dmcH
;					; yes
		ASL	<WORK0
		ASL	<WORK2
		ASL	<WORK4
		ASL	<WORK6
;
;
		LDA	>VRAMD
		CLC
		ADC	#(SZCHGVDTE-SZCHGVDT)-2
		TAX				; vramd address set
		STA	>VRAMD
		LDY	#(SZCHGVDTE-SZCHGVDT)-2
;
BMTS_400	EQU	$
		LDA	SZCHGVDT,Y
		STA	>VRAMD+2,X		; vramd base data set
		DEX
		DEX
		DEY
		DEY
		BPL	BMTS_400		; set end ?
;						; yes
		LDA	#00006H
		STA	<WORKE
BMTS_500	EQU	$
		LDX	<WORKE
		LDA	>VRAMD
		SEC
		SBC	ADRMNDT,X		; varmd set index comp
;
		PHA
;
		LDY	<WORK0,X
		LDA	SUZIDATU,Y
;
		PLX
;
		STA	>VRAMD+2,X		; up charcter No. set
;
		LDA	SUZIDATD,Y
		STA	>VRAMD+2+2,X		; down charcter No. set
;
		DEC	<WORKE
		DEC	<WORKE
		BPL	BMTS_500		; all data f[^ set end ?
;						; yes
		RTS
;
		MEM16
		IDX8
;%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
;%	     BG set Tu					%
;%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
;
YAJIVDT		EQU	$
		WORD	06A78H,00007H
		WORD	00480H,00481H,00482H,00483H
;
		WORD	06A98H,00005H
		WORD	00490H,00491H,00492H
;
		WORD	06AB9H,00001H
		WORD	00493H
;
		WORD	0FFFFH
;
YAJIVDT1	EQU	$
		WORD	06A78H,00007H
		WORD	010EEH,010EEH,010EEH,010EEH
;
		WORD	06A98H,00005H
		WORD	010EEH,010EEH,010EEH
;
		WORD	06AB9H,00001H
		WORD	01046H
;
		WORD	0FFFFH
YAJIVDTE	EQU	$
;
YAJDTCNT	EQU	(YAJIVDT1-YAJIVDT)-2
;
YAJIDX		EQU	$
		WORD	YAJIVDT		; 0  BG set
		WORD	YAJIVDT1	; 1  BG clear
;
;
YAJISET		EQU	$
		LDY	!TRBGONFG
		BNE	YJST_100
;
		RTS
YJST_100	EQU	$
		IDX16
		REP	#00010000B		; index 16bit mode
;
		LDA	!TRBGONFG
		AND	#00FFH
		DEC	A
		ASL	A
		TAY				; index set
;
		LDA	YAJIDX,Y
		STA	<WORK0			; start index set
;
		LDA	>VRAMD
		CLC
		ADC	#YAJDTCNT
		TAX				; vramd address set
		STA	>VRAMD
		LDY	#YAJDTCNT		; BG index set
YJST_400	EQU	$
		LDA	(<WORK0),Y
		STA	>VRAMD+2,X		; vramd base data set
		DEX
		DEX
		DEY
		DEY
		BPL	YJST_400		; set end ?
;						; yes
		IDX8
		SEP	#00010000B		; index 8bit mode
;
;
		LDY	#000H
		STY	!TRBGONFG		; BG set flag clear
;
		RTS
;
;
		MEM8
		IDX8
;%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
;%	     afR Zbg Tu				%
;%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
;
YOUDRWDT	EQU	$		; cqnv
		WORD	035CCH,00011H
;
		WORD	0217FH,0217FH,02927H,02927H
		WORD	02921H,02923H,02928H,0217FH
		WORD	0217FH
;
;
		WORD	035ECH,00011H
;
		WORD	0217FH,0217FH,0A927H,02937H
		WORD	0A921H,02933H,02938H,0217FH
		WORD	0217FH
;
;
		WORD	0FFFFH
;
YOULOSDT	EQU	$		; xnt knrdI
		WORD	035CCH,00011H
;
		WORD	02D20H,02D21H,02D22H,02D7FH
		WORD	02D25H,02D21H,0ED31H,02D26H
		WORD	0AD30H
;
;
		WORD	035ECH,00011H
;
		WORD	02D30H,0AD21H,0AD21H,02D7FH
		WORD	02D35H,0AD21H,02D31H,02D35H
		WORD	02D29H
;
;
		WORD	0FFFFH
;
YOUWINDT	EQU	$		; xnt vhmI
		WORD	035CCH,00011H
;
		WORD	02520H,02521H,02522H,0257FH
		WORD	02523H,02524H,0E532H,0A530H
		WORD	0257FH
;
;
		WORD	035ECH,00011H
;
		WORD	02530H,0A521H,0A521H,0257FH
		WORD	02533H,02534H,02532H,02529H
		WORD	0257FH
;
;
		WORD	0FFFFH
;
;
B3MSCNT		EQU	(YOULOSDT-YOUDRWDT)-2
;
B3MSGIDX	EQU	$
		WORD	YOUDRWDT	; 0 DROW
		WORD	YOULOSDT	; 1 YOU LOSE!
		WORD	YOUWINDT	; 2 YOU WIN!
;
;
B3MSGST		EQU	$
		LDA	!TRGMOVER
		BPL	B3MS_500
;
		TAY
		INY
		BEQ	B3MS_500
;
		MEM16
		IDX16
		REP	#00110000B		; memory,index 16bit mode
;
		AND	#0007FH
		ASL	A
		TAY				; index set
;
		LDA	B3MSGIDX,Y
		STA	<WORK0			; start index set
;
		LDA	>VRAMD
		CLC
		ADC	#B3MSCNT
		TAX				; vramd address set
		STA	>VRAMD
		LDY	#B3MSCNT
;
B3MS_400	EQU	$
		LDA	(<WORK0),Y
		STA	>VRAMD+2,X		; vramd base data set
		DEX
		DEX
		DEY
		DEY
		BPL	B3MS_400		; set end ?
;						; yes
		MEM8
		IDX8
		SEP	#00110000B		; memory,index 8bit mode
;
		LDA	#0FFH
		STA	!TRGMOVER
;
B3MS_500	EQU	$
		RTS
;
;
		MEM8
		IDX8
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		MARKSET ( ~jQ[Zbg )			x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
MKXPADDT	EQU	$
		HEX	000,008,000,008
		HEX	000,008,000,008
MKYPADDT	EQU	$
		HEX	000,000,008,008
		HEX	002,002,00A,00A
MKCHARDT	EQU	$
		HEX	000,000,010,010
		HEX	000,000,011,011
MKATRBDT	EQU	$
		HEX	033,073,033,073
		HEX	033,073,033,073
;
MARKSET		EQU	$
;
		MEM16
		REP	#00100000B		; memory 16bit mosde
;
		LDA	!TRKYORI
		LSR	A
		LSR	A
		LSR	A
		LSR	A
		LSR	A
		LSR	A
		LSR	A
		STA	<WORK0			; 1/40H move
;
		MEM8
		SEP	#00100000B		; memory 8bit mode
;
		LDA	#004H
		STA	<WORK2			; loop counter
		LDX	#000H
		TXY
		LDA	<FRCNT
		AND	#00000100B
		BEQ	MRKS_100		; pattern 1 ?
;						; yes
		LDY	#004H
MRKS_100	EQU	$
		LDA	#04CH			; start marker possition
		CLC
		ADC	<WORK0			; {
		CLC
		ADC	MKXPADDT,Y
		STA	!OAM,X			; xpos set
		LDA	#00013H
		CLC
		ADC	MKYPADDT,Y
		STA	!OAM+1,X		; ypos set
		LDA	MKCHARDT,Y
		STA	!OAM+2,X		; charcter No. set
		LDA	MKATRBDT,Y
		STA	!OAM+3,X		; atribute set
;
		PHX
;
		TXA
		LSR	A
		LSR	A
		TAX
		LDA	#000H
		STA	!OAMSB,X		; oam sub set
;
		PLX
;
		INX
		INX
		INX
		INX
		INY
		DEC	<WORK2
		BNE	MRKS_100		; all set end ?
;						; yes
		RTS
;
;
;------------------------------------------------------------------------
		MEM16
		IDX8
;
		DPAGE	EN0RAM
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		M_PTRIN ( ~jQ[vC[gbRCjVZbg )x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
M_PTRIN		EQU	$
		LDA	#00080H+008H
		STA	ENYPSL,X
		LDA	#00020H
		STA	ENXPSL,X
		LDA	#00008H
		STA	ENTIM0,X		; up,down move timer init set
		LDA	#00002H
		STA	!ENTIM1,X		; ԗ pattern timer init set
		STX	!TRAKCIDX		; Ԃ CfbNX Zbg
;
		LDA	#0A0H-020H
		STA	!ENWRK2,X		;  initial set
		LDA	#00020H
		STA	!ENTIM2,X		; initial lnud v`hs timer set
		LDA	#00010H
		STA	!ENXPOW,X		; wl
		LDA	#00300H
		STA	!ENXMAX,X		; w  Xs[h
;
		RTL
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		M_PTRIN ( ~jQ[vC[gbR[u )		x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
PLCHRNO		EQU	$
		WORD	00000H,00001H,00002H,00001H
;
;
M_PTRMV		EQU	$
		LDY	!TRGMOVER
		BMI	M_PTRMV_200
;
		LDY	!TRDRBIDX
		LDA	!ENXPSL,Y
		SEC
		SBC	!ENXPSL,X
		AND	#0FFF0H
		STA	<EWORK2
		CMP	!ENWRK2,X
		BNE	M_PTRMV_200	; ړ H
;					; no
		LDA	!ENTIM2,X
		BNE	M_PTRMV_200	; lnud v`hs H
;					; no
		MEM8
		SEP	#00100000B	; memory 8bit mode
;
		LDA	2137H
		LDA	213CH
		ADC	TRENRND
		ADC	<FRCNT
		STA	TRENRND		; _
;
		BRA	M_PTRMV_100
		BIT	#00001000B
		BNE	M_PTRMV_100	; move ? (OFF:wait,ON:move init set)
;					; yes
		MEM16
		REP	#00100000B	; memory 16bit mode
;
		LDA	#00300H
		STA	!ENXMAX,X
		LDA	#00020H
		STA	!ENTIM2,X
		BRA	M_PTRMV_200
M_PTRMV_100	EQU	$
		MEM8
;
		AND	#00000111B
		STA	<EWORK0
		STZ	<EWORK1
;
		MEM16
		REP	#00100000B	; memory 16bit mode
;
		ASL	<EWORK0
		JSR	TRSPDSET	; move initial ram set sub
M_PTRMV_200	EQU	$
;
;
;
		LDA	ENTIM0,X
		BNE	M_PTRMV_250
;
		LDA	ENCHPT,X
		INC	A
		AND	#00003H
		STA	ENCHPT,X
		LDA	#00008H
		STA	ENTIM0,X
;
M_PTRMV_250	EQU	$
;;;;;;;;		LDA	ENTIM1,X
;;;;;;;;		BNE	M_PTRMV_300
;
		IDX16
		REP	#00010000B
;
		INC	ENWRK0,X
		LDY	ENOAML,X
;;;;;;;;		LDA	!ENWRK0,X
;;;;;;;;		EOR	#00020H
;;;;;;;;		STA	!ENWRK0,X
		LDA	ENWRK0,X
		AND	#00002
		ASL	A
		ASL	A
		ASL	A
		ASL	A
		ORA	#02940H		; ԗ pattern next set
		STA	SOAM_DX+(9*8)+4,Y
		STA	SOAM_DX+(10*8)+4,Y
;
		IDX8
		SEP	#00010000B	; index 8bit mode
;
		LDX	<ENINDX
;;;;;;;;		LDA	#00002H
;;;;;;;;		STA	ENTIM1,X
;
M_PTRMV_300	EQU	$
		LDA	!ENDSXL,X
		CMP	#00200H
		BMI	M_PTRMV_400	; enmy clear ?
;					; yes
		JSL	>ENCLEAR	; enmy clear
M_PTRMV_400	EQU	$
		RTL
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		M_ETRIN ( ~jQ[GgbRCjVZbg )	x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
M_ETRIN		EQU	$
		LDA	#00080H+008H
		STA	ENYPSL,X
		LDA	#000A0H
		STA	ENXPSL,X
		LDA	#00008H
		STA	ENTIM0,X		; up,down move timer init set
		LDA	#00002H
		STA	!ENTIM1,X		; ԗ pattern timer init set
		STX	!TRDRBIDX
;
		LDA	#00010H
		STA	!ENXPOW,X		; wl
		LDA	#00300H
		STA	!ENXMAX,X		; w  Xs[h
		RTL
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		M_ETRMV ( ~jQ[GgbR[u )			x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;
M_ETRMV		EQU	$
		LDA	ENTIM0,X
		BNE	M_ETRMV_250
;
		LDA	ENCHPT,X
		INC	A
		AND	#00003H
		STA	ENCHPT,X
		LDA	#00008H
		STA	ENTIM0,X
;
M_ETRMV_250	EQU	$
		LDA	ENTIM1,X
		BNE	M_ETRMV_300
;
		IDX16
		REP	#00010000B
;
		LDY	ENOAML,X
		LDA	!ENWRK0,X
		EOR	#00020H
		STA	!ENWRK0,X
		ORA	#02940H		; ԗ pattern next set
		STA	SOAM_DX+(7*8)+4,Y
		STA	SOAM_DX+(8*8)+4,Y
;
		IDX8
		SEP	#00010000B	; index 8bit mode
;
		LDX	<ENINDX
		LDA	#00002H
		STA	ENTIM1,X
;
M_ETRMV_300	EQU	$
		LDA	!ENDSXL,X
		CMP	#00200H
		BMI	M_ETRMV_400	; enmy clear ?
;					; yes
		JSL	>ENCLEAR	; enmy clear
M_ETRMV_400	EQU	$
		RTL
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		M_EGGIN ( ~jQ[CjVZbg )		x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;;;EGGYPSD		EQU	$
;;;		WORD	00088H,00088H,00088H,00080H,00080H,00078H
;;;;
;;;EGGXPSD		EQU	$
;;;		WORD	000A0H,000B0H,000C0H,000A8H,000B8H,000B0H
;;;;
;;;EGGCLRD		EQU	$
;;;		WORD	00020H,00022H,00024H,00026H,00028H,0002AH
;
EGGCLRD		EQU	$
		WORD	00020H,00022H,00024H,00026H
		WORD	00028H,0002AH,00020H,00020H
;
;
;
M_EGGIN		EQU	$
;;;		STZ	!ENWRK0,X	; egg on flag (0FFFFH:n,0:D_,1:Ԃ)
;;;		LDA	PLTMCT
;;;		ASL	A
;;;		TAY
;;;		LDA	!EGGYPSD,Y
		LDA	#00098H
		STA	ENYPSL,X
		STA	!ENWRK4,X	; recover ypos data
;
;;;		LDA	!EGGXPSD,Y
		LDY	!TRDRBIDX
		LDA	!ENXPSL,Y
		STA	!ENXPSL,X
;;;		LDA	!EGGCLRD,Y
;
		MEM8
		SEP	#00100000B	; memory 8bit mode
;
		LDA	2137H
		LDA	213CH
		ADC	TRENRND
		ADC	<FRCNT
		STA	TRENRND		; _
;
		MEM16
		REP	#00100000B	; memory 16bit mode
;
		AND	#0000EH
		TAY
;
		LDA	EGGCLRD,Y
		STA	ENCLOR,X
;;;		INC	PLTMCT
;;;		LDA	PLTMCT
;;;		CMP	ENTMCT
;;;		BNE	M_EGGIN_050
;;;;
;;;		STZ	PLTMCT
;;;;
;;;M_EGGIN_050	EQU	$
;;;		LDA	#0FFFFH
;;;		STA	!ENWRK2,X	; wRv^[ fds tO (initial 0FFFFH)
;					; (0FFFFH:initial,00000H:get,00001H:drop)
		LDA	#EGSWT
		STA	!ENWRKC,X
		LDA	#00040H
		STA	!ENTIM0,X	; 킫^C}[Zbg
		RTL
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		M_EGGMV ( ~jQ[[u )				x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
M_EGGMV		EQU	$
;;;		LDA	!ENWRKC,X
;;;		CMP	#EGNMV1
;;;		BCS	M_EGGMV_200	; result ok ?
;;;;					; no
;;;		LDA	!ENTIM0,X
;;;		ORA	!ENTIM1,X
;;;		BNE	M_EGGMV_200	; initial demo ?
;;;;					; no
;;;		LDA	!ENMODE,X
;;;		CMP	#EMGNT
;;;		BNE	M_EGGMV_100	; now magnet mode ?
;;;;					; yes
;;;		LDA	!ENWRKA,X
;;;		CMP	#EMOVE
;;;		BNE	M_EGGMV_200	; before normal move ?
;;;;					; yes
;;;		STZ	!ENWRK2,X	; get flag on
;;;		LDA	#EGMGTI
;;;		STA	!ENWRKC,X	; egg magnet initial mode
;;;		BRA	M_EGGMV_200
;;;M_EGGMV_100	EQU	$
;;;		LDA	!ENWRK2,X
;;;		BMI	M_EGGMV_200	; normal mode ?
;;;;					; no
;;;		BNE	M_EGGMV_150	; egg drop initial ?
;;;;					; yes
;;;		LDA	#EGDPI
;;;		STA	!ENWRKC,X	; egg drop initial set
;;;		INC	!ENWRK2,X
;;;		BRA	M_EGGMV_200
;;;M_EGGMV_150	EQU	$
;;;		LDA	#EGDRP
;;;		STA	!ENWRKC,X	; egg drop mode set
;;;M_EGGMV_200	EQU	$
;;;		LDA	!ENMODE,X
;;;		STA	!ENWRKA,X	; before mode set
		LDA	!ENWRKC,X
		ASL	A
		TAX
		JMP	(!EGMVADR,X)
;
;
EGMVADR		EQU	$
;
EGA00		WORD	EGSTWT		; 0 : egg set wait
EGA01		WORD	EGDMMV		; 1 : egg demo move
EGA02		WORD	EGNMMV		; 2 : egg normal move
EGA03		WORD	EGMGNT		; 3 : egg magnet first
EGA04		WORD	EGDPIT		; 4 : egg drop initial
EGA05		WORD	EGDROP		; 5 : egg drop
EGA06		WORD	EGMGNT		; 6 : egg magnet
EGA07		WORD	EGFAIL		; 7 : egg fail (nʂj
EGA08		WORD	EGNMMV		; 8 : egg demo
;
EGSWT		EQU	(EGA00-EGA00)/2
EGDMV		EQU	(EGA01-EGA00)/2
EGNMV		EQU	(EGA02-EGA00)/2
EGMGTI		EQU	(EGA03-EGA00)/2
EGDPI		EQU	(EGA04-EGA00)/2
EGDRP		EQU	(EGA05-EGA00)/2
EGMGT		EQU	(EGA06-EGA00)/2
EGFIL		EQU	(EGA07-EGA00)/2
EGDEM		EQU	(EGA08-EGA00)/2
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		EGSTWT	( ~jQ[ZbgX^oC)			x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
EGSTWT		EQU	$
		LDX	!ENINDX
		LDA	!ENTIM0,X
		BNE	ESWTEND		; wait ?
;					; no
		LDA	#EGDMV
		STA	!ENWRKC,X	; egg demo move mode set
		LDA	#0000DH
		STA	!ENTIM1,X	; move count set
ESWTEND		EQU	$
		JSR	EGBLBL
		JMP	TRMGCLR
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		EGDMMV	( ~jQ[f[u )			x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
EGDMMV		EQU	$
		LDX	!ENINDX
		LDA	!ENYPSL,X
		DEC	A
		STA	!ENYPSL,X
		STA	!ENWRK4,X
		LDA	!ENTIM1,X
		BNE	EDMVEND
;
		LDA	#EGNMV
		STA	!ENWRKC,X	; egg normal move set
EDMVEND		EQU	$
		JSR	EGBLBL
		JMP	TRMGCLR
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		EGNMMV	( ~jQ[m[}[u )			x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
EGNMMV		EQU	$
		LDX	!ENINDX
		LDA	!ENMODE,X
		CMP	#EMGNT
		BNE	ENMV010		; now magnet mode ?
;					; yes
		LDA	#EGMGTI
		STA	!ENWRKC,X	; egg magnet initial mode
;
		LDA	#M_EGG
		JSL	>ENINSR_I	; next egg initial set
;
ENMV010		EQU	$
		JSR	EGBLBL
		RTL
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		EGMGNT	( ~jQ[}Olbg )			x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
CKXADD0		EQU	$
		WORD	0FFF2H,00018H
CKXADD1		EQU	$
		WORD	00005H,0001EH
;
EGMGNT		EQU	$
		LDX	!ENINDX
		LDA	!ENMODE,X
		CMP	#EMOVE
		BNE	EMGT010		; normal move ?
;
		LDA	#EGDPI
		STA	!ENWRKC,X	; egg drop initial set
		RTL
TRWALLCK	EQU	$
EMGT010		EQU	$
		LDA	#00002H
		STA	<EWORK8
EMGT020		EQU	$
		LDX	<EWORK8
		LDY	!TRAKCIDX
		LDA	!ENXPSL,Y
		CLC
		ADC	CKXADD0,X
		STA	<EWORK0
		CLC
		ADC	CKXADD1,X
		STA	<EWORK2
;
		LDA	!ENYPSL,Y
		SEC
		SBC	#00008H
		STA	<EWORK4
		CLC
		ADC	#00020H
		STA	<EWORK6
;
		LDX	!ENINDX
		LDA	!ENXPSL,X
		CMP	<EWORK0
		BMI	EMGT050
;
		CMP	<EWORK2
		BPL	EMGT050
;
		LDA	!ENYPSL,X
		CMP	<EWORK4
		BMI	EMGT050
;
		CMP	<EWORK6
		BPL	EMGT050
;
		LDA	<EWORK8
		BEQ	EMGT030
;
		STZ	!ENXSPD,X
		LDA	<EWORK2
		STA	!ENXPSL,X
		BRA	EMGT040
EMGT030		EQU	$
		LDA	!ENXSPD,X
		LSR	A
		AND	#0FFFFH
		INC	A
		STA	!ENXSPD,X
EMGT040		EQU	$
		LDA	!ENMOD0,X
		ORA	#00040H
		STA	!ENMOD0,X	; eat flag off (magnet off)
		LDA	#00040H
		STA	!ENGPOW,X
		LDA	#00400H
		STA	!ENGMAX,X
		LDA	!ENMOD1,X
		ORA	#00020H
		STA	!ENMOD1,X	; Y speed clear off
		LDA	#EGDRP
		STA	!ENWRKC,X	; egg drop mode set
;NOM;		LDY	#02AH
;NOM;		STY	!SOUND3		; egg hit sound set
		LDY	#02EH		; egg hit sound set
		STY	!SOUND_3
;
		JMP	TRMGCLR
EMGT050		EQU	$
		DEC	<EWORK8
		DEC	<EWORK8
		BMI	EMGTEND
;
		JMP	EMGT020
EMGTEND		EQU	$
		RTL
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		EGDPIT	( ~jQ[CjV )			x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
EGDPIT		EQU	$
		LDX	!ENINDX
		LDA	!ENMOD0,X
		ORA	#00040H
		STA	!ENMOD0,X	; eat flag off (magnet off)
		STZ	!ENXSPD,X
		LDA	#00040H
		STA	!ENGPOW,X
		LDA	#00400H
		STA	!ENGMAX,X
		LDA	!ENMOD1,X
		ORA	#00020H
		STA	!ENMOD1,X	; Y speed clear off
		LDA	#EGDRP
		STA	!ENWRKC,X	; egg drop mode set
		JMP	TRMGCLR
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		EGDROP	( ~jQ[ )				x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
EGXPSAD		EQU	$
		WORD	00000H,00010H,00020H,00008H,00018H,00010H
;
EGYPSAD		EQU	$
		WORD	00000H,00000H,00000H,0FFF8H,0FFF8H,0FFF0H
;
;
EGDROP		EQU	$
		LDX	!ENINDX
		LDA	!ENMODE,X
		CMP	#EMGNT
		BNE	TREDP010	; now magnet mode ?
;					; yes
		LDA	#EGMGT
		STA	!ENWRKC,X	; egg magnet mode
		STZ	!ENGPOW,X
		STZ	!ENGMAX,X
		LDA	!ENMOD1,X
		AND	#00020H
		STA	!ENMOD1,X	; Y speed clear on
;
		RTL
;
TREDP010	EQU	$
		JSL	>TRWALLCK
		LDY	!TRAKCIDX
		LDA	!ENXPSL,Y
		SEC
		SBC	#00008H
		STA	<EWORK0
		CLC
		ADC	#00020H
		STA	<EWORK2
;
		LDA	!ENYPSL,Y
		SEC
		SBC	#0006H
		STA	<EWORK4
		CLC
		ADC	#0001AH
		STA	<EWORK6
;
		LDA	!ENXPSL,X
		CMP	<EWORK0
		BMI	TREDP100
;
		CMP	<EWORK2
		BPL	TREDP100
;
		LDA	!ENYPSL,X
		CMP	<EWORK4
		BMI	TREDP100
;
		CMP	<EWORK6
		BPL	TREDP100
;
;;;		LDA	#00001H
;;;		STA	!ENWRK0,X	; egg on flag (1:Ԃ)
;;;		DEC	!TRDRBCNT	; D_  JEg|P
		INC	!TRAKCCNT	; Ԃ  JEg{P
;NOM;		LDY	#029H
;NOM;		STY	!SOUND3		; count up sound set
		LDY	#009H		; count up sound set
		STY	!SOUND_3
		LDA	!ENMOD1,X
		AND	#00020H
		STA	!ENMOD1,X	; Y speed clear on
;
		LDA	!ENMODE,X
		CMP	#EMGNT
		BNE	TREDP050	; magnet mode ?
;					; yes
		JSL	>EMGNT_CANCEL	; mode recover
		PLA
		PLY			; return address clear
TREDP050	EQU	$
		JMP	>ENCLEAR	; enmy clear
;
;;;		LDY	!TRAKCIDX
;;;		LDA	!ENXPSL,Y
;;;		STA	<EWORKC
;;;		LDA	!ENYPSL,Y
;;;		STA	<EWORKE
;;;		LDA	!TRAKCCNT
;;;		DEC	A
;;;		ASL	A
;;;		TAY
;;;		LDA	<EWORKC
;;;		CLC
;;;		ADC	EGXPSAD,Y
;;;		STA	!ENXPSL,X
;;;;
;;;		LDA	<EWORKE
;;;		CLC
;;;		ADC	EGYPSAD,Y
;;;		STA	!ENYPSL,X
;;;		STA	!ENWRK4,X
;;;		BRA	TRMGCLR
;
;
TREDP100	EQU	$
		LDA	!ENYPSL,X
		CMP	#000A0H
		BCC	TREDPEND	; on n H
;					; yes
		LDA	#EGFIL
		STA	!ENWRKC,X
;;;		LDA	#0FFFFH
;;;		STA	!ENWRK0,X	; egg on flag (0FFFFH1:n)
;;;		DEC	!TRDRBCNT	; D_  JEg|P
;
		BRA	TRMGCLR
;
TREDPEND	EQU	$
		RTL
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		EGFAIL	~jQ[( nʂ[u )			x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
EGFAIL		EQU	$
		LDX	!ENINDX
		LDA	!ENYPSL,X
		CMP	#000A0H
		BCC	EGFL_500	; on n H
;					; yes
		BRA	EGFL_030
		LDA	!FRCNT
		AND	#00001H
		BEQ	EGFL_050
;
EGFL_030	EQU	$
;NOM;		LDY	#006H
;NOM;		STY	!SOUND3		; baund sound set
		LDY	#001CH
		STY	!SOUND_3	; baund sound set
EGFL_050	EQU	$
		LDA	!ENYSPD,X
		LSR	A
		EOR	#0FFFFH
		INC	A
		STA	!ENYSPD,X
;
		CMP	#0FEE0H
		BCC	EGFL_100
;
		STZ	!ENGPOW,X
		STZ	!ENGMAX,X
		STZ	!ENYSPD,X
		LDA	!ENMOD1,X
		AND	#00020H
		STA	!ENMOD1,X	; Y speed clear on
EGFL_100	EQU	$
		LDA	!ENXPSL,X
		SEC
		SBC	!SCCH1
		BPL	EGFL_500	; egg display out ?
;					; yes
		JSL	>ENCLEAR	; enmy clear
EGFL_500	EQU	$
TRMGCLR		EQU	$		; *** vC[ }Olbg tO NA ***
		LDA	!ENMODE,X
		CMP	#EMGNT
		BNE	TRENM_100	; magnet mode ?
;					; yes
		JSL	>EMGNT_CANCEL	; mode recover
		PLA
		PLY			; return address clear
TRENM_100	EQU	$
		RTL
;
;
;%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
;%		EGBLBL	( uu[u Tu)		%
;%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
EGBLBL		EQU	$
		LDA	!ENWRK4,X
		STA	!ENYPSL,X	; ypos recover
;
		LDY	!TRDRBIDX
;;;		LDA	!ENWRK0,X
;;;		BEQ	EGBL_400
;;;;
;;;		LDY	!TRAKCIDX
;;;EGBL_400	EQU	$
		LDA	!ENCONT,Y
		AND	#00001H
		BEQ	EGBL_500	; possition down flame ?
;					; yes
		LDA	!ENWRK4,X
		DEC	A
		STA	!ENYPSL,X	; possition -1
EGBL_500	EQU	$
;
		LDA	!ENXPSL,X
		CLC
		ADC	!ENMOVX,Y
		STA	!ENXPSL,X	; possition gbRʒu␳
;
		LDA	!ENDSXL,X
		SEC
		SBC	<SCCH1
		CMP	#00200H
		BMI	EGBL_600	; enmy clear ?
;					; yes
		JSL	>ENCLEAR	; enmy clear
EGBL_600	EQU	$
		RTS
;
;
;
;%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
;%	    speed set sub					%
;%			EWORK0 <- random pointer		%
;%			EWORK2 <- gbR 			%
;%			X <- OAMSET RAM index			%
;%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
;
XKYRIDT		EQU	$
		WORD	000A0H,00080H,00060H,00090H
		WORD	00070H,00050H,000B0H,000C0H
XADSPDT		EQU	$
		WORD	00140H,00200H,000C0H,001C0H
		WORD	00040H,00080H,00100H,00180H
		WORD	0FF60H,0FE00H,0FFA0H,0FF20H
		WORD	0FFE0H,0FFC0H,0FF80H,0FF40H
;
TRSPDSET	EQU	$
		LDY	<EWORK0
		LDA	XKYRIDT,Y
		STA	!ENWRK2,X
		CMP	<EWORK2
		BCC	TRSST_100
;
		TYA
		ORA	#00010H
		TAY
TRSST_100	EQU	$
		LDA	#00300H
		CLC
		ADC	XADSPDT,Y
		STA	!ENXMAX,X
;
		RTS
;
;
;
		END
;
;
;
;
