;************************************************************************
;*									*
;*	title name	: "yossy"					*
;*	proccess	: demo main					*
;*	file name	: ys_demo					*
;*									*
;************************************************************************
;
;
		SALL
;
		include		ys_header.inc
		include		ys_unit.h
		include		ys_presno.h
		include		ys_color.h
;
		XALL
;
;
;------------------------------------------------------------------------
;-		global symbol						-
;------------------------------------------------------------------------
		GLB	DEMO_00_IN,DEMO_00_MV
		GLB	DEMO_01_IN,DEMO_01_MV
		GLB	DM_01_SCRCLR
		GLB	DM_INSR,DM_INSR_X
;
		GLB	DM_MWAND,DM_FUKUR,DM_BABYM,DM_YOSH2,DM_HEIHO
		GLB	DM_HEIH2,DM_FUKR2
;
;------------------------------------------------------------------------
;-		extern symbol						-
;------------------------------------------------------------------------
;
;-------------< ys_main >------------------------------------------------
		EXT	VRAMCL,VRAMCL2,URAMCLR,OAMDXCLR,RAMCLR
		EXT	SOUND_TR
		EXT	MPIN,HF_STAT,GM_OVR,AGAIN
;
;-------------< ys_rpro >------------------------------------------------
		EXT	CHIPON,CHIPON_RAM_READ
		EXT	DMCL
;
;-------------< ys_init >------------------------------------------------
		EXT	CHRSET,GMMDST,COLSET,VRAMDX_ST,UNCOMPRES_X,UNCOMPRES
		EXT	DIVDTST,M_DMA_BFST
		EXT	DM_00_CHR,DM_01_CHR
		EXT	DM_00_COL,DM_01_COL
		EXT	GM00,DM01
;
;-------------< ys_title >-----------------------------------------------
		EXT	MODINC,MODINC2
;
;-------------< ys_enmy >------------------------------------------------
		EXT	ENCSET_DM,ENRAMCLR,ENCLEAR
;
;-------------< ys_demo_1 >----------------------------------------------
		EXT	DM_YOSHIIN,DM_MWANDIN,DM_FUKURIN,DM_BABYMIN,DM_YOSH2IN
		EXT	DM_KAMECIN,DM_HEIHOIN,DM_YOSH3IN,DM_HEIH2IN,DM_FUKR2IN
;
		EXT	DM_YOSHIMV,DM_MWANDMV,DM_FUKURMV,DM_BABYMMV,DM_YOSH2MV
		EXT	DM_KAMECMV,DM_HEIHOMV,DM_YOSH3MV,DM_HEIH2MV,DM_FUKR2MV
;
;-------------< ys_game >------------------------------------------------
		EXT	MSG_BTMP_CLR
;
;-------------< ys_data >------------------------------------------------
		EXT	COS
;
;------------------------------------------------------------------------
;-		define symbol						-
;------------------------------------------------------------------------
;
;
;************************************************************************
;*									*
;*		program start						*
;*									*
;************************************************************************
;
;
		EXTEND
;
		MEM8
		IDX8
;
;
Group_B		GROUP	Demo_pro
Demo_pro	SECT	REL
;
;
;************************************************************************
;*		fnaiZbg[`e[u			*		  *
;************************************************************************
DM_INIT_ADR	EQU	$-(DMSTART*2)
DM_DETH0_N	WORD	DM_DETH0IN	;[DM_DETH0]
DM_DETH1_N	WORD	DM_DETH1IN	;[DM_DETH1]
DM_BEBY0_N	WORD	DM_BEBY0IN	;[DM_BEBY0]
;
DM_BIRD0_N	WORD	DM_BIRD0IN	;[DM_BIRD0]
DM_KUMO0_N	WORD	DM_KUMO0IN	;[DM_KUMO0]
DM_KUMO1_N	WORD	DM_KUMO1IN	;[DM_KUMO1]
DM_KUMO2_N	WORD	DM_KUMO2IN	;[DM_KUMO2]
DM_KAMK0_N	WORD	DM_KAMK0IN	;[DM_KAMK0]
DM_KAMK1_N	WORD	DM_KAMK1IN	;[DM_KAMK1]
DM_KOZU0_N	WORD	DM_KOZU0IN	;[DM_KOZU0]
DM_KOZU1_N	WORD	DM_KOZU1IN	;[DM_KOZU1]
DM_TSUE0_N	WORD	DM_TSUE0IN	;[DM_TSUE0]
DM_YOSHI_N	WORD	DM_YOSHIIN	;[DM_YOSHI]
DM_MWAND_N	WORD	DM_MWANDIN	;[DM_MWAND]
DM_FUKUR_N	WORD	DM_FUKURIN	;[DM_FUKUR]
DM_BABYM_N	WORD	DM_BABYMIN	;[DM_BABYM]
DM_YOSH2_N	WORD	DM_YOSH2IN	;[DM_YOSH2]
DM_KAMEC_N	WORD	DM_KAMECIN	;[DM_KAMEC]
DM_HEIHO_N	WORD	DM_HEIHOIN	;[DM_HEIHO]
DM_FUKR2_N	WORD	DM_FUKR2IN	;[DM_FUKR2]
DM_YOSH3_N	WORD	DM_YOSH3IN	;[DM_YOSH3]
DM_HEIH2_N	WORD	DM_HEIH2IN	;[DM_HEIH2]
;
;************************************************************************
;*		fnaiOx					*
;************************************************************************
DM_DETH0	EQU	(DM_DETH0_N-DM_INIT_ADR)/2
DM_DETH1	EQU	(DM_DETH1_N-DM_INIT_ADR)/2
DM_BEBY0	EQU	(DM_BEBY0_N-DM_INIT_ADR)/2
;
DM_BIRD0	EQU	(DM_BIRD0_N-DM_INIT_ADR)/2
DM_KUMO0	EQU	(DM_KUMO0_N-DM_INIT_ADR)/2
DM_KUMO1	EQU	(DM_KUMO1_N-DM_INIT_ADR)/2
DM_KUMO2	EQU	(DM_KUMO2_N-DM_INIT_ADR)/2
DM_KAMK0	EQU	(DM_KAMK0_N-DM_INIT_ADR)/2
DM_KAMK1	EQU	(DM_KAMK1_N-DM_INIT_ADR)/2
DM_KOZU0	EQU	(DM_KOZU0_N-DM_INIT_ADR)/2
DM_KOZU1	EQU	(DM_KOZU1_N-DM_INIT_ADR)/2
DM_TSUE0	EQU	(DM_TSUE0_N-DM_INIT_ADR)/2
DM_YOSHI	EQU	(DM_YOSHI_N-DM_INIT_ADR)/2
DM_MWAND	EQU	(DM_MWAND_N-DM_INIT_ADR)/2
DM_FUKUR	EQU	(DM_FUKUR_N-DM_INIT_ADR)/2
DM_BABYM	EQU	(DM_BABYM_N-DM_INIT_ADR)/2
DM_YOSH2	EQU	(DM_YOSH2_N-DM_INIT_ADR)/2
DM_KAMEC	EQU	(DM_KAMEC_N-DM_INIT_ADR)/2
DM_HEIHO	EQU	(DM_HEIHO_N-DM_INIT_ADR)/2
DM_FUKR2	EQU	(DM_FUKR2_N-DM_INIT_ADR)/2
DM_YOSH3	EQU	(DM_YOSH3_N-DM_INIT_ADR)/2
DM_HEIH2	EQU	(DM_HEIH2_N-DM_INIT_ADR)/2
;
;************************************************************************
;*		fnai[`e[u				*
;************************************************************************
DM_MOVE_ADR	EQU	$-(DMSTART*2)
		WORD	DM_DETH0MV	;[DM_DETH0]
		WORD	DM_DETH1MV	;[DM_DETH1]
		WORD	DM_BEBY0MV	;[DM_BEBY0]
;
		WORD	DM_BIRD0MV	;[DM_BIRD0]
		WORD	DM_KUMO0MV	;[DM_KUMO0]
		WORD	DM_KUMO1MV	;[DM_KUMO1]
		WORD	DM_KUMO2MV	;[DM_KUMO2]
		WORD	DM_KAMK0MV	;[DM_KAMK0]
		WORD	DM_KAMK1MV	;[DM_KAMK1]
		WORD	DM_KOZU0MV	;[DM_KOZU0]
		WORD	DM_KOZU1MV	;[DM_KOZU1]
		WORD	DM_TSUE0MV	;[DM_TSUE0]
		WORD	DM_YOSHIMV	;[DM_YOSHI]
		WORD	DM_MWANDMV	;[DM_MWAND]
		WORD	DM_FUKURMV	;[DM_FUKUR]
		WORD	DM_BABYMMV	;[DM_BABYM]
		WORD	DM_YOSH2MV	;[DM_YOSH2]
		WORD	DM_KAMECMV	;[DM_KAMEC]
		WORD	DM_HEIHOMV	;[DM_HEIHO]
		WORD	DM_FUKR2MV	;[DM_FUKR2]
		WORD	DM_YOSH3MV	;[DM_YOSH3]
		WORD	DM_HEIH2MV	;[DM_HEIH2]
;
;************************************************************************
;*		Xe[^Xf[^					*
;************************************************************************
DM_MODE2	EQU	$-(DMSTART*2)
;			    [ENMOD2]
		WORD	0101100000000001B	;[DM_DETH0]
		WORD	0101100000000001B	;[DM_DETH1]
		WORD	0100100000000001B	;[DM_BEBY0]
;
		WORD	0110000000000001B	;[DM_BIRD0]
		WORD	0011000000000001B	;[DM_KUMO0]
		WORD	0001000000000001B	;[DM_KUMO1]
		WORD	0000100000000000B	;[DM_KUMO2]
		WORD	1000000000000001B	;[DM_KAMK0]
		WORD	0100000000000001B	;[DM_KAMK1]
		WORD	0000100000000100B	;[DM_KOZU0]
		WORD	1000000000000001B	;[DM_KOZU1]
		WORD	0010000000000101B	;[DM_TSUE0]
		WORD	0100000000000001B	;[DM_YOSHI]
		WORD	0000100000000000B	;[DM_MWAND]
		WORD	0010000000000001B	;[DM_FUKUR]
		WORD	0010000000000001B	;[DM_BABYM]
		WORD	0010000000000101B	;[DM_YOSH2]
		WORD	0101000000000001B	;[DM_KAMEC]
		WORD	0010000000000101B	;[DM_HEIHO]
		WORD	0010000000000101B	;[DM_FUKR2]
		WORD	0110000000000101B	;[DM_YOSH3]
		WORD	0010000000000001B	;[DM_HEIH2]
;
DM_DATA0	EQU	$-(DMSTART*2)
;			[ENYUSN]  [ENCLOR]
		BYTE	     000H,00100000B	;[DM_DETH0]
		BYTE	     001H,00100000B	;[DM_DETH1]
		BYTE	     001H,00100000B	;[DM_BEBY0]
;
		BYTE	     005H,00010000B	;[DM_BIRD0]
		BYTE	     004H,00010000B	;[DM_KUMO0]
		BYTE	     006H,00010000B	;[DM_KUMO1]
		BYTE	     007H,00010000B	;[DM_KUMO2]
		BYTE	     0FFH,00010010B	;[DM_KAMK0]
		BYTE	     005H,00010000B	;[DM_KAMK1]
		BYTE	     005H,00010000B	;[DM_KOZU0]
		BYTE	     0FFH,00010100B	;[DM_KOZU1]
		BYTE	     005H,00010000B	;[DM_TSUE0]
		BYTE	     007H,00100000B	;[DM_YOSHI]
		BYTE	     006H,00100010B	;[DM_MWAND]
		BYTE	     006H,00100100B	;[DM_FUKUR]
		BYTE	     0FFH,00101010B	;[DM_BABYM]
		BYTE	     004H,00100000B	;[DM_YOSH2]
		BYTE	     004H,00010000B	;[DM_KAMEC]
		BYTE	     004H,00011110B	;[DM_HEIHO]
		BYTE	     003H,00010000B	;[DM_FUKR2]
		BYTE	     004H,00010000B	;[DM_YOSH3]
		BYTE	     004H,00011110B	;[DM_HEIH2]
;
;
;
;
;
;************************************************************************
;*									*
;*		_fZbg					*
;*									*
;************************************************************************
;
DEMO_00_IN	EQU	$
		JSL	>VRAMCL		;VRAM clear
		JSL	>URAMCLR	;use RAM clear
		JSL	>ENRAMCLR	;enemy RAM clear
;
;------------------------------------------------------------------------
;		LN^[Zbg					-
;------------------------------------------------------------------------
;
		I16
;
		LDY	#DM_00_CHR	;LN^[Zbg
		JSL	>CHRSET
;
		IDX8
;
;------------------------------------------------------------------------
;		J[Zbg						-
;------------------------------------------------------------------------
;
		MI16
;
		LDA	#00		;kLJ[Zbg
		STA	>DATACOL
		LDX	#DM_00_COL	;(X) <-- J[zuf[^|C^[
		JSL	>COLSET
;
		MEM8
		IDX8
;
;------------------------------------------------------------------------
;		ootWX^Zbg					-
;------------------------------------------------------------------------
		LDX	#GM00		;(X) <-- game mode
		JSL	>GMMDST		;game mode set
		LDA	#00010000B	;OBJ only set
		STA	MANSEL
		STA	212CH
;
;------------------------------------------------------------------------
;		R[XC^Cgfrbg}bvNA[		-
;------------------------------------------------------------------------
		JSL	>MSG_BTMP_CLR
;
;------------------------------------------------------------------------
;		fnaiZbg					-
;------------------------------------------------------------------------
;
		M16
;
		LDA	#DM_DETH0
		JSR	DM_INSR
		LDA	#0070H
		STA	ENXPSL,Y	; w|WV@CjVZbgII
		LDA	#0080H
		STA	ENYPSL,Y	; x|WV@CjVZbgII
		LDA	#0020H
		STA	ENTIM0,Y	; CjV^CZbgII
		LDA	#00008H
		STA	ENTIM1,Y	; Lp^[^CZbgII
;
		LDA	#DM_DETH1
		JSR	DM_INSR
		LDA	#DMOVE
		STA	ENMODE,Y
		LDA	#0062H
		STA	ENXPSL,Y
		LDA	#0071H
		STA	ENYPSL,Y
		LDA	#00002H
		STA	ENTIM1,Y
;
		LDA	#DM_DETH1
		JSR	DM_INSR
		LDA	#DMOVE
		STA	ENMODE,Y
		LDA	#0098H
		STA	ENXPSL,Y
		LDA	#006FH
		STA	ENYPSL,Y
		LDA	#0002H
		STA	ENMUKI,Y
		LDA	#00004H
		STA	ENTIM1,Y
;
		LDA	#DM_DETH1
		JSR	DM_INSR
		LDA	#DMOVE
		STA	ENMODE,Y
		LDA	#008AH
		STA	ENXPSL,Y
		LDA	#007EH
		STA	ENYPSL,Y
		LDA	#0002H
		STA	ENMUKI,Y
		LDA	#00006H
		STA	ENTIM1,Y
;
		LDA	#DM_BEBY0
		JSR	DM_INSR
		LDA	#DMOVE
		STA	ENMODE,Y
		LDA	#0080H
		STA	ENXPSL,Y
		LDA	#0060H
		STA	ENYPSL,Y
		LDA	#00006
		STA	ENTIM1,Y
;
		M8
;
		JSL	>DEMO_00_MV_IN
;
		LDA	#0F0H		;[] aflXgbv
		STA	<SOUND_0
;
		JMP	>MODINC2
;
;************************************************************************
;*									*
;*		_f						*
;*									*
;************************************************************************
;
DEMO_00_MV_IN	EQU	$
		PHB			;(DBR) save
		PHK			;(DBR) <-- (PBR)
		PLB
;
DEMO_00_MV	EQU	$
		JSL	>OAMDXCLR	;OAM clear
;
		JSL	>ENCSET_DM	;fnai n`lZbg
		JSL	>DEMO_OBJ	;     h   
;
		M16
;
		M_CHIP	DX_OAM		;OAM convert
;
		LDA	GMFADE_CT
		BEQ	DEMO_00_MV_020	;bZ[W\H ( no:DEMO_00_MV_020 )
;
;-------------- }bv ------------------------------------------------
		LDA	!PLCONT		; "f`ld@nudq" ?
		BNE	DEMO_00_MV_010	;	NO -> DEMO_00_MV_010
		STZ	!GMFADE_CT
		LDX	#GM_OVR
		BRA	DEMO_00_MV_015
;
DEMO_00_MV_010	EQU	$
		LDX	#AGAIN
		LDA	!MID_POINT	; ԃ|Cg ăX^[g H
		BEQ	DEMO_00_MV_015	;	NO -> DEMO_00_MV_015
		LDX	#HF_STAT
DEMO_00_MV_015	EQU	$
		STX	!MODENO
;
DEMO_00_MV_020	EQU	$
;
		M8
;
		PLB
		RTL
;
;************************************************************************
;*									*
;*		~[WJZbg					*
;*									*
;************************************************************************
;
;------------------------------------------------------------------------
;-		afPCQXN[NA[f[^			-
;------------------------------------------------------------------------
DM_01_SCRCLR	EQU	$
		WORD	6400H,4000H+(0800H-1)
		WORD	03FFH
		WORD	6C00H,4000H+(0800H-1)
		WORD	03FFH
		WORD	7C00H,4000H+(0800H-1)
		WORD	0130H
;
		WORD	3FF0H,4000H+(20H-1)	;ʂLZbg
		WORD	0000H			;
		WORD	0FFFFH
;
;
;
;------------------------------------------------------------------------
;-		g|cl`f[^					-
;------------------------------------------------------------------------
;
;-------------- af[h ----------------------------------------------
DM_01_HDMA_0	EQU	$
		BYTE	00000000B	;DMA control parameter
		BYTE	05H		;    B bus address
		BYTE	LOW  HDMAPR0	;    A	    "     (L)
		BYTE	HIGH HDMAPR0	;	    "     (H)
		BYTE	BANK HDMAPR0	;	    "     (B)
;
DM_01_HDMA_0_PR EQU	$
		BYTE	46H		;line no.
		BYTE	09H
		BYTE	46H		;line no.
		BYTE	09H
		BYTE	01H		;line no.
		WORD	00H
		HEX	00		;end code
;
;-------------- CTu ----------------------------------------
DM_01_HDMA_1	EQU	$
		BYTE	00000001B	;DMA control parameter
		BYTE	2CH		;    B bus address
		BYTE	LOW  HDMAPR1	;    A	    "     (L)
		BYTE	HIGH HDMAPR1	;	    "     (H)
		BYTE	BANK HDMAPR1	;	    "     (B)
;
DM_01_HDMA_1_PR EQU	$
		BYTE	46H		;line no.
		BYTE	00010101B,00000010B
		BYTE	46H		;line no.
		BYTE	00010101B,00000010B
		BYTE	01H
		BYTE	00001000B,00000000B
		HEX	00		;end code
;
;-------------- EBhE ----------------------------------------------
DM_01_HDMA_2	EQU	$
		BYTE	01000100B	;DMA control parameter
		BYTE	26H		;    B bus address
		BYTE	LOW  HDMAPR2	;    A	    "     (L)
		BYTE	HIGH HDMAPR2	;	    "     (H)
		BYTE	BANK HDMAPR2	;	    "     (B)
;
DM_01_HDMA_2_PR EQU	$
		BYTE	12H		;line no.
		WORD	HDMABUF2
		BYTE	70H+80H		;line no.
		WORD	HDMABUF2+8
		BYTE	10H		;line no.
		WORD	HDMABUF2
		BYTE	28H		;line no.
		WORD	HDMABUF2+4
		BYTE	01H		;line no.
		WORD	HDMABUF2
		HEX	00		;end code
;
;-------------- afQX^[XN[iʂj ----------------
DM_01_HDMA_3	EQU	$
		BYTE	01000010B	;DMA control parameter
		BYTE	0FH		;    B bus address
		BYTE	LOW  HDMAPR3	;    A	    "     (L)
		BYTE	HIGH HDMAPR3	;	    "     (H)
		BYTE	BANK HDMAPR3	;	    "     (B)
;
DM_01_HDMA_3_PR EQU	$
		BYTE	24H		;line no.
		WORD	HDMABUF
		BYTE	3DH		;line no.
		WORD	HDMABUF
		BYTE	18H+80H		;line no.
		WORD	HDMABUF+2
		BYTE	01H		;line no.
		WORD	HDMABUF
		HEX	00		;end code
;
;-------------- afQX^[XN[i攪wij ------------------
DM_01_HDMA_4	EQU	$
		BYTE	01000010B	;DMA control parameter
		BYTE	0FH		;    B bus address
		BYTE	LOW  HDMAPR4	;    A	    "     (L)
		BYTE	HIGH HDMAPR4	;	    "     (H)
		BYTE	BANK HDMAPR4	;	    "     (B)
;
DM_01_HDMA_4_PR EQU	$
		BYTE	29H		;line no.
		WORD	HDMABUF
		BYTE	40H		;line no.
		WORD	HDMABUF+2
		BYTE	01H		;line no.
		WORD	SCCH2
		HEX	00		;end code
;
;------------------------------------------------------------------------
;-		hhS  naif[^			-
;------------------------------------------------------------------------
BIRD0_IX	EQU	(ENNO-1)*4	;REmg̃CfbNX
;
DM_01_OBJ_00	EQU	$
;			enemy no.  X	 Y
		WORD	DM_BIRD0,0088H,0058H	;[00]
		WORD	0000H	;end code
;
;------------------------------------------------------------------------
;-		ꖋnaif[^					-
;------------------------------------------------------------------------
DM_01_OBJ_01	EQU	$
;			enemy no.  X	 Y
		WORD	DM_KUMO0,0010H,0050H	;[01]
		WORD	DM_KUMO0,00B0H,0078H	;[02]
		WORD	DM_KUMO0,0050H,0068H	;[03]
		WORD	DM_KUMO0,00E0H,0080H	;[04]
		WORD	DM_KUMO1,0010H,0058H	;[05]
		WORD	DM_KUMO1,0010H,00A8H	;[06]
		WORD	DM_KUMO1,0050H,0078H	;[07]
		WORD	DM_KUMO1,0060H,0048H	;[08]
		WORD	DM_KUMO1,0088H,0068H	;[09]
		WORD	DM_KUMO1,00A8H,0050H	;[0A]
		WORD	DM_KUMO1,00D8H,0030H	;[0B]
		WORD	DM_KUMO1,00E0H,006CH	;[0C]
		WORD	DM_KUMO2,0010H,0068H	;[0D]
		WORD	DM_KUMO2,0018H,0040H	;[0E]
		WORD	DM_KUMO2,0040H,0068H	;[0F]
		WORD	DM_KUMO2,0050H,007CH	;[10]
		WORD	DM_KUMO2,0058H,0038H	;[11]
		WORD	DM_KUMO2,0080H,0076H	;[12]
		WORD	DM_KUMO2,00A8H,0078H	;[13]
		WORD	DM_KUMO2,00D0H,0070H	;[14]
;
		WORD	0000H	;end code
;
;------------------------------------------------------------------------
;-		񖋂naif[^					-
;------------------------------------------------------------------------
DM_01_OBJ_02	EQU	$
;			enemy no.  X	 Y
		WORD	DM_KAMK0,00B8H,0040H	;[01]
		WORD	0000H	;end code
;
;------------------------------------------------------------------------
;-		Onaif[^					-
;------------------------------------------------------------------------
DM_01_OBJ_03	EQU	$
;			enemy no.  X	 Y
		WORD	DM_KAMK1,0600H,0038H	;[01]
		WORD	0000H	;end code
;
;------------------------------------------------------------------------
;-		lnaif[^					-
;------------------------------------------------------------------------
DM_01_OBJ_04	EQU	$
;			enemy no.  X	 Y
		WORD	DM_KOZU1,0078H,0050H	;[01]
		WORD	0000H	;end code
;
;------------------------------------------------------------------------
;-		ܖnaif[^					-
;------------------------------------------------------------------------
DM_01_OBJ_05	EQU	$
;			enemy no.  X	 Y
		WORD	DM_YOSHI,0140H,0070H	;[01]
		WORD	0000H	;end code
;
;------------------------------------------------------------------------
;-		Znaif[^					-
;------------------------------------------------------------------------
DM_01_OBJ_06	EQU	$
;			enemy no.  X	 Y
		WORD	0000H	;end code
;
;------------------------------------------------------------------------
;-		掵naif[^					-
;------------------------------------------------------------------------
DM_01_OBJ_07	EQU	$
;			enemy no.  X	 Y
		WORD	DM_KAMEC,0050H,0082H	;[01]
		WORD	0000H	;end code
;
;------------------------------------------------------------------------
;-		攪naif[^					-
;------------------------------------------------------------------------
DM_01_OBJ_08	EQU	$
;			enemy no.  X	 Y
		WORD	DM_YOSH3,0080H,0070H	 ;[01]
		WORD	0000H	;end code
;
;
DEMO_01_IN	EQU	$
;------------------------------------------------------------------------
;-		Sq`lNA[					-
;------------------------------------------------------------------------
		JSL	>RAMCLR
;
;
		LDA	#DMCL
		JSL	>VRAMCL2	;VRAM clear
		JSL	>URAMCLR	;use RAM clear
		JSL	>ENRAMCLR	;enemy RAM clear
;
;------------------------------------------------------------------------
;-		LN^[Zbg					-
;------------------------------------------------------------------------
;
		I16
;
		LDY	#DM_01_CHR	;(Y) <-- LN^[zuf[^|C^[
		JSL	>CHRSET
;
		IDX8
;
;------------------------------------------------------------------------
;-		J[Zbg						-
;------------------------------------------------------------------------
;
		MI16
;
		LDX	#DM_01_COL	;(X) <-- J[zuf[^|C^[
		JSL	>COLSET
;
		MEM8
		IDX8
;
;------------------------------------------------------------------------
;-		ootWX^Zbg					-
;------------------------------------------------------------------------
		LDX	#DM01		;(X) <-- game mode
		JSL	>GMMDST		;game mode set
		LDA	#07CH		;BG4 screen base address set ( 7C00H- )
		STA	210AH
;
;
		LDA	!TITL_SND
		BNE	DEMO_SND_PASS
		LDA	#002		;[]
		STA	SOUND_0
;
DEMO_SND_PASS	EQU	$
;
;------------------------------------------------------------------------
;-		g|cl`Zbg					-
;------------------------------------------------------------------------
		LDX	#04
DEMO_01_IN_010	EQU	$
		LDA	!DM_01_HDMA_0,X
		STA	4370H,X
		LDA	!DM_01_HDMA_1,X
		STA	4360H,X
		LDA	!DM_01_HDMA_2,X
		STA	4350H,X
		LDA	!DM_01_HDMA_3,X
		STA	4340H,X
		LDA	!DM_01_HDMA_4,X
		STA	4330H,X
		DEX
		BPL	DEMO_01_IN_010
		LDA	#BANK HDMABUF
		STA	4377H
		STA	4367H
		STA	4357H
		STA	4347H
		STA	4337H
;
		LDX	#20		;
DEMO_01_IN_020	EQU	$
		LDA	!DM_01_HDMA_0_PR,X
		STA	>HDMAPR0,X
		LDA	!DM_01_HDMA_1_PR,X
		STA	>HDMAPR1,X
		LDA	!DM_01_HDMA_2_PR,X
		STA	>HDMAPR2,X
		LDA	!DM_01_HDMA_3_PR,X
		STA	>HDMAPR3,X
		LDA	!DM_01_HDMA_4_PR,X
		STA	>HDMAPR4,X
		DEX
		BPL	DEMO_01_IN_020
;
		M16
;
		LDA	>HDMAPR1+1	;CTuʐݒf[^Zbg
		STA	DM_HDMA_PR
;
		LDA	#00FFH		;EBhEobt@Zbg
		STA	>HDMABUF2
		STA	>HDMABUF2+2
		LDA	#0FF00H
		STA	>HDMABUF2+4
		STA	>HDMABUF2+6
;
		M8
;
		LDA	#11100000B	;g|cl`hnmh
		STA	HD420C
;
;------------------------------------------------------------------------
;-		q`lZbg					-
;------------------------------------------------------------------------
		JSL	>DIVDTST	;div data set
;
;------------------------------------------------------------------------
;		fnaiZbg					-
;------------------------------------------------------------------------
;
		MI16
;
		LDX	#DM_01_OBJ_00
		JSR	DEMO_OBJ_READ
;
		MEM8
		IDX8
;
		JSL	>DEMO_01_MV_IN
;
;-------------- NMI-IRQ "ON" ------------------------------------
		LDA	#02H		;IRQ counter set
		STA	IRQFLG
		LDA	#050H		;H counter set
		STA	4207H
		LDA	#0C6H		;V counter set
		STA	4209H
		LDA	#10110001B	;timer IRQ "ON"
		STA	4200H
;
;-------------- I[vjO f [v ^C}[ Zbg --------
		M16			; memory 16bit mode
		LDA	#02800H
		STA	!OPDMLPTM
		M8			; memory 8bit mode
;
		JMP	>MODINC
;
;************************************************************************
;*									*
;*		~[WJ						*
;*									*
;************************************************************************
;
DEMO_01_MV_IN	EQU	$
		PHB			;(DBR) save
		PHK			;(DBR) <-- (PBR)
		PLB
;
		JSR	OPMSGINITSET
		BRA	DEMO_01_MV_010
;
DEMO_01_MV	EQU	$
		M16			; memory 16bit mode
		DEC	!OPDMLPTM
		M8			; memory 8bit mode
;
		LDA	!OPDMLPTM	;I[vjO f
		ORA	!OPDMLPTM+1	;	[v ^C}[  O ?
		BEQ	DEMO_01_MV_NXT	;	YES -> DEMO_01_MV_NXT
;
DM_01_MV_050	EQU	$
		LDA	<KEYC1L
		AND	#11000000B
		ORA	<KEYC1
		AND	#11010000B
		BEQ	DEMO_01_MV_010	;f~H ( no:DEMO_01_MV_010 )
;
DEMO_01_MV_NXT	EQU	$
		INC	MODENO		;}bvf
		LDA	!TITL_SND
		BNE	DEMO_01_MV_030
		LDA	#0F1H
		STA	SOUND_0
		STA	!TITL_SND
		BRA	DEMO_01_MV_030
;
DEMO_01_MV_010	EQU	$

		JSL	>OAMDXCLR	;OAM clear
;
		JSR	OPMSGSET
;
		JSL	>DEMO_OBJ	;fnai
		JSL	>ENCSET_DM	;fnai n`lZbg
;
		M16
;
		LDA	OBJSEL
		AND	#11100000B
		BEQ	DEMO_01_MV_020	;naiTCYύXH ( no:DEMO_01_MV_020 )
;
		M_CHIP	DM01_OAM_SIZE	;~[WJfpn`lTCY̕ύX
;
DEMO_01_MV_020	EQU	$
		M_CHIP	DX_OAM		;OAM convert
;
		M8
;
DEMO_01_MV_030	EQU	$
		PLB
		RTL
;
;
;
;
;
;************************************************************************
;*		fnaif[^ǂݍ				*
;*			in  : (X) <-- fnaif[^|C^[	*
;************************************************************************
;
		MEM16
		IDX16
;
DEMO_OBJ_READ	EQU	$
		LDA	!0,X		;(A) <-- fnaimD
		BEQ	DEMO_OBJ_RD_010 ;f[^IH ( yes:DEMO_OBJ_RD_010 )
;
		PHX			;(X) save
;
		I8
;
		JSR	DM_INSR_X
;
		I16
;
		PLX			;(X) load
;
		LDA	!2,X		;wWZbg
		STA	ENXPSL,Y
		LDA	!4,X		;x	h
		STA	ENYPSL,Y
		TXA
		CLC
		ADC	#6
		TAX
		BRA	DEMO_OBJ_READ
;
DEMO_OBJ_RD_010 EQU	$
;
		MI8
;
		RTS
;
;************************************************************************
;*		fnaiC					*
;************************************************************************
;
		DPAGE	EN0RAM
;
DEMO_OBJ	EQU	$
		PHB			;(DBR) save
		PHK			;(DBR) <-- (PBR)
		PLB
		PHD			;(D) save
;
		M16
;
		LDA	#EN0RAM		;(D) <-- enemy 0 page
		TCD
;
;-------------- t[JE^[Zbg --------------------------------
		INC	<FRCNT2
;
;-------------- WvZ ------------------------------------------------
;
		M_CHIP	XYMOVE
;
;-------------- fnai[` --------------------------------------
		LDX	#(ENNO-1)*4
DEMO_OBJ_010	EQU	$
		STX	<ENINDX
;
;----------------------------------------------------------------
;-		random set					-
;----------------------------------------------------------------
		LDY	2137H
		LDY	213FH
		LDA	213CH
		CLC
		ADC	RANDM0
		STA	RANDM0
;
;-------------- fnai[hZNg ------------------------
		JSR	DEMO_MDSL
;
		DEX
		DEX
		DEX
		DEX
		BPL	DEMO_OBJ_010
;
		M8
;
		PLD
		PLB
		RTL
;
		MEM16
;
;************************************************************************
;*		fnai[hZNg				*
;************************************************************************
DEMO_MDSL	EQU	$
		LDA	ENMODE,X
		BEQ	RTSSUB
;
		JSR	DM_SUB0
;
		LDY	ENMODE,X
		LDA	!DM_MODE_ADR,Y
		PHA
;
RTSSUB		EQU	$
		RTS
;
DM_MODE_ADR	EQU	$-(CENOK-1)*2
DM_01		WORD	DM_INIT-1
DM_02		WORD	DM_MOVE-1
;
;- - - - - - - - - - - - - - - -
DINIT		EQU	DM_01-DM_MODE_ADR
DMOVE		EQU	DM_02-DM_MODE_ADR
;
;==========================================
DM_SUB0		EQU	$
		LDA	ENTIM0,X
		BEQ	DM_SUB0_010
		DEC	ENTIM0,X
DM_SUB0_010	EQU	$
		LDA	ENTIM1,X
		BEQ	DM_SUB0_020
		DEC	ENTIM1,X
DM_SUB0_020	EQU	$
		LDA	ENTIM2,X
		BEQ	DM_SUB0_030
		DEC	ENTIM2,X
DM_SUB0_030	EQU	$
		LDA	ENTIM3,X
		BEQ	DM_SUB0_040
		DEC	ENTIM3,X
DM_SUB0_040	EQU	$
		RTS
;
;************************************************************************
;*		fnaiZbg[`				*
;************************************************************************
DM_INIT		EQU	$
		LDA	#DMOVE		;next goto move !!
		STA	ENMODE,X
		LDA	ENMYNO,X
		ASL	A
;
		I16
;
		TAY
		LDA	!DM_INIT_ADR,Y
		STA	<EWORK
;
		I8
;
		JMP	(EWORK)
;
;************************************************************************
;*		fnai[`					*
;************************************************************************
DM_MOVE		EQU	$
		LDA	ENMYNO,X
		ASL	A
;
		I16
;
		TAY
		LDA	!DM_MOVE_ADR,Y
		STA	<EWORK
;
		I8
;
		JMP	(EWORK)
;
;************************************************************************
;*		fnaiGAmہiafQ\Zbgj		*
;*			in  : (A) <-- enemy no.				*
;*			out : (C) <-- 0:area nothing			*
;*				1:find (Y) <- index			*
;************************************************************************
DM_INSR_X	EQU	$
		JSR	DM_INSR
		BCC	DM_INSR_X_010
;
		LDA	#02FFH		;[ & LDA #02H	  ]
		STA	ENRETN,Y	;[ & STA ENDORE,Y ]
DM_INSR_X_010	EQU	$
		RTS
;
;************************************************************************
;*		fnaiGAm					*
;*			in  : (A) <-- enemy no.				*
;*			out : (C) <-- 0:area nothing			*
;*				1:find (Y) <- index			*
;************************************************************************
DM_INSR		EQU	$
		PHA			;(A) save
;
		LDY	#(ENNO-1)*4
DM_INSR_010	EQU	$
		LDA	ENMODE,Y
		BEQ	DM_INSR_020	;area find ? ( yes:DM_INSR_020 )
		DEY
		DEY
		DEY
		DEY
		BPL	DM_INSR_010
		PLA
		CLC
		RTS
;
DM_INSR_020	EQU	$
		LDA	#DINIT
		STA	ENMODE,Y
		LDA	#00FFH
		STA	ENRETN,Y	;[ & STA ENDORE,Y ]
		LDA	#0000
		STA	ENCOLD,Y
		STA	ENXSPD,Y
		STA	ENYSPD,Y
		STA	ENCONT,Y
		STA	ENMUKI,Y
		STA	ENEMU0,Y	;[ & STA ENXSDR,Y ]
		STA	ENCHRB,Y	;[ & STA ENYSDR,Y ]
		STA	ECRSFG,Y	;[ & STA ENCRPT,Y ]
		STA	ENWRK0,Y	;[ & STA ENWRK1,Y ]
		STA	ENWRK2,Y	;[ & STA ENWRK3,Y ]
		STA	ENWRK4,Y	;[ & STA ENWRK5,Y ]
		STA	ENWRK6,Y	;[ & STA ENWRK7,Y ]
		STA	ENWRK8,Y	;[ & STA ENWRK9,Y ]
		STA	ENWRKA,Y	;[ & STA ENWRKB,Y ]
		STA	ENWRKC,Y	;[ & STA ENWRKD,Y ]
		STA	ENTIM0,Y
		STA	ENTIM1,Y
		STA	ENTIM2,Y
		STA	ENTIM3,Y
		STA	ENCHPT,Y
		STA	ENCBFG,Y
		STA	ENSLOP,Y	;[ & STA EN_ADD_XSP,Y ]
		STA	ENSHOT,Y
		STA	ENDSXL,Y
		STA	ENDSYL,Y
		STA	ENXPOW,Y
		STA	ENXMAX,Y
		STA	ENWRKX,Y	;[ & STA ENSPTM,Y ]
		STA	ENGPOW,Y
		STA	ENGMAX,Y
		STA	ENMOD0,Y
		STA	ENMOD1,Y
		DEC	A		;[ LDA #0FFFFH ]
		STA	ENTROB,Y
		LDA	#0FFH+(((100H/8)-1)*100H)
		STA	ENWATR,Y
;
		PLA			;(A) load
;
		STA	ENMYNO,Y
;
		PHX			;(X) save
;
		ASL	A
;
		I16
;
		TAX
		LDA	!DM_DATA0+1,X
		AND	#00FFH
		STA	ENCLOR,Y
		LDA	!DM_DATA0,X
		AND	#00FFH
		STA	ENYUSN,Y
		LDA	!DM_MODE2,X
		STA	ENMOD2,Y
;
		I8
;
		PLX			;(X) load
		SEC
		RTS
;
;
;************************************************************************
;*		Zbg						*
;************************************************************************
DM_DETH0IN	EQU	$
DM_DETH1IN	EQU	$
DM_BEBY0IN	EQU	$
		LDA	#00009H
		STA	ENTIM2,Y	; |WV`FW^CZbgII
		RTS
;
;************************************************************************
;*			( e_[u )				*
;************************************************************************
SEQTIMD		EQU	$
		WORD	00030H,00000H
;
;
DM_DETH0MV	EQU	$
		LDA	<ENWRK2,X
		DEC	A		;CMP	 #00001H
		BEQ	DDT0100		; ΂ĂH
;					; No !!
		DEC	A		;CMP	 #00002H
		BEQ	DDT0400		; ΂H
;					; No !!
		DEC	A		;CMP	 #00003H
		BEQ	DDT0300		; ㏸H
;					; No !!
		LDA	ENTIM0,X
		BNE	DDT0050		; ΂H
;					; Yes !!
		LDA	#08H		;[]
		STA	SOUND_0
;
		INC	<ENWRK2,X
		LDA	<ENWRK2,X
		ASL	A
		TAY
		LDA	!SEQTIMD-2,Y
		STA	ENTIM0,X	; ^C}[ZbgII
		LDA	#00003H
		STA	ENCHPT,X	; Lp^[ZbgII
		LDA	#0000AH
		STA	ENTIM1,X	; p^[^CZbgII
		JMP	DDT1100
;
DDT0050		EQU	$
		JMP	DM_DETH1MV
;
DDT0100		EQU	$
		LDA	ENTIM0,X
		BNE	DDT0150		; ΂IH
;					; Yes !!
		INC	<ENWRK2,X
		LDA	#00010H
		STA	ENTIM0,X	; ^C}[ZbgII
		LDA	#00008H
		STA	ENTIM1,X	; p^[^CZbgII
		STZ	ENCHPT,X	; Lp^[ZbgII
		JMP	DM_DETH1MV
;
DDT0150		EQU	$
		LDA	ENTIM1,X
		BNE	DDT0250		; ΂Ăp^[`FWH
;					; Yes !!
		LDA	#00003
		STA	ENTIM1,X
		LDA	ENCHPT,X
		INC	A
		CMP	#00005H
		BCC	DDT0200		; p^[I[o[H
;					; Yes !!
		LDA	#00003H
;
DDT0200		EQU	$
		STA	ENCHPT,X
;
DDT0250		EQU	$
		JMP	DDT1100
;
DDT0300		EQU	$
		LDA	ENYPSL,X
		CMP	#0FFC0H
		BPL	DDT0350		; fGhH
;					; Yes !!
		INC	GMFADE_CT
;
DDT0350		EQU	$
		JMP	DM_DETH1MV
;
DDT0400		EQU	$
		LDA	ENTIM0,X
		BNE	DDT0350		; ㏸H
;					; Yes !!
		INC	<ENWRK2,X
		LDA	#0FC00H
		STA	ENGMAX,X
		STA	ENGMAX+4CH
		STA	ENGMAX+50H
		STA	ENGMAX+54H
		STA	ENGMAX+58H
		LDA	#00040H
		STA	ENGPOW,X
		STA	ENGPOW+4CH
		STA	ENGPOW+50H
		STA	ENGPOW+54H
		STA	ENGPOW+58H
		JMP	DM_DETH1MV
;
;
;************************************************************************
;*			( q_[u )				*
;************************************************************************
YPOSDAT		EQU	$
		WORD	00001H,00001H,00002H,00002H,00003H,00002H,00002H,00001H
		WORD	0FFFFH,0FFFEH,0FFFEH,0FFFDH,0FFFEH,0FFFEH,0FFFFH,0FFFFH
;
PUROPERA_CHNO	EQU	$
		WORD	0CC4H,0CC6H,0CC8H,4CC6H
;
DM_DETH1MV	EQU	$
		LDA	ENTIM1,X
		BNE	DDT1100		; p^[`FWH
;					; Yes !!
		LDA	ENCHPT,X
		INC	A
		CMP	#00003
		BNE	DDT1050		; p^[I[o[H
;					; Yes !!
		LDA	#0000
;
DDT1050		EQU	$
		STA	ENCHPT,X	; Lp^[ZbgII
		LDA	#00008
		STA	ENTIM1,X	; p^[^CZbgII
;
;-------------- vy] --------------------------------------------
DDT1100		EQU	$
		LDA	<FRCNT2
		AND	#03H*2
		TAY
		LDA	!PUROPERA_CHNO,Y
;
		I16
;
		LDY	ENOAML,X
		STA	SOAM_DX+4,Y
;
		I8
;
DDT1110		EQU	$
		LDA	ENTIM2,X
		BNE	DDT1150		; |WV`FWH
;					; Yes !!
		LDA	#00008H
		STA	ENTIM2,X	; |WV`FW^CZbgII
		LDA	<ENWRK0,X
		INC	A
		INC	A
		AND	#0001FH
		STA	<ENWRK0,X	; |WV`FW|C^[ZbgII
		TAY
		LDA	ENYPSL,X
		CLC
		ADC	!YPOSDAT,Y
		STA	ENYPSL,X	; |WVZbgII
;
DDT1150		EQU	$
		RTS
;
;
;************************************************************************
;*			( x[r[[u )				*
;************************************************************************
DM_BEBY0MV	EQU	$
		LDA	ENTIM1,X
		BNE	DBY1050		; p^[`FWH
;					; Yes !!
		LDA	ENCHPT,X
		INC	A
		AND	#00001
		STA	ENCHPT,X	; Lp^[ZbgII
		LDA	#00006H
		STA	ENTIM1,X	; p^[^CZbgII
;
DBY1050		EQU	$
		JMP	DDT1110
;
;
;
;
;
;************************************************************************
;*		Zbgi~[WJ̃REmgj			*
;************************************************************************
;
DM_BIRD0IN	EQU	$
;
		I16
;
		LDX	#200H-2
DM_BIRD0IN_0010 EQU	$
		LDA	>DATACOL,X
		STA	>MOTOCOL,X
		STA	>CHNGCOL,X
		DEX
		DEX
		BPL	DM_BIRD0IN_0010
;
		I8
;
		JSR	COL_FADE_SET	;J[tF[hZbg
		LDA	#MOTOCOL
		STA	>MOTOADR
		LDA	#CHNGCOL
		STA	>CHNGADR
;
		STZ	SCCV1		;afXN[JE^[Zbg
		STZ	SCCV2
		STZ	SCCH1		;fnai\pXN[JE^[Zbg
		STZ	SCCH2
		STZ	ESCCH1
		STZ	ESCCH2
		STZ	ESCCV1
		STZ	ESCCV2
		LDX	#00
		JSR	BG_WAVE_SET
		LDX	#04
		JSR	BG_WAVE_SET
;
; #if !="Debug"
		 LDA	 #0200H		 ;ꖋ܂ł̃^C}[Zbg
		 STA	 ENTIM3,X
; #else
;		LDA	#0CH
;		STA	<ENWRK0,X
;		LDA	#0FFH
;		STA	ENYUSN,X
;		LDX	#CHRDC		;(X) <-- LN^[f[^mD
;		LDA	#4000H		;(A) <-- uq`lAhX
;		JSR	CHAR_CHANGE
;		LDA	#00010000B	;afQX^[XN[Zbg
;		TRB	HD420C
; #endif
		STZ	ENWRKA,X
;
;************************************************************************
;*			  i~[WJ̃REmgj			*
;************************************************************************
DM_BIRD0MV	EQU	$
		LDY	<ENWRK0,X
		TYX
		JMP	(!DEMO_01_SEL,X)
;
;------------------------------------------------------------------------
;-		f̐䏈						-
;------------------------------------------------------------------------
DEMO_01_SEL	EQU	$		;[ENWRK0,X]
		WORD	DEMO_01_MV_0	;[0]
		WORD	DEMO_01_MV_1	;[2]
		WORD	DEMO_01_MV_2	;[4]
		WORD	DEMO_01_MV_3	;[6]
		WORD	DEMO_01_MV_4	;[8]
		WORD	DEMO_01_MV_5	;[A]
		WORD	DEMO_01_MV_6	;[C]
		WORD	DEMO_01_MV_7	;[E]
		WORD	DEMO_01_MV_8	;[10]
;
;------------------------------------------------------------------------
;-		hhS\				-
;------------------------------------------------------------------------
DEMO_01_MV_0	EQU	$
		LDX	<ENINDX
;
		JSR	ROGO_ANIME
;
		JSR	NEXT_CHECK
		BNE	DEMO_01_MV_0010 ;H ( no:DEMO_01_MV_0010 )
;
;-------------- ꖋZbg ----------------------------------------
;
		I16
;
		LDX	#DM_01_OBJ_01	;(X) <-- ꖋfnaiZbg
		JSR	DEMO_OBJ_READ
;
		MEM8
		IDX8
;
		M16
;
		LDX	<ENINDX
		LDA	#0500H		;񖋂܂ł̃^C}[Zbg
		STA	ENTIM3,X
;
DEMO_01_MODINC	EQU	$
		INC	<ENWRK0,X	;̃[h
		INC	<ENWRK0,X
DEMO_01_MV_0010 EQU	$
		RTS
;
;================================================================
;-		̖ւ̃`FbN				=
;================================================================
NEXT_CHECK	EQU	$
		LDA	ENTIM3,X	;(Z) <-- 0
		BNE	NEXT_CHECK_010	;^C}[IH ( no:NEXT_CHECK_010 )
;
		LDY	OPNEXTFG
		BNE	NEXT_CHECK_020	;̖ցH ( yes:NEXT_CHECK_020 )
		INC	OPNEXTFG
NEXT_CHECK_010	EQU	$
		RTS
;
NEXT_CHECK_020	EQU	$
		LDY	#00		;(Z) <-- 1
		STY	OPNEXTFG
		RTS
;
;------------------------------------------------------------------------
;-		ꖋf						-
;------------------------------------------------------------------------
DEMO_01_MV_1	EQU	$
		LDX	<ENINDX
;
;-------------- X^[XN[Zbg --------------------------------
		JSR	BG_WAVE_SET
;
;-------------- REmg ------------------------------------------
		JSR	DM_BIRD0_MV
;
;-------------- hhS --------------------------
		LDA	SCCH1
		CMP	#0100H
		BCS	DEMO_01_MV_1010 ;IH ( yes:DEMO_01_MV_1010 )
;
		CLC
		ADC	#02H
		STA	SCCH1
		STA	ESCCH1
;
;-------------- hhS ----------------
ROGO_ANIME	EQU	$
		LDA	<FRCNT2
		AND	#03H
		BNE	ROGO_ANIME_040
;
		LDA	ENWRKA,X
		CLC
		ADC	#050H
		CMP	#050H*3
		BCC	ROGO_ANIME_010
		LDA	#00H
ROGO_ANIME_010	EQU	$
		STA	ENWRKA,X
		ORA	#1900H
		STA	<EWORK0
;
		I16
;
		LDA	>VRAMD
		TAX
		LDA	#05
		STA	<EWORK2
		LDA	#6108H		;VRAM address set
		STA	<EWORK4
ROGO_ANIME_020	EQU	$
		LDA	<EWORK4
		STA	>VRAMD+2,X
		CLC
		ADC	#020H
		STA	<EWORK4
		LDA	#(16*2)-1	;number of byte set
		STA	>VRAMD+4,X
;
		LDY	#16
		LDA	<EWORK0
ROGO_ANIME_030	EQU	$
		STA	>VRAMD+6,X
		INC	A
		INX
		INX
		DEY
		BNE	ROGO_ANIME_030
		STA	<EWORK0
;
		INX
		INX
		INX
		INX
		DEC	<EWORK2
		BNE	ROGO_ANIME_020
;
		LDA	#0FFFFH
		STA	>VRAMD+2,X
;
		I8
;
		LDX	<ENINDX
ROGO_ANIME_040	EQU	$
		RTS
;
;-------------- J[tF[h ------------------------------------------
DEMO_01_MV_1010 EQU	$
		LDA	>CLFDCNT
		CMP	#020H
		BCC	DEMO_01_MV_1020 ;̃J[ցH ( no:DEMO_01_MV_1020 )
;
		LDA	<ENCONT,X
		CMP	#(15*2)*15
		BCS	DEMO_01_MV_1030 ;J[tF[hIH ( yes:DEMO_01_MV_1030 )
;
		JSR	COL_FADE_SET	;̃J[tF[hZbg
;
DEMO_01_MV_1020 EQU	$
		LDA	<FRCNT2
		LSR	A
		BCC	DEMO_01_MV_1030 ;J[tF[hZbgH ( no:DEMO_01_MV_1030 )
;
		M_CHIP	COLFADE
;
DEMO_01_MV_1030 EQU	$
		LDX	<ENINDX
		JSR	NEXT_CHECK
		BNE	DEMO_01_MV_1050 ;̖ɍsH ( no:DEMO_01_MV_1050 )
;
;-------------- jZbg ----------------------------------------
		LDA	#B1OPDM2	;(A) <-- XN[f[^mD
		JSR	DORE_CHANGE
;
		LDX	#(0FH-1)*2
DEMO_01_MV_1040 EQU	$
		LDA	>COL_ADDRESS+MSCL_COL_2_BG,X
		STA	>DATACOL+(41H*2),X
		LDA	>COL_ADDRESS+MSCL_COL_2_BG+(0FH*2),X
		STA	>DATACOL+(51H*2),X
		DEX
		DEX
		BPL	DEMO_01_MV_1040
;
		I16
;
		LDX	#DM_01_OBJ_02	;(X) <-- 񖋃fnaiZbg
		JSR	DEMO_OBJ_READ
;
		MEM8
		IDX8
;
		LDA	#00010000B	;afQX^[XN[Zbg
		TRB	HD420C
;
		M16
;
		LDX	<ENINDX
		LDA	#1C0H		;O܂ł̃^C}[Zbg
		STA	ENTIM3,X
		LDA	#02H		;H΂^C}[Zbg
		STA	ENTIM1,X
		JMP	DEMO_01_MODINC
;
DEMO_01_MV_1050 EQU	$
		RTS
;
;------------------------------------------------------------------------
;-		jf						-
;------------------------------------------------------------------------
DEMO_01_MV_2	EQU	$
		LDX	<ENINDX
;
;-------------- ꖋ	 ------------------------------------------
		LDA	ESCCH1
		CMP	#0300H
		BCS	DEMO_01_MV_2020 ;IH ( yes:DEMO_01_MV_2020 )
;
;;;;		    CLC
		ADC	#02H
		STA	ESCCH1
		CMP	#0100H
		BCC	DEMO_01_MV_2010
		LDA	#0100H
DEMO_01_MV_2010 EQU	$
		STA	SCCH1
;
;-------------- REmg ------------------------------------------
		JMP	DM_BIRD0_MV
;
DEMO_01_MV_2020 EQU	$
		LDA	#0FFH		;\Zbg
		STA	ENYUSN,X
;
		JSR	NEXT_CHECK
		BNE	DEMO_01_MV_2050 ;̖ɍsH ( no:DEMO_01_MV_2050 )
;
;-------------- OZbg ----------------------------------------
		LDA	#B1OPDM1	;(A) <-- XN[f[^mD
		JSR	DORE_CHANGE
;
		I16
;
		LDX	#DM_01_OBJ_03	;(X) <-- OfnaiZbg
		JSR	DEMO_OBJ_READ
;
		MEM8
		IDX8
;
		M16
;
;-------------- REmg̍ĕ\Zbg ------------------------
		LDX	<ENINDX
		LDA	#088H		;WZbg
		STA	ENXPSL,X
		LDA	#048H
		STA	ENYPSL,X
		STZ	ENXSPD,X	;ړXs[hZbg
		STZ	ENYSPD,X
		STZ	ENGPOW,X
		STZ	ENGMAX,X
		STZ	ENXPOW,X
		STZ	ENXMAX,X
		LDA	#05H		;\Zbg
		STA	ENYUSN,X
		LDA	ENCLOR,X
		EOR	#030H
		STA	ENCLOR,X
		LDA	#02FFH		;[ LDA #02H	]
		STA	ENRETN,X	;[ STA ENDORE,X ]
		LDA	#200H		;l܂ł̃^C}[Zbg
		STA	ENTIM3,X
		JMP	DEMO_01_MODINC
;
DEMO_01_MV_2050 EQU	$
		RTS
;
;------------------------------------------------------------------------
;-		Of						-
;------------------------------------------------------------------------
DEMO_01_MV_3	EQU	$
		LDX	<ENINDX
;
;-------------- X^[XN[Zbg --------------------------------
		JSR	BG_WAVE_SET
;
;-------------- REmg ------------------------------------------
		JSR	DM_BIRD0_MV
;
;-------------- 	 ------------------------------------------
		LDA	ESCCH1
		CMP	#0300H
		BCS	DEMO_01_MV_3020 ;IH ( yes:DEMO_01_MV_3020 )
;
;;;;		    CLC
		ADC	#02H
		STA	ESCCH1
		CMP	#0100H
		BCC	DEMO_01_MV_3010
		LDA	#0100H
DEMO_01_MV_3010 EQU	$
		STA	SCCH1
		RTS
;
DEMO_01_MV_3020 EQU	$
		JSR	NEXT_CHECK
		BNE	DEMO_01_MV_3050 ;̖ɍsH ( no:DEMO_01_MV_3050 )
;
;-------------- lZbg ----------------------------------------
		LDX	#CHRD4		;(X) <-- LN^[f[^mD
		LDA	#1000H		;(A) <-- uq`lAhX
		JSR	CHAR_CHANGE
		LDA	#B1OPDM4	;(A) <-- XN[f[^mD
		JSR	DORE_CHANGE
;
		LDX	#(0FH-1)*2
DEMO_01_MV_3030 EQU	$
		LDA	>COL_ADDRESS+MSCL_COL_4_BG,X
		STA	>DATACOL+(41H*2),X
		DEX
		DEX
		BPL	DEMO_01_MV_3030
;
		I16
;
		LDX	#DM_01_OBJ_04	;(X) <-- lfnaiZbg
		JSR	DEMO_OBJ_READ
;
		MEM8
		IDX8
;
		LDA	#00010000B	;afQX^[XN[Zbg
		TRB	HD420C
;
		LDA	#03H		;Pʂ
		TRB	BG2SCF
;
		M16
;
		LDA	#0FE7FH		;afʒuZbg
		STA	SCCH2
		STZ	<FRCNT2
;
		LDX	<ENINDX
		LDA	#300H		;ܖ܂ł̃^C}[Zbg
		STA	ENTIM3,X
		JMP	DEMO_01_MODINC
;
DEMO_01_MV_3050 EQU	$
		RTS
;
;------------------------------------------------------------------------
;-		lf						-
;------------------------------------------------------------------------
DEMO_01_MV_4	EQU	$
		LDX	<ENINDX
;
		LDA	<FRCNT2
		LSR	A
		BCC	DEMO_01_MV_4010
		INC	SCCH2
		INC	SCCV2
DEMO_01_MV_4010 EQU	$
;
;-------------- O	 ------------------------------------------
		LDA	SCCH1
		CMP	#0100H
		BCS	DEMO_01_MV_4020 ;IH ( yes:DEMO_01_MV_4020 )
;
;;;;		    CLC
		ADC	#02H
		STA	SCCH1
		STA	ESCCH1
;
;-------------- REmg ------------------------------------------
		JMP	DM_BIRD0_MV
;
DEMO_01_MV_4020 EQU	$
		LDA	#0FFH		;\Zbg
		STA	ENYUSN,X
;
		JSR	NEXT_CHECK
		BNE	DEMO_01_MV_4050 ;̖ɍsH ( no:DEMO_01_MV_4050 )
;
;-------------- уJ[ZZbg --------------------
		LDA	#00010111B+(00000000B*100H)
		STA	DM_HDMA_PR
		LDY	#00010000B
		STY	WIND30
		LDY	#00000010B	;afQƉZ
		STY	SUBADF
		LDA	#1088H
		STA	NUKCOL
;
;-------------- ܖZbg ----------------------------------------
		LDA	#01H		;Qʂ
		TSB	BG2SCF
;
		LDX	#CHRD5		;(X) <-- LN^[f[^mD
		LDA	#1800H		;(A) <-- uq`lAhX
		JSR	CHAR_CHANGE
		LDA	#B1OPDM5	;(A) <-- XN[f[^mD
		JSR	DORE_CHANGE
;
		LDX	#(0FH-1)*2
DEMO_01_MV_4030 EQU	$
		LDA	>COL_ADDRESS+MSCL_COL_5_BG,X
		STA	>DATACOL+(51H*2),X
		LDA	>COL_ADDRESS+MSCL_COL_5_BG+(0FH*2),X
		STA	>DATACOL+(61H*2),X
		DEX
		DEX
		BPL	DEMO_01_MV_4030
;
		I16
;
		LDX	#DM_01_OBJ_05	;(X) <-- ܖfnaiZbg
		JSR	DEMO_OBJ_READ
;
		MEM8
		IDX8
;
		LDA	#03H		;Pʂ
		TRB	BG2SCF
;
		M16
;
		LDA	#0178H		;afʒuZbg
		STA	SCCH2
;
		LDX	<ENINDX
		LDA	#400H		;Z܂ł̃^C}[Zbg
		STA	ENTIM3,X
		JMP	DEMO_01_MODINC
;
DEMO_01_MV_4050 EQU	$
		RTS
;
;------------------------------------------------------------------------
;-		ܖf						-
;------------------------------------------------------------------------
DEMO_01_MV_5	EQU	$
;
;-------------- уEBhEZbg --------------------------------
		LDA	ESCCH2
		JSR	OPDM_KMLB
		LDX	<ENINDX
;
;-------------- l	 ------------------------------------------
		LDA	SCCH1
		CMP	#0100H
		BCS	DEMO_01_MV_5020 ;IH ( yes:DEMO_01_MV_5020 )
;
;;;;		    CLC
		ADC	#02H
		STA	SCCH1
		STA	ESCCH1
;
		LDA	<FRCNT2
		LSR	A
		BCC	DEMO_01_MV_5010
		INC	SCCV1
DEMO_01_MV_5010 EQU	$
		RTS
;
DEMO_01_MV_5020 EQU	$
		JSR	NEXT_CHECK
		BNE	DEMO_01_MV_5050 ;̖ɍsH ( no:DEMO_01_MV_5050 )
;
;-------------- ZZbg ----------------------------------------
		LDA	#01H		;Qʂ
		TSB	BG2SCF
;
		LDA	#B1OPDM6	;(A) <-- XN[f[^mD
		JSR	DORE_CHANGE
;
		LDX	#(0FH-1)*2
DEMO_01_MV_5030 EQU	$
		LDA	>COL_ADDRESS+MSCL_COL_6_BG,X
		STA	>DATACOL+(31H*2),X
		LDA	>COL_ADDRESS+MSCL_COL_6_BG+(0FH*2),X
		STA	>DATACOL+(41H*2),X
		DEX
		DEX
		BPL	DEMO_01_MV_5030
;
;-------------- уJ[ZύX --------------------------
		LDY	#00000001B	;afPƉZ
		STY	SUBADF
;
		LDX	<ENINDX
		LDA	#100H		;掵܂ł̃^C}[Zbg
		STA	ENTIM3,X
		JMP	DEMO_01_MODINC
;
DEMO_01_MV_5050 EQU	$
		RTS
;
;------------------------------------------------------------------------
;-		Zf						-
;------------------------------------------------------------------------
DEMO_01_MV_6	EQU	$
		LDX	<ENINDX
;
;-------------- ܖ	 ------------------------------------------
		LDA	SCCH1
		CMP	#0100H
		BCS	DEMO_01_MV_6020 ;IH ( yes:DEMO_01_MV_6020 )
;
;;;;		    CLC
		ADC	#02H
		STA	SCCH1
		STA	ESCCH1		;(A) <-- EBhEXN[JE^[
;
;-------------- уEBhEZbg --------------------------------
		JSR	OPDM_KMLB
		LDX	<ENINDX
		RTS
;
DEMO_01_MV_6020 EQU	$
		JSR	NEXT_CHECK
		BNE	DEMO_01_MV_6050 ;̖ɍsH ( no:DEMO_01_MV_6050 )
;
;-------------- 掵Zbg ----------------------------------------
		LDA	#B1OPDM7	;(A) <-- XN[f[^mD
		JSR	DORE_CHANGE
;
		LDX	#(0FH-1)*2
DEMO_01_MV_6030 EQU	$
		LDA	>COL_ADDRESS+MSCL_COL_7_BG,X
		STA	>DATACOL+(51H*2),X
		LDA	>COL_ADDRESS+MSCL_COL_7_BG+(0FH*2),X
		STA	>DATACOL+(61H*2),X
		DEX
		DEX
		BPL	DEMO_01_MV_6030
;
		I16
;
		LDX	#DM_01_OBJ_07	;(X) <-- 掵fnaiZbg
		JSR	DEMO_OBJ_READ
;
		MEM8
		IDX8
;
		M16
;
;-------------- уJ[ZZbg ----------------------
		LDA	#00010101B+(00000010B*100H)
		STA	DM_HDMA_PR
		LDY	#00000010B
		STY	WIND30
		LDY	#00100000B
		STY	SUBADF
		STZ	NUKCOL
;
		LDX	<ENINDX
		LDA	#480H		;攪܂ł̃^C}[Zbg
		STA	ENTIM3,X
		JMP	DEMO_01_MODINC
;
DEMO_01_MV_6050 EQU	$
		RTS
;
;------------------------------------------------------------------------
;-		掵f						-
;------------------------------------------------------------------------
DEMO_01_MV_7	EQU	$
		LDX	<ENINDX
;
;-------------- Z	 ------------------------------------------
		LDA	SCCH1
		CMP	#0100H
		BCS	DEMO_01_MV_7020 ;IH ( yes:DEMO_01_MV_7020 )
;
;;;;		    CLC
		ADC	#02H
		STA	SCCH1
		STA	ESCCH1
		RTS
;
DEMO_01_MV_7020 EQU	$
		JSR	NEXT_CHECK
		BNE	DEMO_01_MV_7050 ;̖ɍsH ( no:DEMO_01_MV_7050 )
;
;-------------- 攪Zbg ----------------------------------------
		LDA	#B1OPDM8	;(A) <-- XN[f[^mD
		JSR	DORE_CHANGE
;
		LDX	#(0FH-1)*2
DEMO_01_MV_7030 EQU	$
		LDA	>COL_ADDRESS+MSCL_COL_8_BG,X
		STA	>DATACOL+(21H*2),X
		LDA	>COL_ADDRESS+MSCL_COL_8_BG+(0FH*2),X
		STA	>DATACOL+(31H*2),X
		LDA	>COL_ADDRESS+MSCL_COL_OBJ_71,X
		STA	>DATACOL+(0F1H*2),X
		DEX
		DEX
		BPL	DEMO_01_MV_7030
;
		I16
;
		LDX	#DM_01_OBJ_08	;(X) <-- 攪fnaiZbg
		JSR	DEMO_OBJ_READ
;
		MEM8
		IDX8
;
		LDA	#03H		;Pʂ
		TRB	BG2SCF
;
		M16
;
		LDX	<ENINDX
		LDA	#300H		;̃[hw̃^C}[Zbg
		STA	ENTIM3,X
		JMP	DEMO_01_MODINC
;
DEMO_01_MV_7050 EQU	$
		RTS
;
;------------------------------------------------------------------------
;-		攪f						-
;------------------------------------------------------------------------
DEMO_01_MV_8	EQU	$
		LDX	<ENINDX
;
;-------------- dXN[Zbg ------------------------------------
		LDA	SCCH2
		LSR	A
		STA	>HDMABUF+2	;_̃XN[
		LSR	A
		STA	>HDMABUF	;R̃XN[
		LDA	#00001000B	;afQX^[XN[Zbg
		TSB	HD420C
;
;-------------- 掵	 ------------------------------------------
		LDA	SCCH1
		CMP	#0100H
		BCS	DEMO_01_MV_8020 ;IH ( yes:DEMO_01_MV_8020 )
;
;;;;		    CLC
		ADC	#02H
		STA	SCCH1
		STA	ESCCH1
		RTS
;
DEMO_01_MV_8020 EQU	$
		JSR	NEXT_CHECK
		BNE	DEMO_01_MV_8050 ;̖ɍsH ( no:DEMO_01_MV_8050 )
;
;-------------- ̃[hw --------------------------------------------
;
DEMO_01_MV_8050 EQU	$
		RTS
;
;========================================================================
;=		H΂p^[Zbg					=
;========================================================================
;
;------------------------------------------------------------------------
;-		㉺Xs[hf[^					-
;------------------------------------------------------------------------
BIRD0_GPOW	EQU	$
		WORD	00001H,00002H
BIRD0_GMAX	EQU	$
		WORD	00010H,0FFC0H
;
;------------------------------------------------------------------------
;-		㏸^C}[f[^					-
;------------------------------------------------------------------------
FLYUP_TIM	EQU	$
		WORD	010H,008H,018H,04H
;
;------------------------------------------------------------------------
;-		]Xs[hf[^					-
;------------------------------------------------------------------------
BIRD0_MINSPD	EQU	$
; ENWRK2,X -->		  0   2
		WORD	256/3,040H
BIRD0_ROTSPD	EQU	$-(12*2)
		WORD	256/3,256/3,256/3,08H,256/1
;
DM_BIRD0_MV	EQU	$
		LDA	#256/2		;(A) <-- H΂Xs[h
		LDY	ENTIM1,X
		BNE	DM_BARD0MV_0010 ;㏸H ( no:DM_BARD0MV_0010 )
;
		LDY	<ENWRK2,X	;(Y) <-- 0: 2:]
		LDA	ENWRK8,X
		CMP	!BIRD0_MINSPD,Y
		BMI	DM_BARD0MV_0010
		SEC
		SBC	#02H
DM_BARD0MV_0010 EQU	$
		STA	ENWRK8,X
		CLC
		ADC	ENWRK6,X
		CMP	#12*100H
		BCC	DM_BARD0MV_0050 ;ԃp^[l`wH ( no:DM_BARD0MV_0050 )
;
		LDY	<ENWRK2,X
		BNE	DM_BARD0MV_0020 ;]H ( yes:DM_BARD0MV_0020 )
;
		AND	#00FFH
		BRA	DM_BARD0MV_0050
;
DM_BARD0MV_0020 EQU	$
		PHA			;(A) save
;
		XBA
		AND	#0FFH
		ASL	A
		TAY
		CPY	#17*2
		BCS	DM_BARD0MV_0030 ;]Xs[hZbgH ( no:DM_BARD0MV_0030 )
;
		LDA	ENWRK6+1,X
		AND	#0FFH
		ASL	A
		STA	<EWORK0
;
		CPY	#16*2
		BNE	DM_BARD0MV_0022 ;ƂH ( no:DM_BARD0MV_0022 )
;
		CMP	#15*2
		BNE	DM_BARD0MV_0030 ;łɃZbgH ( yes:DM_BARD0MV_0030 )
;
		PHY			;(Y) save
;
;-------------- ƂZbg ----------------------------------------
		LDA	#DM_KOZU0	;(A) <-- fnaimD
		JSR	DM_INSR_X
		LDA	ENXPSL,X	;wWZbg
		CLC
		ADC	#014H
		STA	ENXPSL,Y
		LDA	ENYPSL,X	;xWZbg
		CLC
		ADC	#0FFE8H
		STA	ENYPSL,Y
;
		LDA	#DM_TSUE0	;(A) <-- fnaimD
		JSR	DM_INSR_X
		LDA	ENXPSL,X	;wWZbg
		CLC
		ADC	#014H
		STA	ENXPSL,Y
		LDA	ENYPSL,X	;xWZbg
		CLC
		ADC	#0FFE8H
		STA	ENYPSL,Y
;
		PLY			;(Y) load
;
DM_BARD0MV_0022 EQU	$
		CPY	<EWORK0
		BEQ	DM_BARD0MV_0030 ;Xs[hύXH ( no:DM_BARD0MV_0030 )
;
		LDA	!BIRD0_ROTSPD,Y
		STA	ENWRK8,X
		PLA
		AND	#0FF00H
		PHA
;
DM_BARD0MV_0030 EQU	$
		PLA			;(A) load
		CMP	#24*100H
		BCC	DM_BARD0MV_0050 ;]p^[l`wH ( no:DM_BARD0MV_0050 )
;
		AND	#00FFH
		ORA	#16*100H
;
DM_BARD0MV_0050 EQU	$
		STA	ENWRK6,X
;
		XBA
		AND	#00FFH
		STA	ENCHPT,X
;
		LDY	<ENWRK2,X
		BEQ	DM_BARD0MV_0100 ;]H ( no:DM_BARD0MV_0100 )
;
;-------------- ]̃u[LOZbg ------------------------------
		LDA	ENXMAX,X
		SEC
		SBC	#01H
		CMP	#010H
		BPL	DM_BARD0MV_0052
		LDA	#010H
DM_BARD0MV_0052 EQU	$
		STA	ENXMAX,X
;
		LDY	#(ENNO-2)*4	;[ -2:REmgȊO ]
DM_BARD0MV_0060 EQU	$
		LDA	ENMODE,Y
		BEQ	DM_BARD0MV_0070 ;fnaiH ( no:DM_BARD0MV_0070 )
		LDA	ENMYNO,Y
		CMP	#DM_KUMO0
		BCC	DM_BARD0MV_0070 ;_H ( no:DM_BARD0MV_0070 )
		CMP	#DM_KUMO2+1
		BCS	DM_BARD0MV_0070 ;_H ( no:DM_BARD0MV_0070 )
;
;-------------- ̃fnai ------------------------------
		LDA	ENXMAX,Y
		EOR	#0FFFFH
		INC	A
;
		M8
;
		STA	211BH
		XBA
		STA	211BH
		LDA	ENXMAX,X
		STA	211CH
		LDA	2134H
		ASL	A		;(C) <-- 0.5
;
		M16
;
		LDA	2135H
		ROL	A		;x2
		EOR	#0FFFFH
		INC	A
		STA	ENXSPD,Y
DM_BARD0MV_0070 EQU	$
		DEY
		DEY
		DEY
		DEY
		BPL	DM_BARD0MV_0060
DM_BARD0MV_0080 EQU	$
		RTS
;
;-------------- ʂ̔ł鎞̏㉺Xs[hZbg --------------------
DM_BARD0MV_0100 EQU	$
		LDA	ENYPSL,X
		CMP	#058H
		BCC	DM_BARD0MV_0110 ;㏸ZbgH ( no:DM_BARD0MV_0110 )
;
		LDA	RANDM0		;㏸^C}[Zbg
		AND	#03H*2
		TAY
		LDA	!FLYUP_TIM,Y
		STA	ENTIM1,X
DM_BARD0MV_0110 EQU	$
		LDY	ENTIM1,X
		BEQ	DM_BARD0MV_0120 ;㏸H ( no:DM_BARD0MV_0120 )
		LDY	#02H
DM_BARD0MV_0120 EQU	$
		LDA	!BIRD0_GPOW,Y	;d̓Zbg
		STA	ENGPOW,X
		STA	ENXPOW,X
		LDA	!BIRD0_GMAX,Y	;ő嗎Xs[hZbg
		STA	ENGMAX,X
		EOR	#0FFFFH
		INC	A
		STA	ENXMAX,X
DM_BARD0MV_0130 EQU	$
		RTS
;
;========================================================================
;=		afLN^[ւ				=
;=			in  : (X) <-- LN^[f[^mD		=
;=			      (A) <-- uq`lAhX			=
;========================================================================
CHAR_CHANGE	EQU	$
		PHA			;uq`lAhX save
;
		I16
;
		TXA			;(A) <-- LN^[f[^mD
		LDX	#WOB7CHR	;(X) <-- 𓀐AhX
		JSL	>UNCOMPRES
		TAY			;(Y) <-- number of byte
;
		LDA	>VRAMDX
		TAX
;
		PLA			;uq`lAhX load
		STA	>(VRAMDX&0FF0000H),X	;VRAM address set
		LDA	#10000000B+(00000001B*100H)
		STA	>(VRAMDX&0FF0000H)+2,X	;inc mode & DMA parameter set
		LDA	#18H+(WOB7CHR*100H)
		STA	>(VRAMDX&0FF0000H)+4,X	;B bus address & A bus address(L) set
		LDA	#WOB7CHR/100H
		STA	>(VRAMDX&0FF0000H)+6,X	;A bus address(H,B) set
		TYA
		STA	>(VRAMDX&0FF0000H)+8,X	;number of byte set
		TXA
		CLC
		ADC	#12
		STA	>(VRAMDX&0FF0000H)+10,X ;next data set address set
		STA	>VRAMDX			;end address set
;
		I8
;
		LDX	<ENINDX
		RTS
;
;========================================================================
;=		fnai  afQ˂afP\֕ύX			=
;=			in  : (A) <-- XN[f[^mD		=
;========================================================================
DORE_CHANGE	EQU	$
;
;-------------- afXN[ ----------------------------------
;
		I16
;
		JSL	>UNCOMPRES_X
		TAY			;(Y) <-- number of byte
;
		LDA	>VRAMDX
		TAX
;
		LDA	SCCV2		;afP̂afQւ
		STA	SCCV1
		STZ	SCCH1
		STZ	ESCCH1
		STZ	SCCV2
		LDA	BG1SCF
		XBA
		STA	BG1SCF
		AND	#0FC00H
		STA	>(VRAMDX&0FF0000H),X	;VRAM address set
		LDA	#10000000B+(00000001B*100H)
		STA	>(VRAMDX&0FF0000H)+2,X	;inc mode & DMA parameter set
		LDA	#18H+((WOB7CHR+1000H)*100H)
		STA	>(VRAMDX&0FF0000H)+4,X	;B bus address & A bus address(L) set
		LDA	#(WOB7CHR+1000H)/100H
		STA	>(VRAMDX&0FF0000H)+6,X	;A bus address(H,B) set
		TYA
		STA	>(VRAMDX&0FF0000H)+8,X	;number of byte set
		TXA
		CLC
		ADC	#12
		STA	>(VRAMDX&0FF0000H)+10,X ;next data set address set
		STA	>VRAMDX			;end address set
;
;-------------- fnai\af؂ւ ------------------------------
;
		I8
;
		LDX	<ENINDX
		LDY	#(ENNO-1)*4
DORE_CHANGE_010 EQU	$
		LDA	ENMODE,Y
		BEQ	DORE_CHANGE_020 ;GZbgH ( no:DORE_CHANGE_020 )
;
		LDA	#00FFH		;[ & LDA #00	  ]
		STA	ENRETN,Y	;[ & STA ENDORE,Y ]
		LDA	ENYUSN,Y
		AND	#0FFFBH
		STA	ENYUSN,Y
		LDA	ENCLOR,Y
		ORA	#030H
		STA	ENCLOR,Y
DORE_CHANGE_020 EQU	$
		DEY
		DEY
		DEY
		DEY
		BPL	DORE_CHANGE_010
		RTS
;
;========================================================================
;=		J[tF[hZbg					=
;========================================================================
COL_FADE_SET	EQU	$
		PHB			;(DBR) save
		LDY	#BANK DATACOL	;(DBR) <-- DATACOL(B)
		PHY
		PLB
;
		LDA	#00		;J[tF[hJE^[Zbg
		STA	>CLFDCNT
;
		LDA	<ENCONT,X
		CLC
		ADC	#15*2
		STA	<ENCONT,X
;
		I16
;
		TAX
;
		LDY	#(15-1)*2
COL_FADE_SET_10 EQU	$
		LDA	DATACOL+(21H*2),Y
		STA	MOTOCOL+(21H*2),Y
		LDA	>COL_ADDRESS+MSCL_COL_1_SKY0+(15-1)*2,X
		STA	CHNGCOL+(21H*2),Y
;
		LDA	DATACOL+(31H*2),Y
		STA	MOTOCOL+(31H*2),Y
		LDA	>COL_ADDRESS+MSCL_COL_1_SEA0+(15-1)*2,X
		STA	CHNGCOL+(31H*2),Y
;
		LDA	DATACOL+(81H*2),Y
		STA	MOTOCOL+(81H*2),Y
		LDA	>COL_ADDRESS+MSCL_COL_1_OBJ0+(15-1)*2,X
		STA	CHNGCOL+(81H*2),Y
;
		DEX
		DEX
		DEY
		DEY
		BPL	COL_FADE_SET_10
;
		I8
;
		LDX	<ENINDX
		PLB
		RTS
;
;========================================================================
;=		afXN[JE^[Zbg			=
;========================================================================
WAVE_X		EQU	$
		WORD	01H,01H,00H,01H,02H,02H,02H,01H
		WORD	02H,03H,01H,02H,03H,03H,02H,03H
		WORD	02H,03H,02H,02H,03H,03H,02H,03H
;
BG_WAVE_SET	EQU	$
		PHB			;(DBR) save
		LDY	#BANK COS	;(DBR) <-- COS(B)
		PHY
		PLB
;
		LDA	SCCH2		;afXN[JE^[Zbg
		STA	>HDMABUF
		LDA	ENWRKC,X
		CLC
		ADC	#02H*2
		AND	#00FFH*2
		STA	ENWRKC,X
;
		I16
;
		TAY
		LDX	#(18H-1)*2
BG_WAVE_SET_10	EQU	$
		LDA	SCCH2
		BNE	BG_WAVE_SET_20	;H ( yes:BG_WAVE_SET_20 )
;
		LDA	!COS,Y
;
		M8
;
		STA	211BH
		XBA
		STA	211BH
		LDA	>WAVE_X,X
		STA	211CH
;
		M16
;
		LDA	SCCH2
		CLC
		ADC	2135H
BG_WAVE_SET_20	EQU	$
		STA	>HDMABUF+2,X
;
		TYA
		SEC
		SBC	#030H*2
		AND	#00FFH*2
		TAY
		DEX
		DEX
		BPL	BG_WAVE_SET_10
;
		I8
;
		LDA	#00010000B	;afQX^[XN[Zbg
		TSB	HD420C
;
		LDX	<ENINDX
		PLB
		RTS
;
;************************************************************************
;*		Zbgi~[WJ̉_ijj			*
;************************************************************************
DM_KUMO1IN	EQU	$
		LDA	#0FEC0H
		BRA	DM_KUMO_INIT
;
;************************************************************************
;*		Zbgi~[WJ̉_ijj			*
;************************************************************************
DM_KUMO2IN	EQU	$
		LDA	#0FFC0H
		BRA	DM_KUMO_INIT
;
;************************************************************************
;*		Zbgi~[WJ̉_ijj			*
;************************************************************************
DM_KUMO0IN	EQU	$
		LDA	#0FC00H
DM_KUMO_INIT	EQU	$
		STA	ENXSPD,X	;_̈ړXs[hZbg
		STA	ENXMAX,X
;
;************************************************************************
;*			  i~[WJ̉_iAAjj		*
;************************************************************************
DM_KUMO0MV	EQU	$
DM_KUMO1MV	EQU	$
DM_KUMO2MV	EQU	$
		LDY	ENDORE,X
		LDA	ESCCH1,Y
		BNE	DM_KUMOMV_000	;[vH ( no:DM_KUMOMV_000 )
		JMP	DM_KUMOMV_020
;
;-------------- _̖̎ւ̕ύX`FbN ------------------------------
DM_KUMOMV_000	EQU	$
		LDA	ENDSXL,X
		BMI	DM_KUMOMV_002	;\H ( no:DM_KUMOMV_002 )
		JMP	DM_KUMOMV_030
;
DM_KUMOMV_002	EQU	$
		LDA	ENXSPD,X
		EOR	#0FFFFH
		LSR	A
		LSR	A
		LSR	A
		ADC	#040H
		TAY
		STY	4202H
		LDY	ENXPSL,X
		STY	4203H
;
;.............. |Z̃EFCg ................................
		LDA	#02FFH		;afQ\
		STA	ENRETN,X
		LDA	ENYUSN,X	;naiD揇ʕύX
		EOR	#04H
		STA	ENYUSN,X
		LDA	ENCHPT,X	;p^[mDύX
		EOR	#01H
		STA	ENCHPT,X
;................................................................
;
		LDA	4216H
		LSR	A
		LSR	A
		LSR	A
		LSR	A
		LSR	A
		LSR	A
		EOR	#0FFFFH
		SEC
		ADC	#0F0H
		STA	ENXPSL,X	;wWăZbg
		INC	<ENWRK0,X
		LDA	<ENWRK0,X
		CMP	#03H
		BCC	DM_KUMOMV_010	;_ ăZbgH ( yes:DM_KUMOMV_010 )
		JSL	>ENCLEAR
		RTS
;
DM_KUMOMV_010	EQU	$
		LSR	A		;(C) <-- ړXs[hύX[h
		BCC	DM_KUMOMV_012
;
		TXA
		AND	#04H
		BEQ	DM_KUMOMV_011	;\ZbgH ( no:DM_KUMOMV_011 )
;
		LDA	ENYUSN,X
		ORA	#0F0H
		STA	ENYUSN,X
DM_KUMOMV_011	EQU	$
		LDA	ENXSPD,X	;ړXs[hύX
		ASR16
		ASR16
		BRA	DM_KUMOMV_014
;
DM_KUMOMV_012	EQU	$
		LDA	ENYUSN,X	;\Zbg
		AND	#0FH
		STA	ENYUSN,X
;
		LDA	ENXSPD,X	;ړXs[hύX
		ASL	A
		ASL	A
DM_KUMOMV_014	EQU	$
		STA	ENXSPD,X
		STA	ENXMAX,X
		LDA	ENCLOR,X	;afD揇ʕύX
		EOR	#030H
		STA	ENCLOR,X
;
DM_KUMOMV_020	EQU	$
		LDA	ENXPSL,X	;[vZbg
		BPL	DM_KUMOMV_030
;
		LDA	#00F0H
		STA	ENXPSL,X
DM_KUMOMV_030	EQU	$
		RTS
;
;
;************************************************************************
;*		Zbgi~[WJ̃JbNiY[jj		*
;************************************************************************
DM_KAMK0IN	EQU	$
		LDA	#1800H		;ŏ{Zbg
		STA	<ENCONT,X
;
;************************************************************************
;*			(~[WJ̃JbNiY[jj		*
;************************************************************************
DM_KAMK0MV	EQU	$
		LDA	SCCH1
		CMP	#0100H
		BCC	DM_KAMEKMV_020	;O̖H ( no:DM_KAMEKMV_020 )
;
		LDA	#0C0H+(10H*100H)
		STA	<EWORK0		;(EWK0,1) <-- ړwCxXs[h
		LDA	#CIPCHD2+1
		STA	R10		;(R10) <-- LN^[AhXikCgj
;
		LDA	<ENCONT,X
		SEC
		SBC	#014H
		CMP	#080H
		BCS	DM_KAMEKMV_010	;ʂ߂H ( no:DM_KAMEKMV_010 )
;
;-------------- fnaiNA[ --------------------------------------
		JSL	>ENCLEAR
;
		LDY	#00000010B	;naiTCYύXiŴPUj
		STY	OBJSEL
;
		LDX	#CHRDA		;(X) <-- LN^[f[^mD
		LDA	#5000H		;(A) <-- uq`lAhX
		JMP	CHAR_CHANGE
;
ZOOM_CHAR_SET	EQU	$
DM_KAMEKMV_010	EQU	$
		STA	<ENCONT,X
		STA	R6		;(R6)  <-- {
;
		CMP	#0480H		;(C) set
;
		LDA	#07H		;\Zbg
		BCS	DM_KAMEKMV_012	 ;naiD揇ʁijH ( no:DM_KAMEKMV_012 )
		LDA	#04H
DM_KAMEKMV_012	EQU	$
		STA	ENYUSN,X
;
		LDA	#BANK CIPCHD2
		STA	R11		;(R11) <-- LN^[AhXiaj
		M_CHIP	C_128_ZOOM_64
;
		LDA	#2000H		;Y[nai]II
		STA	OBM7WF
;
		LDX	<ENINDX
		LDY	#01100010B	;naiTCYύXiPÛRQj
		STY	OBJSEL
;
;-------------- ړXs[hvZ ----------------------------------------
		LDY	R4
		STY	211BH
		LDY	R4+1
		STY	211BH
		LDY	<EWORK0
		STY	211CH
		LDA	2135H
		ASL	A
		STA	ENXSPD,X	;wړXs[hZbg
		LDY	<EWORK1
		STY	211CH
		LDA	2135H
		ASL	A
		STA	ENYSPD,X	;xړXs[hZbg
;
DM_KAMEKMV_020	EQU	$
		RTS
;
;************************************************************************
;*		Zbgi~[WJ̃JbNijj		*
;************************************************************************
DM_KAMK1IN	EQU	$
		LDA	#0F7A0H		;wړXs[hZbg
		STA	ENXSPD,X
;
;************************************************************************
;*			(~[WJ̃JbNijj			*
;************************************************************************
DM_KAMK1MV	EQU	$
		LDA	ENXPSL,X
		BPL	DM_KAMK1MV_010	;fnaiNA[H ( no:DM_KAMK1MV_010 )
;
;-------------- fnaiNA[ --------------------------------------
		JSL	>ENCLEAR
		RTS
;
DM_KAMK1MV_010	EQU	$
		CMP	#0200H
		BPL	DM_KAMK1MV_020	;REmgɓH ( no:DM_KAMK1MV_020 )
;
;-------------- REmg]Zbg ------------------------------------
		LDY	<ENWRK2+BIRD0_IX
		BNE	DM_KAMK1MV_050	;REmg]H ( yes:DM_KAMK1MV_050 )
;
		LDA	#0200H
		STA	ENXPSL,X
		LDY	ENCHPT+BIRD0_IX
		CPY	#12-1
		BNE	DM_KAMK1MV_020	;REmgp^[njH ( no:DM_KAMK1MV_020 )
;
		LDA	#02H		;REmg]tOZbg
		STA	<ENWRK2+BIRD0_IX
		LDA	#080H		;u[LO{Zbg
		STA	ENXMAX+BIRD0_IX
		LDA	#256/1		;]Xs[hZbg
		STA	ENWRK8+BIRD0_IX
		STZ	ENTIM1+BIRD0_IX ;H΂tOZbg
		STZ	ENXSPD+BIRD0_IX ;ړXs[hZbg
		STZ	ENYSPD+BIRD0_IX
		STZ	ENXPOW+BIRD0_IX
		STZ	ENGPOW+BIRD0_IX
;
		LDA	#029H		;p^[؂ւ^C}[Zbg
		STA	ENTIM0,X
DM_KAMK1MV_020	EQU	$
		RTS
;
;-------------- C[WDp^[Zbg ------------------------------
DM_KAMK1MV_050	EQU	$
		LDA	ENTIM0,X
		BNE	DM_KAMK1MV_060	;p^[؂ւH ( no:DM_KAMK1MV_060 )
;
		LDA	#04H
		STA	ENTIM0,X
		LDA	ENCHPT,X
		CMP	#3
		BCS	DM_KAMK1MV_060	;l`wp^[H ( yes:DM_KAMK1MV_060 )
;
		INC	ENCHPT,X
DM_KAMK1MV_060	EQU	$
		RTS
;
;************************************************************************
;*		Zbgi~[WJ̏j				*
;************************************************************************
DM_TSUE0IN	EQU	$
		LDA	#256/2		;]Xs[hZbg
		STA	<ENWRK2,X
		LDA	#080H
		STA	ENXSPD,X
		LDA	#0FC00H		;ړXs[hZbg
		BRA	DM_KOZU0IN_010
;
;************************************************************************
;*		Zbgi~[WJ̏ijj			*
;************************************************************************
DM_KOZU0IN	EQU	$
		LDA	#0FF80H
		STA	ENXSPD,X
		LDA	#0FD00H		;ړXs[hZbg
DM_KOZU0IN_010	EQU	$
		STA	ENYSPD,X
		LDA	#020H		;d̓Zbg
		STA	ENGPOW,X
		LDA	#0300H
		STA	ENGMAX,X
;
;************************************************************************
;*			(~[WJ̏ijj			*
;************************************************************************
DM_KOZU0MV	EQU	$
		RTS
;
;************************************************************************
;*			(~[WJ̏j				*
;************************************************************************
TSUE0_PTN	EQU	$
		WORD	0,   1,	  1,   0,   0,	 1,   1,   0
TSUE0_ATT	EQU	$
		WORD	000H,000H,040H,040H,0C0H,0C0H,080H,080H
;
DM_TSUE0MV	EQU	$
		LDA	<ENWRK4,X
		CLC
		ADC	<ENWRK2,X
		STA	<ENWRK4,X
		XBA
		AND	#07H
		ASL	A
		TAY
		LDA	!TSUE0_PTN,Y	;̃p^[mDZbg
		STA	ENCHPT,X
		LDA	ENCLOR,X
		AND	#003FH
		ORA	!TSUE0_ATT,Y	;̃tbvZbg
		STA	ENCLOR,X
		RTS
;
;************************************************************************
;*		Zbgi~[WJ̏iY[jj		*
;************************************************************************
DM_KOZU1IN	EQU	$
		LDA	#080H		;ő{Zbg
		STA	<ENCONT,X
;
;************************************************************************
;*			(~[WJ̏iY[jj			*
;************************************************************************
DM_KOZU1MV	EQU	$
		LDA	SCCH1
		CMP	#0100H
		BCC	DM_KOZU1MV_020	;O̖H ( no:DM_KOZU1MV_020 )
;
		LDA	#000H+(00H*100H)
		STA	<EWORK0		;(EWK0,1) <-- ړwCxXs[h
		LDA	#CIPCHD2+40H+1
		STA	R10		;(R10) <-- LN^[AhXikCgj
;
		LDA	<ENCONT,X
		CLC
		ADC	#010H
		CMP	#1B00H
		BCC	DM_KOZU1MV_010	;Ă܂H ( no:DM_KOZU1MV_010 )
;
;-------------- fnaiNA[ --------------------------------------
		LDY	ENYUSN,X
		BMI	DM_KOZU1MV_000	;ǉLN^[ZbgH ( yes:DM_KOZU1MV_000 )
;
		DEY			;[ LDA #0FFH ]
		TYA			;
		STA	ENYUSN,X
;
		LDY	#00000010B	;naiTCYύXiŴPUj
		STY	OBJSEL
;
		LDX	#CHRDC		;(X) <-- LN^[f[^mD
		LDA	#4000H		;(A) <-- uq`lAhX
		JMP	CHAR_CHANGE
;
DM_KOZU1MV_000	EQU	$
		JSL	>ENCLEAR
;
		LDX	#CHR09		;(X) <-- LN^[f[^mD
		LDA	#5400H		;(A) <-- uq`lAhX
		JMP	CHAR_CHANGE
;
DM_KOZU1MV_010	EQU	$
		JSR	ZOOM_CHAR_SET
;
DM_KOZU1MV_020	EQU	$
		RTS
;
;
;
;
;
;****************************************************************
;*								*
;*		I[vjO f				*
;*				()			*
;****************************************************************
		MEM16
OPDM_KMLB	EQU	$
		STA	R10
		LDA	#00030H		; px
		STA	R2
		LDA	#00070H
		STA	R3
		LDA	#00090H
		STA	R4
		LDA	#000A0H
		STA	R5
		LDA	#03800H		; EBhE X^[g|Cg
		STA	R6
		LDA	#05800H
		STA	R7
		LDA	#07000H
		STA	R8
		LDA	#08000H
		STA	R9
;
		M_CHIP	OPDM_WINDOW
;
		I16			; index 16bit mode
		JSL	>M_DMA_BFST	; data trans.
		LWORD	HDMABUF2+8	; to address set
		LWORD	HDMABF		; from address set
		WORD	070H*4		; number of byte set
		I8			; index 8bit mode
		RTS
;
		MEM8
;
;
;****************************************************************
;*								*
;*		I[vjO f bZ[W			*
;*					(CjV)		*
;****************************************************************
;
		DPAGE	WORK0
;
OPMSGINITSET	EQU	$
		M16			; memory 16bit mode
		LDX	#000H
		LDA	#01400H
		STA	<WORK0
		LDA	#01800H
		STA	<WORK2
		LDA	#01C00H
		STA	<WORK4
;
OPMSGINITSET_00 EQU	$
		LDA	<WORK0
		STA	!OPMSGBFNK,X
;
		LDA	<WORK2
		STA	!OPMSGBFU0,X
		CLC
		ADC	#00010H
		STA	!OPMSGBFU1,X
		CLC
		ADC	#00010H
		STA	!OPMSGBFU2,X
		CLC
		ADC	#00010H
		STA	!OPMSGBFU3,X
;
		LDA	<WORK4
		STA	!OPMSGBFD0,X
		CLC
		ADC	#00010H
		STA	!OPMSGBFD1,X
		CLC
		ADC	#00010H
		STA	!OPMSGBFD2,X
		CLC
		ADC	#00010H
		STA	!OPMSGBFD3,X
;
		INC	<WORK2
		INC	<WORK4
		INX
		INX
		CPX	#020H
		BCC	OPMSGINITSET_00
;
		LDA	#01840H
		STA	<WORK2
		LDA	#01C40H
		STA	<WORK4
OPMSGINITSET_10 EQU	$
		LDA	<WORK0
		STA	!OPMSGBFNK,X
;
		LDA	<WORK2
		STA	!OPMSGBFU0,X
		CLC
		ADC	#00010H
		STA	!OPMSGBFU1,X
		CLC
		ADC	#00010H
		STA	!OPMSGBFU2,X
		CLC
		ADC	#00010H
		STA	!OPMSGBFU3,X
;
		LDA	<WORK4
		STA	!OPMSGBFD0,X
		CLC
		ADC	#00010H
		STA	!OPMSGBFD1,X
		CLC
		ADC	#00010H
		STA	!OPMSGBFD2,X
		CLC
		ADC	#00010H
		STA	!OPMSGBFD3,X
;
		INC	<WORK2
		INC	<WORK4
		INX
		INX
		CPX	#040H
		BCC	OPMSGINITSET_10
;
		JSR	OPMSGSET_6SB	; kL Zbg!!
;
		LDA	#07E80H
		STA	!OPMSGSCR
		JSR	OPMSGSET_100
;
		INC	!MSGTRF		; cl`]tO nm !!
		LDA	#000A0H
		STA	!OPMSGTIM
		STZ	!OPMSGMOD
		STZ	!OPMSGDTPT
		STZ	!OPMSGSCV
		STZ	!OPMSGBFCT
		STZ	!OPNEXTFG	; V[؂芷tO NA
		LDA	#0FFFFH
		STA	<SCCV4
		LDA	#00000H
		STA	>DATACOL+0E0H+012H
		STA	>DATACOL+0E0H+016H
		STA	>DATACOL+0E0H+01CH
		STA	>DATACOL+0E0H+01EH
;
		M8			; memory 8bit mode
		STZ	!OPMSGMD
;
		RTS
;
;************************************************************************
;*									*
;*		I[vjO f bZ[W				*
;*									*
;************************************************************************
OPMSGSET	EQU	$
		M16			; memory 16bit mode
		LDA	!OPMSGTIM
		BNE	OPMSGSET_PAS0
;
OPMSGSET_SET	EQU	$
		LDA	!OPMSGMOD
		ASL	A
		TAX
		JSR	(OPMSGSET_ADR,X)
		BRA	OPMSGSET_PAS1
;
OPMSGSET_PAS0	EQU	$
		DEC	!OPMSGTIM
OPMSGSET_PAS1	EQU	$
		LDA	!OPMSGMOD
		CMP	#00006H
		BNE	OPMSGSET_PAS2
		LDX	!OPMSGDTPT
		LDA	OPMSGSET_3DT,X
		BEQ	OPMSGSET_END
OPMSGSET_PAS2	EQU	$
		STZ	!OPNEXTFG
OPMSGSET_END	EQU	$
		M8			; memory 8bit mode
		RTS
;
OPMSGSET_ADR	EQU	$
		WORD	OPMSGSET_000,OPMSGSET_100
		WORD	OPMSGSET_200,OPMSGSET_300
		WORD	OPMSGSET_400,OPMSGSET_500
		WORD	OPMSGSET_600
;
		MEM16
;
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+	bZ[W LN^[ CjVcl`]		+
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
OPMSGSET_000	EQU	$
		JSR	OPMSGSET_300
;
		LDA	#07E80H
		STA	!OPMSGSCR
		STZ	!OPMSGBFCT
		LDA	#0FFFFH
		STA	<SCCV4
		STZ	!OPMSGSCV
		RTS
;
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+	bZ[W LN^[ (CjVXN[)	+
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
OPMSGSET_100	EQU	$
		JSR	OPMSGSET_400
		RTS
;
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+		tF[h AEg					+
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
OPMSGSET_200	EQU	$
		LDA	>DATACOL+0E0H+012H
		CLC
		ADC	#00421H
		CMP	#08000H
		BCC	OPMSGSET_250
		LDA	!OPMSGMD
		AND	#000FFH
		ASL	A
		TAX
		LDA	OPMSGSET_TIM,X
		STA	!OPMSGTIM
		INC	!OPMSGMD
		INC	!OPMSGMOD	; MODE INC.
		LDA	#07FFFH
OPMSGSET_250	EQU	$
		STA	>DATACOL+0E0H+012H
		STA	>DATACOL+0E0H+016H
		STA	>DATACOL+0E0H+01CH
		STA	>DATACOL+0E0H+01EH
		RTS
;
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+		bZ[W LN^[ cl`]		+
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
OPMSGSET_300	EQU	$
		LDX	!OPMSGDTPT
		LDA	OPMSGSET_3DT,X
		BEQ	OPMSGSET_350
		CMP	#0FFFFH
		BEQ	OPMSGSET_390
		STA	!OPMSGADR
		LDA	#BANK OPMSGSET_3DT
		STA	!OPMSGADRB
;
		M8			; memory 8bit mode
		LDA	!CIPSCB
		PHA
		LDA	!CIPSCR
		PHA
		LDA	#DM01_MSGBITMP/400H
		STA	!CIPSCB
		LDA	#00111100B
		STA	!CIPSCR
		M16			; memory 16bit mode
;
		M_CHIP	OPMJSET
;
		M8			; memory 8bit mode
		PLA
		STA	!CIPSCR
		PLA
		STA	!CIPSCB
		M16			; memory 16bit mode
;
		INC	!MSGTRF		; cl`]tO nm !!
		INC	!OPMSGMOD	; MODE INC.
		INC	!OPMSGDTPT
		INC	!OPMSGDTPT
		INC	!OPMSGSCV
		INC	!OPMSGSCV
		BRA	OPMSGSET_390
OPMSGSET_350	EQU	$
		LDA	!OPNEXTFG
		BEQ	OPMSGSET_390
		LDA	#00006H
		STA	!OPMSGMOD
OPMSGSET_390	EQU	$
		RTS
;
OPMSGSET_3DT	EQU	$
		WORD	OPMSG_DT00,00000H
;
		WORD	OPMSG_DT10,OPMSG_DT12,OPMSG_DT14,00000H
;
		WORD	OPMSG_DT20,OPMSG_DT22,00000H
;
		WORD	OPMSG_DT30,OPMSG_DT32,00000H
;
		WORD	OPMSG_DT40,OPMSG_DT42,00000H
;
		WORD	OPMSG_DT50,OPMSG_DT52,OPMSG_DT54
		WORD	OPMSG_DT56,OPMSG_DT58,OPMSG_DT5A,00000H
;
		WORD	OPMSG_DT60,OPMSG_DT62,00000H
;
		WORD	OPMSG_DT70,OPMSG_DT72,OPMSG_DT74
		WORD	00000H
;
		WORD	OPMSG_DT80,OPMSG_DT82,00000H
;
		WORD	OPMSG_DT90,0FFFFH
;
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+		bZ[W LN^[ (XN[)	+
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
OPMSGSET_400	EQU	$
		INC	!OPMSGMOD
		I16			; index 16bit mode
		LDA	#BANK OPMSGBFU0
		STA	<WORK1		; (WK1) <-- ]AhX (a)
		LDA	!OPMSGBIG	; 啶 ?
		BEQ	OPMSGSET_430	;	NO -> OPMSGSET_430
;
		LDY	!OPMSGSCR	; (Y) <-- uq`lAhX
		LDX	!OPMSGBFCT
		LDA	OPMSGSET_4DT,X
		TAX			; (X) <-- ]AhX (k,g)
		LDA	#00080H		; (A) <-- ]oCg
		JSL	>VRAMDX_ST
		JSR	OPMSGSET_4SB0
		JSR	OPMSGSET_4SB1
		BRA	OPMSGSET_450
;
OPMSGSET_430	EQU	$
		LDY	!OPMSGSCR	; (Y) <-- uq`lAhX
		LDX	!OPMSGBFCT
		LDA	OPMSGSET_4DT,X
		TAX			; (X) <-- ]AhX (k,g)
		LDA	#00080H		; (A) <-- ]oCg
		JSL	>VRAMDX_ST
		JSR	OPMSGSET_4SB0
		JSR	OPMSGSET_4SB1
;
		LDY	!OPMSGSCR	; (Y) <-- uq`lAhX
		LDX	#OPMSGBFNK	; (X) <-- ]AhX (k,g)
		LDA	#00040H		; (A) <-- ]oCg
		JSL	>VRAMDX_ST
		JSR	OPMSGSET_4SB1
;
OPMSGSET_450	EQU	$
		LDY	!OPMSGSCR	; (Y) <-- uq`lAhX
		LDX	!OPMSGBFCT
		LDA	OPMSGSET_4DT,X
		TAX			; (X) <-- ]AhX (k,g)
		LDA	#00080H		; (A) <-- ]oCg
		JSL	>VRAMDX_ST
		JSR	OPMSGSET_4SB0
		JSR	OPMSGSET_4SB1
;
		LDY	!OPMSGSCR	; (Y) <-- uq`lAhX
		LDX	#OPMSGBFNK	; (X) <-- ]AhX (k,g)
		LDA	#00040H		; (A) <-- ]oCg
		JSL	>VRAMDX_ST
		JSR	OPMSGSET_4SB1
;
		LDA	!OPMSGBIG
		BEQ	OPMSGSET_480
		LDY	!OPMSGSCR	; (Y) <-- uq`lAhX
		LDX	#OPMSGBFNK	; (X) <-- ]AhX (k,g)
		LDA	#00040H		; (A) <-- ]oCg
		JSL	>VRAMDX_ST
		JSR	OPMSGSET_4SB1
;
OPMSGSET_480	EQU	$
		I8			; index 8bit mode
		RTS
;
OPMSGSET_4DT	EQU	$
		WORD	OPMSGBFU0,OPMSGBFU1
		WORD	OPMSGBFU2,OPMSGBFU3
;
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+		XN[	JE^[ INC	+
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
OPMSGSET_4SB0	EQU	$
		LDA	!OPMSGBFCT
		CLC
		ADC	#00002H
		AND	#00007H
		STA	!OPMSGBFCT
;
OPMSGSET_4SB1	EQU	$
		LDA	!OPMSGSCR
		CLC
		ADC	#00020H
		STA	!OPMSGSCR
		AND	#07FF0H
		BNE	OPMSGSET_4SB_PS
		LDA	#07C00H
		STA	!OPMSGSCR
OPMSGSET_4SB_PS EQU	$
		RTS
;
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+		bZ[W XN[ XN[		+
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
OPMSGSET_500	EQU	$
		LDX	!OPMSGSCV
		LDA	<SCCV4
		CLC
		ADC	#00002H
		STA	<SCCV4
		CMP	OPMSGSET_5DT,X
		BCC	OPMSGSET_590
		LDA	OPMSGSET_5DT,X
		STA	<SCCV4
		LDA	#00003
		STA	!OPMSGMOD
		LDA	!OPMSGMD
		AND	#000FFH
		ASL	A
		TAX
		LDA	OPMSGSET_TIM,X
		STA	!OPMSGTIM
		INC	!OPMSGMD
OPMSGSET_590	EQU	$
		RTS
;
OPMSGSET_5DT	EQU	$-2
		WORD	0002FH,0005FH,0008FH,000BFH,000EFH
;
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+		tF[h C					+
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
OPMSGSET_600	EQU	$
		LDA	>DATACOL+0E0H+012H
		SEC
		SBC	#00421H
		BPL	OPMSGSET_650
		INC	!OPMSGDTPT
		INC	!OPMSGDTPT
		JSR	OPMSGSET_6SB
		STZ	!OPMSGMOD	; MODE INC.
		LDA	!OPMSGMD
		AND	#000FFH
		ASL	A
		TAX
		LDA	OPMSGSET_TIM,X
		STA	!OPMSGTIM
		INC	!OPMSGMD
		LDA	#00000H
OPMSGSET_650	EQU	$
		STA	>DATACOL+0E0H+012H
		STA	>DATACOL+0E0H+016H
		STA	>DATACOL+0E0H+01CH
		STA	>DATACOL+0E0H+01EH
		RTS
;
BLACK	EQU	00050H
;
OPMSGSET_TIM	EQU	$
		WORD	00000H,BLACK					;0
		WORD	00180H,00180H,00100H,BLACK			;1
		WORD	000C0H,00100H,BLACK				;2
		WORD	000A0H,001C0H,BLACK				;3
		WORD	00080H,001C0H,BLACK				;4
		WORD	00110H,00110H,00080H,00180H,00180H,001C0H,BLACK ;5
		WORD	001C0H,001C0H,BLACK				;6
		WORD	000A0H,00180H,00180H,BLACK			;7
		WORD	001C0H,001C0H,00050H				;8
		WORD	00000H
;
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+		kL					+
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
OPMSGSET_6SB	EQU	$
		LDA	#BANK OPMSGBFNK
		STA	<WORK1		; (WK1) <-- ]AhX (a)
		I16			; index 16bit mode
;
		LDY	#07E60H		; (Y) <-- uq`lAhX
		LDX	#OPMSGBFNK	; (X) <-- ]AhX (k,g)
		LDA	#00040H		; (A) <-- ]oCg
		JSL	>VRAMDX_ST
;
		LDY	#07E80H		; (Y) <-- uq`lAhX
		LDX	#OPMSGBFNK	; (X) <-- ]AhX (k,g)
		LDA	#00040H		; (A) <-- ]oCg
		JSL	>VRAMDX_ST
;
		LDY	#07EA0H		; (Y) <-- uq`lAhX
		LDX	#OPMSGBFNK	; (X) <-- ]AhX (k,g)
		LDA	#00040H		; (A) <-- ]oCg
		JSL	>VRAMDX_ST
;
		LDY	#07EC0H		; (Y) <-- uq`lAhX
		LDX	#OPMSGBFNK	; (X) <-- ]AhX (k,g)
		LDA	#00040H		; (A) <-- ]oCg
		JSL	>VRAMDX_ST
;
		LDY	#07EE0H		; (Y) <-- uq`lAhX
		LDX	#OPMSGBFNK	; (X) <-- ]AhX (k,g)
		LDA	#00040H		; (A) <-- ]oCg
		JSL	>VRAMDX_ST
;
		I8			; index 8bit mode
		RTS
;
		MEM8
;
;;;;;; opdemo.dat
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	ނAނ̂͂ȂłB		+
;+	}IƃbV[̂͂Ȃł	+
;++++++++++++++++++++++++++++++++++++++++++++++++
OPMSG_DT00	EQU	$
		BYTE	0FEH,000H
		BYTE	0FDH,000H,0FCH,012H
;
		BYTE	H__Mu,H__Ka,H__Si,M_TEN,H__Mu,H__Ka,H__Si,H__No,H___O,H__Ha,H__Na,H__Si,H__De,H__Su,M_MAR
;
;
		BYTE	0FEH,001H
		BYTE	0FDH,008H,0FCH,012H
;
		BYTE	H___A,H__Ka,H__Ti,H__ya,H___N,K__Ma,K__Ri,K___O,H__To,K__Yo,K__tu,K__Si,M__Hi,H__No,H__Ha,H__Na,H__Si,H__De,H__Su
		BYTE	0FFH
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	悠܂̂炢@REmg	+
;+	ĂŁ@Ƃł䂫܂B	+
;++++++++++++++++++++++++++++++++++++++++++++++++
OPMSG_DT10	EQU	$
		BYTE	0FEH,000H
		BYTE	0FDH,000H,0FCH,012H
;
		BYTE	H__Yo,H___A,H__Ke,H__Ma,H___E,H__No,H__Ku,H__Ra,H___I,H__So,H__Ra,H__Wo,M_SPC,K__Ko,K___U,K__No,K__To,K__Ri,H__Ga
;
;
		BYTE	0FEH,001H
		BYTE	0FDH,008H,0FCH,012H
;
		BYTE	H___O,H___O,H___A,H__Wa,H__Te,H__De,M_SPC,H__Su,H__tu,H__To,H___N,H__De,H__Yu,H__Ki,H__Ma,H__Su,M_MAR
		BYTE	0FFH
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	̂΂Ɂ@ӂ̂	+
;+	Ƃ킦ā@@I	+
;++++++++++++++++++++++++++++++++++++++++++++++++
OPMSG_DT12	EQU	$
		BYTE	0FEH,002H
		BYTE	0FDH,010H,0FCH,012H
;
		BYTE	H__So,H__No,H__Ku,H__Ti,H__Ba,H__Si,H__Ni,M_SPC,H__Hu,H__Ta,H__Go,H__No,H___A,H__Ka,H__Ti,H__ya,H___N,H__Wo,M_SPC
;
		BYTE	0FEH,003H
		BYTE	0FDH,018H,0FCH,012H
;
		BYTE	H__Si,H__tu,H__Ka,H__Ri,H__To,H__Ku,H__Wa,H___E,H__Te,M_SPC,H___I,H__So,H__Gu,M_SPC,H___I,H__So,H__Gu,M___X,M_SPC
;
		BYTE	0FFH
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	̂ƂÂ܂Xs[h	+
;+	Ł@ł@ЂƂ̂I	+
;++++++++++++++++++++++++++++++++++++++++++++++++
OPMSG_DT14	EQU	$
		BYTE	0FEH,000H
		BYTE	0FDH,000H,0FCH,012H
;
		BYTE	H__So,H__No,H__To,H__Ki,M_TEN,H__Ku,H__Mo,H__No,H___A,H___I,H__Ma,H__Ka,H__Ra,H__Mo,H___U,K__Su,K__Pi,M__Hi,K__Do
;
		BYTE	0FEH,001H
		BYTE	0FDH,008H,0FCH,012H
;
		BYTE	H__De,M_SPC,H__Tu,H__tu,H__Ko,H___N,H__De,H__Ku,H__Ru,M_SPC,H__Hi,H__To,H__Tu,H__No,H__Ka,H__Ge,H__Ga,M___X,M_SPC
;
		BYTE	0FFH
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	LB[bIEL[I	(啶)	+
;++++++++++++++++++++++++++++++++++++++++++++++++
OPMSG_DT20	EQU	$
		BYTE	0FEH,000H
		BYTE	0FEH,001H
		BYTE	0FDH,000H,0FCH,028H
		BYTE	0FBH
;
		BYTE	K__Ki,K___i,M__Hi,K__tu,M___X,K___U,K__Ki,M__Hi,M___X
;
		BYTE	0FFH
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	̂@[I		+
;++++++++++++++++++++++++++++++++++++++++++++++++
OPMSG_DT22	EQU	$
		BYTE	0FEH,002H
		BYTE	0FEH,003H
		BYTE	0FDH,010H,0FCH,02EH
;
		BYTE	H__So,H__No,H___A,H__Ka,H__Ti,H__ya,H___N,M_SPC,H___I,H__Ta,H__Da,H__Ku,H__Ze,M__Hi,M___X
;
		BYTE	0FFH
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	킠I		(啶)	+
;++++++++++++++++++++++++++++++++++++++++++++++++
OPMSG_DT30	EQU	$
		BYTE	0FEH,000H
		BYTE	0FEH,001H
		BYTE	0FDH,000H,0FCH,038H
		BYTE	0FBH
;
		BYTE	H___U,H__Wa,H___A,H___a,H___a,H__tu,M___X
;
		BYTE	0FFH
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	́Aꂿ܁@	+
;+	Ђā@䂫܂B		+
;++++++++++++++++++++++++++++++++++++++++++++++++
OPMSG_DT32	EQU	$
		BYTE	0FEH,002H
		BYTE	0FDH,010H,0FCH,012H
;
		BYTE	H__So,H___I,H__Tu,H__Ha,M_TEN,H__Su,H__Re,H__Ti,H__Ga,H___I,H__Za,H__Ma,M_SPC,H___A,H__Ka,H__Ti,H__ya,H___N,H__Wo
;
		BYTE	0FEH,003H
		BYTE	0FDH,018H,0FCH,012H
;
		BYTE	H__Hi,H__tu,H__Ta,H__Ku,H__tu,H__Te,M_SPC,H__Yu,H__Ki,H__Ma,H__Si,H__Ta,M_MAR
;
		BYTE	0FFH
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	QQQQEEE	(啶)	+
;++++++++++++++++++++++++++++++++++++++++++++++++
OPMSG_DT40	EQU	$
		BYTE	0FEH,000H
		BYTE	0FEH,001H
		BYTE	0FDH,000H,0FCH,050H
		BYTE	0FBH
;
		BYTE	H___A,H__tu,0D3H,0D3H,0D3H
;
		BYTE	0FFH
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	ȂƂƂł傤B	+
;+	ЂƂ肪Aā@܂܂B	+
;++++++++++++++++++++++++++++++++++++++++++++++++
OPMSG_DT42	EQU	$
		BYTE	0FEH,002H
		BYTE	0FDH,010H,0FCH,012H
;
		BYTE	H__Na,H___N,H__To,H___I,H___U,H__Ko,H__To,H__De,H__Si,H__yo,H___U,M_MAR,H___A,H__Ka,H__Ti,H__ya,H___N,H__No
;
		BYTE	0FEH,003H
		BYTE	0FDH,018H,0FCH,012H
;
		BYTE	H__Hi,H__To,H__Ri,H__Ga,M_TEN,H___O,H__tu,H__Ko,H__Ti,H__Te,M_SPC,H__Si,H__Ma,H___I,H__Ma,H__Si,H__Ta,M_MAR
;
		BYTE	0FFH
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	ۂ@̓bV[AChB	+
;+	bV[@ςł@܂ł	+
;++++++++++++++++++++++++++++++++++++++++++++++++
OPMSG_DT50	EQU	$
		BYTE	0FEH,000H
		BYTE	0FDH,000H,0FCH,012H
;
		BYTE	H___I,H__tu,H__Po,H___U,M_SPC,H__Ko,H__Ko,H__Ha,K__Yo,K__tu,K__Si,M__Hi,K___A,K___I,K__Ra,K___N,K__Do,M_MAR
;
;
		BYTE	0FEH,001H
		BYTE	0FDH,008H,0FCH,012H
;
		BYTE	K__Yo,K__tu,K__Si,M__Hi,H__Ga,M_SPC,H___I,H__tu,H__Pa,H___I,H__Su,H___N,H__De,H__Ru,M_SPC,H__Si,H__Ma,H__De,H__Su
;
		BYTE	0FFH
;
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	҂̃bV[AۂイB	+
;+	́AƂĂ@悢Ă񂫂łB	+
;++++++++++++++++++++++++++++++++++++++++++++++++
OPMSG_DT52	EQU	$
		BYTE	0FEH,002H
		BYTE	0FDH,010H,0FCH,012H
;
		BYTE	H___I,H__tu,H__Pi,H__Ki,H__No,K__Yo,K__tu,K__Si,M__Hi,H__Ga,M_TEN,H___O,H__Sa,H___N,H__Po,H__Ti,H__yu,H___U,M_MAR
;
		BYTE	0FEH,003H
		BYTE	0FDH,018H,0FCH,012H
;
		BYTE	H__Ke,H__Sa,H__Ha,M_TEN,H__To,H__tu,H__Te,H__Mo,M_SPC,H__Yo,H___I,H__Te,H___N,H__Ki,H__De,H__Su,M_MAR
;
		BYTE	0FFH
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	EEEH				+
;++++++++++++++++++++++++++++++++++++++++++++++++
OPMSG_DT54	EQU	$
		BYTE	0FEH,000H
		BYTE	0FEH,001H
		BYTE	0FDH,000H,0FCH,040H
		BYTE	0FBH
;
		BYTE	M_SPC,H___N,H__tu,M___Q
;
		BYTE	0FFH
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	ȂƁ@炩@̂	+
;+	bV[́@ȂɁ@Ă܂B	+
;++++++++++++++++++++++++++++++++++++++++++++++++
OPMSG_DT56	EQU	$
		BYTE	0FEH,002H
		BYTE	0FDH,010H,0FCH,012H
;
		BYTE	H__Na,H___N,H__To,M_SPC,H__So,H__Ra,H__Ka,H__Ra,M_SPC,H__Sa,H__tu,H__Ki,H__No,H___A,H__Ka,H__Ti,H__ya,H___N,H__Ga
;
		BYTE	0FEH,003H
		BYTE	0FDH,018H,0FCH,012H
;
		BYTE	K__Yo,K__tu,K__Si,M__Hi,H__No,M_SPC,H__Se,H__Na,H__Ka,H__Ni,M_SPC,H___O,H__Ti,H__Te,H__Ki,H__Ma,H__Si,H__Ta,M_MAR
;
;
		BYTE	0FFH
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	ǂ@́AԂȂ悤B	+
;+	悩@悩B			+
;++++++++++++++++++++++++++++++++++++++++++++++++
OPMSG_DT58	EQU	$
		BYTE	0FEH,000H
		BYTE	0FDH,000H,0FCH,012H
;
		BYTE	H__Do,H___U,H__Ya,H__Ra,M_SPC,H___A,H__Ka,H__Ti,H__ya,H___N,H__Ha,M_TEN,H__Bu,H__Zi,H__Na,H__Yo,H___U,H__Su,M_MAR
;
		BYTE	0FEH,001H
		BYTE	0FDH,008H,0FCH,012H
;
		BYTE	H__Yo,H__Ka,H__tu,H__Ta,M_SPC,H__Yo,H__Ka,H__tu,H__Ta,M_MAR
;
		BYTE	0FFH
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	HقɂȂɂ@	+
;+	Ɂ@Ă̂EEEB	+
;++++++++++++++++++++++++++++++++++++++++++++++++
OPMSG_DT5A	EQU	$
		BYTE	0FEH,002H
		BYTE	0FDH,010H,0FCH,012H
;
		BYTE	H___O,H__Ya,H__tu,M___Q,H__Ho,H__Ka,H__Ni,H__Mo,H__Na,H__Ni,H__Ya,H__Ra,M_SPC,H___A,H__Ka,H__Ti,H__ya,H___N,H__To
;
		BYTE	0FEH,003H
		BYTE	0FDH,018H,0FCH,012H
;
		BYTE	H___I,H__tu,H__Si,H__yo,H__Ni,M_SPC,H___O,H__Ti,H__Te,H__Ki,H__Ta,H__Mo,H__No,H__Ga,M_MAR
;
		BYTE	0FFH
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	ǂ@́hĥ悤łB	+
;+	REmgAĂ̂H	+
;++++++++++++++++++++++++++++++++++++++++++++++++
OPMSG_DT60	EQU	$
		BYTE	0FEH,000H
		BYTE	0FDH,000H,0FCH,012H
;
		BYTE	H__Do,H___U,H__Ya,H__Ra,M_SPC,H__Ko,H__Re,H__Ha,M__DQ,H__Ti,H__Zu,M__DQ,H__No,H__Yo,H___U,H__De,H__Su,M_MAR
;
		BYTE	0FEH,001H
		BYTE	0FDH,008H,0FCH,012H
;
		BYTE	K__Ko,K___U,K__No,K__To,K__Ri,H__Ga,M_TEN,H__Tu,H__Ka,H__tu,H__Te,H___I,H__Ta,H__Mo,H__No,H__Ka,H__Mo,M___Q
;
		BYTE	0FFH
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	ǃbV[@Ղ񂩂ՂB	+
;+	Ȃ܂Ɓ@񂷂邱Ƃɂ܂B	+
;++++++++++++++++++++++++++++++++++++++++++++++++
OPMSG_DT62	EQU	$
		BYTE	0FEH,002H
		BYTE	0FDH,010H,0FCH,012H
;
		BYTE	H__Da,H__Ke,H__Do,K__Yo,K__tu,K__Si,M__Hi,M_SPC,H__Ti,H___N,H__Pu,H___N,H__Ka,H___N,H__Pu,H___N,M_MAR
;
		BYTE	0FEH,003H
		BYTE	0FDH,018H,0FCH,012H
;
		BYTE	H__Na,H__Ka,H__Ma,H__To,M_SPC,H__So,H___U,H__Da,H___N,H__Su,H__Ru,H__Ko,H__To,H__Ni,H__Si,H__Ma,H__Si,H__Ta,M_MAR
;
		BYTE	0FFH
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	ELbAELL[I	(啶)	+
;++++++++++++++++++++++++++++++++++++++++++++++++
OPMSG_DT70	EQU	$
		BYTE	0FEH,000H
		BYTE	0FEH,001H
		BYTE	0FDH,000H,0FCH,030H
		BYTE	0FBH
;
		BYTE	K___U,K__Ki,K__tu,M_TEN,K___U,K__Ki,K__Ki,M__Hi,M___X
;
		BYTE	0FFH
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	@̂́AJbN	+
;+	Nbp傤ɂށ@܂قB	+
;++++++++++++++++++++++++++++++++++++++++++++++++
OPMSG_DT72	EQU	$
		BYTE	0FEH,002H
		BYTE	0FDH,010H,0FCH,012H
;
		BYTE	H___A,H__Ka,H__Ti,H__ya,H___N,H__Wo,M_SPC,H__Sa,H__Ra,H__tu,H__Ta,H__No,H__Ha,M_TEN,K__Ka,K__Me,K__tu,K__Ku,H__To
;
		BYTE	0FEH,003H
		BYTE	0FDH,018H,0FCH,012H
;
		BYTE	H___I,H___U,K__Ku,K__tu,K__Pa,H__Zi,H__yo,H___U,H__Ni,H__Su,H__Mu,M_SPC,H__Ma,H__Ho,H___U,H__Tu,H__Ka,H___I,M_MAR
;
		BYTE	0FFH
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	@@ЂƂ@ƂĂ̂+
;+	@ā@Ԃɂɂ䂩܂+
;++++++++++++++++++++++++++++++++++++++++++++++++
OPMSG_DT74	EQU	$
		BYTE	0FEH,000H
		BYTE	0FDH,000H,0FCH,012H
;
		BYTE	H___A,H__Ka,H__Ti,H__ya,H___N,H__Wo,M_SPC,H__Hi,H__To,H__Ri,M_SPC,H___O,H__To,H__Si,H__Te,H__Ki,H__Ta,H__No,H__Ni
;
		BYTE	0FEH,001H
		BYTE	0FDH,008H,0FCH,012H
;
		BYTE	H__Ki,H__Ga,H__Tu,H___I,H__Te,M_SPC,H__Ko,H__Bu,H___N,H__Ni,H__Sa,H__Ga,H__Si,H__Ni,H__Yu,H__Ka,H__Se,H__Ma,H__Su
;
		BYTE	0FFH
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	Ȃ܂̂Ƃւނ@bV[ł	+
;+	ǂɂȂ邳@Ɓ@炭Ȃ悤B	+
;++++++++++++++++++++++++++++++++++++++++++++++++
OPMSG_DT80	EQU	$
		BYTE	0FEH,000H
		BYTE	0FDH,000H,0FCH,012H
;
		BYTE	H__Na,H__Ka,H__Ma,H__No,H__To,H__Ko,H__Ro,H__He,H__Mu,H__Ka,H___U,M_SPC,K__Yo,K__tu,K__Si,M__Hi,H__De,H__Su,H__Ga
;
		BYTE	0FEH,001H
		BYTE	0FDH,008H,0FCH,012H
;
		BYTE	H__Do,H___U,H__Ni,H__Ka,H__Na,H__Ru,H__Sa,M_SPC,H__To,M_SPC,H__Ki,H__Ra,H__Ku,H__Na,H__Yo,H___U,H__Su,M_MAR
;
		BYTE	0FFH
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	AJbŃ@܂イ	+
;+	́@䂭Ă܂B	+
;++++++++++++++++++++++++++++++++++++++++++++++++
OPMSG_DT82	EQU	$
		BYTE	0FEH,002H
		BYTE	0FDH,010H,0FCH,012H
;
		BYTE	H__Si,H__Ka,H__Si,M_TEN,K__Ka,K__Me,K__tu,K__Ku,H__Ta,H__Ti,H__Ha,M_SPC,H__Si,H__Ma,H__Zi,H__yu,H___U,H__De
;
		BYTE	0FEH,003H
		BYTE	0FDH,018H,0FCH,012H
;
		BYTE	H___A,H__Ka,H__Ti,H__ya,H___N,H__No,M_SPC,H__Yu,H__Ku,H___E,H__Wo,H___O,H__tu,H__Te,H___I,H__Ma,H__Su,M_MAR
;
		BYTE	0FFH
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	͂ā@ӂ́@́@Ԃ	+
;+	ppƃ}}Ɂ@Ƃǂ̂ł傤	+
;++++++++++++++++++++++++++++++++++++++++++++++++
OPMSG_DT90	EQU	$
		BYTE	0FEH,000H
		BYTE	0FDH,000H,0FCH,012H
;
		BYTE	H__Ha,H__Ta,H__Si,H__Te,M_SPC,H__Hu,H__Ta,H__Ri,H__No,M_SPC,H___A,H__Ka,H__Ti,H__ya,H___N,H__Ha,M_SPC,H__Bu,H__Zi
;
		BYTE	0FEH,001H
		BYTE	0FDH,008H,0FCH,012H
;
		BYTE	K__Pa,K__Pa,H__To,K__Ma,K__Ma,H__Ni,M_SPC,H__To,H__Do,H__Ke,H__Ra,H__Re,H__Ru,H__No,H__De,H__Si,H__yo,H___U,H__Ka
;
		BYTE	0FFH
;;;;K;;;;;++++++++++++++++++++++++++++++++++++++++++++++++
;;;;K;;;;;+	}IA܂܂̂͂ȂłB	+
;;;;K;;;;;+	REmgAĂłƂł܂	+
;;;;K;;;;;++++++++++++++++++++++++++++++++++++++++++++++++
;;;;K;;;;OPMSG_DT00	EQU	$
;;;;K;;;;		BYTE	0FEH,000H
;;;;K;;;;		BYTE	0FDH,000H,0FCH,012H
;;;;K;;;;;
;;;;K;;;;		BYTE	K__Ma,K__Ri,K___O,H__Ga,M_TEN,H___U,H__Ma,H__Re,H__Ru,H__Ma,H___E,H__No,H___O,H__Ha,H__Na,H__Si,H__De,H__Su,M_MAR
;;;;K;;;;;
;;;;K;;;;;
;;;;K;;;;		BYTE	0FEH,001H
;;;;K;;;;		BYTE	0FDH,008H,0FCH,012H
;;;;K;;;;;
;;;;K;;;;		BYTE	K__Ko,K___U,K__No,K__To,K__Ri,H__Ga,M_TEN,H___O,H___O,H___A,H__Wa,H__Te,H__De,H__To,H___N,H__De,H___I,H__Ma,H__Su
;;;;K;;;;		BYTE	0FFH
;;;;K;;;;;
;;;;K;;;;;++++++++++++++++++++++++++++++++++++++++++++++++
;;;;K;;;;;+	́@ӂ̂@悪	+
;;;;K;;;;;+	܂łɁ@ppƃ}}Ɂ@ƂǂȂ΁I	+
;;;;K;;;;;++++++++++++++++++++++++++++++++++++++++++++++++
;;;;K;;;;OPMSG_DT10	EQU	$
;;;;K;;;;		BYTE	0FEH,000H
;;;;K;;;;		BYTE	0FDH,000H,0FCH,012H
;;;;K;;;;;
;;;;K;;;;		BYTE	H__Ko,H__No,M_SPC,H__Hu,H__Ta,H__Go,H__No,H___A,H__Ka,H__Ti,H__ya,H___N,H__Wo,M_SPC,H__Yo,H__Ga,H___A,H__Ke,H__Ru
;;;;K;;;;;
;;;;K;;;;;
;;;;K;;;;		BYTE	0FEH,001H
;;;;K;;;;		BYTE	0FDH,008H,0FCH,012H
;;;;K;;;;;
;;;;K;;;;		BYTE	H__Ma,H__De,H__Ni,M_SPC,K__Pa,K__Pa,H__To,K__Ma,K__Ma,H__Ni,M_SPC,H__To,H__Do,H__Ke,H__Na,H__Ke,H__Re,H__Ba,M___X
;;;;K;;;;		BYTE	0FFH
;;;;K;;;;;
;;;;K;;;;;++++++++++++++++++++++++++++++++++++++++++++++++
;;;;K;;;;;+	̂ƂłAȂɂނĂ܂B	+
;;;;K;;;;;++++++++++++++++++++++++++++++++++++++++++++++++
;;;;K;;;;OPMSG_DT12	EQU	$
;;;;K;;;;		BYTE	0FEH,002H
;;;;K;;;;		BYTE	0FDH,010H,0FCH,012H
;;;;K;;;;;
;;;;K;;;;		BYTE	H__So,H__No,H__To,H__Ki,H__De,H__Su,M_TEN,H__Na,H__Ni,H__Ka,H__Ga,H__Mu,H__Ka,H__tu,H__Te,H__Ki,H__Ma,H__Su,M_MAR
;;;;K;;;;		BYTE	0FFH
;;;;K;;;;;
;;;;K;;;;;++++++++++++++++++++++++++++++++++++++++++++++++
;;;;K;;;;;+	LB[bIEL[I	(啶)	+
;;;;K;;;;;++++++++++++++++++++++++++++++++++++++++++++++++
;;;;K;;;;OPMSG_DT20	EQU	$
;;;;K;;;;		BYTE	0FEH,000H
;;;;K;;;;		BYTE	0FEH,001H
;;;;K;;;;		BYTE	0FDH,000H,0FCH,028H
;;;;K;;;;		BYTE	0FBH
;;;;K;;;;;
;;;;K;;;;		BYTE	K__Ki,K___i,M__Hi,K__tu,M___X,K___U,K__Ki,M__Hi,M___X
;;;;K;;;;;
;;;;K;;;;		BYTE	0FFH
;;;;K;;;;;
;;;;K;;;;;++++++++++++++++++++++++++++++++++++++++++++++++
;;;;K;;;;;+	̂@[I	+
;;;;K;;;;;+	ꂿ܁@Ђ낤Ƃ܂	+
;;;;K;;;;;++++++++++++++++++++++++++++++++++++++++++++++++
;;;;K;;;;OPMSG_DT22	EQU	$
;;;;K;;;;		BYTE	0FEH,002H
;;;;K;;;;		BYTE	0FDH,010H,0FCH,012H
;;;;K;;;;;
;;;;K;;;;		BYTE	H__So,H__Ko,H__No,H___A,H__Ka,H__Ti,H__ya,H___N,M_SPC,H___I,H__Ta,H__Da,H__Ku,H__Ze,M__Hi,M___X
;;;;K;;;;;
;;;;K;;;;		BYTE	0FEH,003H
;;;;K;;;;		BYTE	0FDH,018H,0FCH,012H
;;;;K;;;;;
;;;;K;;;;		BYTE	H__Su,H__Re,H__Ti,H__Ga,H___I,H__Za,H__Ma,M_SPC,H__Hi,H__tu,H__Ta,H__Ku,H__Ro,H___U,H__To,H__Si,H__Ma,H__Si,H__Ta
;;;;K;;;;;
;;;;K;;;;		BYTE	0FFH
;;;;K;;;;;
;;;;K;;;;;++++++++++++++++++++++++++++++++++++++++++++++++
;;;;K;;;;;+	킠I		(啶)	+
;;;;K;;;;;++++++++++++++++++++++++++++++++++++++++++++++++
;;;;K;;;;OPMSG_DT30	EQU	$
;;;;K;;;;		BYTE	0FEH,000H
;;;;K;;;;		BYTE	0FEH,001H
;;;;K;;;;		BYTE	0FDH,000H,0FCH,038H
;;;;K;;;;		BYTE	0FBH
;;;;K;;;;;
;;;;K;;;;		BYTE	H___U,H__Wa,H___A,H___a,H___a,H__tu,M___X
;;;;K;;;;;
;;;;K;;;;		BYTE	0FFH
;;;;K;;;;;
;;;;K;;;;;++++++++++++++++++++++++++++++++++++++++++++++++
;;;;K;;;;;+	QQQQEEE	(啶)	+
;;;;K;;;;;++++++++++++++++++++++++++++++++++++++++++++++++
;;;;K;;;;OPMSG_DT40	EQU	$
;;;;K;;;;		BYTE	0FEH,000H
;;;;K;;;;		BYTE	0FEH,001H
;;;;K;;;;		BYTE	0FDH,000H,0FCH,050H
;;;;K;;;;		BYTE	0FBH
;;;;K;;;;;
;;;;K;;;;		BYTE	H___A,H__tu,0D3H,0D3H,0D3H
;;;;K;;;;;
;;;;K;;;;		BYTE	0FFH
;;;;K;;;;;
;;;;K;;;;;++++++++++++++++++++++++++++++++++++++++++++++++
;;;;K;;;;;+	񂪁@ӂ@Ƃ͂Ȃ	+
;;;;K;;;;;+	̂Ł@ЂƂ@ƂĂ܂܂B	+
;;;;K;;;;;++++++++++++++++++++++++++++++++++++++++++++++++
;;;;K;;;;OPMSG_DT42	EQU	$
;;;;K;;;;		BYTE	0FEH,002H
;;;;K;;;;		BYTE	0FDH,010H,0FCH,012H
;;;;K;;;;;
;;;;K;;;;		BYTE	H___A,H__Ka,H__Ti,H__ya,H___N,H__Ga,M_SPC,H__Hu,H__Ta,H__Go,M_SPC,H__To,H__Ha,H__Si,H__Ra,H__Na,H__Ka,H__tu,H__Ta
;;;;K;;;;;
;;;;K;;;;;
;;;;K;;;;		BYTE	0FEH,003H
;;;;K;;;;		BYTE	0FDH,018H,0FCH,012H
;;;;K;;;;;
;;;;K;;;;		BYTE	H__No,H__De,M_SPC,H__Hi,H__To,H__Ri,H__Wo,M_SPC,H___O,H__To,H__Si,H__Te,H__Si,H__Ma,H___I,H__Ma,H__Si,H__Ta,M_MAR
;;;;K;;;;;
;;;;K;;;;		BYTE	0FFH
;;;;K;;;;;
;;;;K;;;;;++++++++++++++++++++++++++++++++++++++++++++++++
;;;;K;;;;;+	ۂ@̓bV[AChB	+
;;;;K;;;;;+	bV[@ςł@܂ł	+
;;;;K;;;;;++++++++++++++++++++++++++++++++++++++++++++++++
;;;;K;;;;OPMSG_DT50	EQU	$
;;;;K;;;;		BYTE	0FEH,000H
;;;;K;;;;		BYTE	0FDH,000H,0FCH,012H
;;;;K;;;;;
;;;;K;;;;		BYTE	H___I,H__tu,H__Po,H___U,M_SPC,H__Ko,H__Ko,H__Ha,K__Yo,K__tu,K__Si,M__Hi,K___A,K___I,K__Ra,K___N,K__Do,M_MAR
;;;;K;;;;;
;;;;K;;;;;
;;;;K;;;;		BYTE	0FEH,001H
;;;;K;;;;		BYTE	0FDH,008H,0FCH,012H
;;;;K;;;;;
;;;;K;;;;		BYTE	K__Yo,K__tu,K__Si,M__Hi,H__Ga,M_SPC,H___I,H__tu,H__Pa,H___I,H__Su,H___N,H__De,H__Ru,M_SPC,H__Si,H__Ma,H__De,H__Su
;;;;K;;;;;
;;;;K;;;;		BYTE	0FFH
;;;;K;;;;;
;;;;K;;;;;
;;;;K;;;;;++++++++++++++++++++++++++++++++++++++++++++++++
;;;;K;;;;;+	҂̃bV[@ۂĂ܂B	+
;;;;K;;;;;+	Ȃɂ@肻ȁ@񂶂łB	+
;;;;K;;;;;++++++++++++++++++++++++++++++++++++++++++++++++
;;;;K;;;;OPMSG_DT52	EQU	$
;;;;K;;;;		BYTE	0FEH,002H
;;;;K;;;;		BYTE	0FDH,010H,0FCH,012H
;;;;K;;;;;
;;;;K;;;;		BYTE	H___I,H__tu,H__Pi,H__Ki,H__No,K__Yo,K__tu,K__Si,M__Hi,H__Ga,M_SPC,H__Sa,H___N,H__Po,H__Si,H__Te,H__Ma,H__Su,M_MAR
;;;;K;;;;;
;;;;K;;;;;
;;;;K;;;;		BYTE	0FEH,003H
;;;;K;;;;		BYTE	0FDH,018H,0FCH,012H
;;;;K;;;;;
;;;;K;;;;		BYTE	H__Na,H__Ni,H__Ka,H__Ga,M_SPC,H___O,H__Ko,H__Ri,H__So,H___U,H__Na,M_SPC,H__Ka,H___N,H__Zi,H__De,H__Su,M_MAR
;;;;K;;;;;
;;;;K;;;;		BYTE	0FFH
;;;;K;;;;;
;;;;K;;;;;++++++++++++++++++++++++++++++++++++++++++++++++
;;;;K;;;;;+	ȂƁ@炩@̂	+
;;;;K;;;;;+	bV[́@ȂɁ@Ă܂B	+
;;;;K;;;;;++++++++++++++++++++++++++++++++++++++++++++++++
;;;;K;;;;OPMSG_DT54	EQU	$
;;;;K;;;;		BYTE	0FEH,000H
;;;;K;;;;		BYTE	0FDH,000H,0FCH,012H
;;;;K;;;;;
;;;;K;;;;		BYTE	H__Na,H___N,H__To,M_SPC,H__So,H__Ra,H__Ka,H__Ra,M_SPC,H__Sa,H__tu,H__Ki,H__No,H___A,H__Ka,H__Ti,H__ya,H___N,H__Ga
;;;;K;;;;;
;;;;K;;;;		BYTE	0FEH,001H
;;;;K;;;;		BYTE	0FDH,008H,0FCH,012H
;;;;K;;;;;
;;;;K;;;;		BYTE	K__Yo,K__tu,K__Si,M__Hi,H__No,M_SPC,H__Se,H__Na,H__Ka,H__Ni,M_SPC,H___O,H__Ti,H__Te,H__Ki,H__Ma,H__Si,H__Ta,M_MAR
;;;;K;;;;;
;;;;K;;;;;
;;;;K;;;;		BYTE	0FFH
;;;;K;;;;;
;;;;K;;;;;++++++++++++++++++++++++++++++++++++++++++++++++
;;;;K;;;;;+	肹ȂɂȂł܂Ă	+
;;;;K;;;;;+	̂́@Ȃ񂾂낤B	+
;;;;K;;;;;++++++++++++++++++++++++++++++++++++++++++++++++
;;;;K;;;;OPMSG_DT56	EQU	$
;;;;K;;;;		BYTE	0FEH,002H
;;;;K;;;;		BYTE	0FDH,010H,0FCH,012H
;;;;K;;;;;
;;;;K;;;;		BYTE	H__Su,H__tu,H__Ka,H__Ri,H__Se,H__Na,H__Ka,H__Ni,M_SPC,H__Na,H__Zi,H___N,H__De,H__Si,H__Ma,H__tu,H__Te,H___I,H__Ru
;;;;K;;;;;
;;;;K;;;;		BYTE	0FEH,003H
;;;;K;;;;		BYTE	0FDH,018H,0FCH,012H
;;;;K;;;;;
;;;;K;;;;		BYTE	H__Ko,H__No,H___A,H__Ka,H__Ti,H__ya,H___N,H__Ha,M_SPC,H___I,H__tu,H__Ta,H___I,H__Na,H___N,H__Da,H__Ro,H___U,M_MAR
;;;;K;;;;;
;;;;K;;;;		BYTE	0FFH
;;;;K;;;;;
;;;;K;;;;;++++++++++++++++++++++++++++++++++++++++++++++++
;;;;K;;;;;+	̂Ɓgh@Ă܂B	+
;;;;K;;;;;+	̓LmŔ@̂悤	+
;;;;K;;;;;++++++++++++++++++++++++++++++++++++++++++++++++
;;;;K;;;;OPMSG_DT58	EQU	$
;;;;K;;;;		BYTE	0FEH,000H
;;;;K;;;;		BYTE	0FDH,000H,0FCH,012H
;;;;K;;;;;
;;;;K;;;;		BYTE	H__So,H__No,H___A,H__To,M_RDQ,H__Ti,H__Zu,M__DQ,H__Mo,M_SPC,H___O,H__Ti,H__Te,H__Ki,H__Ma,H__Si,H__Ta,M_MAR
;;;;K;;;;;
;;;;K;;;;		BYTE	0FEH,001H
;;;;K;;;;		BYTE	0FDH,008H,0FCH,012H
;;;;K;;;;;
;;;;K;;;;		BYTE	H__Ko,H__Re,H__Ha,K__Ki,K__No,K__Ko,H___O,H___U,H__Ko,H__Ku,H__No,M_SPC,H__Ti,H__Zu,H__No,H__Yo,H___U,H__Da
;;;;K;;;;;
;;;;K;;;;		BYTE	0FFH
;;;;K;;;;;
;;;;K;;;;;++++++++++++++++++++++++++++++++++++++++++++++++
;;;;K;;;;;+	܂݂̂ȂŁ@킹āA	+
;;;;K;;;;;+	̂@͂łȂ	+
;;;;K;;;;;++++++++++++++++++++++++++++++++++++++++++++++++
;;;;K;;;;OPMSG_DT60	EQU	$
;;;;K;;;;		BYTE	0FEH,000H
;;;;K;;;;		BYTE	0FDH,000H,0FCH,012H
;;;;K;;;;;
;;;;K;;;;		BYTE	H__Si,H__Ma,H__No,H__Mi,H___N,H__Na,H__De,M_SPC,H__Ti,H__Ka,H__Ra,H__Wo,H___A,H__Wa,H__Se,H__Te,M_TEN
;;;;K;;;;;
;;;;K;;;;		BYTE	0FEH,001H
;;;;K;;;;		BYTE	0FDH,008H,0FCH,012H
;;;;K;;;;;
;;;;K;;;;		BYTE	H__Ko,H__No,H___A,H__Ka,H__Ti,H__ya,H___N,H__Wo,M_SPC,H__Ha,H__Ko,H___N,H__De,H__Ya,H__Ra,H__Na,H__Ke,H__Re,H__Ba
;;;;K;;;;;
;;;;K;;;;		BYTE	0FFH
;;;;K;;;;;
;;;;K;;;;;++++++++++++++++++++++++++++++++++++++++++++++++
;;;;K;;;;;+	bV[́@܂イ́@Ȃ܂	+
;;;;K;;;;;+	@[邱ɂ܂B	+
;;;;K;;;;;++++++++++++++++++++++++++++++++++++++++++++++++
;;;;K;;;;OPMSG_DT62	EQU	$
;;;;K;;;;		BYTE	0FEH,002H
;;;;K;;;;		BYTE	0FDH,010H,0FCH,012H
;;;;K;;;;;
;;;;K;;;;		BYTE	K__Yo,K__tu,K__Si,M__Hi,H__Ha,M_SPC,H__Si,H__Ma,H__Zi,H__yu,H___U,H__No,M_SPC,H__Na,H__Ka,H__Ma,H__De
;;;;K;;;;;
;;;;K;;;;		BYTE	0FEH,003H
;;;;K;;;;		BYTE	0FDH,018H,0FCH,012H
;;;;K;;;;;
;;;;K;;;;		BYTE	H___A,H__Ka,H__Ti,H__ya,H___N,H__Wo,M_SPC,K__Ri,K__Re,M__Hi,H__Su,H__Ru,H__Ko,H__To,H__Ni,H__Si,H__Ma,H__Si,H__Ta
;;;;K;;;;;
;;;;K;;;;		BYTE	0FFH
;;;;K;;;;;
;;;;K;;;;;++++++++++++++++++++++++++++++++++++++++++++++++
;;;;K;;;;;+	ELbAELL[I	(啶)	+
;;;;K;;;;;++++++++++++++++++++++++++++++++++++++++++++++++
;;;;K;;;;OPMSG_DT70	EQU	$
;;;;K;;;;		BYTE	0FEH,000H
;;;;K;;;;		BYTE	0FEH,001H
;;;;K;;;;		BYTE	0FDH,000H,0FCH,030H
;;;;K;;;;		BYTE	0FBH
;;;;K;;;;;
;;;;K;;;;		BYTE	K___U,K__Ki,K__tu,M_TEN,K___U,K__Ki,K__Ki,M__Hi,M___X
;;;;K;;;;;
;;;;K;;;;		BYTE	0FFH
;;;;K;;;;;
;;;;K;;;;;++++++++++++++++++++++++++++++++++++++++++++++++
;;;;K;;;;;+	܂ق̃JbŃA	+
;;;;K;;;;;+	ӂƂ@䂤@łȂ̂	+
;;;;K;;;;;++++++++++++++++++++++++++++++++++++++++++++++++
;;;;K;;;;OPMSG_DT72	EQU	$
;;;;K;;;;		BYTE	0FEH,002H
;;;;K;;;;		BYTE	0FDH,010H,0FCH,012H
;;;;K;;;;;
;;;;K;;;;		BYTE	H__Ma,H__Ho,H___U,H__Tu,H__Ka,H___I,H__No,K__Ka,K__Me,K__tu,K__Ku,H__Ha,M_TEN,H___A,H__Ka,H__Ti,H__ya,H___N,H__Wo
;;;;K;;;;;
;;;;K;;;;		BYTE	0FEH,003H
;;;;K;;;;		BYTE	0FDH,018H,0FCH,012H
;;;;K;;;;;
;;;;K;;;;		BYTE	H__Hu,H__Ta,H__Ri,H__To,H__Mo,M_SPC,H__Yu,H___U,H__Ka,H___I,M_SPC,H__De,H__Ki,H__Na,H__Ka,H__tu,H__Ta,H__No,H__De
;;;;K;;;;;
;;;;K;;;;		BYTE	0FFH
;;;;K;;;;;
;;;;K;;;;;++++++++++++++++++++++++++++++++++++++++++++++++
;;;;K;;;;;+	@Ԃ񂽂ɁÃNbp傤	+
;;;;K;;;;;+	@Ă悤Ɂ@߂ꂢ܂B	+
;;;;K;;;;;++++++++++++++++++++++++++++++++++++++++++++++++
;;;;K;;;;OPMSG_DT74	EQU	$
;;;;K;;;;		BYTE	0FEH,000H
;;;;K;;;;		BYTE	0FDH,000H,0FCH,012H
;;;;K;;;;;
;;;;K;;;;		BYTE	M_SPC,H__Ko,H__Bu,H___N,H__Ta,H__Ti,H__Ni,M_TEN,H__Ko,H__No,K__Ku,K__tu,K__Pa,H__Zi,H__yo,H___U,H__He
;;;;K;;;;;
;;;;K;;;;		BYTE	0FEH,001H
;;;;K;;;;		BYTE	0FDH,008H,0FCH,012H
;;;;K;;;;;
;;;;K;;;;		BYTE	M_SPC,H__Tu,H__Re,H__Te,H__Ku,H__Ru,H__Yo,H___U,H__Ni,M_SPC,H__Me,H___I,H__Re,H___I,H__Si,H__Ma,H__Si,H__Ta,M_MAR
;;;;K;;;;;
;;;;K;;;;		BYTE	0FFH
;;;;K;;;;;
;;;;K;;;;;++++++++++++++++++++++++++++++++++++++++++++++++
;;;;K;;;;;+	炭@ЂƂ́@	+
;;;;K;;;;;+	Nbp傤B͂₭Ȃ	+
;;;;K;;;;;++++++++++++++++++++++++++++++++++++++++++++++++
;;;;K;;;;OPMSG_DT80	EQU	$
;;;;K;;;;		BYTE	0FEH,000H
;;;;K;;;;		BYTE	0FDH,000H,0FCH,012H
;;;;K;;;;;
;;;;K;;;;		BYTE	H___O,H__So,H__Ra,H__Ku,M_SPC,H__Mo,H___U,H__Hi,H__To,H__Ri,H__No,M_SPC,H___A,H__Ka,H__Ti,H__ya,H___N,H__Ha
;;;;K;;;;;
;;;;K;;;;		BYTE	0FEH,001H
;;;;K;;;;		BYTE	0FDH,008H,0FCH,012H
;;;;K;;;;;
;;;;K;;;;		BYTE	K__Ku,K__tu,K__Pa,H__Zi,H__yo,H___U,M_MAR,H__Ha,H__Ya,H__Ku,H__Ta,H__Su,H__Ke,H__Da,H__Sa,H__Na,H__Ke,H__Re,H__Ba
;;;;K;;;;;
;;;;K;;;;		BYTE	0FFH
;;;;K;;;;;
;;;;K;;;;;++++++++++++++++++++++++++++++++++++++++++++++++
;;;;K;;;;;+	AJbŃ@܂イ	+
;;;;K;;;;;+	ȁ@Ȃ@Ă悤ł	+
;;;;K;;;;;++++++++++++++++++++++++++++++++++++++++++++++++
;;;;K;;;;OPMSG_DT82	EQU	$
;;;;K;;;;		BYTE	0FEH,002H
;;;;K;;;;		BYTE	0FDH,010H,0FCH,012H
;;;;K;;;;;
;;;;K;;;;		BYTE	H__Si,H__Ka,H__Si,M_TEN,K__Ka,K__Me,K__tu,K__Ku,H__Ta,H__Ti,H__Ha,M_SPC,H__Si,H__Ma,H__Zi,H__yu,H___U,H__Ni
;;;;K;;;;;
;;;;K;;;;		BYTE	0FEH,003H
;;;;K;;;;		BYTE	0FDH,018H,0FCH,012H
;;;;K;;;;;
;;;;K;;;;		BYTE	H___I,H__Ro,H___N,H__Na,M_SPC,H__Wa,H__Na,H__Wo,M_SPC,H__Tu,H__Ku,H__tu,H__Te,H___I,H__Ru,H__Yo,H___U,H__De,H__Su
;;;;K;;;;;
;;;;K;;;;		BYTE	0FFH
;;;;K;;;;;
;;;;K;;;;;++++++++++++++++++++++++++++++++++++++++++++++++
;;;;K;;;;;+	͂ā@ӂ́@́@Ԃ	+
;;;;K;;;;;+	ppƃ}}Ɂ@Ƃǂ̂ł傤	+
;;;;K;;;;;++++++++++++++++++++++++++++++++++++++++++++++++
;;;;K;;;;OPMSG_DT90	EQU	$
;;;;K;;;;		BYTE	0FEH,000H
;;;;K;;;;		BYTE	0FDH,000H,0FCH,012H
;;;;K;;;;;
;;;;K;;;;		BYTE	H__Ha,H__Ta,H__Si,H__Te,M_SPC,H__Hu,H__Ta,H__Ri,H__No,M_SPC,H___A,H__Ka,H__Ti,H__ya,H___N,H__Ha,M_SPC,H__Bu,H__Zi
;;;;K;;;;;
;;;;K;;;;		BYTE	0FEH,001H
;;;;K;;;;		BYTE	0FDH,008H,0FCH,012H
;;;;K;;;;;
;;;;K;;;;		BYTE	K__Pa,K__Pa,H__To,K__Ma,K__Ma,H__Ni,M_SPC,H__To,H__Do,H__Ke,H__Ra,H__Re,H__Ru,H__No,H__De,H__Si,H__yo,H___U,H__Ka
;;;;K;;;;;
;;;;K;;;;		BYTE	0FFH
;
;
;;;;;; opdemo.dat END
;
		END
