;************************************************************************
;*									*
;*	title name	: "yossy"					*
;*	proccess	: mini						*
;*	file name	: ys_mini					*
;*									*
;************************************************************************
;
;
		SALL
;
		include		ys_header.inc
		include		ys_color.h
		include		../union/ys_mapobj.h
		include		ys_presno.h
		include		ys_pld.h
;
		XALL
;
;
;
;------------------------------------------------------------------------
;-		global symbol						-
;------------------------------------------------------------------------
;
		GLB	TAKE,MN0,MN3
		GLB	MINIINIT,MINIPLAY,MHDPLY
		GLB	M_LIFIN,M_LIFMV
		GLB	M_DR2IN,M_DR2MV
		GLB	M_FUSIN,M_FUSMV
;
		GLB	BACK_GAME
;
		GLB	MHDPLY_JSL
		GLB	MFSMOV,MFSWIT,MFSCST,MFSFLY,MFSBOM,MFSBM0,MFSBM1
		GLB	MFSBM2,MFSBM3,MFSBM4,MFSBM5,MFSBM6,MFSBM7,MBMCST
		GLB	MENMOV,MENWIT,MENKEY,ENKYCK,MENJMP,MENDIE,MENWIN
		GLB	MENTST,MPLCST,MPLMOV,MPLWIT,MPLKEY,MPLJMP,MPLDIE
		GLB	MPLWIN,MEPIYO,FSBUYO,GCALCY,GCALCX,KOBJST,MBG2TR
		GLB	MHDWIT,MHDINT,MHDSCR,MBGMSG,KYBGCL,KEYSET,KEYBGW
		GLB	PLKYCK,KYENBG,MCSRST,BADCST,KYTMPT,MATSET,WINDON
		GLB	FUSNPY,PLVSLF,M3KOJ0,M3KOJ1,M3KOJ2,MFSDRL,MFSDRR
		GLB	MFSDRP,MFSREC,MFSLFR,MFSLFP,MFSRIR,MFSRIP,MFSRID
		GLB	MFSPAN,ATAHAZ,MFSSTP,PLVSFS,SIRICK,DR2PIY,DRVSPL
		GLB	DRVSFS,DRCHST,DRVSLF,DRFMCK,DR2FSR,DR2PSR,DRSRCH
		GLB	KEYBGWE,KYENBGE,SHIRIGAME,PLVSLF_SUB,WINDOFF,PLVSFS_SUB
;
;------------------------------------------------------------------------
;-		extern symbol						-
;-------------< SOUND	>------------------------------------------------
		EXT	SOUND_3_ON
;------------------------------------------------------------------------
		EXT	DOSN0,EXINSR,DUST0
;-------------< ys_main >------------------------------------------------
		EXT	VRAMCL,URAMCLR,SOUND_TR_2,RANDAM,OAMDXCLR
		EXT	VMADSPL
;
		EXT	MINPL,GMIN,B3CL,HMPIN
;
;-------------< ys_save >------------------------------------------------
		EXT	SVDTSV
;
;-------------< ys_play >------------------------------------------------
		EXT	PLCSET,PLAYER
;
;-------------< ys_enmy >------------------------------------------------
		EXT	ENCSET_DM,ENRAMCLR,ENEMY_IN,ENINSR2_I,ENINSR_I,ENINSR,ENCLEAR
		EXT	M_LIF,M_DR2,M_FUS,M_HAZ,M_ATA,M_ATK,M_HZK
		EXT	TROBJ_PLOT_X,TROBJ_PLOT_Y
		EXT	TROBJ_OAM_4x4,TROBJ_SR_4x4
;;;;;		EXT	FSMK0_SET2,FSMK0
		EXT	PDON0ST_2
;
;-------------< ys_enmy3 >-----------------------------------------------
		EXT	KIRAKIRA_SET
;
;-------------< ys_rpro >------------------------------------------------
		EXT	CHIPON,CHIPON_SPECIAL
;
;-------------< ys_init >------------------------------------------------
		EXT	GMMDST,VRAMDX_ST,MINICHRST,MINICOLSET,DIVDTST
		EXT	UNCOMPRES_X,VRAMDX_ST
;
		EXT	BONUS1
;
		EXT	MINIT
;
;-------------< ys_mini1 >-----------------------------------------------
		EXT	MINIINT1_2,MINIMOV1_2,MINIINT1_4,MINIMOV1_4
		EXT	MINIINT1_5,MINIMOV1_5,MINIINT1_6,MINIMOV1_6
		EXT	MINIINT1_7,MINIMOV1_7
;
		EXT	ITST1,M_ITM,ITST2,IT1UP
;
;-------------< ys_exst >-----------------------------------------------
		EXT	M_HZKIN
;-------------< ys_game >------------------------------------------------
		EXT	MSGDSP,GMURAMCLR,INHDMA
;
;-------------< ys_chr >-------------------------------------------------
		EXT	ADDSTART
;
;------------------------------------------------------------------------
;-		define symbol						-
;------------------------------------------------------------------------
;
;
;
;************************************************************************
;*									*
;*		program start						*
;*									*
;************************************************************************
;
;
;
		EXTEND
;
;
		MEM8
		IDX8
;
Group_11	GROUP	Mini_pro
Mini_pro	SECT	REL
;
;----------------------------------------------------------------
;
;
;
;****************************************************************
;*								*
;*		~j Q[ CjV Zbg			*
;*								*
;****************************************************************
;
;
MINIINIT	EQU	$
		MI8			; memory , index 8bit mode
;
		JSL	>WINDOFF
		JSL	>VRAMCL		; V-ram clear !!
		JSL	>GMURAMCLR	; use RAM clear !!
		JSL	>ENRAMCLR	; enmy ram clear !!
		JSL	>OAMDXCLR	; OAM delax clear !!
;
		M16			; memory 16bit mode
		LDX	#CORSNO-NUKINO
MN_INT_CLS	EQU	$
		STZ	!GMSTATUS,X
		DEX
		DEX
		BPL	MN_INT_CLS
		STZ	!ITEMNO
		M8			; memory 8bit mode
;
;--------------- LN^[ Zbg ----------------------------
		LDA	!MINIMD
		LSR	A
		TAY
		JSL	>MINICHRST
;
;--------------- [h Zbg ----------------------------------
		LDX	#BONUS1
		JSL	>GMMDST
;
;-------------- gcl`p[^Zbg ------------------------
		JSL	>INHDMA
;
;-------------- q`lCjVZbg --------------------------
		MI16			; memory , index 16bit mode
;
		LDA	#00020H
		STA	PLPRIO
		LDA	#4000H
		STA	WRSCH1
		STA	WRSCV1
;
		LDY	#(ENNO-1)*4
		LDA	#0
INITIAL1_150
		STA	!ENMYNO,Y
		DEY
		DEY
		DEY
		DEY
		BPL	INITIAL1_150
;
;-------------- J[ Zbg -----------------------------------
		LDY	!MINIMD
		JSL	>MINICOLSET
		MEM8
		IDX8
;
;-------------- afRXN[ NA -------------------------
		LDA	#B3CL
		STA	!VRFLG
		JSL	>VMADSPL
;
;-------------- TEhvO]i~jQ[j --------------
;;;;K;;;;		LDX	#006		;(X) <-- TEhvO]e[umD
;;;;K;;;;		JSL	>SOUND_TR_2
;
		LDA	#02H
		STA	!SOUND_0		;[]
;
		STZ	!GM_SOUND_0
;
		LDX	MINIMD
		JSR	(INITADR,X)
;
		M16			; memory 16 bit mode !!
;
		LDA	#8000H
		STA	!BABYNO		; vC[Ȃ[h
		STZ	EGGPNT		;^}SIvVLZ
		INC	MINI_GAME_FG	; 𐶂܂ȂtO
;
		M_CHIP	DX_OAM
;
		LDA	!MINIMD		; bZ[VJm. Zbg
		LSR	A
		CLC
		ADC	#4*12*6
		STA	>MSG_NO
;
		M8			; memory 8 bit mode !!
;
		STZ	!NEXTGOTO
;
		LDA	#MINPL
		STA	!MODENO
;
		INC	!MSGMOD
		LDA	!BGMODE
		ORA	#040H
		STA	!BGMODE
		LDA	#004
		STA	!CHRTRP
;
;-------------- NMI-IRQ "ON" ------------------------------------
		STZ	!NMI_PROG_NO	;荞݃vOm.
		LDA	#004H
		STA	!IRQFLG		;IRQ counter set
		LDA	#050H
		STA	4207H		;H counter set
		LDA	#0D8H
		STA	4209H		;V counter set
		LDA	#10110001B
		STA	4200H		;timer IRQ "ON"
;
		PLB
		RTL
;
;
INITADR		EQU	$
		WORD	INITIAL1_E1	; game 1 initial set !!
		WORD	INITIAL1_E2	; game 2 initial set !!
		WORD	INITIAL1_E3	; game 3 initial set !!
		WORD	MINIINT1_4	; game 4 initial set !!
		WORD	MINIINT1_2	; game 5 initial set !!
		WORD	MINIIAL1_3L0	; game 6 initial set !!
		WORD	MINIIAL1_3L1	; game 7 initial set !!
		WORD	MINIINT1_5	; game 8 initial set !!
		WORD	MINI_RTS	; _~[
		WORD	MINIINT1_6	; game A initial set !!
		WORD	MINIINT1_7	; game B initial set !!
		WORD	INITIAL1_V1	; game C initial set !!
;
;
MINI_RTS	EQU	$
		MI8			; memory,index 8 bit mode !!
		RTS
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		INITIAL1	( world 1 initial set )			x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
INITIAL1_E1	EQU	$
		LDY	#3
		LDX	#0
		BRA	INITIAL1_100
;
INITIAL1_E2	EQU	$
		LDY	#4
		LDX	#0
		BRA	INITIAL1_100
;
INITIAL1_E3	EQU	$
		LDY	#5
		LDX	#0
		BRA	INITIAL1_100
;
INITIAL1_V1	EQU	$
		LDY	#3
		LDX	#1
		BRA	INITIAL1_100
;
INITIAL1_V2	EQU	$
		LDY	#4
		LDX	#1
		BRA	INITIAL1_100
;
INITIAL1_V3	EQU	$
		LDY	#5
		LDX	#1
;-------------- XN[l NA -----------------------------
INITIAL1_100
;
		STY	!KYKAZU
		STX	!MN2PLY
;
		LDA	!BG1SCF
		EOR	#003H
		STA	!BG1SCF
		STA	2107H
		LDA	!BG2SCF
		EOR	#003H
		STA	!BG2SCF
		STA	2108H
;
		M16			; memory 16bit mode
;
		STZ	<SCCH1
		STZ	<SCCV1
		STZ	<SCCH2
		LDA	#0017H
		STA	<SCCV2
		STZ	<SCCH3
		STZ	<SCCV3
;
;-------------- Q[ CjV -----------------------------------
;
		LDA	#0030H
		STA	!ENXPSL		; vC[wW
		STA	!PLXPSL		; vC[wW
		LDA	#00B0H
		STA	!ENYPSL		; vC[xW
		LDA	#00E0H
		STA	!ENXPSL+2	; GwW
		LDA	#00D8H
		STA	!ENYPSL+2	; GxW
		LDA	#0061H
		STA	!ENXPSL+4	; DwW
		LDA	#0035H
		STA	!ENYPSL+4	; DxW
		LDA	#00C0H
		STA	!ZMSCCH		; D{
		LDA	#00C0H
		STA	!ZMSCCV		; Dc{
		STA	!FSNSIZ		; D̑傫
		STZ	!ANGLE
		STZ	!ENWRK0		; vC[[hOiҋ@j
		LDA	#1
		STA	!ENWRK0+4	; D[hPisj
;
		STZ	!ENYCL1+4	; DxXs[hNA
		STZ	!ENYPS2+4	; Dx]NA
		STZ	!ENXPS2+4	; Dw]NA
		JSL	>RANDAM
		LDA	!RANDM0
		LSR	A
		BCC	INITIAL1_300
		LDA	#0FFF0H
		BRA	INITIAL1_350
INITIAL1_300
		LDA	#0010H
INITIAL1_350
		STA	!ENXSPD+4	; DX^[gCjV
;
		STZ	!ENWRK0+2	; G[hOiҋ@j
		LDA	#1
		STA	!FGMFLG		; DQ[tOI
		LDA	#301FH
		STA	>DATACOL+18AH	; DCjVJ[
;;;;		LDA	#4943H
;;;;		STA	!NUKCOL		; ŒJ[f[^[
;
		M8			; memory 8bit mode
;
		LDA	#0B4H
		STA	!KYWTWK		; key wait timer work
		STZ	04204H
		STA	04205H
		LDA	#48H
		STA	04206H
		NOP			; ҂
		NOP			;
		NOP			;
		NOP			;
		NOP			;
		NOP			;
		NOP			;
		NOP			;
		LDA	04214H
		STA	!KYWTCT		; L[͑҂t[ikj
		LDA	04215H
		STA	!KYWTCT+1	; L[͑҂t[igj
;
		LDA	#09H
		STA	!BGMODE
		STZ	!SUBADF		; gamen kasan off
;
		JSR	KOBJST_SUB	; DLN^[ Zbg
;
		RTS
;
;
;
;****************************************************************
;*								*
;*		~j Q[	(CvO)		*
;*								*
;****************************************************************
MINIPLAY	EQU	$
;;;;		LDA	<KEYC2L-1	; fobO[h
;;;;		AND	#00100000B	;
;;;;		BEQ	MINIPLAY05	;
;;;;		LDA	#MINIT		;
;;;;		STA	!MODENO		;
MINIPLAY05
;;;;		LDA	<KEYC2L		;
;;;;		AND	#00110000B	;
;;;;		BEQ	MINIPLAY10	;
;
;;;;		JSL	>BACK_GAME	; Q[ ǂ
;;;;		BRA	MINIPLAY30
MINIPLAY10
		LDA	!MSGMOD
		BEQ	MINIPLAY20
		JSL	>MSGDSP
		LDA	!MSGMOD
		BNE	MINIPLAY20
		JSR	MINI_STAT_ST
;
MINIPLAY20	EQU	$
		LDX	!MINIMD
		JSR	(!MINIADR,X)
;
MINIPLAY30
		PLB
		RTL
;
;
MINIADR		EQU	$
		WORD	FUSENGAME	; fusen game move !!
		WORD	FUSENGAME	; fusen game move !!
		WORD	FUSENGAME	; fusen game move !!
		WORD	MINIMOV1_4	; rS game move !!
		WORD	MINIMOV1_2	; fusen game move !!
		WORD	SHIRIGAME	; K݃p
		WORD	SHIRIGAME	; K݃p
		WORD	MINIMOV1_5	; e game move !!
		WORD	MINI_RTS	; _~[
		WORD	MINIMOV1_6	; Ń{b game move !!
		WORD	MINIMOV1_7	; Ń{b game move !!
		WORD	FUSENGAME	; fusen game move !!
;
;
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+							+
;+		~jQ[ X^[g Zbg		+
;+							+
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
BG3_SCR_DAT	EQU	$
		BYTE	MIN31,MIN31,MIN31
		BYTE	MIN32,MIN32,MIN33
		BYTE	MIN33,MIN35,MIN36
		BYTE	MIN34,MIN34,MIN31
;
;
MINI_STAT_ST	EQU	$
		LDA	!MINIMD
		LSR	A
		MI16			; memory , index 16bit mode
		AND	#000FFH
		TAY
		LDA	BG3_SCR_DAT,Y
		AND	#000FFH
		JSL	>UNCOMPRES_X	; kf[^̉
		LDX	#BANK WOB7CHR
		STX	<WORK1
		LDX	#WOB7CHR+1000H
		LDY	#03400H
		JSL	>VRAMDX_ST	; WJf[^]
;
		LDX	#00000H
MIN_STT_ST_050	EQU	$
		LDA	>COL_ADDRESS+MINI_B3COL,X
		STA	>DATACOL+001H*2,X
		INX
		INX
		CPX	#0000FH*2
		BCC	MIN_STT_ST_050
		MI8			; memory , index 8bit mode
;
		LDA	!HD420C
		EOR	#00100000B
		STA	!HD420C
		LDA	!BGMODE
		EOR	#040H
		STA	!BGMODE
		RTS
;
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x			FUSENGAME					x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
MN0		EQU	$
FUSENGAME	EQU	$
		M16			; memory 16 bit mode
		LDY	!MKYIDX
		LDA	!KEYA1L,Y
		STA	!KEYC1L
		LDA	!KEYA2L,Y
		STA	!KEYC2L
		JSL	>OAMDXCLR	; OAM clear sub !!
;
		MEM8
;
		JSL	>ENCSET_DM	; enemy char set sub !!
		JSR	MPLMOV		; mini game player move
		JSR	MENMOV		; mini game enemy move
		LDA	!MSGMOD		; bZ[W EBhD nm ?
		BNE	FUSENGAME_020	;	NO -> FUSENGAME_020
		LDA	!HD420C
		BIT	#00001000B
		BNE	FUSENGAME_010
		JSR	KYBGCL		; L[ \ g
		JSL	>WINDON		; EChEZI
FUSENGAME_010	EQU	$
		JSR	MFSMOV		; mini game fusen move
FUSENGAME_020	EQU	$
		JSR	MPLCST		; player chr set
		M16
;
		LDA	>VRAMD
		CMP	#20H
		BCS	FUSENGAME_500
		JSR	KOBJST		; kaiten obj paramater set
FUSENGAME_500
		LDA	!MNMODE
		BEQ	FUSENGAME_600
		JSL	>ENEMY_IN
FUSENGAME_600
;
		M16			; memory 16 bit mode !!
;
		M_CHIP	DX_OAM		; SOAM_DX => OAM convert
;
		M8			; memory 8 bit mode !!
;
		RTS
;
;########################################################################
;# (LABEL)	MFSMOV		(mini game fusen move)			#
;########################################################################
MFSMOV		EQU	$
		LDA	!ENWRK0+4
		ASL	A
		TAY
		LDA	MFSMOV_TBL,Y
		STA	<WORK
		LDA	MFSMOV_TBL+1,Y
		STA	<WORK1
		JMP	(WORK)
;
MFSMOV_TBL	EQU	$
		WORD	MFSWIT		; Dg又
		WORD	MFSFLY		; D||ړ
		WORD	MFSBOM		; D
;
;########################################################################
;# (LABEL)	MFSWIT		(fusen kakudai)				#
;########################################################################
MFSWIT		EQU	$
		MI16			; memory , index 16bit mode
		LDA	<FRCNT
		AND	#00000011B
		BEQ	MFSWIT_000
		JMP	MFSWIT_200
MFSWIT_000
		LDA	!FSNSIZ		; DTCY
		AND	#01F0H
		ASL	A
		ASL	A
		ASL	A
		ASL	A
		ASL	A
		ASL	A
		ORA	#001FH
		STA	>DATACOL+18AH	; DJ[Zbg
;
		LDA	!FSNSIZ
		INC	A
		STA	!FSNSIZ		; DTCYAbv
		CMP	#01FFH		; }bNXH
		BCC	MFSWIT_200	; !NO
		LDA	#2
		STA	!ENWRK0+4
		LDA	!ENWRK0
		BNE	MFSWIT_050	; player WIN
		LDA	#3
		STA	!ENWRK0+2
		LDA	#4
		STA	!ENWRK0
		LDA	#0C0H
		STA	!ENWRK4
		STZ	!ENWRK2
		LDA	#MIN2A1
		STA	<WORK
		M8			; memory 8bit mode
		LDA	#0FEH		; Gp[^[Zbg
		STA	!ENYCL0+2
		LDA	#08H
		STA	!ENXSPD+2
		STZ	!ENYCL1+2
		STZ	!ENYPS2+2
		STZ	!ENXPS2+2
		M16			; memory 16bit mode
		BRA	MFSWIT_100
MFSWIT_050
		LDA	#4
		STA	!ENWRK0+2
		LDA	#3
		STA	!ENWRK0
		LDA	#MIN2A2
		STA	<WORK
MFSWIT_100
		MI16			; memory , index 16bit mode
		LDA	#1FFH
		STA	!FSNSIZ
		LDA	!ENCIDX
		LDA	!ENCIDX+2
		LDA	!ENCTIM
		LDA	!ENCTIM+2
		STZ	!ENCTIM+6
		STZ	!ENCIDX+6
		STZ	!FSNIDX
		STZ	!FSNTIM
MFSWIT_200
		LDA	!FSNTIM
		BEQ	MFSWIT_400
		DEC	!FSNTIM
		LDA	!ZMSCCV
		SEC
		SBC	#3
		STA	!ZMSCCV
		LDA	!ZMSCCH
		CLC
		ADC	#3
		CMP	#01FFH
		BCC	MFSWIT_300
		LDA	#01FFH
MFSWIT_300
		STA	!ZMSCCH
;
		LDA	<FRCNT
		AND	#00000011B
		BNE	MFSWIT_700
		INC	!ENYPSL+4
		BRA	MFSWIT_700
MFSWIT_400
		LDA	!ZMSCCV
		CLC
		ADC	#3
		CMP	!FSNSIZ
		BCC	MFSWIT_450
		LDA	!FSNSIZ
MFSWIT_450
		STA	!ZMSCCV
;
		LDA	!ZMSCCH
		SEC
		SBC	#3
		CMP	!FSNSIZ
		BCS	MFSWIT_500
		LDA	!FSNSIZ
MFSWIT_500
		STA	!ZMSCCH
;
		LDA	!ENYPSL+4
		DEC	A
		CMP	#90H
		BCS	MFSWIT_520
		LDA	#90H
MFSWIT_520
		STA	!ENYPSL+4
MFSWIT_700
		JSR	MFSCST
;
		MI8			; memory , index 8bit mode
		RTS
;
;########################################################################
;# (LABEL)	MFSCST		(mini game fusen chr set)		#
;########################################################################
MFSCST		EQU	$
		MI16			; memory , index 16bit mode
		LDY	!OAMIDX
		LDX	#0
;
		STZ	<WORK2
MFSCST_200
		STZ	<WORK
MFSCST_300
;
		LDA	!ENXPSL+4
		CLC
		ADC	<WORK
		STA	!SOAM_DX+00H,Y
		LDA	!ENYPSL+4
		CLC
		ADC	<WORK2
		STA	!SOAM_DX+02H,Y
		LDA	MFSCST_DAT,X
		AND	#00FFH
		ORA	#2900H
		STA	!SOAM_DX+04H,Y
		LDA	#0002H
		STA	!SOAM_DX+06H,Y
		TYA
		CLC
		ADC	#8
		TAY
		INX
		INC	<WORK4
		INC	<WORK4
		LDA	<WORK
		CLC
		ADC	#10H
		STA	<WORK
		CMP	#040H
		BCC	MFSCST_300
		STZ	<WORK
		LDA	<WORK2
		CLC
		ADC	#10H
		STA	<WORK2
		CMP	#40H
		BCC	MFSCST_200
;
		STY	!OAMIDX
		MI8			; memory , index 8bit mode
		RTS
;
MFSCST_DAT	EQU	$
		HEX	C0,C2,C4,C6
		HEX	E0,E2,E4,E6
		HEX	C8,CA,CC,CE
		HEX	E8,EA,EC,EE
;
;########################################################################
;# (LABEL)	MFSFLY		(fusen fly and buyobuyo)		#
;########################################################################
MFSFLY		EQU	$
		LDY	#0
		LDX	#4
		LDA	!ENWRK0
		CMP	#2
		BEQ	MFSFLY_50
		LDA	!ENWRK0+2
		CMP	#2
		BNE	MFSFLY_90
		LDY	#2
MFSFLY_50
		LDA	!ENYCL0,Y
		CMP	#0FDH
		BEQ	MFSFLY_95
MFSFLY_90
		LDA	#0DH
		STA	<WORK
		LDA	#3
		STA	<WORK2
		LDA	#0
		JSR	GCALCY
		JSR	GCALCX
;
MFSFLY_95
		JSR	FSBUYO
;
		LDA	!ENXPSL,X
		CMP	#26H
		BCS	MFSFLY_100
		LDA	#26H
		STA	!ENXPSL,X
		LDA	#90H
		STA	!ENYPSL,X
		STZ	!ENWRK0,X
		LDA	#1
		STA	!ENWRK0
		STZ	!ENCIDX
		STZ	!ENCTIM
		STZ	!KYINDX
		LDA	#08H
		STA	!FSNTIM
		LDA	#13H
		JSL	>SOUND_3_ON
		STZ	!MKYIDX
		JSR	KEYSET		; L[obt@Zbg
		JSR	KEYBGW		; L[af\
		BRA	MFSFLY_200
MFSFLY_100
		CMP	#09DH
		BCC	MFSFLY_200
		LDA	#09CH
		STA	!ENXPSL,X
		LDA	#090H
		STA	!ENYPSL,X
		STZ	!ENWRK0,X
		LDA	#1
		STA	!ENWRK0+2
		STZ	!ENCIDX+2
		STZ	!ENCTIM+2
		STZ	!KYINDX
		LDA	#08H
		STA	!FSNTIM
		LDA	#13H
		JSL	>SOUND_3_ON
		LDA	!MN2PLY		; Qok`xH
		BEQ	MFSFLY_150	; !NO
		LDA	#4
		STA	!MKYIDX
		JSR	KEYSET		; L[obt@Zbg
		JSR	KEYBGW		; L[af\
		BRA	MFSFLY_200
MFSFLY_150
		JSR	MENTST		; G^C}[Zbg
MFSFLY_200
;
		JSR	MFSCST		; DLN^[Zbg
;
		RTS
;
;########################################################################
;# (LABEL)	MFSBOM		(fusen bakuhatu)			#
;########################################################################
MFSBOM		EQU	$
		LDA	!FSNIDX
		ASL	A
		TAY
		LDA	MFSBOM_TBL,Y
		STA	<WORK
		LDA	MFSBOM_TBL+1,Y
		STA	<WORK1
		JMP	(WORK)
;
MFSBOM_TBL	EQU	$
		WORD	MFSBM0
		WORD	MFSBM1
		WORD	MFSBM2
		WORD	MFSBM3
		WORD	MFSBM4
		WORD	MFSBM5
		WORD	MFSBM6
		WORD	MFSBM7
;
;########################################################################
;# (LABEL)	MFSBM0		(fuusen bakuhatu puttern0)		#
;########################################################################
MFSBM0		EQU	$
		MI16
		LDA	#0004H
		STA	<WORK
		LDA	#0002H
		STA	<WORKA
		LDA	#6AH
		STA	<WORKC
		LDX	#0000H
		JSR	MBMCST		; ʃLN^[Zbg
		JSR	MFSCST		; DLN^[Zbg
		MEM8
		IDX8
		INC	!FSNIDX
		LDA	#86H
		JSL	>SOUND_3_ON
;
		RTS
;
;########################################################################
;# (LABEL)	MFSBM1		(fuusen bakuhatu puttern1)		#
;########################################################################
MFSBM1		EQU	$
		MI16
		LDA	#0001H
		STA	<WORK
		LDA	#0002H
		STA	<WORKA
		LDA	#40H
		STA	<WORKC
		LDX	#0004H
		JSR	MBMCST		; ʃLN^[Zbg
		JSR	MFSCST		; DLN^[Zbg
		MI8
		INC	!FSNIDX
		LDA	#10H
		STA	!FSNTIM
;
		RTS
;
;########################################################################
;# (LABEL)	MFSBM2		(fuusen bakuhatu puttern2)		#
;########################################################################
MFSBM2		EQU	$
		MI16
		LDA	#0004H
		STA	<WORK
		LDA	#0002H
		STA	<WORKA
		LDA	#042H
		STA	<WORKC
		LDX	#0005H
		JSR	MBMCST		; ʃLN^[Zbg
		MI8
		LDA	<FRCNT
		LSR	A
		BCS	MFSBM2_200
		JSR	MFSCST		; DLN^[Zbg
MFSBM2_200
		DEC	!FSNTIM
		BNE	MFSBM2_300
		INC	!FSNIDX
		LDA	#02H
		STA	!FSNTIM
MFSBM2_300
		MI16
		LDA	!ZMSCCH
		SEC
		SBC	#10H
		BPL	MFSBM2_350
		LDA	#01
MFSBM2_350
		STA	!ZMSCCH
		LDA	!ZMSCCV
		SEC
		SBC	#10H
		BPL	MFSBM2_360
		LDA	#01
MFSBM2_360
		STA	!ZMSCCV
;
		MI8
		RTS
;
;########################################################################
;# (LABEL)	MFSBM3		(fuusen bakuhatu puttern3)		#
;########################################################################
MFSBM3		EQU	$
		MI16
		LDA	#0010H
		STA	<WORK
		STZ	<WORKA
		LDA	#0E3H
		STA	<WORKC
		LDX	#0009H
		JSR	MBMCST		; ʃLN^[Zbg
		MI8
		DEC	!FSNTIM
		BNE	MFSBM3_300
		INC	!FSNIDX
		LDA	#2
		STA	!FSNTIM
MFSBM3_300
;
		RTS
;
;########################################################################
;# (LABEL)	MFSBM4		(fuusen bakuhatu puttern4)		#
;########################################################################
MFSBM4		EQU	$
		MI16
		LDA	#0020H
		STA	<WORK
		STZ	<WORKA
		LDA	#0E3H
		STA	<WORKC
		LDX	#0019H
		JSR	MBMCST		; ʃLN^[Zbg
		MI8
		DEC	!FSNTIM
		BNE	MFSBM4_300
		INC	!FSNIDX
		LDA	#2
		STA	!FSNTIM
MFSBM4_300
;
		RTS
;
;########################################################################
;# (LABEL)	MFSBM5		(fuusen bakuhatu puttern5)		#
;########################################################################
MFSBM5		EQU	$
		MI16
		LDA	#0020H
		STA	<WORK
		STZ	<WORKA
		LDA	#0E3H
		STA	<WORKC
		LDX	#0039H
		JSR	MBMCST		; ʃLN^[Zbg
		MI8
		DEC	!FSNTIM
		BNE	MFSBM5_300
		INC	!FSNIDX
		LDA	#2
		STA	!FSNTIM
MFSBM5_300
;
		RTS
;
;########################################################################
;# (LABEL)	MFSBM6		(fuusen bakuhatu puttern6)		#
;########################################################################
MFSBM6		EQU	$
		MI16
		LDA	#0008H
		STA	<WORK
		LDA	#0002H
		STA	<WORKA
		LDA	#0E5H
		STA	<WORKC
		LDX	#0059H
		JSR	MBMCST		; ʃLN^[Zbg
		MI8
		DEC	!FSNTIM
		BNE	MFSBM6_300
		INC	!FSNIDX
		INC	!HDMMOD
		LDA	!ENWRK0
		CMP	#4
		BEQ	MFSBM6_200
		INC	!WINFLG
		BRA	MFSBM6_250
MFSBM6_200
		LDA	!MN2PLY
		BEQ	MFSBM6_230
;
		INC	!ITGTFG
		BRA	MFSBM6_250
MFSBM6_230
		M16
		LDA	#M_ITM
		JSL	>ENINSR_I
		BCC	MFSBM6_250
;
		PHX
		LDA	!KYKAZU
		SEC
		SBC	#3
		CLC
		ADC	#IT1UP
		STA	!ENWRK0,Y
;
		LDA	#0080H
		STA	!ENYPSL,Y
		LDA	#0038H
		STA	!ENXPSL,Y
;
		PLX
		INC	!MNMODE
		M8
MFSBM6_250
		JSR	MHDPLY		; Q[I
MFSBM6_300
;
		RTS
;
;########################################################################
;# (LABEL)	MFSBM7		(fuusen bakuhatu puttern7)		#
;########################################################################
MFSBM7		EQU	$
		JSR	MHDPLY		; Q[I
		RTS
;
;########################################################################
;# (LABEL)	MBMCST		(fuusen bakuhatu kyoutuu chr set)	#
;########################################################################
MBMCST		EQU	$
		MI16
		LDY	!OAMIDX
MBMCST_100
		LDA	MBMCST_XDT,X
		CLC
		ADC	#20H
		AND	#00FFH
		CMP	#0080H
		BCC	MBMCST_200
		ORA	#0FF00H
MBMCST_200
		CLC
		ADC	!ENXPSL+4
		STA	!SOAM_DX+00,Y
;
		LDA	MBMCST_YDT,X
		CLC
		ADC	#20H
		AND	#00FFH
		CMP	#0080H
		BCC	MBMCST_300
		ORA	#0FF00H
MBMCST_300
		CLC
		ADC	!ENYPSL+4
		STA	!SOAM_DX+02,Y
;
		LDA	MBMCST_ADT-1,X
		AND	#0FF00H
		ORA	<WORKC
		STA	!SOAM_DX+04,Y
;
		LDA	<WORKA
		STA	!SOAM_DX+06,Y
;
		INX
		TYA
		CLC
		ADC	#8
		TAY
		DEC	<WORK
		BNE	MBMCST_100
		STY	!OAMIDX
;
		MI8
		RTS
;
MBMCST_YDT	EQU	$
		HEX	00,00,F0,F0			; 00
		HEX	F8				; 01
		HEX	00,00,F0,F0			; 02
		HEX	08,08,00,00,F8,F0,F0,F8		; 03
		HEX	08,F0,08,F0,00,00,F8,F8		; 03
		HEX	F4,F4,EC,EC,F4,F4,EC,EC		; 04
		HEX	0C,0C,04,04,0C,0C,04,04		; 04
		HEX	10,10,08,08,F0,F0,E8,E8		; 04
		HEX	00,00,F8,F8,00,00,F8,F8		; 04
		HEX	F0,F0,E8,E8,00,00,F8,F8		; 05
		HEX	10,10,08,08,18,18,10,10		; 05
		HEX	10,10,08,08,00,00,F8,F8		; 05
		HEX	F0,F0,E8,E8,E8,E8,E0,E0		; 05
		HEX	F8,10,18,10,F8,E0,D8,E0		; 06
MBMCST_XDT	EQU	$
		HEX	00,F0,00,F0			; 00
		HEX	F8				; 01
		HEX	F0,00,00,F0			; 02
		HEX	00,F8,F0,08,08,00,F8,F0		; 03
		HEX	08,08,F0,F0,00,F8,00,F8		; 03
		HEX	F4,EC,F4,EC,0C,04,0C,04		; 04
		HEX	0C,04,0C,04,F4,EC,F4,EC		; 04
		HEX	00,F8,00,F8,00,F8,00,F8		; 04
		HEX	10,08,10,08,F0,E8,F0,E8		; 04
		HEX	F0,E8,E8,F0,E8,E0,E0,E8		; 05
		HEX	F0,E8,E8,F0,00,F8,F8,00		; 05
		HEX	10,08,08,10,18,10,10,18		; 05
		HEX	10,08,08,10,00,F8,F8,00		; 05
		HEX	D8,E0,F8,10,18,10,F8,E0		; 06
MBMCST_ADT	EQU	$
		HEX	F0,B0,70,30			; 00
		HEX	30				; 01
		HEX	B2,F2,72,32			; 02
		HEX	B0,F0,30,70,F0,30,70,B0		; 03
		HEX	F0,70,B0,30,30,70,B0,F0		; 03
		HEX	F0,B0,70,30,F0,B0,70,30		; 04
		HEX	F0,B0,70,30,F0,B0,70,30		; 04
		HEX	F0,B0,70,30,F0,B0,70,30		; 04
		HEX	F0,B0,70,30,F0,B0,70,30		; 04
		HEX	F0,B0,30,70,F0,B0,30,70		; 05
		HEX	F0,B0,30,70,F0,B0,30,70		; 05
		HEX	F0,B0,30,70,F0,B0,30,70		; 05
		HEX	F0,B0,30,70,F0,B0,30,70		; 05
		HEX	30,30,30,70,70,70,70,30		; 06
;
;########################################################################
;# (LABEL)	MENMOV		(enemy move)				#
;########################################################################
MENMOV		EQU	$
		LDA	!ENWRK0+2
		ASL	A
		TAY
		LDA	MENMOV_TBL,Y
		STA	<WORK
		LDA	MENMOV_TBL+1,Y
		STA	<WORK1
		JMP	(WORK)
;
MENMOV_TBL	EQU	$
		WORD	MENWIT		; enemy wait
		WORD	MENKEY		; enemy key input
		WORD	MENJMP		; enemy jump
		WORD	MENDIE		; enemy die
		WORD	MENWIN		; enemy win
;
;########################################################################
;# (LABEL)	MENWIT		(enemy wait)				#
;########################################################################
MENWIT		EQU	$
		LDY	!ENCIDX+2
		LDA	!ENCTIM+2
		BEQ	MENWIT_800
		DEC	!ENCTIM+2
		BRA	MENWIT_850
MENWIT_800
		INY
		CPY	#04H
		BCC	MENWIT_820
		LDY	#0
MENWIT_820
		STY	!ENCIDX+2
		LDA	#10H
		STA	!ENCTIM+2
MENWIT_850
		MI16
		TYA
		ASL	A
		ASL	A
		CLC
		ADC	!ENCIDX+2
		ASL	A
		TAX
		LDY	!OAMIDX
		LDA	#5
		STA	<WORK		;chr set counter
;
MENWIT_100
		LDA	MENWIT_XPSDT,X
		CLC
		ADC	!ENXPSL+2
		STA	!SOAM_DX,Y
		LDA	MENWIT_YPSDT,X
		CLC
		ADC	!ENYPSL+2
		STA	!SOAM_DX+2,Y
		LDA	MENWIT_CHRDT,X
		STA	!SOAM_DX+4,Y
		AND	#0FF00H
		SEC
		SBC	#3100H
		BEQ	MENWIT_300
		LDA	#2
MENWIT_300
		STA	!SOAM_DX+6,Y
		INX
		INX
		TYA
		CLC
		ADC	#8
		TAY
		DEC	<WORK
		BNE	MENWIT_100
		STY	!OAMIDX
		MI8
;
		RTS
;
MENWIT_CHRDT	EQU	$
		WORD	319EH,319EH,318BH,318AH,3388H
		WORD	319EH,319EH,318BH,318AH,3388H
		WORD	3388H,319EH,319EH,318BH,318AH
		WORD	319EH,319EH,318BH,318AH,3388H
MENWIT_XPSDT	EQU	$
		WORD	0FFEBH,0FFE0H,0FFE8H,0FFE0H,0FFE0H
		WORD	0FFEBH,0FFE0H,0FFE8H,0FFE0H,0FFDFH
		WORD	0FFDEH,0FFEBH,0FFE0H,0FFE8H,0FFE0H
		WORD	0FFEBH,0FFE0H,0FFE8H,0FFE0H,0FFDFH
MENWIT_YPSDT	EQU	$
		WORD	0FFF0H,0FFF0H,0FFEDH,0FFEDH,0FFDEH
		WORD	0FFF0H,0FFF0H,0FFEDH,0FFEDH,0FFDEH
		WORD	0FFDFH,0FFF0H,0FFF0H,0FFEDH,0FFEDH
		WORD	0FFF0H,0FFF0H,0FFEDH,0FFEDH,0FFDEH
;
;########################################################################
;# (LABEL)	MENKEY		(enemy key input)			#
;########################################################################
MENKEY		EQU	$
		LDA	!MN2PLY
		BEQ	MENKEY_010
		JMP	ENKYCK		; GL[`FbN
MENKEY_010
;
		LDA	!BADCNT
		BEQ	MENKEY_050
		JSR	BADCST		; ܂J[\\
		DEC	!BADCNT
		BEQ	MENKEY_030
		JMP	MENKEY_200
MENKEY_030
		STZ	!KYINDX
		JSR	MENTST		; GEGCg^CZbg
MENKEY_050
		LDA	!KYINDX
		ASL	A
		TAX
		LDA	!KEYBUF,X
		DEC	A
		STA	!KEYBUF,X
		BNE	MENKEY_100
		JSL	>RANDAM
		LDA	!RANDM0
		CMP	#2H
		BCS	MENKEY_090
		LDA	#20H
		STA	!BADCNT
		LDA	#90H
		JSL	>SOUND_3_ON
		BRA	MENKEY_200
MENKEY_090
		INC	!KYINDX
		LDA	#8FH
		JSL	>SOUND_3_ON
		JSR	KYENBGE
MENKEY_100
		DEC	!MENTIM
		BEQ	MENKEY_150
		JSR	MCSRST		; EGCgJ[\\
		JSR	KYTMPT		; L[͑҂^C}[\
		BRA	MENKEY_200
MENKEY_150
		LDA	#13H
		JSL	>SOUND_3_ON
		LDA	#8
		JSL	>SOUND_3_ON
		LDA	#38H
		JSL	>SOUND_3_ON
		LDA	#2
		STA	!ENWRK0+2
		LDA	#1
		STA	!ENWRK0+4
		STZ	!ENCTIM+2
		STZ	!ENCIDX+2
		LDA	#0FDH
		STA	!ENYCL0+2
		LDA	#0FDH
		STA	!ENYCL0+4
		STZ	!ENYCL1+2
		STZ	!ENYCL1+4
		STZ	!ENYPS2+2
		STZ	!ENYPS2+4
		LDA	#0F0H
		STA	!ENXSPD+4
		STZ	!ENXPS2+4
		STZ	!FSNTIM
		STZ	!FSNIDX
		JSR	KYBGCL		; L[afNA
MENKEY_200
;
		JSR	MENWIT		; GEGCg
		RTS
;
;########################################################################
;# (LABEL)	ENKYCK		(enemy key check)			#
;########################################################################
ENKYCK		EQU	$
		LDA	!BADCNT		; machigai wait timer
		BEQ	ENKYCK_00A
		DEC	!BADCNT
		BNE	ENKYCK_00B
		STZ	!KYINDX		; key index counter clear
		JSR	KEYBGW
ENKYCK_00B
		JSR	MENWIT
		JSR	BADCST
		RTS
ENKYCK_00A
		JSR	KYTMPT
		M16
		DEC	!KYWTTM		; key wait timer
		BNE	ENKYCK_100
ENKYCK_000
		LDA	#90H		; fuseikai sound
		JSL	>SOUND_3_ON
		LDA	#20H
		STA	!BADCNT
		LDA	!KYWTWK
		STA	!KYWTTM		; timer repeat set
		M16
		LDA	#48H
		STA	!MATTIM
		STZ	!MATCNT
		JSR	MATSET
		JMP	ENKYCK_900
ENKYCK_100
		JSR	MCSRST
		M16
		LDA	!KYINDX
		ASL	A
		TAX
		LDA	<KEYC2L		; key in?
		BEQ	ENKYCK_900	; !no
		CMP	!KEYBUF,X	; key in seikai?
		BNE	ENKYCK_000	; !no
		LDA	#8FH		; seikai sound
		JSL	>SOUND_3_ON
		INC	!KYINDX
		LDA	!KYKAZU
		CMP	!KYINDX		; key perfect
		BCC	ENKYCK_700	; !yes
		JSR	KYENBG		; key nyuuryoku end bg
		BRA	ENKYCK_900
ENKYCK_700
		M8
		JMP	MENKEY_150
;
ENKYCK_900
		M8
		JSR	MENWIT
		RTS
;
;########################################################################
;# (LABEL)	MENJMP		(enemy jump)				#
;########################################################################
MENJMP		EQU	$
		LDA	#20H
		STA	<WORK
		LDA	#4
		STA	<WORK2
		LDX	#2
		LDA	#0
		JSR	GCALCY
		LDA	!ENYPSL+2
		CMP	#0D8H
		BCC	MENJMP_100
		LDA	#0D8H
		STA	!ENYPSL+2
		STZ	!ENWRK0+2
		STZ	!ENCTIM+2
		STZ	!ENCIDX+2
MENJMP_100
;
		LDA	!ENYCL0+2
		CLC
		ADC	#3
		TAY
		LDA	MENJMP_IDXDT,Y
		TAX
		MI16
		LDA	#5
		STA	<WORK
		LDY	!OAMIDX
;
MENJMP_500
		LDA	!ENXPSL+2
		CLC
		ADC	MENJMP_XPSDT,X
		STA	!SOAM_DX,Y
		LDA	!ENYPSL+2
		CLC
		ADC	MENJMP_YPSDT,X
		STA	!SOAM_DX+2,Y
		LDA	MENJMP_CHRDT,X
		STA	!SOAM_DX+4,Y
		AND	#0200H
		BEQ	MENJMP_600
		LDA	#2
MENJMP_600
		STA	!SOAM_DX+6,Y
		INX
		INX
		TYA
		CLC
		ADC	#8
		TAY
		DEC	<WORK
		BNE	MENJMP_500
		STY	!OAMIDX
		MI8
;
		RTS
;
MENJMP_IDXDT	EQU	$
		HEX	00,0A,0A,14,14,14,1E
MENJMP_YPSDT	EQU	$
		WORD	0FFE2H,0FFEFH,0FFF0H,0FFEDH,0FFEDH
		WORD	0FFEFH,0FFF0H,0FFE8H,0FFE8H,0FFD9H
		WORD	0FFF0H,0FFF0H,0FFDAH,0FFE8H,0FFE8H
		WORD	0FFF1H,0FFF1H,0FFE2H,0FFEFH,0FFEFH
MENJMP_XPSDT	EQU	$
		WORD	0FFDEH,0FFEAH,0FFE3H,0FFE8H,0FFE0H
		WORD	0FFE3H,0FFE8H,0FFE8H,0FFE0H,0FFE2H
		WORD	0FFE8H,0FFE3H,0FFE0H,0FFE8H,0FFE0H
		WORD	0FFE5H,0FFE0H,0FFDFH,0FFE8H,0FFE0H
MENJMP_CHRDT	EQU	$
		WORD	03388H,0319AH,0319EH,0318BH,0318AH
		WORD	0719AH,0719AH,0318BH,0318AH,03388H
		WORD	0B19BH,0B19BH,03388H,0318BH,0318AH
		WORD	0319EH,0319EH,03388H,0318BH,0318AH
;
;########################################################################
;# (LABEL)	MENDIE		(enemy die)				#
;########################################################################
MENDIE		EQU	$
		LDX	#2
		LDA	#20H
		STA	<WORK
		LDA	#4
		STA	<WORK2
		LDA	#0
		JSR	GCALCY
		LDA	!ENYPSL,X
		CMP	#0D8H
		BCC	MENDIE_100
		LDA	#0D8H
		STA	!ENYPSL,X
;
		LDA	!ENXPSL,X
		CLC
		ADC	#0F6H
		STA	!ENXPSL+8
		LDA	!ENYPSL,X
		CLC
		ADC	#0F8H
		STA	!ENYPSL+8
		JSR	MEPIYO
;
		LDA	<FRCNT
		AND	#00110000B
		LSR	A
		LSR	A
		LSR	A
		LSR	A
		TAY
		LDA	MENDIE_PYDAT,Y
		TAX
		BRA	MENDIE_500
MENDIE_100
		JSR	GCALCX
		LDA	!ENYCL0,X
		INC	A
		INC	A
		TAY
		LDX	MENDIE_IDXDT,Y
MENDIE_500
		MI16
		LDY	!OAMIDX
		LDA	#5
		STA	<WORK
MENDIE_600
		LDA	!ENXPSL+2
		CLC
		ADC	MENDIE_XPSDT,X
		STA	!SOAM_DX,Y
		LDA	!ENYPSL+2
		CLC
		ADC	MENDIE_YPSDT,X
		STA	!SOAM_DX+2,Y
		LDA	MENDIE_CHRDT,X
		STA	!SOAM_DX+4,Y
		AND	#0200H
		XBA
		STA	!SOAM_DX+6,Y
		INX
		INX
		TYA
		CLC
		ADC	#8
		TAY
		DEC	<WORK
		BNE	MENDIE_600
		STY	!OAMIDX
		MI8
;
		RTS
;
MENDIE_PYDAT	EQU	$
		HEX	1E,28,32,28
MENDIE_IDXDT	EQU	$
		HEX	00,0A,14,1E,28,32
MENDIE_YPSDT	EQU	$
		WORD	0FFF1H,0FFF1H,0FFE2H,0FFEFH,0FFEFH
		WORD	0FFE4H,0FFF2H,0FFF2H,0FFF1H,0FFF1H
		WORD	0FFF3H,0FFF3H,0FFE6H,0FFF3H,0FFF3H
		WORD	0FFF3H,0FFF3H,0FFE5H,0FFF2H,0FFF2H
		WORD	0FFF3H,0FFF3H,0FFE4H,0FFF2H,0FFF2H
		WORD	0FFF3H,0FFF3H,0FFE4H,0FFF2H,0FFF2H
MENDIE_XPSDT	EQU	$
		WORD	0FFE5H,0FFE0H,0FFDFH,0FFE8H,0FFE0H
		WORD	0FFDFH,0FFE4H,0FFDFH,0FFE9H,0FFE1H
		WORD	0FFDCH,0FFE1H,0FFDFH,0FFE9H,0FFE1H
		WORD	0FFDCH,0FFE1H,0FFDFH,0FFE9H,0FFE1H
		WORD	0FFDCH,0FFE1H,0FFE0H,0FFE9H,0FFE1H
		WORD	0FFDCH,0FFE1H,0FFE1H,0FFE9H,0FFE1H
MENDIE_CHRDT	EQU	$
		WORD	319EH,319EH,3388H,318BH,318AH
		WORD	3388H,319AH,319AH,318BH,318AH
		WORD	319BH,319BH,3388H,318BH,318AH
		WORD	319BH,319BH,3388H,318BH,318AH
		WORD	319BH,319BH,3388H,318BH,318AH
		WORD	319BH,319BH,3388H,318BH,318AH
;
;########################################################################
;# (LABEL)	MENWIN		(enemy win)				#
;########################################################################
MENWIN		EQU	$
		JMP	MENWIT
;
		RTS
;
;########################################################################
;# (LABEL)	MENTST		(enemy tinking time set)		#
;########################################################################
MENTST		EQU	$
		JSR	MATSET
		LDX	#0BH
MENTST_00C
		STZ	!KEYBUF,X
		DEX
		BPL	MENTST_00C
;
		LDA	!FSNSIZ+1
		BEQ	MENTST_00A
		LDA	!FSNSIZ
		CMP	#080H
		BCC	MENTST_00A
		JSL	>RANDAM
		LDA	!RANDM0
		BMI	MENTST_300
;
MENTST_00A
		LDA	!KYKAZU
		ASL	A
		TAX
		STZ	<WORK
MENTST_000
		JSL	>RANDAM
		LDA	!RANDM0
		AND	#00011111B
		CMP	#18H
		BCC	MENTST_100
		CMP	#1CH
		BCS	MENTST_050
		SEC
		SBC	#18H
		BRA	MENTST_100
MENTST_050
		SEC
		SBC	#8H
MENTST_100
		CLC
		ADC	#8
		STA	!KEYBUF,X
		CLC
		ADC	<WORK
		STA	<WORK
		DEX
		DEX
		BPL	MENTST_000
		LDA	<WORK
		CMP	#0B4H
		BCC	MENTST_120
		LDA	#0B4H
MENTST_120
		STA	!MENTIM
		JSR	KEYBGWE
		RTS
;
MENTST_300
		JSL	>RANDAM
		LDA	!RANDM0
		AND	#01111111B
		CLC
		ADC	#30H
		STA	!MENTIM		; enemy timer
;
		STA	04204H
		STZ	04205H
		LDA	!KYKAZU
		INC	A
		STA	04206H
		NOP
		NOP
		NOP
		NOP
		NOP
		NOP
		NOP
		NOP
		LDA	04214H
		STA	<WORK
		LDA	!KYKAZU
		ASL	A
		STA	<WORKA
		LDX	#0
		STZ	<WORK2
MENTST_700
		LDA	<WORK
		STA	!KEYBUF,X
		CLC
		ADC	<WORK2
		STA	<WORK2
		INX
		INX
		CPX	<WORKA
		BNE	MENTST_700
		LDA	!MENTIM
		SEC
		SBC	<WORK2
		STA	!KEYBUF,X
;
		JSL	>RANDAM
		LDA	!RANDM0
		AND	#00000110B
		TAX
		JSR	(MENTST_TBL,X)
;
		JSR	KEYBGWE
		STZ	!KYINDX
;
		RTS
;
MENTST_TBL	EQU	$
		WORD	ENTNK1
		WORD	ENTNK1
		WORD	ENTNK2
		WORD	ENTNK2
;
ENTNK0		EQU	$
		RTS
;
ENTNK1		EQU	$	; quik
		LDA	!KYKAZU
		ASL	A
		TAY
		STZ	<WORK
ENTNK1_100
		LDA	!KEYBUF,Y
		SEC
		SBC	#8
		CLC
		ADC	<WORK
		STA	<WORK
		LDA	#8
		STA	!KEYBUF,Y
		DEY
		DEY
		CPY	#2
		BNE	ENTNK1_100
		LDA	<WORK
		LSR	A
		CLC
		ADC	!KEYBUF
		STA	!KEYBUF
		INC	A
		STA	!KEYBUF+2
		RTS
;
ENTNK2		EQU	$	; tame nage
		LDA	!KYKAZU
		DEC	A
		ASL	A
		TAY
		PHY
		STZ	<WORK
;
ENTNK2_100
		LDA	!KEYBUF,Y
		SEC
		SBC	#8
		CLC
		ADC	<WORK
		STA	<WORK
		LDA	#8
		STA	!KEYBUF,Y
		DEY
		DEY
		BPL	ENTNK2_100
;
		PLY
		LDA	!KEYBUF+2,Y
		CLC
		ADC	<WORK
		STA	!KEYBUF+2,Y
;
		RTS
;
;
;########################################################################
;# (LABEL)	MPLCST		(player chr set)			#
;########################################################################
MPLCST		EQU	$
		LDA	!NEXTGOTO	; ~jQ[ I ?
		BNE	MPLCST_900	;	NO -> MPLCST_900
		M16
		LDA	!ENXPSL
		STA	!PLXPSL
		LDA	!ENYPSL
		STA	!PLYPSL
		M8
MPLCST_900	EQU	$
		JSL	>PLCSET
		RTS
;
;########################################################################
;# (LABEL)	MPLMOV		(mini game player move)			#
;########################################################################
MPLMOV		EQU	$
		LDA	!ENWRK0
		ASL	A
		TAY
		LDA	MPLMOV_TBL,Y
		STA	<WORK
		LDA	MPLMOV_TBL+1,Y
		STA	<WORK1
		JMP	(WORK)
;
MPLMOV_TBL	EQU	$
		WORD	MPLWIT		; player wait
		WORD	MPLKEY		; player key input
		WORD	MPLJMP		; player jump
		WORD	MPLDIE		; player die
		WORD	MPLWIN		; player win
;
;########################################################################
;# (LABEL)	MPLWIT		(player wait)				#
;########################################################################
MPLWIT		EQU	$
		JSL	>RANDAM
;
		M16
;
		M_CHIPS PL_STOP_PATN
;
		M8
;
		RTS
;
;########################################################################
;# (LABEL)	MPLKEY		(player key input)			#
;########################################################################
MPLKEY		EQU	$
		JSR	PLKYCK
;
		LDY	!ENCIDX
		LDA	!ENCTIM
		BEQ	MPLKEY_800
		DEC	!ENCTIM
		BRA	MPLKEY_850
MPLKEY_800
		INY
		CPY	#04H
		BCC	MPLKEY_820
		LDY	#0
MPLKEY_820
		STY	!ENCIDX
		LDA	MPLKEY_TIMTBL,Y
		STA	!ENCTIM
MPLKEY_850
		LDA	MPLKEY_CHRTBL,Y
		STA	!PLPATN
;
		RTS
;
MPLKEY_CHRTBL	EQU	$
		BYTE	P00D
		BYTE	P000
		BYTE	P107
		BYTE	P000
MPLKEY_TIMTBL	EQU	$
		HEX	20,06,06,06
;
;########################################################################
;# (LABEL)	MPLJMP		(player jump)				#
;########################################################################
MPLJMP		EQU	$
		LDA	#20H
		STA	<WORK
		LDA	#4
		STA	<WORK2
		LDX	#0
		TXA
		JSR	GCALCY
;
		LDA	!ENYPSL
		CMP	#0B0H
		BCC	MPLJMP_100
		LDA	#0B0H
		STA	!ENYPSL
		STZ	!ENWRK0
		STZ	!ENCIDX
		STZ	!ENCTIM
MPLJMP_100
;
		LDA	!ENYCL0
		BPL	MPLJMP_500
		LDA	#P006
		BRA	MPLJMP_600
MPLJMP_500
		LDA	#P007
MPLJMP_600
		STA	!PLPATN
;
		RTS
;
;########################################################################
;# (LABEL)	MPLDIE		(player die)				#
;########################################################################
MPLDIE		EQU	$
		LDY	!ENCIDX
		LDA	!ENCTIM
		BEQ	MPLDIE_800
		DEC	!ENCTIM
		BRA	MPLDIE_850
MPLDIE_800
		INY
		CPY	#11H
		BCC	MPLDIE_820
		LDY	#10H
MPLDIE_820
		STY	!ENCIDX
		LDA	MPLDIE_TIMTBL,Y
		STA	!ENCTIM
MPLDIE_850
		LDA	MPLDIE_CHRTBL,Y
		STA	!PLPATN
;
		CPY	#10H
		BNE	MPLDIE_880
		LDA	!ENXPSL
		CLC
		ADC	#28H
		STA	!ENXPSL+8
		LDA	!ENYPSL
		CLC
		ADC	#24H
		STA	!ENYPSL+8
		JSR	MEPIYO
MPLDIE_880
;
		RTS
;
MPLDIE_CHRTBL	EQU	$
		BYTE	DM0A
		BYTE	DM09
		BYTE	DM08
		BYTE	DM07
		BYTE	DM06
		BYTE	DM05
		BYTE	DM0A
		BYTE	DM09
		BYTE	DM08
		BYTE	DM07
		BYTE	DM06
		BYTE	DM05
		BYTE	DM02
		BYTE	DM03
		BYTE	DM04
		BYTE	DM03
		BYTE	DM04
MPLDIE_TIMTBL	EQU	$
		HEX	03,03,03,03,03,03,03,03,03,03,03,03,03,03,03,03,03
;
		RTS
;
;########################################################################
;# (LABEL)	MPLWIN		(player win)				#
;########################################################################
MPLWIN		EQU	$
		LDA	!MN2PLY
		BEQ	MPLWIN_100
;
		LDY	#0
		BRA	MPLWIN_600
MPLWIN_100
		DEC	!ENWRK4
		LDA	!ENWRK4
		BNE	MPLWIN_300
;
		LDA	!ENWRK2
		INC	A
		INC	A
		CMP	#1EH
		BCC	MPLWIN_200
;
		LDA	#1EH
MPLWIN_200
		STA	!ENWRK2
		LSR	A
		TAY
		LDA	MPLWIN_FDT,Y
		STA	!ENWRK4
		CPY	#4
		BNE	MPLWIN_300
;
		LDA	#0FCH
		STA	!ENYCL0
		STZ	!ENYCL1
		STZ	!ENYPS2
MPLWIN_300
		LDA	!ENYCL0
		BNE	MPLWIN_400
;
		LDA	!ENYPSL
		CMP	#0B0H
		BEQ	MPLWIN_500
MPLWIN_400
		LDA	#20H
		STA	<WORK
		LDA	#4
		STA	<WORK2
		LDX	#0
		TXA
		JSR	GCALCY
		LDA	!ENYPSL
		CMP	#0B0H
		BCC	MPLWIN_500
;
		LDA	#0B0H
		STA	!ENYPSL
		STZ	!ENYCL0
		STZ	!ENYCL1
		STZ	!ENYPS2
MPLWIN_500
		LDY	!ENWRK2
MPLWIN_600
		M16
		LDA	MPLWIN_CDT,Y
		STA	!PLPATN
		M8
;
		RTS
;
MPLWIN_CDT	EQU	$
		WORD	P000,B201,B211,B212,B206,PD09,PD0A,PD0B
		WORD	PD0C,PD0D,PD0E,PD0F,B211,B212,B211,P000
MPLWIN_FDT	EQU	$
		HEX	30,20,02,08,0C,03,03,03,03,03,03,22,02,04,02,FF
;
;########################################################################
;# (LABEL)	MEPIYO		(piyo piyo star)			#
;########################################################################
MEPIYO		EQU	$
		LDA	!ENCTIM+8
		BEQ	MEPIYO_050
		DEC	!ENCTIM+8
		BRA	MEPIYO_200
MEPIYO_050
		INC	!ENCIDX+8
		LDA	#3
		STA	!ENCTIM+8
		LDA	!ENCIDX+8
		CMP	#6
		BNE	MEPIYO_200
		STZ	!ENCIDX+8
MEPIYO_200
		LDA	!ENCIDX+8
		ASL	A
		ASL	A
		ASL	A
		TAX
		MI16
		LDA	#4
		STA	<WORK
		LDY	!OAMIDX
;
MEPIYO_100
		LDA	MEPIYO_XPSDT,X
		CLC
		ADC	!ENXPSL+8
		STA	!SOAM_DX,Y
		LDA	#0FFE0H
		CLC
		ADC	!ENYPSL+8
		STA	!SOAM_DX+2,Y
		LDA	MEPIYO_CHRDT,X
		STA	!SOAM_DX+4,Y
		LDA	#0
		STA	!SOAM_DX+6,Y
		INX
		INX
		TYA
		CLC
		ADC	#8
		TAY
		DEC	<WORK
		BNE	MEPIYO_100
		STY	!OAMIDX
;
		MI8
		RTS
;
MEPIYO_XPSDT	EQU	$
		WORD	0FFECH,0FFECH,0FFF8H,0FFE0H
		WORD	0FFEFH,0FFE9H,0FFF7H,0FFE1H
		WORD	0FFE2H,0FFF2H,0FFE6H,0FFF6H
		WORD	0FFE4H,0FFF4H,0FFE4H,0FFF4H
		WORD	0FFE6H,0FFF6H,0FFE2H,0FFF2H
		WORD	0FFE9H,0FFF7H,0FFE1H,0FFEFH
MEPIYO_CHRDT	EQU	$
		WORD	351AH,350AH,350AH,351AH
		WORD	351AH,350AH,350AH,351AH
		WORD	351AH,351AH,350AH,350AH
		WORD	351AH,351AH,350AH,350AH
		WORD	351AH,351AH,350AH,350AH
		WORD	351AH,351AH,350AH,350AH
;
;########################################################################
;# (LABEL)	FSBUYO		(fusen buyobuyo)			#
;########################################################################
FSBUYO		EQU	$
		LDY	!FSNIDX
		INC	!FSNTIM
		LDA	!FSNTIM
		CMP	FSBUYO_TIMDT,Y
		BCC	FSBUYO_050
		STZ	!FSNTIM
		INC	!FSNIDX
FSBUYO_050
		TYA
		ASL	A
		TAY
		LDA	FSBUYO_TBL,Y
		STA	<WORK
		LDA	FSBUYO_TBL+1,Y
		STA	<WORK1
		JMP	(WORK)
;;;		TYX
;;;		JMP	(FSBUYO_TBL,X)
FSBUYO_TBL	EQU	$
		WORD	FSBUYO_100
		WORD	FSBUYO_300
		WORD	FSBUYO_300
		WORD	FSBUYO_100
		WORD	FSBUYO_100
		WORD	FSBUYO_300
		WORD	FSBUYO_300
		WORD	FSBUYO_100
		WORD	FSBUYO_100
FSBUYO_100
		M16
		LDA	!ZMSCCV
		SEC
		SBC	FSBUYO_TIMDT2,Y
		STA	!ZMSCCV
		LDA	!ZMSCCH
		CLC
		ADC	FSBUYO_TIMDT2,Y
		CMP	#01FFH
		BCC	FSBUYO_200
		LDA	#01FFH
FSBUYO_200
		STA	!ZMSCCH
		BRA	FSBUYO_500
FSBUYO_300
		M16
		LDA	!ZMSCCH
		SEC
		SBC	FSBUYO_TIMDT2,Y
		STA	!ZMSCCH
		LDA	!ZMSCCV
		CLC
		ADC	FSBUYO_TIMDT2,Y
		CMP	#01FFH
		BCC	FSBUYO_400
		LDA	#01FFH
FSBUYO_400
		STA	!ZMSCCV
FSBUYO_500
		M8
;
		RTS
;
FSBUYO_TIMDT	EQU	$
		HEX	10,13,10,10,0E,0E,0E,0E,0E,0E
FSBUYO_TIMDT2	EQU	$
		WORD	0006H,0005H,0004H,0004H,0004H,0004H,0004H,0003H,0003H,0003H
;
;########################################################################
;# (LABEL)	GCALCY		(Ypos G power)				#
;#		     (X) -- Index					#
;#		     (A) -- 0 : No fly calc				#
;#			    1 : Fly calc				#
;#		    WORK -- G	Power					#
;#		  WORK+1 -- Fly	  "                                     #
;#		  WORK+2 -- Max down dot				#
;#	 JSR	  GCALC	    [ G power calclate ]			#
;########################################################################
GCALCY		EQU	$
		PHA
;
		LDA	!ENYPS2,X		; New (y) position calclate !
		CLC
		ADC	!ENYCL1,X
		STA	!ENYPS2,X
;
		LDY	#0
		LDA	!ENYCL0,X
		BPL	CALY10
;
		DEY
;
CALY10
		STY	<WORK+7
;
		ADC	!ENYPSL,X
		STA	!ENYPSL,X
;
		LDA	!ENYPSH,X
		ADC	<WORK+7
		STA	!ENYPSH,X
;
		LDA	!ENYCL1,X		; G power calclate !
		CLC
		ADC	<WORK
		STA	!ENYCL1,X
;
		LDA	!ENYCL0,X
		ADC	#0
		STA	!ENYCL0,X
;
		CMP	<WORK+2
		BMI	CALY30
;
		LDA	!ENYCL1,X
		CMP	#80H
		BCC	CALY30
;
		LDA	<WORK+2
		STA	!ENYCL0,X
;
		STZ	!ENYCL1,X
;
CALY30
		PLA
		BEQ	CALY90
;
		LDA	<WORK+2	   ; Flying calclate !
		EOR	#0FFH
		INC	A
		STA	<WORK+7
;
		LDA	!ENYCL1,X
		SEC
		SBC	<WORK+1
		STA	!ENYCL1,X
;
		LDA	!ENYCL0,X
		SBC	#0
		STA	!ENYCL0,X
		CMP	<WORK+7
		BPL	CALY90
;
		LDA	!ENYCL1,X
		CMP	#80H
		BCS	CALY90
;
		LDA	<WORK+7
		STA	!ENYCL0,X
;
		LDA	#0FFH
		STA	!ENYCL1,X
;
CALY90
		RTS
;
;########################################################################
;# (LABEL)	GCALCX		(X pos calc)				#
;#		     (X) -- Index					#
;#	 JSR	  GCALCX    [ RT & LF (x) pos calc ]			#
;#		     (A) -- (x) move value				#
;########################################################################
GCALCX		EQU	$	    ; Speed value calclate !
		LDA	!ENXSPD,X
		ASL	A
		ASL	A
		ASL	A
		ASL	A
		STA	<WORK+1

		LDA	!ENXSPD,X
		LSR	A
		LSR	A
		LSR	A
		LSR	A
		CMP	#8
		BCC	CALX60
;
		ORA	#11110000B
;
CALX60
		STA	<WORK
;
		LDY	#0
		CMP	#0
		BPL	CALX70
;
		DEY
;
CALX70
		STY	<WORK+2
;
		LDA	!ENXPS2,X   ; New (x) position calclate !
		CLC
		ADC	<WORK+1
		STA	!ENXPS2,X
;
		LDA	#0
		ROL	A
		PHA
		ROR	A
;
		LDA	!ENXPSL,X
		ADC	<WORK
		STA	!ENXPSL,X
;
		LDA	!ENXPSH,X
		ADC	<WORK+2
		STA	!ENXPSH,X
;
		PLA
		CLC
		ADC	<WORK		   ; Ar <-- (x) Move value
;
CALRTS
		RTS
;
;########################################################################
;# (LABEL)	KOBJST		(kaiten obj paramater set)		#
;########################################################################
KOBJST		EQU	$
		LDA	!MSGMOD		; bZ[W EBhD nm ?
		BNE	KOBJST_990	;	YES -> KOBJST_990
KOBJST_SUB	EQU	$
		M16
		LDA	!ZMSCCV			;(R11) <- x{iPOOgPDOj
		STA	R11			;
;
		LDA	!ZMSCCH			;(R6) <- w{iPOOgPDOj
		STA	R6			;
;
		LDA	!ANGLE			;(R5) <- ]piO`eegj
		STA	R5			;
;
		LDA	#BANK CIPCHD2+40E0H+001 ;chara data bank set
		STA	R13
		LDA	#CIPCHD2+40E0H+001	;chara data address set
		STA	R12
;
		STZ	R3			;]GAw@onrDZbg
		STZ	R2			;]GAx@onrDZbg
;
		M_CHIP	C_64_RTZ_32_XY
;
		INC	OBM7WF			;mode 7 OBJ chara DMA "ON"
;
		MI8
KOBJST_990	EQU	$
		RTS
;
;########################################################################
;# (LABEL)	MBG2TR		(mini game bg2 screen transfer)		#
;########################################################################
MBG2TR		EQU	$
		MI16			; memory , index 16bit mode
		LDA	!WINFLG
		BEQ	MBG2TR_100
		LDA	#MIN2A2
		BRA	MBG2TR_200
MBG2TR_100
		LDA	#MIN2A1
MBG2TR_200
		STA	<WORK
		ASL	A
		CLC
		ADC	<WORK
;
		TAX
		LDA	>ADDSTART+(NO_PRES*3),X
		STA	R9		;(R9)  <-- pless data address(L,H)
		LDA	>ADDSTART+(NO_PRES*3)+2,X
		AND	#000FFH
		STA	R4		;(R4)  <--	    "        (B)
		LDA	#MSGBITMP
		STA	R10		;(R10) <-- data store address
;
		I8			; index 8bit mode
;
		M_CHIP	DT_UNCOMPRESS
;
		MI16
		LDX	#MSGBITMP
		LDA	#BANK MSGBITMP
		STA	<WORK1
		LDY	#3C00H
		LDA	#0800H
		JSL	>VRAMDX_ST
;
		MI8
		RTS
;
;
;
;########################################################################
;# (LABEL)	MHDPLY		(hdma shori)				#
;########################################################################
MHDPLY_JSL	EQU	$
		M8
		PHB
		LDA	#BANK MHDPLY_TBL
		PHA
		PLB
		JSR	MHDPLY
		PLB
;
		RTL
;
MHDPLY		EQU	$
		M8
		LDA	!HDMMOD
		DEC	A
		ASL	A
		TAY
		LDA	MHDPLY_TBL,Y
		STA	<WORK
		LDA	MHDPLY_TBL+1,Y
		STA	<WORK1
		JMP	(WORK)
;
MHDPLY_TBL	EQU	$
		WORD	MHDINT
		WORD	MHDSCR
		WORD	MHDWIT
;
;########################################################################
;# (LABEL)	MHDWIT		(hdma end & wait)			#
;########################################################################
MHDWIT		EQU	$
		M16
		DEC	!SCCV2
		INC	!SCCH2
;
		LDA	!WINFLG
		BNE	MHDWIT_300
;
		LDA	!ITGTFG
		BEQ	MHDWIT_500
;
		LDA	MINIMD
		CMP	#00014H
		BEQ	MHDWIT_300	; Ń{blp@H
;					; No !!
		LDA	!PLJUMP
		BNE	MHDWIT_500
;
MHDWIT_300
		LDA	#1
		STA	!GMSTOP
		DEC	!WAITTM
		BNE	MHDWIT_500
		JSL	>BACK_GAME
MHDWIT_500
		M8
		LDA	!MSNDTM
		BEQ	MHDWIT_600
;
		DEC	!MSNDTM
		BNE	MHDWIT_600
;
		LDA	!MINIMD
		CMP	#6
		BCC	MHDWIT_600
;
		CMP	#14H
		BCS	MHDWIT_600
;
		LDA	#6
		STA	!SOUND_0
MHDWIT_600
;
		RTS
;
;########################################################################
;# (LABEL)	MHDINT		(hdma initial)				#
;########################################################################
MHDINT		EQU	$
		JSR	MBG2TR
		M8			; memory 8bit mode
		LDA	#01000010B		;HDMA;
		STA	4350H
		LDA	#LOW 210FH
		STA	4351H
		LDA	#LOW HDMAPR1
		STA	4352H
		LDA	#HIGH HDMAPR1
		STA	4353H
		LDA	#BANK HDMAPR1
		STA	4354H
		LDA	#BANK HDMABUF1
		STA	4357H
;
		PHB
		LDA	#BANK HDMABUF1
		PHA
		PLB
;
		STZ	!HDMABUF1
		STZ	!HDMABUF1+2
		STZ	!HDMAPR1+21	; end code !!
;
		LDA	#020H
		STA	!HDMAPR1
		STA	!HDMAPR1+3
		STA	!HDMAPR1+6
		STA	!HDMAPR1+9
		STA	!HDMAPR1+12
		STA	!HDMAPR1+15
		STA	!HDMAPR1+18
;
		M16			; memory 16bit mode
;
		LDA	#HDMABUF1+000H
		STA	!HDMAPR1+1
		STA	!HDMAPR1+7
		STA	!HDMAPR1+13
		STA	!HDMAPR1+19
;
		LDA	#HDMABUF1+002H
		STA	!HDMAPR1+4
		STA	!HDMAPR1+10
		STA	!HDMAPR1+16
;
		M8			; memory 8bit mode
		PLB
;
		LDX	!WINFLG
		LDA	MHDINT_SOUND,X
		STA	!SOUND_0
;
		LDA	#00100000B
		TSB	!HD420C
		INC	!HDMMOD
;
		LDA	!FGMFLG
		BEQ	MHDINT_900
;
		JSR	KYBGCL
MHDINT_900
		JSR	MBGMSG
;
		JSL	>WINDON2
;
		RTS
;
MHDINT_SOUND	EQU	$
		HEX	05,07,06
;
;########################################################################
;# (LABEL)	MHDSCR		(hdma scroll)				#
;########################################################################
MHDSCR		EQU	$
;
		M16
		LDA	!HDMCNT
		CLC
		ADC	#8
		STA	!HDMCNT
		CMP	#0100H
		BCC	MHDSCR_600
;
		M8
;
		LDA	!HD420C
		EOR	#00100000B
		STA	!HD420C
;
		LDA	#1
		STA	!SCCH2+1
		STZ	!SCCH2
		LDA	#3CH
		STA	!BG2SCF
		STA	02108H
;
		INC	!HDMMOD
;
		LDA	!WINFLG
		BNE	MHDSCR_350
;
		LDA	!MINIMD
		CMP	#6
		BCC	MHDSCR_350
;
		CMP	#14H
		BCC	MHDSCR_400
;
MHDSCR_350
		LDA	#0E0H
		BRA	MHDSCR_500
;
MHDSCR_400
		LDA	#1
MHDSCR_500
		STA	!WAITTM
		LDA	#0FFH
		STA	!MSNDTM
MHDSCR_600
		M8
;
		RTS
;
;########################################################################
;# (LABEL)	MBGMSG		(mini game end masseg)			#
;########################################################################
MBGMSG		EQU	$
		MI16
		LDA	>VRAMD
		TAX
		LDA	!MN2PLY
		BEQ	MBGMSG_050
		LDA	#3
MBGMSG_050
		CLC
		ADC	!WINFLG
		ASL	A
		TAY
		LDA	MBGMSG_TBL,Y
		TAY
MBGMSG_100
		LDA	MBGMSG_WIN,Y
		STA	>VRAMD+2,X
		INX
		INX
		INY
		INY
		INC	A
		BNE	MBGMSG_100
		DEX
		DEX
		TXA
		STA	>VRAMD
		MI8
;
		RTS
;
MBGMSG_TBL	EQU	$
		WORD	MBGMSG_WIN-MBGMSG_WIN
		WORD	MBGMSG_LOSS-MBGMSG_WIN
		WORD	MBGMSG_DROW-MBGMSG_WIN
		WORD	MBGMSG_1PWIN-MBGMSG_WIN
		WORD	MBGMSG_2PWIN-MBGMSG_WIN
MBGMSG_WIN	EQU	$
		WORD	035ACH,0000FH,02520H,02521H,02522H,0217FH,02523H,02524H,0E532H,0A530H
		WORD	035CCH,0000FH,02530H,0A521H,0A521H,0217FH,02533H,02534H,02532H,02529H,0FFFFH
MBGMSG_1PWIN	EQU	$
		WORD	035AAH,00019H,0254EH,0217FH,02527H,02525H,02521H,02520H,02526H,02527H,0217FH,02523H,02524H,0E532H,0A530H
		WORD	035CAH,00019H,0255EH,0217FH,02539H,02535H,02536H,02530H,02535H,02537H,0217FH,02533H,02534H,02532H,02529H,0FFFFH
MBGMSG_2PWIN	EQU	$
		WORD	035AAH,00019H,02D4FH,0217FH,02D27H,02D25H,02D21H,02D20H,02D26H,02D27H,0217FH,02D23H,02D24H,0ED32H,0AD30H
		WORD	035CAH,00019H,02D5FH,0217FH,02D39H,02D35H,02D36H,02D30H,02D35H,02D37H,0217FH,02D33H,02D34H,02D32H,02D29H,0FFFFH
MBGMSG_LOSS	EQU	$
		WORD	035ACH,0000FH,02D20H,02D21H,02D22H,0217FH,02D25H,02D21H,0ED31H,02D26H
		WORD	035CCH,0000FH,02D30H,0AD21H,0AD21H,0217FH,02D35H,0AD21H,02D31H,02D35H,0FFFFH
MBGMSG_DROW	EQU	$
		WORD	035AEH,00009H,02927H,02927H,02921H,02923H,02928H
		WORD	035CEH,00009H,0A927H,02937H,0A921H,02933H,02938H,0FFFFH
;
;########################################################################
;# (LABEL)	KYBGCL		(key bg clear)				#
;########################################################################
KYBGCL		EQU	$
		LDA	!KYKAZU
		SEC
		SBC	#3
		ASL	A
		TAX
;
		MI16
;
		LDA	KYBGCL_TBL,X
		TAY
		LDA	>VRAMD
		TAX
;
KYBGCL_200
		LDA	KYBGWK,Y
		STA	>VRAMD+2,X
		INX
		INX
		INY
		INY
		INC	A
		BNE	KYBGCL_200
		DEX
		DEX
		TXA
		STA	>VRAMD
;
		MI8
		RTS
;
KYBGCL_TBL	EQU	$
		WORD	KYBG04-KYBGWK
		WORD	KYBG05-KYBGWK
		WORD	KYBG06-KYBGWK
KYBGWK		EQU	$
KYBG04		EQU	$
		WORD	034C5H,08007H,0A555H,02545H,02545H,02545H
		WORD	034DAH,08007H,0E555H,06545H,06545H,06545H
		WORD	034C6H,04027H,0A556H
		WORD	03547H,04023H,02560H
		WORD	03567H,04023H,02560H
		WORD	068E7H,04023H,000FFH
		WORD	06907H,04023H,000FFH
		WORD	06927H,04023H,000FFH
		WORD	03545H,00003H,02565H,02566H
		WORD	03565H,00003H,02555H,02576H
		WORD	03559H,00003H,06572H,06570H
		WORD	03579H,00003H,06574H,06573H
		WORD	0FFFFH
KYBG05		EQU	$
		WORD	034C3H,08007H,0A555H,02545H,02545H,02545H
		WORD	034DCH,08007H,0E555H,06545H,06545H,06545H
		WORD	034C4H,0402FH,0A556H
		WORD	03545H,04027H,02560H
		WORD	03565H,04027H,02560H
		WORD	068E5H,0402BH,000FFH
		WORD	06905H,0402BH,000FFH
		WORD	06925H,0402BH,000FFH
		WORD	03543H,00007H,02570H,02571H,02567H,02566H
		WORD	03563H,00007H,02573H,02574H,02575H,02576H
		WORD	03559H,00007H,06572H,02571H,02571H,06570H
		WORD	03579H,00007H,06574H,02574H,02574H,06573H
		WORD	0FFFFH
KYBG06		EQU	$
		WORD	034C1H,08007H,0A555H,02545H,02545H,02545H
		WORD	034DEH,08007H,0E555H,06545H,06545H,06545H
		WORD	034C2H,04037H,0A556H
		WORD	03543H,0402BH,02560H
		WORD	03563H,0402BH,02560H
		WORD	068E3H,04033H,000FFH
		WORD	06903H,04033H,000FFH
		WORD	06923H,04033H,000FFH
		WORD	03541H,0000BH,02570H,02571H,02571H,02571H,02567H,02566H
		WORD	03561H,0000BH,02573H,02574H,02574H,02574H,02575H,02576H
		WORD	03559H,0000BH,06572H,02571H,02571H,02571H,02571H,06570H
		WORD	03579H,0000BH,06574H,02574H,02574H,02574H,02574H,06573H
		WORD	0FFFFH
;
;########################################################################
;# (LABEL)	KEYSET		(key data set)				#
;########################################################################
KEYSET		EQU	$
		M16
		LDA	!KYWTWK
		STA	!KYWTTM		; key input wait timer
		STZ	MATCNT
		LDA	#48H
		STA	MATTIM
		STZ	!KYINDX		; key index counter clear
		JSR	MATSET
		M16
;
		LDA	!KYKAZU		; key input kazu
		ASL	A
		TAX
KEYSET_100
		JSL	>RANDAM
		LDA	!RANDM0
		AND	#00001110B
		TAY
		LDA	KEYDAT,Y
		CMP	!KEYBUF+2,X
		BEQ	KEYSET_100
		STA	!KEYBUF,X	; cmp,key buff
		LDA	KEYBGDT,Y
		STA	!KBGBUF,X	; bg put,key buff
		DEX
		DEX
		BPL	KEYSET_100
		M8
		RTS
;
;########################################################################
;# (LABEL)	KEYBGW		(key bg write)				#
;########################################################################
KEYBGW		EQU	$
		MI16
;
		LDX	!KYKAZU
		LDA	CENPOS_DAT,X
		AND	#00FFH
		STA	<WORKA		;centerling xpos
;
		LDA	>VRAMD
		TAX
;
		LDA	#68A4H
		CLC
		ADC	<WORKA
		STA	>VRAMD+02,X
		LDA	!KYKAZU
		INC	A
		ASL	A
		ASL	A
		DEC	A
		ASL	A
		DEC	A
		ORA	#4000H
		STA	>VRAMD+04,X
		LDA	#31DFH
		STA	>VRAMD+06,X
		TXA
		CLC
		ADC	#6
		TAX
;
		LDY	#0
KEYSET_200
		TYA
		ASL	A
		ASL	A
		CLC
		ADC	#6884H
		CLC
		ADC	<WORKA
		STA	>VRAMD+2,X
		CLC
		ADC	#0020H
		STA	>VRAMD+12,X
		CLC
		ADC	#0020H
		STA	>VRAMD+22,X
		LDA	#0005H
		STA	>VRAMD+4,X
		STA	>VRAMD+14,X
		STA	>VRAMD+24,X
		PHY
		TYA
		ASL	A
		TAY
		LDA	!KBGBUF,Y
		TAY
		LDA	KBGRIG,Y
		STA	>VRAMD+6,X
		LDA	KBGRIG+2,Y
		STA	>VRAMD+8,X
		LDA	KBGRIG+4,Y
		STA	>VRAMD+10,X
		LDA	KBGRIG+6,Y
		STA	>VRAMD+16,X
		LDA	KBGRIG+8,Y
		STA	>VRAMD+18,X
		LDA	KBGRIG+10,Y
		STA	>VRAMD+20,X
		LDA	KBGRIG+12,Y
		STA	>VRAMD+26,X
		LDA	KBGRIG+14,Y
		STA	>VRAMD+28,X
		LDA	KBGRIG+16,Y
		STA	>VRAMD+30,X
		PLY
		TXA
		CLC
		ADC	#030
		TAX
		CPY	!KYKAZU
		BEQ	KEYSET_400
		INY
		JMP	KEYSET_200
KEYSET_400					; waku bg set
;
		LDA	#0FFFFH
		STA	>VRAMD+2,X
		TXA
		STA	>VRAMD
		MI8
;
		RTS
;
KEYDAT		EQU	$		; key compear data
;			righr  left  down   up	  B	Y     A	    X
		WORD	0100H,0200H,0400H,0800H,8000H,4000H,0080H,0040H
KEYBGDT		EQU	$
		WORD	KBGRIG-KBGRIG
		WORD	KBGLFT-KBGRIG
		WORD	KBGDWN-KBGRIG
		WORD	KBGUP-KBGRIG
		WORD	KBGTRB-KBGRIG
		WORD	KBGTRY-KBGRIG
		WORD	KBGTRA-KBGRIG
		WORD	KBGTRX-KBGRIG
KBGRIG		EQU	$		; key right bg data
		WORD	03DCCH,03DCDH,075CCH
		WORD	03DDCH,03DDDH,075DCH
		WORD	0BDCCH,0BDCDH,0F5CCH
KBGLFT		EQU	$		; key left bg data
		WORD	035CCH,03DCDH,07DCCH
		WORD	035DCH,03DDDH,07DDCH
		WORD	0B5CCH,0BDCDH,0FDCCH
KBGDWN		EQU	$		; key down bg data
		WORD	03DCCH,03DCDH,07DCCH
		WORD	03DDCH,03DDDH,07DDCH
		WORD	0B5CCH,0B5CDH,0F5CCH
KBGUP		EQU	$		; key up bg data
		WORD	035CCH,035CDH,075CCH
		WORD	03DDCH,03DDDH,07DDCH
		WORD	0BDCCH,0BDCDH,0FDCCH
KBGTRB		EQU	$		; key triger B bg data
		WORD	029CEH,029CFH,069CEH
		WORD	029DEH,029EFH,069DEH
		WORD	0A9CEH,0A9CFH,0E9CEH
KBGTRY		EQU	$		; key triger Y bg data
		WORD	02DCEH,02DCFH,06DCEH
		WORD	02DDEH,02DFEH,06DDEH
		WORD	0ADCEH,0ADCFH,0EDCEH
KBGTRA		EQU	$		; key triger A bg data
		WORD	035CEH,035CFH,075CEH
		WORD	035DEH,035EEH,075DEH
		WORD	0B5CEH,0B5CFH,0F5CEH
KBGTRX		EQU	$		; key triger X bg data
		WORD	031CEH,031CFH,071CEH
		WORD	031DEH,031FFH,071DEH
		WORD	0B1CEH,0B1CFH,0F1CEH
;
CENPOS_DAT	EQU	$		; bg center awase data
		HEX	00,00,00,64,62,60
;
;########################################################################
;# (LABEL)	KEYBGWE		(enemy key bg write)			#
;########################################################################
KEYBGWE		EQU	$
		MI16
;
		LDX	!KYKAZU
		LDA	CENPOS_DAT,X
		AND	#00FFH
		STA	<WORKA		;centerling xpos
;
		LDA	>VRAMD
		TAX
;
		LDA	#68A4H
		CLC
		ADC	<WORKA
		STA	>VRAMD+02,X
		LDA	!KYKAZU
		INC	A
		ASL	A
		ASL	A
		DEC	A
		ASL	A
		DEC	A
		ORA	#4000H
		STA	>VRAMD+04,X
		LDA	#31DFH
		STA	>VRAMD+06,X
		TXA
		CLC
		ADC	#6
		TAX
;
		LDY	#0
KEYBGWE_200
		TYA
		ASL	A
		ASL	A
		CLC
		ADC	#6884H
		CLC
		ADC	<WORKA
		STA	>VRAMD+2,X
		CLC
		ADC	#0020H
		STA	>VRAMD+12,X
		CLC
		ADC	#0020H
		STA	>VRAMD+22,X
		LDA	#0005H
		STA	>VRAMD+4,X
		STA	>VRAMD+14,X
		STA	>VRAMD+24,X
;
		LDA	KBGHTN
		STA	>VRAMD+6,X
		LDA	KBGHTN+2
		STA	>VRAMD+8,X
		LDA	KBGHTN+4
		STA	>VRAMD+10,X
		LDA	KBGHTN+6
		STA	>VRAMD+16,X
		LDA	KBGHTN+8
		STA	>VRAMD+18,X
		LDA	KBGHTN+10
		STA	>VRAMD+20,X
		LDA	KBGHTN+12
		STA	>VRAMD+26,X
		LDA	KBGHTN+14
		STA	>VRAMD+28,X
		LDA	KBGHTN+16
		STA	>VRAMD+30,X
		TXA
		CLC
		ADC	#030
		TAX
		CPY	!KYKAZU
		BEQ	KEYBGWE_400
		INY
		JMP	KEYBGWE_200
KEYBGWE_400					; waku bg set
;
		LDA	#0FFFFH
		STA	>VRAMD+2,X
		TXA
		STA	>VRAMD
		MI8
;
		RTS
;
KBGHTN		EQU	$
		WORD	075EDH,035ECH,035EDH
		WORD	035FBH,035FCH,035FDH
		WORD	034FFH,035EBH,034FFH
;
;########################################################################
;# (LABEL)	PLKYCK		(player key check)			#
;########################################################################
PLKYCK		EQU	$
		LDA	!BADCNT		; machigai wait timer
		BEQ	PLKYCK_00A
		DEC	!BADCNT
		BNE	PLKYCK_00B
		STZ	!KYINDX		; key index counter clear
		JSR	KEYBGW
PLKYCK_00B
		JSR	BADCST
		RTS
PLKYCK_00A
		JSR	KYTMPT
		M16
		DEC	!KYWTTM		; key wait timer
		BNE	PLKYCK_100
PLKYCK_000
		LDA	#90H		; fuseikai sound
		JSL	>SOUND_3_ON
		LDA	#20H
		STA	!BADCNT
		LDA	!KYWTWK
		STA	!KYWTTM		; timer repeat set
		M16
		LDA	#48H
		STA	!MATTIM
		STZ	!MATCNT
		JSR	MATSET
		JMP	PLKYCK_900
PLKYCK_100
		JSR	MCSRST
		M16
		LDA	!KYINDX
		ASL	A
		TAX
		LDA	<KEYC2L		; key in?
		BEQ	PLKYCK_900	; !no
		CMP	!KEYBUF,X	; key in seikai?
		BNE	PLKYCK_000	; !no
		LDA	#8FH		; seikai sound
		JSL	>SOUND_3_ON
		INC	!KYINDX
		LDA	!KYKAZU
		CMP	!KYINDX		; key perfect
		BCC	PLKYCK_700	; !yes
		JSR	KYENBG		; key nyuuryoku end bg
		BRA	PLKYCK_900
PLKYCK_700
		LDA	#13H
		JSL	>SOUND_3_ON
		LDA	#8		; perfect sound
		JSL	>SOUND_3_ON
		LDA	#34H
		JSL	>SOUND_3_ON
		M8
		LDA	#2
		STA	!ENWRK0
		LDA	#1
		STA	!ENWRK0+4
		STZ	!ENCTIM
		STZ	!ENCIDX
		LDA	#0FDH
		STA	!ENYCL0
		LDA	#0FDH
		STA	!ENYCL0+4
		STZ	!ENYCL1
		STZ	!ENYCL1+4
		STZ	!ENYPS2
		STZ	!ENYPS2+4
		LDA	#010H
		STA	!ENXSPD+4
		STZ	!ENXPS2+4
		STZ	!FSNTIM
		STZ	!FSNIDX
		JSR	KYBGCL		; key bg clear
;
PLKYCK_900
		M8
		RTS
;
;########################################################################
;# (LABEL)	KYENBG	(key nyuuryoku end bg)				#
;########################################################################
KYENBG		EQU	$
		MI16
;
		LDA	!KYKAZU
		DEC	A
		DEC	A
		DEC	A
		ASL	A
		STA	<WORK
		ASL	A
		ASL	A
		CLC
		ADC	<WORK
		STA	<WORK
		LDA	!KYINDX
		DEC	A
		ASL	A
		CLC
		ADC	<WORK
		TAY
		LDA	>VRAMD
		TAX
		LDA	KYENBG_ADR,Y
		STA	>VRAMD+02,X
		CLC
		ADC	#20H
		STA	>VRAMD+12,X
		CLC
		ADC	#20H
		STA	>VRAMD+22,X
		LDA	#0005H
		STA	>VRAMD+04,X
		STA	>VRAMD+14,X
		STA	>VRAMD+24,X
;
		LDA	!KYINDX
		DEC	A
		ASL	A
		TAY
		LDA	!KBGBUF,Y
		TAY
		LDA	KBGRIG,Y
		AND	#0E3FFH
		ORA	#01800H
		STA	>VRAMD+06,X
		LDA	KBGRIG+2,Y
		AND	#0E3FFH
		ORA	#01800H
		STA	>VRAMD+08,X
		LDA	KBGRIG+4,Y
		AND	#0E3FFH
		ORA	#01800H
		STA	>VRAMD+10,X
		LDA	KBGRIG+6,Y
		AND	#0E3FFH
		ORA	#01800H
		STA	>VRAMD+16,X
		LDA	KBGRIG+8,Y
		AND	#0E3FFH
		ORA	#01800H
		STA	>VRAMD+18,X
		LDA	KBGRIG+10,Y
		AND	#0E3FFH
		ORA	#01800H
		STA	>VRAMD+20,X
		LDA	KBGRIG+12,Y
		AND	#0E3FFH
		ORA	#01800H
		STA	>VRAMD+26,X
		LDA	KBGRIG+14,Y
		AND	#0E3FFH
		ORA	#01800H
		STA	>VRAMD+28,X
		LDA	KBGRIG+16,Y
		AND	#0E3FFH
		ORA	#01800H
		STA	>VRAMD+30,X
;
		LDA	#0FFFFH
		STA	>VRAMD+32,X
		TXA
		CLC
		ADC	#30
		STA	>VRAMD
;
		MI8
		RTS
;
KYENBG_ADR	EQU	$
		WORD	68E8H,68ECH,68F0H,0000H,0000H
		WORD	68E6H,68EAH,68EEH,68F2H,0000H
		WORD	68E4H,68E8H,68ECH,68F0H,68F4H
;
;########################################################################
;# (LABEL)	KYENBGE (key nyuuryoku end bg)				#
;########################################################################
KYENBGE		EQU	$
		MI16
;
		LDA	!KYKAZU
		DEC	A
		DEC	A
		DEC	A
		ASL	A
		STA	<WORK
		ASL	A
		ASL	A
		CLC
		ADC	<WORK
		STA	<WORK
		LDA	!KYINDX
		DEC	A
		ASL	A
		CLC
		ADC	<WORK
		TAY
		LDA	>VRAMD
		TAX
		LDA	KYENBG_ADR,Y
		STA	>VRAMD+02,X
		CLC
		ADC	#20H
		STA	>VRAMD+12,X
		CLC
		ADC	#20H
		STA	>VRAMD+22,X
		LDA	#0005H
		STA	>VRAMD+04,X
		STA	>VRAMD+14,X
		STA	>VRAMD+24,X
;
		LDA	KBGHTN
		AND	#0E3FFH
		ORA	#01800H
		STA	>VRAMD+06,X
		LDA	KBGHTN+2
		AND	#0E3FFH
		ORA	#01800H
		STA	>VRAMD+08,X
		LDA	KBGHTN+4
		AND	#0E3FFH
		ORA	#01800H
		STA	>VRAMD+10,X
		LDA	KBGHTN+6
		AND	#0E3FFH
		ORA	#01800H
		STA	>VRAMD+16,X
		LDA	KBGHTN+8
		AND	#0E3FFH
		ORA	#01800H
		STA	>VRAMD+18,X
		LDA	KBGHTN+10
		AND	#0E3FFH
		ORA	#01800H
		STA	>VRAMD+20,X
		LDA	KBGHTN+12
		AND	#0E3FFH
		ORA	#01800H
		STA	>VRAMD+26,X
		LDA	KBGHTN+14
		AND	#0E3FFH
		ORA	#01800H
		STA	>VRAMD+28,X
		LDA	KBGHTN+16
		AND	#0E3FFH
		ORA	#01800H
		STA	>VRAMD+30,X
;
		LDA	#0FFFFH
		STA	>VRAMD+32,X
		TXA
		CLC
		ADC	#30
		STA	>VRAMD
;
		MI8
		RTS
;
;########################################################################
;# (LABEL)	MCSRST		(mini game coursor chr set)		#
;########################################################################
MCSRST		EQU	$
		JSR	MCSRST_100
		JMP	MCSRST_200
MCSRST_100
		MI16
		LDY	!OAMIDX
;
		LDA	!KYKAZU
		DEC	A
		DEC	A
		DEC	A
		ASL	A
		TAX
		LDA	MCSRST_IDX,X
		STA	<WORK
		LDA	!KYINDX
		ASL	A
		ASL	A
		ASL	A
		ASL	A
		ASL	A
		CLC
		ADC	<WORK
		STA	!SOAM_DX+00H,Y
		STA	!SOAM_DX+10H,Y
		CLC
		ADC	#8
		STA	!SOAM_DX+08H,Y
		STA	!SOAM_DX+18H,Y
;
		LDA	!BADCNT
		BNE	MCSRST_150
		LDA	<FRCNT
		AND	#0010H
		BEQ	MCSRST_150
		LDA	#0026H
		BRA	MCSRST_170
MCSRST_150
		LDA	#0024H
MCSRST_170
		STA	!SOAM_DX+02H,Y
		STA	!SOAM_DX+0AH,Y
		CLC
		ADC	#8
		STA	!SOAM_DX+12H,Y
		STA	!SOAM_DX+1AH,Y
		RTS
;
MCSRST_200
		LDA	<FRCNT
		AND	#0010H
		BNE	MCSRST_300
;
		LDA	#3300H
		STA	!SOAM_DX+04H,Y
		ORA	#0010H
		STA	!SOAM_DX+14H,Y
		LDA	#7300H
		STA	!SOAM_DX+0CH,Y
		ORA	#0010H
		STA	!SOAM_DX+1CH,Y
		BRA	MCSRST_350
;
MCSRST_300
		LDA	#3300H
		STA	!SOAM_DX+04H,Y
		ORA	#0011H
		STA	!SOAM_DX+14H,Y
		LDA	#7300H
		STA	!SOAM_DX+0CH,Y
		ORA	#0011H
		STA	!SOAM_DX+1CH,Y
;
MCSRST_350
		MI16
		LDA	#0000H
		STA	!SOAM_DX+06H,Y
		STA	!SOAM_DX+0EH,Y
		STA	!SOAM_DX+16H,Y
		STA	!SOAM_DX+1EH,Y
;
		TYA
		CLC
		ADC	#0020H
		STA	!OAMIDX
		MI8
		RTS
;
MCSRST_IDX	EQU	$
		WORD	0044H,0034H,0024H
;
;########################################################################
;# (LABEL)	BADCST		(machigai batsu chr set)		#
;########################################################################
BADCST		EQU	$
		JSR	MCSRST_100
		MI16
		LDA	#3901H
		STA	!SOAM_DX+04H,Y
		LDA	#7901H
		STA	!SOAM_DX+0CH,Y
		LDA	#0B901H
		STA	!SOAM_DX+14H,Y
		LDA	#0F901H
		STA	!SOAM_DX+1CH,Y
		JMP	MCSRST_350
;
;########################################################################
;# (LABEL)	KYTMPT		(player key input timer put)		#
;########################################################################
KYTMPT		EQU	$
		INC	!MATCNT+1
		MI16
		LDA	!MATCNT
		SEC
		SBC	!KYWTCT
		BMI	KYTMPT_900
		STA	!MATCNT
		DEC	!MATTIM
;
		LDA	>VRAMD
		TAX
		LDA	#47H
		SEC
		SBC	!MATTIM
		LSR	A
		LSR	A
		CLC
		ADC	#03547H
		STA	>VRAMD+2,X
		LDA	#00001H
		STA	>VRAMD+4,X
		LDA	!MATTIM
		AND	#00000011B
		ASL	A
		TAY
		LDA	KYTMPT_DAT,Y
		STA	>VRAMD+6,X
		LDA	#0FFFFH
		STA	>VRAMD+8,X
		TXA
		CLC
		ADC	#6
		STA	>VRAMD
;
KYTMPT_900
		MI8
		RTS
;
KYTMPT_DAT	EQU	$
		WORD	2564H,2563H,2562H,2561H
;
;
;########################################################################
;# (LABEL)	MATSET		(mater set)				#
;########################################################################
MATSET		EQU	$
;
		MI16
;
		LDY	#0
		LDA	>VRAMD
		TAX
;
MATSET_200
		LDA	MATSET_DAT,Y
		STA	>VRAMD+2,X
		INX
		INX
		INY
		INY
		INC	A
		BNE	MATSET_200
		DEX
		DEX
		TXA
		STA	>VRAMD
;
		LDA	#48H
		STA	!MATTIM
		STZ	!MATCNT
;
		MI8
		RTS
;
MATSET_DAT	EQU	$
		WORD	03547H,04023H,02556H,0FFFFH
;
;
;########################################################################
;# (LABEL)	WINDON		(Score window on routine)		#
;########################################################################
WINDON		EQU	$
		LDX	#0
MSG_W100
		LDA	WIND_DT2,X
		STA	>HDMAPR0,X
		BEQ	MSG_W110
		INX
		BRA	MSG_W100
MSG_W110
;
		MI16			; memory , index 16bit mode
;
		LDX	#00200H/4-2
		LDA	#000FFH
MSG_W120	EQU	$		; EBhD obt@ NA !!
		STA	>HDMABUF0+000H,X
		STA	>HDMABUF0+080H,X
		STA	>HDMABUF0+100H,X
		STA	>HDMABUF0+180H,X
		DEX
		DEX
		BPL	MSG_W120
;
		M8			; memory 8bit mode
;
		LDX	#02641H
		STX	04330H		; inc. mode & B-bus address set

		LDX	#HDMAPR0
		STX	04332H		; A-bus address (L,H)
		LDA	#BANK HDMAPR0
		STA	04334H		;		(B)
;
		LDA	#BANK HDMABUF0
		STA	04337H		; data bank
;
		LDA	#00110000B
		STA	WIND23		; window mask (BG.2 , BG.1)
		LDA	#00110000B
		STA	WIND24		;	      (BG.4 , BG.3)
		LDA	#00100000B
		STA	WIND25		;	      (Col  , Obj )
		LDA	#00000000B
		STA	WMANSL		; window main
		LDA	#00000000B
		STA	WSUBSL		;	 sub
		LDA	#17H
		STA	!MANSEL
		LDA	#2H
		STA	!SUBSEL
		LDA	#10H
		STA	!WIND30
		LDA	#72H
		STA	!SUBADF
;
		M16			; memory 16bit mode
		LDA	!KYKAZU
		SEC
		SBC	#3
		ASL	A
		TAX
		LDA	WIND_DAT,X
		LDX	#058H
SLC140		EQU	$		; EBhD f[^ Zbg !!
		STA	>HDMABUF0,X
		INX
		INX
		CPX	#0A0H
		BNE	SLC140
;
		LDA	HD420C
		ORA	#00001000B
		STA	HD420C		; window on
;
		MI8			; memory , index 8bit mode
		RTL
;
WIND_DAT	EQU	$
		WORD	0D030H,0E020H,0F010H
;
WIND_DT2	EQU	$
		BYTE	0F8H
		WORD	HDMABUF0
		BYTE	0F8H
		WORD	HDMABUF0+78H*2
		BYTE	00
;
;########################################################################
;# (LABEL)	WINDON2		(Score window on routine)		#
;########################################################################
WINDON2		EQU	$
		LDX	#0
MSG2_W100
		LDA	WIND_DT2,X
		STA	>HDMAPR0,X
		BEQ	MSG2_W110
		INX
		BRA	MSG2_W100
MSG2_W110
;
		MI16			; memory , index 16bit mode
;
		LDX	#00200H/4-2
		LDA	#000FFH
MSG2_W120	EQU	$		; EBhD obt@ NA !!
		STA	>HDMABUF0+000H,X
		STA	>HDMABUF0+080H,X
		STA	>HDMABUF0+100H,X
		STA	>HDMABUF0+180H,X
		DEX
		DEX
		BPL	MSG2_W120
;
		M8			; memory 8bit mode
;
		LDX	#02641H
		STX	04330H		; inc. mode & B-bus address set

		LDX	#HDMAPR0
		STX	04332H		; A-bus address (L,H)
		LDA	#BANK HDMAPR0
		STA	04334H		;		(B)
;
		LDA	#BANK HDMABUF0
		STA	04337H		; data bank
;
		LDA	#00110000B
		STA	WIND23		; window mask (BG.2 , BG.1)
		LDA	#00110000B
		STA	WIND24		;	      (BG.4 , BG.3)
		LDA	#00100000B
		STA	WIND25		;	      (Col  , Obj )
		LDA	#00000000B
		STA	WMANSL		; window main
		LDA	#00000000B
		STA	WSUBSL		;	 sub
		LDA	#17H
		STA	!MANSEL
		LDA	#2H
		STA	!SUBSEL
		LDA	#10H
		STA	!WIND30
;[1995/06/16]		LDA	#62H
;[1995/06/16]		STA	!SUBADF
		STZ	!SUBADF		; gamen kasan off
;
		M16			; memory 16bit mode
		LDA	#7F94H
		STA	!NUKCOL
;
		LDA	#0FF00H
		LDX	#000H
SLC2140		EQU	$		; EBhD f[^ Zbg !!
		STA	>HDMABUF0,X
		INX
		INX
		CPX	#01C0H
		BNE	SLC2140
;
;;;;;		LDA	HD420C
;;;;;		ORA	#00001000B
		LDA	#00101000B
		STA	HD420C		; window on
;
		MI8			; memory , index 8bit mode
		RTL
;
;########################################################################
;# (LABEL)	WINDOFF		(WINDOW off )				#
;########################################################################
WINDOFF		EQU	$
;
		MEM16
		IDX16
		REP	#00110000B		; memory,index 16bit mode
;
		LDX	#00200H/4-2
		LDA	#000FFH
SLC320		EQU	$
		STA	>HDMABUF0+000H,X
		STA	>HDMABUF0+080H,X
		STA	>HDMABUF0+100H,X
		STA	>HDMABUF0+180H,X
		DEX
		DEX
		BPL	SLC320			; window buffer clear end ?
;						; yes
		MEM8
		IDX8
		SEP	#30H
;
		LDA	WIND25
		EOR	#00000011B
		STA	WIND25
		LDA	WMANSL
		EOR	#00010000B
		STA	WMANSL
;
		LDA	HD420C
		AND	#0F7H
		STA	HD420C
		RTL
;
;-------------< ~j Q[Opq`l >----------------------------------
;
;------------------------------------------
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		MINIIAL1_3	( world 1 initial set )			x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
MINIIAL1_3L0	EQU	$
		M16
		LDA	#0
		BRA	MINIIAL1_3
MINIIAL1_3L1	EQU	$
		M16
		LDA	#1
MINIIAL1_3	EQU	$
		STA	!M3LVFG		; game level flag
;-------------- XN[l NA -----------------------------
		M16
;
		STZ	<SCCH1
		STZ	<SCCV1
		STZ	<SCCH2
		LDA	#0017H
		STA	<SCCV2
		STZ	<SCCH3
		STZ	<SCCV3
		M8			; memory 8bit mode
;
		LDA	!BG1SCF
		EOR	#003H
		STA	!BG1SCF
		STA	2107H
		LDA	!BG2SCF
		EOR	#003H
		STA	!BG2SCF
		STA	2108H
;
;-------------- Q[ CjV -----------------------------------
		MI16			; memory,index 8 bit mode !!
;
		LDA	#000B0H
		STA	!PLYPSL		; player Y initial set !!
		STA	!PLYPSL_O	; player Y initial set !!
		LDA	#00020H
		STA	!PLXPSL		; player X initial set !!
		STA	!PLXPSL_O	; player X initial set !!
		STZ	!UNBUFAD
		STA	!TIMER
;
;;;;;		LDA	#0FFFFH
;;;;;		STA	OBJCHR_BNK
;;;;;		STA	OBJCHR_BNK+2
;;;;;		STA	OBJCHR_BNK+4
;
		LDX	#001FEH
		LDA	#00000
;
INT1_3_050	EQU	$
		STA	>BGUNIT,X
		DEX
		DEX
		BPL	INT1_3_050	; BG unit buffer clear end ?
;					; Yes !!
		LDX	#00FH*2
		LDA	#00100H
;
INT1_3_100	EQU	$
		STA	>BGUNIT+1A0H,X
		DEX
		DEX
		BPL	INT1_3_100
;
		LDX	#00160H
;
INT1_3_150	EQU	$
		LDA	#00100H
		STA	>BGUNIT,X
		STA	>BGUNIT+01EH,X
		TXA
		SEC
		SBC	#00020H
		TAX
		BNE	INT1_3_150
;
		LDX	#0018H
		LDA	#03800H		;af
;
INT1_3_170	EQU	$
		STA	>BGUNIT+00A0H,X
		DEX
		DEX
		CPX	#06H
		BCS	INT1_3_170
;
		LDA	#100H
		STA	>BGUNIT+002H
		STA	>BGUNIT+004H
		STA	>BGUNIT+01AH
		STA	>BGUNIT+01CH
;
		STZ	!SUBADF		; gamen kasan off
;---------------@GZbg  ------------------
;
		I8
		LDA	#M_LIF
		JSL	>ENINSR_I	; tgZbg
		LDA	#M_LIF
		JSL	>ENINSR_I	; tgZbg
;
		LDX	#10
INT1_3_200
		LDA	#M_FUS
		JSL	>ENINSR_I	; DZbg
		DEX
		BNE	INT1_3_200
;
		LDA	#M_DR2
		JSL	>ENINSR_I	; D_Zbg
;
		STZ	!FUSENR		; DpxO
		LDA	#100H
		STA	!FUSENX		; Dw{Zbg
		STA	!FUSENY		; Dx{Zbg
;
		LDX	#0
		LDA	#0F000H		; ]IuWF̈m
		STA	TROBJ_SIZE	;
		STA	TROBJ_ARIA	;
		JSR	M3KOJ0		; ]IuWFZbg
		MI8			; memory,index 8 bit mode !!
		JSL	>ENEMY_IN	; G
		LDA	#09H
		STA	!BGMODE
		STZ	!SUBADF		; gamen kasan off
;
		RTS
;
MN3		EQU	$
;
;########################################################################
;# (LABEL)	SHIRIGAME		(shirimochi pan)		#
;########################################################################
SHIRIGAME	EQU	$
		JSL	>OAMDXCLR	; OAM clear sub !!
		M16
		LDA	!PLXPSL		; vC[Wۑ
		STA	!PLXPSL_O
		LDA	!PLYPSL
		STA	!PLYPSL_O
;
		LDA	!PLKYOF		; vC[XgbvH
		BEQ	SHIRIGAME50	; !NO
		LDA	!PLBGCR
		AND	#00000001B
		EOR	#00000001B
		ORA	!PLYSPD		; vC[ĂH
		BEQ	SHIRIGAME30	; !YES
		STZ	!KEYC1L
		STZ	!KEYC1
		STZ	!KEYC2L
		STZ	!KEYC2
		LDA	#DM00		; vC[p^[
		STA	!PLPATN
		BRA	SHIRIGAME50
SHIRIGAME30
		STZ	!PLKYOF		; vC[XgbvIt
		LDA	#0096H
		STA	!PLFLSH		; vC[U^C}[Zbg
		STZ	!PLXSPD		; vC[wړXs[hNA
		STZ	!PLMVSP		;
SHIRIGAME50
		LDA	!PLFLSH
		CMP	#80H		; vC[ړnjH
		BCS	SHIRIGAME60	; !NO
		STZ	!PLFLSH		; ^C}[NA
SHIRIGAME60
		M8
		JSL	>ENCSET_DM	; enemy char set sub !!
		JSL	>PLCSET		; player char set sub !!
		LDA	!GMSTOP		; Q[XgbvH
		BNE	SHIRIGAME65	; !YES
		JSR	PLFMCK		; vC[ʊO`FbN
		JSL	>PLAYER		; player move sub !!
SHIRIGAME65
		LDA	!PLKYOF		; vC[XgbvH
		BNE	SHIRIGAME70	; !YES
		JSR	PLVSLF		; player vs lift cross check
SHIRIGAME70
		LDA	!MSGMOD		; bZ[W EBhD nm ?
		BNE	SHIRIGAME90	;	YES -> SHIRIGAME90
		JSL	>ENEMY_IN	; enemy move sub !!
		JSR	FUSNPY		; fusen poyopoyo
;
SHIRIGAME90	EQU	$
		M16			; memory 16 bit mode !!
;
		M_CHIP	DX_OAM		; SOAM_DX => OAM convert
;
		M8			; memory 8 bit mode !!
;
		RTS
;
;########################################################################
;# (LABEL)	PLFMCK		(player flame check)			#
;########################################################################
PLFMCK		EQU	$
		M16
		LDA	!PLYPSL		; vC[ʊOH
		BPL	PLFMCK_900	; !NO
		CMP	#0FFF0H
		BCS	PLFMCK_900
		LDA	!PLXPSL
		CMP	#30H
		BCS	PLFMCK_300
		STZ	!PLXSPD
		LDA	#30H
		BRA	PLFMCK_500
PLFMCK_300
		CMP	#0C1H
		BCC	PLFMCK_500
		STZ	!PLXSPD
		LDA	#0C0H
PLFMCK_500
		STA	!PLXPSL
PLFMCK_900
		M8
		RTS
;
;########################################################################
;# (LABEL)	FUSNPY		(fusen poyopoyo)			#
;########################################################################
FUSNPY		EQU	$
		M16
		LDA	!GMSTOP
		BEQ	FUSNPY_100
		RTS
FUSNPY_100
		LDA	!FRCNT
		AND	#000FH
		BNE	FUSNPY_900
;
		LDA	!FUSENI
		BNE	FUSNPY_500
		DEC	!FUSENX
		INC	!FUSENY
		LDA	!FUSENY
		CMP	#0101H
		BCC	FUSNPY_900
		LDA	!FUSENI
		EOR	#1
		STA	!FUSENI
		BRA	FUSNPY_900
FUSNPY_500
		INC	!FUSENX
		DEC	!FUSENY
		LDA	!FUSENX
		CMP	#0101H
		BCC	FUSNPY_900
		LDA	!FUSENI
		EOR	#1
		STA	!FUSENI
;
FUSNPY_900
		JSR	M3KOJ0
;
		RTS
;
;
;########################################################################
;# (LABEL)	PLVSLF		(player vs lift cross check)		#
;########################################################################
PLVSLF		EQU	$
		M16
		LDA	!PLYSPD
		BMI	PLVSLF_900
;
		LDA	!PLDOSN		; shirimoti?
		BNE	PLVSLF_500	; !Yes
;
		LDA	#4
		STA	<WORK		; c`FbNhbg
		JSR	PLVSLF_SUB
		CPY	#0		; cross?
		BEQ	PLVSLF_900	; !No
;
		BRA	PLVSLF_800
PLVSLF_500
		LDA	#8
		STA	<WORK		; c`FbNhbg
		JSR	PLVSLF_SUB
		CPY	#0		; cross?
		BEQ	PLVSLF_900	; !No
PLVSLF_800
		LDA	!ENYPSL,Y
		SEC
		SBC	#20H
		STA	!PLYPSL
		LDA	!ENMOVX,Y
		CLC
		ADC	!PLXPSL
		STA	!PLXPSL
		LDA	#1
		STA	!ONLFFG		; tgIԃZbg
;
		LDA	#0400H
		STA	!PLYSPD
PLVSLF_900
		M8
;
		RTS
;
;########################################################################
;# (LABEL)	PLVSLF_SUB	(player vs lift cross check sub)	#
;########################################################################
		MEM16
;
PLVSLF_SUB	EQU	$
		LDY	#0
		LDX	!LIFIDX
		JSR	PLVSLF_SUB_100
		LDX	!LIFIDX+2
PLVSLF_SUB_100
		LDA	!ENXPSL,X
		SEC
		SBC	#000CH
		CMP	!PLXPSL
		BCS	PLVSLF_SUB_900
		CLC
		ADC	#0028H
		CMP	!PLXPSL
		BCC	PLVSLF_SUB_900
;
		LDA	!ENYPSL,X
		SEC
		SBC	#20H
		CMP	!PLYPSL
		BCS	PLVSLF_SUB_900
		CLC
		ADC	<WORK
		CMP	!PLYPSL
		BCC	PLVSLF_SUB_900
;
		TXY
PLVSLF_SUB_900
		RTS
;
;
;########################################################################
;# (LABEL)	M3KOJ0		(~jQ[Rp ]IuWFZbgO)	#
;########################################################################
		MEM16
M3KOJ0		EQU	$
		LDA	!FUSENR
		STA	R5		;(R5)  <-- Dpx
		LDA	!FUSENX
		STA	R6		;(R6)  <-- Dw{
		LDA	!FUSENY
		STA	R11		;(R11) <-- Dx{
;
		LDA	>TROBJ_PLOT_X
		STA	R3		;(R3)  <-- rbg}bvWQw
		LDA	>TROBJ_PLOT_Y
		STA	R2		;(R2)  <--	  h	   Qx
;
		LDA	#CIPCHD2+40E0H+001
		STA	R12		;(R12) <-- LN^[AhXikCgj
		LDA	#BANK CIPCHD2+40E0H+001
		STA	R13		;(R13) <--	   h		(aj
		M_CHIP	C_32_RTZ_32_XY
;
		INC	OBM7WF		;]LN^[]tOhnmh
		RTS
;
;########################################################################
;# (LABEL)	M3KOJ1		(~jQ[Rp ]IuWFZbgP)	#
;########################################################################
		MEM16
M3KOJ1		EQU	$
		LDA	>TROBJ_PLOT_X+8
		STA	R3		;(R3)  <-- rbg}bvWQw
		LDA	>TROBJ_PLOT_Y+8
		STA	R2		;(R2)  <--	  h	   Qx
		BRA	M3KOJ_SET
;
;########################################################################
;# (LABEL)	M3KOJ2		(~jQ[Rp ]IuWFZbgQ)	#
;########################################################################
		MEM16
M3KOJ2		EQU	$
		LDA	>TROBJ_PLOT_X+10H
		STA	R3		;(R3)  <-- rbg}bvWQw
		LDA	>TROBJ_PLOT_Y+10H
		STA	R2		;(R2)  <--	  h	   Qx
;
M3KOJ_SET	EQU	$
		LDA	!ENWRK8,X
		STA	R5		;(R5)  <-- Dpx
		LDA	!ENWRKA,X
		STA	R6		;(R6)  <-- Dw{
		LDA	!ENWRKC,X
		STA	R11		;(R11) <-- Dx{
;
		LDA	#CIPCHD2+40E0H+001
		STA	R12		;(R12) <-- LN^[AhXikCgj
		LDA	#BANK CIPCHD2+40E0H+001
		STA	R13		;(R13) <--	   h		(aj
		M_CHIP	C_32_RTZ_32_XY
;
		INC	OBM7WF		;]LN^[]tOhnmh
		LDX	!ENINDX
		RTS
;
;------------------------------------------------------------------------
		MEM16
		IDX8
;
		DPAGE	EN0RAM
;
;########################################################################
;# (LABEL)	M_LIFIN		(lift initial)				#
;########################################################################
M_LIFIN		EQU	$
		LDY	!LOPCNT		; ėp[vJE^[
		LDA	M_INIT_XDT,Y
		STA	!ENXPSL,X
		LDA	M_INIT_YDT,Y
		STA	!ENYPSL,X
		TXA
		STA	!LIFIDX,Y	; tgpCfbNX
		LDA	!M3LVFG		; Q[x
		BEQ	M_LIFIN_100
		LDA	M_LIFIN_XMV,Y
M_LIFIN_100
		STA	!ENXSPD,X
		INC	!LOPCNT
		INC	!LOPCNT
;
		RTL
;
M_INIT_XDT	EQU	$
		WORD	0010H,00D8H			; tg
		WORD	0010H,00D0H,0028H,0058H,0088H	; D
		WORD	00B8H,0010H,0050H,0090H,00D0H	;
M_INIT_YDT	EQU	$
		WORD	0090H,0090H			; tg
		WORD	0073H,0073H,0033H,0033H,0033H	; D
		WORD	0033H,00B3H,00B3H,00B3H,00B3H	;
M_LIFIN_XMV	EQU	$
		WORD	00080H,0FF80H
;
;########################################################################
;# (LABEL)	M_FUSIN		(fusen initial)				#
;########################################################################
M_FUSIN		EQU	$
		LDY	!LOPCNT
		LDA	M_INIT_XDT,Y
		STA	!ENXPSL,X
		LDA	M_INIT_YDT,Y
		STA	!ENYPSL,X
		INC	!LOPCNT
		INC	!LOPCNT
;
		CPY	#04H
		BEQ	M_FUSIN_300
		CPY	#06H
		BNE	M_FUSIN_900
		LDA	!LIFIDX+2
		BRA	M_FUSIN_400
M_FUSIN_300
		LDA	!LIFIDX
M_FUSIN_400
		STA	<ENWRK4,X
M_FUSIN_900
		STZ	!ENTROB,X
;
		RTL
;
;########################################################################
;# (LABEL)	M_LIFMV		(lift move)				#
;########################################################################
M_LIFMV		EQU	$
		LDA	!GMSTOP
		BEQ	M_LIFMV_100
		STZ	!ENXSPD,X
		RTL
M_LIFMV_100
		LDA	!ENXPSL,X
		CMP	#0080H		; left or right?
		BCS	M_LIFMV_500	; right!!
;
		LDA	!ENXPSL,X
		CMP	#0050H
		BCC	M_LIFMV_200
		LDA	#0050H
		STA	!ENXPSL,X
		BRA	M_LIFMV_300
;
M_LIFMV_200
		CMP	#0010H
		BCS	M_LIFMV_900
		LDA	#0010H
		STA	!ENXPSL,X
		STZ	!ENMOVX,X
M_LIFMV_300
		LDA	!ENXSPD,X
		EOR	#0FFFFH
		INC	A
		STA	!ENXSPD,X
		BRA	M_LIFMV_900
;
M_LIFMV_500
		LDA	!ENXPSL,X
		CMP	#00D0H
		BCC	M_LIFMV_600
		LDA	#00D0H
		STA	!ENXPSL,X
		BRA	M_LIFMV_700
M_LIFMV_600
		CMP	#0090H
		BCS	M_LIFMV_900
		LDA	#0090H
		STA	!ENXPSL,X
		STZ	!ENMOVX,X
M_LIFMV_700
		LDA	!ENXSPD,X
		EOR	#0FFFFH
		INC	A
		STA	!ENXSPD,X
;
M_LIFMV_900
		RTL
;
;########################################################################
;# (LABEL)	M_FUSMV		(fusen move)				#
;########################################################################
M_FUSMV		EQU	$
;
		LDA	<ENWRK4,X
		BEQ	M_FUSMV100
;
		TAY
		LDA	!ENXPSL,Y
		STA	!ENXPSL,X
M_FUSMV100
		LDA	<ENWRK2,X
		ASL	A
		TAY
		LDA	M_FUSMV_TBL,Y
		STA	!WORK
		LDA	M_FUSMV_TBL+1,Y
		STA	!WORK1
		JMP	(WORK)
;
M_FUSMV_TBL	EQU	$
		WORD	MFSSTP		; not cross!
		WORD	MFSLFR		; DI
		WORD	MFSLFP		; DI
		WORD	MFSRIR		; DEI
		WORD	MFSRIP		; DEI
		WORD	MFSRID		; DĂ
		WORD	MFSPAN		; Dj
		WORD	MFSREC		; D
		WORD	MFSDRL		; D_DI
		WORD	MFSDRR		; D_DEI
		WORD	MFSDRP		; D_Dj
;
;########################################################################
;# (LABEL)	MFSDRL		(D_DI)		#
;########################################################################
MFSDRL		EQU	$
		JSL	>TROBJ_OAM_4x4
		LDA	!ENWRK8,X
		CMP	#020H
		BCC	MFSDRL_200
		LDA	#7
		STA	<ENWRK2,X
		BRA	MFSDRL_300
MFSDRL_200
		CLC
		ADC	#8
		AND	#00FFH
		STA	!ENWRK8,X
MFSDRL_300
		LDA	!ENWRKC,X
		CMP	#0C0H
		BCC	MFSDRL_400
		SEC
		SBC	#20H
		STA	!ENWRKC,X
		LDA	!ENWRKA,X
		CLC
		ADC	#12
		STA	!ENWRKA,X
		INC	!ENYPSL,X
		INC	!ENYPSL,X
MFSDRL_400
		JSR	MSFSUB
;
		RTL
;
;########################################################################
;# (LABEL)	MFSDRR		(D_DEI)		#
;########################################################################
MFSDRR		EQU	$
		JSL	>TROBJ_OAM_4x4
		LDA	!ENWRK8,X
		BEQ	MFSDRL_200
		CMP	#0E0H
		BCS	MFSDRL_200
		LDA	#7
		STA	<ENWRK2,X
		BRA	MFSDRR_300
MFSDRR_200
		SEC
		SBC	#8
		AND	#00FFH
		STA	!ENWRK8,X
MFSDRR_300
		LDA	!ENWRKC,X
		CMP	#0C0H
		BCC	MFSDRR_400
		SEC
		SBC	#20H
		STA	!ENWRKC,X
		LDA	!ENWRKA,X
		CLC
		ADC	#12
		STA	!ENWRKA,X
		INC	!ENYPSL,X
		INC	!ENYPSL,X
MFSDRR_400
		JSR	MSFSUB
;
		RTL
;
;########################################################################
;# (LABEL)	MFSDRP		(D_Dj)				#
;########################################################################
MFSDRP		EQU	$
		JSL	>TROBJ_OAM_4x4
;
		LDA	!ENWRKC,X
		SEC
		SBC	#20H
		CMP	#60H
		BCS	MFSDRP_800
;
		JSL	>ENCLEAR
		JSR	ATAHAZ		; Oꌈ菈
		CMP	#M_ATA
		BNE	MFSDRP_700
;
		INC	!GMSTOP
		LDA	#1
		STA	!WINFLG
		STA	!HDMMOD
		LDA	#M_ATA
MFSDRP_700
		PHA
		JSL	>EXINSR
;
		LDA	!ENXPSL,X
		CLC
		ADC	#00020H
		STA	!EXXPSL,Y
		LDA	!ENYPSL,X
		CLC
		ADC	#00010H
		STA	!EXYPSL,Y
		PLA
		PHX
		TYX
		CMP	#M_ATA
		BNE	MFSDRP_750
		JSL	>M_HAZIN
		BRA	MFSDRP_760
MFSDRP_750
		JSL	>M_ATAIN
MFSDRP_760
		PLX
;
		LDA	#DOSN0
		JSL	>EXINSR
		PHX
		LDX	!DRINDX
		LDA	!ENXPSL,X
		STA	!EXXPSL,Y
		LDA	!ENYPSL,X
		CLC
		ADC	#8
		STA	!EXYPSL,Y
		LDA	#0BH
		STA	!EXWRK0,Y
		LDA	#2
		STA	!EXTIM0,Y
		PLX
		LDA	#46H
		JSL	>SOUND_3_ON
;
		RTL
MFSDRP_800
		STA	!ENWRKC,X
		LDA	!ENWRKA,X
		CLC
		ADC	#6
		STA	!ENWRKA,X
		INC	!ENYPSL,X
		INC	!ENYPSL,X
;
		JSR	MSFSUB
;
		RTL
;
;
;########################################################################
;# (LABEL)	M_ATAIN		(蕶CjV)			#
;########################################################################
M_ATAIN		EQU	$
		LDA	#3
		STA	!EXTIM0,X
		STZ	!EXWRK2,X
		LDA	#0FD00H
		STA	!EXYSPD,X
		STZ	!EXXSPD,X
		LDA	#0028H
		STA	!EXGPOW,X
		LDA	#0001H
		STA	!EXYUSN,X
		LDA	#86H
		JSL	>SOUND_3_ON
;
		RTL
;
;########################################################################
;# (LABEL)	M_HAZIN		(nYCjV)			#
;########################################################################
M_HAZIN		EQU	$
		LDA	#2
		STA	!EXTIM0,X
		STA	!EXWRK0,X
		STZ	!EXWRK2,X
		STZ	!EXWRK4,X
		LDA	#0FC00H
		STA	!EXYSPD,X
		STZ	!EXXSPD,X
		LDA	#0030H
		STA	!EXGPOW,X
		LDA	#0001H
		STA	!EXYUSN,X
		LDA	#86H
		JSL	>SOUND_3_ON
;
		RTL
;
;########################################################################
;# (LABEL)	MFSREC		(~jQ[R D)			#
;########################################################################
MFSREC		EQU	$
		JSL	>TROBJ_OAM_4x4
		STZ	!WORK
		LDA	!ENWRK8,X
		BEQ	MFSREC_500
		INC	!WORK
		CMP	#0080H
		BCS	MFSREC_200
		SEC
		SBC	#4
		AND	#00FFH
		STA	!ENWRK8,X
		BRA	MFSREC_500
MFSREC_200
		CLC
		ADC	#4
		AND	#00FFH
		STA	!ENWRK8,X
MFSREC_500
		LDA	!ENWRKC,X
		CMP	#100H
		BEQ	MFSREC_900
		INC	!WORK
		CLC
		ADC	#10H
		CMP	#100H
		BCC	MFSREC_550
		LDA	#100H
MFSREC_550
		STA	!ENWRKC,X
		LDA	!ENWRKA,X
		SEC
		SBC	#6
		STA	!ENWRKA,X
		DEC	!ENYPSL,X
MFSREC_900
		LDA	!WORK
		BNE	MFSREC_950
		STZ	<ENWRK2,X
		STZ	!ENWRK6,X
MFSREC_950
		JSR	MSFSUB
;
		RTL
;
;########################################################################
;# (LABEL)	MFSLFR		(~jQ[R DI)		#
;########################################################################
MFSLFR		EQU	$
		JSL	>TROBJ_OAM_4x4
		LDA	!ENWRK8,X
		CMP	#020H
		BCC	MFSLFR_200
		LDA	#7
		STA	<ENWRK2,X
		BRA	MFSLFR_300
MFSLFR_200
		CLC
		ADC	#4
		AND	#00FFH
		STA	!ENWRK8,X
MFSLFR_300
		LDA	!ENWRKC,X
		CMP	#0C0H
		BCC	MFSLFR_400
		SEC
		SBC	#10H
		STA	!ENWRKC,X
		LDA	!ENWRKA,X
		CLC
		ADC	#6
		STA	!ENWRKA,X
		INC	!ENYPSL,X
MFSLFR_400
		JSR	MSFSUB
;
		RTL
;
;########################################################################
;# (LABEL)	MFSLFP		(~jQ[R DI)	#
;########################################################################
MFSLFP		EQU	$
		JSL	>TROBJ_OAM_4x4
		LDA	!ENWRK8,X
		CMP	#020H
		BCC	MFSLFP_200
		LDA	#7
		STA	<ENWRK2,X
		BRA	MFSLFP_300
MFSLFP_200
		CLC
		ADC	#8
		AND	#00FFH
		STA	!ENWRK8,X
MFSLFP_300
		LDA	!ENWRKC,X
		CMP	#0C0H
		BCC	MFSLFP_400
		SEC
		SBC	#20H
		STA	!ENWRKC,X
		LDA	!ENWRKA,X
		CLC
		ADC	#12
		STA	!ENWRKA,X
		INC	!ENYPSL,X
		INC	!ENYPSL,X
MFSLFP_400
		JSR	MSFSUB
;
		RTL
;
;########################################################################
;# (LABEL)	MFSRIR		(~jQ[R DEI)		#
;########################################################################
MFSRIR		EQU	$
		JSL	>TROBJ_OAM_4x4
		LDA	!ENWRK8,X
		BEQ	MFSRIR_200
		CMP	#0E0H
		BCS	MFSRIR_200
		LDA	#7
		STA	<ENWRK2,X
		BRA	MFSRIR_300
MFSRIR_200
		SEC
		SBC	#4
		AND	#00FFH
		STA	!ENWRK8,X
MFSRIR_300
		LDA	!ENWRKC,X
		CMP	#0C0H
		BCC	MFSRIR_400
		SEC
		SBC	#10H
		STA	!ENWRKC,X
		LDA	!ENWRKA,X
		CLC
		ADC	#6
		STA	!ENWRKA,X
		INC	!ENYPSL,X
MFSRIR_400
		JSR	MSFSUB
;
		RTL
;
;########################################################################
;# (LABEL)	MFSRIP		(~jQ[R DEI)	#
;########################################################################
MFSRIP		EQU	$
		JSL	>TROBJ_OAM_4x4
		LDA	!ENWRK8,X
		BEQ	MFSRIP_200
		CMP	#0E0H
		BCS	MFSRIP_200
		LDA	#7
		STA	<ENWRK2,X
		BRA	MFSRIR_300
MFSRIP_200
		SEC
		SBC	#8
		AND	#00FFH
		STA	!ENWRK8,X
MFSRIP_300
		LDA	!ENWRKC,X
		CMP	#0C0H
		BCC	MFSRIP_400
		SEC
		SBC	#20H
		STA	!ENWRKC,X
		LDA	!ENWRKA,X
		CLC
		ADC	#12
		STA	!ENWRKA,X
		INC	!ENYPSL,X
		INC	!ENYPSL,X
MFSRIP_400
		JSR	MSFSUB
;
		RTL
;
;########################################################################
;# (LABEL)	MFSRID		(~jQ[R DĂ)		#
;########################################################################
MFSRID		EQU	$
		JSL	>TROBJ_OAM_4x4
;
		LDA	!ENWRKC,X
		CMP	#00C0H
		BCC	MFSRID_500
;
		SBC	#10H
		STA	!ENWRKC,X
		LDA	!ENWRKA,X
		CLC
		ADC	#6
		STA	!ENWRKA,X
		INC	!ENYPSL,X
MFSRID_500
		LDA	!PLJUMP
		BNE	MFSRID_700
;
		INC	ONLFFG
		LDA	#100H
		SEC
		SBC	!ENWRKC,X
		LSR	A
		LSR	A
		LSR	A
		LSR	A
		STA	!WORK
		LDA	#1CH
		SEC
		SBC	!WORK
		STA	!WORK
		LDA	!ENYPSL,X
		SEC
		SBC	!WORK
		STA	!PLYPSL
;
		JSR	PLVSFS_SUB
		STA	<ENWRK2,X
		CMP	#1
		BEQ	MFSRID_600
		CMP	#3
		BNE	MFSRID_800
MFSRID_600
		JSR	SIRICK
MFSRID_700
		LDA	#7
		STA	<ENWRK2,X
MFSRID_800
		JSR	MSFSUB
		RTL
;
MSFSUB		EQU	$
		LDA	!ENWRK6,X
		BPL	MSFSUB_100
		JSR	M3KOJ2
		RTS
MSFSUB_100
		JSR	M3KOJ1
		LDA	<ENWRK4,X
		BEQ	MSFSUB_900
		TAY
		LDA	!ENMOVX,Y
		CLC
		ADC	!PLXPSL
		STA	!PLXPSL
MSFSUB_900
;
		RTS
;
;########################################################################
;# (LABEL)	MFSPAN		(~jQ[R Dj)			#
;########################################################################
MFSPAN_WINDAT	EQU	$
		WORD	ITST1,ITST2
;
MFSPAN		EQU	$
		JSL	>TROBJ_OAM_4x4
;
		LDA	!ENWRKC,X
		SEC
		SBC	#20H
		CMP	#60H
		BCC	MFSPAN_300
		JMP	MFSPAN_800
;
MFSPAN_300
		JSL	>ENCLEAR
		JSR	ATAHAZ		; Oꌈ菈
		NOP
		CMP	#M_ATA
TAKE
		BNE	MFSPAN_700
;
		LDA	!HDMMOD
		BEQ	MFSPAN_500
;
		LDA	#M_HAZ
		BRA	MFSPAN_700
MFSPAN_500
		LDA	#0F0F0H		; TEST
		STA	!FUSCNT		; TEST
;
		STZ	!WINFLG
		LDA	#1
		STA	!HDMMOD
		LDX	!DRINDX
		LDA	#4
		STA	!ENWRK0,X
;
		LDA	#M_ITM
		LDY	#(ENNO-1)*4
MFSPAN_530
		LDA	!ENMYNO,Y
		BEQ	MFSPAN_550
		DEY
		DEY
		DEY
		DEY
		BRA	MFSPAN_530
MFSPAN_550
		LDA	#M_ITM
		JSL	>ENINSR2_I
		BCC	MFSPAN_600
;
		LDA	!M3LVFG
		ASL	A
		TAX
		LDA	MFSPAN_WINDAT,X
		STA	!ENWRK0,Y
		LDA	#0080H
		STA	!ENYPSL,Y
		LDA	#0078H
		STA	!ENXPSL,Y
;ITEMTEST
		TYX
		LDA	#M_HZK
		JSL	>EXINSR
		LDA	!ENXPSL,X
		CLC
		ADC	#0FFF0H
		STA	!EXXPSL,Y
		LDA	!ENYPSL,X
		CLC
		ADC	#0FFF0H
		STA	!EXYPSL,Y
		LDA	#3
		STA	!EXTIM0,Y
		TYX
		JSL	>M_HZKIN
;ITEMTEST
MFSPAN_600
;
		LDX	!ENINDX
		LDA	#M_ATA
MFSPAN_700
;
		PHA
		JSL	>EXINSR
		LDA	!ENXPSL,X
		CLC
		ADC	#00020H
		STA	!EXXPSL,Y
		LDA	!ENYPSL,X
		CLC
		ADC	#00010H
		STA	!EXYPSL,Y
;
		LDA	#2
		STA	!EXTIM0,Y
;
		PLA
MFSPAN_730
		PHX
		TYX
		CMP	#M_ATA
		BNE	MFSPAN_750
		JSL	>M_HAZIN
		BRA	MFSPAN_760
MFSPAN_750
		JSL	>M_ATAIN
MFSPAN_760
		PLX
;
		RTL
MFSPAN_800
		STA	!ENWRKC,X
		LDA	!ENWRKA,X
		CLC
		ADC	#6
		STA	!ENWRKA,X
		INC	!ENYPSL,X
		INC	!ENYPSL,X
		LDA	#0200H
		STA	!PLYSPD
		STZ	!PLJUMP
;
		JSR	MSFSUB
		RTL
;
;########################################################################
;# (LABEL)	ATAHAZ		(Oꌈ菈)			#
;########################################################################
ATAHAZ		EQU	$
		PHY
		JSL	>RANDAM
		LDY	!FUSCNT
		BMI	ATAHAZ_200
		M8
		LDA	<RANDM0
		AND	#001FH
		CMP	ATAHAZ_DAT,Y
		BCC	ATAHAZ_300	; 
ATAHAZ_200
		M16
		LDA	#M_HAZ
		BRA	ATAHAZ_400
ATAHAZ_300
		M16
		LDA	#0F0F0H
		STA	!FUSCNT
;;;TEST;;;		INC	!GMSTOP
;
		LDY	#(EXNO-1)*4
		LDA	#0
ATAHAZ_350
		STA	!EXMODE,Y
		STA	!EXTIM0,Y
		DEY
		DEY
		DEY
		DEY
		BPL	ATAHAZ_350
;
		LDA	#M_ATA
ATAHAZ_400
;
		INC	!FUSCNT
		PLY
		RTS
;
ATAHAZ_DAT	EQU	$
		BIN	00000001B	; 00
		BIN	00000001B	; 01
		BIN	00000011B	; 02
		BIN	00000011B	; 03
		BIN	00000011B	; 04
		BIN	00000111B	; 05
		BIN	00000111B	; 06
		BIN	00001111B	; 07
		BIN	00001111B	; 08
		BIN	11111111B	; 09
;
;########################################################################
;# (LABEL)	MFSSTP		(fusen not cross)			#
;########################################################################
MFSSTP		EQU	$
		JSR	PLVSFS		; player vs fusen cross check
;;;TAKE		EQU	$
;
		RTL
;
;########################################################################
;# (LABEL)	PLVSFS		(player vs fusen cross check)		#
;########################################################################
PLVSFS		EQU	$
		LDA	!PLYSPD
		BPL	PLVSFS_000
		JMP	PLVSFS_900
PLVSFS_000
;
		LDA	!PLYSPD+1
		AND	#00FFH
		INC	A
		STA	!WORK
;
		LDA	!ENXPSL,X
		SEC
		SBC	#8
		CMP	!PLXPSL
		BCS	PLVSFS_900
		CLC
		ADC	#20H
		CMP	!PLXPSL
		BCC	PLVSFS_900
		LDA	!ENYPSL,X
		SEC
		SBC	#001CH
		CMP	!PLYPSL
		BCS	PLVSFS_900
		CLC
		ADC	!WORK
		CMP	!PLYPSL
		BCC	PLVSFS_900
;
		LDA	!ENYPSL,X
		SEC
		SBC	#001CH
		STA	!PLYPSL
		INC	!ONLFFG
		LDA	#1
		STA	!ENWRK6,X	; vC[DI
		STZ	!PLKYOF
		JSR	PLVSFS_SUB	; Փ˂̕
;
		STA	<ENWRK2,X
		JSR	SIRICK		; K݃`FbN
		LDA	#0FF00H
		STA	TROBJ_SIZE
		STA	TROBJ_ARIA
		LDA	#8
		STA	!ENTROB,X
		LDA	#100H
		STA	!ENWRKA,X	; {
		STA	!ENWRKC,X	; c{
		LDA	#0
		STA	!ENWRK8,X	; ]p
		JSR	M3KOJ1
;
		LDA	<ENWRK4,X
		BEQ	PLVSFS_900
		TAY
		LDA	!ENMOVX,Y
		CLC
		ADC	!PLXPSL
		STA	!PLXPSL
;
PLVSFS_900
;
		RTS
;
;########################################################################
;# (LABEL)	SIRICK		(K݃`FbN)				#
;########################################################################
SIRICK		EQU	$
		CMP	#5
		BCS	SIRICK_900
		ASL	A
		TAY
		LDA	!ITGTFG
		BNE	SIRICK_300
;
		LDA	#P008
		STA	!PLJUMP
SIRICK_300
		LDA	SIRICK_YMV,Y
		STA	!PLYSPD
		LDA	SIRICK_XMV,Y
		STA	!PLXSPD
		STA	!PLMVSP
		STZ	!PLDOSN
		LDA	#13H
		JSL	>SOUND_3_ON
		LDA	<ENWRK2,X
		LSR	A
		BCS	SIRICK_900
		STZ	!ONLFFG
		LDA	#DM00
		STA	!PLPATN		; vC[p^[Zbg
		INC	!PLKYOF		; vC[tOI
SIRICK_900
		RTS
;
SIRICK_XMV	EQU	$
		WORD	00000H,0FF00H,0FE80H,00100H,00180H
SIRICK_YMV	EQU	$
		WORD	00000H,00000H,0FC00H,00000H,0FC00H
;
;########################################################################
;# (LABEL)	PLVSFS_SUB	(Փ˂̕)				#
;########################################################################
PLVSFS_SUB	EQU	$
		STZ	!WORK2
		LDA	!PLYSPD+1
		AND	#00FFH
		INC	A
		CMP	#8
		BCC	PLVSFS_SUB_100
		INC	!WORK2
PLVSFS_SUB_100
		LDA	!ENXPSL,X
		SEC
		SBC	#04H
		CMP	!PLXPSL
		BCS	PLVSFS_1ST
		CLC
		ADC	#18H
		CMP	!PLXPSL
		BCC	PLVSFS_3ST
PLVSFS_5ST
		LDA	#5
		BRA	PLVSFS_SUB_300
PLVSFS_3ST
		LDA	#3
		BRA	PLVSFS_SUB_300
PLVSFS_1ST
		LDA	#1
PLVSFS_SUB_300
		CLC
		ADC	!WORK2
;
		RTS
;
;########################################################################
;# (LABEL)	M_DR2IN		(D_CjV)			#
;########################################################################
M_DR2IN		EQU	$
		LDA	#00C0H
		STA	!ENXPSL,X
		LDA	#00C0H
		STA	!ENYPSL,X
		LDA	#0009H
		STA	!ENCHPT,X
		STX	!DRINDX
;
		RTL
;
;########################################################################
;# (LABEL)	M_DR2MV		(drobo move)				#
;########################################################################
M_DR2MV		EQU	$
		LDA	!GMSTOP		; Q[IH
		BEQ	M_DR2MV_300	; !NO
		STZ	!ENXSPD,X
		STZ	!ENYSPD,X
		STZ	!ENGPOW,X
M_DR2MV_300
		JSR	DRFMCK		; D_t[`FbN
		JSR	DRSRCH		; D_T[`
;
		STX	!DRINDX
		LDA	<ENWRK0,X
		ASL	A
		TAX
		JSR	(M_DR2MV_TBL,X) ; on gosub M_DR2MV_TBL
;
		LDA	<ENWRK0,X
		CMP	#2
		BEQ	M_DR2MV_700
;
		JSR	DRCHST		; D_LN^[p^[Zbg
;
		JSR	DRVSLF		; D_urtg`FbN
;
		JSR	DRVSFS		; D_urD`FbN
;
		JSR	DRVSPL		; D_urvC[
;
M_DR2MV_700
		LDA	!GMSTOP		; Q[IH
		BEQ	M_DR2MV_800	; !NO
		STZ	!ENXSPD,X
		STZ	!ENYSPD,X
		STZ	!ENGPOW,X
		LDA	#9
		STA	!ENCHPT,X
		STZ	!ENYUSN,X
		RTL
M_DR2MV_800
		LDA	<ENWRK0,X
		CMP	#2
		BEQ	M_DR2MV_890
;
		LDA	!ENXSPD,X
		BPL	M_DR2MV_820
		EOR	#0FFFFH
		INC	A
M_DR2MV_820
		CMP	#40H
		BCC	M_DR2MV_890
		LDA	!ENXSPD,X
		ROL	A
		ROL	A
		ROL	A
		AND	#0002H
		EOR	#0002H
		STA	!ENMUKI,X
M_DR2MV_890
		LDA	!ENXPSL,X	; D_Wۑ
		STA	!DRXPSL_O	;
		LDA	!ENYPSL,X	;
		STA	!DRYPSL_O	;
;
		RTL
;
M_DR2MV_TBL	EQU	$
		WORD	DR2FSR		; DT[`
		WORD	DR2PSR		; vC[T[`
		WORD	DR2PIY		; D_C⏈
		WORD	DR2LSR		; tgT[`
		WORD	DR2STP		; D_~
;
;########################################################################
;# (LABEL)	DR2STP		(D_~)				#
;########################################################################
DR2STP		EQU	$
		LDX	!DRINDX
;
		STZ	!ENXSPD,X
		STZ	!ENYSPD,X
		STZ	!ENGPOW,X
		LDA	#9
		STA	!ENCHPT,X
		STZ	!ENYUSN,X
;
		PLA
;
		RTL
;
;########################################################################
;# (LABEL)	DR2LSR		(tgT[`)				#
;########################################################################
DR2LSR		EQU	$
		LDX	!DRINDX
		LDA	!ENLFXP
		ROL	A
		ROL	A
		ROL	A
		AND	#0002H
		TAY
		LDA	DR2LSR_XMVDT,Y
		CLC
		ADC	!ENXSPD,X
		STA	!ENXSPD,X
;
		LDA	!ENLFXE
		CMP	#4
		BCS	DR2LSR_200
		LDA	#0FA00H
		STA	!ENYSPD,X
		INC	<ENWRK2,X
		STZ	<ENWRK0,X
DR2LSR_200
;
		RTS
;
DR2LSR_XMVDT	EQU	$
		WORD	00008H,0FFF8H
;
;########################################################################
;# (LABEL)	DR2PIY		(D_C⏈)				#
;########################################################################
DR2PIY		EQU	$
		LDX	!DRINDX
		LDA	!ENCBFG,X
		LSR	A
		BCS	DR2PIY_100
		LDA	#1AH
		STA	!ENCHPT,X
		RTS
;
DR2PIY_100
		STZ	!ENXSPD,X
		LDA	!ENWRK8,X
		TAY
		LDA	!DR2PIY_CHDT,Y
		AND	#00FFH
		STA	!ENCHPT,X
		LDA	!ENTIM0,X
		BNE	DR2PIY_200
		LDA	#4
		STA	!ENTIM0,X
		INC	!ENWRK8,X
		LDA	!ENWRK8,X
		CMP	#8
		BCC	DR2PIY_200
		STZ	<ENWRK0,X
DR2PIY_200
;
		RTS
;
DR2PIY_CHDT	EQU	$
		HEX	16,15,16,15,16,15,16,15
;
;########################################################################
;# (LABEL)	DRVSPL		(D_urvC[)			#
;########################################################################
DRVSPL_RTS
		RTS
;
DRVSPL		EQU	$
		LDA	<ENWRK0,X
		CMP	#2
		BEQ	DRVSPL_RTS
		LDA	!PLKYOF
		BNE	DRVSPL_RTS
;
		LDA	!ENPLXE
		CMP	#10H
		BCS	DRVSPL_RTS
;
		LDA	!ENPLYE
		CMP	#10H
		BCS	DRVSPL_RTS
		CMP	#6
		BCC	DRVSPL_500
;
		JSR	DRVSPL_SUB
;
		LDA	!ENPLYP
		BPL	DRVSPL_300
		LDA	#2
		STA	<ENWRK0,X
		STZ	!ENWRK8,X
;
		LDA	!ECENTX,X
		STA	<EWORK0
		LDA	!ENYPSL,X
		SEC
		SBC	#0010H
		STA	<EWORK2
		LDY	#3AH
		JSL	>PDON0ST_2
;;;;;		JSL	>FSMK0_SET2
;
		BRA	DRVSPL_500
DRVSPL_300
		LDA	!PCENTX
		STA	<EWORK0
		LDA	!PLYPSL
		STA	<EWORK2
;
		LDY	#3AH
		JSL	>PDON0ST_2
;;;		LDA	#FSMK0
;;;		JSL	>FSMK0_SET2
		LDA	#DM00
		STA	!PLPATN
		INC	!PLKYOF
;
DRVSPL_500
;
		LDA	!ENXSPD,X
		ROL	A
		ROL	A
		ROL	A
		AND	#2
		TAY
		LDA	DRVSPL_XSP,Y
		STA	!ENXSPD,X
		EOR	#0FFFFH
		INC	A
		STA	!PLXSPD
		STA	!PLMVSP
;
		STZ	!PLDOSN		; 
;
		LDA	!PLJUMP
		BEQ	DRVSPL_600
		LDA	!ENPLYP
		BMI	DRVSPL_600
		STZ	!PLYSPD
		BRA	DRVSPL_700
DRVSPL_600
		LDA	#P008
		STA	!PLJUMP		; vC[WvZbg
		LDA	#0FA00H
		STA	!PLYSPD
;
DRVSPL_700
		LDA	<ENWRK2,X
		BEQ	DRVSPL_800
		LDA	!ENPLYP
		BMI	DRVSPL_800
		STA	!ENYSPD,X
		BRA	DRVSPL_900
DRVSPL_800
		LDA	#1
		STA	<ENWRK2,X
		LDA	#0FB00H
		STA	!ENYSPD,X
DRVSPL_900
;
		RTS
;
DRVSPL_SUB	EQU	$
		LDA	!PLXPSL_O	; vC[wWO̒l
		STA	!PLXPSL
		LDA	!PLYPSL_O	; vC[xWO̒l
		STA	!PLYPSL
		LDA	!DRXPSL_O	; D_wWO̒l
		STA	!ENXPSL,X
		LDA	!DRYPSL_O	; D_xWO̒l
		STA	!ENYPSL,X
;
		RTS
;
DRVSPL_XSP	EQU	$
		WORD	0FE00H,0200H
;
;########################################################################
;# (LABEL)	DRVSFS		(D_urD`FbN)			#
;########################################################################
DRVSFS		EQU	$
		LDA	<ENWRK2,X	; Wv
		BEQ	DRVSFS_900	; !NO
;
		LDA	!ENYSPD,X	; H
		BMI	DRVSFS_900	; !NO
;
		LDY	#5CH
;
DRVSFS_200
		LDA	!ENWRK6,Y
		BNE	DRVSFS_800
;
		LDA	!ENMYNO,Y
		CMP	#M_FUS		; DH
		BNE	DRVSFS_800	; !NO
;
		LDA	!ENXPSL,Y
		CMP	!ECENTX,X	; ͈͊OH
		BCS	DRVSFS_800	; !YES
;
		CLC
		ADC	#0020H
		CMP	!ECENTX,X	; E͈͊OH
		BCC	DRVSFS_800	; !YES
;
		LDA	!ENYPSL,Y
		SEC
		SBC	#10H
		CMP	!ENYPSL,X	; ͈͊OH
		BCS	DRVSFS_800	; !YES
;
		CLC
		ADC	#4
		CMP	!ENYPSL,X	; ͈͊OH
		BCC	DRVSFS_800	; !YES
;
		JMP	DRVSFS_SUB
DRVSFS_800
		DEY
		DEY
		DEY
		DEY
		BPL	DRVSFS_200
;
DRVSFS_900
		RTS
;
DRVSFS_SUB	EQU	$
		LDA	!ENXPSL,Y
		CLC
		ADC	#8
		CMP	!ECENTX,X	; H
		BCS	DRVSFS_400	; !YES
;
		CLC
		ADC	#10H
		CMP	!ECENTX,X	; EH
		BCC	DRVSFS_500	; !YES
;
		LDA	#0AH
		BRA	DRVSFS_600
DRVSFS_400
		LDA	#08H
		BRA	DRVSFS_600
DRVSFS_500
		LDA	#09H
DRVSFS_600
		STA	!ENWRK2,Y
		LDA	#0FFFFH
		STA	!ENWRK6,Y
;
		LDA	#0FFF0H
		STA	TROBJ_SIZE
		STA	TROBJ_ARIA
		LDA	#10H
		STA	!ENTROB,Y
		LDA	#100H
		STA	!ENWRKA,Y	; {
		STA	!ENWRKC,Y	; c{
		LDA	#0
		STA	!ENWRK8,Y	; ]p
		TYX
		JSR	M3KOJ2
		RTS
;
;########################################################################
;# (LABEL)	DRCHST		(D_LN^[p^[Zbg)	#
;########################################################################
DRCHST		EQU	$
		LDA	<ENWRK2,X
		BNE	DRCHST_300
		LDA	!ENTIM0,X
		BNE	DRCHST_200
		LDA	#3
		STA	!ENTIM0,X
		INC	!ENCONT,X
DRCHST_200
		LDA	!ENCONT,X
		AND	#1
		BRA	DRCHST_500
DRCHST_300
		LDA	!ENYSPD,X
		BPL	DRCHST_320
		LDA	#18H
		BRA	DRCHST_500
DRCHST_320
		LDA	!ENFSXE
		CMP	#10H
		BCS	DRCHST_340
;
		JSL	>RANDAM
		LDA	<RANDM0
		AND	#00000111B
		BNE	DRCHST_330
		JSL	>KIRAKIRA_SET	;D_̌ʃZbg
DRCHST_330
		LDA	#1AH
		BRA	DRCHST_500
DRCHST_340
		LDA	#17H
DRCHST_500
		STA	!ENCHPT,X
;
;
		RTS
;
;########################################################################
;# (LABEL)	DRVSLF		(h{[urtg`FbN)		#
;########################################################################
DRVSLF		EQU	$
		LDY	!LIFIDX
		JSR	DRVSLF_100
		LDA	<ENWRK4,X
		BNE	DRVSLF_600
		LDY	!LIFIDX+2
DRVSLF_100
		LDA	!ENYSPD,X
		BMI	DRVSLF_500
		LDA	!ENXPSL,Y
		CMP	!ECENTX,X
		BCS	DRVSLF_500
		CLC
		ADC	#20H
		CMP	!ECENTX,X
		BCC	DRVSLF_500
;
		LDA	!ENYPSL,Y
		SEC
		SBC	#10H
		CMP	!ENYPSL,X
		BCS	DRVSLF_500
		CLC
		ADC	#8
		CMP	!ENYPSL,X
		BCC	DRVSLF_500
;
		LDY	!ENLFIX
		LDA	!ENYPSL,Y
		SEC
		SBC	#10H
		STA	!ENYPSL,X	; ␮
;
		LDA	#1
		STA	<ENWRK4,X
		STZ	<ENWRK2,X
		RTS
DRVSLF_500
		STZ	<ENWRK4,X
DRVSLF_600
;
		RTS
;
;########################################################################
;# (LABEL)	DRFMCK		(D_t[`FbN)			#
;########################################################################
DRFMCK		EQU	$
		LDA	!ENYPSL,X
		BPL	DRFMCK_200
;
		LDA	!ENXPSL,X
		CMP	#30H
		BCS	DRFMCK_300
		STZ	!ENXSPD,X
		LDA	#30H
		BRA	DRFMCK_500
DRFMCK_300
		CMP	#0C1H
		BCC	DRFMCK_500
		STZ	!ENXSPD,X
		LDA	#0C0H
		BRA	DRFMCK_500
;
DRFMCK_200
;
		LDA	!ENXPSL,X
		CMP	#10H
		BCS	DRFMCK_400
		STZ	!ENXSPD,X
		LDA	#10H
		BRA	DRFMCK_500
DRFMCK_400
		CMP	#0E1H
		BCC	DRFMCK_500
		STZ	!ENXSPD,X
		LDA	#0E0H
DRFMCK_500
		STA	!ENXPSL,X
		RTS
;
;########################################################################
;# (LABEL)	DR2FSR		(DT[`)				#
;########################################################################
DR2FSR		EQU	$
		LDX	!DRINDX
		LDA	!ENCBFG,X
		LSR	A		; ĂH
		BCS	DR2FSR_100	; !YES
		LDA	<ENWRK4,X
		BNE	DR2FSR_100
		LDA	#1
		STA	<ENWRK2,X	; WvtOZbg
		BRA	DR2FSR_120
DR2FSR_100
		STZ	<ENWRK2,X	; WvtONA
DR2FSR_120
;
		LDA	<ENWRK4,X
		CMP	#1		; tgIH
		BNE	DR2FSR_300	; !NO
;
		LDA	!ENFSYE
		CMP	#4		; D͓H
		BNE	DR2FSR_200	; !NO
		LDA	!ENFSXE
		CMP	#2		; WvnjH
		BCS	DR2FSR_800	; !NO
;
		LDA	#0FB80H
		BRA	DR2FSR_400	; WvZbg
;
DR2FSR_200				; tg҂
		LDY	!ENLFIX
		LDA	!ENMOVX,Y
		CLC
		ADC	!ENXPSL,X
		STA	!ENXPSL,X
;
		LDA	!ENXPSL,X
		CMP	#20H
		BCC	DR2FSR_250
		CMP	#0D0H
		BCS	DR2FSR_250
;
		LDA	!ENLFXP
		ROL	A
		ROL	A
		ROL	A
		AND	#0002H
		STA	<EWORK0
		LDA	!ENLFXP
		EOR	!ENXSPD,X
		BRA	DR2FSR_805
DR2FSR_250
;
		LDA	#0FA00H
		BRA	DR2FSR_400	; WvZbg
;
DR2FSR_300
		LDA	<ENWRK2,X	; WvH
		BNE	DR2FSR_500	; !YES
;
		LDA	!ENFSXE
		CMP	#4		; D͋߂H
		BCS	DR2FSR_800	; !NO
		LDA	!ENFSYE		; D͓H
		BEQ	DR2FSR_350	; !YES
		CMP	#70H		; tgT[`H
		BCC	DR2FSR_330	; !NO
		LDA	#3
		STA	<ENWRK0,X
		BRA	DR2FSR_800
DR2FSR_330
		LDA	#0FA00H
		BRA	DR2FSR_400
DR2FSR_350
		LDA	#0FB00H
DR2FSR_400
		STA	!ENYSPD,X	; Wv̓Zbg
		LDA	#1
		STA	<ENWRK2,X	; WvtOI
		STZ	<ENWRK4,X
		LDA	#38H
		JSL	>SOUND_3_ON
;
DR2FSR_500				; Wv
;
DR2FSR_800				; ړ
		LDA	!ENFSXP
		ROL	A
		ROL	A
		ROL	A
		AND	#0002H
		STA	<EWORK0
		LDA	!ENFSXP
		EOR	!ENXSPD,X
DR2FSR_805
		AND	#8000H
		BEQ	DR2FSR_820
		LDA	<ENWRK2,X
		BNE	DR2FSR_810
		LDA	#0
		BRA	DR2FSR_820
DR2FSR_810
		LDA	#4
DR2FSR_820
		CLC
		ADC	<EWORK0
		TAY
		LDA	DR2FSR_MVXG,Y
		CLC
		ADC	!ENXSPD,X
		STA	!ENXSPD,X
DR2FSR_900
;
		RTS
;
DR2FSR_MVXG	EQU	$
		WORD	00008H,0FFF8H
		WORD	00038H,0FFC8H
;
;########################################################################
;# (LABEL)	DR2PSR		(vC[T[`)			#
;########################################################################
DR2PSR		EQU	$
		LDX	!DRINDX
		JMP	DR2PSR
;
		RTS
;
;########################################################################
;# (LABEL)	DRSRCH		(D_T[`)			#
;########################################################################
DRSRCH		EQU	$
		LDA	!PCENTX
		SEC
		SBC	!ECENTX,X
		STA	!ENPLXP		; vC[ | D_wW
		BPL	DRSRCH_100
		EOR	#0FFFFH
		INC	A
DRSRCH_100
		STA	!ENPLXE		; vC[|D_wWiΒlj
;
		LDA	!PCENTY
		SEC
		SBC	!ENYPSL,X
		STA	!ENPLYP		; vC[ | D_xW
		BPL	DRSRCH_150
		EOR	#0FFFFH
		INC	A
DRSRCH_150
		STA	!ENPLYE		; vC[|D_xWiΒlj
;
		LDA	<ENWRK2,X
		BEQ	DRSRCH_170
		LDY	!ENFSIX
		LDA	!ENMYNO,Y
		CMP	#M_FUS
		BNE	DRSRCH_170
		LDA	!ENMODE,Y
		BEQ	DRSRCH_170
		JMP	DRSRCH_JCK
DRSRCH_170
		STZ	!ENFSIX
		STZ	!ENLFIX
;
		LDY	#5CH
DRSRCH_200
		LDA	!ENMODE,Y
		BEQ	DRSRCH_500
;
		LDA	!ENMYNO,Y
		CMP	#M_FUS		; DH
		BNE	DRSRCH_300	; !NO
;
		LDA	!ENWRK6,Y
		BNE	DRSRCH_500
		LDA	!ECENTX,Y
		CLC
		ADC	#8
		STA	!ECENTX,Y
		LDA	!ECENTY,Y
		CLC
		ADC	#5
		STA	!ECENTY,Y
		LDA	#2
		STA	<EWORK8
		PHY
		JSR	DRSRCH_SUB
		PLY
		BRA	DRSRCH_500
DRSRCH_300
		CMP	#M_LIF		; tgH
		BNE	DRSRCH_500	; !NO
		LDA	!ECENTX,Y
		CLC
		ADC	#8
		STA	!ECENTX,Y
		LDA	!ECENTY,Y
		CLC
		ADC	#0FFF8H
		STA	!ECENTY,Y
		LDA	#4
		STA	<EWORK8
		PHY
		JSR	DRSRCH_SUB
		PLY
;
DRSRCH_500
		DEY
		DEY
		DEY
		DEY			; IH
		BPL	DRSRCH_200	; !NO
;
		LDY	#2
		LDA	!ENPLYE
		CMP	!ENFSYE
		BCS	DRSRCH_700	; DWZbg
		CMP	#10H
		BCS	DRSRCH_700
		LDA	!PLFLSH
		BNE	DRSRCH_700
		LDY	#0
DRSRCH_700
		LDA	!ENPLXP,Y
		STA	!NEARXP
		LDA	!ENPLYP,Y
		STA	!NEARYP
		LDA	!ENPLXE,Y
		STA	!NEARXE
		LDA	!ENPLYE,Y
		STA	!NEARYE
		LDA	!ENPLIX,Y
		STA	!NEARIX
;
		RTS
;
DRSRCH_JCK	EQU	$
		LDY	!ENFSIX
		LDA	!ECENTX,Y
		CLC
		ADC	#8
		STA	!ECENTX,Y
		LDA	!ECENTY,Y
		CLC
		ADC	#5
		STA	!ECENTY,Y
		LDA	#2
		STA	<EWORK8
		STZ	!ENFSIX
		JSR	DRSRCH_SUB
;
		LDY	!ENLFIX
		LDA	!ECENTX,Y
		CLC
		ADC	#8
		STA	!ECENTX,Y
		LDA	!ECENTY,Y
		CLC
		ADC	#0FFF8H
		STA	!ECENTY,Y
		LDA	#4
		STA	<EWORK8
		STZ	!ENLFIX
		JSR	DRSRCH_SUB
;
		LDY	#0
		JMP	DRSRCH_500
;
DRSRCH_SUB	EQU	$
		LDA	!ECENTX,Y
		SEC
		SBC	!ECENTX,X
		STA	<EWORK0
		BPL	DRSRCH_SUB10
		EOR	#0FFFFH
		INC	A
DRSRCH_SUB10
		STA	<EWORK4
;
		LDA	!ECENTY,Y
		CLC
		ADC	#8
		SEC
		SBC	!ECENTY,X
		STA	<EWORK2
		BPL	DRSRCH_SUB20
		EOR	#0FFFFH
		INC	A
DRSRCH_SUB20
		STA	<EWORK6
;
		STY	<EWORKA
		LDY	<EWORK8
		LDA	ENPLIX,Y
		BEQ	DRSRCH_SUB40
		LDA	!ENPLYE,Y
		CMP	<EWORK6
		BCC	DRSRCH_SUB90
		BNE	DRSRCH_SUB40
		LDA	!ENPLXE,Y
		CMP	<EWORK4
		BCC	DRSRCH_SUB90
DRSRCH_SUB40
		LDA	<EWORK0
		STA	!ENPLXP,Y
		LDA	<EWORK2
		STA	!ENPLYP,Y
		LDA	<EWORK4
		STA	!ENPLXE,Y
		LDA	<EWORK6
		STA	!ENPLYE,Y
		LDA	<EWORKA
		STA	!ENPLIX,Y
		TAY
DRSRCH_SUB90
;
		RTS
;
;
;****************************************************************
;*								*
;*		Q[ɂǂ邽߂̃f[^ Zbg		*
;*								*
;****************************************************************
		MEM8
		IDX8
BACK_GAME	EQU	$
		PHP
		MI8			; memory , index 8bit mode
;
		LDA	!BKHISCRE
		PHA
		LDA	#07FH
		STA	!BKHISCRE
		JSL	>SVDTSV
		PLA
		STA	!BKHISCRE
;
		LDA	!MINI_SVBUF
		CMP	#0FFH
		BNE	BACK_GAME_PASS
		LDA	#HMPIN
		STA	!MODENO
		BRA	BACK_GAME_END
;
BACK_GAME_PASS	EQU	$
		LDA	!MINI_SVBUF+2
		STA	>NXGOTOBF+070H*4+2
		LDA	#000
		STA	>NXGOTOBF+070H*4+3
;
		INC	A
		STA	!NEXTGOTO
		LDA	#GMIN
		STA	!MODENO
;
		M16			; memory 16bit mode
		LDA	!MINI_SVBUF+0
		STA	>NXGOTOBF+070H*4+0
		LDA	#00070H*4
		STA	!NEXTGOTO_POS
		LDA	!MINI_SVBUF+3
		STA	!TIMER
;
BACK_GAME_END	EQU	$
		PLP
		RTL
		MEM8
;
;
;------------------------------------------
;------------------------------------------
;
;
		END
