;************************************************************************
;*									*
;*	title name	: "yossy"					*
;*	proccess	: title						*
;*	file name	: ys_title					*
;*									*
;************************************************************************
;
;
		SALL
;
		include		ys_header.inc
		include		ys_unit.h
;
		XALL
;
;
;------------------------------------------------------------------------
;-		global symbol						-
;------------------------------------------------------------------------
		GLB	MODINC,MODINC2
		GLB	TLINIT,TLPLAY,KEYINCHK
		GLB	SFC_STOP,KEYCHK_DSP
;
;------------------------------------------------------------------------
;-		extern symbol						-
;------------------------------------------------------------------------
;
;-------------< ys_main >------------------------------------------------
		EXT	RAMCLR,VRAMCL,VRAMCL2,BLNKOFF,URAMCLR
		EXT	ENRAMCLR,OAMDXCLR
;
		EXT	SFCSTP,KEYSTP,HMPIN
;
;-------------< ys_save >------------------------------------------------
		EXT	SVRMCK_INT
;
;-------------< ys_rpro >------------------------------------------------
		EXT	CHIPON
;
;-------------< ys_init >------------------------------------------------
		EXT	GMMDST,CHRSET,COLSET
		EXT	GM00
		EXT	TLCHR,TLCOL
;
;------------------------------------------------------------------------
;-		define symbol						-
;------------------------------------------------------------------------
;;;;		EQU
;
;
;************************************************************************
;*									*
;*		program start						*
;*									*
;************************************************************************
;
;
		EXTEND
;
;
		MEM8
		IDX8
;
Group_10	GROUP	Title_pro
Title_pro	SECT	REL
;
;************************************************************************
;*		title initial						*
;************************************************************************
TITLE_OAM_DT	EQU	$
		HEX	60,60,00,00
		HEX	70,60,02,00
		HEX	80,60,04,00
		HEX	90,60,06,00
TITLE_OAM_DT_E	EQU	$
;
TLINIT		EQU	$
;
;------------------------------------------------------------------------
;-		Sq`lNA[					-
;------------------------------------------------------------------------
		JSL	>RAMCLR		;all RAM clear
;
;------------------------------------------------------------------------
;-		uq`lNA[					-
;------------------------------------------------------------------------
		JSL	>VRAMCL		;VRAM clear
;
;------------------------------------------------------------------------
;-		ʃ[hZbg					-
;------------------------------------------------------------------------
		LDX	#GM00		;(X) <-- game mode type no.
		JSL	>GMMDST		;game mode set
		LDA	#00010000B
		STA	212CH		;OBJ only display
;
		LDA	213FH
		AND	#010H		; msrb ?
		BEQ	TLINIT_000	;	YES -> TLINIT_000
		JSR	SFC_STOP_INIT
		JMP	RETSUB
TLINIT_000	EQU	$
;
;------------------------------------------------------------------------
;-		LN^[Zbg					-
;------------------------------------------------------------------------
;
		I16
;
		LDY	#TLCHR		;(Y) <-- LN^[zuf[^|C^[
		JSL	>CHRSET
;
		
;
;------------------------------------------------------------------------
;-		J[Zbg						-
;------------------------------------------------------------------------
;
		MI16
;
		LDX	#TLCOL		;(X) <-- J[zuf[^|C^[
		JSL	>COLSET
;
		MEM8
		IDX8
;
		JSR	KEYCHK_DSP_INT
;
;------------------------------------------------------------------------
;-		^CgSn`lZbg				-
;------------------------------------------------------------------------
		LDX	#TITLE_OAM_DT_E-TITLE_OAM_DT-1
TLINIT_200	EQU	$
		LDA	!TITLE_OAM_DT,X
		STA	>OAM,X
		DEX
		BPL	TLINIT_200
		LDA	#10101010B
		STA	>OAMSUB
;
;------------------------------------------------------------------------
;-		Z[u q`l I[`FbN				-
;------------------------------------------------------------------------
		JSL	>SVRMCK_INT
;
;------------------------------------------------------------------------
;-		q`lZbg					-
;------------------------------------------------------------------------
		STZ	FADTM		;fade wait timer set
		LDA	#080H		;hh\ԃZbg
		STA	TITLEFG
;;;;K;;;;;
;;;;K;;;;;------------------------------------------------------------------------
;;;;K;;;;;-		hhRC`Zbg			-
;;;;K;;;;;------------------------------------------------------------------------
;;;;K;;;;		LDA	#09H		;[]
;;;;K;;;;		STA	<SOUND_3
;
;========================================================================
;=		uLO  mlh荞݋			=
;========================================================================
MODINC2		EQU	$
		JSL	>BLNKOFF	;blanking "OFF"
;
;========================================================================
;=		̏[h					=
;========================================================================
MODINC		EQU	$
		INC	MODENO
;
RETSUB		EQU	$
		PLB
		RTL
;
;
;************************************************************************
;*		title play						*
;************************************************************************
;
TLPLAY		EQU	$
		DEC	TITLEFG
		BNE	RETSUB		;hh\҂H ( yes:RETSUB )
;
		JMP	>MODINC		;go to next mode !!
;
;
;****************************************************************
;*		Q[ Xgbv bZ[W f[^		*
;****************************************************************
SFC_STOP_DAT	EQU	$
		BYTE	0FEH,000H
		BYTE	0FDH,000H,0FCH,000H
		BYTE	0BDH,0B1H,0B2H,0BCH	;THIS
		BYTE	0D0H
		BYTE	0B0H,0AAH,0B6H,0AEH	;GAME
		BYTE	0D0H
		BYTE	0B9H,0AAH,0B4H		;PAK
		BYTE	0D0H
		BYTE	0B2H,0BCH		;IS
		BYTE	0D0H
		BYTE	0B7H,0B8H,0BDH		;NOT
;
		BYTE	0FEH,001H
		BYTE	0FDH,008H,0FCH,000H
		BYTE	0ADH,0AEH,0BCH,0B2H
		BYTE	0B0H,0B7H,0AEH,0ADH	;DESIGINED
		BYTE	0D0H
		BYTE	0AFH,0B8H,0BBH		;FOR
		BYTE	0D0H
		BYTE	0C2H,0B8H,0BEH,0BBH	;FOUR
;
		BYTE	0FEH,002H
		BYTE	0FDH,010H,0FCH,000H
		BYTE	0BCH,0BEH,0B9H,0AEH,0BBH ;SUPER
		BYTE	0D0H
		BYTE	0AFH,0AAH,0B6H,0B2H	;FAMICOM
		BYTE	0ACH,0B8H,0B6H		;
;
		BYTE	0FEH,003H
		BYTE	0FDH,018H,0FCH,030H
		BYTE	0B8H,0BBH		;OR
;
		BYTE	0FFH		; end code
;
;
SFC_STOP_DTSB	EQU	$
		BYTE	0FEH,000H
		BYTE	0FDH,000H,0FCH,000H
		BYTE	0BCH,0BEH,0B9H,0AEH,0BBH ;SUPER
		BYTE	0D0H
		BYTE	0B7H,0AEH,0BCH,0F3H	;NES
;
		BYTE	0FEH,001H	; NINTENDO CO., LTD.
		BYTE	0FDH,008H,0FCH,000H
		BYTE	0B7H,0B2H,0B7H,0BDH,0AEH,0B7H,0ADH,0B8H
		BYTE	0D0H
		BYTE	0ACH,0B8H,0F3H
		BYTE	0FCH,008H
		BYTE	0CFH,0D0H
		BYTE	0FCH,018H
		BYTE	0B5H,0BDH,0ADH,0F3H
		BYTE	0FFH		; end code
;
SFC_STOP_CLS	EQU	$
		WORD	0007FH
;
SFC_STOP_MOJIU0 EQU	$
		WORD	00000H,00001H,00002H,00003H,00004H,00005H
		WORD	00006H,00007H,00008H,00009H,0000AH,0000BH
		WORD	0000CH,0000DH,0000EH,0000FH,00040H,00041H
		WORD	00042H,00043H,00044H,00045H,00046H,00047H
		WORD	00048H,00049H,0004AH,0004BH,0004CH,0004DH
;
SFC_STOP_MOJID0 EQU	$
		WORD	00400H,00401H,00402H,00403H,00404H,00405H
		WORD	00406H,00407H,00408H,00409H,0040AH,0040BH
		WORD	0040CH,0040DH,0040EH,0040FH,00440H,00441H
		WORD	00442H,00443H,00444H,00445H,00446H,00447H
		WORD	00448H,00449H,0044AH,0044BH,0044CH,0044DH
;
SFC_STOP_MOJIU1 EQU	$
		WORD	00010H,00011H,00012H,00013H,00014H,00015H
		WORD	00016H,00017H,00018H,00019H,0001AH,0001BH
		WORD	0001CH,0001DH,0001EH,0001FH,00050H,00051H
		WORD	00052H,00053H,00054H,00055H,00056H,00057H
		WORD	00058H,00059H,0005AH
;
SFC_STOP_MOJID1 EQU	$
		WORD	00410H,00411H,00412H,00413H,00414H,00415H
		WORD	00416H,00417H,00418H,00419H,0041AH,0041BH
		WORD	0041CH,0041DH,0041EH,0041FH,00450H,00451H
		WORD	00452H,00453H,00454H,00455H,00456H,00457H
		WORD	00458H,00459H,0045AH
;
SFC_STOP_MOJIU2 EQU	$
		WORD	00020H,00021H,00022H,00023H,00024H,00025H
		WORD	00026H,00027H,00028H,00029H,0002AH,0002BH
		WORD	0002CH,0002DH,0002EH,0002FH,00060H,00061H
		WORD	00062H,00063H
;
SFC_STOP_MOJID2 EQU	$
		WORD	00420H,00421H,00422H,00423H,00424H,00425H
		WORD	00426H,00427H,00428H,00429H,0042AH,0042BH
		WORD	0042CH,0042DH,0042EH,0042FH,00460H,00461H
		WORD	00462H,00463H
;
SFC_STOP_MOJIU3 EQU	$
		WORD	00030H,00031H,00032H,00033H,00034H,00035H
		WORD	00036H,00037H,00038H,00039H,0003AH,0003BH
		WORD	0003CH,0003DH,0003EH,0003FH,00070H,00071H
;
SFC_STOP_MOJID3 EQU	$
		WORD	00430H,00431H,00432H,00433H,00434H,00435H
		WORD	00436H,00437H,00438H,00439H,0043AH,0043BH
		WORD	0043CH,0043DH,0043EH,0043FH,00470H,00471H
;
SFC_STOP_MOJIU4 EQU	$
		WORD	00080H,00081H,00082H,00083H,00084H,00085H
		WORD	00086H,00087H,00088H,00089H,0008AH,0008BH
		WORD	0008CH,0008DH,0008EH,0008FH,000C0H,000C1H
;
SFC_STOP_MOJID4 EQU	$
		WORD	00480H,00481H,00482H,00483H,00484H,00485H
		WORD	00486H,00487H,00488H,00489H,0048AH,0048BH
		WORD	0048CH,0048DH,0048EH,0048FH,004C0H,004C1H
;
SFC_STOP_MOJIU5 EQU	$
		WORD	00090H,00091H,00092H,00093H,00094H,00095H
		WORD	00096H,00097H,00098H,00099H,0009AH,0009BH
		WORD	0009CH,0009DH,0009EH,0009FH,000D0H,000D1H
		WORD	000D2H,000D3H,000D4H,000D5H,000D6H,000D7H
;
SFC_STOP_MOJID5 EQU	$
		WORD	00490H,00491H,00492H,00493H,00494H,00495H
		WORD	00496H,00497H,00498H,00499H,0049AH,0049BH
		WORD	0049CH,0049DH,0049EH,0049FH,004D0H,004D1H
		WORD	004D2H,004D3H,004D4H,004D5H,004D6H,004D7H
;
;
;****************************************************************
;*		Q[ Xgbv CjV Zbg		*
;****************************************************************
SFC_STOP_INIT	EQU	$
		LDA	#00000100B
		STA	212CH
		STA	!MANSEL
		LDA	!CIPSCR
		AND	#0FCH
		STA	!CIPSCR
		LDA	#DM01_MSGBITMP/400H
		STA	!CIPSCB
;
		LDA	#BANK SFC_STOP_DAT
		STA	!OPMSGADRB
		M16			; memory 16bit mode
		LDA	#SFC_STOP_DAT
		STA	!OPMSGADR
		M_CHIP	OPMJSET
		M8			; memory 8bit mode
;
		JSR	STOP_DMA_SET
;
		LDA	#BANK SFC_STOP_DTSB
		STA	!OPMSGADRB
		M16			; memory 16bit mode
		LDA	#SFC_STOP_DTSB
		STA	!OPMSGADR
		M_CHIP	OPMJSET
;
;--------------- LN^[ cl`] ------------------------
		LDX	#10000000B
		STX	2115H		;inc mode set
		LDA	#06400H
		STA	2116H		;VRAM address set
		LDA	#00000001B+(18H*100H)
		STA	4300H		;DMA paramer & B bus address set
		LDA	#DM01_MSGBITMP
		STA	4302H		;A bus address(L,H) set
		LDX	#BANK DM01_MSGBITMP
		STX	4304H		;	"       (B) set
		LDA	#00800H
		STA	4305H		;number of byte set
		LDY	#00000001B
		STY	420BH		;DMA "ON" !!
;
;--------------- XN[  ----------------------------
		LDA	#07A29H
		STA	2116H		;VRAM address set
		LDA	#00000001B+(18H*100H)
		STA	4300H		;DMA paramer & B bus address set
		LDA	#SFC_STOP_MOJIU4
		STA	4302H		;A bus address(L,H) set
		LDX	#BANK SFC_STOP_MOJIU4
		STX	4304H		;	"       (B) set
		LDA	#SFC_STOP_MOJID4-SFC_STOP_MOJIU4
		STA	4305H		;number of byte set
		STY	420BH
;
		LDA	#07A49H
		STA	2116H		;VRAM address set
		LDA	#SFC_STOP_MOJID4
		STA	4302H		;A bus address(L,H) set
		LDA	#SFC_STOP_MOJID4-SFC_STOP_MOJIU4
		STA	4305H		;number of byte set
		STY	420BH
;
;
		LDA	#07AC5H
		STA	2116H		;VRAM address set
		LDA	#SFC_STOP_MOJIU5
		STA	4302H		;A bus address(L,H) set
		LDA	#SFC_STOP_MOJID5-SFC_STOP_MOJIU5
		STA	4305H		;number of byte set
		STY	420BH
;
		LDA	#07AE5H
		STA	2116H		;VRAM address set
		LDA	#SFC_STOP_MOJID5
		STA	4302H		;A bus address(L,H) set
		LDA	#SFC_STOP_MOJID5-SFC_STOP_MOJIU5
		STA	4305H		;number of byte set
		STY	420BH
;
		M8			; memory 8bit mode
		LDA	#SFCSTP
		STA	!MODENO
		JSL	>BLNKOFF	;blanking "OFF"
		RTS
;
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+		rebXgbvcl`]		+
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
STOP_DMA_SET	EQU	$
		M16			; memory 16bit mode
;
;--------------- LN^[ cl`] ------------------------
		LDX	#10000000B
		STX	2115H		;inc mode set
		LDA	#06000H
		STA	2116H		;VRAM address set
		LDA	#00000001B+(18H*100H)
		STA	4300H		;DMA paramer & B bus address set
		LDA	#DM01_MSGBITMP
		STA	4302H		;A bus address(L,H) set
		LDX	#BANK DM01_MSGBITMP
		STX	4304H		;	"       (B) set
		LDA	#00800H
		STA	4305H		;number of byte set
		LDY	#00000001B
		STY	420BH		;DMA "ON" !!
;
;--------------- XN[ NA ------------------------------
		LDX	#00000000B
		STX	2115H		;inc mode set
		LDA	#07800H
		STA	2116H		;VRAM address
		LDA	#00001001B+(18H*100H)
		STA	4300H		;DMA paramer & B bus address
		LDA	#SFC_STOP_CLS
		STA	4302H		;A bus address(L,H) set
		LDX	#BANK SFC_STOP_CLS
		STX	4304H		;	"       (B) set
		LDA	#00800H
		STA	4305H		;number of byte set
		STY	420BH
;
		LDX	#10000000B
		STX	2115H		;inc mode set
		LDA	#07800H
		STA	2116H		;VRAM address set
		LDA	#00001001B+(19H*100H)
		STA	4300H		;DMA paramer & B bus address set
		LDA	#SFC_STOP_CLS+1
		STA	4302H		;A bus address(L,H) set
		LDA	#00800H
		STA	4305H		;number of byte set
		STY	420BH		;DMA "ON" !!
;
;--------------- XN[  ----------------------------
		LDA	#078A1H
		STA	2116H		;VRAM address set
		LDA	#00000001B+(18H*100H)
		STA	4300H		;DMA paramer & B bus address set
		LDA	#SFC_STOP_MOJIU0
		STA	4302H		;A bus address(L,H) set
		LDX	#BANK SFC_STOP_MOJIU0
		STX	4304H		;	"       (B) set
		LDA	#SFC_STOP_MOJID0-SFC_STOP_MOJIU0
		STA	4305H		;number of byte set
		STY	420BH
;
		LDA	#078C1H
		STA	2116H		;VRAM address set
		LDA	#SFC_STOP_MOJID0
		STA	4302H		;A bus address(L,H) set
		LDA	#SFC_STOP_MOJID0-SFC_STOP_MOJIU0
		STA	4305H		;number of byte set
		STY	420BH
;
;
		LDA	#07903H
		STA	2116H		;VRAM address set
		LDA	#SFC_STOP_MOJIU1
		STA	4302H		;A bus address(L,H) set
		LDA	#SFC_STOP_MOJID1-SFC_STOP_MOJIU1
		STA	4305H		;number of byte set
		STY	420BH
;
		LDA	#07923H
		STA	2116H		;VRAM address set
		LDA	#SFC_STOP_MOJID1
		STA	4302H		;A bus address(L,H) set
		LDA	#SFC_STOP_MOJID1-SFC_STOP_MOJIU1
		STA	4305H		;number of byte set
		STY	420BH
;
;
		LDA	#07966H
		STA	2116H		;VRAM address set
		LDA	#SFC_STOP_MOJIU2
		STA	4302H		;A bus address(L,H) set
		LDA	#SFC_STOP_MOJID2-SFC_STOP_MOJIU2
		STA	4305H		;number of byte set
		STY	420BH
;
		LDA	#07986H
		STA	2116H		;VRAM address set
		LDA	#SFC_STOP_MOJID2
		STA	4302H		;A bus address(L,H) set
		LDA	#SFC_STOP_MOJID2-SFC_STOP_MOJIU2
		STA	4305H		;number of byte set
		STY	420BH
;
;
		LDA	#079C8H
		STA	2116H		;VRAM address set
		LDA	#SFC_STOP_MOJIU3
		STA	4302H		;A bus address(L,H) set
		LDA	#SFC_STOP_MOJID3-SFC_STOP_MOJIU3
		STA	4305H		;number of byte set
		STY	420BH
;
		LDA	#079E8H
		STA	2116H		;VRAM address set
		LDA	#SFC_STOP_MOJID3
		STA	4302H		;A bus address(L,H) set
		LDA	#SFC_STOP_MOJID3-SFC_STOP_MOJIU3
		STA	4305H		;number of byte set
		STY	420BH
;
		LDA	#07FFFH
		STA	>DATACOL+2
		STA	>DATACOL+6
		STA	>DATACOL+12
		STA	>DATACOL+14
;
		M8			; memory 8bit mode
		RTS
;
;
;****************************************************************
;*		Q[ Xgbv					*
;****************************************************************
SFC_STOP	EQU	$
		M16			; memory 16bit mode
		LDA	>DATACOL+2
		INC	A
		CMP	#08000H
		BCC	SFC_STOP_PAS
		LDA	#00000H
SFC_STOP_PAS	EQU	$
		STA	>DATACOL+2
		STA	>DATACOL+6
		STA	>DATACOL+12
		STA	>DATACOL+14
		M8			; memory 8bit mode
		PLB
		RTL
;
;****************************************************************
;*								*
;*	}`^bv  }EX ڑL`FbN			*
;*								*
;****************************************************************
KEYINCHK	EQU	$
;
		JSR	MULTITAP_CHK
;
		LDA	<WORK0		; PoQo
		CMP	#0FFH		;	}`^bv
		BNE	KEYINCHK_250	;		Ȃł ?
		LDA	<WORK1		;	YES -> KEYINCHK_400
		CMP	#0FFH		;	NO --> KEYINCHK_300
		BNE	KEYINCHK_400	;
KEYINCHK_250	EQU	$		;
		LDA	<WORK2		;
		CMP	#0FFH		;
		BNE	KEYINCHK_300	;
		LDA	<WORK3		;
		CMP	#0FFH		;
		BNE	KEYINCHK_400	;
;
KEYINCHK_300	EQU	$
		LDA	4218H		; Po
		AND	#00FH		;   }EXX[p[XR[v
		CMP	#001H		;     Ȃł邩 ?
		BEQ	KEYINCHK_400	;	YES -> KEYINCHK_400
		CMP	#00FH		;
		BEQ	KEYINCHK_400	;
;
		LDA	421AH		; Qo
		AND	#00FH		;   }EXX[p[XR[v
		CMP	#001H		;     Ȃł邩 ?
		BEQ	KEYINCHK_400	;	YES -> KEYINCHK_400
		CMP	#00FH		;
		BNE	KEYINCHK_900	;
;
KEYINCHK_400	EQU	$		; xbZ[W\ !!
		JSL	>ENRAMCLR	;enemy RAM clear
		JSL	>OAMDXCLR	;OAM clear
		M16			; memory 16bit mode
		PHB
		LDX	#BANK DATACOL
		PHX
		PLB
		LDX	#080H-2
KEYINCHK_420	EQU	$
		STZ	!DATACOL+000H,X
		STZ	!DATACOL+080H,X
		STZ	!DATACOL+100H,X
		STZ	!DATACOL+180H,X
		DEX
		DEX
		BPL	KEYINCHK_420
		PLB
		M8			; memory 8bit mode
;
;;;;K;;;;		JSR	KEYCHK_DSP_INT
;
		LDA	#KEYSTP
		STA	!MODENO
		BRA	KEYINCHK_990
;
KEYINCHK_900	EQU	$
		LDA	#09H		; hhRC`Zbg
		STA	<SOUND_3	;[]
		INC	!MODENO
KEYINCHK_990	EQU	$
		PLB
		RTL
;
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+	}`^bv ڑL`FbN			+
;+			out				+
;+			wrk0,1,2,3 : 000h or 0ffh	+
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
MULTITAP_CHK	EQU	$
		LDA	4016H
		ORA	#001
		STA	4016H
		STZ	<WORK0
		STZ	<WORK2
		LDX	#007
MLTTP_CHK_100	EQU	$
		ASL	<WORK0
		LDA	4016H
		AND	#002
		LSR	A
		ORA	<WORK0
		STA	<WORK0
		ASL	<WORK2
		LDA	4017H
		AND	#002
		LSR	A
		ORA	<WORK2
		STA	<WORK2
		DEX
		BPL	MLTTP_CHK_100
;
		LDA	4016H
		AND	#0FEH
		STA	4016H
		STZ	<WORK1
		STZ	<WORK3
		STZ	<WORK3
		LDX	#007
MLTTP_CHK_150	EQU	$
		ASL	<WORK1
		LDA	4016H
		AND	#002
		LSR	A
		ORA	<WORK1
		STA	<WORK1
		ASL	<WORK3
		LDA	4017H
		AND	#002
		LSR	A
		ORA	<WORK3
		STA	<WORK3
		DEX
		BPL	MLTTP_CHK_150
		RTS
;
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+		xbZ[Wf[^			+
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
KEYCHK_DSP_DAT	EQU	$
		BYTE	0FEH,000H
		BYTE	0FDH,000H,0FCH,038H
		BYTE	0A1H,0B9H,008H,0A2H,0B9H,021H	;PoQo
		BYTE	010H,010H,04AH,01BH,001H,03AH	;Ă
;
		BYTE	0FEH,001H
		BYTE	0FDH,008H,0FCH,028H
		BYTE	080H,052H,062H,008H		;}EX
		BYTE	062H,0C9H,092H,0C9H		;X[p[
		BYTE	062H,05CH,0C9H,094H,008H	;XR[v
;
		BYTE	0FEH,002H
		BYTE	0FDH,010H,0FCH,010H
		BYTE	080H,08AH,069H			;}`
		BYTE	094H,08BH,051H,055H,0C9H,0A5H	;v[[T
		BYTE	020H,037H,00EH			;Ȃǂ
;
		BYTE	0FEH,003H
		BYTE	0FDH,018H,0FCH,000H
		BYTE	028H,026H,011H,01BH		;͂
		BYTE	00AH,02EH,010H,001H		;
		BYTE	0FFH	; end code
;
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+	xbZ[W\ CjVZbg		+
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
KEYCHK_DSP_INT	EQU	$
;;;;K;;;;		LDA	#00000100B
;;;;K;;;;		STA	212CH		;afR̂ݕ\
;;;;K;;;;		STA	!MANSEL		;
		STZ	<SCCH3
		STZ	<SCCH3+1
		LDA	!CIPSCR
		AND	#0FCH
		STA	!CIPSCR
		LDA	#DM01_MSGBITMP/400H
		STA	!CIPSCB
;
		LDA	#BANK KEYCHK_DSP_DAT
		STA	!OPMSGADRB
		M16			; memory 16bit mode
		LDA	#KEYCHK_DSP_DAT
		STA	!OPMSGADR
		M_CHIP	OPMJSET
		M8			; memory 8bit mode
;
		JSR	STOP_DMA_SET
;
		RTS
;
;
;****************************************************************
;*								*
;*		L[`FbNɂ Q[ Xgbv		*
;*								*
;****************************************************************
KEYCHK_DSP	EQU	$
		M16			; memory 16bit mode
		LDA	>DATACOL+2
		INC	A
		CMP	#08000H
		BCC	KEYCHK_DSP_PAS
		LDA	#00000H
KEYCHK_DSP_PAS	EQU	$
		STA	>DATACOL+2
		STA	>DATACOL+6
		STA	>DATACOL+12
		STA	>DATACOL+14
		M8			; memory 8bit mode
;
		JSR	MULTITAP_CHK
;
		LDA	<WORK0		; PoQo
		CMP	#0FFH		;	}`^bv
		BNE	KEYCHK_DSP_250	;		Ȃł ?
		LDA	<WORK1		;	YES -> KEYCHK_DSP_900
		CMP	#0FFH		;	NO --> KEYCHK_DSP_300
		BNE	KEYCHK_DSP_900	;
KEYCHK_DSP_250	EQU	$		;
		LDA	<WORK2		;
		CMP	#0FFH		;
		BNE	KEYCHK_DSP_300	;
		LDA	<WORK3		;
		CMP	#0FFH		;
		BNE	KEYCHK_DSP_900	;
;
KEYCHK_DSP_300	EQU	$
		LDA	4218H		; Po
		AND	#00FH		;   }EXX[p[XR[v
		CMP	#001H		;     Ȃł邩 ?
		BEQ	KEYCHK_DSP_900	;	YES -> KEYCHK_DSP_900
		CMP	#00FH		;
		BEQ	KEYCHK_DSP_900	;
;
		LDA	421AH		; Qo
		AND	#00FH		;   }EXX[p[XR[v
		CMP	#001H		;     Ȃł邩 ?
		BEQ	KEYCHK_DSP_900	;	YES -> KEYCHK_DSP_900
		CMP	#00FH		;
		BEQ	KEYCHK_DSP_900	;
;
		STZ	!FADMK
		STZ	!FADNO
		STZ	!MODENO
		BRA	KEYCHK_DSP_990
KEYCHK_DSP_900	EQU	$
		LDA	#00000100B
		STA	212CH		;afR̂ݕ\
		STA	!MANSEL		;
KEYCHK_DSP_990	EQU	$
		PLB
		RTL
;
;
;
;
;
		END
