/****************************************************************/
/*	bZ[WRo[^[					*/
/*		( gcc msgcnv.c -o msgcnv )			*/
/*						by S.Takahata	*/
/****************************************************************/
#include	<stdio.h>
#include	<string.h>

#define		MAXMUM	1000
#if 0
#define		DSP
#endif

typedef struct{
    unsigned short	name;
    unsigned char	label[6];
}LABEL;

static LABEL	cnvdat[MAXMUM];
static int	num;
static FILE	*fpr, *fpw;

static int moji_label(unsigned short s);

void main(int argc, char **argv)
{
    int		i;
    unsigned char	in_file[40], out_file[44], label_file[40], title[40];
    
    if(argc < 2){
	printf("Input Error !!\n");
	printf("msgcnv [̓t@C] (-l[x]) (-h[ϊt@C])\n");
	exit(1);
    }
    
    strcpy(in_file, argv[1]);
    strcpy(out_file, argv[1]);
    strcat(out_file, ".OUT");
    strcpy(label_file, "msg.LBL");
    title[0] = '\0';
    if(argc >= 3){
	for(i = 2; i < argc; i++){
	    if(*argv[i] != '-'){
		printf("Input Error !!\n");
		printf("msgcnv [̓t@C] (-l[x]) (-h[ϊt@C])\n");
		exit(1);
	    }
	    switch(*(argv[i]+1)){
		case 'l' :
		case 'L' :
		    strcpy(title, argv[i]+2);
		    strcat(title, "\tEQU\t$\n");
		    break;
		case 'h' :
		case 'H' :
		    strcpy(label_file, argv[i]+2);
		    break;
		default :
		    printf("Input Error !!\n");
		    printf("msgcnv [̓t@C] (-l[x]) (-h[ϊt@C])\n");
		    exit(1);
	    }
	}
    }

    if((fpr = fopen(label_file, "r")) == NULL){
	printf("File Open Error !! [%s]\n", label_file);
	exit(1);
    }

    num = fread(cnvdat, sizeof(LABEL), MAXMUM, fpr);
    
    for(i=0; i<num; i++)
	cnvdat[i].label[5] = '\0';
    
    fclose(fpr);

    if((fpr = fopen(in_file, "r")) == NULL){
	printf("File Open Error !! [%s]\n", in_file);
	exit(1);
    }
    if((fpw = fopen(out_file, "w")) == NULL){
	printf("File Open Error !! [%s]\n", out_file);
	exit(1);
    }

    printf("JnII <<< %s >>>\n", in_file);
    
    fprintf(fpw, "%s", title);
#ifdef DSP
    printf("%s", title);
#endif
    mojicheck();
    
    fclose(fpr);
    fclose(fpw);

    printf("III\n");
}

mojicheck()
{
    static unsigned char	number[] = {'0', '1', '2', '3', '4', '5', '6', '7',
					    '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'},
    		Mspc[2] = "@", Msp2[2] = "", Mrtn[2] = "";
    int		i, j, c, no, sp;
    unsigned char	str[256], suu[5];
    unsigned short	s, *spc, *sp2, *rtn;

    spc = (unsigned short *)Mspc;
    sp2 = (unsigned short *)Msp2;
    rtn = (unsigned short *)Mrtn;
	
    i = j = 0;
    while((c = getc(fpr)) != EOF){
	if(i == 0){
	    if(c < 0x20){
		strcpy(str, cnvdat[moji_label(*rtn)].label);
		strcat(str, ",010H,000H\n");
		fprintf(fpw,"%s",str);
		fprintf(fpw,";\n");
#ifdef DSP
		puts(";");
#endif
		i = j = 0;
	    }
	    else{
		strcpy(str, "\t\tBYTE\t");
		s = (unsigned short)c << 8;
		c = getc(fpr);
		s = s | (unsigned short)c;
		if((no = moji_label(s)) >= 0){
		    if(cnvdat[no].name != *spc){
			if(j > 1){
			    strcat(str, cnvdat[moji_label(*sp2)].label);
			    strcat(str, ",");
			    sp = i * 8;
			    suu[0] = number[0];
			    suu[1] = number[(sp>>4)&0xf];
			    suu[2] = number[sp&0xf];
			    suu[3] = 'H';
			    suu[4] = '\0';
			    strcat(str, suu);
			    strcat(str, ",");
			}
			else if(j == 1){
			    strcat(str, cnvdat[moji_label(*spc)].label);
			    strcat(str, ",");
			}
			strcat(str, cnvdat[no].label);
			j = 0;
			i ++;
		    }
		    else{
			i ++;
			j ++;
		    }
		}
	    }
	}
	else{
	    if(c < 0x20){
		strcat(str, cnvdat[moji_label(*rtn)].label);
		strcat(str, ",010H,000H\n");
		fprintf(fpw,"%s",str);
		strcat(str,"\n");
		fprintf(fpw,"%s",str);
#ifdef DSP
		printf("%s",str);
#endif
		i = j = 0;
	    }
	    else{
		s = (unsigned short)c << 8;
		c = getc(fpr);
		s = s | (unsigned short)c;
		if((no = moji_label(s)) >= 0){
		    if(cnvdat[no].name != *spc){
			if(j > 1){
			    strcat(str, ",");
			    strcat(str, cnvdat[moji_label(*sp2)].label);
			    strcat(str, ",");
			    sp = i * 8;
			    suu[0] = number[0];
			    suu[1] = number[(sp>>4)&0xf];
			    suu[2] = number[sp&0xf];
			    suu[3] = 'H';
			    suu[4] = '\0';
			    strcat(str, suu);
			}
			else if(j == 1){
			    strcat(str, ",");
			    strcat(str, cnvdat[moji_label(*spc)].label);
			}
			strcat(str, ",");
			strcat(str, cnvdat[no].label);
			j = 0;
			i ++;
		    }
		    else{
			i ++;
			j ++;
		    }
		}
	    }
	}
    }
}

static int moji_label(unsigned short s)
{
    int		i;

    for(i = 0; i < num; i ++){
	if(s == cnvdat[i].name)	return i;
    }
    return -1;
}
