;************************************************************************
;*									*
;*	title name	: "yossy"					*
;*	proccess	: mario chip program.4				*
;*	file name	: ys_chip3					*
;*									*
;************************************************************************
;
;
		SALL
;
		include		ys_chip.inc
;
		XALL
;
;
;------------------------------------------------------------------------
;-		global symbol						-
;------------------------------------------------------------------------
		GLB	BERO_P_BIRI,BERO_P_RETN,BERO_P_END
;
;------------------------------------------------------------------------
;-		extern symbol						-
;------------------------------------------------------------------------
;
;-------------< ys_chip0 >-----------------------------------------------
		EXT	COS,SIN,LCOS,LSIN
;
;-------------< ys_msub0 >-----------------------------------------------
		EXT	HACHI,EGG00,EGG09,PONTA,SSLIM,PUTIG,PUTIB
		EXT	ON_DW,NLFLR,NLFUD,KORA0,KORA1,NRLF0,NRLF1,NRLF2,NRLF3
		EXT	HEIH0,CHKH0,GSTH0,MSHIH
;
;-------------< GmD >---------------------------------------
		EXT	FBOM0
;
;-------------< ys_mpldt >-----------------------------------------------
		EXT	BERO_BIRI_P
;
;------------------------------------------------------------------------
;-		define symbol						-
;------------------------------------------------------------------------
ENOBJ_DATA	EQU	4D0000H
ESPCAD		EQU	4d048aH
ESPTRCAD	EQU	4d0914H
;
;
;************************************************************************
;*									*
;*		program start						*
;*									*
;************************************************************************
;
;
Group_9		GROUP	S_chip_3
S_chip_3	SECT	REL
;
;
;************************************************************************
;*		Gf[^ǂݍ					*
;*			in  : (R1)     <-- H pos			*
;*			      (R2)     <-- min V pos			*
;*			      (R3)     <-- V pos			*
;*			      (R4)     <-- min H pos			*
;*			      (EDTADR) <-- data pointer			*
;************************************************************************
;
ENDTSR		EQU	$
		CACHE
;
		FROM	R1
		ASR
		ASR
		ASR
		TO	R1
		ASR
		FROM	R2
		ASR
		ASR
		ASR
		TO	R2
		ASR
		FROM	R3
		ASR
		ASR
		ASR
		TO	R3
		ASR
		FROM	R4
		ASR
		ASR
		ASR
		TO	R4
		ASR
;
		IBT	R5,#0FFH	;(R5)  <-- end code check data
		IWT	R6,#01FFH	;(R6)  <-- pos AND data
		IBT	R7,#016H	;(R7)  <-- X min <--> max size
		IBT	R13,#014H	;(R13) <-- Y min <--> max size
		IBT	R8,#00H		;(R8)  <-- data ON/OFF ram pointer
		IWT	R9,#EDSWBF	;(R9)  <--	  "        address
		IWT	R10,#EDSRBF	;(R10) <-- serach data no. set ram address
;
		LM	R0,EDTADR+2	;data address(B) set
		ROMB
		LM	R14,EDTADR	;      "     (L,H) set
EDSR10
		LDB	(R9)
		DEC	R0
		BMI	EDSR20		;set data ? ( no:EDSR20 )
		GETB
;
		WITH	R14
		ADD	#3
		INC	R8
		BRA	EDSR10
		INC	R9
;
EDSR20
		INC	R14
		TO	R12
		GETBH
		FROM	R12
		SUB	R5
		BEQ	EDSR60		;data end ? ( yes:EDSR60 )
		INC	R14
;
		FROM	R12
		AND	R6
		STW	(R10)		;serach data no. set
		TO	R11
		GETB
		INC	R14
;
		FROM	R12
		HIB
		LSR
		MOVE	R12,R0
		SUB	R3
		BNE	EDSR32		;= Y pos ? ( no:EDSR32 )
		FROM	R11
;
		SUB	R4
		BMI	EDSR30		;>= X min ? ( no:EDSR30 )
		SUB	R7
		BMI	EDSR40		;< max ? ( yes:EDSR40 )
;
EDSR30
		FROM	R11
EDSR32
		SUB	R1
		BNE	EDSR50		;= X pos ? ( no:EDSR50 )
		FROM	R12
		SUB	R2
		BMI	EDSR50		;>= Y min ? ( no:EDSR50 )
		SUB	R13
		BPL	EDSR50		;< max ? ( no:EDSR50 )
		NOP
;
;-------------- data find !! ------------------------------------
EDSR40
		INC	R10
		INC	R10
		FROM	R11
		STW	(R10)		;serach enemy X pos set
		INC	R10
		INC	R10
		FROM	R12
		STW	(R10)		;serach enemy Y pos set
		INC	R10
		INC	R10
		FROM	R8
		STW	(R10)		;data ON/OFF ram pointer set
		INC	R10
		INC	R10
		FROM	R5		;	"        "ON" !!
		STB	(R9)
EDSR50
		INC	R8
		BRA	EDSR10
		INC	R9
;
;-------------- end set -----------------------------------------
EDSR60
		FROM	R5
		STW	(R10)		;serach data end set
		STOP
		NOP
;
;************************************************************************
;*									*
;*		G̏Փ˃`FbN					*
;*									*
;************************************************************************
;------------------------------------------------------------------------
;-	use register							-
;-		r0,r1,r2,r3,r5,r6,r7,r8,r9,r10,r11,r12,r13,r14		-
;------------------------------------------------------------------------
;
ENCROSS		EQU	$
;
;-------------- enmy width set --------------------------------------------------
		IWT	R1,#CENXPSL
		IWT	R2,#CENYPSL
		IWT	R3,#CECNTXW
		IWT	R4,#CENMODE
		IWT	R5,#CECENTX
;
		CACHE
;
		IBT	R12,#CENNO
		MOVE	R13,R15
ENCR000
		LDB	(R4)
		WITH	R4
		ADD	#04
		DEC	R0
		BPL	ENCR010		; enmy on ? [ yes:ENCR010 ]
		INC	R0
;
;;;;		    SUB	    R0
		MOVE	R6,R12
		STB	(R6)
;
		IBT	R0,#4
		WITH	R1
		ADD	R0
		WITH	R2
		ADD	R0
		WITH	R3
		ADD	R0
		WITH	R5
		ADD	R0
;
		LOOP
		NOP
;
		BRA	ENCR0F0
		NOP
;
ENCR010
		SUB	#CEFAIL
		BCS	ENCR020
		INC	R0		;[ 1-> ]
;
		SUB	R0
ENCR020		EQU	$
		MOVE	R6,R12
		STB	(R6)
;
		TO	R6
		LDW	(R1)
		WITH	R1
		ADD	#04
		LDW	(R3)
		INC	R3
		INC	R3
		ADD	R6
		STW	(R5)
		INC	R5
		INC	R5
		TO	R6
		LDW	(R2)
		WITH	R2
		ADD	#04
		LDW	(R3)
		INC	R3
		INC	R3
		ADD	R6
		STW	(R5)
		INC	R5
;
		LOOP
		INC	R5
;
;
ENCR0F0
;-------------- player & enmy hit -----------------------------------------------
ENCR100
		LMS	R14,CPCENTX	; player center position x
		LMS	R2,CPCENTY	;   "      "	   "     y
		LMS	R3,CPWIDEX	;   "    width x
		LMS	R4,CPWIDEY	;   "      "   y
		IWT	R5,#CECENTX	; enmy center position address
		IWT	R6,#CEWIDEX	;  "   width address
		IWT	R7,#CEPWIDX
		IWT	R8,#CEPXMUK
		IWT	R0,#CECRSFG
		SMS	R0,CWORK1F	; hit flg ram address set
;
		IBT	R12,#CENNO
		MOVE	R13,R15
ENCR110
		MOVE	R0,R12
		LDB	(R0)
		SUB	#CEMOVE-CEFAIL+1
		BCS	ENCR120		; enmy on ? [ yes:ENCR120 ]
		NOP
;
		IBT	R0,#4
		WITH	R5
		ADD	R0
		WITH	R6
		ADD	R0
		WITH	R7
		ADD	R0
		INC	R8
		BRA	ENCR150
		INC	R8
;
ENCR120
		TO	R9
		LDW	(R6)		; enmy width x load
		INC	R6
		INC	R6
		TO	R10
		LDW	(R6)		; enmy width y load
		INC	R6
		INC	R6
;
		LDW	(R5)		; enmy center x load
		INC	R5
		INC	R5
		SUB	R14
		STW	(R7)
		INC	R7
		INC	R7
		MOVES	R11,R0
		BPL	ENCR130
		SUB	R0
;
		INC	R0		;[ IBT R0,#2 ]
		INC	R0		;
ENCR130
		STB	(R8)
		INC	R8
;
		LDW	(R5)		; enmy center y load
		INC	R5
		INC	R5
		SUB	R2
		STW	(R7)
		INC	R7
		INC	R7
		MOVES	R1,R0
		BPL	ENCR140
		SUB	R0
;
		INC	R0		;[ IBT R0,#2 ]
		INC	R0		;
ENCR140
		STB	(R8)
;
		FROM	R1
		ADD	R10
		ADD	R4
		BMI	ENCR150		; y hit ? [ no:ENCR150 ]
		INC	R8
;
		SUB	R10
		SUB	R10
		SUB	R4
		SUB	R4
		BPL	ENCR170		; y hit ? [ no:ENCR170 ]
		SUB	R0
;
		FROM	R11
		ADD	R9
		ADD	R3
		BMI	ENCR150		; x hit ? [ no:ENCR150 ]
		SUB	R9
;
		SUB	R9
		SUB	R3
		SUB	R3
		BPL	ENCR170		; HIT ? [ no:ENCR150 ]
		SUB	R0		;[ IBT R0,#0 ]
;
		LMS	R0,CPLMODE
		SUB	#6
		BCS	ENCR170		;vC[[hnjH ( no:ENCR170 )
		SUB	R0		;[ IBT R0,#0 ]
;
		BRA	ENCR170
		DEC	R0		;[ IBT R0,#0FFH ]
;
ENCR150
		SUB	R0
ENCR170
		LMS	R1,CWORK1F
		STB	(R1)
		INC	R8
		WITH	R1
		ADD	#04
		SMS	R1,CWORK1F
;
		LOOP
		INC	R8
;
;-------------- enmy & enmy hit -------------------------------------------------
ENCR200
		IWT	R1,#CENMOD0+1
		IWT	R5,#CECENTX	; enmy center position address
		IWT	R6,#CEWIDEX	;  "   width address
		IWT	R7,#CECROSX
		IWT	R9,#CECRSFG	; hit flg ram address set
		IWT	R10,#CENCRPT	;VS enmy cross check start pointer address set
;
		IBT	R12,#CENNO
ENCR210
		MOVE	R0,R12
		LDB	(R0)
		DEC	R0
		BMI	ENCR215		; enmy on ? [ no:ENCR215 ]
		NOP
;
		LDB	(R9)
		SUB	#0
		BNE	ENCR215		; player hit ? [ yes:ENCR215 ]
		NOP
;
		LDW	(R1)
		AND	#04H
		BNE	ENCR220		; enmy & enmy hit on ? [ yes:ENCR220 ]
		NOP
;
ENCR215
		IBT	R0,#4
		WITH	R5
		ADD	R0
		WITH	R6
		ADD	R0
		WITH	R7
		ADD	R0
		IWT	R15,#ENCR280
		NOP
;
;-------------- enemy & enemy cross check -----------------------
ENCR220
		TO	R14
		LDW	(R5)		; r14 <- enmy center position x load
		INC	R5
		INC	R5
		TO	R2
		LDW	(R5)		; r2 <- enmy center position y load
		INC	R5
		INC	R5
		TO	R3
		LDW	(R6)		; r3 <- enmy width x load
		INC	R6
		INC	R6
		TO	R4
		LDW	(R6)		; r4 <- enmy width y load
		INC	R6
		INC	R6
;
		SMS	R1,REG1
		SMS	R5,REG5
		SMS	R6,REG6
		SMS	R7,REG7
		SMS	R9,REG9
		SMS	R10,REG10
		SMS	R12,REG12
;
;-------------- VS enemy cross check ----------------------------
		IWT	R1,#CENMOD0+1
;
		TO	R11		;(R11) <-- VS enemy cross start index
		LDB	(R10)
		INC	R11
		MOVE	R10,R12		;(R10) <-- now check enemy index
;
		IBT	R12,#CENNO
		IWT	R13,#ENCR225+1
ENCR225
		FROM	R10
		SUB	R11
		BEQ	ENCR234		;VS enemy = now cross check enemy ? ( yes:ENCR234 )
		NOP
;
		LDB	(R11)
		DEC	R0
		BMI	ENCR234		; enmy on ? [ no:ENCR234 ]
		NOP
;
		IBT	R0,#CENNO
		SUB	R11
		ADD	R0
		ADD	R0
		MOVE	R8,R0		;(R8) <-- VS enemy cross index x4
		ADD	R1
		LDW	(R0)
		AND	#02H
		BEQ	ENCR234		; enmy & enmy hit on ? [ no:ENCR234 ]
		NOP
;
;-------------- cross check -----------------------------
		IWT	R0,#CECENTX	;enmy center position address
		TO	R5
		ADD	R8
		IWT	R0,#CEWIDEX	;  "   width address
		TO	R6
		ADD	R8
;
		TO	R9
		LDW	(R6)		; r9 <- enmy width x load
		LDW	(R5)		; enmy center x load
		SUB	R14
		MOVE	R7,R0		;(R7) <-- X cross wide
		ADD	R3
		ADD	R9
		BMI	ENCR234		; x hit ? [ no:ENCR234 ]
		SUB	R9
;
		SUB	R9
		SUB	R3
		SUB	R3
		DEC	R0		;[ 0 == ok ]
		BPL	ENCR234		; x hit ? [ no:ENCR234 ]
		INC	R5
;
		INC	R5
		INC	R6
		INC	R6
;
		TO	R9
		LDW	(R6)		; r9 <- enmy width y load
		LDW	(R5)		; enmy center y load
		SUB	R2
		MOVE	R5,R0		;(R5) <-- Y cross wide
		ADD	R4
		ADD	R9
		BMI	ENCR234		; y hit ? [ no:ENCR234 ]
		SUB	R9
;
		SUB	R9
		SUB	R4
		SUB	R4
		DEC	R0		;[ 0 == ok ]
		BPL	ENCR234		; HIT ? [ no:ENCR234 ]
		NOP
;
;-------------- cross !! ------------------------
		LMS	R0,REG7
		FROM	R7
		STW	(R0)		;X cross wide set
		INC	R0
		INC	R0
		FROM	R5
		STW	(R0)		;Y cross wide set
		TO	R7
		ADD	#2
;
		LMS	R9,REG9
		INC	R8
		FROM	R8
		STB	(R9)		;cross VS enemy index set
;
;-------------- new VS enemy cross start index set --------------
		DEC	R11
		BNE	ENCR232
		DEC	R11
;
		IBT	R11,#CENNO-1
ENCR232
		LMS	R10,REG10
		MOVE	R0,R11
		STB	(R10)
		BRA	ENCR260+1
		LMS	R1,REG1		;[ dummy ]
;
ENCR234
		DEC	R11
		BNE	ENCR236		;max enemy index over ? ( no:ENCR236 )
		NOP
;
		IBT	R11,#CENNO
ENCR236
		LOOP
		FROM	R10		;[ duumy ]
;
;----------------------------------------------------------------
;
		LMS	R0,REG7
		TO	R7
		ADD	#4
		LMS	R9,REG9
		LMS	R10,REG10
ENCR260
		LMS	R1,REG1
		LMS	R5,REG5
		LMS	R6,REG6
		LMS	R12,REG12
;
		IBT	R0,#4
ENCR280
		WITH	R1
		ADD	R0
		WITH	R9
		ADD	R0
		WITH	R10
		ADD	R0
;
		IWT	R13,#ENCR210+1
		LOOP
		MOVE	R0,R12		;[ dummy ]
;
;-------------- bero & enmy hit -------------------------------------------------
ENCR300
		LMS	R0,CPLSTFG
		SUB	#0
		BNE	ENCR3F0		;vC[rsnoH ( yes:ENCR3F0 )
		CACHE
;
		LMS	R1,CBRCNTX	; bero center position x
		LMS	R2,CBRCNTY	;   "    "	 "     y
		IWT	R5,#CECENTX	; enmy center position address
		IWT	R6,#CEWIDEX	;  "   width address
		IWT	R7,#CENMOD0
		IWT	R8,#CENMOD2
		IWT	R11,#CENSHOT
		IBT	R14,#00040H
;
;;;;		    SUB	    R0		    ;[ IBT R0,#0 ]
;;;;		    SMS	    R0,CEATOK	    ;I[gpHׂtOZbg
;
		IBT	R12,#CENNO
		IWT	R13,#ENCR310+1
ENCR310
		MOVE	R0,R12
		LDB	(R0)
		SUB	#CEMOVE-CEFAIL+1       ;[iw]
		BCC	ENCR315		; enmy on ? [ no:ENCR315 ]
		NOP
;
		LDW	(R7)
		AND	R14
		BEQ	ENCR320		; tabereru ? [ yes:ENCR320 ]
		NOP
;
ENCR315
		IBT	R0,#4
		WITH	R5
		ADD	R0
		WITH	R6
		BRA	ENCR352
		ADD	R0
;
ENCR320
		LDW	(R11)
		LSR
		BNE	ENCR315		;VbgEFCgH ( yes:ENCR315 )
		TO	R9
;
		LDW	(R6)		; enmy width x load
		INC	R6
		INC	R6
		TO	R10
		LDW	(R6)		; enmy width y load
		INC	R6
		INC	R6
;
		LDW	(R5)		; enmy center x load
		INC	R5
		INC	R5
		TO	R3
		SUB	R1		; x kyori
;
		LDW	(R5)		; enmy center y load
		INC	R5
		INC	R5
		TO	R4
		SUB	R2		; y kyori
;
		FROM	R4
		ADD	R10
		ADD	#0CH
		BMI	ENCR350		; y hit ? [ no:ENCR350 ]
		SUB	R10
;
		SUB	R10
		SUB	#0CH
		SUB	#0CH
		BMI	ENCR360		; y hit ? [ yes:ENCR360 ]
		FROM	R3
;
ENCR350
		IBT	R0,#4		;[ * not change !! ]
ENCR352
		WITH	R7
		ADD	R0
		WITH	R8
		ADD	R0
		WITH	R11
		ADD	R0
		LOOP
		MOVE	R0,R12		;[ dummy ]
;
ENCR3F0
		STOP
		NOP
;
ENCR360
;;;;		    FROM    R3
		ADD	R9
		ADD	#0CH
		BMI	ENCR350		; x hit ? [ no:ENCR350 ]
		SUB	R9
;
		SUB	R9
		SUB	#0CH
		SUB	#0CH
		BPL	ENCR350+1	; HIT ? [ no:ENCR350+1 ]
;;;;		    NOP
;
		IBT	R0,#CENNO
		SUB	R12
		ADD	R0
		TO	R1
		ADD	R0
;
;;;;		    LMS	    R0,CCONFIGFG
;;;;		    DEC	    R0
;;;;		    BPL	    ENCR361	    ;I[gHׂnjH ( no:ENCR361 )
		INC	R1		;(R1) <-- G̃CfbNX{P
;
;;;;		    SMS	    R1,CEATOK	    ;I[gpHׂtOhnmh
;;;;ENCR361
		LMS	R0,CEATFLG
		LMS	R5,CEATSTP
		OR	R5
		BNE	ENCR3F0		; syokuji chuu ? [ yes:ENCR3F0 ]
		NOP
;
		LMS	R6,CBERFLG	;(R6) <-- bero flag
		DEC	R6
		BMI	ENCR3F0		; bero on ? [ no:ENCR3F0 ]
		INC	R6
;
		LMS	R0,CBERO_GUNYA
		DEC	R0
		BPL	ENCR370		;OjOjH ( yes:ENCR370 )
		NOP
;
		IWT	R0,#CENMODE-1
		TO	R5		;(R5) <-- G[h|C^[
		ADD	R1
;
;-------------- HׂZbg ------------------------------------------
		LMS	R0,CBERXPS
		LMS	R2,CBERYPS
		OR	R2
		BEQ	ENCR370		; bero on ? [ no:ENCR370 ]
		NOP
;
		FROM	R6
		LSR
		BCC	ENCR363		;シłɖ߂ĂH ( yes:ENCR363 )
		INC	R6
;
		SMS	R6,CBERFLG	;Vbg߂Zbg
ENCR363
		SMS	R1,CEATFLG	;H׃tOZbg
;
		LDW	(R7)
		SEX
		BPL	ENCR364		;_[WH ( no:ENCR364 )
		SUB	R0		;[ IBT R0,#0 ]
;
		INC	R0		;[ IBT R0,#1 ] OjtOZbg
		SMS	R0,CBERO_GUNYA
		IBT	R0,#BERO_BIRI_P ;rrtOZbg
		SMS	R0,CBERO_BIRI
;
		IBT	R0,#03CH	;[]
		SMS	R0,CMSOUND3
;
		STOP
		NOP
;
ENCR364
		SMS	R3,CEATOFX
		SMS	R4,CEATOFY
;
		IBT	R0,#CEEATM	;Hׂꃂ[hZbg
		STW	(R5)
		INC	R7		;to ENMOD1+1 !!
		INC	R7
		LDW	(R7)
		ADD	R0		;(C) set
		BCS	ENCR370		; eat stop ? [ no:EBCR370 ]
		ADD	R0		;[ ASL ]
;
		ADD	R0		;[ ASL ]
		IWT	R2,#8000H
		AND	R2
		OR	R1
		SMS	R0,CEATSTP
;
		LDW	(R8)		;[ LD ENMOD2,X ] ͈͊ONA[ɁII
		BIC	#00001100B	;[ AND #0FFF3H ]
		SBK			;[ ST ENMOD2,X ]
;
		SWAP			;[ AND #0000000010000000B ]
		BMI	ENCR366		;ɓĂEFCgH ( yes:ENCR366 )
		SUB	R0
;
		IWT	R0,#20*60	;ݍ݃EFCg^C}[Zbg
ENCR366
		SMS	R0,CEAT_WAIT
ENCR370
		STOP
		NOP
;
;********************************************************************************
;*		player oam set							*
;*			r1  <- x position					*
;*			r2  <- y position					*
;*			r3  <- muki						*
;*			r12 <- obj suu						*
;*			r14 <- data address					*
;********************************************************************************
;--------------------------------------------------------------------------------
;-	use register								-
;-		r0,r1,r2,r3,r4,r5,r6,r7,r8,r9,r10,r11,r12,r13,r14		-
;--------------------------------------------------------------------------------
;
PLAYOAM		EQU	$
;
;------------------------------------------------------------------------
;-		vC[n`lZbg					-
;------------------------------------------------------------------------
		IBT	R0,#4CH
		ROMB
;
		MOVE	R14,R14
;
		LMS	R4,CPLPRIO	;(R4) <-- player BG pri.
;
		LMS	R5,CPLOAML	; oam address
		IBT	R0,#12*8
		TO	R5
		ADD	R5
;
		IWT	R9,#CPCHNO0
;
		IBT	R7,#00		; chara No. initial
;
		CACHE
;
		MOVE	R13,R15
PLOM000
		TO	R6
		GETB			; atoribute data read
		INC	R14
		FROM	R6
		LSR
		LSR
		LSR
		LSR
		TO	R11
		AND	#2		; r11 <- size
;
		GETB			; x position read
		INC	R14
		SEX
		IBT	R8,#000H
		DEC	R3
		BPL	PLOM020		; h-flip ? [ no:PLOM020 ]
		INC	R3
;
		NOT
		INC	R0
		IBT	R8,#040H
		DEC	R11
		BPL	PLOM020		; big-size ? [ yes:PLOM020 ]
		INC	R11
;
		ADD	#08
PLOM020
		ADD	R1
		STW	(R5)		; x position set
		INC	R5
		INC	R5
;
		GETB
		INC	R14
		SEX
		ADD	R2
		STW	(R5)		; y position set
		INC	R5
		INC	R5
;
		IWT	R0,#000C0H
		AND	R6
		XOR	R8
		OR	R4		; priority set
		LMS	R10,CPLCLOR
		OR	R10		; colour set
		SWAP
		OR	R7		; chara No. set
		INC	R7
		INC	R7
		STW	(R5)		; chara No. & atoribute set
		INC	R5
		INC	R5
;
		FROM	R11
		STW	(R5)		; oamsub & etc_data set
		INC	R5
		INC	R5
;
		FROM	R6
		AND	#0FH
		SWAP
		GETBL			; chara address low read
		INC	R14
;
		WITH	R11
		AND	#2
		BEQ	PLOM040		; small size ? [ yes:PLOM040 ]
		NOP
;
		IWT	R10,#090H
		CMP	R10
		BCS	PLOM040		; eat stop chara ? [ no:PLOM040 ]
		NOP
;
		LMS	R10,CEATSTP
		LMS	R11,CEATFLG
		WITH	R10
		OR	R11
		BNE	PLOM040		; now eat stop ? [ yes:PLOM040 ]
		NOP
;
		IWT	R10,#00100H
		ADD	R10
PLOM040
		IWT	R10,#007FFH
		AND	R10
		WITH	R6
		AND	#08H		;(Z) <-- chara change player ?
		IBT	R6,#052H	;[ vC[]pLN^[f[^oN ]
		BEQ	PLOM050		;chara change player ? ( no:PLOM050 )
		NOP
;
		IWT	R6,#(WOB7CHR+800H)/20H
		ADD	R6
		IBT	R6,#BANK WOB7CHR
PLOM050
		ADD	R0
		ADD	R0
		ADD	R0
		ADD	R0
		ADD	R0
		STW	(R9)		; chara address set
		INC	R9
		INC	R9
;
		TO	R10
		HIB
		FROM	R6
		STB	(R9)		; chara bank set
		INC	R9
		FROM	R10
		ADD	#02
		STB	(R9)		; set
		LOOP
		INC	R9
;
;-------------- ^Cvʂn`lZbg ------------------------------------
;-		r3  <- muki						-
;-		r4  <- priority						-
;-		r5  <- oam address					-
;------------------------------------------------------------------------
		LMS	R0,CPLTYPE	;[JSRSUB]
		ADD	R0		;   "
		INC	R0		;   "
		TO	R15		;   "
		ADD	R15		;   "
		HEX	FF		;   "
		mTWORD	YOSSY_OAM	;ʂ̃bV[
		mTWORD	CAR_OAM		;N}
		mTWORD	MOGURA_OAM	;O
		mTWORD	HERI_OAM	;wRv^[
		mTWORD	TRAIN_OAM	;D
		mTWORD	KINOKO_OAM	;LmR
		mTWORD	SUBMARIN_OAM	;
;;;;		    mTWORD  BAKUDAN_OAM	    ;΂񂭂
		mTWORD	SKI_OAM		;XL[
		mTWORD	MARIO_OAM	;}I
		mTWORD	EGG_OAM		;^}S
;
;----------------------------------------------------------------
;-	x̂n`lZbg					-
;-		in :						-
;-			R3 <- vC[̌			-
;-			R4 <- D揇				-
;----------------------------------------------------------------
YOSSY_OAM
		IWT	R0,#BANK YOSSYBERDTA0
		ROMB
;
		LMS	R0,CBERO_GUNYA
		IWT	R14,#BERO_PATN
		TO	R14
		ADD	R14
		TO	R10			;(R10) <-- xp^[
		GETB
;
		LMS	R5,CPLOAML
		WITH	R4
		SWAP
;
		LMS	R11,CBERFLG
		DEC	R11
		BMI	YOSSY_OAM00F0		; xZbgH [no->YOSSY_OAM00F0]
		NOP
;
		FROM	R11
		SUB	#07
		BCS	YOSSY_OAM00F0		; xZbgH [no->YOSSY_OAM00F0]
		NOP
;
		LMS	R0,CBERYPS
		SUB	#00
		BPL	YOSSY_OAM0080		; {H [yes->YOSSY_OAM0080]
		NOP
;
		NOT
		INC	R0
YOSSY_OAM0080
		LSR
		LSR
		TO	R7
		LSR
;
		LMS	R0,CBERXPS
		SUB	#00
		BPL	YOSSY_OAM0088		; {H [yes->YOSSY_OAM0088]
		NOP
;
		NOT
		INC	R0
YOSSY_OAM0088
		LSR
		LSR
		TO	R6
		LSR
		FROM	R6
		OR	R7
		BNE	YOSSY_OAM0100		; xZbgH [yes->YOSSY_OAM0100]
		NOP
;
YOSSY_OAM00F0
		STOP
		NOP
;
YOSSY_OAM0100
		LMS	R1,CBRDSXL		; w|WVII
		LMS	R2,CBRDSYL		; x|WVII
;
		FROM	R11
		LSR
		BEQ	YOSSY_OAM0120		; H [yes->YOSSY_OAM0120]
		NOP
;
		IWT	R15,#YOSSY_OAM1000	; [->YOSSY_OAM1000]
		NOP
;
YOSSY_OAM0120
		IBT	R9,#008H
		IBT	R8,#00
		MOVE	R7,#00
		DEC	R3
		BPL	YOSSY_OAM0130		; [->YOSSY_OAM0130]
		INC	R3
;
		IBT	R7,#08
		IBT	R9,#0F8H
		IWT	R8,#04000H
YOSSY_OAM0130
		FROM	R1
		ADD	R7
		STW	(R5)			; w|WVII
		INC	R5
		INC	R5
		FROM	R2
		STW	(R5)			; x|WVII
		INC	R5
		INC	R5
		IWT	R0,#00A20H
		OR	R4
		OR	R8
		STW	(R5)			; LN^Agr[gII
		INC	R5
		INC	R5
		SUB	R0
		STW	(R5)			; n`lrtaII
		INC	R5
		INC	R5
YOSSY_OAM0140
;
		CACHE
;
		IWT	R0,#YOSSYBERDTA0
		TO	R14
		ADD	R10
		GETB
		INC	R14
		GETBH
		MOVE	R14,R0
;
		DEC	R6
		BEQ	YOSSY_OAM01F0		; IH [yes->YOSSY_OAM01F0]
		NOP
;
		MOVE	R12,R6
		MOVE	R13,R15
;
		WITH	R1
		ADD	R9
;
		FROM	R1
		ADD	R7
		STW	(R5)			; w|WVII
		INC	R5
		INC	R5
		GETBS
		INC	R14
		ADD	R2
		STW	(R5)			; x|WVII
		INC	R5
		INC	R5
		GETB
		INC	R14
		GETBH
		INC	R14
		OR	R4
		XOR	R8
		STW	(R5)			; LN^Agr[gII
		INC	R5
		INC	R5
		SUB	R0
		STW	(R5)			; n`lrtaII
		INC	R5
;
		LOOP
		INC	R5
;
YOSSY_OAM01F0
		STOP
		NOP
;
YOSSY_OAM1000
		MOVE	R6,R7
		IBT	R8,#00
		IBT	R7,#08
		DEC	R3
		BPL	YOSSY_OAM1030		; [->YOSSY_OAM1030]
		INC	R3
;
		IBT	R7,#00
		IWT	R8,#04000H
YOSSY_OAM1030
		FROM	R1
		ADD	R7
		STW	(R5)			; w|WVII
		INC	R5
		INC	R5
		FROM	R2
		STW	(R5)			; x|WVII
		INC	R5
		INC	R5
		IWT	R0,#00A22H
		OR	R4
		OR	R8
		STW	(R5)			; LN^Agr[gII
		INC	R5
		INC	R5
		SUB	R0
		STW	(R5)			; n`lrtaII
		INC	R5
		INC	R5
;
YOSSY_OAM1040
;
		CACHE
;
		IWT	R0,#YOSSYBERDTA1
		TO	R14
		ADD	R10
		GETB
		INC	R14
		GETBH
		MOVE	R14,R0
;
		DEC	R6
		BEQ	YOSSY_OAM10F0		; IH [yes->YOSSY_OAM10F0]
		NOP
;
		MOVE	R12,R6
		MOVE	R13,R15
;
		WITH	R2
		ADD	#08
;
		GETBS
		INC	R14
		DEC	R3
		BPL	YOSSY_OAM1080		; [->YOSSY_OAM1080]
		INC	R3
;
		NOT
		INC	R0
YOSSY_OAM1080
		ADD	R1
		ADD	R7
		STW	(R5)			; w|WVII
		INC	R5
		INC	R5
		FROM	R2
		STW	(R5)			; x|WVII
		INC	R5
		INC	R5
		GETB
		INC	R14
		GETBH
		INC	R14
		OR	R4
		XOR	R8
		STW	(R5)			; LN^Agr[gII
		INC	R5
		INC	R5
		SUB	R0
		STW	(R5)			; n`lrtaII
		INC	R5
;
		LOOP
		INC	R5
;
YOSSY_OAM10F0
		STOP
		NOP
;
;
BERO_PATN	EQU	$
; BERO_GUNYA -->
		HEX	0
		HEX	2,2,2
BERO_PATN_BIRI	EQU	$
		HEX	4,4,4
		HEX	6,6,6
BERO_PATN_RETN	EQU	$
		HEX	4,4,4
		HEX	2,2,2
BERO_PATN_END	EQU	$
BERO_P_BIRI	EQU	BERO_PATN_BIRI-BERO_PATN
BERO_P_RETN	EQU	BERO_PATN_RETN-BERO_PATN
BERO_P_END	EQU	BERO_PATN_END-BERO_PATN
;
YOSSYBERDTA0	EQU	$
		WORD	YOSSYBERDT00
		WORD	YOSSYBERDT01
		WORD	YOSSYBERDT02
		WORD	YOSSYBERDT03
;
YOSSYBERDT00	EQU	$
		HEX	00, 21, 0A, 00, 21, 0A
		HEX	00, 21, 0A, 00, 21, 0A
		HEX	00, 21, 0A, 00, 21, 0A
		HEX	00, 21, 0A, 00, 21, 0A
;
YOSSYBERDT01	EQU	$
		HEX	00, 30, 0A, FF, 30, 8A
		HEX	00, 30, 0A, FF, 30, 8A
		HEX	00, 30, 0A, FF, 30, 8A
		HEX	00, 30, 0A, FF, 30, 8A
;
YOSSYBERDT02	EQU	$
		HEX	00, 31, 0A, FF, 31, 8A
		HEX	00, 31, 0A, FF, 31, 8A
		HEX	00, 31, 0A, FF, 31, 8A
		HEX	00, 31, 0A, FF, 31, 8A
;
YOSSYBERDT03	EQU	$
		HEX	00, 31, 8A, 01, 31, 0A
		HEX	00, 31, 8A, 01, 31, 0A
		HEX	00, 31, 8A, 01, 31, 0A
		HEX	00, 31, 8A, 01, 31, 0A
;
YOSSYBERDTA1	EQU	$
		WORD	YOSSYBERDT10
		WORD	YOSSYBERDT11
		WORD	YOSSYBERDT12
		WORD	YOSSYBERDT13
;
YOSSYBERDT10	EQU	$
		HEX	00, 32, 0A, 00, 32, 0A
		HEX	00, 32, 0A, 00, 32, 0A
		HEX	00, 32, 0A, 00, 32, 0A
		HEX	00, 32, 0A, 00, 32, 0A
;
YOSSYBERDT11	EQU	$
		HEX	FF, 23, 0A, 00, 23, 4A
		HEX	FF, 23, 0A, 00, 23, 4A
		HEX	FF, 23, 0A, 00, 23, 4A
		HEX	FF, 23, 0A, 00, 23, 4A
;
YOSSYBERDT12	EQU	$
		HEX	FF, 33, 0A, 00, 33, 4A
		HEX	FF, 33, 0A, 00, 33, 4A
		HEX	FF, 33, 0A, 00, 33, 4A
		HEX	FF, 33, 0A, 00, 33, 4A
;
YOSSYBERDT13	EQU	$
		HEX	00, 33, 4A, FF, 33, 0A
		HEX	00, 33, 4A, FF, 33, 0A
		HEX	00, 33, 4A, FF, 33, 0A
		HEX	00, 33, 4A, FF, 33, 0A
;
;
;------------------------------------------------------------------------
;-		N}^Cn`lZbg				-
;-			in :						-
;-				(R3) <-- vC[			-
;-				(R4) <-- afD揇ʃtO		-
;-				(R5) <-- n`lZbg̃CfbNX	-
;------------------------------------------------------------------------
CAR_OAM
		LMS	R0,CPLFTLN
		LOB
		BNE	CAR_OAM0100
		NOP

		STOP
		NOP
;
;-------------< ]IuWF] >-----------------
CAR_OAM0100
		LMS	R6,CPLOAML
		IBT	R0,#12*8
		TO	R5
		ADD	R6
		IBT	R0,#2*8
		WITH	R6
		ADD	R0

		IWT	R2,#08000H
		IBT	R12,#004
		CACHE
		MOVE	R13,R15

		LDW	(R5)
		FROM	R2
		SBK
		STW	(R6)
		INC	R5
		INC	R5
		INC	R6
		INC	R6
		LDW	(R5)
		STW	(R6)
		INC	R5
		INC	R5
		INC	R6
		INC	R6
		LDW	(R5)
		STW	(R6)
		INC	R5
		INC	R5
		INC	R6
		INC	R6
		LDW	(R5)
		STW	(R6)
		INC	R5
		INC	R5
		INC	R6

		LOOP
		INC	R6
;
;-------------< ]LNA >------------------
		FROM	R2
		STW	(R5)
		WITH	R5
		ADD	#04
		LDW	(R5)
		WITH	R5
		ADD	#04
		FROM	R2
		STW	(R5)
;
;-------------< ^CZbg >------------------
		IWT	R9,#001FFH
		BIC	R9
		IBT	R9,#008H	;^C̃LmD
		TO	R9		;(R9) <-- LmD`ss
		OR	R9
;
		LMS	R0,CPLCMKI
		ADD	R0
		ADD	R0
		TO	R14
		SUB	#04
;
		IWT	R1,#CPLLFTX
		IWT	R2,#CPLLFTY
		LMS	R3,CESCCH1
		LMS	R4,CESCCV1
		IBT	R5,#010H
		LMS	R0,CPLFTLN
		SUB	R5
		LMS	R5,CPLYPSL
		ADD	R5
		LMS	R5,CPLYPSV
		SUB	R5
		TO	R4
		SUB	R4
;
		LMS	R5,CPLOAML
		IBT	R0,#6*8
		TO	R6
		ADD	R5
;
		IWT	R10,#04002H

		IBT	R12,#02
		CACHE
		MOVE	R13,R15

		LDW	(R1)		;X POS.
		SUB	#08
		SUB	R3
		STW	(R5)
		SUB	R14
		STW	(R6)
		INC	R5
		INC	R5
		INC	R6
		INC	R6

		LDW	(R2)		;Y POS.
		ADD	R4
		STW	(R5)
		STW	(R6)
		INC	R5
		INC	R5
		INC	R6
		INC	R6

		FROM	R9		;CHR. NO.  &  ATTR.
		STW	(R5)
		FROM	R9		;CHR. NO.  &  ATTR.
		STW	(R6)
		INC	R5
		INC	R5
		INC	R6
		INC	R6

		FROM	R10	;(R5) <- #0002H
		LOB
		STW	(R5)
		FROM	R10	;(R6) <- #4002H
		STW	(R6)
		INC	R5
		INC	R5
		INC	R6

		WITH	R1
		ADD	#04
		WITH	R2
		ADD	#04

		LOOP
		INC	R6
;
;-------------< Zbg >------------------
		LMS	R11,CPLFTLN
		WITH	R11
		SUB	#008H
		BPL	CAR_OAM0700	;o? ( yes:CAR_OAM0700 )
		NOP

		STOP
		NOP
;
CAR_OAM0700
		IBT	R7,#01FH
		FROM	R9
		BIC	R7
		TO	R9		;(R9) <-- LmD`ss
		OR	#00AH
;
		WITH	R10
		BIC	#02
;
		LMS	R0,CPLCMKI
		DEC	R0
		WITH	R3
		ADD	R0
;
		MOVE	R5,R6
		IBT	R0,#6*8
		WITH	R6
		ADD	R0
;
		WITH	R4
		ADD	#04		;8-4	iZbg̃X^[gʒuj
		WITH	R4
;
CAR_OAM0900
		SUB	#08

		IWT	R1,#CPLLFTX
		IWT	R2,#CPLLFTY
;
		IBT	R12,#02
		MOVE	R13,R15

		LDW	(R1)		;X POS.
		SUB	#04		;
		SUB	R3
		STW	(R5)
		SUB	R14
		STW	(R6)
		INC	R5
		INC	R5
		INC	R6
		INC	R6

		LDW	(R2)		;Y POS.
		ADD	R4
		STW	(R5)
		STW	(R6)
		INC	R5
		INC	R5
		INC	R6
		INC	R6

		MOVE	R0,R9
		STW	(R5)		;CHR. NO.  &  ATTR.
		STW	(R6)		;CHR. NO.  &  ATTR.
		INC	R5
		INC	R5
		INC	R6
		INC	R6

		SUB	R0	;(R5) <- #0000H
		STW	(R5)
		FROM	R10	;(R6) <- #4000H
		STW	(R6)
		INC	R5
		INC	R5
		INC	R6

		WITH	R1
		ADD	#04
		WITH	R2
		ADD	#04

		LOOP
		INC	R6

		WITH	R11
		SUB	#08
		FROM	R11
		SUB	#1
		BPL	CAR_OAM0900	;ZbgI? ( no:CAR_OAM0900 )
		WITH	R4

		STOP
		NOP
;
;
;;;;;------------------------------------------------------------------------
;;;;;-		    ΂񂭂n`lZbg				    -
;;;;;-			    in :					    -
;;;;;-				    (R3) <-- vC[		    -
;;;;;-				    (R4) <-- afD揇ʃtO		    -
;;;;;-				    (R5) <-- n`lZbg̃CfbNX   -
;;;;;------------------------------------------------------------------------
;;;;BAK_OAMSET_OPS  EQU	    $
;;;;		    HEX	    F0,F0
;;;;		    HEX	    D0,F0
;;;;		    HEX	    F0,D0
;;;;		    HEX	    D0,D0
;;;;;
;;;;BAKUDAN_OAM
;;;;		    IBT	    R0,#BANK BAK_OAMSET_OPS
;;;;		    ROMB
;;;;
;;;;		    LMS	    R0,CPLBANG
;;;;		    SUB	    #08
;;;;		    BEQ	    BAK_OAM0100	    ;΂͂n`lZbg? ( yes:BAK_OAM0100 )
;;;;		    NOP
;;;;
;;;;		    STOP
;;;;		    NOP
;;;;
;;;;BAK_OAM0100
;;;;		    LM	    R6,CPLOAML	    ; oam address
;;;;		    IWT	    R0,#12*8
;;;;		    TO	    R5
;;;;		    ADD	    R6
;;;;		    IBT	    R0,#08*4
;;;;		    TO	    R7
;;;;		    ADD	    R6
;;;;		    TO	    R8
;;;;		    ADD	    R7
;;;;
;;;;		    IWT	    R11,#08000H
;;;;		    IWT	    R4,#04000H
;;;;		    IWT	    R14,#BAK_OAMSET_OPS
;;;;
;;;;		    IBT	    R2,#002
;;;;		    IBT	    R12,#004
;;;;		    CACHE
;;;;		    MOVE    R13,R15
;;;;
;;;;		    TO	    R9
;;;;		    GETBS
;;;;		    MOVES   R3,R3
;;;;		    BNE	    BAK_OAM0500	    ;h flip? ( no:BAK_OAM0500 )
;;;;		    INC	    R14
;;;;
;;;;		    WITH    R9
;;;;		    NOT
;;;;		    INC	    R9
;;;;
;;;;BAK_OAM0500
;;;;		    TO	    R10
;;;;		    GETBS
;;;;		    INC	    R14
;;;;
;;;;		    LDW	    (R5)	    ;X pos. set
;;;;		    STW	    (R6)
;;;;		    ADD	    R9
;;;;		    STW	    (R7)
;;;;		    STW	    (R8)
;;;;		    WITH    R5
;;;;		    ADD	    R2
;;;;		    WITH    R6
;;;;		    ADD	    R2
;;;;		    WITH    R7
;;;;		    ADD	    R2
;;;;		    WITH    R8
;;;;		    ADD	    R2
;;;;
;;;;		    LDW	    (R5)	    ;Y pos. set
;;;;		    STW	    (R8)
;;;;		    ADD	    R10
;;;;		    STW	    (R6)
;;;;		    STW	    (R7)
;;;;		    WITH    R5
;;;;		    ADD	    R2
;;;;		    WITH    R6
;;;;		    ADD	    R2
;;;;		    WITH    R7
;;;;		    ADD	    R2
;;;;		    WITH    R8
;;;;		    ADD	    R2
;;;;
;;;;		    LDW	    (R5)	    ;Char. no. / Attr. set
;;;;		    OR	    R11
;;;;		    STW	    (R6)
;;;;		    XOR	    R4
;;;;		    STW	    (R7)
;;;;		    XOR	    R11
;;;;		    STW	    (R8)
;;;;		    WITH    R5
;;;;		    ADD	    R2
;;;;		    WITH    R6
;;;;		    ADD	    R2
;;;;		    WITH    R7
;;;;		    ADD	    R2
;;;;		    WITH    R8
;;;;		    ADD	    R2
;;;;
;;;;		    LDW	    (R5)	    ;
;;;;		    STW	    (R6)
;;;;		    STW	    (R7)
;;;;		    STW	    (R8)
;;;;		    WITH    R5
;;;;		    ADD	    R2
;;;;		    WITH    R6
;;;;		    ADD	    R2
;;;;		    WITH    R7
;;;;		    ADD	    R2
;;;;		    INC	    R8
;;;;
;;;;		    LOOP
;;;;		    INC	    R8
;;;;
;;;;		    STOP
;;;;		    NOP
;
;------------------------------------------------------------------------
;-		On`lZbg					-
;-			in :						-
;-				(R3) <-- vC[			-
;-				(R4) <-- afD揇ʃtO		-
;-				(R5) <-- n`lZbg̃CfbNX	-
;------------------------------------------------------------------------
MOGURA_OAM
		LMS	R0,CPLPATN
		IWT	R1,#Mg02
		SUB	R1
		BEQ	MOGURA_OAM_0100 ;~܂ĂH ( yes:MOGURA_OAM_0100 )
		ADD	R1
;
		IBT	R0,#BANK LCOS	;bnrf[^AhXiajZbg
		ROMB
;
		LMS	R0,CPMG_ANGL	;(R0) <-- LN^[]px
		HIB
		IWT	R14,#LCOS
		TO	R14		;(R14) <-- bnrf[^AhXikCgjZbg
		ADD	R14
		TO	R6		;(R6) <-- bnrf[^
		GETBS
;
		IWT	R1,#-03H*100H*4 ;(R1) <-- ̎蔼a~POOg~S
		FROM	R1
		TO	R8		;(R8) <-- ̎wW␳l
		FMULT
;
		IWT	R2,#-09H*100H*4 ;(R2) <-- O̎蔼a~POOg~S
		FROM	R2
		TO	R10		;(R10) <-- O̎wW␳l
		FMULT
;
		MOVES	R3,R3
		BNE	MOGURA_OAM_0050 ;vC[EH ( yes:MOGURA_OAM_0050 )
		WITH	R8
;
		NOT
		INC	R8
		WITH	R10
		NOT
		INC	R10
MOGURA_OAM_0050
		IBT	R0,#040H
		TO	R14		;(R14) <-- rhmf[^AhXikCgjZbg
		ADD	R14
		TO	R6		;(R6) <-- rhmf[^
		GETBS
;
		FROM	R1
		TO	R7		;(R7) <-- ̎xW␳l
		FMULT
;
		FROM	R2
		TO	R9		;(R9) <-- O̎xW␳l
		FMULT
;
		LMS	R5,CPLOAML	; oam address
		IBT	R0,#12*8
		TO	R5		;(R5) <-- n`lZbg|C^[
		ADD	R5
;
		LDW	(R5)
		ADD	R8
		SBK			;[ STW (R5) ]
		INC	R5
		INC	R5
;
		LDW	(R5)
		ADD	R7
		SBK			;[ STW (R5) ]
;
		IBT	R0,#(5*8)-2
		TO	R5
		ADD	R5
;
		LDW	(R5)
		ADD	R10
		SBK			;[ STW (R5) ]
		INC	R5
		INC	R5
;
		LDW	(R5)
		ADD	R9
		SBK			;[ STW (R5) ]
;
MOGURA_OAM_0100
		STOP
		NOP
;
;------------------------------------------------------------------------
;-		wRv^[n`lZbg				-
;-			in :						-
;-				(R3) <-- vC[			-
;-				(R4) <-- afD揇ʃtO		-
;-				(R5) <-- n`lZbg̃CfbNX	-
;------------------------------------------------------------------------
HERI_OAM
		STOP
		NOP
;
;------------------------------------------------------------------------
;-		DԂn`lZbg					-
;-			in :						-
;-				(R3) <-- vC[			-
;-				(R4) <-- afD揇ʃtO		-
;-				(R5) <-- n`lZbg̃CfbNX	-
;------------------------------------------------------------------------
TRAIN_OAM
		LMS	R0,CPLPATN
		IWT	R1,#TR00
		SUB	R1
		BNE	TRAIN_OAM_0150	;[[hp^[H ( yes:TRAIN_OAM_0150 )
		NOP
;
		IBT	R0,#BANK LCOS	;bnrf[^AhXiajZbg
		ROMB
;
		LMS	R0,CPTR_ANGL	;(R0) <-- LN^[]px
		HIB
		MOVE	R6,R0
		IBT	R7,#040H
		ADD	R7
		SEX
		BPL	TRAIN_OAM_0010
		NOP
;
		IBT	R0,#7FH
		XOR	R6
		INC	R0
		TO	R6
		LOB
TRAIN_OAM_0010
		IWT	R0,#LCOS
		TO	R14		;(R14) <-- bnrf[^AhXikCgjZbg
		ADD	R6
		GETBS
;
		IWT	R6,#-04H*100H*4 ;(R6) <-- a~POOg~S
		TO	R7		;(R7) <-- xW␳l
		FMULT
;
		IBT	R0,#040H
		TO	R14		;(R14) <-- rhmf[^AhXikCgjZbg
		ADD	R14
		GETBS
;
		TO	R8		;(R8) <-- wW␳l
		FMULT
		MOVES	R3,R3
		BEQ	TRAIN_OAM_0050	;vC[EH ( no:TRAIN_OAM_0050 )
		WITH	R8
;
		NOT
		INC	R8
TRAIN_OAM_0050
		LMS	R5,CPLOAML	; oam address
		IBT	R0,#12*8
		TO	R5		;(R5) <-- n`lZbg|C^[
		ADD	R5
		IBT	R6,#8-2		;n`lZbg|C^[Zl
;
		CACHE
;
		IBT	R12,#4
		MOVE	R13,R15
TRAIN_OAM_0100
		LDW	(R5)
		ADD	R8
		SBK			;[ STW (R5) ]
		INC	R5
		INC	R5
;
		LDW	(R5)
		ADD	R7
;
		WITH	R5
		ADD	R6
;
		LOOP
		SBK			;[ STW (R5) ]
;
TRAIN_OAM_0150
		STOP
		NOP
;
;------------------------------------------------------------------------
;-		LmRn`lZbg					-
;-			in :						-
;-				(R3) <-- vC[			-
;-				(R4) <-- afD揇ʃtO		-
;-				(R5) <-- n`lZbg̃CfbNX	-
;------------------------------------------------------------------------
KINOKO_OAM
		STOP
		NOP
;
;------------------------------------------------------------------------
;-		͂n`lZbg					-
;-			in :						-
;-				(R3) <-- vC[			-
;-				(R4) <-- afD揇ʃtO		-
;-				(R5) <-- n`lZbg̃CfbNX	-
;------------------------------------------------------------------------
SUBMARIN_OAM
		STOP
		NOP
;
;------------------------------------------------------------------------
;-		XL[n`lZbg					-
;-		^}Sn`lZbg					-
;-			in :						-
;-				(R3) <-- vC[			-
;-				(R4) <-- afD揇ʃtO		-
;-				(R5) <-- n`lZbg̃CfbNX	-
;------------------------------------------------------------------------
SKI_OAM
EGG_OAM
		STOP
		NOP
;
;------------------------------------------------------------------------
;-		}In`lZbg					-
;-			in :						-
;-				(R3) <-- vC[			-
;-				(R4) <-- afD揇ʃtO		-
;-				(R5) <-- n`lZbg̃CfbNX	-
;------------------------------------------------------------------------
MARIO_OAM
		IBT	R0,#BANK LCOS	;bnrf[^AhXiajZbg
		ROMB
;
		LMS	R0,CPLPATN
		IWT	R14,#MR0E
		SUB	R14
		BEQ	MARIO_OAM_0500	;zoOH ( yes:MARIO_OAM_0500 )
		NOP
;
		LMS	R0,CPMR_BGCF
		DEC	R0
		BMI	MARIO_OAM_0150	;\jbN[hH ( no:MARIO_OAM_0150 )
		NOP
;
;-------------- n]W␳ ------------------------------------
		LMS	R0,CPMR_ANGL	;(R0) <-- LN^[]px
		IWT	R14,#LCOS
		TO	R14		;(R14) <-- bnrf[^AhXikCgjZbg
		ADD	R14
		GETBS
;
		IWT	R6,#-0CH*100H*4 ;(R6) <-- a~POOg~S
		FMULT
		IBT	R7,#0EH
		TO	R7		;(R7) <-- xW␳l
		ADD	R7
;
MARIO_OAM_0010
		IBT	R0,#040H
		TO	R14		;(R14) <-- rhmf[^AhXikCgjZbg
		ADD	R14
		GETBS
;
		TO	R8		;(R8) <-- wW␳l
		FMULT
		MOVES	R3,R3
		BEQ	MARIO_OAM_0050	;vC[EH ( no:MARIO_OAM_0050 )
		WITH	R8
;
		NOT
		INC	R8
MARIO_OAM_0050
		LMS	R5,CPLOAML	; oam address
		IBT	R0,#12*8
		TO	R5		;(R5) <-- n`lZbg|C^[
		ADD	R5
		IBT	R6,#8-2		;n`lZbg|C^[Zl
;
		CACHE
;
		IBT	R12,#4
		MOVE	R13,R15
MARIO_OAM_0100
		LDW	(R5)
		ADD	R8
		SBK			;[ STW (R5) ]
		INC	R5
		INC	R5
;
		LDW	(R5)
		ADD	R7
;
		WITH	R5
		ADD	R6
;
		LOOP
		SBK			;[ STW (R5) ]
;
MARIO_OAM_0150
		STOP
		NOP
;
;-------------- zoO]W␳ ----------------------------------
MARIO_OAM_0500
		LMS	R0,CPMR_ANGL	;(R0) <-- LN^[]px
		IWT	R14,#LCOS
		TO	R14		;(R14) <-- bnrf[^AhXikCgjZbg
		ADD	R14
		GETBS
;
		IWT	R6,#0CH*100H*4	;(R6) <-- a~POOg~S
		FMULT
		IBT	R7,#0AH
		TO	R7		;(R7) <-- xW␳l
		BRA	MARIO_OAM_0010
		SUB	R7
;
;************************************************************************
;*		enemy pos calculate					*
;************************************************************************
;
;=============== X Y MOVE ===============================================
XYMOVE		EQU	$
		IBT	R0,#BANK LCOS
		ROMB
;
		IWT	R1,#CEXXSPD		;SPEED
		IWT	R2,#CEXMOVX		;move dot
		IWT	R3,#CEXXSDR-1		;KEISAN X
		IWT	R9,#CEXYSDR-1		;KEISAN Y
		IWT	R7,#CEXMODE		;MODE & SLOP & ADD_XSP
		IWT	R8,#CEXXMAX		;X,Y SPEED MAX
		IWT	R10,#CEXXPOW		;G KEISAN
		IWT	R5,#CEXWATR		;tO
;
		CACHE
;
		IBT	R12,#CENNO+CEXNO	;LOOP N
		MOVE	R13,R15			;LOOP ADDR
;
XYMOVE00
		LDB	(R7)
		INC	R7		;go to EXSLOP
		INC	R7
;;;;		    SUB	    #CENOK
		SUB	#CEFALL
		BCS	XYMOVE10		;MODE MOVE OK ?
		TO	R6		;(R6) <-- X speed
;
		IBT	R0,#4
		TO	R1
		ADD	R1
		TO	R2
		ADD	R2
		TO	R3
		ADD	R3
		TO	R9
		ADD	R9
		TO	R8
		ADD	R8
		TO	R5
		ADD	R5
		TO	R10
		ADD	R10
		mDJMP_X XYMOVE60+1
		INC	R7
;						;Y
;-------------- X power set -------------------------------------
XYMOVE10
;;;;		    TO	    R6		    ;(R6) <-- X speed
		LDW	(R1)
;
		LDW	(R7)
		MOVE	R4,R0
		HIB
		MULT	#8
		TO	R11		;(R11) <-- w
		ADD	R0
;
		FROM	R4
		LOB
;;;;		    SBK			    ;[ STW (R7) ] w̓NA[
		IWT	R14,#LSIN
		TO	R14
		ADD	R14
;
		LDW	(R8)
		SUB	R6
		BPL	XYMOVE20
		LDW	(R10)
;
		NOT
		INC	R0
XYMOVE20
		ADD	R6
		STW	(R1)		;X power set !!
;
		ADD	R11
		ADD	R0
		TO	R6
		ADD	R0
;
;-------------- X pos move --------------------------------------
		GETB			;(R0) <-- sin data
		IBT	R4,#040H
		WITH	R14		;(R14) <-- LCOS address
		SUB	R4
;
		SWAP			;[ 4000H <- 40H ]
		TO	R11		;(R11) <-- ␳xXs[h
		FMULT
;
		GETB			;(R0) <-- cos data
		SWAP			;[ 4000H <- 40H ]
		TO	R6		;(R6) <-- ␳wXs[h
		FMULT
;
		IWT	R14,#0100H	;(R14) <-- Xs[h{
		LDW	(R5)
		DEC	R0
		SWAP
		BMI	XYMOVE22	;H ( no:XYMOVE22 )
		SWAP
;
		INC	R0
		TO	R14
		HIB
		INC	R14
XYMOVE22
		FROM	R14
		LMULT
		WITH	R4
		HIB
		LOB
		SWAP
		OR	R4
		MOVE	R6,R0
		BEQ	XYMOVE30	; pos move ?
		LOB
;
		TO	R4
		SWAP
		LDW	(R3)
		ADD	R4
		SBK
		FROM	R6
		HIB
		SEX
		ADC	#00
XYMOVE30
		STW	(R2)		;move dot set
		INC	R3		;go to EXXPSL
		INC	R3
		TO	R6
		LDW	(R3)
		ADD	R6
		SBK
;
;-------------- G power set -------------------------------------
		INC	R1		;go to EXYSPD
		INC	R1
		INC	R2		;go to EXMOVY
		INC	R2
		INC	R8		;go to EXGMAX
		INC	R8
		INC	R10		;go to EXGPOW
		INC	R10
;
		LDW	(R8)
		TO	R6
		LDW	(R1)
		SUB	R6
		BPL	XYMOVE40
		LDW	(R10)
;
		NOT
		INC	R0
XYMOVE40
		ADD	R6
		STW	(R1)		;d̓Zbg
;
		TO	R6
		ADD	R11		;␳xXs[hZ
;
;-------------- Y pos move --------------------------------------
		FROM	R14		;Xs[h{vZ
		LMULT
		WITH	R4
		HIB
		LOB
		SWAP
		OR	R4
		MOVE	R6,R0
		BEQ	XYMOVE50	; pos move ?
		LOB
;
		TO	R4
		SWAP
		LDW	(R9)
		ADD	R4
		SBK
		FROM	R6
		HIB
		SEX
		ADC	#00
XYMOVE50
		STW	(R2)		;move dot set
		INC	R9		;go to EXYPSL
		INC	R9
		TO	R6
		LDW	(R9)
		ADD	R6
		SBK
;
		INC	R1			;NEXT SPEED
		INC	R1
		INC	R2			;NEXT move dot
		INC	R2
		INC	R8			;NEXT G MAX
		INC	R8
		INC	R3			;NEXT KEISAN X
		INC	R3
		INC	R9			;NEXT KEISAN Y
		INC	R9
		INC	R10			;G KEISAN
		INC	R10
		WITH	R5			;NEXT tO
		ADD	#4
XYMOVE60
		INC	R7			;NEXT MODE
		LOOP
		INC	R7
;
		STOP
		NOP
;
;************************************************************************
;*		enemy arae over check					*
;*			in :						*
;*				(R3) <-- Pv|OtO			*
;************************************************************************
GAMENCHK	EQU	$
GAMENCHK_DM	EQU	$
;
;------------------------------------------------------------------------
;-		vC[w\ʒu`FbN			-
;------------------------------------------------------------------------
		LMS	R0,CPLMODE
		LM	R1,CSP_SCRL_FG
		OR	R1
		BEQ	PL_XDSCK_0010	;`FbNnjH ( yes:PL_XDSCK_0010 )
		NOP
;
		mDJMP	PL_XDSCK_0150
;
PL_XDSCK_0010
		LMS	R0,CPLXPSL
		LMS	R1,CESCCH1	;(R1) <-- XN[JE^[g
		SUB	R1		;(R0) <-- vC[\wW
;
		IBT	R2,#001100000B	;(R2) <-- ܂`FbNf[^
		IBT	R4,#LEFT_X
		TO	R6		;(R6) <-- H݃TCY
		SUB	R4
		BMI	PL_XDSCK_0050	;[I[o[H ( yes:PL_XDSCK_0050 )
		NOP
;
		IWT	R2,#110000000B	;(R2) <-- ܂`FbNf[^
		IWT	R4,#RIGHT_X
		TO	R6		;(R6) <-- H݃TCY
		SUB	R4
		DEC	R6		;[ BEQ ]
		BMI	PL_XDSCK_0150	;E[I[o[H ( no:PL_XDSCK_0150 )
		INC	R6
;
;-------------- Pv|O`FbN ----------------------------------------
		MOVES	R3,R3
		BEQ	PL_XDSCK_0050	;Pv|OH ( no:PL_XDSCK_0050 )
		NOP
;
		IWT	R4,#0F8H
		SUB	R4
		BMI	PL_XDSCK_0150	;Pv|PցH ( no:PL_XDSCK_0150 )
		NOP
;
		mSFCALL GOTO_W1_1
		BRA	PL_XDSCK_0150
		NOP
;
PL_XDSCK_0050
		LM	R5,CSCRL_XSPD	;(R5) <-- XN[wXs[h
		FROM	R6
		XOR	R5
		BPL	PL_XDSCK_0060	;܂ꂽH ( no:PL_XDSCK_0060 )
		NOP
;
		LMS	R0,CPLBGCR
		AND	R2
		BEQ	PL_XDSCK_0060	;܂ꂽH ( no:PL_XDSCK_0060 )
		NOP
;
		MOVES	R0,R6
		BPL	PL_XDSCK_0052
		NOP
;
		NOT
		INC	R0
PL_XDSCK_0052
		SUB	#0FH
		BCC	PL_XDSCK_0150	;܂ꂽH ( no:PL_XDSCK_0150 )
		NOP
;
;-------------- ܂ꂽII --------------------------------------------
		mSFCALL PLDOWNST	;vC[_EZbg
		BRA	PL_XDSCK_0150
		NOP
;
PL_XDSCK_0060
		LMS	R7,CPLXSPD
		FROM	R7
		SUB	R5
		XOR	R7
		BMI	PL_XDSCK_0100	;wXs[hNA[njH ( no:PL_XDSCK_0100 )
		NOP
;
		FROM	R5
		SBK			;[ SMS R0,CPLXSPD ]
		SMS	R5,CPLMVSP
		LM	R0,CSCRL_XSDR
		SMS	R0,CPLXSDR
;
PL_XDSCK_0100
		FROM	R6
		ADD	#4
		BMI	PL_XDSCK_0110	;␳őlI[o[H ( yes:PL_XDSCK_0110 )
		NOP
;
		SUB	#4+4
		BCC	PL_XDSCK_0120	;␳őlI[o[H ( no:PL_XDSCK_0120 )
		NOP
;
PL_XDSCK_0110
		NOT
		INC	R0
		TO	R6
		ADD	R6
PL_XDSCK_0120
		LMS	R0,CPLXPSL
		SUB	R6
		SBK			;[ SMS R0,CPLXPSL ]
;
;-------------- vC[ɏĂĜwW␳ ----------------------
		LM	R5,CNOSEIDX
		MOVES	R5,R5
		BMI	PL_XDSCK_0150	;vC[ɏĂGH ( no:PL_XDSCK_0150 )
		NOP
;
		mLDW0	CENXPSL,R5
		SUB	R6
		SBK			;[ mSTW R0,CENXPSL,R5 ]
;
PL_XDSCK_0150
;
;------------------------------------------------------------------------
;-		Gn`lZbg						-
;------------------------------------------------------------------------
		IBT		R0,#BANK ENCLEAR_SIZE	;ROM BANK SET
		ROMB
;
		IWT		R1,#CEXDORE
		IWT		R2,#CEXXPSL
		IWT		R3,#CEXYPSL
		IWT		R4,#CEXDSXL
		IWT		R6,#CEXMODE
		IWT		R9,#CEXMOD2
		IWT		R10,#CEXRETN
;
		CACHE
;
		IBT		R12,#CENNO+CEXNO
		MOVE		R13,R15
GAMEN00
		LDB		(R6)
		DEC		R0
		BPL		GAMEN02			;enemy "ON" ? ( yes:GAMEN02 )
		NOP
;
		INC		R4
		IWT		R15,#GAMEN20
		INC		R4
;
GAMEN02
		LDB		(R1)
;
		IWT		R7,#CESCCH1		;SCCV GET
		TO		R7
		ADD		R7
		TO		R7
		LDW		(R7)
		IWT		R8,#CESCCV1		;SCCH GET
		ADD		R8
		TO		R8
		LDW		(R0)
;
		LDW		(R2)			;X POS SET
		SUB		R7
		STW		(R4)
		MOVE		R7,R0
;
		LDW		(R3)			;Y POS SET
		SUB		R8
		INC		R4			;go to CEXDSYL !!
		INC		R4
		STW		(R4)
		MOVE		R8,R0
;
		LDW		(R9)
		AND		#0CH
		BEQ		GAMEN20
		NOP
;
		IWT		R14,#ENCLEAR_SIZE-4
		TO		R14
		ADD		R14			;(R14) <-- area check size data address
;
		GETB
		INC		R14
		IWT		R11,#0F0H
		GETBH
		INC		R14
		TO		R5
		ADD		R7
		ADD		R0		;x2
		ADD		R11
		SUB		R5
		BCC		GAMEN80			;X pos area over ? ( yes:GAMEN80 )
		SUB		R0			;[ IBT R0,#00 ]
;
		GETB
		INC		R14
		IWT		R11,#0C8H
		GETBH
		TO		R5
		ADD		R8
		ADD		R0		;x2
		ADD		R11
		SUB		R5
		BCS		GAMEN20			;Y pos area over ? ( no:GAMEN20 )
		SUB		R0			;[ IBT R0,#00 ]
;
GAMEN80
		STW		(R6)			;enemy "OFF" !!
		DEC		R0
		INC		R1			;go to CEXYUSN !!
		STB		(R1)			;not OAM set !!
		DEC		R1
;
		IBT		R0,#(CENNO+CEXNO)-CEXNO
		SUB		R12
		ADD		R0		;x4
		TO		R8		;
		ADD		R0		;
;
;-------------- transfer OBJ aria use check -----------------------------
		IBT		R0,#CEXNO*4
		ADD		R8
		IWT		R8,#CEXTROB
		ADD		R8
		LDW		(R0)
		SUB		#0
		BMI		GAMEN12			;transfer OBJ aria use ? ( no:GAMEN12 )
		NOP

		IWT		R8,#CTROBJ_SIZE
		ADD		R8
		LDW		(R0)
		NOT
		LM		R8,CTROBJ_ARIA
		AND		R8
		SBK
;
GAMEN12
		LDB		(R10)
		IWT		R8,#EDSWBF
		TO		R8
		ADD		R8
		SUB		R0
		STB		(R8)			;enemy data return !!

		LM		R0,CPONLFFG
		SUB		R12
		BNE		GAMEN20
		NOP

		SM		R0,CPONLFFG
;
GAMEN20
		IBT		R0,#004H
		TO		R2
		ADD		R2
		TO		R3
		ADD		R3
		TO		R6
		ADD		R6
		TO		R9
		ADD		R9
		TO		R10
		ADD		R10
		TO		R1
		ADD		R1
		INC		R4
;
		LOOP
		INC		R4
;
;************************************************************************
;*		enemy OAM set						*
;************************************************************************
;							;OAM SET
OAMSET		EQU		$
		IBT		R0,#BANK ENOBJ_DATA	;ROM BANK SET
		ROMB
;
		IBT		R11,#000H
		IWT		R13,#OAMSET20		;LOOP ADDR
		IWT		R1,#CEXYUSN		;YUSEN
		IWT		R2,#CEXMOD2		;CHAR PT
;
		CACHE
OAMSET10
		IBT		R12,#CENNO+CEXNO
		IBT		R10,#000H
OAMSET20
		FROM		R1			;YUSEN CHK.
		ADD		R10
		LDW		(R0)
		SUB		R11
		BEQ		OAMSET21		;OAM SET OK ?
		NOP
;							;N
		IWT		R15,#OAMSET30+1 ;[ JMP OAMSET30+1 ]
		INC		R10
;
OAMSET21
		IWT		R0,#CEXCHPT
		ADD		R10
		LDW		(R0)
		MOVE		R9,R0		;(R9) <-- pattern no.
		HIB
		BEQ		OAMSET26	;Y[naiH ( no:OAMSET26 )
		DEC		R0
;
;-------------- Y[nai OAM set ------------------------
		BNE		OAMSET24	;2x2 size ? ( no:OAMSET24 )
		TO		R9
;
		SUB		R0		;(R9)	<-- p^[mD
		SMS		R9,CWORK0	;(CWK0) <-- LN^[oN
		IWT		R14,#ESPTRCAD	;(R14)	<-- Y[naif[^|C^[
		BRA		OAMSET_1_S+1
		GETB
;
OAMSET24
		SUB		R0		;(R9)	<-- p^[mD
		SMS		R9,CWORK0	;(CWK0) <-- LN^[oN
		SMS		R12,REG12
		IBT		R12,#4		;(R12) <-- naigp
		IWT		R14,#ESPTRCAD+4 ;(R14) <-- Y[naif[^|C^[
		IWT		R15,#OAMSET_2_S+1
		HEX		3E		;[ SMS R1,REG1 ]
;
OAMSET26
		IWT		R0,#CEXCHRB
		ADD		R10
		LDB		(R0)
		MULT		#8
		SMS		R0,CWORK0	;(CWK0) <-- LN^[oN
;
		FROM		R2		;CHPT CHK.
		ADD		R10
		LDW		(R0)		;OAM set type load
		AND		#03H
		MULT		#003H
		INC		R0
		TO		R15
		ADD		R15
		BYTE		0FFH
;
		WORD		OAMSET_1		;1 CHAR SET
		HEX		F0			;[ IWT R0,#CEXSTNO ]
		WORD		OAMSET_2		;SUPER OAMEMU SET
		HEX		3E			;[ SMS R1,REG1 ]
		WORD		OAMSET_3		;NOT SET
		HEX		F0			;[ IWT R0,#CEXMOD2+1 ]
		WORD		OAMSET_4		;NOT SET
		HEX		3E			;[ SMS R1,REG1 ]
;
OAMSET30
		INC		R10			;NEXT TEKI INDEX
		INC		R10
		INC		R10
		LOOP
		INC		R10
;
		INC		R11
		LMS		R0,CPLYUSN		;(R0) <-- player OAM pri.
		SUB		R11
		BEQ		OAMSET40
		FROM		R11
;
		SUB		#008H
		BCS		OAMSET_RTS		;OAM SET END ?
		NOP
;
		IWT		R15,#OAMSET10+1
		HEX		AC			;[ IBT R12,#CENNO+CEXNO ]
;
OAMSET_RTS
;;;;		    SUB		    R0			    ;<<< end >>>
		STOP
		NOP
;
OAMSET40
		LMS		R8,COAMIDX
		IWT		R0,#020*8
		ADD		R8
		SBK					;[ SMS R0,COAMIDX ] COAMIDX + 20*8
		SMS		R8,CPLOAML		;OAMIDX --> PLOAML
;
		IWT		R15,#OAMSET10+1
		HEX		AC			;[ IBT R12,#CENNO+CEXNO ]
;
;------------------------------------------------------------------------
OAMSET_1
		WORD		CEXSTNO			;[ IWT R0,#CEXSTNO ]
;
		ADD		R10
		LDW		(R0)
		ADD		R0			;EXMY NO * 2
		IWT		R14,#ENOBJ_DATA
		TO		R14
		ADD		R14
OAMSET_1_S
		GETB
		INC		R14
;
		IWT		R6,#CEXCLOR		;ATR SET
		WITH		R6
		ADD		R10
		TO		R6
		LDW		(R6)
;
		GETBH
		ADD		R9
		TO		R14
		ADD		R9
;
		IWT		R0,#CEXMUKI
		ADD		R10
		LDB		(R0)
		ADD		R0
		ADD		R0
		MULT		#008H
		XOR		R6
		TO		R6
		SWAP
;
		WITH		R6
		GETBL
		INC		R14
;
		IWT		R0,#CEXEMU0		;DATA SET
		ADD		R10
		LDB		(R0)
		TO		R7
		SWAP
;
		GETB
		MOVE		R4,R0
		IWT		R9,#11110001B
		AND		R9
		SWAP
		TO		R6
		XOR		R6
;
		IBT		R9,#0			;X Y POS ADD CLR
;
		FROM		R4
		AND		#002H
		BNE		OMET_110		;big size ? ( yes:OMET_110 )
		NOP
;
		IBT		R9,#004H		;X Y POS ADD
OMET_110
		TO		R7			;SB SET
		XOR		R7
;
		IWT		R0,#CEXDSXL		;X POS
		TO		R8
		ADD		R10
		LDW		(R8)
		TO		R4
		ADD		R9
;
		INC		R8			;Y POS
		INC		R8
		LDW		(R8)
		TO		R5
		ADD		R9
;
		LMS		R8,COAMIDX		;OAMIDX --> ENOAML
		IWT		R0,#CEXOAML
		ADD		R10
		FROM		R8
		STW		(R0)
;
		FROM		R4			;X SET
		STW		(R8)
		INC		R8
		INC		R8
		FROM		R5			;Y SET
		STW		(R8)
		INC		R8
		INC		R8
		LMS		R0,CWORK0		;(R0) <-- LN^[oN
		ADD		R6
		STW		(R8)			;ATR SET
		INC		R8
		INC		R8
		FROM		R7
		STW		(R8)
		INC		R8
		INC		R8
;
		SMS		R8,COAMIDX
;
		IWT		R15,#OAMSET30+1
		INC		R10			;[ next ]
;
;------------------------------------------------------------------------
OAMSET_2
		BYTE		0ACH,(REG12/2)		;[ SMS R12,REG1 ]
;
		IWT		R0,#CEXSTNO		;EXMY NO * 2
		ADD		R10
		LDW		(R0)
		ADD		R0
		IWT		R14,#ESPCAD
		TO		R14
		ADD		R14
;
		IWT		R0,#CEXMOD2+1		;(EXMOD0 & 1F) * 8
		ADD		R10
		LDB		(R0)
		IWT		R8,#01FH*8
		AND		R8
OAMSET_2_SS
		LSR				;1/8
		LSR
		LSR
		MOVE		R12,R0			;OBJ KAZU
;
		TO		R8			;ADDR L GET
		GETB
		INC		R14
;
		UMULT		#5			;number of OBJ * 5
		UMULT		R9			;(EXMOD0 & 1F) * 5 * EXCHPT
;
		WITH		R8			;ADDR H GET
		GETBH
		TO		R14
		ADD		R8
;
OAMSET_2_S
		SMS		R1,REG1
		SMS		R2,REG2
		SMS		R10,REG10
		SMS		R13,REG13
		IWT		R0,#OAMSET30
		SMS		R0,RTS0		;(RTS0) <-- return address set
;
		IWT		R0,#CEXCLOR		;ATR SET
		ADD		R10
		TO		R3
		LDB		(R0)
		IWT		R0,#CEXMUKI
		ADD		R10
		LDB		(R0)
		ADD		R0
		ADD		R0
		MULT		#008H
		XOR		R3
		TO		R3
		SWAP
;
		LMS		R4,COAMIDX		;OAMIDX --> ENOAML
		IWT		R0,#CEXOAML
		ADD		R10
		FROM		R4
		STW		(R0)
;
		IWT		R0,#CEXEMU0		;DATA SET
		ADD		R10
		LDB		(R0)
		TO		R13
		SWAP
;
EMUOAMST
		IBT		R0,#(CEXNO-1)*4
		SUB		R10
		BCS		OMET_2FF	;GH ( no:OMET_2FF )
		SUB		R0		;[ IBT R0,#1111111111111111B+1 ]
;
		IWT		R0,#CENCOLD-CEXNO*4
		ADD		R10
		LDW		(R0)
		DEC		R0
		BMI		OMET_2FF	;ĂH ( no:OMET_2FF )
		SUB		R0		;[ IBT R0,#1111111111111111B+1 ]
;
		IWT		R0,#1111000111111111B+1
OMET_2FF
		DEC		R0
		SMS		R0,REG7
;
		IWT		R0,#CEXDSXL		;X POS
		ADD		R10
		TO		R1
		LDW		(R0)
;
		INC		R0
		INC		R0
		TO		R2			;Y POS
		LDW		(R0)
;
		MOVE		R10,R13
		MOVE		R13,R15		; loop address set
;
OMET_200
		GETBS
		INC		R14
;
		IWT		R9,#4000H	;H flip check data
		WITH		R9
		AND		R3
		BEQ		OMET_210	;H frip ? [ no:OMET_210 ]
		NOP				;[ * (Z)=1: IBT R9,#0 ]
;
		NOT
		INC		R0
		IBT		R9,#008H
OMET_210
		TO		R5
		ADD		R1		; r5 <- x position
;
		GETBS
		INC		R14
;
		IBT		R8,#00H		;V flip check data
		MOVES		R3,R3
		BPL		OMET_220	;V frip ? [ no:OMET_220 ]
		NOP
;
		NOT
		INC		R0
		IBT		R8,#008H
OMET_220
		TO		R6
		ADD		R2		; r6 <- y position
;
		GETB
		INC		R14
;
		LMS		R7,REG7
;
		GETBH
		INC		R14
;
		AND		R7
		TO		R7
		XOR		R3		; R7 <- atoribute & chara No.
;
		GETB				; oamsb
		AND		#02H
		BNE		OMET_230
		NOP
;
		WITH		R5
		ADD		R9
		WITH		R6
		ADD		R8
OMET_230
		GETBH				;(R0) <-- sub,data
		INC		R14
;
		FROM		R5
		STW		(R4)		; x position
		INC		R4
		INC		R4
;
		TO		R5		; r5 <- sub,data
		XOR		R10
;
		FROM		R6
		STW		(R4)		; y position
		INC		R4
		INC		R4
		LMS		R0,CWORK0	;(R0) <-- LN^[oN
		ADD		R7
		STW		(R4)		; chara No., atoribute
		INC		R4
		INC		R4
		FROM		R5
		STW		(R4)		; oamsb,data
		INC		R4
;
		LOOP
		INC		R4
;
		SMS		R4,COAMIDX
;
		LMS		R1,REG1
		LMS		R2,REG2
		LMS		R10,REG10
		LMS		R12,REG12
		LMS		R13,REG13
;
		LMS		R15,RTS0	;return !!
		NOP
;
;------------------------------------------------------------------------
OAMSET_3
		WORD		CEXMOD2+1		;[ IWT R0,#CEXMOD2+1 ] OAM KAZU
;
		ADD		R10
		LDW		(R0)
		IWT		R7,#01FH*08H
		AND		R7
;
		LMS		R8,COAMIDX
		ADD		R8			;OAMIDX NEXT
		SBK					;[ SMS R0,COAMIDX ]
;
		IWT		R0,#CEXOAML
		ADD		R10
		FROM		R8
		STW		(R0)			;OAMIDX --> ENOAML
;
		IWT		R15,#OAMSET30+1		;[ JMP OAMSET30+1 ]
		INC		R10			;[ next ]
;
;------------------------------------------------------------------------
;-		ʊO`FbNTCYf[^				-
;------------------------------------------------------------------------
ENCLEAR_SIZE	EQU		$
;			     [X size] [Y size]
		WORD		0060H,0060H ;[1]
		WORD		0090H,0060H ;[2]
		WORD		0090H,00A0H ;[3] for BG3
;
;------------------------------------------------------------------------
OAMSET_4
		BYTE		0ACH,(REG12/2)		;[ SMS R12,REG1 ]
;
		IWT		R0,#CEXSTNO		;EXMY NO * 2
		ADD		R10
		LDW		(R0)
		ADD		R0
		IWT		R14,#ESPCAD
		TO		R14
		ADD		R14
;
		IWT		R0,#CEXMOD2+1		;(EXMOD0 & 1F) * 8
		ADD		R10
		LDB		(R0)
		IWT		R8,#01FH*8
		AND		R8
		IWT		R8,#020H*8
		mDJMP_X		OAMSET_2_SS
		ADD		R8
;
;************************************************************************
;*		G ʂn`lZbg					*
;*			in :						*
;*				(R10) <-- G̃CfbNX		*
;*				(R0)  <-- n`lZbgf[^AhX	*
;*				(R14) <--	      h		*
;************************************************************************
;
ENOAMSET_SP	EQU		$
		ROMB
;
		IWT		R0,#CEXOAML
		ADD		R10
		LDW		(R0)
		MOVES		R4,R0
		BPL		ENOAMSET_SP_000 ;n`lmہH ( yes:ENOAMSET_SP_000 )
		NOP
;
		STOP
		NOP
;
ENOAMSET_SP_000
		IWT		R0,#CEXCHPT		;p^[mD
		ADD		R10
		LDB		(R0)
		ADD		R0
		TO		R14
		ADD		R14
;
		GETB
		INC		R14
		TO		R14			;(R14) <-- Zbgp^[n`lZbgf[^AhX
		GETBH
;
		IWT		R0,#CEXCLOR		;ATR SET
		ADD		R10
		TO		R3
		LDB		(R0)
		IWT		R0,#CEXMUKI
		ADD		R10
		LDB		(R0)
		ADD		R0
		ADD		R0
		MULT		#008H
		XOR		R3
		TO		R3
		SWAP
;
		IWT		R0,#CEXDSXL		;X POS
		ADD		R10
		TO		R1
		LDW		(R0)
;
		INC		R0
		INC		R0
		TO		R2			;Y POS
		LDW		(R0)
;
		IWT		R0,#CEXCHRB
		ADD		R10
		LDB		(R0)
		MULT		#8
		SMS		R0,CWORK		;LN^[oN
;
		IWT		R0,#CEXMOD2+1		;(EXMOD0 & 1F) * 8
		ADD		R10
		LDW		(R0)
		IWT		R8,#01FH*8
		AND		R8
		LSR				;1/8
		LSR
		TO		R12			;n`lgp
		LSR
;
		IWT		R0,#CEXEMU0		;DATA SET
		ADD		R10
		LDB		(R0)
		TO		R10
		SWAP
;
		CACHE
;
		MOVE		R13,R15		; loop address set
ENOAMSET_SP_010
		GETBS
		INC		R14
;
		IWT		R9,#4000H	;H flip check data
		WITH		R9
		AND		R3
		BEQ		ENOAMSET_SP_020 ;H frip ? [ no:ENOAMSET_SP_020 ]
		NOP				;[ * (Z)=1: IBT R9,#0 ]
;
		NOT
		INC		R0
		IBT		R9,#008H
ENOAMSET_SP_020
		TO		R5
		ADD		R1		; r5 <- x position
;
		GETBS
		INC		R14
;
		IBT		R8,#00H		;V flip check data
		MOVES		R3,R3
		BPL		ENOAMSET_SP_030 ;V frip ? [ no:ENOAMSET_SP_030 ]
		NOP
;
		NOT
		INC		R0
		IBT		R8,#008H
ENOAMSET_SP_030
		TO		R6
		ADD		R2		; r6 <- y position
;
		GETB
		INC		R14
		GETBH
		INC		R14
;
		TO		R7
		XOR		R3		; R7 <- atoribute & chara No.
;
		GETB				; oamsb
		AND		#02H
		BNE		ENOAMSET_SP_040
		NOP
;
		WITH		R5
		ADD		R9
		WITH		R6
		ADD		R8
ENOAMSET_SP_040
		GETBH				;(R0) <-- sub,data
		INC		R14
;
		FROM		R5
		STW		(R4)		; x position
		INC		R4
		INC		R4
;
		TO		R5		; r5 <- sub,data
		XOR		R10
;
		FROM		R6
		STW		(R4)		; y position
		INC		R4
		INC		R4
		LMS		R0,CWORK0	;(R0) <-- LN^[oN
		ADD		R7
		STW		(R4)		; chara No., atoribute
		INC		R4
		INC		R4
		FROM		R5
		STW		(R4)		; oamsb,data
		INC		R4
;
		LOOP
		INC		R4
;
		STOP
		NOP
;
;************************************************************************
;*		enemy search						*
;*			in  : (CWK0) <-- my enemy index			*
;*			out : (CWK0) <-- search enemy index		*
;*					( < 0 : not search )		*
;*			      (CWK1) <-- search enemy X wide		*
;*			      (CWK2) <--	"     Y  "		*
;************************************************************************
;
ENSRCH		EQU	$
		IBT	R12,#CENNO
		LMS	R2,CWORK0
		FROM	R2
		LSR
		LSR
		FROM	R12
		TO	R1		;(R1) <-- (my enemy index)/4+1
		SUB	R0
;
		IWT	R4,#CECENTX	;(R4) <-- enemy center pos index
		FROM	R2
		ADD	R4
		TO	R2		;(R2) <-- my enemy center X pos
		LDW	(R0)
		ADD	#2
		TO	R3		;(R3) <-- my enemy center Y pos
		LDW	(R0)
;
		IWT	R5,#CENMODE	;(R5)	<-- enemy mode index
		IBT	R6,#CEMOVE	;(R6)	<--   "   move no.
		IWT	R7,#CENMOD1	;(R7)	<--   "   cross ok flag index
		IWT	R8,#0110000000000000B ;(R8)   <--	    "       AND data
		IBT	R9,#0FFH	;[ IWT R9,#0FFFFH ] (R9)   <--	     "      wide
		SMS	R9,CWORK0	;(CWK0) <-- search enemy index
;
		CACHE
;
		IWT	R13,#ESR010+1
ESR010
		FROM	R1
		SUB	R12
		BEQ	ESR050		;my index ? ( yes:ESR050 )
		NOP
;
		LDB	(R5)
		SUB	R6
		BNE	ESR050		;enemy cross check ok ? ( no:ESR050 )
		NOP
;
		LDW	(R7)
		AND	R8
		BNE	ESR050		;		"
		NOP
;
		LDW	(R4)
		SUB	R2
		MOVE	R11,R0		;(R11) <-- X wide
		BPL	ESR020
		NOP
;
		NOT
		INC	R0
ESR020
		MOVE	R10,R0		;(R10) <-- ABS( X wide )
		FROM	R4
		ADD	#2
		LDW	(R0)
		SUB	R3
		MOVE	R14,R0		;(R14) <-- Y wide
		BPL	ESR030
		NOP
;
		NOT
		INC	R0
ESR030
		ADD	R10
		SUB	R9
		BCS	ESR050		;search enemy change ? ( no:ESR050 )
		ADD	R9
;
		MOVE	R9,R0		;(R9)	<--	  "      wide
		SMS	R12,CWORK0	;(CWK0) <-- search enemy index
		SMS	R11,CWORK1	;(CWK1) <--	  "      X wide
		SMS	R14,CWORK2	;(CWK2) <--	  "      Y  "
;
ESR050
		IBT	R0,#4
		TO	R5
		ADD	R5
		TO	R7
		ADD	R7
		TO	R4
		ADD	R4
		LOOP
		FROM	R1
;
		LMS	R1,CWORK0	;((search enemy index)-1)*4
		INC	R1
		BEQ	ESR060		;enemy not search ? ( yes:ESR060 )
		DEC	R1
;
		IBT	R0,#CENNO
		SUB	R1
		ADD	R0
		ADD	R0
		SMS	R0,CWORK0	;(CWK0) <-- search enemy index
ESR060
		STOP
		NOP
;
;************************************************************************
;*		item search						*
;*			in  : (R1) <-- my index				*
;*			out : (R1) <-- search index ( <0:not search )	*				*
;************************************************************************
;
M_ITEM_SEARCH	EQU	$
		IWT	R2,#CENMODE	;(R2) <-- enemy mode pointer
		IWT	R3,#CECENTX	;(R3) <--   "   center X pos pointer
		IWT	R4,#CECENTY	;(R4) <--	"      Y     "
		IWT	R5,#CENMOD1	;(R5) <-- item check data pointer
;
		FROM	R3
		ADD	R1
		TO	R6		;(R6) <-- my center X pos
		LDW	(R0)
		FROM	R4
		ADD	R1
		TO	R7		;(R7) <-- my center Y pos
		LDW	(R0)
		IBT	R8,#0FFH	;(R8) <-- initial min wide
		MOVE	R9,R8		;(R9) <--	 "         enemy index
		IWT	R11,#0110000000000000B
;
		FROM	R1
		LSR
		LSR
		IBT	R12,#CENNO
		FROM	R12
		TO	R1		;(R1) <-- EOR 1/4 index
		SUB	R0
;
		CACHE
;
		MOVE	R13,R15
ITSR010
		FROM	R12
		SUB	R1
		BEQ	ITSR050		;my index ? ( yes:ITSR050 )
		NOP
;
		LDB	(R2)
		SUB	#CEFAIL
		BCC	ITSR050		; enmy on ? [ no:ITSR050 ]
		NOP
;
		LDW	(R5)
		AND	R11
		SUB	R11
		BNE	ITSR050		;item ? ( no:ITSR050 )
		NOP
;
		LDW	(R3)
		SUB	R6
		BPL	ITSR020
		NOP
;
		NOT
		INC	R0
ITSR020
		MOVE	R10,R0		;(R10) <-- X pos wide
		LDW	(R4)
		SUB	R7
		BPL	ITSR030
		NOP
;
		NOT
		INC	R0
ITSR030
		ADD	R10
		SUB	R8
		BCS	ITSR050		;new min wide ? ( no:IRSR050 )
		ADD	R8
;
		MOVE	R8,R0		;(R8) <-- new min wide
		MOVE	R9,R12		;(R9) <--      "       enemy index
ITSR050
		IBT	R0,#04H
		TO	R2
		ADD	R2
		TO	R3
		ADD	R3
		TO	R4
		ADD	R4
		TO	R5
		ADD	R5
;
		LOOP
		FROM	R12		;[ dummy ]
;
		MOVES	R1,R9
		BMI	ITSR060		;not search ? ( yes:ITSR060 )
		NOP
;
		IBT	R0,#CENNO
		SUB	R9
		ADD	R0
		TO	R1
		ADD	R0
ITSR060
		STOP
		NOP
;
;************************************************************************
;*		"HACHI" search						*
;*			in  : (R1) <-- my index				*
;*			out : (R1) <-- search index ( <0:not search )	*
;************************************************************************
;
HACHI_SEARCH	EQU	$
		IWT	R14,#HACHI	;(R14) <-- "HACHI" no.

		IWT	R2,#CENMODE	;(R2) <-- enemy mode pointer
		IWT	R3,#CECENTX	;(R3) <--   "   center X pos pointer
		IWT	R4,#CECENTY	;(R4) <--	"      Y     "
		IWT	R5,#CENMYNO	;(R5) <-- enemy kinds
		IWT	R11,#CENWRK8	;(R11) <-- nose flag
;
		FROM	R3
		ADD	R1
		TO	R6		;(R6) <-- my center X pos
		LDW	(R0)
		FROM	R4
		ADD	R1
		TO	R7		;(R7) <-- my center Y pos
		LDW	(R0)
		IBT	R8,#0FFH	;(R8) <-- initial min wide
		MOVE	R9,R8		;(R9) <--	 "         enemy index
;
		FROM	R1
		LSR
		LSR
		IBT	R12,#CENNO
		FROM	R12
		TO	R1		;(R1) <-- EOR 1/4 index
		SUB	R0
;
		CACHE
;
		MOVE	R13,R15
HSR010
		FROM	R12
		SUB	R1
		BEQ	HSR050		;my index ? ( yes:HSR050 )
		NOP
;
		LDB	(R2)
		SUB	#CEEATM
		BEQ	HSR018
		NOP
;
		SUB	#CEFAIL-CEEATM+1
		BMI	HSR050		; enmy on ? [ no:HSR050 ]
		NOP
;
HSR018
		LDW	(R5)
		CMP	R14
		BNE	HSR050		;hachi ? ( no:HSR050 )
		NOP
;
		LDB	(R11)
		MOVES	R0,R0
		BNE	HSR050		;nose flag = 0 ? ( no:HSR050 )
		NOP
;
		LDW	(R3)
		SUB	R6
		BPL	HSR020
		NOP
;
		NOT
		INC	R0
HSR020
		MOVE	R10,R0		;(R10) <-- X pos wide
		LDW	(R4)
		SUB	R7
		BPL	HSR030
		NOP
;
		NOT
		INC	R0
HSR030
		ADD	R10
		SUB	R8
		BCS	HSR050		;new min wide ? ( no:HSR050 )
		ADD	R8
;
		MOVE	R8,R0		;(R8) <-- new min wide
		MOVE	R9,R12		;(R9) <--      "       enemy index
HSR050
		IBT	R0,#04H
		TO	R2
		ADD	R2
		TO	R3
		ADD	R3
		TO	R4
		ADD	R4
		TO	R5
		ADD	R5
		TO	R11
		ADD	R11
;
		LOOP
		FROM	R12		;[ dummy ]
;
		MOVES	R1,R9
		BMI	HSR060		;not search ? ( yes:HSR060 )
		NOP
;
		IBT	R0,#CENNO
		SUB	R9
		ADD	R0
		TO	R1
		ADD	R0
HSR060
		STOP
		NOP
;
;************************************************************************
;*		TARGET search						*
;*			in  : (R1) <-- my index				*
;*			      (R14)<-- TARGET low enemy no.		*
;*			      (R11)<-- TARGET high enemy no. +1		*
;*			out : (R1) <-- search index ( <0:not search )	*
;************************************************************************
TARGET_SEARCH	EQU	$
		MOVE	R11,R14
		INC	R11

TARGET_SEARCH2	EQU	$
		IWT	R2,#CENMODE	;(R2) <-- enemy mode pointer
		IWT	R3,#CECENTX	;(R3) <--   "   center X pos pointer
		IWT	R4,#CECENTY	;(R4) <--	"      Y     "
		IWT	R5,#CENMYNO	;(R5) <-- enemy kinds
;
		FROM	R3
		ADD	R1
		TO	R6		;(R6) <-- my center X pos
		LDW	(R0)
		FROM	R4
		ADD	R1
		TO	R7		;(R7) <-- my center Y pos
		LDW	(R0)
		IBT	R8,#0FFH	;(R8) <-- initial min wide
		MOVE	R9,R8		;(R9) <--	 "         enemy index
;
		FROM	R1
		LSR
		LSR
		IBT	R12,#CENNO
		FROM	R12
		TO	R1		;(R1) <-- EOR 1/4 index
		SUB	R0
;
		CACHE
;
		MOVE	R13,R15
TSR010
		FROM	R12
		SUB	R1
		BEQ	TSR050		;my index ? ( yes:TSR050 )
		NOP
;
		LDB	(R2)
		SUB	#CEEATM
		BEQ	TSR018
		NOP
;
		SUB	#CEFAIL-CEEATM+1
		BMI	TSR050		; enmy on ? [ no:TSR050 ]
		NOP
;
TSR018
		LDW	(R5)
		CMP	R14
		BMI	TSR050		;hachi ? ( no:TSR050 )
		NOP
;
		CMP	R11
		BPL	TSR050
		NOP
;
		LDW	(R3)
		SUB	R6
		BPL	TSR020
		NOP
;
		NOT
		INC	R0
TSR020
		MOVE	R10,R0		;(R10) <-- X pos wide
		LDW	(R4)
		SUB	R7
		BPL	TSR030
		NOP
;
		NOT
		INC	R0
TSR030
		ADD	R10
		SUB	R8
		BCS	TSR050		;new min wide ? ( no:TSR050 )
		ADD	R8
;
		MOVE	R8,R0		;(R8) <-- new min wide
		MOVE	R9,R12		;(R9) <--      "       enemy index
TSR050
		IBT	R0,#04H
		TO	R2
		ADD	R2
		TO	R3
		ADD	R3
		TO	R4
		ADD	R4
		TO	R5
		ADD	R5
;
		LOOP
		FROM	R12		;[ dummy ]
;
		MOVES	R1,R9
		BMI	TSR060		;not search ? ( yes:TSR060 )
		NOP
;
		IBT	R0,#CENNO
		SUB	R9
		ADD	R0
		TO	R1
		ADD	R0
TSR060
		STOP
		NOP
;
;************************************************************************
;*		shot enemy search					*
;*			in  : (R1) <-- my index				*
;*			out : (R1) <-- search index ( <0:not search )	*				*
;************************************************************************
;
SHOTENSR	EQU	$
		IWT	R2,#CENMODE	;(R2) <-- enemy mode pointer
		IWT	R3,#CECENTX	;(R3) <--   "   center X pos pointer
		IWT	R4,#CECENTY	;(R4) <--	"      Y     "
		IWT	R5,#CENSHOT	;(R5) <-- shot enemy flag pointer
;
		FROM	R3
		ADD	R1
		TO	R6		;(R6) <-- my center X pos
		LDW	(R0)
		FROM	R4
		ADD	R1
		TO	R7		;(R7) <-- my center Y pos
		LDW	(R0)
		IBT	R8,#0FFH	;(R8) <-- initial min wide
		MOVE	R9,R8		;(R9) <--	 "         enemy index
;
		FROM	R1
		LSR
		LSR
		IBT	R12,#CENNO
		FROM	R12
		TO	R1		;(R1) <-- EOR 1/4 index
		SUB	R0
;
		CACHE
;
		DEC	R12		;[-1]
		MOVE	R13,R15
SHTESR010
		IBT	R0,#04H
		TO	R2
		ADD	R2
		TO	R3
		ADD	R3
		TO	R4
		ADD	R4
		TO	R5
		ADD	R5
;
		FROM	R12
		SUB	R1
		BEQ	SHTESR050	;my index ? ( yes:SHTESR050 )
		NOP
;
		LDB	(R2)
		SUB	#CEFAIL
		BCC	SHTESR050	; enmy on ? [ no:SHTESR050 ]
		NOP
;
		LDW	(R5)
		SUB	#0
		BEQ	SHTESR050	;shot enemy ? ( no:SHTESR050 )
		NOP
;
		LDW	(R3)
		SUB	R6
		BPL	SHTESR020
		NOP
;
		NOT
		INC	R0
SHTESR020
		MOVE	R10,R0		;(R10) <-- X pos wide
		LDW	(R4)
		SUB	R7
		BPL	SHTESR030
		NOP
;
		NOT
		INC	R0
SHTESR030
		ADD	R10
		CMP	R8
		BCS	SHTESR050	;new min wide ? ( no:SHTESR050 )
		NOP
;
		MOVE	R8,R0		;(R8) <-- new min wide
		MOVE	R9,R12		;(R9) <--      "       enemy index
SHTESR050
		LOOP
		FROM	R12		;[ dummy ]
;
		MOVES	R1,R9
		BMI	SHTESR060	;not search ? ( yes:SHTESR060 )
		NOP
;
		IBT	R0,#CENNO
		SUB	R9
		ADD	R0
		TO	R1
		ADD	R0
SHTESR060
		STOP
		NOP
;
;************************************************************************
;*									*
;*		GƂ̏Փ˃`FbNiP)				*
;*			in :						*
;*				(R1) <-- ̓G̃CfbNX		*
;*									*
;*			out :						*
;*				(R14)  <-- Փˑ̓G̃CfbNX	*
;*					i<0 : Փˑ薳j		*
;*				(CWK0) <-- w̋			*
;*				(CWK1) <-- x  h			*
;*									*
;*			j`FbN鎞́AqPTqPT	*
;*			  ZbgĂxs΂B		*
;*									*
;************************************************************************
;
MY_ENCROS	EQU	$
		IWT	R9,#CENMODE+(CENNO-1)*4	   ;(R9)  <-- G̃[h|C^[
		IWT	R10,#CENMOD1+1+(CENNO-1)*4 ;(R10) <-- G̏Փ˃`FbNf[^|C^[
		IWT	R11,#CECENTX+(CENNO-1)*4   ;(R11) <-- G̒SwW|C^[
		IWT	R8,#CEWIDEX+(CENNO-1)*4	   ;(R8)  <--	hw|C^[
		IBT	R2,#4		;(R2)  <-- |C^[Zf[^
;
		IBT	R14,#(CENNO-1)*4 ;(R14) <-- ̓G̃CfbNX
		FROM	R14
		TO	R7		;(R7) <-- ̓G̋tCfbNX
		SUB	R1
;
		FROM	R11
		SUB	R7
		TO	R3		;(R3)  <-- ̒SwW
		LDW	(R0)
		ADD	#2
		TO	R4		;(R4)  <--     h    x h
		LDW	(R0)
		FROM	R8
		SUB	R7
		TO	R5		;(R5)  <--   h	 w
		LDW	(R0)
		ADD	#2
		TO	R6		;(R6)  <--   h	 xh
		LDW	(R0)
;
		IBT	R12,#CENNO
;
		CACHE
;
		MOVE	R13,R15
MY_ENCROS_010
		FROM	R14
		SUB	R1
		BEQ	MY_ENCROS_040	;̃CfbNXH ( yes:MY_ENCROS_040 )
		NOP
;
		LDB	(R9)
		SUB	#CEFAIL
		BCC	MY_ENCROS_040	;G̃[hnjH ( no:MY_ENCROS_040 )
		NOP
;
		LDB	(R10)
		AND	#08H
		BEQ	MY_ENCROS_040	;ЂԂH ( no:MY_ENCROS_040 )
		TO	R7		;(R7) <-- ̓Ĝw
;
		LDW	(R8)
		LDW	(R11)		;(R0) <--     h    SwW
		SUB	R3
		SMS	R8,CWORK0	;(CWK1) <-- w̋
		ADD	R5
		ADD	R7
		BMI	MY_ENCROS_040	;wՓˁH ( no:MY_ENCROS_040 )
		SUB	R7
;
		SUB	R7
		SUB	R5
		SUB	R5
		BPL	MY_ENCROS_030	;wՓˁH ( no:MY_ENCROS_030 )
		INC	R11
;
		INC	R11
		INC	R8
		INC	R8
;
		TO	R7		;(R7) <-- ̓Ĝx
		LDW	(R8)
		LDW	(R11)		;(R0) <--     h    SxW
		SUB	R4
		SMS	R0,CWORK1	;(CWK1) <-- x̋
		ADD	R6
		ADD	R7
		BMI	MY_ENCROS_020	;xՓˁH ( no:MY_ENCROS_020 )
		SUB	R7
;
		SUB	R7
		SUB	R6
		SUB	R6
		BPL	MY_ENCROS_020	;xՓˁH ( no:MY_ENCROS_020 )
		NOP
;
;-------------- ՓˁII ------------------------------------------------
		STOP			;<<< return to SFC !! >>>
		NOP
;
MY_ENCROS_020
		DEC	R8
		DEC	R8
		DEC	R11
MY_ENCROS_030
		DEC	R11
MY_ENCROS_040
		WITH	R11
		SUB	R2
		WITH	R8
		SUB	R2
		WITH	R9
		SUB	R2
		WITH	R10
		SUB	R2
		WITH	R14
		SUB	R2
		LOOP
		FROM	R14		;[ duumy ]
;
		STOP
		NOP
;
;************************************************************************
;*									*
;*		GƂ̏Փ˃`FbNi@Ṕ@ʁ@j			*
;*			in :						*
;*				(R1) <-- ̓G̃CfbNX		*
;*									*
;*			out :						*
;*				(R14)  <-- Փˑ̓G̃CfbNX	*
;*					i<0 : Փˑ薳j		*
;*				(CWK0) <-- w̋			*
;*				(CWK1) <-- x  h			*
;*									*
;*			j`FbN鎞́AqPTqPT	*
;*			  ZbgĂxs΂B		*
;*									*
;************************************************************************
;
MY_ENCROS2	EQU	$
		IWT	R9,#CENMODE+(CENNO-1)*4	   ;(R9)  <-- G̃[h|C^[
		IWT	R11,#CECENTX+(CENNO-1)*4   ;(R11) <-- G̒SwW|C^[
		IWT	R8,#CEWIDEX+(CENNO-1)*4	   ;(R8)  <--	hw|C^[
		IBT	R2,#4		;(R2)  <-- |C^[Zf[^
;
		IBT	R14,#(CENNO-1)*4 ;(R14) <-- ̓G̃CfbNX
		FROM	R14
		TO	R7		;(R7) <-- ̓G̋tCfbNX
		SUB	R1
;
		FROM	R11
		SUB	R7
		TO	R3		;(R3)  <-- ̒SwW
		LDW	(R0)
		ADD	#2
		TO	R4		;(R4)  <--     h    x h
		LDW	(R0)
		FROM	R8
		SUB	R7
		TO	R5		;(R5)  <--   h	 w
		LDW	(R0)
		ADD	#2
		TO	R6		;(R6)  <--   h	 xh
		LDW	(R0)
;
		IBT	R12,#CENNO
;
		CACHE
;
		MOVE	R13,R15
MY_ENCROS2_010
		FROM	R14
		SUB	R1
		BEQ	MY_ENCROS2_040	;̃CfbNXH ( yes:MY_ENCROS2_040 )
		NOP
;
		LDB	(R9)
		SUB	#CEFAIL
		BCC	MY_ENCROS2_040	;G̃[hnjH ( no:MY_ENCROS2_040 )
		TO	R7		;(R7) <-- ̓Ĝw
;
		LDW	(R8)
		FROM	R7
		ADD	R5
		TO	R10
		ADD	R0
		INC	R10
		LDW	(R11)		;(R0) <--     h    SwW
		SUB	R3
		SMS	R0,CWORK0	;(CWK0) <-- w̋
		ADD	R5
		ADD	R7
		CMP	R10
		BCS	MY_ENCROS2_030	;wՓˁH ( no:MY_ENCROS2_030 )
		INC	R11
;
		INC	R11
		INC	R8
		INC	R8
;
		TO	R7		;(R7) <-- ̓Ĝx
		LDW	(R8)
		FROM	R7
		ADD	R6
		TO	R10
		ADD	R0
		INC	R10
		LDW	(R11)		;(R0) <--     h    SxW
		SUB	R4
		SMS	R0,CWORK1	;(CWK1) <-- x̋
		ADD	R6
		ADD	R7
		CMP	R10
		BCS	MY_ENCROS2_020	;xՓˁH ( no:MY_ENCROS2_020 )
		NOP
;
;-------------- ՓˁII ------------------------------------------------
		STOP			;<<< return to SFC !! >>>
		NOP
;
MY_ENCROS2_020
		DEC	R8
		DEC	R8
		DEC	R11
MY_ENCROS2_030
		DEC	R11
MY_ENCROS2_040
		WITH	R11
		SUB	R2
		WITH	R8
		SUB	R2
		WITH	R9
		SUB	R2
		WITH	R14
		SUB	R2
		LOOP
		FROM	R14		;[ duumy ]
;
		STOP
		NOP
;
;************************************************************************
;*									*
;*		T[`Xs[hvZ					*
;*									*
;*			in  : (R1) <-- ڕWwW			*
;*			      (R2) <--	h x h			*
;*			      (R3) <-- ݂w h			*
;*			      (R4) <--	h x h			*
;*			      (R6) <-- T[`Xs[h			*
;*									*
;*			out : (R1) <-- T[`wXs[h			*
;*			      (R2) <--	 h  x	  h			*
;*									*
;************************************************************************
;
SEARCH_SPEED	EQU	$
		FROM	R1
		SUB	R3
		MOVE	R5,R0		;(R5) <-- wT[`
		BPL	SEARCH_SPEED_10
		NOP
;
		NOT
		INC	R0
SEARCH_SPEED_10
		MOVE	R7,R0		;(R7) <-- wiZj
;
		FROM	R2
		SUB	R4
		MOVE	R8,R0		;(R8) <-- xT[`
		BPL	SEARCH_SPEED_20
		NOP
;
		NOT
		INC	R0
SEARCH_SPEED_20
		MOVE	R9,R0		;(R9) <-- xij
;
		SUB	R7
		BCS	SEARCH_SPEED_30 ;w̕H ( no:SEARCH_SPEED_30 )
		ROR			;(R0) <-- ̃tOi{FwA|Fxj
;
		MOVE	R0,R7
		MOVE	R7,R9
		MOVE	R9,R0
SEARCH_SPEED_30
		MOVE	R10,R0		;(R10) <-- ̃tO
;
;------------------------------------------------------------------------
;-		Z							-
;------------------------------------------------------------------------
		WITH	R7
		LMULT			;(R7)+(R4) <-- 폜
		SUB	R0		;(R0)	   <-- AL[^NA
		MOVE	R2,R0		;(R2)	   <-- NA
;
		IBT	R12,#32
		IWT	R13,#SEARCH_SPEED_40+1
;
		CACHE
;
SEARCH_SPEED_40
		WITH	R2		;փVtg
		ADD	R2
		WITH	R4		;폜փVtg
		ADD	R4
		WITH	R7
		ROL
		ROL			;폜AL[^ɃVtg
		SUB	R9		;AL[^Ər
		BCC	SEARCH_SPEED_50 ;AL[^ł΁AZȗ
		ADD	R9
;
		SUB	R9		;AL[^珜
		INC	R2		;ɂP
SEARCH_SPEED_50
		LOOP
		WITH	R2		;(R2) <-- T[`xXs[h
;
;------------------------------------------------------------------------
;-		T[`Xs[hZbg					-
;------------------------------------------------------------------------
		MOVES	R10,R10
		BPL	SEARCH_SPEED_60 ;w̕H ( yes:SEARCH_SPEED_60 )
		NOP
;
		MOVE	R0,R6
		MOVE	R6,R2
		MOVE	R2,R0
;
SEARCH_SPEED_60
		MOVE	R1,R6		;(R1) <-- T[`wXs[h
		MOVES	R5,R5
		BPL	SEARCH_SPEED_70 ;wT[`H ( yes:SEARCH_SPEED_70 )
		WITH	R1
;
		NOT
		INC	R1
SEARCH_SPEED_70
		MOVES	R8,R8
		BPL	SEARCH_SPEED_80 ;xT[`H ( yes:SEARCH_SPEED_80 )
		WITH	R2
;
		NOT
		INC	R2
;
SEARCH_SPEED_80
		STOP
		NOP
;
;************************************************************************
;*		Ԃp@r[					*
;*			in :						*
;*				(R1) <-- n`lCfbNX		*
;*				(R4) <-- G\wW			*
;*				(R5) <--    "  x h                    *
;*				(R6) <-- 				*
;*				(R7) <-- ]p				*
;*				(R8) <-- a~S			*
;************************************************************************
BEEM_OAMET	EQU	$
		IBT	R0,#BANK LCOS
		ROMB
;
		IBT	R2,#6		;(R2)  <-- n`lCfbNXZf[^
		IBT	R9,#0100H/3	;(R9)  <-- ]p̉Zf[^
		IBT	R10,#040H	;(R10) <-- rhmf[^ւ̉Zf[^
		IWT	R11,#LCOS
;
		FROM	R11
		TO	R14
		ADD	R7
;
		CACHE
;
		IWT	R12,#3
		IWT	R13,#BEEM_OAMET_010+1
BEEM_OAMET_010
		GETB
;
		WITH	R14
		ADD	R10
;
		MULT	R8
		HIB
		SEX
		DEC	R6
		BMI	BEEM_OAMET_020
		INC	R6
;
		NOT
		INC	R0
BEEM_OAMET_020
		ADD	R4
		STW	(R1)
		INC	R1
		INC	R1
;
		GETB
;
		WITH	R7
		ADD	R9
		WITH	R7
		LOB
;
		FROM	R11
		TO	R14
		ADD	R7
;
		MULT	R8
		HIB
		SEX
		ADD	R5
		STW	(R1)
;
		WITH	R1
		ADD	R2
;
		LOOP
		GETB
;
		STOP
		NOP
;
;
;************************************************************************
;*		痎鏰n`lZbg				*
;*			in :						*
;*				(R1) <-- n`lCfbNX		*
;*				(R2) <-- ubNwW			*
;*				(R3) <--     h	 x h			*
;*				(R4) <--     h	 TCY		*
;*				(R5) <--     h	 c  h			*
;*				(R6) <-- x[XLmD`ss	*
;************************************************************************
ON_DW_C_1	EQU	$
		HEX	22		;PubN̂
ON_DW_C_X	EQU	$
		HEX	2A,2C,2E	;ubN
ON_DW_C_Y	EQU	$
		HEX	24,0,0		;cubN
		HEX	26,0,0
		HEX	28,0,0
ON_DW_C_XY	EQU	$
		HEX	00,02,04	;cubN
		HEX	0C,0E,20
		HEX	06,08,0A
;
ON_DW_OAMST	EQU	$
;
;-------------- Wɕ␳ ------------------------------------------
		IBT	R7,#010H
;
		FROM	R4
		SUB	R7
		LSR
		WITH	R2
		SUB	R0
		FROM	R5
		SUB	R7
		LSR
		WITH	R3
		SUB	R0
;
;-------------- ubN^Cv`FbN ----------------------------------
		IBT	R0,#BANK ON_DW_C_1
		ROMB
;
		FROM	R5
		SUB	R7
		BNE	ON_DW_OAMST_020 ;cPubNH ( no:ON_DW_OAMST_020 )
		FROM	R4
;
		SUB	R7
		BNE	ON_DW_OAMST_010+1 ;PubNH ( no:ON_DW_OAMST_010+1 )
;
;-------------- PubN̂ ----------------------------------
		IWT	R14,#ON_DW_C_1	;(R14) <-- LmDf[^|C^[
		BRA	ON_DW_OAMST_050
		NOP
;
;-------------- ubN ------------------------------------
ON_DW_OAMST_010
		IWT	R14,#ON_DW_C_X	;(R14) <-- LmDf[^|C^[
		BRA	ON_DW_OAMST_050
		NOP
;
ON_DW_OAMST_020
;;;;		    FROM    R4
		SUB	R7
		BNE	ON_DW_OAMST_030+1 ;PubNH ( no:ON_DW_OAMST_030+1 )
;
;-------------- cubN ------------------------------------
		IWT	R14,#ON_DW_C_Y	;(R14) <-- LmDf[^|C^[
		BRA	ON_DW_OAMST_050
		NOP
;
ON_DW_OAMST_030
		IWT	R14,#ON_DW_C_XY ;(R14) <-- LmDf[^|C^[
;
;-------------- n`lZbg --------------------------------------------
ON_DW_OAMST_050
		IBT	R9,#02H		;(R9)  <-- TCYtOZbgf[^
		IWT	R13,#8000H	;(R13) <-- Lutbvf[^
;
		CACHE
;
ON_DW_OAMST_060
;
;-------------- LZbg ----------------------------------
		mJSR	ON_DW_OAMSB
;
		WITH	R5
		SUB	R7
		BEQ	ON_DW_OAMST_100 ;cPubNH ( yes:ON_DW_OAMST_100 )
		NOP
;
;-------------- LZbg ----------------------------------
ON_DW_OAMST_070
		WITH	R3		;xWZ
		ADD	R7
;
		WITH	R5
		SUB	R7
		BEQ	ON_DW_OAMST_080 ;LZbgIH ( yes:ON_DW_OAMST_080 )
		NOP
;
		mJSR	ON_DW_OAMSB
;
		WITH	R14		;Lփ|C^[߂
		SUB	#3
		WITH	R6		;utbvZbg
		XOR	R13
		BRA	ON_DW_OAMST_070+1
		WITH	R3
;
;-------------- LZbg ----------------------------------
ON_DW_OAMST_080
		WITH	R14		;Lփ|C^[Z
		ADD	#3
		WITH	R6		;utbvZbg
		BIC	R13
;
		mJSR	ON_DW_OAMSB
;
ON_DW_OAMST_100
		STOP
		NOP
;
;------------------------------------------------------------------------
;-		n`lZbg						-
;------------------------------------------------------------------------
ON_DW_OAMSB
		MOVE	R8,R2		;(R8)  <-- wW
		MOVE	R10,R4		;(R10) <-- wTCYJE^[
;
;-------------- LZbg ----------------------------------
		FROM	R8
		STW	(R1)		;wWZbg
		INC	R1
		INC	R1
;
		FROM	R3
		STW	(R1)		;xWZbg
		INC	R1
		INC	R1
;
		GETB			;(R0) <-- LmDf[^
		INC	R14
;
		ADD	R6
		STW	(R1)		;LmD`ssZbg
		INC	R1
		INC	R1
;
		FROM	R9
		STW	(R1)		;TCYtOZbg
;
;-------------- LZbg ----------------------------------
		WITH	R10
		SUB	R7
		BEQ	ON_DW_OAMSB_040 ;PubNH ( yes:ON_DW_OAMSB_040 )
		INC	R1
;
		INC	R1
;
		GETB			;(R0) <-- LmD
		INC	R14
;
		TO	R12		;(R12) <-- LmD`ss
		ADD	R6
;
ON_DW_OAMSB_010
		WITH	R8		;wWZ
		ADD	R7
;
		WITH	R10
		SUB	R7
		BEQ	ON_DW_OAMSB_020 ;LZbgIH ( yes:ON_DW_OAMSB_020 )
		FROM	R8
;
		STW	(R1)		;wWZbg
		INC	R1
		INC	R1
;
		FROM	R3
		STW	(R1)		;xWZbg
		INC	R1
		INC	R1
;
		FROM	R12
		STW	(R1)		;LmD`ssZbg
		INC	R1
		INC	R1
;
		FROM	R9
		STW	(R1)		;TCYtOZbg
		INC	R1
		BRA	ON_DW_OAMSB_010
		INC	R1
;
;-------------- ELZbg ----------------------------------
ON_DW_OAMSB_020
		FROM	R8
		STW	(R1)		;wWZbg
		INC	R1
		INC	R1
;
		FROM	R3
		STW	(R1)		;xWZbg
		INC	R1
		INC	R1
;
		GETB			;(R0) <-- ELmD
		INC	R14
;
		ADD	R6
		STW	(R1)		;LmD`ssZbg
		INC	R1
		INC	R1
;
		FROM	R9
		STW	(R1)		;TCYtOZbg
		INC	R1
;
ON_DW_OAMSB_030
		mRTS_X
		INC	R1
;
ON_DW_OAMSB_040
		INC	R14
		INC	R14
		mRTS_X
		INC	R1
;
;
;
;--------------------------------------------------------
;-	EGG SEARCH					-
;-		egg suu -> (R6)				-
;--------------------------------------------------------
;
;--------------------------------------------------------
;-	TARGET_COUNTER					-
;-							-
;-	[In]						-
;-		target low no.	-> (R4)			-
;-		target high no. -> (R5)			-
;-	[Out]						-
;-		target sum. -> (R6)			-
;--------------------------------------------------------
EGGSEARCH	EQU	$
		IWT	R4,#EGG00
		IWT	R5,#EGG09+1
;
TARGET_COUNTER	EQU	$
		IBT	R1,#04
		IWT	R2,#CENMODE		;(R2) <-- enemy mode pointer
		IWT	R3,#CENMYNO		;(R3) <--   "   name    "
		IBT	R6,#00
		CACHE
		IBT	R12,#CENNO
		MOVE	R13,R15

EGSH0000
		LDW	(R2)
		SUB	#00
		BEQ	EGSH0080		;
		NOP
;
		LDW	(R3)
		CMP	R4
		BCC	EGSH0080		;
		NOP
;
		CMP	R5
		BCS	EGSH0080		;
		NOP
;
		INC	R6
EGSH0080
		WITH	R2
		ADD	R1
		WITH	R3
		ADD	R1
		LOOP
		NOP
;
		STOP
		NOP
;
;--------------------------------------------------------
;-	HEIHO_COUNTER					-
;-							-
;-	[Out]						-
;-		target sum. -> (R6)			-
;--------------------------------------------------------
HEIHO_COUNTER	EQU	$
		IWT	R4,#EGG00
		IWT	R5,#EGG09+1
		IWT	R7,#HEIH0
		IWT	R8,#CHKH0
		IWT	R9,#GSTH0
		IWT	R11,#MSHIH
;
		IBT	R1,#04
		IWT	R2,#CENMODE		;(R2) <-- enemy mode pointer
		IWT	R3,#CENMYNO		;(R3) <--   "   name    "
		IBT	R6,#00
		CACHE
		IBT	R12,#CENNO
		MOVE	R13,R15

HEIHO_CNT0000
		LDW	(R2)
		SUB	#00
		BEQ	HEIHO_CNT0800		;
		NOP
;
		LDW	(R3)			;^}S ?
		CMP	R4			;
		BCC	HEIHO_CNT0300		;  no: HEIHO_CNT0300
		NOP				;
		CMP	R5			;
		BCC	HEIHO_CNT0700		; yes: HEIHO_CNT0700
		NOP
;
HEIHO_CNT0300	EQU	$
		CMP	R7			;wCz[ ?
		BEQ	HEIHO_CNT0700		; yes: HEIHO_CNT0700
		NOP				;
		CMP	R8			;nwCz[ ?
		BEQ	HEIHO_CNT0700		; yes: HEIHO_CNT0700
		NOP				;
		CMP	R9			;HwCz[ ?
		BEQ	HEIHO_CNT0700		; yes: HEIHO_CNT0700
		NOP				;
		CMP	R11			;[TgwCz[ ?
		BNE	HEIHO_CNT0800		;  no: HEIHO_CNT0800
		NOP

HEIHO_CNT0700
		INC	R6
HEIHO_CNT0800
		WITH	R2
		ADD	R1
		WITH	R3
		ADD	R1
		LOOP
		NOP
;
		STOP
		NOP
;
;
;************************************************************************
;*									*
;*		ۂ񂽔						*
;*	[In]								*
;*		R1	ۂ񂽂 ECENTX					*
;*		R2	@ h@	 ECENTY					*
;*		R10	a					*
;*		CWRK0	XSPD +						*
;*		CWRK1	YSPD -						*
;*									*
;************************************************************************
PONTA_BOMB	EQU	$
		IWT	R5,#CENMYNO+5CH
		IWT	R6,#CENMODE+5CH
		IWT	R7,#CECENTX+5CH
		IWT	R8,#CECENTY+5CH
		IWT	R9,#CENMOD1+1+5CH
		FROM	R10
		TO	R14
		ADD	R10

		CACHE
		IBT	R12,#CENNO
		MOVE	R13,R15

		LDB	(R6)			;`FbNĂ ?
		SUB	#CEFAIL+1		;
		BMI	P_BOM010		;  no:P_BOM010
		NOP
;
		LDW	(R7)			;w@͈͂nj ?
		SUB	R1			;
		ADD	R10			;
		SUB	R14			;
		BCS	P_BOM010		;  no: P_BOM010
		NOP

		LDW	(R8)			;x@͈͂nj ?
		SUB	R2			;
		ADD	R10			;
		SUB	R14			;
		BCC	P_BOM020		; yes: P_BOM020
		FROM	R12

P_BOM010
		mDJMP_X P_BOM080+1		;  no: P_BOM080
		IBT	R0,#04

P_BOM020
		SUB	#01
		ADD	R0
		SMS	R6,REG6
		TO	R6
		ADD	R0

		IWT	R3,#PONTA
		LDW	(R5)			;ۂ ?
		CMP	R3			;
		BEQ	P_BOM028		;yes: P_BOM028
		NOP

		IWT	R3,#PUTIG		;ՂՂO[g ?
		CMP	R3			;
		BEQ	P_BOM028		; yes: P_BOM028
		NOP

		IWT	R3,#PUTIB		;ՂՂrbO ?
		CMP	R3			;
		BNE	P_BOM030		;  no: P_BOM030
		NOP

P_BOM028
		mLDW0	CENWRK2,R6		;ԂĂ ?
		SUB	#0			;
		BNE	P_BOM078		; yes: P_BOM078
		NOP

		mLDW	R11,CENMOD2,R6
		mSTW	R11,CENWRKA,R6

		BRA	P_BOM060
		NOP

P_BOM030
		IWT	R3,#SSLIM
		CMP	R3			;тՂ ?
		BNE	P_BOM050		;  no: P_BOM050
		NOP

		mLDW0	CENWRK2,R6		;ԂĂ ?
		SUB	#03			;
		BEQ	P_BOM078		; yes: P_BOM078
		NOP				;
		DEC	R0			;
		BNE	P_BOM060		;  no: P_BOM060
		NOP
		BRA	P_BOM078+1
		LMS	R6,REG6
P_BOM050
		LDB	(R9)			;ЂԂ ?
		AND	#00001000B		;
		BEQ	P_BOM078		;  no: P_BOM078
		NOP

P_BOM060
		LMS	R4,CWORK0
		LDW	(R7)			;Eɂ ?
		SUB	R1			;
		BPL	P_BOM070		; yes: P_BOM070
		NOP

		WITH	R4
		NOT
		INC	R4

P_BOM070
		mSTW	R4,CENXSPD,R6

		LMS	R4,CWORK1
		mSTW	R4,CENYSPD,R6
		WITH	R4
		SUB	R4
		mSTW	R4,CENWRK0,R6
		mSTW	R4,CENXPOW,R6
		INC	R4
		mSTW	R4,CENSHOT,R6
		IBT	R4,#040H
		mSTW	R4,CENGPOW,R6
		IWT	R4,#0FFFCH		;s藈肵Ȃ
		LDW	(R9)			;
		AND	R4			;
		SBK				;
		IWT	R4,#1111100111111111B	;Փ˃`FbNȂ
		mLDW0	CENMOD0,R6		;
		AND	R4			;
		SBK

P_BOM078
		LMS	R6,REG6

P_BOM080
		IBT	R0,#04
		WITH	R5
		SUB	R0
		WITH	R6
		SUB	R0
		WITH	R7
		SUB	R0
		WITH	R8
		SUB	R0
		WITH	R9
		SUB	R0

		LOOP
		NOP

		STOP
		NOP
;
;
;----------------------------------------------------------------
;-	tgT[`						-
;-		(R5) <- Z^[ X				-
;-		(R6) <- Z^[ Y				-
;-		(R7) <- X 					-
;-		(R8) <- Y 					-
;-		Ƃ	      : G̃CfbNX -> (R1)-
;-					Y Hݗ -> (R0)-
;-		ȂƂ  : -1 -> (R1)		-
;----------------------------------------------------------------
LIFTSEARCH	EQU	$
		CACHE
		IBT	R12,#CENNO
		MOVE	R13,R15
;
		IWT	R2,#CEMOVE
		FROM	R12
		SUB	#01
		ADD	R0
		TO	R1
		ADD	R0			; (R1) <- enemy index
		mLDW0	CENMODE,R1
		SUB	R2
		BNE	LFTSCH00F0		; mode move ? [no->LFTSCH00F0]
		NOP
;
		IWT	R3,#SEARCHLIFT
		IBT	R0,#BANK LIFTTABLE
		ROMB
		IWT	R14,#LIFTTABLE
LFTSCH0040
		GETB
		INC	R14
		TO	R2
		GETBH
		mLDW0	CENMYNO,R1
		SUB	R2
		BEQ	LFTSCH0050		; lift find ? [yes->LFTSCH0050]
		DEC	R3
		BNE	LFTSCH0040		; search end ? [no->LFTSCH0040]
		INC	R14
;
		BRA	LFTSCH00F0
		NOP
LFTSCH0050
		mLDW0	CECENTX,R1
		TO	R2
		SUB	R5
		BPL	LFTSCH0060		; minus ? [no->LFTSCH0060]
		WITH	R2
;
		NOT
		INC	R2
LFTSCH0060
		mLDW0	CEWIDEX,R1
		ADD	R7
		SUB	R2
		BMI	LFTSCH00F0		; X  I[o[ ? [yes->LFTSCH00F0]
		NOP
;
		mLDW0	CECENTY,R1
		TO	R2
		SUB	R6
		BPL	LFTSCH0070		; minus ? [no->LFTSCH0070]
		WITH	R2
;
		NOT
		INC	R2
LFTSCH0070
		mLDW0	CEWIDEY,R1
		ADD	R7
		SUB	R2
		BMI	LFTSCH00F0		; Y  I[o[ ? [yes->LFTSCH00F0]
		NOP
;
		BRA	LFTSCH0100
		NOP
LFTSCH00F0
		LOOP
		NOP
;
		IWT	R1,#-1
LFTSCH0100
		STOP
		NOP
;
;
LIFTTABLE	EQU	$
		WORD	ON_DW
		WORD	NLFLR
		WORD	NLFUD
		WORD	NRLF0
		WORD	NRLF1
		WORD	NRLF2
		WORD	NRLF3
LIFTTABLE_E	EQU	$
;
SEARCHLIFT	EQU	(LIFTTABLE_E-LIFTTABLE)/2
;
;
;
;
;
;************************************************************************
;*		afQARASXN[Zbg				*
;*			in :						*
;*				(R8)  <-- afQgXN[Xs[h	*
;*				(R9)  <--   h	u	  h		*
;*				(R10) <-- afRgXN[Xs[h	*
;*				(R11) <--   h	u	  h		*
;*				(R12) <-- afSgXN[Xs[h	*
;*				(R13) <--   h	u	  h		*
;************************************************************************
BG234_SCRL	EQU	$
;
;------------------------------------------------------------------------
;-		XN[JE^[gZbg				-
;------------------------------------------------------------------------
		LMS	R1,CESCCH1	;(R1) <-- afPXN[JE^[g
		LM	R0,CESCCH1L
		TO	R2		;(R2) <-- afPXN[JE^[gikj
		LOB
;
;-------------- afQXN[JE^[gZbg ----------------------
		MOVES	R6,R8
		BEQ	BG234_SCRL_0010 ;XN[ZbgH ( no:BG234_SCRL_0010 )
		FROM	R2
;
		LMULT
		WITH	R4
		HIB
		LOB
		SWAP
		TO	R3
		OR	R4
		FROM	R1
		LMULT
		WITH	R4
		ADD	R3
		WITH	R4
		HIB
		ADC	#0
		LOB
		SWAP
		OR	R4
		SMS	R0,CESCCH2
;
;-------------- afRXN[JE^[gZbg ----------------------
BG234_SCRL_0010
		MOVES	R6,R10
		BEQ	BG234_SCRL_0020 ;XN[ZbgH ( no:BG234_SCRL_0020 )
		FROM	R2
;
		LMULT
		WITH	R4
		HIB
		LOB
		SWAP
		TO	R3
		OR	R4
		FROM	R1
		LMULT
		WITH	R4
		ADD	R3
		WITH	R4
		HIB
		ADC	#0
		LOB
		SWAP
		OR	R4
		SMS	R0,CESCCH3
;
;-------------- afSXN[JE^[gZbg ----------------------
BG234_SCRL_0020
		MOVES	R6,R12
		BEQ	BG234_SCRL_0030 ;XN[ZbgH ( no:BG234_SCRL_0030 )
		FROM	R2
;
		LMULT
		WITH	R4
		HIB
		LOB
		SWAP
		TO	R3
		OR	R4
		FROM	R1
		LMULT
		WITH	R4
		ADD	R3
		WITH	R4
		HIB
		ADC	#0
		LOB
		SWAP
		OR	R4
		SMS	R0,CESCCH4
;
BG234_SCRL_0030
;
;------------------------------------------------------------------------
;-		XN[JE^[uZbg				-
;------------------------------------------------------------------------
;;;;		    IWT	    R0,#071CH	    ;(R0) <-- l`wafPXN[JE^[u
		IWT	R0,#070CH	;(R0) <-- l`wafPXN[JE^[u
		LMS	R5,CESCCV1	;(R5) <-- afPXN[JE^[u
		TO	R1		;(R1) <-- XN[JE^[
		SUB	R5
		LM	R0,CESCCV1L
		TO	R2		;(R2) <-- afPXN[JE^[uikj
		LOB
;
;-------------- afQXN[JE^[uZbg ----------------------
		MOVES	R6,R9
		BEQ	BG234_SCRL_0040 ;XN[ZbgH ( no:BG234_SCRL_0040 )
		NOP
;
		BPL	BG234_SCRL_0031 ;afPƓH ( no:BG234_SCRL_0031 )
		FROM	R2
;
		MOVE	R0,R5
		BRA	BG234_SCRL_0032
		NOP
;
BG234_SCRL_0031
		LMULT
		WITH	R4
		HIB
		LOB
		SWAP
		TO	R3
		OR	R4
		FROM	R1
		LMULT
		WITH	R4
		ADD	R3
		WITH	R4
		HIB
		ADC	#0
		LOB
		SWAP
		TO	R3
		OR	R4
;;;;		    IWT	    R0,#0346H	    ;(R0) <-- l`wafQXN[JE^[u
		IWT	R0,#0326H	;(R0) <-- l`wafQXN[JE^[u
		SUB	R3
		BPL	BG234_SCRL_0032
		NOP
;
		SUB	R0
BG234_SCRL_0032
		SMS	R0,CESCCV2
;
;-------------- afRXN[JE^[uZbg ----------------------
BG234_SCRL_0040
		MOVES	R6,R11
		BEQ	BG234_SCRL_0050 ;XN[ZbgH ( no:BG234_SCRL_0050 )
		NOP
;
		BPL	BG234_SCRL_0041 ;afPƓH ( no:BG234_SCRL_0041 )
		FROM	R2
;
		MOVE	R0,R5
		BRA	BG234_SCRL_0042
		NOP
;
BG234_SCRL_0041
		LMULT
		WITH	R4
		HIB
		LOB
		SWAP
		TO	R3
		OR	R4
		FROM	R1
		LMULT
		WITH	R4
		ADD	R3
		WITH	R4
		HIB
		ADC	#0
		LOB
		SWAP
		TO	R3
		OR	R4
;;;;		    IWT	    R0,#0146H	    ;(R0) <-- l`wafRXN[JE^[u
		IWT	R0,#0126H	;(R0) <-- l`wafRXN[JE^[u
		SUB	R3
		BPL	BG234_SCRL_0042
		NOP
;
		SUB	R0
BG234_SCRL_0042
		SMS	R0,CESCCV3
;
;-------------- afSXN[JE^[uZbg ----------------------
BG234_SCRL_0050
		MOVES	R6,R13
		BEQ	BG234_SCRL_0060 ;XN[ZbgH ( no:BG234_SCRL_0060 )
		NOP
;
		BPL	BG234_SCRL_0051 ;afPƓH ( no:BG234_SCRL_0051 )
		FROM	R2
;
		MOVE	R0,R5
		BRA	BG234_SCRL_0052
		NOP
;
BG234_SCRL_0051
		LMULT
		WITH	R4
		HIB
		LOB
		SWAP
		TO	R3
		OR	R4
		FROM	R1
		LMULT
		WITH	R4
		ADD	R3
		WITH	R4
		HIB
		ADC	#0
		LOB
		SWAP
		TO	R3
		OR	R4
;;;;		    IWT	    R0,#0146H	    ;(R0) <-- l`wafSXN[JE^[u
		IWT	R0,#0126H	;(R0) <-- l`wafSXN[JE^[u
		SUB	R3
		BPL	BG234_SCRL_0052
		NOP
;
		SUB	R0
BG234_SCRL_0052
		SMS	R0,CESCCV4
;
BG234_SCRL_0060
		STOP
		NOP
;
;************************************************************************
;*		vC[XN[				*
;************************************************************************
LEFT_CX		EQU	030H
RIGHT_CX	EQU	0A8H
;
;------------------------------------------------------------------------
;-		XN[␳pf[^					-
;------------------------------------------------------------------------
PSCR_HOSFG
;			+--- XN[JE^[u␳
;			|+--	       h	 g h
;			||+- STx␳
;			|||
;			|||  +---- w␳
;			|||  | +-- x	h
;			|||  | |
		BYTE	000B,0,0	;[0000]
		BYTE	110B,0,0	;[0001]
		BYTE	110B,0,0	;[0010]
		BYTE	100B,0,0	;[0011]
		BYTE	110B,0,0	;[0100]
		BYTE	010B,0,0	;[0101]
		BYTE	110B,0,0	;[0110]
		BYTE	001B,0,0	;[0111]
		BYTE	110B,0,0	;[1000]
		BYTE	110B,0,0	;[1001]
		BYTE	010B,0,0	;[1010]
		BYTE	001B,1,0	;[1011]
		BYTE	100B,0,0	;[1100]
		BYTE	001B,0,1	;[1101]
		BYTE	001B,1,1	;[1110]
		BYTE	000B,0,0	;[1111]
;
M_PLSCRL	EQU	$
;
;-------------- XN[JE^[gZbg ----------------------------
		LM	R0,CSP_SCRL_FG
		SUB	#0
		BEQ	M_PLSCRL_0010	;XN[H ( no:M_PLSCRL_0010 )
		NOP
;
;-------------- XN[Zbg ------------------------
		BMI	M_PLSCRL_0000
		SUB	R0		;[ IBT R0,#0 ]
;
		LM	R0,CSP_SCRL_XSP
		TO	R1		;(R1) <-- XN[wXs[h~Q
		ADD	R0
		IWT	R13,#000H	;(R13) <-- XN[ŒwXs[h
		LM	R0,CSP_SCRL_XPS
		BRA	M_PLSCRL_0020
		NOP
;
M_PLSCRL_0000
		IBT	R1,#0		;(R1) <-- XN[wXs[h
		mDJMP	M_PLSCRL_0070
;
;-------------- vC[wړlvZ --------------------------
M_PLSCRL_0010
		LM	R0,CPLXSDR_OLD
		TO	R1
		LOB
		LM	R0,CPLXPSL_OLD
		LOB
		SWAP
		TO	R1		;(R1) <-- OvC[wWitj
		OR	R1
;
		LMS	R0,CPLXSDR
		TO	R3
		LOB
		LMS	R0,CPLXPSL
		LOB
		SWAP
		OR	R3		;(R0) <--  ݃vC[wWitj
		SUB	R1
		TO	R1		;(R1) <-- vC[wړl~Q
		ADD	R0
		IWT	R13,#0100H	;(R13) <-- XN[ŒwXs[h
;
;-------------- gXN[lvZ ------------------------------
		LMS	R0,CPLXPSL
M_PLSCRL_0020
		LMS	R3,CESCCH1
		SUB	R3
		LM	R4,CPLSCRL_CX	;[ * SBK !! ] (R4) <-- vC[XN[_wʒu
		SUB	R4
		BMI	M_PLSCRL_0050	;փXN[H ( yes:M_PLSCRL_0050 )
		NOP
;
		IBT	R3,#018H
		SUB	R3
		DEC	R0
		BPL	M_PLSCRL_0050	;EփXN[H ( yes:M_PLSCRL_0050 )
		INC	R0
;
		IBT	R0,#LEFT_CX
		LMS	R3,CPLCMKI
		DEC	R3
		BMI	M_PLSCRL_0030
		NOP
;
		IWT	R0,#RIGHT_CX
M_PLSCRL_0030
		SUB	R4
		IBT	R3,#050H
		ADD	R3
		BMI	M_PLSCRL_0032	;vC[XN[_wʒuύXH ( yes:M_PLSCRL_0032 )
		NOP
;
		IWT	R3,#050H*2
		SUB	R3
		BCC	M_PLSCRL_0040	;vC[XN[_wʒuύXH ( no:M_PLSCRL_0040 )
M_PLSCRL_0032
		ADD	R4
		SM	R0,CPLSCRL_CX	;vC[XN[_wʒuύX
M_PLSCRL_0040
		BRA	M_PLSCRL_0070
		SUB	R0		;[ IBT R0,#0 ]
;
M_PLSCRL_0050
		MOVES	R1,R1
		BNE	M_PLSCRL_0051	;vC[wړH ( yes:M_PLSCRL_0051 )
		NOP
;
;;;;		    IWT	    R1,#0100H
		MOVE	R1,R13
		SUB	#0
		BPL	M_PLSCRL_0051
		NOP
;
		WITH	R1
		NOT
		INC	R1
M_PLSCRL_0051
		TO	R3		;[ * (R0) not break !! ]
		XOR	R1
		BPL	M_PLSCRL_0052	;ړtH ( no:M_PLSCRL_0052 )
		TO	R4
;
		BRA	M_PLSCRL_0060
		ADD	R4
;
M_PLSCRL_0052
		MOVE	R3,R0		;(R0) save
;;;;		    IWT	    R4,#0100H
		MOVE	R4,R13
		MOVES	R1,R1
		BPL	M_PLSCRL_0054
		NOP
;
		WITH	R4
		NOT
		INC	R4
M_PLSCRL_0054
		FROM	R1
		SUB	R4
		XOR	R1
		BPL	M_PLSCRL_0056
		NOP
;
		MOVE	R1,R4
M_PLSCRL_0056
		MOVE	R0,R3		;(R0) load
;
		IBT	R4,#LEFT_CX
		MOVES	R1,R1
		BPL	M_PLSCRL_0060+1 ;EړH ( yes:M_PLSCRL_0060+1 )
		FROM	R4
;
		IWT	R4,#RIGHT_CX
M_PLSCRL_0060
		FROM	R4
		SBK			;[ SM R4,CPLSCRL_CX ] vC[XN[_wʒuZbg
;
M_PLSCRL_0070
		TO	R3
		ADD	#08H+02H	;[ 08H+02H:XN[ől ]
		BMI	M_PLSCRL_0100	;XN[őlI[o[H ( yes:M_PLSCRL_0100 )
		NOP
;
		TO	R3
		SUB	#08H+02H
		BMI	M_PLSCRL_0150	;EXN[őlI[o[H ( no:M_PLSCRL_0150 )
		NOP
;
;-------------- XN[ől֕␳ ------------------
M_PLSCRL_0100
		SUB	R3
;
M_PLSCRL_0150
		LOB			;XN[ligjO
;
;;;;		    LM	    R3,CSP_SCRL_FG
;;;;		    MOVES   R3,R3
;;;;		    BNE	    M_PLSCRL_0160   ;XN[H ( yes:M_PLSCRL_0160 )
		SWAP
;;;;;
;;;;		    LMS	    R3,CCCHGFG
;;;;		    MOVES   R3,R3
;;;;		    BNE	    M_PLSCRL_0210   ;΃XN[H ( yes:M_PLSCRL_0210 )
;;;;		    NOP			    ;XN[l~POOg
;;;;;
;;;;M_PLSCRL_0160
		XOR	R1
		BPL	M_PLSCRL_0200	;vC[ړtH ( no:M_PLSCRL_0200 )
		NOP
;
		FROM	R1		;[ IBT R0,#0 ]
M_PLSCRL_0200
		XOR	R1
		SUB	R1
		TO	R3
		XOR	R1
		BPL	M_PLSCRL_0250	;vC[ړlI[o[H ( yes:M_PLSCRL_0250 )
		ADD	R1
;
M_PLSCRL_0210
		MOVE	R1,R0		;(R1) <-- XN[l
;
M_PLSCRL_0250
		LM	R0,CESCCH1L
		LOB
		ADD	R1		;(C)
		SBK			;[ SM R0,CESCCH1L ]
		HIB
		SEX
		LMS	R1,CESCCH1
		ADD	R1
;
		LM	R1,CPLSCRL_MINX
		SUB	R1
		BPL	M_PLSCRL_0260	;XN[JE^[gŏlI[o[H ( no:M_PLSCRL_0260 )
		ADD	R1
;
		SUB	R0
		SM	R0,CESCCH1L	;XN[JE^[gikjNA[
		MOVE	R0,R1
M_PLSCRL_0260
		LM	R1,CPLSCRL_MAXX
		SUB	R1
		BMI	M_PLSCRL_0270	;XN[JE^[gőlI[o[H ( no:M_PLSCRL_0270 )
		ADD	R1
;
		SUB	R0
		SM	R0,CESCCH1L	;XN[JE^[gikjNA[
		MOVE	R0,R1
M_PLSCRL_0270
		MOVE	R1,R0		;(R1) <-- VXN[JE^[g
;
;-------------- XN[JE^[uZbg ----------------------------
		LM	R0,CSP_SCRL_FG
		SUB	#0
		BEQ	M_PLSCRL_0280	;XN[H ( no:M_PLSCRL_0280 )
		NOP
;
;-------------- XN[Zbg ------------------------
		BMI	M_PLSCRL_0272
		NOP
;
		LM	R2,CSP_SCRL_YSP
		FROM	R2
		DIV2
		DIV2
		TO	R2		;(R2) <-- XN[xXs[h~PDQT
		ADD	R2
		IWT	R13,#000H	;(R13) <-- XN[ŒxXs[h
		LM	R0,CSP_SCRL_YPS
		BRA	M_PLSCRL_0290
		NOP
;
M_PLSCRL_0272	EQU	$
		IBT	R3,#0		;(R3) <-- XN[l
		IBT	R2,#0		;(R2) <-- XN[xXs[h
		mDJMP	M_PLSCRL_0350
;
;-------------- vC[xړlvZ --------------------------
M_PLSCRL_0280
		LM	R0,CPLYSDR_OLD
		TO	R2
		LOB
		LM	R0,CPLYPSL_OLD
		LOB
		SWAP
		TO	R2		;(R2) <-- OvC[xWitj
		OR	R2
;
		LMS	R0,CPLYSDR
		TO	R3
		LOB
		LMS	R0,CPLYPSL
		LOB
		SWAP
		OR	R3		;(R0) <--  ݃vC[xWitj
		SUB	R2
		MOVE	R2,R0
		DIV2
		DIV2
		TO	R2		;(R2) <-- vC[xړl~PDQT
		ADD	R2
;;;;		    ADD	    R0
		IWT	R13,#0200H	;(R13) <-- XN[ŒwXs[h
;
;-------------- uXN[lvZ ------------------------------
		LMS	R0,CPLYPSL
M_PLSCRL_0290
		LMS	R3,CESCCV1
		SUB	R3
		LM	R4,CPLSCRL_CY	;(R4) <-- vC[XN[_xʒu
		TO	R3		;(R3) <-- XN[l
		SUB	R4
		BMI	M_PLSCRL_0290C	;փXN[H ( yes:M_PLSCRL_0290C )
		WITH	R3
;
		SUB	#08H
		BPL	M_PLSCRL_0290C	;փXN[H ( yes:M_PLSCRL_0290C )
		TO	R3
;
		SUB	R0
M_PLSCRL_0290C
		LM	R0,CSP_SCRL_FG
		SUB	#0
		BEQ	M_PLSCRL_02900	;XN[H ( no:M_PLSCRL_02900 )
		NOP
;
		mDJMP	M_PLSCRL_0350
;
M_PLSCRL_02900
;
;-------------- uXN[SʒuύX`FbN --------
		LM	R5,CMKEYC1
		FROM	R5
		BIC	#0000000000001100B ;[ AND #1111111111110011B ]
		LMS	R14,CPLXSPD
		OR	R14
		LMS	R14,CPLJUMP
		OR	R14
		BNE	M_PLSCRL_0292	;uXN[SʒuύXnjH ( no:M_PLSCRL_0292 )
		SUB	R0		;[ IBT R0,#0 ]
;
		LMS	R0,CPLTYPE
		SUB	#P_MOGURA
		BEQ	M_PLSCRL_0292	;OH ( yes:M_PLSCRL_0292 )
		FROM	R5
;
		AND	#0000000000001100B
		BEQ	M_PLSCRL_02910	;uXN[SʒuύXH ( no:M_PLSCRL_02910 )
		SUB	R0		;[ IBT R0,#0 ]
;
		LM	R0,CPLSCRL_TM	;[ * SBK ]
		INC	R0
		IBT	R4,#010H
		SUB	R4
		BCC	M_PLSCRL_02910	;EFCgH ( yes:M_PLSCRL_02910 )
		ADD	R4
;
		IWT	R4,#080H+20H	;(R4) <-- Ƃ̂uXN[Sʒu
		FROM	R5
		AND	#0000000000001000B
		BNE	M_PLSCRL_0291	;H ( yes:M_PLSCRL_0291 )
		NOP
;
		IBT	R4,#044H+20H	;(R4) <-- Ƃ̂uXN[Sʒu
M_PLSCRL_0291
		SUB	R0		;[ IBT R0,#0 ]
		SBK			;[ SM R0,CPLSCRL_TM ] uXN[SʒuύXEFCgJE^[Zbg
		WITH	R4		;[ MOVE R0,R4 ]
		BRA	M_PLSCRL_02930
		TO	R0
;
M_PLSCRL_02910
		SM	R0,CPLSCRL_TM	;uXN[SʒuύXEFCgJE^[Zbg
		BRA	M_PLSCRL_0294
		NOP
;
M_PLSCRL_0292
		SM	R0,CPLSCRL_TM	;uXN[SʒuύXEFCgJE^[Zbg
;
;-------------- uXN[SʒuZbg`FbN ----
M_PLSCRL_0293	EQU	$
		MOVES	R3,R3
		BEQ	M_PLSCRL_0330	;XN[lOH ( yes:M_PLSCRL_0330 )
		NOP
;
;;;;		    IBT	    R0,#044H
		IBT	R0,#044H+20H
		SUB	R4
		TO	R5
		XOR	R3
		BPL	M_PLSCRL_0294	;uXN[SʒuύXnjH ( no:M_PLSCRL_0294 )
		ADD	R4
;
M_PLSCRL_02930
		SM	R0,CPLSCRL_CY	;vC[XN[_xʒuZbg
;
M_PLSCRL_0294
		MOVES	R3,R3
		BPL	M_PLSCRL_0330	;փXN[H ( no:M_PLSCRL_0330 )
		NOP
;
;-------------- XN[nj`FbN ----------------
		LMS	R0,CPLJUMP
		SUB	#0
		BEQ	M_PLSCRL_0300	;vC[nH ( yes:M_PLSCRL_0300 )
		INC	R0		;[ R0 <- !=0 : XN[njtOhnmh]
;
		LMS	R0,CPLDOSN
		DEC	R0
		BPL	M_PLSCRL_0300	;hhX[IIhH ( yes:M_PLSCRL_0300 )
		INC	R0
;
;-------------- G񂸂hhX[`FbN ----
		LM	R0,CPLSCRL_CY
;;;;		    IBT	    R4,#030H
		IBT	R4,#030H+20H
		SUB	R4
		TO	R4
		ADD	R3
		BPL	M_PLSCRL_0310	;XN[`FbNxʒuH ( no:M_PLSCRL_0310 )
		NOP
;
		LMS	R0,CPLSPJP
		IWT	R5,#02H+8000H
		SUB	R5
		BCC	M_PLSCRL_0310	;G񂸂hhX[IIhH ( no:M_PLSCRL_0310 )
		NOP
;
		MOVE	R3,R4
		BRA	M_PLSCRL_0350+1
		FROM	R3
;
M_PLSCRL_0300
		SM	R0,CSCRONF	;XN[njtOhnmh
;;;;		    IWT	    R0,#-0200H	    ;(R0) <-- XN[njII
		FROM	R13
		NOT
		INC	R0		;(R0) <-- XN[njII
		SUB	R2
		BPL	M_PLSCRL_0310	;vC[ړʏH ( no:M_PLSCRL_0310 )
		TO	R2
;
		ADD	R2
M_PLSCRL_0310
		LM	R0,CSCRONF
		LMS	R4,CPLSWIM
		OR	R4
		LMS	R4,CCCHGFG
		OR	R4
		LMS	R4,CPLKAID
		OR	R4
		BNE	M_PLSCRL_0350	;XN[njH ( yes:M_PLSCRL_0350 )
		NOP
;
		LMS	R0,CPLTYPE
		SUB	#6		;[ wRv^[H ]
		BEQ	M_PLSCRL_0350	;XN[njH ( yes:M_PLSCRL_0350 )
		NOP
;
		TO	R3		;[ IBT R3,#0 ]
		BRA	M_PLSCRL_0350
		SUB	R0
;
;-------------- XN[`FbN --------------------
M_PLSCRL_0330
		LMS	R0,CPLJUMP
		SUB	#0
		BNE	M_PLSCRL_0350	;vC[WvH ( yes:M_PLSCRL_0350 )
		SUB	R0		;[ IBT R0,#0 ]
;
		SM	R0,CSCRONF	;XN[njtOhneeh
;
;;;;		    LM	    R0,CPLSCRL_CY
;;;;		    IWT	    R4,#098H
;;;;		    SUB	    R4
;;;;		    TO	    R4
;;;;		    ADD	    R3
;;;;		    BMI	    M_PLSCRL_0350   ;XN[`FbNxʒuH ( no:M_PLSCRL_0350 )
;;;;		    NOP
;
;;;;		    IWT	    R0,#0100H	    ;(R0) <-- XN[njII
;;;;		    IWT	    R0,#0200H	    ;(R0) <-- XN[njII
		FROM	R13
		SUB	R2
		BMI	M_PLSCRL_0350	;vC[ړʏH ( no:M_PLSCRL_0350 )
		ADD	R2
;
		MOVE	R2,R0
M_PLSCRL_0350
		FROM	R3
		ADD	#08H+02H	;[ 08H+02H:XN[ől ]
		BMI	M_PLSCRL_0400	;XN[őlI[o[H ( yes:M_PLSCRL_0400 )
		FROM	R3
;
		SUB	#08H+02H
		BMI	M_PLSCRL_0450	;XN[őlI[o[H ( no:M_PLSCRL_0450 )
		NOP
;
;-------------- XN[ől֕␳ ------------------
M_PLSCRL_0400
		WITH	R3
		SUB	R0
;
M_PLSCRL_0450
		FROM	R3
		LOB			;XN[ligjO
;
		LM	R3,CSP_SCRL_FG
		MOVES	R3,R3
;;@;;		     BNE     M_PLSCRL_0460   ;XN[H ( yes:M_PLSCRL_0460 )
		SWAP
;
;;@;;		     LMS     R3,CCCHGFG
;;@;;		     MOVES   R3,R3
;;@;;		     BNE     M_PLSCRL_0510   ;΃XN[H ( yes:M_PLSCRL_0510 )
;;@;;		     NOP		     ;XN[l~POOg
;;@;;;
;;@;;M_PLSCRL_0460
		XOR	R2
		BPL	M_PLSCRL_0500	;vC[ړtH ( no:M_PLSCRL_0500 )
		NOP
;
		FROM	R2		;[ IBT R0,#0 ]
M_PLSCRL_0500
		XOR	R2
		SUB	R2
		TO	R3
		XOR	R2
		BPL	M_PLSCRL_0550	;vC[ړlI[o[H ( yes:M_PLSCRL_0550 )
		ADD	R2
;
M_PLSCRL_0510
		MOVE	R2,R0		;(R1) <-- XN[l
;
M_PLSCRL_0550
		LM	R0,CESCCV1L
		LOB
		ADD	R2		;(C)
		SBK			;[ SM R0,CESCCV1L ]
		HIB
		SEX
		LMS	R2,CESCCV1
		ADD	R2
;
		LM	R2,CPLSCRL_MINY
		SUB	R2
		BPL	M_PLSCRL_0560	;XN[JE^[uŏlI[o[H ( no:M_PLSCRL_0560 )
		ADD	R2
;
		SUB	R0
		SM	R0,CESCCV1L	;XN[JE^[uikjNA[
		MOVE	R0,R2
M_PLSCRL_0560
		LM	R2,CPLSCRL_MAXY
		SUB	R2
		BMI	M_PLSCRL_0570	;XN[JE^[uőlI[o[H ( no:M_PLSCRL_0570 )
		ADD	R2
;
		SUB	R0
		SM	R0,CESCCV1L	;XN[JE^[uikjNA[
		MOVE	R0,R2
M_PLSCRL_0570
;;;;		    IBT	    R2,#01CH	    ;(R2) <-- cʃTCY␳l
		IBT	R2,#01CH-10H	;(R2) <-- cʃTCY␳l
		TO	R2		;(R2) <-- VXN[JE^[u
		SUB	R2
;
;-------------- XN[af`FbN ----------------------------------
		IBT	R5,#0		;(R5) <-- af`FbNtO
		IWT	R6,#CUNBUFAD	;(R6) <-- R[Xf[^ʏobt@|C^[
;
		IWT	R0,#0FFH
		TO	R3		;(R3) <-- VXN[JE^[g̉E_
		ADD	R1
		TO	R4		;(R4) <-- VXN[JE^[ủ_
		ADD	R2
;
;-------------- _af`FbN ------------------------------
		MOVES	R0,R2
		BPL	M_PLSCRL_0580
		HIB
;
		SUB	R0
M_PLSCRL_0580
		ADD	R0
		ADD	R0
		ADD	R0
		TO	R7		;(R7) <-- XN[JE^[ȕ_igj
		ADD	R0
		FROM	R1
		HIB
		OR	R7
		ADD	R6
		LDB	(R0)
		SEX
		BMI	M_PLSCRL_0600	;XN[njʁH ( no:M_PLSCRL_0600 )
		NOP
;
		IBT	R5,#2		;[ INC R5 & ASL R5 ]
;
;-------------- E_af`FbN ------------------------------
M_PLSCRL_0600
		FROM	R3
		HIB
		OR	R7
		ADD	R6
		LDB	(R0)
		SEX
		BMI	M_PLSCRL_0650	;XN[njʁH ( no:M_PLSCRL_0650 )
		NOP
;
		INC	R5
;
;-------------- _af`FbN ------------------------------
M_PLSCRL_0650
		WITH	R5		;[ ASL R5 ]
		ADD	R5
;
		FROM	R4
		HIB
		ADD	R0
		ADD	R0
		ADD	R0
		TO	R7
		ADD	R0
		FROM	R1
		HIB
		OR	R7
		ADD	R6
		LDB	(R0)
		SEX
		BMI	M_PLSCRL_0700	;XN[njʁH ( no:M_PLSCRL_0700 )
		NOP
;
		INC	R5
;
;-------------- E_af`FbN ------------------------------
M_PLSCRL_0700
		WITH	R5		;[ ASL R5 ]
		ADD	R5
;
		FROM	R3
		HIB
		OR	R7
		ADD	R6
		LDB	(R0)
		SEX
		BMI	M_PLSCRL_0750	;XN[njʁH ( no:M_PLSCRL_0750 )
		NOP
;
		INC	R5
;
M_PLSCRL_0750
;
;-------------- XN[JE^[␳ ------------------------
		IBT	R0,#BANK PSCR_HOSFG
		ROMB
;
		IWT	R0,#PSCR_HOSFG
		ADD	R5		;x3
		ADD	R5		;
		TO	R14		;(R14) <-- XN[JE^[␳^Cvf[^|C^[
		ADD	R5		;
		GETB
		INC	R14
;
		DEC	R0
		BPL	M_PLSCRL_0760	;␳H( yes:M_PLSCRL_0760 )
		INC	R0
;
		mDJMP	M_PLSCRL_1200	;␳H( no:M_PLSCRL_1200 )
;
M_PLSCRL_0760
		LSR
		BCS	M_PLSCRL_0850	;STx␳H ( yes:M_PLSCRL_0850 )
		LSR
;
		BCC	M_PLSCRL_0800	;gXN[JE^[␳H ( no:M_PLSCRL_0800 )
		NOP
;
;-------------- gXN[JE^[␳ --------------
		MOVE	R6,R0		;(R6) <-- (R0)
;
		SUB	R0
		SM	R0,CESCCH1L	;XN[JE^[gikjNA[
;
		IWT	R0,#080H
		ADD	R1
		HIB
		TO	R1		;(R1) <-- ␳gXN[JE^[
		SWAP
;
		DEC	R6
		BMI	M_PLSCRL_1200	;uXN[JE^[␳H ( no:M_PLSCRL_1200 )
		NOP
;
;-------------- uXN[JE^[␳ --------------
M_PLSCRL_0800
		SUB	R0
		SM	R0,CESCCV1L	;XN[JE^[uikjNA[
;
		IWT	R0,#080H
		ADD	R2
		HIB
		TO	R2		;(R2) <-- ␳uXN[JE^[
		BRA	M_PLSCRL_1200
		SWAP
;
;-------------- STx␳ ------------------------------
M_PLSCRL_0850
		TO	R3		;(R3) <-- STxw␳
		GETB
		INC	R14
;
		MOVE	R0,R1
		DEC	R3
		BMI	M_PLSCRL_0900
		INC	R3
;
		NOT
M_PLSCRL_0900
		TO	R7		;(R7) <-- `ariItZbgwj
		LOB
;
		TO	R5		;(R5) <-- STxx␳
		GETB
;
		MOVE	R0,R2
		DEC	R5
		BMI	M_PLSCRL_0950
		INC	R5
;
		NOT
M_PLSCRL_0950
		LOB
		MOVE	R8,R0		;(R8) <-- `ariItZbgxj
;
		ADD	R7		;(R0) <-- iItZbgwj{iItZbgxj
		IWT	R6,#0FFH+1	;[ 0FFH : STx␳GATCY ]
		SUB	R6
		BCS	M_PLSCRL_1200	;␳GAH ( no:M_PLSCRL_1200 )
		ADD	R6
;
		ADD	R0		;x2
		IWT	R6,#DIVBUF
		ADD	R6
		LDW	(R0)
		IWT	R6,#0FFH*080H	;[ 0FFH : STx␳GATCY ]
		LMULT
		WITH	R4		;[ ASL R4 ]
		ADD	R4		;
		ROL
		WITH	R4		;[ ASL R4 ]
		ADD	R4		;
		TO	R6		;(R6) <-- 䗦
		ADC	#0
;
		FROM	R7
		LMULT
		IWT	R0,#080H	;[ ľܓ ]
		DEC	R3
		BMI	M_PLSCRL_1000
		ADD	R4
;
		NOT
M_PLSCRL_1000
		TO	R7		;(R7) <-- ␳ItZbgw
		HIB
		FROM	R1
		HIB
		SWAP
		TO	R1		;(R1) <-- ␳XN[JE^[g
		OR	R7
;
		FROM	R8
		LMULT
		IWT	R0,#080H	;[ ľܓ ]
		DEC	R5
		BMI	M_PLSCRL_1050
		ADD	R4
;
		NOT
M_PLSCRL_1050
		TO	R8		;(R8) <-- ␳ItZbgx
		HIB
		FROM	R2
		HIB
		SWAP
		TO	R2		;(R2) <-- ␳XN[JE^[u
		OR	R8
;
		SUB	R0
		SM	R0,CESCCH1L	;XN[JE^[gikjNA[
		SM	R0,CESCCV1L	;XN[JE^[uikjNA[
;
M_PLSCRL_1200
		SMS	R1,CESCCH1	;XN[JE^[gZbg
		SMS	R2,CESCCV1	;XN[JE^[uZbg
;
		STOP
		NOP
;
;
;--------------------------------------------------------
;-	bT[`					-
;-		(R3) <- X |WV			-
;-		(R4) <- Y     "                         -
;-	return : (R9) <- GCfbNX			-
;-			 ȂƂ (-1)	-
;--------------------------------------------------------
KOURASEARCH	EQU	$
		IWT	R1,#KORA0
		IWT	R2,#KORA1+1
;
		IBT	R5,#00			; GCfbNX !!
		IBT	R6,#CEMOVE
		IBT	R8,#0FFH
		IBT	R9,#0FFH
		CACHE
		IBT	R12,#CENNO
		MOVE	R13,R15
KRSH0000
		mLDW0	CENMODE,R5		; enemy mode read !!
		SUB	R6
		BNE	KRSH0080		; mode move ? [no->KRSH0080]
		NOP
;
		mLDW0	CENMYNO,R5		; enemy name read !!
		CMP	R1
		BCC	KRSH0080		; b ? [no->KRSH0080]
		NOP
;
		CMP	R2
		BCS	KRSH0080		; b ? [no->KRSH0080]
		NOP
;
		mLDW0	CENSHOT,R5		; enemy shot flag read !!
		SUB	#00
		BNE	KRSH0080		; Vbg ? [yes->KRSH0080]
		NOP
;
		mLDW0	CENXPSL,R5		; enemy X position read !!
		FROM	R3
		SUB	R0			; (R0) <- (My X) - (Enemy X)
		BPL	KRSH0040		; Plus ? [yes->KRSH0040]
		NOP
;
		NOT
		INC	R0
KRSH0040
		MOVE	R7,R0
;
		mLDW0	CENYPSL,R5		; enemy Y position read !!
		FROM	R4
		SUB	R0			; (R0) <- (My Y) - (Enemy Y)
		BPL	KRSH0060		; Plus ? [yes->KRSH0060]
		NOP
;
		NOT
		INC	R0
KRSH0060
		ADD	R7			; (R0) <- c̋̍v
		CMP	R8
		BCS	KRSH0080		; ̋̕߂ ? [no->KRSH0080]
		NOP
;
		MOVE	R8,R0			; (R8) <- c̋̍v
		MOVE	R9,R5			; (R9) <- enemy index
KRSH0080
		WITH	R5
		ADD	#04
		LOOP
		NOP
;
		STOP
		NOP
;
;------------------------------------------------------------------------
;-		Ђ܂胊tgn`lZbg				-
;-			in :						-
;-				(R1) <-- GCfbNX			-
;------------------------------------------------------------------------
HIMWR_OAMST	EQU	$
		mLDW0	CENOAML,R1
		IBT	R2,#6*8		;Ԃ͌łn`lZbgII
		TO	R2		;(R2)  <-- n`lCfbNX
		ADD	R2
		mLDW0	CENWRK2,R1
		LSR			;1/4
		TO	R3		;(R3)  <-- 
		LSR			;
		mLDW	R4,CENWRK4,R1	;(R4)  <-- p^[mDf[^
		mLDW	R5,CENWRK6,R1	;(R5)  <--	    h
		mLDW	R9,CENDSXL,R1	;(R9)  <-- \wW
		mLDW	R10,CENDSYL,R1	;(R10) <-- \xW
		IBT	R11,#00H	;(R11) <-- `ssf[^
;
		mLDB0	CENCHRB,R1
		MULT	#8
		SMS	R0,CWORK	;(CWK0) <-- LN^[oN
;
		IBT	R0,#BANK HIMWRC
		ROMB
;
		CACHE
;
HIMWR_OAMST_010
		WITH	R5		;p^[mDǂݍ
		ADD	R5
		WITH	R4
		ROL
		ROL
		WITH	R5
		ADD	R5
		WITH	R4
		ROL
		ROL
		WITH	R5
		ADD	R5
		WITH	R4
		ROL
		ROL
		AND	#07H
;
		WITH	R3
		SUB	#8
		BCC	HIMWR_OAMST_060 ;ԕtsH ( yes:HIMWR_OAMST_060 )
		NOP
;
;-------------- Ԍs --------------------------------------------------
		ADD	#3		;[ 0:(0-3), 1:(4-7), 2:(8-) ]
		LSR			;
		LSR			;
		IWT	R14,#HIMWRC_M_NO
		TO	R14
		ADD	R14
		TO	R12		;(R12) <-- naigp
		GETB
;
		SMS	R4,REG4		;(R4) save
;
		ADD	R0		;x2
		IWT	R14,#HIMWRC_M_ADR
		TO	R14
		ADD	R14
		GETB
		INC	R14
		TO	R14		;(R14) <-- naif[^AhX
		GETBH
;
		MOVE	R13,R15		; loop address set
HIMWR_OAMST_020
		GETBS
		INC	R14
;
		MOVES	R6,R11
		BEQ	HIMWR_OAMST_030 ;H frip ? [ no:HIMWR_OAMST_030 ]
		NOP			;[ * (Z)=1: IBT R9,#0 ]
;
		NOT
		INC	R0
		IBT	R6,#008H
HIMWR_OAMST_030
		TO	R4
		ADD	R9		; r4 <- x position
;
		GETBS
		INC	R14
;
		TO	R7
		ADD	R10		; r7 <- y position
;
		GETB
		INC	R14
		GETBH
		INC	R14
;
		TO	R8
		XOR	R11		; R8 <- atoribute & chara No.
;
		GETB			; oamsb
		AND	#02H
		BNE	HIMWR_OAMST_050
		NOP
;
		WITH	R4
		ADD	R6
HIMWR_OAMST_050
		FROM	R4
		STW	(R2)		; x position
		INC	R2
		INC	R2
;
		FROM	R7
		STW	(R2)		; y position
		INC	R2
		INC	R2
;
		TO	R7		; r7 <- sub,data
		GETBH
		INC	R14
;
		LMS	R0,CWORK0	;(R0) <-- LN^[oN
		ADD	R8
		STW	(R2)		; chara No., atoribute
		INC	R2
		INC	R2
;
		FROM	R7
		STW	(R2)		; oamsb,data
		INC	R2
;
		LOOP
		INC	R2
;
		LMS	R4,REG4		;(R4) load
;
		IWT	R0,#04000H	;tbvZbg
		TO	R11
		XOR	R11
		IBT	R0,#020H	;xWZ
		WITH	R10
		BRA	HIMWR_OAMST_010
		SUB	R0
;
;-------------- ԕts ------------------------------------------------
HIMWR_OAMST_060
		FROM	R3
		ADD	#8
		BNE	HIMWR_OAMST_062 ;ԍ炫p^[ZbgnjH ( no:HIMWR_OAMST_062 )
		NOP
;
		mLDW0	CENWRK8,R1	;(R0) <-- ԍ炫p^[mD
		LSR			;1/4
		LSR			;
		BEQ	HIMWR_OAMST_062 ;ԍ炭H ( no:HIMWR_OAMST_062 )
		NOP
;
		ADD	#8-1
HIMWR_OAMST_062
		IWT	R14,#HIMWRC_H_NO
		TO	R14
		ADD	R14
		TO	R12		;(R12) <-- naigp
		GETB
;
		ADD	R0		;x2
		IWT	R14,#HIMWRC_H_ADR
		TO	R14
		ADD	R14
		GETB
		INC	R14
		TO	R14		;(R14) <-- naif[^AhX
		GETBH
;
		mLDW	R2,CENOAML,R1	;(R2)  <-- n`lCfbNX
;
		MOVE	R13,R15		; loop address set
HIMWR_OAMST_070
		GETBS
		INC	R14
;
		MOVES	R6,R11
		BEQ	HIMWR_OAMST_080 ;H frip ? [ no:HIMWR_OAMST_080 ]
		NOP			;[ * (Z)=1: IBT R9,#0 ]
;
		NOT
		INC	R0
		IBT	R6,#008H
HIMWR_OAMST_080
		TO	R4
		ADD	R9		; r4 <- x position
;
		GETBS
		INC	R14
;
		TO	R7
		ADD	R10		; r7 <- y position
;
		GETB
		INC	R14
		GETBH
		INC	R14
;
		TO	R8
		XOR	R11		; R8 <- atoribute & chara No.
;
		GETB			; oamsb
		AND	#02H
		BNE	HIMWR_OAMST_090
		NOP
;
		WITH	R4
		ADD	R6
HIMWR_OAMST_090
		FROM	R4
		STW	(R2)		; x position
		INC	R2
		INC	R2
;
		FROM	R7
		STW	(R2)		; y position
		INC	R2
		INC	R2
;
		TO	R7		; r7 <- sub,data
		GETBH
		INC	R14
;
		LMS	R0,CWORK0	;(R0) <-- LN^[oN
		ADD	R8
		STW	(R2)		; chara No., atoribute
		INC	R2
		INC	R2
;
		FROM	R7
		STW	(R2)		; oamsb,data
		INC	R2
;
		LOOP
		INC	R2
;
		STOP
		NOP
;
;-------------- Ԍsn`lZbgf[^ --------------------------------
HIMWRC_M_NO	EQU	$
		BYTE	(HIMWRC_0C-HIMWRC_0B)/5 ;[0]
		BYTE	(HIMWRC_0D-HIMWRC_0C)/5 ;[1]
		BYTE	(HIMWRC_EN-HIMWRC_0D)/5 ;[2]
HIMWRC_M_ADR	EQU	$
		WORD	HIMWRC_0B		;[0]
		WORD	HIMWRC_0C		;[1]
		WORD	HIMWRC_0D		;[2]
;
;-------------- ԕtsn`lZbgf[^ ------------------------------
HIMWRC_H_NO	EQU	$
		BYTE	(HIMWRC_01-HIMWRC_00)/5 ;[0]
		BYTE	(HIMWRC_02-HIMWRC_01)/5 ;[1]
		BYTE	(HIMWRC_03-HIMWRC_02)/5 ;[2]
		BYTE	(HIMWRC_04-HIMWRC_03)/5 ;[3]
		BYTE	(HIMWRC_05-HIMWRC_04)/5 ;[4]
		BYTE	(HIMWRC_06-HIMWRC_05)/5 ;[5]
		BYTE	(HIMWRC_07-HIMWRC_06)/5 ;[6]
		BYTE	(HIMWRC_08-HIMWRC_07)/5 ;[7]
		BYTE	(HIMWRC_09-HIMWRC_08)/5 ;[8]
		BYTE	(HIMWRC_0A-HIMWRC_09)/5 ;[9]
		BYTE	(HIMWRC_0B-HIMWRC_0A)/5 ;[A]
HIMWRC_H_ADR	EQU	$
		WORD	HIMWRC_00		;[0]
		WORD	HIMWRC_01		;[1]
		WORD	HIMWRC_02		;[2]
		WORD	HIMWRC_03		;[3]
		WORD	HIMWRC_04		;[4]
		WORD	HIMWRC_05		;[5]
		WORD	HIMWRC_06		;[6]
		WORD	HIMWRC_07		;[7]
		WORD	HIMWRC_08		;[8]
		WORD	HIMWRC_09		;[9]
		WORD	HIMWRC_0A		;[A]
;
;-------------- naif[^ --------------------------------------------
HIMWRC		EQU	$
HIMWRC_00	EQU	$
		BYTE	001H,000H	;[00]
		HEX	0C,22,02
;
HIMWRC_01	EQU	$
		BYTE	004H,0FCH	;[01]
		HEX	0C,22,02
		BYTE	003H,000H
		HEX	00,A2,02
;
HIMWRC_02	EQU	$
		BYTE	005H,0F8H	;[02]
		HEX	0C,22,02
		BYTE	003H,000H
		HEX	00,A2,02
;
HIMWRC_03	EQU	$
		BYTE	006H,0F4H	;[03]
		HEX	0C,22,02
		BYTE	003H,000H
		HEX	00,A2,02
;
HIMWRC_04	EQU	$
		BYTE	007H,0F0H	;[04]
		HEX	0C,22,02
		BYTE	004H,0FCH
		HEX	1A,22,00
		BYTE	003H,000H
		HEX	00,A2,02
;
HIMWRC_05	EQU	$
		BYTE	004H,0FCH	;[05]
		HEX	0A,22,00
		BYTE	003H,000H
		HEX	00,A2,02
		BYTE	005H,0ECH
		HEX	0C,62,02
		BYTE	00BH,0F8H
		HEX	11,22,00
;
HIMWRC_06	EQU	$
		BYTE	0FBH,0F7H	;[06]
		HEX	08,22,02
		BYTE	003H,000H
		HEX	00,A2,02
		BYTE	003H,0E8H
		HEX	0C,62,02
		BYTE	003H,0F0H
		HEX	00,22,02
;
HIMWRC_07	EQU	$
		BYTE	0F3H,0F7H	;[07]
		HEX	06,22,02
		BYTE	0FBH,0F7H
		HEX	08,22,02
		BYTE	003H,000H
		HEX	00,A2,02
		BYTE	001H,0E4H
		HEX	0C,62,02
		BYTE	003H,0F0H
		HEX	00,22,02
;
HIMWRC_08	EQU	$
		BYTE	005H,004H	;[08]
		HEX	0E,A2,02
		BYTE	005H,0FCH
		HEX	0E,22,02
		BYTE	0FDH,0FCH
		HEX	0E,62,02
		BYTE	0FDH,004H
		HEX	0E,E2,02
;
HIMWRC_09	EQU	$
		BYTE	007H,007H	;[09]
		HEX	1B,22,00
		BYTE	003H,007H
		HEX	1B,62,00
		BYTE	007H,006H
		HEX	0E,A2,02
		BYTE	007H,0FAH
		HEX	0E,22,02
		BYTE	0FBH,0FAH
		HEX	0E,62,02
		BYTE	0FBH,006H
		HEX	0E,E2,02
;
HIMWRC_0A	EQU	$
		BYTE	009H,008H	;[0A]
		HEX	1B,22,00
		BYTE	001H,008H
		HEX	1B,62,00
		BYTE	009H,008H
		HEX	0E,A2,02
		BYTE	009H,0F8H
		HEX	0E,22,02
		BYTE	0F9H,0F8H
		HEX	0E,62,02
		BYTE	0F9H,008H
		HEX	0E,E2,02
;
HIMWRC_0B	EQU	$
		BYTE	0ECH,0F7H	;[0B]
		HEX	02,22,02
		BYTE	0FCH,0F7H
		HEX	04,22,02
		BYTE	003H,000H
		HEX	00,A2,02
		BYTE	003H,0F0H
		HEX	00,22,02
;
HIMWRC_0C	EQU	$
		BYTE	0ECH,0F9H	;[0C]
		HEX	02,22,02
		BYTE	0FCH,0F8H
		HEX	04,22,02
		BYTE	003H,000H
		HEX	00,A2,02
		BYTE	003H,0F0H
		HEX	00,22,02
;
HIMWRC_0D	EQU	$
		BYTE	0FCH,0F9H	;[0D]
		HEX	04,22,02
		BYTE	0ECH,0FAH
		HEX	02,22,02
		BYTE	003H,000H
		HEX	00,A2,02
		BYTE	003H,0F0H
		HEX	00,22,02
;
HIMWRC_EN	EQU	$
;
;------------------------------------------------------------------------
;-		Ђ܂胊tgՓ˃`FbN				-
;-			in :						-
;-				(R1) <-- GCfbNX			-
;-			out :						-
;-				(CWK0) <-- tϏTEhtO	-
;------------------------------------------------------------------------
HAPPA_CX	EQU	020H		;Swtς̐܂ł̒
HAPPA_XW	EQU	020H+4		;tς̏Փ˂w
;
HAPPA_HSDT	EQU	$
		BYTE	0*10H,1*10H,2*10H,3*10H,3*10H,4*10H,5*10H,5*10H ;[0-(HAPPA_XW-1)]
		BYTE	6*10H,6*10H,7*10H,7*10H,7*10H,8*10H,8*10H,8*10H ;
		BYTE	8*10H,8*10H,8*10H,8*10H,8*10H,8*10H,8*10H,8*10H ;
		BYTE	8*10H,7*10H,7*10H,6*10H,6*10H,5*10H,5*10H,4*10H ;
		BYTE	4*10H,3*10H,2*10H,1*10H				;
;
HIMWR_CROSS	EQU	$
		SUB	R0		;[ IBT R0,#0 ]
		SMS	R0,CWORK0	;tϏTEhtOZbg
;
		mLDW0	CENWRK2,R1
		LSR			;1/32
		LSR			;
		LSR			;
		LSR			;
		TO	R2		;(R2)  <-- 
		LSR			;
		mLDW	R3,CENWRK4,R1	;(R3)  <-- p^[mDf[^
		mLDW	R4,CENWRK6,R1	;(R4)  <--	    h
		mLDW0	CECENTX,R1
		IBT	R5,#HAPPA_CX
		TO	R5		;(R5)  <-- tς̍[wW
		SUB	R5
		mLDW0	CENYPSL,R1
		TO	R6		;(R6)  <-- tςxW
		ADD	#04H
		IBT	R7,#(HAPPA_CX-(HAPPA_XW-HAPPA_CX)) ;(R7) <-- tςƉEtς̂w
		IBT	R12,#0		;(R12) <-- ̃p^[mDf[^
		IBT	R13,#1		;(R13) <--	      h	   [ 1:PUrbg[e[V`FbNp ]
;
		IBT	R0,#BANK HAPPA_HSDT
		ROMB
;
		CACHE
;
HIMWR_CROSS_010
		WITH	R4		;p^[mDǂݍ
		ADD	R4
		WITH	R3
		ROL
		ROL
		WITH	R4
		ADD	R4
		WITH	R3
		ROL
		ROL
		WITH	R4
		ADD	R4
		WITH	R3
		ROL
		ROL
		TO	R11		;(R11) <-- tσp^[mD
		AND	#07H
;
		IBT	R0,#010H
		TO	R8		;(R8)  <-- tσp^[mD{
		SUB	R11
;
;-------------- vC[Ƃ̏Փ˃`FbN ------------------------------
		LMS	R0,CPLYSPD
		SUB	#0
		BMI	HIMWR_CROSS_030 ;vC[㏸H ( yes:HIMWR_CROSS_030 )
		NOP
;
		LMS	R0,CPCENTX	;(R0)  <-- vC[SwW
		SUB	R5
		BMI	HIMWR_CROSS_030 ;vC[ƂwՓˁH ( no:HIMWR_CROSS_030 )
		NOP
;
		IBT	R9,#HAPPA_XW
		SUB	R9
		BCS	HIMWR_CROSS_030 ;vC[ƂwՓˁH ( no:HIMWR_CROSS_030 )
		ADD	R9
;
		MOVES	R7,R7
		BMI	HIMWR_CROSS_020 ;tρH ( yes:HIMWR_CROSS_020 )
		FROM	R9
;
		SBC	R0		;[ (C)=0 : -1 ]
HIMWR_CROSS_020
		IWT	R14,#HAPPA_HSDT
		TO	R14
		ADD	R14
;
		LMS	R9,CPLYPSL	;(R9) <-- vC[xW
		IBT	R0,#020H
		TO	R10		;(R10) <-- vC[̂xW
		ADD	R9
;
		GETB
		UMULT	R8
		HIB
		FROM	R6
		SUB	R0		;(R0) <-- tς̂xW
;
		SUB	R10
		BPL	HIMWR_CROSS_030 ;vC[ƂxՓˁH ( no:HIMWR_CROSS_030 )
		NOP
;
		ADD	#08H+1		;[ +1: hhX`ḧ ]
		BMI	HIMWR_CROSS_030 ;Փ˔͈͂njH ( no:HIMWR_CROSS_030 )
		NOP
;
;-------------- vC[xW␳ ----------------------------
		SUB	#(08H+1)-1	;[ -1:H܂ ]
		ADD	R9
		SBK			;[ SMS R0,CPLYPSL ]
		IWT	R0,#0100H
		SMS	R0,CPLYSPD	;vC[xXs[hZbg
		SMS	R0,CONLFFG	;vC[tgtOhnmh
;
		WITH	R11		;(R11) <-- tςɏĂtOhnmh
		OR	#08H
;
;-------------- ԂƂ̏Փ˃`FbN --------------------------------
HIMWR_CROSS_030
;;;;		    LMS	    R0,BABYNO
;;;;		    IWT	    R9,#0C000H
;;;;		    AND	    R9
;;;;		    BNE	    HIMWR_CROSS_050 ;Ԃ񃊃tgH ( no:HIMWR_CROSS_050 )
;;;;		    NOP
;;;;;
;;;;		    LM	    R0,CENYSPD
;;;;		    SUB	    #0
;;;;		    BMI	    HIMWR_CROSS_050 ;Ԃ㏸H ( yes:HIMWR_CROSS_050 )
;;;;		    NOP
;;;;;
;;;;		    LM	    R0,CECENTX	    ;(R0)  <-- Ԃ񒆐SwW
;;;;		    SUB	    R5
;;;;		    BMI	    HIMWR_CROSS_050 ;ԂƂwՓˁH ( no:HIMWR_CROSS_050 )
;;;;		    NOP
;;;;;
;;;;		    IBT	    R9,#HAPPA_XW
;;;;		    SUB	    R9
;;;;		    BCS	    HIMWR_CROSS_050 ;ԂƂwՓˁH ( no:HIMWR_CROSS_050 )
;;;;		    ADD	    R9
;;;;;
;;;;		    MOVES   R7,R7
;;;;		    BMI	    HIMWR_CROSS_040 ;tρH ( yes:HIMWR_CROSS_040 )
;;;;		    FROM    R9
;;;;;
;;;;		    SBC	    R0		    ;[ (C)=0 : -1 ]
;;;;HIMWR_CROSS_040
;;;;		    IWT	    R14,#HAPPA_HSDT
;;;;		    TO	    R14
;;;;		    ADD	    R14
;;;;;
;;;;		    LM	    R9,CENYPSL	    ;(R9) <-- ԂxW
;;;;		    IBT	    R0,#010H
;;;;		    TO	    R10		    ;(R10) <-- Ԃ񑫂̂xW
;;;;		    ADD	    R9
;;;;;
;;;;		    GETB
;;;;		    UMULT   R8
;;;;		    HIB
;;;;		    FROM    R6
;;;;		    SUB	    R0		    ;(R0) <-- tς̂xW
;;;;;
;;;;		    SUB	    R10
;;;;		    BPL	    HIMWR_CROSS_050 ;ԂƂxՓˁH ( no:HIMWR_CROSS_050 )
;;;;		    NOP
;;;;;
;;;;		    ADD	    #08H
;;;;		    BMI	    HIMWR_CROSS_050 ;Փ˔͈͂njH ( no:HIMWR_CROSS_050 )
;;;;		    NOP
;;;;;
;;;;;-------------- ԂxW␳ ------------------------------
;;;;		    SUB	    #08H-1	    ;[ -1:H܂ ]
;;;;		    ADD	    R9
;;;;		    SBK			    ;[ SMS R0,CENYPSL ]
;;;;		    IWT	    R0,#0100H
;;;;		    SM	    R0,CENYSPD	    ;ԂxXs[hZbg
;;;;		    SM	    R0,CB_ONLFFG    ;Ԃ񃊃tgtOhnmh
;;;;;
;;;;		    WITH    R11		    ;(R11) <-- tςɏĂtOhnmh
;;;;		    OR	    #08H
;
;-------------- tσp^[Zbg ------------------------------------
HIMWR_CROSS_050
		FROM	R11
		AND	#07H
		SUB	R11
		BNE	HIMWR_CROSS_060 ;tςɏĂH ( yes:HIMWR_CROSS_060 )
		ADD	R11
;
;-------------- tςɏĖ ------------------------------
		BEQ	HIMWR_CROSS_070 ;p^[njH ( yes:HIMWR_CROSS_070 )
		NOP
;
		BRA	HIMWR_CROSS_070
		DEC	R0
;
;-------------- tςɏĂ --------------------------------
HIMWR_CROSS_060
		TO	R9		;[ * not break (R0) ]
		SUB	#07H
		BCS	HIMWR_CROSS_070 ;p^[njH ( yes:HIMWR_CROSS_070 )
		NOP
;
		DEC	R0
		BPL	HIMWR_CROSS_062 ;TEhZbgH ( no:HIMWR_CROSS_062 )
		INC	R0
;
		IBT	R9,#01DH	;[]
		SMS	R9,CWORK0	;tϏTEhtOZbg
HIMWR_CROSS_062
		INC	R0
;
;-------------- ̗tσp^[mDZbg ------------------
HIMWR_CROSS_070
		MULT	#8		;
		ADD	R0		;[ <<13 ]
		ADD	R0		;
		SWAP			;
;
		ADD	R0		;p^[mD
		WITH	R13
		ROL
		WITH	R12
		ROL
		ADD	R0
		WITH	R13
		ROL
		WITH	R12
		ROL
		ADD	R0
		WITH	R13
		ROL
		WITH	R12
		ROL
;
;-------------- ̗tς --------------------------------------------
		WITH	R5		;(R5) <-- ̗tς̍[wW
		ADD	R7
		IBT	R0,#-020H	;(R6) <-- ̗tςxW
		TO	R6
		ADD	R6
		WITH	R7		;(R7) <-- tςƉEtς̂w̔]
		NOT
;
		DEC	R2
		BEQ	HIMWR_CROSS_080 ;IH ( yes:HIMWR_CROSS_080 )
		INC	R7
;
		mDJMP_X HIMWR_CROSS_010+1
		WITH	R4		;[ dummy ]
;
;-------------- ̗tσp^[mDrbg[e[V ------------
HIMWR_CROSS_080
		WITH	R13
		ADD	R13
		WITH	R12
		ROL
		BCC	HIMWR_CROSS_080+1
		WITH	R13		;[ dummy ]
;
		mSTW	R12,CENWRK4,R1	;̗tσp^[mDf[^Zbg
		mSTW	R13,CENWRK6,R1	;		 h
;
		STOP
		NOP
;
;
;----------------------------------------------------------------
;-	炮(vC[)					-
;-		ENCONT : px (XX.XX)				-
;-		  WRK0 : x_w					-
;-		  WRK2 : x_x					-
;-		  WRK4 : pxXs[h				-
;-		  WRK6 : ŏ̂w				-
;-		  WRK8 : ŏ̂x				-
;-		  XPSL : G̒Sw				-
;-		  YPSL : G̒Sx				-
;-		 CNTXW : C̒Sw			-
;-		 CNTYW : C̒Sx			-
;-		 WIDEX : w`FbN(a)			-
;-		 WIDEY : x`FbN(S̋)		-
;-								-
;-		CWORK1F <- px				-
;----------------------------------------------------------------
GROCK_CRCK	EQU	$
		IBT	R0,#BANK LCOS
		ROMB
;
		LM	R1,CENINDX		; R1 <- G̃CfbNX
;
		LMS	R0,CWORK1F
		TO	R5
		HIB				; R5 <- px
;
		IWT	R0,#LCOS
		TO	R14
		ADD	R5
;
		mLDW	R2,CEWIDEX,R1		; R2 <- Ew
		FROM	R2
		NOT
		TO	R3
		ADD	#01			; R3 <- w
		mLDW	R4,CEWIDEY,R1		; R4 <- x
;
		TO	R6			; R6 <- COS DATA
		GETB
		IWT	R0,#LSIN
		TO	R14
		ADD	R5
		TO	R7			; R7 <- SIN DATA
		GETB
;
		FROM	R4
		TO	R8
		MULT	R6			; R8 <- sy * cos
;
		FROM	R4
		TO	R9
		MULT	R7			; R9 <- sy * sin
;
		IWT	R11,#00080H
		FROM	R3
		MULT	R6			; R0 <- sx * cos ()
		ADD	R9
		ADD	R0
		ADD	R0
		ADD	R11
		HIB
		TO	R10
		SEX
		mLDW0	CENXPSL,R1
		ADD	R10
		SMS	CWORK0,R0		; CWORK0 <- RX ()
;
		FROM	R3
		MULT	R7			; R0 <- sx * sin ()
		FROM	R8
		SUB	R0
		ADD	R0
		ADD	R0
		ADD	R11
		HIB
		TO	R10
		SEX
		mLDW0	CENYPSL,R1
		ADD	R10
		SMS	CWORK1,R0		; CWORK1 <- RY ()
;
		FROM	R2
		MULT	R6			; R0 <- sx * cos (E)
		ADD	R9
		ADD	R0
		ADD	R0
		ADD	R11
		HIB
		TO	R10
		SEX
		mLDW0	CENXPSL,R1
		ADD	R10
		SMS	CWORK2,R0		; CWORK2 <- RX (E)
;
		FROM	R2
		MULT	R7			; R0 <- sx * sin (E)
		FROM	R8
		SUB	R0
		ADD	R0
		ADD	R0
		ADD	R11
		HIB
		TO	R10
		SEX
		mLDW0	CENYPSL,R1
		ADD	R10
		SMS	CWORK3,R0		; CWORK3 <- RY (E)
;
		LMS	R8,CWORK0		; RX ()
		LMS	R9,CWORK2		; RX (E)
		LM	R10,CPCENTX		; vC[w
		FROM	R10
		TO	R7
		SUB	R8			; R7 <- vC[Ƃ̊Ԋu (w)
		BMI	GROCK_CRCK_END		; ͈͊O ? [yes->GROCK_CRCK_END]
		FROM	R10
		SUB	R9
		BPL	GROCK_CRCK_END		; ͈͊O ? [yes->GROCK_CRCK_END]
		NOP
;
		LM	R0,CPLYSPD
		SUB	#00
		BMI	GROCK_CRCK_END		; ㏸ ? [yes->GROCK_CRCK_END]
		NOP
;
		FROM	R9
		SUB	R8
		TO	R9
		ADD	R0
		mLDW	R6,DIVBUF,R9
;
		LMS	R8,CWORK1		; RY ()
		LMS	R0,CWORK3		; RY (E)
		SUB	R8
		LOB
		SWAP
		TO	R6
		FMULT
;
		FROM	R7
		LOB
		SWAP
		FMULT
		TO	R8
		ADD	R8
;
		IBT	R6,#020H
		LM	R7,CPLYPSL
		FROM	R7
		ADD	R6
		SUB	R8
		BMI	GROCK_CRCK_END		; ͈͊O ? [yes->GROCK_CRCK_END]
		NOP
;
		MOVE	R8,R0
		SUB	#09
		BPL	GROCK_CRCK_END		; ͈͊O ? [yes->GROCK_CRCK_END]
		NOP
;
		FROM	R7
		SUB	R8
		SM	CPLYPSL,R0		; vC[x|WVZbg !!
		IBT	R0,#01
		SM	CONLFFG,R0
		IWT	R0,#00100H
		SM	CPLYSPD,R0
;
		mLDW	R6,CENWRK4,R1		; pxXs[h̓ǂݍ !!
		mLDW	R7,CENWRK0,R1		; x_w !!
		LM	R0,CPCENTX
		SUB	R7
		DIV2
		DIV2
;[1995.06.14.WE]		DIV2
		NOP
		NOP
		WITH	R6
		ADD	R0
		mSTW	R6,CENWRK4,R1		; pxXs[hZbg
;
		mLDW0	CENCONT,R1		; px̓ǂݍ !!
		HIB
		CMP	R5
		BNE	GROCK_PLHOSE		; pxς ? [yes->GROCK_PLHOSE]
		NOP
;
		IBT	R0,#01
		STOP
		NOP
;
GROCK_CRCK_END
		IBT	R0,#00
		STOP
		NOP
;
GROCK_PLHOSE
		FROM	R5
		NOT
		INC	R0
		TO	R5
		LOB
		IWT	R0,#LCOS
		TO	R14
		ADD	R5
;
		LM	R8,CPLXPSL
		mLDW	R12,CENXPSL,R1
		WITH	R8
		SUB	R12
		LM	R9,CPLYPSL
		mLDW	R13,CENYPSL,R1
		WITH	R9
		SUB	R13
;
		TO	R6			; R6 <- COS DATA
		GETB
		IWT	R0,#LSIN
		TO	R14
		ADD	R5
;
		FROM	R8
		TO	R10
		MULT	R6
		FROM	R9
		TO	R11
		MULT	R6
;
		TO	R7			; R7 <- SIN DATA
		GETB
;
		IWT	R2,#00080H
		FROM	R9
		MULT	R7
		ADD	R10
		ADD	R0
		ADD	R0
		ADD	R2
		HIB
		TO	R10
		SEX				; R10 <- sx * cos + sy * sin
;
		FROM	R8
		MULT	R7
		FROM	R11
		SUB	R0
		ADD	R0
		ADD	R0
		ADD	R2
		HIB
		TO	R11
		SEX				; R11 <- sy * cos - sx * sin
;
		mLDW0	CENCONT,R1
		TO	R5
		HIB
		IWT	R0,#LCOS
		TO	R14
		ADD	R5
		TO	R6			; R6 <- COS DATA
		GETB
		IWT	R0,#LSIN
		TO	R14
		ADD	R5
;
		FROM	R10
		TO	R8
		MULT	R6
		FROM	R11
		TO	R9
		MULT	R6
;
		TO	R7			; R7 <- SIN DATA
		GETB
;
		FROM	R11
		MULT	R7
		ADD	R8
		ADD	R0
		ADD	R0			; <- sx * cos + sy * sin
		ADD	R2
		HIB
		SEX
		ADD	R12
		SM	CPLXPSL,R0
;
		FROM	R10
		MULT	R7
		FROM	R9
		SUB	R0
		ADD	R0
		ADD	R0			; <- sy * cos - sx * sin
		ADD	R2
		HIB
		SEX
		ADD	R13
		SM	CPLYPSL,R0
;
		IBT	R0,#01
		STOP
		NOP
;
;
;----------------------------------------------------------------
;-	炮(Ԃ)					-
;-		ENCONT : px (XX.XX)				-
;-		  WRK0 : x_w					-
;-		  WRK2 : x_x					-
;-		  WRK4 : pxXs[h				-
;-		  WRK6 : ŏ̂w				-
;-		  WRK8 : ŏ̂x				-
;-		  XPSL : G̒Sw				-
;-		  YPSL : G̒Sx				-
;-		 CNTXW : C̒Sw			-
;-		 CNTYW : C̒Sx			-
;-		 WIDEX : w`FbN(a)			-
;-		 WIDEY : x`FbN(S̋)		-
;-								-
;-		CWORK1F <- px				-
;----------------------------------------------------------------
GRCKB_CRCK	EQU	$
		IBT	R0,#BANK LCOS
		ROMB
;
		LM	R1,CENINDX		; R1 <- G̃CfbNX
;
		LMS	R0,CWORK1F
		TO	R5
		HIB				; R5 <- px
;
		IWT	R0,#LCOS
		TO	R14
		ADD	R5
;
		mLDW	R2,CEWIDEX,R1		; R2 <- Ew
		FROM	R2
		NOT
		TO	R3
		ADD	#01			; R3 <- w
		mLDW	R4,CEWIDEY,R1		; R4 <- x
;
		TO	R6			; R6 <- COS DATA
		GETB
		IWT	R0,#LSIN
		TO	R14
		ADD	R5
		TO	R7			; R7 <- SIN DATA
		GETB
;
		FROM	R4
		TO	R8
		MULT	R6			; R8 <- sy * cos
;
		FROM	R4
		TO	R9
		MULT	R7			; R9 <- sy * sin
;
		IWT	R11,#00080H
		FROM	R3
		MULT	R6			; R0 <- sx * cos ()
		ADD	R9
		ADD	R0
		ADD	R0
		ADD	R11
		HIB
		TO	R10
		SEX
		mLDW0	CENXPSL,R1
		ADD	R10
		SMS	CWORK0,R0		; CWORK0 <- RX ()
;
		FROM	R3
		MULT	R7			; R0 <- sx * sin ()
		FROM	R8
		SUB	R0
		ADD	R0
		ADD	R0
		ADD	R11
		HIB
		TO	R10
		SEX
		mLDW0	CENYPSL,R1
		ADD	R10
		SMS	CWORK1,R0		; CWORK1 <- RY ()
;
		FROM	R2
		MULT	R6			; R0 <- sx * cos (E)
		ADD	R9
		ADD	R0
		ADD	R0
		ADD	R11
		HIB
		TO	R10
		SEX
		mLDW0	CENXPSL,R1
		ADD	R10
		SMS	CWORK2,R0		; CWORK2 <- RX (E)
;
		FROM	R2
		MULT	R7			; R0 <- sx * sin (E)
		FROM	R8
		SUB	R0
		ADD	R0
		ADD	R0
		ADD	R11
		HIB
		TO	R10
		SEX
		mLDW0	CENYPSL,R1
		ADD	R10
		SMS	CWORK3,R0		; CWORK3 <- RY (E)
;
		LMS	R8,CWORK0		; RX ()
		LMS	R9,CWORK2		; RX (E)
		LM	R10,CECENTX		; Ԃw
		FROM	R10
		TO	R7
		SUB	R8			; R7 <- ԂƂ̊Ԋu (w)
		BMI	GRCKB_CRCK_END		; ͈͊O ? [yes->GRCKB_CRCK_END]
		FROM	R10
		SUB	R9
		BPL	GRCKB_CRCK_END		; ͈͊O ? [yes->GRCKB_CRCK_END]
		NOP
;
		LM	R0,CENYSPD
		SUB	#00
		BMI	GRCKB_CRCK_END		; ㏸ ? [yes->GRCKB_CRCK_END]
		NOP
;
		FROM	R9
		SUB	R8
		TO	R9
		ADD	R0
		mLDW	R6,DIVBUF,R9
;
		LMS	R8,CWORK1		; RY ()
		LMS	R0,CWORK3		; RY (E)
		SUB	R8
		LOB
		SWAP
		TO	R6
		FMULT
;
		FROM	R7
		LOB
		SWAP
		FMULT
		TO	R8
		ADD	R8
;
		IBT	R6,#020H
		LM	R7,CENYPSL
		FROM	R7
		ADD	R6
		SUB	R8
		BMI	GRCKB_CRCK_END		; ͈͊O ? [yes->GRCKB_CRCK_END]
		NOP
;
		MOVE	R8,R0
		SUB	#09
		BPL	GRCKB_CRCK_END		; ͈͊O ? [yes->GRCKB_CRCK_END]
		NOP
;
		FROM	R7
		SUB	R8
		SM	CENYPSL,R0		; Ԃx|WVZbg !!
		IWT	R0,#00100H
		SM	CENYSPD,R0
;
		mLDW	R6,CENWRK4,R1		; pxXs[h̓ǂݍ !!
		mLDW	R7,CENWRK0,R1		; x_w !!
		LM	R0,CECENTX
		SUB	R7
		WITH	R6
		ADD	R0
		mSTW	R6,CENWRK4,R1		; pxXs[hZbg
;
		mLDW0	CENCONT,R1		; px̓ǂݍ !!
		HIB
		CMP	R5
		BNE	GRCKB_BYHOSE		; pxς ? [yes->GRCKB_BYHOSE]
		NOP
;
		IBT	R0,#01
		STOP
		NOP
;
GRCKB_CRCK_END
		IBT	R0,#00
		STOP
		NOP
;
GRCKB_BYHOSE
		FROM	R5
		NOT
		INC	R0
		TO	R5
		LOB
		IWT	R0,#LCOS
		TO	R14
		ADD	R5
;
		LM	R8,CENXPSL
		mLDW	R12,CENXPSL,R1
		WITH	R8
		SUB	R12
		LM	R9,CENYPSL
		mLDW	R13,CENYPSL,R1
		WITH	R9
		SUB	R13
;
		TO	R6			; R6 <- COS DATA
		GETB
		IWT	R0,#LSIN
		TO	R14
		ADD	R5
;
		FROM	R8
		TO	R10
		MULT	R6
		FROM	R9
		TO	R11
		MULT	R6
;
		TO	R7			; R7 <- SIN DATA
		GETB
;
		IWT	R2,#00080H
		FROM	R9
		MULT	R7
		ADD	R10
		ADD	R0
		ADD	R0			; R10 <- sx * cos + sy * sin
		ADD	R2
		HIB
		TO	R10
		SEX
;
		FROM	R8
		MULT	R7
		FROM	R11
		SUB	R0
		ADD	R0
		ADD	R0			; R11 <- sy * cos - sx * sin
		ADD	R2
		HIB
		TO	R11
		SEX
;
		mLDW0	CENCONT,R1
		TO	R5
		HIB
		IWT	R0,#LCOS
		TO	R14
		ADD	R5
		TO	R6			; R6 <- COS DATA
		GETB
		IWT	R0,#LSIN
		TO	R14
		ADD	R5
;
		FROM	R10
		TO	R8
		MULT	R6
		FROM	R11
		TO	R9
		MULT	R6
;
		TO	R7			; R7 <- SIN DATA
		GETB
;
		FROM	R11
		MULT	R7
		ADD	R8
		ADD	R0
		ADD	R0			; <- sx * cos + sy * sin
		ADD	R2
		HIB
		SEX
		ADD	R12
		SM	CENXPSL,R0
;
		FROM	R10
		MULT	R7
		FROM	R9
		SUB	R0
		ADD	R0
		ADD	R0			; <- sy * cos - sx * sin
		ADD	R2
		HIB
		SEX
		ADD	R13
		SM	CENYPSL,R0
;
		IBT	R0,#01
		STOP
		NOP
;
;
;----------------------------------------------------------------
;-	炮 (MOVE)					-
;-		ENCONT : px (XX.XX)				-
;-		  WRK0 : x_w					-
;-		  WRK2 : x_x					-
;-		  WRK4 : pxXs[h				-
;-		  WRK6 : ŏ̂w				-
;-		  WRK8 : ŏ̂x				-
;-		  XPSL : G̒Sw				-
;-		  YPSL : G̒Sx				-
;-		 CNTXW : C̒Sw			-
;-		 CNTYW : C̒Sx			-
;-		 WIDEX : w`FbN(a)			-
;-		 WIDEY : x`FbN(S̋)		-
;-								-
;----------------------------------------------------------------
GROCK_MOVE	EQU	$
		IBT	R0,#BANK LCOS
		ROMB
;
		LM	R1,CENINDX		; R1 <- G̃CfbNX
;
		mLDW0	CENCONT,R1
		TO	R2
		HIB
		IWT	R0,#LCOS
		TO	R14
		ADD	R2
;
		mLDW	R3,CENWRK6,R1		; {w̓ǂݍ !!
		mLDW	R12,CENWRK0,R1		; x_w̓ǂݍ !!
		WITH	R3
		SUB	R12			; R3 <- w
		mLDW	R4,CENWRK8,R1		; {x̓ǂݍ !!
		mLDW	R13,CENWRK2,R1		; x_x̓ǂݍ !!
		WITH	R4
		SUB	R13			; R4 <- x
;
		TO	R5
		GETB				; R5 <- COS DATA
;
		IWT	R0,#LSIN
		TO	R14
		ADD	R2
;
		FROM	R3
		TO	R8
		MULT	R5			; R8 <- sx * cos
		FROM	R4
		TO	R9
		MULT	R5			; R9 <- sy * cos
;
		TO	R7
		GETB				; R7 <- SIN DATA
;
		IWT	R10,#00080H
		FROM	R4
		MULT	R7			; sy * sin
		ADD	R8
		ADD	R0
		ADD	R0
		ADD	R10
		HIB
		SEX
		TO	R10
		ADD	R12			; R10 <- sx * cos + sy * sin + cx
		mLDW0	CENXPSL,R1
		FROM	R10
		TO	R11
		SUB	R0
		mSTW	R11,CENMOVX,R1		; ړwZ[u !!
		mSTW	R10,CENXPSL,R1		; wZ[u !!
;
		IWT	R10,#00080H
		FROM	R3
		MULT	R7			; sx * sin
		FROM	R9
		SUB	R0
		ADD	R0
		ADD	R0
		ADD	R10
		HIB
		SEX
		TO	R10
		ADD	R13			; R10 <- sy * cos - sx * sin + cy
		mLDW0	CENYPSL,R1
		FROM	R10
		TO	R11
		SUB	R0
		mSTW	R11,CENMOVY,R1		; ړxZ[u !!
		mSTW	R10,CENYPSL,R1		; xZ[u !!
;
		STOP
		NOP
;
;
;--------------------------------------------------------------------------------
;-	̃T[`								-
;-		in :								-
;-			R14 <- ŏ̗̖O(EGG00 ~ EGG09)			-
;-			R11 <- Ō̗̖O(EGG00+1 ~ EGG09+1)		-
;-			R10 <- l CfbNX				-
;-		out :								-
;-			Ƃ	 : (R1) <-  CfbNX		-
;-			ȂƂ : (R1) <-  -1				-
;--------------------------------------------------------------------------------
EX_EGGSEARCH	EQU	$
		IBT	R1,#-1			; (R1) <- h CfbNX
		IWT	R2,#CENMODE		; (R2) <- G[h|C^
		IWT	R3,#CENMYNO		; (R3) <- Gl[|C^
		IWT	R4,#CEMOVE		; (R4) <- l tO
		IBT	R5,#-1			; (R5) <- h w
		IBT	R6,#-1			; (R6) <- h x
		IBT	R7,#00			; (R7) <- h CfbNX
		mLDW	R8,CECENTX,R10		; (R8) <- l w |WV
		mLDW	R9,CECENTY,R10		; (R9) <- l x |WV
;
		CACHE
;
		IBT	R12,#CENNO
		MOVE	R13,R15
;
		LDW	(R2)
		SUB	R4
		BNE	EX_EGGSEARCH080		; Mode Move ? [no->EX_EGGSEARCH080]
		NOP
;
		LDW	(R3)
		CMP	R14
		BCC	EX_EGGSEARCH080		; H [no->EX_EGGSEARCH080]
		NOP
;
		CMP	R11
		BCS	EX_EGGSEARCH080		; H [no->EX_EGGSEARCH080]
		NOP
;
		mLDW0	CENSHOT,R7
		SUB	#00
		BNE	EX_EGGSEARCH080		; VbgH [yes->EX_EGGSEARCH080]
		NOP
;
		mLDB0	CENWRK4,R7
		SEX
		BMI	EX_EGGSEARCH080		; [hH [yes->EX_EGGSEARCH080]
		NOP
;
		mLDW0	CENWRK6,R7
		SUB	#00
		BNE	EX_EGGSEARCH080		; H [yes->EX_EGGSEARCH080]
		NOP
;
		mLDW0	CECENTX,R7
		TO	R10
		SUB	R8
		BPL	EX_EGGSEARCH040		; { [yes->EX_EGGSEARCH040]
		WITH	R10
;
		NOT
		INC	R10
		FROM	R10
EX_EGGSEARCH040
		CMP	R5
		BCS	EX_EGGSEARCH080		; [->EX_EGGSEARCH080]
		NOP
;
		mLDW0	CECENTY,R7
		SUB	R9
		BPL	EX_EGGSEARCH050		; { [yes->EX_EGGSEARCH050]
		NOP
;
		NOT
		INC	R0
EX_EGGSEARCH050
		CMP	R6
		BCS	EX_EGGSEARCH080		; [->EX_EGGSEARCH080]
		NOP
;
		MOVE	R6,R0
		MOVE	R5,R10
		MOVE	R1,R7
EX_EGGSEARCH080
		WITH	R2
		ADD	#04
		WITH	R3
		ADD	#04
		WITH	R7
		ADD	#04
		LOOP
		NOP
;
		STOP
		NOP
;
;------------------------------------------------------------------------
;-		{XJ`J`N̂n`lʒu␳				-
;-			in :						-
;-				(R1) <-- wZl			-
;-				(R2) <-- xZl			-
;-				(R3) <-- n`l|C^[		-
;------------------------------------------------------------------------
BK_OAM_RV	EQU	$
		IBT	R4,#8-2
;
		CACHE
;
		IBT	R12,#29
		MOVE	R13,R15
BK_OAM_RV_010
		LDW	(R3)
		ADD	R1
		SBK			;[ STW (R3) ]
		INC	R3
		INC	R3
		LDW	(R3)
		ADD	R2
		WITH	R3
		ADD	R4
		LOOP
		SBK			;[ STW (R3) ]
;
		STOP
		NOP
;
;
;
;
;
		END
;
;
