;************************************************************************
;*									*
;*	title name	: "yossy"					*
;*	proccess	: mario chip player program			*
;*	file name	: ys_mplay					*
;*									*
;************************************************************************
;
;
		SALL
;
		include		ys_chip.inc
;
		XALL
;
;
;------------------------------------------------------------------------
;-		global symbol						-
;------------------------------------------------------------------------
		GLB	CAR_MV
;
		GLB	M_RAD_GET_S
;
		GLB	M_ANGCKD,M_ATAN,M_TAN
;
;------------------------------------------------------------------------
;-		extern symbol						-
;------------------------------------------------------------------------
;
;-------------< ys_chip0 >-----------------------------------------------
		EXT	COS,SIN,LCOS,LSIN
;
;-------------< ys_msub0 >-----------------------------------------------
		EXT	ENCRDT,ENMODE0,ENMODE1,ENMODE2,ENDATA0,ENDATA1
		EXT	ENCHR_BNK,ETCADR
		EXT	EXMODE0,EXMODE1,EXMODE2,EXDATA0,EXDATA1
		EXT	EXCHR_BNK
		EXT	EN_BGTYPE,SAKA_DATA
;
		EXT	COIN1,COINR,ZFLWR,ZFLW2
;
;
;-------------< GmD >---------------------------------------
;
;-------------< ʂmD >-------------------------------------
;
;-------------< ys_mplay >-----------------------------------------------
		EXT	PL_CALC,XY_CALC,DASH_SMOK_CK
;
		EXT	BG_SIDECK_IN,BG_SIDECK,BG_HDFTCK,FOOT_RESULT
		EXT	BRBG0_SET,BGUNIT_READ_S
		EXT	BG_SIDECK_0000,BG_HDFTCK_0000
;
		EXT	R_32_ZOOM_16,R_32_RTZ_32_XY
;
;-------------< ys_mpldt0 >-----------------------------------------------
		EXT	PLAYER_DATA
;
		EXT	PLBGCK_POINT_CR
;
		EXT	MAX_SPEED,ADD_SPEED,MIN_SPEED,SUB_SPEED,MAX_DASH
		EXT	CAR_MAX_DASH
;
		EXT	CAR_CHAR,CAR_TIRE_XREV
;
;------------------------------------------------------------------------
;-		define symbol						-
;------------------------------------------------------------------------
;
;-------------- afjbgmDobt@AhX ----------------------
CBGUNIT		EQU	7F8000H
;
;
;
;
;************************************************************************
;*									*
;*		program start						*
;*									*
;************************************************************************
;
;
Group_B		GROUP	S_play0
S_play0		SECT	REL
;
;************************************************************************
;*		pxvZpf[^					*
;************************************************************************
M_ANGCKD
;		;[ ???H/2+[XXH] : XXH = NEG flag ]
		WORD	100H/2+8000H,080H/2+0000H,100H/2+0000H,180H/2+8000H
		WORD	000H/2+0000H,080H/2+8000H,200H/2+8000H,180H/2+0000H
;
;************************************************************************
;*		atan data						*
;************************************************************************
M_ATAN
ATAN		EQU	$
		WORD	00000H,00000H,00000H,00000H,00000H,00002H,00002H,00002H
		WORD	00002H,00002H,00002H,00002H,00004H,00004H,00004H,00004H
		WORD	00004H,00004H,00006H,00006H,00006H,00006H,00006H,00006H
		WORD	00008H,00008H,00008H,00008H,00008H,00008H,0000AH,0000AH
		WORD	0000AH,0000AH,0000AH,0000AH,0000AH,0000CH,0000CH,0000CH
		WORD	0000CH,0000CH,0000CH,0000EH,0000EH,0000EH,0000EH,0000EH
		WORD	0000EH,0000EH,00010H,00010H,00010H,00010H,00010H,00010H
		WORD	00012H,00012H,00012H,00012H,00012H,00012H,00012H,00014H
		WORD	00014H,00014H,00014H,00014H,00014H,00014H,00016H,00016H
		WORD	00016H,00016H,00016H,00016H,00018H,00018H,00018H,00018H
		WORD	00018H,00018H,00018H,0001AH,0001AH,0001AH,0001AH,0001AH
		WORD	0001AH,0001AH,0001CH,0001CH,0001CH,0001CH,0001CH,0001CH
		WORD	0001CH,0001EH,0001EH,0001EH,0001EH,0001EH,0001EH,0001EH
		WORD	0001EH,00020H,00020H,00020H,00020H,00020H,00020H,00020H
		WORD	00022H,00022H,00022H,00022H,00022H,00022H,00022H,00022H
		WORD	00024H,00024H,00024H,00024H,00024H,00024H,00024H,00026H
		WORD	00026H,00026H,00026H,00026H,00026H,00026H,00026H,00028H
		WORD	00028H,00028H,00028H,00028H,00028H,00028H,00028H,0002AH
		WORD	0002AH,0002AH,0002AH,0002AH,0002AH,0002AH,0002AH,0002AH
		WORD	0002CH,0002CH,0002CH,0002CH,0002CH,0002CH,0002CH,0002CH
		WORD	0002EH,0002EH,0002EH,0002EH,0002EH,0002EH,0002EH,0002EH
		WORD	0002EH,00030H,00030H,00030H,00030H,00030H,00030H,00030H
		WORD	00030H,00030H,00032H,00032H,00032H,00032H,00032H,00032H
		WORD	00032H,00032H,00032H,00032H,00034H,00034H,00034H,00034H
		WORD	00034H,00034H,00034H,00034H,00034H,00034H,00036H,00036H
		WORD	00036H,00036H,00036H,00036H,00036H,00036H,00036H,00036H
		WORD	00038H,00038H,00038H,00038H,00038H,00038H,00038H,00038H
		WORD	00038H,00038H,00038H,0003AH,0003AH,0003AH,0003AH,0003AH
		WORD	0003AH,0003AH,0003AH,0003AH,0003AH,0003AH,0003CH,0003CH
		WORD	0003CH,0003CH,0003CH,0003CH,0003CH,0003CH,0003CH,0003CH
		WORD	0003CH,0003EH,0003EH,0003EH,0003EH,0003EH,0003EH,0003EH
		WORD	0003EH,0003EH,0003EH,0003EH,0003EH,00040H,00040H,00040H
		WORD	00040H
;
;************************************************************************
;*		tan data [ efini = 7FFF ]				*
;************************************************************************
M_TAN		EQU	$
TAN		EQU	$
		WORD	00000H,00006H,0000CH,00012H,00019H,0001FH,00025H,0002CH
		WORD	00032H,00039H,00040H,00046H,0004DH,00054H,0005BH,00062H
		WORD	0006AH,00071H,00079H,00080H,00088H,00091H,00099H,000A2H
		WORD	000ABH,000B4H,000BDH,000C7H,000D2H,000DCH,000E8H,000F3H
		WORD	00100H,0010CH,0011AH,00128H,00137H,00148H,00159H,0016BH
		WORD	0017FH,00194H,001ABH,001C3H,001DEH,001FCH,0021DH,00241H
		WORD	0026AH,00297H,002CBH,00306H,0034BH,0039DH,003FEH,00474H
		WORD	00506H,005C3H,006BDH,0081BH,00A27H,00D8EH,0145BH,028BCH
		WORD	07FFFH,0D744H,0EBA6H,0F272H,0F5D9H,0F7E5H,0F943H,0FA3DH
		WORD	0FAFAH,0FB8CH,0FC02H,0FC63H,0FCB5H,0FCFAH,0FD35H,0FD69H
		WORD	0FD96H,0FDBFH,0FDE3H,0FE04H,0FE22H,0FE3DH,0FE55H,0FE6CH
		WORD	0FE81H,0FE95H,0FEA7H,0FEB8H,0FEC9H,0FED8H,0FEE6H,0FEF4H
		WORD	0FF01H,0FF0DH,0FF18H,0FF24H,0FF2EH,0FF39H,0FF43H,0FF4CH
		WORD	0FF55H,0FF5EH,0FF67H,0FF6FH,0FF78H,0FF80H,0FF87H,0FF8FH
		WORD	0FF96H,0FF9EH,0FFA5H,0FFACH,0FFB3H,0FFBAH,0FFC0H,0FFC7H
		WORD	0FFCEH,0FFD4H,0FFDBH,0FFE1H,0FFE7H,0FFEEH,0FFF4H,0FFFAH
		WORD	00000H,00006H,0000CH,00012H,00019H,0001FH,00025H,0002CH
		WORD	00032H,00039H,00040H,00046H,0004DH,00054H,0005BH,00062H
		WORD	0006AH,00071H,00079H,00080H,00088H,00091H,00099H,000A2H
		WORD	000ABH,000B4H,000BDH,000C7H,000D2H,000DCH,000E8H,000F3H
		WORD	00100H,0010CH,0011AH,00128H,00137H,00148H,00159H,0016BH
		WORD	0017FH,00194H,001ABH,001C3H,001DEH,001FCH,0021DH,00241H
		WORD	0026AH,00297H,002CBH,00306H,0034BH,0039DH,003FEH,00474H
		WORD	00506H,005C3H,006BDH,0081BH,00A27H,00D8EH,0145BH,028BCH
		WORD	07FFFH,0D744H,0EBA6H,0F272H,0F5D9H,0F7E5H,0F943H,0FA3DH
		WORD	0FAFAH,0FB8CH,0FC02H,0FC63H,0FCB5H,0FCFAH,0FD35H,0FD69H
		WORD	0FD96H,0FDBFH,0FDE3H,0FE04H,0FE22H,0FE3DH,0FE55H,0FE6CH
		WORD	0FE81H,0FE95H,0FEA7H,0FEB8H,0FEC9H,0FED8H,0FEE6H,0FEF4H
		WORD	0FF01H,0FF0DH,0FF18H,0FF24H,0FF2EH,0FF39H,0FF43H,0FF4CH
		WORD	0FF55H,0FF5EH,0FF67H,0FF6FH,0FF78H,0FF80H,0FF87H,0FF8FH
		WORD	0FF96H,0FF9EH,0FFA5H,0FFACH,0FFB3H,0FFBAH,0FFC0H,0FFC7H
		WORD	0FFCEH,0FFD4H,0FFDBH,0FFE1H,0FFE7H,0FFEEH,0FFF4H,0FFFAH
;
;****************************************************************
;*		_̉][`				*
;*								*
;*		R5	]p					*
;*		R7	xW					*
;*		R8	wW					*
;*								*
;****************************************************************
POI_ROT
		SMS	R4,REG4
		SMS	R12,REG12
		SMS	R14,REG14
		SMS	R10,REG10
;
		IBT	R0,#BANK LCOS
		ROMB
;
		WITH	R5
		ADD	R5

		IWT	R0,#SIN
		TO	R14
		ADD	R5

		IWT	R0,#COS
		TO	R10
		ADD	R5

		GETB
		INC	R14
		GETBH
		MOVE	R6,R0

		FROM	R8		;(R12) <-- X * SIN
		LMULT
		WITH	R4
		HIB
		LOB
		SWAP
		TO	R12
		OR	R4

		FROM	R7		;(R5) <--  Y * SIN
		LMULT
		WITH	R4
		HIB
		LOB
		SWAP
		TO	R5
		OR	R4

		MOVE	R14,R10

		GETB
		INC	R14
		GETBH
		MOVE	R6,R0

		FROM	R8		;(R8) <-- X * COS - Y * SIN
		LMULT
		WITH	R4
		HIB
		LOB
		SWAP
		OR	R4
		TO	R8
		SUB	R5

		FROM	R7		;(R7) <-- X * SIN + Y * COS
		LMULT
		WITH	R4
		HIB
		LOB
		SWAP
		OR	R4
		TO	R7
		ADD	R12

		IBT	R0,#BANK PLAYER_DATA
		ROMB
;
		LMS	R10,REG10
		LMS	R12,REG12
		LMS	R14,REG14
		LMS	R4,REG4
		mRTS
;
;****************************************************************
;*		pxvZ[`				*
;****************************************************************
;[IN]
;		R1	wiQoCgj
;		R2	xiQoCgj
;[OUT]
;		R0	pxiO[Pedgj
;		R1	pxiO[Oeegj
;
M_RAD_GET_S	EQU	$
		IBT	R0,#BANK M_ANGCKD
		ROMB

		SMS	R11,CWORK1C
		SMS	R5,CWORK1D
		SMS	R9,CWORK1E
		SMS	R10,CWORK1F

		IWT	R9,#M_ATAN
		IWT	R10,#M_ANGCKD

		IWT	R5,#DIVBUF
		IWT	R7,#(0100H*2)
		IWT	R8,#001FEH

		WITH	R3
		SUB	R3

		MOVES	R6,R1
		BPL	M_R_G0100
		NOP

		IBT	R3,#004
		FROM	R1
		TO	R6
		NOT
		INC	R6

M_R_G0100
		MOVES	R0,R2
		BPL	M_R_G0200
		NOP

		INC	R3
		INC	R3

		FROM	R2
		NOT
		INC	R0

M_R_G0200
		CMP	R6
		BPL	M_R_G0300
		INC	R3

		DEC	R3
		MOVE	R4,R0
		MOVE	R0,R6
		MOVE	R6,R4

M_R_G0300
		ADD	R0
		ADD	R5
		LDW	(R0)
		LMULT
		WITH	R4
		HIB
		LOB
		SWAP
		OR	R4
		ADD	R0
		CMP	R7
		BCC	M_R_G0400
		NOP

		IWT	R0,#(0100H-1)*2

M_R_G0400
		TO	R14
		ADD	R9

		GETB
		INC	R14
		GETBH
		MOVE	R4,R0

		WITH	R3
		ADD	R3

		FROM	R10
		TO	R14
		ADD	R3

		GETB
		INC	R14
		GETBH

		ADD	R0
		BCC	M_R_G0500
		NOP

		WITH	R4
		NOT
		INC	R4

M_R_G0500
		ADD	R4
		AND	R8
		TO	R1
		LSR

		LMS	R9,CWORK1E
		LMS	R10,CWORK1F

		LMS	R11,CWORK1C
		WITH	R11
		ADD	#03
		LMS	R8,CWORK1D

		FROM	R11
		LJMP	R8
		NOP

;;;;;;;;		mRTS
;
M_RAD_GET	EQU	$
		IWT	R0,#M_RAD_GET_S
		IBT	R8,#BANK M_RAD_GET_S
		IBT	R5,#BANK M_RAD_GET
		MOVE	R11,R15
		LJMP	R8
		NOP
;;;;;;;;		mJSR	M_RAD_GET_S

		STOP
		NOP
;
;************************************************************************
;*									*
;*		܁@悵						*
;*									*
;************************************************************************
CAR_MV
;
;------------------------------------------------------------------------
;-		ړTEhZbg					-
;------------------------------------------------------------------------
		LMS	R0,CPLMVSP
		DEC	R0
		BPL	CAR_SUB0100
		INC	R0
;
		NOT
		INC	R0
CAR_SUB0100
		HIB
		TO	R1		;[ * not break (R0) ]
		SUB	#4
		BCC	CAR_SUB0200	;Xs[hI[o[H ( no:CAR_SUB0200 )
		NOP
;
		IBT	R0,#3
CAR_SUB0200
		IBT	R1,#01000100B
		OR	R1
		SMS	R0,CMSOUND1
;
		LMS	R0,CPLBGCR
		AND	#000001111B
		SMS	R0,CCARWK0
		LMS	R0,CPLCMKI
		SMS	R0,CCARWK1

		SUB	R0
		SMS	R0,CRAMCK0
		SMS	R0,CRAMCK1
		SMS	R0,CRAMCK2
		SMS	R0,CRAMCK3
		SMS	R0,CRAMCK4
;
		mJSR	PL_CALC		;WvZ
;
		mJSR	CR_BGCK		;af`FbN
;
		mJSR	CR_KEY		;Rg[[
;
		mJSR	CR_PATN		;p^[mDZbg
;
		IBT	R5,#060H
		LMS	R1,CPLBGCR
		FROM	R1
		AND	R5
		BEQ	CAR_SUB0300	;VɂԂ? ( no:CAR_SUB0300 )
		NOP

		FROM	R1
		AND	#00001111B
		BEQ	CAR_SUB0300	;nʂɒĂ? ( no:CAR_SUB0300 )
		NOP

		IWT	R5,#000A0H
		LMS	R0,CCARZOM
		CMP	R5
		BMI	CAR_SUB0400	;
		NOP

		SUB	#008
		CMP	R5
		BPL	CAR_SUB0400	;
		DEC	R5

		WITH	R5		;[ MOVE R0,R5 ]
		BRA	CAR_SUB0400
		TO	R0

CAR_SUB0300
		IWT	R5,#00100H
		LMS	R0,CCARZOM
		CMP	R5
		BPL	CAR_SUB0400
		NOP

		ADD	#008
		CMP	R5
		BMI	CAR_SUB0400
		NOP

		MOVE	R0,R5

CAR_SUB0400
		SBK

CAR_SUB0500
		SUB	R0
		MOVE	R3,R0		;(R3)  <-- rbg}bvWQwZbg
		IBT	R0,#020H	;
		MOVE	R2,R0		;(R2)  <--	h	 @QxZbg
		IWT	R6,#00100H	;(R6)  <-- {
		LMS	R4,CCARZOM	;(R11) <-- c@h
		LMS	R5,CCARANG	;(R5)  <-- ]p

		LMS	R0,CCARBDY
		LOB
		BEQ	CAR_SUB0700	;{fB[LŒ? ( no:CAR_SUB0700 )
		NOP

		IWT	R12,#CIPCHD2+4020H+001
		IBT	R13,#BANK CIPCHD2+4020H+001
		BRA	CAR_SUB0800
		NOP

CAR_SUB0700
		LMS	R0,CPLWALK
		IWT	R14,#CAR_CHAR
		WITH	R14
		ADD	R0
		GETB
		INC	R14
		GETBH
		MOVE	R12,R0				;LN^[AhXikCgj

		IBT	R13,#BANK CIPCHD+60A0H+000	;LN^[AhXiaj

CAR_SUB0800
		mJSR	R_32_RTZ_32_XY

		LMS	R0,CCARWK1
		LMS	R1,CPLCMKI
		CMP	R1
		BEQ	CAR_SUB0880
		NOP

		LMS	R0,CCARANG	;px␳
		SEX
		NOT
		INC	R0
		LOB
		SBK

CAR_SUB0880
		IBT	R0,#BANK PLBGCK_POINT_CR
		ROMB
;
		IWT	R0,#PLBGCK_POINT_CR
		TO	R2
		ADD	#00EH				;`FbNf[^

		LMS	R0,CPLCMKI
		ADD	R0
		IWT	R1,#CAR_TIRE_XREV
		TO	R1
		ADD	R1
;
		IWT	R3,#CPLLFTX
		IWT	R4,#CPLLFTY
;
		LMS	R9,CPLXPSL
		LMS	R10,CPLYPSL
;
		IBT	R12,#03
		CACHE
		MOVE	R13,R15

		MOVE	R14,R1
		TO	R6
		GETBS
		INC	R1

		MOVE	R14,R2
		GETBS
		TO	R8
		ADD	R6
		INC	R14
		INC	R2
		INC	R2
		TO	R7
		GETBS

		LMS	R5,CPLANGL

		mJSR	POI_ROT

		FROM	R8
		ADD	#08
		ADD	R9
		STW	(R3)

		IBT	R6,#018H
		FROM	R7
		ADD	R6
		ADD	R10
		STW	(R4)

		INC	R3
		INC	R3
		INC	R4

		LOOP
		INC	R4
;
;
		LMS	R0,CPLXPSL
		SMS	R0,CCARWK1

		IBT	R0,#01
		SMS	R0,CRAMCK0

		LMS	R2,CPLBGCR
		mJSR	CR_TIRE_BGCK

		LMS	R1,CCARWK1
		LMS	R0,CPLXPSL
		TO	R1
		SUB	R1

		IWT	R3,#CPLLFTX
		IBT	R12,#03
		CACHE
		MOVE	R13,R15

		LDW	(R3)
		ADD	R1
		SBK

		INC	R3

		LOOP
		INC	R3

		LMS	R0,CPLYPSL
		SMS	R0,CPLYPSV

;;;;		    IWT	    R1,#000A7H
		IBT	R1,#00067H
		LMS	R0,CPLFLSH
		SUB	R1
		BEQ	CAR_SUB0900+1	;vC[_[W? ( yes:CAR_SUB0900 )
		SUB	R0

		LMS	R0,CCARYSW
		LOB
		BEQ	CAR_SUB0900+1	;LтĂ? ( no:CAR_SUB0900 )
		NOP

;;;;;;;;		mJSR	CAR_COUNT_UP
		mJSR	CAR_COIN_GET

CAR_SUB0900
		SUB	R0		;<<< end >>>
		STOP
		NOP
;
;************************************************************************
;*									*
;*		af`FbN						*
;*									*
;************************************************************************
;
CR_BGCK
		SMS	R11,RTS2	;[ return address save ]
;
		IWT	R14,#PLBGCK_POINT_CR ;(R14) <-- af`FbN|Cgf[^|C^[
		LMS	R9,CPLXPSL	     ;(R9)  <-- vC[wW
		LMS	R10,CPLYPSL	     ;(R10) <--	     h	  x h
		IBT	R2,#00		     ;(R2)  <-- aftONA[
		SMS	R2,CPLWATR	     ;tONA[
		SMS	R2,CPLTNEL	     ;gltONA[
		SMS	R2,CPLBGNO	     ;Ă鏰̂af^CvNA[
		SMS	R2,CPLKAID	     ;KitONA[
;
;------------------------------------------------------------------------
;-		TCh`FbN					-
;------------------------------------------------------------------------
		IBT	R3,#001H	;(R3) <-- ␳
		MOVE	R4,R3		;(R4) <-- ␳f[^
		SUB	R0
		mJSR_X	CR_SIDECK_IN
		CACHE

		FROM	R2		;for [ PLBGCR ]
		TO	R6		;	"
		AND	#01		;	"
		FROM	R2		;	"
		ADD	R2		;	"
		TO	R2		;	"
		OR	R6		;	"
;
;------------------------------------------------------------------------
;-		TCh`FbN					-
;------------------------------------------------------------------------
		SUB	R0
		mJSR_X	CR_SIDECK+1
		HEX	3E

		FROM	R2		;for [ PLBGCR ]
		TO	R6		;	"
		AND	#01		;	"
		FROM	R2		;	"
		ADD	R2		;	"
		TO	R2		;	"
		OR	R6		;	"
;
;------------------------------------------------------------------------
;-		ETCh`FbN					-
;------------------------------------------------------------------------
		IBT	R3,#0FFH	;(R3) <-- ␳f[^
		DEC	R4		;[ CMP #0 ]
		BMI	CR_BGCK_0010	;TCh␳H ( yes:CR_BGCK_0010 )
		INC	R4
;
		MOVE	R4,R3		;(R4) <-- ␳f[^
CR_BGCK_0010
		IBT	R0,#0FFH
		mJSR_X	CR_SIDECK+1
		HEX	3E		;[ SMS R11,RTS1 ]

		FROM	R2		;for [ PLBGCR ]
		TO	R6		;	"
		AND	#01		;	"
		FROM	R2		;	"
		ADD	R2		;	"
		TO	R2		;	"
		OR	R6		;	"
;
;------------------------------------------------------------------------
;-		ETCh`FbN					-
;------------------------------------------------------------------------
		IBT	R0,#0FFH
		mJSR_X	CR_SIDECK+1
		HEX	3E

		FROM	R2		;for [ PLBGCR ]
		TO	R6		;	"
		AND	#01		;	"
		FROM	R2		;	"
		ADD	R2		;	"
		TO	R2		;	"
		OR	R6		;	"
;
;------------------------------------------------------------------------
;-		TCh`FbN					-
;------------------------------------------------------------------------
		SUB	R0		;[ IBT R0,#0 ]
		SMS	R0,CPSPUSH	;ǉJE^[Zbg
;
		MOVES	R0,R1
		BEQ	CR_BGCK_0040	;njH ( no:CR_BGCK_0040 )
		LSR
;
		LSR
		OR	R1
		MOVE	R5,R0
		LSR
		LSR
		LSR
		LSR
		OR	R5
		AND	#03
		DEC	R0
		BNE	CR_BGCK_0030	;Xs[ho߂ĂH ( yes:CR_BGCK_0030 )
		SUB	R0
;
		SMS	R0,CPLXSPD
		SMS	R0,CPLMVSP
;
		FROM	R1
		AND	#0FH
		BEQ	CR_BGCK_0018	;H ( yes:CR_BGCK_0018 )
		INC	R9
;
		DEC	R9
		DEC	R9
CR_BGCK_0018
;
;-------------- ǉ`FbN --------------------------------
		LMS	R0,CPLJUMP
		SUB	#0
		BNE	CR_BGCK_0040	;WvH ( yes:CR_BGCK_0040 )
		NOP
;
		FROM	R1
		AND	#0FH
		BEQ	CR_BGCK_0020	;H ( yes:CR_BGCK_0020 )
		INC	R0		;[ IBT R0,#01H ]
;
		SUB	R0		;[ IBT R0,#0 ]
CR_BGCK_0020
		INC	R0		;[ :00000010B E:00000001B ]
;
		LM	R5,CMKEYC1	;(R5) <-- Rg[[
		AND	R5
		BEQ	CR_BGCK_0040	;ǉL[́H ( no:CR_BGCK_0040 )
		NOP
;
;-------------- ǉJE^[Zbg ----------------
		SMS	R0,CPSPUSH	;ǉJE^[Zbg
		BRA	CR_BGCK_0040
		NOP
;
;-------------- vC[˕Ԃ ----------------------
CR_BGCK_0030
		LMS	R0,CPLXSPD	;vC[Xs[h]
		NOT
		INC	R0
;;;;;;;;		DIV2
		DIV2
		DIV2
		SBK			;[ SMS R0,CPLXSPD ] vC[wXs[hZbg
		SMS	R0,CPLMVSP
		BMI	CR_BGCK_0032
		ADD	R0
;
		NOT
		INC	R0
CR_BGCK_0032
		ADD	R0
		SMS	R0,CPLYSPD	;vC[xXs[hZbg

		IBT	R0,#047H	;mn
		SMS	R0,CMSOUND3
;
		IBT	R0,#020H
		SMS	R0,CTILTCT
;
;------------------------------------------------------------------------
;-		`FbN						-
;------------------------------------------------------------------------
CR_BGCK_0040
		IBT	R1,#00
		IBT	R3,#010H	;(R3) <-- `FbNtO
		mJSR_X	CR_HEADCK+1
		HEX	3E		;[ SMS R11,RTS1 ]
;
;------------------------------------------------------------------------
;-		`FbN						-
;------------------------------------------------------------------------
		IBT	R1,#00
		mJSR_X	CR_HEADCK+1
		HEX	3E		;[ SMS R11,RTS1 ]

		FROM	R2		;for [ PLBGCR ]
		TO	R6		;	"
		AND	#01		;	"
		FROM	R2		;	"
		ADD	R2		;	"
		TO	R2		;	"
		OR	R6		;	"
;
;------------------------------------------------------------------------
;-		E`FbN						-
;------------------------------------------------------------------------
		IBT	R1,#00
		mJSR_X	CR_HEADCK+1
		HEX	3E		;[ SMS R11,RTS1 ]
;
;------------------------------------------------------------------------
;-		`FbN						-
;------------------------------------------------------------------------
		FROM	R2
		AND	#00001111B
		BEQ	CR_BGCK_0050	;H ( no:CR_BGCK_0050 )
		NOP
;
;-------------- af --------------------------------------------
		INC	R10		;xW␳
;
		LMS	R0,CPLYSPD
		SUB	#0
		BPL	CR_BGCK_0050	;vC[~H ( yes:CR_BGCK_0050 )
		SUB	R0
;
		SBK			;[ SMS R0,PLYSPD ]
		SMS	R0,CPLSPJP	;W^o^Wv Zbg
;
		IBT	R0,#0AH		;[]
		SMS	R0,CMSOUND3
;
;------------------------------------------------------------------------
;-		`FbN						-
;------------------------------------------------------------------------
CR_BGCK_0050
		IBT	R3,#0F0H	;(R3) <-- `FbNtO
		LMS	R4,CPLSKCL	;(R4) <-- OtO
		mJSR_X	CR_FOOTCK+1
		HEX	3E		;[ SMS R11,RTS1 ]
;
;-------------- ̂af`FbNۑ ----------------------
		LMS	R0,CWORK8	;(CWKC) <-- ړpx
		SMS	R0,CWORKC
		SMS	R0,CPLSKCL	;OtOZbg
		SMS	R1,CWORKD	;(CWKD) <-- ␳l
;
		LMS	R0,CWORK0	;(CWKA) <-- af`FbNwW
		SMS	R0,CWORKA
		LMS	R0,CWORK1	;(CWKB) <-- af`FbNxW
		SMS	R0,CWORKB
;
;------------------------------------------------------------------------
;-		`FbN						-
;------------------------------------------------------------------------
		LMS	R4,CPLSKCC	;(R4) <-- OtO
		mJSR_X	CR_FOOTCK+1
		HEX	3E		;[ SMS R11,RTS1 ]
;
;-------------- ̂af`FbNۑ ----------------------
		LMS	R0,CWORK8	;(CWK10) <-- ړpx
		SMS	R0,CWORK10
		SMS	R0,CPLSKCC	;OtOZbg
		SMS	R1,CWORK11	;(CWK11) <-- ␳l
;
		LMS	R0,CWORK0	;(CWKE) <-- af`FbNwW
		SMS	R0,CWORKE
		LMS	R0,CWORK1	;(CWKF) <-- af`FbNxW
		SMS	R0,CWORKF
;
		FROM	R2		;for [ PLBGCR ]
		TO	R6		;	"
		AND	#01		;	"
		FROM	R2		;	"
		ADD	R2		;	"
		TO	R2		;	"
		OR	R6		;	"
;
;------------------------------------------------------------------------
;-		E`FbN						-
;------------------------------------------------------------------------
		LMS	R4,CPLSKCR	;(R4) <-- OtO
		mJSR_X	CR_FOOTCK+1
		HEX	3E		;[ SMS R11,RTS1 ]
;
;-------------- Êaf`FbNۑ ----------------------
		LMS	R0,CWORK8	;(CWK17) <-- Eړpx
		SMS	R0,CWORK17
		SMS	R0,CPLSKCR	;OtOZbg
		SMS	R1,CWORK18	;(CWK18) <-- E␳l
;
		LMS	R0,CWORK0	;(CWK15) <-- af`FbNwW
		SMS	R0,CWORK15
		LMS	R0,CWORK1	;(CWK16) <-- af`FbNxW
		SMS	R0,CWORK16
;
;------------------------------------------------------------------------
;-		af`FbN					-
;------------------------------------------------------------------------
		SMS	R2,REG2
		LMS	R0,CCARANG
		SMS	R0,REG0
;
		FROM	R2		;Ă ?
		AND	#00001111B	;
		BEQ	CR_BGCK_0178	;  no: CR_BGCK_0178
		NOP

		IWT	R0,#00100H
		SMS	R0,CPLYSPD

		FROM	R2
		AND	#00000110B
		BEQ	CR_BGCK_0170	;nʂɒĂ? ( no:CR_BGCK_0170 )
		FROM	R2

		BRA	CR_BGCK_0450
		NOP

CR_BGCK_0170
		AND	#00001001B
		BNE	CR_BGCK_0200	;Eǂ炩nʂɒĂ? ( yes:CR_BGCK_0200 )
		NOP
;
;-------------- tgĂ邩H`FbN ------------------------------
CR_BGCK_0178
		LMS	R0,CONLFFG
		SUB	#0
		BEQ	CR_BGCK_0180	;tgĂH ( no:CR_BGCK_0180 )
		SUB	R0
;
		SMS	R0,CPLANGL	;ړpxZbg
		SMS	R0,CCARANG	;\pxZbg

		mDJMP	CR_BGCK_0700
;
;-------------- afĖ ----------------------------------------
CR_BGCK_0180
;;;;;;;;		LMS	R0,CPLJUMP
;;;;;;;;		SUB	#0
;;;;;;;;		BNE	CR_BGCK_0190	;vC[WvH ( yes:CR_BGCK_0190 )
;;;;;;;;		NOP
;
		IWT	R0,#P008	;WvtOhnmh
		SMS	R0,CPLJUMP
CR_BGCK_0190
		mDJMP	CR_BGCK_0800
;
;-------------- af ----------------------------------------------
CR_BGCK_0200
		SUB	#00001001B
		BEQ	CR_BGCK_0400	;EnʂɒĂ? ( YES:CR_BGCK_0400 )
		NOP

		mDJMP	CR_BGCK_0500
;
;-------------- E --------------
CR_BGCK_0400
		LMS	R0,CPLRFTX	;(CWK1C) <-- EwW
		SMS	R0,CWORK1C
		LMS	R1,CPLRFTY	;(CWK1D) <-- ExW
		SMS	R1,CWORK1D
		LMS	R0,CPLLFTX	;(CWK1E) <-- wW
		SMS	R0,CWORK1E
		LMS	R0,CPLLFTY	;(CWK1F) <-- xW
		SMS	R0,CWORK1F
;
		LMS	R0,CWORK18	;(R0) <-- E␳l
		mJSR	CR_ANG_POS_CALC

		mDJMP	CR_BGCK_0700
;
;--------------  --------------
CR_BGCK_0450
		IBT	R0,#01
		SMS	R0,CCARBGF
;
		LMS	R0,CPLANSV
		SMS	R0,CCARSKV
;
		LMS	R0,CWORKE
		SMS	R0,CWORK0	;(CWK0) <-- af`FbNwW
		LMS	R0,CWORKF
		SMS	R0,CWORK1	;(CWK1) <-- af`FbNxW
;
		LMS	R0,CWORKE	;`FbNwW
		LMS	R1,CWORK10	;ړpx
;
		LMS	R2,CPLXSPD
		WITH	R2
		SUB	#0
		BNE	CR_BGCK_0460	;Ă? ( yes:CR_BGCK_0460 )
		NOP

		LMS	R2,CPLCMKI
		WITH	R2
		LOB
		BNE	CR_BGCK_0470	;? ( yes:CR_BGCK_0470 )
		NOP

CR_BGCK_0460
		BMI	CR_BGCK_0470	;ɓĂ? ( yes:CR_BGCK_0470 )
		NOP

		mJSR	CR_ANG_CALC_R
		BRA	CR_BGCK_0480
		NOP

CR_BGCK_0470
		mJSR	CR_ANG_CALC_L
;
CR_BGCK_0480
		LMS	R0,CWORK11
		mDJMP_X CR_BGCK_05A0
		TO	R10
;
;-------------- Б --------------
CR_BGCK_0500
		IWT	R12,#00080H
		IWT	R13,#00100H
		FROM	R2
		AND	#00001000B
		BEQ	CR_BGCK_0550	;Eŕ␳? ( yes:CR_BGCK_0550 )
		SUB	R0
;
		LMS	R0,CWORKA
		SMS	R0,CWORK0	;(CWK0) <-- af`FbNwW
		LMS	R0,CWORKB
		SMS	R0,CWORK1	;(CWK1) <-- af`FbNxW
;
		LMS	R1,CWORKC	;ړpx
		LMS	R0,CCARBGF
		LOB
		BEQ	CR_BGCK_0509	;O͒Ń`FbNĂ? ( no:CR_BGCK_0509 )
		NOP

		LMS	R0,CCARSKV
		CMP	R1
		BNE	CR_BGCK_0508	;px? ( no:CR_BGCK_0508 )
		NOP

		SUB	#0
		BNE	CR_BGCK_0540	;n? ( no:CR_BGCK_0540 )
		SUB	R0

		LMS	R0,CPLXSPD
		ADD	R12
		CMP	R13
		BCS	CR_BGCK_0507	;Xs[h̏o߂? ( yes:CR_BGCK_0507 )
		NOP

		LMS	R0,CWORKE
		AND	#00FH
		TO	R12
		SUB	#03
		BMI	CR_BGCK_0507	;o߂? ( no:CR_BGCK_0507 )
		INC	R12

		WITH	R10
		ADD	R12
		INC	R10

		SUB	R0
		IBT	R1,#004
		MOVE	R13,R15

		SUB	R1

		LOOP
		WITH	R0

		TO	R1		;[ MOVE R1,R0 ]

CR_BGCK_0507
		LMS	R0,CWORKD
		BRA	CR_BGCK_0540
		NOP

CR_BGCK_0508
		SUB	R0
		SMS	R0,CCARBGF
		SMS	R1,CCARSKV

CR_BGCK_0509
		LMS	R0,CWORKA	;`FbNwW
;
		LMS	R2,CPLXSPD
		WITH	R2
		SUB	#0
		BNE	CR_BGCK_0510	;Ă? ( yes:CR_BGCK_0510 )
		NOP

		LMS	R2,CPLCMKI
		WITH	R2
		LOB
		BNE	CR_BGCK_0530	;? ( yes:CR_BGCK_0530 )
		NOP

CR_BGCK_0510
		BMI	CR_BGCK_0530	;ɓĂ? ( yes:CR_BGCK_0530 )
		NOP

CR_BGCK_0520
		mJSR	CR_ANG_CALC_R
		BRA	CR_BGCK_0540
		SUB	R0

CR_BGCK_0530
		mJSR	CR_ANG_CALC_L
		SUB	R0
;
CR_BGCK_0540
;;;;;;;;		LMS	R0,CWORKD
		BRA	CR_BGCK_05A0
		TO	R10

CR_BGCK_0550
		LMS	R1,CWORK17	;Eړpx
		LMS	R0,CCARBGF
		LOB
		BEQ	CR_BGCK_0559	;O͒Ń`FbNĂ? ( no:CR_BGCK_0559 )
		NOP

		LMS	R0,CCARSKV
		CMP	R1
		BNE	CR_BGCK_0558	;px? ( no:CR_BGCK_0558 )
		NOP

		SUB	#0
		BNE	CR_BGCK_0590	;n? ( no:CR_BGCK_0590 )
		SUB	R0

		LMS	R0,CPLXSPD
		ADD	R12
		CMP	R13
		BCS	CR_BGCK_0557	;Xs[h̏o߂? ( yes:CR_BGCK_0557 )
		NOP

		LMS	R0,CWORKE
		AND	#00FH
		SUB	#00DH
		BPL	CR_BGCK_0557	;o߂? ( no:CR_BGCK_0557 )
		TO	R12

		NOT
		INC	R12
		WITH	R10
		ADD	R12
		INC	R10

		SUB	R0
		IBT	R1,#004
		MOVE	R13,R15

		ADD	R1

		LOOP
		WITH	R0

		TO	R1		; [ MOVE R1,R0 ]

CR_BGCK_0557
		LMS	R0,CWORK18
		BRA	CR_BGCK_0590
		NOP

CR_BGCK_0558
		SUB	R0
		SMS	R0,CCARBGF
		SMS	R1,CCARSKV

CR_BGCK_0559
		LMS	R0,CWORK15	;`FbNwW
;
		LMS	R2,CPLXSPD
		WITH	R2
		SUB	#0
		BNE	CR_BGCK_0560	;Ă? ( yes:CR_BGCK_0560 )
		NOP

		LMS	R2,CPLCMKI
		WITH	R2
		LOB
		BNE	CR_BGCK_0580	;? ( yes:CR_BGCK_0580 )
		NOP

CR_BGCK_0560
		BMI	CR_BGCK_0580	;ɓĂ? ( yes:CR_BGCK_0580 )
		NOP

CR_BGCK_0570
		mJSR	CR_ANG_CALC_R
		BRA	CR_BGCK_0590
		SUB	R0

CR_BGCK_0580
		mJSR	CR_ANG_CALC_L
		SUB	R0
;
CR_BGCK_0590
;;;;;;;;		LMS	R0,CWORK18
		TO	R10

CR_BGCK_05A0
		ADD	R10
;
		FROM	R1
		TO	R2
		LOB
		SMS	R2,CPLANGL

		LMS	R0,CPLCMKI
		LOB
		BNE	CR_BGCK_0600
		FROM	R1

		NOT
		INC	R0
		TO	R2
		LOB

CR_BGCK_0600
		SMS	R2,CCARANG
;
;-------------- njaf`FbN ------------------
		mJSR	FOOT_RESULT
;
CR_BGCK_0700
		LMS	R2,REG2

		SUB	R0		;OtOZbg
		SMS	R0,CPLSKCL
		SMS	R0,CPLSKCC
		SMS	R0,CPLSKCR
;
;-------------- n̏uԃ`FbN ------------------------------
		LMS	R0,CPLJUMP
		SUB	#0
		BEQ	CR_BGCK_0770	;n̏uԁH ( no:CR_BGCK_0770 )
		SUB	R0
;
		SMS	R0,CPLJUMP	;WvtOhneeh
		SMS	R0,CPLSPJP	;W^o^WvtOZbg
		LMS	R0,CPLXSPD
		SMS	R0,CPLMVSP	;ړXs[hZbg
;
CR_BGCK_0770
;
;-------------- _bVyނZbg`FbN ------------------
;;;;;;;;		mJSR	DASH_SMOK_CK
;
CR_BGCK_0800
		SMS	R9,CPLXPSL
		SMS	R10,CPLYPSL
		SMS	R2,CPLBGCR
		FROM	R2
		AND	#00001111B
		SMS	R0,CPLBGSV
;
		LMS	R11,RTS2	;[ return address load ]
		mRTS
;
;****************************************************************
;*								*
;*		LтƂ̃^C̃TCh`FbN		*
;*								*
;*	[In]							*
;*		R2	PLBGCR					*
;*		R9	PLXPSL					*
;*		R10	PLYPSL					*
;*								*
;****************************************************************
CR_TIRE_BGCK
		SMS	R11,RTS6	;[ return address save ]
;
		LMS	R0,CPLFTLN
		LOB
		BEQ	CR_T_BGCK0100	;LтĂ? ( no:CR_T_BGCK0100 )
		NOP
;
		IWT	R1,#0FF00H
		FROM	R2
		AND	R1
		BEQ	CR_T_BGCK0200	;łɃTChĂ? ( no:CR_T_BGCK0200 )
		NOP

CR_T_BGCK0100
		mRTS
;
;------------------------------------------------------------------------
;-		^CTCh`FbN					-
;------------------------------------------------------------------------
CR_T_BGCK0200
		IBT	R2,#0
;
		IBT	R3,#001H	;(R3) <-- ␳
		MOVE	R4,R3		;(R4) <-- ␳f[^
;
		LMS	R0,CPLLFTX
		TO	R8
		SUB	#04
		LMS	R5,CPLFTLN
		LMS	R0,CPLLFTY
		SUB	#08
		ADD	R5
		TO	R7
		ADD	R0

		mJSR_X	CR_T_SIDECK_IN
		CACHE

		FROM	R2		;for [ PLBGCR ]
		TO	R6		;	"
		AND	#01		;	"
		FROM	R2		;	"
		ADD	R2		;	"
		OR	R6		;	"
		ADD	R0		;	"
		OR	R6		;	"
		ADD	R0		;	"
		TO	R2		;	"
		OR	R6		;	"
;
;------------------------------------------------------------------------
;-		E^CTCh`FbN					-
;------------------------------------------------------------------------
		IBT	R3,#0FFH	;(R3) <-- ␳f[^
		DEC	R4		;[ CMP #0 ]
		BMI	CR_T_BGCK_0300	;TCh␳H ( yes:CR_T_BGCK_0300 )
		INC	R4
;
		MOVE	R4,R3		;(R4) <-- ␳f[^
CR_T_BGCK_0300
		LMS	R0,CPLRFTX
		TO	R8
		ADD	#04
		LMS	R5,CPLFTLN
		LMS	R0,CPLRFTY
		SUB	#08
		ADD	R5
		TO	R7
		ADD	R0

		mJSR_X	CR_T_SIDECK+1
		HEX	3E

		FROM	R2		;for [ PLBGCR ]
		TO	R6		;	"
		AND	#01		;	"
		FROM	R2		;	"
		ADD	R2		;	"
		OR	R6		;	"
		ADD	R0		;	"
		OR	R6		;	"
		ADD	R0		;	"
		TO	R2		;	"
		OR	R6		;	"
;
;------------------------------------------------------------------------
;-		TCh`FbN					-
;------------------------------------------------------------------------
		MOVES	R0,R1
		BEQ	CR_T_BGCK_0800	;njH ( no:CR_T_BGCK_0800 )
		NOP
;
		SUB	R0
		SMS	R0,CPLXSPD
		SMS	R0,CPLMVSP
;
		FROM	R1
		AND	#03H
		BEQ	CR_T_BGCK_0800	;H ( yes:CR_T_BGCK_0800 )
		INC	R9
;
		DEC	R9
		DEC	R9
;
CR_T_BGCK_0800
		WITH	R2
		SWAP
		LMS	R0,CPLBGCR
		OR	R2
		SBK
;
		SMS	R9,CPLXPSL
;
		LMS	R11,RTS6

		mRTS
;
;****************************************************************
;*		^CTCh`FbN				*
;****************************************************************
CR_T_SIDECK_IN
		IBT	R1,#0		;(R1) <-- afnjtO
;
CR_T_SIDECK
		SMS	R11,RTS1	;[ return address save ]
;
		WITH	R2		;[ ASL R2 ]
		ADD	R2
		WITH	R1		;[ ASL R1 ]
		ADD	R1
		WITH	R1		;[ ASL R1 ]
		ADD	R1
;
;-------------- af`FbN --------------------------------------
		FROM	R7
		LSR
		mJSR_X	BGUNIT_READ_S+1
		HEX	3D		;[ LMS R6,CBG2OF_FG ]
;
		mDJMP	BG_SIDECK_0000
;
;****************************************************************
;*		]pvZ					*
;*								*
;*	[In]							*
;*		R0	`FbNwW				*
;*		R1	ڕW]p				*
;*								*
;****************************************************************
CR_ANG_CALC_L
		SMS	R11,RTS6
;
		LMS	R2,CPLANSV
		FROM	R2
		CMP	R1
		BEQ	CR_A_CALC_L0200
		LOB
;
		BEQ	CR_A_CALC_L0100
		NOT

		INC	R0
		TO	R4
		AND	#00FH
		IBT	R5,#08
		FROM	R4
		SUB	R5
		BPL	CR_A_CALC_L0100
		NOP
;
		FROM	R1
		SEX
		DIV2
		DIV2
		DIV2
		MOVE	R12,R4
		IBT	R2,#0
		CACHE
		MOVE	R13,R15

		WITH	R2
		ADD	R0

		LOOP
		DEC	R5
;
		LMS	R0,PLANSV
		SEX
		DIV2
		DIV2
		TO	R3
		DIV2
		MOVE	R12,R5
		SUB	R0		;[ IBT R0,#0 ]
		MOVE	R13,R15

		ADD	R3

		LOOP
		NOP
;
		TO	R1
		BRA	CR_A_CALC_L0200
		ADD	R2

CR_A_CALC_L0100
		SMS	R1,CPLANSV

CR_A_CALC_L0200
		LMS	R11,RTS6

		mRTS
;
;
CR_ANG_CALC_R
		SMS	R11,RTS6
;
		LMS	R2,CPLANSV
		FROM	R2
		CMP	R1
		BEQ	CR_A_CALC_R0200
		TO	R4
;
		AND	#00FH
		IBT	R5,#07
		FROM	R4
		SUB	R5
		BPL	CR_A_CALC_R0100
		INC	R4
;
		INC	R5
		FROM	R1
		SEX
		DIV2
		DIV2
		DIV2
		MOVE	R12,R4
		IBT	R2,#0
		CACHE
		MOVE	R13,R15

		WITH	R2
		ADD	R0

		LOOP
		DEC	R5
;
		LMS	R0,PLANSV
		SEX
		DIV2
		DIV2
		TO	R3
		DIV2
		MOVE	R12,R5
		SUB	R0		;[ IBT R0,#0 ]
		MOVE	R13,R15

		ADD	R3

		LOOP
		NOP
;
		TO	R1
		BRA	CR_A_CALC_R0200
		ADD	R2

CR_A_CALC_R0100
		SMS	R1,CPLANSV

CR_A_CALC_R0200
		LMS	R11,RTS6

		mRTS
;
;----------------------------------------------------------------
;-								-
;-	[In]							-
;-		R0	E␳l				-
;-		CWK0	Eaf`FbNwW			-
;-		CWK1	Eaf`FbNxW			-
;-		CWKA	af`FbNwW			-
;-		CWKB	af`FbNxW			-
;-		CWKD	␳l				-
;-		CWK1C	EwW				-
;-		CWK1D	ExW				-
;-		CWK1E	wW				-
;-		CWK1F	xW				-
;-	[Use]							-
;-		R5	return address				-
;-								-
;----------------------------------------------------------------
;
CR_ANG_POS_CALC
		SMS	R11,RTS5	;[ return address save ]
;
		LMS	R5,CWORKD	;(R5) <-- ␳l
		TO	R5
		SUB	R5
		BMI	CR_A_P_CALC0200 ;ŕ␳H ( no:CR_A_P_CALC0200 )
		NOP
;
		BNE	CR_A_P_CALC0100 ;H ( no:CR_A_P_CALC0100 )
		NOP
;
;-------------- Enjaf`FbN ----------------
		mJSR	FOOT_RESULT
;
;-------------- ̂af`FbN񕜋A ----------------------
CR_A_P_CALC0100
		LMS	R0,CWORKA
		SMS	R0,CWORK0	;(CWK0) <-- af`FbNwW
		LMS	R0,CWORKB
		SMS	R0,CWORK1	;(CWK1) <-- af`FbNxW

		LMS	R0,CWORKD	;(R0) <-- ␳l
;
CR_A_P_CALC0200
		TO	R10		;xW␳
		ADD	R10
;
;-------------- njaf`FbN ------------------
		mJSR	FOOT_RESULT
;
;-------------- Zbg ------------------------------
		IBT	R0,#0FFH	;[ IWT R0,#0FFFFH ] np̈
		SMS	R0,CPLYSDR

		LMS	R0,CWORK17
		SEX
		LMS	R1,CWORKC
		WITH	R1
		SEX
		ADD	R1
		TO	R1
		DIV2
		LMS	R0,CPLANGL
		SEX
		ADD	R1
		TO	R1
		DIV2

		FROM	R1
		TO	R4
		LOB
		SMS	R4,CPLANGL
		SMS	R4,CPLANSV

		LMS	R0,CPLCMKI
		LOB
		BNE	CR_A_P_CALC0400
		FROM	R1

		NOT
		INC	R0
		TO	R4
		LOB

CR_A_P_CALC0400
		SMS	R4,CCARANG
;
		LMS	R11,RTS5

		mRTS
;
;****************************************************************
;*		TCh`FbN					*
;****************************************************************
CR_SIDECK_IN
		IBT	R1,#0		;(R1) <-- afnjtO
;
CR_SIDECK
		SMS	R11,RTS1	;[ return address save ]
;
		WITH	R2		;[ ASL R2 ]
		ADD	R2
		WITH	R1		;[ ASL R1 ]
		ADD	R1
		WITH	R1		;[ ASL R1 ]
		ADD	R1

		TO	R8
		GETBS
		INC	R14
		TO	R7
		GETBS
		INC	R14

		LMS	R5,CPLCMKI
		DEC	R5
		TO	R6
		XOR	R5

		LMS	R0,CCARYSW
		LOB
		BNE	CR_SIDECK0200	;LтĂ? ( yes:CR_SIDECK0200 )
		NOP

		LMS	R0,CPLANGL
		SEX
		MOVES	R5,R5
		BPL	CR_SIDECK0100
		NOP

		NOT
		INC	R0

CR_SIDECK0100
		XOR	R6
		BPL	CR_SIDECK0300+1
		FROM	R8
;;;;;;;;		NOP

CR_SIDECK0200
		LMS	R5,CPLANGL

		mJSR	POI_ROT

CR_SIDECK0300
		FROM	R8
		ADD	#008
		TO	R8
		ADD	R9
		IBT	R5,#018H
		FROM	R7
		ADD	R5
		ADD	R10
;;;;		    TO	    R7
;;;;		    ADD	    R0
;
;-------------- af`FbN --------------------------------------
		mJSR_X	BGUNIT_READ_S+1
		HEX	3D		;[ LMS R6,CBG2OF_FG ]

		mDJMP	BG_SIDECK_0000
;
;****************************************************************
;*		`FbN					*
;****************************************************************
CR_HEADCK
CR_FOOTCK
		SMS	R11,RTS1	;[ return address save ]
;
		WITH	R2		;[ ASL R2 ]
		ADD	R2
;
		SUB	R0
		SMS	R0,CWORK8	;(CWK8) <-- saka angle
;
		TO	R8
		GETBS
		INC	R14
		TO	R7
		GETBS
		INC	R14

		FROM	R8
		ADD	#008
		TO	R8
		ADD	R9

		IBT	R0,#018H
		ADD	R10
;;;;		    TO	    R7
		ADD	R7

		MOVES	R3,R3
		BPL	CR_HDFTCK0100	;`FbN? ( yes:CR_HDFTCK0100 )
		NOP

;;;;		    LMS	    R0,CCARYSW
		LMS	R7,CCARYSW
;;;;		    TO	    R7
		ADD	R7

CR_HDFTCK0100
;;;;		    WITH    R7
;;;;		    ADD	    R7
;
		mJSR_X	BGUNIT_READ_S+1
		HEX	3D		;[ LMS R6,CBG2OF_FG ]
;
		mDJMP	BG_HDFTCK_0000
;
;************************************************************************
;*									*
;*		Rg[[					*
;*									*
;************************************************************************
;
CR_KEY
;------------------------------------------------------------------------
;-		ړL[`FbN					-
;------------------------------------------------------------------------
;		LM	R1,CMKEYC1L	;(R1) <-- Rg[[iAj
		LM	R1,CMKEYC2L	;(R2) <--	   h	    igK[j
;
;------------------------------------------------------------------------
;-		̂у`FbN						-
;------------------------------------------------------------------------
CR_KEY_0500
		LMS	R0,CPLTIM0	;L΂^C}[nm ?
		SUB	#0		;
		BEQ	CR_KEY_0530	;  no: CR_KEY_0530
		SUB	R0

		BRA	CR_KEY_0550
		NOP

CR_KEY_0530
		LMS	R0,CCARZOM	;ԏkł ?
		HIB			;
		BEQ	CR_KEY_0600+1	; yes: CR_KEY_0600+1
		LMS	R0,CPLFTLN	;LтĂ ?
		SUB	#0		;
		BNE	CR_KEY_0600	; yes: CR_KEY_0600
		NOP

		LM	R0,CP_KEY_JUMP	;x^a^`{^ꂽ ?
		LM	R5,CP_KEY_BERO	;
		OR	R5		;
		LM	R5,CP_KEY_MNAG	;
		OR	R5		;
		AND	R1		;
		BEQ	CR_KEY_0600	;  no: CR_KEY_0600
		INC	R0		;[ IBT R0,#001 ]
		SMS	R0,CCARFTF

		IBT	R0,#040H	;L΂^C}[Zbg
		SMS	R0,CPLTIM0	;
		IBT	R0,#034H	;mn
		SMS	R0,CMSOUND3

CR_KEY_0550
		IBT	R5,#0F0H	;AEĂ ?
		LMS	R0,CPLBGCR	;
		AND	R5		;
		BEQ	CR_KEY_0560	;  no: CR_KEY_0560
		NOP

		IWT	R5,#0FF00H	;EĂ ?
		AND	R5		;
		BEQ	CR_KEY_0555	;  no: CR_KEY_0555
		NOP

		IWT	R0,#0FC00H
		SMS	R0,CPLYSPD
		IBT	R0,#P008
		SMS	R0,CPLJUMP
		SUB	R0

CR_KEY_0555
		SMS	R0,CPLTIM0
		BRA	CR_KEY_1000	;Ă? ( yes:CR_KEY_1000 )
		NOP

CR_KEY_0560
		LMS	R0,CPLFTLN	;LтĂ ?
		SUB	#1		;
		BMI	CR_KEY_0580	;  no: CR_KEY_0580
		INC	R0

		IBT	R5,#01		;{fB[LtOZbg
		SMS	R5,CCARBDY

CR_KEY_0580
		INC	R0		;Lѐ؂ ?
		INC	R0		;
		IBT	R5,#020H	;
		CMP	R5		;
		BPL	CR_KEY_1000	; yes: CR_KEY_1000
		NOP

		SMS	R0,CPLFTLN
		SMS	R0,CCARYSW
		BRA	CR_KEY_1000
		NOP

CR_KEY_0600
		LMS	R0,CCARYSW	;܂ŐLтĂ ?
		SUB	#00		;
		BEQ	CR_KEY_0610+1	;  no: CR_KEY_0610+1
		SUB	R0

		IBT	R0,#056H	;mn
		SMS	R0,CMSOUND3

CR_KEY_0610	EQU	$
		SUB	R0
		SMS	R0,CCARYSW

		LMS	R0,CPLFTLN	;kł ?
		SUB	#08		;
		BPL	CR_KEY_1000	;  no: CR_KEY_1000
		SBK

		SUB	R0
		SBK

		LMS	R0,CCARBDY
		LOB
		BEQ	CR_KEY_1000	;{fB[LŒ? ( no:CR_KEY_1000 )
		SUB	R0

		SBK			;{fB[LtONA
;
;------------------------------------------------------------------------
;-		ړL[`FbN					-
;------------------------------------------------------------------------
CR_KEY_1000
		LM	R1,CMKEYC1	;(R1) <-- Rg[[iAj
		LMS	R0,CPLDASH
		SUB	#0
		BNE	CR_KEY_1510	;߃_bVH ( yes:CR_KEY_1510 )
		FROM	R1

		AND	#00000011B
		BNE	CR_KEY_1510	;EL[́H ( yes:CR_KEY_1510 )
		NOP
;
		mDJMP	CR_KEY_1800
;
CR_KEY_1510
		SMS	R0,CPLSTOP	;~܂ĂtOZbg
;
		IBT	R7,#-1		;(R7) <-- EL[ɂړij
		AND	#02H		;(R0) <-- vC[
		BNE	CR_KEY_1520	;ցH ( yes:CR_KEY_1520 )
		NOP
;
		IBT	R7,#01H		;(R7) <-- EL[ɂړiEj
CR_KEY_1520
		LMS	R4,CPLCMKI	;(R4) <-- ړ
		SUB	R4
		BEQ	CR_KEY_1550	;ςH ( no:CR_KEY_1550 )
		ADD	R4
;
		SMS	R0,CPLCMKI
		MOVE	R4,R0		;(R4) <-- ړ

CR_KEY_1550
		LMS	R0,CPLMVSP
		SUB	#0
		BEQ	CR_KEY_1700	;~܂ĂH ( yes:CR_KEY_1700 )
		NOP
;
		XOR	R7
		BPL	CR_KEY_1700	;XbvH ( no:CR_KEY_1700 )
		NOP
;
;----------------------------------------------------------------
;-		Xbv					-
;----------------------------------------------------------------
		LMS	R0,CPLJUMP
		SUB	#0
		BNE	CR_KEY_1700	;WvH ( yes:CR_KEY_1700 )
		NOP
;
		IBT	R0,#08H
		SMS	R0,CPLSLIP	;XbvtOhnmh
;
;----------------------------------------------------------------
;-								-
;----------------------------------------------------------------
CR_KEY_1700
		LMS	R0,CPLBGNO
		SWAP			;af^Cv ~iiQ{Qj~PUj
		LSR			;
		LSR			;
		TO	R7
		OR	R4		;[ nqiړj ]
		LMS	R0,CPLANGL
		BIC	#0FH		;[ AND #0FFF0H ]
		LSR
		LSR
		TO	R7		;(R7) <-- f[^|C^[
		OR	R7
;
		LMS	R0,CPLDASH
		DEC	R0
		BMI	CR_KEY_1702+1	;߃_bVH ( no:CR_KEY_1702+1 )

		IWT	R0,#CAR_MAX_DASH
		TO	R14		;(R14) <-- ߃_bVl`wXs[hf[^|C^[
		ADD	R4
		BRA	CR_KEY_1704+1
		GETB

CR_KEY_1702
		IWT	R0,#MAX_SPEED
		TO	R14		;(R14) <-- l`wXs[hf[^|C^[
		ADD	R7
;
CR_KEY_1704
		GETB
		INC	R14
		TO	R8		;(R8) <-- l`wXs[h
		GETBH
;
		LMS	R0,CPLMVSP	;(R0) <-- ړXs[h
		SUB	R8
		BEQ	CR_KEY_1850	;l`wXs[hI[o[H ( yes:CR_KEY_1850 )
		NOP
;
		XOR	R8
		BPL	CR_KEY_1850	;l`wXs[hI[o[H ( yes:CR_KEY_1850 )
		NOP
;
		LMS	R0,CPLSLIP
		LOB
		BEQ	CR_KEY_1710	;XbvH ( no:CR_KEY_1710 )
		NOP
;
		INC	R7
CR_KEY_1710
		IWT	R0,#ADD_SPEED
		ADD	R7
		TO	R14
		ADD	R7
		GETB
		INC	R14
		GETBH
;
		LMS	R7,CPLMVSP
		ADD	R7
		SBK			;[ SMS R0,CPLMVSP ]
;
CR_KEY_1720
		mRTS
;
;----------------------------------------------------------------
;-								-
;----------------------------------------------------------------
CR_KEY_1800
		LMS	R0,CPLJUMP
		SUB	#0
		BEQ	CR_KEY_1850	;WvH ( no:CR_KEY_1850 )
		NOP
;
;--------------------------------------------------------
;-		Wv̌			-
;--------------------------------------------------------
		IWT	R14,#MAX_SPEED	;(R14) <-- l`wXs[hf[^|C^[
		LMS	R0,CPLMVSP
		SUB	#0
		BPL	CR_KEY_1810
		NOP
;
		INC	R14
		INC	R14
CR_KEY_1810
		TO	R8
		GETB
		INC	R14
		WITH	R8
		GETBH
;
		SUB	R8
		BEQ	CR_KEY_1850	;l`wXs[hI[o[H ( yes:CR_KEY_1850 )
		NOP
;
		XOR	R8
		BPL	CR_KEY_1850	;l`wXs[hI[o[H ( yes:CR_KEY_1850 )
		NOP
;
		mRTS
;
;--------------------------------------------------------
;-		ň				-
;--------------------------------------------------------
CR_KEY_1850
		LMS	R0,CPLBGNO
		SWAP			;af^Cv ~iQ~PUj
		LSR			;
		LSR			;
		TO	R7		;
		LSR			;
		LMS	R0,CPLANGL
		BIC	#0FH		;[ AND #0FFF0H ]
		LSR
		LSR
		LSR
		TO	R4		;(R4) <-- f[^|C^[
		OR	R7
		IWT	R0,#MIN_SPEED
		TO	R14
		ADD	R4
		GETB
		INC	R14
		TO	R7		;(R7) <-- lhmXs[h
		GETBH
;
		LMS	R8,CPLMVSP	;(R8) <-- ړXs[h
		FROM	R8
		SUB	R7
		BPL	CR_KEY_1860
		NOP
;
		INC	R4
CR_KEY_1860
		IWT	R0,#SUB_SPEED
		ADD	R4
		TO	R14
		ADD	R4
		GETB
		INC	R14
		GETBH
		MOVE	R4,R0		;(R4) <-- l
;
		ADD	R8
		MOVE	R8,R0
		SUB	R7
		XOR	R4
		BMI	CR_KEY_1870	;lhmXs[hI[o[H ( no:CR_KEY_1870 )
		SUB	R0
;
		SMS	R0,CPLSTOP
		MOVE	R8,R7
;
CR_KEY_1870
		SMS	R8,CPLMVSP
		mRTS
;
;************************************************************************
;*									*
;*		p^[mDZbg					*
;*									*
;************************************************************************
;
CR_PATN
;
;-------------- Wvp^[Zbg --------------------------------
		LMS	R0,CPLJUMP
		LOB
;;;;;;;;		BEQ	CR_PATN_0200	;Wv? ( no:BP_PATN_0200 )
;;;;;;;;		NOP
;;;;;;;;
;;;;;;;;		mDJMP	CR_PATN_0500
		BNE	CR_PATN_0500
		NOP
;
;-------------- ~܂Ă鎞̃p^[Zbg ------------------------
CR_PATN_0200
		LMS	R0,CPLSTOP
		LOB
		BEQ	CR_PATN_0380	;~܂Ă? ( yes:BP_PATN_0380 )
		NOP

		LMS	R0,CPSPUSH
		LOB
		BEQ	CR_PATN_0400	;ǂĂ? ( no:CR_PATN_0400 )
		NOP

CR_PATN_0380
		IWT	R0,#00080H
		BRA	CR_PATN_0410
		NOP

CR_PATN_0400
		LMS	R0,CPLMVSP
		SUB	#0
		BEQ	CR_PATN_0380	;~܂Ă? ( yes:BP_PATN_0380 )
		NOP

		BPL	CR_PATN_0410
		NOP

		NOT
		INC	R0

CR_PATN_0410
		LMS	R3,CPLWALK
		IWT	R2,#00800H
		LMS	R1,CCARCT0
		ADD	R1
		SUB	R2
		BMI	CR_PATN_0420	;p^[`FW? ( no: CR_PATN_0420 )
		ADD	R2

		SUB	R2
		INC	R3
		INC	R3

CR_PATN_0420
		SBK

CR_PATN_0500
		IWT	R2,#CA00
		LMS	R0,CPLFTLN
		LOB
		BEQ	CR_PATN_0800	;LтĂ? ( no:CR_PATN_0800 )
		NOP

		IWT	R2,#CA01

		FROM	R3
		AND	#02
		BEQ	CR_PATN_0600
		NOP

		IWT	R2,#CA02

CR_PATN_0600
		SMS	R2,CPLPATN
		SMS	R0,CPLWALK

		mRTS

CR_PATN_0800
		SMS	R2,CPLPATN

		FROM	R3
		AND	#02
		SMS	R0,CPLWALK

		mRTS
;
;****************************************************************
;*		RC܂				*
;****************************************************************
CAR_COIN_GET
		SMS	R11,RTS1		;[ return address save ]
;
		IBT	R1,#CEMOVE
		IWT	R2,#CENMODE
		IWT	R3,#CENMYNO
		IWT	R4,#CECENTX
		IWT	R5,#CEWIDEX
;
		LMS	R6,CPCENTX
		LMS	R7,CPCENTY
		LMS	R8,CPLFTLN
;
		IBT	R12,#CENNO
		CACHE
		MOVE	R13,R15

		LDW	(R2)			;Ă ?
		SUB	R1			;
		BNE	CAR_C_G0800		;  no: CAR_C_G0800
		INC	R2

		TO	R9			;R9 <- EWIDEX
		LDW	(R5)			;
		FROM	R9			;R10 <- CMP DATA
		TO	R10			;
		ADD	R9			;

		LDW	(R4)			;nj ?
		SUB	R6			;
		ADD	R9			;
		CMP	R10			;
		BCS	CAR_C_G0800		;  no: CAR_C_G0800
		NOP

		INC	R5
		INC	R5
		INC	R4
		INC	R4

		LDW	(R5)			;
		TO	R9			;R9 <- EWIDEY
		ADD	R8

		LDW	(R4)			;cnj ?
		DEC	R5			;
		DEC	R5			;
		DEC	R4			;
		SUB	R7			;
		CMP	R9			;
		BCS	CAR_C_G0800		;  no: CAR_C_G0800
		DEC	R4			;

		TO	R9
		LDW	(R3)
		IWT	R0,#COIN1
		CMP	R9
		BEQ	CAR_C_G0100
		NOP

		IWT	R0,#COINR
		CMP	R9
		BEQ	CAR_C_G0100
		NOP

		IWT	R0,#ZFLWR
		CMP	R9
		BEQ	CAR_C_G0100
		NOP

		IWT	R0,#ZFLW2
		CMP	R9
		BNE	CAR_C_G0800
		NOP

CAR_C_G0100
		IWT	R0,#CENNO
		SUB	R12
		ADD	R0
		ADD	R0
		SMS	R0,CWORK0

		mSFCALL GET_POINT

CAR_C_G0800
		IBT	R0,#04
		WITH	R3
		ADD	R0
		WITH	R4
		ADD	R0
		WITH	R5
		ADD	R0
		INC	R2
		INC	R2
		LOOP
		INC	R2

		LMS	R11,RTS1
		mRTS
;
;
;
;
;
		END
