;************************************************************************
;*									*
;*	title name	: "yossy"					*
;*	proccess	: mario chip program message 0			*
;*	file name	: ys_msge0.asm					*
;*									*
;************************************************************************
;
;
		SALL
;
		include		ys_chip.inc
;
		XALL
;
;
;------------------------------------------------------------------------
;-		global symbol						-
;------------------------------------------------------------------------
		GLB	MSG_FONT,MSG_FONT_X
;
;------------------------------------------------------------------------
;-		extern symbol						-
;------------------------------------------------------------------------
;
;-------------< ys_chip0 >-----------------------------------------------
		EXT	COS,SIN,LCOS,LSIN
;
;************************************************************************
;*									*
;*		program start						*
;*									*
;************************************************************************
;
;
Group_9		GROUP	S_msge_0
S_msge_0	SECT	REL
;
;
;************************************************************************
;*									*
;*	bZ[W							*
;*					Programmed by  Y. Yamamoto.	*
;*						Sep. 21(Tue), JST 1993	*
;*								Ver 0.00*
;************************************************************************
;
 IF  NES | PAL ;**** NES or PAL Ή [1995/7/13] *****************
MSG_X_REAL	EQU		130	;bZ[W \ GA wTCY( TCY)
MSG_Y_REAL	EQU		64	;bZ[W \ GA xTCY( TCY)
MSG_X_AREA	EQU		130	;bZ[W \ GA wTCY(_ TCY)
MSG_Y_AREA	EQU		64	;bZ[W \ GA xTCY(_ TCY)
 ENDIF	  ;**** NES or PAL Ή [1995/7/13] **********************
;
 IF  JPN  ;**** { Ή [1995/6/30] ****************************
MSG_X_REAL	EQU		128	;bZ[W \ GA wTCY( TCY)
MSG_Y_REAL	EQU		64	;bZ[W \ GA xTCY( TCY)
MSG_X_AREA	EQU		121	;bZ[W \ GA wTCY(_ TCY)
MSG_Y_AREA	EQU		64	;bZ[W \ GA xTCY(_ TCY)
 ENDIF	  ;**** { Ή [1995/6/30] ****************************
;--------
MSG_Stat	EQU		MSG_RAM ;0: bZ[W Xe[^X q`l
MSG_init	EQU		0	; : bZ[W Xe[^X CjV
MSG_proc	EQU		1	; : bZ[W Xe[^X vZX
MSG_exit	EQU		2	; : bZ[W Xe[^X COWbg
;
MSG_No		EQU		MSG_Stat+2	; : bZ[W mD
;
MSG_Char	EQU		MSG_No+2	; :  R[h
;
MSG_KeyAD	EQU		MSG_Char+2	; : Rg[[ P hbO
MSG_KeyAT	EQU		MSG_KeyAD+2	; : Rg[[ P gK[
MSG_KeyBD	EQU		MSG_KeyAT+2	; : Rg[[ Q hbO
MSG_KeyBT	EQU		MSG_KeyBD+2	; : Rg[[ Q gK[
;
MSG_Poit	EQU		MSG_KeyBT+2	; :  |C^[
;
MSG_Fade	EQU		MSG_Poit+2	;0: tF[h C AEg
;
MSG_Xsiz	EQU		MSG_Fade+2	;0:  wTCY (0 - 3)
MSG_Ysiz	EQU		MSG_Xsiz+2	;0:  xTCY (0 - 3)
MSG_siz0	EQU		0		; :  TCY O
MSG_siz1	EQU		1		; :  TCY P
MSG_siz2	EQU		2		; :  TCY Q
MSG_siz3	EQU		3		; :  TCY R
;
MSG_Xpos	EQU		MSG_Ysiz+2	;0:  w|WV
MSG_Ypos	EQU		MSG_Xpos+2	;0:  x|WV
;
MSG_Sped	EQU		MSG_Ypos+2	;0:  \ Xs[h JE^[ (FRAME)
MSG_Sped_BAK	EQU		MSG_Sped+2	;0;  \ Xs[h Lp (FRAME)
MSG_spd0	EQU		00H	; :  \ Xs[h O
MSG_spd1	EQU		01H	; :  \ Xs[h P
MSG_spd2	EQU		02H	; :  \ Xs[h Q
MSG_spd3	EQU		03H	; :  \ Xs[h R
MSG_spd4	EQU		04H	; :  \ Xs[h S
MSG_spd5	EQU		05H	; :  \ Xs[h T
MSG_spd6	EQU		06H	; :  \ Xs[h U
MSG_spd7	EQU		07H	; :  \ Xs[h V
MSG_spd8	EQU		08H	; :  \ Xs[h W
MSG_spd9	EQU		09H	; :  \ Xs[h X
MSG_spdA	EQU		0AH	; :  \ Xs[h `
MSG_spdB	EQU		0BH	; :  \ Xs[h a
MSG_spdC	EQU		0CH	; :  \ Xs[h b
MSG_spdD	EQU		0DH	; :  \ Xs[h c
MSG_spdE	EQU		0EH	; :  \ Xs[h d
MSG_spdF	EQU		0FH	; :  \ Xs[h e
;
MSG_1Putc_X	EQU		MSG_Sped_BAK+2	;P\ wʒu
MSG_1Putc_Y	EQU		MSG_1Putc_X+2	;P\ xʒu
MSG_1Putc_C	EQU		MSG_1Putc_Y+2	;P\ LN^[
MSG_1Putc_Rts	EQU		MSG_1Putc_C+2	;P\ ^[AhX
;
;
;
;------------------------------------------------------------------------
;|		bZ[W RA vO				|
;------------------------------------------------------------------------
MSG_CORE	EQU		$
		IBT		R0,#BANK MSG_CORE ;qnl a`mj Zbg
		ROMB
		mCMODE		000H		;blncd Zbg
		mCOLOUR		003H		;bnkntq Zbg
;
		LM		R0, MSG_Stat
		mJSRSUB
		mTWORD		MSG_INIT
		mTWORD		MSG_PROC
		mTWORD		MSG_EXIT
;
;
;
;
;
;------------------------------------------------------------------------
;|		bZ[W CjV vO			|
;------------------------------------------------------------------------
MSG_INIT
		IBT		R0, #MSG_proc
		SM		R0, MSG_Stat		;bZ[W Xe[^X q`l <-- MSG_proc
;
		SUB		R0
		SM		R0, MSG_Fade		;tF[h C AEg <-- 0
		SM		R0, MSG_Xpos		; w|WV <-- 0
;;;;K;;;;		SM		R0, MSG_Ypos		; x|WV <-- 0
		SM		R0, MSG_Sped		; \ Xs[h JE^[ <-- 0
		SM		R0, MSG_Sped_BAK	; \ Xs[h Lp <-- 0
		SM		R0, MSG_Xsiz		; wTCY <-- 0
		SM		R0, MSG_Ysiz		; xTCY <-- 0
		SM		R0, MSG_ANS		;xdr mn <-- 0
;
		IBT		R0, #010H
		SM		R0, MSG_Ypos		; x|WV <-- 0
;
;;;;K;;;;		LM		R0, MSG_No		;bZ[W mD
;;;;K;;;;		IWT		R1, #MSG_DOCA		;bZ[W hLg̓ĂAhX
;;;;K;;;;		ADD		R0			; |C^[ɃZbg
;;;;K;;;;		TO		R14
;;;;K;;;;		ADD		R1
;;;;K;;;;		GETB
;;;;K;;;;		INC		R14
;;;;K;;;;		GETBH
;;;;K;;;;		SM		R0, MSG_Poit
;
		LM		R0,MSG_ADR
		SM		R0,MSG_Poit
;
;		IBT		R0, #000H		;tF[h C AEg CjV Zbg
;		SM		R0, DATACOL + 32H
;		SM		R0, DATACOL + 34H
;		SM		R0, DATACOL + 36H
;		SM		R0, DATACOL + 3AH
;		SM		R0, DATACOL + 3CH
;		SM		R0, DATACOL + 3EH
;
		IWT		R0, #00FFH		;bZ[W GA NA
		IWT		R1, #MSGBITMP
		IWT		R12, #( 800H + 200H ) / 2
		MOVE		R13, R15
		STW		(R1)
		INC		R1
		LOOP
		INC		R1
;
;		IBT		R0, #000H		;cl`]p rbg}bv GA NA
;		IWT		R1, #MSGDMABF
;		IWT		R12, #400H / 2
;		MOVE		R13, R15
;		STW		(R1)
;		INC		R1
;		LOOP
;		INC		R1
;
;		STOP
;		NOP
;
;
;
;
;
;------------------------------------------------------------------------
;|		bZ[W vZX vO				|
;------------------------------------------------------------------------
MSG_PROC
		SUB		R0
		SMS		R0,CMSOUND3
		LM		R0, MSG_Sped		;\Xs[hJE^[ -1
		DEC		R0
		BMI		MSG_PROC_START		;\ ? Y: MSG_PROC_START
		SBK
		mDJMP		MSG_PROC_EXIT
MSG_PROC_START
		LM		R0, MSG_Sped_BAK	;\Xs[hLp -> \Xs[hJE^[
		SM		R0, MSG_Sped
;
		LM		R0, MSG_BNK
		ROMB					;a`mj Zbg
;
		LM		R14, MSG_Poit		;|C^[
		GETB					;AhX
		INC		R14			;R[hĂ
		GETBH
		SM		R0, MSG_Char		;R[h Zbg
;
		IBT		R1,#BANK MSG_CORE
		FROM		R1
		ROMB					;a`mj Zbg
;
		MOVE		R1, R0
		INC		R0
		LOB
		BEQ		MSG_CODE		;R[h ? Y: MSG_CODE
		NOP
		mDJMP		MSG_PUTC		;\
MSG_CODE
		FROM		R1
		HIB
		mJSRSUB
;
		mTWORD		MSG_CODE_00
		mTWORD		MSG_CODE_01
		mTWORD		MSG_CODE_02
		mTWORD		MSG_CODE_03
		mTWORD		MSG_CODE_04
		mTWORD		MSG_CODE_05
		mTWORD		MSG_CODE_06
		mTWORD		MSG_CODE_07
		mTWORD		MSG_CODE_08
		mTWORD		MSG_CODE_09
		mTWORD		MSG_CODE_0A
		mTWORD		MSG_CODE_0B
		mTWORD		MSG_CODE_0C
		mTWORD		MSG_CODE_0D
		mTWORD		MSG_CODE_0E
		mTWORD		MSG_CODE_0F
;
		mTWORD		MSG_CODE_10
		mTWORD		MSG_CODE_11
		mTWORD		MSG_CODE_12
		mTWORD		MSG_CODE_13
		mTWORD		MSG_CODE_14
		mTWORD		MSG_CODE_15
		mTWORD		MSG_CODE_16
		mTWORD		MSG_CODE_17
		mTWORD		MSG_CODE_18
		mTWORD		MSG_CODE_19
		mTWORD		MSG_CODE_1A
		mTWORD		MSG_CODE_1B
		mTWORD		MSG_CODE_1C
		mTWORD		MSG_CODE_1D
		mTWORD		MSG_CODE_1E
		mTWORD		MSG_CODE_1F
;
		mTWORD		MSG_CODE_20
		mTWORD		MSG_CODE_21
		mTWORD		MSG_CODE_22
		mTWORD		MSG_CODE_23
		mTWORD		MSG_CODE_24
		mTWORD		MSG_CODE_25
		mTWORD		MSG_CODE_26
		mTWORD		MSG_CODE_27
		mTWORD		MSG_CODE_28
		mTWORD		MSG_CODE_29
		mTWORD		MSG_CODE_2A
		mTWORD		MSG_CODE_2B
		mTWORD		MSG_CODE_2C
		mTWORD		MSG_CODE_2D
		mTWORD		MSG_CODE_2E
		mTWORD		MSG_CODE_2F
;
		mTWORD		MSG_CODE_30
		mTWORD		MSG_CODE_31
		mTWORD		MSG_CODE_32
		mTWORD		MSG_CODE_33
		mTWORD		MSG_CODE_34
		mTWORD		MSG_CODE_35
		mTWORD		MSG_CODE_36
		mTWORD		MSG_CODE_37
		mTWORD		MSG_CODE_38
		mTWORD		MSG_CODE_39
		mTWORD		MSG_CODE_3A
		mTWORD		MSG_CODE_3B
		mTWORD		MSG_CODE_3C
		mTWORD		MSG_CODE_3D
		mTWORD		MSG_CODE_3E
		mTWORD		MSG_CODE_3F
;
		mTWORD		MSG_CODE_40
		mTWORD		MSG_CODE_41
		mTWORD		MSG_CODE_42
		mTWORD		MSG_CODE_43
		mTWORD		MSG_CODE_44
		mTWORD		MSG_CODE_45
		mTWORD		MSG_CODE_46
		mTWORD		MSG_CODE_47
		mTWORD		MSG_CODE_48
		mTWORD		MSG_CODE_49
		mTWORD		MSG_CODE_4A
		mTWORD		MSG_CODE_4B
		mTWORD		MSG_CODE_4C
		mTWORD		MSG_CODE_4D
		mTWORD		MSG_CODE_4E
		mTWORD		MSG_CODE_4F
;
		mTWORD		MSG_CODE_50
		mTWORD		MSG_CODE_51
		mTWORD		MSG_CODE_52
		mTWORD		MSG_CODE_53
		mTWORD		MSG_CODE_54
		mTWORD		MSG_CODE_55
		mTWORD		MSG_CODE_56
		mTWORD		MSG_CODE_57
		mTWORD		MSG_CODE_58
		mTWORD		MSG_CODE_59
		mTWORD		MSG_CODE_5A
		mTWORD		MSG_CODE_5B
		mTWORD		MSG_CODE_5C
		mTWORD		MSG_CODE_5D
		mTWORD		MSG_CODE_5E
		mTWORD		MSG_CODE_5F
;
		mTWORD		MSG_CODE_60
		mTWORD		MSG_CODE_61
		mTWORD		MSG_CODE_62
		mTWORD		MSG_CODE_63
		mTWORD		MSG_CODE_64
		mTWORD		MSG_CODE_65
		mTWORD		MSG_CODE_66
		mTWORD		MSG_CODE_67
		mTWORD		MSG_CODE_68
		mTWORD		MSG_CODE_69
		mTWORD		MSG_CODE_6A
		mTWORD		MSG_CODE_6B
		mTWORD		MSG_CODE_6C
		mTWORD		MSG_CODE_6D
		mTWORD		MSG_CODE_6E
		mTWORD		MSG_CODE_6F
;
		mTWORD		MSG_CODE_70
		mTWORD		MSG_CODE_71
		mTWORD		MSG_CODE_72
		mTWORD		MSG_CODE_73
		mTWORD		MSG_CODE_74
		mTWORD		MSG_CODE_75
		mTWORD		MSG_CODE_76
		mTWORD		MSG_CODE_77
		mTWORD		MSG_CODE_78
		mTWORD		MSG_CODE_79
		mTWORD		MSG_CODE_7A
		mTWORD		MSG_CODE_7B
		mTWORD		MSG_CODE_7C
		mTWORD		MSG_CODE_7D
		mTWORD		MSG_CODE_7E
		mTWORD		MSG_CODE_7F
;
		mTWORD		MSG_CODE_80
		mTWORD		MSG_CODE_81
		mTWORD		MSG_CODE_82
		mTWORD		MSG_CODE_83
		mTWORD		MSG_CODE_84
		mTWORD		MSG_CODE_85
		mTWORD		MSG_CODE_86
		mTWORD		MSG_CODE_87
		mTWORD		MSG_CODE_88
		mTWORD		MSG_CODE_89
		mTWORD		MSG_CODE_8A
		mTWORD		MSG_CODE_8B
		mTWORD		MSG_CODE_8C
		mTWORD		MSG_CODE_8D
		mTWORD		MSG_CODE_8E
		mTWORD		MSG_CODE_8F
;
		mTWORD		MSG_CODE_90
		mTWORD		MSG_CODE_91
		mTWORD		MSG_CODE_92
		mTWORD		MSG_CODE_93
		mTWORD		MSG_CODE_94
		mTWORD		MSG_CODE_95
		mTWORD		MSG_CODE_96
		mTWORD		MSG_CODE_97
		mTWORD		MSG_CODE_98
		mTWORD		MSG_CODE_99
		mTWORD		MSG_CODE_9A
		mTWORD		MSG_CODE_9B
		mTWORD		MSG_CODE_9C
		mTWORD		MSG_CODE_9D
		mTWORD		MSG_CODE_9E
		mTWORD		MSG_CODE_9F
;
		mTWORD		MSG_CODE_A0
		mTWORD		MSG_CODE_A1
		mTWORD		MSG_CODE_A2
		mTWORD		MSG_CODE_A3
		mTWORD		MSG_CODE_A4
		mTWORD		MSG_CODE_A5
		mTWORD		MSG_CODE_A6
		mTWORD		MSG_CODE_A7
		mTWORD		MSG_CODE_A8
		mTWORD		MSG_CODE_A9
		mTWORD		MSG_CODE_AA
		mTWORD		MSG_CODE_AB
		mTWORD		MSG_CODE_AC
		mTWORD		MSG_CODE_AD
		mTWORD		MSG_CODE_AE
		mTWORD		MSG_CODE_AF
;
		mTWORD		MSG_CODE_B0
		mTWORD		MSG_CODE_B1
		mTWORD		MSG_CODE_B2
		mTWORD		MSG_CODE_B3
		mTWORD		MSG_CODE_B4
		mTWORD		MSG_CODE_B5
		mTWORD		MSG_CODE_B6
		mTWORD		MSG_CODE_B7
		mTWORD		MSG_CODE_B8
		mTWORD		MSG_CODE_B9
		mTWORD		MSG_CODE_BA
		mTWORD		MSG_CODE_BB
		mTWORD		MSG_CODE_BC
		mTWORD		MSG_CODE_BD
		mTWORD		MSG_CODE_BE
		mTWORD		MSG_CODE_BF
;
		mTWORD		MSG_CODE_C0
		mTWORD		MSG_CODE_C1
		mTWORD		MSG_CODE_C2
		mTWORD		MSG_CODE_C3
		mTWORD		MSG_CODE_C4
		mTWORD		MSG_CODE_C5
		mTWORD		MSG_CODE_C6
		mTWORD		MSG_CODE_C7
		mTWORD		MSG_CODE_C8
		mTWORD		MSG_CODE_C9
		mTWORD		MSG_CODE_CA
		mTWORD		MSG_CODE_CB
		mTWORD		MSG_CODE_CC
		mTWORD		MSG_CODE_CD
		mTWORD		MSG_CODE_CE
		mTWORD		MSG_CODE_CF
;
		mTWORD		MSG_CODE_D0
		mTWORD		MSG_CODE_D1
		mTWORD		MSG_CODE_D2
		mTWORD		MSG_CODE_D3
		mTWORD		MSG_CODE_D4
		mTWORD		MSG_CODE_D5
		mTWORD		MSG_CODE_D6
		mTWORD		MSG_CODE_D7
		mTWORD		MSG_CODE_D8
		mTWORD		MSG_CODE_D9
		mTWORD		MSG_CODE_DA
		mTWORD		MSG_CODE_DB
		mTWORD		MSG_CODE_DC
		mTWORD		MSG_CODE_DD
		mTWORD		MSG_CODE_DE
		mTWORD		MSG_CODE_DF
;
		mTWORD		MSG_CODE_E0
		mTWORD		MSG_CODE_E1
		mTWORD		MSG_CODE_E2
		mTWORD		MSG_CODE_E3
		mTWORD		MSG_CODE_E4
		mTWORD		MSG_CODE_E5
		mTWORD		MSG_CODE_E6
		mTWORD		MSG_CODE_E7
		mTWORD		MSG_CODE_E8
		mTWORD		MSG_CODE_E9
		mTWORD		MSG_CODE_EA
		mTWORD		MSG_CODE_EB
		mTWORD		MSG_CODE_EC
		mTWORD		MSG_CODE_ED
		mTWORD		MSG_CODE_EE
		mTWORD		MSG_CODE_EF
;
		mTWORD		MSG_CODE_F0
		mTWORD		MSG_CODE_F1
		mTWORD		MSG_CODE_F2
		mTWORD		MSG_CODE_F3
		mTWORD		MSG_CODE_F4
		mTWORD		MSG_CODE_F5
		mTWORD		MSG_CODE_F6
		mTWORD		MSG_CODE_F7
		mTWORD		MSG_CODE_F8
		mTWORD		MSG_CODE_F9
		mTWORD		MSG_CODE_FA
		mTWORD		MSG_CODE_FB
		mTWORD		MSG_CODE_FC
		mTWORD		MSG_CODE_FD
		mTWORD		MSG_CODE_FE
		mTWORD		MSG_CODE_FF
;
;
;
;
;
;
;------------------------------------------------------------------------
;|		bZ[W COWbg vO			|
;------------------------------------------------------------------------
MSG_EXIT
		stop
		nop
;
;
;
;
;
;------------------------------------------------------------------------
;|		bZ[W vZX Tu vO			|
;------------------------------------------------------------------------
MSG_PUTC	;bZ[W \
		LM		R0, MSG_Ysiz		;R0 <-- MSG_Ysiz * 4 + MSG_Xsiz
		ADD		R0
		ADD		R0
		LM		R1, MSG_Xsiz
		OR		R1
		mJSRSUB
		mTWORD		MSG_PUTC_X0Y0		;wP{ xP{
		mTWORD		MSG_PUTC_X1Y0		;wQ{ xP{
		mTWORD		MSG_PUTC_X2Y0		;wR{ xP{
		mTWORD		MSG_PUTC_X3Y0		;wS{ xP{
		mTWORD		MSG_PUTC_X0Y1		;wP{ xQ{
		mTWORD		MSG_PUTC_X1Y1		;wQ{ xQ{
		mTWORD		MSG_PUTC_X2Y1		;wR{ xQ{
		mTWORD		MSG_PUTC_X3Y1		;wS{ xQ{
		mTWORD		MSG_PUTC_X0Y2		;wP{ xR{
		mTWORD		MSG_PUTC_X1Y2		;wQ{ xR{
		mTWORD		MSG_PUTC_X2Y2		;wR{ xR{
		mTWORD		MSG_PUTC_X3Y2		;wS{ xR{
		mTWORD		MSG_PUTC_X0Y3		;wP{ xS{
		mTWORD		MSG_PUTC_X1Y3		;wQ{ xS{
		mTWORD		MSG_PUTC_X2Y3		;wR{ xS{
		mTWORD		MSG_PUTC_X3Y3		;wS{ xS{
;
MSG_PUTC_X0Y0	;wP{ xP{
		CACHE
		LM		R0, MSG_Char		;tHgf[^AhX vZ
		LOB
		UMULT		#00CH
		IWT		R1, #MSG_FONT
		TO		R14
		ADD		R1
;
		LM		R0, MSG_Ypos		;vbg x|WV Zbg
		TO		R2
		ADD		#003H			;vbg x|WV { R
;
		LM		R3, MSG_Xpos		;vbg w|WV ۑ
;
		IBT		R12, #00CH
		MOVE		R13, R15
		MOVE		R1, R3			;vbg w|WV Zbg
		GETB
		INC		R14
		SWAP
		ADD		R0
		BCC		MSG_PUTC10
		INC		R1
		DEC		R1
		PLOT
MSG_PUTC10
		ADD		R0
		BCC		MSG_PUTC20
		INC		R1
		DEC		R1
		PLOT
MSG_PUTC20
		ADD		R0
		BCC		MSG_PUTC30
		INC		R1
		DEC		R1
		PLOT
MSG_PUTC30
		ADD		R0
		BCC		MSG_PUTC40
		INC		R1
		DEC		R1
		PLOT
MSG_PUTC40
		ADD		R0
		BCC		MSG_PUTC50
		INC		R1
		DEC		R1
		PLOT
MSG_PUTC50
		ADD		R0
		BCC		MSG_PUTC60
		INC		R1
		DEC		R1
		PLOT
MSG_PUTC60
		ADD		R0
		BCC		MSG_PUTC70
		INC		R1
		DEC		R1
		PLOT
MSG_PUTC70
		ADD		R0
		BCC		MSG_PUTC80
		INC		R1
		DEC		R1
		PLOT
MSG_PUTC80
		LOOP
		INC		R2
;
		RPIX
;
		LM		R0, MSG_Poit		;|C^[ ̈ʒu
		INC		R0
		SBK
;
		LM		R0, MSG_Char		;tHg wTCYf[^ AhX vZ
		LOB
		IWT		R1, #MSG_FONT_X
		TO		R14
		ADD		R1
		GETB
		TO		R1
		ADD		R3
		IWT		R0, #MSG_X_AREA
		FROM		R1
		SUB		R0
		BCC		MSG_PUTC100		;s ? N: MSG_PUTC100
		NOP
		IBT		R1, #000H		;vbg w|WV s
		LM		R0, MSG_Ypos		;s MSG_Ypos + 10H
		INC		R0
		TO		R2
		ADD		#00FH
		IWT		R0, #MSG_Y_AREA
		FROM		R2
		SUB		R0
		BCC		MSG_PUTC110		;y[W ? N: MSG_PUTC110
		NOP
;;;;K;;;;		IBT		R2, #000H		;vbg x|WV y[W擪
		IBT		R2, #010H		;vbg x|WV y[W擪
MSG_PUTC110
		SM		R2, MSG_Ypos
MSG_PUTC100
		SM		R1, MSG_Xpos		;vbg w|WV XV
;
		mDJMP		MSG_PROC
MSG_PUTC_X1Y0	;wQ{ xP{
MSG_PUTC_X2Y0	;wR{ xP{
MSG_PUTC_X3Y0	;wS{ xP{
MSG_PUTC_X0Y1	;wP{ xQ{
MSG_PUTC_X1Y1	;wQ{ xQ{
MSG_PUTC_X2Y1	;wR{ xQ{
MSG_PUTC_X3Y1	;wS{ xQ{
MSG_PUTC_X0Y2	;wP{ xR{
MSG_PUTC_X1Y2	;wQ{ xR{
MSG_PUTC_X2Y2	;wR{ xR{
MSG_PUTC_X3Y2	;wS{ xR{
MSG_PUTC_X0Y3	;wP{ xS{
MSG_PUTC_X1Y3	;wQ{ xS{
MSG_PUTC_X2Y3	;wR{ xS{
MSG_PUTC_X3Y3	;wS{ xS{
		CACHE
		LM		R5 ,MSG_Xsiz		; wTCY ۑ
		INC		R5
		LM		R6 ,MSG_Ysiz		; xTCY ۑ
		INC		R6
;
		LM		R4, MSG_Ypos		;vbg x|WV vZ
		FROM		R6
		UMULT		#003H
		TO		R4
		ADD		R4			;vbg x|WV { R   xTCY
;
		LM		R9, MSG_Xpos		;vbg w|WV ۑ
;
		LM		R0, MSG_Char		;tHgf[^AhX vZ
		LOB
		UMULT		#00CH
		IWT		R1, #MSG_FONT
		TO		R14
		ADD		R1
;
		IWT		R13, #MSG_PUTC_XY20	;[v AhX Zbg
;
		IBT		R11, #00CH		;tHg xTCY
MSG_PUTC_XY10
		GETB					;tHg f[^ Qbg
		INC		R14
		TO		R10
		SWAP
;
		IBT		R12, #008H
		IBT		R3, #000H		;w|WV
MSG_PUTC_XY20
		WITH		R10
		ADD		R10
		BCC		MSG_PUTC_XY30		;vbg ? N:MSG_PUTC_XY30
		NOP
		FROM		R9			;vbg w|WV vZ
		TO		R7
		ADD		R3
		MOVE		R2, R4			;vbg x|WV Zbg
		MOVE		R8, R6			;hbg xTCY
MSG_PUTC_XY40
		MOVE		R1, R7			;vbg w|WV Zbg
		MOVE		R0, R5			;hbg wTCY
MSG_PUTC_XY50
		DEC		R0
		BNE		MSG_PUTC_XY50		;hbg w vbg I ? N:MSG_PUTC_XY50
		PLOT
		DEC		R8
		BNE		MSG_PUTC_XY40		;hbgx vbg I ? N:MSG_PUTC_XY40
		INC		R2
MSG_PUTC_XY30
		WITH		R3			;̂w|WV
		ADD		R5
		LOOP					;PI ? N:MSG_PUTC_XY20
		NOP
		WITH		R4			;̂x|WV
		ADD		R6
		DEC		R11
		BNE		MSG_PUTC_XY10		;cPI ? N:MSG_PUTC_XY10
		NOP
;
		RPIX
;
		LM		R0, MSG_Poit		;|C^[ ̈ʒu
		INC		R0
		SBK
;
		LM		R0, MSG_Char		;tHg wTCYf[^ AhX vZ
		LOB
		IWT		R1, #MSG_FONT_X
		TO		R14
		ADD		R1
		GETB
		UMULT		R5
		TO		R1
		ADD		R9
		IWT		R0, #MSG_X_AREA
		FROM		R1
		SUB		R0
		BCC		MSG_PUTC_XY100		;s ? N: MSG_PUTC_XY100
		NOP
		IBT		R1, #000H		;vbg w|WV s
		LM		R0, MSG_Ypos		;s MSG_Ypos + 10H *  wTCY
		IBT		R2, #010H
		WITH		R2
		UMULT		R6
		IWT		R0, #MSG_Y_AREA
		FROM		R2
		SUB		R0
		BCC		MSG_PUTC_XY110		;y[W ? N: MSG_PUTC_XY110
		NOP
;;;;K;;;;		IBT		R2, #000H		;vbg x|WV y[W擪
		IBT		R2, #010H		;vbg x|WV y[W擪
MSG_PUTC_XY110
		SM		R2, MSG_Ypos
MSG_PUTC_XY100
		SM		R1, MSG_Xpos		;vbg w|WV XV
;
		mDJMP		MSG_PROC
;
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	bZ[W GA NA		+
;++++++++++++++++++++++++++++++++++++++++++++++++
MSG_CODE_00
		IWT		R1, #MSGBITMP
		IWT		R12, #( 800H + 200H) / 2
		BRA		MSG_CODE_CLS
		NOP
;
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	bZ[W Ps NA		+
;++++++++++++++++++++++++++++++++++++++++++++++++
MSG_CODE_01
		IWT		R1, #MSGBITMP + 200H * 0
		IWT		R12, #800H / (2 * 4)
		BRA		MSG_CODE_CLS
		NOP
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	bZ[W Qs NA		+
;++++++++++++++++++++++++++++++++++++++++++++++++
MSG_CODE_02
		IWT		R1, #MSGBITMP + 200H * 1
		IWT		R12, #800H / (2 * 4)
		BRA		MSG_CODE_CLS
		NOP
;
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	bZ[W Rs NA		+
;++++++++++++++++++++++++++++++++++++++++++++++++
MSG_CODE_03
		IWT		R1, #MSGBITMP + 200H * 2
		IWT		R12, #800H / (2 * 4)
		BRA		MSG_CODE_CLS
		NOP
;
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	bZ[W Ss NA		+
;++++++++++++++++++++++++++++++++++++++++++++++++
MSG_CODE_04
		IWT		R1, #MSGBITMP + 200H * 3
		IWT		R12, #800H / (2 * 4)
		BRA		MSG_CODE_CLS
		NOP
;
;
;++++++++++++++++++++++++++++++++++++++++
;+	NA Tu[`		+
;++++++++++++++++++++++++++++++++++++++++
MSG_CODE_CLS
		IWT		R0, #000FFH
		MOVE		R13, R15
		STW		(R1)
		INC		R1
		LOOP
		INC		R1
		IWT		R15,#MSG_CODE_INC
		NOP
;
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+		PsڂɈړ			+
;++++++++++++++++++++++++++++++++++++++++++++++++
MSG_CODE_05
		IBT		R0, #000H
		SM		R0, MSG_Xpos
		IBT		R0, #010H
		SM		R0, MSG_Ypos
		IWT		R15,#MSG_CODE_INC
		NOP
;
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+		QsڂɈړ			+
;++++++++++++++++++++++++++++++++++++++++++++++++
MSG_CODE_06
		IBT		R0, #000H
		SM		R0, MSG_Xpos
		IBT		R0, #020H
		SM		R0, MSG_Ypos
		IWT		R15,#MSG_CODE_INC
		NOP
;
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+		RsڂɈړ			+
;++++++++++++++++++++++++++++++++++++++++++++++++
MSG_CODE_07
		IBT		R0, #000H
		SM		R0, MSG_Xpos
		IBT		R0, #030H
		SM		R0, MSG_Ypos
		IWT		R15,#MSG_CODE_INC
		NOP
;
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+		SsڂɈړ			+
;++++++++++++++++++++++++++++++++++++++++++++++++
MSG_CODE_08
		IBT		R0, #000H
		SM		R0, MSG_Xpos
		IBT		R0, #040H
		SM		R0, MSG_Ypos
		IWT		R15,#MSG_CODE_INC
		NOP
;
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+		s				+
;++++++++++++++++++++++++++++++++++++++++++++++++
MSG_CODE_09
		LM		R0, MSG_Ypos
		IBT		R1, #040H
		INC		R0
		ADD		#00FH
		CMP		R1
		BCC		MSG_CODE_09_5
		NOP
		IBT		R0,#010H
MSG_CODE_09_5
		SBK
		IWT		R15,#MSG_CODE_INC
		NOP
;;;;K;;;;		LM		R0, MSG_Ypos
;;;;K;;;;		IBT		R1, #030H
;;;;K;;;;		INC		R0
;;;;K;;;;		ADD		#00FH
;;;;K;;;;		AND		R1
;;;;K;;;;		SBK
;;;;K;;;;		IWT		R15,#MSG_CODE_INC
;;;;K;;;;		NOP
;
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+		L[͑҂			+
;++++++++++++++++++++++++++++++++++++++++++++++++
MSG_CODE_0A
		IWT		R0,#004C0H
		LM		R1,MSG_KeyAT
		AND		R1
		BEQ		MSG_CODE_0F
		NOP
		IBT		R0,#05CH
		SMS		R0,CMSOUND3	; sound set!!
;
MSG_CODE_0F
		IWT		R0,#004C0H
		LM		R1,MSG_KeyAT
		AND		R1
		BEQ		MSG_CODE_0A_90
		NOP
		LM		R0,MSG_Poit
		INC		R0
		INC		R0
		SBK
;
MSG_CODE_0A_90
		mDJMP		MSG_EXIT
;
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+		tF[hC			+
;++++++++++++++++++++++++++++++++++++++++++++++++
MSG_CODE_0B
;		LM		R0, MSG_Fade
;		INC		R0
;		SBK
;		MOVE		R1, R0
;		IBT		R2, #01FH
;		SUB		R2
;		BCC		MSG_CODE_0B_10
;		NOP
;		LM		R0, MSG_Poit		;|C^[ ̈ʒu
;		INC		R0
;		INC		R0
;		SBK
;MSG_CODE_0B_10
;		FROM		R1
;		ADD		R1
;		ADD		R0
;		ADD		R0
;		ADD		R0
;		ADD		R0
;		ADD		R1
;		ADD		R0
;		ADD		R0
;		ADD		R0
;		ADD		R0
;		ADD		R0
;		ADD		R1
;		SM		R0, DATACOL + 32H
;		IWT		R1, #003E0H
;		AND		R1
;		SM		R0, DATACOL + 36H
;;		SM		R0, DATACOL + 3CH
;;		SM		R0, DATACOL + 3EH
;;
;		mDJMP		MSG_PROC_EXIT
;
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+		tF[hAEg			+
;++++++++++++++++++++++++++++++++++++++++++++++++
MSG_CODE_0C
;		LM		R0, MSG_Fade
;		DEC		R0
;		SBK
;		MOVES		R1,R0
;		BNE		MSG_CODE_0C_10
;		NOP
;		LM		R0, MSG_Poit		;|C^[ ̈ʒu
;		INC		R0
;		INC		R0
;		SBK
;MSG_CODE_0C_10
;		FROM		R1
;		ADD		R1
;		ADD		R0
;		ADD		R0
;		ADD		R0
;		ADD		R0
;		ADD		R1
;		ADD		R0
;		ADD		R0
;		ADD		R0
;		ADD		R0
;		ADD		R0
;		ADD		R1
;		SM		R0, DATACOL + 32H
;		SM		R0, DATACOL + 36H
;;		SM		R0, DATACOL + 3CH
;;		SM		R0, DATACOL + 3EH
;;
;		mDJMP		MSG_PROC_EXIT
;;
;;
;;
;;
;;
;
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	bZ[W Ts NA		+
;+		TsڂɈړ			+
;++++++++++++++++++++++++++++++++++++++++++++++++
MSG_CODE_0D
MSG_CODE_0E
		IWT		R1, #MSGBITMP + 200H * 4
		IWT		R12, #800H / (2 * 4)
		IWT		R0, #000FFH
		MOVE		R13, R15
		STW		(R1)
		INC		R1
		LOOP
		INC		R1
;
		IBT		R0, #000H
		SM		R0, MSG_Xpos
		IBT		R0, #050H
		SM		R0, MSG_Ypos
		IWT		R15,#MSG_CODE_INC
		NOP
;
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+		cPUhbgXN[		+
;++++++++++++++++++++++++++++++++++++++++++++++++
MSG_CODE_10
		IWT		R12, #800H / 2 / 4
		IWT		R1, #MSGBITMP + 200H * 0
		IWT		R2, #MSGBITMP + 200H * 1
		IWT		R3, #MSGBITMP + 200H * 2
		IWT		R4, #MSGBITMP + 200H * 3
		IWT		R5, #000FFH
		MOVE		R13, R15
		LDW		(R2)
		STW		(R1)
		INC		R1
		INC		R1
		LDW		(R3)
		STW		(R2)
		INC		R2
		INC		R2
		LDW		(R4)
		STW		(R3)
		INC		R3
		INC		R3
		FROM		R5
		STW		(R4)
		INC		R4
		LOOP
		INC		R4
		IWT		R15,#MSG_CODE_INC
		NOP
;
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+		cPhbgXN[		+
;++++++++++++++++++++++++++++++++++++++++++++++++
MSG_CODE_11
		IWT		R0, #001H
		IWT		R15,#MSG_CODE_SCR
		NOP
;
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+		cQhbgXN[		+
;++++++++++++++++++++++++++++++++++++++++++++++++
MSG_CODE_12
		IBT		R0, #002H
		IWT		R15,#MSG_CODE_SCR
		NOP
;
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+		cRhbgXN[		+
;++++++++++++++++++++++++++++++++++++++++++++++++
MSG_CODE_13
		IBT		R0, #003H
		IWT		R15,#MSG_CODE_SCR
		NOP
;
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+		cShbgXN[		+
;++++++++++++++++++++++++++++++++++++++++++++++++
MSG_CODE_14
		IBT		R0, #004H
		IWT		R15,#MSG_CODE_SCR
		NOP
;
;
;
;
;
MSG_CODE_15
MSG_CODE_16
MSG_CODE_17
MSG_CODE_18
MSG_CODE_19
MSG_CODE_1A
MSG_CODE_1B
MSG_CODE_1C
MSG_CODE_1D
MSG_CODE_1E
MSG_CODE_1F
;
;
;++++++++++++++++++++++++++++++++++++++++
;+	cXN[ Tu[`	+
;+			in		+
;+			R0 <- hbg	+
;++++++++++++++++++++++++++++++++++++++++
MSG_CODE_SCR
		ADC	R0
		IWT	R1, #MSGBITMP
		MOVE	R2,R1
		TO	R2
		ADC	R2
		IBT	R5, #010H
		IWT	R6,#MSGBITMP+200H*5
		IWT	R13,#MSG_CODE_SCR_1
;
MSG_CODE_SCR_0
		MOVE	R12,R5
		MOVE	R4,R2
		MOVE	R3,R1
MSG_CODE_SCR_1
		LDW	(R4)		; ]
		STW	(R3)		; ]
		WITH	R4
		ADC	R5
		WITH	R3
		ADC	R5
		LOOP
		NOP
;
		INC	R2
		INC	R2
		FROM	R5
		AND	R2
		BEQ	MSG_CODE_SCR_2
		NOP
		IWT	R0,#0FF00H
		AND	R2
		IWT	R2,#00100H
		TO	R2
		ADC	R2
MSG_CODE_SCR_2
		INC	R1
		INC	R1
		FROM	R5
		AND	R1
		BEQ	MSG_CODE_SCR_3
		NOP
		IWT	R0,#0FF00H
		AND	R1
		IWT	R1,#00100H
		TO	R1
		ADC	R1
MSG_CODE_SCR_3
		FROM	R1
		CMP	R6
		BCC	MSG_CODE_SCR_0
		NOP
		LM	R0,MSG_Poit
		INC	R0
		INC	R0
		SBK
		mDJMP	MSG_EXIT
;
;
;
;
MSG_CODE_20
MSG_CODE_21
MSG_CODE_22
MSG_CODE_23
MSG_CODE_24
MSG_CODE_25
MSG_CODE_26
MSG_CODE_27
MSG_CODE_28
MSG_CODE_29
MSG_CODE_2A
MSG_CODE_2B
MSG_CODE_2C
MSG_CODE_2D
MSG_CODE_2E
MSG_CODE_2F
;
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+		TCY cP P		+
;++++++++++++++++++++++++++++++++++++++++++++++++
MSG_CODE_30
		IBT		R0, #MSG_siz0
		SM		R0, MSG_Xsiz		; wTCY Zbg
		SM		R0, MSG_Ysiz		; xTCY Zbg
		IWT		R15,#MSG_CODE_INC
		NOP
;
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+		TCY cQ Q		+
;++++++++++++++++++++++++++++++++++++++++++++++++
MSG_CODE_31
		IBT		R0, #MSG_siz1
		SM		R0, MSG_Xsiz		; wTCY Zbg
		SM		R0, MSG_Ysiz		; xTCY Zbg
		IWT		R15,#MSG_CODE_INC
		NOP
;
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+		TCY cR R		+
;++++++++++++++++++++++++++++++++++++++++++++++++
MSG_CODE_32
		IBT		R0, #MSG_siz2
		SM		R0, MSG_Xsiz		; wTCY Zbg
		SM		R0, MSG_Ysiz		; xTCY Zbg
		IWT		R15,#MSG_CODE_INC
		NOP
;
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+		TCY cS S		+
;++++++++++++++++++++++++++++++++++++++++++++++++
MSG_CODE_33
		IBT		R0, #MSG_siz3
		SM		R0, MSG_Xsiz		; wTCY Zbg
		SM		R0, MSG_Ysiz		; xTCY Zbg
		IWT		R15,#MSG_CODE_INC
		NOP
;
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+		TCY cP			+
;++++++++++++++++++++++++++++++++++++++++++++++++
MSG_CODE_34
		IBT		R0, #MSG_siz0
		SM		R0, MSG_Ysiz		; xTCY Zbg
		IWT		R15,#MSG_CODE_INC
		NOP
;
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+		TCY cQ			+
;++++++++++++++++++++++++++++++++++++++++++++++++
MSG_CODE_35
		IBT		R0, #MSG_siz1
		SM		R0, MSG_Ysiz		; xTCY Zbg
		IWT		R15,#MSG_CODE_INC
		NOP
;
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;		TCY cR			+
;++++++++++++++++++++++++++++++++++++++++++++++++
MSG_CODE_36
		IBT		R0, #MSG_siz2
		SM		R0, MSG_Ysiz		; xTCY Zbg
		IWT		R15,#MSG_CODE_INC
		NOP
;
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+		TCY cS			+
;++++++++++++++++++++++++++++++++++++++++++++++++
MSG_CODE_37
		IBT		R0, #MSG_siz3
		SM		R0, MSG_Ysiz		; xTCY Zbg
		IWT		R15,#MSG_CODE_INC
		NOP
;
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+		TCY P			+
;++++++++++++++++++++++++++++++++++++++++++++++++
MSG_CODE_38
		IBT		R0, #MSG_siz0
		SM		R0, MSG_Xsiz		; wTCY Zbg
		IWT		R15,#MSG_CODE_INC
		NOP
;
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+		TCY Q			+
;++++++++++++++++++++++++++++++++++++++++++++++++
MSG_CODE_39
		IBT		R0, #MSG_siz1
		SM		R0, MSG_Xsiz		; wTCY Zbg
		IWT		R15,#MSG_CODE_INC
		NOP
;
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+		TCY R			+
;++++++++++++++++++++++++++++++++++++++++++++++++
MSG_CODE_3A
		IBT		R0, #MSG_siz2
		SM		R0, MSG_Xsiz		; wTCY Zbg
		IWT		R15,#MSG_CODE_INC
		NOP
;
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+		TCY S			+
;++++++++++++++++++++++++++++++++++++++++++++++++
MSG_CODE_3B
		IBT		R0, #MSG_siz3
		SM		R0, MSG_Xsiz		; wTCY Zbg
		IWT		R15,#MSG_CODE_INC
		NOP
;
;
;
;
;
MSG_CODE_3C
;
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	v[[cl S̈		+
;++++++++++++++++++++++++++++++++++++++++++++++++
MSG_CODE_3D
		IWT		R6, #000A0H
		IWT		R5, #000D0H
		IBT		R1, #00100
		IBT		R2, #00010
		IBT		R3, #000
		IBT		R4, #000
		LM		R0, MSG_PLCT
CODE_3D_020
		SUB		R1		; S̈
		BPL		CODE_3D_020
		INC		R3
		ADD		R1
		DEC		R3
		BEQ		CODE_3D_040
		NOP
		FROM		R6
		TO		R5
		ADD		R3
;
CODE_3D_040
		SUB		R2		; \̈
		BPL		CODE_3D_040
		INC		R4
		DEC		R4
		ADD		R2		; low --> \̈
		SWAP				;
		OR		R4		; high -> ̈
		SM		R0, MSG_PLCT_BF ;
		BRA		PL_CT_SET
		NOP
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	v[[cl \̈		+
;++++++++++++++++++++++++++++++++++++++++++++++++
MSG_CODE_3E
		LM		R0, MSG_PLCT_BF
		IWT		R4, #000A0H
		IWT		R5, #000D0H
		LM		R1, MSG_PLCT
		IBT		R2, #010
		FROM		R1
		CMP		R2
		BCC		PL_CT_SET
		TO		R5
		ADD		R4
		BRA		PL_CT_SET
		NOP
;
;
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	v[[cl ̈		+
;++++++++++++++++++++++++++++++++++++++++++++++++
MSG_CODE_3F
		LM		R0, MSG_PLCT_BF
		HIB
;
		IWT		R4, #000A0H
		TO		R5
		ADD		R4
;
PL_CT_SET
		SM		R5, MSG_Char
		LM		R0,  MSG_Poit
		INC		R0
		SM		R0,  MSG_Poit
;
		mDJMP		MSG_PUTC		;\
;
MSG_CODE_40
MSG_CODE_41
MSG_CODE_42
MSG_CODE_43
MSG_CODE_44
MSG_CODE_45
MSG_CODE_46
MSG_CODE_47
MSG_CODE_48
MSG_CODE_49
MSG_CODE_4A
MSG_CODE_4B
MSG_CODE_4C
MSG_CODE_4D
MSG_CODE_4E
MSG_CODE_4F
		mDJMP		MSG_EXIT
;
;
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+		c  IJ[\ 				+
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;
 IF  NES | PAL ;**** NES or PAL Ή [1995/7/19] *****************
MSG_CODE_5_DT0
		BYTE	007H,040H	;  ړ
		BYTE	002H,020H	; c ړ
;
MSG_CODE_5_DT1
		BYTE	034H,040H	;  ړ
		BYTE	002H,030H	; c ړ
 ENDIF	     ;**** NES or PAL Ή [1995/7/19] *******************
;
;
 IF  JPN  ;**** { Ή [1995/6/30] ****************************
MSG_CODE_5_DT0
		BYTE	00AH,040H	;  ړ
		BYTE	014H,020H	; c ړ
;
MSG_CODE_5_DT1
		BYTE	03CH,040H	;  ړ
		BYTE	014H,030H	; c ړ
 ENDIF	  ;**** { Ή [1995/6/30] ****************************
;
MSG_CODE_5_KY0
;			    c
		BYTE	002H,008H
;
MSG_CODE_5_KY1
;			    c
		BYTE	001H,004H
;
;
MSG_CODE_50
MSG_CODE_51
		LM		R1,MSG_KeyAT
		WITH		R1
		SWAP
		IWT		R0,#0C0C0H
		AND		R1
		BEQ		MSG_CODE_50_10
		NOP
		IBT		R1, #043H
		LM		R0, MSG_ANS
		AND		#001
		BEQ		MSG_CODE_50_05
		NOP
		IBT		R1, #02EH
		IBT		R0, #MSG_exit
		SM		R0, MSG_Stat
MSG_CODE_50_05
		SMS		R1, CMSOUND3	; sound set!!
		LM		R0, MSG_Poit
		INC		R0
		INC		R0
		SBK
		mDJMP		MSG_EXIT
;
MSG_CODE_50_10
		LM		R0, MSG_Char
		SWAP
;;;;K;;;;		AND		#00FH
		AND		#001H
		IWT		R14, #MSG_CODE_5_KY0
		TO		R14
		ADD		R14
		GETB
		AND		R1			; EL[nm ?
		BEQ		MSG_CODE_50_20		;	NO -> MSG_CODE_50_20
		NOP
		IBT		R0, #05CH
		SMS		R0, CMSOUND3	; sound set!!
		IBT		R0, #000H
		SM		R0, MSG_ANS
		IWT		R0, #000D4H
		SM		R0, MSG_1Putc_C
		LM		R0, MSG_Char
		SWAP
;;;;K;;;;		AND		#00FH
		AND		#001H
		ADD		R0
		IWT		R14, #MSG_CODE_5_DT0
		TO		R14
		ADD		R14
		GETB
		SM		R0, MSG_1Putc_X
		INC		R14
		GETB
		SM		R0, MSG_1Putc_Y
		IWT		R0, #MSG_CODE_50_30
		SM		R0, MSG_1Putc_Rts
		mDJMP		MSG_1PUTC
MSG_CODE_50_30
		IWT		R0, #000D0H
		SM		R0, MSG_1Putc_C
		LM		R0, MSG_Char
		SWAP
;;;;K;;;;		AND		#00FH
		AND		#001H
		ADD		R0
		IWT		R14, #MSG_CODE_5_DT1
		TO		R14
		ADD		R14
		GETB
		SM		R0, MSG_1Putc_X
		INC		R14
		GETB
		SM		R0, MSG_1Putc_Y
		IWT		R0, #MSG_EXIT
		SM		R0, MSG_1Putc_Rts
		mDJMP		MSG_1PUTC
;
MSG_CODE_50_20
		LM		R0, MSG_Char
		SWAP
;;;;K;;;;		AND		#00FH
		AND		#001H
		IWT		R14, #MSG_CODE_5_KY1
		TO		R14
		ADD		R14
		GETB
		AND		R1			; ㉺L[nm ?
		BEQ		MSG_CODE_50_40		;	NO -> MSG_CODE_50_40
		NOP
		IBT		R0, #05CH
		SMS		R0, CMSOUND3	; sound set!!
		IBT		R0, #001H
		SM		R0, MSG_ANS
		IWT		R0, #000D4H
		SM		R0, MSG_1Putc_C
		LM		R0, MSG_Char
		SWAP
;;;;K;;;;		AND		#00FH
		AND		#001H
		ADD		R0
		IWT		R14, #MSG_CODE_5_DT1
		TO		R14
		ADD		R14
		GETB
		SM		R0, MSG_1Putc_X
		INC		R14
		GETB
		SM		R0, MSG_1Putc_Y
		IWT		R0, #MSG_CODE_50_50
		SM		R0, MSG_1Putc_Rts
		mDJMP		MSG_1PUTC
MSG_CODE_50_50
		IWT		R0, #000D0H
		SM		R0, MSG_1Putc_C
		LM		R0, MSG_Char
		SWAP
;;;;K;;;;		AND		#00FH
		AND		#001H
		ADD		R0
		IWT		R14, #MSG_CODE_5_DT0
		TO		R14
		ADD		R14
		GETB
		SM		R0, MSG_1Putc_X
		INC		R14
		GETB
		SM		R0, MSG_1Putc_Y
		IWT		R0, #MSG_EXIT
		SM		R0, MSG_1Putc_Rts
		mDJMP		MSG_1PUTC
;
MSG_CODE_50_40
		mDJMP		MSG_EXIT
;
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+		RtBO^Cv؂芷			+
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
MSG_CODE_52
		LM		R0,  MSG_KeyAT
		IWT		R1,  #0C0C0H
		AND		R1
		BEQ		MSG_CODE_52_10
		NOP
		LM		R0,  MSG_ANS
		AND		#001
		BEQ		MSG_CODE_52_10
		NOP
		LM		R0,  CCONFIGFG
		XOR		#002
		SM		R0,  CCONFIGFG
;
MSG_CODE_52_10
		IWT		R15, #MSG_CODE_50
		NOP
;
;
;;;;K;;;;;
;;;;K;;;;;
;;;;K;;;;;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;;;;K;;;;;+		g`hCgxh\؂芷			+
;;;;K;;;;;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;;;;K;;;;MSG_A_Y_DT
;;;;K;;;;		BYTE	0C2H,0AAH
;;;;K;;;;;
;;;;K;;;;;
;;;;K;;;;MSG_CODE_52
;;;;K;;;;		IWT		R14, #MSG_A_Y_DT
;;;;K;;;;		LM		R0,  CCONFIGFG
;;;;K;;;;		AND		#002
;;;;K;;;;		LSR
;;;;K;;;;		TO		R14
;;;;K;;;;		ADD		R14
;;;;K;;;;		GETB
;;;;K;;;;		SM		R0,  MSG_Char
;;;;K;;;;;
;;;;K;;;;		LM		R0,  MSG_Poit
;;;;K;;;;		INC		R0
;;;;K;;;;		SM		R0,  MSG_Poit
;;;;K;;;;;
;;;;K;;;;		mDJMP		MSG_PUTC		;\
;
;
MSG_CODE_53
MSG_CODE_54
MSG_CODE_55
MSG_CODE_56
MSG_CODE_57
MSG_CODE_58
MSG_CODE_59
MSG_CODE_5A
MSG_CODE_5B
MSG_CODE_5C
MSG_CODE_5D
MSG_CODE_5E
MSG_CODE_5F
		mDJMP		MSG_EXIT
;
MSG_CODE_60
		CACHE
;
		LM		R0,MSG_BNK
		ROMB				;a`mjZbg
;
		LM		R0, MSG_Poit
		TO		R14
		ADD		#002
		GETB
		INC		R14
		LSR
		LSR
		LSR
		MOVE		R11, R0		;Xpos
		MOVE		R10, R0		;Xpos BAK
		GETB
		INC		R14
		GETBH
		INC		R14
		ADD		R0
		ADD		R0
		ADD		R0
		TO		R9		;Ypos
		ADD		R0
		GETB
		INC		R14
		ADD		#7
		LSR
		LSR
		TO		R8		;X SIZE
		LSR
		TO		R7		;Y SIZE
		GETB
		INC		R14
		TO		R3		;X PLOT POS
		GETB
		INC		R14
		GETB
		TO		R2		;Y PLOT POS
		ADD		#00FH
		INC		R1
;
		IBT		R0,#BANK MSG_CORE
		ROMB				;a`mjZbg
;
MSG_CODE_60_10
		MOVE		R1, R3
		MOVE		R11, R10
		MOVE		R12, R8
		MOVE		R13, R15
;
		IWT		R0, #MSG_PICT
		ADD		R9
		TO		R14
		ADD		R11
		GETBH
		ADD		R0
		BCC		MSG_CODE_60_20
		INC		R1
		DEC		R1
		PLOT
MSG_CODE_60_20
		ADD		R0
		BCC		MSG_CODE_60_30
		INC		R1
		DEC		R1
		PLOT
MSG_CODE_60_30
		ADD		R0
		BCC		MSG_CODE_60_40
		INC		R1
		DEC		R1
		PLOT
MSG_CODE_60_40
		ADD		R0
		BCC		MSG_CODE_60_50
		INC		R1
		DEC		R1
		PLOT
MSG_CODE_60_50
		ADD		R0
		BCC		MSG_CODE_60_60
		INC		R1
		DEC		R1
		PLOT
MSG_CODE_60_60
		ADD		R0
		BCC		MSG_CODE_60_70
		INC		R1
		DEC		R1
		PLOT
MSG_CODE_60_70
		ADD		R0
		BCC		MSG_CODE_60_80
		INC		R1
		DEC		R1
		PLOT
MSG_CODE_60_80
		ADD		R0
		BCC		MSG_CODE_60_90
		INC		R1
		DEC		R1
		PLOT
MSG_CODE_60_90
		LOOP
		INC		R11
;
		WITH		R9
		ADD		#00FH
		INC		R9
		DEC		R7
		BNE		MSG_CODE_60_10
		INC		R2
;
		LM		R0, MSG_Poit
		ADD		#009
		SM		R0, MSG_Poit
;
		mDJMP		MSG_EXIT
MSG_CODE_61
MSG_CODE_62
MSG_CODE_63
MSG_CODE_64
MSG_CODE_65
MSG_CODE_66
MSG_CODE_67
MSG_CODE_68
MSG_CODE_69
MSG_CODE_6A
MSG_CODE_6B
MSG_CODE_6C
MSG_CODE_6D
MSG_CODE_6E
MSG_CODE_6F
;
MSG_CODE_70
MSG_CODE_71
MSG_CODE_72
MSG_CODE_73
MSG_CODE_74
MSG_CODE_75
MSG_CODE_76
MSG_CODE_77
MSG_CODE_78
MSG_CODE_79
MSG_CODE_7A
MSG_CODE_7B
MSG_CODE_7C
MSG_CODE_7D
MSG_CODE_7E
MSG_CODE_7F
;
MSG_CODE_80
MSG_CODE_81
MSG_CODE_82
MSG_CODE_83
MSG_CODE_84
MSG_CODE_85
MSG_CODE_86
MSG_CODE_87
MSG_CODE_88
MSG_CODE_89
MSG_CODE_8A
MSG_CODE_8B
MSG_CODE_8C
MSG_CODE_8D
MSG_CODE_8E
MSG_CODE_8F
;
MSG_CODE_90
MSG_CODE_91
MSG_CODE_92
MSG_CODE_93
MSG_CODE_94
MSG_CODE_95
MSG_CODE_96
MSG_CODE_97
MSG_CODE_98
MSG_CODE_99
MSG_CODE_9A
MSG_CODE_9B
MSG_CODE_9C
MSG_CODE_9D
MSG_CODE_9E
MSG_CODE_9F
;
MSG_CODE_A0
MSG_CODE_A1
MSG_CODE_A2
MSG_CODE_A3
MSG_CODE_A4
MSG_CODE_A5
MSG_CODE_A6
MSG_CODE_A7
MSG_CODE_A8
MSG_CODE_A9
MSG_CODE_AA
MSG_CODE_AB
MSG_CODE_AC
MSG_CODE_AD
MSG_CODE_AE
MSG_CODE_AF
;
MSG_CODE_B0
MSG_CODE_B1
MSG_CODE_B2
MSG_CODE_B3
MSG_CODE_B4
MSG_CODE_B5
MSG_CODE_B6
MSG_CODE_B7
MSG_CODE_B8
MSG_CODE_B9
MSG_CODE_BA
MSG_CODE_BB
MSG_CODE_BC
MSG_CODE_BD
MSG_CODE_BE
MSG_CODE_BF
;
MSG_CODE_C0
MSG_CODE_C1
MSG_CODE_C2
MSG_CODE_C3
MSG_CODE_C4
MSG_CODE_C5
MSG_CODE_C6
MSG_CODE_C7
MSG_CODE_C8
MSG_CODE_C9
MSG_CODE_CA
MSG_CODE_CB
MSG_CODE_CC
MSG_CODE_CD
MSG_CODE_CE
MSG_CODE_CF
;
MSG_CODE_D0
MSG_CODE_D1
MSG_CODE_D2
MSG_CODE_D3
MSG_CODE_D4
MSG_CODE_D5
MSG_CODE_D6
MSG_CODE_D7
MSG_CODE_D8
MSG_CODE_D9
MSG_CODE_DA
MSG_CODE_DB
MSG_CODE_DC
MSG_CODE_DD
MSG_CODE_DE
MSG_CODE_DF
;
MSG_CODE_E0
MSG_CODE_E1
MSG_CODE_E2
MSG_CODE_E3
MSG_CODE_E4
MSG_CODE_E5
MSG_CODE_E6
MSG_CODE_E7
MSG_CODE_E8
MSG_CODE_E9
MSG_CODE_EA
MSG_CODE_EB
MSG_CODE_EC
MSG_CODE_ED
MSG_CODE_EE
MSG_CODE_EF
;
MSG_CODE_F0
MSG_CODE_F1
MSG_CODE_F2
MSG_CODE_F3
MSG_CODE_F4
MSG_CODE_F5
MSG_CODE_F6
MSG_CODE_F7
MSG_CODE_F8
MSG_CODE_F9
MSG_CODE_FA
MSG_CODE_FB
MSG_CODE_FC
MSG_CODE_FD
MSG_CODE_FE
MSG_CODE_FF
		IBT		R0, #MSG_exit
		SM		R0, MSG_Stat		;bZ[W Xe[^X q`l <-- MSG_exit
		mDJMP		MSG_PROC_EXIT
;
;
;++++++++++++++++++++++++++++++++++++++++
;+	̃|C^ Zbg		+
;++++++++++++++++++++++++++++++++++++++++
MSG_CODE_INC
		LM		R0, MSG_Poit		;|C^[ ̈ʒu
		INC		R0
		INC		R0
		SBK
;
		mDJMP		MSG_PROC
;
;
;
;
;
MSG_PROC_EXIT	;bZ[W vZX COWbg
;		IWT		R1, #MSGBITMP		;rbg}bvGA O
;		IWT		R2, #MSGBITMP + 401H	;rbg}bvGA 㔼
;		IWT		R3, #MSGDMABF		;cl`]p rbg}bvGA
;;
;		IWT		R12, #00400H / 2	;rbg}bvGAOƃrbg}bvGA㔼
;		MOVE		R13, R15		;ghfgoCgȂ
;		LDB		(R1)
;		INC		R1
;		INC		R1
;		TO		R4
;		LDW		(R2)
;		INC		R2
;		INC		R2
;		OR		R4
;		STW		(R3)
;		INC		R3
;		LOOP
;		INC		R3
;;
		STOP
		NOP
;
;
;
;
;
;*======================================================================*
;|	P \							|
;*======================================================================*
MSG_1PUTC	;bZ[W \
		mCOLOUR		001H		;bnkntq Zbg
;
		LM		R8, MSG_1Putc_X
		LM		R2, MSG_1Putc_Y
;
		IBT		R0, #010
		LM		R1, MSG_Xsiz
		INC		R1
		TO		R6
		MULT		R1
;
		IBT		R0, #016
		LM		R1, MSG_Ysiz
		INC		R1
		TO		R7
		MULT		R1
MSG_1PUTC_CLR_10
;
		MOVE		R1, R8
		MOVE		R12, R6
		MOVE		R13, R15
;
		LOOP
		PLOT
;
		DEC		R7
		BNE		MSG_1PUTC_CLR_10
		INC		R2
;
;
;
		mCOLOUR		003H		;bnkntq Zbg
		LM		R0, MSG_Ysiz		;R0 <-- MSG_Ysiz * 4 + MSG_Xsiz
		ADD		R0
		ADD		R0
		LM		R1, MSG_Xsiz
		OR		R1
		mJSRSUB
		mTWORD		MSG_1PUTC_X0Y0		;wP{ xP{
		mTWORD		MSG_1PUTC_X1Y0		;wQ{ xP{
		mTWORD		MSG_1PUTC_X2Y0		;wR{ xP{
		mTWORD		MSG_1PUTC_X3Y0		;wS{ xP{
		mTWORD		MSG_1PUTC_X0Y1		;wP{ xQ{
		mTWORD		MSG_1PUTC_X1Y1		;wQ{ xQ{
		mTWORD		MSG_1PUTC_X2Y1		;wR{ xQ{
		mTWORD		MSG_1PUTC_X3Y1		;wS{ xQ{
		mTWORD		MSG_1PUTC_X0Y2		;wP{ xR{
		mTWORD		MSG_1PUTC_X1Y2		;wQ{ xR{
		mTWORD		MSG_1PUTC_X2Y2		;wR{ xR{
		mTWORD		MSG_1PUTC_X3Y2		;wS{ xR{
		mTWORD		MSG_1PUTC_X0Y3		;wP{ xS{
		mTWORD		MSG_1PUTC_X1Y3		;wQ{ xS{
		mTWORD		MSG_1PUTC_X2Y3		;wR{ xS{
		mTWORD		MSG_1PUTC_X3Y3		;wS{ xS{
;
MSG_1PUTC_X0Y0	;wP{ xP{
		LM		R0, MSG_1Putc_C		;tHgf[^AhX vZ
		LOB
		UMULT		#00CH
		IWT		R1, #MSG_FONT
		TO		R14
		ADD		R1
;
		LM		R0, MSG_1Putc_Y		;vbg x|WV Zbg
		TO		R2
		ADD		#003H			;vbg x|WV { R
;
		LM		R3, MSG_1Putc_X		;vbg w|WV ۑ
;
		IBT		R12, #00CH
		MOVE		R13, R15
		MOVE		R1, R3			;vbg w|WV Zbg
		GETB
		INC		R14
		SWAP
		ADD		R0
		BCC		MSG_1PUTC10
		INC		R1
		DEC		R1
		PLOT
MSG_1PUTC10
		ADD		R0
		BCC		MSG_1PUTC20
		INC		R1
		DEC		R1
		PLOT
MSG_1PUTC20
		ADD		R0
		BCC		MSG_1PUTC30
		INC		R1
		DEC		R1
		PLOT
MSG_1PUTC30
		ADD		R0
		BCC		MSG_1PUTC40
		INC		R1
		DEC		R1
		PLOT
MSG_1PUTC40
		ADD		R0
		BCC		MSG_1PUTC50
		INC		R1
		DEC		R1
		PLOT
MSG_1PUTC50
		ADD		R0
		BCC		MSG_1PUTC60
		INC		R1
		DEC		R1
		PLOT
MSG_1PUTC60
		ADD		R0
		BCC		MSG_1PUTC70
		INC		R1
		DEC		R1
		PLOT
MSG_1PUTC70
		ADD		R0
		BCC		MSG_1PUTC80
		INC		R1
		DEC		R1
		PLOT
MSG_1PUTC80
		LOOP
		INC		R2
;
		RPIX
;
		LM		R0, MSG_1Putc_C		;tHg wTCYf[^ AhX vZ
		LOB
		IWT		R1, #MSG_FONT_X
		TO		R14
		ADD		R1
		GETB
		TO		R1
		ADD		R3
		IWT		R0, #MSG_X_AREA
		FROM		R1
		SUB		R0
		BCC		MSG_1PUTC100		;s ? N: MSG_1PUTC100
		NOP
		IBT		R1, #000H		;vbg w|WV s
		LM		R0, MSG_Ypos		;s MSG_Ypos + 10H
		INC		R0
		TO		R2
		ADD		#00FH
		IWT		R0, #MSG_Y_AREA
		FROM		R2
		SUB		R0
		BCC		MSG_1PUTC110		;y[W ? N: MSG_1PUTC110
		NOP
;;;;K;;;;		IBT		R2, #000H		;vbg x|WV y[W擪
		IBT		R2, #010H		;vbg x|WV y[W擪
MSG_1PUTC110
		SM		R2, MSG_Ypos
MSG_1PUTC100
		SM		R1, MSG_Xpos		;vbg w|WV XV
;
		LM		R15, MSG_1Putc_Rts
		NOP
MSG_1PUTC_X1Y0	;wQ{ xP{
MSG_1PUTC_X2Y0	;wR{ xP{
MSG_1PUTC_X3Y0	;wS{ xP{
MSG_1PUTC_X0Y1	;wP{ xQ{
MSG_1PUTC_X1Y1	;wQ{ xQ{
MSG_1PUTC_X2Y1	;wR{ xQ{
MSG_1PUTC_X3Y1	;wS{ xQ{
MSG_1PUTC_X0Y2	;wP{ xR{
MSG_1PUTC_X1Y2	;wQ{ xR{
MSG_1PUTC_X2Y2	;wR{ xR{
MSG_1PUTC_X3Y2	;wS{ xR{
MSG_1PUTC_X0Y3	;wP{ xS{
MSG_1PUTC_X1Y3	;wQ{ xS{
MSG_1PUTC_X2Y3	;wR{ xS{
MSG_1PUTC_X3Y3	;wS{ xS{
		LM		R5 ,MSG_Xsiz		; wTCY ۑ
		INC		R5
		LM		R6 ,MSG_Ysiz		; xTCY ۑ
		INC		R6
;
		LM		R4, MSG_1Putc_Y		;vbg x|WV vZ
		FROM		R6
		UMULT		#003H
		TO		R4
		ADD		R4			;vbg x|WV { R   xTCY
;
		LM		R9, MSG_1Putc_X		;vbg w|WV ۑ
;
		LM		R0, MSG_1Putc_C		;tHgf[^AhX vZ
		LOB
		UMULT		#00CH
		IWT		R1, #MSG_FONT
		TO		R14
		ADD		R1
;
		IWT		R13, #MSG_1PUTC_XY20	;[v AhX Zbg
;
		IBT		R11, #00CH		;tHg xTCY
MSG_1PUTC_XY10
		GETB					;tHg f[^ Qbg
		INC		R14
		TO		R10
		SWAP
;
		IBT		R12, #008H
		IBT		R3, #000H		;w|WV
MSG_1PUTC_XY20
		WITH		R10
		ADD		R10
		BCC		MSG_1PUTC_XY30		;vbg ? N:MSG_1PUTC_XY30
		NOP
		FROM		R9			;vbg w|WV vZ
		TO		R7
		ADD		R3
		MOVE		R2, R4			;vbg x|WV Zbg
		MOVE		R8, R6			;hbg xTCY
MSG_1PUTC_XY40
		MOVE		R1, R7			;vbg w|WV Zbg
		MOVE		R0, R5			;hbg wTCY
MSG_1PUTC_XY50
		DEC		R0
		BNE		MSG_1PUTC_XY50		;hbg w vbg I ? N:MSG_1PUTC_XY50
		PLOT
		DEC		R8
		BNE		MSG_1PUTC_XY40		;hbgx vbg I ? N:MSG_1PUTC_XY40
		INC		R2
MSG_1PUTC_XY30
		WITH		R3			;̂w|WV
		ADD		R5
		LOOP					;PI ? N:MSG_1PUTC_XY20
		NOP
		WITH		R4			;̂x|WV
		ADD		R6
		DEC		R11
		BNE		MSG_1PUTC_XY10		;cPI ? N:MSG_1PUTC_XY10
		NOP
;
		RPIX
;
		LM		R0, MSG_1Putc_C		;tHg wTCYf[^ AhX vZ
		LOB
		IWT		R1, #MSG_FONT_X
		TO		R14
		ADD		R1
		GETB
		UMULT		R5
		TO		R1
		ADD		R9
		IWT		R0, #MSG_X_AREA
		FROM		R1
		SUB		R0
		BCC		MSG_1PUTC_XY100		;s ? N: MSG_1PUTC_XY100
		NOP
		IBT		R1, #000H		;vbg w|WV s
		LM		R0, MSG_Ypos		;s MSG_Ypos + 10H *  wTCY
		IBT		R2, #010H
		WITH		R2
		UMULT		R6
		IWT		R0, #MSG_Y_AREA
		FROM		R2
		SUB		R0
		BCC		MSG_1PUTC_XY110		;y[W ? N: MSG_1PUTC_XY110
		NOP
;;;;K;;;;		IBT		R2, #000H		;vbg x|WV y[W擪
		IBT		R2, #010H		;vbg x|WV y[W擪
MSG_1PUTC_XY110
		SM		R2, MSG_Ypos
MSG_1PUTC_XY100
		SM		R1, MSG_Xpos		;vbg w|WV XV
;
		LM		R15, MSG_1Putc_Rts
		NOP
;
 IF  NES | PAL ;**** NES or PAL Ή [1995/7/13] *****************
;
;------------------------------------------------------------------------
;|		bZ[W tHg w TCY e[u			|
;------------------------------------------------------------------------
MSG_FONT_X
		BYTE	008H, 008H, 008H, 008H, 008H, 008H, 005H, 008H	; 0 -  7
		BYTE	008H, 008H, 008H, 008H, 008H, 008H, 008H, 008H	; 8 -  F
		BYTE	008H, 008H, 008H, 008H, 008H, 008H, 008H, 008H	;10 - 17
		BYTE	008H, 008H, 008H, 008H, 008H, 008H, 008H, 008H	;18 - 1F
		BYTE	008H, 008H, 008H, 008H, 008H, 008H, 004H, 004H	;20 - 27
		BYTE	008H, 008H, 008H, 008H, 008H, 008H, 008H, 008H	;28 - 2F
		BYTE	008H, 008H, 008H, 008H, 008H, 008H, 008H, 004H	;30 - 37
		BYTE	006H, 003H, 007H, 006H, 007H, 006H, 007H, 003H	;38 - 3F
		BYTE	008H, 008H, 008H, 008H, 008H, 008H, 008H, 008H	;40 - 47
		BYTE	008H, 008H, 008H, 008H, 008H, 008H, 008H, 008H	;48 - 4F
		BYTE	008H, 008H, 008H, 008H, 008H, 008H, 008H, 008H	;50 - 57
		BYTE	008H, 008H, 008H, 008H, 008H, 008H, 008H, 008H	;58 - 5F
		BYTE	008H, 008H, 008H, 008H, 008H, 008H, 008H, 008H	;60 - 67
		BYTE	008H, 008H, 008H, 008H, 008H, 008H, 008H, 008H	;68 - 6F
		BYTE	008H, 008H, 008H, 008H, 008H, 008H, 008H, 008H	;70 - 77
		BYTE	008H, 008H, 008H, 008H, 008H, 008H, 008H, 008H	;78 - 7F
		BYTE	008H, 008H, 008H, 008H, 008H, 008H, 008H, 008H	;80 - 87
		BYTE	008H, 008H, 008H, 008H, 008H, 008H, 008H, 008H	;88 - 8F
		BYTE	008H, 008H, 008H, 008H, 008H, 008H, 008H, 008H	;90 - 97
		BYTE	008H, 008H, 008H, 008H, 008H, 008H, 008H, 008H	;98 - 9F
		BYTE	008H, 008H, 008H, 008H, 008H, 008H, 008H, 008H	;A0 - A7
		BYTE	008H, 008H, 008H, 008H, 008H, 008H, 007H, 007H	;A8 - AF
		BYTE	008H, 008H, 005H, 008H, 008H, 007H, 008H, 008H	;B0 - B7
		BYTE	008H, 008H, 008H, 008H, 008H, 008H, 008H, 008H	;B8 - BF
		BYTE	008H, 008H, 008H, 008H, 008H, 008H, 008H, 008H	;C0 - C7
		BYTE	008H, 008H, 008H, 008H, 008H, 008H, 008H, 008H	;C8 - CF
		BYTE	004H, 008H, 008H, 008H, 008H, 008H, 008H, 008H	;D0 - D7
		BYTE	008H, 008H, 008H, 008H, 007H, 007H, 008H, 008H	;D8 - DF
		BYTE	004H, 007H, 008H, 004H, 008H, 008H, 008H, 008H	;E0 - E7
		BYTE	008H, 007H, 008H, 008H, 008H, 008H, 008H, 008H	;E8 - EF
		BYTE	008H, 008H, 008H, 008H, 008H, 008H, 008H, 008H	;F0 - F7
		BYTE	008H, 008H, 008H, 008H, 008H, 008H, 008H, 008H	;F8 - FF
;
;
;
;
;
;------------------------------------------------------------------------
;|		bZ[W tHg f[^ e[u			|
;------------------------------------------------------------------------
MSG_FONT
		BYTE	00000000B
		BYTE	00011000B
		BYTE	00001100B
		BYTE	00000000B
		BYTE	00011100B
		BYTE	00000110B
		BYTE	00111110B
		BYTE	01100110B
		BYTE	01101110B
		BYTE	00111011B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00011100B
		BYTE	00110110B
		BYTE	00000000B
		BYTE	00011100B
		BYTE	00000110B
		BYTE	00111110B
		BYTE	01100110B
		BYTE	01101110B
		BYTE	00111011B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00111110B
		BYTE	01110011B
		BYTE	01100000B
		BYTE	01100000B
		BYTE	01100011B
		BYTE	00111110B
		BYTE	00011000B
		BYTE	00001100B
		BYTE	00111000B

		BYTE	00000000B
		BYTE	00011000B
		BYTE	00001100B
		BYTE	00000000B
		BYTE	00111100B
		BYTE	01100110B
		BYTE	01111110B
		BYTE	01100000B
		BYTE	01100110B
		BYTE	00111100B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00001100B
		BYTE	00011000B
		BYTE	00000000B
		BYTE	00111100B
		BYTE	01100110B
		BYTE	01111110B
		BYTE	01100000B
		BYTE	01100110B
		BYTE	00111100B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00011100B
		BYTE	00110110B
		BYTE	00000000B
		BYTE	00111100B
		BYTE	01100110B
		BYTE	01111110B
		BYTE	01100000B
		BYTE	01100110B
		BYTE	00111100B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00110000B
		BYTE	01001000B
		BYTE	00000000B
		BYTE	00110000B
		BYTE	00110000B
		BYTE	00110000B
		BYTE	01100000B
		BYTE	01100000B
		BYTE	00110000B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00011100B
		BYTE	00110110B
		BYTE	00000000B
		BYTE	00011110B
		BYTE	00110011B
		BYTE	01100011B
		BYTE	01100011B
		BYTE	01100110B
		BYTE	00111100B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00011000B
		BYTE	00001100B
		BYTE	00000000B
		BYTE	01100000B
		BYTE	01100110B
		BYTE	01100110B
		BYTE	01100110B
		BYTE	01100111B
		BYTE	00111101B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00011100B
		BYTE	00110110B
		BYTE	00000000B
		BYTE	01100000B
		BYTE	01100110B
		BYTE	01100110B
		BYTE	01100110B
		BYTE	01100111B
		BYTE	00111101B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00110110B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00011100B
		BYTE	00000110B
		BYTE	00111110B
		BYTE	01100110B
		BYTE	01101110B
		BYTE	00111011B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00110110B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00011110B
		BYTE	00110011B
		BYTE	01100011B
		BYTE	01100011B
		BYTE	01100110B
		BYTE	00111100B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00110110B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	01100000B
		BYTE	01100110B
		BYTE	01100110B
		BYTE	01100110B
		BYTE	01100111B
		BYTE	00111101B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00011110B
		BYTE	00010011B
		BYTE	00110011B
		BYTE	00111110B
		BYTE	00110011B
		BYTE	00110011B
		BYTE	00111011B
		BYTE	01101110B
		BYTE	01000000B
		BYTE	00000000B

		BYTE	00110110B
		BYTE	00000000B
		BYTE	00011100B
		BYTE	00110110B
		BYTE	01100011B
		BYTE	01100011B
		BYTE	01111111B
		BYTE	01100011B
		BYTE	01100011B
		BYTE	00000011B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00110110B
		BYTE	00000000B
		BYTE	00011100B
		BYTE	00110110B
		BYTE	01100011B
		BYTE	01100011B
		BYTE	01100011B
		BYTE	01100011B
		BYTE	00110111B
		BYTE	00011110B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00110110B
		BYTE	00000000B
		BYTE	00110011B
		BYTE	00110011B
		BYTE	01110011B
		BYTE	01100011B
		BYTE	01100011B
		BYTE	01100011B
		BYTE	01100110B
		BYTE	00111100B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000011B
		BYTE	00001111B
		BYTE	00011100B
		BYTE	00011001B
		BYTE	00111001B
		BYTE	00111001B
		BYTE	00111000B
		BYTE	00111001B
		BYTE	00011001B
		BYTE	00011001B
		BYTE	00001111B
		BYTE	00000011B

		BYTE	11000000B
		BYTE	11110000B
		BYTE	00111000B
		BYTE	10011000B
		BYTE	10011100B
		BYTE	10011100B
		BYTE	00011100B
		BYTE	10011100B
		BYTE	10011000B
		BYTE	10011000B
		BYTE	11110000B
		BYTE	11000000B

		BYTE	00000011B
		BYTE	00001111B
		BYTE	00011000B
		BYTE	00011001B
		BYTE	00111001B
		BYTE	00111000B
		BYTE	00111001B
		BYTE	00111001B
		BYTE	00011001B
		BYTE	00011000B
		BYTE	00001111B
		BYTE	00000011B

		BYTE	11000000B
		BYTE	11110000B
		BYTE	00111000B
		BYTE	10011000B
		BYTE	10011100B
		BYTE	00111100B
		BYTE	11011100B
		BYTE	11001100B
		BYTE	10001000B
		BYTE	00011000B
		BYTE	11110000B
		BYTE	11000000B

		BYTE	00000011B
		BYTE	00001111B
		BYTE	00011001B
		BYTE	00011001B
		BYTE	00111001B
		BYTE	00111100B
		BYTE	00111110B
		BYTE	00111110B
		BYTE	00011110B
		BYTE	00011110B
		BYTE	00001111B
		BYTE	00000011B

		BYTE	11000000B
		BYTE	11110000B
		BYTE	10011000B
		BYTE	10011000B
		BYTE	10011100B
		BYTE	00111100B
		BYTE	01111100B
		BYTE	01111100B
		BYTE	01111000B
		BYTE	01111000B
		BYTE	11110000B
		BYTE	11000000B

		BYTE	00000011B
		BYTE	00001111B
		BYTE	00011001B
		BYTE	00011001B
		BYTE	00111000B
		BYTE	00111100B
		BYTE	00111110B
		BYTE	00111101B
		BYTE	00011011B
		BYTE	00011011B
		BYTE	00001111B
		BYTE	00000011B

		BYTE	11000000B
		BYTE	11110000B
		BYTE	11011000B
		BYTE	11011000B
		BYTE	10111100B
		BYTE	01111100B
		BYTE	00111100B
		BYTE	00011100B
		BYTE	10011000B
		BYTE	10011000B
		BYTE	11110000B
		BYTE	11000000B

		BYTE	00000000B
		BYTE	00011111B
		BYTE	00111111B
		BYTE	01110010B
		BYTE	01110110B
		BYTE	01110010B
		BYTE	01111010B
		BYTE	01110010B
		BYTE	00111111B
		BYTE	00011111B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	11111111B
		BYTE	11111111B
		BYTE	01011001B
		BYTE	11011011B
		BYTE	01011001B
		BYTE	11011011B
		BYTE	01001001B
		BYTE	11111111B
		BYTE	11111111B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	11111100B
		BYTE	11111110B
		BYTE	00100011B
		BYTE	01110111B
		BYTE	01110111B
		BYTE	01110111B
		BYTE	00110111B
		BYTE	11111110B
		BYTE	11111100B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00011111B
		BYTE	00111111B
		BYTE	01111111B
		BYTE	01111111B
		BYTE	01111111B
		BYTE	01111111B
		BYTE	01111111B
		BYTE	00111111B
		BYTE	00011111B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	11111111B
		BYTE	11111111B
		BYTE	10011111B
		BYTE	10011111B
		BYTE	10011111B
		BYTE	10011111B
		BYTE	10000001B
		BYTE	11111111B
		BYTE	11111111B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	11111100B
		BYTE	11111110B
		BYTE	11111111B
		BYTE	11111111B
		BYTE	11111111B
		BYTE	11111111B
		BYTE	11111111B
		BYTE	11111110B
		BYTE	11111100B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00110000B
		BYTE	00110000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00110000B
		BYTE	00110000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00110000B
		BYTE	00110000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00110000B
		BYTE	00110000B
		BYTE	00010000B
		BYTE	00100000B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00011111B
		BYTE	00111111B
		BYTE	01111111B
		BYTE	01111111B
		BYTE	01111111B
		BYTE	01111111B
		BYTE	01111111B
		BYTE	00111111B
		BYTE	00011111B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	11111111B
		BYTE	11111111B
		BYTE	10000011B
		BYTE	10011001B
		BYTE	10000011B
		BYTE	10011001B
		BYTE	10011001B
		BYTE	11111111B
		BYTE	11111111B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	11111100B
		BYTE	11111110B
		BYTE	11111111B
		BYTE	11111111B
		BYTE	11111111B
		BYTE	11111111B
		BYTE	11111111B
		BYTE	11111110B
		BYTE	11111100B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00110000B
		BYTE	00110000B
		BYTE	00010000B
		BYTE	00100000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00010100B
		BYTE	00100010B
		BYTE	01000001B
		BYTE	01110111B
		BYTE	00010100B
		BYTE	00010100B
		BYTE	00010100B
		BYTE	00010100B
		BYTE	00010100B
		BYTE	00011100B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00000100B
		BYTE	00001100B
		BYTE	00011111B
		BYTE	00111111B
		BYTE	01111111B
		BYTE	00111111B
		BYTE	00011111B
		BYTE	00001100B
		BYTE	00000100B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00100000B
		BYTE	00110000B
		BYTE	11111000B
		BYTE	11111100B
		BYTE	11111110B
		BYTE	11111100B
		BYTE	11111000B
		BYTE	00110000B
		BYTE	00100000B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00001000B
		BYTE	00011100B
		BYTE	00111110B
		BYTE	01111111B
		BYTE	00111110B
		BYTE	00111110B
		BYTE	00111110B
		BYTE	00111110B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00111110B
		BYTE	00111110B
		BYTE	00111110B
		BYTE	00111110B
		BYTE	01111111B
		BYTE	00111110B
		BYTE	00011100B
		BYTE	00001000B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00011111B
		BYTE	00111111B
		BYTE	01110010B
		BYTE	01110111B
		BYTE	01110011B
		BYTE	01111011B
		BYTE	01110011B
		BYTE	00111111B
		BYTE	00011111B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	11111111B
		BYTE	11111111B
		BYTE	00110110B
		BYTE	01101010B
		BYTE	01100010B
		BYTE	01101010B
		BYTE	01101010B
		BYTE	11111111B
		BYTE	11111111B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	11111100B
		BYTE	11111110B
		BYTE	01100011B
		BYTE	10110111B
		BYTE	01110111B
		BYTE	10110111B
		BYTE	10110111B
		BYTE	11111110B
		BYTE	11111100B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00001101B
		BYTE	00010010B
		BYTE	00100001B
		BYTE	01000011B
		BYTE	01000111B
		BYTE	00101111B
		BYTE	01000011B
		BYTE	01000011B
		BYTE	00100011B
		BYTE	00011000B
		BYTE	00000111B
		BYTE	00000000B

		BYTE	11000000B
		BYTE	00110000B
		BYTE	10001000B
		BYTE	11001100B
		BYTE	11100010B
		BYTE	11110010B
		BYTE	11000010B
		BYTE	11000100B
		BYTE	11000100B
		BYTE	00011000B
		BYTE	11100000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00111110B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00111110B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00110000B
		BYTE	00110000B
		BYTE	00010000B
		BYTE	00100000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00111100B
		BYTE	01100110B
		BYTE	01111110B
		BYTE	01100000B
		BYTE	01100110B
		BYTE	00111100B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00110000B
		BYTE	00000000B
		BYTE	01100000B
		BYTE	01100000B
		BYTE	01100000B
		BYTE	01100000B
		BYTE	01100000B
		BYTE	00110000B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00110000B
		BYTE	00110000B
		BYTE	01111100B
		BYTE	00110000B
		BYTE	00110000B
		BYTE	00110000B
		BYTE	00110110B
		BYTE	00011100B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	01101100B
		BYTE	00111110B
		BYTE	00110110B
		BYTE	00110000B
		BYTE	00110000B
		BYTE	00110000B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	01100000B
		BYTE	00110000B
		BYTE	00110000B
		BYTE	00111110B
		BYTE	00110011B
		BYTE	00110011B
		BYTE	00110110B
		BYTE	01100110B
		BYTE	01100011B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00011100B
		BYTE	00110110B
		BYTE	00110000B
		BYTE	01111110B
		BYTE	00110000B
		BYTE	00110000B
		BYTE	00110000B
		BYTE	00110000B
		BYTE	00011000B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	01101100B
		BYTE	00111110B
		BYTE	00110110B
		BYTE	00110110B
		BYTE	00110110B
		BYTE	00110011B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	01100000B
		BYTE	01100000B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00001000B
		BYTE	00000100B
		BYTE	00011100B
		BYTE	00110110B
		BYTE	00100010B
		BYTE	01100011B
		BYTE	01111111B
		BYTE	01100011B
		BYTE	01100011B
		BYTE	00000011B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00011000B
		BYTE	00100100B
		BYTE	00011100B
		BYTE	00110110B
		BYTE	00100010B
		BYTE	01100011B
		BYTE	01111111B
		BYTE	01100011B
		BYTE	01100011B
		BYTE	00000011B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00011110B
		BYTE	00110011B
		BYTE	01100000B
		BYTE	01100000B
		BYTE	01100000B
		BYTE	01100011B
		BYTE	00110111B
		BYTE	00011110B
		BYTE	00001100B
		BYTE	00111000B

		BYTE	00011000B
		BYTE	00001100B
		BYTE	00000000B
		BYTE	00111110B
		BYTE	01100000B
		BYTE	01100000B
		BYTE	01111100B
		BYTE	01100000B
		BYTE	01100000B
		BYTE	01111111B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00001100B
		BYTE	00011000B
		BYTE	00000000B
		BYTE	00111110B
		BYTE	01110000B
		BYTE	01100000B
		BYTE	01111100B
		BYTE	01100000B
		BYTE	01100000B
		BYTE	01111111B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00011100B
		BYTE	00110110B
		BYTE	00000000B
		BYTE	00111110B
		BYTE	01110000B
		BYTE	01100000B
		BYTE	01111100B
		BYTE	01100000B
		BYTE	01100000B
		BYTE	01111111B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00111000B
		BYTE	01101100B
		BYTE	00000000B
		BYTE	00111100B
		BYTE	00011000B
		BYTE	00011000B
		BYTE	00011000B
		BYTE	00110000B
		BYTE	00110000B
		BYTE	01111000B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00011100B
		BYTE	00110110B
		BYTE	00000000B
		BYTE	00011100B
		BYTE	00110110B
		BYTE	01100011B
		BYTE	01100011B
		BYTE	01100011B
		BYTE	00110111B
		BYTE	00011110B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00001100B
		BYTE	00011000B
		BYTE	00000000B
		BYTE	00110011B
		BYTE	00110011B
		BYTE	01100011B
		BYTE	01100011B
		BYTE	01100011B
		BYTE	01100110B
		BYTE	00111100B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00011000B
		BYTE	00001100B
		BYTE	00000000B
		BYTE	00110011B
		BYTE	00110011B
		BYTE	01100011B
		BYTE	01100011B
		BYTE	01100011B
		BYTE	01100110B
		BYTE	00111100B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	01101100B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00111100B
		BYTE	00011000B
		BYTE	00011000B
		BYTE	00110000B
		BYTE	00110000B
		BYTE	00110000B
		BYTE	01111000B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	01010000B
		BYTE	00000000B
		BYTE	01100000B
		BYTE	01100000B
		BYTE	01100000B
		BYTE	01100000B
		BYTE	01110000B
		BYTE	00111000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00011100B
		BYTE	00110010B
		BYTE	00110011B
		BYTE	01100011B
		BYTE	01100011B
		BYTE	01100011B
		BYTE	00100110B
		BYTE	00011100B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00011100B
		BYTE	00001100B
		BYTE	00001100B
		BYTE	00001100B
		BYTE	00011000B
		BYTE	00011000B
		BYTE	00011000B
		BYTE	00111100B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00011110B
		BYTE	00110011B
		BYTE	00000011B
		BYTE	00000111B
		BYTE	00011110B
		BYTE	00110000B
		BYTE	01100010B
		BYTE	01111110B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00111100B
		BYTE	01100110B
		BYTE	00000110B
		BYTE	00001100B
		BYTE	00000110B
		BYTE	01000011B
		BYTE	01100111B
		BYTE	00111110B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	01100110B
		BYTE	01100110B
		BYTE	01100110B
		BYTE	01101100B
		BYTE	01101100B
		BYTE	01111110B
		BYTE	00001100B
		BYTE	00001100B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00110000B
		BYTE	00111110B
		BYTE	00110000B
		BYTE	00110000B
		BYTE	00111110B
		BYTE	00000011B
		BYTE	01100011B
		BYTE	00111110B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00011100B
		BYTE	00110000B
		BYTE	01100000B
		BYTE	01111110B
		BYTE	01100111B
		BYTE	01100011B
		BYTE	00110011B
		BYTE	00011110B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00111111B
		BYTE	01100011B
		BYTE	01100110B
		BYTE	00001100B
		BYTE	00001100B
		BYTE	00011000B
		BYTE	00011000B
		BYTE	00011000B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00011100B
		BYTE	00110110B
		BYTE	00110110B
		BYTE	00011100B
		BYTE	00110010B
		BYTE	01100011B
		BYTE	01100111B
		BYTE	00111110B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00111110B
		BYTE	01110011B
		BYTE	01100011B
		BYTE	01100110B
		BYTE	00111110B
		BYTE	00001100B
		BYTE	00011000B
		BYTE	00011000B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00011100B
		BYTE	00110110B
		BYTE	01100011B
		BYTE	01100011B
		BYTE	01111111B
		BYTE	01100011B
		BYTE	01100011B
		BYTE	01100011B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	01111110B
		BYTE	00110011B
		BYTE	00110011B
		BYTE	00111110B
		BYTE	00110011B
		BYTE	00110011B
		BYTE	00110011B
		BYTE	01111110B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00011100B
		BYTE	00110110B
		BYTE	01100000B
		BYTE	01100000B
		BYTE	01100000B
		BYTE	01100011B
		BYTE	00110111B
		BYTE	00011110B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	01111100B
		BYTE	00110110B
		BYTE	00110011B
		BYTE	00110011B
		BYTE	01100011B
		BYTE	01100011B
		BYTE	01100110B
		BYTE	01111100B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00111110B
		BYTE	01110000B
		BYTE	01100000B
		BYTE	01111100B
		BYTE	01100000B
		BYTE	01100000B
		BYTE	01100000B
		BYTE	01111110B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00111110B
		BYTE	01100000B
		BYTE	01100000B
		BYTE	01100000B
		BYTE	01111100B
		BYTE	01100000B
		BYTE	01100000B
		BYTE	00100000B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00011100B
		BYTE	00110110B
		BYTE	01100000B
		BYTE	01100000B
		BYTE	01101111B
		BYTE	01100011B
		BYTE	00110111B
		BYTE	00011110B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00110011B
		BYTE	01100011B
		BYTE	01100011B
		BYTE	01100011B
		BYTE	01111111B
		BYTE	01100011B
		BYTE	01100011B
		BYTE	01100011B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	01111000B
		BYTE	00110000B
		BYTE	00110000B
		BYTE	00110000B
		BYTE	00110000B
		BYTE	00110000B
		BYTE	00110000B
		BYTE	01111000B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000111B
		BYTE	00000011B
		BYTE	00000011B
		BYTE	00100011B
		BYTE	01100011B
		BYTE	01100011B
		BYTE	01100110B
		BYTE	00111100B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	01100010B
		BYTE	01100110B
		BYTE	01101100B
		BYTE	01111000B
		BYTE	01111000B
		BYTE	01101100B
		BYTE	01100110B
		BYTE	01100011B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	01100000B
		BYTE	01100000B
		BYTE	01100000B
		BYTE	01100000B
		BYTE	01100000B
		BYTE	01100000B
		BYTE	01100000B
		BYTE	01111110B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	01000001B
		BYTE	01100011B
		BYTE	01110111B
		BYTE	01111111B
		BYTE	01101011B
		BYTE	01100011B
		BYTE	01100011B
		BYTE	00100011B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	01000011B
		BYTE	01100011B
		BYTE	01110011B
		BYTE	01110011B
		BYTE	01111011B
		BYTE	01101111B
		BYTE	01100111B
		BYTE	01100011B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00011100B
		BYTE	00110110B
		BYTE	01100011B
		BYTE	01100011B
		BYTE	01100011B
		BYTE	01100011B
		BYTE	00110111B
		BYTE	00011110B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00111110B
		BYTE	01110011B
		BYTE	01100011B
		BYTE	01100111B
		BYTE	01111110B
		BYTE	01100000B
		BYTE	01100000B
		BYTE	01100000B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00011100B
		BYTE	00110110B
		BYTE	01100011B
		BYTE	01100011B
		BYTE	01100011B
		BYTE	01101111B
		BYTE	00110110B
		BYTE	00011110B
		BYTE	00000011B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	01111100B
		BYTE	01100110B
		BYTE	01100011B
		BYTE	01100111B
		BYTE	01111110B
		BYTE	01101100B
		BYTE	01100110B
		BYTE	01100011B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00011110B
		BYTE	00110011B
		BYTE	00111000B
		BYTE	00011100B
		BYTE	00001110B
		BYTE	00000111B
		BYTE	01100111B
		BYTE	00111110B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	01111111B
		BYTE	00001100B
		BYTE	00011100B
		BYTE	00011000B
		BYTE	00011000B
		BYTE	00011000B
		BYTE	00011000B
		BYTE	00011000B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00110010B
		BYTE	00110011B
		BYTE	01100011B
		BYTE	01100011B
		BYTE	01100011B
		BYTE	01100011B
		BYTE	01100110B
		BYTE	00111100B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	01100011B
		BYTE	01100011B
		BYTE	00100011B
		BYTE	00110011B
		BYTE	00110110B
		BYTE	00010110B
		BYTE	00011100B
		BYTE	00001000B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	01100010B
		BYTE	01100011B
		BYTE	01100011B
		BYTE	01101011B
		BYTE	01101011B
		BYTE	01111111B
		BYTE	01110111B
		BYTE	00100010B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	01100001B
		BYTE	01100011B
		BYTE	00110111B
		BYTE	00011110B
		BYTE	00011100B
		BYTE	00110110B
		BYTE	01100011B
		BYTE	01000011B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	01000001B
		BYTE	01100011B
		BYTE	00110110B
		BYTE	00011100B
		BYTE	00011000B
		BYTE	00011000B
		BYTE	00011000B
		BYTE	00011000B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	01110000B
		BYTE	01111111B
		BYTE	00000111B
		BYTE	00001110B
		BYTE	00011100B
		BYTE	00111000B
		BYTE	01110000B
		BYTE	01111111B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	01111110B
		BYTE	10000010B
		BYTE	10111110B
		BYTE	10100000B
		BYTE	10100000B
		BYTE	10100000B
		BYTE	11100000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000111B
		BYTE	00000101B
		BYTE	00000101B
		BYTE	00000101B
		BYTE	01111101B
		BYTE	01000001B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00111100B
		BYTE	01100110B
		BYTE	01100110B
		BYTE	00001110B
		BYTE	00011000B
		BYTE	00011000B
		BYTE	00000000B
		BYTE	00011000B
		BYTE	00011000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00110000B
		BYTE	00110000B
		BYTE	01110000B
		BYTE	01100000B
		BYTE	01100000B
		BYTE	01000000B
		BYTE	00000000B
		BYTE	01100000B
		BYTE	01100000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	10000000B
		BYTE	11000000B
		BYTE	01100000B
		BYTE	00100000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	01111111B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000011B
		BYTE	00000011B
		BYTE	00000011B
		BYTE	00011111B
		BYTE	00011111B
		BYTE	00011110B
		BYTE	00011111B
		BYTE	00011111B
		BYTE	00000011B
		BYTE	00000011B
		BYTE	00000011B
		BYTE	00000000B

		BYTE	11100000B
		BYTE	11100000B
		BYTE	11100000B
		BYTE	11111100B
		BYTE	01111100B
		BYTE	10111100B
		BYTE	01111100B
		BYTE	11111100B
		BYTE	11100000B
		BYTE	11100000B
		BYTE	11100000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00101010B
		BYTE	00101010B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	01100000B
		BYTE	10010000B
		BYTE	10010000B
		BYTE	01100000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00111000B
		BYTE	01011101B
		BYTE	00001110B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00110000B
		BYTE	00110000B
		BYTE	00010000B
		BYTE	00100000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	01001000B
		BYTE	01001000B
		BYTE	01101100B
		BYTE	00100100B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00100100B
		BYTE	00100100B
		BYTE	01101100B
		BYTE	01001000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00011000B
		BYTE	00011000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	01100000B
		BYTE	01110000B
		BYTE	01111000B
		BYTE	01111100B
		BYTE	01111110B
		BYTE	01111111B
		BYTE	01111110B
		BYTE	01111100B
		BYTE	01111000B
		BYTE	01110000B
		BYTE	01100000B
		BYTE	00000000B

		BYTE	00000001B
		BYTE	00011010B
		BYTE	00100111B
		BYTE	00100001B
		BYTE	00100000B
		BYTE	00010001B
		BYTE	00001110B
		BYTE	00000010B
		BYTE	00000001B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	10000000B
		BYTE	01000000B
		BYTE	01100000B
		BYTE	00010000B
		BYTE	00010000B
		BYTE	00100110B
		BYTE	00111010B
		BYTE	00010010B
		BYTE	10000100B
		BYTE	01011000B
		BYTE	11110000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	01000100B
		BYTE	01101000B
		BYTE	00110000B
		BYTE	00011000B
		BYTE	00101100B
		BYTE	01000100B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00011100B
		BYTE	00000110B
		BYTE	00111110B
		BYTE	01100110B
		BYTE	01101110B
		BYTE	00111011B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	01100000B
		BYTE	00110000B
		BYTE	00110000B
		BYTE	00111110B
		BYTE	00110011B
		BYTE	00110011B
		BYTE	00110011B
		BYTE	00111011B
		BYTE	01101110B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00111110B
		BYTE	01110011B
		BYTE	01100000B
		BYTE	01100000B
		BYTE	01100111B
		BYTE	00111110B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00000110B
		BYTE	00000011B
		BYTE	00000011B
		BYTE	00111011B
		BYTE	01101110B
		BYTE	01100110B
		BYTE	01100110B
		BYTE	01101110B
		BYTE	00111011B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00111100B
		BYTE	01100110B
		BYTE	01111110B
		BYTE	01100000B
		BYTE	01100110B
		BYTE	00111100B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00011100B
		BYTE	00110110B
		BYTE	00110000B
		BYTE	01111110B
		BYTE	00110000B
		BYTE	00110000B
		BYTE	00110000B
		BYTE	00110000B
		BYTE	00011000B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000110B
		BYTE	00011110B
		BYTE	00110011B
		BYTE	00011110B
		BYTE	00001100B
		BYTE	00111110B
		BYTE	01100011B
		BYTE	01100011B
		BYTE	00111110B

		BYTE	00000000B
		BYTE	01100000B
		BYTE	00110000B
		BYTE	00110000B
		BYTE	00111110B
		BYTE	00110011B
		BYTE	00110011B
		BYTE	00110110B
		BYTE	01100110B
		BYTE	01100011B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00110000B
		BYTE	00000000B
		BYTE	01100000B
		BYTE	01100000B
		BYTE	01100000B
		BYTE	01100000B
		BYTE	01100000B
		BYTE	00110000B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000110B
		BYTE	00000000B
		BYTE	00000110B
		BYTE	00000110B
		BYTE	00000110B
		BYTE	00000110B
		BYTE	00000110B
		BYTE	01100110B
		BYTE	01101100B
		BYTE	00111000B

		BYTE	00000000B
		BYTE	01100000B
		BYTE	01100000B
		BYTE	01100000B
		BYTE	01100110B
		BYTE	01101100B
		BYTE	00111000B
		BYTE	00111100B
		BYTE	00110110B
		BYTE	00110011B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00110000B
		BYTE	00110000B
		BYTE	01100000B
		BYTE	01100000B
		BYTE	01100000B
		BYTE	01100000B
		BYTE	01100000B
		BYTE	01100000B
		BYTE	00110000B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	01000000B
		BYTE	01110110B
		BYTE	01111111B
		BYTE	01101011B
		BYTE	01101011B
		BYTE	01101011B
		BYTE	01101011B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	01101100B
		BYTE	00111110B
		BYTE	00110110B
		BYTE	00110110B
		BYTE	00110110B
		BYTE	00110011B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00011100B
		BYTE	00110110B
		BYTE	01100011B
		BYTE	01100011B
		BYTE	01100110B
		BYTE	00111100B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	01101110B
		BYTE	00111011B
		BYTE	00110011B
		BYTE	00110011B
		BYTE	00111110B
		BYTE	01110000B
		BYTE	01100000B
		BYTE	01100000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00011101B
		BYTE	00110111B
		BYTE	01100111B
		BYTE	01101110B
		BYTE	00111100B
		BYTE	00001100B
		BYTE	00001100B
		BYTE	00000110B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	01101100B
		BYTE	00111110B
		BYTE	00110110B
		BYTE	00110000B
		BYTE	00110000B
		BYTE	00110000B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00011100B
		BYTE	00110110B
		BYTE	00110000B
		BYTE	00011100B
		BYTE	00000110B
		BYTE	01100110B
		BYTE	00111100B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00110000B
		BYTE	00110000B
		BYTE	01111100B
		BYTE	00110000B
		BYTE	00110000B
		BYTE	00110000B
		BYTE	00110110B
		BYTE	00011100B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	01100000B
		BYTE	01100110B
		BYTE	01100110B
		BYTE	01100110B
		BYTE	01101111B
		BYTE	00111011B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000011B
		BYTE	01100011B
		BYTE	01100110B
		BYTE	00110110B
		BYTE	00111100B
		BYTE	00011100B
		BYTE	00001000B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00110011B
		BYTE	01100011B
		BYTE	01101011B
		BYTE	01101011B
		BYTE	01111111B
		BYTE	00110110B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000001B
		BYTE	01100011B
		BYTE	00110110B
		BYTE	00011100B
		BYTE	00011000B
		BYTE	00111100B
		BYTE	01100111B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	01100011B
		BYTE	00110011B
		BYTE	00110111B
		BYTE	00011110B
		BYTE	00001110B
		BYTE	00011100B
		BYTE	00111000B
		BYTE	11110000B
		BYTE	11000000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00111100B
		BYTE	00000111B
		BYTE	00001110B
		BYTE	00011100B
		BYTE	00111000B
		BYTE	01111100B
		BYTE	00000111B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000011B
		BYTE	00000111B
		BYTE	00001111B
		BYTE	00011111B
		BYTE	00111111B
		BYTE	01111111B
		BYTE	00111111B
		BYTE	00011111B
		BYTE	00001111B
		BYTE	00000111B
		BYTE	00000011B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	01100000B
		BYTE	01100000B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00001101B
		BYTE	00010010B
		BYTE	00100000B
		BYTE	01000011B
		BYTE	01000100B
		BYTE	01000000B
		BYTE	01000001B
		BYTE	00100000B
		BYTE	00010001B
		BYTE	00001100B
		BYTE	00000011B
		BYTE	00000000B

		BYTE	11000000B
		BYTE	00110000B
		BYTE	00001000B
		BYTE	11000100B
		BYTE	00100010B
		BYTE	11100010B
		BYTE	10000010B
		BYTE	00001100B
		BYTE	10000100B
		BYTE	00011000B
		BYTE	11100000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00000001B
		BYTE	00000010B
		BYTE	00111100B
		BYTE	00010001B
		BYTE	00001001B
		BYTE	00000100B
		BYTE	00000100B
		BYTE	00111000B
		BYTE	00111101B
		BYTE	00011110B
		BYTE	00000000B

		BYTE	10000000B
		BYTE	01000000B
		BYTE	00100000B
		BYTE	00011110B
		BYTE	01000100B
		BYTE	01001000B
		BYTE	00010000B
		BYTE	00010000B
		BYTE	10001110B
		BYTE	01011110B
		BYTE	00111100B
		BYTE	00000000B

		BYTE	00000001B
		BYTE	00000110B
		BYTE	00001001B
		BYTE	00010001B
		BYTE	00010000B
		BYTE	00100000B
		BYTE	00100000B
		BYTE	00100000B
		BYTE	00111111B
		BYTE	00101011B
		BYTE	00111111B
		BYTE	00000000B

		BYTE	11000000B
		BYTE	00110000B
		BYTE	11001000B
		BYTE	11000100B
		BYTE	10000100B
		BYTE	00000010B
		BYTE	10000010B
		BYTE	00000010B
		BYTE	11111110B
		BYTE	00000010B
		BYTE	11111110B
		BYTE	00000000B

		BYTE	00011100B
		BYTE	00010100B
		BYTE	00010100B
		BYTE	00010100B
		BYTE	00010100B
		BYTE	00010100B
		BYTE	01110111B
		BYTE	01000001B
		BYTE	00100010B
		BYTE	00010100B
		BYTE	00001000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
;
;
;
;
MSG_PICT
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,003,248,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,003,012,014,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,003,152,003,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,027,176,001,128,000,000,000,000,000,000,000,004,008,000,000
	BYTE 000,025,192,000,192,000,000,000,000,000,000,000,004,016,000,000
	BYTE 000,028,192,000,064,000,000,000,000,000,000,000,002,016,000,000
	BYTE 000,015,000,000,096,000,000,000,000,000,000,000,003,032,000,000
	BYTE 000,031,248,000,032,000,000,000,000,000,000,000,001,192,000,000
	BYTE 000,048,012,000,032,031,240,000,000,000,000,000,000,128,000,000
	BYTE 000,096,002,000,032,031,240,000,000,000,000,000,002,048,000,000
	BYTE 000,064,001,000,032,031,176,000,000,000,000,000,003,048,000,000
	BYTE 000,192,000,128,032,031,160,000,000,000,000,000,003,051,255,000
	BYTE 003,128,000,192,032,015,160,096,000,000,000,001,195,190,001,192
	BYTE 004,128,000,064,032,015,227,224,000,000,000,003,111,056,000,096
	BYTE 004,128,000,064,032,015,255,224,000,000,000,002,051,048,004,048
	BYTE 004,128,000,064,103,255,255,160,000,000,000,002,048,000,072,016
	BYTE 003,192,000,000,071,252,127,224,000,000,000,002,100,012,144,008
	BYTE 001,064,000,000,199,248,063,160,000,000,002,002,068,025,033,008
	BYTE 002,064,000,000,135,248,063,160,000,000,003,003,078,050,098,008
	BYTE 002,096,000,003,007,248,060,032,124,000,005,006,074,038,194,008
	BYTE 002,032,000,028,007,060,127,225,199,000,012,204,074,004,000,008
	BYTE 001,240,000,004,004,255,192,003,193,128,008,120,068,000,000,008
	BYTE 000,056,000,004,007,143,224,003,194,128,008,076,064,000,000,008
	BYTE 000,054,004,012,000,015,224,007,193,128,016,071,160,000,000,008
	BYTE 000,030,007,240,000,031,240,015,135,064,016,064,176,000,000,016
	BYTE 000,006,006,000,000,031,240,015,143,192,016,103,248,000,000,048
	BYTE 000,124,131,192,000,031,208,030,015,192,016,060,184,000,000,096
	BYTE 015,217,131,096,000,031,016,016,015,192,016,096,000,000,000,128
	BYTE 008,017,001,048,000,031,240,016,015,192,016,064,192,016,003,128
	BYTE 008,035,001,016,000,000,000,016,007,064,016,192,129,008,006,000
	BYTE 008,097,129,048,000,000,000,016,002,192,024,129,003,007,248,000
	BYTE 004,096,067,224,000,000,000,027,137,192,040,129,002,001,128,000
	BYTE 004,032,066,192,000,063,240,015,229,128,068,130,006,000,000,000
	BYTE 002,048,196,000,000,031,224,015,243,128,146,102,024,000,000,000
	BYTE 001,025,136,000,000,031,192,007,247,000,161,156,112,000,000,000
	BYTE 000,206,016,000,000,015,128,003,254,097,032,224,248,000,000,000
	BYTE 000,048,096,000,000,007,000,000,248,017,065,255,191,000,000,000
	BYTE 000,255,188,000,000,007,000,000,001,138,071,192,192,224,000,000
	BYTE 003,028,003,128,000,002,000,000,000,100,140,049,128,016,000,000
	BYTE 004,002,000,192,000,000,000,000,000,016,152,013,128,016,000,000
	BYTE 008,001,000,064,000,000,000,000,000,009,016,004,224,112,000,000
	BYTE 012,001,255,192,000,000,000,000,000,000,019,254,031,192,000,000
	BYTE 007,254,000,000,000,000,000,000,000,000,028,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,002,000,000,000,000
	BYTE 000,000,000,024,000,000,000,000,000,000,000,002,000,000,000,000
	BYTE 000,000,001,155,224,000,000,000,000,000,033,002,000,000,000,000
	BYTE 000,000,001,159,248,000,000,000,000,000,032,129,000,000,000,000
	BYTE 000,000,001,206,012,000,000,000,000,000,032,129,000,000,000,000
	BYTE 000,000,000,216,006,000,000,000,000,000,016,129,000,000,000,000
	BYTE 000,000,048,208,002,000,000,000,000,000,008,128,128,000,000,000
	BYTE 000,000,076,016,003,000,000,000,000,000,008,064,128,000,000,000
	BYTE 000,000,195,000,003,000,000,000,000,000,008,064,128,000,000,000
	BYTE 000,000,140,128,003,000,000,000,000,000,008,064,000,000,000,000
	BYTE 000,000,116,000,003,000,000,000,000,000,008,064,064,000,000,000
	BYTE 000,000,056,000,003,000,000,000,000,000,001,224,230,000,000,000
	BYTE 000,000,040,000,002,000,000,000,000,000,003,048,238,000,000,000
	BYTE 000,000,104,064,002,000,000,000,000,000,002,017,206,000,000,000
	BYTE 000,000,120,032,012,000,000,000,000,000,002,025,156,000,000,000
	BYTE 000,000,060,048,008,000,000,000,000,000,003,224,063,192,000,000
	BYTE 000,000,060,028,048,000,000,000,000,000,004,192,000,048,000,000
	BYTE 000,000,015,007,224,000,000,000,000,000,009,128,000,024,000,000
	BYTE 000,000,003,242,000,000,000,000,000,000,009,000,000,008,000,000
	BYTE 000,000,000,099,000,000,001,000,000,000,007,012,000,012,000,000
	BYTE 000,000,000,065,000,000,003,000,000,000,007,024,000,004,000,000
	BYTE 000,000,000,129,000,003,003,000,000,000,053,136,000,004,000,000
	BYTE 000,000,003,193,000,003,195,128,000,000,251,200,000,004,000,000
	BYTE 000,000,007,064,128,003,247,128,000,001,009,248,000,004,000,000
	BYTE 000,000,057,064,128,003,255,192,000,001,015,068,000,008,000,000
	BYTE 000,003,194,113,128,007,255,192,000,001,001,198,000,024,000,000
	BYTE 000,003,006,017,000,007,255,224,000,001,128,067,000,048,000,000
	BYTE 000,001,006,049,000,015,255,240,000,000,254,065,128,064,000,000
	BYTE 000,000,195,227,000,015,255,248,000,064,114,192,227,128,000,000
	BYTE 000,000,224,006,000,007,255,252,000,096,003,128,220,000,000,000
	BYTE 000,000,048,024,000,001,255,248,000,120,007,000,096,004,000,000
	BYTE 000,000,015,240,000,000,031,224,000,032,028,008,032,132,000,000
	BYTE 000,000,000,000,000,000,031,128,000,032,120,060,033,195,000,000
	BYTE 000,000,014,112,000,000,030,000,000,032,032,060,035,192,224,000
	BYTE 000,000,030,080,000,000,062,000,000,064,032,124,103,193,128,000
	BYTE 000,002,050,144,000,000,056,000,000,128,048,248,079,194,000,000
	BYTE 000,004,038,144,000,000,048,000,007,192,025,248,079,132,000,000
	BYTE 000,004,036,144,000,000,000,000,000,096,015,224,158,012,000,000
	BYTE 000,008,040,224,000,000,000,000,000,016,007,227,028,008,000,000
	BYTE 000,024,176,096,000,000,000,000,000,016,003,198,024,056,000,000
	BYTE 000,017,000,000,000,000,000,000,000,062,003,248,001,204,000,000
	BYTE 000,017,000,000,000,000,000,000,000,098,224,000,001,002,000,000
	BYTE 000,017,008,000,000,000,000,000,000,195,176,000,122,000,000,000
	BYTE 000,002,016,000,000,000,000,000,000,003,023,207,070,000,000,000
	BYTE 000,002,016,000,000,000,000,000,000,004,024,105,195,000,000,000
	BYTE 000,002,032,000,000,000,000,000,000,000,008,024,065,000,000,000
	BYTE 000,002,032,000,000,000,000,000,000,000,000,024,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,024,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,028,007,192,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,001,156,024,056,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,001,142,096,004,000,000,000,000,001,248,000,000,000,000
	BYTE 000,000,001,206,192,002,000,000,000,000,001,004,000,007,000,000
	BYTE 000,000,000,198,128,003,000,000,000,000,003,004,000,024,192,000
	BYTE 000,000,000,225,000,001,000,000,112,000,003,004,000,056,032,000
	BYTE 000,000,000,097,000,000,128,000,144,000,001,011,128,124,016,000
	BYTE 000,000,000,002,000,000,128,001,142,000,001,000,195,252,008,000
	BYTE 000,000,000,114,000,000,128,003,131,000,003,064,124,124,232,000
	BYTE 000,000,006,130,000,000,128,002,003,128,002,048,224,249,244,000
	BYTE 000,000,015,000,000,000,128,006,032,128,007,224,096,217,244,000
	BYTE 000,000,010,000,000,000,128,006,032,128,124,032,192,225,244,000
	BYTE 000,000,010,000,000,000,128,003,056,207,132,016,193,192,226,000
	BYTE 000,000,010,000,000,001,128,001,012,240,006,024,062,184,002,000
	BYTE 000,000,014,000,000,003,000,003,124,192,001,024,032,252,002,000
	BYTE 000,000,010,000,000,002,000,015,132,192,003,240,048,254,014,000
	BYTE 000,000,011,007,000,012,000,241,012,096,062,016,016,254,030,000
	BYTE 000,000,009,001,192,120,000,003,024,039,194,016,031,252,060,000
	BYTE 000,000,015,192,127,224,000,002,024,056,002,024,048,120,060,000
	BYTE 000,000,000,121,144,208,000,003,188,016,001,252,096,032,056,000
	BYTE 000,000,000,047,012,159,000,007,204,048,127,224,032,024,048,000
	BYTE 000,000,000,121,135,153,128,248,200,127,128,040,032,007,192,000
	BYTE 000,000,000,071,252,000,128,000,248,096,000,040,032,000,000,000
	BYTE 000,007,097,161,236,000,128,003,224,096,000,028,032,000,000,000
	BYTE 000,028,129,001,148,000,156,000,022,064,000,003,192,000,000,000
	BYTE 000,049,001,007,026,001,228,000,030,096,000,000,000,000,000,000
	BYTE 000,198,003,143,011,255,132,000,007,192,000,000,000,000,000,000
	BYTE 003,136,014,251,010,097,004,000,000,000,000,000,000,000,000,000
	BYTE 006,048,048,002,010,034,008,000,000,000,000,000,000,000,000,000
	BYTE 008,064,192,226,010,034,024,000,000,000,000,000,000,000,000,000
	BYTE 016,071,003,034,020,036,048,000,000,000,000,000,000,000,000,000
	BYTE 032,120,013,023,052,104,096,000,000,000,000,000,000,000,000,000
	BYTE 064,000,113,015,232,105,192,000,000,000,000,000,000,000,000,000
	BYTE 064,003,129,007,240,075,000,000,000,000,000,000,000,000,000,000
	BYTE 096,062,001,130,000,204,000,000,000,000,000,000,000,000,000,000
	BYTE 063,240,000,129,001,192,000,000,000,000,000,000,000,000,000,000
	BYTE 007,128,000,193,195,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,048,252,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,015,128,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,001,128,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,102,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,102,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,102,031,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,102,113,128,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,103,128,096,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,006,000,032,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,008,000,016,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,240,000,016,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,243,000,000,008,000,000,000,000,000,000,000,000,000
	BYTE 000,000,001,156,000,000,008,000,000,000,000,000,048,000,000,000
	BYTE 000,000,002,008,000,000,008,000,000,000,000,000,080,000,000,000
	BYTE 000,000,002,016,000,000,008,000,000,000,000,000,151,252,000,000
	BYTE 000,000,002,016,000,000,008,000,000,000,000,000,159,007,000,000
	BYTE 000,000,001,240,000,000,016,000,000,000,000,000,123,225,128,000
	BYTE 000,000,000,240,000,000,016,000,000,000,000,000,060,248,064,000
	BYTE 000,000,000,144,003,224,032,000,000,000,000,000,119,030,096,000
	BYTE 000,000,000,152,012,028,096,000,000,000,000,000,083,135,048,000
	BYTE 000,003,000,200,016,007,128,000,000,000,001,252,209,195,176,000
	BYTE 000,003,195,252,048,000,000,000,000,000,006,006,144,225,144,000
	BYTE 000,002,108,102,032,000,000,000,000,000,004,003,152,240,208,000
	BYTE 000,002,056,035,063,255,255,255,255,255,248,001,152,120,208,000
	BYTE 000,002,111,255,032,000,000,000,000,000,000,001,152,060,208,000
	BYTE 000,002,152,125,032,000,000,000,000,000,000,001,156,028,080,000
	BYTE 000,001,129,129,191,255,255,255,255,255,252,003,204,014,112,000
	BYTE 000,001,134,002,160,000,000,000,000,000,003,142,079,006,032,000
	BYTE 000,001,132,006,160,000,000,000,000,000,000,120,071,131,096,000
	BYTE 000,000,204,004,184,000,000,000,000,000,000,000,035,225,192,000
	BYTE 000,000,248,024,134,000,000,000,000,000,000,000,024,125,128,000
	BYTE 000,000,096,236,066,000,000,000,000,000,000,000,006,007,000,000
	BYTE 000,003,255,251,102,000,000,000,000,000,000,000,001,254,000,000
	BYTE 000,004,003,224,188,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,007,252,063,128,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255
	BYTE 189,189,189,189,189,189,189,189,189,189,189,189,189,189,189,189
	BYTE 219,219,219,219,219,219,219,219,219,219,219,219,219,219,219,219
	BYTE 231,231,231,231,231,231,231,231,231,231,231,231,231,231,231,231
	BYTE 231,231,231,231,231,231,231,231,231,231,231,231,231,231,231,231
	BYTE 219,219,219,219,219,219,219,219,219,219,219,219,219,219,219,219
	BYTE 189,189,189,189,189,189,189,189,189,189,189,189,189,189,189,189
	BYTE 255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255
	BYTE 255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255
	BYTE 189,189,189,189,189,189,189,189,189,189,189,189,189,189,189,189
	BYTE 219,219,219,219,219,219,219,219,219,219,219,219,219,219,219,219
	BYTE 231,231,231,231,231,231,231,231,231,231,231,231,231,231,231,231
	BYTE 231,231,231,231,231,231,231,231,231,231,231,231,231,231,231,231
	BYTE 219,219,219,219,219,219,219,219,219,219,219,219,219,219,219,219
	BYTE 189,189,189,189,189,189,189,189,189,189,189,189,189,189,189,189
	BYTE 255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255
	BYTE 255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255
	BYTE 189,189,189,189,189,189,189,189,189,189,189,189,189,189,189,189
	BYTE 219,219,219,219,219,219,219,219,219,219,219,219,219,219,219,219
	BYTE 231,231,231,231,231,231,231,231,231,231,231,231,231,231,231,231
	BYTE 231,231,231,231,231,231,231,231,231,231,231,231,231,231,231,231
	BYTE 219,219,219,219,219,219,219,219,219,219,219,219,219,219,219,219
	BYTE 189,189,189,189,189,189,189,189,189,189,189,189,189,189,189,189
	BYTE 255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255
	BYTE 000,000,000,255,255,255,255,255,255,255,255,255,255,255,255,255
	BYTE 000,000,000,189,189,189,189,189,189,189,189,189,189,189,189,189
	BYTE 000,000,000,219,219,219,219,219,219,219,219,219,219,219,219,219
	BYTE 048,000,000,231,231,231,231,231,231,231,231,231,231,231,231,231
	BYTE 080,000,000,231,231,231,231,231,231,231,231,231,231,231,231,231
	BYTE 144,000,000,219,219,219,219,219,219,219,219,219,219,219,219,219
	BYTE 159,000,000,189,189,189,189,189,189,189,189,189,189,189,189,189
	BYTE 125,128,000,255,255,255,255,255,255,255,255,255,255,255,255,255
	BYTE 108,255,000,255,255,255,255,255,255,255,255,255,255,255,255,255
	BYTE 072,032,192,189,189,189,189,189,189,189,189,189,189,189,189,189
	BYTE 072,096,096,219,219,219,219,219,219,219,219,219,219,219,219,219
	BYTE 204,192,048,231,231,231,231,231,231,231,231,231,231,231,231,231
	BYTE 135,129,016,231,231,231,231,231,231,231,231,231,231,231,231,231
	BYTE 128,003,208,219,219,219,219,219,219,219,219,219,219,219,219,219
	BYTE 128,004,112,189,189,189,189,189,189,189,189,189,189,189,189,189
	BYTE 134,008,016,255,255,255,255,255,255,255,255,255,255,255,255,255
	BYTE 153,136,016,255,255,255,255,255,255,255,255,255,255,255,255,255
	BYTE 224,136,016,189,189,189,189,189,189,189,189,189,189,189,189,189
	BYTE 096,200,032,219,219,219,219,219,219,219,219,219,219,219,219,219
	BYTE 096,076,096,231,231,231,231,231,231,231,231,231,231,231,231,231
	BYTE 096,067,192,231,231,231,231,231,231,231,231,231,231,231,231,231
	BYTE 048,128,128,219,219,219,219,219,219,219,219,219,219,219,219,219
	BYTE 031,131,000,189,189,189,189,189,189,189,189,189,189,189,189,189
	BYTE 007,254,000,255,255,255,255,255,255,255,255,255,255,255,255,255
	BYTE 255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255
	BYTE 189,189,189,189,189,189,189,189,189,189,189,189,189,189,189,189
	BYTE 219,219,219,219,219,219,219,219,219,219,219,219,219,219,219,219
	BYTE 231,231,231,231,231,231,231,231,231,231,231,231,231,231,231,231
	BYTE 231,231,231,231,231,231,231,231,231,231,231,231,231,231,231,231
	BYTE 219,219,219,219,219,219,219,219,219,219,219,219,219,219,219,219
	BYTE 189,189,189,189,189,189,189,189,189,189,189,189,189,189,189,189
	BYTE 255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255
	BYTE 255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255
	BYTE 189,189,189,189,189,189,189,189,189,189,189,189,189,189,189,189
	BYTE 219,219,219,219,219,219,219,219,219,219,219,219,219,219,219,219
	BYTE 231,231,231,231,231,231,231,231,231,231,231,231,231,231,231,231
	BYTE 231,231,231,231,231,231,231,231,231,231,231,231,231,231,231,231
	BYTE 219,219,219,219,219,219,219,219,219,219,219,219,219,219,219,219
	BYTE 189,189,189,189,189,189,189,189,189,189,189,189,189,189,189,189
	BYTE 255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,007,224,000,000,005,005,000,000,005,000,012,012,000,000,000
	BYTE 000,004,032,016,000,005,053,000,064,005,004,008,008,000,000,000
	BYTE 000,004,032,016,000,000,024,000,064,128,068,008,008,000,000,000
	BYTE 000,060,060,255,000,254,008,000,097,132,068,024,024,000,000,000
	BYTE 000,033,132,016,000,012,008,000,039,191,255,016,016,000,000,000
	BYTE 000,034,068,016,000,024,024,000,060,130,068,016,016,000,000,000
	BYTE 000,034,068,016,000,048,082,124,048,130,068,016,016,000,000,000
	BYTE 000,033,132,255,255,096,219,198,096,158,068,016,016,000,000,000
	BYTE 000,060,060,008,000,064,137,002,192,179,064,000,000,000,000,000
	BYTE 000,004,032,008,000,064,137,006,129,162,064,016,016,000,000,000
	BYTE 000,004,032,012,000,099,024,012,195,182,099,056,056,000,000,000
	BYTE 000,007,224,004,000,062,048,024,126,028,062,048,048,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,002,000,000,000,000
	BYTE 000,000,000,024,000,000,000,000,000,000,000,002,000,000,000,000
	BYTE 000,000,001,155,224,000,000,000,000,000,033,002,000,000,000,000
	BYTE 000,000,001,159,248,000,000,000,000,000,032,129,000,000,000,000
	BYTE 000,000,001,206,012,000,000,000,000,000,032,129,000,000,000,000
	BYTE 000,000,001,216,006,000,000,000,000,000,016,129,000,000,000,000
	BYTE 000,000,048,016,002,000,000,000,000,000,008,128,128,000,000,000
	BYTE 000,000,076,016,003,000,000,000,000,000,008,064,128,000,000,000
	BYTE 000,000,195,000,003,000,000,000,000,000,008,064,128,000,000,000
	BYTE 000,000,140,128,003,000,000,000,000,000,008,064,000,000,000,000
	BYTE 000,000,116,000,003,000,000,000,000,000,008,064,000,000,000,000
	BYTE 000,000,056,000,003,000,000,000,000,000,001,224,012,000,000,000
	BYTE 000,000,040,000,002,000,000,000,000,000,003,049,140,000,000,000
	BYTE 000,000,104,064,002,000,000,000,000,000,002,017,152,000,000,000
	BYTE 000,000,120,032,012,000,000,000,000,000,002,031,184,000,000,000
	BYTE 000,000,060,048,008,000,000,000,000,000,003,227,191,192,000,000
	BYTE 000,000,060,028,048,000,000,000,000,000,004,199,016,048,000,000
	BYTE 000,000,015,007,224,000,000,000,000,000,009,134,032,024,000,000
	BYTE 000,000,003,242,000,000,000,000,000,000,009,002,000,008,000,000
	BYTE 000,000,000,099,000,000,001,000,000,000,007,012,000,012,000,000
	BYTE 000,000,000,065,000,000,003,000,000,000,007,024,000,004,000,000
	BYTE 000,000,000,129,000,003,003,000,000,000,053,136,000,004,000,000
	BYTE 000,000,003,193,000,003,195,128,000,000,251,200,000,004,000,000
	BYTE 000,000,007,064,128,003,247,128,000,001,009,248,000,004,000,000
	BYTE 000,000,057,064,128,003,255,192,000,001,015,068,000,008,000,000
	BYTE 000,003,194,113,128,007,255,192,000,001,001,198,000,024,000,000
	BYTE 000,003,006,017,000,007,255,224,000,001,128,067,000,048,000,000
	BYTE 000,001,006,049,000,015,255,240,000,000,254,065,128,064,000,000
	BYTE 000,000,195,227,000,015,255,248,000,064,114,192,227,128,000,000
	BYTE 000,000,224,006,000,007,255,252,000,096,003,128,220,000,000,000
	BYTE 000,000,048,024,000,001,255,248,000,120,007,000,096,004,000,000
	BYTE 000,000,015,240,000,000,031,224,000,032,028,008,032,132,000,000
	BYTE 000,000,000,000,000,000,031,128,000,032,120,060,033,195,000,000
	BYTE 000,000,014,112,000,000,030,000,000,032,032,060,035,192,224,000
	BYTE 000,000,030,080,000,000,062,000,000,064,032,124,103,193,128,000
	BYTE 000,002,050,144,000,000,056,000,000,128,048,248,079,194,000,000
	BYTE 000,004,038,144,000,000,048,000,007,192,025,248,079,132,000,000
	BYTE 000,004,036,144,000,000,000,000,000,096,015,224,158,012,000,000
	BYTE 000,008,040,224,000,000,000,000,000,016,007,227,028,008,000,000
	BYTE 000,024,176,096,000,000,000,000,000,016,003,198,024,056,000,000
	BYTE 000,017,000,000,000,000,000,000,000,062,003,248,001,204,000,000
	BYTE 000,017,000,000,000,000,000,000,000,098,224,000,001,002,000,000
	BYTE 000,017,008,000,000,000,000,000,000,195,176,000,122,000,000,000
	BYTE 000,002,016,000,000,000,000,000,000,003,023,207,070,000,000,000
	BYTE 000,002,016,000,000,000,000,000,000,004,024,105,195,000,000,000
	BYTE 000,002,032,000,000,000,000,000,000,000,008,024,065,000,000,000
	BYTE 000,002,032,000,000,000,000,000,000,000,000,024,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,005,000,000,005,000,005,000,000,000,005,012,012,000,000
	BYTE 000,131,021,016,000,005,032,005,048,032,252,005,008,008,000,000
	BYTE 000,198,016,062,192,000,038,128,028,032,012,248,008,008,000,000
	BYTE 000,108,255,099,120,254,243,132,006,172,024,024,024,024,000,000
	BYTE 000,056,016,193,001,012,065,159,032,190,048,048,016,016,000,000
	BYTE 000,016,016,145,001,024,196,130,096,178,062,096,016,016,000,000
	BYTE 000,016,082,027,003,048,132,130,062,162,003,255,016,016,000,000
	BYTE 000,048,210,014,006,096,060,130,003,166,121,024,016,016,000,000
	BYTE 000,032,147,006,012,064,102,130,001,228,205,048,000,000,000,000
	BYTE 000,032,145,012,024,064,071,198,003,230,135,032,016,016,000,000
	BYTE 000,032,024,024,048,099,109,012,198,035,198,051,056,056,000,000
	BYTE 000,032,008,048,096,062,056,008,124,032,124,030,048,048,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,007,128,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,128,064,024,120,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,134,064,032,015,000,000,000
	BYTE 000,000,000,000,000,000,000,001,193,026,192,000,001,128,000,000
	BYTE 000,000,000,000,000,000,000,001,035,008,128,000,000,192,000,000
	BYTE 000,000,000,000,000,000,000,017,037,000,000,031,128,096,000,000
	BYTE 000,000,000,000,000,000,000,019,201,128,000,096,096,032,000,000
	BYTE 000,000,000,000,000,000,000,012,000,128,000,064,056,000,000,000
	BYTE 000,000,000,000,000,000,000,024,000,128,204,000,012,015,192,000
	BYTE 000,000,013,143,128,000,000,041,000,000,204,000,006,024,224,000
	BYTE 000,000,013,152,192,000,000,069,192,000,204,001,224,060,112,000
	BYTE 000,000,015,224,096,000,000,018,064,051,236,000,024,124,056,000
	BYTE 000,000,029,128,032,000,000,018,000,126,205,248,012,124,028,000
	BYTE 000,000,045,128,016,000,000,024,000,136,006,012,004,248,252,000
	BYTE 000,000,224,000,024,000,000,000,000,144,008,002,000,193,236,000
	BYTE 000,001,064,000,024,000,000,000,000,176,016,003,000,129,236,000
	BYTE 000,001,064,128,024,000,000,000,001,224,000,001,000,129,236,000
	BYTE 000,015,193,128,024,002,000,000,003,032,000,001,001,185,204,000
	BYTE 000,059,067,000,024,003,000,000,002,032,000,001,001,252,012,000
	BYTE 000,033,230,000,048,003,128,000,002,032,016,001,001,222,028,000
	BYTE 000,113,226,000,048,003,128,048,003,032,112,003,000,254,024,000
	BYTE 000,121,211,000,096,035,128,120,192,241,192,002,000,252,112,000
	BYTE 000,249,233,129,192,127,192,073,192,024,192,006,000,123,224,000
	BYTE 000,248,252,226,096,063,224,077,255,156,039,132,000,031,192,000
	BYTE 000,176,046,060,144,063,240,069,127,240,060,140,000,000,000,000
	BYTE 000,128,036,033,048,063,248,069,032,080,120,248,000,000,000,000
	BYTE 000,128,064,153,048,063,252,067,049,160,000,112,000,000,000,000
	BYTE 000,240,129,014,048,063,252,067,062,096,000,024,000,000,000,000
	BYTE 000,124,130,006,112,035,240,099,048,065,000,008,000,000,000,000
	BYTE 000,124,204,002,096,003,192,039,031,129,192,008,000,000,000,000
	BYTE 000,060,124,002,096,003,128,037,128,003,254,024,000,000,000,000
	BYTE 000,031,196,001,096,003,128,044,128,003,003,112,000,000,000,000
	BYTE 000,000,004,000,192,003,000,048,192,007,000,192,000,000,000,000
	BYTE 000,000,006,000,064,002,000,000,096,006,000,000,000,000,000,000
	BYTE 000,000,002,000,128,000,000,000,124,012,000,000,000,000,000,000
	BYTE 000,000,001,007,000,000,000,000,031,120,000,000,000,000,000,000
	BYTE 000,000,007,252,000,000,000,000,003,192,000,000,000,000,000,000
	BYTE 000,000,028,032,000,000,000,000,006,062,000,000,000,000,000,000
	BYTE 000,000,032,016,000,000,000,000,012,001,000,000,000,000,000,000
	BYTE 000,000,063,240,000,000,000,000,015,255,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
;
 ENDIF	  ;**** NES or PAL Ή [1995/7/13] **********************
;
 IF  JPN  ;**** { Ή [1995/6/30] ****************************
;
;------------------------------------------------------------------------
;|		bZ[W tHg w TCY e[u			|
;------------------------------------------------------------------------
MSG_FONT_X
		BYTE	00AH, 00AH, 00AH, 00AH, 00AH, 00AH, 00AH, 00AH	; 0 -  7
		BYTE	00AH, 00AH, 00AH, 00AH, 00AH, 00AH, 00AH, 00AH	; 8 -  F
		BYTE	00AH, 00AH, 00AH, 00AH, 00AH, 00AH, 00AH, 00AH	;10 - 17
		BYTE	00AH, 00AH, 00AH, 00AH, 00AH, 00AH, 00AH, 00AH	;18 - 1F
		BYTE	00AH, 00AH, 00AH, 00AH, 00AH, 00AH, 00AH, 00AH	;20 - 27
		BYTE	00AH, 00AH, 00AH, 00AH, 00AH, 00AH, 00AH, 00AH	;28 - 2F
		BYTE	00AH, 00AH, 00AH, 00AH, 00AH, 00AH, 00AH, 00AH	;30 - 37
		BYTE	00AH, 00AH, 00AH, 00AH, 00AH, 00AH, 00AH, 00AH	;38 - 3F
		BYTE	00AH, 00AH, 00AH, 00AH, 00AH, 00AH, 00AH, 00AH	;40 - 47
		BYTE	00AH, 00AH, 00AH, 00AH, 00AH, 00AH, 00AH, 00AH	;48 - 4F
		BYTE	00AH, 00AH, 00AH, 00AH, 00AH, 00AH, 00AH, 00AH	;50 - 57
		BYTE	00AH, 00AH, 00AH, 00AH, 00AH, 00AH, 00AH, 00AH	;58 - 5F
		BYTE	00AH, 00AH, 00AH, 00AH, 00AH, 00AH, 00AH, 00AH	;60 - 67
		BYTE	00AH, 00AH, 00AH, 00AH, 00AH, 00AH, 00AH, 00AH	;68 - 6F
		BYTE	00AH, 00AH, 00AH, 00AH, 00AH, 00AH, 00AH, 00AH	;70 - 77
		BYTE	00AH, 00AH, 00AH, 00AH, 00AH, 00AH, 00AH, 00AH	;78 - 7F
		BYTE	00AH, 00AH, 00AH, 00AH, 00AH, 00AH, 00AH, 00AH	;80 - 87
		BYTE	00AH, 00AH, 00AH, 00AH, 00AH, 00AH, 00AH, 00AH	;88 - 8F
		BYTE	00AH, 00AH, 00AH, 00AH, 00AH, 00AH, 00AH, 00AH	;90 - 97
		BYTE	00AH, 00AH, 00AH, 00AH, 00AH, 00AH, 00AH, 00AH	;98 - 9F
		BYTE	00AH, 00AH, 00AH, 00AH, 00AH, 00AH, 00AH, 00AH	;A0 - A7
		BYTE	00AH, 00AH, 00AH, 00AH, 00AH, 00AH, 00AH, 00AH	;A8 - AF
		BYTE	00AH, 00AH, 00AH, 00AH, 00AH, 00AH, 00AH, 00AH	;B0 - B7
		BYTE	00AH, 00AH, 00AH, 00AH, 00AH, 00AH, 00AH, 00AH	;B8 - BF
		BYTE	00AH, 00AH, 00AH, 00AH, 00AH, 00AH, 00AH, 00AH	;C0 - C7
		BYTE	00AH, 00AH, 008H, 00AH, 00AH, 00AH, 00AH, 00AH	;C8 - CF
		BYTE	00AH, 00AH, 00AH, 00AH, 00AH, 008H, 00AH, 00AH	;D0 - D7
		BYTE	00AH, 00AH, 00AH, 00AH, 00AH, 00AH, 00AH, 00AH	;D8 - DF
		BYTE	00AH, 00AH, 00AH, 00AH, 00AH, 00AH, 00AH, 00AH	;E0 - E7
		BYTE	00AH, 00AH, 00AH, 00AH, 00AH, 00AH, 00AH, 00AH	;E8 - EF
		BYTE	00AH, 00AH, 00AH, 00AH, 008H, 00AH, 008H, 00AH	;F0 - F7
		BYTE	008H, 00AH, 00AH, 00AH, 00AH, 00AH, 00AH, 00AH	;F8 - FF
;
;
;
;
;
;------------------------------------------------------------------------
;|		bZ[W tHg f[^ e[u			|
;------------------------------------------------------------------------
MSG_FONT
		BYTE	00000000B
		BYTE	00010000B
		BYTE	11111110B
		BYTE	00010000B
		BYTE	00010001B
		BYTE	01111111B
		BYTE	11010010B
		BYTE	10010111B
		BYTE	10011101B
		BYTE	11011001B
		BYTE	01110011B
		BYTE	00000010B

		BYTE	00000000B
		BYTE	10000000B
		BYTE	10000110B
		BYTE	10000010B
		BYTE	10000011B
		BYTE	10000001B
		BYTE	10000001B
		BYTE	10000000B
		BYTE	10000000B
		BYTE	11011000B
		BYTE	01110000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00110000B
		BYTE	00011110B
		BYTE	00000000B
		BYTE	01111110B
		BYTE	11000011B
		BYTE	00000001B
		BYTE	00000001B
		BYTE	00000011B
		BYTE	00000110B
		BYTE	00001100B
		BYTE	00111000B

		BYTE	00000000B
		BYTE	00110000B
		BYTE	00011110B
		BYTE	00000000B
		BYTE	01111110B
		BYTE	00000110B
		BYTE	00001100B
		BYTE	00011000B
		BYTE	00110000B
		BYTE	01110001B
		BYTE	11011011B
		BYTE	00001110B

		BYTE	00000000B
		BYTE	00010001B
		BYTE	11111101B
		BYTE	00010001B
		BYTE	00010000B
		BYTE	01111110B
		BYTE	11010011B
		BYTE	10010001B
		BYTE	11110001B
		BYTE	01100011B
		BYTE	00000110B
		BYTE	00001100B

		BYTE	00000000B
		BYTE	01000100B
		BYTE	01000100B
		BYTE	11111110B
		BYTE	00101011B
		BYTE	00101001B
		BYTE	00100011B
		BYTE	00100110B
		BYTE	00100100B
		BYTE	00100000B
		BYTE	00100000B
		BYTE	00100000B

		BYTE	00000000B
		BYTE	00001000B
		BYTE	10001000B
		BYTE	10011110B
		BYTE	10111011B
		BYTE	11101001B
		BYTE	11001001B
		BYTE	10011001B
		BYTE	00010011B
		BYTE	00110010B
		BYTE	01100000B
		BYTE	01000000B

		BYTE	00000000B
		BYTE	00010000B
		BYTE	00010000B
		BYTE	00011111B
		BYTE	00001000B
		BYTE	00001000B
		BYTE	01111000B
		BYTE	11001110B
		BYTE	10001011B
		BYTE	10001000B
		BYTE	11011000B
		BYTE	01110000B

		BYTE	00000000B
		BYTE	01000100B
		BYTE	01000110B
		BYTE	01000011B
		BYTE	11111001B
		BYTE	01001101B
		BYTE	01000100B
		BYTE	01000100B
		BYTE	01000100B
		BYTE	01000100B
		BYTE	00001100B
		BYTE	00011000B

		BYTE	00000000B
		BYTE	00001000B
		BYTE	01111110B
		BYTE	00000100B
		BYTE	00000100B
		BYTE	00111111B
		BYTE	00000010B
		BYTE	00000010B
		BYTE	10000110B
		BYTE	11000000B
		BYTE	01100000B
		BYTE	00111000B

		BYTE	00000000B
		BYTE	00001110B
		BYTE	00011000B
		BYTE	00110000B
		BYTE	01100000B
		BYTE	01000000B
		BYTE	01000000B
		BYTE	01100000B
		BYTE	00110000B
		BYTE	00011000B
		BYTE	00001100B
		BYTE	00000110B

		BYTE	00000000B
		BYTE	00000100B
		BYTE	10000100B
		BYTE	10011111B
		BYTE	10000010B
		BYTE	10000010B
		BYTE	10000010B
		BYTE	10000010B
		BYTE	10000010B
		BYTE	11000110B
		BYTE	00001100B
		BYTE	00001000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	11111100B
		BYTE	00000110B
		BYTE	00000100B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	10000000B
		BYTE	11000011B
		BYTE	01111110B

		BYTE	00000000B
		BYTE	00100000B
		BYTE	00100000B
		BYTE	10111110B
		BYTE	10110011B
		BYTE	10100001B
		BYTE	11100001B
		BYTE	11100001B
		BYTE	10100001B
		BYTE	00100011B
		BYTE	00100110B
		BYTE	00100100B

		BYTE	00010000B
		BYTE	00010000B
		BYTE	11111110B
		BYTE	00010000B
		BYTE	00010000B
		BYTE	00011110B
		BYTE	00111000B
		BYTE	01101000B
		BYTE	11001100B
		BYTE	10000000B
		BYTE	11000011B
		BYTE	01111110B

		BYTE	00000000B
		BYTE	00010000B
		BYTE	00110000B
		BYTE	00100000B
		BYTE	01100000B
		BYTE	01000000B
		BYTE	01000000B
		BYTE	11110001B
		BYTE	11011001B
		BYTE	10001001B
		BYTE	10001111B
		BYTE	00000110B

		BYTE	00000000B
		BYTE	00001000B
		BYTE	00001000B
		BYTE	11111111B
		BYTE	00000100B
		BYTE	00000100B
		BYTE	00000100B
		BYTE	00001100B
		BYTE	10000000B
		BYTE	11000000B
		BYTE	01100000B
		BYTE	00111000B

		BYTE	00000000B
		BYTE	00011000B
		BYTE	00110000B
		BYTE	00100000B
		BYTE	01100000B
		BYTE	01000000B
		BYTE	01000000B
		BYTE	01000000B
		BYTE	01000001B
		BYTE	01100011B
		BYTE	00110110B
		BYTE	00011100B

		BYTE	00000000B
		BYTE	00000100B
		BYTE	11111111B
		BYTE	00000100B
		BYTE	00111100B
		BYTE	01100110B
		BYTE	11000110B
		BYTE	10001110B
		BYTE	11011010B
		BYTE	01110010B
		BYTE	00000110B
		BYTE	00000100B

		BYTE	00000000B
		BYTE	00000100B
		BYTE	01000100B
		BYTE	01000100B
		BYTE	11111111B
		BYTE	01000100B
		BYTE	01000100B
		BYTE	01000100B
		BYTE	01000000B
		BYTE	01000000B
		BYTE	01100011B
		BYTE	00111110B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	11111110B
		BYTE	00011000B
		BYTE	00110000B
		BYTE	01100000B
		BYTE	11111111B
		BYTE	00011000B
		BYTE	00110000B
		BYTE	00100000B
		BYTE	00110011B
		BYTE	00011110B

		BYTE	00000101B
		BYTE	01000101B
		BYTE	01000000B
		BYTE	01000110B
		BYTE	11111011B
		BYTE	01001101B
		BYTE	01000101B
		BYTE	01000100B
		BYTE	01000100B
		BYTE	01000100B
		BYTE	00001100B
		BYTE	00011000B

		BYTE	00000101B
		BYTE	00000101B
		BYTE	00001000B
		BYTE	01111110B
		BYTE	00000100B
		BYTE	00111111B
		BYTE	00000010B
		BYTE	00000010B
		BYTE	10000110B
		BYTE	11000000B
		BYTE	01100000B
		BYTE	00111000B

		BYTE	00000101B
		BYTE	00000101B
		BYTE	00011000B
		BYTE	00110000B
		BYTE	01100000B
		BYTE	01000000B
		BYTE	01000000B
		BYTE	01100000B
		BYTE	00110000B
		BYTE	00011000B
		BYTE	00001100B
		BYTE	00000100B

		BYTE	00000000B
		BYTE	00100000B
		BYTE	11111110B
		BYTE	01000000B
		BYTE	01000000B
		BYTE	01001111B
		BYTE	11000001B
		BYTE	10000000B
		BYTE	10000000B
		BYTE	10010000B
		BYTE	10011000B
		BYTE	10001111B

		BYTE	00000000B
		BYTE	00010000B
		BYTE	11111111B
		BYTE	00100000B
		BYTE	00100000B
		BYTE	00100000B
		BYTE	00101110B
		BYTE	00110001B
		BYTE	00000001B
		BYTE	00000011B
		BYTE	00000110B
		BYTE	00001100B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	11111100B
		BYTE	00000110B
		BYTE	00000011B
		BYTE	00000001B
		BYTE	00000001B
		BYTE	00000001B
		BYTE	00000011B
		BYTE	00000010B
		BYTE	00000110B
		BYTE	00011100B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	11111111B
		BYTE	00000110B
		BYTE	00001100B
		BYTE	00011000B
		BYTE	00110000B
		BYTE	01100000B
		BYTE	01000000B
		BYTE	01000000B
		BYTE	01100000B
		BYTE	00111110B

		BYTE	00000000B
		BYTE	01000000B
		BYTE	01000000B
		BYTE	01100001B
		BYTE	00100111B
		BYTE	00111100B
		BYTE	00110000B
		BYTE	01100000B
		BYTE	11000000B
		BYTE	10000001B
		BYTE	11000011B
		BYTE	01111110B

		BYTE	00000101B
		BYTE	00000101B
		BYTE	10000000B
		BYTE	10000100B
		BYTE	10011111B
		BYTE	10000010B
		BYTE	10000010B
		BYTE	10000010B
		BYTE	10000010B
		BYTE	11000110B
		BYTE	00001100B
		BYTE	00001000B

		BYTE	00000101B
		BYTE	00000101B
		BYTE	11111000B
		BYTE	00001100B
		BYTE	00001000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	10000000B
		BYTE	11000011B
		BYTE	01111110B

		BYTE	00000101B
		BYTE	00000101B
		BYTE	00001000B
		BYTE	11111111B
		BYTE	00000100B
		BYTE	00000100B
		BYTE	00000100B
		BYTE	00001100B
		BYTE	10000000B
		BYTE	11000000B
		BYTE	01100000B
		BYTE	00111000B

		BYTE	00000000B
		BYTE	00100000B
		BYTE	00100110B
		BYTE	11110011B
		BYTE	01000001B
		BYTE	11000100B
		BYTE	10000100B
		BYTE	00111100B
		BYTE	01100110B
		BYTE	01000111B
		BYTE	01101101B
		BYTE	00111000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	10000000B
		BYTE	10011111B
		BYTE	10000011B
		BYTE	10000010B
		BYTE	10000000B
		BYTE	10000000B
		BYTE	10000000B
		BYTE	10010000B
		BYTE	10011100B
		BYTE	11000111B

		BYTE	00000000B
		BYTE	00100100B
		BYTE	00100100B
		BYTE	01111110B
		BYTE	11101011B
		BYTE	10101001B
		BYTE	10101001B
		BYTE	10101001B
		BYTE	10111111B
		BYTE	11111001B
		BYTE	01101011B
		BYTE	00001110B

		BYTE	00000000B
		BYTE	00100000B
		BYTE	00100000B
		BYTE	10101110B
		BYTE	10111011B
		BYTE	10110001B
		BYTE	10100111B
		BYTE	11101101B
		BYTE	11101001B
		BYTE	10101001B
		BYTE	00101111B
		BYTE	00100110B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00111100B
		BYTE	01110110B
		BYTE	11010011B
		BYTE	10010001B
		BYTE	10010001B
		BYTE	10010001B
		BYTE	11110011B
		BYTE	01100010B
		BYTE	00000110B
		BYTE	00001100B

		BYTE	00000101B
		BYTE	00010101B
		BYTE	00110000B
		BYTE	00100000B
		BYTE	01100000B
		BYTE	01000000B
		BYTE	01000000B
		BYTE	01000000B
		BYTE	01000001B
		BYTE	01100011B
		BYTE	00110110B
		BYTE	00011100B

		BYTE	00000101B
		BYTE	00000101B
		BYTE	00010000B
		BYTE	11111111B
		BYTE	00001000B
		BYTE	01111100B
		BYTE	11000110B
		BYTE	10001110B
		BYTE	11011010B
		BYTE	01110010B
		BYTE	00000110B
		BYTE	00000100B

		BYTE	00000101B
		BYTE	00000101B
		BYTE	01000000B
		BYTE	01000100B
		BYTE	11111111B
		BYTE	01000100B
		BYTE	01000100B
		BYTE	01000100B
		BYTE	01000000B
		BYTE	01000000B
		BYTE	01100011B
		BYTE	00111110B

		BYTE	00000000B
		BYTE	00000100B
		BYTE	10000100B
		BYTE	10111111B
		BYTE	10000010B
		BYTE	10000010B
		BYTE	10000010B
		BYTE	10011110B
		BYTE	10110011B
		BYTE	10100010B
		BYTE	10110110B
		BYTE	00011100B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	11100000B
		BYTE	00110111B
		BYTE	00110101B
		BYTE	01100100B
		BYTE	11000100B
		BYTE	10000100B
		BYTE	10000100B
		BYTE	10001100B
		BYTE	11011000B
		BYTE	01110000B

		BYTE	00000000B
		BYTE	00110000B
		BYTE	00011000B
		BYTE	00001000B
		BYTE	00001000B
		BYTE	00011000B
		BYTE	01010010B
		BYTE	11011011B
		BYTE	10001001B
		BYTE	10001001B
		BYTE	00011000B
		BYTE	00110000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00111000B
		BYTE	01101100B
		BYTE	01000100B
		BYTE	11000110B
		BYTE	10000010B
		BYTE	10000011B
		BYTE	00000001B
		BYTE	00000001B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	10111111B
		BYTE	10000100B
		BYTE	10000100B
		BYTE	10111111B
		BYTE	10000010B
		BYTE	10011110B
		BYTE	10110011B
		BYTE	10100010B
		BYTE	10110110B
		BYTE	00011100B

		BYTE	00000101B
		BYTE	00000101B
		BYTE	11111000B
		BYTE	00011000B
		BYTE	00110000B
		BYTE	01100000B
		BYTE	11111111B
		BYTE	00011000B
		BYTE	00110000B
		BYTE	00100000B
		BYTE	00110011B
		BYTE	00011110B

		BYTE	00000101B
		BYTE	00100101B
		BYTE	00100000B
		BYTE	11111110B
		BYTE	01000000B
		BYTE	01001111B
		BYTE	11000001B
		BYTE	10000000B
		BYTE	10000000B
		BYTE	10010000B
		BYTE	10011000B
		BYTE	10001111B

		BYTE	00000101B
		BYTE	00100101B
		BYTE	00100000B
		BYTE	11111111B
		BYTE	01000000B
		BYTE	01000000B
		BYTE	01100000B
		BYTE	00111110B
		BYTE	00000011B
		BYTE	00000110B
		BYTE	00001100B
		BYTE	00001000B

		BYTE	00000000B
		BYTE	00001000B
		BYTE	11111111B
		BYTE	00001000B
		BYTE	00001000B
		BYTE	01111111B
		BYTE	00001000B
		BYTE	01111110B
		BYTE	11001011B
		BYTE	10001001B
		BYTE	11011000B
		BYTE	01110000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	11100010B
		BYTE	00110010B
		BYTE	00010010B
		BYTE	00111111B
		BYTE	01101010B
		BYTE	11001010B
		BYTE	10001010B
		BYTE	10011010B
		BYTE	11110010B
		BYTE	01100010B

		BYTE	00000000B
		BYTE	00100000B
		BYTE	11110010B
		BYTE	00100011B
		BYTE	00100001B
		BYTE	01100000B
		BYTE	11100000B
		BYTE	10100000B
		BYTE	10100001B
		BYTE	11100011B
		BYTE	01110110B
		BYTE	00011100B

		BYTE	00000000B
		BYTE	01000100B
		BYTE	01000100B
		BYTE	01111110B
		BYTE	11101011B
		BYTE	10101001B
		BYTE	10101001B
		BYTE	10101001B
		BYTE	11111001B
		BYTE	01110011B
		BYTE	00000110B
		BYTE	00001100B

		BYTE	00000000B
		BYTE	00010000B
		BYTE	00010000B
		BYTE	11111110B
		BYTE	00100000B
		BYTE	00100000B
		BYTE	11111110B
		BYTE	01000000B
		BYTE	01000000B
		BYTE	01000001B
		BYTE	01100011B
		BYTE	00111110B

		BYTE	00000101B
		BYTE	00000101B
		BYTE	00000000B
		BYTE	01111110B
		BYTE	11000011B
		BYTE	00000001B
		BYTE	00000001B
		BYTE	00000001B
		BYTE	00000011B
		BYTE	00000110B
		BYTE	00001100B
		BYTE	00001000B

		BYTE	00000101B
		BYTE	00000101B
		BYTE	00000000B
		BYTE	11111110B
		BYTE	00001100B
		BYTE	00011000B
		BYTE	00110000B
		BYTE	01100000B
		BYTE	01000000B
		BYTE	01000000B
		BYTE	01100011B
		BYTE	00111110B

		BYTE	00000101B
		BYTE	01000101B
		BYTE	01000000B
		BYTE	01100001B
		BYTE	00100111B
		BYTE	00111100B
		BYTE	00110000B
		BYTE	01100000B
		BYTE	11000000B
		BYTE	10000001B
		BYTE	11000011B
		BYTE	01111110B

		BYTE	00000000B
		BYTE	00110000B
		BYTE	00011100B
		BYTE	00000110B
		BYTE	00100000B
		BYTE	01100000B
		BYTE	00111110B
		BYTE	00000011B
		BYTE	00000001B
		BYTE	00000011B
		BYTE	11000110B
		BYTE	01111100B

		BYTE	00000000B
		BYTE	01000001B
		BYTE	01000001B
		BYTE	01000001B
		BYTE	01000001B
		BYTE	01100001B
		BYTE	00100001B
		BYTE	00110011B
		BYTE	00000010B
		BYTE	00000110B
		BYTE	00001100B
		BYTE	00011000B

		BYTE	00000000B
		BYTE	11111100B
		BYTE	00001100B
		BYTE	00011000B
		BYTE	00110000B
		BYTE	00111110B
		BYTE	00000011B
		BYTE	01111001B
		BYTE	11001101B
		BYTE	10000111B
		BYTE	11000110B
		BYTE	01111100B

		BYTE	00000000B
		BYTE	00100000B
		BYTE	00100000B
		BYTE	10101100B
		BYTE	10111110B
		BYTE	10110010B
		BYTE	10100010B
		BYTE	10100110B
		BYTE	11100100B
		BYTE	11100110B
		BYTE	00100011B
		BYTE	00100000B

		BYTE	00000000B
		BYTE	01111100B
		BYTE	00001100B
		BYTE	00011000B
		BYTE	00110000B
		BYTE	01111110B
		BYTE	11000011B
		BYTE	10000001B
		BYTE	00000001B
		BYTE	00000011B
		BYTE	00000110B
		BYTE	00011100B

		BYTE	00000101B
		BYTE	00000101B
		BYTE	10000000B
		BYTE	10000100B
		BYTE	10111111B
		BYTE	10000010B
		BYTE	10000010B
		BYTE	10011110B
		BYTE	10110011B
		BYTE	10100010B
		BYTE	10110110B
		BYTE	00011100B

		BYTE	00000101B
		BYTE	00000101B
		BYTE	11100000B
		BYTE	00110111B
		BYTE	00110100B
		BYTE	01100100B
		BYTE	11000100B
		BYTE	10000100B
		BYTE	10000100B
		BYTE	10001100B
		BYTE	11011000B
		BYTE	01110000B

		BYTE	00000101B
		BYTE	00110101B
		BYTE	00011000B
		BYTE	00001000B
		BYTE	00001000B
		BYTE	00011000B
		BYTE	01010010B
		BYTE	11011011B
		BYTE	10001001B
		BYTE	10001001B
		BYTE	00011000B
		BYTE	00110000B

		BYTE	00000101B
		BYTE	00000101B
		BYTE	00000000B
		BYTE	00111000B
		BYTE	01101100B
		BYTE	01000100B
		BYTE	11000110B
		BYTE	10000010B
		BYTE	10000011B
		BYTE	00000001B
		BYTE	00000001B
		BYTE	00000000B

		BYTE	00000101B
		BYTE	00000101B
		BYTE	10000000B
		BYTE	10111111B
		BYTE	10000100B
		BYTE	10111111B
		BYTE	10000010B
		BYTE	10011110B
		BYTE	10110011B
		BYTE	10100010B
		BYTE	10110110B
		BYTE	00011100B

		BYTE	00000111B
		BYTE	00000101B
		BYTE	10000111B
		BYTE	10000100B
		BYTE	10111111B
		BYTE	10000010B
		BYTE	10000010B
		BYTE	10011110B
		BYTE	10110011B
		BYTE	10100010B
		BYTE	10110110B
		BYTE	00011100B

		BYTE	00000111B
		BYTE	00000101B
		BYTE	11100111B
		BYTE	00110000B
		BYTE	00110111B
		BYTE	01100100B
		BYTE	11000100B
		BYTE	10000100B
		BYTE	10000100B
		BYTE	10001100B
		BYTE	11011000B
		BYTE	01110000B

		BYTE	00000111B
		BYTE	00110101B
		BYTE	00011111B
		BYTE	00001000B
		BYTE	00001000B
		BYTE	00011000B
		BYTE	01010010B
		BYTE	11011011B
		BYTE	10001001B
		BYTE	10001001B
		BYTE	00011000B
		BYTE	00110000B

		BYTE	00000111B
		BYTE	00000101B
		BYTE	00000111B
		BYTE	00111000B
		BYTE	01101100B
		BYTE	01000100B
		BYTE	11000110B
		BYTE	10000010B
		BYTE	10000011B
		BYTE	00000001B
		BYTE	00000001B
		BYTE	00000000B

		BYTE	00000111B
		BYTE	00000101B
		BYTE	10000111B
		BYTE	10111111B
		BYTE	10000100B
		BYTE	10111111B
		BYTE	10000010B
		BYTE	10011110B
		BYTE	10110011B
		BYTE	10100010B
		BYTE	10110110B
		BYTE	00011100B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00101000B
		BYTE	00101000B
		BYTE	11111110B
		BYTE	00101010B
		BYTE	00100010B
		BYTE	00100110B
		BYTE	00101100B
		BYTE	00100000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00010000B
		BYTE	00010000B
		BYTE	10111100B
		BYTE	11110110B
		BYTE	11010010B
		BYTE	10010110B
		BYTE	00110100B
		BYTE	00100000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00001000B
		BYTE	00001000B
		BYTE	00001110B
		BYTE	00001000B
		BYTE	01111000B
		BYTE	11001110B
		BYTE	11011010B
		BYTE	01110000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	01111100B
		BYTE	11000110B
		BYTE	00000010B
		BYTE	00000110B
		BYTE	00001100B
		BYTE	00011000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00010000B
		BYTE	11111110B
		BYTE	00100000B
		BYTE	01111110B
		BYTE	11101100B
		BYTE	10111110B
		BYTE	11110010B
		BYTE	01100010B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	10000100B
		BYTE	10000110B
		BYTE	10000010B
		BYTE	10000010B
		BYTE	10000010B
		BYTE	11010000B
		BYTE	01110000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00111000B
		BYTE	00000000B
		BYTE	01111100B
		BYTE	11000110B
		BYTE	00000110B
		BYTE	00001100B
		BYTE	00011000B
		BYTE	00110000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00111000B
		BYTE	00000000B
		BYTE	11111100B
		BYTE	00011000B
		BYTE	00110000B
		BYTE	01110000B
		BYTE	11011000B
		BYTE	00001110B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00010010B
		BYTE	11111010B
		BYTE	00010010B
		BYTE	01111100B
		BYTE	11010110B
		BYTE	10010010B
		BYTE	11110110B
		BYTE	01100100B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	11111110B
		BYTE	00000011B
		BYTE	00000001B
		BYTE	00011001B
		BYTE	00110011B
		BYTE	01100110B
		BYTE	01000100B
		BYTE	11000000B
		BYTE	10000000B
		BYTE	10000000B

		BYTE	00000000B
		BYTE	00000001B
		BYTE	00000111B
		BYTE	00011100B
		BYTE	00111000B
		BYTE	01101000B
		BYTE	11001000B
		BYTE	10001000B
		BYTE	00001000B
		BYTE	00001000B
		BYTE	00001000B
		BYTE	00001000B

		BYTE	00000000B
		BYTE	00010000B
		BYTE	00011000B
		BYTE	01111110B
		BYTE	11000011B
		BYTE	10000001B
		BYTE	11000001B
		BYTE	01000011B
		BYTE	00000010B
		BYTE	00000110B
		BYTE	00001100B
		BYTE	00011000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	01111111B
		BYTE	00001000B
		BYTE	00011000B
		BYTE	00010000B
		BYTE	00010000B
		BYTE	00010000B
		BYTE	00010000B
		BYTE	00011000B
		BYTE	11111111B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00000100B
		BYTE	00000100B
		BYTE	11111111B
		BYTE	00000010B
		BYTE	00001110B
		BYTE	00011010B
		BYTE	00110010B
		BYTE	01100010B
		BYTE	11000010B
		BYTE	10000110B
		BYTE	00000100B

		BYTE	00000000B
		BYTE	00100000B
		BYTE	00100000B
		BYTE	00111110B
		BYTE	11100011B
		BYTE	00100001B
		BYTE	00100011B
		BYTE	00100110B
		BYTE	00110100B
		BYTE	00010000B
		BYTE	00010000B
		BYTE	00010000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	01111100B
		BYTE	00000110B
		BYTE	00000010B
		BYTE	00000010B
		BYTE	00000110B
		BYTE	00000100B
		BYTE	00000100B
		BYTE	00001100B
		BYTE	00001000B
		BYTE	11111111B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	01111100B
		BYTE	00000110B
		BYTE	00000010B
		BYTE	00000010B
		BYTE	01111110B
		BYTE	00000010B
		BYTE	00000010B
		BYTE	00000010B
		BYTE	00000110B
		BYTE	01111110B

		BYTE	00000000B
		BYTE	00001000B
		BYTE	00001000B
		BYTE	11111110B
		BYTE	00010011B
		BYTE	00110001B
		BYTE	00100001B
		BYTE	00100001B
		BYTE	01100001B
		BYTE	01000011B
		BYTE	01000010B
		BYTE	00000110B

		BYTE	00000000B
		BYTE	00010000B
		BYTE	00010000B
		BYTE	11111111B
		BYTE	00010000B
		BYTE	00010000B
		BYTE	00010000B
		BYTE	11111111B
		BYTE	00001000B
		BYTE	00001000B
		BYTE	00001100B
		BYTE	00000100B

		BYTE	00000000B
		BYTE	00011000B
		BYTE	00110000B
		BYTE	01111110B
		BYTE	11000011B
		BYTE	10000001B
		BYTE	00000001B
		BYTE	00000011B
		BYTE	00000110B
		BYTE	00001100B
		BYTE	00011000B
		BYTE	00110000B

		BYTE	00000000B
		BYTE	01100000B
		BYTE	01000000B
		BYTE	11111111B
		BYTE	10000100B
		BYTE	10000100B
		BYTE	10000100B
		BYTE	00001100B
		BYTE	00001000B
		BYTE	00011000B
		BYTE	00110000B
		BYTE	00100000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	11111110B
		BYTE	00000011B
		BYTE	00000001B
		BYTE	00000001B
		BYTE	00000001B
		BYTE	00000001B
		BYTE	00000001B
		BYTE	00000011B
		BYTE	11111110B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	11111111B
		BYTE	10000011B
		BYTE	10000001B
		BYTE	10000001B
		BYTE	00000001B
		BYTE	00000011B
		BYTE	00000010B
		BYTE	00000110B
		BYTE	00011100B
		BYTE	00110000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	11111110B
		BYTE	00000011B
		BYTE	00000001B
		BYTE	00011111B
		BYTE	01110001B
		BYTE	00000001B
		BYTE	00000011B
		BYTE	00000110B
		BYTE	00001100B
		BYTE	00111000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	11000000B
		BYTE	01100000B
		BYTE	00110001B
		BYTE	00000001B
		BYTE	00000011B
		BYTE	00000110B
		BYTE	00001100B
		BYTE	00011000B
		BYTE	00110000B
		BYTE	01100000B

		BYTE	00000000B
		BYTE	01000010B
		BYTE	01000010B
		BYTE	11111111B
		BYTE	01000010B
		BYTE	01000010B
		BYTE	01100010B
		BYTE	00100110B
		BYTE	00001100B
		BYTE	00011000B
		BYTE	00110000B
		BYTE	00100000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	11100000B
		BYTE	00110000B
		BYTE	00000000B
		BYTE	11000001B
		BYTE	01110001B
		BYTE	00000011B
		BYTE	00000110B
		BYTE	00001100B
		BYTE	00011000B
		BYTE	00110000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	11111100B
		BYTE	00000110B
		BYTE	00000110B
		BYTE	00001100B
		BYTE	00011000B
		BYTE	00111000B
		BYTE	01101100B
		BYTE	11000110B
		BYTE	10000011B

		BYTE	00000000B
		BYTE	01000000B
		BYTE	01000000B
		BYTE	11111110B
		BYTE	01000011B
		BYTE	01000011B
		BYTE	01000110B
		BYTE	01000100B
		BYTE	01100000B
		BYTE	00100000B
		BYTE	00110011B
		BYTE	00011110B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	10000001B
		BYTE	11000001B
		BYTE	01100011B
		BYTE	00100010B
		BYTE	00000110B
		BYTE	00000100B
		BYTE	00001100B
		BYTE	00011000B
		BYTE	00110000B
		BYTE	00100000B

		BYTE	00000101B
		BYTE	00000101B
		BYTE	00001000B
		BYTE	11111110B
		BYTE	00010011B
		BYTE	00110001B
		BYTE	00100001B
		BYTE	00100001B
		BYTE	01100001B
		BYTE	01000011B
		BYTE	01000010B
		BYTE	00000110B

		BYTE	00000101B
		BYTE	00010101B
		BYTE	00010000B
		BYTE	11111111B
		BYTE	00010000B
		BYTE	00010000B
		BYTE	00010000B
		BYTE	11111111B
		BYTE	00001000B
		BYTE	00001000B
		BYTE	00001100B
		BYTE	00000100B

		BYTE	00000101B
		BYTE	00010101B
		BYTE	00110000B
		BYTE	01111110B
		BYTE	11000011B
		BYTE	10000001B
		BYTE	00000001B
		BYTE	00000011B
		BYTE	00000110B
		BYTE	00001100B
		BYTE	00011000B
		BYTE	00110000B

		BYTE	00000000B
		BYTE	00010000B
		BYTE	00111110B
		BYTE	01100011B
		BYTE	11000001B
		BYTE	10010001B
		BYTE	00011011B
		BYTE	00001110B
		BYTE	00000110B
		BYTE	00001100B
		BYTE	00011000B
		BYTE	00110000B

		BYTE	00000000B
		BYTE	00000110B
		BYTE	00011100B
		BYTE	01111000B
		BYTE	00001000B
		BYTE	00001100B
		BYTE	11111111B
		BYTE	00000100B
		BYTE	00000100B
		BYTE	00001100B
		BYTE	00011000B
		BYTE	00110000B

		BYTE	00000000B
		BYTE	00010000B
		BYTE	10010000B
		BYTE	11011000B
		BYTE	01001001B
		BYTE	01001001B
		BYTE	00000011B
		BYTE	00000010B
		BYTE	00000110B
		BYTE	00001100B
		BYTE	00011000B
		BYTE	00110000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	01111110B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	11111111B
		BYTE	00001000B
		BYTE	00001000B
		BYTE	00011000B
		BYTE	00110000B
		BYTE	01100000B
		BYTE	01000000B

		BYTE	00000000B
		BYTE	00100000B
		BYTE	00100000B
		BYTE	01100000B
		BYTE	01000000B
		BYTE	01111000B
		BYTE	01001110B
		BYTE	01000011B
		BYTE	01000000B
		BYTE	01100000B
		BYTE	00100000B
		BYTE	00100000B

		BYTE	00000101B
		BYTE	01100101B
		BYTE	01000000B
		BYTE	11111111B
		BYTE	10000100B
		BYTE	10000100B
		BYTE	10000100B
		BYTE	00001100B
		BYTE	00001000B
		BYTE	00011000B
		BYTE	00110000B
		BYTE	00100000B

		BYTE	00000101B
		BYTE	00000101B
		BYTE	00000000B
		BYTE	11111110B
		BYTE	00000011B
		BYTE	00000001B
		BYTE	00000001B
		BYTE	00000001B
		BYTE	00000001B
		BYTE	00000001B
		BYTE	00000011B
		BYTE	11111110B

		BYTE	00000101B
		BYTE	01000101B
		BYTE	01000010B
		BYTE	11111111B
		BYTE	01000010B
		BYTE	01000010B
		BYTE	01100010B
		BYTE	00100110B
		BYTE	00001100B
		BYTE	00011000B
		BYTE	00110000B
		BYTE	00100000B

		BYTE	00000000B
		BYTE	00001000B
		BYTE	00001100B
		BYTE	00000100B
		BYTE	11111111B
		BYTE	00000100B
		BYTE	00000100B
		BYTE	00001100B
		BYTE	00001000B
		BYTE	00011000B
		BYTE	00110000B
		BYTE	01100000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	01111110B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	11111111B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	11111110B
		BYTE	00000011B
		BYTE	00000001B
		BYTE	00100011B
		BYTE	00110110B
		BYTE	00011100B
		BYTE	00111100B
		BYTE	01100110B
		BYTE	11000011B
		BYTE	10000000B

		BYTE	00010000B
		BYTE	00011000B
		BYTE	11111100B
		BYTE	00000110B
		BYTE	00001110B
		BYTE	00011100B
		BYTE	00111000B
		BYTE	01111100B
		BYTE	11010110B
		BYTE	10010011B
		BYTE	00010000B
		BYTE	00010000B

		BYTE	00000000B
		BYTE	00000010B
		BYTE	00000110B
		BYTE	00001100B
		BYTE	00011000B
		BYTE	00010000B
		BYTE	00110000B
		BYTE	00100000B
		BYTE	00100000B
		BYTE	01100000B
		BYTE	01000000B
		BYTE	01000000B

		BYTE	00000101B
		BYTE	00000101B
		BYTE	11100000B
		BYTE	00110000B
		BYTE	00000000B
		BYTE	11000001B
		BYTE	01110001B
		BYTE	00000011B
		BYTE	00000110B
		BYTE	00001100B
		BYTE	00011000B
		BYTE	00110000B

		BYTE	00000101B
		BYTE	00000101B
		BYTE	11110000B
		BYTE	00011100B
		BYTE	00000100B
		BYTE	00000100B
		BYTE	00001100B
		BYTE	00011000B
		BYTE	00111000B
		BYTE	01101100B
		BYTE	11000110B
		BYTE	10000011B

		BYTE	00000101B
		BYTE	01000101B
		BYTE	01000000B
		BYTE	11111110B
		BYTE	01000011B
		BYTE	01000011B
		BYTE	01000110B
		BYTE	01000100B
		BYTE	01100000B
		BYTE	00100000B
		BYTE	00110011B
		BYTE	00011110B

		BYTE	00000000B
		BYTE	00100000B
		BYTE	00100000B
		BYTE	01100100B
		BYTE	01000110B
		BYTE	01000010B
		BYTE	01000010B
		BYTE	11000011B
		BYTE	10000001B
		BYTE	10000001B
		BYTE	10000001B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	10000000B
		BYTE	10000000B
		BYTE	10000010B
		BYTE	10001110B
		BYTE	10111000B
		BYTE	11100000B
		BYTE	10000000B
		BYTE	11000000B
		BYTE	01000000B
		BYTE	01100011B
		BYTE	00111110B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	11111110B
		BYTE	00000011B
		BYTE	00000001B
		BYTE	00000001B
		BYTE	00000011B
		BYTE	00000010B
		BYTE	00000110B
		BYTE	00001100B
		BYTE	00011000B
		BYTE	00110000B

		BYTE	00000000B
		BYTE	00010000B
		BYTE	00111000B
		BYTE	01101000B
		BYTE	01001100B
		BYTE	11000100B
		BYTE	10000110B
		BYTE	00000010B
		BYTE	00000011B
		BYTE	00000001B
		BYTE	00000001B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00001000B
		BYTE	00011000B
		BYTE	11111111B
		BYTE	00010000B
		BYTE	00010000B
		BYTE	01010010B
		BYTE	11010010B
		BYTE	10010011B
		BYTE	10010001B
		BYTE	00011000B
		BYTE	00001000B

		BYTE	00000101B
		BYTE	00000101B
		BYTE	10000000B
		BYTE	11000001B
		BYTE	01100011B
		BYTE	00100010B
		BYTE	00000110B
		BYTE	00000100B
		BYTE	00001100B
		BYTE	00011000B
		BYTE	00110000B
		BYTE	00100000B

		BYTE	00000101B
		BYTE	00010101B
		BYTE	00111110B
		BYTE	01100011B
		BYTE	11000001B
		BYTE	10010001B
		BYTE	00011011B
		BYTE	00001110B
		BYTE	00000110B
		BYTE	00001100B
		BYTE	00011000B
		BYTE	00110000B

		BYTE	00000101B
		BYTE	00000101B
		BYTE	00011110B
		BYTE	01111000B
		BYTE	00001000B
		BYTE	00001100B
		BYTE	11111111B
		BYTE	00000100B
		BYTE	00000100B
		BYTE	00001100B
		BYTE	00011000B
		BYTE	00110000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	11111110B
		BYTE	00000011B
		BYTE	00000001B
		BYTE	00000011B
		BYTE	01000110B
		BYTE	01101100B
		BYTE	00111000B
		BYTE	00011000B
		BYTE	00001100B
		BYTE	00000110B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	01110000B
		BYTE	00011110B
		BYTE	00000010B
		BYTE	01100000B
		BYTE	00111000B
		BYTE	00001110B
		BYTE	10000000B
		BYTE	11100000B
		BYTE	00111100B
		BYTE	00000111B

		BYTE	00000000B
		BYTE	00001000B
		BYTE	00011000B
		BYTE	00110000B
		BYTE	00100000B
		BYTE	01100000B
		BYTE	01000100B
		BYTE	11000110B
		BYTE	10000010B
		BYTE	10000111B
		BYTE	11011101B
		BYTE	01110001B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000001B
		BYTE	11000011B
		BYTE	01100110B
		BYTE	00111100B
		BYTE	00011000B
		BYTE	00011100B
		BYTE	00110110B
		BYTE	01100011B
		BYTE	11000000B
		BYTE	10000000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	01111110B
		BYTE	00010000B
		BYTE	00110000B
		BYTE	00100000B
		BYTE	11111111B
		BYTE	00100000B
		BYTE	00100000B
		BYTE	00100000B
		BYTE	00110011B
		BYTE	00011110B

		BYTE	00000101B
		BYTE	00010101B
		BYTE	10010000B
		BYTE	11011000B
		BYTE	01001001B
		BYTE	01001001B
		BYTE	00000011B
		BYTE	00000010B
		BYTE	00000110B
		BYTE	00001100B
		BYTE	00011000B
		BYTE	00110000B

		BYTE	00000101B
		BYTE	00000101B
		BYTE	01111110B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	11111111B
		BYTE	00001000B
		BYTE	00001000B
		BYTE	00011000B
		BYTE	00110000B
		BYTE	01100000B
		BYTE	01000000B

		BYTE	00000101B
		BYTE	00100101B
		BYTE	00100000B
		BYTE	01100000B
		BYTE	01000000B
		BYTE	01111000B
		BYTE	01001110B
		BYTE	01000011B
		BYTE	01000000B
		BYTE	01100000B
		BYTE	00100000B
		BYTE	00100000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	01111110B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	11111110B
		BYTE	00000011B
		BYTE	00000011B
		BYTE	00000110B
		BYTE	00001100B
		BYTE	00011000B
		BYTE	00110000B

		BYTE	00000000B
		BYTE	01000000B
		BYTE	01000001B
		BYTE	01000001B
		BYTE	01000001B
		BYTE	01000001B
		BYTE	01100001B
		BYTE	00100011B
		BYTE	00000010B
		BYTE	00000110B
		BYTE	00001100B
		BYTE	00011000B

		BYTE	00000000B
		BYTE	00001000B
		BYTE	01001000B
		BYTE	01011000B
		BYTE	01010000B
		BYTE	11010000B
		BYTE	10010001B
		BYTE	10110001B
		BYTE	10100011B
		BYTE	10100010B
		BYTE	10110110B
		BYTE	00011100B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	01000000B
		BYTE	01000000B
		BYTE	11000000B
		BYTE	10000000B
		BYTE	10000001B
		BYTE	10000011B
		BYTE	10000110B
		BYTE	10001100B
		BYTE	11011000B
		BYTE	01110000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00100000B
		BYTE	01111110B
		BYTE	01000011B
		BYTE	11000001B
		BYTE	10000001B
		BYTE	10000001B
		BYTE	10000001B
		BYTE	10000001B
		BYTE	11000001B
		BYTE	01111111B

		BYTE	00000101B
		BYTE	00100101B
		BYTE	00100000B
		BYTE	01100100B
		BYTE	01000110B
		BYTE	01000010B
		BYTE	01000010B
		BYTE	11000011B
		BYTE	10000001B
		BYTE	10000001B
		BYTE	10000001B
		BYTE	00000000B

		BYTE	00000101B
		BYTE	10000101B
		BYTE	10000000B
		BYTE	10000010B
		BYTE	10001110B
		BYTE	10111000B
		BYTE	11100000B
		BYTE	10000000B
		BYTE	11000000B
		BYTE	01000000B
		BYTE	01100011B
		BYTE	00111110B

		BYTE	00000101B
		BYTE	00000101B
		BYTE	11111110B
		BYTE	00000011B
		BYTE	00000001B
		BYTE	00000001B
		BYTE	00000011B
		BYTE	00000010B
		BYTE	00000110B
		BYTE	00001100B
		BYTE	00011000B
		BYTE	00110000B

		BYTE	00000101B
		BYTE	00010101B
		BYTE	00111000B
		BYTE	01101000B
		BYTE	01001100B
		BYTE	11000100B
		BYTE	10000110B
		BYTE	00000010B
		BYTE	00000011B
		BYTE	00000001B
		BYTE	00000001B
		BYTE	00000000B

		BYTE	00000101B
		BYTE	00010101B
		BYTE	00010000B
		BYTE	11111111B
		BYTE	00010000B
		BYTE	00010000B
		BYTE	01010010B
		BYTE	11010010B
		BYTE	10010011B
		BYTE	10010001B
		BYTE	00011000B
		BYTE	00001000B

		BYTE	00000111B
		BYTE	00100101B
		BYTE	00100111B
		BYTE	01100100B
		BYTE	01000110B
		BYTE	01000010B
		BYTE	01000010B
		BYTE	11000011B
		BYTE	10000001B
		BYTE	10000001B
		BYTE	10000001B
		BYTE	00000000B

		BYTE	00000111B
		BYTE	10000101B
		BYTE	10000111B
		BYTE	10000000B
		BYTE	10001110B
		BYTE	10111000B
		BYTE	11100000B
		BYTE	10000000B
		BYTE	11000000B
		BYTE	01000000B
		BYTE	01100011B
		BYTE	00111110B

		BYTE	00000111B
		BYTE	00000101B
		BYTE	00000111B
		BYTE	11111110B
		BYTE	00000001B
		BYTE	00000001B
		BYTE	00000011B
		BYTE	00000010B
		BYTE	00000110B
		BYTE	00001100B
		BYTE	00011000B
		BYTE	00110000B

		BYTE	00000111B
		BYTE	00010101B
		BYTE	00111111B
		BYTE	01101000B
		BYTE	01001100B
		BYTE	11000100B
		BYTE	10000110B
		BYTE	00000010B
		BYTE	00000011B
		BYTE	00000001B
		BYTE	00000001B
		BYTE	00000000B

		BYTE	00000111B
		BYTE	00010101B
		BYTE	00010111B
		BYTE	00010000B
		BYTE	11111111B
		BYTE	00010000B
		BYTE	01010010B
		BYTE	11010010B
		BYTE	10010011B
		BYTE	10010001B
		BYTE	00011000B
		BYTE	00001000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00100000B
		BYTE	00100000B
		BYTE	11111100B
		BYTE	00100110B
		BYTE	00101100B
		BYTE	00101000B
		BYTE	00100000B
		BYTE	00100000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	01110000B
		BYTE	00011000B
		BYTE	00001000B
		BYTE	00001000B
		BYTE	00001000B
		BYTE	00001000B
		BYTE	11111110B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	01111000B
		BYTE	00001100B
		BYTE	00000100B
		BYTE	01111110B
		BYTE	00000100B
		BYTE	00000100B
		BYTE	00111100B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	01010000B
		BYTE	01010000B
		BYTE	01010010B
		BYTE	00000110B
		BYTE	00001100B
		BYTE	00011000B
		BYTE	00110000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	11111100B
		BYTE	00000110B
		BYTE	00010010B
		BYTE	00110110B
		BYTE	00100100B
		BYTE	01100000B
		BYTE	01000000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00001100B
		BYTE	00011000B
		BYTE	00111000B
		BYTE	01101000B
		BYTE	11001000B
		BYTE	00001000B
		BYTE	00001000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00010000B
		BYTE	01111110B
		BYTE	01000010B
		BYTE	01000110B
		BYTE	00001100B
		BYTE	00011000B
		BYTE	00110000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	01111110B
		BYTE	00001000B
		BYTE	00001000B
		BYTE	00011000B
		BYTE	00010000B
		BYTE	00010000B
		BYTE	01111110B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00001000B
		BYTE	11111110B
		BYTE	00001100B
		BYTE	00011100B
		BYTE	00110100B
		BYTE	01100100B
		BYTE	11000100B

		BYTE	00000000B
		BYTE	00111100B
		BYTE	01100110B
		BYTE	01000011B
		BYTE	11000001B
		BYTE	10000001B
		BYTE	10000001B
		BYTE	10000001B
		BYTE	10000011B
		BYTE	10000010B
		BYTE	11000110B
		BYTE	01111100B

		BYTE	00000000B
		BYTE	00011000B
		BYTE	00001100B
		BYTE	00000100B
		BYTE	00000100B
		BYTE	00001100B
		BYTE	00001000B
		BYTE	00001000B
		BYTE	00011000B
		BYTE	00010000B
		BYTE	00010000B
		BYTE	00111000B

		BYTE	00000000B
		BYTE	00111110B
		BYTE	01100011B
		BYTE	01000001B
		BYTE	00000001B
		BYTE	00000011B
		BYTE	00001110B
		BYTE	00111000B
		BYTE	01100000B
		BYTE	11000000B
		BYTE	11000001B
		BYTE	01111111B

		BYTE	00000000B
		BYTE	00111100B
		BYTE	01100110B
		BYTE	01000010B
		BYTE	00000110B
		BYTE	00011100B
		BYTE	00000110B
		BYTE	00000011B
		BYTE	10000001B
		BYTE	11000011B
		BYTE	01100110B
		BYTE	00111100B

		BYTE	00000000B
		BYTE	01000010B
		BYTE	11000010B
		BYTE	10000110B
		BYTE	10000100B
		BYTE	10000100B
		BYTE	11001100B
		BYTE	01101000B
		BYTE	00111111B
		BYTE	00001000B
		BYTE	00001000B
		BYTE	00001000B

		BYTE	00000000B
		BYTE	10000000B
		BYTE	11111111B
		BYTE	10000000B
		BYTE	10000000B
		BYTE	11111100B
		BYTE	00000110B
		BYTE	00000011B
		BYTE	00000001B
		BYTE	10000011B
		BYTE	11000110B
		BYTE	01111100B

		BYTE	00000000B
		BYTE	00110000B
		BYTE	01100000B
		BYTE	11000000B
		BYTE	10000000B
		BYTE	10111110B
		BYTE	11100011B
		BYTE	11000001B
		BYTE	11000001B
		BYTE	01000001B
		BYTE	01100011B
		BYTE	00111110B

		BYTE	00000000B
		BYTE	01111110B
		BYTE	11000011B
		BYTE	10000001B
		BYTE	00000011B
		BYTE	00000110B
		BYTE	00001100B
		BYTE	00011000B
		BYTE	00010000B
		BYTE	00110000B
		BYTE	00100000B
		BYTE	00100000B

		BYTE	00000000B
		BYTE	01111100B
		BYTE	11000110B
		BYTE	10000010B
		BYTE	10000010B
		BYTE	11000110B
		BYTE	01111110B
		BYTE	11000011B
		BYTE	10000001B
		BYTE	10000001B
		BYTE	11000011B
		BYTE	01111110B

		BYTE	00000000B
		BYTE	01111110B
		BYTE	11000011B
		BYTE	10000001B
		BYTE	10000001B
		BYTE	11000011B
		BYTE	01111110B
		BYTE	00000110B
		BYTE	00001100B
		BYTE	00011000B
		BYTE	00110000B
		BYTE	00100000B

		BYTE	00000000B
		BYTE	00011100B
		BYTE	00110110B
		BYTE	01100010B
		BYTE	01000011B
		BYTE	11000001B
		BYTE	11111111B
		BYTE	10000001B
		BYTE	10000001B
		BYTE	10000001B
		BYTE	10000001B
		BYTE	00000001B

		BYTE	00000000B
		BYTE	11111100B
		BYTE	10001110B
		BYTE	10000010B
		BYTE	10000010B
		BYTE	10000110B
		BYTE	11111100B
		BYTE	10000110B
		BYTE	10000011B
		BYTE	10000011B
		BYTE	10000110B
		BYTE	11111100B

		BYTE	00000000B
		BYTE	00111100B
		BYTE	01100110B
		BYTE	01000010B
		BYTE	11000010B
		BYTE	10000000B
		BYTE	10000000B
		BYTE	10000000B
		BYTE	10000000B
		BYTE	10000011B
		BYTE	11000110B
		BYTE	01111100B

		BYTE	00000000B
		BYTE	11111100B
		BYTE	10000110B
		BYTE	10000011B
		BYTE	10000001B
		BYTE	10000001B
		BYTE	10000001B
		BYTE	10000001B
		BYTE	10000011B
		BYTE	10000110B
		BYTE	10011100B
		BYTE	11110000B

		BYTE	00000000B
		BYTE	11111110B
		BYTE	10000000B
		BYTE	10000000B
		BYTE	10000000B
		BYTE	11111100B
		BYTE	10000000B
		BYTE	10000000B
		BYTE	10000000B
		BYTE	10000000B
		BYTE	10000011B
		BYTE	11111110B

		BYTE	00000000B
		BYTE	00111110B
		BYTE	01100000B
		BYTE	01000000B
		BYTE	01000000B
		BYTE	01000000B
		BYTE	01111110B
		BYTE	01000000B
		BYTE	01000000B
		BYTE	01000000B
		BYTE	01000000B
		BYTE	00100000B

		BYTE	00000000B
		BYTE	00111100B
		BYTE	01100110B
		BYTE	01000010B
		BYTE	11000000B
		BYTE	10000000B
		BYTE	10001111B
		BYTE	10000001B
		BYTE	10000001B
		BYTE	11000001B
		BYTE	01100011B
		BYTE	00111110B

		BYTE	00000000B
		BYTE	00100001B
		BYTE	01100001B
		BYTE	01000001B
		BYTE	01000001B
		BYTE	01000010B
		BYTE	11111110B
		BYTE	10000010B
		BYTE	10000010B
		BYTE	10000010B
		BYTE	10000010B
		BYTE	10000010B

		BYTE	00000000B
		BYTE	00111110B
		BYTE	00001000B
		BYTE	00001000B
		BYTE	00001000B
		BYTE	00011000B
		BYTE	00010000B
		BYTE	00010000B
		BYTE	00010000B
		BYTE	00010000B
		BYTE	00010000B
		BYTE	01111100B

		BYTE	00000000B
		BYTE	00000100B
		BYTE	00000110B
		BYTE	00000010B
		BYTE	00000011B
		BYTE	00000001B
		BYTE	00000001B
		BYTE	00000001B
		BYTE	10000001B
		BYTE	11000011B
		BYTE	01100110B
		BYTE	00111100B

		BYTE	00000000B
		BYTE	01000011B
		BYTE	01000110B
		BYTE	11001100B
		BYTE	10011000B
		BYTE	10111000B
		BYTE	11101000B
		BYTE	11001100B
		BYTE	10000100B
		BYTE	10000110B
		BYTE	10000010B
		BYTE	11000011B

		BYTE	00000000B
		BYTE	01000000B
		BYTE	01000000B
		BYTE	01000000B
		BYTE	01000000B
		BYTE	11000000B
		BYTE	10000000B
		BYTE	10000000B
		BYTE	10000000B
		BYTE	10000000B
		BYTE	10000000B
		BYTE	11111111B

		BYTE	00000000B
		BYTE	00100010B
		BYTE	01100011B
		BYTE	01110111B
		BYTE	01011101B
		BYTE	11011001B
		BYTE	10001001B
		BYTE	10000001B
		BYTE	10000001B
		BYTE	10000001B
		BYTE	11000001B
		BYTE	01000000B

		BYTE	00000000B
		BYTE	01000001B
		BYTE	01100001B
		BYTE	11100011B
		BYTE	10110010B
		BYTE	10010010B
		BYTE	10011010B
		BYTE	10001010B
		BYTE	10001110B
		BYTE	10000110B
		BYTE	11000010B
		BYTE	01000000B

		BYTE	00000000B
		BYTE	00111100B
		BYTE	01100110B
		BYTE	01000010B
		BYTE	11000011B
		BYTE	10000001B
		BYTE	10000001B
		BYTE	10000001B
		BYTE	10000001B
		BYTE	11000001B
		BYTE	01100011B
		BYTE	00111110B

		BYTE	00000000B
		BYTE	11111000B
		BYTE	11001110B
		BYTE	10000011B
		BYTE	10000001B
		BYTE	10000011B
		BYTE	10001110B
		BYTE	11111000B
		BYTE	10000000B
		BYTE	11000000B
		BYTE	01000000B
		BYTE	01000000B

		BYTE	00000000B
		BYTE	00111100B
		BYTE	01100110B
		BYTE	11000010B
		BYTE	10000011B
		BYTE	10000001B
		BYTE	10000001B
		BYTE	10110001B
		BYTE	10011011B
		BYTE	11001110B
		BYTE	01111110B
		BYTE	00000011B

		BYTE	00000000B
		BYTE	11111100B
		BYTE	11000110B
		BYTE	10000011B
		BYTE	10000001B
		BYTE	10000011B
		BYTE	11111110B
		BYTE	10110000B
		BYTE	10011000B
		BYTE	10001100B
		BYTE	10000110B
		BYTE	00000011B

		BYTE	00000000B
		BYTE	00111100B
		BYTE	01100110B
		BYTE	01000000B
		BYTE	01100000B
		BYTE	00110000B
		BYTE	00011100B
		BYTE	00000110B
		BYTE	11000011B
		BYTE	10000001B
		BYTE	11000011B
		BYTE	01111110B

		BYTE	00000000B
		BYTE	11111111B
		BYTE	10001000B
		BYTE	00001000B
		BYTE	00011000B
		BYTE	00010000B
		BYTE	00010000B
		BYTE	00010000B
		BYTE	00010000B
		BYTE	00010000B
		BYTE	00011000B
		BYTE	00001000B

		BYTE	00000000B
		BYTE	01000000B
		BYTE	01000010B
		BYTE	11000010B
		BYTE	10000011B
		BYTE	10000001B
		BYTE	10000001B
		BYTE	10000001B
		BYTE	11000001B
		BYTE	01000011B
		BYTE	01100110B
		BYTE	00111100B

		BYTE	00000000B
		BYTE	10000000B
		BYTE	10000001B
		BYTE	11000001B
		BYTE	01000011B
		BYTE	01000010B
		BYTE	01000010B
		BYTE	01100110B
		BYTE	00100100B
		BYTE	00100100B
		BYTE	00111100B
		BYTE	00011000B

		BYTE	00000000B
		BYTE	00000010B
		BYTE	10000011B
		BYTE	10000001B
		BYTE	10000001B
		BYTE	10000001B
		BYTE	10000001B
		BYTE	10010001B
		BYTE	10111001B
		BYTE	11101101B
		BYTE	11000111B
		BYTE	10000011B

		BYTE	00000000B
		BYTE	00000010B
		BYTE	11000110B
		BYTE	01100100B
		BYTE	00111100B
		BYTE	00011000B
		BYTE	00011100B
		BYTE	00110110B
		BYTE	00100011B
		BYTE	01100001B
		BYTE	01000000B
		BYTE	11000000B

		BYTE	00000000B
		BYTE	10000001B
		BYTE	10000011B
		BYTE	10000010B
		BYTE	01000110B
		BYTE	01101100B
		BYTE	00111000B
		BYTE	00110000B
		BYTE	00100000B
		BYTE	00100000B
		BYTE	00100000B
		BYTE	00100000B

		BYTE	00000000B
		BYTE	11111100B
		BYTE	00001100B
		BYTE	00001000B
		BYTE	00011000B
		BYTE	00010000B
		BYTE	00110000B
		BYTE	00100000B
		BYTE	01100000B
		BYTE	01000000B
		BYTE	11000000B
		BYTE	11111110B

		BYTE	01111110B
		BYTE	10000010B
		BYTE	10111110B
		BYTE	10100000B
		BYTE	10100000B
		BYTE	10100000B
		BYTE	11100000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000111B
		BYTE	00000101B
		BYTE	00000101B
		BYTE	00000101B
		BYTE	01111101B
		BYTE	01000001B
		BYTE	01111110B

		BYTE	01111110B
		BYTE	11000011B
		BYTE	10000001B
		BYTE	11000011B
		BYTE	00000110B
		BYTE	00001100B
		BYTE	00011000B
		BYTE	00010000B
		BYTE	00000000B
		BYTE	00010000B
		BYTE	00111000B
		BYTE	00110000B

		BYTE	00001100B
		BYTE	00001000B
		BYTE	00001000B
		BYTE	00011000B
		BYTE	00010000B
		BYTE	00010000B
		BYTE	00010000B
		BYTE	00010000B
		BYTE	00000000B
		BYTE	00010000B
		BYTE	00111000B
		BYTE	00110000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	10000000B
		BYTE	11000000B
		BYTE	01100000B
		BYTE	00100000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	11111111B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00000111B
		BYTE	00000100B
		BYTE	00000100B
		BYTE	00111100B
		BYTE	00100001B
		BYTE	00100010B
		BYTE	00100001B
		BYTE	00111100B
		BYTE	00000100B
		BYTE	00000100B
		BYTE	00000111B

		BYTE	00000000B
		BYTE	11000000B
		BYTE	01000000B
		BYTE	01000000B
		BYTE	01111000B
		BYTE	00001000B
		BYTE	10001000B
		BYTE	00001000B
		BYTE	01111000B
		BYTE	01000000B
		BYTE	01000000B
		BYTE	11000000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	11011011B
		BYTE	11011011B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	01100000B
		BYTE	10010000B
		BYTE	10010000B
		BYTE	01100000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	01110001B
		BYTE	11011011B
		BYTE	00001110B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00110000B
		BYTE	00010000B
		BYTE	00110000B
		BYTE	01100000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00100100B
		BYTE	00110110B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00010010B
		BYTE	00110110B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00011000B
		BYTE	00111100B
		BYTE	00111100B
		BYTE	00011000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	11100000B
		BYTE	11110000B
		BYTE	11111000B
		BYTE	11111100B
		BYTE	11111110B
		BYTE	11111111B
		BYTE	11111111B
		BYTE	11111110B
		BYTE	11111100B
		BYTE	11111000B
		BYTE	11110000B
		BYTE	11100000B

		BYTE	00000001B
		BYTE	00111010B
		BYTE	01000111B
		BYTE	01000001B
		BYTE	01000000B
		BYTE	00100001B
		BYTE	00011110B
		BYTE	00000010B
		BYTE	00000010B
		BYTE	00000001B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	10000000B
		BYTE	01000000B
		BYTE	01100000B
		BYTE	00010000B
		BYTE	00010000B
		BYTE	00100000B
		BYTE	00111110B
		BYTE	00011010B
		BYTE	00000010B
		BYTE	00000100B
		BYTE	10111000B
		BYTE	11111000B

		BYTE	00000000B
		BYTE	00000010B
		BYTE	01000110B
		BYTE	01101100B
		BYTE	00111000B
		BYTE	00011000B
		BYTE	00111100B
		BYTE	01100110B
		BYTE	01000010B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00011100B
		BYTE	00000110B
		BYTE	00111010B
		BYTE	01001110B
		BYTE	10000100B
		BYTE	10000100B
		BYTE	11001010B
		BYTE	01110001B

		BYTE	00000000B
		BYTE	01000000B
		BYTE	00100000B
		BYTE	00100000B
		BYTE	00100000B
		BYTE	00100000B
		BYTE	01111000B
		BYTE	01001100B
		BYTE	01000110B
		BYTE	10000110B
		BYTE	10001100B
		BYTE	11111000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00111100B
		BYTE	01100110B
		BYTE	11000000B
		BYTE	10000000B
		BYTE	10000000B
		BYTE	11001100B
		BYTE	01111000B

		BYTE	00000000B
		BYTE	00000010B
		BYTE	00000001B
		BYTE	00000001B
		BYTE	00000011B
		BYTE	00000010B
		BYTE	00111110B
		BYTE	01100010B
		BYTE	11000010B
		BYTE	11000010B
		BYTE	01100110B
		BYTE	00111011B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00111100B
		BYTE	01100010B
		BYTE	11000010B
		BYTE	11111110B
		BYTE	10000000B
		BYTE	10000100B
		BYTE	01111000B

		BYTE	00000000B
		BYTE	00000011B
		BYTE	00001100B
		BYTE	00001000B
		BYTE	00010000B
		BYTE	00010000B
		BYTE	11111110B
		BYTE	00100000B
		BYTE	00100000B
		BYTE	01000000B
		BYTE	01000000B
		BYTE	01000000B

		BYTE	00000100B
		BYTE	00011100B
		BYTE	00100010B
		BYTE	00100010B
		BYTE	00011100B
		BYTE	00001000B
		BYTE	00111100B
		BYTE	01000110B
		BYTE	10000010B
		BYTE	10000110B
		BYTE	11001100B
		BYTE	01111000B

		BYTE	00000000B
		BYTE	01000000B
		BYTE	00100000B
		BYTE	00100000B
		BYTE	00100000B
		BYTE	01000000B
		BYTE	01111100B
		BYTE	01000110B
		BYTE	01000010B
		BYTE	10000010B
		BYTE	10000100B
		BYTE	10000110B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00001000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00011000B
		BYTE	00001000B
		BYTE	00001000B
		BYTE	00010000B
		BYTE	00010000B
		BYTE	00010000B
		BYTE	00010000B

		BYTE	00000001B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000110B
		BYTE	00000010B
		BYTE	00000010B
		BYTE	00000010B
		BYTE	00000010B
		BYTE	10000100B
		BYTE	10000100B
		BYTE	10001000B
		BYTE	01110000B

		BYTE	00000000B
		BYTE	00110000B
		BYTE	00010000B
		BYTE	00010000B
		BYTE	00010000B
		BYTE	00100010B
		BYTE	00100010B
		BYTE	00100100B
		BYTE	01111000B
		BYTE	01010000B
		BYTE	01001000B
		BYTE	10000110B

		BYTE	00000000B
		BYTE	00010000B
		BYTE	00001000B
		BYTE	00001000B
		BYTE	00001000B
		BYTE	00010000B
		BYTE	00010000B
		BYTE	00010000B
		BYTE	00010000B
		BYTE	00100000B
		BYTE	00100000B
		BYTE	00100000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	01000000B
		BYTE	01110110B
		BYTE	01011101B
		BYTE	01001001B
		BYTE	11001001B
		BYTE	10011010B
		BYTE	10010010B
		BYTE	10010001B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	01011100B
		BYTE	01100110B
		BYTE	01000010B
		BYTE	10000010B
		BYTE	10000100B
		BYTE	10000100B
		BYTE	10000010B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00111100B
		BYTE	01000110B
		BYTE	10000010B
		BYTE	10000010B
		BYTE	10000010B
		BYTE	11000100B
		BYTE	01111000B

		BYTE	10000000B
		BYTE	01011100B
		BYTE	01100110B
		BYTE	01000010B
		BYTE	01000010B
		BYTE	01000110B
		BYTE	01001100B
		BYTE	01111000B
		BYTE	01000000B
		BYTE	01000000B
		BYTE	10000000B
		BYTE	10000000B

		BYTE	00000000B
		BYTE	00111001B
		BYTE	01101111B
		BYTE	11000110B
		BYTE	10000110B
		BYTE	10000100B
		BYTE	11001100B
		BYTE	01111100B
		BYTE	00001000B
		BYTE	00010001B
		BYTE	00011011B
		BYTE	00001110B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	01000000B
		BYTE	00101100B
		BYTE	00110010B
		BYTE	00100000B
		BYTE	01100000B
		BYTE	01000000B
		BYTE	01000000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00111100B
		BYTE	01000010B
		BYTE	01000000B
		BYTE	00111100B
		BYTE	00000010B
		BYTE	10000010B
		BYTE	01111100B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00010000B
		BYTE	00110000B
		BYTE	00100000B
		BYTE	11111100B
		BYTE	01000000B
		BYTE	01000000B
		BYTE	01000000B
		BYTE	01000100B
		BYTE	01101100B
		BYTE	00111000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	01000000B
		BYTE	01000010B
		BYTE	10000010B
		BYTE	10000010B
		BYTE	10000100B
		BYTE	11001100B
		BYTE	01111000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000001B
		BYTE	10000011B
		BYTE	11000010B
		BYTE	01000010B
		BYTE	01000110B
		BYTE	01100100B
		BYTE	00101100B
		BYTE	00111000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000010B
		BYTE	01000001B
		BYTE	11000001B
		BYTE	10010001B
		BYTE	10010001B
		BYTE	10111010B
		BYTE	01101100B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	11100010B
		BYTE	00110110B
		BYTE	00011100B
		BYTE	00011000B
		BYTE	00111000B
		BYTE	01101000B
		BYTE	11001100B
		BYTE	10000110B

		BYTE	00000000B
		BYTE	01000001B
		BYTE	01100001B
		BYTE	00100011B
		BYTE	00110011B
		BYTE	00011010B
		BYTE	00000110B
		BYTE	00000100B
		BYTE	00001100B
		BYTE	00011000B
		BYTE	01110000B
		BYTE	11000000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	01111000B
		BYTE	00001110B
		BYTE	00000011B
		BYTE	00000110B
		BYTE	00011100B
		BYTE	01110000B
		BYTE	11111000B
		BYTE	00001110B

		BYTE	00000111B
		BYTE	00001111B
		BYTE	00011111B
		BYTE	00111111B
		BYTE	01111111B
		BYTE	11111111B
		BYTE	11111111B
		BYTE	01111111B
		BYTE	00111111B
		BYTE	00011111B
		BYTE	00001111B
		BYTE	00000111B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	01100000B
		BYTE	01100000B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00011101B
		BYTE	00110010B
		BYTE	01100000B
		BYTE	01000111B
		BYTE	11001100B
		BYTE	10001100B
		BYTE	10000001B
		BYTE	11000011B
		BYTE	01100000B
		BYTE	00100011B
		BYTE	00111000B
		BYTE	00001111B

		BYTE	11000000B
		BYTE	00100000B
		BYTE	00011000B
		BYTE	11000100B
		BYTE	01100010B
		BYTE	01100010B
		BYTE	11000010B
		BYTE	10000110B
		BYTE	00011100B
		BYTE	10001000B
		BYTE	00011000B
		BYTE	11100000B

		BYTE	00000001B
		BYTE	00000010B
		BYTE	00000010B
		BYTE	01111100B
		BYTE	00100010B
		BYTE	00010010B
		BYTE	00001000B
		BYTE	00011000B
		BYTE	01110001B
		BYTE	01001010B
		BYTE	00100100B
		BYTE	00011100B

		BYTE	00000000B
		BYTE	10000000B
		BYTE	10000000B
		BYTE	01111100B
		BYTE	10001000B
		BYTE	10010000B
		BYTE	00100000B
		BYTE	00110000B
		BYTE	00011100B
		BYTE	10100100B
		BYTE	01001000B
		BYTE	01110000B

		BYTE	00000011B
		BYTE	00001100B
		BYTE	00010001B
		BYTE	00100001B
		BYTE	00100001B
		BYTE	01000000B
		BYTE	01000001B
		BYTE	01000000B
		BYTE	01111111B
		BYTE	01000000B
		BYTE	01000000B
		BYTE	01111111B

		BYTE	11000000B
		BYTE	00110000B
		BYTE	10001000B
		BYTE	10000100B
		BYTE	10000100B
		BYTE	00000010B
		BYTE	10000010B
		BYTE	00000010B
		BYTE	11111110B
		BYTE	00000010B
		BYTE	00000010B
		BYTE	11111110B

		BYTE	00111100B
		BYTE	00100100B
		BYTE	00100100B
		BYTE	00100100B
		BYTE	00100100B
		BYTE	00100100B
		BYTE	00100100B
		BYTE	11100111B
		BYTE	10000001B
		BYTE	01000010B
		BYTE	00100100B
		BYTE	00011000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B

		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
		BYTE	00000000B
;
;
;
;
MSG_PICT
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,063,252,000,000,000,000,000
	BYTE 000,000,003,248,000,000,000,000,001,224,007,000,000,000,000,000
	BYTE 000,003,012,014,000,000,000,000,006,028,000,128,000,000,000,000
	BYTE 000,003,152,003,000,000,000,000,008,054,000,064,000,000,000,000
	BYTE 000,027,176,001,128,000,000,000,017,162,000,064,004,008,000,000
	BYTE 000,025,192,000,192,000,000,000,033,162,000,032,004,016,000,000
	BYTE 000,028,192,000,064,000,000,000,033,182,192,032,002,016,000,000
	BYTE 000,015,000,000,096,000,000,000,079,252,224,032,003,032,000,000
	BYTE 000,031,248,000,032,000,000,000,079,248,102,032,001,192,000,000
	BYTE 000,048,012,000,032,031,240,000,065,128,006,032,000,128,000,000
	BYTE 000,096,002,000,032,031,240,000,089,176,006,032,002,048,000,000
	BYTE 000,064,001,000,032,031,176,000,089,176,012,064,003,048,000,000
	BYTE 000,192,000,128,032,031,160,000,089,152,124,064,003,051,255,000
	BYTE 003,128,000,192,032,015,160,096,033,152,120,129,195,190,001,192
	BYTE 004,128,000,064,032,015,227,224,032,000,003,003,111,056,000,096
	BYTE 004,128,000,064,032,015,255,224,016,000,028,002,051,048,004,048
	BYTE 004,128,000,064,103,255,255,160,014,001,224,002,048,000,072,016
	BYTE 003,192,000,000,071,252,127,224,001,251,000,002,100,012,144,008
	BYTE 001,064,000,000,199,248,063,160,000,010,002,002,068,025,033,008
	BYTE 002,064,000,000,135,248,063,160,000,010,003,003,078,050,098,008
	BYTE 002,096,000,003,007,248,060,032,124,014,005,006,074,038,194,008
	BYTE 002,032,000,028,007,060,127,225,199,006,012,204,074,004,000,008
	BYTE 001,240,000,004,004,255,192,003,193,134,008,120,068,000,000,008
	BYTE 000,056,000,004,007,143,224,003,194,132,008,076,064,000,000,008
	BYTE 000,054,004,012,000,015,224,007,193,128,016,071,160,000,000,008
	BYTE 000,030,007,240,000,031,240,015,135,064,016,064,176,000,000,016
	BYTE 000,006,006,000,000,031,240,015,143,192,016,103,248,000,000,048
	BYTE 000,124,131,192,000,031,208,030,015,192,016,060,184,000,000,096
	BYTE 015,217,131,096,000,031,016,016,015,192,016,096,000,000,000,128
	BYTE 008,017,001,048,000,031,240,016,015,192,016,064,192,016,003,128
	BYTE 008,035,001,016,000,000,000,016,007,064,016,192,129,008,006,000
	BYTE 008,097,129,048,000,000,000,016,002,192,024,129,003,007,248,000
	BYTE 004,096,067,224,000,000,000,027,137,192,040,129,002,001,128,000
	BYTE 004,032,066,192,000,063,240,015,229,128,068,130,006,000,000,000
	BYTE 002,048,196,000,000,031,224,015,243,128,146,102,024,000,000,000
	BYTE 001,025,136,000,000,031,192,007,247,000,161,156,112,000,000,000
	BYTE 000,206,016,000,000,015,128,003,254,097,032,224,248,000,000,000
	BYTE 000,048,096,000,000,007,000,000,248,017,065,255,191,000,000,000
	BYTE 000,255,188,000,000,007,000,000,001,138,071,192,192,224,000,000
	BYTE 003,028,003,128,000,002,000,000,000,100,140,049,128,016,000,000
	BYTE 004,002,000,192,000,000,000,000,000,016,152,013,128,016,000,000
	BYTE 008,001,000,064,000,000,000,000,000,009,016,004,224,112,000,000
	BYTE 012,001,255,192,000,000,000,000,000,000,019,254,031,192,000,000
	BYTE 007,254,000,000,000,000,000,000,000,000,028,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,002,000,000,000,000
	BYTE 000,000,000,024,000,000,000,000,000,000,000,002,000,000,000,000
	BYTE 000,000,001,155,224,000,000,000,000,000,033,002,000,000,000,000
	BYTE 000,000,001,159,248,000,000,000,000,000,032,129,000,000,000,000
	BYTE 000,000,001,206,012,000,000,000,000,000,032,129,000,000,000,000
	BYTE 000,000,000,216,006,000,000,000,000,000,016,129,000,000,000,000
	BYTE 000,000,048,208,002,000,000,000,000,000,008,128,128,000,000,000
	BYTE 000,000,076,016,003,000,000,000,000,000,008,064,128,000,000,000
	BYTE 000,000,195,000,003,000,000,000,000,000,008,064,128,000,000,000
	BYTE 000,000,140,128,003,000,000,000,000,000,008,064,000,000,000,000
	BYTE 000,000,116,000,003,000,000,000,000,000,008,064,064,000,000,000
	BYTE 000,000,056,000,003,000,000,000,000,000,001,224,230,000,000,000
	BYTE 000,000,040,000,002,000,000,000,000,000,003,048,238,000,000,000
	BYTE 000,000,104,064,002,000,000,000,000,000,002,017,206,000,000,000
	BYTE 000,000,120,032,012,000,000,000,000,000,002,025,156,000,000,000
	BYTE 000,000,060,048,008,000,000,000,000,000,003,224,063,192,000,000
	BYTE 000,000,060,028,048,000,000,000,000,000,004,192,000,048,000,000
	BYTE 000,000,015,007,224,000,000,000,000,000,009,128,000,024,000,000
	BYTE 000,000,003,242,000,000,000,000,000,000,009,000,000,008,000,000
	BYTE 000,000,000,099,000,000,001,000,000,000,007,012,000,012,000,000
	BYTE 000,000,000,065,000,000,003,000,000,000,007,024,000,004,000,000
	BYTE 000,000,000,129,000,003,003,000,000,000,053,136,000,004,000,000
	BYTE 000,000,003,193,000,003,195,128,000,000,251,200,000,004,000,000
	BYTE 000,000,007,064,128,003,247,128,000,001,009,248,000,004,000,000
	BYTE 000,000,057,064,128,003,255,192,000,001,015,068,000,008,000,000
	BYTE 000,003,194,113,128,007,255,192,000,001,001,198,000,024,000,000
	BYTE 000,003,006,017,000,007,255,224,000,001,128,067,000,048,000,000
	BYTE 000,001,006,049,000,015,255,240,000,000,254,065,128,064,000,000
	BYTE 000,000,195,227,000,015,255,248,000,064,114,192,227,128,000,000
	BYTE 000,000,224,006,000,007,255,252,000,096,003,128,220,000,000,000
	BYTE 000,000,048,024,000,001,255,248,000,120,007,000,096,004,000,000
	BYTE 000,000,015,240,000,000,031,224,000,032,028,008,032,132,000,000
	BYTE 000,000,000,000,000,000,031,128,000,032,120,060,033,195,000,000
	BYTE 000,000,014,112,000,000,030,000,000,032,032,060,035,192,224,000
	BYTE 000,000,030,080,000,000,062,000,000,064,032,124,103,193,128,000
	BYTE 000,002,050,144,000,000,056,000,000,128,048,248,079,194,000,000
	BYTE 000,004,038,144,000,000,048,000,007,192,025,248,079,132,000,000
	BYTE 000,004,036,144,000,000,000,000,000,096,015,224,158,012,000,000
	BYTE 000,008,040,224,000,000,000,000,000,016,007,227,028,008,000,000
	BYTE 000,024,176,096,000,000,000,000,000,016,003,198,024,056,000,000
	BYTE 000,017,000,000,000,000,000,000,000,062,003,248,001,204,000,000
	BYTE 000,017,000,000,000,000,000,000,000,098,224,000,001,002,000,000
	BYTE 000,017,008,000,000,000,000,000,000,195,176,000,122,000,000,000
	BYTE 000,002,016,000,000,000,000,000,000,003,023,207,070,000,000,000
	BYTE 000,002,016,000,000,000,000,000,000,004,024,105,195,000,000,000
	BYTE 000,002,032,000,000,000,000,000,000,000,008,024,065,000,000,000
	BYTE 000,002,032,000,000,000,000,000,000,000,000,024,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,024,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 002,000,064,028,007,192,000,000,000,000,000,000,000,000,000,000
	BYTE 002,000,033,156,024,056,000,000,000,000,000,000,000,000,000,000
	BYTE 011,000,033,142,096,004,000,000,000,000,001,248,000,000,000,000
	BYTE 008,000,033,206,192,002,000,000,000,000,001,004,000,007,000,000
	BYTE 006,014,032,198,128,003,000,000,000,000,003,004,000,024,192,000
	BYTE 002,000,032,225,000,001,000,000,112,000,003,004,000,056,032,000
	BYTE 000,000,032,097,000,000,128,000,144,000,001,011,128,124,016,000
	BYTE 003,000,032,002,000,000,128,001,142,000,001,000,195,252,008,000
	BYTE 003,000,064,114,000,000,128,003,131,000,003,064,124,124,232,000
	BYTE 005,000,006,130,000,000,128,002,003,128,002,048,224,249,244,000
	BYTE 009,000,015,000,000,000,128,006,032,128,007,224,096,217,244,000
	BYTE 016,128,010,000,000,000,128,006,032,128,124,032,192,225,244,000
	BYTE 016,128,010,000,000,000,128,003,056,207,132,016,193,192,226,000
	BYTE 032,128,010,000,000,001,128,001,012,240,006,024,062,184,002,000
	BYTE 000,128,014,000,000,003,000,003,124,192,001,024,032,252,002,000
	BYTE 000,128,010,000,000,002,000,015,132,192,003,240,048,254,014,000
	BYTE 000,128,011,007,000,012,000,241,012,096,062,016,016,254,030,000
	BYTE 000,000,009,001,192,120,000,003,024,039,194,016,031,252,060,000
	BYTE 000,000,015,192,127,224,000,002,024,056,002,024,048,120,060,000
	BYTE 000,000,000,121,144,208,000,003,188,016,001,252,096,032,056,000
	BYTE 000,000,000,047,012,159,000,007,204,048,127,224,032,024,048,000
	BYTE 000,000,000,121,135,153,128,248,200,127,128,040,032,007,192,000
	BYTE 000,000,000,071,252,000,128,000,248,096,000,040,032,000,000,000
	BYTE 000,007,097,161,236,000,128,003,224,096,000,028,032,000,000,000
	BYTE 000,028,129,001,148,000,156,000,022,064,000,003,192,000,000,000
	BYTE 000,049,001,007,026,001,228,000,030,096,000,000,000,000,000,000
	BYTE 000,198,003,143,011,255,132,000,007,192,000,000,000,000,000,000
	BYTE 003,136,014,251,010,097,004,000,000,000,000,000,000,000,000,000
	BYTE 006,048,048,002,010,034,008,000,000,000,000,000,000,000,000,000
	BYTE 008,064,192,226,010,034,024,000,000,000,000,000,000,000,000,000
	BYTE 016,071,003,034,020,036,048,000,000,000,000,000,000,000,000,000
	BYTE 032,120,013,023,052,104,096,000,000,000,000,000,000,000,000,000
	BYTE 064,000,113,015,232,105,192,000,000,000,000,000,000,000,000,000
	BYTE 064,003,129,007,240,075,000,000,000,000,000,000,000,000,000,000
	BYTE 096,062,001,130,000,204,000,000,000,000,000,000,000,000,000,000
	BYTE 063,240,000,129,001,192,000,000,000,000,000,000,000,000,000,000
	BYTE 007,128,000,193,195,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,048,252,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,015,128,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,001,128,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,102,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,102,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,102,031,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,102,113,128,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,103,128,096,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,006,000,032,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,008,000,016,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,240,000,016,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,243,000,000,008,000,000,000,000,000,000,000,000,000
	BYTE 000,000,001,156,000,000,008,000,000,000,000,000,048,000,000,000
	BYTE 000,000,002,008,000,000,008,000,000,000,000,000,080,000,000,000
	BYTE 000,000,002,016,000,000,008,000,000,000,000,000,151,252,000,000
	BYTE 000,000,002,016,000,000,008,000,000,000,000,000,159,007,000,000
	BYTE 000,000,001,240,000,000,016,000,000,000,000,000,123,225,128,000
	BYTE 000,000,000,240,000,000,016,000,000,000,000,000,060,248,064,000
	BYTE 000,000,000,144,003,224,032,000,000,000,000,000,119,030,096,000
	BYTE 000,000,000,152,012,028,096,000,000,000,000,000,083,135,048,000
	BYTE 000,003,000,200,016,007,128,000,000,000,001,252,209,195,176,000
	BYTE 000,003,195,252,048,000,000,000,000,000,006,006,144,225,144,000
	BYTE 000,002,108,102,032,000,000,000,000,000,004,003,152,240,208,000
	BYTE 000,002,056,035,063,255,255,255,255,255,248,001,152,120,208,000
	BYTE 000,002,111,255,032,000,000,000,000,000,000,001,152,060,208,000
	BYTE 000,002,152,125,032,000,000,000,000,000,000,001,156,028,080,000
	BYTE 000,001,129,129,191,255,255,255,255,255,252,003,204,014,112,000
	BYTE 000,001,134,002,160,000,000,000,000,000,003,142,079,006,032,000
	BYTE 000,001,132,006,160,000,000,000,000,000,000,120,071,131,096,000
	BYTE 000,000,204,004,184,000,000,000,000,000,000,000,035,225,192,000
	BYTE 000,000,248,024,134,000,000,000,000,000,000,000,024,125,128,000
	BYTE 000,000,096,236,066,000,000,000,000,000,000,000,006,007,000,000
	BYTE 000,003,255,251,102,000,000,000,000,000,000,000,001,254,000,000
	BYTE 000,004,003,224,188,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,007,252,063,128,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255
	BYTE 189,189,189,189,189,189,189,189,189,189,189,189,189,189,189,189
	BYTE 219,219,219,219,219,219,219,219,219,219,219,219,219,219,219,219
	BYTE 231,231,231,231,231,231,231,231,231,231,231,231,231,231,231,231
	BYTE 231,231,231,231,231,231,231,231,231,231,231,231,231,231,231,231
	BYTE 219,219,219,219,219,219,219,219,219,219,219,219,219,219,219,219
	BYTE 189,189,189,189,189,189,189,189,189,189,189,189,189,189,189,189
	BYTE 255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255
	BYTE 255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255
	BYTE 189,189,189,189,189,189,189,189,189,189,189,189,189,189,189,189
	BYTE 219,219,219,219,219,219,219,219,219,219,219,219,219,219,219,219
	BYTE 231,231,231,231,231,231,231,231,231,231,231,231,231,231,231,231
	BYTE 231,231,231,231,231,231,231,231,231,231,231,231,231,231,231,231
	BYTE 219,219,219,219,219,219,219,219,219,219,219,219,219,219,219,219
	BYTE 189,189,189,189,189,189,189,189,189,189,189,189,189,189,189,189
	BYTE 255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255
	BYTE 255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255
	BYTE 189,189,189,189,189,189,189,189,189,189,189,189,189,189,189,189
	BYTE 219,219,219,219,219,219,219,219,219,219,219,219,219,219,219,219
	BYTE 231,231,231,231,231,231,231,231,231,231,231,231,231,231,231,231
	BYTE 231,231,231,231,231,231,231,231,231,231,231,231,231,231,231,231
	BYTE 219,219,219,219,219,219,219,219,219,219,219,219,219,219,219,219
	BYTE 189,189,189,189,189,189,189,189,189,189,189,189,189,189,189,189
	BYTE 255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255
	BYTE 000,000,000,255,255,255,255,255,255,255,255,255,255,255,255,255
	BYTE 000,000,000,189,189,189,189,189,189,189,189,189,189,189,189,189
	BYTE 000,000,000,219,219,219,219,219,219,219,219,219,219,219,219,219
	BYTE 048,000,000,231,231,231,231,231,231,231,231,231,231,231,231,231
	BYTE 080,000,000,231,231,231,231,231,231,231,231,231,231,231,231,231
	BYTE 144,000,000,219,219,219,219,219,219,219,219,219,219,219,219,219
	BYTE 159,000,000,189,189,189,189,189,189,189,189,189,189,189,189,189
	BYTE 125,128,000,255,255,255,255,255,255,255,255,255,255,255,255,255
	BYTE 108,255,000,255,255,255,255,255,255,255,255,255,255,255,255,255
	BYTE 072,032,192,189,189,189,189,189,189,189,189,189,189,189,189,189
	BYTE 072,096,096,219,219,219,219,219,219,219,219,219,219,219,219,219
	BYTE 204,192,048,231,231,231,231,231,231,231,231,231,231,231,231,231
	BYTE 135,129,016,231,231,231,231,231,231,231,231,231,231,231,231,231
	BYTE 128,003,208,219,219,219,219,219,219,219,219,219,219,219,219,219
	BYTE 128,004,112,189,189,189,189,189,189,189,189,189,189,189,189,189
	BYTE 134,008,016,255,255,255,255,255,255,255,255,255,255,255,255,255
	BYTE 153,136,016,255,255,255,255,255,255,255,255,255,255,255,255,255
	BYTE 224,136,016,189,189,189,189,189,189,189,189,189,189,189,189,189
	BYTE 096,200,032,219,219,219,219,219,219,219,219,219,219,219,219,219
	BYTE 096,076,096,231,231,231,231,231,231,231,231,231,231,231,231,231
	BYTE 096,067,192,231,231,231,231,231,231,231,231,231,231,231,231,231
	BYTE 048,128,128,219,219,219,219,219,219,219,219,219,219,219,219,219
	BYTE 031,131,000,189,189,189,189,189,189,189,189,189,189,189,189,189
	BYTE 007,254,000,255,255,255,255,255,255,255,255,255,255,255,255,255
	BYTE 255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255
	BYTE 189,189,189,189,189,189,189,189,189,189,189,189,189,189,189,189
	BYTE 219,219,219,219,219,219,219,219,219,219,219,219,219,219,219,219
	BYTE 231,231,231,231,231,231,231,231,231,231,231,231,231,231,231,231
	BYTE 231,231,231,231,231,231,231,231,231,231,231,231,231,231,231,231
	BYTE 219,219,219,219,219,219,219,219,219,219,219,219,219,219,219,219
	BYTE 189,189,189,189,189,189,189,189,189,189,189,189,189,189,189,189
	BYTE 255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255
	BYTE 255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255
	BYTE 189,189,189,189,189,189,189,189,189,189,189,189,189,189,189,189
	BYTE 219,219,219,219,219,219,219,219,219,219,219,219,219,219,219,219
	BYTE 231,231,231,231,231,231,231,231,231,231,231,231,231,231,231,231
	BYTE 231,231,231,231,231,231,231,231,231,231,231,231,231,231,231,231
	BYTE 219,219,219,219,219,219,219,219,219,219,219,219,219,219,219,219
	BYTE 189,189,189,189,189,189,189,189,189,189,189,189,189,189,189,189
	BYTE 255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,007,224,000,000,005,005,000,000,005,000,012,012,000,000,000
	BYTE 000,004,032,016,000,005,053,000,064,005,004,008,008,000,000,000
	BYTE 000,004,032,016,000,000,024,000,064,128,068,008,008,000,000,000
	BYTE 000,060,060,255,000,254,008,000,097,132,068,024,024,000,000,000
	BYTE 000,033,132,016,000,012,008,000,039,191,255,016,016,000,000,000
	BYTE 000,034,068,016,000,024,024,000,060,130,068,016,016,000,000,000
	BYTE 000,034,068,016,000,048,082,124,048,130,068,016,016,000,000,000
	BYTE 000,033,132,255,255,096,219,198,096,158,068,016,016,000,000,000
	BYTE 000,060,060,008,000,064,137,002,192,179,064,000,000,000,000,000
	BYTE 000,004,032,008,000,064,137,006,129,162,064,016,016,000,000,000
	BYTE 000,004,032,012,000,099,024,012,195,182,099,056,056,000,000,000
	BYTE 000,007,224,004,000,062,048,024,126,028,062,048,048,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,002,000,000,000,000
	BYTE 000,000,000,024,000,000,000,000,000,000,000,002,000,000,000,000
	BYTE 000,000,001,155,224,000,000,000,000,000,033,002,000,000,000,000
	BYTE 000,000,001,159,248,000,000,000,000,000,032,129,000,000,000,000
	BYTE 000,000,001,206,012,000,000,000,000,000,032,129,000,000,000,000
	BYTE 000,000,001,216,006,000,000,000,000,000,016,129,000,000,000,000
	BYTE 000,000,048,016,002,000,000,000,000,000,008,128,128,000,000,000
	BYTE 000,000,076,016,003,000,000,000,000,000,008,064,128,000,000,000
	BYTE 000,000,195,000,003,000,000,000,000,000,008,064,128,000,000,000
	BYTE 000,000,140,128,003,000,000,000,000,000,008,064,000,000,000,000
	BYTE 000,000,116,000,003,000,000,000,000,000,008,064,000,000,000,000
	BYTE 000,000,056,000,003,000,000,000,000,000,001,224,012,000,000,000
	BYTE 000,000,040,000,002,000,000,000,000,000,003,049,140,000,000,000
	BYTE 000,000,104,064,002,000,000,000,000,000,002,017,152,000,000,000
	BYTE 000,000,120,032,012,000,000,000,000,000,002,031,184,000,000,000
	BYTE 000,000,060,048,008,000,000,000,000,000,003,227,191,192,000,000
	BYTE 000,000,060,028,048,000,000,000,000,000,004,199,016,048,000,000
	BYTE 000,000,015,007,224,000,000,000,000,000,009,134,032,024,000,000
	BYTE 000,000,003,242,000,000,000,000,000,000,009,002,000,008,000,000
	BYTE 000,000,000,099,000,000,001,000,000,000,007,012,000,012,000,000
	BYTE 000,000,000,065,000,000,003,000,000,000,007,024,000,004,000,000
	BYTE 000,000,000,129,000,003,003,000,000,000,053,136,000,004,000,000
	BYTE 000,000,003,193,000,003,195,128,000,000,251,200,000,004,000,000
	BYTE 000,000,007,064,128,003,247,128,000,001,009,248,000,004,000,000
	BYTE 000,000,057,064,128,003,255,192,000,001,015,068,000,008,000,000
	BYTE 000,003,194,113,128,007,255,192,000,001,001,198,000,024,000,000
	BYTE 000,003,006,017,000,007,255,224,000,001,128,067,000,048,000,000
	BYTE 000,001,006,049,000,015,255,240,000,000,254,065,128,064,000,000
	BYTE 000,000,195,227,000,015,255,248,000,064,114,192,227,128,000,000
	BYTE 000,000,224,006,000,007,255,252,000,096,003,128,220,000,000,000
	BYTE 000,000,048,024,000,001,255,248,000,120,007,000,096,004,000,000
	BYTE 000,000,015,240,000,000,031,224,000,032,028,008,032,132,000,000
	BYTE 000,000,000,000,000,000,031,128,000,032,120,060,033,195,000,000
	BYTE 000,000,014,112,000,000,030,000,000,032,032,060,035,192,224,000
	BYTE 000,000,030,080,000,000,062,000,000,064,032,124,103,193,128,000
	BYTE 000,002,050,144,000,000,056,000,000,128,048,248,079,194,000,000
	BYTE 000,004,038,144,000,000,048,000,007,192,025,248,079,132,000,000
	BYTE 000,004,036,144,000,000,000,000,000,096,015,224,158,012,000,000
	BYTE 000,008,040,224,000,000,000,000,000,016,007,227,028,008,000,000
	BYTE 000,024,176,096,000,000,000,000,000,016,003,198,024,056,000,000
	BYTE 000,017,000,000,000,000,000,000,000,062,003,248,001,204,000,000
	BYTE 000,017,000,000,000,000,000,000,000,098,224,000,001,002,000,000
	BYTE 000,017,008,000,000,000,000,000,000,195,176,000,122,000,000,000
	BYTE 000,002,016,000,000,000,000,000,000,003,023,207,070,000,000,000
	BYTE 000,002,016,000,000,000,000,000,000,004,024,105,195,000,000,000
	BYTE 000,002,032,000,000,000,000,000,000,000,008,024,065,000,000,000
	BYTE 000,002,032,000,000,000,000,000,000,000,000,024,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,005,000,000,005,000,005,000,000,000,005,012,012,000,000
	BYTE 000,131,021,016,000,005,032,005,048,032,252,005,008,008,000,000
	BYTE 000,198,016,062,192,000,038,128,028,032,012,248,008,008,000,000
	BYTE 000,108,255,099,120,254,243,132,006,172,024,024,024,024,000,000
	BYTE 000,056,016,193,001,012,065,159,032,190,048,048,016,016,000,000
	BYTE 000,016,016,145,001,024,196,130,096,178,062,096,016,016,000,000
	BYTE 000,016,082,027,003,048,132,130,062,162,003,255,016,016,000,000
	BYTE 000,048,210,014,006,096,060,130,003,166,121,024,016,016,000,000
	BYTE 000,032,147,006,012,064,102,130,001,228,205,048,000,000,000,000
	BYTE 000,032,145,012,024,064,071,198,003,230,135,032,016,016,000,000
	BYTE 000,032,024,024,048,099,109,012,198,035,198,051,056,056,000,000
	BYTE 000,032,008,048,096,062,056,008,124,032,124,030,048,048,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,007,128,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,128,064,024,120,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,134,064,032,015,000,000,000
	BYTE 000,000,000,000,000,000,000,001,193,026,192,000,001,128,000,000
	BYTE 000,000,000,000,000,000,000,001,035,008,128,000,000,192,000,000
	BYTE 000,000,000,000,000,000,000,017,037,000,000,031,128,096,000,000
	BYTE 000,000,000,000,000,000,000,019,201,128,000,096,096,032,000,000
	BYTE 000,000,000,000,000,000,000,012,000,128,000,064,056,000,000,000
	BYTE 000,000,000,000,000,000,000,024,000,128,204,000,012,015,192,000
	BYTE 000,000,013,143,128,000,000,041,000,000,204,000,006,024,224,000
	BYTE 000,000,013,152,192,000,000,069,192,000,204,001,224,060,112,000
	BYTE 000,000,015,224,096,000,000,018,064,051,236,000,024,124,056,000
	BYTE 000,000,029,128,032,000,000,018,000,126,205,248,012,124,028,000
	BYTE 000,000,045,128,016,000,000,024,000,136,006,012,004,248,252,000
	BYTE 000,000,224,000,024,000,000,000,000,144,008,002,000,193,236,000
	BYTE 000,001,064,000,024,000,000,000,000,176,016,003,000,129,236,000
	BYTE 000,001,064,128,024,000,000,000,001,224,000,001,000,129,236,000
	BYTE 000,015,193,128,024,002,000,000,003,032,000,001,001,185,204,000
	BYTE 000,059,067,000,024,003,000,000,002,032,000,001,001,252,012,000
	BYTE 000,033,230,000,048,003,128,000,002,032,016,001,001,222,028,000
	BYTE 000,113,226,000,048,003,128,048,003,032,112,003,000,254,024,000
	BYTE 000,121,211,000,096,035,128,120,192,241,192,002,000,252,112,000
	BYTE 000,249,233,129,192,127,192,073,192,024,192,006,000,123,224,000
	BYTE 000,248,252,226,096,063,224,077,255,156,039,132,000,031,192,000
	BYTE 000,176,046,060,144,063,240,069,127,240,060,140,000,000,000,000
	BYTE 000,128,036,033,048,063,248,069,032,080,120,248,000,000,000,000
	BYTE 000,128,064,153,048,063,252,067,049,160,000,112,000,000,000,000
	BYTE 000,240,129,014,048,063,252,067,062,096,000,024,000,000,000,000
	BYTE 000,124,130,006,112,035,240,099,048,065,000,008,000,000,000,000
	BYTE 000,124,204,002,096,003,192,039,031,129,192,008,000,000,000,000
	BYTE 000,060,124,002,096,003,128,037,128,003,254,024,000,000,000,000
	BYTE 000,031,196,001,096,003,128,044,128,003,003,112,000,000,000,000
	BYTE 000,000,004,000,192,003,000,048,192,007,000,192,000,000,000,000
	BYTE 000,000,006,000,064,002,000,000,096,006,000,000,000,000,000,000
	BYTE 000,000,002,000,128,000,000,000,124,012,000,000,000,000,000,000
	BYTE 000,000,001,007,000,000,000,000,031,120,000,000,000,000,000,000
	BYTE 000,000,007,252,000,000,000,000,003,192,000,000,000,000,000,000
	BYTE 000,000,028,032,000,000,000,000,006,062,000,000,000,000,000,000
	BYTE 000,000,032,016,000,000,000,000,012,001,000,000,000,000,000,000
	BYTE 000,000,063,240,000,000,000,000,015,255,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
	BYTE 000,000,000,000,000,000,000,000,000,000,000,000,000,000,000,000
;
 ENDIF	  ;**** { Ή [1995/6/30] ****************************
;
;
;****************************************************************
;*								*
;*	R[X 鎞 bZ[WZbg			*
;*				in				*
;*				R0  <- oN			*
;*				R10 <- bZ[WAhX	*
;*				R8  <- xW			*
;*				R9  <- wW			*
;*				R11 <- data read index		*
;*				R14 <- R[X io[		*
;*				out				*
;*				R8  <- ̂xW		*
;*				R9  <- ̂wW		*
;*				R11 <- next data read index	*
;****************************************************************
INCOSEMOJI	EQU	$
		ROMB
;
		FROM	R14
		ADD	R14		; R0 = R14 * 2
		TO	R14
		ADD	R10		; R14 = R0 + R10
		TO	R10
		GETB
		INC	R14
		WITH	R10
		GETBH			; R10 <- f[^AhX
;
		IBT	R0,#002H	; oknsJ[f[^ Zbg
		COLOR			;
;
		IWT	R13,#INCOSEMOJI_150	; AhX
;
		CACHE			; LbV X^[g !!
;
INCOSEMOJI_000
		IWT	R3,#000FFH
		FROM	R10
		TO	R14
		ADD	R11		;	R14 = R10 + R11
		GETB
;
		CMP	R3		; wWZbg ?
		BEQ	INCOSEMOJI_050	;	YES -> INCOSEMOJI_050
		DEC	R3
		CMP	R3		; wxWZbg ?
		BEQ	INCOSEMOJI_030	;	YES -> INCOSEMOJI_030
		DEC	R3
		CMP	R3		; f[^ Gh ?
		BNE	INCOSEMOJI_080	;	NO -> INCOSEMOJI_080
		NOP
 IF  JPN  ;**** { Ή [1995/6/30] ****************************
		IBT	R11,#020H
 ENDIF    ;**** { Ή [1995/6/30] ****************************
		IWT	R15,#INCOSEMOJI_990
		NOP
;
INCOSEMOJI_030				; xWZbg
		INC	R11		; data read index inc.
		INC	R14
		TO	R8
		GETB
;
INCOSEMOJI_050				; wWZbg
		INC	R11		; data read index inc.
		INC	R14
		TO	R9
		GETB
		INC	R11		; data read index inc.
		INC	R14
		GETB
;
INCOSEMOJI_080
;
 IF  NES | PAL ;**** NES or PAL Ή [1995/7/11] *****************
		SMS	R0,CWORK1F	; f[^ -> CWORK1F
 ENDIF	  ;**** NES or PAL Ή [1995/7/11] **********************
;
		INC	R11		; data read index inc.
		IBT	R6,#00CH	; ̃rbgf[^CfbNX
		LMULT			;	R4 = R0 * R6
		IBT	R0,#BANK MSG_FONT
		ROMB
		IWT	R0,#MSG_FONT
		TO	R14		; ̃rbgf[^AhX
		ADD	R4		;	R14 = R0 + R4
		IBT	R3,#00CH	; P[vJE^[
;
		MOVE	R2,R8		; xW Zbg
;
INCOSEMOJI_100
		IBT	R12,#008H	; [v
		MOVE	R1,R9
		IBT	R0,#000
		GETBL
		TO	R5
		SWAP			; (L),(H) ] -> R5
		BEQ	INCOSEMOJI_190
;
INCOSEMOJI_150
		WITH	R5
		ROL			; okns nj ?
		BCC	INCOSEMOJI_180	;	NO -> INCOSEMOJI_180
		NOP
		PLOT
		BRA	INCOSEMOJI_185
		NOP
;
INCOSEMOJI_180
		INC	R1
INCOSEMOJI_185
		LOOP
		NOP
;
INCOSEMOJI_190
		DEC	R3		; Pokns Gh ?
		BEQ	INCOSEMOJI_900	;	YES -> INCOSEMOJI_900
		INC	R2		; x inc.
		INC	R14		; rbgf[^AhX inc.
		BRA	INCOSEMOJI_100
		NOP
;
INCOSEMOJI_900
		RPIX
;
 IF  NES | PAL ;**** NES or PAL Ή [1995/7/11] *****************
		IBT	R0,#BANK MSG_FONT_X
		ROMB
		IWT	R14,#MSG_FONT_X
		LMS	R0,CWORK1F
		TO	R14
		ADD	R14
		GETB
		TO	R9
		ADD	R9
 ENDIF	  ;**** NES or PAL Ή [1995/7/11] **********************
;
;
 IF  JPN  ;**** { Ή [1995/6/30] ****************************
		WITH	R9
		ADD	#00AH		; ̂wW
 ENDIF	  ;**** { Ή [1995/6/30] ****************************
;
INCOSEMOJI_990
		STOP
		NOP
;
;
;****************************************************************
;*								*
;*	I[vjO f bZ[WLN^[ Zbg	*
;*			in					*
;*			OPMSGADR <- bZ[W f[^ AhX	*
;*							(L,H,B) *
;*								*
;****************************************************************
OPMJSET		EQU	$
		CACHE			; LbV X^[g!!
;
		IBT	R0,#000
		CMODE
		SMS	R0,COPMSGBIG
;
OPMJSET_000
		LMS	R0,COPMSGADRB
		ROMB			; bZ[W f[^ oN Zbg
		LMS	R14,COPMSGADR
		TO	R11
		GETB
		INC	R14
		SMS	R14,COPMSGADR	; ̃AhX Zbg
		MOVE	R0,R11
;
 IF  NES | PAL ;**** NES or PAL Ή [1995/7/11] *****************
		SMS	R0,CWORK1F	; f[^ -> CWORK1F
 ENDIF	  ;**** NES or PAL Ή [1995/7/11] **********************
;
		IWT	R3,#000FFH
		CMP	R3		;f[^ Gh ?
		BEQ	OPMJSET_090	;	YES -> OPMJSET_090
		DEC	R3
		CMP	R3		;bZ[W PC NA ?
		BEQ	OPMJSET_010	;	YES -> OPMJSET_010
		DEC	R3
		CMP	R3		;x X^[g|Cg Zbg ?
		BEQ	OPMJSET_010	;	YES -> OPMJSET_010
		DEC	R3
		CMP	R3		;w X^[g|Cg Zbg ?
		BEQ	OPMJSET_010	;	YES -> OPMJSET_010
		DEC	R3
		CMP	R3		;Q{TCY  Zbg ?
		BEQ	OPMJSET_010	;	YES -> OPMJSET_010
		DEC	R3
		IBT	R3,#0FEH
		LMS	R0,COPMSGBIG
		LOB
		BEQ	OPMJSET_010
		NOP
		IBT	R3,#0F9H
;
OPMJSET_010
		INC	R3
		IBT	R0,#BANK OPMJSET_0DT
		ROMB
		FROM	R3
		SEX
		NOT			; rbg]
		ADD	R0		; R0 = R0 * 2
		IWT	R14,#OPMJSET_0DT
		TO	R14
		ADD	R14		; R14 = R0 + #OPMJSET_0DT
		GETB
		INC	R14
		GETBH
		MOVE	R15,R0
		NOP
;
OPMJSET_090
		STOP
		NOP
;
OPMJSET_0DT
		WORD	OPMJSET_100
		WORD	OPMJSET_200
		WORD	OPMJSET_300
		WORD	OPMJSET_400
		WORD	OPMJSET_500
		WORD	OPMJSET_600
;
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+	bZ[WLN^[ Zbg (2*1)		+
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
OPMJSET_100	EQU	$
		IBT	R0,#BANK MSG_FONT
		ROMB
		IBT	R6,#00CH
		FROM	R11
		LMULT			; R4 = R11 * #00C
		IWT	R14,#MSG_FONT
		FROM	R14
		TO	R9
		ADD	R4		; R9 <- vbgf[^ AhX
		LMS	R5,COPMSGYPOS	; xX^[g |CgZbg
		MOVE	R2,R5
		IBT	R3,#007
		IBT	R4,#07FH
		IWT	R13,#OPMJSET_140
;
OPMJSET_130
		MOVE	R14,R9
		IBT	R12,#008	; w[v JE^[Zbg
		LMS	R1,COPMSGXPOS	; wX^[g |CgZbg
		GETB			; R11 <- vbgf[^
		TO	R10
		SWAP			; vbg f[^ (high) Zbg
		WITH	R14
		ADD	#008
		GETB
		TO	R11
		SWAP			; vbg f[^ (low) Zbg
		FROM	R3
		AND	#004
		BNE	OPMJSET_140
		INC	R9		; [h CfbNX INC .
		IBT	R11,#000
;
OPMJSET_140
		IBT	R0,#000		; J[ WX^ Zbg
		WITH	R11		;
		ROL			;
		ROL			;
		WITH	R10		;
		ROL			;
		ROL			;
		COLOR			;
;
		PLOT			; vbg!!
;
		WITH	R1
		AND	R4		; R1 <- R1 and #07F
		BNE	OPMJSET_165
		NOP
		IBT	R0,#008*4
		TO	R2
		ADD	R2		; R2 = R2 + #008*4
OPMJSET_165
		LOOP
		NOP
;
		INC	R5
		MOVE	R2,R5
		DEC	R3		; vbgP Gh
		BPL	OPMJSET_130	;	NO -> OPMJSET_130
		NOP
;
OPMJSET_190	EQU	$
;
 IF  NES | PAL ;**** NES or PAL Ή [1995/7/11] *****************
		IWT	R14,#MSG_FONT_X
		LMS	R0,CWORK1F
		TO	R14
		ADD	R14
		GETB
		LMS	R1,COPMSGXPOS
		ADD	R1
		SMS	R0,COPMSGXPOS	; ̂wW Zbg
 ENDIF	  ;**** NES or PAL Ή [1995/7/11] **********************
;
;
 IF  JPN  ;**** { Ή [1995/6/30] ****************************
		LMS	R0,COPMSGXPOS
		ADD	#00CH		; R0 = R0 + #00C
		SMS	R0,COPMSGXPOS	; ̂wW Zbg
 ENDIF	  ;**** { Ή [1995/6/30] ****************************
;
		IBT	R1,#07FH
		CMP	R1
		BCC	OPMJSET_195
		NOP
		AND	R1		; R0 = R0 and #07f
		SMS	R0,COPMSGXPOS	; #000 -> COPMSGXPOS
		IBT	R0,#008*4
		LMS	R1,COPMSGYPOS
		ADD	R1		; R0 = #008*4 + R1
		SMS	R0,COPMSGYPOS
OPMJSET_195
		RPIX
		IWT	R15,#OPMJSET_000
		NOP
;
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+	bZ[W PC NA			+
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
OPMJSET_200	EQU	$
		LMS	R0,COPMSGADRB
		ROMB
		LMS	R14,COPMSGADR
		GETB
		SWAP
		INC	R14
		SMS	R14,COPMSGADR
;
		IWT	R2,#0256*4
		IWT	R1,#DM01_MSGBITMP
		TO	R1
		ADD	R1
		WITH	R2
		ADD	R1
		IWT	R12,#0256/2
		IWT	R13,#OPMJSET_250
		IBT	R0,#000
;
OPMJSET_250
		STW	(R1)
		INC	R1
		INC	R1
		STW	(R2)
		INC	R2
		LOOP
		INC	R2
;
		IWT	R15,#OPMJSET_000
		NOP
;
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+	x X^[g|Cg Zbg			+
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
OPMJSET_300	EQU	$
		LMS	R0,COPMSGADRB
		ROMB
		LMS	R14,COPMSGADR
		GETB
		INC	R14
		SMS	R14,COPMSGADR
;
		SMS	R0,COPMSGYPOS
;
		IWT	R15,#OPMJSET_000
		NOP
;
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+	w X^[g|Cg Zbg			+
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
OPMJSET_400	EQU	$
		LMS	R0,COPMSGADRB
		ROMB
		LMS	R14,COPMSGADR
		GETB
		INC	R14
		SMS	R14,COPMSGADR
;
		SMS	R0,COPMSGXPOS
;
		IWT	R15,#OPMJSET_000
		NOP
;
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+  bZ[WQ{TCYLN^[ tOZbg	+
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
OPMJSET_500	EQU	$
		IBT	R0,#001
		SMS	R0,COPMSGBIG
;
		IWT	R15,#OPMJSET_000
		NOP
;
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+   bZ[WQ{TCYLN^[ Zbg (4*2)	+
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
OPMJSET_600	EQU	$
		IBT	R0,#BANK MSG_FONT
		ROMB
		IBT	R6,#00CH
		FROM	R11
		LMULT			; R4 = R11 * #00C
		IWT	R14,#MSG_FONT
		FROM	R14
		TO	R9
		ADD	R4		; R9 <- vbgf[^ AhX
		LMS	R5,COPMSGYPOS	; xX^[g |CgZbg
		IBT	R3,#008
		IBT	R4,#07FH
		IWT	R13,#OPMJSET_635
;
OPMJSET_630
		IBT	R12,#008	; w[v JE^[Zbg
		LMS	R1,COPMSGXPOS	; wX^[g |CgZbg
		MOVE	R14,R9
		MOVE	R2,R5
		GETB			; R11 <- vbgf[^
		TO	R10
		SWAP			; vbg f[^ (high) Zbg
		WITH	R14
		ADD	#004
		GETB
		TO	R11
		SWAP			; vbg f[^ (low) Zbg
;
OPMJSET_635
		IBT	R0,#000		; J[ WX^ Zbg
		WITH	R11		;
		ROL			;
		ROL			;
		WITH	R10		;
		ROL			;
		ROL			;
		COLOR			;
;
		PLOT			; vbg!!
		PLOT			; vbg!!
;
		WITH	R1
		AND	R4		; R1 <- R1 and #07F
		BNE	OPMJSET_638
		NOP
		IBT	R0,#008*4
		TO	R2
		ADD	R2		; R2 = R2 + #008*4
OPMJSET_638
		LOOP
		NOP
;
		DEC	R3
		BEQ	OPMJSET_640
		FROM	R3
		AND	#001
		BNE	OPMJSET_630
		INC	R5		; x INC .
		BRA	OPMJSET_630
		INC	R9		; [h CfbNX INC .
;
OPMJSET_640
		IBT	R0,#001
		COLOR
		INC	R5
		INC	R9
		INC	R9
		INC	R9
		INC	R9
		INC	R9
		IBT	R3,#008
		IWT	R13,#OPMJSET_655
;
OPMJSET_650
		IBT	R12,#008	; w[v JE^[Zbg
		LMS	R1,COPMSGXPOS	; wX^[g |CgZbg
		MOVE	R14,R9
		MOVE	R2,R5
		GETB
		TO	R10
		SWAP			; R10 <- vbgf[^
;
OPMJSET_655
		WITH	R10
		ROL
		BCC	OPMJSET_657
		NOP
;
		PLOT			; vbg!!
		PLOT			; vbg!!
		DEC	R1
		DEC	R1
;
OPMJSET_657
;
		INC	R1
		INC	R1
		WITH	R1
		AND	R4		; R1 <- R1 and #07F
		BNE	OPMJSET_658
		NOP
		IBT	R0,#008*4
		TO	R2
		ADD	R2		; R2 = R2 + #008*4
;
OPMJSET_658
		LOOP
		NOP
;
		DEC	R3
		BEQ	OPMJSET_690
		FROM	R3
		AND	#001
		BNE	OPMJSET_650
		INC	R5		; x INC .
		BRA	OPMJSET_650
		INC	R9		; [h CfbNX INC .
;
OPMJSET_690	EQU	$
;
 IF  NES | PAL ;**** NES or PAL Ή [1995/7/11] *****************
		IWT	R14,#MSG_FONT_X
		LMS	R0,CWORK1F
		TO	R14
		ADD	R14
		TO	R1
		GETB
		LMS	R0,COPMSGXPOS
		ADD	R1
		ADD	R1
		SMS	R0,COPMSGXPOS	; ̂wW
 ENDIF	  ;**** NES or PAL Ή [1995/7/11] **********************
;
;
 IF  JPN  ;**** { Ή [1995/6/30] ****************************
		LMS	R0,COPMSGXPOS
		ADD	#005		; R0 = R0 + #005
		ADD	#00FH		; R0 = R0 + #00F
		SMS	R0,COPMSGXPOS	; ̂wW
 ENDIF	  ;**** { Ή [1995/6/30] ****************************
;
		IBT	R1,#07FH
		CMP	R1
		BCC	OPMJSET_695
		NOP
		AND	R1		; R0 = R0 and #07f
		SMS	R0,COPMSGXPOS	; #000 -> COPMSGXPOS
		IBT	R0,#008*4
		LMS	R1,COPMSGYPOS
		ADD	R1		; R0 = #008*4 + R1
		SMS	R0,COPMSGYPOS
OPMJSET_695
		RPIX
		IWT	R15,#OPMJSET_000
		NOP
;
;
;****************************************************************
;*								*
;*	t@C ZNg [h				*
;*			[h̖O				*
;*			in					*
;*			cwork14 <- x^ J[m.		*
;*			cwork15 <- pJ[m.		*
;*			cwork16 <- vbg rbgJ[m.	*
;****************************************************************
FLSLMDMN	EQU	$
		CACHE			; LbV X^[g!!
;
		IBT	R0,#011H	; CMODE SET
		CMODE
;
		LMS	R0,CWORK14	; x^ rbgJ[ Zbg
		COLOR
		IBT	R1,#000
		IBT	R2,#000
		IBT	R3,#07FH
		IBT	R12,#010H
		IWT	R13,#FLSLMDMN_000
;
FLSLMDMN_000
		PLOT
		WITH	R1
		AND	R3		; R1 <- R1 and #0007f
		BNE	FLSLMDMN_000
		NOP
		LOOP
		INC	R2
;
		LMS	R0,CWORK15	; pJ[ Zbg
		COLOR
		IBT	R1,#000
		IBT	R2,#000
		PLOT
		IBT	R1,#000
		IBT	R2,#010H-1
		PLOT
		IBT	R1,#00DH*8-1
		IBT	R2,#000
		PLOT
		IBT	R1,#00DH*8-1
		IBT	R2,#00FH
		PLOT
;
;-------------- f[^ vbg X^[g --------------------
		LMS	R0,CWORK16	;vbg rbgJ[ Zbg
		COLOR
		IWT	R13,#FLSLMDMN_650
;
FLSLMDMN_100
		IWT	R1,#000FFH
		LMS	R0,CWORK11
		ROMB
		LMS	R14,CWORK10
		GETB			; R0 <- f[^
		INC	R14
		SMS	R14,CWORK10
;
		CMP	R1		; tO ?
		BNE	FLSLMDMN_500	;	NO -> FLSLMDMN_500
		NOP
FLSLMDMN_300
		GETB
		INC	R14
		SMS	R14,CWORK10
;
		CMP	R1		;okns I ?
		BNE	FLSLMDMN_350	;	NO -> FLSLMDMN_350
		NOP
		STOP
		NOP
;
FLSLMDMN_350
		SEX			;[h̖O Zbg I ?
		BMI	FLSLMOJ		;	YES -> FLSLMOJ
;
		TO	R10		; w X^[g |Cg Zbg
		LOB
		GETB			; x X^[g |Cg Zbg
		TO	R11
		LOB
		INC	R14
		SMS	R14,CWORK10
		BRA	FLSLMDMN_100
		NOP
;
FLSLMDMN_500
;
 IF  NES | PAL ;**** NES or PAL Ή [1995/7/11] *****************
		SMS	R0,CWORK1F	; f[^ -> CWORK1F
 ENDIF	  ;**** NES or PAL Ή [1995/7/11] **********************
;
		IBT	R6,#00CH	; P[vJE^[
		LMULT			; R4 = R0 * #00C
;
		IBT	R0,#BANK MSG_FONT
		ROMB
		IWT	R0,#MSG_FONT
		TO	R14		; ̃rbgf[^AhX
		ADD	R4		;	R14 = R0 + R4
		MOVE	R2,R11		; xX^[g |Cg Zbg
;
FLSLMDMN_600
		IBT	R12,#008H
		GETB			; R3 <- f[^
		LOB
		TO	R3
		SWAP
		INC	R14
		MOVE	R1,R10		; w X^[g |Cg Zbg
;
FLSLMDMN_650
		WITH	R3
		ROL			; okns nj ?
		BCC	FLSLMDMN_680	;	NO -> FLSLMDMN_680
		NOP
;
		PLOT
		DEC	R1
;
FLSLMDMN_680
		LOOP
		INC	R1
		DEC	R6
		BNE	FLSLMDMN_600
		INC	R2
;
		RPIX
;
 IF  NES | PAL ;**** NES or PAL Ή [1995/7/11] *****************
		IWT	R14,#MSG_FONT_X
		LMS	R0,CWORK1F
		TO	R14
		ADD	R14
		GETB
		TO	R10
		ADD	R10		;  w X^[g |Cg Zbg
 ENDIF	  ;**** NES or PAL Ή [1995/7/11] **********************
;
;
 IF  JPN  ;**** { Ή [1995/6/30] ****************************
		WITH	R10
		ADD	#009		;  w X^[g |Cg Zbg
 ENDIF	  ;**** { Ή [1995/6/30] ****************************
;
		BRA	FLSLMDMN_100
		NOP
;
;
;****************************************************************
;*								*
;*	t@C ZNg [h				*
;*			bZ[W Zbg			*
;*			in					*
;*			cwork10 <- f[^AhX	(L,H)	*
;*			cwork11 <-	"       "	(B)	*
;*			cwork12 <- x^ rbgJ[m.	*
;*			cwork13 <- vbg rbgJ[m.	*
;****************************************************************
FLSLMOJ		EQU	$
		CACHE			; LbV X^[g!!
;
		IBT	R0,#011H	; CMODE SET
		CMODE
;
		LMS	R0,CWORK12	; x^ rbgJ[ Zbg
		COLOR
		IBT	R1,#000
		IBT	R2,#010H
		IBT	R3,#07FH
		IBT	R12,#030H
		IWT	R13,#FLSLMOJ_100
FLSLMOJ_100
		PLOT
		WITH	R1
		AND	R3		; R1 <- R1 and #0007f
		BNE	FLSLMOJ_100
		NOP
		LOOP
		INC	R2
;
;-------------- f[^ vbg X^[g --------------------
		LMS	R0,CWORK13	;vbg rbgJ[ Zbg
		COLOR
		IWT	R13,#FLSLMOJ_450
;
FLSLMOJ_200
		IWT	R1,#000FFH
		LMS	R0,CWORK11
		ROMB
		LMS	R14,CWORK10
		GETB			; R0 <- f[^
		INC	R14
		SMS	R14,CWORK10
;
		CMP	R1		; tO ?
		BNE	FLSLMOJ_300	;	NO -> FLSLMOJ_300
		NOP
		GETB			; R0 <- f[^
		INC	R14
		SMS	R14,CWORK10
		CMP	R1		; f[^ Gh ?
		BEQ	FLSLMOJ_900	;	YES -> FLSLMOJ_900
		TO	R10		; w X^[g |Cg Zbg
		LOB
		GETB			; x X^[g |Cg Zbg
		TO	R11
		LOB
		INC	R14
		SMS	R14,CWORK10
		BRA	FLSLMOJ_200
		NOP
;
FLSLMOJ_300
;
 IF  NES | PAL ;**** NES or PAL Ή [1995/7/11] *****************
		SMS	R0,CWORK1F	; f[^ -> CWORK1F
 ENDIF	  ;**** NES or PAL Ή [1995/7/11] **********************
;
		IBT	R6,#00CH	; P[vJE^[
		LMULT			; R4 = R0 * #00C
;
		IBT	R0,#BANK MSG_FONT
		ROMB
		IWT	R0,#MSG_FONT
		TO	R14		; ̃rbgf[^AhX
		ADD	R4		;	R14 = R0 + R4
		MOVE	R2,R11		; xX^[g |Cg Zbg
		MOVE	R5,R2		; R5 <- R2
;
FLSLMOJ_400
		MOVE	R2,R5
		IBT	R12,#008H
		GETB			; R3 <- f[^
		LOB
		TO	R3
		SWAP
		INC	R14
		MOVE	R1,R10		; w X^[g |Cg Zbg
;
FLSLMOJ_450
		WITH	R3
		ROL			; okns nj ?
		BCC	FLSLMOJ_480	;	NO -> FLSLMOJ_480
		NOP
;
		PLOT
		DEC	R1
;
FLSLMOJ_480
		INC	R1
		IBT	R0,#07FH
		AND	R1		; mdws C Zbg ?
		BNE	FLSLMOJ_490	;	NO -> FLSLMOJ_490
		NOP
		IBT	R0,#010H
		TO	R2
		ADD	R2
FLSLMOJ_490
		LOOP
		NOP
		INC	R5
		DEC	R6
		BNE	FLSLMOJ_400
		NOP
;
		RPIX
;
;
 IF  NES | PAL ;**** NES or PAL Ή [1995/7/11] *****************
		IWT	R14,#MSG_FONT_X
		LMS	R0,CWORK1F
		TO	R14
		ADD	R14
		GETB
		TO	R10
		ADD	R10		;  w X^[g |Cg Zbg
 ENDIF	  ;**** NES or PAL Ή [1995/7/11] **********************
;
;
 IF  JPN  ;**** { Ή [1995/6/30] ****************************
		WITH	R10
		ADD	#009		;  w X^[g |Cg Zbg
 ENDIF	  ;**** { Ή [1995/6/30] ****************************
;
		BRA	FLSLMOJ_200
		NOP
;
FLSLMOJ_900
		STOP
		NOP
;
;
;****************************************************************
;*								*
;*	dmchmfLN^[ 쐬 vO		*
;*								*
;****************************************************************
ENDING_MOJI	EQU	$
		CACHE			; LbV X^[g!!
;
		IBT	R0,#011H
		CMODE			; blncdZbg !!
;
		IBT	R0,#BANK MSG_FONT
		ROMB
		IWT	R14,#MSG_FONT
;
		IBT	R0,#001
		COLOR
;
		GETB			; R0 <- rbgf[^
		SWAP
		INC	R14
		IBT	R3,#000
		IBT	R4,#004
		IWT	R11,#008
		IWT	R13,#EDG_0020
;
EDG_0010
		IBT	R12,#008
EDG_0020
		IBT	R10,#00CH
		MOVE	R2,R4		; vbgx l
		WITH	R3
EDG_0030
		TO	R1		; vbgw l
EDG_0040
		ADD	R0
		BCC	EDG_0060
		INC	R1
		DEC	R1
		PLOT			; vbg!!
EDG_0060
		MOVES	R0,R0		; PhbgCI ?
		BNE	EDG_0040	;	NO -> EDG_0040
		NOP
		GETB			; R0 <- rbgf[^
		SWAP
		INC	R14
		INC	R2		; ̃vbgx
		DEC	R10		; PZbgI ?
		BNE	EDG_0030	;	NO -> EDG_0030
		WITH	R3
		ADD	#008		; WZbgI ?
		LOOP			;	NO -> EDG_0020
		WITH	R4
		ADD	#00FH
		INC	R4
		IBT	R3,#000
		DEC	R11		; USZbgI ?
		BNE	EDG_0010	;	NO ->  EDG_0010
		NOP
;
;
		IBT	R3,#8*8
		IBT	R4,#004
		IWT	R11,#008
		IWT	R13,#EDG_0120
;
EDG_0110
		IBT	R12,#008
EDG_0120
		IBT	R10,#00CH
		MOVE	R2,R4		; vbgx l
		WITH	R3
EDG_0130
		TO	R1		; vbgw l
EDG_0140
		ADD	R0
		BCC	EDG_0160
		INC	R1
		DEC	R1
		PLOT			; vbg!!
EDG_0160
		MOVES	R0,R0		; PhbgCI ?
		BNE	EDG_0140	;	NO -> EDG_0140
		NOP
		GETB			; R0 <- rbgf[^
		SWAP
		INC	R14
		INC	R2		; ̃vbgx
		DEC	R10		; PZbgI ?
		BNE	EDG_0130	;	NO -> EDG_0130
		WITH	R3
		ADD	#008		; WZbgI ?
		LOOP			;	NO -> EDG_0120
		WITH	R4
		ADD	#00FH
		INC	R4
		IBT	R3,#8*8
		DEC	R11		; USZbgI ?
		BNE	EDG_0110	;	NO ->  EDG_0110
		NOP
;
;
		IWT	R3,#00080H
		IBT	R4,#004
		IWT	R11,#008
		IWT	R13,#EDG_0220
;
EDG_0210
		IBT	R12,#008
EDG_0220
		IBT	R10,#00CH
		MOVE	R2,R4		; vbgx l
		WITH	R3
EDG_0230
		TO	R1		; vbgw l
EDG_0240
		ADD	R0
		BCC	EDG_0260
		INC	R1
		DEC	R1
		PLOT			; vbg!!
EDG_0260
		MOVES	R0,R0		; PhbgCI ?
		BNE	EDG_0240	;	NO -> EDG_0240
		NOP
		GETB			; R0 <- rbgf[^
		SWAP
		INC	R14
		INC	R2		; ̃vbgx
		DEC	R10		; PZbgI ?
		BNE	EDG_0230	;	NO -> EDG_0230
		WITH	R3
		ADD	#008		; WZbgI ?
		LOOP			;	NO -> EDG_0220
		WITH	R4
		ADD	#00FH
		INC	R4
		IWT	R3,#00080H
		DEC	R11		; USZbgI ?
		BNE	EDG_0210	;	NO ->  EDG_0210
		NOP
;
;
		IWT	R3,#8*8+080H
		IBT	R4,#004
		IWT	R11,#008
		IWT	R13,#EDG_0320
;
EDG_0310
		IBT	R12,#008
EDG_0320
		IBT	R10,#00CH
		MOVE	R2,R4		; vbgx l
		WITH	R3
EDG_0330
		TO	R1		; vbgw l
EDG_0340
		ADD	R0
		BCC	EDG_0360
		INC	R1
		DEC	R1
		PLOT			; vbg!!
EDG_0360
		MOVES	R0,R0		; PhbgCI ?
		BNE	EDG_0340	;	NO -> EDG_0340
		NOP
		GETB			; R0 <- rbgf[^
		SWAP
		INC	R14
		INC	R2		; ̃vbgx
		DEC	R10		; PZbgI ?
		BNE	EDG_0330	;	NO -> EDG_0330
		WITH	R3
		ADD	#008		; WZbgI ?
		LOOP			;	NO -> EDG_0320
		WITH	R4
		ADD	#00FH
		INC	R4
		IWT	R3,#8*8+080H
		DEC	R11		; USZbgI ?
		BNE	EDG_0310	;	NO ->  EDG_0310
		NOP
;
		RPIX
;
		IWT	R10,#BITMAP_BF+00001H
		IWT	R11,#BITMAP_BF+02000H
		IWT	R12,#02000H
		MOVE	R13,R15
		LDB	(R11)
		STB	(R10)
		INC	R11
		INC	R11
		INC	R10
		LOOP
		INC	R10
;
		STOP
		NOP
;
;
;
;
;
;
;
		mEND_NOP
		END
