;************************************************************************
;*									*
;*	title name	: "yossy"					*
;*	proccess	: course BG write main				*
;*	file name	: ys_bgsc					*
;*									*
;************************************************************************
;
;
		SALL
;
		include		ys_header.inc
		include		ys_unit.h
;
		XALL
;
;
;------------------------------------------------------------------------
;-		global symbol						-
;------------------------------------------------------------------------
		GLB	BG3SCK,BGINT,BGSET,UNITST,BGSTATST,UNITST_SUB
		GLB	RUTSET
		GLB	UNITCHG,MINI_INT_BG
;
		GLB	GMBGIN,TIMEUP
		GLB	CORSIN_WIND_ST
;
;-------------- BG chenge no. ------------------------------------------
		GLB	BLK0,BGCG,DBG0	;DROP,DRCL
		GLB	KPCL,DWCG,BCG2,TGTM,CNCL
;
;-------------- _~[ !! ----------------------------------------------
		GLB	UNDO_GO
;
;------------------------------------------------------------------------
;-		extern symbol						-
;------------------------------------------------------------------------
;
;-------------< ys_main >------------------------------------------------
		EXT	BGSCWTL
		EXT	MPIN,GM_OVR
		EXT	INT_STAT,HF_STAT,AGAIN
;
;-------------< ys_rpro >------------------------------------------------
		EXT	CHIPON,NEWVMADL,VMADSPL
		EXT	COURSE_IN_DM,INCSMSG,INCSMSG_100
		EXT	BLUE_COIN_ST_SB
;
;-------------< ys_init >------------------------------------------------
		EXT	M_DMA_BFST
;
;-------------< ys_bgsc0 >-----------------------------------------------
		EXT	KOTEISB,KAHENSB
		EXT	CHKCHG_DAT0,CHKCHG_DAT1,CHKCHG_DAT2,CHKCHG_DAT3,CHKCHG_DAT4
		EXT	KAHNSB
;
;-------------< ys_unit >------------------------------------------------
		EXT	UNDTADD,UNDATA,RUTDATA
;
;-------------< ys_game >------------------------------------------------
		EXT	GMPLAY2
		EXT	STAT_MSG
		EXT	BGCIN_STCHK_ADR,BGCIN_STCHK_DAT
;
;-------------< ys_enemy >-----------------------------------------------
		EXT	ENINSB
;
;-------------< ys_enemy8 >----------------------------------------------
		EXT	BGBR0_SET
;
;------------------------------------------------------------------------
;-		define symbol						-
;------------------------------------------------------------------------
;;;;		EQU
;
;
;************************************************************************
;*									*
;*		program start						*
;*									*
;************************************************************************
;
;
		EXTEND
;
;
		MEM8
		IDX8
;
Group_10	GROUP	Bgsc_pro
Bgsc_pro	SECT	REL
;
;************************************************************************
;*		R[Xf[^ Xe[^Xf[^Zbg			*
;************************************************************************
STAT_CNVDT	EQU	$
;			[number of bit]
		BYTE	5		;[NUKINO] kLJ[(0-1F)
		BYTE	4		;[BG1TYP] afP^Cv(0-F)
		BYTE	5		;[BG1COL]   h	J[(0-F)
		BYTE	5		;[BG2TYP] afQXN[^Cv(0-1F)
		BYTE	6		;[BG2COL]   h	J[(0-1F)
		BYTE	6		;[BG3TYP] afR^Cv(0-3F)
		BYTE	6		;[BG3COL]   h	J[(0-F)
		BYTE	7		;[OBJTYP] nai^Cv(0-F)
		BYTE	4		;[OBJCOL]   "   J[(0-F)
		BYTE	5		;[DSPMOD] ʃ[h(0-1F)
		BYTE	6		;[CHRTRP] L]p^[(0-1F)
		BYTE	5		;[COLTRP] J[]p^[(0-F)
		BYTE	5		;[SCRLNO] XN[^Cv(0-F)
		BYTE	4		;[BGM_NO] afl mD(0-F)
		BYTE	2		;[CORSNO] R[X mD(0-3)
		HEX	00	;end code
;
		MEM8
		IDX8
;
BGSTATST	EQU	$
		PHB			;(DBR) save
		PHK			;(DBR) <-- (PBR)
		PLB
;
		I16
;
		LDY	#00		;(Y) <-- status data set RAM pointer
		LDX	#00		;(X) <-- status data convert data pointer
		STX	<BGDTPT		;(BGDTPT) <-- BG course data pointer
		STZ	<WORK2		;(WK2) <-- number of bit initial set
		LDA	!STAT_CNVDT,X
STATLD_010	EQU	$
		STA	<WORK4		;(WK4) <-- set number of bit
		LDA	#00		;(A) <-- status data set RAM
STATLD_020	EQU	$
		DEC	<WORK2
		BPL	STATLD_030	;BG course data read ? ( no:STATLD_030 )
;
		PHA			;(A) save
		LDA	#8-1
		STA	<WORK2		;(WK2) <-- number of bit
		PHY			;(Y) save
		LDY	<BGDTPT
		LDA	[<BGDTADR],Y	;(A) <-- raed BG course data
		STA	<WORK6
		INY
		STY	<BGDTPT
		PLY			;(Y) load
		PLA			;(A) load
STATLD_030	EQU	$
		ASL	<WORK6
		ROL	A		;(A) <-- status data
		DEC	WORK4
		BNE	STATLD_020
;
		STA	GMSTATUS,Y	;status data RAM set
		INY
		INY
		INX
		LDA	!STAT_CNVDT,X
		BNE	STATLD_010	;end ? ( no:STATLD_010 )
;
		LDA	!CORSNO
		STA	!CORSNOBUF
		I8
;
		PLB
		RTL
;
;************************************************************************
;*		R[Xf[^WJ					*
;************************************************************************
;
UNITST		EQU	$
		JSL	>BGSTATST
;
UNITST_SUB	EQU	$
		PHB			;(DBR) save
		PHK			;(DBR) <-- (PBR)
		PLB
;
;-------------- base unit no. set -----------------------
		JSL	>RUTSET
;
;-------------- BG unit buffer clear --------------------
;
		M16			; memory 16bit mode
		PHB
		LDX	#BANK BG2FKN_CP
		PHX
		PLB
;
		LDX	#000H
UNST000_000	EQU	$
		STZ	!BG2FKN_CP,X
		INX
		INX
		CPX	#006*20
		BCC	UNST000_000
;
		LDX	#BANK NXGOTOBF
		PHX
		PLB
		I16			; index 16bit mode
		LDX	#(200H*64)+(16*8*4)
UNST000		EQU	$
		STZ	!NXGOTOBF-2,X
		DEX
		DEX
		BNE	UNST000
;
		PLB
;
		LDX	#0000EH
UNST001		EQU	$
		STZ	!UNBFSB+000H,X
		STZ	!UNBFSB+010H,X
		STZ	!UNBFSB+020H,X
		STZ	!UNBFSB+030H,X
		DEX
		DEX
		BPL	UNST001
;
		MI8			; memory , index 8bit mode
;
		STZ	!UBFSBCNT
;
		LDA	#080H
		LDX	#16*8-1
UNST002		EQU	$
		STA	UNBUFAD,X
		DEX
		BPL	UNST002
		STZ	<BGBFPT		;buffer pointer clear !!
;
;-------------- BG unit buffer set ----------------------
UNTS010		EQU	$
		MI16			; memory , index 16bit mode
		LDA	#00001H
		STA	<XSIZECP
		STA	<YSIZECP
		STZ	<STUNTNO
		M8			; memory 8bit mode
;
		LDY	<BGDTPT
		LDA	[<BGDTADR],Y
		STA	<STUNTNO
		INY
		LDA	[<BGDTADR],Y
		STA	<XYPOINT+1	; X,Y (H) point
		INY
		LDA	[<BGDTADR],Y
		STA	<XYPOINT	; X,Y (L) point
;
		LDA	<STUNTNO	; Œ or  ?
		BEQ	KOTEISL		;	Œ -> goto KOTEISL
		CMP	#0FFH		;
		BNE	KAHENSL		;	 -> goto KAHENSL
;
;-------------- next go to data check -------------------
		LDA	<XYPOINT+1	; next goto data end ?
		BMI	UNTS040		;	YES -> UNTS040
;
		M16			; memory 16bit mode
UNTS020		EQU	$
		AND	#0007FH
		ASL	A		;x4
		ASL	A
		TAX
		LDA	[<BGDTADR],Y
		STA	>NXGOTOBF,X
		INY
		LDA	[<BGDTADR],Y
		STA	>NXGOTOBF+1,X
		INY
		LDA	[<BGDTADR],Y
		STA	>NXGOTOBF+2,X
		INY
		LDA	[<BGDTADR],Y
		INY
		INY
		XBA
		AND	#000FFH
		CMP	#000FFH		; next go to data end ?
		BNE	UNTS020		;	NO -> UNTS020
;
		M8			; memory 8bit mode
;
UNTS040		EQU	$
;
		I8			; index 8bit mode
;
;-------------- afQʃ}bvZbg ----------------------------------
		LDX	#(16*8)-1
UNTS050		EQU	$
		LDA	UNBUFAD,X
		STA	UNBUFAD+(16*8)+(16*4),X
		DEX
		BPL	UNTS050
;
		PLB
		RTL
;
;-------------- kotei data -------------------------------
KOTEISL		EQU	$
		PHK
		PEA	UNTS010-1
;
		LDA	#BANK KOTEISB
		PHA
		PHA
		PLB
;
		INY
		LDA	[<BGDTADR],Y	; unit NO.
		STA	<STUNTNO
		INY
		STY	<BGDTPT
;
		M16			; memory 16bit mode
		AND	#000FFH
		ASL	A
		TAX
;
		LDA	>KOTEISB,X
		PHA
		MI8			; memory , index 8bit mode
		RTL
;
		MEM8
		IDX16
;
;-------------- kahen data -------------------------------
KAHENSL		EQU	$
		PHK
		PEA	UNTS010-1
;
		M16			; memory 16bit mode
		LDX	<STUNTNO
		LDA	>KAHNSB,X
		AND	#00003H
		CMP	#00001H
		BEQ	KAHEN10
		TAX
;
		INY
		LDA	[<BGDTADR],Y
		STA	<WORKA
		BIT	#00080H
		BEQ	KAHEN05
		LDA	!BG1TYP
		CMP	#00002H
		BEQ	KAHEN05
		LDA	<WORKA
		ORA	#0FF00H
		DEC	A
		BRA	KAHEN08
KAHEN05		EQU	$
		LDA	<WORKA
		AND	#000FFH
		INC	A
KAHEN08		EQU	$
		STA	<XSIZECP	; X size set
		TXA
		BEQ	KAHEN15
;
KAHEN10		EQU	$
		INY
		LDA	[<BGDTADR],Y
		BIT	#00080H
		BEQ	KAHEN13
		ORA	#0FF00H
		DEC	A
		BRA	KAHEN18
KAHEN13		EQU	$
		AND	#000FFH
		INC	A
KAHEN18		EQU	$
		STA	<YSIZECP	; Y size set
KAHEN15		EQU	$
		INY
		STY	<BGDTPT
;
KAHEN20		EQU	$
		LDA	<STUNTNO
		ASL	A
		TAX
		M8			; memory 8bit mode
;
		LDA	#BANK KAHENSB
		PHA
		PHA
		PLB
		LDA	KAHENSB+1,X
		PHA
		LDA	KAHENSB,X
		PHA
		I8			; index 8bit mode
		RTL
;
;************************************************************************
;*		"mogura" course BG3 screen set check			*
;************************************************************************
;
BG3SCK		EQU	$
		LDA	BG3TYP
		CMP	#0AH
		BEQ	B3SC020		;"mogura" course ? ( yes:B3SC020 )
B3SC010		EQU	$
		RTL
;
B3SC020		EQU	$
		LDA	<BGWHF1
		ORA	<BGWVF1
		BEQ	B3SC010		;BG write timming ? ( no:B3SC010 )
;
		PHB			;(DBR) save
		PHK			;(DBR) <-- (PBR)
		PLB
;
		M16
;
		LDA	#0C07FH		;(R6) <-- convert AND data
		STA	R6
		LDA	#02100H		;(R7) <--    "    OR   "
		STA	R7
		LDA	<BGWAV1_00
		BIT	#0400H
		BEQ	B3SC022
		ORA	#020H
B3SC022		EQU	$
		AND	#03EH
		STA	R8	       ;(R8) <-- V scroll write start buffer pointer
;
		LDX	#BANK BG3SCST
		LDA	#BG3SCST
		JSL	>CHIPON
;
		LDX	#BANK VRAMDX
		PHX
		PLB
;
		I16
;
		LDX	VRAMDX		;(X) <-- VRAMDX index
;
		LDA	<BGWHF1
		BEQ	B3SC040		;H scroll BG write ? ( no:B3SC040 )
;
;-------------- BG3 H scroll BG write ---------------------------
		LDA	<BGWAH1_0
		AND	#07FFH
		BIT	#0400H
		BEQ	BGSC030
		EOR	#0400H|020H
BGSC030		EQU	$
		LSR	A
		ORA	#3400H
		STA	0,X		;VRAM address set
		LDA	#10000001B+(00000001B*100H)
		STA	2,X		;inc mode & DMA parameter set
		LDA	#18H+(LOW BG3HSCRBF)*100H
		STA	4,X		;B bus address & A bus address(L) set
		LDA	#BG3HSCRBF/100H
		STA	6,X		;A bus address(H,B) set
		LDA	#020H*2
		STA	8,X		;number of byte
		TXA
		CLC
		ADC	#12
		STA	10,X		;next data address set
		TAX
;
B3SC040		EQU	$
		LDA	<BGWVF1
		BEQ	B3SC050		;V scroll BG write ? ( no:B3SC050 )
;
;-------------- BG3 V scroll BG write ---------------------------
		LDA	<BG3WSCV
		AND	#01F0H
		ASL	A
		ORA	#3400H
		STA	0,X		;VRAM address set
		LDA	#10000000B+(00000001B*100H)
		STA	2,X		;inc mode & DMA parameter set
		LDA	#18H+(LOW BG3VSCRBF)*100H
		STA	4,X		;B bus address & A bus address(L) set
		LDA	#BG3VSCRBF/100H
		STA	6,X		;A bus address(H,B) set
		LDA	#020H*2
		STA	8,X		;number of byte
		TXA
		CLC
		ADC	#12
		STA	10,X		;next data address set
		TAX
;
B3SC050		EQU	$
		STX	VRAMDX		;end address set
;
		MI8
;
		PLB
		RTL
;
;************************************************************************
;*		R[XC^Cg					*
;************************************************************************
;
GMBGIN		EQU	$
		LDA	<BGW_WORK
		BEQ	GMBGIN_010	;IH ( no:GMBGIN_010 )
;
;-------------- R[Xf[^afZbg ------------------------------
;
		MI16
;
		JSR	BGINT_SUB
;
		MI8
;
;-------------- R[XC^Cgf ------------------------------
		JSL	>COURSE_IN_DM
;
		DEC	<BGW_WORK
		BNE	GMBGIN_004	;IH ( no:GMBGIN_004 )
;
;-------------- GZbg ------------------------------------
		JSL	>ENINSB		;enemy initial set
		LDX	#(ENNO-1)*4	;\Zbg
GMBGIN_002	EQU	$
		LDA	ENYUSN,X
		ORA	#80H
		STA	ENYUSN,X
		DEX
		DEX
		DEX
		DEX
		BNE	GMBGIN_002
;
GMBGIN_004	EQU	$
		PLB
		RTL
;
;-------------- J[enodm ----------------------------------------
GMBGIN_010	EQU	$
		LDA	GMFADE_CT
		BEQ	GMBGIN_010_00	;IH ( yes:GMBGIN_010_00 )
;
		M16
;
		LDY	GMFADE_FLG0
		INY			;[ CPY #0FFH ]
		BEQ	GMBGIN_010_50	;IH ( yes:GMBGIN_010_50 )
;
		M8
;
		JSL	>FIN_10
		BRA	GMBGIN_020
;
;-------------- KR[Xp bZ[W `FbN ------------------------
GMBGIN_010_00	EQU	$
		M8			; memory 8bit mode
		LDA	!MAPOINT
		CMP	#(1-1)*12+(5-1)
		BEQ	GMBGIN_010_10	;Pv|TH ( yes:GMBGIN_010_10 )
		CMP	#(2-1)*12+(7-1)
		BEQ	GMBGIN_010_10	;Qv|VH ( yes:GMBGIN_010_10 )
		CMP	#(5-1)*12+(7-1)
		BNE	GMBGIN_010_20	;Tv|VH ( no:GMBGIN_010_20 )
;
;-------------- vC[] ------------------------------
GMBGIN_010_10	EQU	$
		LDX	#02H
		STX	PLCMKI
;
GMBGIN_010_20	EQU	$
		CMP	#INT_STAT	; KR[X ?
		BNE	GMBGIN_010_40	;	NO -> GMBGIN_010_40
		LDA	<KEYC1L
		AND	#0F0H
		ORA	<KEYC1		; L[ nm ?
		BEQ	GMBGIN_020	;	NO -> GMBGIN_020
		INC	!MSGMOD
		LDA	#STAT_MSG
		STA	>MSG_NO
GMBGIN_010_40	EQU	$
		INC	MODENO
		STZ	PLMODE		;vC[ʃ[h
;
;-------------- EBhEp[^Zbg ----------------------------
		MEM16
GMBGIN_010_50	EQU	$
		STZ	GMFADE_CT
;
		M8
;
		STZ	WMANSL		;window disable
		STZ	WSUBSL
		STZ	WIND23
		STZ	WIND24
		STZ	WIND25
		LDA	#00100000B	;H-DMA "OFF"
		TRB	HD420C
;
		LDX	#(ENNO-1)*4	;\Zbg
GMBGIN_012	EQU	$
		LDA	ENYUSN,X
		CMP	#0FFH
		BEQ	GMBGIN_014
		AND	#7FH
		STA	ENYUSN,X
GMBGIN_014	EQU	$
		DEX
		DEX
		DEX
		DEX
		BNE	GMBGIN_012
;
GMBGIN_020	EQU	$
;
		M8
;
;-------------- R[XC^Cgf ------------------------------
		JSL	>GMPLAY2	;game play ( display only )
;;;;K;;;;		I16			; index 16bit mode
;;;;K;;;;		LDX	#00000H
;;;;K;;;;		LDY	!MAPOINT
;;;;K;;;;		JSL	>INCSMSG	;R[XC^Cg\
;
		IDX8
;
		PLB
		RTL
;
;
;
;
;
;------------------------------------------------------------------------
;-		R[XCEBhEZbg			-
;------------------------------------------------------------------------
FIN02DT_100	EQU	$
		HEX	33,23,17,15,00
FIN02DT_110	EQU	$
		HEX	0C,04,02,02,01
FIN02DT_200	EQU	$
		HEX	20,10,00
FIN02DT_210	EQU	$
		HEX	20,10,08
;
FIN_10		EQU	$
		PHB			;(DBR) save
		PHK			;(DBR) <-- (PBR)
		PLB
;
		LDX	GMFADE_FLG0
		BEQ	FIN02_100
		CPX	#0FFH
		BEQ	FIN02_900
;
		LDA	#000H
		STA	GMFADE_FLG0
;
		LDA	#00FFH
		STA	GMFADE_AWK0	       ;LEFT
		LDA	#00FFH
		STA	GMFADE_AWK1	       ;RIGHT
;
		BRA	FIN02_300
;
FIN02_100	EQU	$
;
		LDA	GMFADE_AWK0
		BEQ	FIN02_200
;
		LDX	GMFADE_AWK2
		LDA	GMFADE_AWK0
		CMP	FIN02DT_100,X
		BCS	FIN02_110
;
		INX
;
FIN02_110	EQU	$
		LDA	GMFADE_AWK0
		SEC
		SBC	FIN02DT_110,X
		BCS	FIN02_115
		LDA	#000H
FIN02_115	EQU	$
		STA	GMFADE_AWK0
;
		BRA	FIN02_300
;
FIN02_200	EQU	$
;
		LDX	GMFADE_AWK2
		LDA	GMFADE_AWK1
		BEQ	FIN02_212
		CMP	FIN02DT_200,X
		BCS	FIN02_210
;
		INX
;
FIN02_210	EQU	$
;
		LDA	GMFADE_AWK1
		SEC
		SBC	FIN02DT_210,X
		BCS	FIN02_215
FIN02_212	EQU	$
		LDX	#0FFH
		STX	GMFADE_FLG0
		STX	GMFADE_AWK0
		LDX	#000H
		STX	GMFADE_AWK1
		BRA	FIN02_300
FIN02_215	EQU	$
		STA	GMFADE_AWK1
;
FIN02_300	EQU	$
;
		M16
;
		LDY	GMFADE_AWK0
		TYA
		STA	R1
		LDY	GMFADE_AWK1
		TYA
		STA	R2
		M_CHIP	W1BUF_SINSET
;
FIN02_900	EQU	$
;
		M16
;
		JMP	>CORSIN_WIND_ON
;
		MEM8
;
;
;
;
;************************************************************************
;*		^CAbv					*
;************************************************************************
;
TIMEUP		EQU	$
;
		M16
;
		LDA	GMFADE_CT
		BNE	TIMEUP_FFF	;ZbgH ( no:TIMEUP_FFF )
;
;-------------- Zbg ----------------------------------------------
		LDX	#(ENNO-1)*4	;GNA[
TIMEUP_SET_010	EQU	$
		LDA	ENMODE,X
		BEQ	TIMEUP_SET_018	;GZbgH ( no:TIMEUP_SET_018 )
;
		LDA	ENMOD0,X
		AND	#0000000100000000B
		BEQ	TIMEUP_SET_018	;NA[H ( no:TIMEUP_SET_018 )
;
		STZ	ENMODE,X
		LDA	#0FFH
		STA	ENYUSN,X	;n`l\Zbg
;
		LDY	BG2TYP
		CPY	#16H
		BNE	TIMEUP_SET_014	;afQGH ( no:TIMEUP_SET_014 )
		LDA	#00000010B+(00000010B*100H)
		TRB	MANSEL		;[ & SUBSEL ]
TIMEUP_SET_014	EQU	$
		LDY	BG3TYP
		CPY	#02H
		BEQ	TIMEUP_SET_016	;afRGH ( yes:TIMEUP_SET_016 )
		CPY	#16H
		BNE	TIMEUP_SET_018	;afRGH ( no:TIMEUP_SET_018 )
TIMEUP_SET_016	EQU	$
		LDA	#00000100B+(00000100B*100H)
		TRB	MANSEL		;[ & SUBSEL ]
;
TIMEUP_SET_018	EQU	$
		DEX
		DEX
		DEX
		DEX
		BPL	TIMEUP_SET_010
;
		LDA	>DATACOL
		BEQ	TIMEUP_SET_019	;kLJ[H ( no:TIMEUP_SET_019 )
;
		STA	NUKCOL		;kLJ[ւ
		LDA	#00
		STA	>DATACOL
		LDX	#020H		;ʉZLZ
		STX	SUBADF
;
TIMEUP_SET_019	EQU	$
;
;-------------- vC[Ԃn`lZbg ------------------------
TIMEUP_FFF	EQU	$
;
		M8
;
		JSL	>GMPLAY2	;game play ( display only )
;
;-------------- J[ebknrd --------------------------------------
		JSL	>CORSIN_WIND_ST
		LDA	#00011111B	;nai
		STA	WMANSL
		STA	WSUBSL
;
		MI16			; memory 16bit mode
;
		LDA	!GMFADE_CT
		CLC
		ADC	#06H
		STA	!GMFADE_CT
;
		CMP	#0400H		; J[ebknrdIH
		BCC	TIMEUP_090	;	NO -> TIMEUP_090
;;;;K;;;;		CMP	#0700H
;;;;K;;;;		BCC	TIMEUP_010
;
;-------------- ̃[hw ------------------------------------
;
		LDA	!PLCONT		; "f`ld@nudq" ?
		BNE	TIMEUP_000	;	NO -> TIMEUP_000
		LDY	#GM_OVR
		BRA	TIMEUP_008
;
TIMEUP_000	EQU	$
		LDY	#AGAIN
		LDA	!MID_POINT	; ԃ|Cg ăX^[g H
		BEQ	TIMEUP_005	;	NO -> TIMEUP_005
		LDY	#HF_STAT
TIMEUP_005	EQU	$
;
TIMEUP_008	EQU	$
		STY	!MODENO
		STZ	!GMFADE_CT
;
;-------------- ]LN^[NA[ ------------------------
		PHB
		PEA	WOB7CHR/100H
		PLB
		PLB
		LDX	#0100H-2
TIMEUP_009	EQU	$
		STZ	!WOB7CHR+0000H,X
		STZ	!WOB7CHR+0100H,X
		STZ	!WOB7CHR+0200H,X
		STZ	!WOB7CHR+0300H,X
		STZ	!WOB7CHR+0400H,X
		STZ	!WOB7CHR+0500H,X
		STZ	!WOB7CHR+0600H,X
		STZ	!WOB7CHR+0700H,X
		DEX
		DEX
		BNE	TIMEUP_009
		PLB
;
		INC	!OBM7WF
;
;-------------- vC[_E bZ[WZbg ---------------
TIMEUP_010	EQU	$
;;;;K;;;;		LDA	!GMFADE_CT
;;;;K;;;;		AND	#03H
;;;;K;;;;		BEQ	TIMEUP_020
;;;;K;;;;		LDA	!INCSNXT	; bZ[W\n߂ ?
;;;;K;;;;		BEQ	TIMEUP_020	;	NO -> TIMEUP_020
;;;;K;;;;		LDA	!GMFADE_CT
;;;;K;;;;		PHA
;;;;K;;;;		LDA	#00120H
;;;;K;;;;		STA	!GMFADE_CT
;;;;K;;;;		JSL	>INCSMSG_100	; IuWFZbg
;;;;K;;;;		M16			; memory 16bit mode
;;;;K;;;;		PLA
;;;;K;;;;		STA	!GMFADE_CT
;;;;K;;;;		BRA	TIMEUP_090
;;;;K;;;;;
;;;;K;;;;TIMEUP_020	EQU	$
;;;;K;;;;		I16			; index 16bit mode
;;;;K;;;;		LDX	#00002H
;;;;K;;;;		LDY	#00000H
;;;;K;;;;		LDA	!TIMER
;;;;K;;;;		BEQ	TIMEUP_025
;;;;K;;;;		INY
;;;;K;;;;TIMEUP_025	EQU	$
;;;;K;;;;		LDA	!GMFADE_CT
;;;;K;;;;		PHA
;;;;K;;;;		LDA	#00120H
;;;;K;;;;		STA	!GMFADE_CT
;;;;K;;;;		JSL	>INCSMSG	;̃LƃIuWF Zbg
;;;;K;;;;		M16			; memory 16bit mode
;;;;K;;;;		PLA
;;;;K;;;;		STA	!GMFADE_CT
;
TIMEUP_090	EQU	$
;
		MI8			; memory ,index 8bit mode
;
		PLB
		RTL
;
;------------------------------------------------------------------------
;-		R[XC^CgEBhEZbg			-
;------------------------------------------------------------------------
CORSIN_WIND_ST	EQU	$
		PHB			;(DBR) save
		PHK			;(DBR) <-- (PBR)
		PLB
;
		M16
;
		LDA	GMFADE_CT
		STA	R1		;(R1) <-- EBhE
		M_CHIP	CORSIN_WIND
;
;-------------- EBhEobt@]Zbg ----------------------------
CORSIN_WIND_ON	EQU	$
		JSL	>M_DMA_BFST
		LWORD	WINDBUF		;]AhX
		LWORD	WINDBF		;]AhX
		WORD	(0D2H*4)	;]oCg
;
;-------------- EBhEp[^Zbg ------------------------------
		STZ	WLOGIC		;window logic set
;
		M8
;
		LDA	#00001111B
		STA	WMANSL
		STA	WSUBSL
		LDA	#00100010B
		STA	WIND23
		STA	WIND24
		STA	WIND25
;;;;		    LDA	    #00100000B
;;;;		    STA	    SUBADF
		LDA	#00100000B
		TSB	HD420C		;H-DMA "ON" !!
;
		PLB
		RTL
;
;------------------------------------------------------------------------
;-		R[Xf[^afZbg					-
;------------------------------------------------------------------------
;
		MEM16
		IDX16
;
BGINT_SUB	EQU	$
		LDA	WRSCH1
		JSR	HWADST		;H scroll BG screen write VRAM address set
;
		LDA	WRSCH1
		CLC
		ADC	#0010H
		STA	WRSCH1
;
		MI8
;
		JSL	>BG3SCK		;"mogura" course BG3 screen set check
;
		MI16
;
		RTS
;
;
;************************************************************************
;*									*
;*		~j Q[p af				*
;*									*
;************************************************************************
MINI_INT_BG	EQU	$
		PHB			;(DBR) save
		PHK			;(DBR) <-- (PBR)
		PLB
;
		STZ	<BGWHF1		;BG write flag reset !!
		STZ	<BGWVF1
		STZ	<SCHMK1		;scroll muki reset !!
;
		MI16			; memory , index 16bit mode
;
;-------------- intial BG write ---------------------------------
		LDA	#16+1		;loop no.
		STA	<BGW_WORK
;
		LDA	<SCCV1
		STA	WRSCV1
		LDA	<SCCH1
		SEC
		SBC	#00100H
		STA	WRSCH1
;
MINI_INT_LOP	EQU	$
		JSR	BGINT_SUB
		MI8			; memory , index 8bit mode
;
		JSL	>NEWVMADL	;BG3 screen write
		JSL	>BGSCWTL	;BG screen write
;
		MI16			; memory , index 16bit mode
		DEC	<BGW_WORK
		BNE	MINI_INT_LOP
;
		MI8			; memory , index 8bit mode
		PLB
		RTL
;
;************************************************************************
;*		BG intial write						*
;************************************************************************
BGINT		EQU	$
		PHB			;(DBR) save
		PHK			;(DBR) <-- (PBR)
		PLB
		LDA	!DSPMOD
		CMP	#009		; [hV ?
		BNE	BGINT_SET	;	NO -> BGINT_SET
		JMP	BGINT_PASS
;
BGINT_SET	EQU	$
		STZ	<BGWHF1		;BG write flag reset !!
		STZ	<BGWVF1
		STZ	<SCHMK1		;scroll muki reset !!
;
		MI16
;
;-------------- intial BG write ---------------------------------
		LDA	#16+1		;loop no.
		STA	<BGW_WORK
;
		LDA	NEXTGOTO
		BEQ	BGIN40		;CjVX^[gH ( yes:BGIN40 )
;
		LDA	<SCCV1
		STA	WRSCV1
		LDA	<SCCH1
		SEC
		SBC	#0100H
		STA	WRSCH1
;
BGIN20		EQU	$
		JSR	BGINT_SUB
;
		MI8

		JSL	>NEWVMADL	;BG3 screen write
		JSL	>BGSCWTL	;BG screen write
;
		MI16
;
		DEC	<BGW_WORK
		BNE	BGIN20
;
;-------------- OafRCgݒ ----------------------
BGIN40		EQU	$
		LDA	BG3TYP
		CMP	#0AH
		BNE	BGIN050		;"mogura course ? ( no:BGIN050 )
;
		PHB			;(DBR) save
		PEA	VRAMD/100H
		PLB
		PLB
;
		LDY	VRAMD
		LDA	#2800H
		STA	VRAMD+2,Y		;VRAM address set
		LDA	#0010000000000000B+(800H-1)
		STA	VRAMD+4,Y		;number of byte & VRAM raed flag set
		LDA	#CHRSVBF
		STA	VRAMD+6,Y		;A bus address(L,H) set
		LDA	#BANK CHRSVBF
		STA	VRAMD+8,Y		;A bus address(B) set
		LDA	#0FFFFH
		STA	VRAMD+9,Y		;end code set
		TYA
		CLC
		ADC	#7
		STA	VRAMD			;next index set
;
		PLB
;
		MI8
;
		JSL	>VMADSPL		;VRAM read !!
;
BGIN050		EQU	$
		MI8			; memory , index 8bit mode
;
BGINT_PASS	EQU	$
		PLB
		RTL
;
;************************************************************************
;*		BG screen scroll write set				*
;************************************************************************
;
BGSET		EQU	$
		PHB			;(DBR) save
		PHK			;(DBR) <-- (PBR)
		PLB
		LDA	!DSPMOD
		CMP	#009		; [hV ?
		BNE	BGST000		;	NO -> BGST000
		JMP	BGSET_PASS
;
BGST000		EQU	$
;
		MI16			; memory , index 16bit mode
;
;-------------- BG write timming check --------------------------
;
;-------------- H scroll BG write -----------------------
		LDA	<SCCH1
		AND	#0FFF0H
		CMP	WRSCH1
		BEQ	BGST020		;BG change ? ( no:BGST020 )
;
		JSR	HWADST		;H scroll screen data set
;
;-------------- V scroll BG write -----------------------
BGST020		EQU	$
		LDA	<SCCV1
		AND	#0FFF0H
		CMP	WRSCV1
		BEQ	BGST030		;BG change ? ( no:BGST030 )
;
		JSR	VWADST		;V scroll screen data set
;
BGST030		EQU	$
;
		MI8			; memory , index 8bit mode
;
BGSET_PASS	EQU	$
		PLB
		RTL
;
;****************************************************************
;*		H scroll BG screen write set			*
;*			in  : (X) <-- BG type [ 0:BG1 4:BG2 ]	*
;*			      (A) <-- H scroll counter		*
;****************************************************************
;
		MEM16
		IDX16
;
BGWPNTH		EQU	$
		WORD	00100H,00000H
;
HWADST		EQU	$
		INC	<BGWHF1		;BG write flag "ON"
;
		STA	WRSCH1
		LDY	<SCHMK1
		CLC
		ADC	!BGWPNTH,Y
		TAY
		AND	#01F0H
		TAX			;(A) save
;
		LSR	A
		LSR	A
		LSR	A
		STA	<WORKA		;(WKA,B) <-- af`FbNpobt@|C^[wʒu
;
		TXA			;(A) load
		BIT	#0100H
		BEQ	HWAS010
;
		EOR	#(0400H<<3)|0100H
HWAS010		EQU	$
		LSR	A
		LSR	A
		LSR	A
		TAX			;(A) save
;;;;		CLC
		ADC	#6800H		;screen base address add
		STA	<BGWAH1_0
		INC	A
		STA	<BGWAH1_1
		TYA
		AND	#0F00H
		XBA
		STA	<WORK
		TXA			;(A) load
		AND	#000FH<<1
		STA	<WORK2
;
		LDA	<SCCV1
		AND	#00F0H
		TAY
;
		ASL	A
		ASL	A		;(A) <-- af`FbNpobt@|C^[xʒu
		TSB	<WORKA		;(WKA,B) <-- af`FbNpobt@|C^[ʒu
;
		TYA
		LSR	A
		LSR	A
		LSR	A
		LSR	A
		STA	R3		;(R3) <-- jbgDQ
		EOR	#000FH
		INC	A
		STA	<WORK6		;(WK6,7) <-- up set loop no.
		STA	R12		;(R12) <-- jbgDP
		TYA
		ASL	A
		STA	<WORKE
		LDA	<SCCV1
		LSR	A
		LSR	A
		TAY
		LSR	A
		LSR	A
		AND	#0700H>>4
		ORA	<WORK
		STA	<WORK4
		TAX
		LDA	UNBUFAD-1,X
		AND	#3F00H
		ASL	A
		ORA	<WORKE
		ORA	<WORK2
		TAX			;(X) <-- unit buffer pointer
;
		TYA
		AND	#00F0H>>2
		STA	R10		;(R10) <-- obt@|C^[
		LDY	<WORKA		;(Y)  <-- jbgobt@|C^[DP
		STY	R1		;(R1) <-- jbgobt@|C^[DP
;
		PHB			 ;(DBR) save
		PEA	BGCHECK_BUF/100H ;(DBR) <-- BGCHECK_BUF(B)
		PLB
		PLB
;
		JSR	HWAS20
;
		LDA	>R3		;(R3) <-- jbgDQ
		BEQ	HWAS020		;low set ? ( no:HWAS020 )
;
;-------------- hi -> low set -----------------------------------
		STA	<WORK6		;(WK6,7) <-- loop no.
;
		TYA
		AND	#03FFH
		TAY
		STA	>R2		;(R2) <-- jbgobt@|C^[DQ
;
		LDA	<WORK4
		CLC
		ADC	#0010H
		AND	#07F0H>>4
		TAX
		LDA	>UNBUFAD-1,X
		AND	#3F00H
		ASL	A
		ORA	<WORK2
		TAX
		JSR	HWAS20
;
HWAS020		EQU	$
		PLB
;
		I8
;
		M_CHIP	BGWRITE_H
;
		I16
;
		RTS
;
;-------------- write buffer set --------------------------------
HWAS20		EQU	$
		LDA	>BGUNIT,X
		STA	BGCHECK_BUF,Y
		TYA
		CLC
		ADC	#(010H*2)*2
		TAY
		TXA			;(X) load
		CLC
		ADC	#0020H
		TAX
		DEC	<WORK6
		BNE	HWAS20
;
HWAS30		EQU	$
		RTS
;
;****************************************************************
;*		V scroll BG screen write set			*
;*			in  : (X) <-- BG type [ 0:BG1 4:BG2 ]	*
;*			      (A) <-- V scroll counter		*
;****************************************************************
BGWPNTV		EQU	$
		WORD	000E0H,00000H
;
VWADST		EQU	$
		INC	<BGWVF1		;BG write flag "ON"
;
		STA	WRSCV1
		LDY	<SCVMK1
		CLC
		ADC	!BGWPNTV,Y
		STA	<BG3WSCV	;BG3 screen write scroll counter_V set
		TAY
		ASL	A
		AND	#00F0H<<1
		STA	<WORK2
		ASL	A
;
		STA	<WORKA		;(WKA,B) <-- af`FbNpobt@|C^[xʒu
;
		STA	<WORK
		TYA
		LSR	A
		LSR	A
		LSR	A
		LSR	A
		AND	#0700H>>4
		STA	<WORK4
;
		LDA	<SCCH1
		LSR	A
		LSR	A
		TAX
		AND	#00F0H>>2
		TAY
		LSR	A
		LSR	A
		STA	<WORK8		;(WK8,9) <-- low set loop no. -1
		EOR	#0FH
		INC	A
		STA	<WORK6		;(WK6,7) <-- hi set loop no.
		STA	R12		;(R12) <-- jbgDP
;
		TYA
		CLC
		ADC	#04H
		STA	<BGWNO1_1	;number of byte 2 set
		TYA
		LSR	A
		STA	<WORKE
		TXA			;(A) load
		LSR	A
		AND	#01F0H>>3
		TAY
;
		TSB	<WORKA		;(WKA,B) <-- af`FbNpobt@|C^[ʒu
;
		TYA
		BIT	#0100H>>3
		BEQ	VWAS10
;
		EOR	#0400H|(0100H>>3)
VWAS10		EQU	$
		ORA	<WORK
		TAX
		CLC
		ADC	#6800H		;screen base address add
		STA	<BGWAV1_00
		CLC
		ADC	#020H
		STA	<BGWAV1_01
		TXA
		EOR	#0400H
		AND	#0FFE0H
		CLC
		ADC	#6800H		;screen base address add
		STA	<BGWAV1_10
		CLC
		ADC	#020H
		STA	<BGWAV1_11
		LDA	#22H*2
		SEC
		SBC	<BGWNO1_1
		STA	<BGWNO1_0	;number of byte 1 set
		LDY	#BGVSCRBF	;(Y) <-- chara no. set buffer address
		LDA	<SCCH1+1
		AND	#000FH
		STA	<WORKC		:(WKC,D) <-- ʂmD
		ORA	<WORK4
		TAX
		LDA	UNBUFAD-1,X
		AND	#3F00H
		ASL	A
		ORA	<WORKE
		ORA	<WORK2
		TAX
;
		LDY	<WORKA		;(Y)  <-- jbgobt@|C^[DP
		STY	R1		;(R1) <-- jbgobt@|C^[DP
;
		PHB			 ;(DBR) save
		PEA	BGCHECK_BUF/100H ;(DBR) <-- BGCHECK_BUF(B)
		PLB
		PLB
;
		JSR	VWAS20
;
;-------------- hi -> low set -----------------------------------
		LDA	<WORK8
		INC	A
		STA	<WORK6		;(WK6,7) <-- loop no.
		STA	>R3		;(R3) <-- jbgDQ
;
		TYA
		BIT	#01FH<<1
		BNE	VWAS12
		SEC
		SBC	#020H<<1
		TAY
VWAS12		EQU	$
		STA	>R2		;(R2) <-- jbgobt@|C^[DQ
;
		LDA	<WORKC		;(A) <-- ʂmD
		INC	A
		AND	#0FH
		ORA	<WORK4
		TAX
		LDA	>UNBUFAD-1,X
		AND	#3F00H
		ASL	A
		ORA	<WORK2
		TAX
		JSR	VWAS20
;
		PLB
;
		I8
;
		M_CHIP	BGWRITE_V
;
		I16
;
		RTS
;
;-------------- write buffer set --------------------------------
VWAS20		EQU	$
		LDA	>BGUNIT,X
		STA	BGCHECK_BUF,Y
		INY
		INY
		INX
		INX
		DEC	<WORK6
		BNE	VWAS20
		RTS
;
		MEM8
		IDX8
;
;************************************************************************
;*		base unit data set					*
;************************************************************************
;
		MEM8
		IDX8
;
RUTSET		EQU	$
		LDA	#BANK RUT0200	;(WK2) <-- ram unit address(B)
		STA	<WORK2
;
		MI16
;
		LDX	#0		;(X) <-- base unit data set data pointer
RUTS010		EQU	$
		STX	<WORK3		;(WK3,4) <-- base unit data set data pointer
;
		LDA	>RUTDATA,X
		AND	#00FFH
		BEQ	RUTS050		;end ? ( yes:RUTS050 )
;
		TAY
		LDA	>RUTDATA+1,X
		STA	<WORK0		;(WK0,1,2) <-- ram unit address(L,H)
;
		LDA	BG1TYP
		ASL	A
;;;;		CLC
		ADC	<WORK3
		TAX
		LDA	>RUTDATA+3,X	;(A) <-- base unit course data
		TYX			;(X) <-- number of data byte
		LDY	#00		;(Y) <-- ram unit pointer
RUTS020		EQU	$
		STA	[<WORK0],Y
		INC	A
		INY
		INY
		DEX
		BNE	RUTS020
;
		LDA	<WORK3
		CLC
		ADC	#1+2+(2*16)	;[ 1:number of unit 2:ram unit address (2*8):unit data address ]
		TAX
		BRA	RUTS010
;
RUTS050		EQU	$
;
		MI8
;
		RTL
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		BG & unit_no. chenge program				x
;x			BGCGNO <--- chenge no.				x
;x			BGXPS1 <---    "   X_pos                        x
;x			BGYPS1 <---    "   Y_pos                        x
;x		      ( BGUTNO <--- chenge unit no. )			x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;
		MEM16
		IDX8
;
UNITCHG		EQU	$
		PHP			;(P) save
		PHB			;(DBR) save
		PHK			;(DBR) <-- (PBR)
		PLB
;
		PHD			;(D) save
		LDA	#0000		;(D) <-- 0
		TCD
;
		MI16			; memory , index 16bit mode
;
;-------------- afGA`FbN ------------------------------
		LDA	<BGXPS1
		AND	#0FFF0H
		SEC
		SBC	WRSCH1
		CLC
		ADC	#010H
		STA	<WORK12		;(WK12) <-- af`FbNw
;
		LDA	<BGYPS1
		AND	#0FFF0H
		SEC
		SBC	WRSCV1
		CLC
		ADC	#010H
		STA	<WORK14		;(WK14) <-- af`FbNx
;
		LDA	<BGYPS1
		TAY
		AND	#0700H
		LSR	A
		LSR	A
		LSR	A
		LSR	A
		STA	<WORK0
		TYA
		AND	#00F0H
		ASL	A
		STA	<WORK2
		ASL	A
		STA	<WORK7
;
		LDA	<BGXPS1
		TAY
		AND	#000F0H
		LSR	A
		LSR	A
		LSR	A
		TSB	<WORK2
		TYA
		AND	#001F0H
		LSR	A
		LSR	A
		LSR	A
		BIT	#00100H>>3
		BEQ	UNCNG010
;
		EOR	#0400H|(0100H>>3)
UNCNG010	EQU	$
		TSB	<WORK7		;(WK7) <-- uq`lAhX
;
		TYA
		AND	#0F00H
		XBA
		ORA	<WORK0
		STA	<WORK10		;(WK10) <-- tmate`c|C^[
		TAX
;
		LDA	UNBUFAD-1,X
		AND	#03F00H
		ASL	A
		TSB	<WORK2		;(WK2) <-- aftmhs|C^[
;
		LDA	<BGCGNO
		ASL	A
		TAX
		JSR	(!CHEGADD,X)
;
		PLD
		PLB
		PLP
		RTL
;
CHEGADD		EQU	$
BLOK0		WORD	BLK0EST		; eat block chenge set !!
BGCHG		WORD	BGCHGST		; BG change set
DWBG0		WORD	DWBG0ST		; ւݏ change set !!
;;;;DOROP	    WORD    DOROPST	    ; {[iXhAI[v
;;;;DORCL	    WORD    DORCLST	    ;	   "      N[Y
KPCLR		WORD	KPBGCLR		; Nbpaf
DWCHG		WORD	DWCHGST		; ̍YafāÂaf
BGCG2		WORD	BGCGST2		; BG change set ikLȂ珑j
TGTAMA		WORD	TOGETAMA	; Ƃ̋
BGCINCLS	WORD	BGCOINCLS	; afRC NA
;
;
BLK0		EQU	(BLOK0-CHEGADD)/2
BGCG		EQU	(BGCHG-CHEGADD)/2
DBG0		EQU	(DWBG0-CHEGADD)/2
;;;;DROP	    EQU	    (DOROP-CHEGADD)/2
;;;;DRCL	    EQU	    (DORCL-CHEGADD)/2
KPCL		EQU	(KPCLR-CHEGADD)/2
DWCG		EQU	(DWCHG-CHEGADD)/2
BCG2		EQU	(BGCG2-CHEGADD)/2
TGTM		EQU	(TGTAMA-CHEGADD)/2
CNCL		EQU	(BGCINCLS-CHEGADD)/2
;
;
		MEM16
		IDX16
;
;************************************************************************
;*		Hׂaf					*
;************************************************************************
;
BLK0EST		EQU	$
;
;-------------- Hׂaf --------------------------------------
		LDA	<WORK7
		STA	<WORK4
		LDA	<WORK12
		STA	<WORK16
		LDA	<WORK14
		STA	<WORK18
;
		LDX	<WORK2
		LDA	>BGUNIT,X
		TAY
		AND	#0FF00H
		XBA
		SEC
		SBC	#01AH
		CMP	#03H
		BCC	BKT000		; block unit_No. (H) ?
		RTS
;
BKT000		EQU	$
		PHB			  ;(DBR) save
;
		M8
;
		LDA	#BANK CHKCHG_DAT0 ;(DBR) <-- CHKCHG_DAT0(B)
		PHA
		PLB
;
		M16

		TYA
		AND	#00FFH
		ASL	A
		TAY
		LDA	!CHKCHG_DAT4,Y
		BEQ	BKT010		;kL ? ( yes:BKT010 )
;
		TAY
		LDA	0,Y
BKT010		EQU	$
		STA	>BGUNIT,X
		JSR	VRAMDST
;
;-------------- ̂af ----------------------------------------
		JSR	CHGBG_SET_UP
		LDA	<WORK0		; max over ?
		BNE	BKT200		;	YES -> BKT200
;
		LDA	>BGUNIT,X
		TAY
		AND	#0FF00H
		XBA
		SEC
		SBC	#01AH
		CMP	#03H
		BCS	BKT200		; unit_No. (H) = block ?
;					; Yes!
		TYA
		AND	#00FFH
		ASL	A
		TAY
		LDA	!CHKCHG_DAT0,Y
		TAY
		LDA	0,Y
		CMP	>BGUNIT,X
		BEQ	BKT200
;
		STA	>BGUNIT,X	; unit_No. set
		JSR	VRAMDST
;
;-------------- ̂af ----------------------------------------
BKT200		EQU	$
		JSR	CHGBG_SET_LFT
		LDA	<WORK0		; max over ?
		BNE	BKT400		;	YES -> BKT400
;
		LDA	>BGUNIT,X
		TAY
		AND	#0FF00H
		XBA
		SEC
		SBC	#01AH
		CMP	#03H
		BCS	BKT400		; block unit_No. (H) ?
;					; Yes!
		TYA
		AND	#00FFH
		ASL	A
		TAY
		LDA	!CHKCHG_DAT3,Y
		TAY
		LDA	0,Y
		CMP	>BGUNIT,X
		BEQ	BKT400
;
		STA	>BGUNIT,X	; change unit_No. set
		JSR	VRAMDST
;
;-------------- Êaf ----------------------------------------
BKT400		EQU	$
		JSR	CHGBG_SET_RIT
		LDA	<WORK0		; max over ?
		BNE	BKT600		;	YES -> BKT600
;
		LDA	>BGUNIT,X
		TAY
		AND	#0FF00H
		XBA
		SEC
		SBC	#01AH
		CMP	#03H
		BCS	BKT600
;
		TYA
		AND	#00FFH
		ASL	A
		TAY
		LDA	!CHKCHG_DAT2,Y
		TAY
		LDA	0,Y
		CMP	>BGUNIT,X
		BEQ	BKT600
;
		STA	>BGUNIT,X
		JSR	VRAMDST
;
;-------------- ̂af ----------------------------------------
BKT600		EQU	$
		JSR	CHGBG_SET_DWN
		LDA	<WORK0		; max over ?
		BNE	BKT800		;	YES -> BKT800
;
		LDA	>BGUNIT,X
		TAY
		AND	#0FF00H
		XBA
		SEC
		SBC	#01AH
		CMP	#03H
		BCS	BKT800
;
		TYA
		AND	#00FFH
		ASL	A
		TAY
		LDA	!CHKCHG_DAT1,Y
		TAY
		LDA	0,Y
		CMP	>BGUNIT,X
		BEQ	BKT800
;
		STA	>BGUNIT,X
		JSR	VRAMDST
;
BKT800		EQU	$
		LDA	>VRAMDSP
		TAX
		LDA	#0FFFFH
		STA	>VRAMDSP+2,X	;end code set
;
		PLB
		RTS
;
;
;
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+	̂af̃AhX`FbN  Zbg		+
;+			out				+
;+			wrk7,8	: uq`lAhX	+
;+			X	: unit buffer index	+
;+			wrk0,1	: max over chack	+
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
CHGBG_SET_UP	EQU	$
		LDA	<WORK18		;af`FbNxZbg
		SEC
		SBC	#010H
		STA	<WORK14
;
		STZ	<WORK0
		LDA	<WORK4
		SEC
		SBC	#00040H
		STA	<WORK7
		LDA	<WORK2
		SEC
		SBC	#010H*2
		TAX
		AND	#001E0H
		CMP	#001E0H
		BNE	CHGBG_UP_900
;
		LDA	<WORK10
		SEC
		SBC	#010H		; max over ?
		BPL	CHGBG_UP_100	;	NO -> CHGBG_UP_100
		INC	<WORK0
;
CHGBG_UP_100	EQU	$
		TXY
		TAX
		LDA	<WORK7
		CLC
		ADC	#00400H
		AND	#007FFH
		STA	<WORK7		; V-ram address set
		LDA	UNBUFAD-1,X
		AND	#3F00H
		ASL	A
		STA	<WORK9
		TYA
		AND	#01FFH
		ORA	<WORK9
		TAX			; unit buffer index set
;
CHGBG_UP_900	EQU	$
		RTS
;
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+	̂af̃AhX`FbN  Zbg		+
;+			out				+
;+			wrk7,8	: uq`lAhX	+
;+			X	: unit buffer index	+
;+			wrk0,1	: max over chack	+
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
CHGBG_SET_LFT	EQU	$
		LDA	<WORK16		;af`FbNwZbg
		SEC
		SBC	#010H
		STA	<WORK12
;
		STZ	<WORK0
		LDA	<WORK4
		DEC	A
		DEC	A
		STA	<WORK7
		LDA	<WORK2
		DEC	A
		DEC	A
		TAX
		AND	#0001EH
		CMP	#0001EH
		BNE	CHGBG_LFT_900
;
		LDA	<WORK10
		BIT	#0000FH		; max over ?
		BNE	CHGBG_LFT_100	;	NO -> CHGBG_LFT_100
		INC	<WORK0
;
CHGBG_LFT_100	EQU	$
		LDA	<WORK10
		DEC	A
		TXY
		TAX
		LDA	<WORK7
		CLC
		ADC	#0420H
		AND	#07FFH
		STA	<WORK7		; V-ram address set
		LDA	UNBUFAD-1,X
		AND	#3F00H
		ASL	A
		STA	<WORK9
		TYA
		CLC
		ADC	#0020H
		AND	#01FFH
		ORA	<WORK9
		TAX			; unit buffer index set
;
CHGBG_LFT_900	EQU	$
		RTS
;
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+	Êaf̃AhX`FbN  Zbg		+
;+			out				+
;+			wrk7,8	: uq`lAhX	+
;+			X	: unit buffer index	+
;+			wrk0,1	: max over chack	+
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
CHGBG_SET_RIT	EQU	$
		LDA	<WORK16		;af`FbNwZbg
		CLC
		ADC	#010H
		STA	<WORK12
;
		STZ	<WORK0
		LDA	<WORK4
		INC	A
		INC	A
		STA	<WORK7
		LDA	<WORK2
		INC	A
		INC	A
		TAX
		AND	#0001EH
		BNE	CHGBG_RIT_900
;
		LDA	<WORK10
		INC	A
		BIT	#0FH		; max over ?
		BNE	CHGBG_RIT_100	;	NO -> CHGBG_RIT_100
		INC	<WORK0
;
CHGBG_RIT_100	EQU	$
		TXY
		TAX
		LDA	<WORK7
		SEC
		SBC	#0420H
		AND	#07FFH
		STA	<WORK7		; V-ram address set
		LDA	UNBUFAD-1,X
		AND	#3F00H
		ASL	A
		STA	<WORK9
		TYA
		SEC
		SBC	#0020H
		AND	#01FFH
		ORA	<WORK9
		TAX			; unit buffer index set
;
CHGBG_RIT_900	EQU	$
		RTS
;
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+	̂af̃AhX`FbN  Zbg		+
;+			out				+
;+			wrk7,8	: uq`lAhX	+
;+			X	: unit buffer index	+
;+			wrk0,1	: max over chack	+
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
CHGBG_SET_DWN	EQU	$
		LDA	<WORK18		;af`FbNxZbg
		CLC
		ADC	#010H
		STA	<WORK14
;
		STZ	<WORK0
		LDA	<WORK4
		CLC
		ADC	#00040H
		STA	<WORK7
;
		LDA	<WORK2
		CLC
		ADC	#00020H
		TAX
		AND	#001E0H
		BNE	CHGBG_DWN_900
;
		LDA	<WORK10
		CLC
		ADC	#010H
		BIT	#070H		; max over ?
		BNE	CHGBG_DWN_100	;	NO -> CHGBG_DWN_100
		INC	<WORK0
;
CHGBG_DWN_100	EQU	$
		TXY
		TAX
;
		LDA	<WORK7
		SEC
		SBC	#00400H
		AND	#007FFH
		STA	<WORK7		; V-ram address set
		LDA	UNBUFAD-1,X
		AND	#3F00H
		ASL	A
		STA	<WORK9
		TYA
		AND	#01FFH
		ORA	<WORK9
		TAX			; unit buffer index set
;
CHGBG_DWN_900	EQU	$
		RTS
;
;************************************************************************
;*		ւݏaf					*
;************************************************************************
;
DWBG0ST		EQU	$
		LDY	#0
DWBG0ST_010	EQU	$
		LDX	<WORK2		;(X) <-- BG unit buffer pointer
		LDA	>BGUNIT,X
		STA	WORK20,Y	;(WK20-) <-- old unit no. set
		AND	#0FF00H
		CMP	#06100H
		BEQ	DWBG0ST_012	;ւݏH ( yes:DWBG0ST_012 )
		CMP	#06200H
		BEQ	DWBG0ST_012	;	      "
;
		LDA	#UT6108+1
		STA	WORK20,Y
		BRA	DWBG0ST_014
;
DWBG0ST_012	EQU	$
		LDA	BGUTNO		;(A) <-- change unit no.
		STA	>BGUNIT,X
		PHY			;(Y) save
		JSR	VRAMDST
		PLY			;(Y) load
;
DWBG0ST_014	EQU	$
		INC	BGUTNO		;next change unit no. set
;
		LDA	<WORK12		;af`FbNwZbg
		CLC
		ADC	#010H
		STA	<WORK12
;
		LDA	<WORK7
		INC	A
		INC	A
		STA	<WORK7
		LDA	<WORK2
		INC	A
		INC	A
		STA	<WORK2
		BIT	#0FH*2
		BNE	DWBG0ST_020	;X pos(H) change ? ( no:DWBG0ST_020 )
;
		SEC
		SBC	#10H*2
		AND	#01FFH
		STA	<WORK2
		LDA	<WORK7
		SEC
		SBC	#0420H
		AND	#07FFH
		STA	<WORK7
		LDX	<WORK10
		INX
		LDA	UNBUFAD-1,X
		AND	#3F00H
		ASL	A
		TSB	<WORK2
DWBG0ST_020	EQU	$
		INY
		INY
		CPY	#3*2
		BCC	DWBG0ST_010
;
		LDA	>VRAMDSP
		TAX
		LDA	#0FFFFH
		STA	>VRAMDSP+2,X	;end code set
		RTS
;
;************************************************************************
;*		Nbpaf					*
;************************************************************************
KPBG_CHG_UNIT	EQU	$-2*3*2
;			 E[	[	;[KOOPA_BLKNO]
		WORD	UT0000,UTA562	;[2]
		WORD	UT0000,UT0000
		WORD	UT0000,UTA563
;
		WORD	UT0000,UTA562	;[4]
		WORD	UT0000,UTA563
		WORD	UTA561,UT0000
;
		WORD	UTA560,UTA562	;[6]
		WORD	UTA561,UT0000
		WORD	UT0000,UT0000
;
		WORD	UTA560,UT0000	;[8]
		WORD	UT0000,UT0000
		WORD	UTA561,UT0000
;
		WORD	UTA560,UT0000	;[A]
		WORD	UT0000,UT0000
		WORD	UTA561,UT0000
;
		WORD	UT0000,UTA562	;[C]
		WORD	UT0000,UT0000
		WORD	UTA561,UTA563
;
		WORD	UT0000,UTA562	;[E]
		WORD	UT0000,UT0000
		WORD	UT0000,UTA563
;
KPBGCLR		EQU	$
		LDY	BGUTNO
KPBGCLR_0050	EQU	$
		PHY			;(Y) save
;
		LDX	<WORK2		;(X) <-- BG unit buffer pointer
		TYA
		BEQ	KPBGCLR_0100	;E[H ( yes:KPBGCLR_0100 )
		CPY	BGUTNO
		BNE	KPBGCLR_0250	;[H ( no:KPBGCLR_0250 )
;
		LDA	#2
;
;-------------- [jbg`FbN --------------------------------------
KPBGCLR_0100	EQU	$
		STA	<WORK0		;(WK0,1) <-- [E[
;
		LDA	>BGUNIT,X
;;;;		    CMP	    #UT0000
		BEQ	KPBGCLR_0310	;łɃkLH ( yes:KPBGCLR_0310 )
;
		PHX			;(X) save
;
		I8
;
		JSL	>BGBR0_SET	;jЌʃZbg
;
		I16
;
		PLX			;(X) load
;
		LDA	<BGYPS1
		SEC
		SBC	#07C0H
		AND	#0FFF0H
		LSR	A
		LSR	A
		TSB	<WORK0
		LDA	KOOPA_BLKNO
		ASL	A
;;;;		    CLC
		ADC	KOOPA_BLKNO
		ASL	A
;;;;		    CLC
		ADC	<WORK0
		TAY
		LDA	!KPBG_CHG_UNIT,Y
		BRA	KPBGCLR_0300
;
;-------------- ԃjbg --------------------------------------------
KPBGCLR_0250	EQU	$
		LDA	#UT0000
KPBGCLR_0300	EQU	$
		STA	>BGUNIT,X
		JSR	VRAMDST
;
KPBGCLR_0310	EQU	$
		LDA	<WORK12		;af`FbNwZbg
		CLC
		ADC	#010H
		STA	<WORK12
		LDA	<BGXPS1
		CLC
		ADC	#010H
		STA	<BGXPS1
;
		LDA	<WORK7
		INC	A
		INC	A
		STA	<WORK7
		LDA	<WORK2
		INC	A
		INC	A
		STA	<WORK2
		BIT	#0FH*2
		BNE	KPBGCLR_0350	;X pos(H) change ? ( no:KPBGCLR_0350 )
;
		SEC
		SBC	#10H*2
		AND	#01FFH
		STA	<WORK2
		LDA	<WORK7
		SEC
		SBC	#0420H
		AND	#07FFH
		STA	<WORK7
		LDX	<WORK10
		INX
		LDA	UNBUFAD-1,X
		AND	#3F00H
		ASL	A
		TSB	<WORK2
KPBGCLR_0350	EQU	$
		PLY			;(Y) load
;
		DEY
		BMI	KPBGCLR_0400
		JMP	KPBGCLR_0050
;
KPBGCLR_0400	EQU	$
		LDA	>VRAMDSP
		TAX
		LDA	#0FFFFH
		STA	>VRAMDSP+2,X	;end code set
		RTS
;
;************************************************************************
;*		̍YafāÂaf			*
;************************************************************************
KUI_CHANGE_DOWN EQU	$
; ̃jbgmD ->	    UT6B00     UT6B01	  UT6B02     UT6B03
		BYTE	LOW UT6B00,LOW UT6B00,LOW UT6B03,LOW UT6B03
; ̃jbgmD ->	    UT6B10     UT6B11	  UT6B12     UT6B13
		BYTE	LOW UT6B10,LOW UT6B10,LOW UT6B13,LOW UT6B13
; ̃jbgmD ->	    UT6B20     UT6B21	  UT6B22     UT6B23
		BYTE	LOW UT6B20,LOW UT6B20,LOW UT6B23,LOW UT6B23
; ̃jbgmD ->	    UT6B30     UT6B31	  UT6B32     UT6B33
		BYTE	LOW UT6B30,LOW UT6B30,LOW UT6B33,LOW UT6B33
; ̃jbgmD ->	    UT6B60     UT6B61	  UT6B62     UT6B63
		BYTE	LOW UT6B60,LOW UT6B60,LOW UT6B63,LOW UT6B63
;
;
DWCHGST		EQU	$
		LDA	!DSPMOD
		CMP	#00009		; [hV̏ ?
		BNE	DWCHGST_000	;	NO -> DWCHGST_000
		JMP	MD7KUI_CHG
;
DWCHGST_000	EQU	$
		LDX	<WORK2		;(X) <-- BG unit buffer pointer
		LDA	>BGUNIT,X
		AND	#0FF00H
		CMP	#UTA300		; ԃRC ?
		BNE	DWCHGST_010	;	NO -> DWCHGST_010
		LDA	<WORK0
		PHA
		LDA	<WORK2
		PHA
		LDA	<WORK7
		PHA
		JSR	BG_BIT_ON
		JSL	>BLUE_COIN_ST_SB
		PLA
		STA	<WORK7
		PLA
		STA	<WORK2
		PLA
		STA	<WORK0
;
DWCHGST_010	EQU	$
		LDX	<WORK2		;(X) <-- BG unit buffer pointer
		LDA	<BGUTNO		;(A) <-- change unit no.
		STA	>BGUNIT,X
		JSR	VRAMDST
;
		LDA	<WORK7
		STA	<WORK4
		LDA	<WORK14
		STA	<WORK18
		JSR	CHGBG_SET_DWN
		LDA	<WORK0		; max over ?
		BNE	DWCHGST_090	;	YES -> DWCHGST_090
;
DWCHGST_020	EQU	$
		LDA	>BGUNIT,X
		AND	#000FFH
		TAY
		LDA	!KUI_CHANGE_DOWN,Y
		AND	#000FFH
		TAY
		LDA	>BGUNIT,X
		AND	#0FF00H
		CMP	#UT6B00		; ̃jbg͍Y H
		BEQ	DWCHGST_050	;	YES -> DWCHGST_050
		CMP	#UTA300		; ̃jbǵHY H
		BNE	DWCHGST_090	;	NO -> DWCHGST_030
		TYA
		ORA	#UTA300
		BRA	DWCHGST_055
;
DWCHGST_050	EQU	$
		TYA
		ORA	#UT6B00
DWCHGST_055	EQU	$
		STA	>BGUNIT,X
		JSR	VRAMDST
;
DWCHGST_090	EQU	$
		LDA	>VRAMDSP
		TAX
		LDA	#0FFFFH
		STA	>VRAMDSP+2,X	;end code set
		RTS
;
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+		[hV̏				+
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
MD7KUI_CHG_CMP	EQU	$
		WORD	005C8H,005DCH
		WORD	005D2H,007C6H
MD7KUI_CHG_END	EQU	$
;
MD7KI_CHG_DT00	EQU	$
		HEX	086H,086H,0B0H
		HEX	086H,086H,0B1H
;
MD7KI_CHG_DT01	EQU	$
		HEX	0B6H,0C6H,0C6H
		HEX	0B7H,0C6H,0C6H
;
MD7KI_CHG_DT02	EQU	$
		HEX	0C2H,08AH,08AH
		HEX	0C3H,08BH,08BH
;
MD7KI_CHG_DT03	EQU	$
		HEX	08AH,08AH,0BCH
		HEX	08BH,08BH,0BDH
;
MD7KI_CHG_DT10	EQU	$
		HEX	0ACH,0AEH,003H
		HEX	0ADH,0AFH,004H
;
MD7KI_CHG_DT11	EQU	$
		HEX	043H,0B2H,0B4H
		HEX	044H,0B3H,0B5H
;
MD7KI_CHG_DT12	EQU	$
		HEX	023H,0BEH,0BFH
		HEX	02CH,0C0H,0C1H
;
MD7KI_CHG_DT13	EQU	$
		HEX	0B8H,0B9H,01FH
		HEX	0BAH,0BBH,024H
;
MD7KI_CHG_ADR0	EQU	$
		WORD	00B9FH,0121FH
		WORD	00F25H,00F18H
;
MD7KI_CHG_ADR1	EQU	$
		WORD	00BA0H,01220H
		WORD	00FA5H,00F98H
;
;
MD7KI_CHG_CNT0	EQU	$
MD7KI_CHG_CNT1	EQU	$
		WORD	00000011B+(00000000B*100H)
		WORD	00000011B+(00000000B*100H)
		WORD	00000000B+(00000000B*100H)
		WORD	00000000B+(00000000B*100H)
;
MD7KI_CHG_DAT00 EQU	$
		WORD	MD7KI_CHG_DT00,MD7KI_CHG_DT01
		WORD	MD7KI_CHG_DT02,MD7KI_CHG_DT03
;
MD7KI_CHG_DAT01 EQU	$
		WORD	MD7KI_CHG_DT00+3,MD7KI_CHG_DT01+3
		WORD	MD7KI_CHG_DT02+3,MD7KI_CHG_DT03+3
;
MD7KI_CHG_DAT10 EQU	$
		WORD	MD7KI_CHG_DT10,MD7KI_CHG_DT11
		WORD	MD7KI_CHG_DT12,MD7KI_CHG_DT13
;
MD7KI_CHG_DAT11 EQU	$
		WORD	MD7KI_CHG_DT10+3,MD7KI_CHG_DT11+3
		WORD	MD7KI_CHG_DT12+3,MD7KI_CHG_DT13+3
;
;
MD7KUI_CHG	EQU	$
		LDX	<WORK2		; (X) <-- BG unit buffer pointer
		LDA	>BGUNIT,X
		BNE	MD7KUI_CHG_000
		JMP	MD7KUI_CHG_990
MD7KUI_CHG_000	EQU	$
		STA	<WORK0
		LDA	#UT0000
		STA	>BGUNIT,X
;
		LDA	#00002
		STA	!BOSSQ_KUI_ON
;
		TXA
		LDX	#00000
MD7KUI_CHG_220	EQU	$		; AhX T[` !!
		CMP	MD7KUI_CHG_CMP,X
		BEQ	MD7KUI_CHG_300
		INX
		INX
		CPX	#MD7KUI_CHG_CMP-MD7KUI_CHG_END
		BCC	MD7KUI_CHG_220
;
MD7KUI_CHG_300	EQU	$
		STX	<WORK8
		TXA
		EOR	#00002
		TAX
		LDA	MD7KUI_CHG_CMP,X
		TAX
;
		LDA	<WORK0
		STA	>BGUNIT,X
;
;------------------------------------------ Y
		LDY	<WORK8
		LDA	MD7KI_CHG_ADR0,Y
		STA	<WORK0		; uq`lAhX
		LDA	MD7KI_CHG_CNT0,Y
		STA	<WORK2		;CN[h  cl`p[^
		LDA	MD7KI_CHG_DAT00,Y
		STA	<WORK4		; `oX AhX
		JSR	MD7VRAMDX_SET
;
		LDY	<WORK8
		LDA	MD7KI_CHG_ADR1,Y
		STA	<WORK0		; uq`lAhX
		LDA	MD7KI_CHG_CNT0,Y
		STA	<WORK2		;CN[h  cl`p[^
		LDA	MD7KI_CHG_DAT01,Y
		STA	<WORK4		; `oX AhX
		JSR	MD7VRAMDX_SET
;
;------------------------------------------ Y
		LDA	<WORK8
		EOR	#00002
		TAY
		STA	<WORK8
		LDA	MD7KI_CHG_ADR0,Y
		STA	<WORK0		; uq`lAhX
		LDA	MD7KI_CHG_CNT1,Y
		STA	<WORK2		;CN[h  cl`p[^
		LDA	MD7KI_CHG_DAT10,Y
		STA	<WORK4		; `oX AhX
		JSR	MD7VRAMDX_SET
;
		LDY	<WORK8
		LDA	MD7KI_CHG_ADR1,Y
		STA	<WORK0		; uq`lAhX
		LDA	MD7KI_CHG_CNT1,Y
		STA	<WORK2		;CN[h  cl`p[^
		LDA	MD7KI_CHG_DAT11,Y
		STA	<WORK4		; `oX AhX
		JSR	MD7VRAMDX_SET
;
MD7KUI_CHG_990	EQU	$
		RTS
;
;++++++++++++++++++++++++++++++++++++++++++++++++
;+	[hVp uq`lcwZbg		+
;++++++++++++++++++++++++++++++++++++++++++++++++
MD7VRAMDX_SET	EQU	$
		PHB
		PEA	VRAMDX/100H
		PLB
		PLB
;
		LDX	!VRAMDX
		LDA	<WORK0
		STA	0,X		; uq`lAhX
		LDA	<WORK2
		STA	2,X		; CN[h  cl`p[^
		LDA	#00018H
		STA	4,X		; aoX AhX
		LDA	#BANK MD7KI_CHG_DAT00
		STA	7,X		; `oX AhX (a)
		LDA	#00003
		STA	8,X		; oCg
		LDA	<WORK4
		STA	5,X		;	"         (g,k)
;
		TXA
		CLC
		ADC	#00012
		STA	10,X		; mdws hmcdw
		STA	!VRAMDX
;
		PLB
		RTS
;
;
BG_BIT_ON	EQU	$
		LDA	!CORSNO
		ASL	A
		TAX
		LDA	>BGCIN_STCHK_ADR,X
		STA	<WORK0
		LDX	<WORK10
		LDA	UNBUFAD,X
		AND	#0003FH
		ASL	A
		ADC	<WORK0
		STA	<WORK0		;ʃAhX Zbg
		LDA	<WORK2
		AND	#0001EH
		TAX
		LDA	>BGCIN_STCHK_DAT,X
		STA	<WORK4
		LDA	(<WORK0)
		ORA	<WORK4
		STA	(<WORK0)	;rbgnm !!
		RTS
;
;************************************************************************
;*		afRC NA					*
;************************************************************************
BGCOINCLS	EQU	$
		JSR	BG_BIT_ON
;
;************************************************************************
;*		af						*
;************************************************************************
;
BGCHGST		EQU	$
		LDX	<WORK2		;(X) <-- BG unit buffer pointer
		LDA	BGUTNO		;(A) <-- change unit no.
		STA	>BGUNIT,X
		JSR	VRAMDST
;
		LDA	>VRAMDSP
		TAX
		LDA	#0FFFFH
		STA	>VRAMDSP+2,X	;end code set
		RTS
;
;************************************************************************
;*		afikLȂ珑j			*
;************************************************************************
;
BGCGST2		EQU	$
		LDX	<WORK2		;(X) <-- BG unit buffer pointer
		LDA	>BGUNIT,X
		CMP	#UT0000
		BNE	BGCGST2_010	;H ( no:BGCGST2_010 )
;
		LDA	BGUTNO		;(A) <-- change unit no.
		STA	>BGUNIT,X
		JSR	VRAMDST
;
		LDA	>VRAMDSP
		TAX
		LDA	#0FFFFH
		STA	>VRAMDSP+2,X	;end code set
BGCGST2_010	EQU	$
		RTS
;
;************************************************************************
;*		Ƃ̋						*
;************************************************************************
TOGETAMA	EQU	$
		LDX	<WORK2
		LDA	>BGUNIT,X
		CMP	#UT7C00		; Ƃ̋ 邩 ?
		BEQ	TOGETAMA_000	;	YES -> TOGETAMA_000
		JMP	TOGETAMA_900
;
TOGETAMA_000	EQU	$
		STZ	<WORKE
		LDA	<WORK7
		STA	<WORK4
		LDA	<WORK12
		STA	<WORK16
		LDA	<WORK14
		STA	<WORK18
;
;-------------- ̂af ----------------------------------------
		JSR	CHGBG_SET_UP
		LDA	<WORK0		; max over ?
		BNE	TOGETAMA_100	;	YES -> TOGETAMA_100
;
		LDA	>BGUNIT,X
		AND	#0FF00H
		TAY
		CMP	#UT7C00		;  ?
		BNE	TOGETAMA_020	;	NO -> TOGETAMA_020
		LDA	#00008
		STA	<WORKE
		BRA	TOGETAMA_100
;
TOGETAMA_020	EQU	$
		TYA
		CMP	#UT7700
		BNE	TOGETAMA_100
		LDA	>BGUNIT,X
		DEC	A
		DEC	A
		DEC	A
		DEC	A
		CMP	#UT7781
		BCS	TOGETAMA_025
		LDA	#UT0000
TOGETAMA_025	EQU	$
		STA	>BGUNIT,X	; unit_No. set
		JSR	VRAMDST
;
;-------------- ̂af ----------------------------------------
TOGETAMA_100	EQU	$
		JSR	CHGBG_SET_LFT
		LDA	<WORK0		; max over ?
		BNE	TOGETAMA_200	;	YES -> TOGETAMA_200
;
		LDA	>BGUNIT,X
		AND	#0FF00H
		TAY
		CMP	#UT7C00		;  ?
		BNE	TOGETAMA_120	;	NO -> TOGETAMA_120
		LDA	<WORKE
		ORA	#00001
		STA	<WORKE
		BRA	TOGETAMA_200
;
TOGETAMA_120	EQU	$
		TYA
		CMP	#UT7700
		BNE	TOGETAMA_200
		LDA	>BGUNIT,X
		DEC	A
		DEC	A
		CMP	#UT7781
		BCS	TOGETAMA_125
		LDA	#UT0000
TOGETAMA_125	EQU	$
		STA	>BGUNIT,X	; unit_No. set
		JSR	VRAMDST
;
;-------------- Êaf ----------------------------------------
TOGETAMA_200	EQU	$
		JSR	CHGBG_SET_RIT
		LDA	<WORK0		; max over ?
		BNE	TOGETAMA_300	;	YES -> TOGETAMA_300
;
		LDA	>BGUNIT,X
		AND	#0FF00H
		TAY
		CMP	#UT7C00		;  ?
		BNE	TOGETAMA_220	;	NO -> TOGETAMA_220
		LDA	<WORKE
		ORA	#00002
		STA	<WORKE
		BRA	TOGETAMA_300
;
TOGETAMA_220	EQU	$
		TYA
		CMP	#UT7700
		BNE	TOGETAMA_300
		LDA	>BGUNIT,X
		DEC	A
		CMP	#UT7781
		BCS	TOGETAMA_225
		LDA	#UT0000
TOGETAMA_225	EQU	$
		STA	>BGUNIT,X	; unit_No. set
		JSR	VRAMDST
;
;-------------- ̂af ----------------------------------------
TOGETAMA_300	EQU	$
		JSR	CHGBG_SET_DWN
		LDA	<WORK0		; max over ?
		BNE	TOGETAMA_400	;	YES -> TOGETAMA_400
;
		LDA	>BGUNIT,X
		AND	#0FF00H
		TAY
		CMP	#UT7C00		;  ?
		BNE	TOGETAMA_320	;	NO -> TOGETAMA_320
		LDA	<WORKE
		ORA	#00004
		STA	<WORKE
		BRA	TOGETAMA_400
;
TOGETAMA_320	EQU	$
		TYA
		CMP	#UT7700
		BNE	TOGETAMA_400
		LDA	>BGUNIT,X
		SEC
		SBC	#00008
		CMP	#UT7781
		BCS	TOGETAMA_325
		LDA	#UT0000
TOGETAMA_325	EQU	$
		STA	>BGUNIT,X	; unit_No. set
		JSR	VRAMDST
;
;-------------- ʂ̂af ---------------------------------------
TOGETAMA_400	EQU	$
		LDX	<WORK2
		LDA	<WORK4
		STA	<WORK7
		LDA	<WORKE
		BEQ	TOGETAMA_425
		CLC
		ADC	#UT7781-1
TOGETAMA_425	EQU	$
		STA	>BGUNIT,X
		JSR	VRAMDST
;
TOGETAMA_900	EQU	$
		LDA	>VRAMDSP
		TAX
		LDA	#0FFFFH
		STA	>VRAMDSP+2,X	;end code set
		RTS
;
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
;x		JSR	VRAMDST ( unit data vramd set sub )		x
;x			in  : (A) <-- unit no.				x
;xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
VRAMDST		EQU	$
		TAY			;(Y) <-- (A)
;
		LDA	<WORK12
		CMP	#0130H
		BCS	VRAMDST_010	;afnjH ( yes:VRAMDST_010 )
		LDA	<WORK14
		CMP	#0100H
		BCS	VRAMDST_010	;afnjH ( yes:VRAMDST_010 )
;
		PHB			;(DBR) save
		PEA	VRAMDSP/100H	;(DBR) <-- VRAMDSP(B)
		PLB
		PLB
;
		LDA	<WORK7
		BIT	#0400H
		BEQ	VRAMDST_000
		EOR	#0400H|020H
VRAMDST_000	EQU	$
		TAX
		TYA
		STA	>BGCHECK_BUF,X
;
		TYA
		AND	#0FF00H
		XBA
		ASL	A
		TAX
		LDA	>UNDTADD,X
		STA	<WORK0
		TYA
		AND	#000FFH
		ASL	A
		ASL	A
		ASL	A
;;;;		    CLC
		ADC	<WORK0
		CLC
		ADC	#UNDATA
		STA	<WORK0
;
		LDY	!VRAMDSP
		LDA	<WORK7
		ORA	#06800H
		STA	!VRAMDSP+2,Y	; VRAM AhX Zbg
;
		LDA	<WORK0
		STA	!VRAMDSP+4,Y
;
		TYA
		CLC
		ADC	#00004
		STA	!VRAMDSP
;
		PLB
;
VRAMDST_010	EQU	$
		RTS
;
;++++++++++++++++++++++++++++++++++++++++
;+		_~[ !!		+
;++++++++++++++++++++++++++++++++++++++++
UNDO_GO		EQU	$
		BRA	UNDO_GO
		RTL
;
;
		MEM8
		IDX8
;
;
;
;
;
		END

